/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Dialog to display a user's user-token details.
 *
 * @since 3.0
 */
Ext.define('NX.proui.view.usertoken.UserTokenDetails', {
  extend: 'Ext.window.Window',
  alias: 'widget.nx-proui-usertoken-details',
  requires: [
    'NX.Icons',
    'NX.Messages',
    'NX.I18n'
  ],

  /**
   * user token userCode.
   *
   * @cfg {String}
   */
  nameCode: undefined,

  /**
   * user token passCode.
   *
   * @cfg {String}
   */
  passCode: undefined,

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    me.title = NX.I18n.get('UserToken_UserTokenDetails_Title');
    me.autoShow = true;
    me.modal = true;
    me.constrain = true;
    me.width = 640;
    me.resizable = false;

    me.items = {
      xtype: 'form',
      bodyPadding: 10,
      items: [
        {
          xtype: 'panel',
          layout: 'hbox',
          items: [
            { xtype: 'component', html: NX.Icons.img('usertoken-default', 'x32') },
            { xtype: 'label', margin: '0 0 0 5',
              html: NX.I18n.get('UserToken_UserTokenDetails_Html1')
            }
          ]
        },
        {
          xtype: 'label',
          html: NX.I18n.get('UserToken_UserTokenDetails_Html2')
        },
        {
          xtype: 'panel',
          layout: 'hbox',
          items: [
            {
              xtype: 'textfield',
              name: 'nameCode',
              value: me.nameCode,
              width: 100,
              readOnly: true,
              selectOnFocus: true,
              fieldCls: 'user-token-field'
            },
            {
              xtype: 'label',
              html: ':',
              cls: 'nx-user-token-field'
            },
            {
              xtype: 'textfield',
              name: 'passCode',
              value: me.passCode,
              width: 360,
              readOnly: true,
              selectOnFocus: true,
              fieldCls: 'user-token-field'
            }
          ]
        },
        {
          xtype: 'label',
          html: NX.I18n.get('UserToken_UserTokenDetails_Html3')
        },
        {
          xtype: 'textarea',
          value: '<server>\n' +
              '  <id>${server}</id>\n' +
              '  <username>' + me.nameCode + '</username>\n' +
              '  <password>' + me.passCode + '</password>\n' +
              '</server>',
          height: 90,
          width: 610,
          readOnly: true,
          selectOnFocus: true,
          fieldCls: 'user-token-field'
        },
        {
          xtype: 'label',
          html: NX.I18n.get('UserToken_UserTokenDetails_Html4')
        },
        {
          xtype: 'textfield',
          name: 'base64',
          value: NX.util.Base64.encode(me.nameCode + ":" + me.passCode),
          width: 610,
          readOnly: true,
          selectOnFocus: true,
          fieldCls: 'user-token-field'
        },
        {
          xtype: 'label',
          html: NX.I18n.get('UserToken_UserTokenDetails_AutoClose_Html')
        }
      ],
      buttonAlign: 'left',
      buttons: [
        { text: NX.I18n.get('Button_Close'), ui: 'nx-primary', handler: function () {
          this.up('window').close();
        }}
      ]
    };

    me.callParent();

    // Automatically close the window
    Ext.defer(function () {
      // ignore if already closed
      if (me.isVisible()) {
        NX.Messages.add({ text: NX.I18n.get('UserToken_UserTokenDetails_AutoClosing_Message') });
        me.close();
      }
      // 1 minute
    }, 1 * 60 * 1000);
  }

});
