/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Application strings
 *
 * @since 3.0
 */
Ext.define('NX.proui.app.PluginStrings', {
  '@aggregate_priority': 90,

  singleton: true,
  requires: [
    'NX.I18n'
  ],

  /*
   * Note: Symbols follow the following naming convention:
   * <Class>_<Name>_<Component or Attribute>
   */

  keys: {
    // Admin -> Security -> Atlassian Crowd
    Crowd_Text: 'Atlassian Crowd',
    Crowd_Description: 'Manage Atlassian Crowd configuration',
    Crowd_CrowdSettings_Update_Error: 'You do not have permission to configure Atlassian Crowd',
    Crowd_CrowdSettings_Update_Success: 'Atlassian Crowd settings $action',
    Crowd_CrowdSettings_Html: '<p>Application can be configured to use <a href="https://www.atlassian.com/software/crowd" target="_blank">Atlassian Crowd</a> for user database and authentication.</p>',
    Crowd_CrowdSettings_Enable_FieldLabel: 'Enable Crowd',
    Crowd_CrowdSettings_Activate_FieldLabel: 'Enable Crowd Realm for authentication',
    Crowd_CrowdSettings_Activate_HelpText: 'To control ordering, go to the <a href="#admin/security/realms">Realms</a> page.',
    Crowd_CrowdSettings_URL_FieldLabel: 'Crowd server URL',
    Crowd_CrowdSettings_URL_HelpText: 'For example: http://localhost:8095/crowd',
    Crowd_CrowdSettings_Name_FieldLabel: 'Crowd application name',
    Crowd_CrowdSettings_Password_FieldLabel: 'Crowd application password',
    Crowd_CrowdSettings_Request_FieldLabel: 'Connection timeout',
    Crowd_CrowdSettings_Request_HelpText: 'Seconds to wait for activity before stopping and retrying the connection. Leave blank to use the globally defined HTTP timeout.',
    Crowd_CrowdSettings_VerifyConnection_Text: 'Verify connection',
    Crowd_CrowdSettings_Verified_Success: 'Connection to Crowd server verified: {0}',
    Crowd_CrowdSettings_ClearCache_Text: 'Clear cache',
    Crowd_CrowdSettings_ClearCache_Success: 'Crowd cache has been cleared',

    // Admin -> Security -> User Token
    UserToken_Text: 'User Tokens',
    UserToken_Description: 'Manage user token configuration',
    UserTokenSettings_Update_Error: 'You do not have permission to configure user token',
    UserTokenSettings_Update_Success: 'User Token settings $action',
    UserTokenSettings_Html: '<p>The user token feature allows users to authenticate securely ' +
    'without typical user credentials such as those used by LDAP or Crowd.</p>' +
    '<p>User tokens generated for this server are only valid for use on this server. Once enabled, users can access ' +
    'their user token from <a href="#user/usertoken">user mode</a>.</p>',
    UserTokenSettings_Enable_FieldLabel: 'Enable user tokens',
    UserTokenSettings_Require_FieldLabel: 'Require user tokens for repository authentication',
    UserTokenSettings_Require_HelpText: 'This does not affect UI access',
    UserTokenSettings_Reset_Title: 'Reset user tokens',
    UserTokenSettings_Reset_Html: '<p>Reset will invalidate <b>ALL</b> existing user tokens and force new tokens to be created the next time they are accessed.</p>',
    UserTokenSettings_ResetAll_Button: 'Reset all user tokens',
    UserToken_Authentication_Validation: '{0} user tokens requires validation of your credentials.',
    UserToken_ResetAll_Success: 'All user tokens have been reset',
    UserToken_Reset_Success: 'Your user token has been reset',
    UserToken_ResetById_Message: 'User token of {0} has been reset',

    // Admin -> Security -> Users -> User Token -> Reset Token
    UserToken_UserTokenUser_Title: 'User Token',
    UserToken_UserTokenUser_ResetToken_Title: 'Reset user token',
    UserToken_UserTokenUser_ResetToken_Html: '<p>Resetting a user’s token will invalidate their current token and force a new token to be created the next time it is accessed by the user.</p>',
    UserToken_UserTokenUser_ResetToken_Button: 'Reset user token',

    // User -> User Token
    UserToken_Text: 'User Token',
    UserToken_Description: 'Access Nexus Repository Manager without the use of passwords',
    UserToken_UserTokenCurrent_Access_Title: 'Access your token',
    UserToken_UserTokenCurrent_Access_Html: 'A new user token will be created the first time it is accessed.',
    UserToken_UserTokenCurrent_Access_Button: 'Access user token',
    UserToken_UserTokenCurrent_Reset_Title: 'Reset your token',
    UserToken_UserTokenCurrent_Reset_Html: 'Resetting your user token will invalidate the current token and force a new token to be created the next time it is accessed.',
    UserToken_UserTokenCurrent_Reset_Button: 'Reset user token',

    // User -> User Token -> Access Token
    UserToken_UserTokenDetails_Title: 'User Token',
    UserToken_UserTokenDetails_Html1: 'User tokens are a combination of a name and password codes. <strong>Keep these codes secret.</strong>',
    UserToken_UserTokenDetails_Html2: '<p>Your user token is</p>',
    UserToken_UserTokenDetails_Html3: '<p>Use the following in your Maven settings.xml:</p>',
    UserToken_UserTokenDetails_Html4: '<p>Use the following for a base64 representation of "user:password":</p>',
    UserToken_UserTokenDetails_AutoClose_Html: 'This window will automatically close after one minute.',
    UserToken_UserTokenDetails_AutoClosing_Message: 'Automatically closing user token details due to timeout',

    //Nexus Lifecycle -> Server
    Clm_ClmSettings_Permission_Error: 'You do not have permission to configure IQ Server',
    Clm_Text: 'Server',
    Clm_Description: 'Manage IQ Server configuration',
    Clm_Connection_Success: 'Connection to IQ Server verified: {0}',
    Clm_Dashboard_Title: 'Dashboard',
    Clm_Dashboard_Description : 'Open IQ Server Dashboard',
    ClmSettings_Html: '<p><a href="http://www.sonatype.com/nexus/product-overview/nexus-lifecycle" target="_blank">IQ Server</a> ' +
    'can evaluate application and organization policies.</p>' +
    '<p>To enable this feature configure the IQ Server URL, username and password.</p>',

    Clm_SettingsTestResults_Title: 'Applications',
    Clm_SettingsTestResults_EmptyText: 'No applications found',
    Clm_SettingsTestResults_Id_Header: 'Id',
    Clm_SettingsTestResults_Name_Header: 'Name',

    ClmSettings_Enable_FieldLabel: 'Enable IQ Server',
    ClmSettings_Enable_HelpText: 'Whether to use IQ Server',
    ClmSettings_URL_FieldLabel: 'IQ Server URL',
    ClmSettings_URL_HelpText: 'The address of your IQ Server',
    ClmSettings_URL_EmptyText: 'enter a URL',
    ClmSettings_AuthenticationType_FieldLabel: 'Authentication Method',
    ClmSettings_AuthenticationType_Pki: 'PKI Authentication',
    ClmSettings_AuthenticationType_User: 'User Authentication',
    ClmSettings_Username_FieldLabel: 'Username',
    ClmSettings_Username_HelpText: 'User with access to IQ Server',
    ClmSettings_Username_EmptyText: 'enter a name',
    ClmSettings_Password_FieldLabel: 'Password',
    ClmSettings_Password_HelpText: 'Credentials for the IQ Server User',
    ClmSettings_Password_EmptyText: 'enter a password',
    ClmSettings_ConnectionTimeout_FieldLabel: 'Connection Timeout',
    ClmSettings_ConnectionTimeout_HelpText: 'Seconds to wait for activity before stopping and retrying the connection. Leave blank to use the globally defined HTTP timeout.',
    ClmSettings_ConnectionTimeout_EmptyText: 'enter a timeout',
    ClmSettings_Properties_FieldLabel: 'Properties',
    ClmSettings_Properties_HelpText: 'Additional properties to configure for IQ Server',
    ClmSettings_Properties_EmptyText: 'enter properties',
    ClmSettings_Properties_Verify_Button: 'Verify connection',

    // Healthcheck results
    HealthCheckInfo_Security_Alerts_Label: 'Security',
    HealthCheckInfo_License_Threat_Label: 'License ',
    HealthCheckInfo_Tooltip: 'License and security data is only available with a paid license.',
    HealthCheckInfo_LoggedInOnly_Tooltip: 'The license and security data is only available once you have logged in.',
    HealthCheckInfo_NoPermission_Tooltip: 'You do not have permission to view the license and security data.',

    FirewallRepositoryColumn_Header: 'IQ Policy Violations',
    FirewallRepositoryColumn_Loading: 'Loading&hellip;',
    FirewallRepositoryColumn_NoViolations: 'No violations',

    DatabaseQuorumReset_Title: 'Cluster Reset',
    DatabaseQuorumResetConfirm_Resetting: 'Resetting Cluster Size',
    DatabaseQuorumReset_Description: 'Take your cluster down to a single node',
    DatabaseQuorumReset_ResetButton: 'Reset Database Quorum',
    DatabaseQuorumResetConfirm_Title: 'Confirm Cluster Reset',
    DatabaseQuorumResetConfirm_HelpText: 'Have you ensured that other nodes in the cluster are shut down? Resetting the quorum can result in corrupt data if other nodes are still online.',
    DatabaseQuorumResetConfirm_Fail: 'Failed to reset database cluster quorum setting!',
    DatabaseQuorumResetConfirm_GetLocalNode_Fail: 'Unable to detect which node you are currently connected to',
    DatabaseQuorumResetConfirm_LocalNodeNotKnown: 'Cannot reset database cluster quorum setting, the current node is unidentified',
    DatabaseQuorumResetConfirm_Success: 'The database cluster write quorum was reset to one node',
    DatabaseQuorumResetConfirm_Yes: 'Reset Quorum',
    DatabaseQuorumResetConfirm_No: '@Button_Cancel',

    // Tags
    ComponentTags_TagTitle: 'Component Tags',
    ComponentTags_NoTagsFound: 'No tags found',
    ComponentTags_ClickForDetails: 'Click row to view details in a new window',
    ComponentTags_TagNameHeader: 'Tag Name',
    ComponentTags_FirstCreatedHeader: 'First Created Time',
    ComponentTags_LastUpdatedHeader: 'Last Updated Time',

    Tags_Description: 'View created tags',
    Tags_Title: 'Tags',
    Tags_EmptyText: 'No tags found.',
    TagFeature_FindTaggedComponents_Button: 'Find Tagged Components',
    TagPanel_Attributes_Label: 'Attributes',
    TagPanel_FirstCreated_Label: 'First Created Time',
    TagPanel_LastUpdated_Label: 'Last Updated Time'
  }
}, function(obj) {
  NX.I18n.register(obj);
});

/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * ProUi plugin configuration.
 *
 * @since 3.0
 */
Ext.define('NX.proui.app.PluginConfig', {
  '@aggregate_priority': 100,

  requires: [
    'NX.State',
    'NX.proui.app.PluginStrings'
  ],

  controllers: [
    { id: 'NX.proui.controller.Crowd',
      active: function () {
        return NX.State.getValue('crowd', {})['licenseValid']
            && NX.app.Application.bundleActive('com.sonatype.nexus.plugins.nexus-crowd-plugin');
      }
    },
    'NX.proui.controller.FeatureGroups',
    { id: 'NX.proui.controller.ComponentTags',
      active: function () {
        return NX.app.Application.bundleActive('com.sonatype.nexus.plugins.nexus-tags-plugin');
      }
    },
    { id: 'NX.proui.controller.HealthCheckRepositoryDetail',
      active: function () {
        return NX.app.Application.bundleActive('com.sonatype.nexus.plugins.nexus-clm-plugin');
      }
    },
    { id: 'NX.proui.controller.HealthCheckAssetDetail',
      active: function () {
        return NX.app.Application.bundleActive('com.sonatype.nexus.plugins.nexus-clm-plugin');
      }
    },
    { id: 'NX.proui.controller.HealthCheckInfo',
      active: function () {
        return NX.app.Application.bundleActive('com.sonatype.nexus.plugins.nexus-clm-plugin');
      }
    },
    {
      id: 'NX.proui.controller.LicenseWarnings',
      active: function () {
        return NX.State.requiresLicense();
      }
    },
    { id: 'NX.proui.controller.UserToken',
      active: function () {
        return NX.State.getValue('usertoken', {})['licenseValid']
            && NX.app.Application.bundleActive('com.sonatype.nexus.plugins.nexus-usertoken-plugin');
      }
    },
    { id: 'NX.proui.controller.DatabaseQuorumReset',
      active: function () {
        return true;
      }
    },
    {
      id: 'NX.proui.controller.Tags',
      active: function() {
        return NX.app.Application.bundleActive('com.sonatype.nexus.plugins.nexus-tags-plugin');
      }
    }
  ]
});

/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Usertoken user tab.
 *
 * @since 3.0
 */
Ext.define('NX.proui.view.usertoken.UserTokenUser', {
  extend: 'NX.view.SettingsPanel',
  alias: 'widget.nx-proui-usertoken-user',
  requires: [
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function() {
    Ext.apply(this, {
      title: NX.I18n.get('UserToken_UserTokenUser_Title'),

      settingsForm: [
        {
          xtype: 'nx-settingsform',
          itemId: 'resetAll',
          title: NX.I18n.get('UserToken_UserTokenUser_ResetToken_Title'),

          items: [
            {
              xtype: 'label',
              html: NX.I18n.get('UserToken_UserTokenUser_ResetToken_Html')
            }
          ],

          buttonAlign: 'left',
          buttons: [
            { text: NX.I18n.get('UserToken_UserTokenUser_ResetToken_Button'), action: 'reset', ui: 'nx-primary', glyph: 'xf023@FontAwesome' /* fa-lock */ }
          ]
        }
      ]
    });

    this.callParent();
  }

});

/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Tag model.
 *
 * @since 3.14
 */
Ext.define('NX.proui.model.Tag', {
  extend: 'Ext.data.Model',
  fields: [
    {name: 'id', type: 'string', sortType: 'asUCText'},
    {name: 'lastUpdatedTime', type: 'string'},
    {name: 'firstCreatedTime', type: 'string'}
  ]
});

/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Current user, usertoken settings form.
 *
 * @since 3.0
 */
Ext.define('NX.proui.view.usertoken.UserTokenCurrent', {
  extend: 'NX.view.SettingsPanel',
  alias: 'widget.nx-proui-usertoken-current',
  requires: [
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function() {
    Ext.apply(this, {
      settingsForm: [
        {
          xtype: 'form',
          ui: 'nx-subsection',
          frame: true,
          title: NX.I18n.get('UserToken_UserTokenCurrent_Access_Title'),

          items: [
            {
              xtype: 'label',
              html: NX.I18n.get('UserToken_UserTokenCurrent_Access_Html')
            }
          ],

          buttonAlign: 'left',
          buttons: [
            { text: NX.I18n.get('UserToken_UserTokenCurrent_Access_Button'), action: 'access', ui: 'nx-primary', glyph: 'xf023@FontAwesome' /* fa-lock */ }
          ]
        },
        {
          xtype: 'form',
          ui: 'nx-subsection',
          frame: true,
          title: NX.I18n.get('UserToken_UserTokenCurrent_Reset_Title'),

          items: [
            {
              xtype: 'label',
              html: NX.I18n.get('UserToken_UserTokenCurrent_Reset_Html')
            }
          ],

          buttonAlign: 'left',
          buttons: [
            { text: NX.I18n.get('UserToken_UserTokenCurrent_Reset_Button'), action: 'reset', glyph: 'xf023@FontAwesome' /* fa-lock */ }
          ]
        }
      ]
    });

    this.callParent();
  }

});

/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Crowd settings form.
 *
 * @since 3.0
 */
Ext.define('NX.proui.view.crowd.CrowdSettings', {
  extend: 'NX.view.SettingsPanel',
  alias: 'widget.nx-proui-crowd-settings',
  requires: [
    'NX.Conditions',
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    me.settingsForm = {
      xtype: 'nx-settingsform',
      settingsFormSuccessMessage: NX.I18n.get('Crowd_CrowdSettings_Update_Success'),
      api: {
        load: 'NX.direct.crowd_Crowd.read',
        submit: 'NX.direct.crowd_Crowd.update'
      },
      editableCondition: NX.Conditions.isPermitted('nexus:crowd:update'),
      editableMarker: NX.I18n.get('Crowd_CrowdSettings_Update_Error'),

      items: [
        {
          xtype: 'label',
          html: NX.I18n.get('Crowd_CrowdSettings_Html')
        },
        {
          xtype: 'checkbox',
          name: 'enabled',
          fieldLabel: NX.I18n.get('Crowd_CrowdSettings_Enable_FieldLabel')
        },
        {
          xtype: 'checkbox',
          name: 'realmActive',
          fieldLabel: NX.I18n.get('Crowd_CrowdSettings_Activate_FieldLabel'),
          helpText: NX.I18n.get('Crowd_CrowdSettings_Activate_HelpText')
        },
        {
          xtype: 'nx-url',
          name: 'url',
          fieldLabel: NX.I18n.get('Crowd_CrowdSettings_URL_FieldLabel'),
          helpText: NX.I18n.get('Crowd_CrowdSettings_URL_HelpText')
        },
        {
          name: 'applicationName',
          fieldLabel: NX.I18n.get('Crowd_CrowdSettings_Name_FieldLabel'),
          inputAttrTpl: 'autocomplete="new-username"'
        },
        {
          xtype: 'nx-password',
          name: 'applicationPassword',
          fieldLabel: NX.I18n.get('Crowd_CrowdSettings_Password_FieldLabel'),
          inputAttrTpl: 'autocomplete="new-password"'
        },
        {
          xtype: 'numberfield',
          name: 'timeout',
          fieldLabel: NX.I18n.get('Crowd_CrowdSettings_Request_FieldLabel'),
          helpText: NX.I18n.get('Crowd_CrowdSettings_Request_HelpText'),
          allowBlank: true,
          allowDecimals: false,
          allowExponential: false,
          minValue: 1,
          maxValue: 3600
        }
      ]
    };

    me.callParent();

    me.down('nx-settingsform').getDockedItems('toolbar[dock="bottom"]')[0].add({
      xtype: 'button', text: NX.I18n.get('Crowd_CrowdSettings_VerifyConnection_Text'), formBind: true, action: 'verify'
    },
    {
      xtype: 'button',
      text: NX.I18n.get('Crowd_CrowdSettings_ClearCache_Text'),
      glyph: 'xf014@FontAwesome' /* fa-trash-o */,
      formBind: true,
      action: 'clearCache'
    }
    );
  }

});

/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Tag panel.
 *
 * @since 3.14
 */
Ext.define('NX.proui.view.tags.TagPanel', {
  extend: 'Ext.panel.Panel',
  alias: 'widget.nx-proui-tag-panel',
  autoScroll: true,

  requires: [
    'NX.I18n'
  ],

  cls: 'nx-hr',
  ui: 'nx-inset',
  layout: {
    type: 'vbox',
    align: 'stretch'
  },

  title: 'Details',

  loadRecord: function(record) {
    var me = this;

    me.removeAll(true);

    NX.direct.proui_TagList.getTag(record.get('id'), function(response) {
      var items = [],
          tag = response.data;

      if (!response.success) {
        return;
      }

      items.push(me.createTextField(NX.I18n.get('TagPanel_FirstCreated_Label'), new Date(tag.firstCreatedTime).toLocaleString()));

      items.push({xtype:'label', html:'&nbsp;'});

      items.push(me.createTextField(NX.I18n.get('TagPanel_LastUpdated_Label'), new Date(tag.lastUpdatedTime).toLocaleString()));

      items.push({xtype:'label', html:'&nbsp;'});

      items.push(me.createHtmlField(NX.I18n.get('TagPanel_Attributes_Label'), me.toJsonText(tag.attributes)));

      me.add({
        ui: 'nx-subsection',
        frame: true,
        xtype: 'panel',

        layout: {
          type: 'vbox',
          align: 'stretch'
        },
        items: items
      });

      me.fireEvent('recordloaded', me, record);
    });
  },

  /*
   * @private
   * Value will be HTML encoded
   */
  createTextField: function(label, value) {
    return this.createHtmlField(label, Ext.htmlEncode(value));
  },

  /*
   * @private
   * Note callers should ensure any input in value is already HTML encoded.
   */
  createHtmlField: function(label, value) {
    return {
      items: [{
        xtype: 'label',
        html: '<b>' + Ext.htmlEncode(label) + ':</b>'
      }, {
        xtype: 'label',
        html: value
      }],
      xtype: 'panel',
      layout: 'vbox',
      frame: false,
      ui: 'nx-subsection'
    };
  },

  /*
   * @private
   */
  toJsonText: function(obj) {
    return  '<pre>' + Ext.htmlEncode(JSON.stringify(obj, null, 2)) + '</pre>';
  }
});

/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Tags list details panel.
 *
 * @since 3.14
 */
Ext.define('NX.proui.view.tags.ComponentTags', {
  extend: 'Ext.grid.Panel',
  alias: 'widget.nx-proui-tags-taglistdetails',
  requires: [
    'NX.I18n'
  ],

  manageHeight: false,

  store: 'ComponentTags',

  initComponent: function() {
    Ext.apply(this, {
      store: 'ComponentTags',

      // Prevent the store from automatically loading
      loadStore: Ext.emptyFn,

      allowDeselect: true,

      viewConfig: {
        emptyText: NX.I18n.get('ComponentTags_NoTagsFound'),
        deferEmptyText: false
      },

      columns: [
        {
          text: NX.I18n.get('ComponentTags_TagNameHeader'),
          dataIndex: 'id',
          renderer: Ext.htmlEncode,
          flex: 2.5
        },
        {
          text: NX.I18n.get('ComponentTags_FirstCreatedHeader'),
          dataIndex: 'firstCreatedTime',
          flex: 2.5,
          renderer: function (val) {
            return new Date(val).toLocaleString();
          }
        },
        {
          text: NX.I18n.get('ComponentTags_LastUpdatedHeader'),
          dataIndex: 'lastUpdatedTime',
          flex: 2.5,
          renderer: function (val) {
            return new Date(val).toLocaleString();
          }
        }
      ]
    });

    this.on('itemclick', function(dv, record) {
      var bookmark = Ext.create('NX.Bookmark');

      bookmark.applyToken('browse/tags');
      bookmark.appendSegments(record.id);
      NX.Bookmarks.navigateTo(bookmark);
    });

    this.callParent();
  }
});

/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * ComponentTags model.
 *
 * @since 3.14
 */
Ext.define('NX.proui.model.ComponentTags', {
  extend: 'Ext.data.Model',
  fields: [
    {name: 'id', type: 'string', sortType: 'asUCText'},
    {name: 'lastUpdatedTime', type: 'string'},
    {name: 'firstCreatedTime', type: 'string'},
    {name: 'url', type: 'string'},
    {name: 'details', type: 'string'}
  ]
});

/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * ComponentTags store.
 *
 * @since 3.14
 */
Ext.define('NX.proui.store.ComponentTags', {
  extend: 'Ext.data.Store',
  model: 'NX.proui.model.ComponentTags',

  proxy: {
    type: 'direct',

    api: {
      read: 'NX.direct.proui_TagList.readTagListDetails'
    },

    reader: {
      type: 'json',
      rootProperty: 'data',
      successProperty: 'success'
    }
  },

  autoLoad: false,

  sorters: { property: 'id', direction: 'ASC' }
});

/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Tag List details controller.
 *
 * Shows tags data associated with a selected component or asset.
 *
 * @since 3.14
 */
Ext.define('NX.proui.controller.ComponentTags', {
  extend: 'NX.app.Controller',
  requires: [
    'NX.Permissions',
    'NX.State'
  ],

  views: [
    'tags.ComponentTags'
  ],

  models: [
    'ComponentTags'
  ],

  stores: [
    'ComponentTags'
  ],

  /**
   * @override
   */
  init: function() {
    var me = this;

    me.listen({
      component: {
        'nx-coreui-component-componentassetinfo': {
          updated: me.onComponentAssetInfoUpdated
        },
        'nx-coreui-component-assetcontainer': {
          updated: me.onAssetContainerInfoUpdated
        },
        'nx-coreui-component-componentinfo': {
          updated: me.onComponentInfoUpdated
        }
      }
    });
  },

  /**
   * Shows tag information about selected asset if user is logged in, has "nexus:tags:read" and
   * we have a PRO edition.
   *
   * @private
   * @param {NX.coreui.view.component.AssetContainer} container
   * @param {NX.coreui.model.AssetModel} assetModel selected asset
   */
  onAssetContainerInfoUpdated: function(container, assetModel) {
    var me = this;
    var panel = container.down('nx-proui-tags-taglistdetails');

    if (this.isTaggingEnabled()) {
      if (!panel) {
        // add a tab to the container
        container.addTab(
          {
            xtype: 'nx-proui-tags-taglistdetails',
            ui: 'nx-inset',
            title: NX.I18n.get('ComponentTags_TagTitle'),
            itemId: 'taglistdetails',
            weight: 40,
            autoScroll: true
          }
        );
      }
      me.loadComponentData(assetModel.get('componentId'), assetModel.get('repositoryName'));
    } else {
      container.remove(panel);
    }
  },

  /**
   * Shows tag information about selected asset if user is logged in, has "nexus:tags:read" and
   * we have a PRO edition.
   *
   * @private
   * @param {NX.coreui.view.component.ComponentAssetInfo} container
   * @param {NX.coreui.model.Asset} asset selected asset
   * @param {NX.coreui.model.Component} component selected asset's component
   */
  onComponentAssetInfoUpdated: function(container, asset, component) {
    this.onComponentUpdated(container, component.get('id'), component.get('repositoryName'));
  },

  /**
   * Shows tag information about the selected component if user is logged in, has "nexus:tags:read" and
   * we have a PRO edition.
   *
   * @private
   * @param {NX.coreui.view.component.ComponentAssetInfo} container
   * @param {NX.coreui.model.Component} component selected asset's component
   */
  onComponentInfoUpdated: function(container, component) {
    this.onComponentUpdated(container, component.get('id'), component.get('repositoryName'));
  },

  /**
   * @private
   */
  onComponentUpdated: function(container, componentId, repositoryName) {
    var me = this;
    var panel = container.down('nx-proui-tags-taglistdetails');

    if (this.isTaggingEnabled()) {
      if (!panel) {
        // add a collapsible panel to the container
        container.add(
            {
              xtype: 'nx-proui-tags-taglistdetails',
              ui: 'nx-inset',
              title: NX.I18n.get('ComponentTags_TagTitle'),
              itemId: 'tagPanel',
              weight: 20,
              autoScroll: true,
              collapsible: true
            }
        );
      }
      me.loadComponentData(componentId, repositoryName);
    } else {
      container.remove(panel);
    }
  },

  loadComponentData: function(componentId, repositoryName) {
    var me = this;
    var tagComponentStore = me.getStore('ComponentTags');
    tagComponentStore.load({
      params: {
        filter: [{property: 'componentId',value :componentId}, {property:'repositoryName', value:repositoryName}]
      },
      scope: this
    });
  },

  isTaggingEnabled: function() {
    var edition = NX.State.getEdition();
    return NX.State.getUser() && NX.Permissions.check('nexus:tags:read') &&
        !('EVAL' === edition || 'OSS' === edition);
  }
});

/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Health Check info panel.
 *
 * @since 3.0
 */
Ext.define('NX.proui.view.healthcheck.HealthCheckAssetDetail', {
  extend: 'Ext.panel.Panel',
  alias: 'widget.nx-proui-healthcheck-healthcheckassetdetail',
  requires: [
    'NX.util.Base64',
    'NX.util.Url',
    'NX.Windows',
    'NX.I18n'
  ],
  ui: 'nx-inset',

  layout: {
    type: 'vbox',
    align: 'stretch',
    pack: 'start'
  },

  /**
   * Name of repository containing asset to be shown.
   * @private
   */
  repositoryName: undefined,

  /**
   * Format of asset to be shown.
   * @private
   */
  format: undefined,

  /**
   * Path of asset to be shown.
   * @private
   */
  path: undefined,

  /**
   * @private
   * True if info was successfully loaded from server.
   */
  loaded: false,

  /**
   * @private
   * True when active in toolbar.
   */
  active: false,

  listeners: {
    afterrender: function() {
      var me = this;
      me.active = true;
      me.loadInfo();
    }
  },

  /**

   * Shows Health Check information about selected file.
   *
   * @public
   * @param {NX.coreui.model.Asset} assetModel selected asset
   */
  showInfo: function(assetModel) {
    var me = this;
    me.format = assetModel.get('format');
    me.repositoryName = assetModel.get('containingRepositoryName');
    me.path = assetModel.get('name');
    me.loaded = false;
    me.loadInfo();
  },

  /**
   * @private
   * Loads Health Check information about selected file.
   */
  loadInfo: function() {
    var me = this;

    if (!me.loaded) {
      me.removeAll();
      if (me.active && me.rendered && me.path) {
        me.getEl().mask(NX.I18n.get('HealthCheckInfo_Loading_Text'));
        me.add([
          {
            xtype: 'panel',
            ui: 'nx-subsection',
            frame: true,
            minHeight: 600,

            items: [
              {
                xtype: 'box',
                border: false,
                autoEl: {
                  tag: 'iframe',
                  src: NX.util.Url.urlOf('service/rest/healthcheck/healthCheckFileDetail' +
                      '/' + NX.util.Base64.encode(me.path) +
                      '/' + NX.util.Base64.encode(me.repositoryName) +
                      '/index.html?' +
                      Ext.Object.toQueryString({
                        format: me.format
                      })),
                  width: '100%',
                  height: '100%',
                  scrolling: 'auto'
                },
                listeners: {
                  afterrender: function(iframe) {
                    me.loaded = true;
                    iframe.getEl().on({
                      load: function() {
                        var insight = iframe.getEl().dom.contentWindow.Insight;
                        me.getEl().unmask();
                        if (insight) {
                          me.setClmComponent(insight);
                          me.registerClmViewDetailsListener(insight);
                        }
                      }
                    });
                  }
                }
              }
            ]
          }
        ]);
      }
    }
  },

  /**
   * @private
   */
  setClmComponent: function(insight) {
    var me = this;

    NX.direct.healthcheck_AssetDetail.identify(me.repositoryName, me.path, function(response) {
      if (Ext.isObject(response)) {
        if (response.success) {
          var format = response.data.componentIdentifier.format,
              coordinates = response.data.componentIdentifier.coordinates,
              hash = response.data.hash;

          if (me.isLegacyClm(insight)) {
            me.setLegacyClmComponent(insight, format, coordinates, hash);
          }
          else {
            insight.setCoordinates(format, coordinates, {hash: hash});
          }
        }
        else {
          insight.setError({
            errorMessage: 'Unable to identify component: ' + response.message,
            errorCode: 400
          });
        }
      }
      else {
        insight.setError({
          errorMessage: 'Unable to identify component',
          errorCode: 500
        });
      }
    }, undefined, {skipResultCheck: true});
  },

  /**
   * @private
   */
  setLegacyClmComponent: function(insight, format, coordinates, hash) {
    if (format !== 'maven') {
      insight.setError({
        errorMessage: 'Unsupported repository format, please upgrade to Nexus IQ Server 1.13 or greater.',
        errorCode: 400
      });
      return;
    }

    insight.setGav({
      groupId: coordinates.groupId,
      artifactId: coordinates.artifactId,
      version: coordinates.version,
      extension: coordinates.extension,
      classifier: coordinates.classifier,
      hash: hash
    });
  },

  /**
   * @private
   */
  registerClmViewDetailsListener: function(insight) {
    var me = this;
    if (me.isLegacyClm(insight)) {
      me.registerLegacyClmViewDetailsListener(insight);
    }
    else {
      insight.registerCoordsViewDetailsListener(
          function(appId, format, coordinates, hash) {
            var component = {
                  format: format,
                  coordinates: {}
                },
                queryParams = {
                  appId: appId,
                  hash: hash
                };

            if (coordinates) {
              for (var i = 0; i < coordinates.length; i += 2) {
                component.coordinates[coordinates[i]] = coordinates[i + 1];
              }
            }
            queryParams['componentIdentifier'] = JSON.stringify(component);

            if (coordinates) {
              NX.Windows.open(
                  NX.util.Url.urlOf(
                      'service/rest/healthcheck/clm/assets/version-graph/rm/nexus/viewdetails.html?' +
                      Ext.Object.toQueryString(queryParams)
                  )
              );
            }
          }
      );
    }
  },

  registerLegacyClmViewDetailsListener: function(insight) {
    insight.registerViewDetailsListener(
        function(appId, groupId, artifactId, version, classifier, extension, hash) {
          var queryParams = {
            appId: appId,
            hash: hash,
            groupId: groupId,
            artifactId: artifactId,
            version: version,
            classifier: classifier,
            extension: extension
          };

          NX.Windows.open(
              NX.util.Url.urlOf(
                  'service/rest/healthcheck/clm/assets/version-graph/rm/nexus/viewdetails.html?' +
                  Ext.Object.toQueryString(queryParams)
              )
          );
        });
  },

  showDetails: function(appId, hash, component, legacy) {
    Sonatype.view.mainTabPanel.addOrShowTab(me.toTabId(appId, hash, component, legacy),
        Nexus.clm.ComponentDetailView, {
          title: 'IQ Server Detail',
          appId: appId,
          hash: hash,
          component: !legacy ? component : null,
          gav: legacy ? component.coordinates : null
        });
  },

  /**
   * @private
   */
  isLegacyClm: function(insight) {
    return !(insight.registerCoordsViewDetailsListener || insight.setCoordinates);
  }

});

/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * HealthCheck repository detail controller.
 *
 * Adds a detail button to health check summary window shown when hovering over enabled repositories in repository grid.
 *
 * @since 3.0
 */
Ext.define('NX.proui.controller.HealthCheckRepositoryDetail', {
  extend: 'NX.app.Controller',
  requires: [
    'NX.Permissions',
    'NX.Windows'
  ],

  /**
   * @override
   */
  init: function() {
    var me = this;

    me.listen({
      component: {
        'nx-coreui-healthcheck-summary': {
          afterrender: me.addDetailButton
        },
        'nx-coreui-healthcheck-summary button[action=viewdetail]': {
          click: me.viewDetail
        }
      }
    });
  },

  /**
   * Add 'View Detailed Report' to Summary tooltip window.
   *
   * @private
   * @param {NX.coreui.view.healthcheck.HealthCheckSummary} win summary window
   */
  addDetailButton: function(win) {
    var statusModel = win['statusModel'],
        toolbar;

    if (statusModel && statusModel.get('detailedReportSupported')) {
      toolbar = win.getDockedItems('toolbar[dock="bottom"]')[0];
      if (statusModel.get('detailUrl')) {
        toolbar.add([
          '->',
          {
            xtype: 'button', text: 'View Detailed Report', action: 'viewdetail',
            disabled: !NX.Permissions.check('nexus:healthcheckdetail:read')
          }
        ]);
      }
      else {
        toolbar.add([
          '->',
          'The next analysis will include the detailed report.'
        ]);
      }
    }
  },

  /**
   * Show detail report into a new browser tab/window.
   *
   * @private
   * @param {Ext.Button} button 'View Detailed Report' button
   */
  viewDetail: function(button) {
    var win = button.up('window'),
        statusModel = win['statusModel'];

    NX.Windows.open(statusModel.get('detailUrl'));
    win.close();
  }

});

/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Tags store.
 *
 * @since 3.14
 */
Ext.define('NX.proui.store.Tags', {
  extend: 'Ext.data.Store',
  model: 'NX.proui.model.Tag',

  proxy: {
    type: 'direct',

    api: {
      read: 'NX.direct.proui_TagList.readTags'
    },

    reader: {
      type: 'json',
      rootProperty: 'data',
      successProperty: 'success'
    }
  },

  autoLoad: false,

  sorters: { property: 'id', direction: 'ASC' }
});

/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Tags grid
 *
 * @since 3.14
 */
Ext.define('NX.proui.view.tags.TagList', {
  extend: 'NX.view.drilldown.Master',
  alias: 'widget.nx-proui-tags-list',
  requires: [
    'NX.I18n'
  ],

  stateful: true,
  stateId: 'nx-proui-tags-list',

  tbar: {
    xtype: 'nx-actions'
  },

  /**
   * @override
   */
  initComponent: function() {
    Ext.apply(this, {
      store: 'Tags',

      viewConfig: {
        emptyText: NX.I18n.get('ComponentTags_NoTagsFound'),
        deferEmptyText: false
      },

      columns: [
        {
          text: NX.I18n.get('ComponentTags_TagNameHeader'),
          dataIndex: 'id',
          flex: 2.5,
          renderer: Ext.htmlEncode
        },
        {
          text: NX.I18n.get('ComponentTags_FirstCreatedHeader'),
          dataIndex: 'firstCreatedTime',
          flex: 2.5,
          renderer: function (val) {
            return new Date(val).toLocaleString();
          }
        },
        {
          text: NX.I18n.get('ComponentTags_LastUpdatedHeader'),
          dataIndex: 'lastUpdatedTime',
          flex: 2.5,
          renderer: function (val) {
            return new Date(val).toLocaleString();
          }
        }
      ],

      plugins: [
        {ptype: 'gridfilterbox', emptyText: NX.I18n.get('Tags_EmptyText')}
      ]
    });

    this.callParent();
  }

});

/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Tags feature panel.
 *
 * @since 3.14
 */
Ext.define('NX.proui.view.tags.TagFeature', {
  extend: 'NX.view.drilldown.Drilldown',
  alias: 'widget.nx-proui-tags-feature',

  requires: [
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function() {
    Ext.apply(this, {
      iconCls: 'x-fa fa-tag',

      masters: [
        { xtype: 'nx-proui-tags-list' }
      ],

      tabs: { xtype: 'nx-proui-tag-panel' },

      nxActions: [{
        xtype: 'button',
        text: NX.I18n.get('TagFeature_FindTaggedComponents_Button'),
        glyph: 'xf002@FontAwesome' /* fa-search */,
        action: 'search',
        disabled: false
      }]
    });

    this.callParent();
  }
});

/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Tag Controller
 *
 * @since 3.14
 */
Ext.define('NX.proui.controller.Tags', {
  extend: 'NX.controller.Drilldown',
  requires: [
    'NX.Bookmarks',
    'NX.Permissions',
    'NX.I18n'
  ],
  masters: [
    'nx-proui-tags-list'
  ],
  models: [
    'Tag'
  ],
  stores: [
    'Tags'
  ],
  views: [
    'tags.TagFeature',
    'tags.TagList',
    'tags.TagPanel'
  ],
  refs: [
    { ref: 'feature', selector: 'nx-proui-tags-feature' },
    { ref: 'content', selector: 'nx-feature-content' },
    { ref: 'list', selector: 'nx-proui-tags-list' },
    { ref: 'settings', selector: 'nx-proui-tags-feature nx-proui-tag-panel' }
  ],

  permission: 'nexus:tags',

  /**
   * @override
   */
  init: function() {
    var me = this;

    me.features = {
      mode: 'browse',
      path: '/tags',
      text: NX.I18n.get('Tags_Title'),
      description: NX.I18n.get('Tags_Description'),
      view: {xtype: 'nx-proui-tags-feature'},
      iconCls: 'x-fa fa-tags',
      visible: function() {
        return NX.Permissions.check('nexus:tags:read');
      }
    };

    me.callParent();

    me.listen({
      controller: {
        '#Refresh': {
          refresh: me.loadStores
        }
      },
      store: {
        '#Tags': {
          load: me.reselect
        }
      },
      component: {
        'nx-proui-tags-feature button[action=search]': {
          click: me.searchByTag
        }
      }
    });
  },

  /**
   * @override
   */
  getDescription: function(model) {
    return model.get('id');
  },

  /**
   * @override
   */
  onSelection: function(list, model) {
    if (Ext.isDefined(model)) {
      this.getSettings().loadRecord(model);
    }
  },

  searchByTag: function() {
    var tagName = NX.Bookmarks.getBookmark().segments[1],
        searchUrl = '#browse/search/custom=' + encodeURIComponent('tags="' + tagName + '"');

    window.open(searchUrl, '_self');
  }
});

/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext*/

/**
 * License warning controller, handles showing messages.
 *
 * @since 3.1
 */
Ext.define('NX.proui.controller.LicenseWarnings', {
  extend: 'NX.app.Controller',

  requires: [
    'NX.I18n',
    'NX.Permissions'
  ],
  refs: [
    {
      ref: 'licenseWarning',
      selector: '#nx-license-warning'
    }
  ],

  /**
   * The number of days before expiry that we should warn for.
   * @private
   */
  daysToWarn: 30,

  /**
   * @override
   */
  init: function () {
    var me = this;

    me.listen({
      controller: {
        '#State': {
          licensechanged: me.updateLicenseExpiryWarning
        },
        '#Permissions': {
          changed: me.updateLicenseExpiryWarning
        }
      }
    });
  },

  /**
   * Set a warning for license expiry based on the current state. 
   * @public
   */
  updateLicenseExpiryWarning: function () {
    var me = this,
        daysToExpiry = NX.State.getDaysToLicenseExpiry(),
        licenseWarning = me.getLicenseWarning();

    if (licenseWarning) {
      if (daysToExpiry != null) {
        //<if debug>
//        me.logDebug('Checking for license warning');
        //</if>
        if(daysToExpiry < 0) {
          me.setLicenseWarning(NX.I18n.get('State_License_Expired'))
        }
        else if (daysToExpiry < me.daysToWarn) {
          me.setLicenseWarning(NX.I18n.format('State_License_Expiry', daysToExpiry));
        }
      }
      else {
        //<if debug>
//        me.logDebug('Skipping check for license warning');
        //</if>
        licenseWarning.hide();
      }
    }
  },

  /**
   * Set the text for the license warning element.
   * @public
   * @param text
   */
  setLicenseWarning: function (text) {
    var me = this,
        licenseWarning = me.getLicenseWarning();
    licenseWarning.setTitle(text);
    licenseWarning.show();
  }

});

/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Dialog to display a user's user-token details.
 *
 * @since 3.0
 */
Ext.define('NX.proui.view.usertoken.UserTokenDetails', {
  extend: 'Ext.window.Window',
  alias: 'widget.nx-proui-usertoken-details',
  requires: [
    'NX.Icons',
    'NX.Messages',
    'NX.I18n'
  ],

  /**
   * user token userCode.
   *
   * @cfg {String}
   */
  nameCode: undefined,

  /**
   * user token passCode.
   *
   * @cfg {String}
   */
  passCode: undefined,

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    me.title = NX.I18n.get('UserToken_UserTokenDetails_Title');
    me.autoShow = true;
    me.modal = true;
    me.constrain = true;
    me.width = 640;
    me.resizable = false;

    me.items = {
      xtype: 'form',
      bodyPadding: 10,
      items: [
        {
          xtype: 'panel',
          layout: 'hbox',
          items: [
            { xtype: 'component', html: NX.Icons.img('usertoken-default', 'x32') },
            { xtype: 'label', margin: '0 0 0 5',
              html: NX.I18n.get('UserToken_UserTokenDetails_Html1')
            }
          ]
        },
        {
          xtype: 'label',
          html: NX.I18n.get('UserToken_UserTokenDetails_Html2')
        },
        {
          xtype: 'panel',
          layout: 'hbox',
          items: [
            {
              xtype: 'textfield',
              name: 'nameCode',
              value: me.nameCode,
              width: 100,
              readOnly: true,
              selectOnFocus: true,
              fieldCls: 'user-token-field'
            },
            {
              xtype: 'label',
              html: ':',
              cls: 'nx-user-token-field'
            },
            {
              xtype: 'textfield',
              name: 'passCode',
              value: me.passCode,
              width: 360,
              readOnly: true,
              selectOnFocus: true,
              fieldCls: 'user-token-field'
            }
          ]
        },
        {
          xtype: 'label',
          html: NX.I18n.get('UserToken_UserTokenDetails_Html3')
        },
        {
          xtype: 'textarea',
          value: '<server>\n' +
              '  <id>${server}</id>\n' +
              '  <username>' + me.nameCode + '</username>\n' +
              '  <password>' + me.passCode + '</password>\n' +
              '</server>',
          height: 90,
          width: 610,
          readOnly: true,
          selectOnFocus: true,
          fieldCls: 'user-token-field'
        },
        {
          xtype: 'label',
          html: NX.I18n.get('UserToken_UserTokenDetails_Html4')
        },
        {
          xtype: 'textfield',
          name: 'base64',
          value: NX.util.Base64.encode(me.nameCode + ":" + me.passCode),
          width: 610,
          readOnly: true,
          selectOnFocus: true,
          fieldCls: 'user-token-field'
        },
        {
          xtype: 'label',
          html: NX.I18n.get('UserToken_UserTokenDetails_AutoClose_Html')
        }
      ],
      buttonAlign: 'left',
      buttons: [
        { text: NX.I18n.get('Button_Close'), ui: 'nx-primary', handler: function () {
          this.up('window').close();
        }}
      ]
    };

    me.callParent();

    // Automatically close the window
    Ext.defer(function () {
      // ignore if already closed
      if (me.isVisible()) {
        NX.Messages.add({ text: NX.I18n.get('UserToken_UserTokenDetails_AutoClosing_Message') });
        me.close();
      }
      // 1 minute
    }, 1 * 60 * 1000);
  }

});

/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Crowd controller.
 *
 * @since 3.0
 */
Ext.define('NX.proui.controller.Crowd', {
  extend: 'NX.app.Controller',
  requires: [
    'NX.Permissions',
    'NX.Messages',
    'NX.I18n'
  ],

  views: [
    'crowd.CrowdSettings'
  ],

  /**
   * @override
   */
  init: function () {
    var me = this;

    me.getApplication().getIconController().addIcons({
      'crowd-security-source': {
        file: 'crowd.png',
        variants: ['x16']
      }
    });

    me.getApplication().getFeaturesController().registerFeature({
      mode: 'admin',
      path: '/Security/Atlassian Crowd',
      text: NX.I18n.get('Crowd_Text'),
      description: NX.I18n.get('Crowd_Description'),
      view: { xtype: 'nx-proui-crowd-settings' },
      iconConfig: {
        file: 'crowd.png',
        variants: ['x16', 'x32']
      },
      visible: function () {
        return NX.Permissions.check('nexus:crowd:read');
      }
    }, me);

    me.listen({
      component: {
        'nx-proui-crowd-settings button[action=verify]': {
          click: me.verifyConnection
        },
        'nx-proui-crowd-settings button[action=clearCache]': {
          click: me.clearCache
        }
      }
    });
  },

  verifyConnection: function (button) {
    var form = button.up('form'),
        values = form.getForm().getFieldValues();

    form.getEl().mask('Checking connection to ' + values.url);

    NX.direct.crowd_Crowd.verifyConnection(values, function (response) {
      form.getEl().unmask();
      if (Ext.isDefined(response) && response.success) {
        NX.Messages.add({ text: NX.I18n.format('Crowd_CrowdSettings_Verified_Success', values.url), type: 'success' });
      }
    });
  },

  clearCache: function (button) {
    var form = button.up('form');

    form.getEl().mask('Clearing cache...');

    NX.direct.crowd_Crowd.clearCache(function (response) {
      form.getEl().unmask();
      if (Ext.isDefined(response) && response.success) {
        NX.Messages.add({ text: NX.I18n.format('Crowd_CrowdSettings_ClearCache_Success'), type: 'success' });
      }
    });
  }

});

/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */

/*global Ext, NX*/

/**
 * System Information panel.
 *
 * @since 3.4
 */
Ext.define('NX.proui.view.database.DatabaseQuorumResetConfirm', {
  extend: 'NX.view.SettingsPanel',
  alias: 'widget.nx-proui-database-quorum-reset',
  requires: [
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function() {
    var me = this;
    Ext.apply(me, {
      settingsForm: {
        xtype: 'nx-settingsform',
        items: [
          {
            xtype: 'label',
            html: '<h3>Resetting the Database Write Quorum</h3>' +
            '<p>Resetting the database write quorum is not meant to fix all problems related to Nexus clustering. ' +
            'However it can be used if you would like to reduce your cluster down to a single node and rebuild your ' +
            'cluster.</p>' +
            '<p>It is important to understand the implications of resetting the write quorum. In doing so, you will ' +
            'move from having a "cluster" to only having one working node. If that is your intention, then we ' +
            'suggest that you first attempt to shut down any other running Nexus nodes.</p>' +
            '<p>To recreate your cluster after resetting the write quorum, you will need to reattach nodes to the ' +
            'cluster. The new nodes that join your cluster, after resetting the write quorum, may need to replicate ' +
            'all of the Nexus databases. This may consume considerable time and resources.</p>'
          }
        ],
        buttonAlign: 'left',
        buttons: [
          {
            xtype: 'button',
            text: NX.I18n.get('DatabaseQuorumReset_ResetButton'),
            glyph: 'xf019@FontAwesome' /* fa-download */,
            action: 'resetQuorum'
          }
        ]
      }
    });
    me.callParent();
  }

});

/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Usertoken settings form.
 *
 * @since 3.0
 */
Ext.define('NX.proui.view.usertoken.UserTokenSettings', {
  extend: 'NX.view.SettingsPanel',
  alias: 'widget.nx-proui-usertoken-settings',
  requires: [
    'NX.Conditions',
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function() {
    Ext.apply(this, {
      settingsForm: [
        {
          xtype: 'nx-settingsform',
          settingsFormSuccessMessage: NX.I18n.get('UserTokenSettings_Update_Success'),
          api: {
            load: 'NX.direct.usertoken_UserToken.read',
            submit: 'NX.direct.usertoken_UserToken.update'
          },
          editableCondition: NX.Conditions.isPermitted('nexus:usertoken-settings:update'),
          editableMarker: NX.I18n.get('UserTokenSettings_Update_Error'),

          items: [
            {
              xtype: 'label',
              html: NX.I18n.get('UserTokenSettings_Html')
            },
            {
              xtype: 'checkbox',
              name: 'enabled',
              fieldLabel: NX.I18n.get('UserTokenSettings_Enable_FieldLabel')
            },
            {
              xtype: 'checkbox',
              name: 'protectContent',
              fieldLabel: NX.I18n.get('UserTokenSettings_Require_FieldLabel'),
              helpText: NX.I18n.get('UserTokenSettings_Require_HelpText')
            }
          ]
        },
        {
          xtype: 'form',
          ui: 'nx-subsection',
          frame: true,
          itemId: 'resetAll',
          title: NX.I18n.get('UserTokenSettings_Reset_Title'),
          hidden: true,

          items: [
            {
              xtype: 'label',
              html: NX.I18n.get('UserTokenSettings_Reset_Html')
            }
          ],

          buttonAlign: 'left',
          buttons: [
            { text: NX.I18n.get('UserTokenSettings_ResetAll_Button'), action: 'resetall', ui: 'nx-primary', glyph: 'xf023@FontAwesome' /* fa-lock */ }
          ]
        }
      ]
    });

    this.callParent();
  }

});

/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * User Token controller.
 *
 * @since 3.0
 */
Ext.define('NX.proui.controller.UserToken', {
  extend: 'NX.app.Controller',
  requires: [
    'NX.Conditions',
    'NX.Messages',
    'NX.Permissions',
    'NX.Security',
    'NX.State',
    'NX.I18n'
  ],

  views: [
    'usertoken.UserTokenCurrent',
    'usertoken.UserTokenDetails',
    'usertoken.UserTokenSettings',
    'usertoken.UserTokenUser'
  ],
  refs: [
    {
      ref: 'userUserTokenPanel',
      selector: 'nx-coreui-user-feature nx-proui-usertoken-user'
    }
  ],

  /**
   * @override
   */
  init: function () {
    var me = this;

    me.getApplication().getIconController().addIcons({
      'feature-usertoken': {
        file: 'key.png',
        variants: ['x16', 'x32']
      },
      'usertoken-default': {
        file: 'key.png',
        variants: ['x16', 'x32']
      }
    });

    me.getApplication().getFeaturesController().registerFeature([
      {
        mode: 'admin',
        path: '/Security/User Token',
        view: { xtype: 'nx-proui-usertoken-settings' },
        text: NX.I18n.get('UserToken_Text'),
        description: NX.I18n.get('UserToken_Description'),
        iconConfig: {
          file: 'key.png',
          variants: ['x16', 'x32']
        },
        visible: function () {
          return NX.Permissions.check('nexus:usertoken-settings:read');
        }
      },
      {
        mode: 'user',
        path: '/User Token',
        text: NX.I18n.get('UserToken_Text'),
        description: NX.I18n.get('UserToken_Description'),
        view: { xtype: 'nx-proui-usertoken-current' },
        iconConfig: {
          file: 'key.png',
          variants: ['x16', 'x32']
        },
        visible: function () {
          var userTokenState = NX.State.getValue('usertoken');
          return NX.Permissions.check('nexus:usertoken-current:read') && userTokenState && userTokenState.enabled;
        }
      }
    ], me);

    me.listen({
      component: {
        'nx-proui-usertoken-settings button[action=resetall]': {
          click: me.resetAll,
          afterrender: me.bindResetAllButton
        },
        'nx-proui-usertoken-settings nx-settingsform': {
          loaded: me.onLoaded,
          submitted: me.onSubmitted
        },
        'nx-proui-usertoken-current button[action=access]': {
          click: me.accessCurrent,
          afterrender: me.bindAccessButton
        },
        'nx-proui-usertoken-current button[action=reset]': {
          click: me.resetCurrent,
          afterrender: me.bindResetCurrentButton
        },
        'nx-coreui-user-list': {
          beforerender: me.bindUserUserTokenTab,
          selection: me.onUserSelection
        },
        'nx-proui-usertoken-user button[action=reset]': {
          click: me.reset,
          afterrender: me.bindResetButton
        }
      }
    });
  },

  /**
   * @private
   */
  onLoaded: function (form, action) {
    var resetAllForm = form.up('nx-proui-usertoken-settings').down('#resetAll');

    if (action.result.data.enabled) {
      resetAllForm.show();
    }
    else {
      resetAllForm.hide();
    }
  },

  /**
   * @private
   */
  onSubmitted: function (form, action) {
    NX.State.setValue('usertoken', Ext.apply(
        NX.State.getValue('usertoken', {}),
        { enabled: action.result.data.enabled }
    ));
  },

  /**
   * @private
   */
  onUserSelection: function (list, model) {
    var panel = this.getUserUserTokenPanel();

    if (Ext.isDefined(model) && panel) {
      panel.down('form').loadRecord(model);
    }
  },

  /**
   * @private
   * Show/Hide user token tab if user token is enabled.
   */
  bindUserUserTokenTab: function (list) {
    var me = this;
    list.mon(
        NX.Conditions.watchState('usertoken', function (userToken) {
          return userToken && userToken.enabled;
        }),
        {
          satisfied: function () {
            var panel = me.getUserUserTokenPanel();

            if (!panel) {
              me.fireEvent('userSettingsAddTab', {xtype: 'nx-proui-usertoken-user'});
            }
          },
          unsatisfied: function () {
            var panel = me.getUserUserTokenPanel();

            if (panel) {
              me.fireEvent('userSettingsRemoveTab', {xtype: 'nx-proui-usertoken-user'});
            }
          },
          scope: me
        }
    );
  },

  /**
   * @override
   * @private
   * Enable 'Reset all user tokens' when user has 'nexus:usertoken-users:delete' permission.
   */
  bindResetAllButton: function (button) {
    button.mon(
        NX.Conditions.and(
            NX.Conditions.isPermitted('nexus:usertoken-users:delete')
        ),
        {
          satisfied: function () {
            button.enable();
          },
          unsatisfied: function () {
            button.disable();
          }
        }
    );
  },

  /**
   * @override
   * @private
   * Enable 'Access user token' when user has 'nexus:usertoken-current:read' permission.
   */
  bindAccessButton: function (button) {
    button.mon(
        NX.Conditions.and(
            NX.Conditions.isPermitted('nexus:usertoken-current:read')
        ),
        {
          satisfied: function () {
            button.enable();
          },
          unsatisfied: function () {
            button.disable();
          }
        }
    );
  },

  /**
   * @override
   * @private
   * Enable 'Reset user token' when user has 'nexus:usertoken-current:delete' permission.
   */
  bindResetCurrentButton: function (button) {
    button.mon(
        NX.Conditions.and(
            NX.Conditions.isPermitted('nexus:usertoken-current:delete')
        ),
        {
          satisfied: function () {
            button.enable();
          },
          unsatisfied: function () {
            button.disable();
          }
        }
    );
  },

  /**
   * @override
   * @private
   * Enable 'Reset user token' when user has 'nexus:usertoken-user:delete' permission.
   */
  bindResetButton: function (button) {
    button.mon(
        NX.Conditions.and(
            NX.Conditions.isPermitted('nexus:usertoken-user:delete')
        ),
        {
          satisfied: function () {
            button.enable();
          },
          unsatisfied: function () {
            button.disable();
          }
        }
    );
  },

  /**
   * @private
   */
  resetAll: function () {
    NX.Security.doWithAuthenticationToken(
        NX.I18n.format('UserToken_Authentication_Validation', 'Resetting'),
        {
          success: function (authToken) {
            NX.direct.usertoken_UserToken.resetAll(authToken, function (response) {
              if (Ext.isDefined(response) && response.success) {
                NX.Messages.add({ text: NX.I18n.get('UserToken_ResetAll_Success'), type: 'success' });
              }
            });
          }
        }
    );
  },

  /**
   * @private
   */
  accessCurrent: function () {
    NX.Security.doWithAuthenticationToken(
      NX.I18n.format('UserToken_Authentication_Validation', 'Accessing'),
        {
          success: function (authToken) {
            NX.direct.usertoken_UserToken.retrieveCurrent(authToken, function (response) {
              if (Ext.isDefined(response) && response.success) {
                Ext.widget('nx-proui-usertoken-details', response.data);
              }
            });
          }
        }
    );
  },

  /**
   * @private
   */
  resetCurrent: function () {
    NX.Security.doWithAuthenticationToken(
      NX.I18n.format('UserToken_Authentication_Validation', 'Resetting'),
        {
          success: function (authToken) {
            NX.direct.usertoken_UserToken.resetCurrent(authToken, function (response) {
              if (Ext.isDefined(response) && response.success) {
                NX.Messages.add({ text: NX.I18n.get('UserToken_Reset_Success'), type: 'success' });
              }
            });
          }
        }
    );
  },

  /**
   * @private
   */
  reset: function (button) {
    var form = button.up('form'),
        userModel = form.getRecord();
    NX.Security.doWithAuthenticationToken(
      NX.I18n.format('UserToken_Authentication_Validation', 'Resetting'),
        {
          success: function (authToken) {
            NX.direct.usertoken_UserToken.reset(authToken, userModel.get('userId'), function (response) {
              var errorMessage = '';
              if (Ext.isDefined(response) && response.success) {
                NX.Messages.add({
                  text: NX.I18n.format('UserToken_ResetById_Message', userModel.get('userId')),
                  type: 'success'
                });
              }
              else if (Ext.isDefined(response.errors)) {
                Object.keys(response.errors).forEach(function(key) {
                  errorMessage += key + ' ' + response.errors[key] + ". ";
                });
                NX.Messages.warning(errorMessage);
              }
            });
          }
        }
    );
  }

});

/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Manages health check information (security and license alerts) shown in component details view.
 *
 * @since 3.0
 */
Ext.define('NX.proui.controller.HealthCheckInfo', {
  extend: 'NX.app.Controller',
  requires: [
    'NX.Conditions',
    'NX.Permissions',
    'NX.State',
    'NX.util.Url',
    'NX.I18n',
    'NX.coreui.util.HealthCheckUtil'
  ],

  /**
   * @override
   */
  init: function() {
    var me = this;

    me.listen({
      component: {
        'nx-coreui-component-details': {
          healthCheckLoaded: me.renderHealthCheckFields
        },
        'nx-coreui-component-componentinfo': {
          healthCheckLoaded: me.renderComponentInfoHealthCheckFields
        },
        'nx-coreui-component-componentassetinfo': {
          healthCheckLoaded: me.renderComponentInfoHealthCheckFields
        }
      }
    });
  },

  /**
   * Render healthcheck fields.
   *
   * @private
   * @param {Ext.Panel} panel containing health check info section
   * @param {NX.coreui.model.Component} model component model
   */
  renderHealthCheckFields: function(panel, model) {
    var me = this,
        infoPanel,
        info = {};

    if (model) {
      infoPanel = panel.down('#healthCheckInfoPro');
      if (!infoPanel) {
        infoPanel = panel.add({
          xtype: 'nx-info',
          itemId: 'healthCheckInfoPro'
        });
      }
      info[NX.I18n.get('HealthCheckInfo_Security_Alerts_Label')] = me.renderSecurityAlerts(model);
      info[NX.I18n.get('HealthCheckInfo_License_Threat_Label')] = me.renderLicenseThreat(model);
      infoPanel.showInfo(info);
    }
  },

  /**
   * Render healthcheck fields.
   *
   * @private
   * @param {Ext.Panel} panel containing health check info section
   * @param {NX.coreui.model.Component} model component model
   */
  renderComponentInfoHealthCheckFields: function(panel, model) {
    var me = this;

    if (model) {
      panel.setInfo('healthCheckInfoPro', NX.I18n.get('HealthCheckInfo_Security_Alerts_Label'), me.renderSecurityAlerts(model));
      panel.setInfo('healthCheckInfoPro', NX.I18n.get('HealthCheckInfo_License_Threat_Label'), me.renderLicenseThreat(model));
      panel.showInfo();
    }
  },

  /**
   * Render security alerts column.
   *
   * @private
   * @param {NX.coreui.model.Component} model component model
   * @returns {String} rendered value
   */
  renderSecurityAlerts: function(model) {
    var me = this,
        metadata = {},
        result, securityAlerts, critical, severe, moderate,
        buildChiclet = function(clazz, value) {
          return '<span class="nx-clm-chiclet-small ' + clazz + '">' + value + '</span>';
        };

    result = me.renderPreconditions(model, metadata);
    if (!result) {
      securityAlerts = model.get('healthCheckSecurityAlerts');
      critical = model.get('healthCheckCriticalSecurityAlerts');
      severe = model.get('healthCheckSevereSecurityAlerts');
      moderate = model.get('healthCheckModerateSecurityAlerts');
      if (securityAlerts === 0 || securityAlerts > 0) {
        result = buildChiclet(critical > 0 ? 'critical' : '', critical > 0 ? critical : '')
            + buildChiclet(severe > 0 ? 'severe' : '', severe > 0 ? severe : '')
            + buildChiclet(moderate > 0 ? 'moderate' : '', moderate > 0 ? moderate : '');
      }
      if (!Ext.isDefined(result)) {
        result = me.renderNotAvailable(metadata);
      }
    }
    return '<div ' + (metadata.attr || '') + '>' + result + '</div>';
  },

  /**
   * Render license threat column.
   *
   * @private
   * @param {NX.coreui.model.Component} model component model
   * @returns {String} rendered value
   */
  renderLicenseThreat: function(model) {
    var me = this,
        metadata = {},
        result, licenseThreat, licenseThreatName, barClass = '';

    result = me.renderPreconditions(model, metadata);
    if (!result) {
      licenseThreat = model.get('healthCheckLicenseThreat');
      licenseThreatName = model.get('healthCheckLicenseThreatName');
      if (licenseThreat === 0 || licenseThreat > 0) {
        if (licenseThreat === 4) {
          barClass = 'critical';
        }
        else if (licenseThreat === 2) {
          barClass = 'moderate';
        }
        else if (licenseThreat === 1) {
          barClass = 'none';
        }
        else {
          barClass = 'severe';
        }
        return '<span class="nx-clm-chiclet-small ' + barClass + '" style="width: auto; padding: 1px 2px; font-size: inherit;">' + licenseThreatName + '</span>';
      }
      if (!Ext.isDefined(result)) {
        result = me.renderNotAvailable(metadata);
      }
    }
    return '<div ' + (metadata.attr || '') + '>' + result + '</div>';
  },

  /**
   * Render value based on preconditions.
   *
   * @private
   * @param {NX.coreui.model.Component} model component model
   * @param metadata column metadata
   * @returns {*} rendered value
   */
  renderPreconditions: function(model, metadata) {
    var edition = NX.State.getEdition(),
        util = NX.coreui.util.HealthCheckUtil;

    if ('EVAL' === edition || 'OSS' === edition) {
      metadata.attr = 'data-qtip="' + NX.I18n.get('HealthCheckInfo_Tooltip') + '"';
      return util.iconSpan('fa-lock', 'opacity: 0.33;');
    }
    else if (!NX.State.getUser()) {
      metadata.attr = 'data-qtip="' + NX.I18n.get('HealthCheckInfo_LoggedInOnly_Tooltip') + '"';
      return util.iconSpan('fa-lock', 'opacity: 0.33;');
    }
    else if (!NX.Permissions.check('nexus:healthcheckalerts:update')) {
      metadata.attr = 'data-qtip="' + NX.I18n.get('HealthCheckInfo_NoPermission_Tooltip') + '"';
      return util.iconSpan('fa-lock', 'opacity: 0.33;');
    }
    else if (model.get('healthCheckLoading')) {
      return NX.I18n.get('HealthCheckInfo_Loading_Text');
    }
    else if (model.get('healthCheckDisabled')) {
      metadata.attr = 'data-qtip="' + NX.I18n.get('HealthCheckInfo_Disabled_Tooltip') + '"';
      return util.iconSpan('fa-info-circle', 'opacity: 0.33;');
    }
    else if (model.get('healthCheckError')) {
      metadata.attr = 'data-qtip="' + NX.I18n.get('HealthCheckInfo_Error_Tooltip') + '"';
      return util.iconSpan('fa-exclamation-triangle', 'color: red;');
    }
    else if (model.get('healthCheckCapped')
        || (model && model.get('cappedAlerts'))) {
      metadata.attr = 'data-qtip="' + NX.I18n.get('HealthCheckInfo_Quota_Tooltip') + '"';
      return util.iconSpan('fa-exclamation-triangle', 'color: yellow;');
    }
    return undefined;
  },

  /**
   * Render a not available value (no data).
   *
   * @private
   * @param metadata column metadata
   * @returns {String} rendered value
   */
  renderNotAvailable: function(metadata) {
    metadata.attr = 'data-qtip="' + NX.I18n.get('HealthCheckInfo_Unavailable_Tooltip') + '"';
    return NX.coreui.util.HealthCheckUtil.iconSpan('fa-ban', 'opacity: 0.33;');
  }

});

/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Registers all feature groups for proui.
 *
 * @since 3.0
 */
Ext.define('NX.proui.controller.FeatureGroups', {
  extend: 'NX.app.Controller',
  requires: [
    'NX.I18n'
  ],

  /**
   * @override
   */
  init: function () {
    this.getApplication().getFeaturesController().registerFeature([
      {
        mode: 'admin',
        path: '/IQ',
        text: 'IQ Server',
        description: 'IQ Server integration',
        group: true,
        weight: 70,
        iconConfig: {
          file: 'three_tags.png',
          variants: ['x16', 'x32']
        }
      }
    ]);
  }

});

/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Health Check Asset details controller.
 *
 * Shows healthcheck details when asset details are shown.
 *
 * @since 3.0
 */
Ext.define('NX.proui.controller.HealthCheckAssetDetail', {
  extend: 'NX.app.Controller',
  requires: [
    'NX.Permissions',
    'NX.State'
  ],

  views: [
    'healthcheck.HealthCheckAssetDetail'
  ],

  /**
   * @override
   */
  init: function() {
    var me = this;

    me.listen({
      component: {
        'nx-coreui-component-assetcontainer': {
          updated: me.onAssetContainerUpdated
        },
        'nx-coreui-component-componentassetinfo': {
          updated: me.onComponentAssetInfoUpdated
        }
      }
    });
  },

  /**
   * Shows Health Check information about selected asset if user is logged in, has "nexus:healthcheckalerts:update" and
   * we have a PRO edition.
   *
   * @private
   * @param {NX.coreui.view.component.AssetContainer} container asset container
   * @param {NX.coreui.model.Asset} assetModel selected asset
   */
  onAssetContainerUpdated: function(container, assetModel) {
    var panel = container.down('nx-proui-healthcheck-healthcheckassetdetail');

    if (this.isHealthCheckEnabled()) {
      if (!panel) {
        container.addTab(
            {
              xtype: 'nx-proui-healthcheck-healthcheckassetdetail',
              title: NX.I18n.get('Component_AssetInfo_HealthCheck_Title'),
              itemId: 'healthCheckInfo',
              weight: 50
            }
        );
        panel = container.down('nx-proui-healthcheck-healthcheckassetdetail');
      }

      panel.showInfo(assetModel);
    }
    else if (panel) {
      container.remove(panel);
    }
  },

  onComponentAssetInfoUpdated: function(container, asset) {
    var panel = container.down('nx-proui-healthcheck-healthcheckassetdetail');
    if (this.isHealthCheckEnabled()) {
      if (!panel) {
        panel = container.add(
          {
            xtype: 'nx-proui-healthcheck-healthcheckassetdetail',
            title: NX.I18n.get('Component_AssetInfo_HealthCheck_Title'),
            itemId: 'healthCheckInfo',
            weight: 30,
            collapsible: true
          }
        );
      }

      panel.showInfo(asset);
    } else if (panel) {
      container.remove(panel);
    }
  },

  isHealthCheckEnabled: function() {
    var edition = NX.State.getEdition();
    return NX.State.getUser() &&
           NX.Permissions.check('nexus:healthcheckalerts:read') &&
           !('EVAL' === edition || 'OSS' === edition);
  }

});

/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Database Quorum Reset controller.
 *
 * @since 3.4
 */
Ext.define('NX.proui.controller.DatabaseQuorumReset', {
  extend: 'NX.app.Controller',
  requires: [
    'NX.Permissions',
    'NX.Messages',
    'NX.I18n'
  ],
  views: [
    'database.DatabaseQuorumResetConfirm'
  ],

  /**
   * @override
   */
  init: function () {
    var me = this;

    me.getApplication().getFeaturesController().registerFeature({
      mode: 'admin',
      path: '/System/Nodes/Cluster Reset',
      text: NX.I18n.get('DatabaseQuorumReset_Title'),
      description: NX.I18n.get('DatabaseQuorumReset_Description'),
      view: { xtype: 'nx-proui-database-quorum-reset' },
      visible: function () {
        return NX.Permissions.check('nexus:settings:update') && !NX.State.getValue('quorum', {})['quorumPresent'];
      }
    }, me);

    me.listen({
      component: {
        'nx-proui-database-quorum-reset button[action=resetQuorum]': {
          'click': me.resetQuorum
        }
      }
    });

    me.myNodeId = null;
    NX.direct.node_NodeAccess.nodes(function(response, event){
      if (Ext.isObject(response) && response.success) {
        response.data.forEach(function(nodeXO) {
          if (nodeXO.local) {
            me.myNodeId = nodeXO.name;
          }
        });
      }
      else if (event.xhr.status !== 0) {
        NX.Messages.add({ text: NX.I18n.get('DatabaseQuorumResetConfirm_GetLocalNode_Fail'), type: 'warning' });
      }
    });
  },

  /**
   *
   * @private
   */
  resetQuorum: function () {
    var me = this;

    if (me.myNodeId == null) {
      NX.Messages.add({ text: NX.I18n.get('DatabaseQuorumResetConfirm_LocalNodeNotKnown'), type: 'warning' });
    }
    else {
      NX.Dialogs.askConfirmation(NX.I18n.get('DatabaseQuorumResetConfirm_Title'),
          NX.I18n.format('DatabaseQuorumResetConfirm_HelpText'), function() {
            NX.direct.proui_Database.resetQuorum(me.myNodeId, function(response){
              if (Ext.isObject(response) && response.success) {
                NX.Messages.add({ text: NX.I18n.get('DatabaseQuorumResetConfirm_Success'), type: 'success' });
                NX.Bookmarks.navigateTo(NX.Bookmarks.fromToken('admin/system/nodes'));
              }
              else {
                NX.Messages.add({ text: NX.I18n.get('DatabaseQuorumResetConfirm_Fail'), type: 'warning' });
              }
            });
          }, {
            scope: me,
            buttonText: {
              yes: NX.I18n.get('DatabaseQuorumResetConfirm_Yes'),
              no: NX.I18n.get('DatabaseQuorumResetConfirm_No')
            }
          });
    }
  }
});

