/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Header panel.
 *
 * @since 3.0
 */
Ext.define('NX.view.header.Panel', {
  extend: 'Ext.container.Container',
  alias: 'widget.nx-header-panel',
  requires: [
    'NX.I18n',
    'NX.State'
  ],

  cls: 'nx-header-panel',

  layout: {
    type: 'vbox',
    align: 'stretch',
    pack: 'start'
  },

  ariaRole: 'banner',

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    me.items = [
      { xtype: 'nx-header-branding', hidden: true },
      {
        xtype: 'toolbar',

        // set height to ensure we have uniform size and not depend on what is in the toolbar
        height: 50,

        anchor: '100%',

        defaults: {
          scale: 'medium'
        },

        items: [
          { xtype: 'nx-header-logo' },
          {
            xtype: 'container',
            layout: {
              type: 'vbox',
              pack: 'center'
            },
            items: [
              {
                xtype: 'label',
                cls: 'productname',
                text: NX.I18n.get('Header_Panel_Logo_Text')
              },
              {
                xtype: 'label',
                cls: 'productspec',
                text: NX.State.getBrandedEditionAndVersion()
              }
            ]
          }
        ]
      }
    ];

    me.callParent();
  }
});
