/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * @since 3.15
 */
Ext.define('NX.rubygems.controller.RubygemsDependencySnippetController', {
  extend: 'NX.app.Controller',

  /**
   * @override
   */
  init: function() {
    NX.getApplication().getDependencySnippetController()
        .addDependencySnippetGenerator('rubygems', this.snippetGenerator);
  },

  snippetGenerator: function(componentModel, assetModel) {
    var name = componentModel.get('name'),
        version = componentModel.get('version');

    return [
      {
        displayName: 'Install',
        snippetText: 'gem install ' + name + ' -v ' + version
      }, {
        displayName: 'Gemfile',
        snippetText: 'gem \'' + name + '\', \'~> ' + version + '\''
      }
    ];
  }
});
