/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Ssl Certificate grid.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.ssl.SslCertificateList', {
  extend: 'NX.view.drilldown.Master',
  alias: 'widget.nx-coreui-sslcertificate-list',
  requires: [
    'NX.Icons',
    'NX.I18n'
  ],

  stateful: true,
  stateId: 'nx-coreui-sslcertificate-list',

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    me.store = 'SslCertificate';

    me.columns = [
      {
        xtype: 'nx-iconcolumn',
        width: 36,
        iconVariant: 'x16',
        iconName: function () {
          return 'sslcertificate-default';
        }
      },
      {
        header: NX.I18n.get('Ssl_SslCertificateList_Name_Header'),
        dataIndex: 'subjectCommonName',
        stateId: 'subjectCommonName',
        flex: 1,
        renderer: Ext.htmlEncode
      },
      {
        header: NX.I18n.get('Ssl_SslCertificateList_IssuedTo_Header'),
        dataIndex: 'subjectOrganization',
        stateId: 'subjectOrganization',
        flex: 1,
        renderer: Ext.htmlEncode
      },
      {
        header: NX.I18n.get('Ssl_SslCertificateList_IssuedBy_Header'),
        dataIndex: 'issuerOrganization',
        stateId: 'issuerOrganization',
        flex: 1,
        renderer: Ext.htmlEncode
      },
      {
        header: NX.I18n.get('Ssl_SslCertificateList_Fingerprint_Header'),
        dataIndex: 'fingerprint',
        stateId: 'fingerprint',
        flex: 1,
        renderer: Ext.htmlEncode
      }
    ];

    me.viewConfig = {
      emptyText: NX.I18n.get('Ssl_SslCertificateList_EmptyText'),
      deferEmptyText: false
    };

    me.plugins = [
      { ptype: 'gridfilterbox', emptyText: NX.I18n.get('Ssl_SslCertificateList_Filter_EmptyText') }
    ];

    me.dockedItems = [{
      xtype: 'nx-actions',
      items: [
        {
          xtype: 'button',
          text: NX.I18n.get('Ssl_SslCertificateList_New_Button'),
          glyph: 'xf055@FontAwesome' /* fa-plus-circle */,
          action: 'new',
          disabled: true,
          menu: [
            {
              text: NX.I18n.get('Ssl_SslCertificateList_Load_Button'),
              action: 'newfromserver',
              iconCls: NX.Icons.cls('sslcertificate-add-by-server', 'x16')
            },
            {
              text: NX.I18n.get('Ssl_SslCertificateList_Paste_Button'),
              action: 'newfrompem',
              iconCls: NX.Icons.cls('sslcertificate-add-by-pem', 'x16')
            }
          ]
        }
      ]
    }];

    me.callParent();
  }
});
