/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * CoreUi plugin strings.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.app.PluginStrings', {
  '@aggregate_priority': 90,

  singleton: true,
  requires: [
    'NX.I18n'
  ],

  /**
   * String keys.
   *
   * Keys follow the following naming convention:
   *
   * Class_Name>_[Component_or_Attribute]: string
   *
   * @type {Object}
   */
  keys: {
    // Browse -> Browse
    Assets_Info_Repository: 'Repository',
    Assets_Info_Format: 'Format',
    Assets_Info_Group: 'Component Group',
    Assets_Info_Name: 'Component Name',
    Assets_Info_Version: 'Component Version',
    Assets_Info_Path: 'Path',
    Assets_Info_ContentType: 'Content type',
    Assets_Info_FileSize: 'File size',
    Assets_Info_Last_Downloaded: 'Last downloaded',
    Assets_Info_No_Downloads: 'has not been downloaded',
    Assets_Info_Locally_Cached: 'Locally cached',
    Assets_Info_BlobRef: 'Blob reference',
    Assets_Info_Blob_Created: 'Blob created',
    Assets_Info_Blob_Updated: 'Blob updated',
    Assets_Info_ContainingRepositoryName: 'Containing repo',
    Assets_Info_Downloaded_Count: 'Last 30 days',
    Assets_Info_Downloaded_Unit: 'downloads',
    Assets_Info_UploadedBy: 'Uploader',
    Assets_Info_UploadedIp: 'Uploader\'s IP Address',
    AssetInfo_Delete_Button: 'Delete asset',
    AssetInfo_Delete_Title: 'Confirm deletion?',
    AssetInfo_Delete_Success: 'Asset deleted: {0}',
    FolderInfo_Delete_Button: 'Delete folder',
    FolderInfo_Delete_Title: 'Delete the entire folder?',
    FolderInfo_Delete_Text: 'All assets you have permission to delete under folder \'{0}\' will be removed. The view will not automatically refresh to show progress. This operation cannot be undone.',
    FolderInfo_Delete_Success: 'The folder is now being deleted in the background',
    Component_Asset_Tree_Title_Feature: 'Tree',
    Component_Asset_Tree_Description_Feature: 'View tree layout of components and assets',
    Component_Asset_Tree_EmptyText_View: 'No component/assets found in repository',
    Component_Asset_Tree_Expand_Failure: 'Unable to show requested tree entry',
    Component_Asset_Tree_Filtered_EmptyText_View: 'All components have been filtered out, try using <a href="#browse/search">search</a> instead?',
    Component_Asset_Tree_Results_Warning: 'There may be additional results, try filtering the results or searching if you cannot find what you\'re looking for.',
    Component_Asset_Tree_Html_View: 'HTML View',
    Component_Asset_Tree_Upload_Component: 'Upload component',

    ComponentDetails_Delete_Button: 'Delete component',
    ComponentDetails_Analyze_Button: 'Analyze application',
    ComponentDetails_Browse_Snapshots_Button: 'Browse SNAPSHOT(s)',
    ComponentDetails_Delete_Body: 'This will delete all asset(s) associated with the component: {0}',
    ComponentDetails_Delete_Title: 'Confirm deletion?',
    ComponentDetails_Delete_Success: 'Component deleted: {0}',
    ComponentDetails_Analyze_Success: 'Analysis in process. Email will be sent when report is ready.',
    ComponentDetails_Loading_Mask: 'Loading...',
    ComponentDetails_Rebuild_Warning: 'Browse tree is being rebuilt; results may not be complete until the rebuild is finished.',

    ComponentUtils_Delete_Button_Unauthenticated: 'Please sign in first',
    ComponentUtils_Delete_Asset_No_Permissions: 'You do not have permission to delete this asset',
    ComponentUtils_Delete_Component_No_Permissions: 'You do not have permission to delete this component',

    AnalyzeApplication_Button_Unauthenticated: 'Please sign in first',

    AnalyzeApplicationWindow_Title: 'Analyze Application',
    AnalyzeApplicationWindow_Form_Asset_FieldLabel: 'Application asset',
    AnalyzeApplicationWindow_Form_Asset_HelpText: 'Select the asset that contains the application',
    AnalyzeApplicationWindow_Form_Asset_EmptyText: 'Select an asset',
    AnalyzeApplicationWindow_Form_Email_FieldLabel: 'Email address',
    AnalyzeApplicationWindow_Form_Email_HelpText: 'The address where the summary report will be sent',
    AnalyzeApplicationWindow_Form_Password_FieldLabel: 'Report password',
    AnalyzeApplicationWindow_Form_Password_HelpText: 'A password to gain access to the detailed report',
    AnalyzeApplicationWindow_Form_ProprietaryPackages_FieldLabel: 'Proprietary packages',
    AnalyzeApplicationWindow_Form_ProprietaryPackages_HelpText: 'A comma separated list of proprietary packages',
    AnalyzeApplicationWindow_Form_Label_FieldLabel: 'Report label',
    AnalyzeApplicationWindow_Form_Label_HelpText: 'The name the report will be given',
    AnalyzeApplicationWindow_Analyze_Button: 'Analyze',
    AnalyzeApplicationWindow_Cancel_Button: 'Cancel',
    AnalyzeApplicationWindow_Form_Html: '<p>Application analysis performs a deep inspection of this application, ' +
    'identifying potential risks.  More information is available ' +
    '<a href="http://links.sonatype.com/products/insight/ac/home" target="_blank" class="x-link">here</a>.</p>',
    AnalyzeApplicationWindow_Loading_Mask: 'Loading',
    AnalyzeApplicationWindow_No_Assets_Error_Title: 'Component has no application assets',
    AnalyzeApplicationWindow_No_Assets_Error_Message: 'This component has no application assets or you do not have read permission for any of it\'s application assets',

    HealthCheckInfo_Most_Popular_Version_Label: 'Most popular version',
    HealthCheckInfo_Age_Label: 'Age',
    HealthCheckInfo_Popularity_Label: 'Popularity',
    HealthCheckInfo_Loading_Text: 'Loading...',
    HealthCheckInfo_Disabled_Tooltip: 'The age and popularity data is only available once Repository Health Check (RHC) has been enabled.',
    HealthCheckInfo_Error_Tooltip: 'Error retrieving component data',
    HealthCheckInfo_Quota_Tooltip: 'The query limit for age and popularity data has been reached. Contact Sonatype support to extend current quota limits.',
    HealthCheckInfo_Unavailable_Tooltip: 'No data available for this component',

    // Browse -> Search
    Search_Text: 'Search',
    Search_Description: 'Search for components by attribute',
    Search_SaveSearchFilter_Title: 'Save search filter',
    Search_SaveSearchFilter_Name_FieldLabel: 'Filter name',
    Search_SaveSearchFilter_Description_FieldLabel: 'Filter description',
    Search_Results_Limit_Message: 'Only showing the first {0} of {1} results',
    SearchCriteria_Keyword_FieldLabel: 'Keyword',
    SearchCriteria_RepositoryName_FieldLabel: 'Repository Name',
    SearchCriteria_Name_FieldLabel: 'Name',
    SearchCriteria_Tag_FieldLabel: 'Tag',
    SearchCriteria_Format_FieldLabel: 'Format',
    SearchCriteria_Group_FieldLabel: 'Group',
    SearchCriteria_Checksum_Group: 'Checksum',
    SearchDocker_Group: 'Docker Repositories',
    SearchMaven_Group: 'Maven Repositories',
    SearchNpm_Group: 'npm Repositories',
    SearchNuget_Group: 'NuGet Repositories',
    SearchPyPi_Group: 'PyPI Repositories',
    SearchRubygems_Group: 'RubyGems Repositories',
    SearchGitLfs_Group: 'Git LFS Repositories',
    SearchYum_Group: 'Yum Repositories',
    SearchCriteria_MD5_FieldLabel: 'MD5',
    SearchCriteria_SHA1_FieldLabel: 'SHA-1',
    SearchCriteria_SHA256_FieldLabel: 'SHA-256',
    SearchCriteria_SHA2_FieldLabel: 'SHA-512',
    SearchCriteria_Version_FieldLabel: 'Version',
    Search_TextSearchCriteria_Filter_EmptyText: 'Any',
    SearchDocker_Image_Name_FieldLabel: 'Image Name',
    SearchDocker_Image_Tag_FieldLabel: 'Image Tag',
    SearchDocker_LayerId_FieldLabel: 'Layer Id',
    SearchDocker_ContentDigest_FieldLabel: 'Content Digest',
    SearchMaven_ArtifactID_FieldLabel: 'Artifact Id',
    SearchMaven_BaseVersion_FieldLabel: 'Base Version',
    SearchMaven_Extension_FieldLabel: 'Extension',
    SearchMaven_GroupID_FieldLabel: 'Group Id',
    SearchMaven_Classifier_FieldLabel: 'Classifier',
    SearchMaven_Version_FieldLabel: 'Version',
    SearchNpm_Scope_FieldLabel: 'Scope',
    SearchNpm_Name_FieldLabel: 'Name',
    SearchNpm_Version_FieldLabel: 'Version',
    SearchNpm_Author_FieldLabel: 'Author',
    SearchNpm_Description_FieldLabel: 'Description',
    SearchNpm_Keywords_FieldLabel: 'Keywords',
    SearchNpm_License_FieldLabel: 'License',
    SearchNuget_ID_FieldLabel: 'ID',
    SearchNuget_Tags_FieldLabel: 'Tags',
    SearchPyPi_Classifiers_FieldLabel: 'Classifiers',
    SearchPyPi_Description_FieldLabel: 'Description',
    SearchPyPi_Keywords_FieldLabel: 'PyPI Keywords',
    SearchPyPi_Summary_FieldLabel: 'Summary',
    SearchRubygems_Name_FieldLabel: 'Name',
    SearchRubygems_Version_FieldLabel: 'Version',
    SearchRubygems_Platform_FieldLabel: 'Platform',
    SearchRubygems_Summary_FieldLabel: 'Summary',
    SearchRubygems_Description_FieldLabel: 'Description',
    SearchRubygems_Licenses_FieldLabel: 'Licenses',
    SearchRubygems_Homepage_FieldLabel: 'Homepage',
    SearchYum_Architecture_FieldLabel: 'Architecture',
    SearchYum_Name_FieldLabel: 'Package Name',
    Search_More_Text: 'More criteria',
    Search_SearchResultList_Format_Header: 'Format',
    Search_SearchResultList_Group_Header: 'Group',
    Search_SearchResultList_Name_Header: 'Name',
    Search_SearchResultList_Repository_Header: 'Repository',
    Search_SearchResultList_Version_Header: 'Version',
    Search_SearchResultList_EmptyText: 'No components matched the filter criteria',
    Search_Assets_Group: 'Group',
    Search_Assets_Name: 'Name',
    Search_Assets_Format: 'Format',
    Search_Assets_Repository: 'Repository',
    Search_Assets_Version: 'Version',
    SearchResultAssetList_Name_Header: 'Name',
    Component_AssetInfo_Info_Title: 'Summary',
    Component_AssetInfo_Attributes_Title: 'Attributes',
    Component_AssetInfo_HealthCheck_Title: 'Component IQ',

    // Browse -> Search -> Bower
    SearchBower_Text: 'Bower',
    SearchBower_Description: 'Search for components in Bower repositories',

    // Browse -> Search -> Docker
    SearchDocker_Text: 'Docker',
    SearchDocker_Description: 'Search for components in Docker repositories',

    // Browse -> Search -> Raw
    SearchRaw_Text: 'Raw',
    SearchRaw_Description: 'Search for components in Raw repositories',

    // Browse -> Search -> Git LFS
    SearchGitLfs_Text: 'Git LFS',
    SearchGitLfs_Description: 'Search for components in Git LFS repositories',

    // Browse -> Search -> npm
    SearchNpm_Text: 'npm',
    SearchNpm_Description: 'Search for components in npm repositories',

    // Browse -> Search -> Nuget
    SearchNuget_Text: 'NuGet',
    SearchNuget_Description: 'Search for components in NuGet repositories',

    // Browse -> Search -> PyPI
    SearchPyPi_Text: 'PyPI',
    SearchPyPi_Description: 'Search for components in PyPI repositories',

    // Browse -> Search -> Rubygems
    SearchRubygems_Text: 'RubyGems',
    SearchRubygems_Description: 'Search for components in RubyGems repositories',

    // Browse -> Search -> Custom
    Search_Custom_Text: 'Custom',
    Search_Custom_Description: 'Search for components by custom criteria',

    // Browse -> Search -> Maven
    SearchMaven_Text: 'Maven',
    SearchMaven_Description: 'Search for components by Maven coordinates',

    // Browse -> Search -> Yum
    SearchYum_Text: 'Yum',
    SearchYum_Description: 'Search for components in Yum repositories',

    // Browse -> Browse
    FeatureGroups_Browse_Text: 'Browse',
    FeatureGroups_Browse_Description: 'Browse assets and components',

    // Browse -> Upload
    FeatureGroups_Upload_Text: 'Upload',
    FeatureGroups_Upload_Description: 'Upload content to the repository',
    FeatureGroups_Upload_Wait_Message: 'Uploading your components...',
    FeatureGroups_Upload_Successful: 'Components uploaded successfully',
    FeatureGroups_Upload_Successful_Link_Text: 'view it now.',
    FeatureGroups_Upload_Successful_Text: 'Component uploaded to the {0} repository',
    FeatureGroups_Upload_Asset_Form_Title: 'Choose assets for this component',
    FeatureGroups_Upload_Asset_Form_File_Label: 'File',
    FeatureGroups_Upload_Asset_Form_Remove_Button: 'Remove',
    FeatureGroups_Upload_Asset_Form_Add_Asset_Button: 'Add another asset',
    FeatureGroups_Upload_Asset_Form_Not_Unique_Error_Message: 'Asset not unique',
    FeatureGroups_Upload_Form_Upload_Button: 'Upload',
    FeatureGroups_Upload_Form_Discard_Button: 'Cancel',
    FeatureGroups_Upload_Form_Browse_Button: 'Browse',
    FeatureGroups_Upload_Form_DetailsFromPom_Mask: 'Component details will be extracted from the provided POM file.',

    // Admin -> Repository
    FeatureGroups_Repository_Text: 'Repository',
    FeatureGroups_Repository_Description: 'Repository administration',

    // Admin -> Repository -> Repositories
    Repositories_Text: 'Repositories',
    Repositories_Description: 'Manage repositories',
    Repositories_Delete_Mask: 'Deleting repository',
    Repositories_Create_Title: 'Create Repository: {0}',
    Repositories_SelectRecipe_Title: 'Select Recipe',
    Repository_RepositoryAdd_Create_Success: 'Repository created: ',
    Repository_RepositoryAdd_Create_Error: 'You do not have permission to create repositories',
    Repository_RepositorySettingsForm_Update_Success: 'Repository updated: ',
    Repository_RepositorySettingsForm_Update_Error: 'You do not have permission to update repositories',
    Repository_RepositoryList_New_Button: 'Create repository',
    Repository_RepositoryList_Name_Header: 'Name',
    Repository_RepositoryList_Type_Header: 'Type',
    Repository_RepositoryList_Format_Header: 'Format',
    Repository_RepositoryList_Status_Header: 'Status',
    Repository_RepositoryList_URL_Header: 'URL',
    Repository_RepositoryList_Filter_EmptyText: 'No repositories matched "$filter"',
    Repository_RepositoryList_EmptyText: 'No repositories defined',
    Repository_RepositoryFeature_Delete_Button: 'Delete repository',
    Repository_RepositoryFeature_RebuildIndex_Button: 'Rebuild index',
    Repository_RepositoryFeature_HealthCheckDisable_Button: 'Disable HealthCheck',
    Repository_RepositoryFeature_HealthCheckEnable_Button: 'Enable HealthCheck',
    Repository_RepositoryFeature_InvalidateCache_Button: 'Invalidate cache',
    Repository_RepositorySettings_Title: 'Settings',
    Repository_Facet_BowerProxyFacet_Title: 'Bower',
    Repository_Facet_BowerProxyFacet_RewritePackageUrls_FieldLabel: 'Enable rewrite of package URLs',
    Repository_Facet_BowerProxyFacet_RewritePackageUrls_HelpText: 'Force Bower to retrieve packages through the proxy repository',
    Repository_Facet_DockerHostedFacet_V1_Title: 'Docker Registry API Support',
    Repository_Facet_DockerHostedFacet_V1_Enabled: 'Enable Docker V1 API',
    Repository_Facet_DockerHostedFacet_V1_Enabled_Help: 'Allow clients to use the V1 API to interact with this Repository',
    Repository_Facet_DockerConnectorFacet_Title: 'Repository Connectors',
    Repository_Facet_DockerConnectorFacet_Help: '<em>Connectors allow Docker clients to connect directly ' +
    'to hosted registries, but are not always required. Consult our <a href="https://help.sonatype.com/repomanager3/private-registry-for-docker/ssl-and-repository-connector-configuration" target="_blank">documentation</a>' +
    ' for which connector is appropriate for your use case. For information on scaling the repositories' +
    ' see our <a href="https://help.sonatype.com/repomanager3/private-registry-for-docker/scaling-repositories" target="_blank">scaling documentation</a>.</em>',
    Repository_Facet_DockerConnectorFacet_HttpPort_FieldLabel: 'HTTP',
    Repository_Facet_DockerConnectorFacet_HttpPort_HelpText: 'Create an HTTP connector at specified port. Normally used if the server is behind a secure proxy.',
    Repository_Facet_DockerConnectorFacet_HttpsPort_FieldLabel: 'HTTPS',
    Repository_Facet_DockerConnectorFacet_HttpsPort_HelpText: 'Create an HTTPS connector at specified port. Normally used if the server is configured for https.',
    Repository_Facet_DockerProxyFacet_IndexType_FieldLabel: 'Docker Index',
    Repository_Facet_DockerProxyFacet_IndexTypeRegistry_BoxLabel: 'Use proxy registry (specified above)',
    Repository_Facet_DockerProxyFacet_IndexTypeHub_BoxLabel: 'Use Docker Hub',
    Repository_Facet_DockerProxyFacet_IndexTypeCustom_BoxLabel: 'Custom index',
    Repository_Facet_DockerProxyFacet_IndexUrl_HelpText: 'Location of Docker index',
    Repository_Facet_DockerProxyFacet_BasicAuth_FieldLabel: 'Allow anonymous docker pull',
    Repository_Facet_DockerProxyFacet_BasicAuth_BoxLabel: 'Allow anonymous docker pull ( Docker Bearer Token Realm required )',
    Repository_Facet_YumHostedFacet_Title: 'Yum',
    Repository_Facet_YumHostedFacet_RepodataDepth_FieldLabel: 'Repodata Depth',
    Repository_Facet_YumHostedFacet_RepodataDepth_HelpText: 'Specifies the repository depth where repodata folder(s) are created',
    Repository_Facet_YumHostedFacet_DeployPolicy_FieldLabel: 'Deploy Policy',
    Repository_Facet_YumHostedFacet_DeployPolicy_HelpText: 'Validate that all paths are RPMs or yum metadata',
    Repository_Facet_YumHostedFacet_DeployPolicy_EmptyText: 'Select a policy',
    Repository_Facet_YumHostedFacet_DeployPolicy_StrictItem: 'Strict',
    Repository_Facet_YumHostedFacet_DeployPolicy_PermissiveItem: 'Permissive',
    Repository_Facet_GroupFacet_Title: 'Group',
    Repository_Facet_HttpClientFacet_Title: 'HTTP',
    Repository_Facet_Maven2Facet_Title: 'Maven 2',
    Repository_Facet_NegativeCacheFacet_Title: 'Negative Cache',
    Repository_Facet_NugetProxyFacet_Title: 'NuGet',
    Repository_Facet_ProxyFacet_Title: 'Proxy',
    Repository_Facet_StorageFacet_Title: 'Storage',
    Repository_Facet_StorageFacetHosted_Title: 'Hosted',
    Repository_Facet_ProxyFacet_Autoblock_FieldLabel: 'Auto blocking enabled',
    Repository_Facet_ProxyFacet_Autoblock_HelpText: 'Auto-block outbound connections on the repository if remote peer is detected as unreachable/unresponsive',
    Repository_Facet_ProxyFacet_Blocked_FieldLabel: 'Blocked',
    Repository_Facet_ProxyFacet_Blocked_HelpText: 'Block outbound connections on the repository',
    Repository_RepositorySettingsForm_Name_FieldLabel: 'Name',
    Repository_RepositorySettingsForm_Name_HelpText: 'A unique identifier for this repository',
    Repository_RepositorySettingsForm_URL_FieldLabel: 'URL',
    Repository_RepositorySettingsForm_URL_HelpText: 'The URL used to access this repository',
    Repository_Facet_GroupFacet_Members_FieldLabel: 'Member repositories',
    Repository_Facet_GroupFacet_Members_HelpText: 'Select and order the repositories that are part of this group',
    Repository_Facet_GroupFacet_Members_FromTitle: 'Available',
    Repository_Facet_GroupFacet_Members_ToTitle: 'Members',
    Repository_Facet_StorageFacetHosted_Deployment_FieldLabel: 'Deployment policy',
    Repository_Facet_StorageFacetHosted_Deployment_HelpText: 'Controls if deployments of and updates to artifacts are allowed',
    Repository_Facet_StorageFacetHosted_Deployment_EmptyText: 'Select a policy',
    Repository_Facet_StorageFacetHosted_Deployment_AllowItem: 'Allow redeploy',
    Repository_Facet_StorageFacetHosted_Deployment_DisableItem: 'Disable redeploy',
    Repository_Facet_StorageFacetHosted_Deployment_ReadOnlyItem: 'Read-only',
    Repository_Facet_ProxyFacet_Remote_FieldLabel: 'Remote storage',
    Repository_Facet_ProxyFacet_Remote_HelpText: 'Location of the remote repository being proxied',
    Repository_Facet_ProxyFacet_Remote_EmptyText: 'Enter a URL',
    Ssl_SslUseTrustStore_BoxLabel: 'Use the Nexus truststore',
    Ssl_SslUseTrustStore_Certificate_Button: 'View certificate',
    Ssl_SslUseTrustStore_Certificate_HelpText: 'Use certificates stored in the Nexus truststore to connect to external systems',
    Maven2Facet_VersionPolicy_FieldLabel: 'Version policy',
    Maven2Facet_VersionPolicy_HelpText: 'What type of artifacts does this repository store?',
    Maven2Facet_VersionPolicy_EmptyText: 'Select a policy',
    Maven2Facet_VersionPolicy_MixedItem: 'Mixed',
    Maven2Facet_VersionPolicy_ReleaseItem: 'Release',
    Maven2Facet_VersionPolicy_SnapshotItem: 'Snapshot',
    Repository_Facet_Maven2Facet_LayoutPolicy_FieldLabel: 'Layout policy',
    Repository_Facet_Maven2Facet_LayoutPolicy_HelpText: 'Validate that all paths are maven artifact or metadata paths',
    Repository_Facet_Maven2Facet_LayoutPolicy_EmptyText: 'Select a policy',
    Repository_Facet_Maven2Facet_LayoutPolicy_StrictItem: 'Strict',
    Repository_Facet_Maven2Facet_LayoutPolicy_PermissiveItem: 'Permissive',
    Repository_RepositorySettingsForm_Format_FieldLabel: 'Format',
    Repository_RepositorySettingsForm_Format_HelpText: 'The format of the repository (i.e. maven2, docker, raw, nuget...)',
    Repository_RepositorySettingsForm_Type_FieldLabel: 'Type',
    Repository_RepositorySettingsForm_Type_HelpText: 'The type of repository (i.e. group, hosted, or proxy)',
    Repository_RepositorySettingsForm_Online_FieldLabel: 'Online',
    Repository_RepositorySettingsForm_Online_HelpText: 'If checked, the repository accepts incoming requests',
    Repository_Facet_ProxyFacet_ArtifactAge_FieldLabel: 'Maximum component age',
    Repository_Facet_ProxyFacet_MetadataAge_FieldLabel: 'Maximum metadata age',
    Repository_Facet_ProxyFacet_ArtifactAge_HelpText: 'How long (in minutes) to cache artifacts before rechecking the remote repository. Release repositories should use -1.',
    Repository_Facet_ProxyFacet_MetadataAge_HelpText: 'How long (in minutes) to cache metadata before rechecking the remote repository.',
    Repository_Facet_HttpClientFacet_ConnectionRetries_FieldLabel: 'Connection retries',
    Repository_Facet_HttpClientFacet_ConnectionRetries_HelpText: 'Total retries if the initial connection attempt suffers a timeout',
    Repository_Facet_HttpClientFacet_ConnectionTimeout_FieldLabel: 'Connection timeout',
    Repository_Facet_HttpClientFacet_ConnectionTimeout_HelpText: 'Seconds to wait for activity before stopping and retrying the connection. Leave blank to use the globally defined HTTP timeout.',
    Repository_Facet_HttpClientFacet_EnableCircularRedirects_FieldLabel: 'Enable circular redirects',
    Repository_Facet_HttpClientFacet_EnableCircularRedirects_HelpText: 'Enable redirects to the same location (may be required by some servers)',
    Repository_Facet_HttpClientFacet_EnableCookies_FieldLabel: 'Enable cookies',
    Repository_Facet_HttpClientFacet_EnableCookies_HelpText: 'Allow cookies to be stored and used',
    Repository_Facet_StorageFacet_BlobStore_FieldLabel: 'Blob store',
    Repository_Facet_StorageFacet_BlobStore_HelpText: 'Blob store used to store asset contents',
    Repository_Facet_StorageFacet_BlobStore_EmptyText: 'Select a blob store',
    Repository_Facet_StorageFacet_ContentTypeValidation_FieldLabel: 'Strict Content Type Validation',
    Repository_Facet_StorageFacet_ContentTypeValidation_HelpText: 'Validate that all content uploaded to this repository is of a MIME type appropriate for the repository format',
    Repository_Facet_NegativeCacheFacet_Enabled_FieldLabel: 'Not found cache enabled',
    Repository_Facet_NegativeCacheFacet_Enabled_HelpText: 'Cache responses for content not present in the proxied repository',
    Repository_Facet_NegativeCacheFacet_TTL_FieldLabel: 'Not found cache TTL',
    Repository_Facet_NegativeCacheFacet_TTL_HelpText: 'How long to cache the fact that a file was not found in the repository (in minutes)',
    Repository_Facet_NugetProxyFacet_ItemMaxAge_FieldLabel: 'Metadata query cache age',
    Repository_Facet_NugetProxyFacet_ItemMaxAge_HelpText: 'How long to cache query results from the proxied repository (in seconds)',
    Repository_Facet_HttpClientFacet_AuthenticationType_FieldLabel: 'Authentication type',
    Repository_Facet_HttpClientFacet_AuthenticationType_Username: 'Username',
    Repository_Facet_HttpClientFacet_AuthenticationType_NTLM: 'Windows NTLM',
    Repository_Facet_HttpClientFacet_Authentication_Title: 'Authentication',
    Repository_Facet_HttpClientFacet_HTTP_Title: 'HTTP request settings',
    Repository_Facet_CleanupPolicyFacet_Title: 'Cleanup Policy',
    Repository_Facet_CleanupPolicyFacet_Policy_FieldLabel: 'Available cleanup policies',
    Repository_Facet_CleanupPolicyFacet_Policy_HelpText: 'Select a cleanup policy',
    Repository_Facet_CleanupPolicyFacet_Policy_EmptyText: 'None',
    Repository_Formats_All: '(All Formats)',

    HealthCheckRepositoryColumn_Header: 'Health check',
    HealthCheckRepositoryColumn_Analyzing: 'Analyzing&hellip;',
    HealthCheckRepositoryColumn_Analyzing_Tooltip: '<span><h2>The Analysis is Under Way</h2>' +
    'The contents of your repository are being analyzed. This process should only take a few minutes.<br><br>' +
    'When the analysis is complete and this page has been refreshed, we will show you the top 5 most vulnerable ' +
    'components in the repository, the number of downloads over the last month, and a year-over-year overview.</span>',
    HealthCheckRepositoryColumn_View_Permission_Error: '<span><h2>Insufficient Permissions to View Summary Report</h2>' +
    'To view healthcheck summary report for a repository your user account must have the necessary permissions.</span>',
    HealthCheckRepositoryColumn_Analyze: 'Analyze',
    HealthCheckRepositoryColumn_Analyze_Tooltip: '<span><h2>Repository Health Check Analysis</h2>Click this button to request a Repository Health Check (RHC) ' +
    'by IQ Server.  The process is non-invasive and non-disruptive. IQ Server ' +
    'will return actionable quality and security information about the open source components in the repository.' +
    '<br><br><a href="http://links.sonatype.com/products/clm/rhc/home" ' +
    'target="_blank">How the IQ Server Repository Health Check can help you make better software faster</a></span>',
    HealthCheckRepositoryColumn_Analyze_Dialog_Title: 'Analyze Repository',
    HealthCheckRepositoryColumn_Analyze_Dialog_Msg: 'Do you want to analyze the repository {0} and others for security vulnerabilities and license issues?',
    HealthCheckRepositoryColumn_Analyze_Dialog_Ok_Text: 'Yes, all repositories',
    HealthCheckRepositoryColumn_Analyze_Dialog_Yes_Text: 'Yes, only this repository',
    HealthCheckRepositoryColumn_Analyze_Permission_Error: '<span><h2>Insufficient Permissions to Analyze a Repository</h2>' +
    'To analyze a repository your user account must have permissions to start analysis.</span>',
    HealthCheckRepositoryColumn_Loading: 'Loading&hellip;',
    HealthCheckRepositoryColumn_CollectingTrendData: 'Insufficient trend data',
    HealthCheckRepositoryColumn_DownloadsDisabled: 'Download trends disabled',
    HealthCheckRepositoryColumn_Unavailable_Tooltip: '<span><h2>Repository Health Check Unavailable</h2>A Repository Health Check (RHC) ' +
    'cannot be performed on this repository, because it is an unsupported type or out of service.<br><br>' +
    '<a href="http://links.sonatype.com/products/clm/rhc/home" ' +
    'target="_blank">How the IQ Server Repository Health Check can help you make better software faster</a></span>',

    HealthCheckSummary_Help: '<a href="http://links.sonatype.com/products/nexus/rhc/manual-remediation-with-rhc" target="_blank">What should I do with this report?</a>',

    // Admin -> Repository -> Blob Stores
    Blobstores_Text: 'Blob Stores',
    Blobstores_Description: 'Manage blob stores',
    Blobstores_Delete_Mask: 'Deleting blob store',
    Blobstores_Update_Mask: 'Updating blob store',
    Blobstores_Create_Title: 'Create blob store',
    Blobstores_Update_Success: 'Blob store updated: {0}',
    Blobstore_BlobstoreAdd_Create_Success: 'Blob store created: ',
    Blobstore_BlobstoreAdd_Create_Error: 'You do not have permission to create blob stores',
    Blobstore_BlobstoreSettingsForm_Update_Success: 'Blob store updated: ',
    Blobstore_BlobstoreSettingsForm_Update_Error: 'Update is not supported for blob stores',
    Blobstore_BlobstoreList_New_Button: 'Create blob store',
    Blobstore_BlobstoreList_Name_Header: 'Name',
    Blobstore_BlobstoreList_Type_Header: 'Type',
    Blobstore_BlobstoreList_BlobCount_Header: 'Blob count',
    Blobstore_BlobstoreList_TotalSize_Header: 'Total size',
    Blobstore_BlobstoreList_AvailableSpace_Header: 'Available space',
    Blobstore_BlobstoreList_Filter_EmptyText: 'No blob stores matched "$filter"',
    Blobstore_BlobstoreList_EmptyText: 'No blob stores defined',
    Blobstore_BlobstoreFeature_Delete_Button: 'Delete blob store',
    Blobstore_BlobstoreFeature_Delete_Disabled_Message: 'This blob store is in use by {0} and {1} and cannot be deleted',
    Blobstore_BlobstoreFeature_Editing_Enabled_Message: 'Updating blob store configuration will cause it to be temporarily unavailable for a short period. Edits to configuration may also leave the blob store in a non-functional state. Use caution when changing values.',
    Blobstore_BlobstoreFeature_Promote_Button: 'Promote to group',
    Blobstore_BlobstoreFeature_Promote_Success: 'Blob store: {0} promoted to blob store group',
    Blobstore_BlobstoreFeature_Update_Title: 'Update Blob Store?',
    Blobstore_BlobstoreFeature_Update_Warning: 'Warning: The blob store will be temporarily unavailable for a short period.  This function does not migrate data to a new location.',
    Blobstore_BlobstoreSettings_Title: 'Settings',
    Blobstore_BlobstoreAdd_Type_FieldLabel: 'Type',
    Blobstore_BlobstoreAdd_Type_EmptyText: 'Select a type',
    Blobstore_BlobstoreSettingsForm_Name_FieldLabel: 'Name',
    Blobstore_BlobstoreSettingsForm_Path_FieldLabel: 'Path',
    Blobstore_BlobstoreSettingsForm_EnableSoftQuota_FieldLabel: 'Enable Soft Quota',
    Blobstore_BlobstoreSettingsForm_SoftQuota_HelpText: 'A soft quota provides warnings when a limit is violated.  It never causes an operation to be rejected',
    Blobstore_BlobstoreSettingsForm_QuotaType_FieldLabel: 'Type of Quota',
    Blobstore_BlobstoreSettingsForm_QuotaLimit_FieldLabel: 'Quota Limit in MB',

    // Admin -> Repository -> Selectors
    Selectors_Text: 'Content Selectors',
    Selectors_Description: 'Manage content selectors',
    Selectors_Create_Title: 'Create Selector',
    Selector_SelectorAdd_Create_Error: 'You do not have permission to create selectors',
    Selector_SelectorAdd_Create_Success: 'Selector created: {0}',
    Selector_SelectorSettingsForm_Update_Error: 'You do not have permission to update selectors',
    Selector_SelectorSettingsForm_Update_Success: 'Selector updated: {0}',
    Selector_SelectorList_New_Button: 'Create selector',
    Selector_SelectorList_Name_Header: 'Name',
    Selector_SelectorList_Type_Header: 'Type',
    Selector_SelectorList_Description_Header: 'Description',
    Selector_SelectorList_EmptyText: 'No selectors defined',
    Selector_SelectorList_Filter_EmptyText: 'No selectors matched "$filter"',
    Selector_SelectorFeature_Delete_Button: 'Delete selector',
    Selectors_Delete_Message: 'Selector deleted: {0}',
    Selector_SelectorFeature_Settings_Title: 'Settings',
    Selector_SelectorSettingsForm_Name_FieldLabel: 'Name',
    Selector_SelectorSettingsForm_Type_FieldLabel: 'Type',
    Selector_SelectorSettingsForm_Type_Jexl: 'JEXL',
    Selector_SelectorSettingsForm_Type_Sonatype: 'CSEL',
    Selector_SelectorSettingsForm_Description_FieldLabel: 'Description',
    Selector_SelectorSettingsForm_Expression_FieldLabel: 'Search expression',
    Selector_SelectorSettingsForm_Expression_HelpText: 'Use query to identify repositories, components or assets',
    Selector_SelectorSettingsForm_Expression_Examples: '<div style="font-size: 11px"><br/>' +
    '<h4>Example Content Selector Expressions:</h4>' +
    '<p>Select all "raw" format content<br/><i>format == "raw"</i></p>' +
    '<p>Select all "maven2" content with a groupId that starts with "org.sonatype.nexus"<br/><i>format == "maven2" and coordinate.groupId =^ "org.sonatype.nexus"</i></p>' +
    '<br/>' +
    '<p>See the <a href="http://links.sonatype.com/products/nexus/selectors/docs" target="_blank">Nexus documentation</a> for more details</p>' +
    '</div>',
    Selector_SelectorSettingsForm_Expression_Examples_jexl: '<div style="font-size: 11px"><br/>' +
    '<h4>Example <a href="http://links.sonatype.com/products/nexus/jexl" target="_blank">JEXL</a> queries:</h4>' +
    '<p>Select all "raw" format content<br/><i>format == "raw"</i></p>' +
    '<p>Select all "maven2" content with a groupId that starts with "org.sonatype.nexus"<br/><i>format == "maven2" and coordinate.groupId =^ "org.sonatype.nexus"</i></p>' +
    '<br/>' +
    '<p>See the <a href="http://links.sonatype.com/products/nexus/selectors/docs" target="_blank">Nexus documentation</a> for more details</p>' +
    '</div>',
    Selector_SelectorSettingsForm_SelectorID_Title: 'Selector ID',
    Selector_SelectorSettingsForm_Specification_Title: 'Specification',
    Selector_SelectorSettingsForm_Preview_Button: 'Preview results',

    // Admin -> Repository -> Selectors -> Preview Window
    SelectorPreviewWindow_Title: 'Preview results',
    SelectorPreviewWindow_expression_FieldLabel: 'Expression',
    SelectorPreviewWindow_expression_jexl: 'JEXL',
    SelectorPreviewWindow_expression_csel: 'CSEL',
    SelectorPreviewWindow_type_FieldLabel: 'Type',
    SelectorPreviewWindow_repository_FieldLabel: 'Preview Repository',
    SelectorPreviewWindow_repository_HelpText: 'Select a repository to evaluate the content selector and see the content that would be available.',
    SelectorPreviewWindow_repository_EmptyText: 'Select a repository...',
    SelectorPreviewWindow_EmptyText_View: 'No assets in repository matched the expression',
    SelectorPreviewWindow_EmptyText_Filter: 'No assets matched "$filter"',
    SelectorPreviewWindow_Name_Column: 'Name',
    SelectorPreviewWindow_Preview_Button: 'Preview',

    // Admin -> Security
    FeatureGroups_Security_Title: 'Security',
    FeatureGroups_Security_Description: 'Security administration',

    // Admin -> Security -> Privileges
    Privileges_Text: 'Privileges',
    Privileges_Description: 'Manage privileges',
    Privileges_Update_Mask: 'Updating privilege',
    Privileges_Update_Success: 'Privilege updated: {0}',
    Privileges_Create_Success: 'Privilege created: {0}',
    Privileges_Delete_Success: 'Privilege deleted: {0}',
    Privileges_Select_Title: 'Select Privilege Type',
    Privilege_PrivilegeList_New_Button: 'Create privilege',
    Privilege_PrivilegeList_Name_Header: 'Name',
    Privilege_PrivilegeList_Description_Header: 'Description',
    Privilege_PrivilegeList_Type_Header: 'Type',
    Privilege_PrivilegeList_Permission_Header: 'Permission',
    Privilege_PrivilegeList_EmptyText: 'No privileges defined',
    Privilege_PrivilegeList_Filter_EmptyText: 'No privileges matched "$filter"',
    Privilege_PrivilegeFeature_Details_Tab: 'Summary',
    Privilege_PrivilegeFeature_Delete_Button: 'Delete privilege',
    Privilege_PrivilegeFeature_Settings_Title: 'Settings',
    Privilege_PrivilegeSelectType_Type_Header: 'Type',
    Privilege_PrivilegeAdd_Create_Error: 'You do not have permission to create privileges',
    Privilege_PrivilegeSettingsForm_Update_Success: 'Privilege updated: {0}',
    Privilege_PrivilegeSettingsForm_Update_Error: 'You do not have permission to update privileges or privilege is read only',
    Privilege_PrivilegeSettingsForm_Description_FieldLabel: 'Description',
    Privilege_PrivilegeSettingsForm_Name_FieldLabel: 'Name',
    Privileges_Summary_ID: 'ID',
    Privileges_Summary_Type: 'Type',
    Privileges_Summary_Name: 'Name',
    Privileges_Summary_Description: 'Description',
    Privileges_Summary_Permission: 'Permission',
    Privileges_Summary_Property: 'Property-{0}',
    Privileges_Create_Title: 'Create {0} Privilege',

    // Admin -> Security -> Roles
    Roles_Text: 'Roles',
    Roles_Description: 'Manage roles',
    Roles_Create_Title: 'Create Role',
    Role_RoleAdd_Create_Error: 'You do not have permission to create roles',
    Role_RoleAdd_Create_Success: 'Role created: ',
    Role_RoleSettingsForm_Update_Error: 'You do not have permission to update roles or role is readonly',
    Role_RoleSettingsForm_Update_Success: 'Role updated: ',
    Role_RoleList_New_Button: 'Create role',
    Role_RoleList_New_NexusRoleItem: 'Nexus role',
    Roles_New_ExternalRoleItem: 'External role mapping',
    Role_RoleList_Name_Header: 'Name',
    Role_RoleList_Source_Header: 'Source',
    Role_RoleList_Description_Header: 'Description',
    Role_RoleList_EmptyText: 'No roles defined',
    Role_RoleList_Filter_EmptyText: 'No roles matched "$filter"',
    Role_RoleFeature_Delete_Button: 'Delete role',
    Roles_Delete_Message: 'Role deleted: {0}',
    Role_RoleFeature_Settings_Title: 'Settings',
    Role_RoleSettingsForm_RoleID_FieldLabel: 'Role ID',
    Role_RoleSettingsForm_MappedRole_FieldLabel: 'Mapped Role',
    Role_RoleSettingsForm_MappedRole_EmptyText: 'Select a role',
    Role_RoleSettingsForm_Name_FieldLabel: 'Role name',
    Role_RoleSettingsForm_Description_FieldLabel: 'Role description',
    Role_RoleSettingsForm_Privileges_FieldLabel: 'Privileges',
    Role_RoleSettingsForm_Privileges_FromTitle: 'Available',
    Role_RoleSettingsForm_Privileges_ToTitle: 'Given',
    Role_RoleSettingsForm_Roles_FieldLabel: 'Roles',
    Role_RoleSettingsForm_Roles_FromTitle: 'Available',
    Role_RoleSettingsForm_Roles_ToTitle: 'Contained',

    // Admin -> Security -> Users
    User_Text: 'Users',
    User_Description: 'Manage users',
    User_UserSettingsForm_Update_Error: 'You do not have permission to update users or is an external user',
    User_UserSettingsForm_Update_Success: 'User updated: ',
    User_UserSettingsForm_UpdateRoles_Success: 'User role mappings updated: {0}',
    User_UserSettingsExternalForm_Remove_Error: 'Cannot remove role',
    Users_Create_Title: 'Create User',
    User_UserAdd_Password_FieldLabel: 'Password',
    User_UserAdd_PasswordConfirm_FieldLabel: 'Confirm password',
    User_UserChangePassword_NoMatch_Error: 'Passwords do not match',
    User_UserAdd_Create_Error: 'You do not have permission to create users',
    User_UserAdd_Create_Success: 'User created: ',
    User_UserChangePassword_Title: 'Change Password',
    User_UserChangePassword_Password_FieldLabel: 'New password',
    User_UserChangePassword_PasswordConfirm_FieldLabel: 'Confirm password',
    User_UserChangePassword_Submit_Button: 'Change password',
    User_UserChangePassword_Cancel_Button: '@Button_Cancel',
    User_UserChangePassword_NoPermission_Error: 'You do not have permission to change your password',
    User_UserList_New_Button: 'Create local user',
    User_UserList_Source_Label: 'Source:',
    User_UserList_Default_Button: 'Default',
    User_UserList_Filter_EmptyText: 'Filter by user ID',
    User_UserList_ID_Header: 'User ID',
    User_UserList_Realm_Header: 'Realm',
    User_UserList_FirstName_Header: 'First name',
    User_UserList_LastName_Header: 'Last name',
    User_UserList_Email_Header: 'Email',
    User_UserList_Status_Header: 'Status',
    User_UserList_EmptyText: 'No users defined',
    User_UserFeature_Delete_Button: 'Delete user',
    Users_Delete_Success: 'User deleted: {0}',
    User_UserFeature_More_Button: 'More',
    User_UserFeature_ChangePasswordItem: 'Change password',
    Users_Change_Success: 'Password changed',
    User_UserFeature_Settings_Title: 'Settings',
    User_UserSettingsForm_ID_FieldLabel: 'ID',
    User_UserSettingsForm_ID_HelpText: 'This will be used as the username',
    User_UserSettingsForm_FirstName_FieldLabel: 'First name',
    User_UserSettingsForm_LastName_FieldLabel: 'Last name',
    User_UserSettingsForm_Email_FieldLabel: 'Email',
    User_UserSettingsForm_Email_HelpText: 'Used for notifications',
    User_UserSettingsForm_Status_FieldLabel: 'Status',
    User_UserSettingsForm_Status_EmptyText: 'Select status',
    User_UserSettingsForm_Status_ActiveItem: 'Active',
    User_UserSettingsForm_Status_DisabledItem: 'Disabled',
    User_UserSettingsExternalForm_Roles_FieldLabel: 'Roles',
    User_UserSettingsExternalForm_Roles_FromTitle: 'Available',
    User_UserSettingsExternalForm_Roles_ToTitle: 'Granted',
    User_UserSettingsExternalForm_ExternalRoles_FieldLabel: 'External roles',
    User_UserSettingsExternalForm_ExternalRoles_HelpText: 'External roles should be managed at their source, and cannot be managed here.',

    // Admin -> Security -> Anonymous
    AnonymousSettings_Text: 'Anonymous',
    AnonymousSettings_Description: 'Browse server contents without authenticating',
    Security_AnonymousSettings_Update_Error: 'You do not have permission to configure the anonymous user',
    Security_AnonymousSettings_Update_Success: 'Anonymous security settings $action',
    Security_AnonymousSettings_Allow_BoxLabel: 'Allow anonymous users to access the server',
    Security_AnonymousSettings_Username_FieldLabel: 'Username',
    Security_AnonymousSettings_Realm_FieldLabel: 'Realm',

    // Admin -> Security -> LDAP
    LdapServers_Text: 'LDAP',
    LdapServers_Description: 'Manage LDAP server configuration',
    LdapServers_Update_Mask: 'Updating LDAP connection',
    LdapServers_Update_Success: 'LDAP server updated: {0}',
    Ldap_LdapServerConnectionForm_Update_Error: 'You do not have permission to update LDAP servers',
    LdapServers_Create_Mask: 'Creating LDAP connection',
    LdapServers_CreateConnection_Title: 'Create LDAP Connection',
    LdapServers_CreateUsersAndGroups_Title: 'Choose Users and Groups',
    LdapServers_Create_Success: 'LDAP server created: {0}',
    Ldap_LdapServerConnectionAdd_Create_Error: 'You do not have permission to create LDAP servers',
    LdapServers_Delete_Success: 'LDAP server deleted: {0}',
    Ldap_LdapServerChangeOrder_Title: 'Change LDAP servers ordering',
    LdapServers_ChangeOrder_Success: 'LDAP server order changed',
    Ldap_LdapServerUserAndGroupLoginCredentials_Title: 'Login Credentials',
    Ldap_LdapServerUserAndGroupLoginCredentials_Text: 'You have requested an operation which requires validation of your credentials.',
    Ldap_LdapServerUserAndGroupLoginCredentials_Input_Text: '<div>Enter your LDAP server credentials</div>',
    Ldap_LdapServerUserAndGroupLoginCredentials_Username_FieldLabel: 'LDAP server username',
    Ldap_LdapServerUserAndGroupLoginCredentials_Password_FieldLabel: 'LDAP server password',
    Ldap_LdapServerUserAndGroupLoginCredentials_Submit_Button: 'Test connection',
    Ldap_LdapServerUserAndGroupLoginCredentials_Cancel_Button: '@Button_Cancel',
    Ldap_LdapServerUserAndGroupMappingTestResults_Title: 'User Mapping Test Results',
    Ldap_LdapServerUserAndGroupMappingTestResults_ID_Header: 'User ID',
    Ldap_LdapServerUserAndGroupMappingTestResults_Name_Header: 'Name',
    Ldap_LdapServerUserAndGroupMappingTestResults_Email_Header: 'Email',
    Ldap_LdapServerUserAndGroupMappingTestResults_Roles_Header: 'Roles',
    Ldap_LdapServerList_New_Button: 'Create connection',
    Ldap_LdapServerList_ChangeOrder_Button: 'Change order',
    Ldap_LdapServerList_ClearCache_Button: 'Clear cache',
    Ldap_LdapServerList_Order_Header: 'Order',
    Ldap_LdapServerList_Name_Header: 'Name',
    Ldap_LdapServerList_URL_Header: 'URL',
    Ldap_LdapServerList_Filter_EmptyText: 'No LDAP servers matched "$filter"',
    Ldap_LdapServerList_EmptyText: 'No LDAP servers defined',
    Ldap_LdapServerFeature_Delete_Button: 'Delete connection',
    Ldap_LdapServerFeature_Connection_Title: 'Connection',
    Ldap_LdapServerFeature_UserAndGroup_Title: 'User and group',
    LdapServers_ClearCache_Success: 'LDAP cache has been cleared',
    LdapServers_VerifyConnection_Mask: 'Checking connection to {0}',
    LdapServers_VerifyConnection_Success: 'Connection to LDAP server verified: {0}',
    LdapServers_VerifyMapping_Mask: 'Checking user mapping on {0}',
    LdapServers_VerifyMapping_Success: 'LDAP server user mapping verified: {0}',
    LdapServers_VerifyLogin_Mask: 'Checking login on {0}',
    LdapServers_VerifyLogin_Success: 'LDAP login completed successfully on: {0}',
    LdapServersConnectionFieldSet_Address_Text: 'LDAP server address:',
    LdapServersConnectionFieldSet_Address_HelpText: 'The LDAP server usually listens on port 389 (ldap://) or port 636 (ldaps://)',
    LdapServersConnectionFieldSet_Name_FieldLabel: 'Name',
    LdapServersConnectionFieldSet_Protocol_EmptyText: 'Protocol',
    LdapServersConnectionFieldSet_Protocol_PlainItem: 'ldap',
    LdapServersConnectionFieldSet_Protocol_SecureItem: 'ldaps',
    LdapServersConnectionFieldSet_Host_EmptyText: 'Hostname',
    LdapServersConnectionFieldSet_Port_EmptyText: 'Port',
    LdapServersConnectionFieldSet_Base_FieldLabel: 'Search base',
    LdapServersConnectionFieldSet_Base_HelpText: 'LDAP location to be added to the connection URL (e.g. "dc=sonatype,dc=com")',
    LdapServersConnectionFieldSet_AuthMethod_FieldLabel: 'Authentication method',
    LdapServersConnectionFieldSet_AuthMethod_EmptyText: 'Select an authentication method',
    LdapServersConnectionFieldSet_AuthMethod_SimpleItem: 'Simple Authentication',
    LdapServersConnectionFieldSet_AuthMethod_AnonymousItem: 'Anonymous Authentication',
    LdapServersConnectionFieldSet_AuthMethod_DigestItem: 'DIGEST-MD5',
    LdapServersConnectionFieldSet_AuthMethod_CramItem: 'CRAM-MD5',
    LdapServersConnectionFieldSet_SaslRealm_FieldLabel: 'SASL realm',
    LdapServersConnectionFieldSet_SaslRealm_HelpText: 'The SASL realm to bind to (e.g. mydomain.com)',
    LdapServersConnectionFieldSet_Username_FieldLabel: 'Username or DN',
    LdapServersConnectionFieldSet_Username_HelpText: 'This must be a fully qualified username if simple authentication is used',
    LdapServersConnectionFieldSet_Password_FieldLabel: 'Password',
    LdapServersConnectionFieldSet_Password_HelpText: 'The password to bind with.',
    LdapServersConnectionFieldSet_Rules_Text: 'Connection rules',
    LdapServersConnectionFieldSet_Rules_HelpText: 'Set timeout parameters and max connection attempts to avoid being blacklisted',
    LdapServersConnectionFieldSet_Rules_Text1: 'Wait ',
    LdapServersConnectionFieldSet_Rules_Text2: ' seconds before timeout. Retry after ',
    LdapServersConnectionFieldSet_Rules_Text3: ' seconds, max of ',
    LdapServersConnectionFieldSet_Rules_Text4: ' failed attempts.',
    Ldap_LdapServerConnectionForm_VerifyConnection_Button: 'Verify connection',
    Ldap_LdapServerUserAndGroupFieldSet_Template_FieldLabel: 'Configuration template',
    Ldap_LdapServerUserAndGroupFieldSet_Template_EmptyText: 'Select a template',
    Ldap_LdapServerUserAndGroupFieldSet_BaseDN_FieldLabel: 'Base DN',
    Ldap_LdapServerUserAndGroupFieldSet_BaseDN_HelpText: 'The base location in LDAP that users are found. This is relative to the search base (e.g. ou=people).',
    Ldap_LdapServerUserAndGroupFieldSet_UserSubtree_FieldLabel: 'User subtree',
    Ldap_LdapServerUserAndGroupFieldSet_UserSubtree_HelpText: 'Are users located in structures below the user base DN?',
    Ldap_LdapServerUserAndGroupFieldSet_ObjectClass_FieldLabel: 'Object class',
    Ldap_LdapServerUserAndGroupFieldSet_ObjectClass_HelpText: 'LDAP class for user objects (e.g. inetOrgPerson)',
    Ldap_LdapServerUserAndGroupFieldSet_UserFilter_FieldLabel: 'User filter',
    Ldap_LdapServerUserAndGroupFieldSet_UserFilter_HelpText: 'LDAP search filter to limit user search (e.g. "attribute=foo" or "(l(mail=*@domain.com)(uid=dom*))")',
    Ldap_LdapServerUserAndGroupFieldSet_UserID_FieldLabel: 'User ID attribute',
    Ldap_LdapServerUserAndGroupFieldSet_RealName_FieldLabel: 'Real name attribute',
    Ldap_LdapServerUserAndGroupFieldSet_Email_FieldLabel: 'Email attribute',
    Ldap_LdapServerUserAndGroupFieldSet_Password_FieldLabel: 'Password attribute',
    Ldap_LdapServerUserAndGroupFieldSet_Password_HelpText: 'If this field is blank the user will be authenticated against a bind with the LDAP server.',
    Ldap_LdapServerUserAndGroupFieldSet_GroupMap_FieldLabel: 'Map LDAP groups as roles',
    Ldap_LdapServerUserAndGroupFieldSet_GroupType_FieldLabel: 'Group type',
    Ldap_LdapServerUserAndGroupFieldSet_GroupType_EmptyText: 'Select a group type',
    Ldap_LdapServerUserAndGroupFieldSet_GroupType_DynamicItem: 'Dynamic Groups',
    Ldap_LdapServerUserAndGroupFieldSet_GroupType_StaticItem: 'Static Groups',
    Ldap_LdapServerUserAndGroupFieldSet_GroupBaseDN_FieldLabel: 'Group base DN',
    Ldap_LdapServerUserAndGroupFieldSet_GroupBaseDN_HelpText: 'The base location in the LDAP that groups are found. This is relative to the search base (e.g. ou=Group).',
    Ldap_LdapServerUserAndGroupFieldSet_GroupSubtree_FieldLabel: 'Group subtree',
    Ldap_LdapServerUserAndGroupFieldSet_GroupSubtree_HelpText: 'Are groups located in structures below the group base DN.',
    Ldap_LdapServerUserAndGroupFieldSet_GroupObject_FieldLabel: 'Group object class',
    Ldap_LdapServerUserAndGroupFieldSet_GroupObject_HelpText: 'LDAP class for group objects (e.g. posixGroup)',
    Ldap_LdapServerUserAndGroupFieldSet_GroupID_FieldLabel: 'Group ID attribute',
    Ldap_LdapServerUserAndGroupFieldSet_GroupMember_FieldLabel: 'Group member attribute',
    Ldap_LdapServerUserAndGroupFieldSet_GroupMember_HelpText: 'LDAP attribute containing the usernames for the group.',
    Ldap_LdapServerUserAndGroupFieldSet_GroupMemberFormat_FieldLabel: 'Group member format',
    Ldap_LdapServerUserAndGroupFieldSet_GroupMemberFormat_HelpText: 'The format of user ID stored in the group member attribute (e.g. "uid=${username},ou=people,o=sonatype")',
    Ldap_LdapServerUserAndGroupFieldSet_GroupMemberOf_FieldLabel: 'Group member of attribute',
    Ldap_LdapServerUserAndGroupFieldSet_GroupMemberOf_HelpText: 'Set this to the attribute used to store the attribute which holds groups DN in the user object',
    Ldap_LdapServerUserAndGroupForm_VerifyGroupMapping_Button: 'Verify user mapping',
    Ldap_LdapServerUserAndGroupForm_VerifyLogin_Button: 'Verify login',

    // Admin -> Security -> Realms
    RealmSettings_Text: 'Realms',
    RealmSettings_Description: 'Manage the active security realms and their order',
    Security_RealmSettings_Update_Error: 'You do not have permission to configure realms',
    Security_RealmSettings_Update_Success: 'Security realms settings $action',
    Security_RealmSettings_Available_FromTitle: 'Available',
    Security_RealmSettings_Available_ToTitle: 'Active',

    // Admin -> Security -> SSL Certificates
    SslCertificates_Text: 'SSL Certificates',
    SslCertificates_Description: 'Manage trusted SSL certificates for use with the Nexus truststore',
    SslCertificates_Paste_Title: 'Paste Certificate as PEM',
    Ssl_SslCertificateAddFromPem_Cancel_Button: '@Button_Cancel',
    SslCertificates_Load_Title: 'Load Certificate from Server',
    Ssl_SslCertificateAddFromServer_Load_FieldLabel: 'Please enter a hostname, hostname:port or a URL to fetch a SSL certificate from',
    SslTrustStore_Load_Mask: 'Loading certificate&hellip;',
    Ssl_SslCertificateAddFromServer_Cancel_Button: '@Button_Cancel',
    SslCertificates_Load_Success: 'SSL Certificate created: {0}',
    Ssl_SslCertificateList_New_Button: 'Load certificate',
    Ssl_SslCertificateList_Load_Button: 'Load from server',
    Ssl_SslCertificateList_Paste_Button: 'Paste PEM',
    Ssl_SslCertificateList_Name_Header: 'Name',
    Ssl_SslCertificateList_IssuedTo_Header: 'Issued to',
    Ssl_SslCertificateList_IssuedBy_Header: 'Issued by',
    Ssl_SslCertificateList_Fingerprint_Header: 'Fingerprint',
    Ssl_SslCertificateList_EmptyText: 'No SSL certificates',
    Ssl_SslCertificateList_Filter_EmptyText: 'No SSL certificates matched "$filter"',
    Ssl_SslCertificateDetailsWindow_Title: 'Certificate Details',
    SslCertificates_Remove_Button: 'Remove certificate from truststore',
    SslCertificates_Add_Button: 'Add certificate to truststore',
    Ssl_SslCertificateFeature_Delete_Button: 'Delete certificate',
    SslCertificates_Delete_Success: 'SSL Certificate deleted: {0}',
    Ssl_SslCertificateDetailsWindow_Cancel_Button: '@Button_Cancel',
    Ssl_SslCertificateDetailsForm_Subject_Title: 'Subject',
    Ssl_SslCertificateDetailsForm_SubjectCommonName_FieldLabel: 'Common name',
    Ssl_SslCertificateDetailsForm_SubjectOrganization_FieldLabel: 'Organization',
    Ssl_SslCertificateDetailsForm_SubjectUnit_FieldLabel: 'Unit',
    Ssl_SslCertificateDetailsForm_Issuer_Title: 'Issuer',
    Ssl_SslCertificateDetailsForm_IssuerName_FieldLabel: 'Common name',
    Ssl_SslCertificateDetailsForm_IssuerOrganization_FieldLabel: 'Organization',
    Ssl_SslCertificateDetailsForm_IssuerUnit_FieldLabel: 'Unit',
    Ssl_SslCertificateDetailsForm_Certificate_Title: 'Certificate',
    Ssl_SslCertificateDetailsForm_CertificateIssuedOn_FieldLabel: 'Issued on',
    Ssl_SslCertificateDetailsForm_CertificateValidUntil_FieldLabel: 'Valid until',
    Ssl_SslCertificateDetailsForm_CertificateFingerprint_FieldLabel: 'Fingerprint',

    // Admin -> Support
    FeatureGroups_Support_Text: 'Support',
    FeatureGroups_Support_Description: 'Support tools',

    // Admin -> Support -> Logging
    Loggers_Text: 'Logging',
    Loggers_Description: 'Control logging verbosity levels',
    Loggers_Create_Title: 'Create logger',
    Logging_LoggerAdd_Name_FieldLabel: 'Logger name',
    Logging_LoggerAdd_Level_FieldLabel: 'Logging level',
    Loggers_Write_Success: 'Logger {0}d: {1}',
    Logging_LoggerList_New_Button: 'Create logger',
    Loggers_Update_Title: 'Confirm update?',
    Loggers_HelpText: 'Logger "{0}" is already configured. Would you like to update its level to "{1}"?',
    Logging_LoggerList_Delete_Button: 'Delete logger',
    Loggers_Delete_Title: 'Confirm deletion?',
    Loggers_Delete_Success: 'Logger deleted: {0}',
    Loggers_Reset_Title: 'Confirm reset?',
    Loggers_Reset_HelpText: 'Reset loggers to their default levels',
    Logging_LoggerList_Reset_Button: 'Reset to default levels',
    Loggers_Reset_Success: 'Loggers have been reset',
    Logging_LoggerList_Name_Header: 'Name',
    Logging_LoggerList_Level_Header: 'Level',
    Logging_LoggerList_Level_TraceItem: 'TRACE',
    Logging_LoggerList_Level_DebugItem: 'DEBUG',
    Logging_LoggerList_Level_InfoItem: 'INFO',
    Logging_LoggerList_Level_WarnItem: 'WARN',
    Logging_LoggerList_Level_ErrorItem: 'ERROR',
    Logging_LoggerList_Level_OffItem: 'OFF',
    Logging_LoggerList_Level_DefaultItem: 'DEFAULT',
    Logging_LoggerList_EmptyText: 'No loggers defined',
    Logging_LoggerList_Filter_EmptyText: 'No loggers matched "$filter"',

    // Admin -> Support -> Logging -> Log Viewer
    Log_Text: 'Log Viewer',
    Log_Description: 'View the current log contents',
    Logging_LogMark_Title: 'Mark Log',
    Logging_LogMark_Error: 'You do not have permission to mark the log',
    Logging_LogMark_FieldLabel: 'Log message',
    Logging_LogMark_HelpText: 'Insert this text into the log file as a reference point',
    Logging_LogMark_Success: 'Log has been marked',
    Log_LogMark_Mask: 'Marking Log',
    Logging_LogViewer_Download_Button: 'Download',
    Logging_LogViewer_Mark_Button: 'Create mark',
    Logging_LogViewer_Refresh_Text: 'Refresh interval:',
    Logging_LogViewer_Refresh_ManualItem: 'Manual',
    Logging_LogViewer_Refresh_20SecondsItem: 'Every 20 seconds',
    Logging_LogViewer_Refresh_MinuteItem: 'Every minute',
    Logging_LogViewer_Refresh_2MinutesItem: 'Every 2 minutes',
    Logging_LogViewer_Refresh_5MinutesItem: 'Every 5 minutes',
    Logging_LogViewer_Last25KBItem: 'Last 25KB',
    Logging_LogViewer_Last50KBItem: 'Last 50KB',
    Logging_LogViewer_Last100KBItem: 'Last 100KB',
    Log_Loading_Mask: 'Loading&hellip;',
    Log_Load_Failure: 'Failed to retrieve log due to "{0}".',
    Logging_LogViewer_EmptyText: 'Refresh to display log',

    // Admin -> Support -> Metrics
    Metrics_Text: 'Metrics',
    Metrics_Description: 'Provides server metrics',
    Metrics_Load_Mask: 'Loading&hellip;',
    Metrics_Refresh_Warning: 'Failed to refresh metrics data',
    Support_Metrics_Download_Button: 'Download',
    Metrics_Download_Tooltip: 'Download metrics data',
    Support_Metrics_Dump_Button: 'Thread dump',
    Support_Metrics_Dump_Tooltip: 'Download thread dump',
    Support_Metrics_MemoryUsage_Title: 'Memory usage',
    Support_Metrics_Heap_Title: 'Heap',
    Metrics_Heap_NonHeapItem: 'Non-heap',
    Metrics_Heap_Available: 'Available',
    Support_Metrics_ThreadStates_Title: 'Thread states',
    Metrics_ThreadStates_New: 'New',
    Metrics_ThreadStates_Terminated: 'Terminated',
    Metrics_ThreadStates_Blocked: 'Blocked',
    Metrics_ThreadStates_Runnable: 'Runnable',
    Metrics_ThreadStates_TimedWaiting: 'Timed waiting',
    Metrics_ThreadStates_Waiting: 'Waiting',
    Support_Metrics_Dispatches_Title: 'Active Web Requests',
    Support_Metrics_ResponseCode_Title: 'Web Response Codes',
    Support_Metrics_Requests_Title: 'Web Requests',
    
    // Admin -> Support -> MetricHealth
    Metric_Health_Text: 'Status',
    Metric_Health_Description: 'System status checks',
    Metric_Health_Name_Header: 'Name',
    Metric_Health_Message_Header: 'Message',
    Metric_Health_Error_Header: 'Error',
    Metric_Health_Load_Mask: 'Loading&hellip;',
    Metric_Health_Refresh_Warning : 'Failed to refresh server status',

    // Admin -> Support -> Support Request
    SupportRequest_Text: 'Support Request',
    SupportRequest_Description: 'Submit a support request to Sonatype',
    Support_SupportRequest_HelpText: '<p>Please include a complete description of your problem and steps to allow us to reproduce the problem (if available).</p><p>Attaching a <a href="#admin/support/supportzip">support ZIP</a> to your request will help our engineers give you a faster response.</p>',
    Support_SupportRequest_Submit_Button: 'Submit request',

    // Admin -> Support -> Support ZIP
    SupportZip_Title: 'Support ZIP',
    SupportZip_Description: 'Creates a ZIP file containing useful support information about your server',
    SupportZip_HelpText: '<p>No information will be sent to Sonatype when creating the support ZIP file.</p>' +
    '<p>Support ZIP creation may take a few minutes to complete.</p>',
    Support_SupportZip_Contents_FieldLabel: 'Contents',
    Support_SupportZip_Report_BoxLabel: 'System information report',
    Support_SupportZip_Dump_BoxLabel: 'JVM thread-dump',
    Support_SupportZip_Configuration_BoxLabel: 'Configuration files',
    Support_SupportZip_Security_BoxLabel: 'Security configuration files',
    Support_SupportZip_LogFiles_BoxLabel: 'Log files',
    Support_SupportZip_TaskLogFiles_BoxLabel: 'Task log files',
    Support_SupportZip_Metrics_BoxLabel: 'System and component metrics',
    Support_SupportZip_JMX_BoxLabel: 'JMX information',
    Support_SupportZip_Options_FieldLabel: 'Options',
    Support_SupportZip_Included_BoxLabel: 'Limit files in the ZIP archive to 30 MB apiece',
    Support_SupportZip_Max_BoxLabel: 'Limit the ZIP archive to 20 MB',
    Support_SupportZip_Create_Button: 'Create support ZIP',
    Support_SupportZip_Creating_Message: '<div align="center">Creating support ZIP <br/>(may take a few minutes)</div>',
    Support_SupportZipCreated_FileType_Text: 'Support ZIP',
    Support_SupportZipCreated_Truncated_Text: 'Contents have been truncated due to exceeded size limits.',
    Support_SupportZip_Create_Success: 'Support ZIP created',
    Support_FileCreated_Name_FieldLabel: 'Name',
    Support_FileCreated_Size_FieldLabel: 'Size',
    Support_FileCreated_Path_FieldLabel: 'Path',
    Support_FileCreated_Download_Button: 'Download',
    Support_FileCreated_Cancel_Button: '@Button_Cancel',
    SupportZip_Authenticate_Text: 'Downloading support ZIP requires validation of your credentials.',
    SupportZip_Permission_Error: 'You do not have permission to create a support ZIP',

    // Admin -> Support -> System Information
    SysInfo_Title: 'System Information',
    SysInfo_Description: 'Shows system information',
    SysInfo_Load_Mask: 'Loading&hellip;',
    Support_SysInfo_Download_Button: 'Download',

    // Admin -> System
    FeatureGroups_System_Text: 'System',
    FeatureGroups_System_Description: 'System administration',

    // Admin -> System -> API
    Api_Text: 'API',
    Api_Description: 'Learn how to interact with Nexus Repository Manager programmatically',

    // Admin -> System -> Capabilities
    Capabilities_Text: 'Capabilities',
    Capabilities_Description: 'Manage capabilities',
    Capabilities_Update_Mask: 'Updating capability',
    Capabilities_Enable_Mask: 'Enabling capability',
    Capabilities_Disable_Mask: 'Disabling capability',
    Capabilities_Update_Error: 'You do not have permission to update capabilities',
    Capability_CapabilityAdd_Create_Error: 'You do not have permission to update capabilities',
    Capabilities_Update_Success: 'Capability updated: {0}',
    Capability_CapabilitySettingsForm_Update_Error: 'You do not have permission to create capabilities',
    Capabilities_Create_Title: 'Create {0} Capability',
    Capabilities_Create_Success: 'Capability created: {0}',
    Capabilities_Delete_Success: 'Capability deleted: {0}',
    Capability_CapabilityList_New_Button: 'Create capability',
    Capability_CapabilityList_Type_Header: 'Type',
    Capability_CapabilityList_Description_Header: 'Description',
    Capability_CapabilityList_Notes_Header: 'Notes',
    Capability_CapabilityList_EmptyText: 'No capabilities defined',
    Capability_CapabilityList_Filter_EmptyText: 'No capability matched criteria "$filter"',
    Capability_CapabilityFeature_Delete_Button: 'Delete',
    Capability_CapabilityFeature_Enable_Button: 'Enable',
    Capability_CapabilityFeature_Disable_Button: 'Disable',
    Capability_CapabilitySummary_Title: 'Summary',
    Capability_CapabilitySettings_Title: 'Settings',
    Capability_CapabilitySettingsForm_Enabled_FieldLabel: 'Enable this capability',
    Capability_CapabilitySummary_Status_Title: 'Status',
    Capability_CapabilitySummary_About_Title: 'About',
    Capability_CapabilitySummary_Notes_Title: 'Notes',
    Capabilities_Enable_Text: 'Capability enabled: {0}',
    Capabilities_Disable_Text: 'Capability disabled: {0}',
    Capabilities_Select_Title: 'Select Capability Type',
    Capability_CapabilitySelectType_Description_Header: 'Description',
    Capability_CapabilitySelectType_Type_Header: 'Type',
    Capabilities_TypeName_Text: 'Type',
    Capabilities_Description_Text: 'Description',
    Capabilities_State_Text: 'State',
    Capability_CapabilitySummary_Notes_HelpText: 'Optional notes about configured capability',
    Capability_CapabilityStatus_EmptyText: 'This capability does not provide any status',

    // Admin -> System -> Cleanup Policies
    CleanupPolicies_Text: 'Cleanup Policies',
    CleanupPolicies_Description: 'Manage component removal configuration',
    CleanupPolicies_Create_Title: 'Create Cleanup Policy',
    CleanupPolicies_Delete_Title: 'Confirm deletion?',
    CleanupPolicies_Delete_Description: 'This Cleanup Policy is not used by any repository',
    CleanupPolicies_Delete_Description_Multiple: 'This Cleanup Policy is used by {0} repositories',
    CleanupPolicies_Delete_Success: 'Cleanup Policy deleted: {0}',
    CleanupPolicy_CleanupPolicyList_Preview_Button: 'Preview results',
    CleanupPolicy_CleanupPolicyList_New_Button: 'Create Cleanup Policy',
    CleanupPolicy_CleanupPolicyList_Filter_EmptyState: 'No cleanup policies matched "$filter"',
    CleanupPolicy_CleanupPolicyList_EmptyState: 'No cleanup policies defined',
    CleanupPolicy_CleanupPolicyList_Name_Header: 'Name',
    CleanupPolicy_CleanupPolicyList_Format_Header: 'Format',
    CleanupPolicy_CleanupPolicyList_Notes_Header: 'Notes',
    CleanupPolicy_CleanupPolicyFeature_Settings_Title: 'Settings',
    CleanupPolicy_CleanupPolicyFeature_Delete_Button: 'Delete',
    CleanupPolicy_CleanupPolicySettingsForm_Update_Success: 'Cleanup Policy updated: ',
    CleanupPolicy_CleanupPolicySettingsForm_Update_Error: 'You do not have permission to update Cleanup Policies',
    CleanupPolicy_CleanupPolicySettingsForm_CleanupPolicy_Title :'Cleanup Policy',
    CleanupPolicy_CleanupPolicySettingsForm_Name_FieldLabel: 'Name',
    CleanupPolicy_CleanupPolicySettingsForm_Name_HelpText: 'A unique name for the cleanup policy',
    CleanupPolicy_CleanupPolicySettingsForm_Format_FieldLabel: 'Format',
    CleanupPolicy_CleanupPolicySettingsForm_Format_HelpText: 'The format that this cleanup policy can be applied to',
    CleanupPolicy_CleanupPolicySettingsForm_Notes_FieldLabel: 'Notes',
    CleanupPolicy_CleanupPolicySettingsForm_Criteria_Title :'Criteria',
    CleanupPolicy_CleanupPolicySettingsForm_AddCriteria_Text: 'Add criteria',
    CleanupPolicy_CleanupPolicySettingsForm_LastBlobUpdated_FieldLabel: 'Published Before',
    CleanupPolicy_CleanupPolicySettingsForm_LastBlobUpdated_HelpText: 'Restrict cleanup to components that were published to NXRM more than the given number of days ago. (Blob updated date)',
    CleanupPolicy_CleanupPolicySettingsForm_LastDownloaded_FieldLabel: 'Last Downloaded Before',
    CleanupPolicy_CleanupPolicySettingsForm_LastDownloaded_HelpText: 'Restrict cleanup to components that were last downloaded more than the given number of days ago. (Last downloaded	date)',
    CleanupPolicy_CleanupPolicySettingsForm_IsPrerelease_FieldLabel: 'Release Type',
    CleanupPolicy_CleanupPolicySettingsForm_IsPrerelease_HelpText: 'Restrict cleanup to components that are of this release type',
    CleanupPolicy_CleanupPolicySettingsForm_IsPrerelease_Prereleases_Item: 'Pre-Release / Snapshot Versions',
    CleanupPolicy_CleanupPolicySettingsForm_IsPrerelease_Releases_Item: 'Release Versions',
    CleanupPolicy_CleanupPolicyAdd_Create_Error: 'You do not have permission to create Cleanup Policies',
    CleanupPolicy_CleanupPolicyAdd_Create_Success: 'Cleanup Policy created: ',
    CleanupPolicy_CleanupPolicyPreviewWindow_Title: 'Cleanup Policy preview',
    CleanupPolicy_CleanupPolicyPreviewWindow_repository_FieldLabel: 'Repository to Preview',
    CleanupPolicy_CleanupPolicyPreviewWindow_repository_HelpText: 'Select a repository to preview what might get cleaned up if this policy was applied',
    CleanupPolicy_CleanupPolicyPreviewWindow_repository_EmptyText: 'Select a repository',
    CleanupPolicy_CleanupPolicyPreviewWindow_Preview_Button: 'Preview',
    CleanupPolicy_CleanupPolicyPreviewWindow_EmptyText_View: 'No assets in repository matched the criteria',
    CleanupPolicy_CleanupPolicyPreviewWindow_EmptyText_Filter: 'No assets matched "$filter"',
    CleanupPolicy_CleanupPolicyPreviewWindow_Group_Column: 'Group',
    CleanupPolicy_CleanupPolicyPreviewWindow_Name_Column: 'Name',
    CleanupPolicy_CleanupPolicyPreviewWindow_Version_Column: 'Version',
    CleanupPolicy_CleanupPolicyPreviewWindow_Total_Component_Count: 'Component count (matching criteria) viewing',
    CleanupPolicy_CleanupPolicyPreviewWindow_Total_Component_Count_Out_Of: ' out of ',
    CleanupPolicy_CleanupPolicyPreviewWindow_Warning: 'Results may only be a sample of what will be deleted using the current criteria',

    // Admin -> System -> Email Server
    SmtpSettings_Text: 'Email Server',
    SmtpSettings_Description: 'Manage email server configuration',
    System_SmtpSettings_Update_Error: 'You do not have permission to configure email server',
    System_SmtpSettings_Update_Success: 'Email server configuration $action',
    System_SmtpSettings_Enabled_FieldLabel: 'Enabled',
    System_SmtpSettings_Host_FieldLabel: 'Host',
    System_SmtpSettings_Port_FieldLabel: 'Port',
    System_SmtpSettings_Username_FieldLabel: 'Username',
    System_SmtpSettings_Password_FieldLabel: 'Password',
    System_SmtpSettings_FromAddress_FieldLabel: 'From address',
    System_SmtpSettings_SubjectPrefix_FieldLabel: 'Subject prefix',
    System_SmtpSettings_SslTlsSection_FieldLabel: 'SSL/TLS options',
    System_SmtpSettings_StartTlsEnabled_FieldLabel: 'Enable STARTTLS support for insecure connections',
    System_SmtpSettings_StartTlsRequired_FieldLabel: 'Require STARTTLS support',
    System_SmtpSettings_SslOnConnectEnabled_FieldLabel: 'Enable SSL/TLS encryption upon connection',
    System_SmtpSettings_SslCheckServerIdentityEnabled_FieldLabel: 'Enable server identity check',

    System_SmtpSettings_VerifyServer_Button: 'Verify email server',
    System_VerifySmtpConnection_VerifyServer_Title: 'Verify Email Server',
    System_VerifySmtpConnection_HelpText: 'Where do you want to send the test email?',
    SmtpSettings_Verify_Mask: 'Checking email server {0}',
    SmtpSettings_Verify_Success: 'Email server verification email sent successfully',

    // Admin -> System -> HTTP
    HttpSettings_Text: 'HTTP',
    HttpSettings_Description: 'Manage outbound HTTP/HTTPS configuration',
    System_HttpSettings_Update_Error: 'You do not have permission to configure HTTP',
    System_HttpSettings_Update_Success: 'HTTP system settings $action',
    System_HttpSettings_Proxy_Title: 'HTTP proxy',
    System_HttpSettings_ProxyHost_FieldLabel: 'HTTP proxy host',
    System_HttpSettings_ProxyHost_HelpText: 'No http:// required (e.g. "proxy-host" or "192.168.1.101")',
    System_HttpSettings_ProxyPort_FieldLabel: 'HTTP proxy port',
    System_HttpSettings_Authentication_Title: 'Authentication',
    System_HttpSettings_ExcludeHosts_FieldLabel: 'Hosts to exclude from HTTP/HTTPS proxy',
    System_HttpSettings_ExcludeHosts_HelpText: 'Accepts Java "http.nonProxyHosts" wildcard patterns (one per line, no \'|\' hostname delimiters)',
    System_HttpSettings_HttpsProxy_Title: 'HTTPS proxy',
    System_HttpSettings_HttpsProxyHost_FieldLabel: 'HTTPS proxy host',
    System_HttpSettings_HttpsProxyHost_HelpText: 'No https:// required (e.g. "proxy-host" or "192.168.1.101")',
    System_HttpSettings_HttpsProxyPort_FieldLabel: 'HTTPS proxy port',
    System_HttpSettings_HttpsProxyAuthentication_Title: 'Authentication',

    // Admin -> System -> Bundles
    Bundles_Text: 'Bundles',
    Bundles_Description: 'View OSGI bundles',
    System_BundleList_Filter_EmptyText: 'No bundles matched "$filter"',
    System_BundleList_ID_Header: 'ID',
    System_BundleList_Name_Header: 'Name',
    System_BundleList_SymbolicName_Header: 'Symbolic Name',
    System_BundleList_Version_Header: 'Version',
    System_BundleList_State_Header: 'State',
    System_BundleList_Location_Header: 'Location',
    System_BundleList_Level_Header: 'Level',
    System_BundleList_Fragment_Header: 'Fragment',
    System_Bundles_Details_Tab: 'Summary',
    Bundles_ID_Info: 'ID',
    Bundles_Name_Info: 'Name',
    Bundles_SymbolicName_Info: 'Symbolic Name',
    Bundles_Version_Info: 'Version',
    Bundles_State_Info: 'State',
    Bundles_Location_Info: 'Location',
    Bundles_StartLevel_Info: 'Start Level',
    Bundles_Fragment_Info: 'Fragment',
    Bundles_Fragments_Info: 'Fragments',
    Bundles_FragmentHosts_Info: 'Fragment Hosts',
    Bundles_LastModified_Info: 'Last Modified',
    Bundles_Summary_Info: '{0}',

    // Admin -> System -> Nodes
    Nodes_Toggling_read_only_mode: 'Toggling read-only mode',
    Nodes_Disable_read_only_mode: 'Disable read-only mode',
    Nodes_Disable_read_only_mode_dialog: 'Disable read-only mode?',
    Nodes_Enable_read_only_mode: 'Enable read-only mode',
    Nodes_Enable_read_only_mode_dialog: 'Enable read-only mode?',
    Nodes_Read_only_mode_warning: 'Nexus Repository is in read-only mode',
    Nodes_force_release_dialog: 'Forcibly disable read-only mode?',
    Nodes_force_release: 'Force disable read-only mode',
    Nodes_Quorum_lost_warning: 'Not enough Nexus Repository Manager nodes in the cluster are reachable so quorum cannot be achieved; database is read only. <a href="#admin/system/nodes/clusterreset">Troubleshoot</a>',
    Nodes_OSS_Message: 'You are running a single-node instance of Nexus Repository Manager.',
    Nodes_enable_read_only_mode_dialog_description: 'Are you sure you want to reject additions of new' +
    ' components and changes to configuration?',
    Nodes_disable_read_only_mode_dialog_description: 'Are you sure you want to stop rejecting additions of new' +
    ' components and changes to configuration?',
    Nodes_force_release_warning: 'Warning: read-only mode has been enabled by system tasks. Releasing read-only mode before those tasks are complete may cause them to fail and/or cause data loss.',
    Nodes_force_release_confirmation: 'Are you sure you want to forcibly release read-only mode?',
    Nodes_NodeSettings_Title: 'Edit Node',
    Nodes_NodeSettingsForm_Update_Error: 'You do not have permission to update nodes',
    Nodes_NodeSettingsForm_Update_Success: 'Node updated, node is now named: ',
    Nodes_NodeSettingsForm_ID_FieldLabel: 'Node ID',
    Nodes_NodeSettingsForm_ID_HelpText: 'System-generated node identity',
    Nodes_NodeSettingsForm_Local_FieldLabel: 'Local',
    Nodes_NodeSettingsForm_Local_HelpText: 'Whether the current UI session is connected to the listed node',
    Nodes_NodeSettingsForm_SocketAddress_FieldLabel: 'Socket Address',
    Nodes_NodeSettingsForm_SocketAddress_HelpText: 'The IP address and port number used by the listed node to communicate with the cluster',
    Nodes_NodeSettingsForm_FriendlyName_FieldLabel: 'Node Name',
    Nodes_NodeSettingsForm_FriendlyName_HelpText: 'Custom alias for this node',

    // Admin -> System -> Tasks
    Tasks_Text: 'Tasks',
    Tasks_Description: 'Manage scheduled tasks',
    Tasks_Select_Title: 'Select a Type',
    Task_TaskSelectType_Filter_EmptyText: 'No types matched "$filter"',
    Task_TaskSelectType_Name_Header: 'Type',
    Tasks_Update_Mask: 'Updating task',
    Tasks_Run_Mask: 'Running task',
    Tasks_Stop_Mask: 'Stopping task',
    Task_TaskAdd_Create_Error: 'You do not have permission to create tasks',
    Tasks_Create_Title: 'Create {0} Task',
    Tasks_Create_Success: 'Task created: {0}',
    Task_TaskList_New_Button: 'Create task',
    Task_TaskList_Name_Header: 'Name',
    Task_TaskList_Type_Header: 'Type',
    Task_TaskList_Status_Header: 'Status',
    Task_TaskList_Schedule_Header: 'Schedule',
    Task_TaskList_NextRun_Header: 'Next run',
    Task_TaskList_LastRun_Header: 'Last run',
    Task_TaskList_LastResult_Header: 'Last result',
    Task_TaskList_EmptyState: 'No scheduled tasks defined',
    Task_TaskList_Filter_EmptyState: 'No scheduled tasks matched "$filter"',
    Task_TaskFeature_Delete_Button: 'Delete task',
    Tasks_Delete_Success: 'Task deleted: {0}',
    Task_TaskFeature_Run_Button: 'Run',
    Tasks_RunConfirm_Title: 'Confirm?',
    Tasks_RunConfirm_HelpText: 'Run {0} task?',
    Tasks_Run_Success: 'Task started: {0}',
    Tasks_Run_Disabled: 'Task is disabled',
    Task_TaskFeature_Stop_Button: 'Stop',
    Tasks_StopConfirm_Title: 'Confirm?',
    Tasks_StopConfirm_HelpText: 'Stop {0} task?',
    Tasks_Stop_Success: 'Task stopped: {0}',
    TaskFeature_Summary_Title: 'Summary',
    TaskFeature_Summary_Status_Section_Title: 'Run Status',
    TaskFeature_Status_Node_Column: 'Node ID',
    TaskFeature_Status_Status_Column: 'Status',
    TaskFeature_Status_LastResult_Column: 'Last result',
    Tasks_Settings_Title: 'Settings',
    Tasks_ID_Info: 'ID',
    Tasks_Name_Info: 'Name',
    Tasks_Type_Info: 'Type',
    Tasks_Status_Info: 'Status',
    Tasks_NextRun_Info: 'Next run',
    Tasks_LastRun_Info: 'Last run',
    Tasks_LastResult_Info: 'Last result',
    Task_TaskSettingsForm_Update_Error: 'You do not have permission to update tasks or task is readonly',
    Tasks_Update_Success: 'Task updated: {0}',
    Task_TaskSettingsForm_Enabled_FieldLabel: 'Task enabled',
    Task_TaskSettingsForm_Enabled_HelpText: 'This flag determines if the task is currently active.  To disable this task for a period of time, de-select this checkbox.',
    Task_TaskSettingsForm_Name_FieldLabel: 'Task name',
    Task_TaskSettingsForm_Name_HelpText: 'A name for the scheduled task',
    Task_TaskSettingsForm_Email_FieldLabel: 'Notification email',
    Task_TaskSettingsForm_Email_HelpText: 'The email address where an email will be sent in case that task execution fails',
    Task_TaskScheduleFieldSet_Recurrence_FieldLabel: 'Task frequency',
    Task_TaskScheduleFieldSet_Recurrence_HelpText: 'The frequency this task will run. Manual - this task can only be run manually. Once - run the task once at the specified date/time. Daily - run the task every day at the specified time. Weekly - run the task every week on the specified day at the specified time. Monthly - run the task every month on the specified day(s) and time. Advanced - run the task using the supplied cron string',
    Task_TaskScheduleFieldSet_Recurrence_EmptyText: 'Select a frequency',
    Task_TaskScheduleFieldSet_Recurrence_ManualItem: 'Manual',
    Task_TaskScheduleFieldSet_Recurrence_OnceItem: 'Once',
    Task_TaskScheduleFieldSet_Recurrence_HourlyItem: 'Hourly',
    Task_TaskScheduleFieldSet_Recurrence_DailyItem: 'Daily',
    Task_TaskScheduleFieldSet_Recurrence_WeeklyItem: 'Weekly',
    Task_TaskScheduleFieldSet_Recurrence_MonthlyItem: 'Monthly',
    Task_TaskScheduleFieldSet_Recurrence_AdvancedItem: 'Advanced (provide a CRON expression)',
    Task_TaskScheduleDaily_StartDate_FieldLabel: 'Start date',
    Task_TaskScheduleHourly_EndDate_FieldLabel: 'Start time',
    Task_TaskScheduleDaily_Recurring_FieldLabel: 'Time to run this task',
    Task_TaskScheduleMonthly_Days_FieldLabel: 'Days to run this task',
    Task_TaskScheduleMonthly_Days_BlankText: 'At least one day should be selected',
    Task_TaskScheduleAdvanced_Cron_FieldLabel: 'CRON expression',
    Task_TaskScheduleAdvanced_Cron_EmptyText: '* * * * * * *',
    Task_TaskScheduleAdvanced_Cron_HelpText: 'A cron expression that will control the running of the task.',
    Task_TaskScheduleAdvanced_Cron_AfterBodyEl: '<div style="font-size: 11px"><p>From left to right the fields and accepted values are:</p>' +
    '<table>' +
    '<thead><tr><th>Field Name</th><th>Allowed Values</th></tr></thead>' +
    '<tbody>' +
    '<tr><td>Seconds</td><td>0-59</td></tr>' +
    '<tr><td>Minutes</td><td>0-59</td></tr>' +
    '<tr><td>Hours</td><td>0-23</td></tr>' +
    '<tr><td>Day of month</td><td>1-31</td></tr>' +
    '<tr><td>Month</td><td>1-12 or JAN-DEC</td></tr>' +
    '<tr><td>Day of week</td><td>1-7 or SUN-SAT</td></tr>' +
    '<tr><td>Year(optional)</td><td>empty, 1970-2099</td></tr>' +
    '</tbody>' +
    '</table>' +
    '<br/>' +
    '<p>Special tokens include: * (all acceptable values), ? (no specific value), - (ranges, e.g. 10-12)</p>' +
    '</div> '
    ,
    Task_TaskScheduleManual_HelpText: 'Without recurrence, this service can only be run manually.',

    // Authentication section
    System_AuthenticationSettings_Username_FieldLabel: 'Username',
    System_AuthenticationSettings_Password_FieldLabel: 'Password',
    System_AuthenticationSettings_WindowsNtlmHostname_FieldLabel: 'Windows NTLM hostname',
    System_AuthenticationSettings_WindowsNtlmDomain_FieldLabel: 'Windows NTLM domain',

    // HTTP Request section
    System_HttpRequestSettings_UserAgentCustomization_FieldLabel: 'User-agent customization',
    System_HttpRequestSettings_UserAgentCustomization_HelpText: 'Custom fragment to append to "User-Agent" header in HTTP requests.',
    System_HttpRequestSettings_Timeout_FieldLabel: 'Connection/Socket timeout',
    System_HttpRequestSettings_Timeout_HelpText: 'Seconds to wait for activity before stopping and retrying the connection.',
    System_HttpRequestSettings_Attempts_FieldLabel: 'Connection/Socket retry attempts',
    System_HttpRequestSettings_Attempts_HelpText: 'Total retries if the initial connection attempt suffers a timeout',

    // User -> Account
    Users_Text: 'Account',
    Users_Description: 'Manage your account',
    User_UserAccount_Update_Success: 'User account settings $action',
    User_UserAccount_Update_Error: 'External users cannot be updated',
    User_UserAccount_ID_FieldLabel: 'ID',
    User_UserAccount_ID_HelpText: 'This is used as your username.',
    User_UserAccount_First_FieldLabel: 'First name',
    User_UserAccount_Last_FieldLabel: 'Last Name',
    User_UserAccount_Email_FieldLabel: 'Email',
    User_UserAccount_Password_Button: 'Change password',

    // User -> NuGet Api Key
    NuGetApiKey_Text: 'NuGet API Key',
    NuGetApiKey_Description: 'Configure credentials for NuGet repositories',
    Nuget_NuGetApiKeyDetails_Html: 'Your NuGet API Key enables pushing packages using NuGet.exe. ' +
    '<span style="font-weight: bold;">Keep this key secret!</span>',
    Nuget_NuGetApiKeyDetails_ApiKey_Text: 'Your NuGet API Key is:',
    Nuget_NuGetApiKeyDetails_Register_Text: 'You can register this key for a given repository with the following command:',
    Nuget_NuGetApiKeyDetails_Register_Value: 'nuget setapikey {0} -source {1}',
    Nuget_NuGetApiKeyDetails_AutoClose_Html: 'This window will automatically close after one minute.',
    Nuget_NuGetApiKeyDetails_AutoClose_Message: 'Automatically closing NuGet API Key details due to timeout',
    Nuget_NuGetApiKey_Instructions_Text: 'A new API Key will be created the first time it is accessed. Resetting your API Key will invalidate the current key.',
    Nuget_NuGetApiKey_Access_Button: 'Access API Key',
    Nuget_NuGetApiKey_Access_HelpText: 'Accessing NuGet API Key requires validation of your credentials.',
    Nuget_NuGetApiKey_Reset_Button: 'Reset API Key',
    Nuget_NuGetApiKey_Reset_HelpText: 'Resetting NuGet API Key requires validation of your credentials.',

    // Admin -> System -> Licensing
    Licensing_Text: 'Licensing',
    Licensing_Description: 'A valid license is required for PRO features. Manage it here.',
    Licensing_LicensingDetails_Company_FieldLabel: 'Company',
    Licensing_LicensingDetails_Name_FieldLabel: 'Name',
    Licensing_LicensingDetails_Email_FieldLabel: 'Email',
    Licensing_LicensingDetails_EffectiveDate_FieldLabel: 'Effective date',
    Licensing_LicensingDetails_ExpirationDate_FieldLabel: 'Expiration date',
    Licensing_LicensingDetails_Type_FieldLabel: 'License type',
    Licensing_LicensingDetails_LicensedUsers_FieldLabel: 'Number of licensed users',
    Licensing_LicensingDetails_Connections_FieldLabel: 'Number of unique IP addresses that have connected in the last 7 days',
    Licensing_LicensingDetails_Fingerprint_FieldLabel: 'Fingerprint',
    Licensing_LicensingDetails_InstallLicense_Title: 'Install license',
    Licensing_LicensingDetails_InstallLicense_Html: '<p>Installing a new license requires restarting the server to take effect</p>',
    Licensing_LicensingDetails_LicenseSelect_Button: 'Select license&hellip;',
    Licensing_LicensingDetails_LicenseInstall_Button: 'Install license',
    Licensing_LicenseAgreement_Title: 'Nexus Repository Manager License Agreement',
    Licensing_LicenseAgreement_Yes_Button: 'I agree',
    Licensing_LicenseAgreement_No_Button: 'I do not agree',
    Licensing_LicenseAgreement_Download_Button: 'Download a copy of the agreement.',
    Licensing_Install_Success: 'License installed. Restart is only required if you are enabling new PRO features.',
    Licensing_Authentication_Validation: '{0} a license requires validation of your credentials.',

    // Admin -> System -> Licensing -> Recent Connections
    LicenseUsers_Title: 'Recent Connections',
    LicenseUsers_Description: 'Reports active users in the last 7 days',
    Licensing_LicenseUserList_Download_Button: 'Download',
    Licensing_LicenseUserList_IP_Header: 'IP',
    Licensing_LicenseUserList_Date_Header: 'Date',
    Licensing_LicenseUserList_User_Header: 'User',
    Licensing_LicenseUserList_Agent_Header: 'User agent',
    Licensing_LicenseUserList_EmptyText: 'No active users in the last 7 days.',

    //Nexus Lifecycle -> Server
    Clm_ClmSettings_Permission_Error: 'You do not have permission to configure IQ Server',
    Clm_Text: 'Server',
    Clm_Description: 'Manage IQ Server configuration',
    Clm_Connection_Success: 'Connection to IQ Server verified: {0}',
    Clm_Dashboard_Title: 'Dashboard',
    Clm_Dashboard_Description: 'Open IQ Server Dashboard',
    ClmSettings_Html: '<p><a href="http://www.sonatype.com/nexus/product-overview/nexus-lifecycle" target="_blank">IQ Server</a> ' +
    'can evaluate application and organization policies.</p>' +
    '<p>To enable this feature configure the IQ Server URL, username and password.</p>',

    Clm_SettingsTestResults_Title: 'Applications',
    Clm_SettingsTestResults_EmptyText: 'No applications found',
    Clm_SettingsTestResults_Id_Header: 'Id',
    Clm_SettingsTestResults_Name_Header: 'Name',

    ClmSettings_Enable_FieldLabel: 'Enable IQ Server',
    ClmSettings_Enable_HelpText: 'Whether to use IQ Server',
    ClmSettings_URL_FieldLabel: 'IQ Server URL',
    ClmSettings_URL_HelpText: 'The address of your IQ Server',
    ClmSettings_URL_EmptyText: 'enter a URL',
    ClmSettings_AuthenticationType_FieldLabel: 'Authentication Method',
    ClmSettings_AuthenticationType_Pki: 'PKI Authentication',
    ClmSettings_AuthenticationType_User: 'User Authentication',
    ClmSettings_Username_FieldLabel: 'Username',
    ClmSettings_Username_HelpText: 'User with access to IQ Server',
    ClmSettings_Username_EmptyText: 'enter a name',
    ClmSettings_Password_FieldLabel: 'Password',
    ClmSettings_Password_HelpText: 'Credentials for the IQ Server User',
    ClmSettings_Password_EmptyText: 'enter a password',
    ClmSettings_ConnectionTimeout_FieldLabel: 'Connection Timeout',
    ClmSettings_ConnectionTimeout_HelpText: 'Seconds to wait for activity before stopping and retrying the connection. Leave blank to use the globally defined HTTP timeout.',
    ClmSettings_ConnectionTimeout_EmptyText: 'enter a timeout',
    ClmSettings_Properties_FieldLabel: 'Properties',
    ClmSettings_Properties_HelpText: 'Additional properties to configure for IQ Server',
    ClmSettings_Properties_EmptyText: 'enter properties',
    ClmSettings_Properties_Verify_Button: 'Verify connection'
  },

  /**
   * String bundles.
   *
   * @type {Object}
   */
  bundles: {
    'NX.coreui.migration.Controller': {
      Feature_Text: 'Upgrade',
      Feature_Description: 'Upgrade configuration and content from Nexus Repository Manager 2',

      Activate_Mask: 'Loading',

      Configure_Mask: 'Configuring',
      Configure_Message: 'Upgrade configured',

      Cancel_Confirm_Title: 'Cancel Upgrade',
      Cancel_Confirm_Text: 'Do you want to cancel upgrade?',
      Cancel_Mask: 'Canceling',
      Cancel_Message: 'Upgrade canceled',

      IncompleteCancel_Title: 'Configuration Incomplete',
      IncompleteCancel_Text: 'Upgrade has been partially configured and needs to be reset to continue.',
      IncompleteCancel_Mask: 'Resetting',

      PlanStepDetail_Mask: 'Fetching details'
    },

    'NX.coreui.migration.AgentScreen': {
      Title: 'Agent Connection',
      Description: "<p>Configure the connection to remote server's upgrade-agent.<br/>" +
      'The remote server must have an upgrade-agent configured and enabled.</p>',
      Endpoint_FieldLabel: 'URL',
      Endpoint_HelpText: "The base URL of the remote server",
      Token_FieldLabel: 'Access Token',
      Token_HelpText: "The access token from the remote server's upgrade-agent settings"
    },

    'NX.coreui.migration.AgentStep': {
      Connect_Mask: 'Connecting',
      Connect_Message: 'Connected'
    },

    'NX.coreui.migration.ContentScreen': {
      Title: 'Content',
      Description: '<p>What content from Nexus Repository Manager 2 would you like to transfer?</p>',
      Repositories_FieldLabel: 'Repository configuration and content',
      Configuration_FieldLabel: 'Server configuration'
    },

    'NX.coreui.migration.OverviewScreen': {
      Title: 'Overview',
      Description: '<p>This wizard will help you upgrade from Nexus Repository Manager 2.</p>' +
      '<p>Many aspects of a server can be upgraded <strong>automatically</strong>:' +
      '<ul>' +
      '<li>Configuration: security (users, roles and privileges) and other applicable system settings </li>' +
      '<li>Repositories in supported formats: maven2, nuget, npm, rubygems, site</li>' +
      '</ul>' +
      '</p>' +
      '<p>Some aspects are <strong>incompatible</strong> and can not be automatically upgraded:' +
      '<ul>' +
      '<li>Unsupported repository formats: yum, p2, obr</li>' +
      '<li>Scheduled tasks</li>' +
      '<li>Capabilities</li>' +
      '</ul>' +
      '</p>' +
      '<p>Upgrade is incremental. We recommend upgrading one or two repositories first to ensure that the process works, then repeat the process and upgrade the rest. Take note of the following:' +
      '<ul>' +
      '<li>Repository upgrade could take <strong>considerable time</strong>.</li>' +
      '<li>Until upgrade has successfully completed, it is not recommended to make any configuration changes in Nexus Repository Manager 3, as the configuration is volatile during this time.</li>' +
      '<li>Also during the upgrade, all of the repositories in Nexus Repository Manager 3 will be offline.</li>' +
      '<li>Server configuration can be transferred multiple times, each time it will completely replace existing configurations.</li>' +
      '</ul>' +
      '</p>'
    },

    'NX.coreui.migration.PhaseFinishScreen': {
      Title: 'Finishing',
      Description: '<p>Upgrade is finishing.</p>',
      Abort_Button: 'Abort',
      Done_Button: 'Done'
    },

    'NX.coreui.migration.RepositoryDefaultsScreen': {
      $extend: 'NX.coreui.migration.RepositoryCustomizeWindow',

      Title: 'Repository Defaults',
      Description: '<p>Configure the default settings used for repository upgrade.<br/>' +
      'Per-repository settings may be customized when selecting repositories to upgrade.</p>',
      IngestMethod_HelpText: 'Choose how the repository content should be transferred. The method you choose may not be supported by all repositories.'
    },

    'NX.coreui.migration.RepositoryCustomizeWindow': {
      Title: 'Customize {0}',

      BlobStore_FieldLabel: 'Destination',
      BlobStore_HelpText: 'Choose where the repository content should be stored',
      BlobStore_EmptyText: 'Choose a blob store',

      IngestMethod_FieldLabel: 'Method',
      IngestMethod_HelpText: 'Choose how the repository content should be transferred',
      IngestMethod_EmptyText: 'Choose a repository content transfer method',
      IngestMethod_Link: 'Hard link (fastest)',
      IngestMethod_Copy: 'Filesystem copy (slow)',
      IngestMethod_Download: 'Download (slowest)'
    },

    'NX.coreui.migration.PlanStepDetailWindow': {
      Title: '{0}',
      EmptyLog: 'No progress',
      Timestamp_Column: 'Timestamp',
      Message_Column: 'Message'
    },

    'NX.coreui.migration.PreviewScreen': {
      Title: 'Preview',
      Description: '<p>Here is a preview of the upgrade configuration.</p>',
      Name_Column: 'Name',
      State_Column: 'State',
      Begin_Button: 'Begin'
    },

    'NX.coreui.migration.PreviewStep': {
      Begin_Confirm_Title: 'Begin Upgrade',
      Begin_Confirm_Text: 'Do you want to begin upgrade?',
      Begin_Mask: 'Upgrade beginning',
      Begin_Message: 'Upgrade begun'
    },

    'NX.coreui.migration.ProgressScreenSupport': {
      Name_Column: 'Name',
      Status_Column: 'Status',
      State_Column: 'State',
      Complete_Column: 'Complete'
    },

    'NX.coreui.migration.ProgressStepSupport': {
      Loading_Mask: 'Loading'
    },

    'NX.coreui.migration.RepositoriesScreen': {
      Title: 'Repositories',
      Description: '<p>Select the repositories to be upgraded.<br/>' +
      'Customize advanced configuration of the upgrade per-repository as needed.</p>',
      Repository_Column: 'Repository',
      Type_Column: 'Type',
      Format_Column: 'Format',
      Supported_Column: 'Supported',
      Status_Column: 'Status',
      Destination_Column: 'Destination',
      Method_Column: 'Method',
      Action_Tooltip: 'Customize repository options'
    },

    'NX.coreui.migration.RepositoriesStep': {
      $extend: 'NX.coreui.migration.ProgressStepSupport'
    },

    'NX.coreui.migration.RepositoryDefaultsStep': {
      $extend: 'NX.coreui.migration.ProgressStepSupport'
    },

    'NX.coreui.migration.PhasePrepareScreen': {
      Title: 'Preparing',
      Description: '<p>Preparing for upgrade.</p>',
      Abort_Button: 'Abort',
      Continue_Button: 'Continue'
    },

    'NX.coreui.migration.PhasePrepareStep': {
      $extend: 'NX.coreui.migration.ProgressStepSupport',

      Abort_Confirm_Title: 'Abort Upgrade',
      Abort_Confirm_Text: 'Do you want to abort upgrade?',
      Abort_Mask: 'Upgrade aborting',
      Abort_Message: 'Upgrade aborted',

      Continue_Confirm_Title: 'Continue Upgrade',
      Continue_Confirm_Text: 'Do you want to continue upgrade?',
      Continue_Mask: 'Upgrade continuing',
      Continue_Message: 'Upgrade continuing'
    },

    'NX.coreui.migration.PhaseSyncScreen': {
      Title: 'Synchronizing',
      Description: '<p>Upgrade is synchronizing changes.</p>',
      Abort_Button: 'Abort',
      Continue_Button: 'Continue',
      Continue_Button_Pending: '<i class="fa fa-spinner fa-spin fa-fw"></i> Continue'
    },

    'NX.coreui.migration.PhaseSyncStep': {
      $extend: 'NX.coreui.migration.ProgressStepSupport',

      Abort_Confirm_Title: 'Abort Upgrade',
      Abort_Confirm_Text: 'Do you want to abort upgrade?',
      Abort_Mask: 'Upgrade aborting',
      Abort_Message: 'Upgrade aborted',

      Stop_Waiting_Confirm_Title: 'Stop waiting for changes',
      Stop_Waiting_Confirm_Text: 'Any future changes to repositories will not be synchronized. Proceed?',
      Stop_Waiting_Confirm_Mask: 'Finalizing changes',
      Stop_Waiting_Confirm_Message: 'Changes finalized',

      Finish_Mask: 'Upgrade finishing',
      Finish_Message: 'Upgrade finishing'
    },

    'NX.coreui.migration.PhaseFinishStep': {
      $extend: 'NX.coreui.migration.ProgressStepSupport',

      Abort_Confirm_Title: 'Abort Upgrade',
      Abort_Confirm_Text: 'Do you want to abort upgrade?',
      Abort_Mask: 'Upgrade aborting',
      Abort_Message: 'Upgrade aborted',

      Done_Mask: 'Confirming',
      Done_Message: 'Upgrade done'
    },

    'NX.coreui.audit.AuditController': {
      Text: 'Audit',
      Description: 'System audit information',
      Clear_Title: 'Clear Audit Data',
      Clear_Body: 'Clear audit data?',
      Clear_Mask: 'Clearing audit data',
      Clear_Success: 'Audit data cleared'
    },

    'NX.coreui.audit.AuditList': {
      EmptyText: 'No audit data',
      Filter_EmptyText: 'No audit data matching "$filter"',
      Domain: 'Domain',
      Type: 'Type',
      Context: 'Context',
      Timestamp: 'Timestamp',
      NodeId: 'Node ID',
      Initiator: 'Initiator',
      Attribute: 'Attribute: {0}',
      Clear_Button: 'Clear'
    },

    'NX.coreui.controller.FileDescriptorWarnings': {
      File_Descriptor_Warning: '<a href="http://links.sonatype.com/products/nexus/system-reqs#filehandles" target="_blank">System Requirement: max file descriptors [{0}] likely too low, increase to at least [{1}].</a>'
    }
  }
}, function(self) {
  NX.I18n.register(self);
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * CoreUi plugin configuration.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.app.PluginConfig', {
  '@aggregate_priority': 100,

  namespaces: [
    'NX.coreui'
  ],

  requires: [
    'NX.coreui.app.PluginStrings'
  ],

  controllers: [
    {
      id: 'NX.coreui.controller.Api',
      active: function() {
        return NX.State.getValue('api') &&
            NX.app.Application.bundleActive('org.sonatype.nexus.plugins.nexus-coreui-plugin');
      }
    },
    {
      id: 'NX.coreui.controller.Assets',
      active: function () {
        return NX.app.Application.bundleActive('org.sonatype.nexus.plugins.nexus-coreui-plugin');
      }
    },
    {
      id: 'NX.coreui.controller.AnonymousSettings',
      active: function () {
        return NX.app.Application.bundleActive('org.sonatype.nexus.plugins.nexus-coreui-plugin');
      }
    },
    {
      id: 'NX.coreui.audit.AuditController',
      active: function () {
        return NX.app.Application.bundleActive('org.sonatype.nexus.plugins.nexus-audit-plugin');
      }
    },
    {
      id: 'NX.coreui.controller.BrowseableFormats',
      active: function () {
        return NX.app.Application.bundleActive('org.sonatype.nexus.plugins.nexus-coreui-plugin');
      }
    },
    {
      id: 'NX.coreui.controller.Capabilities',
      active: function() {
        return NX.app.Application.bundleActive('org.sonatype.nexus.plugins.nexus-coreui-plugin');
      }
    },
    {
      id: 'NX.coreui.controller.ComponentAssetTree',
      active: function () {
        return NX.app.Application.bundleActive('org.sonatype.nexus.plugins.nexus-coreui-plugin') &&
            NX.State.getValue('browseableformats').length > 0;
      }
    },
    'NX.coreui.controller.FeatureGroups',
    {
      id: 'NX.coreui.controller.HttpSettings',
      active: function () {
        return NX.app.Application.bundleActive('org.sonatype.nexus.plugins.nexus-coreui-plugin');
      }
    },
    {
      id: 'NX.coreui.controller.HealthCheckInfo',
      active: function () {
        return NX.app.Application.bundleActive('com.sonatype.nexus.plugins.nexus-clm-oss-plugin')
            || NX.app.Application.bundleActive('com.sonatype.nexus.plugins.nexus-clm-plugin');
      }
    },
    {
      id: 'NX.coreui.controller.HealthCheckRepositoryColumn',
      active: function () {
        return NX.app.Application.bundleActive('com.sonatype.nexus.plugins.nexus-clm-oss-plugin')
            || NX.app.Application.bundleActive('com.sonatype.nexus.plugins.nexus-clm-plugin');
      }
    },
    {
      id: 'NX.coreui.controller.HealthCheckRepositoryConfiguration',
      active: function () {
        return NX.app.Application.bundleActive('com.sonatype.nexus.plugins.nexus-clm-oss-plugin')
            || NX.app.Application.bundleActive('com.sonatype.nexus.plugins.nexus-clm-plugin');
      }
    },
    {
      id: 'NX.coreui.controller.Clm',
      active: function () {
        return NX.app.Application.bundleActive('com.sonatype.nexus.plugins.nexus-clm-oss-plugin')
            || NX.app.Application.bundleActive('com.sonatype.nexus.plugins.nexus-clm-plugin');
      }
    },
    {
      id: 'NX.coreui.controller.FirewallRepositoryColumn',
      active: function () {
        return NX.app.Application.bundleActive('com.sonatype.nexus.plugins.nexus-clm-oss-plugin')
            || NX.app.Application.bundleActive('com.sonatype.nexus.plugins.nexus-clm-plugin');
      }
    },
    {
      id: 'NX.coreui.controller.LdapServers',
      active: function () {
        return NX.app.Application.bundleActive('com.sonatype.nexus.plugins.nexus-ldap-plugin');
      }
    },
    {
      id: 'NX.coreui.controller.Log',
      active: function () {
        return NX.app.Application.bundleActive('org.sonatype.nexus.plugins.nexus-coreui-plugin');
      }
    },
    {
      id: 'NX.coreui.controller.Loggers',
      active: function () {
        return NX.app.Application.bundleActive('org.sonatype.nexus.plugins.nexus-coreui-plugin');
      }
    },
    {
      id: 'NX.coreui.controller.Metrics',
      active: function () {
        return NX.app.Application.bundleActive('org.sonatype.nexus.plugins.nexus-coreui-plugin');
      }
    },
    {
      id: 'NX.coreui.controller.MetricHealth',
      active: function () {
        return NX.app.Application.bundleActive('org.sonatype.nexus.plugins.nexus-coreui-plugin');
      }
    },
    {
      id: 'NX.coreui.migration.Controller',
      active: function () {
        return NX.State.getValue('migration', {})['enabled'] &&
            NX.app.Application.bundleActive('com.sonatype.nexus.plugins.nexus-migration-plugin');
      }
    },
    { id: 'NX.coreui.controller.NuGetApiKey',
      active: function () {
        return NX.app.Application.bundleActive('com.sonatype.nexus.plugins.nexus-repository-nuget');
      }
    },
    {
      id: 'NX.coreui.controller.Outreach',
      active: function () {
        return NX.app.Application.bundleActive('com.sonatype.nexus.plugins.nexus-outreach-plugin');
      }
    },
    {
      id: 'NX.coreui.controller.Bundles',
      active: function () {
        return NX.app.Application.bundleActive('org.sonatype.nexus.plugins.nexus-coreui-plugin');
      }
    },
    {
      id: 'NX.coreui.controller.Repositories',
      active: function () {
        return NX.app.Application.bundleActive('org.sonatype.nexus.plugins.nexus-coreui-plugin');
      }
    },
    {
      id: 'NX.coreui.controller.Blobstores',
      active: function () {
        return NX.app.Application.bundleActive('org.sonatype.nexus.plugins.nexus-coreui-plugin');
      }
    },
    { id: 'NX.coreui.controller.Licensing',
      active: function () {
        return NX.app.Application.bundleActive('com.sonatype.nexus.plugins.nexus-licensing-plugin');
      }
    },
    { id: 'NX.coreui.controller.LicenseUsers',
      active: function () {
        return NX.app.Application.bundleActive('com.sonatype.nexus.plugins.nexus-licensing-plugin');
      }
    },
    {
      id: 'NX.coreui.controller.Nodes',
      active: function () {
            return NX.app.Application.bundleActive('org.sonatype.nexus.plugins.nexus-coreui-plugin');
      }
    },
    {
      id: 'NX.coreui.controller.Privileges',
      active: function () {
        return NX.app.Application.bundleActive('org.sonatype.nexus.plugins.nexus-coreui-plugin');
      }
    },
    {
      id: 'NX.coreui.controller.DatabaseWarnings',
      active: function () {
        return NX.app.Application.bundleActive('org.sonatype.nexus.plugins.nexus-coreui-plugin');
      }
    },
    {
      id: 'NX.coreui.controller.RealmSettings',
      active: function () {
        return NX.app.Application.bundleActive('org.sonatype.nexus.plugins.nexus-coreui-plugin');
      }
    },
    {
      id: 'NX.coreui.controller.Roles',
      active: function () {
        return NX.app.Application.bundleActive('org.sonatype.nexus.plugins.nexus-coreui-plugin');
      }
    },
    {
      id: 'NX.coreui.controller.Search',
      active: function () {
        return NX.app.Application.bundleActive('org.sonatype.nexus.plugins.nexus-coreui-plugin');
      }
    },
    {
      id: 'NX.coreui.controller.SearchBower',
      active: function () {
        return NX.app.Application.bundleActive('com.sonatype.nexus.plugins.nexus-repository-bower');
      }
    },
    {
      id: 'NX.coreui.controller.SearchDocker',
      active: function () {
        return NX.app.Application.bundleActive('com.sonatype.nexus.plugins.nexus-repository-docker');
      }
    },
    {
      id: 'NX.coreui.controller.SearchGitLfs',
      active: function () {
        return NX.app.Application.bundleActive('com.sonatype.nexus.plugins.nexus-repository-gitlfs');
      }
    },
    {
      id: 'NX.coreui.controller.SearchMaven',
      active: function () {
        return NX.app.Application.bundleActive('org.sonatype.nexus.plugins.nexus-repository-maven');
      }
    },
    {
      id: 'NX.coreui.controller.SearchNpm',
      active: function () {
        return NX.app.Application.bundleActive('org.sonatype.nexus.plugins.nexus-repository-npm');
      }
    },
    {
      id: 'NX.coreui.controller.SearchNuget',
      active: function () {
        return NX.app.Application.bundleActive('com.sonatype.nexus.plugins.nexus-repository-nuget');
      }
    },
    {
      id: 'NX.coreui.controller.SearchPyPi',
      active: function () {
        return NX.app.Application.bundleActive('org.sonatype.nexus.plugins.nexus-repository-pypi');
      }
    },
    {
      id: 'NX.coreui.controller.SearchRaw',
      active: function () {
        return NX.app.Application.bundleActive('org.sonatype.nexus.plugins.nexus-repository-raw');
      }
    },
    {
      id: 'NX.coreui.controller.SearchRubygems',
      active: function () {
        return NX.app.Application.bundleActive('com.sonatype.nexus.plugins.nexus-repository-rubygems');
      }
    },
    {
      id: 'NX.coreui.controller.SearchYum',
      active: function () {
        return NX.app.Application.bundleActive('com.sonatype.nexus.plugins.nexus-repository-yum');
      }
    },
    {
      id: 'NX.coreui.controller.Selectors',
      active: function() {
        return NX.app.Application.bundleActive('org.sonatype.nexus.plugins.nexus-coreui-plugin');
      }
    },
    {
      id: 'NX.coreui.controller.SmtpSettings',
      active: function () {
        return NX.app.Application.bundleActive('org.sonatype.nexus.plugins.nexus-coreui-plugin');
      }
    },
    {
      id: 'NX.coreui.controller.SslCertificates',
      active: function () {
        return NX.app.Application.bundleActive('org.sonatype.nexus.plugins.nexus-ssl-plugin');
      }
    },
    {
      id: 'NX.coreui.controller.SslTrustStore',
      active: function () {
        return NX.app.Application.bundleActive('org.sonatype.nexus.plugins.nexus-ssl-plugin');
      }
    },
    {
      id: 'NX.coreui.controller.SupportRequest',
      active: function () {
        return NX.app.Application.bundleActive('org.sonatype.nexus.plugins.nexus-coreui-plugin');
      }
    },
    {
      id: 'NX.coreui.controller.SupportZip',
      active: function () {
        return NX.app.Application.bundleActive('org.sonatype.nexus.plugins.nexus-coreui-plugin');
      }
    },
    {
      id: 'NX.coreui.controller.SysInfo',
      active: function () {
        return NX.app.Application.bundleActive('org.sonatype.nexus.plugins.nexus-coreui-plugin');
      }
    },
    {
      id: 'NX.coreui.controller.Tasks',
      active: function () {
        return NX.app.Application.bundleActive('org.sonatype.nexus.plugins.nexus-coreui-plugin');
      }
    },
    {
      id: 'NX.coreui.controller.UploadComponent',
      active: function () {
        return NX.State.getValue('upload') &&
          NX.app.Application.bundleActive('org.sonatype.nexus.plugins.nexus-coreui-plugin');
      }
    },
    {
      id: 'NX.coreui.controller.Users',
      active: function () {
        return NX.app.Application.bundleActive('org.sonatype.nexus.plugins.nexus-coreui-plugin');
      }
    },
    {
      id: 'NX.coreui.controller.FileDescriptorWarnings',
      active: function () {
        return NX.app.Application.bundleActive('org.sonatype.nexus.plugins.nexus-coreui-plugin');
      }
    },
    {
      id: 'NX.coreui.controller.CleanupPolicies',
      active: function () {
        return NX.app.Application.bundleActive('org.sonatype.nexus.plugins.nexus-coreui-plugin');
      }
    }
  ]
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Configuration specific to proxy repositories.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.repository.facet.ProxyFacet', {
  extend: 'Ext.form.FieldContainer',
  alias: 'widget.nx-coreui-repository-proxy-facet',
  requires: [
    'NX.I18n'
  ],

  defaults: {
    allowBlank: false,
    itemCls: 'required-field'
  },

  /**
   * @override
   */
  initComponent: function() {
    var me = this;

    me.items = [
      {
        xtype: 'fieldset',
        itemId: 'proxyFieldSet',
        cls: 'nx-form-section',
        title: NX.I18n.get('Repository_Facet_ProxyFacet_Title'),

        items: [
          {
            xtype: 'nx-url',
            itemId: 'remoteUrl',
            name: 'attributes.proxy.remoteUrl',
            fieldLabel: NX.I18n.get('Repository_Facet_ProxyFacet_Remote_FieldLabel'),
            helpText: NX.I18n.get('Repository_Facet_ProxyFacet_Remote_HelpText'),
            emptyText: NX.I18n.get('Repository_Facet_ProxyFacet_Remote_EmptyText'),
            allowBlank: false,
            useTrustStore: function (field) {
              if (Ext.String.startsWith(field.getValue(), 'https://')) {
                return {
                  name: 'attributes.httpclient.connection.useTrustStore',
                  url: field
                };
              }
              return undefined;
            }
          },
          {
            xtype: 'checkbox',
            name: 'attributes.httpclient.blocked',
            fieldLabel: NX.I18n.get('Repository_Facet_ProxyFacet_Blocked_FieldLabel'),
            helpText: NX.I18n.get('Repository_Facet_ProxyFacet_Blocked_HelpText'),
            value: false
          },
          {
            xtype: 'checkbox',
            name: 'attributes.httpclient.autoBlock',
            fieldLabel: NX.I18n.get('Repository_Facet_ProxyFacet_Autoblock_FieldLabel'),
            helpText: NX.I18n.get('Repository_Facet_ProxyFacet_Autoblock_HelpText'),
            value: true
          },
          {
            xtype: 'numberfield',
            name: 'attributes.proxy.contentMaxAge',
            fieldLabel: NX.I18n.get('Repository_Facet_ProxyFacet_ArtifactAge_FieldLabel'),
            helpText: NX.I18n.get('Repository_Facet_ProxyFacet_ArtifactAge_HelpText'),
            minValue: -1,
            value: 1440
          },
          {
            xtype: 'numberfield',
            name: 'attributes.proxy.metadataMaxAge',
            fieldLabel: NX.I18n.get('Repository_Facet_ProxyFacet_MetadataAge_FieldLabel'),
            helpText: NX.I18n.get('Repository_Facet_ProxyFacet_MetadataAge_HelpText'),
            minValue: -1,
            value: 1440
          }
        ]
      }
    ];

    me.callParent();
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Component model.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.model.ComponentPreview', {
  extend: 'Ext.data.Model',
  fields: [
    {name: 'id', type: 'string', sortType: 'asUCText'},
    {name: 'group', type: 'string'},
    {name: 'name', type: 'string'},
    {name: 'version', type: 'string'}
  ]
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Cleanup preview.
 *
 * @since 3.14
 */
Ext.define('NX.coreui.store.CleanupPreview', {
  extend: 'Ext.data.Store',
  model: 'NX.coreui.model.ComponentPreview',

  proxy: {
    type: 'direct',

    api: {
      read: 'NX.direct.cleanup_CleanupPolicy.previewCleanup'
    },

    reader: {
      type: 'json',
      rootProperty: 'data',
      successProperty: 'success'
    }
  },

  remote: true,
  autoLoad: false,

  buffered: true,
  pageSize: 50,

  remoteFilter: true,
  remoteSort: true,

  sorters: { property: 'name', direction: 'ASC' }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Capability "Settings" panel.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.capability.CapabilitySettings', {
  extend: 'NX.view.SettingsPanel',
  alias: 'widget.nx-coreui-capability-settings',

  settingsForm: { xtype: 'nx-coreui-capability-settings-form' }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Configuration for repository cleanup policy facet.
 *
 * @since 3.14
 */
Ext.define('NX.coreui.view.repository.facet.CleanupPolicyFacet', {
  extend: 'Ext.form.FieldContainer',
  alias: 'widget.nx-coreui-repository-cleanup-policy-facet',
  requires: [
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function() {
    var me = this;

    me.items = [
      {
        xtype: 'fieldset',
        cls: 'nx-form-section',
        title: NX.I18n.get('Repository_Facet_CleanupPolicyFacet_Title'),

        defaults: {
          allowBlank: true,
          itemCls: 'required-field'
        },

        items: [
          {
            xtype: 'combo',
            name: 'attributes.cleanup.policyName',
            itemId: 'cleanupPolicyName',
            fieldLabel: NX.I18n.get('Repository_Facet_CleanupPolicyFacet_Policy_FieldLabel'),
            helpText: NX.I18n.get('Repository_Facet_CleanupPolicyFacet_Policy_HelpText'),
            editable: false,
            store: 'CleanupPolicy',
            queryMode: 'local',
            displayField: 'name',
            valueField: 'name',
            listeners: {
              afterrender: function (combo) {
                if (!combo.getValue()) {
                  var store = combo.getStore();
                  if (store.getTotalCount() > 0) {
                    var value = store.getAt(0).get('name');
                    combo.originalValue = value;
                    combo.setValue(value);
                  }
                }
              }
            }
          }
        ]
      }
    ];

    me.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Configuration for repository storage facet.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.repository.facet.StorageFacet', {
  extend: 'Ext.form.FieldContainer',
  alias: 'widget.nx-coreui-repository-storage-facet',
  requires: [
    'NX.I18n'
  ],

  /**
   * @cfg Boolean
   * Set whether or not strict content type validation is enabled for storage, defaults to true.
   */
  strictContentTypeValidation: true,

  /**
   * @override
   */
  initComponent: function() {
    var me = this;


    me.items = [
      {
        xtype: 'fieldset',
        cls: 'nx-form-section',
        title: NX.I18n.get('Repository_Facet_StorageFacet_Title'),

        defaults: {
          allowBlank: false,
          itemCls: 'required-field'
        },

        items: [
          {
            xtype: 'combo',
            name: 'attributes.storage.blobStoreName',
            itemId: 'blobStoreName',
            fieldLabel: NX.I18n.get('Repository_Facet_StorageFacet_BlobStore_FieldLabel'),
            helpText: NX.I18n.get('Repository_Facet_StorageFacet_BlobStore_HelpText'),
            emptyText: NX.I18n.get('Repository_Facet_StorageFacet_BlobStore_EmptyText'),
            editable: false,
            store: 'Blobstore',
            queryMode: 'local',
            displayField: 'name',
            valueField: 'name',
            readOnlyOnUpdate: true,
            listeners: {
              afterrender: function (combo) {
                if (!combo.getValue()) {
                  var store = combo.getStore();
                  if (store.getTotalCount() === 1) {
                    var value = store.getAt(0).get('name');
                    combo.originalValue = value;
                    combo.setValue(value);
                  }
                }
              }
            }
          },
          {
            xtype: 'checkbox',
            name: 'attributes.storage.strictContentTypeValidation',
            itemId: 'strictContentTypeValidation',
            fieldLabel: NX.I18n.get('Repository_Facet_StorageFacet_ContentTypeValidation_FieldLabel'),
            helpText: NX.I18n.get('Repository_Facet_StorageFacet_ContentTypeValidation_HelpText'),
            value: me.strictContentTypeValidation
          }
        ]
      }
    ];

    me.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Repository "Settings" form.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.repository.RepositorySettingsForm', {
  extend: 'NX.view.SettingsForm',
  alias: 'widget.nx-coreui-repository-settings-form',
  requires: [
    'NX.Conditions',
    'NX.I18n',
    'NX.util.Validator'
  ],

  api: {
    submit: 'NX.direct.coreui_Repository.update'
  },

  initComponent: function() {
    var me = this,
        permittedCondition;

    me.settingsFormSuccessMessage = function(data) {
      return NX.I18n.get('Repository_RepositorySettingsForm_Update_Success') + data['name'];
    };

    me.editableMarker = NX.I18n.get('Repository_RepositorySettingsForm_Update_Error');

    if (!me.editableCondition) {
      me.editableCondition = NX.Conditions.and(
          permittedCondition = NX.Conditions.isPermitted('nexus:repository-admin:*:*:edit'),
          NX.Conditions.formHasRecord('nx-coreui-repository-settings-form', function(model) {
            permittedCondition.setPermission(
                'nexus:repository-admin:' + model.get('format') + ':' + model.get('name') + ':edit'
            );
            return true;
          })
      );
    }

    me.items = me.items || [];
    Ext.Array.insert(me.items, 0, [
      {
        xtype: 'fieldset',
        cls: 'nx-form-section nx-no-title',

        items: [
          {
            xtype: 'textfield',
            cls: 'nx-no-border',
            name: 'name',
            itemId: 'name',
            labelAlign: 'left',
            fieldLabel: NX.I18n.get('Repository_RepositorySettingsForm_Name_FieldLabel'),
            helpText: NX.I18n.get('Repository_RepositorySettingsForm_Name_HelpText'),
            readOnly: true,
            allowBlank: false,
            vtype: 'nx-name'
          },
          {
            xtype: 'textfield',
            cls: 'nx-no-border',
            name: 'format',
            itemId: 'format',
            labelAlign: 'left',
            fieldLabel: NX.I18n.get('Repository_RepositorySettingsForm_Format_FieldLabel'),
            helpText: NX.I18n.get('Repository_RepositorySettingsForm_Format_HelpText'),
            readOnly: true
          },
          {
            xtype: 'textfield',
            cls: 'nx-no-border',
            name: 'type',
            itemId: 'type',
            labelAlign: 'left',
            fieldLabel: NX.I18n.get('Repository_RepositorySettingsForm_Type_FieldLabel'),
            helpText: NX.I18n.get('Repository_RepositorySettingsForm_Type_HelpText'),
            readOnly: true
          },

          {
            xtype: 'textfield',
            cls: 'nx-no-border',
            name: 'url',
            itemId: 'url',
            labelAlign: 'left',
            fieldLabel: NX.I18n.get('Repository_RepositorySettingsForm_URL_FieldLabel'),
            helpText: NX.I18n.get('Repository_RepositorySettingsForm_URL_HelpText'),
            readOnly: true
          },
          {
            xtype: 'checkbox',
            name: 'online',
            itemId: 'online',
            labelAlign: 'left',
            fieldLabel: NX.I18n.get('Repository_RepositorySettingsForm_Online_FieldLabel'),
            helpText: NX.I18n.get('Repository_RepositorySettingsForm_Online_HelpText'),
            value: true
          }
        ]
      }
    ]);

    me.callParent();

    //map repository attributes raw map structure to/from a flattened representation
    Ext.override(me.getForm(), {
      getValues: function() {
        return me.doGetValues(this.callParent(arguments));
        },
      setValues: function(values) { 
        me.doSetValues(values);
        this.callParent(arguments);
      }
    });
  },

  doGetValues: function(values) {
    var processed = { attributes: {} };

    Ext.Object.each(values, function(key, value) {
      var segments = key.split('.'),
          parent = processed;

      Ext.each(segments, function(segment, pos) {
        if (pos === segments.length - 1) {
          parent[segment] = value;
        }
        else {
          if (!parent[segment]) {
            parent[segment] = {};
          }
          parent = parent[segment];
        }
      });
    });

    return processed;
  },

  doSetValues: function(values) {
    var process = function(child, prefix) {
      Ext.Object.each(child, function(key, value) {
        var newPrefix = (prefix ? prefix + '.' : '') + key;
        if (Ext.isObject(value)) {
          process(value, newPrefix);
        }
        else {
          values[newPrefix] = value;
        }
      });
    };

    process(values);
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Configuration for repository storage write policy.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.repository.facet.StorageFacetHosted', {
  extend: 'Ext.form.FieldContainer',
  alias: 'widget.nx-coreui-repository-storage-hosted-facet',
  requires: [
    'NX.I18n'
  ],

  defaults: {
    allowBlank: false,
    itemCls: 'required-field'
  },

  /**
   * @cfg String
   * Set the write policy of storage, defaults to ALLOW_ONCE.
   */
  writePolicy: 'ALLOW_ONCE',

  /**
   * @override
   */
  initComponent: function() {
    var me = this;

    me.items = [
      {
        xtype: 'fieldset',
        cls: 'nx-form-section',
        title: NX.I18n.get('Repository_Facet_StorageFacetHosted_Title'),

        items: [
          {
            xtype: 'combo',
            name: 'attributes.storage.writePolicy',
            itemId: 'writePolicy',
            fieldLabel: NX.I18n.get('Repository_Facet_StorageFacetHosted_Deployment_FieldLabel'),
            helpText: NX.I18n.get('Repository_Facet_StorageFacetHosted_Deployment_HelpText'),
            emptyText: NX.I18n.get('Repository_Facet_StorageFacetHosted_Deployment_EmptyText'),
            editable: false,
            store: [
              ['ALLOW', NX.I18n.get('Repository_Facet_StorageFacetHosted_Deployment_AllowItem')],
              ['ALLOW_ONCE', NX.I18n.get('Repository_Facet_StorageFacetHosted_Deployment_DisableItem')],
              ['DENY', NX.I18n.get('Repository_Facet_StorageFacetHosted_Deployment_ReadOnlyItem')]
            ],
            value: me.writePolicy,
            queryMode: 'local'
          }
        ]
      }
    ];

    me.callParent();
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Repository "Settings" form for a npm Hosted repository.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.repository.recipe.NpmHosted', {
  extend: 'NX.coreui.view.repository.RepositorySettingsForm',
  alias: 'widget.nx-coreui-repository-npm-hosted',
  requires: [
    'NX.coreui.view.repository.facet.StorageFacet',
    'NX.coreui.view.repository.facet.StorageFacetHosted',
    'NX.coreui.view.repository.facet.CleanupPolicyFacet'
  ],

  /**
   * @override
   */
  initComponent: function() {
    var me = this;

    me.items = [
      { xtype: 'nx-coreui-repository-storage-facet'},
      { xtype: 'nx-coreui-repository-storage-hosted-facet'},
      { xtype: 'nx-coreui-repository-cleanup-policy-facet'}
    ];

    me.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Migration preview screen.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.migration.PreviewScreen', {
  extend: 'NX.wizard.GridScreen',
  alias: 'widget.nx-coreui-migration-preview',
  requires: [
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    Ext.apply(me, {
      title: NX.I18n.render(me, 'Title'),

      description: NX.I18n.render(me, 'Description'),

      grid: {
        xtype: 'grid',

        viewConfig: {
          stripeRows: true
        },

        hideHeaders: true,

        columns: [
          {
            xtype: 'nx-iconcolumn',
            width: 36,
            iconVariant: 'x16',
            iconName: function (value, meta, record) {
              var state = record.get('state');
              switch (state) {
                case 'INITIALIZED':
                  return 'migration-step-pending';

                default:
                  return 'migration-step-error';
              }
            }
          },
          {
            header: NX.I18n.render(me, 'Name_Column'),
            dataIndex: 'name',
            flex: 1
          },
          {
            header: NX.I18n.render(me, 'State_Column'),
            dataIndex: 'state'
          }
        ],

        store: 'NX.coreui.migration.PreviewStore',

        features: [
          {
            ftype: 'grouping',
            collapsible: false,
            enableGroupingMenu: false
          }
        ]
      },

      buttons: [
        'back',
        {
          text: NX.I18n.render(me, 'Begin_Button'),
          action: 'begin',
          ui: 'nx-primary',
          disabled: true
        },
        'cancel'
      ]
    });

    me.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Migration preview step.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.migration.PreviewStep', {
  extend: 'NX.wizard.Step',
  requires: [
    'NX.coreui.migration.PreviewScreen'
  ],

  config: {
    screen: 'NX.coreui.migration.PreviewScreen',
    enabled: true
  },

  resetOnBack: true,

  /**
   * @override
   */
  init: function () {
    var me = this;

    me.control({
      'button[action=back]': {
        click: me.moveBack
      },
      'button[action=begin]': {
        click: me.doBegin
      },
      'button[action=cancel]': {
        click: me.cancel
      },
      'gridpanel': {
        cellclick: me.doDisplayDetail
      }
    });
  },

  /**
   * @override
   */
  prepare: function () {
    var preview = this.get('plan-preview'),
        store = this.getStore('NX.coreui.migration.PreviewStore');

    store.loadData(preview.steps, false);

    // if plan-preview is valid, then enable begin button
    if (preview.valid) {
      this.getScreenCmp().down('button[action=begin]').enable();
    }
  },

  /**
   * @override
   */
  reset: function () {
    var me = this,
        screen = me.getScreenCmp();

    if (screen) {
      screen.down('button[action=begin]').disable();
    }

    me.getStore('NX.coreui.migration.PreviewStore').removeAll(true);
    me.callParent();
  },

  /**
   * @private
   */
  doBegin: function () {
    var me = this;

    NX.Dialogs.askConfirmation(
        NX.I18n.render(me, 'Begin_Confirm_Title'),
        NX.I18n.render(me, 'Begin_Confirm_Text'),
        function () {
          me.mask(NX.I18n.render(me, 'Begin_Mask'));

          NX.direct.migration_Assistant.prepare(function (response, event) {
            me.unmask();

            if (event.status && response.success) {
              me.moveNext();

              NX.Messages.success(NX.I18n.render(me, 'Begin_Message'));
            }
          });
        }
    );
  },

  /**
   *@private
   */
  doDisplayDetail: function (grid, td, cellIndex, record) {
    this.controller.displayPlanStepDetail(record.get('id'));
    return false;
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Loggers grid.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.logging.LoggerList', {
  extend: 'Ext.grid.Panel',
  alias: 'widget.nx-coreui-logger-list',
  requires: [
    'NX.I18n'
  ],

  stateful: true,
  stateId: 'nx-coreui-logger-list',

  /**
   * @override
   */
  initComponent: function() {
    Ext.apply(this, {
      store: 'Logger',

      columns: [
        {
          xtype: 'nx-iconcolumn',
          width: 36,
          iconVariant: 'x16',
          iconName: function () {
            return 'logger-default';
          }
        },
        {
          header: NX.I18n.get('Logging_LoggerList_Name_Header'),
          dataIndex: 'name',
          stateId: 'name',
          hideable: false,
          flex: 1,
          renderer: Ext.htmlEncode
        },
        {
          header: NX.I18n.get('Logging_LoggerList_Level_Header'),
          dataIndex: 'level',
          stateId: 'level',
          hideable: false,
          editor: {
            xtype: 'combo',
            editable: false,
            store: [
              ['TRACE', NX.I18n.get('Logging_LoggerList_Level_TraceItem')],
              ['DEBUG', NX.I18n.get('Logging_LoggerList_Level_DebugItem')],
              ['INFO', NX.I18n.get('Logging_LoggerList_Level_InfoItem')],
              ['WARN', NX.I18n.get('Logging_LoggerList_Level_WarnItem')],
              ['ERROR', NX.I18n.get('Logging_LoggerList_Level_ErrorItem')],
              ['OFF', NX.I18n.get('Logging_LoggerList_Level_OffItem')],
              ['DEFAULT', NX.I18n.get('Logging_LoggerList_Level_DefaultItem')]
            ],
            queryMode: 'local'
          }
        }
      ],

      viewConfig: {
        emptyText: NX.I18n.get('Logging_LoggerList_EmptyText'),
        deferEmptyText: false
      },

      dockedItems: [
        {
          xtype: 'nx-actions',
          items: [
            {
              xtype: 'button',
              text: NX.I18n.get('Logging_LoggerList_New_Button'),
              glyph: 'xf055@FontAwesome' /* fa-plus-circle */,
              action: 'new',
              disabled: true
            },
            {
              xtype: 'button',
              text: NX.I18n.get('Logging_LoggerList_Delete_Button'),
              glyph: 'xf1f8@FontAwesome' /* fa-trash */,
              action: 'delete',
              disabled: true
            },
            '-',
            {
              xtype: 'button',
              text: NX.I18n.get('Logging_LoggerList_Reset_Button'),
              glyph: 'xf0e2@FontAwesome' /* fa-undo */,
              action: 'reset',
              disabled: true
            }
          ]
        }
      ],

      plugins: [{
        pluginId: 'editor',
        ptype: 'rowediting',
        clicksToEdit: 1,
        errorSummary: false
      }, {
        ptype: 'gridfilterbox',
        emptyText: NX.I18n.get('Logging_LoggerList_Filter_EmptyText')
      }]
    });

    this.callParent();
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Bundles feature panel.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.system.Bundles', {
  extend: 'NX.view.drilldown.Drilldown',
  alias: 'widget.nx-coreui-system-bundles',
  requires: [
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function() {
    Ext.apply(this, {
      iconName: 'bundle-default',

      masters: [
        { xtype: 'nx-coreui-system-bundlelist' }
      ],

      tabs: {
        xtype: 'nx-info-panel',
        title: NX.I18n.get('System_Bundles_Details_Tab'),
        cls: 'nx-hr'
      }
    });

    this.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Configuration specific to Http connections for repositories.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.repository.facet.HttpClientFacet', {
  extend: 'Ext.form.FieldContainer',
  alias: 'widget.nx-coreui-repository-httpclient-facet',
  requires: [
    'NX.I18n'
  ],
  /**
   * @override
   */
  initComponent: function() {
    var me = this;

    me.items = [
      {
        xtype: 'fieldset',
        cls: 'nx-form-section',
        title: NX.I18n.get('Repository_Facet_HttpClientFacet_Title'),

        items: [
          {
            xtype: 'nx-optionalfieldset',
            title: NX.I18n.get('Repository_Facet_HttpClientFacet_Authentication_Title'),
            checkboxToggle: true,
            checkboxName: 'authEnabled',
            collapsed: true,
            items: [
              {
                xtype: 'combo',
                name: 'attributes.httpclient.authentication.type',
                fieldLabel: NX.I18n.get('Repository_Facet_HttpClientFacet_AuthenticationType_FieldLabel'),
                editable: false,
                store: [
                  ['username', NX.I18n.get('Repository_Facet_HttpClientFacet_AuthenticationType_Username')],
                  ['ntlm', NX.I18n.get('Repository_Facet_HttpClientFacet_AuthenticationType_NTLM')]
                ],
                value: 'username' ,
                listeners: {
                  'change': function(combo) {
                    var ntlmFields = this.up('form').down('#ntlmFields');

                    if(combo.getValue() === 'ntlm') {
                      ntlmFields.show();
                      ntlmFields.enable();
                    }
                    else {
                      ntlmFields.hide();
                      ntlmFields.disable();
                    }
                  }
                }
              },
              {
                xtype:'textfield',
                name: 'attributes.httpclient.authentication.username',
                fieldLabel: NX.I18n.get('System_AuthenticationSettings_Username_FieldLabel'),
                allowBlank: false
              },
              {
                xtype: 'textfield',
                inputType: 'password',
                name: 'attributes.httpclient.authentication.password',
                fieldLabel: NX.I18n.get('System_AuthenticationSettings_Password_FieldLabel'),
                allowBlank: false
              },
              {
                xtype: 'fieldcontainer',
                itemId: 'ntlmFields',
                hidden: true,
                items:[
                  {
                    xtype:'textfield',
                    name: 'attributes.httpclient.authentication.ntlmHost',
                    fieldLabel: NX.I18n.get('System_AuthenticationSettings_WindowsNtlmHostname_FieldLabel')
                  },
                  {
                    xtype:'textfield',
                    name: 'attributes.httpclient.authentication.ntlmDomain',
                    fieldLabel: NX.I18n.get('System_AuthenticationSettings_WindowsNtlmDomain_FieldLabel')
                  }
                ]
              }
            ]
          },
          {
            xtype: 'nx-optionalfieldset',
            title: NX.I18n.get('Repository_Facet_HttpClientFacet_HTTP_Title'),
            checkboxToggle: true,
            checkboxName: 'httpRequestSettings',
            collapsed: true,
            items: [
              {
                xtype: 'textfield',
                name: 'attributes.httpclient.connection.userAgentSuffix',
                fieldLabel: NX.I18n.get('System_HttpRequestSettings_UserAgentCustomization_FieldLabel'),
                helpText: NX.I18n.get('System_HttpRequestSettings_UserAgentCustomization_HelpText')
              },
              {
                xtype: 'numberfield',
                name: 'attributes.httpclient.connection.retries',
                fieldLabel: NX.I18n.get('Repository_Facet_HttpClientFacet_ConnectionRetries_FieldLabel'),
                helpText: NX.I18n.get('Repository_Facet_HttpClientFacet_ConnectionRetries_HelpText'),
                allowDecimals: false,
                allowExponential: false,
                minValue: 0,
                maxValue: 10
              },
              {
                xtype: 'numberfield',
                name: 'attributes.httpclient.connection.timeout',
                fieldLabel: NX.I18n.get('Repository_Facet_HttpClientFacet_ConnectionTimeout_FieldLabel'),
                helpText: NX.I18n.get('Repository_Facet_HttpClientFacet_ConnectionTimeout_HelpText'),
                allowDecimals: false,
                allowExponential: false,
                minValue: 0,
                maxValue: 3600
              },
              {
                xtype: 'checkbox',
                name: 'attributes.httpclient.connection.enableCircularRedirects',
                fieldLabel: NX.I18n.get('Repository_Facet_HttpClientFacet_EnableCircularRedirects_FieldLabel'),
                helpText: NX.I18n.get('Repository_Facet_HttpClientFacet_EnableCircularRedirects_HelpText')
              },
              {
                xtype: 'checkbox',
                name: 'attributes.httpclient.connection.enableCookies',
                fieldLabel: NX.I18n.get('Repository_Facet_HttpClientFacet_EnableCookies_FieldLabel'),
                helpText: NX.I18n.get('Repository_Facet_HttpClientFacet_EnableCookies_HelpText')
              }
            ]
          }
        ]
      }
    ];

    me.callParent();
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Configuration specific to Http connections for repositories.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.repository.facet.NegativeCacheFacet', {
  extend: 'Ext.form.FieldContainer',
  alias: 'widget.nx-coreui-repository-negativecache-facet',
  requires: [
    'NX.I18n'
  ],

  defaults: {
    itemCls: 'required-field'
  },

  /**
   * @override
   */
  initComponent: function() {
    var me = this;

    me.items = [
      {
        xtype: 'fieldset',
        cls: 'nx-form-section',
        title: NX.I18n.get('Repository_Facet_NegativeCacheFacet_Title'),

        items: [
          {
            xtype: 'checkbox',
            name: 'attributes.negativeCache.enabled',
            fieldLabel: NX.I18n.get('Repository_Facet_NegativeCacheFacet_Enabled_FieldLabel'),
            helpText: NX.I18n.get('Repository_Facet_NegativeCacheFacet_Enabled_HelpText'),
            value: true
          },
          {
            xtype: 'numberfield',
            name: 'attributes.negativeCache.timeToLive',
            fieldLabel: NX.I18n.get('Repository_Facet_NegativeCacheFacet_TTL_FieldLabel'),
            helpText: NX.I18n.get('Repository_Facet_NegativeCacheFacet_TTL_HelpText'),
            minValue: -1,
            value: 1440
          }
        ]
      }
    ];

    me.callParent();
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Repository "Settings" form for an Npm Proxy repository
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.repository.recipe.NpmProxy', {
  extend: 'NX.coreui.view.repository.RepositorySettingsForm',
  alias: 'widget.nx-coreui-repository-npm-proxy',
  requires: [
    'NX.coreui.view.repository.facet.ProxyFacet',
    'NX.coreui.view.repository.facet.StorageFacet',
    'NX.coreui.view.repository.facet.HttpClientFacet',
    'NX.coreui.view.repository.facet.NegativeCacheFacet',
    'NX.coreui.view.repository.facet.CleanupPolicyFacet'
  ],

  /**
   * @override
   */
  initComponent: function() {
    var me = this;

    me.items = [
      {xtype: 'nx-coreui-repository-proxy-facet'},
      {xtype: 'nx-coreui-repository-storage-facet'},
      {xtype: 'nx-coreui-repository-negativecache-facet'},
      {xtype: 'nx-coreui-repository-cleanup-policy-facet'},
      {xtype: 'nx-coreui-repository-httpclient-facet'}
    ];

    me.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Task "Settings" form.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.task.TaskSettingsForm', {
  extend: 'NX.view.SettingsForm',
  alias: 'widget.nx-coreui-task-settings-form',
  requires: [
    'NX.Conditions',
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function() {
    var me = this;

    me.items = [
      {
        xtype: 'hiddenfield',
        name: 'id'
      },
      {
        xtype: 'hiddenfield',
        name: 'typeId'
      },
      {
        xtype: 'checkbox',
        fieldLabel: NX.I18n.get('Task_TaskSettingsForm_Enabled_FieldLabel'),
        helpText: NX.I18n.get('Task_TaskSettingsForm_Enabled_HelpText'),
        name: 'enabled',
        allowBlank: false,
        checked: true,
        editable: true
      },
      {
        name: 'name',
        fieldLabel: NX.I18n.get('Task_TaskSettingsForm_Name_FieldLabel'),
        helpText: NX.I18n.get('Task_TaskSettingsForm_Name_HelpText'),
        transformRawValue: Ext.htmlDecode
      },
      {
        xtype: 'nx-email',
        name: 'alertEmail',
        fieldLabel: NX.I18n.get('Task_TaskSettingsForm_Email_FieldLabel'),
        helpText: NX.I18n.get('Task_TaskSettingsForm_Email_HelpText'),
        allowBlank: true
      },
      { xtype: 'nx-coreui-formfield-settingsfieldset' },
      { xtype: 'nx-coreui-task-schedulefieldset' }
    ];

    me.editableMarker = NX.I18n.get('Task_TaskSettingsForm_Update_Error');

    me.editableCondition = me.editableCondition || NX.Conditions.and(
      NX.Conditions.isPermitted('nexus:tasks:update'),
      NX.Conditions.formHasRecord('nx-coreui-task-settings-form', function (model) {
        return model.get('schedule') !== 'internal';
      })
    );

    me.callParent();
  },

  /**
   * @override
   * Additionally, gets value of properties.
   */
  getValues: function() {
    var me = this,
      values = me.getForm().getFieldValues(),
      task = {
        id: values.id,
        typeId: values.typeId,
        enabled: values.enabled ? true : false,
        name: values.name,
        alertEmail: values.alertEmail,
        schedule: values.schedule
      };

    task.properties = me.down('nx-coreui-formfield-settingsfieldset').exportProperties(values);
    task.recurringDays = me.down('nx-coreui-task-schedulefieldset').getRecurringDays();
    task.startDate = me.down('nx-coreui-task-schedulefieldset').getStartDate();
    if (task.startDate) {
      task.startDate = task.startDate.toJSON();
    }

    if (task.schedule === 'advanced') {
      task.cronExpression = values.cronExpression;
    }

    return task;
  },

  /**
   * @override
   * Additionally, sets properties values.
   */
  loadRecord: function(model) {
    var me = this,
        taskTypeModel = NX.getApplication().getStore('TaskType').getById(model.get('typeId')),
        settingsFieldSet = me.down('nx-coreui-formfield-settingsfieldset'),
        scheduleFieldSet = me.down('nx-coreui-task-schedulefieldset'),
        formFields;

    this.callParent(arguments);

    this.resetTaskForm();

    if (taskTypeModel) {
      formFields = taskTypeModel.get('formFields');

      Ext.each(formFields, function(field) {
        var properties = model.get('properties');
        if (properties && !properties.hasOwnProperty(field.id)) {
          properties[field.id] = null;
          model.set('properties', properties, { dirty: false });
        }
      });

      settingsFieldSet.importProperties(model.get('properties'), formFields);
      scheduleFieldSet.setRecurringDays(model.get('recurringDays'));
      scheduleFieldSet.setStartDate(model.get('startDate'));
    }
  },

  /**
   * To Reset Task Form including Days to run checkboxes.
   */
  resetTaskForm: function() {
    var me = this,
        checkboxes = me.query('checkbox[recurringDayValue]');

    Ext.Array.each(checkboxes, function(checkbox) {
      checkbox.originalValue = false;
    });
    me.form.reset();
  },

  /**
   * @override
   * Additionally, marks invalid properties.
   */
  markInvalid: function(errors) {
    this.down('nx-coreui-formfield-settingsfieldset').markInvalid(errors);
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Task "Settings" panel.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.task.TaskSettings', {
  extend: 'NX.view.SettingsPanel',
  alias: 'widget.nx-coreui-task-settings',

  settingsForm: { xtype: 'nx-coreui-task-settings-form' }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Repository grid.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.repository.RepositoryListTemplate', {
  extend: 'NX.view.drilldown.Master',
  alias: 'widget.nx-coreui-repository-list-template',
  requires: [
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function() {
    var me = this;

    me.columns = [
      {
        xtype: 'nx-iconcolumn',
        width: 36,
        iconVariant: 'x16',
        iconNamePrefix: 'repository-',
        dataIndex: 'type'
      },
      {
        text: NX.I18n.get('Repository_RepositoryList_Name_Header'),
        dataIndex: 'name',
        stateId: 'name',
        flex: 1,
        renderer: Ext.htmlEncode
      },
      {
        text: NX.I18n.get('Repository_RepositoryList_Type_Header'),
        dataIndex: 'type',
        stateId: 'type',
        renderer: Ext.htmlEncode
      },
      {
        text: NX.I18n.get('Repository_RepositoryList_Format_Header'),
        dataIndex: 'format',
        stateId: 'format',
        renderer: Ext.htmlEncode
      },
      {
        header: NX.I18n.get('Repository_RepositoryList_Status_Header'), dataIndex: 'status', stateId: 'status', flex: 1,
        xtype: 'templatecolumn',
        tpl: new Ext.XTemplate(
          '<tpl if="status.online">',
          'Online',
          '<tpl else>',
          'Offline',
          '</tpl>',
          '<tpl if="status.description">',
          ' - {status.description}',
          '</tpl>',
          '<tpl if="status.reason">',
          '<br/><i>{status.reason}</i>',
          '</tpl>')
      },
      {
        xtype: 'nx-copylinkcolumn',
        header: NX.I18n.get('Repository_RepositoryList_URL_Header'),
        dataIndex: 'url'
      }
    ];

    me.viewConfig = {
      emptyText: NX.I18n.get('Repository_RepositoryList_EmptyText'),
      deferEmptyText: false,
      markDirty: false
    };

    me.plugins = [
      {
        ptype: 'gridfilterbox',
        emptyText: NX.I18n.get('Repository_RepositoryList_Filter_EmptyText')
      }
    ];

    me.callParent();
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Repository grid.
 *
 * @since 3.8
 */
Ext.define('NX.coreui.view.upload.UploadRepositoryList', {
  extend: 'NX.coreui.view.repository.RepositoryListTemplate',
  alias: 'widget.nx-coreui-upload-repository-list',
  requires: [
    'NX.I18n'
  ],

  stateful: true,
  stateId: 'nx-coreui-upload-repository-list',

  store: 'RepositoryReference',

  tbar: {
    xtype: 'nx-actions'
  },

  listeners: {
    beforedestroy: function(element) {
      element.getStore().clearFilter();
    }
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * SMTP System Settings form.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.system.SmtpSettings', {
  extend: 'NX.view.SettingsPanel',
  alias: 'widget.nx-coreui-system-smtp-settings',
  requires: [
    'NX.Conditions',
    'NX.I18n',
    'NX.ext.form.field.Hostname'
  ],

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    me.settingsForm = [
      {
        xtype: 'nx-settingsform',
        settingsFormSuccessMessage: NX.I18n.get('System_SmtpSettings_Update_Success'),
        api: {
          load: 'NX.direct.coreui_Email.read',
          submit: 'NX.direct.coreui_Email.update'
        },
        editableCondition: NX.Conditions.isPermitted('nexus:settings:update'),
        editableMarker: NX.I18n.get('System_SmtpSettings_Update_Error'),

        items: [
          {
            xtype: 'checkbox',
            name: 'enabled',
            fieldLabel: NX.I18n.get('System_SmtpSettings_Enabled_FieldLabel')
          },
          {
            xtype: 'nx-hostname',
            name: 'host',
            itemId: 'host',
            fieldLabel: NX.I18n.get('System_SmtpSettings_Host_FieldLabel')
          },
          {
            xtype: 'numberfield',
            name: 'port',
            itemId: 'port',
            fieldLabel: NX.I18n.get('System_SmtpSettings_Port_FieldLabel'),
            minValue: 1,
            maxValue: 65536,
            allowDecimals: false,
            allowExponential: false,
            useTrustStore: function (field) {
              var form = field.up('form');
              return {
                name: 'nexusTrustStoreEnabled',
                host: form.down('#host'),
                port: form.down('#port')
              };
            }
          },
          {
            xtype: 'textfield',
            name: 'username',
            fieldLabel: NX.I18n.get('System_SmtpSettings_Username_FieldLabel'),
            allowBlank: true,
            inputAttrTpl: 'autocomplete="new-username"'
          },
          {
            xtype: 'nx-password',
            name: 'password',
            fieldLabel: NX.I18n.get('System_SmtpSettings_Password_FieldLabel'),
            allowBlank: true,
            inputAttrTpl: 'autocomplete="new-password"'
          },
          {
            xtype: 'nx-email',
            name: 'fromAddress',
            fieldLabel: NX.I18n.get('System_SmtpSettings_FromAddress_FieldLabel')
          },
          {
            xtype: 'textfield',
            name: 'subjectPrefix',
            fieldLabel: NX.I18n.get('System_SmtpSettings_SubjectPrefix_FieldLabel'),
            allowBlank: true
          },
          {
            xtype: 'checkboxgroup',
            fieldLabel: NX.I18n.get('System_SmtpSettings_SslTlsSection_FieldLabel'),
            columns: 1,
            allowBlank: true,
            items: [
              {
                xtype: 'checkbox',
                name: 'startTlsEnabled',
                boxLabel: NX.I18n.get('System_SmtpSettings_StartTlsEnabled_FieldLabel')
              },
              {
                xtype: 'checkbox',
                name: 'startTlsRequired',
                boxLabel: NX.I18n.get('System_SmtpSettings_StartTlsRequired_FieldLabel')
              },
              {
                xtype: 'checkbox',
                name: 'sslOnConnectEnabled',
                boxLabel: NX.I18n.get('System_SmtpSettings_SslOnConnectEnabled_FieldLabel')
              },
              {
                xtype: 'checkbox',
                name: 'sslCheckServerIdentityEnabled',
                boxLabel: NX.I18n.get('System_SmtpSettings_SslCheckServerIdentityEnabled_FieldLabel')
              }
            ]
          }
        ]
      }
    ];

    me.callParent();

    me.down('nx-settingsform').getDockedItems('toolbar[dock="bottom"]')[0].add({
      xtype: 'button',
      text: NX.I18n.get('System_SmtpSettings_VerifyServer_Button'),
      formBind: true,
      action: 'verify',
      glyph: 'xf003@FontAwesome' /* fa-envelope-o */
    });
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Privilege feature panel.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.privilege.PrivilegeFeature', {
  extend: 'NX.view.drilldown.Drilldown',
  alias: 'widget.nx-coreui-privilege-feature',
  requires: [
    'NX.I18n'
  ],

  iconName: 'privilege-default',

  masters: [
    { xtype: 'nx-coreui-privilege-list' }
  ],

  /**
   * @override
   */
  initComponent: function() {
    var me = this;

    Ext.apply(me, {
      tabs: {
        xtype: 'nx-coreui-privilege-settings',
        title: NX.I18n.get('Privilege_PrivilegeFeature_Settings_Title'),
        weight: 10
      },

      nxActions: [
        { xtype: 'button', text: NX.I18n.get('Privilege_PrivilegeFeature_Delete_Button'), glyph: 'xf1f8@FontAwesome' /* fa-trash */, action: 'delete', disabled: true }
      ]
    });

    me.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Generic reference (id/name) model.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.model.Reference', {
  extend: 'Ext.data.Model',
  fields: [
    {name: 'id', type: 'string', sortType: 'asUCText'},
    {name: 'name', type: 'string', sortType: 'asUCText'}
  ]
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Repository Recipe store.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.store.RepositoryRecipe', {
  extend: 'Ext.data.Store',
  model: 'NX.coreui.model.Reference',

  proxy: {
    type: 'direct',
    paramsAsHash: false,

    api: {
      read: 'NX.direct.coreui_Repository.readRecipes'
    },

    reader: {
      type: 'json',
      rootProperty: 'data',
      successProperty: 'success'
    }
  },

  sorters: { property: 'name', direction: 'ASC' }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Repository "Settings" form for a Rubygems Proxy repository
 *
 * @since 3.1
 */
Ext.define('NX.coreui.view.repository.recipe.RubygemsProxy', {
  extend: 'NX.coreui.view.repository.RepositorySettingsForm',
  alias: 'widget.nx-coreui-repository-rubygems-proxy',
  requires: [
    'NX.coreui.view.repository.facet.ProxyFacet',
    'NX.coreui.view.repository.facet.StorageFacet',
    'NX.coreui.view.repository.facet.HttpClientFacet',
    'NX.coreui.view.repository.facet.NegativeCacheFacet',
    'NX.coreui.view.repository.facet.CleanupPolicyFacet'
  ],

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    me.items = [
      {xtype: 'nx-coreui-repository-proxy-facet'},
      {xtype: 'nx-coreui-repository-storage-facet'},
      {xtype: 'nx-coreui-repository-negativecache-facet'},
      {xtype: 'nx-coreui-repository-cleanup-policy-facet'},
      {xtype: 'nx-coreui-repository-httpclient-facet'}
    ];

    me.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Raw repository search contribution.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.controller.SearchRaw', {
  extend: 'NX.app.Controller',
  requires: [
    'NX.I18n'
  ],

  /**
   * @override
   */
  init: function() {
    var me = this,
        search = me.getController('NX.coreui.controller.Search');

    search.registerFilter({
      id: 'raw',
      name: 'Raw',
      text: NX.I18n.get('SearchRaw_Text'),
      description: NX.I18n.get('SearchRaw_Description'),
      readOnly: true,
      criterias: [
        { id: 'format', value: 'raw', hidden: true },
        { id: 'name.raw' }
      ]
    }, me);
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Repository reference model.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.model.RepositoryReference', {
  extend: 'Ext.data.Model',
  fields: [
    {name: 'id', type: 'string', sortType: 'asUCText'},
    {name: 'name', type: 'string', sortType: 'asUCText'},
    {name: 'type', type: 'string', sortType: 'asUCText'},
    {name: 'format', type: 'string', sortType: 'asUCText'},
    {name: 'versionPolicy', type: 'string', sortType: 'asUCText'},
    {name: 'status', type: 'auto' /*object*/},
    {name: 'url', type: 'string', sortType: 'asUCText'},
    {name: 'sortOrder', sortType: 'asInt'}
  ]
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * URL related utils.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.util.RepositoryUrls', {
  singleton: true,
  requires: [
    'NX.util.Url',
    'NX.Assert'
  ],

  mixins: {
    logAware: 'NX.LogAware'
  },

  /**
   * Strategies for building urls to download assets.
   *
   * @private
   */
  repositoryUrlStrategies: {
    maven2: function (assetModel) {
      var repositoryName = assetModel.get('repositoryName'),
          assetName = assetModel.get('name');
      return NX.util.Url.asLink(NX.util.Url.baseUrl + '/repository/' + encodeURIComponent(repositoryName) + '/' + encodeURI(assetName), assetName);
    },
    npm: function (assetModel) {
      var repositoryName = assetModel.get('repositoryName'),
          assetName = assetModel.get('name');
      return NX.util.Url.asLink(NX.util.Url.baseUrl + '/repository/' + encodeURIComponent(repositoryName) + '/' + encodeURI(assetName), assetName);
    },
    nuget: function (assetModel) {
      var repositoryName = assetModel.get('repositoryName'),
          assetName = assetModel.get('name');
      return NX.util.Url.asLink(NX.util.Url.baseUrl + '/repository/' + encodeURIComponent(repositoryName) + '/' + encodeURI(assetName), assetName);
    },
    raw: function (assetModel) {
      var repositoryName = assetModel.get('repositoryName'),
          assetName = assetModel.get('name');
      return NX.util.Url.asLink(NX.util.Url.baseUrl + '/repository/' + encodeURIComponent(repositoryName) + '/' + encodeURI(assetName), assetName);
    },
    rubygems: function (assetModel) {
      var repositoryName = assetModel.get('repositoryName'),
          assetName = assetModel.get('name');
      return NX.util.Url.asLink(NX.util.Url.baseUrl + '/repository/' + encodeURIComponent(repositoryName) + '/' + encodeURI(assetName), assetName);
    },
    docker: function (assetModel) {
      var repositoryName = assetModel.get('repositoryName'),
          assetName = assetModel.get('name');
      return NX.util.Url.asLink(NX.util.Url.baseUrl + '/repository/' + encodeURIComponent(repositoryName) + '/' + encodeURI(assetName), assetName);
    },
    bower: function (assetModel) {
      var repositoryName = assetModel.get('repositoryName'),
          assetName = assetModel.get('name');
      return NX.util.Url.asLink(NX.util.Url.baseUrl + '/repository/' + encodeURIComponent(repositoryName) + '/' + encodeURI(assetName), assetName);
    },
    pypi: function (assetModel) {
      var repositoryName = assetModel.get('repositoryName'),
          assetName = assetModel.get('name');
      return NX.util.Url.asLink(NX.util.Url.baseUrl + '/repository/' + encodeURIComponent(repositoryName) + '/' + encodeURI(assetName), assetName);
    },
    yum: function (assetModel) {
      var repositoryName = assetModel.get('repositoryName'),
          assetName = assetModel.get('name');
      return NX.util.Url.asLink(NX.util.Url.baseUrl + '/repository/' + encodeURIComponent(repositoryName) + '/' + encodeURI(assetName), assetName);
    },
    gitlfs: function (assetModel) {
      var repositoryName = assetModel.get('repositoryName'),
          assetName = assetModel.get('name');
      return NX.util.Url.asLink(NX.util.Url.baseUrl + '/repository/' + encodeURIComponent(repositoryName) + '/' + encodeURI(assetName), assetName);
    }
  },

  /**
   * Add a strategy to build repository download links for a particular strategy.
   *
   * @public
   */
  addRepositoryUrlStrategy: function (format, strategy) {
    this.repositoryUrlStrategies[format] = strategy;
  },

  /**
   * Creates a link to an asset in a repository.
   *
   * @public
   * @param {Object} assetModel the asset to create a link for
   * @param {String} format the format of the repository storing this asset
   */
  asRepositoryLink: function (assetModel, format) {
    //<if assert>
//    NX.Assert.assert(assetModel, 'Expected an assetModel with format: ' + format);
    //</if>
    //<if debug>
//    this.logTrace('Creating link for format and asset:', format, assetModel.get('name'));
    //</if>

    var linkStrategy = this.repositoryUrlStrategies[format];
    return linkStrategy(assetModel);
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Component helper utils.
 *
 * @since 3.14
 */

Ext.define('NX.coreui.mixin.ComponentUtils', {
  requires: [
    'NX.Bookmarks',
    'NX.Dialogs',
    'NX.I18n',
    'NX.Messages'
  ],

  /**
   * Open the analyze application form window
   *
   */
  openAnalyzeApplicationWindow: function() {
    var me = this,
        componentModel = me.fetchComponentModelFromView();

    function doOpenAnalyzeWindow(response) {
      var widget = Ext.widget('nx-coreui-component-analyze-window');
      var form = widget.down('form');
      form.getForm().setValues(response.data);
      //I am setting the original value so it won't be marked dirty unless user touches it
      form.down('textfield[name="reportLabel"]').originalValue = response.data.reportLabel;

      var assetKeys = response.data.assetMap ? Ext.Object.getKeys(response.data.assetMap) : [];

      if (assetKeys.length < 1) {
        widget.close();
        NX.Dialogs.showError(NX.I18n.get('AnalyzeApplicationWindow_No_Assets_Error_Title'),
            NX.I18n.get('AnalyzeApplicationWindow_No_Assets_Error_Message'));
      }
      else if (assetKeys.length === 1) {
        widget.down('combo[name="asset"]').setValue(response.data.selectedAsset);
      }
      else {
        var data = [];
        for (var i = 0; i < assetKeys.length; i++) {
          data.push([assetKeys[i], response.data.assetMap[assetKeys[i]]]);
        }
        var combo = widget.down('combo[name="asset"]');
        combo.getStore().loadData(data, false);
        combo.setValue(response.data.selectedAsset);
        combo.show();
      }
    }

    me.getRootContainer().getEl().mask(NX.I18n.get('AnalyzeApplicationWindow_Loading_Mask'));
    NX.direct.ahc_Component.getPredefinedValues(JSON.stringify(componentModel.getData()), function(response) {
      me.getRootContainer().getEl().unmask();
      if (Ext.isObject(response) && response.success) {
        if (response.data.tosAccepted) {
          doOpenAnalyzeWindow(response);
        }
        else {
          Ext.widget('nx-coreui-healthcheck-eula', {
            acceptFn: function() {
              NX.direct.ahc_Component.acceptTermsOfService(function() {
                doOpenAnalyzeWindow(response);
              });
            }
          });
        }
      }
    });
  },

  updateAnalyzeButton: function(componentModel) {
    var user = NX.State.getUser(),
        analyzeApplicationButton = this.getAnalyzeApplicationButton();

    if (!componentModel) {
      analyzeApplicationButton.disable();
    }
    else if (user && user.authenticated) {
      NX.direct.ahc_Component.containsApplication(JSON.stringify(componentModel.getData()), function(response) {
        if (Ext.isObject(response) && response.success) {
          if (response.data) {
            analyzeApplicationButton.enable();
          }
          else {
            analyzeApplicationButton.disableWithTooltip(
                NX.I18n.get('AnalyzeApplicationWindow_No_Assets_Error_Message'));
          }
        }
      });
    }
    else {
      analyzeApplicationButton.disableWithTooltip(NX.I18n.get('AnalyzeApplication_Button_Unauthenticated'));
    }
  },

  updateDeleteComponentButton: function(currentRepository, componentModel) {
    var me = this,
        deleteComponentButton = me.getDeleteComponentButton();

    if (componentModel) {
      me.updateDeleteButton(deleteComponentButton, currentRepository, function() {
        NX.direct.coreui_Component.canDeleteComponent(JSON.stringify(componentModel.getData()), function(response) {
          if (Ext.isObject(response) && response.success) {
            if (response.data) {
              deleteComponentButton.enable();
            }
            else {
              deleteComponentButton.disableWithTooltip(NX.I18n.get('ComponentUtils_Delete_Component_No_Permissions'));
            }
          }
        });
      });
    }
    else {
      deleteComponentButton.disable();
    }
  },

  updateDeleteAssetButton: function(currentRepository, assetModel) {
    var me = this,
        deleteAssetButton = me.getDeleteAssetButton();

    if (assetModel) {
      me.updateDeleteButton(deleteAssetButton, currentRepository, function() {
        NX.direct.coreui_Component.canDeleteAsset(assetModel.getId(), assetModel.get('repositoryName'),
            function(response) {
              if (Ext.isObject(response) && response.success) {
                if (response.data) {
                  deleteAssetButton.enable();
                }
                else {
                  deleteAssetButton.disableWithTooltip(NX.I18n.get('ComponentUtils_Delete_Asset_No_Permissions'));
                }
              }
            });
      });
    }
    else {
      deleteAssetButton.disable();
    }
  },

  updateDeleteButton: function(deleteButton, currentRepository, isAuthenticatedCallback) {
    var user = NX.State.getUser();

    if (currentRepository && currentRepository.get('type') !== 'group') {
      deleteButton.disable();
      deleteButton.show();
      if (user && user.authenticated) {
        isAuthenticatedCallback();
      }
      else {
        deleteButton.disableWithTooltip(NX.I18n.get('ComponentUtils_Delete_Button_Unauthenticated'));
      }
    }
    else {
      deleteButton.hide();
    }
  },

  updateDeleteFolderButton: function (currentRepository, path) {
    var me = this,
        deleteButton = me.getDeleteFolderButton();

    if (path) {
      me.updateDeleteButton(deleteButton, currentRepository, function() {
        NX.direct.coreui_Component.canDeleteFolder(path, currentRepository.get('name'),
            function(response) {
              if (Ext.isObject(response) && response.success) {
                if (response.data) {
                  deleteButton.enable();
                }
                else {
                  deleteButton.disableWithTooltip(NX.I18n.get('ComponentUtils_Delete_Asset_No_Permissions'));
                }
              }
            });
      });
    }
  },

  /**
   * @private
   * @param assetModel
   * @returns string showing either last download date or that no downloads have happened
   */
  getLastDownloadDateForDisplay: function(assetModel) {
    var out, lastDownload = assetModel.get('lastDownloaded');
    if (lastDownload != null) {
      out = Ext.Date.format(lastDownload, 'D M d Y');
    }
    else {
      out = NX.I18n.get('Assets_Info_No_Downloads');
    }
    return out;
  },

  /**
   * @param asset
   * @returns {NX.model.Icon} an icon for a given asset
   */
  getIconForAsset: function (asset) {
    var me = this,
        iconController = NX.getApplication().getIconController();

    switch (asset.get('type')) {
      case 'folder':
        return iconController.findIcon('tree-folder', 'x16');
      case 'component':
        return iconController.findIcon('tree-component', 'x16');
      case 'asset':
        var assetName = asset.get('text');
        var icon = me.getIconForAssetName(assetName);
        if (icon) {
          return icon;
        }
        return iconController.findIcon((asset.get('leaf') ? 'tree-asset' : 'tree-asset-folder'), 'x16')
    }
  },

  /**
   * @param assetName
   * @returns {NX.model.Icon} an icon for a given asset name
   */
  getIconForAssetName: function (assetName) {
    var extension = assetName.substr(assetName.lastIndexOf('.') + 1);
    extension = this.getExtensionOverrideMaybe(extension);

    return NX.getApplication().getIconController().findIcon('asset-type-' + extension, 'x16');
  },

  /**
   * @private
   * @param extension
   * @returns {string} extension or an extension override
   */
  getExtensionOverrideMaybe: function (extension) {
    switch (extension) {
      case 'gem':
      case 'rb':
        return 'ruby';

      case 'egg':
      case 'nupkg':
      case 'rpm':
      case 'whl':
        return 'zip';

      case 'bz2':
      case 'lzma':
      case 'rz':
      case 'xz':
      case 'Z':
        return 'gz';

      case 'tbz2':
      case 'tlz':
      case 'txz':
        return 'tgz';

      case 'ear':
      case 'war':
        return 'jar';

      case 'sh':
        return 'bat';

      case 'pom':
      case 'xml':
        return 'code';

      case 'deb':
        return 'debian';

      default:
        return extension;
    }
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Asset info panel.
 *
 * @since 3.6
 */
Ext.define('NX.coreui.view.component.ComponentAssetInfo', {
  extend: 'Ext.Panel',
  alias: 'widget.nx-coreui-component-componentassetinfo',
  requires: [
    'NX.I18n',
    'NX.coreui.util.RepositoryUrls',
    'NX.ext.button.Button',
    'NX.view.info.DependencySnippetPanel'
  ],

  mixins: {
    componentUtils: 'NX.coreui.mixin.ComponentUtils'
  },

  autoScroll: true,
  cls: 'nx-coreui-component-componentassetinfo',

  dockedItems: {
    xtype: 'nx-actions',
    items: [
      {
        xtype: 'nx-button',
        text: NX.I18n.get('AssetInfo_Delete_Button'),
        glyph: 'xf1f8@FontAwesome' /* fa-trash */,
        action: 'deleteAsset',
        hidden: true
      }
    ]
  },

  referenceHolder: true,

  items: [{
    xtype: 'nx-info-panel',
    reference: 'summaryPanel',
    titled: 'Summary',
    collapsible: true
  }, {
    xtype: 'nx-info-dependency-snippet-panel',
    reference: 'dependencySnippetPanel'
  }, {
    xtype: 'panel',
    ui: 'nx-inset',
    title: 'Attributes',
    collapsible: true,
    manageHeight: false,
    items: [{
      xtype: 'nx-coreui-component-assetattributes',
      reference: 'attributesPanel'
    }]
  }],

  savedInfo: {},

  setModel: function(asset, component) {
    var me = this;

    var computedInfo = {},
        contentType = asset.get('contentType'),
        size = asset.get('size'),
        attributesPanel = this.lookup('attributesPanel'),
        titleText;

    this.assetModel = asset;
    this.componentModel = component;

    computedInfo[NX.I18n.get('Assets_Info_Repository')] = Ext.htmlEncode(asset.get('repositoryName'));
    computedInfo[NX.I18n.get('Assets_Info_Format')] = Ext.htmlEncode(asset.get('format'));
    computedInfo[NX.I18n.get('Assets_Info_Group')] = Ext.htmlEncode(component.get('group'));
    computedInfo[NX.I18n.get('Assets_Info_Name')] = Ext.htmlEncode(component.get('name'));
    computedInfo[NX.I18n.get('Assets_Info_Version')] = Ext.htmlEncode(component.get('version'));
    computedInfo[NX.I18n.get('Assets_Info_Path')] = NX.coreui.util.RepositoryUrls.asRepositoryLink(asset, asset.get('format'));
    computedInfo[NX.I18n.get('Assets_Info_ContentType')] = Ext.htmlEncode(contentType);
    computedInfo[NX.I18n.get('Assets_Info_FileSize')] = Ext.util.Format.fileSize(size);
    computedInfo[NX.I18n.get('Assets_Info_Blob_Created')] = Ext.htmlEncode(asset.get('blobCreated'));
    computedInfo[NX.I18n.get('Assets_Info_Blob_Updated')] = Ext.htmlEncode(asset.get('blobUpdated'));

    if (asset.get('downloadCount')) {
      computedInfo[NX.I18n.get('Assets_Info_Downloaded_Count')] = Ext.htmlEncode(asset.get('downloadCount')) + ' '
          + NX.I18n.get('Assets_Info_Downloaded_Unit');
    }

    computedInfo[NX.I18n.get('Assets_Info_Last_Downloaded')] = Ext.htmlEncode(
        me.mixins.componentUtils.getLastDownloadDateForDisplay(asset));
    computedInfo[NX.I18n.get('Assets_Info_Locally_Cached')] = Ext.htmlEncode(contentType !== 'unknown' && size > 0);
    computedInfo[NX.I18n.get('Assets_Info_BlobRef')] = Ext.htmlEncode(asset.get('blobRef'));
    computedInfo[NX.I18n.get('Assets_Info_ContainingRepositoryName')] = Ext.htmlEncode(asset.get('containingRepositoryName'));

    computedInfo[NX.I18n.get('Assets_Info_UploadedBy')] = Ext.htmlEncode(asset.get('createdBy'));
    computedInfo[NX.I18n.get('Assets_Info_UploadedIp')] = Ext.htmlEncode(asset.get('createdByIp'));

    if (attributesPanel) {
      attributesPanel.setAssetModel(asset);
    }

    this.showInfo(Ext.apply({}, this.savedInfo, computedInfo));

    titleText = Ext.htmlEncode(asset.get('name'));
    this.setTitle({
      text: titleText,
      listeners: {
        destroy: function(me) {
          Ext.tip.QuickTipManager.unregister(me.getId());
        }
      }
    });

    // title is already rendered at this point so can't use afterrender event here
    Ext.tip.QuickTipManager.register({
      target: this.down('title').getId(),
      text: titleText
    });

    this.fireEvent('updated', this, asset, component);
  },

  setInfo: function(section, key, value) {
    this.savedInfo[key] = value;
  },

  showInfo: function(info) {
    var summaryPanel = this.lookup('summaryPanel');
    if (summaryPanel) {
      summaryPanel.showInfo(info);
    }
  },

  getDependencySnippetPanel: function() {
    return this.lookup('dependencySnippetPanel');
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Folder info panel.
 *
 * @since 3.15
 */
Ext.define('NX.coreui.view.component.ComponentFolderInfo', {
  extend: 'Ext.Panel',
  alias: 'widget.nx-coreui-component-componentfolderinfo',
  requires: [
    'NX.ext.button.Button'
  ],

  autoScroll: true,
  cls: 'nx-coreui-component-componentfolderinfo',

  dockedItems: {
    xtype: 'nx-actions',
    items: [
      {
        xtype: 'nx-button',
        text: NX.I18n.get('FolderInfo_Delete_Button'),
        glyph: 'xf1f8@FontAwesome' /* fa-trash */,
        action: 'deleteFolder',
        hidden: true
      }
    ]
  },

  setModel: function(folder) {
    this.folderModel = folder;
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * @since 3.7
 */
Ext.define('NX.coreui.model.UploadComponentDefinition', {
  extend: 'Ext.data.Model',
  idProperty: 'format',
  fields: [
    {name: 'multipleUpload', type: 'boolean', sortType: 'asUCText'},
    {name: 'format', type: 'string', sortType: 'asUCText'},
    {name: 'assetFields', type: 'auto' /*object*/},
    {name: 'componentFields', type: 'auto' /*object*/},
    {name: 'regexMap', type: 'auto' /*object*/}
  ]
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * @since 3.7
 */
Ext.define('NX.coreui.store.UploadComponentDefinition', {
  extend: 'Ext.data.Store',
  model: 'NX.coreui.model.UploadComponentDefinition',

  proxy: {
    type: 'direct',

    api: {
      read: 'NX.direct.coreui_Upload.getUploadDefinitions'
    },

    reader: {
      type: 'json',
      rootProperty: 'data',
      successProperty: 'success'
    }
  },

  sorters: { property: 'format', direction: 'ASC' }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Component/Asset tree feature.
 *
 * @since 3.6
 */
Ext.define('NX.coreui.view.browse.ComponentAssetTreeFeature', {
  extend: 'NX.view.drilldown.Drilldown',
  alias: 'widget.nx-coreui-componentassettreefeature',

  iconName: 'browse-asset-default',

  masters: [
    {xtype: 'nx-coreui-browse-repository-list'},
    {xtype: 'nx-coreui-component-asset-tree'}
  ]
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Repository grid.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.browse.BrowseRepositoryList', {
  extend: 'NX.coreui.view.repository.RepositoryListTemplate',
  alias: 'widget.nx-coreui-browse-repository-list',
  requires: [
    'NX.I18n'
  ],

  stateful: true,
  stateId: 'nx-coreui-browse-repository-list',

  store: 'RepositoryReference',

  tbar: {
    xtype: 'nx-actions'
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Component model.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.model.Component', {
  extend: 'Ext.data.Model',
  fields: [
    {name: 'id', type: 'string', sortType: 'asUCText'},
    {name: 'repositoryName', type: 'string', sortType: 'asUCText'},
    {name: 'group', type: 'string'},
    {name: 'name', type: 'string'},
    {name: 'version', type: 'string'},
    {name: 'format', type: 'string', sortType: 'asUCText'}
  ]
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Component info panel.
 *
 * @since 3.4
 */
Ext.define('NX.coreui.view.component.ComponentInfo', {
  extend: 'Ext.Panel',
  alias: 'widget.nx-coreui-component-componentinfo',
  cls: 'nx-coreui-component-componentinfo',
  requires: [
    'NX.I18n',
    'NX.coreui.util.RepositoryUrls',
    'NX.ext.button.Button',
    'NX.view.info.DependencySnippetPanel'
  ],
  dockedItems: {
    xtype: 'nx-actions',
    dock: 'top',
    items: [
      {
        xtype: 'nx-button',
        text: NX.I18n.get('ComponentDetails_Delete_Button'),
        glyph: 'xf1f8@FontAwesome' /* fa-trash */,
        action: 'deleteComponent',
        hidden: true
      },
      {
        xtype: 'nx-button',
        text: NX.I18n.get('ComponentDetails_Analyze_Button'),
        glyph: 'xf085@FontAwesome' /* fa-gears */,
        action: 'analyzeApplication'
      }
    ]
  },

  referenceHolder: true,

  items: [
    {
      xtype: 'nx-info-panel',
      reference: 'summaryPanel',
      titled: NX.I18n.get('Component_AssetInfo_Info_Title'),
      collapsible: true
    },
    {
      xtype: 'nx-info-dependency-snippet-panel',
      reference: 'dependencySnippetPanel'
    }
  ],
  autoScroll: true,
  summary: {},

  setModel: function(componentModel) {
    var me = this,
        summary = this.summary,
        componentName = Ext.htmlEncode(componentModel.get('name'));

    this.componentModel = componentModel;

    summary[NX.I18n.get('Search_Assets_Repository')] = Ext.htmlEncode(componentModel.get('repositoryName'));
    summary[NX.I18n.get('Search_Assets_Format')] = Ext.htmlEncode(componentModel.get('format'));
    summary[NX.I18n.get('Search_Assets_Group')] = Ext.htmlEncode(componentModel.get('group'));
    summary[NX.I18n.get('Search_Assets_Name')] = Ext.htmlEncode(componentModel.get('name'));
    summary[NX.I18n.get('Search_Assets_Version')] = Ext.htmlEncode(componentModel.get('version'));

    me.showInfo();

    me.setTitle({
      text: componentName,
      listeners: {
        destroy: function(me) {
          Ext.tip.QuickTipManager.unregister(me.getId());
        }
      }
    });

    Ext.tip.QuickTipManager.unregister(me.down('title').getId());
    Ext.tip.QuickTipManager.register({
      target: me.down('title').getId(),
      text: componentName
    });

    me.fireEvent('updated', me, me.componentModel);
  },

  setInfo: function(section, key, value) {
    this.summary[key] = value;
  },

  showInfo: function() {
    var summaryPanel = this.lookup('summaryPanel');
    if (summaryPanel) {
      summaryPanel.showInfo(this.summary);
    }
  },

  getDependencySnippetPanel: function() {
    return this.lookup('dependencySnippetPanel');
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Asset model.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.model.Asset', {
  extend: 'Ext.data.Model',
  fields: [
    {name: 'id', type: 'string', sortType: 'asUCText'},
    {name: 'name', type: 'string'},
    {name: 'format', type: 'string', sortType: 'asUCText'},
    {name: 'contentType', type: 'string', sortType: 'asUCText'},
    {name: 'size', type: 'int'},
    {name: 'repositoryName', type: 'string', sortType: 'asUCText'},
    {name: 'containingRepositoryName', type: 'string', sortType: 'asUCText'},
    {name: 'blobCreated', type: 'date', dateFormat: 'c' },
    {name: 'blobUpdated', type: 'date', dateFormat: 'c' },
    {name: 'lastDownloaded', type: 'date', dateFormat: 'c' },
    {name: 'downloadCount', type: 'int'},
    {name: 'blobRef', type: 'string', sortType: 'asUCText'},
    {name: 'componentId', type: 'string', sortType: 'asUCText'},
    {name: 'createdBy', type: 'string'},
    {name: 'createdByIp', type: 'string', sortType: 'asUCText'},
    {name: 'attributes', type: 'auto' /*object*/}
  ]
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Component/Asset tree model.
 *
 * @since 3.6
 */
Ext.define('NX.coreui.model.ComponentAssetTree', {
  extend: 'Ext.data.Model',
  mixins: {
    componentUtils: 'NX.coreui.mixin.ComponentUtils'
  },
  fields: [
    {name: 'id', type: 'string', sortType: 'asUCText'},
    {name: 'type', type: 'string', sortType: 'asUCText'},
    {name: 'text', type: 'string', convert: Ext.util.Format.htmlEncode},
    {name: 'iconCls', type: 'string', convert: function(value, record){
        var icon = record.mixins.componentUtils.getIconForAsset(record);
        if (icon) {
          return icon.get('cls');
        }
    }},
    {name: 'leaf', type: 'boolean'},
    {name: 'componentId', type: 'string'},
    {name: 'assetId', type: 'string'}
  ]
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Component/Asset tree result store.
 *
 * @since 3.6
 */
(function() {
  Ext.define('NX.coreui.store.ComponentAssetTree', {
      extend: 'Ext.data.TreeStore',
      model: 'NX.coreui.model.ComponentAssetTree',
      autoLoad: false,
      paramOrder: ['node', 'repositoryName', 'filter'],
      defaultRootId: '/',
      folderSort: true,
      root: {
          node: '/',
          expanded: false
      },
      proxy: {
          type: 'direct',
          api: {
              read: 'NX.direct.coreui_Browse.read'
          },

          reader: {
              type: 'json',
              rootProperty: 'data',
              successProperty: 'success'
          }
      },
      listeners: {
          beforeload: function (store) {
              if (store.isLoading()) {
                  return false;
              }
          },
          nodeexpand: function(node) {
              if (node.childNodes && node.childNodes.length === 1) {
                  node.childNodes[0].expand();
              }
          }
      }
  });
}());

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Component/Asset tree panel
 *
 * @since 3.6
 */
Ext.define('NX.coreui.view.browse.ComponentAssetTree', {
  extend: 'Ext.panel.Panel',
  alias: 'widget.nx-coreui-component-asset-tree',
  requires: [
    'NX.I18n',
    'NX.State',
    'NX.coreui.view.component.ComponentInfo',
    'NX.coreui.view.component.ComponentAssetInfo',
    'NX.coreui.view.component.ComponentFolderInfo'
  ],

  /**
   * @override
   */
  initComponent: function() {
    var me = this;
    var store = me.store || 'ComponentAssetTree';
    Ext.apply(me, {
      layout: {
        type: 'hbox',
        align: 'stretch'
      },
      items: [{
        xtype: 'treepanel',
        ariaRole: 'grid',
        flex: 3,
        store: store,
        rootVisible: false,
        // Prevent the store from automatically loading
        loadStore: Ext.emptyFn,
        animate: Ext.enableFx && !!NX.State.getValue('animateDuration'),
        viewConfig: {
          emptyText: NX.I18n.get('Component_Asset_Tree_EmptyText_View'),
          deferEmptyText: false
        }
      },
      {
        xtype: 'nx-coreui-component-componentinfo',
        iconCls: 'nx-icon-tree-component-x16',
        flex: 2,
        visible: false
      },
      {
        xtype: 'nx-coreui-component-componentassetinfo',
        flex: 2,
        iconCls: 'nx-icon-tree-asset-x16',
        visible: false
      },
      {
        xtype: 'nx-coreui-component-componentfolderinfo',
        iconCls: 'nx-icon-tree-folder-x16',
        flex: 2,
        visible: false
      }],
      dockedItems: [{
        xtype: 'panel',
        items: [{
          xtype: 'panel',
          itemId: 'info',
          ui: 'nx-drilldown-message',
          cls: 'nx-drilldown-info',
          iconCls: NX.Icons.cls('drilldown-info', 'x16'),
          hidden: true
        },
        {
          xtype: 'panel',
          itemId: 'warning',
          ui: 'nx-drilldown-message',
          cls: 'nx-drilldown-warning',
          iconCls: NX.Icons.cls('drilldown-warning', 'x16'),
          hidden: true
        },
        {
          xtype: 'nx-actions',
          dock: 'top',
          items: [{
            xtype: 'button',
            text: NX.I18n.get('Component_Asset_Tree_Upload_Component'),
            glyph: 'xf093@FontAwesome' /* fa-upload */,
            action: 'upload',
            hidden: true
          },
          {
            xtype: 'label',
            itemId: 'nx-coreui-component-asset-tree-html-view',
            html: NX.util.Url.asLink("", NX.I18n.get('Component_Asset_Tree_Html_View'), '_blank')
          },
          '->',
          {
            xtype: 'nx-searchbox',
            emptyText: NX.I18n.get('Grid_Plugin_FilterBox_Empty'),
            searchDelay: 200,
            width: 200
          },
          {
            xtype: 'label',
            itemId: 'nx-coreui-component-asset-tree-advanced-search',
            html: '<a href="#browse/search">Advanced search...</a>'
          }]
        }]
      }]
    });

    me.callParent();
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Repository model.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.model.Repository', {
  extend: 'Ext.data.Model',
  idProperty: 'name',
  fields: [
    {name: 'name', type: 'string', sortType: 'asUCText'},
    {name: 'type', type: 'string', sortType: 'asUCText'},
    {name: 'format', type: 'string', sortType: 'asUCText'},
    {name: 'recipe', type: 'string', sortType: 'asUCText'},
    {name: 'online', type: 'boolean'},
    {name: 'status', type: 'auto' /*object*/},
    {name: 'attributes', type: 'auto' /*object*/},
    {name: 'url', type: 'string', sortType: 'asUCText'}
  ]
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Repository CMA format.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.store.Repository', {
  extend: 'Ext.data.Store',
  model: 'NX.coreui.model.Repository',

  proxy: {
    type: 'direct',

    api: {
      read: 'NX.direct.coreui_Repository.read'
    },

    reader: {
      type: 'json',
      rootProperty: 'data',
      successProperty: 'success'
    }
  },

  sorters: { property: 'name', direction: 'ASC' }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Component/Asset tree browser controller.
 *
 * @since 3.6
 */
Ext.define('NX.coreui.controller.ComponentAssetTree', {
  extend: 'NX.controller.Drilldown',
  requires: [
    'NX.Bookmarks',
    'NX.Messages',
    'NX.Permissions',
    'NX.I18n',
    'NX.State'
  ],
  mixins: {
    componentUtils: 'NX.coreui.mixin.ComponentUtils'
  },
  masters: [
    'nx-coreui-componentassettreefeature nx-coreui-browse-repository-list'
  ],
  stores: [
    'Repository',
    'ComponentAssetTree',
    'UploadComponentDefinition'
  ],
  models: [
    'RepositoryReference',
    'ComponentAssetTree',
    'Component',
    'Asset',
    'UploadComponentDefinition'
  ],

  views: [
    'browse.BrowseRepositoryList',
    'browse.ComponentAssetTreeFeature',
    'browse.ComponentAssetTree',
    'component.ComponentInfo',
    'component.ComponentAssetInfo',
    'component.ComponentFolderInfo'
  ],

  refs: [
    {ref: 'feature', selector: 'nx-coreui-componentassettreefeature'},
    {ref: 'repositoryList', selector: 'nx-coreui-componentassettreefeature nx-coreui-browse-repository-list'},
    {ref: 'componentAssetTree', selector: 'nx-coreui-componentassettreefeature nx-coreui-component-asset-tree'},
    {ref: 'componentAssetTreePanel', selector: 'nx-coreui-componentassettreefeature nx-coreui-component-asset-tree treepanel'},
    {ref: 'treeFilterBox', selector: 'nx-coreui-componentassettreefeature nx-searchbox'},
    {ref: 'advancedSearchLink', selector: 'nx-coreui-componentassettreefeature #nx-coreui-component-asset-tree-advanced-search'},
    {ref: 'uploadButton', selector: 'nx-coreui-componentassettreefeature button[action=upload]'},
    {ref: 'htmlViewLink', selector: 'nx-coreui-componentassettreefeature #nx-coreui-component-asset-tree-html-view'},
    {ref: 'componentInfo', selector: 'nx-coreui-component-componentinfo'},
    {ref: 'componentAssetInfo', selector: 'nx-coreui-component-componentassetinfo'},
    {ref: 'componentFolderInfo', selector: 'nx-coreui-component-componentfolderinfo'},
    {ref: 'deleteComponentButton', selector: 'nx-coreui-component-componentinfo button[action=deleteComponent]'},
    {ref: 'deleteAssetButton', selector: 'nx-coreui-component-componentassetinfo button[action=deleteAsset]'},
    {ref: 'deleteFolderButton', selector: 'nx-coreui-component-componentfolderinfo button[action=deleteFolder]'},
    {ref: 'analyzeApplicationButton', selector: 'nx-coreui-component-componentinfo button[action=analyzeApplication]'},
    {ref: 'analyzeApplicationWindow', selector: 'nx-coreui-component-analyze-window'},
    {ref: 'rootContainer', selector: 'nx-main'},
    {ref: 'treeWarning', selector: 'nx-coreui-componentassettreefeature nx-coreui-component-asset-tree #warning'}
  ],

  icons: {
    'browse-asset-default': {
      file: 'page_white.png',
      variants: ['x16', 'x32']
    }
  },

  /**
   * @override
   */
  init: function() {
    var me = this;

    me.features = {
      mode: 'browse',
      path: '/Browse',
      text: NX.I18n.get('FeatureGroups_Browse_Text'),
      description: NX.I18n.get('FeatureGroups_Browse_Description'),
      view: 'NX.coreui.view.browse.ComponentAssetTreeFeature',
      iconCls: 'x-fa fa-database',
      authenticationRequired: false
    };

    me.callParent();

    me.listen({
      store: {
        '#ComponentAssetTree': {
          beforeload: me.showTreeMask,
          load: me.browseNodesLoaded
        }
      },
      controller: {
        '#Refresh': {
          refresh: me.loadStores
        },
        '#State': {
          changed: me.stateChanged,
          userchanged: me.loadStores
        }
      },
      component: {
        'nx-coreui-componentassettreefeature nx-coreui-browse-repository-list': {
          beforerender: me.onBeforeRender
        },
        'nx-coreui-componentassettreefeature nx-drilldown-item > container': {
          beforedeactivate: me.onBeforeDeactivate
        },
        'nx-coreui-componentassettreefeature treepanel': {
          select: me.selectNode,
          itemkeydown: me.itemKeyDown
        },
        'nx-coreui-componentassettreefeature nx-searchbox': {
          search: me.onFilterChanged,
          searchcleared: me.onFilterChanged
        },
        'nx-coreui-component-componentinfo button[action=deleteComponent]': {
          click: me.deleteComponent
        },
        'nx-coreui-component-componentinfo button[action=analyzeApplication]': {
          click: me.mixins.componentUtils.openAnalyzeApplicationWindow
        },
        'nx-coreui-component-componentassetinfo button[action=deleteAsset]': {
          click: me.deleteAsset
        },
        'nx-coreui-component-componentfolderinfo button[action=deleteFolder]': {
          click: me.deleteFolder
        },
        'nx-coreui-component-analyze-window button[action=analyze]': {
          click: me.analyzeAsset
        },
        'nx-coreui-component-analyze-window combobox[name="asset"]': {
          select: me.selectedApplicationChanged
        },
        'nx-coreui-componentassettreefeature button[action=upload]': {
          click: me.onClickUploadButton
        },
        'nx-coreui-componentassettreefeature #nx-coreui-component-asset-tree-html-view': {
          render: function () { me.updateHtmlLink(); }
        }
      }
    });

    me.getApplication().getIconController().addIcons({
      'tree-folder': {
        file: 'folder.png',
        variants: ['x16']
      },
      'tree-component': {
        file: 'box_front.png',
        variants: ['x16']
      },
      'tree-asset': {
        file: 'page_white_stack.png',
        variants: ['x16']
      },
      'tree-asset-folder': {
        file: 'folder_page_white.png',
        variants: ['x16', 'x32']
      }
    });
  },

  /**
   * @override
   */
  getDescription: function(model) {
    return model.get('name');
  },

  /**
   * @override
   * When a list managed by this controller is clicked, route the event to the proper handler
   */
  onSelection: function(list, model) {
    var modelType = list.getStore().model;

    if (modelType === this.getRepositoryReferenceModel()) {
      this.onRepositorySelection(model);
    }
  },

  /**
   * @public
   * @param {NX.Bookmark} bookmark to navigate to
   */
  navigateTo: function (bookmark) {
    var me = this,
        lists = Ext.ComponentQuery.query('nx-drilldown-master'),
        list_ids = bookmark.getSegments().slice(1),
        modelId, store;

    // Don’t navigate if the feature view hasn’t loaded
    if (!me.getFeature || !me.getFeature()) {
      return;
    }

    if (lists.length && list_ids.length) {
      //<if debug>
//      me.logDebug('Navigate to: ' + bookmark.getSegments().join(':'));
      //</if>

      modelId = decodeURIComponent(list_ids.shift());
      store = lists[0].getStore();

      if (store.isLoading() || !store.isLoaded()) {
        // The store hasn’t yet loaded, load it when ready
        me.mon(store, 'load', function() {
          me.selectModelById(0, modelId);
          me.mun(store, 'load');
        });
      } else {
        me.selectModelById(0, modelId);
      }
    } else {
      me.loadView(0);
    }
  },

  /**
   * @private
   * Handle setting up the tree store with proper repo name parameter and reset the tree for reloading
   */
  onRepositorySelection: function(model) {
    var me = this, componentAssetTreeStore = me.getStore('ComponentAssetTree');

    if (!me.selectedRepository || me.selectedRepository.id !== model.id) {
      //reset the filter
      componentAssetTreeStore.proxy.setExtraParam('filter');
      componentAssetTreeStore.proxy.setExtraParam('repositoryName', model.get('name'));
    }

    // Update HTML View link
    me.updateHtmlLink(model);
    me.updateUploadButton(model);

    me.reloadNodes();

    me.expandTree();

    me.selectedRepository = model;

    me.updateWarningMessage(model.get('name'));
  },

  expandTree: function() {
    var me = this,
        treePanel = me.getComponentAssetTreePanel(),
        segments = window.location.hash.split(':'),
        hasPath = segments && segments.length === 3,
        path;

    if (treePanel.getStore().isLoading()) {
      treePanel.getStore().on({
        load: me.expandTree,
        scope: me,
        single: true
      });
    }
    else if (hasPath) {
      path = decodeURIComponent(segments[2]);
      treePanel.selectPath('/Root/' + path, 'text', '/', function (successful, lastNode) {
        if (!successful) {
          NX.Messages.error(NX.I18n.get('Component_Asset_Tree_Expand_Failure'));
        }
        else {
          lastNode.expand();
        }
      });
    }
  },

  showTreeMask: function() {
    var me = this,
      treePanel = me.getComponentAssetTreePanel(),
      treeStore = me.getStore('ComponentAssetTree'),
      maskTask = new Ext.util.DelayedTask(function() {
        if (treeStore.isLoading()) {
          // Show the loading mask
          treePanel.setLoading(true);

          // Wait for the store to load before unmasking the tree
          treeStore.on({
            single: true,
            load: function() {
              treePanel.setLoading(false);
            }
          });
        }
      });

    // Wait 0.1 seconds before showing the loading mask
    maskTask.delay(100);
  },

  browseNodesLoaded: function(store, node, records) {
    var message = { type: 'warning', text: NX.I18n.get('Component_Asset_Tree_Results_Warning')};
    if (records && records.length === NX.State.getValue('browseTreeMaxNodes') && !NX.Messages.messageExists(message)) {
      NX.Messages.add(message);
    }
  },

  /**
   * @private
   * Handle when the filter changes, so the tree will be reloaded and future node requests will contain the filter
   * parameter
   */
  onFilterChanged: function(filterBox, value) {
    var me = this,
        componentAssetTreeStore = me.getStore('ComponentAssetTree'),
        emptyText = me.getComponentAssetTreePanel().view.emptyText,
        advancedSearchLink = me.getAdvancedSearchLink(),
        treePanel = me.getComponentAssetTreePanel(),
        url;

    if (me.selectedRepository) {
      // repository selected, filter the tree
      if (value) {
        url = 'browse/search=' + encodeURIComponent('keyword=' + value);
        emptyText = emptyText.replace(/>.*</, '>' + NX.I18n.get('Component_Asset_Tree_Filtered_EmptyText_View') + '<');
        emptyText = emptyText.replace('browse/search', url);

        advancedSearchLink.setText(advancedSearchLink.initialConfig.html.replace('browse/search', url), false);
      } else {
        emptyText = emptyText.replace(/>.*</, '>' + NX.I18n.get('Component_Asset_Tree_EmptyText_View') + '<');

        advancedSearchLink.setText(advancedSearchLink.initialConfig.html, false);
      }
      treePanel.view.emptyText = emptyText;

      componentAssetTreeStore.proxy.setExtraParam('filter', value);

      me.reloadNodes();
    }
  },

  /**
   * @override
   * Load all of the stores associated with this controller.
   */
  loadStores: function() {
    var me = this;
    if (me.getFeature()) {
      if (me.atRepositoryPage()) {
        me.getRepositoryList().getStore().load();
      }
      else if (me.atTreePage()) {
        me.onRepositorySelection(me.getCurrentRepository());
      }
    }
  },

  stateChanged: function() {
    var currentRepository = this.getCurrentRepository(),
        repositoryName = currentRepository ? currentRepository.get('name') : null;

    this.updateUploadButton();
    this.updateWarningMessage(repositoryName);
  },

  updateWarningMessage: function(repositoryName) {
    var warning = this.getTreeWarning(),
        rebuildingRepositories = NX.State.getValue('rebuildingRepositories') || [];

    if (!warning) {
      return;
    }

    if (rebuildingRepositories.indexOf(repositoryName) !== -1) {
      warning.setTitle(NX.I18n.format('ComponentDetails_Rebuild_Warning'));
      warning.show();
    }
    else {
      warning.hide();
    }
  },

  bookmarkNode: function(node) {
    const ROOT_LENGTH = '/Root/'.length;
    var baseUrl = '#browse/browse:' + encodeURIComponent(this.getCurrentRepository().get('name')),
        encodedId = node ? encodeURIComponent(node.getPath('text').substring(ROOT_LENGTH)) : null;

    //if we don't have the replaceState method, don't bother doing anything
    if (window.history.replaceState && window.location.hash.indexOf(baseUrl) === 0) {
      window.history.replaceState({}, null, baseUrl + (encodedId ? (':' + encodedId) : ''));
    }
  },

  selectNode: function(view, node) {
    var me = this,
        componentInfoPanel,
        componentInfoPanelTitleText,
        assetInfoPanel;

    me.removeSideContent();
    me.bookmarkNode(node);

    if ('component' === node.get('type')) {
      componentInfoPanelTitleText = me.buildPathString(node);
      componentInfoPanel = me.getComponentInfo();
      componentInfoPanel.setTitle(componentInfoPanelTitleText);
      componentInfoPanel.setIconCls(me.mixins.componentUtils.getIconForAsset(node).get('cls'));
      componentInfoPanel.getDependencySnippetPanel().hide();
      componentInfoPanel.show();
      componentInfoPanel.mask(NX.I18n.get('ComponentDetails_Loading_Mask'));

      NX.direct.coreui_Component.readComponent(node.get('componentId'), me.getCurrentRepository().get('name'), function(response) {
        var componentModel;
        me.maybeUnmask(componentInfoPanel);
        if (me.isPanelVisible(componentInfoPanel) && me.isResponseSuccessful(response)) {
          componentModel = me.getComponentModel().create(response.data);
          me.setComponentModel(componentModel);
         }
      });
    }
    else if ('asset' === node.get('type')) {
      assetInfoPanel = me.getComponentAssetInfo();
      assetInfoPanel.setIconCls(me.mixins.componentUtils.getIconForAsset(node).get('cls'));
      assetInfoPanel.getDependencySnippetPanel().hide();
      assetInfoPanel.show();
      assetInfoPanel.mask(NX.I18n.get('ComponentDetails_Loading_Mask'));

      NX.direct.coreui_Component.readAsset(node.get('assetId'), me.getCurrentRepository().get('name'), function(response) {
        if (me.isPanelVisible(assetInfoPanel) && me.isResponseSuccessful(response)) {
          me.setInfoPanelModel(assetInfoPanel, me.getAssetModel().create(response.data));
        }
        else {
          me.maybeUnmask(assetInfoPanel);
        }
      });
    }
    else if ('folder' === node.get('type')) {
      var folderInfoPanel = me.getComponentFolderInfo();
      folderInfoPanel.setTitle(node.get('text'));
      folderInfoPanel.setIconCls(me.mixins.componentUtils.getIconForAsset(node).get('cls'));
      folderInfoPanel.show();

      folderInfoPanel.mask(NX.I18n.get('ComponentDetails_Loading_Mask'));
      me.getDeleteFolderButton().show();
      me.getDeleteFolderButton().enable();
      folderInfoPanel.setModel({repositoryName: me.getCurrentRepository().get('name'), folderName: node.get('text'), path: node.get('id')});
      me.updateDeleteFolderButton(me.getCurrentRepository(), node.get('id'));
      me.maybeUnmask(folderInfoPanel);
    }
  },

  setComponentModel: function(componentModel) {
    var componentInfoPanel = this.getComponentInfo();

    componentInfoPanel.setModel(componentModel);
    this.updateDeleteComponentButton(this.getCurrentRepository(), componentModel);
    this.updateAnalyzeButton(componentModel);
    this.setDependencySnippets(componentInfoPanel.getDependencySnippetPanel(), componentModel);
  },

  setInfoPanelModel: function(assetInfoPanel, asset) {
    var me = this,
        componentModel;

    if (asset.get('componentId')) {
      NX.direct.coreui_Component.readComponent(asset.get('componentId'), me.getCurrentRepository().get('name'), function (response) {
        me.maybeUnmask(assetInfoPanel);
        if (me.isPanelVisible(assetInfoPanel) && me.isResponseSuccessful(response)) {
          componentModel = me.getComponentModel().create(response.data);
          assetInfoPanel.setModel(asset, componentModel);
          me.updateDeleteAssetButton(me.getCurrentRepository(), asset);
          me.setDependencySnippets(assetInfoPanel.getDependencySnippetPanel(), componentModel, asset);
        }
      });
    }
    else {
      me.maybeUnmask(assetInfoPanel);
      if (me.isPanelVisible(assetInfoPanel)) {
        componentModel = me.getComponentModel().create({});
        assetInfoPanel.setModel(asset, componentModel);
        me.updateDeleteAssetButton(me.getCurrentRepository(), asset);
        me.setDependencySnippets(assetInfoPanel.getDependencySnippetPanel(), componentModel, asset);
      }
    }
  },

  setDependencySnippets: function(dependencySnippetPanel, componentModel, assetModel) {
    var format, dependencySnippets;

    if (componentModel) {
      format = componentModel.get('format');
      dependencySnippets = NX.getApplication().getDependencySnippetController()
          .getDependencySnippets(format, componentModel, assetModel);

      dependencySnippetPanel.setDependencySnippets(format, dependencySnippets);

      if (dependencySnippets && dependencySnippets.length > 0) {
        dependencySnippetPanel.show();
      }
    }
  },

  isPanelVisible : function(panel) {
    return panel && panel.isVisible();
  },

  isResponseSuccessful : function(response) {
    return Ext.isObject(response) && response.success && response.data;
  },

  maybeUnmask : function(panel) {
    var me = this;
    if (me.isPanelVisible(panel)) {
      panel.getEl().unmask();
    }
  },

  itemKeyDown: function(view, model, el, index, event) {
    var key = event.getKey();
    if (key === event.ENTER || key === event.RETURN || key === event.SPACE || key === event.RIGHT) {
      view.getSelectionModel().select(model);
    }
  },

  removeSideContent: function() {
    var me = this,
        componentInfo = me.getComponentInfo(),
        componentAssetInfo = me.getComponentAssetInfo(),
        componentFolderInfo = me.getComponentFolderInfo();

    componentInfo.hide();
    componentAssetInfo.hide();
    componentFolderInfo.hide();
  },

  buildPathString: function(node) {
    var path = '';
    //node.parentNode check will skip the trees root node (labeld Root and hidden)
    while (node != null && node.parentNode != null) {
      path = node.get('text') + '/' + path;
      node = node.parentNode;
    }

    return path;
  },

  /**
   * @override
   */
  onNavigate: function() {
    if (this.getFeature()) {
      this.onBeforeRender();
    }
  },

  /**
   * @private
   */
  atRepositoryPage: function() {
    var me = this;
    return me.currentIndex === 0;
  },

  /**
   * @private
   */
  atTreePage: function() {
    var me = this;
    return me.currentIndex === 1;
  },

  /**
   * @private
   * Load stores based on the bookmarked URL
   */
  onBeforeRender: function() {
    var me = this,
        repoList = me.getRepositoryList(),
        repoModel;

    if (repoList) {
      repoList.getStore().on({
        load: function() {
          repoModel = me.getCurrentRepository();

          if (repoModel) {
            //0 references the first list in the Drilldown parent (the repository list)
            me.onModelChanged(0, repoModel);
            me.onRepositorySelection(repoModel);
          }

          me.reselect();
        },
        single: true
      });

      // In theory we should be able to just pass in the above load listener here, but for some reason it isn't being called
      repoList.getStore().load();
    }
  },

  /**
   * @private
   * Clears the filter box before the view is changed
   */
  onBeforeDeactivate: function(oldCard) {
    var filterBox = oldCard.down('nx-searchbox');

    filterBox && filterBox.clearSearch && filterBox.clearSearch();
  },

  /**
   * @private
   * Opens the Upload UI for current repository
   */
  onClickUploadButton: function() {
    var me = this,
        repository = me.getCurrentRepository(),
        uploadUrl = '#browse/upload:' + encodeURIComponent(repository.get('name'));

    window.open(uploadUrl, '_self');
  },

  /**
   * @private
   * Updates the href for the HTML Tree view
   */
  updateHtmlLink: function(repository) {
    var me = this,
        htmlViewLink = me.getHtmlViewLink(),
        currentRepository = repository || me.getCurrentRepository(),
        repositoryName = currentRepository && currentRepository.get('name');

    if (htmlViewLink && htmlViewLink.el && repositoryName) {
      htmlViewLink.el.select('a').set({
        href: NX.util.Url.urlOf('/service/rest/repository/browse/'+ encodeURIComponent(repositoryName))
      });
    }
  },

  /**
   * @private
   * Updates the visibility of the upload button.
   */
  updateUploadButton: function(repo) {
    var me = this,
        uploadButton = me.getUploadButton(),
        store = me.getStore('UploadComponentDefinition'),
        repository = repo || me.getCurrentRepository();

    if (uploadButton && repository) {
      if (NX.State.getValue('upload') &&
          NX.Permissions.check('nexus:component:add') &&
          repository.getData().type === 'hosted' &&
          repository.getData().versionPolicy !== 'SNAPSHOT') {
        store.load(function (store, results) {
          var isSupported = Ext.Array.some(results.getRecords(), function (item) {
            return item.getData().format === repository.getData().format;
          });
          uploadButton.setVisible(isSupported);
        });
      }
      else {
        uploadButton.setVisible(false);
      }
    }
  },

  /**
   * @pivate
   * Retrieve the current repository model as defined in the bookmark
   */
  getCurrentRepository: function() {
    var me = this,
        bookmark = NX.Bookmarks.getBookmark(),
        list_ids = bookmark.getSegments().slice(1),
        repoList = me.getRepositoryList();

    if (repoList && list_ids && list_ids.length > 0) {
      return repoList.getStore().getById(decodeURIComponent(list_ids[0]));
    }

    return null;
  },

  /**
   * Remove selected component.
   *
   * @private
   */
  deleteComponent: function() {
    var me = this,
        treePanel = me.getComponentAssetTreePanel(),
        componentInfo = me.getComponentInfo(),
        selectedNode = treePanel.getSelectionModel().getSelection()[0],
        componentModel, componentId;

    if (componentInfo) {
      componentModel = componentInfo.componentModel;
      componentId = componentModel.get('name') + '/' + componentModel.get('version');
      NX.Dialogs.askConfirmation(NX.I18n.get('ComponentDetails_Delete_Title'), Ext.htmlEncode(NX.I18n.format('ComponentDetails_Delete_Body', componentId)), function() {
        NX.direct.coreui_Component.deleteComponent(JSON.stringify(componentModel.getData()), function(response) {
          if (Ext.isObject(response) && response.success && Ext.isArray(response.data)) {
            me.removeNodeFromTree(selectedNode);
            Ext.each(response.data, function (nodeId) {
              var node = treePanel.getStore().findNode('id', nodeId);
              if (node) {
                me.removeNodeFromTree(node);
              }
            });
            NX.Messages.add({text: NX.I18n.format('ComponentDetails_Delete_Success', componentId), type: 'success'});
          }
        });
      });
    }
  },

  /**
   * @private
   * Remove selected asset.
   */
  deleteAsset: function () {
    var me = this,
        treePanel = me.getComponentAssetTreePanel(),
        componentAssetInfo = me.getComponentAssetInfo();

    if (componentAssetInfo) {
      var asset = componentAssetInfo.assetModel;
      NX.Dialogs.askConfirmation(NX.I18n.get('AssetInfo_Delete_Title'), Ext.htmlEncode(asset.get('name')), function () {
        NX.direct.coreui_Component.deleteAsset(asset.getId(), asset.get('repositoryName'), function (response) {
          if (Ext.isObject(response) && response.success) {
            var selectedRecord = treePanel.getSelectionModel().getSelection()[0];
            if (selectedRecord.get('leaf')) {
              me.removeSideContent();
              me.removeNodeFromTree(selectedRecord);
            }
            else {
              selectedRecord.set('type', 'folder');
              selectedRecord.set('iconCls', me.mixins.componentUtils.getIconForAsset(selectedRecord).get('cls'));
            }
            NX.Messages.add({text: NX.I18n.format('AssetInfo_Delete_Success', asset.get('name')), type: 'success'});
          }
        });
      });
    }
  },

  /**
   * @private
   * Remove selected Folder.
   */
  deleteFolder: function() {
    var me = this,
        componentFolderInfo = me.getComponentFolderInfo();

    if (componentFolderInfo) {
      var model = componentFolderInfo.folderModel;
      NX.Dialogs.askConfirmation(
          NX.I18n.get('FolderInfo_Delete_Title'),
          NX.I18n.format('FolderInfo_Delete_Text', Ext.htmlEncode(model.folderName)),
          function() {
            NX.direct.coreui_Component.deleteFolder(model.path, model.repositoryName,
                function(response) {
                  if (Ext.isObject(response) && response.success) {
                    NX.Messages.add({text: NX.I18n.format('FolderInfo_Delete_Success'), type: 'success'});
                  }
                });
          });
    }
  },

  fetchComponentModelFromView: function() {
    return this.getComponentInfo().componentModel;
  },

  /**
   * Analyze a component using the AHC service
   *
   * @private
   */
  analyzeAsset: function(button) {
    var me = this,
        componentInfo = me.getComponentInfo(),
        win,
        form,
        formValues,
        repositoryName,
        assetId;

    if (componentInfo) {
      win = button.up('window');
      form = button.up('form');
      formValues = form.getForm().getValues();
      repositoryName = componentInfo.componentModel.get('repositoryName');
      assetId = form.down('combo[name="asset"]').getValue();
      NX.direct.ahc_Component.analyzeAsset(repositoryName, assetId, formValues.emailAddress, formValues.password,
          formValues.proprietaryPackages, formValues.reportLabel, function (response) {
            if (Ext.isObject(response) && response.success) {
              win.close();
              NX.Messages.add({text: NX.I18n.get('ComponentDetails_Analyze_Success'), type: 'success'});
            }
          });
    }
  },

  /**
   * When app changes, update the reportName as well
   */
  selectedApplicationChanged: function(combo) {
    var me = this,
        componentInfo = me.getComponentInfo(),
        labelField;

    if (componentInfo) {
      labelField = me.getAnalyzeApplicationWindow().down('textfield[name="reportLabel"]');
      if (!labelField.isDirty()) {
        //I am setting the original value so it won't be marked dirty unless user touches it
        labelField.originalValue = combo.getRawValue();
        labelField.setValue(combo.getRawValue());
      }
    }
  },

  removeNodeFromTree: function(node) {
    var me = this,
        panel = me.getComponentAssetTreePanel(),
        selectedNode;

    while(node) {
      var parentNode = node.parentNode;
      node.remove();
      node = parentNode;
      //if after removing a node there are still children, thats the one we want to select
      if (node && node.hasChildNodes()) {
        panel.getSelectionModel().select(node);
        selectedNode = true;
        break;
      }
    }

    //we found no node to select, so everything must be gone, thus make sure to update the address bar
    if (!selectedNode) {
      me.bookmarkNode(null);
    }
  },

  loadView: function (index, model) {
    var me = this,
      lists = Ext.ComponentQuery.query('nx-drilldown-master'),
      hasPath = NX.Bookmarks.getBookmark().getSegments().length > 2;

    // Don’t load the view if the feature is not ready
    if (!me.getFeature()) {
      return;
    }

    // Model specified, select it in the previous list
    if (model && index > 0) {
      lists[index - 1].fireEvent('selection', lists[index - 1], model);
      me.onModelChanged(index - 1, model);
    }

    // Set all child bookmarks
    for (var i = 0; i <= index; ++i) {
      me.setItemBookmark(i, NX.Bookmarks.fromSegments(NX.Bookmarks.getBookmark().getSegments().slice(0, i + 1)), me);
    }

    // Show the next view in line
    me.showChild(index);
    if (!hasPath) {
      me.bookmark(index, model);
    }
  },

  reloadNodes: function() {
    var me = this, componentAssetTreeStore = me.getStore('ComponentAssetTree');

    //remove the side panel which if there, is showing old data
    me.removeSideContent();

    if (!componentAssetTreeStore.isLoading()) {
      //this will trigger the tree to be reloaded
      componentAssetTreeStore.setRootNode({
          expanded: true
      });
    }
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * LDAP Server "User & Group" panel.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.ldap.LdapServerUserAndGroup', {
  extend: 'NX.view.SettingsPanel',
  alias: 'widget.nx-coreui-ldapserver-userandgroup',

  settingsForm: { xtype: 'nx-coreui-ldapserver-userandgroup-form' }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext*/

/**
 * File descriptor warning controller, handles showing messages.
 *
 * @since 3.5
 */
Ext.define('NX.coreui.controller.FileDescriptorWarnings', {
  extend: 'NX.app.Controller',

  requires: [
    'NX.I18n',
    'NX.Permissions'
  ],
  refs: [
    {
      ref: 'fileDescriptorWarning',
      selector: '#nx-file-descriptor-warning'
    }
  ],

  /**
   * @override
   */
  init: function() {

    var me = this;

    me.listen({
      controller: {
        '#State': {
          changed: me.stateChanged
        }
      }
    });
  },

  stateChanged: function() {
    var me = this,
        warningPanel = me.getFileDescriptorWarning(),
        fileDescriptorLimitOk = NX.State.getValue('file_descriptor_limit', {})['limitOk'],
        fileDescriptorCount = NX.State.getValue('file_descriptor_limit', {})['count'],
        fileDescriptorRecommended = NX.State.getValue('file_descriptor_limit', {})['recommended'],
        user = NX.State.getUser();

    if (warningPanel) {
      if (user && user.administrator && !fileDescriptorLimitOk) {
        warningPanel.setTitle(NX.I18n.render(me, 'File_Descriptor_Warning', fileDescriptorCount, fileDescriptorRecommended));
        warningPanel.show();
      }
      else {
        warningPanel.hide();
      }
    }
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Cleanup Policy "Settings" form.
 *
 * @since 3.14
 */
var criteriaConfiguration = null;

Ext.define('NX.coreui.view.cleanuppolicy.CleanupPolicySettingsForm', {
  extend: 'NX.view.SettingsForm',
  alias: 'widget.nx-coreui-cleanuppolicy-settings-form',
  requires: [
    'NX.Conditions',
    'NX.I18n'
  ],

  api: {
    submit: 'NX.direct.cleanup_CleanupPolicy.update'
  },

  initComponent: function() {
    var me = this;

    me.settingsFormSuccessMessage = me.settingsFormSuccessMessage || function(data) {
      return NX.I18n.get('CleanupPolicy_CleanupPolicySettingsForm_Update_Success') + Ext.htmlEncode(data['name']);
    };

    me.editableMarker = NX.I18n.get('CleanupPolicy_CleanupPolicySettingsForm_Update_Error');

    me.editableCondition = me.editableCondition ||
        NX.Conditions.and(NX.Conditions.isPermitted('nexus:repository-admin:*:*:edit'));

    me.items = [
      {
        xtype: 'fieldset',
        itemId: 'cleanupPolicies',
        cls: 'nx-form-section',
        title: NX.I18n.get('CleanupPolicy_CleanupPolicySettingsForm_CleanupPolicy_Title'),
        items: [
          {
            xtype: 'textfield',
            name: 'name',
            itemId: 'name',
            fieldLabel: NX.I18n.get('CleanupPolicy_CleanupPolicySettingsForm_Name_FieldLabel'),
            helpText: NX.I18n.get('CleanupPolicy_CleanupPolicySettingsForm_Name_HelpText'),
            readOnly: true,
            allowBlank: false,
            maxLength: 255,
            vtype: 'nx-name'
          },
          {
            xtype: 'combo',
            name: 'format',
            itemId: 'format',
            fieldLabel: NX.I18n.get('CleanupPolicy_CleanupPolicySettingsForm_Format_FieldLabel'),
            helpText: NX.I18n.get('CleanupPolicy_CleanupPolicySettingsForm_Format_HelpText'),
            editable: false,
            allowBlank: false,
            store: 'RepositoryFormat',
            queryMode: 'local',
            displayField: 'value',
            valueField: 'value',
            readOnlyOnUpdate: true,
            listeners: {
              'change': {
                fn: me.onFormatChange,
                scope: me
              }
            }
          },
          {
            xtype: 'textfield',
            name: 'notes',
            itemId: 'notes',
            fieldLabel: NX.I18n.get('CleanupPolicy_CleanupPolicySettingsForm_Notes_FieldLabel'),
            allowBlank: true
          },
          {
            xtype: 'hiddenfield',
            name: 'mode',
            value: 'delete' // default
          }
        ]
      },
      {
        xtype: 'fieldset',
        itemId: 'criteria',
        cls: 'nx-form-section',
        title: NX.I18n.get('CleanupPolicy_CleanupPolicySettingsForm_Criteria_Title'),
        items: [
          {
            xtype: 'fieldcontainer',
            itemId: 'lastBlobUpdatedContainer',
            fieldLabel: NX.I18n.get('CleanupPolicy_CleanupPolicySettingsForm_LastBlobUpdated_FieldLabel'),
            helpText: NX.I18n.get('CleanupPolicy_CleanupPolicySettingsForm_LastBlobUpdated_HelpText'),
            layout: 'hbox',
            items: [
              me.createCheckbox('lastBlobUpdated'),
              me.createNumberField('lastBlobUpdated')
            ]
          },
          {
            xtype: 'fieldcontainer',
            itemId: 'lastDownloadedContainer',
            fieldLabel: NX.I18n.get('CleanupPolicy_CleanupPolicySettingsForm_LastDownloaded_FieldLabel'),
            helpText: NX.I18n.get('CleanupPolicy_CleanupPolicySettingsForm_LastDownloaded_HelpText'),
            layout: 'hbox',
            items: [
              me.createCheckbox('lastDownloaded'),
              me.createNumberField('lastDownloaded')
            ]
          },
          {
            xtype: 'fieldcontainer',
            itemId: 'isPrereleaseContainer',
            fieldLabel: NX.I18n.get('CleanupPolicy_CleanupPolicySettingsForm_IsPrerelease_FieldLabel'),
            helpText: NX.I18n.get('CleanupPolicy_CleanupPolicySettingsForm_IsPrerelease_HelpText'),
            layout: 'hbox',
            items: [
              me.createCheckbox('releaseType'),
              me.createComboBox('releaseType', [
                ['RELEASES', NX.I18n.get('CleanupPolicy_CleanupPolicySettingsForm_IsPrerelease_Releases_Item')],
                ['PRERELEASES', NX.I18n.get('CleanupPolicy_CleanupPolicySettingsForm_IsPrerelease_Prereleases_Item')]
              ])
            ],
            hidden: true
          }
        ]
      }
    ];

    me.callParent();

    Ext.override(me.getForm(), {
      getValues: function() {
        var values = this.callParent(arguments);
        values.criteria = {};
        values.criteria['lastBlobUpdated'] = values.lastBlobUpdated;
        values.criteria['lastDownloaded'] = values.lastDownloaded;
        values.criteria['releaseType'] = values.releaseType;
        return values;
      },
      setValues: function(values) {
        values.lastBlobUpdatedEnabled = values.criteria['lastBlobUpdated'] !== null;
        values.lastDownloadedEnabled = values.criteria['lastDownloaded'] !== null;
        values.releaseTypeEnabled = values.criteria['releaseType'] !== null;

        values.lastBlobUpdated = values.criteria['lastBlobUpdated'];
        values.lastDownloaded = values.criteria['lastDownloaded'];
        values.releaseType = values.criteria['releaseType'];
        this.callParent(arguments);
      }
    });
  },

  /**
   * @override
   *
   * reset the form to keep check boxes correct
   */
  loadRecord: function(model) {
    var me = this,
        checkboxes = me.down('#criteria').query('checkbox');

    Ext.Array.each(checkboxes, function(checkbox) {
      checkbox.resetOriginalValue();
    });

    me.form.reset();

    me.callParent(arguments);
  },

  createCheckbox: function(name) {
    return {
      xtype: 'checkbox',
      name: name + 'Enabled',
      itemId: name + 'Enabled',
      boxLabel: name + 'Enabled',
      listeners: {
        afterrender: function() {
          // HACK. Why? Boxlabel makes a label appear, on which we
          // use selection in tests but do not want to actually display it
          this.boxLabelEl.dom.style.width = '0';
          this.boxLabelEl.dom.style.overflow = 'hidden';
        },
        change: function() {
          var form = this.up('form'),
              field = form.down('#' + name);

          if (this.getValue()) {
            field.enable();
          }
          else {
            field.disable();
          }

          form.isValid();
        }
      }
    };
  },

  createNumberField: function(name) {
    return {
      xtype: 'numberfield',
      name: name,
      itemId: name,
      minValue: 1,
      // (2147483646 - 1 / 86400) java max - 1 / seconds in day
      maxValue: 24855,
      allowDecimals: false,
      allowExponential: false,
      allowBlank: false,
      disabled: true,
      width: 580,
      style: {
        marginLeft: '5px'
      },
      listeners: {
        change: function() {
          var form = this.up('form'),
              checkbox = form.down('#' + name + 'Enabled');
          if (this.getValue() && !checkbox.getValue()) {
            checkbox.setValue(true);
            checkbox.resetOriginalValue();
          }
        }
      }
    };
  },

  createComboBox: function(name, store) {
    return {
      xtype: 'combo',
      name: name,
      itemId: name,
      editable: false,
      store: store,
      readOnlyOnUpdate: false,
      disabled: true,
      allowBlank: false,
      width: 580,
      style: {
        marginLeft: '5px'
      },
      listeners: {
        change: function() {
          var form = this.up('form'),
              checkbox = form.down('#' + name + 'Enabled');
          if (this.getValue() && !checkbox.getValue()) {
            checkbox.setValue(true);
            checkbox.resetOriginalValue();
          }
        }
      }
    };
  },

  onFormatChange: function() {
    if (criteriaConfiguration) {
      this.updateFields();
    }
    else {
      this.initialiseCriteriaFields();
    }
  },

  updateFields: function() {
    var me = this;
    var items = me.down('#cleanupPolicies').items;
    var formatCombo = items.items[1];
    var format = formatCombo.getValue();
    var containers = this.getContainers();

    Ext.Object.each(containers, function(field, container, myself) {
      var formatCriteria = criteriaConfiguration[format];

      if (!formatCriteria) {
        formatCriteria = criteriaConfiguration['default'];
      }

      var visible = formatCriteria[field];

      container.setVisible(visible);

      if (!visible) {
        container.down('checkbox').setValue(false);
        container.down('combo').clearValue();
      }
    });
  },

  initialiseCriteriaFields: function() {
    var me = this;
    var containers = this.getContainers();

    NX.direct.cleanup_CleanupPolicy.getApplicableFields(Object.keys(containers), function(response) {
      if (Ext.isObject(response) && response.success) {

        criteriaConfiguration = response.data;
        me.updateFields();
      }
    });
  },

  getContainers: function() {
    var me = this;
    var elements = me.down('#criteria').items;

    var containers = {};

    elements.eachKey(function (k, container) {
      var containerId = container.getItemId();

      if (containerId.indexOf('Container') >= 0) {
        var key = containerId.substring(0, containerId.indexOf('Container'));
        containers[key] = container;
      }
    });

    return containers;
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/*global NX*/

/**
 * 'textfield' factory.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.formfield.factory.FormfieldTextFieldFactory', {
  singleton: true,
  alias: [
    'nx.formfield.factory.textfield',
    'nx.formfield.factory.string',
    'nx.formfield.factory.password'
  ],

  /**
   * Creates a textfield.
   * @param formField form field to create textfield for
   * @returns {*} created textfield (never null)
   */
  create: function (formField) {
    var item = {
      xtype: formField.type === 'url' ? 'nx-url' : 'textfield',
      htmlDecode: true,
      fieldLabel: formField.label,
      itemCls: formField.required ? 'required-field' : '',
      helpText: formField.helpText,
      allowBlank: !formField.required,
      regex: formField.regexValidation ? new RegExp(formField.regexValidation) : null
    };
    if (formField.type === 'password') {
      item.inputType = 'password';
      item.inputAttrTpl = 'autocomplete="new-password"';
    }
    if (formField.initialValue) {
      item.value = formField.initialValue;
    }
    return item;
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * LDAP Server model.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.model.LdapServer', {
  extend: 'Ext.data.Model',
  fields: [
    {name: 'id', type: 'string'},
    {name: 'name', type: 'string', sortType: 'asUCText'},
    {name: 'order', type: 'int'},
    {name: 'url', type: 'string'},

    {name: 'protocol', type: 'auto' /*object*/},
    {name: 'host', type: 'string'},
    {name: 'port', type: 'int'},
    {name: 'useTrustStore', type: 'boolean'},
    {name: 'searchBase', type: 'string'},

    {name: 'authScheme', type: 'string'},
    {name: 'authRealm', type: 'string'},
    {name: 'authUsername', type: 'string'},
    {name: 'authPassword', type: 'string'},

    {name: 'connectionTimeout', type: 'int'},
    {name: 'connectionRetryDelay', type: 'int'},
    {name: 'maxIncidentsCount', type: 'int'},

    {name: 'userBaseDn', type: 'string'},
    {name: 'userSubtree', type: 'boolean'},
    {name: 'userObjectClass', type: 'string'},
    {name: 'userLdapFilter', type: 'string'},
    {name: 'userIdAttribute', type: 'string'},
    {name: 'userRealNameAttribute', type: 'string'},
    {name: 'userMemberOfAttribute', type: 'string'},
    {name: 'userEmailAddressAttribute', type: 'string'},
    {name: 'userPasswordAttribute', type: 'string'},

    {name: 'ldapGroupsAsRoles', type: 'boolean'},
    {name: 'groupType', type: 'string'},
    {name: 'groupBaseDn', type: 'string'},
    {name: 'groupSubtree', type: 'boolean'},
    {name: 'groupIdAttribute', type: 'string'},
    {name: 'groupMemberAttribute', type: 'string'},
    {name: 'groupMemberFormat', type: 'string'},
    {name: 'groupObjectClass', type: 'string'}
  ]
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * LDAP Server store.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.store.LdapServer', {
  extend: 'Ext.data.Store',
  model: 'NX.coreui.model.LdapServer',

  proxy: {
    type: 'direct',
    paramsAsHash: false,

    api: {
      read: 'NX.direct.ldap_LdapServer.read'
    },

    reader: {
      type: 'json',
      rootProperty: 'data',
      successProperty: 'success'
    }
  },

  sorters: { property: 'order', direction: 'ASC' }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Configuration for availability of Docker V1 api.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.repository.facet.DockerV1Facet', {
  extend: 'Ext.form.FieldContainer',
  alias: 'widget.nx-coreui-repository-docker-v1-facet',
  requires: [
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function() {
    var me = this;

    me.items = [
      {
        xtype: 'fieldset',
        itemId: 'dockerV1',
        cls: 'nx-form-section',
        title: NX.I18n.get('Repository_Facet_DockerHostedFacet_V1_Title'),
        width: 600,
        items: [
          {
            xtype: 'checkbox',
            name: 'attributes.docker.v1Enabled',
            itemId: 'v1enabled',
            fieldLabel: NX.I18n.get('Repository_Facet_DockerHostedFacet_V1_Enabled'),
            helpText: NX.I18n.get('Repository_Facet_DockerHostedFacet_V1_Enabled_Help'),
            value: false
          }
        ]
      }
    ];

    me.callParent();
  }

});


/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Support for progress screens.
 *
 * @since 3.0
 * @abstract
 */
Ext.define('NX.coreui.migration.ProgressScreenSupport', {
  extend: 'NX.wizard.GridScreen',
  requires: [
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    me.fields = [{
      xtype: 'progressbar'
    }];

    me.grid = {
      xtype: 'grid',

      viewConfig: {
        stripeRows: true,

        // disable load-mask this is too distracting when auto-refreshing via task
        loadMask: false
      },
      hideHeaders: true,

      columns: [
        {
          xtype: 'nx-iconcolumn',
          width: 36,
          iconVariant: 'x16',
          iconName: function (value, meta, record) {
            var state = record.get('state');
            switch (state) {
              case 'COMPLETED':
                return 'migration-step-done';

              case 'INITIALIZED':
                return 'migration-step-pending';

              case 'RUNNING':
                return 'migration-step-running';

              default:
                return 'migration-step-error';
            }
          }
        },
        {
          header: NX.I18n.render(me, 'Name_Column'),
          dataIndex: 'name',
          flex: 1
        },
        {
          header: NX.I18n.render(me, 'Status_Column'),
          dataIndex: 'status',
          flex: 2,
          renderer: function (value) {
            if (value === null) {
              return 'Pending';
            }
            return value;
          }
        },
        {
          header: NX.I18n.render(me, 'State_Column'),
          dataIndex: 'state'
        },
        {
          header: NX.I18n.render(me, 'Complete_Column'),
          dataIndex: 'complete',
          width: 80,
          renderer: function (value) {
            if (value >= 0) {
              return Math.floor(value * 100) + '%';
            }
            //else {
            //  return '&infin;';
            //}
          }
        }
      ],

      store: 'NX.coreui.migration.ProgressStore',
      invalidateScrollerOnRefresh: false
    };

    me.callParent();
  },

  /**
   * @returns {Ext.ProgressBar}
   */
  getProgressBar: function() {
    return this.down('progressbar');
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Migration FINISH phase screen.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.migration.PhaseFinishScreen', {
  extend: 'NX.coreui.migration.ProgressScreenSupport',
  alias: 'widget.nx-coreui-migration-phasefinish',
  requires: [
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    Ext.apply(me, {
      title: NX.I18n.render(me, 'Title'),
      description: NX.I18n.render(me, 'Description'),
      buttons: [
        {
          text: NX.I18n.render(me, 'Abort_Button'),
          action: 'abort',
          ui: 'default'
        },
        {
          text: NX.I18n.render(me, 'Done_Button'),
          action: 'done',
          ui: 'nx-primary',
          disabled: true
        }
      ]
    });

    me.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Repository "Settings" form for a NuGet Hosted repository.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.repository.recipe.NugetHosted', {
  extend: 'NX.coreui.view.repository.RepositorySettingsForm',
  alias: 'widget.nx-coreui-repository-nuget-hosted',
  requires: [
    'NX.coreui.view.repository.facet.StorageFacet',
    'NX.coreui.view.repository.facet.StorageFacetHosted',
    'NX.coreui.view.repository.facet.CleanupPolicyFacet'
  ],

  /**
   * @override
   */
  initComponent: function() {
    var me = this;

    me.items = [
      { xtype: 'nx-coreui-repository-storage-facet'},
      { xtype: 'nx-coreui-repository-storage-hosted-facet'},
      { xtype: 'nx-coreui-repository-cleanup-policy-facet'}
    ];

    me.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Bundle list.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.system.BundleList', {
  extend: 'NX.view.drilldown.Master',
  alias: 'widget.nx-coreui-system-bundlelist',
  requires: [
    'NX.I18n'
  ],

  stateful: true,
  stateId: 'nx-coreui-system-bundlelist',

  /**
   * @override
   */
  initComponent: function() {
    Ext.apply(this, {
      store: 'Bundle',

      columns: [
        {
          xtype: 'nx-iconcolumn',
          width: 36,
          iconVariant: 'x16',
          iconName: function () {
            return 'bundle-default';
          }
        },
        {
          header: NX.I18n.get('System_BundleList_ID_Header'),
          dataIndex: 'id',
          stateId: 'id',
          width: 60,
          resizable: false,
          renderer: Ext.htmlEncode
        },
        {
          header: NX.I18n.get('System_BundleList_State_Header'),
          dataIndex: 'state',
          stateId: 'state',
          width: 80,
          resizable: false,
          renderer: Ext.htmlEncode
        },
        {
          header: NX.I18n.get('System_BundleList_Level_Header'),
          dataIndex: 'startLevel',
          stateId: 'startLevel',
          width: 60,
          resizable: false,
          renderer: Ext.htmlEncode
        },
        {
          header: NX.I18n.get('System_BundleList_Name_Header'),
          dataIndex: 'name',
          stateId: 'name',
          flex: 2,
          renderer: Ext.htmlEncode
        },
        {
          header: NX.I18n.get('System_BundleList_SymbolicName_Header'),
          dataIndex: 'symbolicName',
          stateId: 'symbolicName',
          flex: 2,
          hidden: true,
          renderer: Ext.htmlEncode
        },
        {
          header: NX.I18n.get('System_BundleList_Version_Header'),
          dataIndex: 'version',
          stateId: 'version',
          flex: 1,
          renderer: Ext.htmlEncode
        },
        {
          header: NX.I18n.get('System_BundleList_Location_Header'),
          dataIndex: 'location',
          stateId: 'location',
          hidden: true,
          renderer: Ext.htmlEncode
        },
        {
          header: NX.I18n.get('System_BundleList_Fragment_Header'),
          dataIndex: 'fragment',
          stateId: 'fragment',
          hidden: true,
          renderer: Ext.htmlEncode
        }
      ],

      // filter will install into toolbar, ensure its properly styled for drilldown
      tbar: {
        xtype: 'nx-actions'
      },

      plugins: [
        {ptype: 'gridfilterbox', emptyText: NX.I18n.get('System_BundleList_Filter_EmptyText')}
      ]
    });

    this.callParent();
  }
});

 /*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Blobstore "Settings" form.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.blobstore.BlobstoreSettingsForm', {
  extend: 'NX.view.SettingsForm',
  alias: 'widget.nx-coreui-blobstore-settings-form',
  requires: [
    'NX.Conditions',
    'NX.I18n'
  ],

  initComponent: function() {
    var me = this;

    me.settingsFormSuccessMessage = function(data) {
      return NX.I18n.get('Blobstore_BlobstoreSettingsForm_Update_Success') + data['name'];
    };

    me.editableMarker = NX.I18n.get('Blobstore_BlobstoreSettingsForm_Update_Error');

    me.editableCondition = me.editableCondition || NX.Conditions.and(
        NX.Conditions.isPermitted('nexus:blobstores:update'),
        NX.Conditions.formHasRecord('nx-coreui-blobstore-settings-form', function(model) {
          var blobstoreTypeModel = NX.getApplication().getStore('BlobstoreType').getById(model.data.type);
          return blobstoreTypeModel.data.isModifiable;
        })
    );

    me.items = [
      {
        xtype: 'combo',
        name: 'type',
        itemId: 'type',
        fieldLabel: NX.I18n.get('Blobstore_BlobstoreAdd_Type_FieldLabel'),
        emptyText: NX.I18n.get('Blobstore_BlobstoreAdd_Type_EmptyText'),
        editable: false,
        store: 'BlobstoreType',
        queryMode: 'local',
        displayField: 'name',
        valueField: 'id',
        readOnly: true,
        onChange: function(newValue, oldValue) {
          var comboxBox = this;
          var settingsFieldSet = me.down('nx-coreui-formfield-settingsfieldset');
          var value = newValue || oldValue;
          if (!newValue) {
            comboxBox.setValue(value);
            comboxBox.originalValue = value;
            comboxBox.validate();
          }
          var blobstoreTypeModel = NX.getApplication().getStore('BlobstoreType').getById(value);
          settingsFieldSet.importProperties(null, blobstoreTypeModel.get('formFields'), me.editableCondition);
        }
      },
      {
        xtype: 'textfield',
        name: 'name',
        itemId: 'name',
        fieldLabel: NX.I18n.get('Blobstore_BlobstoreSettingsForm_Name_FieldLabel'),
        readOnly: true
      },
      {
        xtype: 'checkbox',
        name: 'isQuotaEnabled',
        itemId: 'isQuotaEnabled',
        boxLabel: NX.I18n.get('Blobstore_BlobstoreSettingsForm_EnableSoftQuota_FieldLabel'),
        readOnly: true,
        listeners: {
          change: function(checkbox, newValue) {
            me.toggleQuotaParamVisibility(newValue);
          }
        }
      },
      {
        xtype: 'combo',
        name: 'quotaType',
        itemId: 'quotaType',
        fieldLabel: NX.I18n.get('Blobstore_BlobstoreSettingsForm_QuotaType_FieldLabel'),
        editable: false,
        store: 'BlobStoreQuotaType',
        queryMode: 'local',
        displayField: 'name',
        valueField: 'id',
        readOnly: true
      },
      {
        xtype: 'numberfield',
        name: 'quotaLimit',
        itemId: 'quotaLimit',
        fieldLabel: NX.I18n.get('Blobstore_BlobstoreSettingsForm_QuotaLimit_FieldLabel'),
        minValue: 1,
        allowDecimals: false,
        allowExponential: true,
        readOnly: true
      },
      {
        xtype: 'nx-coreui-formfield-settingsfieldset',
        delimiter: null,
        disableSort: true
      }
    ];

    me.callParent();

    var isQuotaEnabledField = me.down('#isQuotaEnabled');
    me.toggleQuotaParamVisibility(isQuotaEnabledField !== null && isQuotaEnabledField.value);

    //map repository attributes raw map structure to/from a flattened representation
    Ext.override(me.getForm(), {
      getValues: function() {
        var values = this.callParent(arguments);
        var type = values['type'].toLowerCase();
        values.attributes = {};
        values.attributes[type] = me.down('nx-coreui-formfield-settingsfieldset').exportProperties(values);
        return values;
      },
      setValues: function(values) {
        var attrs = values['attributes'];
        var type = values['type'].toLowerCase();
        for (var prop in attrs[type]) {
          if (attrs[type].hasOwnProperty(prop)) {
            values["property_" + prop] = attrs[type][prop];
          }
        }
        this.callParent(arguments);

        if (type === 'group') {
          me.filterGroupStore(values['name'], values);
        }
      }
    });
  },
  /**
   * @private
   */
  toggleQuotaParamVisibility: function(value) {
    var me = this,
        form = me.up('form');
    var quotaTypeField = me.down('#quotaType');
    quotaTypeField.setVisible(value);
    quotaTypeField.setDisabled(!value);

    var quotaLimitField = me.down('#quotaLimit');
    quotaLimitField.setVisible(value);
    quotaLimitField.setDisabled(!value);

    if (form && form.rendered) {
      form.isValid();
    }
  },
  /**
   * @private
   */
  filterGroupStore: function(selectedBlobStoreName, values) {
    var me = this,
        members = me.down('nx-coreui-formfield-settingsfieldset').down('nx-itemselector'),
        membersValue = values['property_members'];

    if (!members || !membersValue || members.name !== 'property_members') {
      return;
    }

    members.getStore().load({
      params: {
        filter: [{property: 'blobStoreName', value: selectedBlobStoreName}]
      },
      callback: function() {
        members.suspendEvents();
        members.setValue(membersValue);
        members.validateValue();
        members.resumeEvents();
      }
    });
  },

  setEditable: function(editable) {
    var me = this;

    if (editable || !NX.Permissions.check('nexus:blobstores:update')) {
      me.quotaFieldsReadOnly(false);
      NX.getApplication().getController('Blobstores').showWarning(
          NX.I18n.format('Blobstore_BlobstoreFeature_Editing_Enabled_Message'));
      me.callParent(arguments);
    }
    else {
      me.quotaFieldsReadOnly(true);

      //if the form has any fields
      if (me.items != null) {
        //then grab all of the dynamically generated fields and make them non-editable
        var itemsToDisable = me.getChildItemsToDisable().filter(function(item) {
          return item.ownerCt.xtype === 'nx-coreui-formfield-settingsfieldset';
        });

        me.setItemsEditable(false, itemsToDisable);
      }
    }
  },

  quotaFieldsReadOnly: function(readOnly) {
    var me = this;
    if (me.items) {
      Ext.Array.forEach(['#isQuotaEnabled', '#quotaType', '#quotaLimit'], function(f) {
        me.down(f).setReadOnly(readOnly);
      });
    }
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Add blobstore window.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.blobstore.BlobstoreAdd', {
  extend: 'NX.view.AddPanel',
  alias: 'widget.nx-coreui-blobstore-add',
  requires: [
    'NX.Conditions',
    'NX.I18n'
  ],

  defaultFocus: 'type',

  /**
   * @override
   */
  initComponent: function() {
    var me = this;

    // cache the default work directory path
    NX.direct.coreui_Blobstore.defaultWorkDirectory(function(response) {
      if (Ext.isObject(response) && response.success) {
        me.defaultWorkDirectory = response.data.path;
        me.fileSeparator = response.data.fileSeparator;
      }
    });

    me.settingsForm = {
      xtype: 'nx-coreui-blobstore-settings-form',
      api: {
        submit: 'NX.direct.coreui_Blobstore.create'
      },
      settingsFormSuccessMessage: function(data) {
        return NX.I18n.get('Blobstore_BlobstoreAdd_Create_Success') + data['name'];
      },
      editableCondition: NX.Conditions.isPermitted('nexus:blobstores:create'),
      editableMarker: NX.I18n.get('Blobstore_BlobstoreAdd_Create_Error'),

      buttons: [
        { text: NX.I18n.get('Blobstore_BlobstoreList_New_Button'), action: 'add', formBind: true, ui: 'nx-primary' },
        { text: NX.I18n.get('Add_Cancel_Button'), action: 'back' }
      ]
    };

    me.callParent();

    var typeCombo = me.down('#type');
    typeCombo.setReadOnly(false);
    typeCombo.on({
      beforerender: function() {
        var me = this;
        me.setValue(me.getStore('BlobstoreType').first().data.id);
        typeCombo.resetOriginalValue();
      }
    });

    var nameField = me.down('#name');
    nameField.setReadOnly(false);
    // onChange listener to pre-populate the path
    nameField.on({
      change: function(f, newName, oldName) {
        var pathField = f.up().query('[name=property_path]')[0],
            wd = me.defaultWorkDirectory,
            oldPath = wd + me.fileSeparator + oldName;
        if (pathField && (!pathField.getValue() || pathField.getValue() === oldPath)) {
          pathField.setValue(wd + me.fileSeparator + newName);
        }
      }
    });

    // Enable quota fields
    Ext.Array.forEach(['#isQuotaEnabled', '#quotaType', '#quotaLimit'], function(f) { me.down(f).setReadOnly(false); });
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Blobstore type model.
 *
 * @since 3.6
 */
Ext.define('NX.coreui.model.BlobstoreType', {
  extend: 'Ext.data.Model',
  fields: [
    {name: 'id', type: 'string', sortType: 'asUCText'},
    {name: 'name', type: 'string', sortType: 'asUCText'},
    {name: 'formFields', type: 'auto' /*object*/},
    {name: 'isModifiable', type: 'boolean'},
    {name: 'isEnabled', type: 'boolean'}
  ]
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Blobstore Type store.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.store.BlobstoreType', {
  extend: 'Ext.data.Store',
  model: 'NX.coreui.model.BlobstoreType',

  proxy: {
    type: 'direct',
    paramsAsHash: false,

    api: {
      read: 'NX.direct.coreui_Blobstore.readTypes'
    },

    reader: {
      type: 'json',
      rootProperty: 'data',
      successProperty: 'success'
    }
  },

  sorters: { property: 'name', direction: 'ASC' },
  filters: [
    { property: 'isEnabled', value: true }
  ]
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Blobstore model.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.model.Blobstore', {
  extend: 'Ext.data.Model',
  idProperty: 'name',
  fields: [
    {name: 'name', type: 'string', sortType: 'asUCText'},
    {name: 'type', type: 'string', sortType: 'asUCText'},
    {name: 'isQuotaEnabled', type:'boolean' },
    {name: 'quotaType', type:'string' },
    {name: 'quotaLimit', type:'int' },
    {name: 'attributes', type: 'auto' /*object*/, defaultValue: null },
    {name: 'blobCount', type: 'int'},
    {name: 'totalSize', type: 'int'},
    {name: 'availableSpace', type: 'int'},
    {name: 'unlimited', type: 'boolean'},
    {name: 'repositoryUseCount', type: 'int'},
    {name: 'blobStoreUseCount', type: 'int'},
    {name: 'inUse', type: 'boolean'},
    {name: 'promotable', type: 'boolean'},
    {name: 'groupName', type: 'string'}
  ]
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Blobstore format.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.store.Blobstore', {
  extend: 'Ext.data.Store',
  model: 'NX.coreui.model.Blobstore',

  proxy: {
    type: 'direct',

    api: {
      read: 'NX.direct.coreui_Blobstore.read'
    },

    reader: {
      type: 'json',
      rootProperty: 'data',
      successProperty: 'success'
    }
  },

  sorters: { property: 'name', direction: 'ASC' }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Blobstore feature panel.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.blobstore.BlobstoreFeature', {
  extend: 'NX.view.drilldown.Drilldown',
  alias: 'widget.nx-coreui-blobstore-feature',
  requires: [
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function() {
    Ext.apply(this, {
      iconName: 'blobstore-default',

      masters: [
        { xtype: 'nx-coreui-blobstore-list' }
      ],

      tabs: { xtype: 'nx-coreui-blobstore-settings' },

      nxActions: [
        { xtype: 'button', text: NX.I18n.get('Blobstore_BlobstoreFeature_Delete_Button'), glyph: 'xf1f8@FontAwesome' /* fa-trash */, action: 'delete', disabled: true },
        { xtype: 'button', text: NX.I18n.get('Blobstore_BlobstoreFeature_Promote_Button'), glyph: 'xf0ad@FontAwesome' /* fa-wrench */, action: 'promoteToGroup', disabled: true}
      ]
    });

    this.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Blob store Quota Type store.
 *
 * @since 3.14
 */
Ext.define('NX.coreui.store.BlobStoreQuotaType', {
  extend: 'Ext.data.Store',
  model: 'NX.coreui.model.Reference',

  proxy: {
    type: 'direct',
    paramsAsHash: false,

    api: {
      read: 'NX.direct.coreui_Blobstore.readQuotaTypes'
    },

    reader: {
      type: 'json',
      rootProperty: 'data',
      idProperty: 'id',
      successProperty: 'success'
    }
  },

  sorters: { property: 'name', direction: 'ASC' }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Blobstore grid.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.blobstore.BlobstoreList', {
  extend: 'NX.view.drilldown.Master',
  alias: 'widget.nx-coreui-blobstore-list',
  requires: [
    'NX.I18n'
  ],

  stateful: true,
  stateId: 'nx-coreui-blobstore-list',

  /**
   * @override
   */
  initComponent: function() {
    Ext.apply(this, {
      store: 'Blobstore',

      columns: [
        {
          xtype: 'nx-iconcolumn',
          width: 36,
          iconVariant: 'x16',
          iconName: function () {
            return 'blobstore-default';
          }
        },
        {header: NX.I18n.get('Blobstore_BlobstoreList_Name_Header'), dataIndex: 'name', stateId: 'name', flex: 1,  renderer: Ext.htmlEncode},
        {header: NX.I18n.get('Blobstore_BlobstoreList_Type_Header'), dataIndex: 'type', stateId: 'type'},
        {header: NX.I18n.get('Blobstore_BlobstoreList_BlobCount_Header'), dataIndex: 'blobCount', stateId: 'blobCount'},
        {
          header: NX.I18n.get('Blobstore_BlobstoreList_TotalSize_Header'), dataIndex: 'totalSize', stateId: 'totalSize',
          renderer: Ext.util.Format.fileSize
        },
        {
          header: NX.I18n.get('Blobstore_BlobstoreList_AvailableSpace_Header'), dataIndex: 'availableSpace',
          stateId: 'availableSpace', renderer: function(value, metaData, record, row, col, store, gridView) {
            if (record.data.unlimited) {
              return 'Unlimited';
            }

            return Ext.util.Format.fileSize(value, metaData, record, row, col, store, gridView);
          }, flex: 1
        }
      ],

      viewConfig: {
        emptyText: NX.I18n.get('Blobstore_BlobstoreList_EmptyText'),
        deferEmptyText: false
      },

      dockedItems: [
        {
          xtype: 'nx-actions',
          items: [
            {
              xtype: 'button',
              text: NX.I18n.get('Blobstore_BlobstoreList_New_Button'),
              glyph: 'xf055@FontAwesome' /* fa-plus-circle */,
              action: 'new',
              disabled: true
            }
          ]
        }
      ],

      plugins: [
        {ptype: 'gridfilterbox', emptyText: NX.I18n.get('Blobstore_BlobstoreList_Filter_EmptyText')}
      ]
    });

    this.callParent();
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Blobstore "Settings" panel.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.blobstore.BlobstoreSettings', {
  extend: 'NX.view.SettingsPanel',
  alias: 'widget.nx-coreui-blobstore-settings',
  requires: [
    'NX.I18n'
  ],

  settingsForm: { xtype: 'nx-coreui-blobstore-settings-form' },

  /**
   * @override
   */
  initComponent: function() {
    var me = this;

    me.title = NX.I18n.get('Blobstore_BlobstoreSettings_Title');

    me.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Blobstores controller.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.controller.Blobstores', {
  extend: 'NX.controller.Drilldown',
  requires: [
    'NX.Dialogs',
    'NX.Messages',
    'NX.Permissions',
    'NX.I18n'
  ],
  masters: [
    'nx-coreui-blobstore-list'
  ],
  models: [
    'Blobstore'
  ],
  stores: [
    'Blobstore',
    'BlobstoreType',
    'BlobStoreQuotaType'
  ],
  views: [
    'blobstore.BlobstoreAdd',
    'blobstore.BlobstoreFeature',
    'blobstore.BlobstoreList',
    'blobstore.BlobstoreSettings',
    'blobstore.BlobstoreSettingsForm'
  ],
  refs: [
    { ref: 'feature', selector: 'nx-coreui-blobstore-feature' },
    { ref: 'content', selector: 'nx-feature-content' },
    { ref: 'list', selector: 'nx-coreui-blobstore-list' },
    { ref: 'settings', selector: 'nx-coreui-blobstore-feature nx-coreui-blobstore-settings' }
  ],
  icons: {
    'blobstore-default': {
      file: 'drive_network.png',
      variants: ['x16', 'x32']
    }
  },

  permission: 'nexus:blobstores',

  /**
   * @override
   */
  init: function() {
    var me = this;

    me.features = {
      mode: 'admin',
      path: '/Repository/Blobstores',
      text: NX.I18n.get('Blobstores_Text'),
      description: NX.I18n.get('Blobstores_Description'),
      view: {xtype: 'nx-coreui-blobstore-feature'},
      iconConfig: {
        file: 'drive_network.png',
        variants: ['x16', 'x32']
      },
      visible: function() {
        return NX.Permissions.check('nexus:blobstores:read') && !Ext.isEmpty(NX.State.getUser());
      }
    };

    me.callParent();

    me.listen({
      controller: {
        '#Refresh': {
          refresh: me.loadStores
        }
      },
      store: {
        '#Blobstore': {
          load: me.reselect
        }
      },
      component: {
        'nx-coreui-blobstore-list': {
          beforerender: me.loadRecipe
        },
        'nx-coreui-blobstore-list button[action=new]': {
          click: me.showAddWindow
        },
        'nx-coreui-blobstore-settings button[action=save]': {
          click: me.updateBlobstore
        },
        'nx-coreui-blobstore-feature button[action=promoteToGroup]': {
          click: me.promoteToGroup,
          afterrender: me.bindIfUpdatableAndGroupsEnabled
        },
        'nx-coreui-blobstore-settings-form': {
          submitted: me.loadStores
        },
        //Note that this component is from the Task UI
        'combobox[name=property_fromGroup]': {
          change: me.fromGroupChanged
        }
      }
    });
  },

  /**
   * @override
   */
  getDescription: function(model) {
    return model.get('name');
  },

  /**
   * @override
   */
  onSelection: function(list, model) {
    if (Ext.isDefined(model)) {
      this.getSettings().loadRecord(model);
    }
  },

  /**
   * @protected
   * Enable 'Delete' when user has 'delete' permission for selected blobstore.
   */
  bindDeleteButton: function(button) {
    var me = this;

    button.mon(
        NX.Conditions.and(
            NX.Conditions.isPermitted(this.permission + ':delete'),
            NX.Conditions.watchEvents([
              { observable: me.getStore('Blobstore'), events: ['load']},
              { observable: Ext.History, events: ['change']}
            ], me.watchEventsHandler())
        ),
        {
          satisfied: function () {
            button.enable();
          },
          unsatisfied: function () {
            button.disable();
          }
        }
    );
  },

  /**
   * @private
   */
  watchEventsHandler: function () {
    var me = this,
        store = me.getStore('Blobstore');

    return function() {
      var blobstoreId = me.getModelIdFromBookmark(),
          model = blobstoreId ? store.findRecord('name', blobstoreId, 0, false, true, true) : undefined;

      if (model) {
        var inUse = model.get('inUse');
        if (inUse) {
          var repositoryUseCount = model.get('repositoryUseCount');
          var blobStoreUseCount = model.get('blobStoreUseCount');
          me.showInfo(NX.I18n.format('Blobstore_BlobstoreFeature_Delete_Disabled_Message',
                     Ext.util.Format.plural(repositoryUseCount, 'repository', 'repositories'),
                     Ext.util.Format.plural(blobStoreUseCount, 'other blob store', 'other blob stores')));
          return false;
        }

        me.clearInfo();
        return true;
      }

      return false;
    };
  },

  /**
   * @private
   */
  showAddWindow: function() {
    var me = this;

    // Show the first panel in the create wizard, and set the breadcrumb
    me.setItemName(1, NX.I18n.get('Blobstores_Create_Title'));
    me.loadCreateWizard(1, Ext.create('widget.nx-coreui-blobstore-add'));
  },

  /**
   * @private
   */
  loadRecipe: function() {
    var me = this,
        list = me.getList();

    if (list) {
      me.getStore('Blobstore').clearFilter();
      me.getStore('BlobstoreType').load();
      me.getStore('BlobStoreQuotaType').load();
    }
  },

  /**
   * @private
   * Updates blobstore.
   */
  updateBlobstore: function(button) {
    var me = this,
        form = button.up('form'),
        values = form.getValues();

    NX.Dialogs.askConfirmation(NX.I18n.get('Blobstore_BlobstoreFeature_Update_Title'),
                               NX.I18n.get('Blobstore_BlobstoreFeature_Update_Warning'),
                               function () {
      me.getContent().getEl().mask(NX.I18n.get('Blobstores_Update_Mask'));
      NX.direct.coreui_Blobstore.update(values, function(response) {
        me.getContent().getEl().unmask();
        if (Ext.isObject(response)) {
          if (response.success) {
            NX.Messages.add({
              text: NX.I18n.format('Blobstores_Update_Success',
                  me.getDescription(me.getBlobstoreModel().create(response.data))),
              type: 'success'
            });
            me.getStore('Blobstore').load();
          }
          else if (Ext.isDefined(response.errors)) {
            form.markInvalid(response.errors);
          }
        }
      });
    }, {scope: me});
  },

  /**
   * @private
   */
  deleteModel: function(model) {
    var me = this,
        description = me.getDescription(model);

    me.getContent().getEl().mask(NX.I18n.get('Blobstores_Delete_Mask'));
    NX.direct.coreui_Blobstore.remove(model.getId(), function(response) {
      me.getContent().getEl().unmask();
      me.getStore('Blobstore').load();
      if (Ext.isObject(response) && response.success) {
        NX.Messages.add({ text: 'Blobstore deleted: ' + description, type: 'success' });
      }
    });
  },

  /**
   * @private
   * Converts file blob store to group.
   */
  promoteToGroup: function(button) {
    var me = this,
        model = me.getList().getSelectionModel().getLastSelected();
    NX.direct.coreui_Blobstore.promoteToGroup(model.get('name'), function (response) {
      if (Ext.isObject(response) && response.success) {
        NX.Messages.add({
          text: NX.I18n.format('Blobstore_BlobstoreFeature_Promote_Success', response.data.name),
          type: 'success'
        });
        me.getStore('Blobstore').load();
        button.disable();
      }
    });
  },

  /**
   * @private
   */
  watchEventsForNonGroups: function () {
    var me = this,
        store = me.getStore('Blobstore');

    return function() {
      var blobstoreId = me.getModelIdFromBookmark(),
          model = blobstoreId ? store.findRecord('name', blobstoreId, 0, false, true, true) : undefined;

      if (model) {
        return model.get('promotable');
      }

      return false;
    };
  },

  /**
   * @private
   * checks that blobstore is not a blobstore group and that user has permissions before activating button
   */
  bindIfUpdatableAndGroupsEnabled: function(button) {
    var me = this;

    button.mon(
        NX.Conditions.and(
            NX.Conditions.isPermitted(this.permission + ':update'),
            NX.Conditions.watchEvents([
              { observable: me.getStore('Blobstore'), events: ['load']},
              { observable: Ext.History, events: ['change']}
            ], me.watchEventsForNonGroups())
        ),
        {
          satisfied: function () {
            button.enable();
          },
          unsatisfied: function () {
            button.disable();
          }
        }
    );

    // check that Groups are enabled before showing the promote button
    button.mon(
        NX.Conditions.watchEvents([
          { observable: me.getStore('BlobstoreType'), events: ['load']},
          { observable: Ext.History, events: ['change']}
        ], function() {
          return me.getStore('BlobstoreType').findRecord('name', 'Group', false, true, true) != null;
        }),
        {
          satisfied: function () {
            button.show();
          },
          unsatisfied: function () {
            button.hide();
          }
        }
    );
  },

  fromGroupChanged: function(groupComboBox, newVal, old) {
    var members = groupComboBox.up().query('[name=property_memberToRemove]')[0];
    var selectedGroup = groupComboBox.getStore().getById(newVal);
    var data = Ext.Array.map(selectedGroup.data.attributes.group.members, function(m) {return {name: m, id: m};});
    members.setValue(null);
    members.getStore().setData(data);
    if(!old) {
      members.reset();
    }
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Task "Summary" panel.
 *
 * @since 3.1
 */
Ext.define('NX.coreui.view.task.TaskSummary', {
  extend: 'Ext.Panel',
  alias: 'widget.nx-coreui-task-summary',
  requires: [
    'NX.Conditions',
    'NX.I18n'
  ],
  cls: 'nx-hr',

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    me.title = NX.I18n.get('TaskFeature_Summary_Title');
    me.autoScroll = true;

    me.layout = {
      type: 'vbox',
      align: 'stretch'
    };

    me.items = {
      xtype: 'panel',
      ui: 'nx-inset',
      items: [
        {
          xtype: 'panel',
          ui: 'nx-subsection',
          itemId: 'nx-coreui-task-summary-subsection',
          frame: true,
          layout: 'column',
          weight: 10,
          items: [
            {
              xtype: 'nx-info',
              columnWidth: 1
            }
          ]
        },
        {
          xtype: 'nx-coreui-task-status',
          ui: 'nx-subsection',
          frame: true,
          title: NX.I18n.get('TaskFeature_Summary_Status_Section_Title'),
          weight: 20
        }
      ]
    };

    me.callParent();
  },

  showInfo: function (info) {
    this.down('nx-info').showInfo(info);
  },

  getStatuses: function() {
    var me = this;
    return me.down('nx-coreui-task-status');
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Support for progress steps.
 *
 * @since 3.0
 * @abstract
 */
Ext.define('NX.coreui.migration.ProgressStepSupport', {
  extend: 'NX.wizard.Step',
  requires: [
    'Ext.util.TaskManager',
    'NX.I18n'
  ],

  config: {
    /**
     * @cfg {String}
     */
    phase: null
  },

  /**
   * @override
   */
  init: function () {
    var me = this;

    me.control({
      'gridpanel': {
        cellclick: me.doDisplayDetail
      }
    });
  },

  /**
   * @override
   */
  prepare: function () {
    var me = this;

    // TODO: Likely have to listen for session timeout events to stop auto-refreshing

    // add loading mask, remove once store data changes first time
    me.mask(NX.I18n.render(me, 'Loading_Mask'));
    me.getStore('NX.coreui.migration.ProgressStore').on({
      single: true,
      datachanged: function() {
        me.unmask();
      }
    });

    me.autoRefresh(true);
  },

  /**
   * @override
   */
  reset: function() {
    this.autoRefresh(false);
    this.getStore('NX.coreui.migration.ProgressStore').removeAll(true);
    this.callParent();
  },

  //
  // Auto-refresh
  //

  /**
   * The auto-refresh task, or undefined if not running.
   *
   * @private
   * @type {Ext.util.TaskRunner.Task}
   */
  refreshTask: undefined,

  /**
   * Toggle auto-refresh.
   *
   * @protected
   * @param {boolean} enable
   */
  autoRefresh: function(enable) {
    var me = this;

    if (enable) {
      //<if assert>
//      NX.Assert.assert(me.refreshTask === undefined, 'Auto-refresh task already exists');
      //</if>

      me.refreshTask = Ext.util.TaskManager.start({
        interval: 1000,
        fireOnStart: true,
        run: function() {
          me.refresh();
        }
      });

      //<if debug>
//      me.logDebug('Auto-refresh enabled');
      //</if>
    }
    else if (me.refreshTask) {
      Ext.util.TaskManager.stop(me.refreshTask);
      delete me.refreshTask;

      //<if debug>
//      me.logDebug('Auto-refresh disabled');
      //</if>
    }
  },

  /**
   * @override
   */
  refresh: function() {
    var me = this;

    NX.direct.migration_Progress.read(me.getPhase(), function (response, event) {
      if (event.status && response.success) {
        var payload = response.data,
            store = me.getStore('NX.coreui.migration.ProgressStore');

        me.getScreenCmp().getProgressBar().updateProgress(payload.complete);

        // replace records
        store.loadData(payload.steps, false);

        // if completed, stop auto-refresh and inform
        if (payload.complete / 1 === 1) {
          me.autoRefresh(false);
          me.doComplete();
        }
      }
    });
  },

  /**
   * Extension-point to inform when progress has indicated completion.
   *
   * @protected
   * @template
   */
  doComplete: Ext.emptyFn,

  /**
   * @private
   */
  doDisplayDetail: function(grid, td, cellIndex, record) {
    this.controller.displayPlanStepDetail(record.get('id'));
    return false;
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Migration FINISH phase step.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.migration.PhaseFinishStep', {
  extend: 'NX.coreui.migration.ProgressStepSupport',
  requires: [
    'NX.coreui.migration.PhaseFinishScreen'
  ],

  config: {
    screen: 'NX.coreui.migration.PhaseFinishScreen',
    enabled: true
  },

  phase: 'FINISH',

  /**
   * @override
   */
  init: function () {
    var me = this;

    me.control({
      'button[action=abort]': {
        click: me.doAbort
      },
      'button[action=done]': {
        click: me.doDone
      }
    });

    me.callParent();
  },

  /**
   * @override
   */
  reset: function() {
    var me = this,
        screen = me.getScreenCmp();

    if (screen) {
      screen.down('button[action=abort]').enable();
      screen.down('button[action=done]').disable();
    }
    me.callParent();
  },

  /**
   * @override
   */
  doComplete: function() {
    this.getScreenCmp().down('button[action=abort]').disable();
    this.getScreenCmp().down('button[action=done]').enable();
  },

  /**
   * @private
   */
  doAbort: function() {
    var me = this;

    NX.Dialogs.askConfirmation(
        NX.I18n.render(me, 'Abort_Confirm_Title'),
        NX.I18n.render(me, 'Abort_Confirm_Text'),
        function () {
          me.mask(NX.I18n.render(me, 'Abort_Mask'));

          me.autoRefresh(false);

          NX.direct.migration_Assistant.abort(function (response, event) {
            me.unmask();

            if (event.status && response.success) {
              me.controller.reset();

              NX.Messages.warning(NX.I18n.render(me, 'Abort_Message'));
            }
          });
        }
    );
  },

  /**
   * @private
   */
  doDone: function() {
    var me = this;

    me.mask(NX.I18n.render(me, 'Done_Mask'));

    NX.direct.migration_Assistant.done(function (response, event) {
      me.unmask();

      if (event.status && response.success) {
        me.finish();

        NX.Messages.success(NX.I18n.render(me, 'Done_Message'));
      }
    });
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Firewall repository status model.
 *
 * @since 3.2
 */
Ext.define('NX.coreui.model.FirewallRepositoryStatus', {
  extend: 'Ext.data.Model',
  idProperty: 'repositoryName',
  fields: [
    {name:'repositoryName', type: 'string', sortType: 'asUCText'},
    {name:'affectedComponentCount', type: 'int'},
    {name:'criticalComponentCount', type: 'int'},
    {name:'moderateComponentCount', type: 'int'},
    {name:'quarantinedComponentCount', type: 'int'},
    {name:'severeComponentCount', type: 'int'},
    {name:'reportUrl', type: 'string', sortType: 'asUCText'},
    {name:'message', type: 'string', sortType: 'asUCText'},
    {name:'errorMessage', type: 'string', sortType: 'asUCText'}
  ]
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Firewall repository status store.
 *
 * @since 3.2
 */
Ext.define('NX.coreui.store.FirewallRepositoryStatus', {
  extend: 'Ext.data.Store',
  model: 'NX.coreui.model.FirewallRepositoryStatus',

  loaded: false,

  proxy: {
    type: 'direct',
    paramsAsHash: false,

    api: {
      read: 'NX.direct.firewall_RepositoryStatus.read'
    },

    reader: {
      type: 'json',
      rootProperty: 'data',
      successProperty: 'success'
    }
  },

  listeners: {
    beforeload: function() {
      this.loaded = false;
    },
    load: function() {
      this.loaded = true;
    }
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Migration repository model.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.migration.RepositoryModel', {
  extend: 'Ext.data.Model',
  idProperty: 'repository',
  fields: [
    {name: 'repository', type: 'string', sortType: 'asUCText'},
    {name: 'name', type: 'string', sortType: 'asUCText'},
    {name: 'type', type: 'string', sortType: 'asUCText'},
    {name: 'format', type: 'string', sortType: 'asUCText'},
    {name: 'supported', type: 'boolean'},
    {name: 'status', type: 'string'},
    {name: 'blobStore', type: 'string'},
    {name: 'ingestMethod', type: 'string'}
  ]
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Migration repository store.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.migration.RepositoryStore', {
  extend: 'Ext.data.ArrayStore',
  requires: [
    'NX.coreui.migration.RepositoryModel'
  ],

  model: 'NX.coreui.migration.RepositoryModel',

  sorters: { property: 'repository', direction: 'ASC' }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Node list.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.system.NodeList', {
  extend: 'NX.view.drilldown.Master',
  alias: 'widget.nx-coreui-system-nodelist',
  requires: [
    'NX.I18n'
  ],

  config: {
    stateful: true,
    stateId: 'nx-coreui-system-nodelist'
  },

  store: 'Node',

  columns: [
    {
      xtype: 'nx-iconcolumn',
      width: 36,
      iconVariant: 'x16',
      iconName: function () {
        return 'node-default';
      }
    },
    {
      header: 'Node Name',
      dataIndex: 'friendlyName',
      stateId: 'friendlyName',
      flex: 1,
      renderer: Ext.htmlEncode
    },
    {
      header: 'Socket Address',
      dataIndex: 'socketAddress',
      stateId: 'socketAddress',
      flex: 1,
      renderer: Ext.htmlEncode
    },
    {
      header: 'Node Identity',
      dataIndex: 'nodeIdentity',
      stateId: 'nodeIdentity',
      flex: 1,
      renderer: Ext.htmlEncode
    }
  ],

  // Add a white background behind the filter, to make it look like part of the header
  dockedItems: [
    {
      xtype: 'nx-actions',
      items: [
        {
          xtype: 'button',
          text: 'Enable read-only mode',
          glyph: 'xf1e5@FontAwesome' /* fa-binoculars */,
          action: 'freeze'
        }
      ]
    }
  ],

  plugins: [
    {ptype: 'gridfilterbox', emptyText: 'No nodes matched "$filter"'}
  ]
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Select privilege type window.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.privilege.PrivilegeSelectType', {
  extend: 'NX.view.drilldown.Master',
  alias: 'widget.nx-coreui-privilege-selecttype',
  requires: [
    'NX.I18n'
  ],

  cls: 'nx-hr',

  initComponent: function() {
    var me = this;

    Ext.apply(me, {

      store: 'PrivilegeType',

      columns: [
        {
          xtype: 'nx-iconcolumn',
          dataIndex: 'id',
          width: 36,
          iconVariant: 'x16',
          iconNamePrefix: 'privilege-'
        },
        {
          header: NX.I18n.get('Privilege_PrivilegeSelectType_Type_Header'),
          dataIndex: 'name',
          flex: 1
        }
      ]
    });

    me.callParent();
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Capability type model.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.model.CapabilityType', {
  extend: 'Ext.data.Model',
  fields: [
    {name: 'id', type: 'string', sortType: 'asUCText'},
    {name: 'name', type: 'string', sortType: 'asUCText'},
    {name: 'about', type: 'string', sortType: 'asUCText'},
    {name: 'formFields', type: 'auto' /*object*/}
  ]
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Capability type store.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.store.CapabilityType', {
  extend: 'Ext.data.Store',
  model: 'NX.coreui.model.CapabilityType',

  proxy: {
    type: 'direct',
    paramsAsHash: false,
    api: {
      read: 'NX.direct.capability_Capability.readTypes'
    },

    reader: {
      type: 'json',
      rootProperty: 'data',
      successProperty: 'success'
    }
  },

  sorters: { property: 'name', direction: 'ASC' }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Add role window.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.role.RoleAdd', {
  extend: 'NX.view.AddPanel',
  alias: 'widget.nx-coreui-role-add',
  requires: [
    'NX.Conditions',
    'NX.I18n'
  ],

  defaultFocus: 'id',

  initComponent: function() {
    var me = this;

    me.settingsForm = {
      xtype: 'nx-coreui-role-settings-form',
      api: {
        submit: 'NX.direct.coreui_Role.create'
      },
      settingsFormSuccessMessage: function(data) {
        return NX.I18n.get('Role_RoleAdd_Create_Success') + Ext.htmlEncode(data['name']);
      },
      editableCondition: NX.Conditions.isPermitted('nexus:roles:create'),
      editableMarker: NX.I18n.get('Role_RoleAdd_Create_Error'),
      source: me.source,

      buttons: [
        { text: NX.I18n.get('Role_RoleList_New_Button'), action: 'add', formBind: true, ui: 'nx-primary' },
        { text: NX.I18n.get('Add_Cancel_Button'), action: 'back' }
      ]
    };

    me.callParent();

    me.down('#id').setReadOnly(false);
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Support Request panel.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.support.SupportRequest', {
  extend: 'NX.view.SettingsPanel',
  alias: 'widget.nx-coreui-support-supportrequest',
  requires: [
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function() {
    Ext.apply(this, {
      settingsForm: {
        xtype: 'nx-settingsform',
        items: [
          {
            xtype: 'label',
            html: NX.I18n.get('Support_SupportRequest_HelpText')
          }
        ],

        buttonAlign: 'left',

        buttons: [
          {
            text: NX.I18n.get('Support_SupportRequest_Submit_Button'),
            glyph: 'xf08e@FontAwesome' /* fa-external-link */,
            action: 'makerequest',
            ui: 'nx-primary'
          }
        ]
      }
    });

    this.callParent();
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Support Request controller.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.controller.SupportRequest', {
  extend: 'NX.app.Controller',
  requires: [
    'NX.State',
    'NX.Permissions',
    'NX.Windows',
    'NX.I18n'
  ],

  views: [
    'support.SupportRequest'
  ],

  /**
   * @override
   */
  init: function () {
    var me = this;

    me.getApplication().getFeaturesController().registerFeature({
      mode: 'admin',
      path: '/Support/Support Request',
      text: NX.I18n.get('SupportRequest_Text'),
      description: NX.I18n.get('SupportRequest_Description'),
      view: { xtype: 'nx-coreui-support-supportrequest' },
      iconConfig: {
        file: 'premium_support.png',
        variants: ['x16', 'x32']
      },
      visible: function () {
        // only show if edition is not OSS (ie. PRO or trial) and we have perms
        return NX.State.getEdition() !== 'OSS' &&
            NX.Permissions.check('nexus:atlas:create');
      }
    }, me);

    me.listen({
      component: {
        'nx-coreui-support-supportrequest button[action=makerequest]': {
          click: me.makeRequest
        }
      }
    });
  },

  /**
   * @private
   * Open sonatype support in a new browser window/tab.
   */
  makeRequest: function () {
    NX.Windows.open('http://links.sonatype.com/products/nexus/pro/support-request');
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Roles / source store.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.store.RoleBySource', {
  extend: 'Ext.data.Store',
  model: 'NX.coreui.model.Reference',

  proxy: {
    type: 'direct',
    paramOrder: 'source',

    api: {
      read: 'NX.direct.coreui_Role.readFromSource'
    },

    reader: {
      type: 'json',
      rootProperty: 'data',
      successProperty: 'success'
    }
  },

  sorters: { property: 'name', direction: 'ASC' }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Abstract superclass for the different types of task schedule fields we dynamically create.
 *
 * @since 3.13
 */
Ext.define('NX.coreui.view.task.TaskScheduleFields', {
  extend: 'Ext.form.FieldContainer',
  alias: 'widget.nx-coreui-task-schedule-fields'
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Task Schedule Hourly field set.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.task.TaskScheduleHourly', {
  extend: 'NX.coreui.view.task.TaskScheduleFields',
  alias: 'widget.nx-coreui-task-schedule-hourly',
  requires: [
    'NX.util.DateFormat',
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    me.items = [
      {
        xtype: 'datefield',
        name: 'startDate',
        itemId: 'startDate',
        fieldLabel: NX.I18n.get('Task_TaskScheduleDaily_StartDate_FieldLabel'),
        allowBlank: false,
        format: 'm/d/Y',
        value: new Date(),
        submitValue: false
      },
      {
        xtype: 'timefield',
        name: 'startTime',
        fieldLabel: NX.I18n.get('Task_TaskScheduleHourly_EndDate_FieldLabel'),
        itemId: 'startTime',
        helpText: 'The time this task should start running in your time zone ' + NX.util.DateFormat.getTimeZone() + '.',
        allowBlank: false,
        format: 'H:i',
        submitValue: false
      }
    ];

    me.callParent();
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Repository "Settings" form for a Git LFS Hosted repository.
 *
 * @since 3.3
 */
Ext.define('NX.coreui.view.repository.recipe.GitLfsHosted', {
  extend: 'NX.coreui.view.repository.RepositorySettingsForm',
  alias: 'widget.nx-coreui-repository-gitlfs-hosted',
  requires: [
    'NX.coreui.view.repository.facet.StorageFacet',
    'NX.coreui.view.repository.facet.StorageFacetHosted',
    'NX.coreui.view.repository.facet.CleanupPolicyFacet'
  ],

  /**
   * @override
   */
  initComponent: function() {
    var me = this;

    me.items = [
      { xtype: 'nx-coreui-repository-storage-facet'},
      { xtype: 'nx-coreui-repository-storage-hosted-facet'},
      { xtype: 'nx-coreui-repository-cleanup-policy-facet'}
    ];

    me.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Registers all feature groups for coreui.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.controller.FeatureGroups', {
  extend: 'NX.app.Controller',
  requires: [
    'NX.I18n'
  ],

  /**
   * @override
   */
  init: function () {
    this.getApplication().getFeaturesController().registerFeature([
      {
        mode: 'admin',
        path: '/Repository',
        text: NX.I18n.get('FeatureGroups_Repository_Text'),
        description: NX.I18n.get('FeatureGroups_Repository_Description'),
        group: true,
        weight: 50,
        iconConfig: {
          file: 'database.png',
          variants: ['x16', 'x32']
        }
      },
      {
        mode: 'admin',
        path: '/Security',
        text: NX.I18n.get('FeatureGroups_Security_Title'),
        description: NX.I18n.get('FeatureGroups_Security_Description'),
        group: true,
        weight: 90,
        iconConfig: {
          file: 'security.png',
          variants: ['x16', 'x32']
        }
      },
      {
        mode: 'admin',
        path: '/Support',
        text: NX.I18n.get('FeatureGroups_Support_Text'),
        description: NX.I18n.get('FeatureGroups_Support_Description'),
        group: true,
        iconConfig: {
          file: 'support.png',
          variants: ['x16', 'x32']
        }
      },
      {
        mode: 'admin',
        path: '/System',
        text: NX.I18n.get('FeatureGroups_System_Text'),
        description: NX.I18n.get('FeatureGroups_System_Description'),
        group: true,
        weight: 1000,
        iconConfig: {
          file: 'cog.png',
          variants: ['x16', 'x32']
        }
      },
      {
        mode: 'browse',
        path: '/Upload',
        text: NX.I18n.get('FeatureGroups_Upload_Text'),
        description: NX.I18n.get('FeatureGroups_Upload_Description'),
        group: true,
        iconConfig: {
          file: 'upload.png',
          variants: ['x16', 'x32']
        }
      }
    ]);
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Privilege grid.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.privilege.PrivilegeList', {
  extend: 'NX.view.drilldown.Master',
  alias: 'widget.nx-coreui-privilege-list',
  requires: [
    'NX.Icons',
    'NX.I18n'
  ],

  stateful: true,
  stateId: 'nx-coreui-privilege-list',

  // filter will install into toolbar, ensure its properly styled for drilldown
  tbar: {
    xtype: 'nx-actions'
  },

  /**
   * @override
   */
  initComponent: function() {
    var me = this;

    Ext.apply(me, {
      store: 'Privilege',

      columns: [
        {
          xtype: 'nx-iconcolumn',
          dataIndex: 'type',
          width: 36,
          iconVariant: 'x16',
          iconNamePrefix: 'privilege-'
        },

        // NOTE: Not including ID here as for user-created privileges these are random strings

        { header: NX.I18n.get('Privilege_PrivilegeList_Name_Header'), dataIndex: 'name', stateId: 'name', flex: 2 },

        {
          header: NX.I18n.get('Privilege_PrivilegeList_Description_Header'),
          dataIndex: 'description',
          stateId: 'description',
          flex: 4
        },

        { header: NX.I18n.get('Privilege_PrivilegeList_Type_Header'), dataIndex: 'type', stateId: 'type', flex: 1 },

        {
          header: NX.I18n.get('Privilege_PrivilegeList_Permission_Header'),
          dataIndex: 'permission',
          stateId: 'permission',
          flex: 2
        }
      ],

      viewConfig: {
        emptyText: NX.I18n.get('Privilege_PrivilegeList_EmptyText'),
        emptyTextFilter: NX.I18n.get('Privilege_PrivilegeList_Filter_EmptyText'),
        deferEmptyText: false
      },

      selModel: {
        pruneRemoved: false
      },

      dockedItems: [{
        xtype: 'nx-actions',
        items: [
          {
            xtype: 'button',
            text: NX.I18n.get('Privilege_PrivilegeList_New_Button'),
            action: 'new',
            disabled: true,
            glyph: 'xf055@FontAwesome' /* fa-plus-circle */
          }
        ]
      }],

      plugins: [
        {ptype: 'remotegridfilterbox'}
      ]
    });

    me.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * All Repository reference store. includes items such as 'All Repositories', 'All Maven2 Repositories', etc.
 *
 * @since 3.1
 */
Ext.define('NX.coreui.store.AllRepositoriesReference', {
  extend: 'Ext.data.Store',
  model: 'NX.coreui.model.RepositoryReference',

  proxy: {
    type: 'direct',

    api: {
      read: 'NX.direct.coreui_Repository.readReferencesAddingEntriesForAllFormats'
    },

    reader: {
      type: 'json',
      rootProperty: 'data',
      successProperty: 'success'
    }
  },

  sortOnLoad: true,
  sorters: [{ property: 'sortOrder', direction: 'DESC' }, { property: 'name', direction: 'ASC' }]

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Capability grid.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.capability.CapabilityList', {
  extend: 'NX.view.drilldown.Master',
  alias: 'widget.nx-coreui-capability-list',
  requires: [
    'NX.I18n',
    'NX.ext.grid.column.Renderers'
  ],

  /**
   * Copy of original column configuration, to support adding dynamic tag columns.
   *
   * @cfg
   */
  originalColumns: undefined,

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    me.store = 'Capability';

    me.columns = [
      {
        xtype: 'nx-iconcolumn',
        width: 36,
        iconVariant: 'x16',
        iconNamePrefix: 'capability-',
        dataIndex: 'state',
        hideable: false
      },
      {
        text: NX.I18n.get('Capability_CapabilityList_Type_Header'),
        dataIndex: 'typeName',
        flex: 1,
        renderer: Ext.htmlEncode
      },
      {
        text: NX.I18n.get('Capability_CapabilityList_Description_Header'),
        dataIndex: 'description',
        flex: 1,
        groupable: false,
        renderer: NX.ext.grid.column.Renderers.optionalData
      },
      {
        text: NX.I18n.get('Capability_CapabilityList_Notes_Header'),
        dataIndex: 'notes',
        flex: 1,
        renderer: NX.ext.grid.column.Renderers.optionalData
      }
    ];

    me.viewConfig = {
      emptyText: NX.I18n.get('Capability_CapabilityList_EmptyText'),
      deferEmptyText: false,
      getRowClass: function (record) {
        if (record.get('enabled') && !record.get('active')) {
          return 'nx-red-marker';
        }
      }
    };

    me.dockedItems = [{
      xtype: 'nx-actions',
      items: [
        {
          xtype: 'button',
          text: NX.I18n.get('Capability_CapabilityList_New_Button'),
          action: 'new',
          disabled: true,
          glyph: 'xf055@FontAwesome' /* fa-plus-circle */
        }
      ]
    }];

    me.features = [
      {
        ftype: 'grouping',
        groupHeaderTpl: '{[values.name === "" ? "No " + values.columnName : values.name + " " + values.columnName]}'
      }
    ];

    me.plugins = [
      { ptype: 'gridfilterbox', emptyText: NX.I18n.get('Capability_CapabilityList_Filter_EmptyText') }
    ];

    me.originalColumns = me.columns;

    me.callParent();
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * @since 3.7
 */
Ext.define('NX.coreui.view.upload.UploadComponentFeature', {
  extend: 'NX.view.drilldown.Drilldown',
  alias: 'widget.nx-coreui-uploadcomponentfeature',

  iconName: 'upload-component-default',

  masters: [
    {xtype: 'nx-coreui-upload-repository-list'},
    {xtype: 'nx-coreui-upload-component'}
  ]
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Repository reference store.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.store.RepositoryReference', {
  extend: 'Ext.data.Store',
  model: 'NX.coreui.model.RepositoryReference',

  proxy: {
    type: 'direct',

    api: {
      read: 'NX.direct.coreui_Repository.readReferences'
    },

    reader: {
      type: 'json',
      rootProperty: 'data',
      successProperty: 'success'
    }
  },

  sortOnLoad: true,
  sorters: { property: 'name', direction: 'ASC' }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Upload Component View
 *
 * @since 3.7
 */
Ext.define('NX.coreui.view.upload.UploadComponent', {
    extend: 'NX.view.AddPanel',
    alias: 'widget.nx-coreui-upload-component',
    requires: [
      'NX.I18n',
      'Ext.util.Cookies'
    ],

    /**
     * @override
     */
    initComponent: function() {
      var me = this;
      me.store = 'UploadDefinition';

      me.callParent();
    },

    loadRecord: function(uploadDefinition, repository) {
      var me = this,
          uiSettings = NX.State.getValue('uiSettings', {});

      me.uploadDefinition = uploadDefinition;
      me.repository = repository;

      var fields = me.uploadDefinition.get('componentFields').reduce(me.byGroup, {}),
          groupedFields = me.createFieldsets(fields);

      me.removeAll(true);
      me.add(
        {
          xtype: 'panel',
          ui: 'nx-inset',
          items: [{
            xtype: 'nx-settingsform',
            timeout: uiSettings['longRequestTimeout'],
            api: {
              submit: 'NX.direct.coreui_Upload.doUpload'
            },
            baseParams: {
              'NX-ANTI-CSRF-TOKEN': Ext.util.Cookies.get('NX-ANTI-CSRF-TOKEN')
            },
            buttons: [{
              text: NX.I18n.get('FeatureGroups_Upload_Form_Upload_Button'),
              action: 'upload',
              formBind: true,
              ui: 'nx-primary'
            }, {
              text: NX.I18n.get('FeatureGroups_Upload_Form_Discard_Button'),
              action: 'cancel'
            }],
            items: [{
              xtype: 'fieldcontainer',
              width: 700,
              items: [{
                xtype: 'fieldset',
                cls: 'nx-form-section',
                itemId: 'nx-coreui-upload-component-assets',
                nextSuffix: 0,
                title: NX.I18n.get('FeatureGroups_Upload_Asset_Form_Title'),
                items: [
                  me.createHeader(),
                  me.createRow(),
                  {
                    xtype: 'button',
                    text: NX.I18n.get('FeatureGroups_Upload_Asset_Form_Add_Asset_Button'),
                    action: 'add_asset',
                    hidden: !me.uploadDefinition.get('multipleUpload')
                  }
                ]
              }, {
                xtype: 'container',
                cls: 'nx-form-section',
                itemId: 'nx-coreui-upload-component-fields',
                layout: {
                  type: 'vbox',
                  align: 'stretch'
                },
                items: groupedFields,
                hidden: groupedFields.length === 0
              }, {
                xtype: 'hidden',
                name: 'repositoryName',
                value: repository.get('name')
              }]
            }],
            dockedItems: [{
              xtype: 'panel',
              itemId: 'nx-coreui-upload-success-message',
              ui: 'nx-drilldown-message',
              cls: 'nx-drilldown-info',
              iconCls: NX.Icons.cls('tick', 'x16'),
              hidden: true,
              dock: 'top'
            }]
          }]
        }
      );

      if (me.repository.get('format') === 'maven2') {
        me.down('textfield[name=packaging]').setDisabled(true);
      }
    },

    addAssetRow: function() {
      var me = this,
          assetPanel = me.down('#nx-coreui-upload-component-assets');

      if (assetPanel) {
        var row = me.createRow(),
            fields = row.items,
            suffix = assetPanel.nextSuffix++;

        fields.forEach(function(field) {
          field.name += suffix;
        });

        assetPanel.insert(assetPanel.items.items.length - 1, row);
      }
    },

    createHeader: function() {
      var me = this,
          header = {
            xtype: 'container',
            layout: {
              type: 'hbox',
              align: 'stretch'
            },
            items: [
              {
                xtype: 'label',
                text: NX.I18n.get('FeatureGroups_Upload_Asset_Form_File_Label'),
                cls: 'nx-table-header-label',
                width: 305,
                height: 25
              }
            ]
          },
          assetFields = me.uploadDefinition.get('assetFields');

      assetFields.forEach(function(assetField) {
        header.items.push({
          xtype: 'label',
          text: assetField.displayName,
          cls: 'nx-table-header-label',
          width: 145,
          height: 25
        });
      });

      return header;
    },

    createRow: function() {
      var me = this,
          row = {
              xtype: 'panel',
              layout: 'column',
              cls: 'nx-repeated-row',
              items: [{
                  xtype: 'fileuploadfield',
                  cls: 'nx-float-left',
                  allowBlank: false,
                  submitValue: true,
                  clearOnSubmit: false,
                  buttonText: NX.I18n.get('FeatureGroups_Upload_Form_Browse_Button'),
                  buttonConfig: {
                      glyph: 'xf016@FontAwesome' /* fa-file-o */
                  },
                  name: 'file',
                  width: '300px',
                  listeners: {
                    change: function() {
                      me.fileChange.apply(me, arguments);
                    }
                  }
              }]
          };

      var assetFields = me.uploadDefinition.get('assetFields');

      assetFields.forEach(function(assetField) {
          row.items.push(me.createAssetField(assetField));
      });

      row.items.push({
        xtype: 'button',
        text: NX.I18n.get('FeatureGroups_Upload_Asset_Form_Remove_Button'),
        glyph: 'xf1f8@FontAwesome' /* fa-trash */,
        action: 'remove_upload_asset',
        hidden: true
      });

      return row;
    },

    createComponentField: function (field) {
      var me = this;
      return me.createField(field, false);
    },

    createAssetField: function(field) {
      var me = this;
      return me.createField(field, true, '140px', 'nx-float-left', me.validateUniqueAsset);
    },

    createField: function (field, hideLabel, width, cls, validator) {
      var widget = {
        allowBlank: field.optional,
        name: field.name,
        width: width,
        cls: cls,
        validator: validator,
        listeners: {
          change: function() {
            this.up('form').isValid();
          }
        }
      };

      if (field.type === 'STRING') {
        widget.xtype = 'textfield';
        widget.fieldLabel = hideLabel ? undefined : field.displayName;
        widget.helpText = field.helpText || undefined;
      }
      else if (field.type === 'BOOLEAN') {
        widget.xtype = 'checkbox';
        widget.boxLabel = field.displayName;
      }
      return widget;
    },

    byGroup: function(accumulator, value) {
      var group = value.group;
      if (accumulator[group]) {
        accumulator[group].push(value);
      }
      else {
        accumulator[group] = [value];
      }
      return accumulator;
    },

    createFieldsets: function(fields) {
      var groupFields = [];
      for (var groupName in fields) {
        if (fields.hasOwnProperty(groupName)) {
          groupFields.push({
            xtype: 'fieldset',
            cls: 'nx-form-section',
            title: groupName,
            layout: {
              type: 'vbox',
              align: 'stretch'
            },
            items: fields[groupName].map(this.createComponentField, this),
            hidden: fields[groupName].length === 0
          });
        }
      }
      return groupFields;
    },

    fileChange: function(fileField, value) {
      var me = this,
          regexMap = me.uploadDefinition.get('regexMap'),
          filename, match, suffix;

      if (regexMap && value) {
        filename = value.substring(value.lastIndexOf((value.indexOf('/') === 0) ? '/' : '\\') + 1);
        match = filename.match(regexMap.regex);

        if (match) {
          suffix = (fileField.name.match("file(\\d*)") || [])[1] || '';
          regexMap.fieldList.forEach(function(field, index) {
            if (field) {
              var input = me.down('textfield[name=' + field + suffix + ']') || me.down('textfield[name=' + field + ']') ;
              if (input) {
                input.setValue(match[index + 1]);
              }
            }
          });
        }
      }
    },

    validateUniqueAsset: function() {
      var me = this,
          assetRow = me.up(),
          assetValue = {},
          assetRows = Ext.Array.difference(assetRow.up().query('panel'), [assetRow]);

      function trim(val) {
        return val ? val.trim() : val;
      }

      assetRow.query('textfield,checkboxfield').forEach(function(field) {
        assetValue[field.name.replace(/[0-9]/g, '')] = trim(field.value);
      });

      var duplicate = Ext.Array.findBy(assetRows, function(row) {
        var isDuplicate = true;
        Object.keys(assetValue).forEach(function(fieldName) {
          isDuplicate = isDuplicate &&
              (trim(row.query('field[name^=' + fieldName + ']')[0].value) === assetValue[fieldName]);
        });
        return isDuplicate;
      });

      return (duplicate === null) || NX.I18n.get('FeatureGroups_Upload_Asset_Form_Not_Unique_Error_Message');
    }

  });

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Upload controller.
 *
 * @since 3.7
 */
Ext.define('NX.coreui.controller.UploadComponent', {
  extend: 'NX.controller.Drilldown',
  requires: [
    'NX.Bookmarks',
    'NX.Conditions',
    'NX.Permissions',
    'NX.I18n'
  ],
  masters: [
    'nx-coreui-uploadcomponentfeature nx-coreui-upload-repository-list',
    'nx-coreui-uploadcomponentfeature nx-coreui-upload-component'
  ],
  stores: [
    'RepositoryReference',
    'UploadComponentDefinition'
  ],
  models: [
    'UploadComponentDefinition',
    'RepositoryReference'
  ],

  views: [
    'upload.UploadComponentFeature',
    'upload.UploadComponent',
    'upload.UploadRepositoryList'
  ],

  refs: [
    {ref: 'feature', selector: 'nx-coreui-uploadcomponentfeature'},
    {ref: 'repositoryList', selector: 'nx-coreui-uploadcomponentfeature nx-coreui-upload-repository-list'},
    {ref: 'uploadComponent', selector: 'nx-coreui-uploadcomponentfeature nx-coreui-upload-component'},
    {ref: 'successMessage', selector: '#nx-coreui-upload-success-message'}
  ],

  icons: {
    'upload': {
      file: 'upload.png',
      variants: ['x16', 'x32']
    },
    'tick': {
      file: 'tick.png',
      variants: ['x16', 'x32']
    }
  },

  /**
   * @override
   */
  init: function() {
    var me = this;

    me.features = {
      mode: 'browse',
      path: '/Upload',
      text: NX.I18n.get('FeatureGroups_Upload_Text'),
      description: NX.I18n.get('FeatureGroups_Upload_Description'),
      view: 'NX.coreui.view.upload.UploadComponentFeature',
      group: false,
      iconCls: 'x-fa fa-upload',
      authenticationRequired: false,
      visible: function() {
          return NX.Permissions.check('nexus:component:add');
      }
    };

    me.callParent();

    me.listen({
      controller: {
        '#Refresh': {
          refresh: me.loadStores
        }
      },
      component: {
        'nx-coreui-uploadcomponentfeature nx-coreui-upload-repository-list': {
          beforerender: me.onBeforeRender
        },
        'nx-coreui-upload-component button[action=remove_upload_asset]': {
          click: me.removeUploadAsset
        },
        'nx-coreui-upload-component button[action=upload]': {
          click: me.doUpload
        },
        'nx-coreui-upload-component button[action=cancel]': {
          click: me.discardUpload
        },
        'nx-coreui-upload-component button[action=add_asset]': {
          click: me.addAsset
        },
        'nx-coreui-upload-component textfield[name^=extension]': {
          change: me.onExtensionChange
        },
        'nx-coreui-upload-component checkbox[name=generate-pom]' : {
          change: me.onGeneratePomChange
        }
      }
    });
  },

  /**
   * @override
   */
  getDescription: function(model) {
    return model.get('name');
  },

  /**
   * @override
   * When a list managed by this controller is clicked, route the event to the proper handler
   */
  onSelection: function(list, model) {
    this.loadUploadPage(model);
  },

  loadUploadPage: function(repoModel) {
    var uploadComponentDefinition = this.getStore('UploadComponentDefinition').getById(repoModel.get('format'));
    this.getUploadComponent().loadRecord(uploadComponentDefinition, repoModel);
  },

  /**
   * @override
   */
  onNavigate: function() {
    if (this.getFeature()) {
      this.onBeforeRender();
    }
  },

  loadView: function (index, model) {
    this.callParent(arguments);
    if (model) {
        //redraw the panel after visible, to get around issue where file field can be drawn at invalid size
        this.loadUploadPage(model);
    }
  },

  /**
   * @private
   * Load stores based on the bookmarked URL
   */
  onBeforeRender: function() {
    var me = this,
        uploadComponent = me.getUploadComponent(),
        bookmark = NX.Bookmarks.getBookmark(),
        list_ids = bookmark.getSegments().slice(1),
        repoStore = me.getRepositoryList().getStore(),
        repoModel;

    // If the list hasn’t loaded, don't do anything
    if (!uploadComponent) {
      return;
    }

    repoStore.removeAll();

    this.getStore('UploadComponentDefinition').load(function (data) {
        var formats = [];

        data.forEach(function(def) {
          formats.push(def.get('format'));
        });

        repoStore.addFilter([{
          property: 'format',
          filterFn: function(item) {
            return formats.indexOf(item.get('format')) !== -1;
          }
        }, {
          property: 'type',
          value: 'hosted'
        }, {
          property: 'versionPolicy',
          filterFn: function(item) {
            return item.get('versionPolicy') == null || item.get('versionPolicy') !== 'SNAPSHOT';
          }
        }]);
        repoStore.load(function () {
            // Load the asset upload page
            if (list_ids[1]) {
                repoModel = repoStore.getById(decodeURIComponent(list_ids[0]));
                uploadComponent.getStore().load(function () {
                    me.onModelChanged(0, repoModel);
                    me.onSelection(undefined, repoModel);
                });
            }
            // Load the asset list view or repository list view
            else {
                me.reselect();
            }
        });
    });
  },

  removeUploadAsset: function(fileUploadField) {
    var me = this;

    fileUploadField.up('#nx-coreui-upload-component-assets').remove(fileUploadField.up());
    me.refreshRemoveButtonState();
    me.updatePomFileState();
  },

  doUpload: function(button) {
    var me = this,
        fp = button.up('form');

    if(fp.getForm().isValid()) {
      me.setSuccessMessage();

      fp.getForm().submit({
        waitMsg: NX.I18n.get('FeatureGroups_Upload_Wait_Message'),
        success: function(form, action){
          var message = NX.I18n.format('FeatureGroups_Upload_Successful_Text', form.getValues().repositoryName);
          if (NX.Permissions.check('nexus:search:read')) {
            message += ", " + NX.util.Url.asLink(
                '#browse/search=' + encodeURIComponent('keyword="' + action.result.data + '"'),
                NX.I18n.get('FeatureGroups_Upload_Successful_Link_Text'), '_self');
          }
          me.setSuccessMessage(message);
          me.resetForm();
        }
      });
    }
  },

  setSuccessMessage: function (message) {
      var me = this,
          successMessage = me.getSuccessMessage();

      if (message) {
          successMessage.setTitle(message);
          successMessage.show();
      }
      else {
          successMessage.hide();
      }
  },

  discardUpload: function() {
    var me = this;
    me.resetForm();
    me.loadView(me.BROWSE_INDEX);
  },

  resetForm: function() {
    var me = this,
        form = me.getUploadComponent().down('form');

    form.getForm().reset();

    // remove rows
    form.query('fileuploadfield').forEach(function(fileUploadField) {
      me.removeUploadAsset(fileUploadField);
    });

    // create new row
    me.addAsset();

    // clearOnSubmit prevents normal form reset from working...
    form.down('fileuploadfield').inputEl.dom.value = '';
  },

  addAsset: function() {
    var me = this,
        uploadComponent = me.getUploadComponent(),
        form = uploadComponent.down('form');

    uploadComponent.addAssetRow();
    me.refreshRemoveButtonState();
    me.updatePomFileState();
    form.isValid();
  },

  onExtensionChange: function() {
    var me = this,
        form = me.getUploadComponent().down('form');

    me.updatePomFileState();
    form.isValid();
  },

  updatePomFileState: function() {
    var me = this,
        form = me.getUploadComponent().down('form'),
        componentCoordinatesFieldset = form.down('fieldset[title="Component coordinates"]'),
        isPomFilePresent = form.query('textfield[name^=extension][value=pom]').length !== 0;

    if (componentCoordinatesFieldset === null) {
        return;
    }

    componentCoordinatesFieldset.setDisabled(isPomFilePresent);
    if (isPomFilePresent) {
      componentCoordinatesFieldset.mask(NX.I18n.get('FeatureGroups_Upload_Form_DetailsFromPom_Mask'), 'nx-mask-without-spinner');
    }
    else {
      componentCoordinatesFieldset.unmask();
    }
  },

  /**
   * @private
   * Hide remove buttons if there is only one asset displayed
   */
  refreshRemoveButtonState: function() {
    var me = this,
        buttons = me.getUploadComponent().query('button[action=remove_upload_asset]'),
        hidden = (buttons.length === 1);

    buttons.forEach(function(button) {
      button.setVisible(!hidden);
    });
  },

  /**
   * @private
   * Change disabled state of packaging field based on generate pom checkbox
   */
  onGeneratePomChange: function(element) {
    element.up('form').down('textfield[name=packaging]').setDisabled(!element.getValue());
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * 'itemselect' factory.
 *
 * @since 3.1
 */
Ext.define('NX.coreui.view.formfield.factory.FormfieldItemselectFactory', {
  singleton: true,
  alias: [
    'nx.formfield.factory.itemselect'
  ],
  requires: [
    'Ext.data.Store',
    'Ext.data.SortTypes',
    'NX.ext.form.field.ItemSelector'
  ],
  mixins: {
    logAware: 'NX.LogAware'
  },

  /**
   * Create control.
   */
  create: function (formField, disableSort) {
    var filters,
        attributes = formField['attributes'] || {},
        idMapping = formField['idMapping'] || 'id',
        nameMapping = formField['nameMapping'] || 'name',
        itemConfig = {
          xtype: 'nx-itemselector',
          fieldLabel: formField.label,
          helpText: formField.helpText,
          name: formField.id,
          valueField: idMapping,
          displayField: nameMapping,
          width:600,

          itemCls: formField.required ? 'required-field' : '',
          allowBlank: !formField.required,
          delimiter: ',',

          // initialValue is null, but expected to be undefined for not set
          value: formField.initialValue ? formField.initialValue : undefined,

          listeners: {
            afterrender: function() {
              var value = this.getValue();
              if (formField.required && value === undefined || (Ext.isArray(value) && value.length === 0)) {
                // HACK: default blank behavior is not properly rendering required field error, forcing error to display
                this.markInvalid(this.blankText);
              }
            }
          }
        };

    if (attributes['buttons']) {
      itemConfig.buttons = attributes['buttons'];
    }
    if (attributes['fromTitle']) {
      itemConfig.fromTitle = attributes['fromTitle'];
    }
    if (attributes['toTitle']) {
      itemConfig.toTitle = attributes['toTitle'];
    }

    if (formField['storeApi']) {
      if (formField['storeFilters']) {
        filters = [];
        Ext.Object.each(formField['storeFilters'], function (key, value) {
          filters.push({ property: key, value: value });
        });
      }

      var args = {
        proxy: {
          type: 'direct',
          api: {
            read: 'NX.direct.' + formField['storeApi']
          },
          reader: {
            type: 'json',
            rootProperty: 'data',
            idProperty: idMapping,
            successProperty: 'success'
          }
        },

        fields: [
          { name: 'id', mapping: idMapping },
          { name: 'name', mapping: nameMapping, sortType: Ext.data.SortTypes.asUCString }
        ],

        filters: filters,
        sortOnLoad: true,
        sorters: { property: nameMapping, direction: 'ASC' },
        remoteFilter: true,
        autoLoad: true
      };

      if (disableSort) {
        delete args.sortOnLoad;
        delete args.sorters;
      }
      itemConfig.store = Ext.create('Ext.data.Store', args);
    }

    return Ext.create('NX.ext.form.field.ItemSelector', itemConfig);
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Asset info panel.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.component.AssetAttributes', {
  extend: 'Ext.grid.Panel',
  alias: 'widget.nx-coreui-component-assetattributes',
  requires: [
    'NX.I18n'
  ],

  cls: 'nx-coreui-component-assetattributes',

  manageHeight: false,

  disableSelection: true,
  rowLines: false,

  /**
   * model to display
   */
  assetModel: null,
  viewConfig: {
    enableTextSelection: true
  },
  itemId: 'attributeGrid',
  store: Ext.create('Ext.data.Store', {
    fields: ['facet', 'label', 'value'],
    groupField: 'facet'
  }),
  columns: {
    items: [
      {
        text: 'Facet',
        hidden: true,
        dataIndex: 'facet'
      },
      {
        text: 'label',
        flex: 1,
        dataIndex: 'label',
        renderer: function(value, metaData) {
          metaData.tdAttr = 'data-qtip="' + value + '"';
          return value;
        }
      },
      {
        text: 'Value',
        flex: 2,
        dataIndex: 'value',
        renderer: function (val) {
          return Ext.DomHelper.markup({
            tag: 'div',
            cls: 'attribute-value',
            html: Ext.util.Format.htmlEncode(val)
          });
        }
      }
    ]
  },
  hideHeaders: true,
  features: [
    {
      ftype: 'grouping',
      groupHeaderTpl: '{name:capitalize}'
    }
  ],

  /**
   * @public
   * @param {Object} assetModel the asset to display
   */
  setAssetModel: function(assetModel) {
    var me = this,
      store = me.getStore();
    me.assetModel = assetModel;

    // update the grid attribute data
    store.removeAll();
    Ext.iterate(me.assetModel.get('attributes'), function(facet, facetValues) {
      Ext.iterate(facetValues, function(key, value) {
        store.add({facet: facet, label: key, value: Ext.isObject(value) ? Ext.encode(value) : value});
      });
    });
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * BrowseableFormat model.
 *
 * @since 3.2.1
 */
Ext.define('NX.coreui.model.BrowseableFormat', {
  extend: 'Ext.data.Model',

  fields: [
    { name: 'id', type: 'string' }
  ]
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext*/

/**
 * BrowseableFormat store.
 *
 * @since 3.2.1
 */
Ext.define('NX.coreui.store.BrowseableFormat', {
  extend: 'Ext.data.Store',
  model: 'NX.coreui.model.BrowseableFormat',

  proxy: {
    type: 'direct',

    api: {
      read: 'NX.direct.coreui_Repository.getBrowseableFormats'
    },

    reader: {
      type: 'json',
      rootProperty: 'data',
      successProperty: 'success'
    }
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext*/

/**
 * BrowseableFormats helper.
 *
 * @since 3.2.1
 */
Ext.define('NX.coreui.util.BrowseableFormats', {
  singleton: true,
  mixins: {
    logAware: 'NX.LogAware'
  },

  /**
   * Array of visible formats.
   *
   * @private
   */
  formats: undefined,

  /**
   * @public
   * @returns {boolean} True, if formats had been set (loaded from server)
   */
  available: function() {
    return Ext.isDefined(this.formats);
  },

  /**
   * Sets formats.
   *
   * @public
   * @param {Object} formats
   */
  setFormats: function(formats) {
    var me = this;

    // defensive copy
    me.formats = Ext.clone(formats);

    //<if debug>
//    me.logDebug('BrowseableFormats installed');
    //</if>
  },

  /**
   * Resets all formats.
   *
   * @public
   */
  resetFormats: function() {
    var me = this;

    //<if debug>
//    me.logDebug('Resetting formats');
    //</if>

    delete me.formats;
  },

  /**
   * Check if the format is in the current list of formats.
   *
   * @public
   * @param {String} format
   * @returns {boolean} True if format is in the list of visible formats.
   */
  check: function(format) {
    var me = this;

    if (!me.available()) {
      return false;
    }

    return Ext.Array.contains(me.formats, format);
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * BrowseableFormats management controller.
 *
 * @since 3.2.1
 */
Ext.define('NX.coreui.controller.BrowseableFormats', {
  extend: 'NX.app.Controller',
  requires: [
    'NX.State',
    'NX.coreui.util.BrowseableFormats'
  ],

  stores: [
    'BrowseableFormat'
  ],

  /**
   * @override
   */
  init: function () {
    var me = this;

    me.primeInitialFormats();

    me.listen({
      controller: {
        '#State': {
          userchanged: me.fetchFormats,
          browseableformatschanged: me.setFormats
        }
      },
      store: {
        '#BrowseableFormat': {
          load: me.fireFormatsChanged,
          update: me.onUpdate,
          remove: me.fireFormatsChanged
        }
      }
    });
  },

  /**
   * @private
   */
  primeInitialFormats: function () {
    var me = this,
        rawData = NX.State.getValue('browseableformats');

    //<if debug>
//    me.logTrace('Initial visible formats:', rawData);
    //</if>

    me.getStore('BrowseableFormat').loadRawData(rawData, false);
    NX.coreui.util.BrowseableFormats.setFormats(me.getFormats());

    //<if debug>
//    me.logInfo('VisiblePermissions primed');
    //</if>
  },

  /**
   * @private
   */
  onUpdate: function (store, record, operation) {
    if (operation === Ext.data.Model.COMMIT) {
      this.fireFormatsChanged();
    }
  },

  /**
   * @private
   */
  fetchFormats: function () {
    var me = this;

    NX.coreui.util.BrowseableFormats.resetFormats();
    //<if debug>
//    me.logDebug('Fetching formats...');
    //</if>
    me.getStore('BrowseableFormat').load();
    NX.coreui.util.BrowseableFormats.setFormats(me.getFormats());
  },

  /**
   * @private
   */
  setFormats: function (formats) {
    var me = this;

    //<if debug>
//    me.logDebug('Loading visible formats...');
    //</if>

    me.getStore('BrowseableFormat').loadRawData(formats, false);
    me.fireFormatsChanged();
  },

  /**
   * @private
   */
  fireFormatsChanged: function () {
    var me = this;

    NX.coreui.util.BrowseableFormats.setFormats(me.getFormats());

    //<if debug>
//    me.logDebug('BrowseableFormats changed; Firing event');
    //</if>

    me.fireEvent('changed', NX.coreui.util.BrowseableFormats);
  },

  /**
   * @private
   * @return {Object} formats
   */
  getFormats: function () {
    var store = this.getStore('BrowseableFormat'),
        formats = [];

    store.each(function (rec) {
      formats.push(rec.get('id'));
    });

    return formats;
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Security realms settings form.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.security.RealmSettings', {
  extend: 'NX.view.SettingsPanel',
  alias: 'widget.nx-coreui-security-realm-settings',
  requires: [
    'NX.Conditions',
    'NX.ext.form.field.ItemSelector',
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    me.settingsForm = [
      // basic settings
      {
        xtype: 'nx-settingsform',
        settingsFormSuccessMessage: NX.I18n.get('Security_RealmSettings_Update_Success'),
        api: {
          load: 'NX.direct.coreui_RealmSettings.read',
          submit: 'NX.direct.coreui_RealmSettings.update'
        },
        editableCondition: NX.Conditions.isPermitted('nexus:settings:update'),
        editableMarker: NX.I18n.get('Security_RealmSettings_Update_Error'),

        items: [
          {
            xtype: 'nx-itemselector',
            name: 'realms',
            fieldLabel: 'Active realms',
            buttons: ['up', 'add', 'remove', 'down'],
            fromTitle: NX.I18n.get('Security_RealmSettings_Available_FromTitle'),
            toTitle: NX.I18n.get('Security_RealmSettings_Available_ToTitle'),
            store: 'RealmType',
            valueField: 'id',
            displayField: 'name',
            delimiter: null
          }
        ]
      }
    ];

    me.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Repository grid.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.repository.RepositoryList', {
  extend: 'NX.coreui.view.repository.RepositoryListTemplate',
  alias: 'widget.nx-coreui-repository-list',
  requires: [
    'NX.I18n'
  ],

  stateful: true,
  stateId: 'nx-coreui-repository-list',

  /**
   * @override
   */
  initComponent: function() {
    this.store = 'Repository';

    this.dockedItems = [
      {
        xtype: 'nx-actions',
        items: [
          {
            xtype: 'button',
            text: NX.I18n.get('Repository_RepositoryList_New_Button'),
            glyph: 'xf055@FontAwesome' /* fa-plus-circle */,
            action: 'new',
            disabled: true
          }
        ]
      }
    ];

    this.callParent();
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Metric Health model.
 *
 * @since 3.13
 */
Ext.define('NX.coreui.model.MetricHealth', {
  extend: 'Ext.data.Model',
  fields: [
    {name: 'name', type: 'string', sortType: 'asUCText'},
    {name: 'healthy', type: 'boolean'},
    {name: 'message', type: 'string'},
    {name: 'error', type: 'string'}
  ]
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Metric Healthcheck store.
 * Intended to be populated directly by a controller.
 *
 * @since 3.13
 */
Ext.define('NX.coreui.store.MetricHealth', {
  extend: 'Ext.data.Store',
  model: 'NX.coreui.model.MetricHealth',

  proxy: {
    type: 'memory',
    reader: {
      type: 'json'
    }
  },

  sorters: [
    {property: 'name', direction: 'ASC'},
    {property: 'healthy', direction: 'DESC'}
  ],

  autoLoad:false
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Metric Health grid.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.support.MetricHealth', {
  extend: 'Ext.grid.Panel',
  alias: 'widget.nx-coreui-support-metric-health',
  requires: [
    'NX.I18n',
    'NX.coreui.model.MetricHealth',
    'NX.coreui.store.MetricHealth'
  ],

  stateful: true,
  stateId: 'nx-coreui-support-metric-health',

  /**
   * @override
   */
  initComponent: function() {
    Ext.apply(this, {
      store: Ext.create('NX.coreui.store.MetricHealth'),

      viewConfig: {
        stripeRows: true
      },

      columns: [
        {
          xtype: 'nx-iconcolumn',
          width: 36,
          iconVariant: 'x16',
          iconName: function (value, meta, record) {
            return record.get('healthy') ? 'message-success' : 'message-danger'; 
          }
        },
        {
          header: NX.I18n.get('Metric_Health_Name_Header'),
          dataIndex: 'name',
          stateId: 'name',
          flex: 1
        },
        {
          header: NX.I18n.get('Metric_Health_Message_Header'),
          dataIndex: 'message',
          stateId: 'message',
          flex: 1,
          renderer: function (val){
            return '<div style="white-space:normal !important;">'+ val +'</div>';
          }
        },
        {
          header: NX.I18n.get('Metric_Health_Error_Header'),
          dataIndex: 'error',
          stateId: 'error',
          flex: 1
        }
      ]
    });

    this.callParent();
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Repository "Settings" form for a Maven Proxy repository
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.repository.recipe.RawProxy', {
  extend: 'NX.coreui.view.repository.RepositorySettingsForm',
  alias: 'widget.nx-coreui-repository-raw-proxy',
  requires: [
    'NX.coreui.view.repository.facet.ProxyFacet',
    'NX.coreui.view.repository.facet.StorageFacet',
    'NX.coreui.view.repository.facet.HttpClientFacet',
    'NX.coreui.view.repository.facet.NegativeCacheFacet',
    'NX.coreui.view.repository.facet.CleanupPolicyFacet'
  ],

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    me.items = [
      {xtype: 'nx-coreui-repository-proxy-facet'},
      {xtype: 'nx-coreui-repository-storage-facet'},
      {xtype: 'nx-coreui-repository-negativecache-facet'},
      {xtype: 'nx-coreui-repository-cleanup-policy-facet'},
      {xtype: 'nx-coreui-repository-httpclient-facet'}
    ];

    me.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Select repository recipe panel.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.repository.RepositorySelectRecipe', {
  extend: 'NX.view.drilldown.Master',
  alias: 'widget.nx-coreui-repository-selectrecipe',
  requires: [
    'NX.I18n'
  ],

  cls: 'nx-hr',

  store: 'RepositoryRecipe',
  columns: [
    {
      xtype: 'nx-iconcolumn',
      width: 36,
      iconVariant: 'x16',
      iconName: function() {
        return 'repository-hosted';
      }
    },
    { header: 'Recipe', dataIndex: 'name', flex: 1 }
  ]

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Outreach controller.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.controller.Outreach', {
  extend: 'NX.app.Controller',
  requires: [
    'NX.util.Url',
    'NX.State',
    'NX.Permissions'
  ],

  refs: [
    { ref: 'welcomePage', selector: 'nx-dashboard-welcome' }
  ],

  /**
   * @override
   */
  init: function () {
    var me = this;

    me.listen({
      controller: {
        '#Refresh': {
          refresh: me.refreshOutreachContent
        },
        '#State': {
          userchanged: me.refreshOutreachContent
        }
      },
      component: {
        'nx-dashboard-welcome': {
          afterrender: me.refreshOutreachContent
        }
      }
    });
  },

  /**
   * @private
   * Add/Remove outreach content to/from welcome page, if outreach content is available.
   */
  refreshOutreachContent: function () {
    var me = this,
        welcomePage = me.getWelcomePage();

    if (welcomePage) {
      NX.direct.outreach_Outreach.readStatus(function (response) {
        if (Ext.isObject(response) && response.success && response.data != null && welcomePage.rendered) {
          var user = NX.State.getUser(),
              usertype,
              url;

          if (user) {
            usertype = user.administrator ? 'admin' : 'normal';
          }
          else {
            usertype = 'anonymous';
          }

          url = NX.util.Url.urlOf('service/outreach/?version=' + NX.State.getVersion() +
              '&versionMm=' + NX.State.getVersionMajorMinor() +
              '&edition=' + NX.State.getEdition() +
              '&usertype=' + usertype);

          // add the outreach iframe to the welcome view
          welcomePage.removeAll();
          welcomePage.add({
            xtype: 'uxiframe',
            itemId: 'outreach',
            anchor: '100%',
            width: '100%',
            flex: 1,
            border: false,
            frame: false,
            hidden: true,
            src: url,
            // override renderTpl to add title attribute for accessibility purpose
            renderTpl: [
              '<iframe src="{src}" id="{id}-iframeEl" data-ref="iframeEl" name="{frameName}" title="Nexus Repository Manager Outreach" width="100%" height="100%" frameborder="0"></iframe>'
            ],
            listeners: {
              load: function () {
                var iframe = this;
                // if the outreach content has loaded properly, show it
                if (iframe.getWin().iframeLoaded) {
                  iframe.show();
                }
                else {
                  // else complain and leave it hidden
                  //<if debug>
//                  me.logDebug('Outreach iframe did not load: ' + url);
                  //</if>
                }
              }
            }
          });
        }
      });
    }
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Role sources store.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.store.RoleSource', {
  extend: 'Ext.data.Store',
  model: 'NX.coreui.model.Reference',

  proxy: {
    type: 'direct',
    paramsAsHash: false,

    api: {
      read: 'NX.direct.coreui_Role.readSources'
    },

    reader: {
      type: 'json',
      rootProperty: 'data',
      successProperty: 'success'
    }
  },

  sorters: { property: 'id', direction: 'ASC' }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Manages firewall column shown in repository grid.
 *
 * @since 3.2
 */
Ext.define('NX.coreui.controller.FirewallRepositoryColumn', {
  extend: 'NX.app.Controller',
  requires: [
    'Ext.grid.column.Column',
    'Ext.XTemplate',
    'NX.Conditions',
    'NX.Permissions',
    'NX.I18n',
    'NX.Icons',
    'NX.ext.grid.column.Renderers',
    'NX.Windows'
  ],

  models: [
    'FirewallRepositoryStatus'
  ],
  stores: [
    'FirewallRepositoryStatus'
  ],
  refs: [
    { ref: 'list', selector: 'nx-coreui-repository-list' }
  ],

  /**
   * @override
   */
  init: function() {
    var me = this;

    me.getApplication().getIconController().addIcons({
      'license-alert': {
        file: 'license-alert.png',
        variants: ['x16']
      },
      'security-alert': {
        file: 'security-alert.png',
        variants: ['x16']
      }
    });

    me.listen({
      controller: {
        '#Permissions': {
          changed: me.refreshFirewallColumn
        }
      },
      store: {
        '#Repository': {
          load: me.loadFirewallStatus
        },
        '#FirewallRepositoryStatus': {
          load: me.refreshFirewallColumn
        }
      },
      component: {
        'nx-coreui-repository-list': {
          afterrender: me.bindFirewallColumn
        }
      }
    });

    me.firewallColumnTemplate = Ext.create('Ext.XTemplate',
        '<div class="nx-firewall-container">',
        '<tpl if="criticalCount &gt; 0">',
        '<div class="nx-firewall-chiclet critical">{criticalCount}</div>',
        '</tpl>',
        '<tpl if="severeCount &gt; 0">',
        '<div class="nx-firewall-chiclet severe">{severeCount}</div>',
        '</tpl>',
        '<tpl if="moderateCount &gt; 0">',
        '<div class="nx-firewall-chiclet moderate">{moderateCount}</div>',
        '</tpl>',
        '<tpl if="!criticalCount && !severeCount && !moderateCount">',
        '<div style="float:left;">' + NX.I18n.get('FirewallRepositoryColumn_NoViolations') + '</div>',
        '</tpl>',
        '<tpl if="quarantinedCount &gt; 0">',
        '<div class="nx-firewall-quarantine-icon"></div><div class="nx-firewall-quarantine-count">{quarantinedCount}</div>',
        '</tpl>',
        '<div class="nx-external-link"></div>',
        '</div>',
        {
          compiled : true
        }
    );

    me.firewallColumnMessageTemplate = Ext.create('Ext.XTemplate',
        '<div class="nx-firewall-container">',
        '<div style="float:left;">{message}</div>',
        '</div>',
        {
          compiled : true
        }
    );

    me.firewallColumnErrorTemplate = Ext.create('Ext.XTemplate',
        '<div class="nx-firewall-container">',
        '<div class="nx-firewall-iq-error-icon"></div>',
        '<div class="nx-firewall-error">{errorMessage}</div>',
        '</div>',
        {
          compiled : true
        }
    );
  },

  /**
   * Load Firewall status store if repository grid is active.
   *
   * @private
   */
  loadFirewallStatus: function() {
    var me = this,
        list = me.getList();

    if (list) {
      me.getFirewallRepositoryStatusStore().load();
    }
  },

  /**
   * Add Firewall column.
   *
   * @private
   * @param {NX.coreui.view.repository.RepositoryList} grid repository grid
   */
  bindFirewallColumn: function(grid) {
    var me = this;
    me.addFirewallColumn(grid);
  },

  /**
   * Add Firewall column to repository grid.
   *
   * @private
   * @param {NX.coreui.view.repository.RepositoryList} grid repository grid
   */
  addFirewallColumn: function(grid) {
    var me = this,
        view = grid.getView();

    if (!grid.firewallColumn) {
      grid.firewallColumn = grid.pushColumn({
        id: 'firewallColumn',
        header: NX.I18n.get('FirewallRepositoryColumn_Header'),
        hideable: false,
        sortable: false,
        menuDisabled: true,
        stateId: 'firewall',
        width: 120,
        align: 'center',
        renderer: Ext.bind(me.renderFirewallColumn, me),
        listeners: {
          click: Ext.bind(me.viewReportHandler, me)
        }
      });

      view.refresh();
    }
  },

  /**
   * Render Firewall column based on corresponding {NX.coreui.model.FirewallRepositoryStatus}.
   *
   * @private
   * @param value (not used)
   * @param metadata firewall column metadata
   * @param {NX.coreui.model.Repository} repositoryModel repository model
   * @returns {String} Firewall column content
   */
  renderFirewallColumn: function(value, metadata, repositoryModel) {
    var me = this,
        statusModel = me.getFirewallRepositoryStatusStore().getById(repositoryModel.getId());
    if (statusModel) {
      if (statusModel.get('errorMessage')) {
        var errorMessage = Ext.util.Format.htmlEncode(statusModel.get('errorMessage'));
        metadata.tdAttr = 'data-qtip="' + errorMessage + '"';
        return me.firewallColumnErrorTemplate.apply({
          errorMessage: errorMessage
        });
      }
      else if (statusModel.get('message')) {
        var message = Ext.util.Format.htmlEncode(statusModel.get('message'));
        metadata.tdAttr = 'data-qtip="' + message + '"';
        return me.firewallColumnMessageTemplate.apply({
          message: message
        });
      }
      return me.firewallColumnTemplate.apply({
        criticalCount: statusModel.get('criticalComponentCount'),
        severeCount: statusModel.get('severeComponentCount'),
        moderateCount: statusModel.get('moderateComponentCount'),
        quarantinedCount: statusModel.get('quarantinedComponentCount')
      });
    }
    else if (me.getFirewallRepositoryStatusStore().loaded) {
      return NX.ext.grid.column.Renderers.optionalData(null);
    }
    return NX.I18n.get('FirewallRepositoryColumn_Loading');
  },

  /**
   * Refresh repository grid view (when Firewall status changes).
   *
   * @private
   */
  refreshFirewallColumn: function() {
    var list = this.getList();

    if (list) {
      list.getView().refresh();
    }
  },

  /**
   * Handler for when the cell is clicked and opens a new window to go to the IQ report
   *
   * @private
   * @param gridView (not used)
   * @param cell (not used)
   * @param row (not used)
   * @param col (not used)
   * @param event (not used)
   * @param {NX.coreui.model.Repository} repositoryModel repository model
   */
  viewReportHandler: function(gridView, cell, row, col, event, repositoryModel) {
    var me = this;
    var statusModel = me.getFirewallRepositoryStatusStore().getById(repositoryModel.getId());
    if (statusModel && statusModel.get('reportUrl')) {
      NX.Windows.open(statusModel.get('reportUrl'), '_blank');
    }
    return false;
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Role grid.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.role.RoleList', {
  extend: 'NX.view.drilldown.Master',
  alias: 'widget.nx-coreui-role-list',
  requires: [
    'NX.Icons',
    'NX.I18n'
  ],

  stateful: true,
  stateId: 'nx-coreui-role-list',

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    me.store = 'Role';

    me.columns = [
      {
        xtype: 'nx-iconcolumn',
        width: 36,
        iconVariant: 'x16',
        iconName: function () {
          return 'role-default';
        }
      },
      {header: NX.I18n.get('Role_RoleList_Name_Header'), dataIndex: 'name', stateId: 'name', flex: 1},
      {header: NX.I18n.get('Role_RoleList_Source_Header'), dataIndex: 'source', stateId: 'source'},
      {header: NX.I18n.get('Role_RoleList_Description_Header'), dataIndex: 'description', stateId: 'description', flex: 1}
    ];

    me.viewConfig = {
      emptyText: NX.I18n.get('Role_RoleList_EmptyText'),
      deferEmptyText: false
    };

    me.plugins = [
      { ptype: 'gridfilterbox', emptyText: NX.I18n.get('Role_RoleList_Filter_EmptyText') }
    ];

    me.dockedItems = [{
      xtype: 'nx-actions',
      items: [
        { xtype: 'button', text: NX.I18n.get('Role_RoleList_New_Button'), glyph: 'xf055@FontAwesome' /* fa-plus-circle */, action: 'new', disabled: true,
          menu: [
            { text: NX.I18n.get('Role_RoleList_New_NexusRoleItem'), action: 'newrole', iconCls: NX.Icons.cls('role-default', 'x16') }
          ]
        }
      ]
    }];

    me.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Configuration for enabling Bower urls rewrites.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.repository.facet.BowerProxyFacet', {
  extend: 'Ext.form.FieldContainer',
  alias: 'widget.nx-coreui-repository-bower-proxy-facet',
  requires: [
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function() {
    var me = this;

    me.items = [
      {
        xtype: 'fieldset',
        cls: 'nx-form-section',
        title: NX.I18n.get('Repository_Facet_BowerProxyFacet_Title'),
        width: 600,
        items: [
          {
            xtype: 'checkbox',
            name: 'attributes.bower.rewritePackageUrls',
            fieldLabel: NX.I18n.get('Repository_Facet_BowerProxyFacet_RewritePackageUrls_FieldLabel'),
            helpText: NX.I18n.get('Repository_Facet_BowerProxyFacet_RewritePackageUrls_HelpText'),
            value: true
          }
        ]
      }
    ];

    me.callParent();
  }

});


/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Search criteria model.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.model.SearchCriteria', {
  extend: 'Ext.data.Model',
  fields: [
    {name: 'id', type: 'string', sortType: 'asUCText'},
    {name: 'group', type: 'string', sortType: 'asUCText'},
    {name: 'config', type: 'auto' /*object*/}
  ]
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * License User model.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.model.LicenseUser', {
  extend: 'Ext.data.Model',
  fields: [
    {name: 'ip', type: 'string', sortType: 'asUCText'},
    {name: 'userId', type: 'string', sortType: 'asUCText', convert: Ext.htmlEncode },
    {name: 'userAgent', type: 'string', sortType: 'asUCText', convert: Ext.htmlEncode },
    {name: 'timestamp', type: 'date', dateFormat: 'c' }
  ]
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Configuration specific to Maven repositories.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.repository.facet.Maven2Facet', {
  extend: 'Ext.form.FieldContainer',
  alias: 'widget.nx-coreui-repository-maven2-facet',
  requires: [
    'NX.I18n'
  ],

  defaults: {
    allowBlank: false,
    queryMode: 'local',
    itemCls: 'required-field'
  },

  /**
   * @override
   */
  initComponent: function() {
    var me = this;

    me.items = [
      {
        xtype: 'fieldset',
        cls: 'nx-form-section',
        title: NX.I18n.get('Repository_Facet_Maven2Facet_Title'),

        items: [
          {
            xtype: 'combo',
            name: 'attributes.maven.versionPolicy',
            itemId: 'versionPolicy',
            fieldLabel: NX.I18n.get('Maven2Facet_VersionPolicy_FieldLabel'),
            helpText: NX.I18n.get('Maven2Facet_VersionPolicy_HelpText'),
            emptyText: NX.I18n.get('Maven2Facet_VersionPolicy_EmptyText'),
            editable: false,
            store: [
              ['RELEASE', NX.I18n.get('Maven2Facet_VersionPolicy_ReleaseItem')],
              ['SNAPSHOT', NX.I18n.get('Maven2Facet_VersionPolicy_SnapshotItem')],
              ['MIXED', NX.I18n.get('Maven2Facet_VersionPolicy_MixedItem')]
            ],
            value: 'RELEASE',
            readOnlyOnUpdate: true
          },
          {
            xtype: 'combo',
            name: 'attributes.maven.layoutPolicy',
            fieldLabel: NX.I18n.get('Repository_Facet_Maven2Facet_LayoutPolicy_FieldLabel'),
            helpText: NX.I18n.get('Repository_Facet_Maven2Facet_LayoutPolicy_HelpText'),
            emptyText: NX.I18n.get('Repository_Facet_Maven2Facet_LayoutPolicy_EmptyText'),
            editable: false,
            store: [
              ['STRICT', NX.I18n.get('Repository_Facet_Maven2Facet_LayoutPolicy_StrictItem')],
              ['PERMISSIVE', NX.I18n.get('Repository_Facet_Maven2Facet_LayoutPolicy_PermissiveItem')]
            ],
            value: 'STRICT'
          }
        ]
      }
    ];

    me.callParent();
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Capability model.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.model.Capability', {
  extend: 'Ext.data.Model',
  fields: [
    {name: 'id', type: 'string', sortType: 'asUCText'},
    {name: 'typeId', type: 'string', sortType: 'asUCText'},
    {name: 'enabled', type: 'boolean'},
    {name: 'notes', type: 'string', sortType: 'asUCText'},
    {name: 'properties', type: 'auto' /*object*/, defaultValue: null },

    {name: 'active', type: 'boolean'},
    {name: 'error', type: 'boolean'},
    {name: 'description', type: 'string', sortType: 'asUCText'},
    {name: 'state', type: 'string', sortType: 'asUCText'},
    {name: 'stateDescription', type: 'string', sortType: 'asUCText'},
    {name: 'status', type: 'string', sortType: 'asUCText'},
    {name: 'typeName', type: 'string', sortType: 'asUCText'},
    {name: 'tags', type: 'auto' /*object*/}
  ]
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Capability store.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.store.Capability', {
  extend: 'Ext.data.Store',
  model: 'NX.coreui.model.Capability',

  proxy: {
    type: 'direct',
    paramsAsHash: false,
    api: {
      read: 'NX.direct.capability_Capability.read'
    },

    reader: {
      type: 'json',
      rootProperty: 'data',
      successProperty: 'success'
    }
  },

  sorters: { property: 'typeName', direction: 'ASC' }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext*/

/**
 * Migration repository customization window.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.migration.RepositoryCustomizeWindow', {
  extend: 'NX.view.ModalDialog',
  alias: 'widget.nx-coreui-migration-repositorycustomize',
  requires: [
    'NX.I18n'
  ],

  config: {
    /**
     * @cfg {String}
     */
    repository: undefined,

    /**
     * Id of the record being modified.
     *
     * @cfg {*}
     */
    recordId: undefined,

    /**
     * The default blob store to display.
     *
     * @cfg {String}
     */
    blobStore: undefined,

    /**
     * The default method to display.
     *
     * @cfg {String}
     */
    ingestMethod: undefined
  },

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    Ext.apply(me, {
      ui: 'nx-inset',
      closable: true,
      width: NX.view.ModalDialog.SMALL_MODAL,

      title: NX.I18n.render(me, 'Title', me.getRepository()),

      items: {
        xtype: 'form',
        defaultType: 'textfield',
        defaults: {
          anchor: '100%'
        },
        items: [
          {
            xtype: 'hiddenfield',
            name: 'id',
            value: me.getRecordId()
          },
          {
            xtype: 'combo',
            name: 'blobStore',
            fieldLabel: NX.I18n.render(me, 'BlobStore_FieldLabel'),
            helpText: NX.I18n.render(me, 'BlobStore_HelpText'),
            emptyText: NX.I18n.render(me, 'BlobStore_EmptyText'),
            editable: false,
            store: 'Blobstore',
            queryMode: 'local',
            displayField: 'name',
            valueField: 'name',
            readOnlyOnUpdate: true,
            value: me.getBlobStore()
          },
          {
            xtype: 'combo',
            name: 'ingestMethod',
            fieldLabel: NX.I18n.render(me, 'IngestMethod_FieldLabel'),
            helpText: NX.I18n.render(me, 'IngestMethod_HelpText'),
            emptyText: NX.I18n.render(me, 'IngestMethod_EmptyText'),
            editable: false,
            store: [
              ['FS_LINK', NX.I18n.render(me, 'IngestMethod_Link')],
              ['FS_COPY', NX.I18n.render(me, 'IngestMethod_Copy')],
              ['DOWNLOAD', NX.I18n.render(me, 'IngestMethod_Download')]
            ],
            value: me.getIngestMethod()
          }
        ],

        buttonAlign: 'left',
        buttons: [
          { text: NX.I18n.get('Button_Save'), action: 'save', scope: me, formBind: true, bindToEnter: true, ui: 'nx-primary' },
          { text: NX.I18n.get('Button_Cancel'), handler: me.close, scope: me }
        ]
      }
    });

    me.callParent();
  },

  /**
   * @return {Ext.form.Basic}
   */
  getForm: function() {
    return this.down('form').getForm();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Repository "Settings" form for a PyPI Hosted repository.
 *
 * @since 3.1
 */
Ext.define('NX.coreui.view.repository.recipe.PyPiHosted', {
  extend: 'NX.coreui.view.repository.RepositorySettingsForm',
  alias: 'widget.nx-coreui-repository-pypi-hosted',
  requires: [
    'NX.coreui.view.repository.facet.StorageFacet',
    'NX.coreui.view.repository.facet.StorageFacetHosted',
    'NX.coreui.view.repository.facet.CleanupPolicyFacet'
  ],

  /**
   * @override
   */
  initComponent: function() {
    var me = this;

    me.items = [
      { xtype: 'nx-coreui-repository-storage-facet'},
      { xtype: 'nx-coreui-repository-storage-hosted-facet'},
      { xtype: 'nx-coreui-repository-cleanup-policy-facet'}
    ];

    me.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Asset store.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.store.PreviewAsset', {
  extend: 'Ext.data.Store',
  model: 'NX.coreui.model.Asset',

  proxy: {
    type: 'direct',

    api: {
      read: 'NX.direct.coreui_Component.previewAssets'
    },

    reader: {
      type: 'json',
      rootProperty: 'data',
      successProperty: 'success'
    }
  },

  remote: true,
  autoLoad: false,

  buffered: true,
  pageSize: 50,

  remoteFilter: true,
  remoteSort: true,

  sorters: { property: 'name', direction: 'ASC' }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Search filter model.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.model.SearchFilter', {
  extend: 'Ext.data.Model',
  fields: [
    {name: 'id', type: 'string'},
    {name: 'name', type: 'string'},
    {name: 'text', type: 'string'},
    {name: 'description', type: 'string'},
    {name: 'criterias', type: 'auto' /*array*/},
    {name: 'readOnly', type: 'boolean'}
  ]
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Search result model.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.model.SearchResult', {
  extend: 'Ext.data.Model',
  idProperty: 'groupingKey',
  fields: [
    'groupingKey',
    'group',
    'name',
    'format'
  ]
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Task Schedule Daily field set.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.task.TaskScheduleDaily', {
  extend: 'NX.coreui.view.task.TaskScheduleFields',
  alias: 'widget.nx-coreui-task-schedule-daily',
  requires: [
    'NX.util.DateFormat',
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    me.items = [
      {
        xtype: 'datefield',
        name: 'startDate',
        itemId: 'startDate',
        fieldLabel: NX.I18n.get('Task_TaskScheduleDaily_StartDate_FieldLabel'),
        allowBlank: false,
        format: 'm/d/Y',
        value: new Date(),
        submitValue: false
      },
      {
        xtype: 'timefield',
        name: 'startTime',
        itemId: 'startTime',
        fieldLabel: NX.I18n.get('Task_TaskScheduleDaily_Recurring_FieldLabel'),
        helpText: 'The time this task should start on days it will run in your time zone ' +
            NX.util.DateFormat.getTimeZone() + '.',
        allowBlank: false,
        format: 'H:i',
        submitValue: false
      }
    ];

    me.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/**
 * Nodes disabled.
 *
 * @since 3.2
 */
Ext.define('NX.coreui.view.system.NodesDisabledMessage', {
  extend: 'Ext.panel.Panel',
  alias: 'widget.nx-coreui-system-nodes-disabled',
  requires: [
    'NX.I18n'
  ],

  dockedItems: [
    {
      xtype: 'nx-actions',
      items: [
        {
          xtype: 'button',
          text: 'Enable read-only mode',
          glyph: 'xf1e5@FontAwesome' /* fa-binoculars */,
          action: 'freeze'
        }
      ]
    }
  ],
  items: [
    {
      xtype: 'panel',
      ui: 'nx-inset',
      items: {
        xtype: 'panel',
        ui: 'nx-subsection-framed',
        html: NX.I18n.get('Nodes_OSS_Message')
      }
    }
  ]
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Add LDAP connection window.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.ldap.LdapServerConnectionAdd', {
  extend: 'NX.view.AddPanel',
  alias: 'widget.nx-coreui-ldapserver-connection-add',
  requires: [
    'NX.Conditions',
    'NX.I18n'
  ],

  dockedItems: null,

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    me.settingsForm = {
      xtype: 'nx-coreui-ldapserver-connection-form',

      editableCondition: NX.Conditions.isPermitted('nexus:ldap:create'),
      editableMarker: NX.I18n.get('Ldap_LdapServerConnectionAdd_Create_Error'),

      buttons: [
        { text: NX.I18n.get('Ldap_LdapServerConnectionAdd_Text'), action: 'next', ui: 'nx-primary' },
        { text: NX.I18n.get('Add_Cancel_Button'), action: 'back' }
      ]
    };

    me.callParent();

    NX.Conditions.formIs(me.down('form'), function(form) {
      return !form.isDisabled() && form.isValid();
    }).on({
      satisfied: function() {
        this.enable();
      },
      unsatisfied: function() {
        this.disable();
      },
      scope: me.down('button[action=next]')
    });
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Selector "Settings" panel.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.selector.SelectorSettings', {
  extend: 'NX.view.SettingsPanel',
  alias: 'widget.nx-coreui-selector-settings',

  initComponent: function() {
    var me = this;

    me.settingsForm = {
      xtype: 'nx-coreui-selector-settings-form',
      buttons: [
        {text: NX.I18n.get('Selector_SelectorSettingsForm_Preview_Button'), action: 'preview', ui: 'nx-primary'},
        {text: NX.I18n.get('SettingsForm_Save_Button'), action: 'save', ui: 'nx-primary', bindToEnter: false},
        {text: NX.I18n.get('SettingsForm_Discard_Button'), action: 'discard'}
      ]
    };

    me.callParent();
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Add privilege window.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.privilege.PrivilegeAdd', {
  extend: 'NX.view.AddPanel',
  alias: 'widget.nx-coreui-privilege-add',
  requires: [
    'NX.I18n'
  ],

  defaultFocus: 'name',

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    Ext.apply(me, {
      settingsForm: {
        xtype: 'nx-coreui-privilege-settings-form',
        editableCondition: NX.Conditions.isPermitted('nexus:privileges:create'),
        editableMarker: NX.I18n.get('Privilege_PrivilegeSettingsForm_Update_Error'),

        buttons: [
          {text: NX.I18n.get('Privilege_PrivilegeList_New_Button'), action: 'add', formBind: true, ui: 'nx-primary'},
          {text: NX.I18n.get('Add_Cancel_Button'), action: 'back'}
        ]
      }
    });

    me.callParent();

    me.down('#name').setReadOnly(false);
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * User grid.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.user.UserList', {
  extend: 'NX.view.drilldown.Master',
  alias: 'widget.nx-coreui-user-list',
  requires: [
    'NX.I18n'
  ],

  stateful: true,
  stateId: 'nx-coreui-user-list',

  /**
   * @override
   */
  initComponent: function() {
    Ext.apply(this, {
      store: 'User',

      columns: [
        {
          xtype: 'nx-iconcolumn',
          width: 36,
          iconVariant: 'x16',
          iconName: function() {
            return 'user-default';
          }
        },
        { header: NX.I18n.get('User_UserList_ID_Header'), dataIndex: 'userId', stateId: 'userId', flex: 2, renderer: Ext.htmlEncode },
        { header: NX.I18n.get('User_UserList_Realm_Header'), dataIndex: 'realm', stateId: 'realm' },
        { header: NX.I18n.get('User_UserList_FirstName_Header'), dataIndex: 'firstName', stateId: 'firstName', flex: 2, renderer: Ext.htmlEncode },
        { header: NX.I18n.get('User_UserList_LastName_Header'), dataIndex: 'lastName', stateId: 'lastName', flex: 2, renderer: Ext.htmlEncode },
        { header: NX.I18n.get('User_UserList_Email_Header'), dataIndex: 'email', stateId: 'email', flex: 2 },
        { header: NX.I18n.get('User_UserList_Status_Header'), dataIndex: 'status', stateId: 'status' }
      ],

      viewConfig: {
        emptyText: NX.I18n.get('User_UserList_EmptyText'),
        deferEmptyText: false
      },

      dockedItems: [{
        xtype: 'nx-actions',
        items: [
          {
            xtype: 'button',
            text: NX.I18n.get('User_UserList_New_Button'),
            glyph: 'xf055@FontAwesome' /* fa-plus-circle */,
            action: 'new',
            disabled: true
          },
          '-',
          { xtype: 'label', text: NX.I18n.get('User_UserList_Source_Label') },
          { xtype: 'button', text: NX.I18n.get('User_UserList_Default_Button'), action: 'filter', menu: [] },
          { xtype: 'nx-coreui-user-searchbox' }
        ]
      }]
    });

    this.callParent();
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Log Viewer panel.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.logging.LogViewer', {
  extend: 'Ext.panel.Panel',
  alias: 'widget.nx-coreui-log-viewer',
  requires: [
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function() {
    Ext.apply(this, {
      layout: 'fit',

      items: {
        xtype: 'textarea',

        plugins: {
          responsive: false
        },
        cls: 'nx-log-viewer-field nx-monospace-field',
        readOnly: true,
        hideLabel: true,
        emptyText: NX.I18n.get('Logging_LogViewer_EmptyText'),
        inputAttrTpl: 'wrap="off"'
      },

      dockedItems: [{
        xtype: 'nx-actions',
        items: [
          {
            xtype: 'button',
            text: NX.I18n.get('Logging_LogViewer_Download_Button'),
            glyph: 'xf019@FontAwesome' /* fa-download */,
            action: 'download'
          },
          '-',
          {
            xtype: 'button',
            text: NX.I18n.get('Logging_LogViewer_Mark_Button'),
            glyph: 'xf11e@FontAwesome' /* fa-flag-checkered */,
            action: 'mark',
            disabled: true
          },
          '->',
          {
            xtype: 'label',
            text: NX.I18n.get('Logging_LogViewer_Refresh_Text')
          },
          {
            xtype: 'combo',
            itemId: 'refreshPeriod',
            width: 140,
            editable: false,
            value: 0,
            store: [
              [0, NX.I18n.get('Logging_LogViewer_Refresh_ManualItem')],
              [20, NX.I18n.get('Logging_LogViewer_Refresh_20SecondsItem')],
              [60, NX.I18n.get('Logging_LogViewer_Refresh_MinuteItem')],
              [120, NX.I18n.get('Logging_LogViewer_Refresh_2MinutesItem')],
              [300, NX.I18n.get('Logging_LogViewer_Refresh_5MinutesItem')]
            ],
            queryMode: 'local'
          },
          {
            xtype: 'combo',
            itemId: 'refreshSize',
            width: 120,
            editable: false,
            value: 25,
            store: [
              [25, NX.I18n.get('Logging_LogViewer_Last25KBItem')],
              [50, NX.I18n.get('Logging_LogViewer_Last50KBItem')],
              [100, NX.I18n.get('Logging_LogViewer_Last100KBItem')]
            ],
            queryMode: 'local'
          }
        ]
      }]
    });

    this.callParent();
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Mark log window.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.logging.LogMark', {
  extend: 'NX.view.AddWindow',
  alias: 'widget.nx-coreui-log-mark',
  requires: [
    'NX.Conditions',
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    me.ui = 'nx-inset';

    me.title = NX.I18n.get('Logging_LogMark_Title');

    me.items = {
      xtype: 'nx-settingsform',
        frame: false,
        defaults: {
        anchor: '100%'
      },
      settingsFormSuccessMessage: NX.I18n.get('Logging_LogMark_Success'),
        settingsFormSubmitOnEnter: true,
        editableMarker: NX.I18n.get('Logging_LogMark_Error'),
        items: [
        {
          xtype: 'textfield',
          name: 'message',
          itemId: 'message',
          fieldLabel: NX.I18n.get('Logging_LogMark_FieldLabel'),
          helpText: NX.I18n.get('Logging_LogMark_HelpText'),
          allowBlank: false
        }
      ]
    };

    me.items.buttons = [
      { text: NX.I18n.get('Logging_LogViewer_Mark_Button'), action: 'add', formBind: true, ui: 'nx-primary', bindToEnter: me.items.settingsFormSubmitOnEnter },
      { text: NX.I18n.get('Add_Cancel_Button'), handler:
        function() {
          me.close();
        }
      }
    ];

    me.on({
      resize: function() {
        me.down('#message').focus();
      },
      single: true
    });

    me.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * View log controller.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.controller.Log', {
  extend: 'NX.controller.Drilldown',
  requires: [
    'Ext.util.TaskManager',
    'Ext.Ajax',
    'NX.util.Url',
    'NX.util.DownloadHelper',
    'NX.Permissions',
    'NX.Conditions',
    'NX.I18n'
  ],

  views: [
    'logging.LogViewer',
    'logging.LogMark'
  ],
  refs: [
    { ref: 'content', selector: 'nx-feature-content' },
    { ref: 'list', selector: 'nx-coreui-log-viewer' }
  ],

  /**
   * @override
   */
  init: function () {
    var me = this;

    me.callParent();

    me.getApplication().getFeaturesController().registerFeature({
      mode: 'admin',
      path: '/Support/Logging/Log Viewer',
      text: NX.I18n.get('Log_Text'),
      description: NX.I18n.get('Log_Description'),
      view: { xtype: 'nx-coreui-log-viewer' },
      iconConfig: {
        file: 'script_text.png',
        variants: ['x16', 'x32']
      },
      visible: function () {
        return NX.Permissions.check('nexus:logging:read');
      }
    }, me);

    me.listen({
      controller: {
        '#Refresh': {
          refresh: me.retrieveLog
        }
      },
      component: {
        'nx-coreui-log-viewer': {
          afterrender: me.retrieveLog,
          destroy: me.stopRetrieveLogTask
        },
        'nx-coreui-log-viewer button[action=download]': {
          click: me.downloadLog
        },
        'nx-coreui-log-viewer button[action=mark]': {
          afterrender: me.bindMarkButton,
          click: me.showMarkWindow
        },
        'nx-coreui-log-viewer #refreshPeriod': {
          change: me.changeRefreshPeriod
        },
        'nx-coreui-log-viewer #refreshSize': {
          change: me.changeRefreshSize
        },
        'nx-coreui-log-mark button[action=add]': {
          click: me.mark
        }
      }
    });
  },

  /**
   * Shows mark log window.
   *
   * @private
   */
  showMarkWindow: function () {
    Ext.widget({ xtype: 'nx-coreui-log-mark' });
  },

  /**
   * @private
   */
  mark: function(button) {
    var me = this,
        form = button.up('form'),
        win = form.up('window'),
        values = form.getValues();

    win.hide();
    me.getContent().getEl().mask(NX.I18n.get('Log_LogMark_Mask'));
    NX.direct.logging_Log.mark(values, function(response) {
      me.getContent().getEl().unmask();
      if (Ext.isObject(response)) {
        if (response.success) {
          NX.Messages.add({ text: form.settingsFormSuccessMessage, type: 'success' });
          me.retrieveLog();
          win.close();
        }
        else if (Ext.isDefined(response.errors)) {
          win.show();
          form.getForm().markInvalid(response.errors);
        }
      }
    });
  },

  /**
   * @private
   * Opens a new browser window pointing to GET /service/rest/logging/log.
   */
  downloadLog: function () {
    NX.util.DownloadHelper.downloadUrl(NX.util.Url.urlOf('service/rest/logging/log'));
  },

  /**
   * @private
   * Changes retrieving task recurrence interval when refresh period changed.
   * @param {Ext.form.ComboBox} combo refresh period combobox
   * @param {Number} value period in seconds
   */
  changeRefreshPeriod: function (combo, value) {
    var me = this;

    me.stopRetrieveLogTask();
    me.startRetrieveLogTask(value);
  },

  /**
   * @private
   * Triggers log retrieval when refresh size changed.
   */
  changeRefreshSize: function () {
    this.retrieveLog();
  },

  /**
   * @private
   * Starts log retrieval task, with a recurrence specified by period.
   * @param {Number} period in seconds
   */
  startRetrieveLogTask: function (period) {
    var me = this;

    if (period > 0) {
      me.retrieveLog();
      me.retrieveLogTask = Ext.util.TaskManager.newTask({
        run: function () {
          me.retrieveLog();
        },
        interval: period * 1000
      });
      me.retrieveLogTask.start();

      //<if debug>
//      me.logDebug('Started refreshing log every ' + period + ' seconds');
      //</if>
    }
  },

  /**
   * @private
   * Stops log retrieval task, if active.
   */
  stopRetrieveLogTask: function () {
    var me = this;

    if (me.retrieveLogTask) {
      me.retrieveLogTask.destroy();
      delete me.retrieveLogTask;

      //<if debug>
//      me.logDebug('Stopped refreshing log');
      //</if>
    }
  },

  /**
   * @private
   * Retrieves log from /service/rest/logging/log and shows it in log panel.
   */
  retrieveLog: function () {
    var me = this,
        logPanel = me.getList(),
        size;

    if (logPanel) {
      size = logPanel.down('#refreshSize').getValue();

      me.getContent().getEl().mask(NX.I18n.get('Log_Loading_Mask'));

      //<if debug>
//      me.logDebug('Retrieving last ' + size + 'kb from log');
      //</if>

      Ext.Ajax.request({
        url: NX.util.Url.urlOf('service/rest/logging/log'),
        method: 'GET',
        headers: {
          'accept': 'text/plain'
        },
        params: {
          bytesCount: -1024 * size
        },
        scope: me,
        suppressStatus: true,
        success: function (response) {
          me.getContent().getEl().unmask();
          me.showLog(response.responseText);
        },
        failure: function (response) {
          me.getContent().getEl().unmask();
          me.showLog(NX.I18n.format('Log_Load_Failure', response.statusText));
        }
      });
    }
  },

  /**
   * @private
   * Display log content.
   * @param {String} text log content
   */
  showLog: function (text) {
    var list = this.getList(),
        textarea = list ? list.down('textarea') : null;

    if (textarea) {
      textarea.setValue(text);
      // scroll to the bottom
      textarea.getEl().down('textarea').dom.scrollTop = 1000000;
    }
  },

  /**
   * @private
   * Enable 'Mark' when user has 'update' permission.
   */
  bindMarkButton: function (button) {
    button.mon(
        NX.Conditions.isPermitted('nexus:logging:mark'),
        {
          satisfied: function () {
            button.enable();
          },
          unsatisfied: function () {
            button.disable();
          }
        }
    );
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Migration repository defaults screen.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.migration.RepositoryDefaultsScreen', {
  extend: 'NX.wizard.FormScreen',
  alias: 'widget.nx-coreui-migration-repositorydefaults',

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    Ext.apply(me, {
      title: NX.I18n.render(me, 'Title'),

      description: NX.I18n.render(me, 'Description'),

      fields: [
        {
          xtype: 'combo',
          name: 'blobStore',
          fieldLabel: NX.I18n.render(me, 'BlobStore_FieldLabel'),
          helpText: NX.I18n.render(me, 'BlobStore_HelpText'),
          emptyText: NX.I18n.render(me, 'BlobStore_EmptyText'),
          editable: false,
          store: 'Blobstore',
          queryMode: 'local',
          displayField: 'name',
          valueField: 'name',
          readOnlyOnUpdate: true,
          allowBlank: false
        },
        {
          xtype: 'combo',
          name: 'ingestMethod',
          fieldLabel: NX.I18n.render(me, 'IngestMethod_FieldLabel'),
          helpText: NX.I18n.render(me, 'IngestMethod_HelpText'),
          emptyText: NX.I18n.render(me, 'IngestMethod_EmptyText'),
          editable: false,
          allowBlank: false,
          store: [
            ['FS_LINK', NX.I18n.render(me, 'IngestMethod_Link')],
            ['FS_COPY', NX.I18n.render(me, 'IngestMethod_Copy')],
            ['DOWNLOAD', NX.I18n.render(me, 'IngestMethod_Download')]
          ]
        }
      ],

      buttons: ['back', 'next', 'cancel']
    });

    me.callParent();
    me.down('form').settingsForm = true;
  },

  /**
   * Returns the state of the screen form
   *
   * @return {boolean}
   */
  isDirty: function() {
    return this.down('form').isDirty();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Migration repository defaults step.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.migration.RepositoryDefaultsStep', {
  extend: 'NX.wizard.Step',
  requires: [
    'NX.coreui.migration.RepositoryDefaultsScreen',
    'NX.I18n'
  ],

  config: {
    screen: 'NX.coreui.migration.RepositoryDefaultsScreen',
    enabled: true
  },

  /**
   * @override
   */
  init: function () {
    var me = this;

    me.control({
      'button[action=back]': {
        click: me.moveBack
      },
      'button[action=next]': {
        click: me.doNext
      },
      'button[action=cancel]': {
        click: me.cancel
      }
    });

    // toggle step enabled when content-options change
    me.getContext().on('add', function(index, value, key, opts) {
      if (key === 'content-options') {
        me.setEnabled(value['repositories']);
      }
    });
  },

  /**
   * Prepare the defaults form.
   *
   * @private
   */
  prepare: function () {
    var me = this;

    me.mask(NX.I18n.render(me, 'Loading_Mask'));

    me.getStore('Blobstore').load();

    // load defaults from server
    NX.direct.migration_Repository.defaults(function (response, event) {
      if (event.status && response.success) {
        me.getScreenCmp().getForm().setValues(response.data);
      }
      me.unmask();
    });
  },

  /**
   * @override
   */
  reset: function () {
    var me = this,
        screen = me.getScreenCmp();

    if (screen) {
      screen.getForm().reset();
    }
    me.unset('repository-defaults');
    me.callParent();
  },

  /**
   * @private
   */
  doNext: function () {
    var me = this,
        values = me.getScreenCmp().getForm().getFieldValues();

    me.set('repository-defaults', {
      blobStore: values.blobStore,
      ingestMethod: values.ingestMethod
    });

    me.moveNext();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Migration PREPARE phase screen.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.migration.PhasePrepareScreen', {
  extend: 'NX.coreui.migration.ProgressScreenSupport',
  alias: 'widget.nx-coreui-migration-phaseprepare',
  requires: [
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    Ext.apply(me, {
      title: NX.I18n.render(me, 'Title'),
      description: NX.I18n.render(me, 'Description'),
      buttons: [
        {
          text: NX.I18n.render(me, 'Abort_Button'),
          action: 'abort',
          ui: 'default'
        },
        {
          text: NX.I18n.render(me, 'Continue_Button'),
          action: 'continue',
          ui: 'nx-primary',
          disabled: true
        }
      ]
    });

    me.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Migration PREPARE phase step.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.migration.PhasePrepareStep', {
  extend: 'NX.coreui.migration.ProgressStepSupport',
  requires: [
    'NX.coreui.migration.PhasePrepareScreen'
  ],

  config: {
    screen: 'NX.coreui.migration.PhasePrepareScreen',
    enabled: true
  },

  phase: 'PREPARE',

  /**
   * @override
   */
  init: function () {
    var me = this;

    me.control({
      'button[action=abort]': {
        click: me.doAbort
      },
      'button[action=continue]': {
        click: me.doContinue
      }
    });

    me.callParent();
  },

  /**
   * @override
   */
  reset: function() {
    var me = this,
        screen = me.getScreenCmp();

    if (screen) {
      screen.down('button[action=continue]').disable();
      screen.down('button[action=abort]').enable();
    }
    me.callParent();
  },

  /**
   * @override
   */
  doComplete: function() {
    this.getScreenCmp().down('button[action=continue]').enable();
    this.getScreenCmp().down('button[action=abort]').disable();
  },

  /**
   * @private
   */
  doAbort: function() {
    var me = this;

    NX.Dialogs.askConfirmation(
        NX.I18n.render(me, 'Abort_Confirm_Title'),
        NX.I18n.render(me, 'Abort_Confirm_Text'),
        function () {
          me.mask(NX.I18n.render(me, 'Abort_Mask'));

          me.autoRefresh(false);

          NX.direct.migration_Assistant.abort(function (response, event) {
            me.unmask();

            if (event.status && response.success) {
              me.controller.reset();

              NX.Messages.warning(NX.I18n.render(me, 'Abort_Message'));
            }
          });
        }
    );
  },

  /**
   * @private
   */
  doContinue: function() {
    var me = this;
    me.mask(NX.I18n.render(me, 'Continue_Mask'));

    NX.direct.migration_Assistant.sync(function (response, event) {
      me.unmask();

      if (event.status && response.success) {
        // need to set forms so they won't be queried for dirtiness
        var forms = Ext.ComponentQuery.query('form[settingsForm=true]');
        if (forms.length !== 0) {
          Ext.Array.each(forms, function (form) {
            form.settingsForm = false;
          });
        }
        // now ready to move ahead
        me.moveNext();

        NX.Messages.success(NX.I18n.render(me, 'Continue_Message'));
      }
    });
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Migration progress model.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.migration.ProgressModel', {
  extend: 'Ext.data.Model',
  fields: [
    {name: 'id', type: 'string'},
    {name: 'name', type: 'string'},
    {name: 'state', type: 'string'},
    {name: 'complete', type: 'number'},
    {name: 'status', type: 'string'},
    {name: 'phase', type: 'string'}
  ]
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Migration progress store.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.migration.ProgressStore', {
  extend: 'Ext.data.ArrayStore',
  requires: [
    'NX.coreui.migration.ProgressModel'
  ],

  model: 'NX.coreui.migration.ProgressModel'
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Migration panel.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.migration.Panel', {
  extend: 'NX.wizard.Panel',
  alias: 'widget.nx-coreui-migration-panel'
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Migration plan-step detail window.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.migration.PlanStepDetailWindow', {
  extend: 'NX.view.ModalDialog',
  alias: 'widget.nx-coreui-migration-progressdetail',
  requires: [
    'Ext.XTemplate',
    'NX.I18n',
    'NX.util.DateFormat'
  ],

  config: {
    /**
     * @cfg {Object} Plan-step detail object.
     */
    detail: undefined
  },

  resizable: true,
  closable: true,
  layout: 'fit',
  height: 480,

  /**
   * @override
   */
  initComponent: function () {
    var me = this,
        store,
        timestampFmt = NX.util.DateFormat.forName('datetime')['short'];

    store = Ext.create('Ext.data.ArrayStore', {
      fields: [
        {name: 'timestamp', type: 'date', dateFormat: 'c'},
        {name: 'message', type: 'string'}
      ]
    });
    store.add(me.getDetail().entries);

    Ext.apply(me, {
      title: NX.I18n.render(me, 'Title', me.getDetail().name),
      width: NX.view.ModalDialog.LARGE_MODAL,
      items: {
        xtype: 'grid',
        viewConfig: {
          stripeRows: true,
          enableTextSelection: true,
          emptyText: NX.I18n.render(me, 'EmptyLog')
        },
        hideHeaders: true,
        columns: [
          {
            header: NX.I18n.render('Timestamp_Column'),
            dataIndex: 'timestamp',
            width: 150,
            renderer: function (value) {
              return Ext.util.Format.date(value, timestampFmt);
            }
          },
          {
            header: NX.I18n.render('Message_Column'),
            dataIndex: 'message',
            flex: 1
          }
        ],
        store: store,
        plugins: [
          {
            ptype: 'rowexpander',
            rowBodyTpl: Ext.create('Ext.XTemplate',
                '<div class="nx-rowexpander">',
                '<span class="x-selectable">{message}</span>',
                '</div>',
                {
                  compiled: true
                })
          }
        ]
      },

      buttonAlign: 'left',
      buttons: [
        {text: NX.I18n.get('Button_Close'), handler: me.close, scope: me}
      ]
    });

    me.callParent();
    me.center();
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Supported-repository selection model.
 *
 * Assumes records are {@link NX.coreui.migration.RepositoryModel}.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.migration.SupportedSelectionModel', {
  extend: 'Ext.selection.CheckboxModel',

  mode: 'SIMPLE',

  // note this only prevents use of right-mouse click when there is already some selection :-(
  ignoreRightMouseSelection: true,

  constructor: function () {
    var me = this;
    me.callParent(arguments);

    me.on('beforeselect', function(sm, record, i, opts) {
      // only allow selection of supported records
      return record.get('supported');
    });
  },

  /**
   * @override
   */
  selectAll: function (suppressEvent) {
    var me = this,
        selections = me.store.getRange(),
        i = 0,
        len = selections.length,
        lenMinusUnsupported = len,
        start = me.getSelection().length;

    // Subtract the number of unsupported repositories from the length
    selections.forEach(function (e) {
      if (!e.get('supported')) {
        --lenMinusUnsupported;
      }
    });

    // If the corrected length is different from the starting length, select all
    if (start !== lenMinusUnsupported) {
      me.suspendChanges();
      for (i = 0; i < len; i++) {
        if (selections[i].get('supported')) {
          me.doSelect(selections[i], true, suppressEvent);
        }
      }
      me.resumeChanges();
      // fire selection change only if the number of selections differs
      if (!suppressEvent) {
        me.maybeFireSelectionChange(me.getSelection().length !== start);
      }
    }
    else {
      // Otherwise, deselect all
      me.deselectAll(suppressEvent);
    }
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Migration repository selection screen.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.migration.RepositoriesScreen', {
  extend: 'NX.wizard.GridScreen',
  alias: 'widget.nx-coreui-migration-repositories',
  requires: [
    'NX.Icons',
    'NX.ext.grid.column.Action',
    'NX.coreui.migration.SupportedSelectionModel',
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    Ext.apply(me, {
      title: NX.I18n.render(me, 'Title'),

      description: NX.I18n.render(me, 'Description'),

      grid: {
        xtype: 'grid',

        viewConfig: {
          stripeRows: true,
          getRowClass: function (record) {
            if (!record.get('supported')) {
              return 'nx-disabled-row';
            }
          }
        },

        columns: [
          {
            header: NX.I18n.render(me, 'Repository_Column'),
            dataIndex: 'name',
            flex: 1
          },
          {
            header: NX.I18n.render(me, 'Type_Column'),
            dataIndex: 'type',
            width: 70
          },
          {
            header: NX.I18n.render(me, 'Format_Column'),
            dataIndex: 'format'
          },
          {
            header: NX.I18n.render(me, 'Supported_Column'),
            dataIndex: 'supported',
            width: 90
          },
          {
            header: NX.I18n.render(me, 'Status_Column'),
            dataIndex: 'status',
            flex: 1,
            renderer: function (value, meta) {
              var truncated = Ext.String.ellipsis(value, 40, false);
              if (truncated !== value) {
                meta.tdAttr = Ext.String.format('data-qtip="{0}"', Ext.String.htmlEncode(value));
              }
              return truncated;
            }
          },
          {
            header: NX.I18n.render(me, 'Destination_Column'),
            dataIndex: 'blobStore'
          },
          {
            header: NX.I18n.render(me, 'Method_Column'),
            dataIndex: 'ingestMethod',
            width: 80,
            renderer: function (value) {
              // TODO: i18n
              return value.toLowerCase();
            }
          },
          {
            xtype: 'nx-actioncolumn',
            width: 32,
            menuDisabled: true,
            items: [
              {
                action: 'customize',
                iconCls: NX.Icons.cls('migration-customize', 'x16'),
                tooltip: NX.I18n.render(me, 'Action_Tooltip'),
                isDisabled: function(view, ri, ci, item, record) {
                  return !record.get('supported');
                }
              }
            ]
          }
        ],

        selModel: Ext.create('NX.coreui.migration.SupportedSelectionModel'),

        store: 'NX.coreui.migration.RepositoryStore'
      },

      fields: [
        {
          // hidden field to provide form validity support for grid
          xtype: 'hidden',
          isValid: function() {
            // valid if we have at least 1 selection
            return me.getSelectionModel().getCount() !== 0;
          }
        }
      ],

      buttons: ['back', 'next', 'cancel']
    });

    me.callParent();

    me.down('grid').settingsForm = true;

    // update hidden field to when grid selection changes
    me.getSelectionModel().on('selectionchange', function(selModel, selected, opts) {
      me.down('hidden').setValue(selected.length);
    });
  },

  /**
   * @return {Ext.grid.Panel}
   */
  getGrid: function() {
    return this.down('grid');
  },

  /**
   * @return {Ext.selection.Model}
   */
  getSelectionModel: function() {
    return this.getGrid().getSelectionModel();
  },

  /**
   * Returns the state of the screen form
   *
   * @return {boolean}
   */
  isDirty: function() {
    return this.getGrid().isDirty();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Migration repository selection step.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.migration.RepositoriesStep', {
  extend: 'NX.wizard.Step',
  requires: [
    'NX.coreui.migration.RepositoriesScreen',
    'NX.coreui.migration.RepositoryCustomizeWindow'
  ],

  config: {
    screen: 'NX.coreui.migration.RepositoriesScreen',
    enabled: true
  },

  /**
   * @override
   */
  init: function () {
    var me = this;

    me.control({
      'button[action=back]': {
        click: me.moveBack
      },
      'button[action=next]': {
        click: me.doNext
      },
      'button[action=cancel]': {
        click: me.cancel
      },
      'gridpanel nx-actioncolumn': {
        actionclick: me.doCustomize
      }
    });

    me.listen({
      component: {
        'nx-coreui-migration-repositorycustomize button[action=save]': {
          click: me.doCustomizeSave
        }
      }
    });

    // toggle step enabled when content-options change
    me.getContext().on('add', function(index, value, key, opts) {
      if (key === 'content-options') {
        me.setEnabled(value['repositories']);
      }
    });
  },

  /**
   * Prepare repository store and apply defaults to records.
   *
   * @override
   */
  prepare: function () {
    var me = this,
        uiSettings = NX.State.getValue('uiSettings', {});

    me.mask(NX.I18n.render(me, 'Loading_Mask'));

    // ensure blobstore is loaded, for customize window
    me.getStore('Blobstore').load();

    NX.direct.migration_Repository.read(function (response, event) {
      if (event.status && response.success) {
        //<if debug>
//        me.logDebug('Loading', response.data.length, 'records');
        //</if>

        //<if assert>
//        NX.Assert.assert(response.data.length !== 0, 'Missing records');
        //</if>

        var store = me.getStore('NX.coreui.migration.RepositoryStore'),
            defaults = me.get('repository-defaults');

        // apply configuration defaults if supported
        Ext.Array.each(response.data, function (data) {
          if (data.supported) {
            Ext.apply(data, defaults);
          }
        });

        store.loadData(response.data);
      }

      me.unmask();
    }, me, {
      timeout: uiSettings['longRequestTimeout'] * 1000
    });
  },

  /**
   * Clear the repository store on reset.
   *
   * @override
   */
  reset: function () {
    this.getStore('NX.coreui.migration.RepositoryStore').removeAll();
    this.unset('selected-repositories');
    this.callParent();
  },

  /**
   * @private
   */
  doNext: function () {
    var me = this,
        selections = me.getScreenCmp().getSelectionModel(),
        repositories = [];

    //<if assert>
//    NX.Assert.assert(selections.getCount() !== 0, 'Missing selection');
    //</if>

    // collect selected repositories
    Ext.Array.each(selections.getSelection(), function (record) {
      repositories.push({
        repository: record.get('repository'),
        blobStore: record.get('blobStore'),
        ingestMethod: record.get('ingestMethod')
      });
    });
    me.set('selected-repositories', repositories);

    // inform controller to initialize plan configuration
    me.controller.configure();
  },

  /**
   * Open repository customize window.
   *
   * @private
   */
  doCustomize: function (column, grid, ri, ci, item, record, row) {
    if (item.action === 'customize') {
      Ext.create('NX.coreui.migration.RepositoryCustomizeWindow', {
        recordId: record.getId(),
        repository: record.get('repository'),
        blobStore: record.get('blobStore'),
        ingestMethod: record.get('ingestMethod')
      });
    }
  },

  /**
   * Apply changes from repository customize window.
   *
   * @private
   */
  doCustomizeSave: function (button) {
    var window = button.up('window'),
        grid = this.getScreenCmp().getGrid(),
        values = window.getForm().getFieldValues(),
        record = grid.getStore().getById(values.id);

    record.set('blobStore', values.blobStore);
    record.set('ingestMethod', values.ingestMethod);
    record.commit();

    window.close();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Migration preview model.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.migration.PreviewModel', {
  extend: 'Ext.data.Model',
  fields: [
    {name: 'id', type: 'string'},
    {name: 'name', type: 'string'},
    {name: 'state', type: 'string'},
    {name: 'phase', type: 'string'}
  ]
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Migration preview store.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.migration.PreviewStore', {
  extend: 'Ext.data.ArrayStore',
  requires: [
    'NX.coreui.migration.PreviewModel'
  ],

  model: 'NX.coreui.migration.PreviewModel',

  groupField: 'phase',

  // data comes back in proper order, do not attempt to re-sort
  remoteSort: true
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * ???
 *
 * @since 3.0
 */
Ext.define('NX.coreui.migration.OverviewScreen', {
  extend: 'NX.wizard.Screen',
  alias: 'widget.nx-coreui-migration-overview',

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    Ext.apply(me, {
      title: NX.I18n.render(me, 'Title'),

      description: NX.I18n.render(me, 'Description'),

      buttons: ['next']
    });

    me.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Migration overview step.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.migration.OverviewStep', {
  extend: 'NX.wizard.Step',
  requires: [
    'NX.coreui.migration.OverviewScreen'
  ],

  config: {
    screen: 'NX.coreui.migration.OverviewScreen',
    enabled: true
  },

  /**
   * @override
   */
  init: function () {
    var me = this;

    me.control({
      'button[action=next]': {
        click: me.moveNext
      }
    });
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Migration content-options screen.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.migration.ContentScreen', {
  extend: 'NX.wizard.FormScreen',
  alias: 'widget.nx-coreui-migration-content',
  requires: [
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    Ext.apply(me, {
      title: NX.I18n.render(me, 'Title'),

      description: NX.I18n.render(me, 'Description'),

      fields: [
        {
          xtype: 'checkboxgroup',
          columns: 1,
          allowBlank: false,
          items: [
            {
              xtype: 'checkbox',
              name: 'repositories',
              boxLabel: NX.I18n.render(me, 'Repositories_FieldLabel'),
              checked: true
            },
            {
              xtype: 'checkbox',
              name: 'configuration',
              boxLabel: NX.I18n.render(me, 'Configuration_FieldLabel'),
              checked: true
            }
          ]
        }
      ],

      buttons: ['back', 'next', 'cancel']
    });

    me.callParent();
    me.down('form').settingsForm = true;
  },

  /**
   * Returns the state of the screen form
   *
   * @return {boolean}
   */
  isDirty: function() {
    return this.down('form').isDirty();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Migration content-options step.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.migration.ContentStep', {
  extend: 'NX.wizard.Step',
  requires: [
    'NX.State',
    'NX.coreui.migration.ContentScreen'
  ],

  screen: 'NX.coreui.migration.ContentScreen',

  /**
   * @override
   */
  init: function () {
    var me = this;

    me.control({
      'button[action=back]': {
        click: me.moveBack
      },
      'button[action=next]': {
        click: me.doNext
      },
      'button[action=cancel]': {
        click: me.cancel
      }
    });
  },

  /**
   * @override
   */
  reset: function() {
    var me = this,
        screen = me.getScreenCmp();

    if (screen) {
      screen.getForm().reset();
    }

    me.unset('content-options');
    me.callParent();
  },

  /**
   * @private
   */
  doNext: function() {
    var values = this.getScreenCmp().getForm().getFieldValues();
    this.set('content-options', values);

    // when options indicate repositories, move to next
    if (values['repositories']) {
      this.moveNext();
    }
    else {
      // otherwise there is no more configuration, prepare plan
      this.controller.configure();
    }
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Migration SYNC phase screen.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.migration.PhaseSyncScreen', {
  extend: 'NX.coreui.migration.ProgressScreenSupport',
  alias: 'widget.nx-coreui-migration-phasesync',
  requires: [
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    Ext.apply(me, {
      title: NX.I18n.render(me, 'Title'),
      description: NX.I18n.render(me, 'Description'),
      buttons: [
        {
          text: NX.I18n.render(me, 'Abort_Button'),
          action: 'abort',
          ui: 'default'
        },
        {
          text: NX.I18n.render(me, 'Continue_Button'),
          action: 'continue',
          ui: 'nx-primary',
          disabled: true
        }
      ]
    });

    me.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Migration SYNC phase step.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.migration.PhaseSyncStep', {
  extend: 'NX.coreui.migration.ProgressStepSupport',
  requires: [
    'NX.coreui.migration.PhaseSyncScreen',
    'NX.I18n'
  ],

  config: {
    screen: 'NX.coreui.migration.PhaseSyncScreen',
    enabled: true
  },

  phase: 'SYNC',

  /**
   * @override
   */
  init: function () {
    var me = this;

    me.control({
      'button[action=abort]': {
        click: me.doAbort
      },
      'button[action=continue]': {
        click: me.doContinue
      }
    });

    me.callParent();
  },

  /**
   * @private
   * @type {boolean}
   */
  checkSyncStatus: true,

  /**
   * @private
   * @type {boolean}
   */
  waitingToFinish: false,

  /**
   * @override
   */
  prepare: function () {
    var me = this,
        selectedRepos = me.controller.getContext().get('selected-repositories');

    me.checkSyncStatus = selectedRepos && selectedRepos.length;
    me.waitingToFinish = false;
    me.callParent();
  },

  /**
   * @override
   */
  reset: function() {
    var me = this,
        screen = me.getScreenCmp();

    if (screen) {
      screen.down('button[action=continue]').setVisible(true);
      screen.down('button[action=continue]').disable();
      screen.down('button[action=abort]').enable();
    }
    me.callParent();
  },

  /**
   * @override
   */
  refresh: function() {
    var me = this,
        screen = me.getScreenCmp();

    me.callParent();

    if (screen && (me.checkSyncStatus || me.controller.getContext().get('checkSyncStatus'))) {
      NX.direct.migration_Assistant.syncStatus(function (response, event) {
        var isComplete = response.success && response.data.waitingForChanges && response.data.scanComplete;
        if (!me.waitingToFinish && event.status && isComplete) {
          screen.down('button[action=continue]').enable().setText(NX.I18n.render(screen, 'Continue_Button'));
        }
      });
    }
  },

  /**
   * @override
   */
  doComplete: function() {
    var me = this;

    me.mask(NX.I18n.render(me, 'Finish_Mask'));

    NX.direct.migration_Assistant.finish(function (response, event) {
      me.unmask();

      if (event.status && response.success) {
        me.moveNext();

        NX.Messages.success(NX.I18n.render(me, 'Finish_Message'));
      }
    });
  },

  /**
   * @private
   */
  doAbort: function() {
    var me = this;

    NX.Dialogs.askConfirmation(
        NX.I18n.render(me, 'Abort_Confirm_Title'),
        NX.I18n.render(me, 'Abort_Confirm_Text'),
        function () {
          me.mask(NX.I18n.render(me, 'Abort_Mask'));

          me.autoRefresh(false);

          NX.direct.migration_Assistant.abort(function (response, event) {
            me.unmask();

            if (event.status && response.success) {
              me.controller.reset();

              NX.Messages.warning(NX.I18n.render(me, 'Abort_Message'));
            }
          });
        }
    );
  },

  /**
   * @private
   */
  doContinue: function() {
    var me = this;

    NX.Dialogs.askConfirmation(
      NX.I18n.render(me, 'Stop_Waiting_Confirm_Title'),
      NX.I18n.render(me, 'Stop_Waiting_Confirm_Text'),
      function () {
        var screen = me.getScreenCmp();
        screen.down('button[action=continue]').disable()
            .setText(NX.I18n.render(screen, 'Continue_Button_Pending'));
        NX.direct.migration_Assistant.stopWaiting(function (response, event) {
          if (event.status && response.success && response.data) {
            me.waitingToFinish = true;
          }
        });
      }
    );
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Migration agent connection screen.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.migration.AgentScreen', {
  extend: 'NX.wizard.FormScreen',
  alias: 'widget.nx-coreui-migration-agent',

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    Ext.apply(me, {
      title: NX.I18n.render(me, "Title"),

      description: NX.I18n.render(me, "Description"),

      fields: [
        {
          xtype: 'nx-url',
          name: 'url',
          fieldLabel: NX.I18n.render(me, "Endpoint_FieldLabel"),
          helpText: NX.I18n.render(me, "Endpoint_HelpText"),
          allowBlank: false
        },
        {
          xtype: 'textfield',
          inputType: 'password',
          inputAttrTpl: 'autocomplete="new-password"',
          name: 'accessToken',
          fieldLabel: NX.I18n.render(me, "Token_FieldLabel"),
          helpText: NX.I18n.render(me, "Token_HelpText"),
          allowBlank: false
        }
      ],

      buttons: [ 'back', 'next', 'cancel' ]
    });

    me.callParent();

    me.down('form').settingsForm = true;
  },

  /**
   * Returns the state of the screen form
   *
   * @return {boolean}
   */
  isDirty: function() {
    return this.down('form').isDirty();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Migration agent connection step.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.migration.AgentStep', {
  extend: 'NX.wizard.Step',
  requires: [
    'NX.coreui.migration.AgentScreen',
    'NX.I18n'
  ],

  config: {
    screen: 'NX.coreui.migration.AgentScreen',
    enabled: true
  },

  /**
   * @override
   */
  init: function () {
    var me = this;

    me.control({
      'button[action=back]': {
        click: me.moveBack
      },
      'button[action=next]': {
        click: me.doNext
      },
      'button[action=cancel]': {
        click: me.cancel
      }
    });
  },

  /**
   * @override
   */
  reset: function() {
    var me = this,
        screen = me.getScreenCmp();

    if (screen) {
      screen.getForm().reset();
    }

    me.callParent();
  },

  /**
   * @private
   */
  doNext: function() {
    var me = this,
        input = me.getScreenCmp().getForm().getFieldValues();

    me.mask(NX.I18n.render(me, 'Connect_Mask'));

    NX.direct.migration_Assistant.connect(input.url, input.accessToken, input.useTrustStoreForUrl, function (response, event) {
      me.unmask();

      // FIXME: handle validation/errors

      if (event.status && response.success) {
        me.moveNext();

        NX.Messages.success(NX.I18n.render(me, 'Connect_Message'));
      }
    });
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Migration controller.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.migration.Controller', {
  extend: 'NX.wizard.Controller',
  requires: [
    'NX.I18n',
    'NX.Permissions',
    'NX.coreui.migration.PlanStepDetailWindow',
    'NX.coreui.migration.RepositoryStore',
    'NX.coreui.migration.PreviewStore',
    'NX.coreui.migration.ProgressStore',
    'NX.coreui.migration.Panel',
    'NX.coreui.migration.OverviewStep',
    'NX.coreui.migration.ContentStep',
    'NX.coreui.migration.AgentStep',
    'NX.coreui.migration.RepositoryDefaultsStep',
    'NX.coreui.migration.RepositoriesStep',
    'NX.coreui.migration.PreviewStep',
    'NX.coreui.migration.PhasePrepareStep',
    'NX.coreui.migration.PhaseSyncStep',
    'NX.coreui.migration.PhaseFinishStep'
  ],

  stores: [
    'Blobstore',
    'NX.coreui.migration.RepositoryStore',
    'NX.coreui.migration.PreviewStore',
    'NX.coreui.migration.ProgressStore'
  ],

  /**
   * @override
   */
  init: function () {
    var me = this;

    me.callParent();

    me.getApplication().getIconController().addIcons({
      'migration-customize': {
        file: 'wrench_orange.png',
        variants: ['x16', 'x32']
      },
      'migration-step-pending': {
        file: 'lorry.png',
        variants: ['x16', 'x32']
      },
      'migration-step-running': {
        file: 'resultset_next.png',
        variants: ['x16', 'x32']
      },
      'migration-step-done': {
        file: 'tick.png',
        variants: ['x16', 'x32']
      },
      'migration-step-error': {
        file: 'exclamation.png',
        variants: ['x16', 'x32']
      }
    });

    me.getApplication().getFeaturesController().registerFeature({
      mode: 'admin',
      path: '/System/Upgrade',
      text: NX.I18n.render(me, 'Feature_Text'),
      description: NX.I18n.render(me, 'Feature_Description'),
      view: {xtype: 'nx-coreui-migration-panel'},
      iconConfig: {
        file: 'server_go.png',
        variants: ['x16', 'x32']
      },
      visible: function () {
        return NX.Permissions.check('nexus:migration:read');
      }
    }, me);

    me.registerSteps([
      'NX.coreui.migration.OverviewStep',
      'NX.coreui.migration.AgentStep',
      'NX.coreui.migration.ContentStep',
      'NX.coreui.migration.RepositoryDefaultsStep',
      'NX.coreui.migration.RepositoriesStep',
      'NX.coreui.migration.PreviewStep',
      'NX.coreui.migration.PhasePrepareStep',
      'NX.coreui.migration.PhaseSyncStep',
      'NX.coreui.migration.PhaseFinishStep'
    ]);

    me.listen({
      component: {
        'nx-coreui-migration-panel': {
          added: me.load,
          beforerender: me.activate,
          removed: me.reset
        }
      }
    });
  },

  // TODO: Could potentially use StateContributor to inform initial migration state?

  /**
   * @private
   */
  activate: function () {
    var me = this;

    me.mask(NX.I18n.render(me, 'Activate_Mask'));

    // fetch migration status and adapt UI to state, or force cancel
    NX.direct.migration_Assistant.status(function (response, event) {
      me.unmask();

      if (event.status && response.success) {
        var state = response.data.state;
        //<if debug>
//        me.logDebug('Upgrade state:', state);
        //</if>

        switch (state) {
          case 'INITIAL':
            break;

          case 'CONNECTED':
          case 'CONFIGURED':
              me.incompleteCancel();
            break;

          case 'PHASE_PREPARE':
            me.moveToStepNamed('NX.coreui.migration.PhasePrepareStep');
            break;

          case 'PHASE_SYNC':
            //at this point we don't have a list of repositories, but we need to check the status anyway
            me.getContext().add('checkSyncStatus', true);
            me.moveToStepNamed('NX.coreui.migration.PhaseSyncStep');
            break;

          case 'PHASE_FINISH':
            me.moveToStepNamed('NX.coreui.migration.PhaseFinishStep');
            break;

          default:
            me.logError('Unknown state:', state);
            break;
        }
      }
    });
  },

  /**
   * @private
   */
  incompleteCancel: function() {
    var me = this;

    NX.Dialogs.showInfo(
        NX.I18n.render(me, 'IncompleteCancel_Title'),
        NX.I18n.render(me, 'IncompleteCancel_Text'),
        {
          fn: function () {
            me.mask(NX.I18n.render(me, 'IncompleteCancel_Mask'));
            NX.direct.migration_Assistant.cancel(function (response, event) {
              if (event.status && response.success) {
                me.reset();
              }
              me.unmask();
            });
          }
        }
    );
  },

  /**
   * Configure migration plan.
   */
  configure: function () {
    var me = this,
        ctx = me.getContext(),
        config;

    me.mask(NX.I18n.render(me, 'Configure_Mask'));

    // aggregate migration plan configuration from context
    config = {
      options: ctx.get('content-options'),
      repositories: ctx.get('selected-repositories')
    };

    // configure plan
    NX.direct.migration_Assistant.configure(config, function (response, event) {
      if (event.status && response.success) {
        ctx.add('plan-preview', response.data);

        me.unmask();
        me.moveNext();

        NX.Messages.success(NX.I18n.render(me, 'Configure_Message'));
      }
      else {
        // ensure we unmask
        me.unmask();
      }
    });
  },

  /**
   * Display plan-step detail window.
   *
   * @param id {String} plan-step id
   */
  displayPlanStepDetail: function (id) {
    var me = this;

    me.mask(NX.I18n.render(me, 'PlanStepDetail_Mask'));

    NX.direct.migration_Progress.detail(id, function (response, event) {
      if (event.status && response.success) {
        Ext.create('NX.coreui.migration.PlanStepDetailWindow', {
          detail: response.data
        });
      }

      me.unmask();
    });
  },

  /**
   * Customized cancel behavior to prompt user.
   *
   * @override
   */
  cancel: function () {
    var me = this;

    NX.Dialogs.askConfirmation(
        NX.I18n.render(me, 'Cancel_Confirm_Title'),
        NX.I18n.render(me, 'Cancel_Confirm_Text'),
        function () {
          me.mask(NX.I18n.render(me, 'Cancel_Mask'));

          NX.direct.migration_Assistant.cancel(function (response, event) {
            me.unmask();

            if (event.status && response.success) {
              // invoke super, callParent() unavailable in callback
              me.self.superclass.cancel.call(me);

              NX.Messages.success(NX.I18n.render(me, 'Cancel_Message'));
            }
          });
        }
    );
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Add logger window.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.logging.LoggerAdd', {
  extend: 'NX.view.AddPanel',
  alias: 'widget.nx-coreui-logger-add',
  requires: [
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function() {
    Ext.apply(this, {
      defaultFocus: 'name',

      settingsForm: {
        xtype: 'nx-settingsform',
        items: [
          {
            xtype: 'textfield',
            name: 'name',
            itemId: 'name',
            fieldLabel: NX.I18n.get('Logging_LoggerAdd_Name_FieldLabel')
          },
          {
            xtype: 'combo',
            name: 'level',
            fieldLabel: NX.I18n.get('Logging_LoggerAdd_Level_FieldLabel'),
            editable: false,
            value: 'INFO',
            store: [
              ['TRACE', NX.I18n.get('Logging_LoggerList_Level_TraceItem')],
              ['DEBUG', NX.I18n.get('Logging_LoggerList_Level_DebugItem')],
              ['INFO', NX.I18n.get('Logging_LoggerList_Level_InfoItem')],
              ['WARN', NX.I18n.get('Logging_LoggerList_Level_WarnItem')],
              ['ERROR', NX.I18n.get('Logging_LoggerList_Level_ErrorItem')],
              ['OFF', NX.I18n.get('Logging_LoggerList_Level_OffItem')],
              ['DEFAULT', NX.I18n.get('Logging_LoggerList_Level_DefaultItem')]
            ],
            queryMode: 'local'
          }
        ],
        buttons: [
          { text: NX.I18n.get('Logging_LoggerList_New_Button'), action: 'add', formBind: true, ui: 'nx-primary' },
          { text: NX.I18n.get('Add_Cancel_Button'), action: 'back' }
        ]
      }
    });

    this.callParent();
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * File created window.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.support.FileCreated', {
  extend: 'NX.view.ModalDialog',
  alias: 'widget.nx-coreui-support-filecreated',
  requires: [
    'NX.I18n'
  ],

  // FIXME: remove use of nx-inset
  ui: 'nx-inset',

  // FIXME: convert to config{} block
  /**
   * @cfg Icon to show (img)
   */
  fileIcon: undefined,

  /**
   * @cfg Type of file shown
   */
  fileType: undefined,

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    me.setWidth(NX.view.ModalDialog.LARGE_MODAL);

    Ext.apply(me, {
      title: me.title || me.fileType + ' Created',
      items: [
        {
          xtype: 'form',
          defaults: {
            anchor: '100%'
          },
          items: [
            {
              // FIXME: use container instead of panel
              xtype: 'panel',
              layout: 'hbox',
              style: {
                // FIXME: sort out common style here for dialogs
                marginBottom: '10px'
              },
              // TODO Style
              items: [
                { xtype: 'component', html: me.fileIcon },
                { xtype: 'component', html: me.fileType + ' has been created.' +
                    '<br/>You can reference this file on the filesystem or download the file from your browser.',
                  margin: '0 0 0 5'
                }
              ]
            },
            {
              // TODO Style
              xtype: 'textfield',
              name: 'name',
              fieldLabel: NX.I18n.get('Support_FileCreated_Name_FieldLabel'),
              helpText: me.fileType + ' file name',
              readOnly: true
            },
            {
              // TODO Style
              xtype: 'textfield',
              name: 'size',
              fieldLabel: NX.I18n.get('Support_FileCreated_Size_FieldLabel'),
              // FIXME: Would like to render in bytes/kilobytes/megabytes
              helpText: 'Size of ' + me.fileType + ' file in bytes',
              readOnly: true
            },
            {
              xtype: 'textfield',
              name: 'file',
              fieldLabel: NX.I18n.get('Support_FileCreated_Path_FieldLabel'),
              helpText: me.fileType + ' file location',
              readOnly: true,
              selectOnFocus: true
            },
            {
              xtype: 'hidden',
              name: 'truncated'
            }
          ],

          buttonAlign: 'left',
          buttons: [
            {
              text: NX.I18n.get('Support_FileCreated_Download_Button'),
              action: 'download',
              formBind: true,
              bindToEnter: true,
              ui: 'nx-primary',
              glyph: 'xf023@FontAwesome' /* fa-lock */
            },
            {
              text: NX.I18n.get('Support_FileCreated_Cancel_Button'),
              handler: me.close,
              scope: me
            }
          ]
        }
      ]
    });

    me.callParent();
  },

  /**
   * Set form values.
   *
   * @public
   */
  setValues: function (values) {
    this.down('form').getForm().setValues(values);
  },

  /**
   * Get form values.
   *
   * @public
   */
  getValues: function () {
    return this.down('form').getForm().getValues();
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * User sources store.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.store.UserSource', {
  extend: 'Ext.data.Store',
  model: 'NX.coreui.model.Reference',

  proxy: {
    type: 'direct',
    paramsAsHash: false,

    api: {
      read: 'NX.direct.coreui_User.readSources'
    },

    reader: {
      type: 'json',
      rootProperty: 'data',
      successProperty: 'success'
    }
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * LDAP Server "User & Group" form.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.ldap.LdapServerUserAndGroupForm', {
  extend: 'NX.view.SettingsForm',
  alias: 'widget.nx-coreui-ldapserver-userandgroup-form',
  requires: [
    'NX.Conditions',
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function() {
    var me = this;

    me.items = { xtype: 'nx-coreui-ldapserver-userandgroup-fieldset' };

    me.editableMarker = NX.I18n.get('Ldap_LdapServerConnectionForm_Update_Error');

    me.editableCondition = me.editableCondition || NX.Conditions.isPermitted('nexus:ldap:update');

    me.callParent();

    me.getDockedItems('toolbar[dock="bottom"]')[0].add(
        { xtype: 'button', text: NX.I18n.get('Ldap_LdapServerUserAndGroupForm_VerifyGroupMapping_Button'), formBind: true, action: 'verifyusermapping' },
        { xtype: 'button', text: NX.I18n.get('Ldap_LdapServerUserAndGroupForm_VerifyLogin_Button'), formBind: true, action: 'verifylogin' }
    );
  },

  /**
   * @override
   * Additionally, marks invalid properties.
   */
  markInvalid: function(errors) {
    this.down('nx-coreui-ldapserver-userandgroup-fieldset').markInvalid(errors);
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Task Schedule Advanced field set.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.task.TaskScheduleAdvanced', {
  extend: 'NX.coreui.view.task.TaskScheduleFields',
  alias: 'widget.nx-coreui-task-schedule-advanced',
  requires: [
    'NX.I18n'
  ],

  initComponent: function () {
    var me = this;

    me.items = [
      {
        xtype: 'textfield',
        name: 'cronExpression',
        fieldLabel: NX.I18n.get('Task_TaskScheduleAdvanced_Cron_FieldLabel'),
        helpText: NX.I18n.get('Task_TaskScheduleAdvanced_Cron_HelpText'),
        afterBodyEl: NX.I18n.get('Task_TaskScheduleAdvanced_Cron_AfterBodyEl'),
        emptyText: NX.I18n.get('Task_TaskScheduleAdvanced_Cron_EmptyText'),
        allowBlank: false
      }
    ];

    me.callParent();
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * User account settings form.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.user.UserAccount', {
  extend: 'NX.view.SettingsPanel',
  alias: 'widget.nx-coreui-user-account',
  requires: [
    'NX.I18n'
  ],

  initComponent: function () {
    var me = this;

    me.settingsForm = [
      {
        xtype: 'nx-settingsform',
        settingsFormSuccessMessage: NX.I18n.get('User_UserAccount_Update_Success'),
        api: {
          load: 'NX.direct.coreui_User.readAccount',
          submit: 'NX.direct.coreui_User.updateAccount'
        },
        editableMarker: NX.I18n.get('User_UserAccount_Update_Error'),
        items: [
          {
            name: 'userId',
            itemId: 'userId',
            readOnly: true,
            fieldLabel: NX.I18n.get('User_UserAccount_ID_FieldLabel'),
            helpText: NX.I18n.get('User_UserAccount_ID_HelpText')
          },
          {
            name: 'firstName',
            fieldLabel: NX.I18n.get('User_UserAccount_First_FieldLabel')
          },
          {
            name: 'lastName',
            fieldLabel: NX.I18n.get('User_UserAccount_Last_FieldLabel')
          },
          {
            xtype: 'nx-email',
            name: 'email',
            fieldLabel: NX.I18n.get('User_UserAccount_Email_FieldLabel')
          },
          {
            xtype: 'hidden',
            name: 'external',
            listeners: {
              change: function(field, value) {
                var form = field.up('nx-settingsform'),
                    external = value && value.trim().toLowerCase() === 'true'; // hidden fields values are always strings

                form.getForm().external = external;
                form.setEditable(!external);
              }
            }
          }
        ]
      }
    ];

    me.callParent();

    me.down('nx-settingsform').getDockedItems('toolbar[dock="bottom"]')[0].add({
      xtype: 'button', text: NX.I18n.get('User_UserAccount_Password_Button'), action: 'changepassword', glyph: 'xf023@FontAwesome' /* fa-lock */, disabled: true
    });

    // do not perform any validity check if we have an external user
    Ext.override(me.down('nx-settingsform').getForm(), {
      isValid: function() {
        if (this.external) {
          this.clearInvalid();
          return true;
        }
        else {
          return this.callParent();
        }
      }
    });
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Configuration for Docker proxy repositories.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.repository.facet.DockerProxyFacet', {
  extend: 'Ext.form.FieldContainer',
  alias: 'widget.nx-coreui-repository-docker-proxy-facet',
  requires: [
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function() {
    var me = this;

    me.items = [
      {
        xtype: 'fieldcontainer',
        fieldLabel: NX.I18n.get('Repository_Facet_DockerProxyFacet_IndexType_FieldLabel'),
        defaultType: 'radiofield',
        layout: 'vbox',
        items: [
          {
            boxLabel: NX.I18n.get('Repository_Facet_DockerProxyFacet_IndexTypeRegistry_BoxLabel'),
            name: 'attributes.dockerProxy.indexType',
            itemId: 'indexTypeRegistry',
            inputValue: 'REGISTRY',
            checked: true,
            listeners: {
              change: function(radio) {
                var remoteUrl = radio.up('form').down('#remoteUrl'),
                    indexUrl = radio.up('form').down('#indexUrl');
                if (radio.getValue()) {
                  indexUrl.setValue(remoteUrl.getValue());
                  indexUrl.setDisabled(true);
                  indexUrl.setVisible(false);
                }
              }
            }
          },
          {
            boxLabel: NX.I18n.get('Repository_Facet_DockerProxyFacet_IndexTypeHub_BoxLabel'),
            name: 'attributes.dockerProxy.indexType',
            itemId: 'indexTypeHub',
            inputValue: 'HUB',
            listeners: {
              change: function(radio) {
                var indexUrl = radio.up('form').down('#indexUrl');
                if (radio.getValue()) {
                  me.deselectDefaultOption(radio);
                  indexUrl.setValue('https://index.docker.io/');
                  indexUrl.setDisabled(true);
                  indexUrl.setVisible(true);
                }
              }
            }
          },
          {
            boxLabel: NX.I18n.get('Repository_Facet_DockerProxyFacet_IndexTypeCustom_BoxLabel'),
            name: 'attributes.dockerProxy.indexType',
            itemId: 'indexTypeCustom',
            inputValue: 'CUSTOM',
            listeners: {
              change: function(radio) {
                var indexUrl = radio.up('form').down('#indexUrl');
                if (radio.getValue()) {
                  me.deselectDefaultOption(radio);
                  indexUrl.setDisabled(false);
                  indexUrl.setVisible(true);
                }
              }
            }
          }
        ]
      },
      {
        xtype: 'nx-url',
        itemId: 'indexUrl',
        name: 'attributes.dockerProxy.indexUrl',
        helpText: NX.I18n.get('Repository_Facet_DockerProxyFacet_IndexUrl_HelpText'),
        disabled: true,
        hidden: true,
        allowBlank: false,
        useTrustStore: function(field) {
          var remoteUrl = field.up('form').down('#remoteUrl');
          if (Ext.String.startsWith(field.getValue(), 'https://') && field.getValue() !== remoteUrl.getValue()) {
            return {
              name: 'attributes.dockerProxy.useTrustStoreForIndexAccess',
              url: field
            };
          }
          return undefined;
        }
      }
    ];

    me.callParent();
  },

  deselectDefaultOption: function(radio) {
    var indexTypeRegistryRadio = radio.up('form').down('#indexTypeRegistry');
    if (indexTypeRegistryRadio.getValue()) {
      //this is working around an apparent bug in ext where 2 radiobuttons from same group are being
      //selected apparently because we have the 'checked' property set on one of them
      indexTypeRegistryRadio.setValue(false);
    }
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Cleanup Policy model.
 *
 * @since 3.14
 */
Ext.define('NX.coreui.model.CleanupPolicy', {
  extend: 'Ext.data.Model',
  idProperty: 'name',
  fields: [
    {name: 'name', type: 'string', sortType: 'asUCText'},
    {name: 'format', type: 'string', sortType: 'asUCText'},
    {name: 'notes', type: 'string', sortType: 'asUCText'},
    {name: 'mode', type: 'string', sortType: 'asUCText'},
    {name: 'sortOrder', sortType: 'asInt'}
  ]
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Cleanup Policy store.
 *
 * @since 3.14
 */
Ext.define('NX.coreui.store.CleanupPolicies', {
  extend: 'Ext.data.Store',
  model: 'NX.coreui.model.CleanupPolicy',

  proxy: {
    type: 'direct',

    api: {
      read: 'NX.direct.cleanup_CleanupPolicy.readAll'
    },

    reader: {
      type: 'json',
      rootProperty: 'data',
      idProperty: 'id',
      successProperty: 'success'
    }
  },

  sorters: [{ property: 'name', direction: 'ASC' }]
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Clustered task state model.
 *
 * @since 3.1
 */
Ext.define('NX.coreui.model.ClusteredTaskState', {
  extend: 'Ext.data.Model',
  fields: [
    {name: 'nodeId', type: 'string', sortType: 'asUCText'},
    {name: 'status', type: 'string', sortType: 'asUCText'},
    {name: 'statusDescription', type: 'string', sortType: 'asUCText'},
    {name: 'lastRunResult', type: 'string', sortType: 'asUCText'}
  ]
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Task model.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.model.Task', {
  extend: 'Ext.data.Model',
  requires: [
    'NX.coreui.model.ClusteredTaskState'
  ],
  fields: [
    {name: 'id', type: 'string', sortType: 'asUCText'},
    {name: 'enabled', type: 'boolean'},
    {name: 'name', type: 'string', sortType: 'asUCText'},
    {name: 'typeId', type: 'string', sortType: 'asUCText'},
    {name: 'typeName', type: 'string', sortType: 'asUCText'},
    {name: 'status', type: 'string', sortType: 'asUCText'},
    {name: 'statusDescription', type: 'string', sortType: 'asUCText'},
    {name: 'schedule', type: 'string', sortType: 'asUCText'},
    {name: 'nextRun', type: 'date', dateFormat: 'c' },
    {name: 'lastRun', type: 'date', dateFormat: 'c' },
    {name: 'lastRunResult', type: 'string'},
    {name: 'runnable', type: 'boolean'},
    {name: 'stoppable', type: 'boolean'},
    {name: 'alertEmail', type: 'string'},
    {name: 'properties', type: 'auto' /*object*/, defaultValue: null },
    {name: 'startDate', type: 'date', dateFormat: 'c' },
    {name: 'recurringDays', type: 'auto' /*array*/},
    {name: 'cronExpression', type: 'string'}
  ],
  hasMany: {
    model: 'NX.coreui.model.ClusteredTaskState',
    associationKey: 'clusteredTaskStates',
    name: 'clusteredTaskStates'
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Task store.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.store.Task', {
  extend: 'Ext.data.Store',
  model: 'NX.coreui.model.Task',

  proxy: {
    type: 'direct',
    paramsAsHash: false,

    api: {
      read: 'NX.direct.coreui_Task.read'
    },

    reader: {
      type: 'json',
      rootProperty: 'data',
      successProperty: 'success'
    }
  },

  sorters: { property: 'name', direction: 'ASC' }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Selector "Settings" form.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.selector.SelectorSettingsForm', {
  extend: 'NX.view.SettingsForm',
  alias: 'widget.nx-coreui-selector-settings-form',
  requires: [
    'NX.Conditions',
    'NX.I18n'
  ],

  api: {
    submit: 'NX.direct.coreui_Selector.update'
  },

  initComponent: function() {
    var me = this;

    me.settingsFormSuccessMessage = me.settingsFormSuccessMessage || function(data) {
          return NX.I18n.format('Selector_SelectorSettingsForm_Update_Success', data['name']);
        };

    me.editableMarker = me.editableMarker || NX.I18n.get('Selector_SelectorSettingsForm_Update_Error');

    me.editableCondition = me.editableCondition || NX.Conditions.isPermitted('nexus:selectors:update');

    me.items = [
      {
        xtype: 'hiddenfield',
        name: 'id'
      },
      {
        xtype: 'fieldcontainer',
        items: {
          xtype: 'fieldset',
          cls: 'nx-form-section',
          title: NX.I18n.get('Selector_SelectorSettingsForm_SelectorID_Title'),
          defaults: {
            xtype: 'textfield',
            allowBlank: false
          },
          items: [
            {
              name: 'name',
              itemId: 'name',
              fieldLabel: NX.I18n.get('Selector_SelectorSettingsForm_Name_FieldLabel'),
              readOnly: true
            },
            {
              xtype: 'combo',
              cls: 'nx-combo-disabled',
              name: 'type',
              fieldLabel: NX.I18n.get('Selector_SelectorSettingsForm_Type_FieldLabel'),
              editable: false,
              store: [
                ['jexl', NX.I18n.get('Selector_SelectorSettingsForm_Type_Jexl')],
                ['csel', NX.I18n.get('Selector_SelectorSettingsForm_Type_Sonatype')]
              ],
              value: 'csel',
              readOnly: true
            },
            {
              name: 'description',
              allowBlank: true,
              fieldLabel: NX.I18n.get('Selector_SelectorSettingsForm_Description_FieldLabel'),
              transformRawValue: Ext.htmlDecode
            }
          ]
        }
      },
      {
        xtype: 'fieldcontainer',
        items: {
          xtype: 'fieldset',
          cls: 'nx-form-section',
          title: NX.I18n.get('Selector_SelectorSettingsForm_Specification_Title'),
          defaults: {
            xtype: 'textfield',
            allowBlank: false
          },
          items: [{
            xtype: 'textareafield',
            name: 'expression',
            itemId: 'expression',
            fieldLabel: NX.I18n.get('Selector_SelectorSettingsForm_Expression_FieldLabel'),
            helpText: NX.I18n.get('Selector_SelectorSettingsForm_Expression_HelpText')
          },{
              xtype: 'panel',
              itemId: 'cselHelp',
              html: NX.I18n.get('Selector_SelectorSettingsForm_Expression_Examples')
          },{
              xtype: 'panel',
              itemId: 'jexlHelp',
              html: NX.I18n.get('Selector_SelectorSettingsForm_Expression_Examples_jexl'),
              hidden: true
          }]
        }
      }
    ];

    me.callParent();
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * License Agreement window.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.licensing.LicenseAgreement', {
  extend: 'Ext.window.Window',
  alias: 'widget.nx-coreui-licensing-agreement',
  requires: [
    'NX.util.Url',
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    me.title = NX.I18n.get('Licensing_LicenseAgreement_Title');

    me.layout = 'fit';
    me.autoShow = true;
    me.modal = true;
    me.constrain = true;
    me.width = 640;
    me.height = 500;

    me.items = {
      xtype: 'box',
      autoEl: {
        tag: 'iframe',
        src: NX.util.Url.licenseUrl()
      }
    };

    me.dockedItems = [
      {
        xtype: 'toolbar',
        dock: 'bottom',
        ui: 'footer',
        items: [
          { xtype: 'button', text: NX.I18n.get('Licensing_LicenseAgreement_Yes_Button'), action: 'agree', formBind: true, ui: 'nx-primary' },
          { xtype: 'button', text: NX.I18n.get('Licensing_LicenseAgreement_No_Button'), handler: function () {
            this.up('window').close();
          }},
          '->',
          { xtype: 'component', html: '<a href="' + NX.util.Url.licenseUrl() +
              '" target="_new">' + NX.I18n.get('Licensing_LicenseAgreement_Download_Button') + '</a>'
          }
        ]
      }
    ];

    me.callParent();
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Licensing details panel.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.licensing.LicensingDetails', {
  extend: 'NX.view.SettingsPanel',
  alias: 'widget.nx-coreui-licensing-details',
  requires: [
    'NX.I18n',
    'Ext.util.Cookies'
  ],

  /**
   * @override
   */
  initComponent: function() {
    var dateFormat = 'D, M d, Y';
    Ext.apply(this, {
      settingsForm: [
        {
          xtype: 'nx-settingsform',
          api: {
            load: 'NX.direct.licensing_Licensing.read'
          },
          listeners: {
            'actioncomplete': function(form, action, eOpts) {
              var fieldValues = form.getFieldValues();
              if(!fieldValues.contactCompany) {
                this.hide();  
              }
            }
          }, 
          itemId: 'details',
          defaults: {
            xtype: 'textfield',
            readOnly: true
          },
          items: [
            {
              name: 'contactCompany',
              fieldLabel: NX.I18n.get('Licensing_LicensingDetails_Company_FieldLabel'),
              xtype: 'displayfield'
            },
            {
              name: 'contactName',
              fieldLabel: NX.I18n.get('Licensing_LicensingDetails_Name_FieldLabel'),
              xtype: 'displayfield'
            },
            {
              name: 'contactEmail',
              fieldLabel: NX.I18n.get('Licensing_LicensingDetails_Email_FieldLabel'),
              xtype: 'displayfield'
            },
            {
              name: 'effectiveDate',
              fieldLabel: NX.I18n.get('Licensing_LicensingDetails_EffectiveDate_FieldLabel'),
              xtype: 'nx-datedisplayfield',
              format: dateFormat
            },
            {
              name: 'expirationDate',
              fieldLabel: NX.I18n.get('Licensing_LicensingDetails_ExpirationDate_FieldLabel'),
              xtype: 'nx-datedisplayfield',
              format: dateFormat
            },
            {
              name: 'licenseType',
              fieldLabel: NX.I18n.get('Licensing_LicensingDetails_Type_FieldLabel'),
              xtype: 'displayfield'
            },
            {
              name: 'licensedUsers',
              fieldLabel: NX.I18n.get('Licensing_LicensingDetails_LicensedUsers_FieldLabel'),
              xtype: 'displayfield'
            },
            {
              name: 'connections',
              fieldLabel: NX.I18n.get('Licensing_LicensingDetails_Connections_FieldLabel'),
              xtype: 'displayfield'
            },
            {
              name: 'fingerprint',
              fieldLabel: NX.I18n.get('Licensing_LicensingDetails_Fingerprint_FieldLabel'),
              xtype: 'displayfield'
            }
          ],
          buttons: undefined
        },
        {
          xtype: 'form',
          title: NX.I18n.get('Licensing_LicensingDetails_InstallLicense_Title'),
          ui: 'nx-subsection',
          frame: true,

          api: {
            submit: 'NX.direct.licensing_Licensing.install'
          },
          baseParams: {
            'NX-ANTI-CSRF-TOKEN': Ext.util.Cookies.get('NX-ANTI-CSRF-TOKEN')
          },

          items: [
            {
              xtype: 'label',
              html: NX.I18n.get('Licensing_LicensingDetails_InstallLicense_Html')
            },
            {
              xtype: 'fileuploadfield',
              name: 'license',
              allowBlank: false,
              buttonText: NX.I18n.get('Licensing_LicensingDetails_LicenseSelect_Button'),
              buttonConfig: {
                glyph: 'xf016@FontAwesome' /* fa-file-o */
              }
            }
          ],

          buttonAlign: 'left',
          buttons: [
            { text: NX.I18n.get('Licensing_LicensingDetails_LicenseInstall_Button'), action: 'install', formBind: true, ui: 'nx-primary', glyph: 'xf023@FontAwesome' /* fa-lock */ }
          ]
        }
      ]
    });

    this.callParent();
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Licensing controller.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.controller.Licensing', {
  extend: 'NX.app.Controller',
  requires: [
    'NX.Conditions',
    'NX.Permissions',
    'NX.Messages',
    'NX.Security',
    'NX.I18n'
  ],

  views: [
    'licensing.LicenseAgreement',
    'licensing.LicensingDetails'
  ],

  refs: [
    {
      ref: 'panel',
      selector: 'nx-coreui-licensing-details'
    }
  ],

  /**
   * @override
   */
  init: function () {
    var me = this;

    me.getApplication().getFeaturesController().registerFeature({
      mode: 'admin',
      path: '/System/Licensing',
      text: NX.I18n.get('Licensing_Text'),
      description: NX.I18n.get('Licensing_Description'),
      view: { xtype: 'nx-coreui-licensing-details' },
      iconConfig: {
        file: 'license_key.png',
        variants: ['x16', 'x32']
      },
      visible: function () {
        return NX.Permissions.check('nexus:licensing:read');
      }
    }, me);

    me.listen({
      component: {
        'nx-coreui-licensing-details button[action=install]': {
          click: me.install,
          afterrender: me.bindInstallButton
        },
        'nx-coreui-licensing-agreement button[action=agree]': {
          click: me.onAgree
        }
      }
    });
  },

  /**
   * @private
   */
  showAgreementWindow: function () {
    return Ext.widget('nx-coreui-licensing-agreement');
  },

  /**
   * @private
   * Install license, as user agreed.
   */
  onAgree: function (button) {
    var me = this,
        win = button.up('window'),
        form = win.licenseForm,
        authToken = win.authToken;

    win.close();
    form.submit({
      params: {
        authToken: authToken
      },
      success: function () {
        NX.Messages.add({ text: NX.I18n.get('Licensing_Install_Success'), type: 'success' });
        me.getPanel().down('nx-settingsform').load(); //reload to pick up server changes
        me.getPanel().down('nx-settingsform').show();
      }
    });
  },

  /**
   * @override
   * @private
   * Enable 'Install' when user has 'create' permission.
   */
  bindInstallButton: function (button) {
    button.mon(
        NX.Conditions.and(
            NX.Conditions.isPermitted('nexus:licensing:create')
        ),
        {
          satisfied: function () {
            button.enable();
          },
          unsatisfied: function () {
            button.disable();
          }
        }
    );
  },

  /**
   * @private
   * Install a license after successful authentication.
   */
  install: function (button) {
    var me = this,
        form = button.up('form');
    NX.Security.doWithAuthenticationToken(
        NX.I18n.format('Licensing_Authentication_Validation', 'Installing'),
        {
          success: function (authToken) {
            Ext.apply(me.showAgreementWindow(), { licenseForm: form, authToken: authToken });
            me.getPanel().down('form').show();
          }
        }
    );
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Capability "Summary" panel.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.capability.CapabilitySummary', {
  extend: 'Ext.Panel',
  alias: 'widget.nx-coreui-capability-summary',
  requires: [
    'NX.Conditions',
    'NX.I18n'
  ],
  scrollable: true,
  cls: 'nx-hr',

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    me.title = NX.I18n.get('Capability_CapabilitySummary_Title');

    me.layout = {
      type: 'vbox',
      align: 'stretch'
    };

    me.items = {
      xtype: 'panel',
      ui: 'nx-inset',
      items: [
        {
          xtype: 'panel',
          ui: 'nx-subsection',
          itemId: 'nx-coreui-capability-summary-subsection',
          frame: true,
          layout: 'column',
          weight: 10,
          items: [
            {
              xtype: 'nx-info',
              columnWidth: 1
            }
          ]
        },
        {
          xtype: 'nx-coreui-capability-status',
          ui: 'nx-subsection',
          frame: true,
          title: NX.I18n.get('Capability_CapabilitySummary_Status_Title'),
          weight: 20
        },
        {
          xtype: 'nx-coreui-capability-about',
          ui: 'nx-subsection',
          frame: true,
          title: NX.I18n.get('Capability_CapabilitySummary_About_Title'),
          weight: 30
        },
        {
          xtype: 'nx-settingsform',
          itemId: 'nx-coreui-capability-notes-subsection',
          title: NX.I18n.get('Capability_CapabilitySummary_Notes_Title'),
          weight: 40,
          api: {
            submit: 'NX.direct.capability_Capability.updateNotes'
          },
          settingsFormSuccessMessage: function (data) {
            var description = NX.I18n.format('Capabilities_Update_Success', data['typeName']);
            if (data['description']) {
              description += ' - ' + data['description'];
            }
            return description;
          },
          editableCondition: NX.Conditions.isPermitted('nexus:capabilities:update'),
          editableMarker: NX.I18n.get('Capabilities_Update_Error'),
          items: [
            {
              xtype: 'hiddenfield',
              name: 'id'
            },
            {
              xtype: 'textarea',
              helpText: NX.I18n.get('Capability_CapabilitySummary_Notes_HelpText'),
              name: 'notes',
              allowBlank: true,
              anchor: '100%',
              transformRawValue: Ext.htmlDecode
            }
          ]
        }
      ]
    };

    me.callParent();
  },

  /**
   * @public
   * Shows capability info.
   * @param {Object} info capability info object
   */
  showInfo: function (info) {
    this.down('nx-info').showInfo(info);
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Health Check Summary window.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.healthcheck.HealthCheckSummary', {
  extend: 'Ext.window.Window',
  alias: 'widget.nx-coreui-healthcheck-summary',
  requires: [
    'Ext.util.DelayedTask',
    'NX.I18n'
  ],

  /**
   * @cfg {NX.coreui.model.HealthCheckRepositoryStatus} model corresponding to this summary report
   */
  statusModel: undefined,

  layout: 'fit',
  header: false,
  closable: false,
  autoShow: true,
  modal: false,
  constrain: true,
  resizable: false,
  mouseIsOver: true,

  /**
   * @override
   */
  initComponent: function() {
    var me = this;

    me.items = {
      xtype: 'box',
      border: false,
      autoEl: {
        tag: 'iframe',
        src: me.statusModel.get('summaryUrl')
      }
    };

    me.callParent();

    me.addDocked({
      xtype: 'toolbar',
      dock: 'bottom',
      items: {
        xtype: 'label',
        html: NX.I18n.get('HealthCheckSummary_Help')
      }
    });
  },

  listeners: {

    /**
     * Hook into hovering over summary window in order to auto close it if mouse is out.
     */
    afterrender: function(){
      var me = this;

      me.el.hover(
          function () {
            me.mouseIsOver = true;
          },
          function () {
            me.mouseIsOver = false;
            if (me.closeOnMouseOut) {
              me.closeOnMouseOut = false;
              me.close();
            }
          },
          me
      );

      me.task = Ext.create('Ext.util.DelayedTask', me.doAutoClose, me);
      me.task.delay(1000);
    }
  },

  /**
   * Auto close window if mouse is out of summary window.
   *
   * @private
   */
  doAutoClose: function () {
    var me = this;

    if (!me.mouseIsOver) {
      // Close immediately
      me.close();
    } else {
      // Delayed closing when mouse leaves the component.
      me.closeOnMouseOut = true;
    }
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * CLM Application store.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.store.ClmApplication', {
  extend: 'Ext.data.Store',
  model: 'NX.coreui.model.Reference',

  proxy: {
    type: 'direct',
    paramsAsHash: false,

    api: {
      read: 'NX.direct.clm_CLM.readApplications'
    },

    reader: {
      type: 'json',
      rootProperty: 'data',
      successProperty: 'success'
    }
  },

  sorters: { property: 'name', direction: 'ASC' }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * CLM test results window (shows a list of applications).
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.clm.ClmSettingsTestResults', {
  extend: 'NX.view.ModalDialog',
  alias: 'widget.nx-coreui-clm-settings-testresults',
  requires: [
    'Ext.data.JsonStore',
    'NX.I18n'
  ],

  /**
   * @cfg json array of applications (as returned by checking the connection)
   */
  applications: undefined,

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    me.title = NX.I18n.get('Clm_SettingsTestResults_Title');

    me.layout = 'fit';
    me.closable = true;
    me.autoShow = true;
    me.modal = true;
    me.constrain = true;

    me.buttonAlign = 'left';
    me.buttons = [
      { text: NX.I18n.get('Button_Close'), handler: function () {
        this.up('window').close();
      }}
    ];

    me.items = {
      xtype: 'grid',
      emptyText: NX.I18n.get('Clm_SettingsTestResults_EmptyText'),
      columns: [
        { header: NX.I18n.get('Clm_SettingsTestResults_Id_Header'), dataIndex: 'id', flex: 1 },
        { header: NX.I18n.get('Clm_SettingsTestResults_Name_Header'), dataIndex: 'name', flex: 1 }
      ],
      store: Ext.create('Ext.data.JsonStore', {
        fields: ['id', 'name'],
        data: me.applications
      })
    };

    me.width = NX.view.ModalDialog.LARGE_MODAL;
    me.maxHeight = me.height = Ext.getBody().getViewSize().height - 100;

    me.callParent();
    me.center();
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * CLM dashboard view.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.clm.ClmDashboard', {
  extend: 'Ext.panel.Panel',
  alias: 'widget.nx-coreui-clm-dashboard',

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    me.items = [
      {
        xtype: 'box',
        html: '<p>Visit the <a href="http://www.sonatype.com/clm" target="_blank">IQ Server</a> dashboard to manage applications, organizations and policies.</p>',
        margin: 10
      },
      {
        xtype: 'nx-settingsform',
        buttons: [
          {
            xtype: 'button',
            action: 'open',
            ui: 'nx-primary',
            text: 'Open IQ Server Dashboard',
            glyph: 'xf08e@FontAwesome' /* fa-external-link */
          }
        ]
      }
    ];

    me.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * CLM settings form.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.clm.ClmSettings', {
  extend: 'NX.view.SettingsPanel',
  alias: 'widget.nx-coreui-clm-settings',
  requires: [
    'NX.Conditions',
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    me.settingsForm = {
      xtype: 'nx-settingsform',
      settingsFormSuccessMessage: 'IQ Server Settings $action',
      api: {
        load: 'NX.direct.clm_CLM.read',
        submit: 'NX.direct.clm_CLM.update'
      },
      editableCondition: NX.Conditions.isPermitted('nexus:settings:update'),
      editableMarker: NX.I18n.get('Clm_ClmSettings_Permission_Error'),
      items: [
        {
          xtype: 'label',
          html: NX.I18n.get('ClmSettings_Html')
        },
        {
          xtype: 'checkbox',
          name: 'enabled',
          fieldLabel: NX.I18n.get('ClmSettings_Enable_FieldLabel'),
          helpText: NX.I18n.get('ClmSettings_Enable_HelpText')
        },
        {
          xtype: 'nx-url',
          name: 'url',
          fieldLabel: NX.I18n.get('ClmSettings_URL_FieldLabel'),
          helpText: NX.I18n.get('ClmSettings_URL_HelpText'),
          emptyText: NX.I18n.get('ClmSettings_URL_EmptyText')
        },
        {
          xtype: 'combo',
          name: 'authenticationType',
          fieldLabel: NX.I18n.get('ClmSettings_AuthenticationType_FieldLabel'),
          editable: false,
          store: [
            ['USER', NX.I18n.get('ClmSettings_AuthenticationType_User')],
            ['PKI', NX.I18n.get('ClmSettings_AuthenticationType_Pki')]
          ],
          listeners: {
            'change': function(combo) {
              var userAuthFields = this.up('form').down('#userAuthFields');

              if(combo.getValue() === 'USER') {
                userAuthFields.show();
                userAuthFields.enable();
              }
              else {
                userAuthFields.hide();
                userAuthFields.disable();
              }
            }
          }
        },
        {
          xtype: 'fieldcontainer',
          itemId: 'userAuthFields',
          hidden: true,
          items: [
            {
              xtype:'textfield',
              name: 'username',
              fieldLabel: NX.I18n.get('ClmSettings_Username_FieldLabel'),
              helpText: NX.I18n.get('ClmSettings_Username_HelpText'),
              emptyText: NX.I18n.get('ClmSettings_Username_EmptyText'),
              allowBlank: false,
              inputAttrTpl: 'autocomplete="new-username"'
            },
            {
              xtype: 'nx-password',
              name: 'password',
              fieldLabel: NX.I18n.get('ClmSettings_Password_FieldLabel'),
              helpText: NX.I18n.get('ClmSettings_Password_HelpText'),
              emptyText: NX.I18n.get('ClmSettings_Password_EmptyText'),
              allowBlank: false,
              inputAttrTpl: 'autocomplete="new-password"'
            }
          ]
        },
        {
          xtype: 'numberfield',
          name: 'timeout',
          fieldLabel: NX.I18n.get('ClmSettings_ConnectionTimeout_FieldLabel'),
          helpText: NX.I18n.get('ClmSettings_ConnectionTimeout_HelpText'),
          emptyText: NX.I18n.get('ClmSettings_ConnectionTimeout_EmptyText'),
          allowBlank: true,
          allowDecimals: false,
          allowExponential: false,
          minValue: 1,
          maxValue: 3600
        },
        {
          xtype: 'textareafield',
          name: 'properties',
          fieldLabel: NX.I18n.get('ClmSettings_Properties_FieldLabel'),
          helpText: NX.I18n.get('ClmSettings_Properties_HelpText'),
          emptyText: NX.I18n.get('ClmSettings_Properties_EmptyText'),
          allowBlank: true
        }
      ]
    };

    me.callParent();

    me.down('nx-settingsform').getDockedItems('toolbar[dock="bottom"]')[0].add({
      xtype: 'button', text: NX.I18n.get('ClmSettings_Properties_Verify_Button'), formBind: true, action: 'verify'
    });
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * CLM controller.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.controller.Clm', {
  extend: 'NX.app.Controller',
  requires: [
    'NX.State',
    'NX.Messages',
    'NX.Permissions',
    'NX.Windows',
    'NX.I18n'
  ],

  stores: [
    'ClmApplication'
  ],
  views: [
    'clm.ClmSettings',
    'clm.ClmDashboard',
    'clm.ClmSettingsTestResults'
  ],
  refs: [
    {
      ref: 'clmSettingsForm',
      selector: 'nx-coreui-clm-settings'
    }
  ],

  /**
   * @override
   */
  init: function () {
    var me = this;

    // preload icon to avoid a grey icon when clm dashboard feature will be registered
    me.getApplication().getIconController().addIcons({
      'feature-clm-dashboard': {
        file: 'clm_dashboard.png',
        variants: ['x16', 'x32']
      }
    });

    me.getApplication().getFeaturesController().registerFeature({
      mode: 'admin',
      path: '/IQ/Server',
      text: NX.I18n.get('Clm_Text'),
      description: NX.I18n.get('Clm_Description'),
      view: { xtype: 'nx-coreui-clm-settings' },
      iconConfig: {
        file: 'clm_server.png',
        variants: ['x16', 'x32']
      },
      visible: function () {
        return NX.Permissions.check('nexus:settings:read');
      }
    }, me);

    me.onClmStateChanged(NX.State.getValue('clm'), undefined, true);

    me.listen({
      controller: {
        '#State': {
          clmchanged: me.onClmStateChanged
        }
      },
      component: {
        'nx-coreui-clm-settings button[action=verify]': {
          click: me.verifyConnection
        },
        'nx-coreui-clm-settings nx-settingsform': {
          submitted: me.onSubmitted
        },
        'nx-coreui-clm-dashboard': {
          activate: me.openDashboardWindow
        },
        'nx-coreui-clm-dashboard button[action=open]': {
          click: me.openDashboardWindow
        }
      }
    });
  },

  /**
   * Verify the connection to the IQ Server.
   * @private
   */
  verifyConnection: function (button) {
    var form = button.up('form'),
        values = form.getForm().getFieldValues();

    form.getEl().mask('Checking connection to ' + values.url);

    NX.direct.clm_CLM.verifyConnection(values, function (response) {
      form.getEl().unmask();
      if (Ext.isDefined(response) && response.success) {
        NX.Messages.add({ text: NX.I18n.format('Clm_Connection_Success', values.url), type: 'success' });
        Ext.widget('nx-coreui-clm-settings-testresults', {applications: response.data});
      }
    });
  },

  /**
   * @private
   */
  onSubmitted: function(form, action) {
    NX.State.setValue('clm', Ext.apply(Ext.clone(NX.State.getValue('clm', {})), {
      enabled: action.result.data.enabled,
      url: action.result.data.url
    }));
  },

  /**
   * Update the global UI state to register/unregister this Feature.
   * @param newState
   * @param oldState
   * @param avoidMenuRefresh
   * @private
   */
  onClmStateChanged: function (newState, oldState, avoidMenuRefresh) {
    var me = this,
        features = me.getApplication().getFeaturesController(),
        shouldRefreshMenu = false;

    if (oldState && oldState.enabled && oldState.url) {
      features.unregisterFeature({
        mode: 'admin',
        path: '/IQ/Dashboard'
      });
      shouldRefreshMenu = true;
    }
    if (newState && newState.enabled && newState.url) {
      features.registerFeature({
        mode: 'admin',
        path: '/IQ/Dashboard',
        text: NX.I18n.get('Clm_Dashboard_Title'),
        description: NX.I18n.get('Clm_Dashboard_Description'),
        view: { xtype: 'nx-coreui-clm-dashboard' },
        weight: 10,
        // use preloaded icon to avoid a grey icon
        iconName: 'feature-clm-dashboard',
        visible: function () {
          var clmState = NX.State.getValue('clm');
          return NX.Permissions.check('nexus:settings:read') && clmState && clmState.enabled && clmState.url;
        }
      }, me);
      shouldRefreshMenu = true;
    }
    if (!avoidMenuRefresh && shouldRefreshMenu) {
      me.getController('Menu').refreshMenu();
    }
  },

  /**
   * @private
   */
  openDashboardWindow: function() {
    var state = NX.State.getValue('clm');

    NX.Windows.open(state.url);
  },

  /**
   * Load the list of applications available from the configured server and show it in a modal window.
   * @private
   */
  loadApplications: function () {
    this.getClmClmApplicationsView().create().show();
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * LDAP Schema Template model.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.model.LdapSchemaTemplate', {
  extend: 'Ext.data.Model',
  fields: [
    {name: 'name', type: 'string', sortType: 'asUCText'},

    {name: 'userBaseDn', type: 'string'},
    {name: 'userSubtree', type: 'boolean'},
    {name: 'userObjectClass', type: 'string'},
    {name: 'userLdapFilter', type: 'string'},
    {name: 'userIdAttribute', type: 'string'},
    {name: 'userRealNameAttribute', type: 'string'},
    {name: 'userEmailAddressAttribute', type: 'string'},
    {name: 'userPasswordAttribute', type: 'string'},

    {name: 'ldapGroupsAsRoles', type: 'boolean'},
    {name: 'userMemberOfAttribute', type: 'string'},
    {name: 'groupType', type: 'string'},
    {name: 'groupBaseDn', type: 'string'},
    {name: 'groupSubtree', type: 'boolean'},
    {name: 'groupIdAttribute', type: 'string'},
    {name: 'groupMemberAttribute', type: 'string'},
    {name: 'groupMemberFormat', type: 'string'},
    {name: 'groupObjectClass', type: 'string'}
  ]
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Task Schedule Manual field set.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.task.TaskScheduleManual', {
  extend: 'NX.coreui.view.task.TaskScheduleFields',
  alias: 'widget.nx-coreui-task-schedule-manual',
  requires: [
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function() {
    Ext.apply(this, {
      items: {
        xtype: 'label',
        text: NX.I18n.get('Task_TaskScheduleManual_HelpText')
      }
    });

    this.callParent();
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Repository "Settings" form for a Maven Hosted repository.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.repository.recipe.RawHosted', {
  extend: 'NX.coreui.view.repository.RepositorySettingsForm',
  alias: 'widget.nx-coreui-repository-raw-hosted',
  requires: [
    'NX.coreui.view.repository.facet.StorageFacet',
    'NX.coreui.view.repository.facet.StorageFacetHosted',
    'NX.coreui.view.repository.facet.CleanupPolicyFacet'
  ],

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    me.items = [
      {xtype: 'nx-coreui-repository-storage-facet', strictContentTypeValidation: false},
      {xtype: 'nx-coreui-repository-storage-hosted-facet', writePolicy: 'ALLOW'},
      {xtype: 'nx-coreui-repository-cleanup-policy-facet'}
    ];

    me.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * LDAP Server User & Group login credentials window.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.ldap.LdapServerUserAndGroupLoginCredentials', {
  extend: 'Ext.window.Window',
  alias: 'widget.nx-coreui-ldapserver-userandgroup-login-credentials',
  requires: [
    'NX.Icons',
    'NX.I18n'
  ],

  /**
   * @protected
   */
  initComponent: function () {
    var me = this;

    if (!me.message) {
      me.message = NX.I18n.get('Ldap_LdapServerUserAndGroupLoginCredentials_Text');
    }

    Ext.apply(me, {
      ui: 'nx-inset',
      title: NX.I18n.get('Ldap_LdapServerUserAndGroupLoginCredentials_Title'),
      layout: 'fit',
      autoShow: true,
      modal: true,
      constrain: true,
      width: 360,
      defaultFocus: 'username',
      items: {
        xtype: 'form',
        defaultType: 'textfield',
        defaults: {
          labelAlign: 'left',
          labelWidth: 140,
          anchor: '100%'
        },
        items: [
          {
            xtype: 'panel',
            layout: 'hbox',
            style: {
              // FIXME: sort out common style here for dialogs
              marginBottom: '10px'
            },
            items: [
              { xtype: 'component', html: NX.Icons.img('authenticate', 'x32') },
              { xtype: 'component', html: NX.I18n.get('Ldap_LdapServerUserAndGroupLoginCredentials_Input_Text') }
            ]
          },
          {
            name: 'username',
            itemId: 'username',
            fieldLabel: NX.I18n.get('Ldap_LdapServerUserAndGroupLoginCredentials_Username_FieldLabel'),
            allowBlank: false,
            validateOnBlur: false // allow cancel to be clicked w/o validating this to be non-blank
          },
          {
            name: 'password',
            itemId: 'password',
            fieldLabel: NX.I18n.get('Ldap_LdapServerUserAndGroupLoginCredentials_Password_FieldLabel'),
            inputType: 'password',
            allowBlank: false,
            validateOnBlur: false // allow cancel to be clicked w/o validating this to be non-blank
          }
        ],

        buttonAlign: 'left',
        buttons: [
          { text: NX.I18n.get('Ldap_LdapServerUserAndGroupLoginCredentials_Submit_Button'), action: 'verifylogin', formBind: true, bindToEnter: true, ui: 'nx-primary' },
          { text: NX.I18n.get('Ldap_LdapServerUserAndGroupLoginCredentials_Cancel_Button'), handler: me.close, scope: me }
        ]
      }
    });

    me.callParent();
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Change LDAP Server ordering window.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.ldap.LdapServerChangeOrder', {
  extend: 'NX.view.ChangeOrderWindow',
  alias: 'widget.nx-coreui-ldapserver-changeorder',
  requires: [
    'NX.coreui.store.LdapServer',
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    me.title = NX.I18n.get('Ldap_LdapServerChangeOrder_Title');

    me.store = Ext.create('NX.coreui.store.LdapServer', {
      sortOnLoad: true,
      sorters: { property: 'order', direction: 'ASC' }
    });
    me.store.load();

    me.callParent();
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Add LDAP users and groups window.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.ldap.LdapServerUserAndGroupAdd', {
  extend: 'NX.view.AddPanel',
  alias: 'widget.nx-coreui-ldapserver-userandgroup-add',
  requires: [
    'NX.Conditions',
    'NX.I18n'
  ],

  dockedItems: null,

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    me.settingsForm = {
      xtype: 'nx-coreui-ldapserver-userandgroup-form',

      editableCondition: NX.Conditions.isPermitted('nexus:ldap:create'),
      editableMarker: NX.I18n.get('Ldap_LdapServerConnectionAdd_Create_Error'),

      buttons: [
        { text: NX.I18n.get('Add_Submit_Button'), action: 'add', formBind: true, ui: 'nx-primary' },
        { text: NX.I18n.get('Add_Cancel_Button'), action: 'back' }
      ]
    };

    me.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * LDAP Server feature panel.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.ldap.LdapServerFeature', {
  extend: 'NX.view.drilldown.Drilldown',
  alias: 'widget.nx-coreui-ldapserver-feature',
  requires: [
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function() {
    Ext.apply(this, {
      iconName: 'ldapserver-default',

      masters: [
        { xtype: 'nx-coreui-ldapserver-list' }
      ],

      tabs: [
        { xtype: 'nx-coreui-ldapserver-connection', title: NX.I18n.get('Ldap_LdapServerFeature_Connection_Title'), weight: 10 },
        { xtype: 'nx-coreui-ldapserver-userandgroup', title: NX.I18n.get('Ldap_LdapServerFeature_UserAndGroup_Title'), weight: 20 }
      ],

      nxActions: [
        { xtype: 'button', text: NX.I18n.get('Ldap_LdapServerFeature_Delete_Button'), glyph: 'xf1f8@FontAwesome' /* fa-trash */, action: 'delete', disabled: true }
      ]
    });

    this.callParent();
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * LDAP Server "Connection" field set.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.ldap.LdapServerConnectionFieldSet', {
  extend: 'Ext.panel.Panel',
  alias: 'widget.nx-coreui-ldapserver-connection-fieldset',
  requires: [
    'NX.I18n',
    'NX.ext.form.field.Hostname'
  ],

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    me.defaults = {
      xtype: 'textfield',
        allowBlank: false,
        bindGroup: 'connection'
    };

    me.items = [
      {
        xtype: 'hiddenfield',
        name: 'id'
      },
      {
        name: 'name',
        itemId: 'name',
        fieldLabel: NX.I18n.get('LdapServersConnectionFieldSet_Name_FieldLabel'),
        transformRawValue: Ext.htmlDecode
      },
      {
        xtype: 'label',
        text: NX.I18n.get('LdapServersConnectionFieldSet_Address_Text'),
        style: {
          fontWeight: 'bold',
          display: 'block',
          marginTop: '10px',
          marginBottom: '5px'
        }
      },
      {
        xtype: 'label',
        text: NX.I18n.get('LdapServersConnectionFieldSet_Address_HelpText'),
        style: {
          fontSize: '10px',
          display: 'block',
          marginBottom: '1px'
        }
      },
      {
        xtype: 'combo',
        name: 'protocol',
        itemId: 'protocol',
        cls: 'nx-float-left',
        blankText: 'Required',
        width: 85,
        emptyText: NX.I18n.get('LdapServersConnectionFieldSet_Protocol_EmptyText'),
        editable: false,
        store: [
          ['ldap', NX.I18n.get('LdapServersConnectionFieldSet_Protocol_PlainItem')],
          ['ldaps', NX.I18n.get('LdapServersConnectionFieldSet_Protocol_SecureItem')]
        ],
        queryMode: 'local',
        listeners: {
          change: function(){
            var protocol = this.up('form').down('#port');
            protocol.fireEvent('change', protocol, protocol.getValue(), protocol.getValue());
          }
        }
      },
      {
        xtype: 'label',
        cls: 'nx-float-left nx-interstitial-label',
        text: '://'
      },
      {
        xtype: 'nx-hostname',
        name: 'host',
        itemId: 'host',
        cls: 'nx-float-left',
        blankText: 'Required',
        width: 405,
        emptyText: NX.I18n.get('LdapServersConnectionFieldSet_Host_EmptyText'),
        listeners: {
          change: function(){
            var protocol = this.up('form').down('#port');
            protocol.fireEvent('change', protocol, protocol.getValue(), protocol.getValue());
          }
        }
      },
      {
        xtype: 'label',
        cls: 'nx-float-left nx-interstitial-label',
        text: ':'
      },
      {
        xtype: 'numberfield',
        name: 'port',
        itemId: 'port',
        cls: 'nx-float-left',
        blankText: 'Required',
        width: 75,
        emptyText: NX.I18n.get('LdapServersConnectionFieldSet_Port_EmptyText'),
        minValue: 1,
        maxValue: 65535,
        allowDecimals: false,
        allowExponential: false,
        useTrustStore: function (field) {
          var form = field.up('form');
          if (form.down('#protocol').getValue() === 'ldaps' && form.down('#host').getValue() && field.getValue()) {
            return {
              name: 'useTrustStore',
              value: form.getRecord() ? form.getRecord().getData().useTrustStore : false,
              host: form.down('#host'),
              port: form.down('#port')
            };
          }
          return undefined;
        }
      },
      {
        name: 'searchBase',
        fieldLabel: NX.I18n.get('LdapServersConnectionFieldSet_Base_FieldLabel'),
        helpText: NX.I18n.get('LdapServersConnectionFieldSet_Base_HelpText'),
        cls: 'nx-clear-both'
      },
      {
        xtype: 'combo',
        name: 'authScheme',
        fieldLabel: NX.I18n.get('LdapServersConnectionFieldSet_AuthMethod_FieldLabel'),
        emptyText: NX.I18n.get('LdapServersConnectionFieldSet_AuthMethod_EmptyText'),
        editable: false,
        store: [
          ['simple', NX.I18n.get('LdapServersConnectionFieldSet_AuthMethod_SimpleItem')],
          ['none', NX.I18n.get('LdapServersConnectionFieldSet_AuthMethod_AnonymousItem')],
          ['DIGEST-MD5', NX.I18n.get('LdapServersConnectionFieldSet_AuthMethod_DigestItem')],
          ['CRAM-MD5', NX.I18n.get('LdapServersConnectionFieldSet_AuthMethod_CramItem')]
        ],
        queryMode: 'local',
        listeners: {
          change: function (combo, newValue) {
            this.up('panel').showOrHide('authScheme', newValue);
          }
        }
      },
      {
        name: 'authRealm',
        itemId: 'authRealm',
        fieldLabel: NX.I18n.get('LdapServersConnectionFieldSet_SaslRealm_FieldLabel'),
        helpText: NX.I18n.get('LdapServersConnectionFieldSet_SaslRealm_HelpText'),
        allowBlank: true,
        authScheme: ['DIGEST-MD5', 'CRAM-MD5']
      },
      {
        name: 'authUsername',
        itemId: 'authUsername',
        fieldLabel: NX.I18n.get('LdapServersConnectionFieldSet_Username_FieldLabel'),
        helpText: NX.I18n.get('LdapServersConnectionFieldSet_Username_HelpText'),
        authScheme: ['simple', 'DIGEST-MD5', 'CRAM-MD5']
      },
      {
        xtype: 'nx-password',
        name: 'authPassword',
        itemId: 'authPassword',
        fieldLabel: NX.I18n.get('LdapServersConnectionFieldSet_Password_FieldLabel'),
        inputType: 'password',
        helpText: NX.I18n.get('LdapServersConnectionFieldSet_Password_HelpText'),
        authScheme: ['simple', 'DIGEST-MD5', 'CRAM-MD5']
      },
      {
        xtype: 'label',
        text: NX.I18n.get('LdapServersConnectionFieldSet_Rules_Text'),
        style: {
          fontWeight: 'bold',
          display: 'block',
          marginTop: '10px',
          marginBottom: '5px'
        }
      },
      {
        xtype: 'label',
        text: NX.I18n.get('LdapServersConnectionFieldSet_Rules_HelpText'),
        style: {
          fontSize: '10px',
          display: 'block',
          marginBottom: '1px'
        }
      },
      {
        xtype: 'label',
        cls: 'nx-float-left nx-interstitial-label',
        text: NX.I18n.get('LdapServersConnectionFieldSet_Rules_Text1')
      },
      {
        xtype: 'numberfield',
        name: 'connectionTimeout',
        cls: 'nx-float-left',
        width: 70,
        value: 30
      },
      {
        xtype: 'label',
        cls: 'nx-float-left nx-interstitial-label',
        text: NX.I18n.get('LdapServersConnectionFieldSet_Rules_Text2')
      },
      {
        xtype: 'numberfield',
        name: 'connectionRetryDelay',
        cls: 'nx-float-left',
        width: 70,
        value: 300
      },
      {
        xtype: 'label',
        cls: 'nx-float-left nx-interstitial-label',
        text: NX.I18n.get('LdapServersConnectionFieldSet_Rules_Text3')
      },
      {
        xtype: 'numberfield',
        name: 'maxIncidentsCount',
        cls: 'nx-float-left',
        width: 55,
        value: 3
      },
      {
        xtype: 'label',
        cls: 'nx-float-left nx-interstitial-label',
        text: NX.I18n.get('LdapServersConnectionFieldSet_Rules_Text4')
      }
    ];

    me.callParent();

    me.showOrHide('authScheme', undefined);
  },

  /**
   * @private
   * Show & enable or hide and disable components that have attributes that matches the specified value.
   * @param attribute name of attribute
   * @param value to be matched in order to show
   */
  showOrHide: function (attribute, value) {
    var me = this,
        form = me.up('form'),
        components = me.query('component[' + attribute + ']');

    Ext.iterate(components, function (component) {
      if (value && component[attribute].indexOf(value) > -1) {
        component.enable();
        component.show();
      }
      else {
        component.disable();
        component.hide();
      }
    });
    if (form && form.rendered) {
      form.isValid();
    }
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * LDAP Server "Connection" panel.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.ldap.LdapServerConnection', {
  extend: 'NX.view.SettingsPanel',
  alias: 'widget.nx-coreui-ldapserver-connection',

  settingsForm: { xtype: 'nx-coreui-ldapserver-connection-form' }

});

  /*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * LDAP Server "Connection" form.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.ldap.LdapServerConnectionForm', {
  extend: 'NX.view.SettingsForm',
  alias: 'widget.nx-coreui-ldapserver-connection-form',
  requires: [
    'NX.Conditions',
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function() {
    var me = this;

    me.items = { xtype: 'nx-coreui-ldapserver-connection-fieldset' };

    me.editableMarker = NX.I18n.get('Ldap_LdapServerConnectionForm_Update_Error');

    me.editableCondition = me.editableCondition || NX.Conditions.isPermitted('nexus:ldap:update');

    me.callParent();

    me.getDockedItems('toolbar[dock="bottom"]')[0].add(
        { xtype: 'button', text: NX.I18n.get('Ldap_LdapServerConnectionForm_VerifyConnection_Button'), action: 'verifyconnection' }
    );

    NX.Conditions.formIs(me, function(form) {
      return !form.isDisabled() && form.isValid();
    }).on({
      satisfied: function() {
        this.enable();
      },
      unsatisfied: function() {
        this.disable();
      },
      scope: me.down('button[action=verifyconnection]')
    });
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * LDAP Server "User & Group" field set.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.ldap.LdapServerUserAndGroupFieldSet', {
  extend: 'Ext.panel.Panel',
  alias: 'widget.nx-coreui-ldapserver-userandgroup-fieldset',
  requires: [
    'NX.I18n'
  ],

  defaults: {
    xtype: 'textfield',
    allowBlank: false
  },

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    me.items = [
      {
        xtype: 'combo',
        itemId: 'template',
        name: 'template',
        fieldLabel: NX.I18n.get('Ldap_LdapServerUserAndGroupFieldSet_Template_FieldLabel'),
        emptyText: NX.I18n.get('Ldap_LdapServerUserAndGroupFieldSet_Template_EmptyText'),
        editable: false,
        store: 'LdapSchemaTemplate',
        displayField: 'name',
        queryMode: 'local',
        listeners: {
          select: function (combo, selected) {
            var data = selected.getData();
            delete data.name;
            combo.up('form').getForm().setValues(data);
          }
        },
        allowBlank: true
      },

      //user
      {
        name: 'userBaseDn',
        fieldLabel: NX.I18n.get('Ldap_LdapServerUserAndGroupFieldSet_BaseDN_FieldLabel'),
        helpText: NX.I18n.get('Ldap_LdapServerUserAndGroupFieldSet_BaseDN_HelpText'),
        allowBlank: true
      },
      {
        xtype: 'checkbox',
        name: 'userSubtree',
        fieldLabel: NX.I18n.get('Ldap_LdapServerUserAndGroupFieldSet_UserSubtree_FieldLabel'),
        helpText: NX.I18n.get('Ldap_LdapServerUserAndGroupFieldSet_UserSubtree_HelpText')
      },
      {
        name: 'userObjectClass',
        fieldLabel: NX.I18n.get('Ldap_LdapServerUserAndGroupFieldSet_ObjectClass_FieldLabel'),
        helpText: NX.I18n.get('Ldap_LdapServerUserAndGroupFieldSet_ObjectClass_HelpText')
      },
      {
        name: 'userLdapFilter',
        fieldLabel: NX.I18n.get('Ldap_LdapServerUserAndGroupFieldSet_UserFilter_FieldLabel'),
        helpText: NX.I18n.get('Ldap_LdapServerUserAndGroupFieldSet_UserFilter_HelpText'),
        allowBlank: true
      },
      {
        name: 'userIdAttribute',
        fieldLabel: NX.I18n.get('Ldap_LdapServerUserAndGroupFieldSet_UserID_FieldLabel')
      },
      {
        name: 'userRealNameAttribute',
        fieldLabel: NX.I18n.get('Ldap_LdapServerUserAndGroupFieldSet_RealName_FieldLabel')
      },
      {
        name: 'userEmailAddressAttribute',
        fieldLabel: NX.I18n.get('Ldap_LdapServerUserAndGroupFieldSet_Email_FieldLabel')
      },
      {
        name: 'userPasswordAttribute',
        fieldLabel: NX.I18n.get('Ldap_LdapServerUserAndGroupFieldSet_Password_FieldLabel'),
        helpText: NX.I18n.get('Ldap_LdapServerUserAndGroupFieldSet_Password_HelpText'),
        allowBlank: true
      },
      // group
      {
        xtype: 'checkbox',
        name: 'ldapGroupsAsRoles',
        fieldLabel: NX.I18n.get('Ldap_LdapServerUserAndGroupFieldSet_GroupMap_FieldLabel'),
        value: true,
        listeners: {
          change: function (checkbox, newValue) {
            var panel = checkbox.up('panel');

            panel.showOrHide('ldapGroupsAsRoles', newValue);
            panel.showOrHide('groupType', newValue ? panel.down('#groupType').getValue() : undefined);
          }
        }
      },
      {
        xtype: 'combo',
        name: 'groupType',
        itemId: 'groupType',
        fieldLabel: NX.I18n.get('Ldap_LdapServerUserAndGroupFieldSet_GroupType_FieldLabel'),
        emptyText: NX.I18n.get('Ldap_LdapServerUserAndGroupFieldSet_GroupType_EmptyText'),
        editable: false,
        store: [
          ['dynamic', NX.I18n.get('Ldap_LdapServerUserAndGroupFieldSet_GroupType_DynamicItem')],
          ['static', NX.I18n.get('Ldap_LdapServerUserAndGroupFieldSet_GroupType_StaticItem')]
        ],
        queryMode: 'local',
        listeners: {
          change: function (combo, newValue) {
            combo.up('panel').showOrHide('groupType', newValue);
          }
        },
        ldapGroupsAsRoles: [true]
      },
      {
        name: 'groupBaseDn',
        fieldLabel: NX.I18n.get('Ldap_LdapServerUserAndGroupFieldSet_GroupBaseDN_FieldLabel'),
        helpText: NX.I18n.get('Ldap_LdapServerUserAndGroupFieldSet_GroupBaseDN_HelpText'),
        allowBlank: true,
        groupType: ['static']
      },
      {
        xtype: 'checkbox',
        name: 'groupSubtree',
        fieldLabel: NX.I18n.get('Ldap_LdapServerUserAndGroupFieldSet_GroupSubtree_FieldLabel'),
        helpText: NX.I18n.get('Ldap_LdapServerUserAndGroupFieldSet_GroupSubtree_HelpText'),
        groupType: ['static']
      },
      {
        name: 'groupObjectClass',
        fieldLabel: NX.I18n.get('Ldap_LdapServerUserAndGroupFieldSet_GroupObject_FieldLabel'),
        helpText: NX.I18n.get('Ldap_LdapServerUserAndGroupFieldSet_GroupObject_HelpText'),
        groupType: ['static']
      },
      {
        name: 'groupIdAttribute',
        fieldLabel: NX.I18n.get('Ldap_LdapServerUserAndGroupFieldSet_GroupID_FieldLabel'),
        groupType: ['static']
      },
      {
        name: 'groupMemberAttribute',
        fieldLabel: NX.I18n.get('Ldap_LdapServerUserAndGroupFieldSet_GroupMember_FieldLabel'),
        helpText: NX.I18n.get('Ldap_LdapServerUserAndGroupFieldSet_GroupMember_HelpText'),
        groupType: ['static']
      },
      {
        name: 'groupMemberFormat',
        fieldLabel: NX.I18n.get('Ldap_LdapServerUserAndGroupFieldSet_GroupMemberFormat_FieldLabel'),
        helpText: NX.I18n.get('Ldap_LdapServerUserAndGroupFieldSet_GroupMemberFormat_HelpText'),
        groupType: ['static']
      },
      {
        name: 'userMemberOfAttribute',
        fieldLabel: NX.I18n.get('Ldap_LdapServerUserAndGroupFieldSet_GroupMemberOf_FieldLabel'),
        helpText: NX.I18n.get('Ldap_LdapServerUserAndGroupFieldSet_GroupMemberOf_HelpText'),
        groupType: ['dynamic']
      }
    ];

    me.callParent();

    me.showOrHide('ldapGroupsAsRoles', true);
    me.showOrHide('groupType', undefined);
  },

  /**
   * @private
   * Show & enable or hide and disable components that have attributes that matches the specified value.
   * @param attribute name of attribute
   * @param value to be matched in order to show
   */
  showOrHide: function (attribute, value) {
    var me = this,
        form = me.up('form'),
        components = me.query('component[' + attribute + ']');

    Ext.iterate(components, function (component) {
      if (value && component[attribute].indexOf(value) > -1) {
        component.enable();
        component.show();
      }
      else {
        component.disable();
        component.hide();
      }
    });
    if (form && form.rendered) {
      form.isValid();
    }
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * LDAP Server grid.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.ldap.LdapServerList', {
  extend: 'NX.view.drilldown.Master',
  alias: 'widget.nx-coreui-ldapserver-list',
  requires: [
    'NX.I18n'
  ],

  stateful: true,
  stateId: 'nx-coreui-ldapserver-list',

  /**
   * @override
   */
  initComponent: function() {
    Ext.apply(this, {
      store: 'LdapServer',

      columns: [
        {
          xtype: 'nx-iconcolumn',
          width: 36,
          iconVariant: 'x16',
          iconName: function () {
            return 'ldapserver-default';
          }
        },
        { header: NX.I18n.get('Ldap_LdapServerList_Order_Header'), dataIndex: 'order', stateId: 'order', width: 80 },
        { header: NX.I18n.get('Ldap_LdapServerList_Name_Header'), dataIndex: 'name', stateId: 'name', flex: 1, renderer: Ext.htmlEncode },
        { header: NX.I18n.get('Ldap_LdapServerList_URL_Header'), dataIndex: 'url', stateId: 'url', flex: 1, renderer: Ext.htmlEncode }
      ],

      viewConfig: {
        emptyText: NX.I18n.get('Ldap_LdapServerList_EmptyText'),
        deferEmptyText: false
      },

      dockedItems: [{
        xtype: 'nx-actions',
        items: [
          {
            xtype: 'button',
            text: NX.I18n.get('Ldap_LdapServerList_New_Button'),
            glyph: 'xf055@FontAwesome' /* fa-plus-circle */,
            action: 'new',
            disabled: true
          },
          {
            xtype: 'button',
            text: NX.I18n.get('Ldap_LdapServerList_ChangeOrder_Button'),
            glyph: 'xf162@FontAwesome' /* fa-sort-numeric-asc */,
            action: 'changeorder',
            disabled: true
          },
          {
            xtype: 'button',
            text: NX.I18n.get('Ldap_LdapServerList_ClearCache_Button'),
            glyph: 'xf014@FontAwesome' /* fa-trash-o */,
            action: 'clearcache',
            disabled: true
          }
        ]
      }],

      plugins: [
        { ptype: 'gridfilterbox', emptyText: NX.I18n.get('Ldap_LdapServerList_Filter_EmptyText') }
      ]
    });

    this.callParent();
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * LDAP Schema Template store.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.store.LdapSchemaTemplate', {
  extend: 'Ext.data.Store',
  model: 'NX.coreui.model.LdapSchemaTemplate',

  proxy: {
    type: 'direct',
    paramsAsHash: false,

    api: {
      read: 'NX.direct.ldap_LdapServer.readTemplates'
    },

    reader: {
      type: 'json',
      rootProperty: 'data',
      successProperty: 'success'
    }
  },

  sorters: { property: 'name', direction: 'ASC' }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * LDAP Server User & Group test results window.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.ldap.LdapServerUserAndGroupMappingTestResults', {
  extend: 'NX.view.ModalDialog',
  alias: 'widget.nx-coreui-ldapserver-userandgroup-testresults',
  requires: [
    'Ext.data.JsonStore',
    'NX.I18n'
  ],

  /**
   * @cfg json array of users (as returned by checking the user mapping)
   */
  config: {
    mappedUsers: undefined
  },

  initComponent: function () {
    var me = this;

    me.title = NX.I18n.get('Ldap_LdapServerUserAndGroupMappingTestResults_Title');
    me.layout = 'fit';
    me.closeable = true;
    me.autoShow = true;
    me.modal = true;
    me.constrain = true;
    me.buttonAlign = 'left';
    me.buttons = [
      { text: NX.I18n.get('Button_Close'), handler: function () {
        this.up('window').close();
      }}
    ];

    me.items = {
      xtype: 'grid',
      columns: [
        { header: NX.I18n.get('Ldap_LdapServerUserAndGroupMappingTestResults_ID_Header'), dataIndex: 'username', flex: 1 },
        { header: NX.I18n.get('Ldap_LdapServerUserAndGroupMappingTestResults_Name_Header'), dataIndex: 'realName', flex: 1 },
        { header: NX.I18n.get('Ldap_LdapServerUserAndGroupMappingTestResults_Email_Header'), dataIndex: 'email', width: 250 },
        { header: NX.I18n.get('Ldap_LdapServerUserAndGroupMappingTestResults_Roles_Header'), dataIndex: 'membership', flex: 3 }
      ],
      store: Ext.create('Ext.data.JsonStore', {
        fields: ['username', 'realName', 'email', 'membership'],
        data: me.getMappedUsers()
      })
    };

    me.width = NX.view.ModalDialog.LARGE_MODAL;
    me.maxHeight = me.height = Ext.getBody().getViewSize().height - 100;

    me.callParent();
    me.center();
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * LDAP controller.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.controller.LdapServers', {
  extend: 'NX.controller.Drilldown',
  requires: [
    'NX.Conditions',
    'NX.Messages',
    'NX.Permissions',
    'NX.I18n'
  ],
  masters: [
    'nx-coreui-ldapserver-list'
  ],
  models: [
    'LdapServer'
  ],
  stores: [
    'LdapServer',
    'LdapSchemaTemplate'
  ],
  views: [
    'ldap.LdapServerChangeOrder',
    'ldap.LdapServerFeature',
    'ldap.LdapServerList',
    'ldap.LdapServerConnection',
    'ldap.LdapServerConnectionFieldSet',
    'ldap.LdapServerConnectionForm',
    'ldap.LdapServerUserAndGroup',
    'ldap.LdapServerUserAndGroupFieldSet',
    'ldap.LdapServerUserAndGroupForm',
    'ldap.LdapServerUserAndGroupLoginCredentials',
    'ldap.LdapServerUserAndGroupMappingTestResults',
    'ldap.LdapServerConnectionAdd',
    'ldap.LdapServerUserAndGroupAdd'
  ],
  refs: [
    { ref: 'main', selector: 'nx-main' },
    { ref: 'feature', selector: 'nx-coreui-ldapserver-feature' },
    { ref: 'content', selector: 'nx-feature-content' },
    { ref: 'list', selector: 'nx-coreui-ldapserver-list' },
    { ref: 'connection', selector: 'nx-coreui-ldapserver-feature nx-coreui-ldapserver-connection' },
    { ref: 'userAndGroup', selector: 'nx-coreui-ldapserver-feature nx-coreui-ldapserver-userandgroup' }
  ],
  icons: {
    'ldapserver-default': {
      file: 'book_addresses.png',
      variants: ['x16', 'x32']
    },
    'ldap-security-source': {
      file: 'book_addresses.png',
      variants: ['x16']
    }
  },

  permission: 'nexus:ldap',

  /**
   * @override
   */
  init: function() {
    var me = this;

    me.features = {
      mode: 'admin',
      path: '/Security/LDAP',
      text: NX.I18n.get('LdapServers_Text'),
      description: NX.I18n.get('LdapServers_Description'),
      view: {xtype: 'nx-coreui-ldapserver-feature'},
      iconConfig: {
        file: 'book_addresses.png',
        variants: ['x16', 'x32']
      },
      visible: function() {
        return NX.Permissions.check('nexus:ldap:read');
      }
    };

    me.callParent();

    me.listen({
      controller: {
        '#Refresh': {
          refresh: me.loadStores
        }
      },
      store: {
        '#LdapServer': {
          load: me.reselect
        }
      },
      component: {
        'nx-coreui-ldapserver-list': {
          beforerender: me.loadStores
        },
        'nx-coreui-ldapserver-list button[action=new]': {
          click: me.showConnectionPanel
        },
        'nx-coreui-ldapserver-connection-add button[action=next]': {
          click: me.showUserAndGroupPanel
        },
        'nx-coreui-ldapserver-userandgroup-form button[action=add]': {
          click: me.createServer
        },
        'nx-coreui-ldapserver-connection-form button[action=save]': {
          click: me.updateServer
        },
        'nx-coreui-ldapserver-userandgroup-form button[action=save]': {
          click: me.updateServer
        },
        'nx-coreui-ldapserver-list button[action=changeorder]': {
          click: me.showChangeOrder,
          afterrender: me.bindChangeOrderButton
        },
        'nx-coreui-ldapserver-list button[action=clearcache]': {
          click: me.clearCache,
          afterrender: me.bindClearCacheButton
        },
        'nx-coreui-ldapserver-changeorder button[action=save]': {
          click: me.changeOrder
        },
        'nx-coreui-ldapserver-connection-add button[action=verifyconnection]': {
          click: me.verifyConnection
        },
        'nx-coreui-ldapserver-connection button[action=verifyconnection]': {
          click: me.verifyConnection
        },
        'nx-coreui-ldapserver-userandgroup-add button[action=verifyusermapping]': {
          click: me.verifyUserMapping
        },
        'nx-coreui-ldapserver-userandgroup button[action=verifyusermapping]': {
          click: me.verifyUserMapping
        },
        'nx-coreui-ldapserver-userandgroup-add button[action=verifylogin]': {
          click: me.showLoginCredentialsWindow
        },
        'nx-coreui-ldapserver-userandgroup button[action=verifylogin]': {
          click: me.showLoginCredentialsWindow
        },
        'nx-coreui-ldapserver-userandgroup-login-credentials button[action=verifylogin]': {
          click: me.verifyLogin
        }
      }
    });
  },

  /**
   * @override
   */
  getDescription: function(model) {
    return model.get('name');
  },

  /**
   * @override
   */
  onSelection: function(list, model) {
    var me = this;

    if (Ext.isDefined(model)) {
      Ext.suspendLayouts();

      me.connectionInfo = model.getData();
      me.getConnection().loadRecord(model);
      me.getUserAndGroup().loadRecord(model);
      me.getUserAndGroup().down('#template').setValue(null);

      Ext.resumeLayouts(true);
    }
  },

  /**
   * @private
   */
  showConnectionPanel: function() {
    var me = this;

    me.connectionInfo = {};

    // Show the first panel in the create wizard, and set the breadcrumb
    me.setItemName(1, NX.I18n.get('LdapServers_CreateConnection_Title'));
    me.loadCreateWizard(1, Ext.widget({
      xtype: 'panel',
      layout: {
        type: 'vbox',
        align: 'stretch',
        pack: 'start'
      },
      items: [
        {
          xtype: 'nx-coreui-ldapserver-connection-add',
          flex: 1
        }
      ]
    }));
  },

  /**
   * @private
   */
  showUserAndGroupPanel: function() {
    var me = this;

    me.connectionInfo = me.getFeature().down('nx-coreui-ldapserver-connection-add').down('nx-coreui-ldapserver-connection-form').getForm().getValues();

    // Show the first panel in the create wizard, and set the breadcrumb
    me.setItemName(2, NX.I18n.get('LdapServers_CreateUsersAndGroups_Title'));
    me.loadCreateWizard(2, Ext.widget({
      xtype: 'panel',
      layout: {
        type: 'vbox',
        align: 'stretch',
        pack: 'start'
      },
      items: [
        {
          xtype: 'nx-coreui-ldapserver-userandgroup-add',
          flex: 1
        }
      ]
    }));
  },

  /**
   * @private
   */
  showChangeOrder: function() {
    Ext.widget('nx-coreui-ldapserver-changeorder');
  },

  /**
   * @private
   * Update an existing LDAP entry
   */
  updateServer: function() {
    var me = this,
      feature = me.getFeature(),
      connectionForm = feature.down('nx-coreui-ldapserver-connection').down('nx-coreui-ldapserver-connection-form'),
      userGroupForm = feature.down('nx-coreui-ldapserver-userandgroup').down('nx-coreui-ldapserver-userandgroup-form'),
      values = {};

    // Get fields from all relevant forms
    Ext.apply(values, connectionForm.getForm().getFieldValues());
    Ext.apply(values, userGroupForm.getForm().getFieldValues());

    var modelData = connectionForm.getForm().getRecord().getData(false);

    Object.keys(values).forEach(function(field) {
      delete modelData[field];
    });
    Ext.apply(modelData, values);

    // Apply masks
    me.getContent().getEl().mask(NX.I18n.get('LdapServers_Update_Mask'));
    NX.direct.ldap_LdapServer.update(modelData, function(response) {
      me.getContent().getEl().unmask();
      if (Ext.isObject(response)) {
        if (response.success) {
          NX.Messages.add({
            text: NX.I18n.format('LdapServers_Update_Success',
              me.getDescription(me.getLdapServerModel().create(response.data))),
            type: 'success'
          });
          me.getStore('LdapServer').load();
        }
      }
    });
  },

  /**
   * @private
   * Create a new LDAP entry
   */
  createServer: function() {
    var me = this,
      feature = me.getFeature(),
      userGroupForm = feature.down('nx-coreui-ldapserver-userandgroup-add').down('nx-coreui-ldapserver-userandgroup-form'),
      values = me.connectionInfo;

    // Get fields from all relevant forms
    Ext.apply(values, userGroupForm.getForm().getFieldValues());

    me.getContent().getEl().mask(NX.I18n.get('LdapServers_Create_Mask'));
    NX.direct.ldap_LdapServer.create(values, function(response) {
      me.getContent().getEl().unmask();
      if (Ext.isObject(response)) {
        if (response.success) {
          NX.Messages.add({
            text: NX.I18n.format('LdapServers_Create_Success',
              me.getDescription(me.getLdapServerModel().create(response.data))),
            type: 'success'
          });
          me.getStore('LdapServer').load();
        }
      }
    });
  },

  /**
   * @private
   * Enable 'Change Order' when user has 'update' permission.
   */
  bindChangeOrderButton: function(button) {
    button.mon(
        NX.Conditions.isPermitted(this.permission + ':update'),
        {
          satisfied: function() {
            button.enable();
          },
          unsatisfied: function() {
            button.disable();
          }
        }
    );
  },

  /**
   * @private
   * Enable 'ClearCache' when user has 'delete' permission and there is at least one LDAP server configured.
   */
  bindClearCacheButton: function(button) {
    button.mon(
        NX.Conditions.and(
            NX.Conditions.isPermitted(this.permission + ':delete'),
            NX.Conditions.storeHasRecords('LdapServer')
        ),
        {
          satisfied: function () {
            button.enable();
          },
          unsatisfied: function () {
            button.disable();
          }
        }
    );
  },

  /**
   * @private
   * @override
   * Deletes a LDAP server.
   * @param {NX.coreui.model.LdapServer} model to be deleted
   */
  deleteModel: function(model) {
    var me = this,
        description = me.getDescription(model);

    NX.direct.ldap_LdapServer.remove(model.getId(), function(response) {
      me.getStore('LdapServer').load();
      if (Ext.isObject(response) && response.success) {
        NX.Messages.add({ text: NX.I18n.format('LdapServers_Delete_Success', description), type: 'success' });
      }
    });
  },

  /**
   * @private
   * Change LDAP servers order.
   */
  changeOrder: function(button) {
    var me = this,
        win = button.up('window'),
        order = button.up('form').down('nx-itemorderer').getValue();

    NX.direct.ldap_LdapServer.changeOrder(order, function(response) {
      if (Ext.isObject(response) && response.success) {
        win.close();
        NX.Messages.add({ text: NX.I18n.get('LdapServers_ChangeOrder_Success'), type: 'success' });
        me.getStore('LdapServer').load();
      }
    });
  },

  /**
   * @private
   * Clear LDAP cache.
   */
  clearCache: function(button) {
    NX.direct.ldap_LdapServer.clearCache(function(response) {
      if (Ext.isObject(response) && response.success) {
        NX.Messages.add({ text: NX.I18n.get('LdapServers_ClearCache_Success'), type: 'success' });
      }
    });
  },

  /**
   * @private
   * Verify LDAP server connection.
   */
  verifyConnection: function(button) {
    var form = button.up('form'),
        values = form.getForm().getFieldValues(),
        url = values.protocol + '://' + values.host + ':' + values.port;

    form.getEl().mask(NX.I18n.format('LdapServers_VerifyConnection_Mask', url));

    NX.direct.ldap_LdapServer.verifyConnection(values, function(response) {
      form.getEl().unmask();
      if (Ext.isObject(response) && response.success) {
        NX.Messages.add({ text: NX.I18n.format('LdapServers_VerifyConnection_Success', url), type: 'success' });
      }
    });
  },

  /**
   * @private
   * Verify LDAP user mapping.
   */
  verifyUserMapping: function() {
    var me = this,
        values = me.getValues(),
        url = values.protocol + '://' + values.host + ':' + values.port;

    me.getMain().getEl().mask(NX.I18n.format('LdapServers_VerifyMapping_Mask', url));

    NX.direct.ldap_LdapServer.verifyUserMapping(values, function(response) {
      me.getMain().getEl().unmask();
      if (Ext.isObject(response) && response.success) {
        NX.Messages.add({text: NX.I18n.format('LdapServers_VerifyMapping_Success', url), type: 'success'});
        Ext.widget('nx-coreui-ldapserver-userandgroup-testresults', {mappedUsers: response.data});
      }
    });
  },

  /**
   * @private
   */
  showLoginCredentialsWindow: function(button) {
    Ext.widget('nx-coreui-ldapserver-userandgroup-login-credentials');
  },

  /**
   * @private
   * Verify LDAP login.
   */
  verifyLogin: function(button) {
    var win = button.up('window'),
        form = button.up('form'),
        loginValues = form.getForm().getFieldValues(),
        userName = NX.util.Base64.encode(loginValues.username),
        userPass = NX.util.Base64.encode(loginValues.password),
        values = this.getValues(),
        url = values.protocol + '://' + values.host + ':' + values.port;

    form.getEl().mask(NX.I18n.format('LdapServers_VerifyLogin_Mask', url));

    NX.direct.ldap_LdapServer.verifyLogin(values, userName, userPass, function(response) {
      form.getEl().unmask();
      if (Ext.isObject(response) && response.success) {
        win.close();
        NX.Messages.add({ text: NX.I18n.format('LdapServers_VerifyLogin_Success', url), type: 'success' });
      }
    });
  },

  /**
   * @private
   * Get form values from connection adn user/group form.
   */
  getValues: function() {
    var feature = this.getFeature(),
        values = this.connectionInfo,
        url, connectionForm, userGroupForm;

    if (feature.down('nx-coreui-ldapserver-connection-add')) {
      connectionForm = feature.down('nx-coreui-ldapserver-connection-add').down('nx-coreui-ldapserver-connection-form');
    }
    else {
      connectionForm = feature.down('nx-coreui-ldapserver-connection').down('nx-coreui-ldapserver-connection-form');
    }
    if (feature.down('nx-coreui-ldapserver-userandgroup-add')) {
      userGroupForm = feature.down('nx-coreui-ldapserver-userandgroup-add').down('nx-coreui-ldapserver-userandgroup-form');
    }
    else {
      userGroupForm = feature.down('nx-coreui-ldapserver-userandgroup').down('nx-coreui-ldapserver-userandgroup-form');
    }

    // Get fields from all relevant forms
    Ext.apply(values, connectionForm.getForm().getFieldValues());
    Ext.apply(values, userGroupForm.getForm().getFieldValues());

    return values;
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * License User store.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.store.LicenseUser', {
  extend: 'Ext.data.Store',
  model: 'NX.coreui.model.LicenseUser',

  proxy: {
    type: 'direct',
    paramsAsHash: false,

    api: {
      read: 'NX.direct.licensing_Licensing.readLicenseUsers'
    },

    reader: {
      type: 'json',
      rootProperty: 'data',
      successProperty: 'success'
    }
  },

  sorters: { property: 'timestamp', direction: 'DESC' }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Asset info panel.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.component.AssetInfo', {
  extend: 'NX.view.info.Panel',
  alias: 'widget.nx-coreui-component-assetinfo',
  requires: [
    'NX.I18n',
    'NX.coreui.util.RepositoryUrls'
  ],
  
  mixins: {
    componentUtils: 'NX.coreui.mixin.ComponentUtils'
  },

  /**
   * model to display
   */
  assetModel: null,

  /**
   * @public
   * @param {Object} assetModel the asset to display
   */
  setAssetModel: function (assetModel) {
    var me = this,
        info = {};
    me.assetModel = assetModel;

    // display common data
    var contentType = assetModel.get('contentType');
    var size = assetModel.get('size');
    info[NX.I18n.get('Assets_Info_Path')] = NX.coreui.util.RepositoryUrls.asRepositoryLink(
        assetModel, assetModel.get('format'));
    info[NX.I18n.get('Assets_Info_ContentType')] = Ext.htmlEncode(contentType);
    info[NX.I18n.get('Assets_Info_FileSize')] = Ext.util.Format.fileSize(size);
    info[NX.I18n.get('Assets_Info_Blob_Created')] = Ext.htmlEncode(assetModel.get('blobCreated'));
    info[NX.I18n.get('Assets_Info_Blob_Updated')] = Ext.htmlEncode(assetModel.get('blobUpdated'));

    if (assetModel.get('downloadCount')) {
      info[NX.I18n.get('Assets_Info_Downloaded_Count')] = Ext.htmlEncode(assetModel.get('downloadCount')) + ' ' +
          NX.I18n.get('Assets_Info_Downloaded_Unit');
    }

    info[NX.I18n.get('Assets_Info_Last_Downloaded')] = Ext.htmlEncode(
        me.mixins.componentUtils.getLastDownloadDateForDisplay(assetModel));
    info[NX.I18n.get('Assets_Info_Locally_Cached')] = Ext.htmlEncode(contentType !== 'unknown' && size > 0);
    info[NX.I18n.get('Assets_Info_BlobRef')] = Ext.htmlEncode(assetModel.get('blobRef'));
    info[NX.I18n.get('Assets_Info_ContainingRepositoryName')] = Ext.htmlEncode(assetModel.get('containingRepositoryName'));

    info[NX.I18n.get('Assets_Info_UploadedBy')] = Ext.htmlEncode(assetModel.get('createdBy'));
    info[NX.I18n.get('Assets_Info_UploadedIp')] = Ext.htmlEncode(assetModel.get('createdByIp'));

    me.showInfo(info);
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Add Ssl Certificate from Server window.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.ssl.SslCertificateAddFromServer', {
  extend: 'NX.view.AddPanel',
  alias: 'widget.nx-coreui-sslcertificate-add-from-server',
  requires: [
    'NX.Icons',
    'NX.I18n'
  ],

  defaultFocus: 'server',

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    me.settingsForm = {
      xtype: 'nx-settingsform',
      settingsFormSubmitOnEnter: true,

      items: [
        {
          xtype: 'textfield',
          fieldLabel: NX.I18n.get('Ssl_SslCertificateAddFromServer_Load_FieldLabel'),
          name: 'server',
          itemId: 'server'
        }
      ],

      buttons: [
        { text: NX.I18n.get('Ssl_SslCertificateList_Load_Button'), action: 'load', formBind: true, bindToEnter: true, ui: 'nx-primary' },
        { text: NX.I18n.get('Ssl_SslCertificateAddFromServer_Cancel_Button'), action: 'back' }
      ]
    };

    me.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Selector feature panel.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.selector.SelectorFeature', {
  extend: 'NX.view.drilldown.Drilldown',
  alias: 'widget.nx-coreui-selector-feature',
  requires: [
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function() {
    Ext.apply(this, {
      iconName: 'selector-default',

      masters: [
        {xtype: 'nx-coreui-selector-list'}
      ],

      tabs: [
        {
          xtype: 'nx-coreui-selector-settings',
          title: NX.I18n.get('Selector_SelectorFeature_Settings_Title'),
          weight: 10
        }
      ],

      nxActions: [
        {
          xtype: 'button',
          text: NX.I18n.get('Selector_SelectorFeature_Delete_Button'),
          glyph: 'xf1f8@FontAwesome' /* fa-trash */,
          action: 'delete',
          disabled: true
        }
      ]
    });

    this.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Repository "Settings" form for a Maven Proxy repository
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.repository.recipe.Maven2Proxy', {
  extend: 'NX.coreui.view.repository.RepositorySettingsForm',
  alias: 'widget.nx-coreui-repository-maven2-proxy',
  requires: [
    'NX.coreui.view.repository.facet.Maven2Facet',
    'NX.coreui.view.repository.facet.ProxyFacet',
    'NX.coreui.view.repository.facet.StorageFacet',
    'NX.coreui.view.repository.facet.HttpClientFacet',
    'NX.coreui.view.repository.facet.NegativeCacheFacet',
    'NX.coreui.view.repository.facet.CleanupPolicyFacet'
  ],

  /**
   * @override
   */
  initComponent: function() {
    var me = this;

    me.items = [
      { xtype: 'nx-coreui-repository-maven2-facet'},
      { xtype: 'nx-coreui-repository-proxy-facet'},
      { xtype: 'nx-coreui-repository-storage-facet'},
      { xtype: 'nx-coreui-repository-negativecache-facet'},
      { xtype: 'nx-coreui-repository-cleanup-policy-facet'},
      { xtype: 'nx-coreui-repository-httpclient-facet'}
    ];

    me.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Role "Settings" panel.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.role.RoleSettings', {
  extend: 'NX.view.SettingsPanel',
  alias: 'widget.nx-coreui-role-settings',

  settingsForm: { xtype: 'nx-coreui-role-settings-form' }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Audit model.
 *
 * @since 3.1
 */
Ext.define('NX.coreui.audit.AuditModel', {
  extend: 'Ext.data.Model',

  identifier: 'sequential',
  fields: [
    {name: 'domain', type: 'string', sortType: 'asUCText'},
    {name: 'type', type: 'string', sortType: 'asUCText'},
    {name: 'context', type: 'string', sortType: 'asUCText', convert: Ext.htmlEncode},
    {name: 'timestamp', type: 'date'},
    {name: 'nodeId', type: 'string', sortType: 'asUCText'},
    {name: 'initiator', type: 'string', sortType: 'asUCText'},
    {name: 'attributes', type: 'auto' /*object*/}
  ]
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Dialog to display a NuGet API Key details.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.nuget.NuGetApiKeyDetails', {
  extend: 'NX.view.ModalDialog',
  alias: 'widget.nx-coreui-nuget-apikeydetails',
  requires: [
    'NX.Icons',
    'NX.Messages',
    'NX.I18n',
    'NX.util.Url'
  ],
  ui: 'nx-inset',

  title: 'NuGet API Key',

  /**
   * @cfg {String} NuGet API Key
   */
  apiKey: undefined,

  /**
   * @override
   */
  initComponent: function() {
    var me = this;

    me.setWidth(NX.view.ModalDialog.LARGE_MODAL);

    me.items = {
      xtype: 'form',
      items: [
        {
          xtype: 'panel',
          layout: 'hbox',
          items: [
            { xtype: 'component', html: NX.Icons.img('nuget-default', 'x32') },
            { xtype: 'label', margin: '0 0 0 5',
              html: NX.I18n.get('Nuget_NuGetApiKeyDetails_Html')
            }
          ]
        },

        {
          xtype: 'panel',
          layout: 'vbox',
          margin: '0 0 10 0',
          items: [
            {
              xtype: 'label',
              margin: '5 0 0 0',
              text: NX.I18n.get('Nuget_NuGetApiKeyDetails_ApiKey_Text')
            },
            {
              xtype: 'textfield',
              value: me.apiKey,
              readOnly: true,
              selectOnFocus: true,
              fieldStyle: {
                padding: '2px',
                'font-family': 'monospace'
              }
            },
            {
              xtype: 'label',
              margin: '5 0 0 0',
              text: NX.I18n.get('Nuget_NuGetApiKeyDetails_Register_Text')
            },
            {
              xtype: 'textfield',
              value: NX.I18n.format('Nuget_NuGetApiKeyDetails_Register_Value', me.apiKey,
                  NX.util.Url.urlOf('repository/{repository name}/')),
              readOnly: true,
              selectOnFocus: true,
              fieldStyle: {
                padding: '2px',
                'font-family': 'monospace'
              }
            }
          ]
        },
        {
          xtype: 'label',
          style: 'font-style: italic;',
          html: NX.I18n.get('Nuget_NuGetApiKeyDetails_AutoClose_Html')
        }
      ],
      buttonAlign: 'left',
      buttons: [
        { text: NX.I18n.get('Button_Close'), handler: function() {
          this.up('window').close();
        }}
      ]
    };

    me.callParent();

    // Automatically close the window
    Ext.defer(function() {
      if (me.isVisible()) { // ignore if already closed
        NX.Messages.add({ text: NX.I18n.get('Nuget_NuGetApiKeyDetails_AutoClose_Message') });
        me.close();
      }
    }, 1 * 60 * 1000); // 1 minute
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * NuGet Api Key.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.nuget.NuGetApiKey', {
  extend: 'NX.view.SettingsPanel',
  alias: 'widget.nx-coreui-nuget-apikey',
  requires: [
    'NX.I18n'
  ],

  config: {
    active: false
  },

  /**
   * @override
   */
  initComponent: function() {
    var me = this;

    me.settingsForm = [
      {
        xtype: 'nx-settingsform',

        items: [
          {
            xtype: 'label',
            margin: '5 0 5 0',
            text: NX.I18n.get('Nuget_NuGetApiKey_Instructions_Text')
          }
        ],

        buttonAlign: 'left',
        buttons: [
          { text: NX.I18n.get('Nuget_NuGetApiKey_Access_Button'), action: 'access', ui: 'nx-primary', glyph: 'xf023@FontAwesome' /* fa-lock */, disabled: true },
          { text: NX.I18n.get('Nuget_NuGetApiKey_Reset_Button'), action: 'reset', glyph: 'xf023@FontAwesome' /* fa-lock */, disabled: true }
        ]
      }
    ];

    me.callParent();
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * NuGet repository settings controller.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.controller.NuGetApiKey', {
  extend: 'NX.app.Controller',
  requires: [
    'NX.Conditions',
    'NX.Permissions',
    'NX.Security'
  ],

  views: [
    'nuget.NuGetApiKeyDetails',
    'nuget.NuGetApiKey'
  ],

  /**
   * @override
   */
  init: function() {
    var me = this;

    me.getApplication().getIconController().addIcons({
      'nuget-default': {
        file: 'key.png',
        variants: ['x16', 'x32']
      }
    });

    me.getApplication().getFeaturesController().registerFeature([
      {
        mode: 'user',
        path: '/NuGet API Token',
        text: NX.I18n.get('NuGetApiKey_Text'),
        description: NX.I18n.get('NuGetApiKey_Description'),
        view: { xtype: 'nx-coreui-nuget-apikey' },
        iconConfig: {
          file: 'key.png',
          variants: ['x16', 'x32']
        },
        visible: function() {
          return NX.Security.hasUser();
        }
      }
    ], me);

    me.listen({
      component: {
        'nx-coreui-nuget-apikey button[action=access]': {
          click: me.accessApiKey,
          afterrender: me.bindAccessApiKeyButton
        },
        'nx-coreui-nuget-apikey button[action=reset]': {
          click: me.resetApiKey,
          afterrender: me.bindResetApiKeyButton
        }
      }
    });
  },

  /**
   * @private
   * Authenticate & show API Key.
   */
  accessApiKey: function() {
    var me = this;

    NX.Security.doWithAuthenticationToken(
        NX.I18n.get('Nuget_NuGetApiKey_Access_HelpText'),
        {
          success: function(authToken) {
            NX.direct.nuget_NuGetApiKey.readKey(authToken, function(response) {
              if (Ext.isDefined(response) && response.success) {
                me.showApiKey(response.data);
              }
            });
          }
        }
    );
  },

  /**
   * @private
   * Authenticate & reset API Key.
   */
  resetApiKey: function() {
    var me = this;

    NX.Security.doWithAuthenticationToken(
        NX.I18n.get('Nuget_NuGetApiKey_Reset_HelpText'),
        {
          success: function(authToken) {
            NX.direct.nuget_NuGetApiKey.resetKey(authToken, function(response) {
              if (Ext.isDefined(response) && response.success) {
                me.showApiKey(response.data);
              }
            });
          }
        }
    );
  },

  /**
   * @private
   * Show API Key details window.
   * @param {String} apiKey to show
   */
  showApiKey: function(apiKey) {
    Ext.widget('nx-coreui-nuget-apikeydetails', { apiKey: apiKey });
  },

  /**
   * @private
   * Enable 'Access API Key' when user has 'nexus:apikey:read' permission.
   * @param {Ext.Button} button access API Key button
   */
  bindAccessApiKeyButton: function(button) {
    button.mon(
        NX.Conditions.isPermitted('nexus:apikey:read'),
        {
          satisfied: function () {
            button.enable();
          },
          unsatisfied: function () {
            button.disable();
          }
        }
    );
  },

  /**
   * @private
   * Enable 'Reset API Key' when user has 'nexus:apikey:delete' permission.
   * @param {Ext.Button} button reset API Key button
   */
  bindResetApiKeyButton: function(button) {
    button.mon(
        NX.Conditions.isPermitted('nexus:apikey:delete'),
        {
          satisfied: function () {
            button.enable();
          },
          unsatisfied: function () {
            button.disable();
          }
        }
    );
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Health Check EULA window.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.healthcheck.HealthCheckEula', {
  extend: 'Ext.window.Window',
  alias: 'widget.nx-coreui-healthcheck-eula',
  requires: [
    'NX.util.Url'
  ],

  title: 'Nexus IQ Server Terms of Use',

  layout: 'fit',
  autoShow: true,
  modal: true,
  constrain: true,
  width: 640,
  height: 500,

  acceptFn: undefined,

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    me.items = {
      xtype: 'box',
      autoEl: {
        tag: 'iframe',
        src: NX.util.Url.urlOf('/static/healthcheck-tos.html')
      }
    };

    me.dockedItems = [
      {
        xtype: 'toolbar',
        dock: 'bottom',
        ui: 'footer',
        items: [
          { xtype: 'button', text: 'I Agree', action: 'agree', formBind: true, ui: 'nx-primary', handler: function () {
            var win = this.up('window');

            win.close();
            if (win.acceptFn) {
              win.acceptFn.call();
            }
          }},
          { xtype: 'button', text: 'I Do Not Agree', handler: function () {
            this.up('window').close();
          }},
          '->',
          { xtype: 'component', html: '<a href="' + NX.util.Url.urlOf('/static/healthcheck-tos.html') +
              '" target="_new">Download a copy of the license.</a>'
          }
        ]
      }
    ];

    me.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Versions / search result version model.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.model.SearchResultVersion', {
  extend: 'Ext.data.Model',
  idProperty: 'version',
  fields: [
    'groupingKey',
    'group',
    'name',
    'version',
    'versionOrder',
    'repositoryId',
    'repositoryName',
    'path',
    'type'
  ]
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Role model.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.model.Role', {
  extend: 'Ext.data.Model',
  fields: [
    {name: 'id', type: 'string', sortType: 'asUCText'},
    {name: 'version', type: 'string', sortType: 'asUCText'},
    {name: 'source', type: 'string', sortType: 'asUCText'},
    {name: 'name', type: 'string', sortType: 'asUCText', convert: Ext.htmlEncode},
    {name: 'description', type: 'string', sortType: 'asUCText', convert: Ext.htmlEncode},
    {name: 'readOnly', type: 'boolean', defaultValue: false},
    {name: 'privileges', type: 'auto'},
    {name: 'roles', type: 'auto'}
  ],
  constructor: function(data, id, raw, convertedData) {
    this.callParent([data, Ext.htmlEncode(id), raw, convertedData]);
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Assets grid.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.component.AssetList', {
  extend: 'NX.view.drilldown.Master',
  alias: 'widget.nx-coreui-component-asset-list',
  requires: [
    'NX.I18n'
  ],
  mixins: {
    componentUtils: 'NX.coreui.mixin.ComponentUtils'
  },
  /**
   * Currently shown component model.
   */
  componentModel: undefined,

  /**
   * @override
   */
  initComponent: function() {
    var me = this;

    Ext.apply(me, {
      store: 'ComponentAsset',

      cls: 'nx-hr',

      // Marker for source of targets to be shown in container assets
      assetContainerSource: true,

      // Prevent the store from automatically loading
      loadStore: Ext.emptyFn,

      allowDeselect: true,

      viewConfig: {
        emptyText: 'No assets found',
        deferEmptyText: false
      },

      columns: [
        {
          xtype: 'nx-iconcolumn',
          dataIndex: 'name',
          width: 36,
          iconVariant: 'x16',
          iconName: function(value) {
            var icon = me.mixins.componentUtils.getIconForAssetName(value);
            if (icon) {
              var iconName = icon.get('name');
              if (iconName) {
                return iconName;
              }
            }
            return 'default';
          }
        },
        {
          text: NX.I18n.get('SearchResultAssetList_Name_Header'),
          dataIndex: 'name',
          flex: 2.5,
          renderer: Ext.htmlEncode
        }
      ]
    });

    me.callParent();
  },

  /**
   * @public
   *
   * Sets owning component.
   * @param {NX.coreui.model.Component} componentModel owning component
   */
  setComponentModel: function(componentModel) {
    var me = this;

    me.componentModel = componentModel;
    me.fireEvent('updated', me, me.componentModel);
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Support Zip panel.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.support.SupportZip', {
  extend: 'NX.view.SettingsPanel',
  alias: 'widget.nx-coreui-support-supportzip',
  requires: [
    'NX.Conditions',
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function () {
    var me = this,
        uiSettings = NX.State.getValue('uiSettings', {});

    me.settingsForm = {
      xtype: 'nx-settingsform',
      settingsFormSubmitMessage: NX.I18n.get('Support_SupportZip_Creating_Message'),
      settingsFormSuccessMessage: NX.I18n.get('Support_SupportZip_Create_Success'),
      timeout: uiSettings['longRequestTimeout'],
      isDirty: function() { return false; }, // form is never saved, so never dirty
      api: {
        submit: 'NX.direct.atlas_SupportZip.create'
      },
      editableCondition: NX.Conditions.isPermitted('nexus:atlas:create'),
      editableMarker: NX.I18n.get('SupportZip_Permission_Error'),
      items: [
        {
          xtype: 'label',
          html: NX.I18n.get('SupportZip_HelpText')
        },
        {
          xtype: 'checkboxgroup',
          fieldLabel: NX.I18n.get('Support_SupportZip_Contents_FieldLabel'),
          columns: 1,
          allowBlank: false,
          items: [
            {
              xtype: 'checkbox',
              name: 'systemInformation',
              boxLabel: NX.I18n.get('Support_SupportZip_Report_BoxLabel'),
              checked: true
            },
            {
              xtype: 'checkbox',
              name: 'threadDump',
              boxLabel: NX.I18n.get('Support_SupportZip_Dump_BoxLabel'),
              checked: true
            },
            {
              xtype: 'checkbox',
              name: 'configuration',
              boxLabel: NX.I18n.get('Support_SupportZip_Configuration_BoxLabel'),
              checked: true
            },
            {
              xtype: 'checkbox',
              name: 'security',
              boxLabel: NX.I18n.get('Support_SupportZip_Security_BoxLabel'),
              checked: true
            },
            {
              xtype: 'checkbox',
              name: 'log',
              boxLabel: NX.I18n.get('Support_SupportZip_LogFiles_BoxLabel'),
              checked: true
            },
            {
              xtype: 'checkbox',
              name: 'taskLog',
              boxLabel: NX.I18n.get('Support_SupportZip_TaskLogFiles_BoxLabel'),
              checked: true
            },
            {
              xtype: 'checkbox',
              name: 'metrics',
              boxLabel: NX.I18n.get('Support_SupportZip_Metrics_BoxLabel'),
              checked: true
            },
            {
              xtype: 'checkbox',
              name: 'jmx',
              boxLabel: NX.I18n.get('Support_SupportZip_JMX_BoxLabel'),
              checked: true
            }
          ]
        },
        {
          xtype: 'checkboxgroup',
          fieldLabel: NX.I18n.get('Support_SupportZip_Options_FieldLabel'),
          allowBlank: true,
          columns: 1,
          items: [
            {
              xtype: 'checkbox',
              name: 'limitFileSizes',
              boxLabel: NX.I18n.get('Support_SupportZip_Included_BoxLabel'),
              checked: true
            },
            {
              xtype: 'checkbox',
              name: 'limitZipSize',
              boxLabel: NX.I18n.get('Support_SupportZip_Max_BoxLabel'),
              checked: true
            }
          ]
        }
      ],

      buttonAlign: 'left',

      buttons: [
        {
          text: NX.I18n.get('Support_SupportZip_Create_Button'),
          formBind: true,
          glyph: 'xf019@FontAwesome' /* fa-download */,
          action: 'submit',
          ui: 'nx-primary'
        }
      ]
    };

    me.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Support ZIP created window.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.support.SupportZipCreated', {
  extend: 'NX.coreui.view.support.FileCreated',
  alias: 'widget.nx-coreui-support-supportzipcreated',
  requires: [
      'NX.Icons',
      'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    me.fileIcon = NX.Icons.img('supportzip-zip', 'x32');
    me.fileType = NX.I18n.get('Support_SupportZipCreated_FileType_Text'),

    me.callParent();

    me.truncatedWarning = Ext.widget({
      // FIXME: use container instead of panel
      xtype: 'panel',
      layout: {
        type: 'hbox',
        align: 'middle'
      },
      style: {
        // FIXME: sort out common style here for dialogs
        marginBottom: '10px'
      },
      // TODO Style
      items: [
        { xtype: 'component', html: NX.Icons.img('supportzip-truncated', 'x32') },
        { xtype: 'component', html: NX.I18n.get('Support_SupportZipCreated_Truncated_Text'),
          margin: '0 0 0 5'
        }
      ],
      hidden: true
    });

    me.items.get(0).items.insert(1, me.truncatedWarning);
  },

  /**
   * Set form values.
   *
   * @public
   */
  setValues: function (values) {
    var me = this;

    me.callParent(arguments);

    // if truncated show the warning
    if (values.truncated) {
      me.truncatedWarning.show();
    }
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Support Zip controller.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.controller.SupportZip', {
  extend: 'NX.app.Controller',
  requires: [
    'NX.Permissions',
    'NX.Security',
    'NX.util.Base64',
    'NX.util.Url',
    'NX.util.DownloadHelper',
    'NX.I18n'
  ],

  views: [
    'support.SupportZip',
    'support.SupportZipCreated'
  ],

  /**
   * @override
   */
  init: function () {
    var me = this;

    me.getApplication().getIconController().addIcons({
      'supportzip-zip': {
        file: 'file_extension_zip.png',
        variants: ['x16', 'x32']
      },
      'supportzip-truncated': {
        file: 'warning.png',
        variants: ['x16', 'x32']
      }
    });

    me.getApplication().getFeaturesController().registerFeature({
      mode: 'admin',
      path: '/Support/Support ZIP',
      text: NX.I18n.get('SupportZip_Title'),
      description: NX.I18n.get('SupportZip_Description'),
      view: { xtype: 'nx-coreui-support-supportzip' },
      iconConfig: {
        file: 'file_extension_zip.png',
        variants: ['x16', 'x32']
      },
      visible: function () {
        return NX.Permissions.check('nexus:atlas:create');
      }
    }, me);

    me.listen({
      component: {
        'nx-coreui-support-supportzip form': {
          submitted: me.showSupportZipCreatedWindow
        },
        'nx-coreui-support-supportzipcreated button[action=download]': {
          click: me.download
        }
      }
    });
  },

  /**
   * @private
   */
  showSupportZipCreatedWindow: function (form, action) {
    Ext.widget('nx-coreui-support-supportzipcreated').setValues(action.result.data);
  },

  /**
   * @private
   * Download support ZIP file.
   */
  download: function (button) {
    var win = button.up('window'),
        fileName = win.down('form').getValues().name;

    NX.Security.doWithAuthenticationToken(
        NX.I18n.get('SupportZip_Authenticate_Text'),
        {
          success: function (authToken) {
            NX.util.DownloadHelper.downloadUrl(NX.util.Url.urlOf(
                'service/rest/wonderland/download/' + fileName + '?t=' + NX.util.Base64.encode(authToken)
            ));
            win.close();
          }
        }
    );
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext*/

/**
 * Database freeze warning controller, handles showing messages.
 *
 * @since 3.2
 */
Ext.define('NX.coreui.controller.DatabaseWarnings', {
  extend: 'NX.app.Controller',

  requires: [
    'NX.I18n',
    'NX.Permissions'
  ],
  refs: [
    {
      ref: 'databaseFreezeWarning',
      selector: '#nx-database-freeze-warning'
    }
  ],

  /**
   * @override
   */
  init: function() {

    var me = this;

    me.listen({
      controller: {
        '#State': {
          changed: me.stateChanged
        }
      },
      component: {
        '#nx-database-freeze-warning' : {
          afterrender: me.stateChanged
        }
      }
    });
  },

  stateChanged: function() {
    var me = this,
        warningPanel = me.getDatabaseFreezeWarning(),
        databaseFreezeState = NX.State.getValue('db', {})['dbFrozen'],
        quorumState = NX.State.getValue('quorum', {'quorumPresent':true})['quorumPresent'],
        reason = NX.State.getValue('db', {})['reason'];

    if (warningPanel) {
      if (!quorumState) {
        warningPanel.setTitle(NX.I18n.get('Nodes_Quorum_lost_warning'));
      }

      // Read-only mode will take precedence and be the only message shown.
      if (databaseFreezeState) {
        var message = NX.I18n.get('Nodes_Read_only_mode_warning');
        if (typeof reason !== 'undefined' && reason !== '') {
          message += ': ' + reason;
        }
        warningPanel.setTitle(message);
      }

      if (!quorumState || databaseFreezeState) {
        warningPanel.show();
      }
      else {
        warningPanel.hide();
      }
    }
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Ssl Certificate detail panel.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.ssl.SslCertificateDetails', {
  extend: 'NX.view.SettingsPanel',
  alias: 'widget.nx-coreui-sslcertificate-details',

  title: 'Summary',
  settingsForm: { xtype: 'nx-coreui-sslcertificate-details-form' },

  dockedItems: null
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Maven2 Component Details Provider.
 *
 * @since 3.14
 */
Ext.define('NX.coreui.util.Maven2ComponentActionHandler', {
  alias: 'nx-coreui-maven2-component-action-handler',
  singleton: true,
  requires: [
      'NX.Bookmarks',
      'NX.I18n'
  ],

  isSnapshot: function(componentModel) {
    var id;

    if (!componentModel) {
      return false;
    }

    id = componentModel.get('id');
    return (componentModel.get('format') === 'maven2') &&
        id.indexOf('-SNAPSHOT') === (id.length - '-SNAPSHOT'.length);
  },

  updateDeleteButtonVisibility: function(button, componentModel) {
    var visibilityUpdated;

    if (this.isSnapshot(componentModel)) {
      button.hide();
      visibilityUpdated = true;
    } else {
      visibilityUpdated = false;
    }

    return visibilityUpdated;
  },

  updateBrowseButtonVisibility: function(button, componentModel) {
    if (this.isSnapshot(componentModel)) {
      button.show();
    } else {
      button.hide();
    }

    return true;
  },

  /**
   * Browse to the selected component.
   *
   * @private
   */
  browseComponent: function(componentModel, assetModel) {
    var repositoryName, componentGroup, componentName,
        attributes, version, baseVersion, path;

    if (componentModel && assetModel) {
      repositoryName = componentModel.get('repositoryName');
      componentGroup = componentModel.get('group').replace(/\./g, '/');
      componentName = componentModel.get('name');

      attributes = assetModel.get('attributes');
      version = attributes.maven2 && attributes.maven2.version;
      baseVersion = attributes.maven2 && attributes.maven2.baseVersion;

      path = 'browse/browse:' + encodeURIComponent(repositoryName) + ':' +
          encodeURIComponent(componentGroup + '/' + componentName + '/' + baseVersion + '/' + version);

      NX.Bookmarks.navigateTo(NX.Bookmarks.fromToken(path));
    }
  }


});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Component details panel.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.component.ComponentDetails', {
  // FIXME: change to container
  extend: 'Ext.panel.Panel',
  alias: 'widget.nx-coreui-component-details',

  cls: 'nx-coreui-component-details',

  requires: [
    'NX.ext.button.Button'
  ],

  /**
   * Currently shown component model.
   */
  componentModel: undefined,

  layout: {
    type: 'hbox',
    align: 'stretch'
  },

  /**
   * @override
   */
  initComponent: function() {
    Ext.apply(this, {
      dockedItems: {
        xtype: 'nx-actions',
        dock: 'bottom',
        items: [
          {
            xtype: 'nx-button',
            text: NX.I18n.get('ComponentDetails_Delete_Button'),
            glyph: 'xf1f8@FontAwesome' /* fa-trash */,
            action: 'deleteComponent',
            hidden: true
          },
          {
            xtype: 'nx-button',
            text: NX.I18n.get('ComponentDetails_Browse_Snapshots_Button'),
            glyph: 'xf1c0@FontAwesome' /* fa-database */,
            action: 'browseComponent',
            hidden: true
          },
          {
            xtype: 'nx-button',
            text: NX.I18n.get('ComponentDetails_Analyze_Button'),
            glyph: 'xf085@FontAwesome' /* fa-gears */,
            action: 'analyzeApplication'
          }
        ]
      },

      items: [
        {xtype: 'nx-info', itemId: 'repositoryInfo'},
        {xtype: 'nx-info', itemId: 'componentInfo'},
        {xtype: 'nx-info', itemId: 'extraInfo'}
      ]
    });

    this.callParent();
  },

  /**
   * Sets component.
   *
   * @public
   * @param {NX.coreui.model.Component} componentModel
   */
  setComponentModel: function(componentModel) {
    var me = this;

    me.componentModel = componentModel;
    me.fireEvent('updated', me, me.componentModel);
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Configuration for Repository Groups.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.repository.facet.GroupFacet', {
  extend: 'Ext.form.FieldContainer',
  alias: 'widget.nx-coreui-repository-group-facet',
  requires: [
    'NX.I18n',
    'NX.coreui.store.RepositoryReference'
  ],

  /**
   * @cfg String
   * Set the format to narrow the format of groups available to choose from.
   */
  format: undefined,

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    me.repositoryStore = Ext.create('NX.coreui.store.RepositoryReference', {remote: true, sorters: undefined});
    me.repositoryStore.filter([
      {property: 'format', value: me.format}
    ]);
    me.repositoryStore.load(function (records, operation, success) {
      //TODO - KR hackity hack, but it appears that the store loading somehow unsets values?
      var form = me.up('form');
      if (form) {
        var record = form.getRecord();
        if (record) {
          me.repositoryStore.filter([
            {property: 'format', value: me.format},
            {
              filterFn: function (item) {
                return item.get('name') !== record.get('name');
              }
            }
          ]);
          var memberNames = record.get('attributes').group.memberNames;
          form.down('#groupMemberNames').setValue(memberNames);
          // clears isDirty state after setting the value
          form.down('#groupMemberNames').resetOriginalValue();
        }
      }
    });
    me.items = [
      {
        xtype: 'fieldset',
        cls: 'nx-form-section',
        title: NX.I18n.get('Repository_Facet_GroupFacet_Title'),

        items: {
          xtype: 'nx-itemselector',
          name: 'attributes.group.memberNames',
          itemId: 'groupMemberNames',
          fieldLabel: NX.I18n.get('Repository_Facet_GroupFacet_Members_FieldLabel'),
          helpText: NX.I18n.get('Repository_Facet_GroupFacet_Members_HelpText'),
          buttons: ['up', 'add', 'remove', 'down'],
          fromTitle: NX.I18n.get('Repository_Facet_GroupFacet_Members_FromTitle'),
          toTitle: NX.I18n.get('Repository_Facet_GroupFacet_Members_ToTitle'),
          store: me.repositoryStore,
          valueField: 'id',
          displayField: 'name',
          allowBlank: false,
          delimiter: null,
          forceSelection: true,
          queryMode: 'local',
          triggerAction: 'all',
          selectOnFocus: false,
          itemCls: 'required-field'
        }
      }
    ];

    me.callParent();
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Repository "Settings" form for a Maven Group repository.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.repository.recipe.Maven2Group', {
  extend: 'NX.coreui.view.repository.RepositorySettingsForm',
  alias: 'widget.nx-coreui-repository-maven2-group',
  requires: [
    'NX.coreui.view.repository.facet.Maven2Facet',
    'NX.coreui.view.repository.facet.StorageFacet',
    'NX.coreui.view.repository.facet.GroupFacet'
  ],

  /**
   * @override
   */
  initComponent: function() {
    var me = this;

    me.items = [
      { xtype: 'nx-coreui-repository-storage-facet'},
      { xtype: 'nx-coreui-repository-group-facet', format: 'maven2' }
    ];

    me.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Configuration specific to Http connections for repositories.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.repository.facet.NugetProxyFacet', {
  extend: 'Ext.form.FieldContainer',
  alias: 'widget.nx-coreui-repository-nugetproxy-facet',
  requires: [
    'NX.I18n'
  ],

  defaults: {
    itemCls: 'required-field'
  },

  /**
   * @override
   */
  initComponent: function() {
    var me = this;

    me.items = [
      {
        xtype: 'fieldset',
        cls: 'nx-form-section',
        title: NX.I18n.get('Repository_Facet_NugetProxyFacet_Title'),

        items: [
          {
            xtype: 'numberfield',
            name: 'attributes.nugetProxy.queryCacheItemMaxAge',
            fieldLabel: NX.I18n.get('Repository_Facet_NugetProxyFacet_ItemMaxAge_FieldLabel'),
            helpText: NX.I18n.get('Repository_Facet_NugetProxyFacet_ItemMaxAge_HelpText'),
            minValue: 0,
            value: 3600
          }
        ]
      }
    ];

    me.callParent();
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Health Check repository status model.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.model.HealthCheckRepositoryStatus', {
  extend: 'Ext.data.Model',
  idProperty: 'repositoryName',
  fields: [
    {name:'repositoryName', type: 'string', sortType: 'asUCText'},
    {name:'enabled', type: 'boolean'},
    {name:'eulaAccepted', type: 'boolean'},
    {name:'analyzing', type: 'boolean'},
    {name:'detailedReportSupported', type: 'boolean'},
    {name:'iframeHeight', type: 'int'},
    {name:'iframeWidth', type: 'int'},
    {name:'securityIssueCount', type: 'int'},
    {name:'licenseIssueCount', type: 'int'},
    {name:'summaryUrl', type: 'string', sortType: 'asUCText'},
    {name:'detailUrl', type: 'string', sortType: 'asUCText'},
    {name:'totalCounts', type: 'auto' /* array */},
    {name:'vulnerableCounts', type: 'auto' /* array */}
  ]
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Health Check repository status store.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.store.HealthCheckRepositoryStatus', {
  extend: 'Ext.data.Store',
  model: 'NX.coreui.model.HealthCheckRepositoryStatus',

  loaded: false,

  proxy: {
    type: 'direct',
    paramsAsHash: false,

    api: {
      read: 'NX.direct.healthcheck_Status.read'
    },

    reader: {
      type: 'json',
      rootProperty: 'data',
      successProperty: 'success'
    }
  },

  listeners: {
    beforeload: function() {
      this.loaded = false;
    },
    load: function() {
      this.loaded = true;
    }
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Manages health check enabling/disabling on a per repository basis.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.controller.HealthCheckRepositoryConfiguration', {
  extend: 'NX.app.Controller',
  requires: [
    'NX.Conditions',
    'NX.Permissions',
    'NX.I18n'
  ],
  stores: [
    'HealthCheckRepositoryStatus'
  ],
  views: [
    'healthcheck.HealthCheckEula'
  ],
  refs: [
    {ref: 'settings', selector: 'nx-coreui-repository-settings'},
    {ref: 'button', selector: 'nx-coreui-repository-feature button[action=toggleHealthCheck]'}
  ],

  /**
   * @override
   */
  init: function () {
    var me = this;

    me.listen({
      component: {
        'nx-coreui-repository-feature button[action=toggleHealthCheck]': {
          click: me.toggleHealthCheck,
          show: me.updateLabel
        },
        'nx-coreui-repository-settings-form': {
          recordloaded: me.updateHealthCheckButton
        }
      }
    });
  },

  /**
   * Update the button text based on whether or not the feature is enabled.
   * @private
   */
  updateLabel: function () {
    var me = this,
        button = me.getButton();

    if (!button.disabled) {
      var settings = me.getSettings();
      var form = settings.down('form');
      if (form) {
        var repository = form.getForm().getRecord();
        var repositoryStatus = me.getHealthCheckRepositoryStatusStore().findRecord('repositoryName',
            repository.get('name'));
        if (repositoryStatus && repositoryStatus.get('enabled') === true) {
          button.setText(NX.I18n.get('Repository_RepositoryFeature_HealthCheckDisable_Button'));
        }
        else {
          button.setText(NX.I18n.get('Repository_RepositoryFeature_HealthCheckEnable_Button'));
        }
      }
    }
  },

  /**
   * Show/hide Health Check button for proxy repositories based on permissions.
   *
   * @private
   */
  updateHealthCheckButton: function (e, model) {
    var me = this,
        button = me.getButton();

    if (model.get('type') !== 'proxy' || model.get('format') === 'maven2'
            && model.get('attributes').maven.versionPolicy !== 'RELEASE') {
      button.hide();
      return;
    }
    button.show();

    if (NX.Permissions.check('nexus:repository-admin:' + model.get('format') + ':' + model.get('name') + ':edit')) {
      button.enable();
    }
    else {
      button.disable();
    }
    me.updateLabel();
  },

  /**
   * Enable/disable Health Check for specified repository. Checks for eula acceptance and offers it if not
   * previously accepted.
   *
   * @private
   */
  toggleHealthCheck: function () {
    var me = this,
        repository = me.getSettings().down('form').getForm().getRecord(),
        repositoryName = repository.get('name'),
        status = me.getHealthCheckRepositoryStatusStore().findRecord('repositoryName', repositoryName);

    if (status.get('eulaAccepted')) {
      me.enableAnalysis(!status.get('enabled'), repositoryName);
    }
    else {
      Ext.widget('nx-coreui-healthcheck-eula', {
        acceptFn: function () {
          me.enableAnalysis(true, repositoryName);
        }
      });
    }
  },

  /**
   * Set the enabled status appropriately for a repository.  Assumes the eula has already been accepted.
   * @private
   */
  enableAnalysis: function (enabled, repositoryName) {
    var me = this;
    NX.direct.healthcheck_Status.update(
        true /* eula accepted */, repositoryName, enabled /* enabled */,
        function (response) {
          if (Ext.isObject(response) && response.success) {
            me.getHealthCheckRepositoryStatusStore().load(function (records, operation, success) {
              if (success) {
                me.updateLabel();
              }
            });
          }
        }
    );
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Task Schedule Once field set.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.task.TaskScheduleOnce', {
  extend: 'NX.coreui.view.task.TaskScheduleFields',
  alias: 'widget.nx-coreui-task-schedule-once',
  requires: [
    'NX.util.DateFormat',
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    me.items = [
      {
        xtype: 'datefield',
        name: 'startDate',
        itemId: 'startDate',
        fieldLabel: NX.I18n.get('Task_TaskScheduleDaily_StartDate_FieldLabel'),
        allowBlank: false,
        format: 'm/d/Y',
        value: new Date(),
        submitValue: false
      },
      {
        xtype: 'timefield',
        name: 'startTime',
        itemId: 'startTime',
        fieldLabel: NX.I18n.get('Task_TaskScheduleHourly_EndDate_FieldLabel'),
        helpText: 'The time this task should start running in your time zone ' + NX.util.DateFormat.getTimeZone() + '.',
        allowBlank: false,
        format: 'H:i',
        submitValue: false
      }
    ];

    me.callParent();
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * License User grid.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.licensing.LicenseUserList', {
  extend: 'Ext.grid.Panel',
  alias: 'widget.nx-coreui-licensing-licenseuser-list',
  requires: [
    'NX.I18n'
  ],

  stateful: true,
  stateId: 'nx-coreui-licensing-licenseuser-list',

  /**
   * @override
   */
  initComponent: function() {
    Ext.apply(this, {
      store: 'LicenseUser',

      columns: [
        {
          xtype: 'nx-iconcolumn',
          width: 36,
          iconVariant: 'x16',
          iconName: function () {
            return 'licenseuser-default';
          }
        },
        { header: NX.I18n.get('Licensing_LicenseUserList_IP_Header'), dataIndex: 'ip', stateId: 'ip', flex: 1 },
        { header: NX.I18n.get('Licensing_LicenseUserList_Date_Header'), dataIndex: 'timestamp', stateId: 'timestamp', flex: 1 },
        { header: NX.I18n.get('Licensing_LicenseUserList_User_Header'), dataIndex: 'userId', stateId: 'userId', flex: 1 },
        { header: NX.I18n.get('Licensing_LicenseUserList_Agent_Header'), dataIndex: 'userAgent', stateId: 'userAgent', flex: 2 }
      ],

      viewConfig: {
        emptyText: NX.I18n.get('Licensing_LicenseUserList_EmptyText'),
        deferEmptyText: false
      },

      dockedItems: [{
        xtype: 'nx-actions',
        items: {
          xtype: 'button',
          text: NX.I18n.get('Licensing_LicenseUserList_Download_Button'),
          glyph: 'xf019@FontAwesome' /* fa-download */,
          action: 'download'
        }
      }],

      plugins: [{ ptype: 'gridfilterbox', emptyText: 'No license user matched criteria "$filter"' }]
    });

    this.callParent();
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Repository format model.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.model.RepositoryFormat', {
  extend: 'Ext.data.Model',
  fields: [
    {name: 'id', type: 'string', sortType: 'asUCText'},
    {name: 'name', type: 'string', sortType: 'asUCText'}
  ]
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Audit store.
 *
 * @since 3.1
 */
Ext.define('NX.coreui.audit.AuditStore', {
  extend: 'Ext.data.Store',
  model: 'NX.coreui.audit.AuditModel',

  pageSize: 250,

  proxy: {
    type: 'direct',

    api: {
      read: 'NX.direct.audit_Audit.read'
    },

    reader: {
      type: 'json',
      rootProperty: 'data',
      successProperty: 'success'
    }
  },

  sorters: { property: 'timestamp', direction: 'ASC' }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Logger model.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.model.Logger', {
  extend: 'Ext.data.Model',
  idProperty: 'name',
  fields: [
    {name: 'name', type: 'string', sortType: 'asText'},
    {name: 'level', type: 'string', sortType: 'asUCText'}
  ]
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Generic reference (id/name) model.
 *
 * @since 3.14
 */
Ext.define('NX.coreui.model.Format', {
  extend: 'Ext.data.Model',
  fields: [
    {name: 'value', type: 'string', sortType: 'asUCText'}
  ]
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Bundle model.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.model.Bundle', {
  extend: 'Ext.data.Model',
  fields: [
    { name: 'id', type: 'int' },
    { name: 'state', type: 'string' },
    { name: 'name', type: 'string' },
    { name: 'symbolicName', type: 'string' },
    { name: 'version', type: 'string' },
    { name: 'location', type: 'string' },
    { name: 'startLevel', type: 'int' },
    { name: 'lastModified', type: 'int'},
    { name: 'fragment', type: 'bool' },
    { name: 'fragments', type: 'auto' /*array*/ },
    { name: 'fragmentHosts', type: 'auto' /*array*/ },
    { name: 'headers', type: 'auto' /*object*/}
  ]
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * bower repository search contribution.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.controller.SearchBower', {
  extend: 'NX.app.Controller',
  requires: [
    'NX.I18n'
  ],

  /**
   * @override
   */
  init: function() {
    var me = this,
        search = me.getController('NX.coreui.controller.Search');

    search.registerFilter({
      id: 'bower',
      name: 'bower',
      text: NX.I18n.get('SearchBower_Text'),
      description: NX.I18n.get('SearchBower_Description'),
      readOnly: true,
      criterias: [
        { id: 'format', value: 'bower', hidden: true },
        { id: 'name.raw' },
        { id: 'version' }
      ]
    }, me);
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/*global NX*/

/**
 * 'textarea' factory.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.formfield.factory.FormfieldTextAreaFactory', {
  singleton: true,
  alias: [
    'nx.formfield.factory.textarea',
    'nx.formfield.factory.text-area'
  ],

  /**
   * Creates a textarea.
   * @param formField form field to create textarea for
   * @returns {*} created textarea (never null)
   */
  create: function (formField) {
    var item = {
      xtype: 'textarea',
      htmlDecode: true,
      width: '100%',
      fieldLabel: formField.label,
      itemCls: formField.required ? 'required-field' : '',
      helpText: formField.helpText,
      allowBlank: !formField.required,
      regex: formField.regexValidation ? new RegExp(formField.regexValidation) : null,
      grow: true,
      growMax: 320
    };
    if (formField.initialValue) {
      item.value = formField.initialValue;
    }
    return item;
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/*global NX, Ext, Sonatype*/

/**
 * 'combo' factory.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.formfield.factory.FormfieldComboFactory', {
  singleton: true,
  alias: [
    'nx.formfield.factory.combo',
    'nx.formfield.factory.combobox',
    'nx.formfield.factory.repo',
    'nx.formfield.factory.repo-or-group',
    'nx.formfield.factory.repo-target'
  ],
  requires: [
    'Ext.data.Store',
    'Ext.form.ComboBox',
    'NX.util.Url'
  ],
  mixins: {
    logAware: 'NX.LogAware'
  },

  /**
   * Creates a combo.
   * @param formField form field to create combo for
   * @returns {*} created combo (never null)
   */
  create: function (formField) { // NOSONAR
    var ST = Ext.data.SortTypes,
        item, filters,
        itemConfig = {
          xtype: 'combo',
          fieldLabel: formField.label,
          itemCls: formField.required ? 'required-field' : '',
          helpText: formField.helpText,
          name: formField.id,
          displayField: 'name',
          valueField: 'id',
          editable: false,
          forceSelection: true,
          queryMode: 'local',
          triggerAction: 'all',
          emptyText: 'Select...',
          selectOnFocus: false,
          allowBlank: !formField.required
        };

    if (formField.initialValue != null) {
      itemConfig.listeners = {
        afterrender: function() {
          var me = this;
          if (!me.getValue()) {
            me.setValue(formField.initialValue);
          }
        }
      };
    }
    if (formField['storeApi']) {
      if (formField['storeFilters']) {
        filters = [];
        Ext.Object.each(formField['storeFilters'], function (key, value) {
          filters.push({ property: key, value: value });
        });
      }
      itemConfig.store = Ext.create('Ext.data.Store', {
        proxy: {
          type: 'direct',
          api: {
            read: 'NX.direct.' + formField['storeApi']
          },
          reader: {
            type: 'json',
            rootProperty: 'data',
            idProperty: formField['idMapping'] || 'id',
            successProperty: 'success'
          }
        },

        fields: [
          {name: 'id', mapping: formField['idMapping'] || 'id'},
          {name: 'name', mapping: formField['nameMapping'] || 'name', sortType: ST.asUCString},
          {name: 'sortOrder', sortType: ST.asInt}
        ],

        filters: filters,
        sortOnLoad: true,
        sorters: [{ property: 'sortOrder', direction: 'DESC' }, { property: formField['attributes']['sortProperty'] || 'name', direction: 'ASC' }],
        remoteFilter: true,
        autoLoad: true
      });
    } else {
      itemConfig.store = Ext.create('Ext.data.Store', {
        fields: [
          {name: 'id', mapping: formField['idMapping'] || 'id'},
          {name: 'name', mapping: formField['nameMapping'] || 'name', sortType: ST.asUCString},
          {name: 'sortOrder', sortType: ST.asInt}
        ],

        sortOnLoad: true,
        sorters: [{ property: 'sortOrder', direction: 'DESC' }, { property: formField['attributes']['sortProperty'] || 'name', direction: 'ASC' }],
        remoteFilter: true,
        autoLoad: false
      });
    }
    item = Ext.create('Ext.form.ComboBox', itemConfig);
    Ext.override(item, {
      /**
       * Avoid value being set to null by combobox in case that store was not already loaded.
       */
      setValue: function (value) {
        var me = this;
        me.callParent(arguments);
        if (me.getValue() === null) {
          me.value = value;
        }
      }
    });
    return item;
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Security anonymous settings form.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.security.AnonymousSettings', {
  extend: 'NX.view.SettingsPanel',
  alias: 'widget.nx-coreui-security-anonymous-settings',
  requires: [
    'NX.Conditions',
    'NX.I18n'
  ],

  initComponent: function () {
    var me = this;

    me.settingsForm = [
      {
        xtype: 'nx-settingsform',
        settingsFormSuccessMessage: NX.I18n.get('Security_AnonymousSettings_Update_Success'),
        api: {
          load: 'NX.direct.coreui_AnonymousSettings.read',
          submit: 'NX.direct.coreui_AnonymousSettings.update'
        },
        editableCondition: NX.Conditions.isPermitted('nexus:settings:update'),
        editableMarker: NX.I18n.get('Security_AnonymousSettings_Update_Error'),
        items: [
          {
            xtype: 'checkbox',
            name: 'enabled',
            value: true,
            boxLabel: NX.I18n.get('Security_AnonymousSettings_Allow_BoxLabel')
          },
          {
            xtype: 'textfield',
            name: 'userId',
            fieldLabel: NX.I18n.get('Security_AnonymousSettings_Username_FieldLabel'),
            allowBlank: false
          },
          {
            xtype: 'combo',
            name: 'realmName',
            fieldLabel: NX.I18n.get('Security_AnonymousSettings_Realm_FieldLabel'),
            queryMode: 'local',
            displayField: 'name',
            valueField: 'id',
            store: 'RealmType',
            editable: false
          }
        ]
      }
    ];

    me.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Add user window.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.user.UserAdd', {
  extend: 'NX.view.AddPanel',
  alias: 'widget.nx-coreui-user-add',
  requires: [
    'NX.Conditions',
    'NX.I18n'
  ],

  defaultFocus: 'userId',

  /**
   * @override
   */
  initComponent: function() {
    var me = this;

    me.settingsForm = {
      xtype: 'nx-coreui-user-settings-form',
      api: {
        submit: 'NX.direct.coreui_User.create'
      },
      settingsFormSuccessMessage: function(data) {
        return NX.I18n.get('User_UserAdd_Create_Success') + data['userId'];
      },
      editableCondition: NX.Conditions.isPermitted('nexus:users:create'),
      editableMarker: NX.I18n.get('User_UserAdd_Create_Error'),

      buttons: [
        { text: NX.I18n.get('User_UserList_New_Button'), action: 'add', formBind: true, ui: 'nx-primary' },
        { text: NX.I18n.get('Add_Cancel_Button'), action: 'back' }
      ]
    };

    me.callParent();

    me.down('#userId').setReadOnly(false);

    me.down('form').insert(5, [
      {
        xtype: 'nx-password',
        name: 'password',
        itemId: 'password',
        fieldLabel: NX.I18n.get('User_UserAdd_Password_FieldLabel')
      },
      {
        xtype: 'nx-password',
        allowBlank: true,
        fieldLabel: NX.I18n.get('User_UserAdd_PasswordConfirm_FieldLabel'),
        submitValue: false,
        validator: function() {
          var me = this;
          return (me.up('form').down('#password').getValue() === me.getValue()) ? true : NX.I18n.get('User_UserChangePassword_NoMatch_Error');
        }
      }
    ]);
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Repository "Settings" form for a bower Group repository.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.repository.recipe.BowerGroup', {
  extend: 'NX.coreui.view.repository.RepositorySettingsForm',
  alias: 'widget.nx-coreui-repository-bower-group',
  requires: [
    'NX.coreui.view.repository.facet.StorageFacet',
    'NX.coreui.view.repository.facet.GroupFacet'
  ],

  /**
   * @override
   */
  initComponent: function() {
    var me = this;

    me.items = [
      {xtype: 'nx-coreui-repository-storage-facet'},
      {xtype: 'nx-coreui-repository-group-facet', format: 'bower'}
    ];

    me.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Cleanup Policy "Settings" panel.
 *
 * @since 3.14
 */
Ext.define('NX.coreui.view.cleanuppolicy.CleanupPolicySettings', {
  extend: 'NX.view.SettingsPanel',
  alias: 'widget.nx-coreui-cleanuppolicy-settings',
  requires: [
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function() {
    Ext.apply(this, {
      title: NX.I18n.get('CleanupPolicy_CleanupPolicyFeature_Settings_Title'),
      settingsForm: {
        xtype: 'nx-coreui-cleanuppolicy-settings-form',
        buttons: [
          {
            text: NX.I18n.get('CleanupPolicy_CleanupPolicyList_Preview_Button'),
            action: 'preview',
            ui: 'nx-primary'
          },
          {text: NX.I18n.get('SettingsForm_Save_Button'), action: 'save', ui: 'nx-primary', bindToEnter: false},
          {text: NX.I18n.get('SettingsForm_Discard_Button'), action: 'discard'}
        ]
      },
      dockedItems: null
    });

    this.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Task type model.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.model.TaskType', {
  extend: 'Ext.data.Model',
  fields: [
    {name: 'id', type: 'string', sortType: 'asUCText'},
    {name: 'name', type: 'string', sortType: 'asUCText'},
    {name: 'exposed', type: 'boolean'},
    {name: 'formFields', type: 'auto' /*array*/}
  ]
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Search Filter store.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.store.SearchFilter', {
  extend: 'Ext.data.Store',
  model: 'NX.coreui.model.SearchFilter',

  autoLoad: true,

  proxy: {
    type: 'memory',
    reader: {
      type: 'json'
    }
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Task grid.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.task.TaskList', {
  extend: 'NX.view.drilldown.Master',
  alias: 'widget.nx-coreui-task-list',
  requires: [
    'NX.I18n'
  ],

  stateful: true,
  stateId: 'nx-coreui-task-list',

  /**
   * @override
   */
  initComponent: function() {
    Ext.apply(this, {
      store: 'Task',

      columns: [
        {
          xtype: 'nx-iconcolumn',
          width: 36,
          iconVariant: 'x16',
          iconName: function () {
            return 'task-default';
          }
        },
        { header: NX.I18n.get('Task_TaskList_Name_Header'), dataIndex: 'name', stateId: 'name', flex: 1, renderer: Ext.htmlEncode },
        { header: NX.I18n.get('Task_TaskList_Type_Header'), dataIndex: 'typeName', stateId: 'typeName', flex: 1, renderer: Ext.htmlEncode },
        { header: NX.I18n.get('Task_TaskList_Status_Header'), dataIndex: 'statusDescription', stateId: 'statusDescription', renderer: Ext.htmlEncode },
        { header: NX.I18n.get('Task_TaskList_Schedule_Header'), dataIndex: 'schedule', stateId: 'schedule', renderer: Ext.htmlEncode },
        { header: NX.I18n.get('Task_TaskList_NextRun_Header'), dataIndex: 'nextRun', stateId: 'nextRun', flex: 1, renderer: Ext.htmlEncode },
        { header: NX.I18n.get('Task_TaskList_LastRun_Header'), dataIndex: 'lastRun', stateId: 'lastRun', flex: 1, renderer: Ext.htmlEncode },
        { header: NX.I18n.get('Task_TaskList_LastResult_Header'), dataIndex: 'lastRunResult', stateId: 'lastRunResult', renderer: Ext.htmlEncode }
      ],

      viewConfig: {
        emptyText: NX.I18n.get('Task_TaskList_EmptyState'),
        deferEmptyText: false
      },

      dockedItems: [{
        xtype: 'nx-actions',
        items: [
          {
            xtype: 'button',
            text: NX.I18n.get('Task_TaskList_New_Button'),
            glyph: 'xf055@FontAwesome' /* fa-plus-circle */,
            action: 'new',
            disabled: true
          }
        ]
      }],

      plugins: [
        { ptype: 'gridfilterbox', emptyText: NX.I18n.get('Task_TaskList_Filter_EmptyState') }
      ]
    });

    this.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/*global NX*/

/**
 * 'checkbox' factory.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.formfield.factory.FormfieldCheckboxFactory', {
  singleton: true,
  alias: 'nx.formfield.factory.checkbox',

  /**
   * Creates a checkbox.
   * @param formField form field to create checkbox for
   * @returns {*} created checkbox (never null)
   */
  create: function (formField) {
    var item = {
      xtype: 'checkbox',
      fieldLabel: formField.label,
      helpText: formField.helpText,
      inputValue: true
    };
    if (formField.initialValue) {
      item.checked = Boolean('true' === formField.initialValue);
    }
    return item;
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext*/

/**
 * 'url' factory.
 *
 * @since 3.2
 */
Ext.define('NX.coreui.view.formfield.factory.FormfieldUrlFactory', {
  singleton: true,
  alias: [
    'nx.formfield.factory.url'
  ],

  /**
   * Creates a nx-url field.
   * @param formField form field to create nx-url for
   * @returns {*} created textfield (never null)
   */
  create: function (formField) {
    var item = {
      xtype: 'nx-url',
      htmlDecode: true,
      fieldLabel: formField.label,
      itemCls: formField.required ? 'required-field' : '',
      helpText: formField.helpText,
      allowBlank: !formField.required,
      disabled: formField.disabled,
      readOnly: formField.readOnly,
      useTrustStore: null,
      regex: formField.regexValidation ? new RegExp(formField.regexValidation) : null
    };
    if (formField.initialValue) {
      item.value = formField.initialValue;
    }
    return item;
  }

});


/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/*global NX*/

/**
 * 'datefield' factory.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.formfield.factory.FormfieldDateFieldFactory', {
  singleton: true,
  alias: [
    'nx.formfield.factory.datefield',
    'nx.formfield.factory.date'
  ],

  /**
   * Creates a datefield.
   * @param formField form field to create datefield for
   * @returns {*} created datefield (never null)
   */
  create: function (formField) {
    var item = {
      xtype: 'datefield',
      htmlDecode: true,
      fieldLabel: formField.label,
      itemCls: formField.required ? 'required-field' : '',
      helpText: formField.helpText,
      allowBlank: !formField.required,
      regex: formField.regexValidation ? new RegExp(formField.regexValidation) : null,
      value: new Date()
    };
    if (formField.initialValue) {
      item.value = new Date(Number(formField.initialValue));
    }
    return item;
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/*global NX*/

/**
 * 'numberfield' factory.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.formfield.factory.FormfieldNumberFieldFactory', {
  singleton: true,
  alias: [
    'nx.formfield.factory.numberfield',
    'nx.formfield.factory.number'
  ],

  /**
   * Creates a numberfield.
   * @param formField form field to create numberfield for
   * @returns {*} created numberfield (never null)
   */
  create: function (formField) {
    var item = {
      xtype: 'numberfield',
      fieldLabel: formField.label,
      itemCls: formField.required ? 'required-field' : '',
      helpText: formField.helpText,
      allowBlank: !formField.required,
      regex: formField.regexValidation ? new RegExp(formField.regexValidation) : null
    };
    if (formField.initialValue) {
      item.value = Number(formField.initialValue);
    }
    if(formField.minValue) {
      item.minValue = Number(formField.minValue);
    }
    if(formField.maxValue) {
      item.maxValue = Number(formField.maxValue);
    }
    return item;
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Settings FieldSet.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.formfield.SettingsFieldSet', {
  extend: 'Ext.form.FieldContainer',
  alias: 'widget.nx-coreui-formfield-settingsfieldset',

  requires: [
    'NX.coreui.view.formfield.factory.FormfieldCheckboxFactory',
    'NX.coreui.view.formfield.factory.FormfieldComboFactory',
    'NX.coreui.view.formfield.factory.FormfieldDateFieldFactory',
    'NX.coreui.view.formfield.factory.FormfieldItemselectFactory',
    'NX.coreui.view.formfield.factory.FormfieldNumberFieldFactory',
    'NX.coreui.view.formfield.factory.FormfieldTextAreaFactory',
    'NX.coreui.view.formfield.factory.FormfieldTextFieldFactory',
    'NX.coreui.view.formfield.factory.FormfieldUrlFactory'
  ],

  mixins: {
    logAware: 'NX.LogAware'
  },

  plugins: {
    responsive:true
  },
  responsiveConfig: {
    'width <= 1366': {
      width: 600
    },
    'width <= 1600': {
      width: 800
    },
    'width > 1600' : {
      width: 1000
    }
  },

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    Ext.apply(me, {
      autoHeight: false,
      autoScroll: true,
      collapsed: false,
      items: []
    });

    me.callParent();
  },

  /**
   * @property
   */
  formFields: undefined,

  /**
   * Renders form fields.
   * @param {Array} formFields form fields to rendered
   */
  setFormFields: function (formFields) {
    var me = this,
        item;

    me.formFields = formFields;

    me.removeAll();

    if (me.formFields) {
      Ext.Array.each(me.formFields, function (formField) {
        var factory = Ext.ClassManager.getByAlias('nx.formfield.factory.' + formField.type);
        if (!factory) {
          me.logWarn('Missing factory for form-field type:', formField.type);
          factory = Ext.ClassManager.getByAlias('nx.formfield.factory.string');
        }
        if (factory) {
          var config = {
            requiresPermission: true,
            name: 'property_' + formField.id,
            factory: factory,
            delimiter: me.delimiter,
            listeners: {
              afterrender: {
                fn: function() {
                  // fixes an issue with hidden validation errors when the error is added before the field is rendered
                  this.validate();
                }
              }
            }
          };
          if (Ext.isDefined(me.delimiter)) {
            config.delimiter = me.delimiter;
          }
          item = Ext.apply(factory.create(formField, me.disableSort), config);
          me.add(item);
        }
      });
    }
    me.up('form').isValid();
  },

  /**
   * Exports properties.
   * @returns {Object} properties object
   */
  exportProperties: function (values) {
    var me = this,
        properties = {},
        value;

    if (me.formFields) {
      Ext.Array.each(me.formFields, function (formField) {
        value = values['property_' + formField.id];
        if (Ext.isDefined(value) && value !== null) {
          if (Ext.isArray(value)) {
            properties[formField.id] = value;
          } else {
            properties[formField.id] = String(value);
          }
          delete values['property_' + formField.id];
        }
        else {
          properties[formField.id] = null;  
        }
      });
    }

    return properties;
  },

  /**
   * Imports properties.
   * @param {Object} properties to import
   * @param {Array} formFields to import
   */
  importProperties: function (properties, formFields, editableCondition) {
    var me = this,
        form = me.up('form').getForm(),
        data = {};

    // recreate settings only when we have different form fields  (compare json encoded objects)
    if (Ext.encode(me.formFields) !== Ext.encode(formFields)) {
      me.setFormFields(formFields);

      if (Ext.isDefined(editableCondition) && !editableCondition.isSatisfied()) {
        me.up('form').setEditable(false);
      }
    }

    // avoid resetting initial values of fields when creating a new record (properties will be null)
    if (properties) {
      if (me.formFields) {
        Ext.Array.each(me.formFields, function(formField) {
          data['property_' + formField.id] = '';
        });
      }

      Ext.Object.each(properties, function(key, value) {
        data['property_' + key] = value;
      });

      form.setValues(data);
    }
  },

  /**
   * Mark fields in this form invalid in bulk.
   * @param {Object/Object[]/Ext.data.Errors} errors
   * Either an array in the form `[{id:'fieldId', msg:'The message'}, ...]`,
   * an object hash of `{id: msg, id2: msg2}`, or a {@link Ext.data.Errors} object.
   */
  markInvalid: function (errors) {
    var form = this.up('form').getForm(),
        remainingMessages = [],
        key, marked, field;

    if (Ext.isDefined(errors)) {
      for (key in errors) {
        if (errors.hasOwnProperty(key)) {
          marked = false;
          if (form) {
            field = form.findField('property_' + key);
            if (!field) {
              field = form.findField(key);
            }
            if (field) {
              marked = true;
              field.markInvalid(errors[key]);
            }
          }
          if (!marked) {
            remainingMessages.push(errors[key]);
          }
        }
      }
    }

    if (remainingMessages.length > 0) {
      NX.Messages.add({ text: remainingMessages.join('\n'), type: 'warning' });
    }
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Task type store.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.store.TaskType', {
  extend: 'Ext.data.Store',
  model: 'NX.coreui.model.TaskType',

  proxy: {
    type: 'direct',
    paramsAsHash: false,

    api: {
      read: 'NX.direct.coreui_Task.readTypes'
    },

    reader: {
      type: 'json',
      rootProperty: 'data',
      successProperty: 'success'
    }
  },

  sorters: { property: 'name', direction: 'ASC' }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Task Schedule Monthly field set.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.task.TaskScheduleMonthly', {
  extend: 'NX.coreui.view.task.TaskScheduleFields',
  alias: 'widget.nx-coreui-task-schedule-monthly',
  requires: [
    'NX.util.DateFormat',
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function () {
    var me = this,
        columns = [];

    for (var c = 0; c < 7; c++) {
      columns.push({
        xtype: 'panel',
        items: [],
        width: 50
      });
    }

    for (var day = 1; day <= 32; day++) {
      var columnNumber = day % 7 - 1,
          recurringDayValue = day === 32 ? '999' : day;

      if (columnNumber === -1) {
        columnNumber = 6;
      }
      columns[columnNumber].items.push({
        xtype: 'checkbox',
        name: 'recurringDay-' + recurringDayValue,
        boxLabel: day === 32 ? 'Last' : day,
        submitValue: false,
        recurringDayValue: recurringDayValue
      });
    }

    me.items = [
      {
        xtype: 'datefield',
        name: 'startDate',
        itemId: 'startDate',
        fieldLabel: NX.I18n.get('Task_TaskScheduleDaily_StartDate_FieldLabel'),
        allowBlank: false,
        format: 'm/d/Y',
        value: new Date(),
        submitValue: false
      },
      {
        xtype: 'timefield',
        name: 'startTime',
        itemId: 'startTime',
        fieldLabel: NX.I18n.get('Task_TaskScheduleDaily_Recurring_FieldLabel'),
        helpText: 'The time this task should start on days it will run in your time zone ' +
            NX.util.DateFormat.getTimeZone() + '.',
        allowBlank: false,
        format: 'H:i',
        submitValue: false
      },
      {
        xtype: 'checkboxgroup',
        fieldLabel: NX.I18n.get('Task_TaskScheduleMonthly_Days_FieldLabel'),
        allowBlank: false,
        blankText: NX.I18n.get('Task_TaskScheduleMonthly_Days_BlankText'),
        items: {
          xtype: 'panel',
          layout: 'column',
          items: columns
        }
      }
    ];

    me.callParent();
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Task feature panel.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.task.TaskFeature', {
  extend: 'NX.view.drilldown.Drilldown',
  alias: 'widget.nx-coreui-task-feature',
  requires: [
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function() {
    Ext.apply(this, {
      iconName: 'task-default',

      masters: [
        { xtype: 'nx-coreui-task-list' }
      ],

      tabs: [
        {
          xtype: 'nx-coreui-task-summary',
          weight: 10
        }
      ],

      nxActions: [
        {
          xtype: 'button',
          text: NX.I18n.get('Task_TaskFeature_Delete_Button'),
          glyph: 'xf1f8@FontAwesome' /* fa-trash */,
          action: 'delete',disabled: true
        },
        {
          xtype: 'button',
          text: NX.I18n.get('Task_TaskFeature_Run_Button'),
          glyph: 'xf04b@FontAwesome' /* fa-play */,
          action: 'run',
          handler: function(button) {
            button.fireEvent('runaction');
          },
          disabled: true
        },
        {
          xtype: 'button',
          text: NX.I18n.get('Task_TaskFeature_Stop_Button'),
          glyph: 'xf04d@FontAwesome' /* fa-stop */,
          action: 'stop',
          handler: function(button) {
            button.fireEvent('runaction');
          },
          disabled: true
        }
      ]
    });

    this.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Task Schedule Weekly field set.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.task.TaskScheduleWeekly', {
  extend: 'NX.coreui.view.task.TaskScheduleFields',
  alias: 'widget.nx-coreui-task-schedule-weekly',
  requires: [
    'NX.util.DateFormat',
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function () {
    var me = this,
        weekDays = ['sunday', 'monday', 'tuesday', 'wednesday', 'thursday', 'friday', 'saturday'],
        days = [];

    Ext.Array.each(weekDays, function (day)
    {
      days.push({
        xtype: 'checkbox',
        name: 'recurringDay-' + (weekDays.indexOf(day) + 1),
        boxLabel: Ext.String.capitalize(day),
        recurringDayValue: weekDays.indexOf(day) + 1,
        submitValue: false
      });
    });

    me.items = [
      {
        xtype: 'datefield',
        name: 'startDate',
        itemId: 'startDate',
        fieldLabel: NX.I18n.get('Task_TaskScheduleDaily_StartDate_FieldLabel'),
        allowBlank: false,
        format: 'm/d/Y',
        value: new Date(),
        submitValue: false
      },
      {
        xtype: 'timefield',
        name: 'startTime',
        itemId: 'startTime',
        fieldLabel: NX.I18n.get('Task_TaskScheduleDaily_Recurring_FieldLabel'),
        helpText: 'The time this task should start on days it will run in your time zone ' +
            NX.util.DateFormat.getTimeZone() + '.',
        allowBlank: false,
        format: 'H:i',
        submitValue: false
      },
      {
        xtype: 'checkboxgroup',
        fieldLabel: NX.I18n.get('Task_TaskScheduleMonthly_Days_FieldLabel'),
        allowBlank: false,
        blankText: NX.I18n.get('Task_TaskScheduleMonthly_Days_BlankText'),
        vertical: true,
        columns: 1,
        items: days
      }
    ];

    me.callParent();
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Add task window.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.task.TaskAdd', {
  extend: 'NX.view.AddPanel',
  alias: 'widget.nx-coreui-task-add',
  requires: [
    'NX.Conditions',
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    me.settingsForm = {
      xtype: 'nx-coreui-task-settings-form',
      editableCondition: NX.Conditions.isPermitted('nexus:tasks:create'),
      editableMarker: NX.I18n.get('Task_TaskAdd_Create_Error'),

      buttons: [
        { text: NX.I18n.get('Task_TaskList_New_Button'), action: 'add', formBind: true, ui: 'nx-primary' },
        { text: NX.I18n.get('Add_Cancel_Button'), action: 'back' }
      ]
    };

    me.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Task Schedule FieldSet.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.task.TaskScheduleFieldSet', {
  extend: 'Ext.form.FieldContainer',
  alias: 'widget.nx-coreui-task-schedulefieldset',
  requires: [
    'NX.I18n'
  ],

  autoHeight: false,
  autoScroll: true,
  collapsed: false,
  defaults: {
    allowBlank: false
  },

  initComponent: function() {
    var me = this;

    me.items = [
      {
        xtype: 'combo',
        name: 'schedule',
        itemId: 'schedule',
        fieldLabel: NX.I18n.get('Task_TaskScheduleFieldSet_Recurrence_FieldLabel'),
        helpText: NX.I18n.get('Task_TaskScheduleFieldSet_Recurrence_HelpText'),
        emptyText: NX.I18n.get('Task_TaskScheduleFieldSet_Recurrence_EmptyText'),
        editable: false,
        store: [
          ['manual', NX.I18n.get('Task_TaskScheduleFieldSet_Recurrence_ManualItem')],
          ['once', NX.I18n.get('Task_TaskScheduleFieldSet_Recurrence_OnceItem')],
          ['hourly', NX.I18n.get('Task_TaskScheduleFieldSet_Recurrence_HourlyItem')],
          ['daily', NX.I18n.get('Task_TaskScheduleFieldSet_Recurrence_DailyItem')],
          ['weekly', NX.I18n.get('Task_TaskScheduleFieldSet_Recurrence_WeeklyItem')],
          ['monthly', NX.I18n.get('Task_TaskScheduleFieldSet_Recurrence_MonthlyItem')],
          ['advanced', NX.I18n.get('Task_TaskScheduleFieldSet_Recurrence_AdvancedItem')]
        ],
        queryMode: 'local',
        listeners: {
          change: function (combo, newValue, oldValue) {
            var form = combo.up('form');

            var taskScheduleFields = me.down('nx-coreui-task-schedule-fields');
            if (taskScheduleFields) {
              taskScheduleFields.up().remove(taskScheduleFields);
            }

            if (newValue && newValue !== 'internal') {
              combo.ownerCt.add({ xtype: 'nx-coreui-task-schedule-' + newValue });
              form.getForm().checkValidity();
              form.isValid();
            }
          }
        }
      }
    ];

    me.callParent();

  },

  /**
   * @public
   * Exports recurring days.
   * @returns {Array} recurring
   */
  getRecurringDays: function () {
    var me = this,
        days = me.query('checkbox[recurringDayValue]'),
        recurringDays = [];

    Ext.Array.each(days, function (day) {
      if (day.value) {
        recurringDays.push(day.recurringDayValue);
      }
    });

    return recurringDays;
  },

  /**
   * @public
   * Returns start date out of start date/time.
   * @returns {Date} start date
   */
  getStartDate: function () {
    var me = this,
        startDate = me.down('#startDate'),
        startTime = me.down('#startTime');

    if (startDate && startTime) {
      startDate = startDate.getValue();
      startTime = startTime.getValue();
      if (startDate && startTime) {
        startDate.setHours(startTime.getHours(), startTime.getMinutes(), 0, 0);
      }
    }
    return startDate;
  },

  /**
   * @public
   * Set values of start date and time
   */
  setStartDate: function(date) {
    var me = this,
      startDate = me.down('#startDate'),
      startTime = me.down('#startTime');

    if (startDate && startTime) {
      startDate.setValue(date);
      startTime.setValue(date);

      // startTime is not part of the form data load and therefore is marked 'dirty' otherwise
      startTime.resetOriginalValue();
    }
  },

  /**
   * @public
   * Set values of recurring days checkboxes
   */
  setRecurringDays: function(recurringDays) {
    var me = this;

    Ext.Array.each(recurringDays, function(day) {
      var checkbox = me.down('checkbox[name=recurringDay-' + day + ']');
      if (checkbox) {
        checkbox.setValue(true);
        //checkboxes are not part of the form data load and therefore is marked 'dirty' otherwise
        checkbox.resetOriginalValue();
      }
    });
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Select task type window.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.task.TaskSelectType', {
  extend: 'NX.view.drilldown.Master',
  alias: 'widget.nx-coreui-task-selecttype',
  requires: [
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function() {
    var me = this;

    me.columns = [
      {
        xtype: 'nx-iconcolumn',
        width: 36,
        iconVariant: 'x16',
        iconName: function() {
          return 'task-default';
        }
      },
      { header: NX.I18n.get('Task_TaskSelectType_Name_Header'), dataIndex: 'name', flex: 1 }
    ];

    me.plugins = [
      { ptype: 'gridfilterbox', emptyText: NX.I18n.get('Task_TaskSelectType_Filter_EmptyText') }
    ];

    me.store = Ext.create('NX.coreui.store.TaskType');
    me.store.addFilter([
      { property: 'exposed', value: true }
    ], false);

    // Add a white background behind the filter, to make it look like part of the header
    me.dockedItems = [
      {
        xtype: 'nx-actions'
      }
    ];

    me.callParent();
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Task "Status" panel.
 *
 * @since 3.1
 */
Ext.define('NX.coreui.view.task.TaskStatus', {
  extend: 'Ext.panel.Panel',
  alias: 'widget.nx-coreui-task-status',
  ui: 'nx-inset',
  requires: [
    'NX.I18n'
  ],

  initComponent: function() {
    var me = this;

    me.items = {
      xtype: 'grid',
          columns: [
        { text: NX.I18n.get('TaskFeature_Status_Node_Column'), dataIndex: 'nodeId', width: 400},
        { text: NX.I18n.get('TaskFeature_Status_Status_Column'), dataIndex: 'statusDescription', width: 200 },
        { text: NX.I18n.get('TaskFeature_Status_LastResult_Column'), dataIndex: 'lastRunResult', flex: 1 }
      ]
    };

    me.callParent();
  },

  getGrid: function() {
    var me = this;
    return me.down('grid');
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Tasks controller.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.controller.Tasks', {
  extend: 'NX.controller.Drilldown',
  requires: [
    'NX.view.info.Panel',
    'NX.view.info.Entry',
    'NX.Conditions',
    'NX.Dialogs',
    'NX.Messages',
    'NX.Permissions',
    'NX.I18n'
  ],
  masters: [
    'nx-coreui-task-list'
  ],
  stores: [
    'Task',
    'TaskType'
  ],
  models: [
    'Task'
  ],
  views: [
    'task.TaskAdd',
    'task.TaskFeature',
    'task.TaskList',
    'task.TaskSelectType',
    'task.TaskScheduleFieldSet',
    'task.TaskScheduleFields',
    'task.TaskScheduleAdvanced',
    'task.TaskScheduleDaily',
    'task.TaskScheduleHourly',
    'task.TaskScheduleManual',
    'task.TaskScheduleMonthly',
    'task.TaskScheduleOnce',
    'task.TaskScheduleWeekly',
    'task.TaskSummary',
    'task.TaskStatus',
    'task.TaskSettings',
    'task.TaskSettingsForm',
    'formfield.SettingsFieldSet'
  ],
  refs: [
    { ref: 'feature', selector: 'nx-coreui-task-feature' },
    { ref: 'content', selector: 'nx-feature-content' },
    { ref: 'list', selector: 'nx-coreui-task-list' },
    { ref: 'summary', selector: 'nx-coreui-task-summary' },
    { ref: 'settings', selector: 'nx-coreui-task-settings' }
  ],
  icons: {
    'task-default': {
      file: 'time.png',
      variants: ['x16', 'x32']
    }
  },

  permission: 'nexus:tasks',

  /**
   * @override
   */
  init: function() {
    var me = this;

    me.features = {
      mode: 'admin',
      path: '/System/Tasks',
      text: NX.I18n.get('Tasks_Text'),
      description: NX.I18n.get('Tasks_Description'),
      view: {xtype: 'nx-coreui-task-feature'},
      iconConfig: {
        file: 'time.png',
        variants: ['x16', 'x32']
      },
      visible: function() {
        return NX.Permissions.check('nexus:tasks:read');
      }
    };

    me.callParent();

    me.listen({
      store: {
        '#Task': {
          load: me.reselect
        }
      },
      controller: {
        '#Refresh': {
          refresh: me.loadStores
        }
      },
      component: {
        'nx-coreui-task-list': {
          beforerender: me.loadStores
        },
        'nx-coreui-task-list button[action=new]': {
          click: me.showSelectTypePanel
        },
        'nx-coreui-task-feature button[action=run]': {
          runaction: me.runTask,
          afterrender: me.bindRunButton
        },
        'nx-coreui-task-feature button[action=stop]': {
          runaction: me.stopTask,
          afterrender: me.bindStopButton
        },
        'nx-coreui-task-settings button[action=save]': {
          click: me.updateTask
        },
        'nx-coreui-task-add button[action=add]': {
          click: me.createTask
        },
        'nx-coreui-task-selecttype': {
          cellclick: me.showAddPanel
        }
      }
    });
  },

  /**
   * @override
   * Returns a description of task suitable to be displayed.
   * @param {NX.coreui.model.Task} model selected model
   */
  getDescription: function(model) {
    return model.get('name') + ' (' + model.get('typeName') + ')';
  },

  /**
   * @override
   * Load task model into detail tabs.
   * @param {NX.coreui.view.task.TaskList} list task grid
   * @param {NX.coreui.model.Task} model selected model
   */
  onSelection: function(list, model) {
    var me = this,
        settings = me.getSettings(),
        taskTypeModel,
        taskTypeStore = me.getStore('TaskType');

    if (Ext.isDefined(model)) {
      me.showSummary(model);
      if (!taskTypeStore.isLoaded()) {
        taskTypeStore.on('load', function() {
          me.onSelection(list, model);
        }, me, {single: true});
        return;
      }
      taskTypeModel = taskTypeStore.getById(model.get('typeId'));
      if (taskTypeModel) {
        if (!settings) {
          me.addTab({ xtype: 'nx-coreui-task-settings', title: NX.I18n.get('Tasks_Settings_Title'), weight: 20 });
        }
        me.showSettings(model);
      }
      else {
        if (settings) {
          me.removeTab(settings);
        }
      }
    }
  },

  /**
   * @private
   * Displays task summary.
   * @param {NX.coreui.model.Task} model task model
   */
  showSummary: function(model) {
    var info = {},
        me = this,
        summary = me.getSummary();

    info[NX.I18n.get('Tasks_ID_Info')] = model.getId();
    info[NX.I18n.get('Tasks_Name_Info')] = model.get('name');
    info[NX.I18n.get('Tasks_Type_Info')] = model.get('typeName');
    info[NX.I18n.get('Tasks_Status_Info')] = model.get('statusDescription');
    info[NX.I18n.get('Tasks_NextRun_Info')] = model.get('nextRun');
    info[NX.I18n.get('Tasks_LastRun_Info')] = model.get('lastRun');
    info[NX.I18n.get('Tasks_LastResult_Info')] = model.get('lastRunResult');

    summary.showInfo(info);
    me.maybeShowSummaryStatuses(model);
  },

  /**
   * @private
   * Displays task status summary if there are clustered task states.
   * @param model the task model to get states from
   */
  maybeShowSummaryStatuses: function(model) {
    var me = this;

    if (!model.clusteredTaskStatesStore) {
      me.getSummary().getStatuses().hide();
    }
    else {
      me.getSummary().getStatuses().show();
      me.getSummary().getStatuses().getGrid().reconfigure(model.clusteredTaskStatesStore);
    }
  },

  /**
   * @private
   * Displays task settings.
   * @param {NX.coreui.model.Task} model task model
   */
  showSettings: function(model) {
    this.getSettings().loadRecord(model);
  },

  /**
   * @private
   */
  showSelectTypePanel: function() {
    var me = this;

    //clear any filters that may previously have been applied
    me.getStore('TaskType').clearFilter();

    // Show the first panel in the create wizard, and set the breadcrumb
    me.setItemName(1, NX.I18n.get('Tasks_Select_Title'));
    me.loadCreateWizard(1, Ext.widget({
      xtype: 'panel',
      layout: {
        type: 'vbox',
        align: 'stretch'
      },
      items: {
        xtype: 'nx-coreui-task-selecttype',
        flex: 1
      }
    }));
  },

  /**
   * @private
   */
  showAddPanel: function(list, td, cellIndex, model) {
    var me = this,
      panel;

    // Show the second panel in the create wizard, and set the breadcrumb
    me.setItemName(2, NX.I18n.format('Tasks_Create_Title', model.get('name')));
    me.loadCreateWizard(2, panel = Ext.widget({
      xtype: 'panel',
      layout: {
        type: 'vbox',
        align: 'stretch',
        pack: 'start'
      },
      items: [
        {
          xtype: 'nx-coreui-task-add',
          flex: 1
        }
      ]
    }));
    panel.down('nx-settingsform').loadRecord(me.getTaskModel().create({typeId: model.getId(), enabled: true}));
  },

  /**
   * @private
   */
  updateTask: function(button) {
    var me = this,
      form = button.up('form'),
      values = form.getValues();

    me.getContent().getEl().mask(NX.I18n.get('Tasks_Update_Mask'));
    NX.direct.coreui_Task.update(values, function(response) {
      me.getContent().getEl().unmask();
      if (Ext.isObject(response)) {
        if (response.success) {
          NX.Messages.add({
            text: NX.I18n.format('Tasks_Update_Success',
              me.getDescription(me.getTaskModel().create(response.data))),
            type: 'success'
          });
          form.fireEvent('submitted', form);
          me.getStore('Task').load();
        }
        else if (Ext.isDefined(response.errors)) {
          form.markInvalid(response.errors);
        }
      }
    });
  },

  /**
   * @private
   */
  createTask: function(button) {
    var me = this,
      form = button.up('form'),
      values = form.getValues();

    NX.direct.coreui_Task.create(values, function(response) {
      if (Ext.isObject(response)) {
        if (response.success) {
          NX.Messages.add({
            text: NX.I18n.format('Tasks_Create_Success',
              me.getDescription(me.getTaskModel().create(response.data))),
            type: 'success'
          });
          me.getStore('Task').load();
        }
        else if (Ext.isDefined(response.errors)) {
          form.markInvalid(response.errors);
        }
      }
    });
  },

  /**
   * @override
   * @protected
   * Enable 'New' when user has 'create' permission and there is at least one task type.
   */
  bindNewButton: function(button) {
    button.mon(
        NX.Conditions.and(
            NX.Conditions.isPermitted('nexus:tasks:create'),
            NX.Conditions.storeHasRecords('TaskType')
        ),
        {
          satisfied: function () {
            button.enable();
          },
          unsatisfied: function () {
            button.disable();
          }
        }
    );
  },

  /**
   * @override
   * @private
   * Enable 'Run' when user has 'read' permission and task is 'runnable'.
   */
  bindRunButton: function(button) {
    var me = this;
    button.mon(
        NX.Conditions.and(
            NX.Conditions.isPermitted('nexus:tasks:start'),
            NX.Conditions.watchEvents(me.getObservables(), me.watchEventsHandler({run: true}))
        ),
        {
          satisfied: function () {
            button.enable();
          },
          unsatisfied: function () {
            button.disable();
          }
        }
    );
  },

  /**
   * @override
   * @private
   * Enable 'Stop' when user has 'delete' permission and task is 'stoppable'.
   */
  bindStopButton: function(button) {
    var me = this;
    button.mon(
        NX.Conditions.and(
            NX.Conditions.isPermitted('nexus:tasks:stop'),
            NX.Conditions.watchEvents(me.getObservables(), me.watchEventsHandler({stop: true}))
        ),
        {
          satisfied: function () {
            button.enable();
          },
          unsatisfied: function () {
            button.disable();
          }
        }
    );
  },

  /**
   * @private
   */
  getObservables: function () {
    var me = this;
    return [
      { observable: me.getStore('Task'), events: ['load']},
      { observable: Ext.History, events: ['change']}
    ];
  },

  /**
   * @private
   */
  watchEventsHandler: function (options) {
    var me = this,
        store = me.getStore('Task');

    return function() {
      var taskId = me.getModelIdFromBookmark(),
          model = taskId ? store.findRecord('id', taskId, 0, false, true, true) : undefined;

      if (model) {
        if (options.run) {
          return model.get('runnable');
        }
        else if (options.stop) {
          return model.get('stoppable');
        }
      }

      return false;
    };
  },

  /**
   * @override
   * Delete task.
   * @param model task to be deleted
   */
  deleteModel: function(model) {
    var me = this,
        description = me.getDescription(model);

    NX.direct.coreui_Task.remove(model.getId(), function(response) {
      me.getStore('Task').load();
      if (Ext.isObject(response) && response.success) {
        NX.Messages.add({
          text: NX.I18n.format('Tasks_Delete_Success', description), type: 'success'
        });
      }
    });
  },

  /**
   * @override
   * Run selected task.
   */
  runTask: function() {
    var me = this,
        bookmark = NX.Bookmarks.getBookmark(),
        model, modelId, description;

    // Reload the form
    me.getStore('Task').load();

    modelId = decodeURIComponent(bookmark.getSegment(1));
    model = me.getList().getStore().getById(modelId);
    description = me.getDescription(model);

    if (model) {
      if (model.data.enabled) {
        description = me.getDescription(model);
        NX.Dialogs.askConfirmation(NX.I18n.get('Tasks_RunConfirm_Title'),
            NX.I18n.format('Tasks_RunConfirm_HelpText', description), function() {
              me.getContent().getEl().mask(NX.I18n.get('Tasks_Run_Mask'));
              NX.direct.coreui_Task.run(model.getId(), function(response) {
                me.getContent().getEl().unmask();
                if (Ext.isObject(response) && response.success) {
                  me.getStore('Task').load();
                  NX.Messages.add({
                    text: NX.I18n.format('Tasks_Run_Success', description), type: 'success'
                  });
                }
              });
            }, {scope: me});
      }
      else {
        NX.Messages.warning(NX.I18n.get('Tasks_Run_Disabled'));
      }
    }
  },

  /**
   * @override
   * Stop selected task.
   */
  stopTask: function() {
    var me = this,
      bookmark = NX.Bookmarks.getBookmark(),
      model, modelId, description;

    // Reload the form
    me.getStore('Task').load();

    modelId = decodeURIComponent(bookmark.getSegment(1));
    model = me.getList().getStore().getById(modelId);
    description = me.getDescription(model);

    if (model) {
      description = me.getDescription(model);
      NX.Dialogs.askConfirmation(NX.I18n.get('Tasks_StopConfirm_Title'),
        NX.I18n.format('Tasks_StopConfirm_HelpText', description), function() {
        me.getContent().getEl().mask(NX.I18n.get('Tasks_Stop_Mask'));
        NX.direct.coreui_Task.stop(model.getId(), function(response) {
          me.getContent().getEl().unmask();
          if (Ext.isObject(response) && response.success) {
            me.getStore('Task').load();
            NX.Messages.add({
              text: NX.I18n.format('Tasks_Stop_Success', description), type: 'success'
            });
          }
        });
      }, { scope: me });
    }
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Repository "Settings" form for a bower Hosted repository.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.repository.recipe.BowerHosted', {
  extend: 'NX.coreui.view.repository.RepositorySettingsForm',
  alias: 'widget.nx-coreui-repository-bower-hosted',
  requires: [
    'NX.coreui.view.repository.facet.StorageFacet',
    'NX.coreui.view.repository.facet.StorageFacetHosted',
    'NX.coreui.view.repository.facet.CleanupPolicyFacet'
  ],

  /**
   * @override
   */
  initComponent: function() {
    var me = this;

    me.items = [
      { xtype: 'nx-coreui-repository-storage-facet'},
      { xtype: 'nx-coreui-repository-storage-hosted-facet'},
      { xtype: 'nx-coreui-repository-cleanup-policy-facet'}
    ];

    me.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Ssl Certificate detail panel.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.ssl.SslCertificateDetailsPanel', {
  extend: 'NX.view.AddPanel',
  alias: 'widget.nx-coreui-sslcertificate-details-panel',
  requires: [
    'NX.Conditions',
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function() {
    Ext.apply(this, {
      settingsForm: {
        xtype: 'nx-coreui-sslcertificate-details-form',
        buttons: [
          { text: NX.I18n.get('Ssl_SslCertificateDetailsWindow_Cancel_Button'), action: 'back' }
        ]
      }
    });

    this.callParent();
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Ssl Certificate detail panel.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.ssl.SslCertificateDetailsForm', {
  extend: 'NX.view.SettingsForm',
  alias: 'widget.nx-coreui-sslcertificate-details-form',
  requires: [
    'NX.util.DateFormat',
    'NX.I18n'
  ],

  buttons: undefined,

  /**
   * @override
   */
  initComponent: function() {
    var me = this;

    me.items = [
      {
        xtype: 'panel',
        ui: 'nx-subsection',
        title: NX.I18n.get('Ssl_SslCertificateDetailsForm_Subject_Title'),
        items: {
          xtype: 'fieldset',
          margin: 0,
          padding: 0,
          defaults: {
            xtype: 'displayfield',
            labelAlign: 'left',
            renderer: Ext.htmlEncode
          },
          items: [
            { name: 'subjectCommonName', fieldLabel: NX.I18n.get('Ssl_SslCertificateDetailsForm_SubjectCommonName_FieldLabel') },
            { name: 'subjectOrganization', fieldLabel: NX.I18n.get('Ssl_SslCertificateDetailsForm_SubjectOrganization_FieldLabel') },
            { name: 'subjectOrganizationalUnit', fieldLabel: NX.I18n.get('Ssl_SslCertificateDetailsForm_SubjectUnit_FieldLabel') }
          ]
        }
      },
      {
        xtype: 'panel',
        ui: 'nx-subsection',
        title: NX.I18n.get('Ssl_SslCertificateDetailsForm_Issuer_Title'),
        items: {
          xtype: 'fieldset',
          margin: 0,
          padding: 0,
          defaults: {
            xtype: 'displayfield',
            labelAlign: 'left',
            renderer: Ext.htmlEncode
          },
          items: [
            { name: 'issuerCommonName', fieldLabel: NX.I18n.get('Ssl_SslCertificateDetailsForm_IssuerName_FieldLabel') },
            { name: 'issuerOrganization', fieldLabel: NX.I18n.get('Ssl_SslCertificateDetailsForm_IssuerOrganization_FieldLabel') },
            { name: 'issuerOrganizationalUnit', fieldLabel: NX.I18n.get('Ssl_SslCertificateDetailsForm_IssuerUnit_FieldLabel') }
          ]
        }
      },
      {
        xtype: 'panel',
        ui: 'nx-subsection',
        title: NX.I18n.get('Ssl_SslCertificateDetailsForm_Certificate_Title'),
        items: {
          xtype: 'fieldset',
          margin: 0,
          padding: '0 0 10px 0',
          defaults: {
            xtype: 'displayfield',
            labelAlign: 'left'
          },
          items: [
            {
              name: 'issuedOn',
              fieldLabel: NX.I18n.get('Ssl_SslCertificateDetailsForm_CertificateIssuedOn_FieldLabel'),
              renderer: NX.util.DateFormat.timestampRenderer()
            },
            {
              name: 'expiresOn',
              fieldLabel: NX.I18n.get('Ssl_SslCertificateDetailsForm_CertificateValidUntil_FieldLabel'),
              renderer: NX.util.DateFormat.timestampRenderer()
            },
            {
              name: 'fingerprint',
              fieldLabel: NX.I18n.get('Ssl_SslCertificateDetailsForm_CertificateFingerprint_FieldLabel')
            }
          ]
        }
      }
    ];

    me.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Ssl Certificate grid.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.ssl.SslCertificateList', {
  extend: 'NX.view.drilldown.Master',
  alias: 'widget.nx-coreui-sslcertificate-list',
  requires: [
    'NX.Icons',
    'NX.I18n'
  ],

  stateful: true,
  stateId: 'nx-coreui-sslcertificate-list',

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    me.store = 'SslCertificate';

    me.columns = [
      {
        xtype: 'nx-iconcolumn',
        width: 36,
        iconVariant: 'x16',
        iconName: function () {
          return 'sslcertificate-default';
        }
      },
      {
        header: NX.I18n.get('Ssl_SslCertificateList_Name_Header'),
        dataIndex: 'subjectCommonName',
        stateId: 'subjectCommonName',
        flex: 1,
        renderer: Ext.htmlEncode
      },
      {
        header: NX.I18n.get('Ssl_SslCertificateList_IssuedTo_Header'),
        dataIndex: 'subjectOrganization',
        stateId: 'subjectOrganization',
        flex: 1,
        renderer: Ext.htmlEncode
      },
      {
        header: NX.I18n.get('Ssl_SslCertificateList_IssuedBy_Header'),
        dataIndex: 'issuerOrganization',
        stateId: 'issuerOrganization',
        flex: 1,
        renderer: Ext.htmlEncode
      },
      {
        header: NX.I18n.get('Ssl_SslCertificateList_Fingerprint_Header'),
        dataIndex: 'fingerprint',
        stateId: 'fingerprint',
        flex: 1,
        renderer: Ext.htmlEncode
      }
    ];

    me.viewConfig = {
      emptyText: NX.I18n.get('Ssl_SslCertificateList_EmptyText'),
      deferEmptyText: false
    };

    me.plugins = [
      { ptype: 'gridfilterbox', emptyText: NX.I18n.get('Ssl_SslCertificateList_Filter_EmptyText') }
    ];

    me.dockedItems = [{
      xtype: 'nx-actions',
      items: [
        {
          xtype: 'button',
          text: NX.I18n.get('Ssl_SslCertificateList_New_Button'),
          glyph: 'xf055@FontAwesome' /* fa-plus-circle */,
          action: 'new',
          disabled: true,
          menu: [
            {
              text: NX.I18n.get('Ssl_SslCertificateList_Load_Button'),
              action: 'newfromserver',
              iconCls: NX.Icons.cls('sslcertificate-add-by-server', 'x16')
            },
            {
              text: NX.I18n.get('Ssl_SslCertificateList_Paste_Button'),
              action: 'newfrompem',
              iconCls: NX.Icons.cls('sslcertificate-add-by-pem', 'x16')
            }
          ]
        }
      ]
    }];

    me.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Ssl Certificate model.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.model.SslCertificate', {
  extend: 'Ext.data.Model',
  fields: [
    {name: 'id', type: 'string'},
    {name: 'fingerprint', type: 'string'},
    {name: 'pem', type: 'string'},
    {name: 'serialNumber', type: 'string'},
    {name: 'subjectCommonName', type: 'string'},
    {name: 'subjectOrganization', type: 'string'},
    {name: 'subjectOrganizationalUnit', type: 'string'},
    {name: 'issuerCommonName', type: 'string'},
    {name: 'issuerOrganization', type: 'string'},
    {name: 'issuerOrganizationalUnit', type: 'string'},
    {name: 'issuedOn', type: 'int'},
    {name: 'expiresOn', type: 'int'},
    {name: 'inTrustStore', type: 'boolean'}
  ]
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Ssl Certificate store.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.store.SslCertificate', {
  extend: 'Ext.data.Store',
  model: 'NX.coreui.model.SslCertificate',

  proxy: {
    type: 'direct',
    paramsAsHash: false,

    api: {
      read: 'NX.direct.ssl_TrustStore.read'
    },

    reader: {
      type: 'json',
      rootProperty: 'data',
      successProperty: 'success'
    }
  },

  sorters: { property: 'subjectCommonName', direction: 'ASC' }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Add Ssl Certificate from PEM window.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.ssl.SslCertificateAddFromPem', {
  extend: 'NX.view.AddPanel',
  alias: 'widget.nx-coreui-sslcertificate-add-from-pem',
  requires: [
    'NX.Icons',
    'NX.I18n'
  ],

  defaultFocus: 'pem',

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    me.settingsForm = {
      xtype: 'nx-settingsform',

      items: [
        {
          xtype: 'textareafield',
          name: 'pem',
          itemId: 'pem',
          cls: 'nx-monospace-field',
          height: '16rem'
        }
      ],

      buttons: [
        { text: NX.I18n.get('Ssl_SslCertificateList_New_Button'), action: 'load', formBind: true, ui: 'nx-primary' },
        { text: NX.I18n.get('Ssl_SslCertificateAddFromPem_Cancel_Button'), action: 'back' }
      ]
    };

    me.callParent();
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Ssl Certificate detail window.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.ssl.SslCertificateDetailsWindow', {
  extend: 'NX.view.AddWindow',
  alias: 'widget.nx-coreui-sslcertificate-details-window',
  requires: [
    'NX.Conditions',
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function() {
    Ext.apply(this, {
      ui: 'nx-inset',

      title: NX.I18n.get('Ssl_SslCertificateDetailsWindow_Title'),

      items: {
        xtype: 'nx-coreui-sslcertificate-details-form',
        frame: false,
        buttons: [
          { text: NX.I18n.get('Ssl_SslCertificateDetailsWindow_Cancel_Button'),
            handler: function () {
              this.up('window').close();
            }
          }
        ]
      }
    });

    this.callParent();
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Ssl Certificate Set feature panel.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.ssl.SslCertificateFeature', {
  extend: 'NX.view.drilldown.Drilldown',
  alias: 'widget.nx-coreui-sslcertificate-feature',
  requires: [
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function() {
    Ext.apply(this, {
      iconName: 'sslcertificate-default',

      masters: [
        { xtype: 'nx-coreui-sslcertificate-list' }
      ],

      tabs: { xtype: 'nx-coreui-sslcertificate-details' },

      nxActions: [
        { xtype: 'button', text: NX.I18n.get('Ssl_SslCertificateFeature_Delete_Button'), glyph: 'xf1f8@FontAwesome' /* fa-trash */, action: 'delete', disabled: true }
      ]
    });

    this.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Ssl Certificates controller.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.controller.SslCertificates', {
  extend: 'NX.controller.Drilldown',
  requires: [
    'NX.Messages',
    'NX.Permissions',
    'NX.I18n'
  ],
  masters: [
    'nx-coreui-sslcertificate-list'
  ],
  models: [
    'SslCertificate'
  ],
  stores: [
    'SslCertificate'
  ],
  views: [
    'ssl.SslCertificateAddFromPem',
    'ssl.SslCertificateAddFromServer',
    'ssl.SslCertificateDetails',
    'ssl.SslCertificateDetailsForm',
    'ssl.SslCertificateDetailsPanel',
    'ssl.SslCertificateDetailsWindow',
    'ssl.SslCertificateFeature',
    'ssl.SslCertificateList'
  ],
  refs: [
    { ref: 'feature', selector: 'nx-coreui-sslcertificate-feature' },
    { ref: 'content', selector: 'nx-feature-content' },
    { ref: 'list', selector: 'nx-coreui-sslcertificate-list' },
    { ref: 'details', selector: 'nx-coreui-sslcertificate-feature nx-coreui-sslcertificate-details-form' }
  ],
  icons: {
    'sslcertificate-default': {
      file: 'ssl_certificates.png',
      variants: ['x16', 'x32']
    },
    'sslcertificate-add-by-pem': {
      file: 'server_add.png',
      variants: ['x16', 'x32']
    },
    'sslcertificate-add-by-server': {
      file: 'server_connect.png',
      variants: ['x16', 'x32']
    }
  },

  permission: 'nexus:ssl-truststore',

  /**
   * @override
   */
  init: function () {
    var me = this;

    me.features = {
      mode: 'admin',
      path: '/Security/SSL Certificates',
      view: {xtype: 'nx-coreui-sslcertificate-feature'},
      text: NX.I18n.get('SslCertificates_Text'),
      description: NX.I18n.get('SslCertificates_Description'),
      iconConfig: {
        file: 'ssl_certificates.png',
        variants: ['x16', 'x32']
      },
      visible: function() {
        return NX.Permissions.check('nexus:ssl-truststore:read');
      }
    };

    me.callParent();

    me.listen({
      controller: {
        '#Refresh': {
          refresh: me.loadStores
        }
      },
      store: {
        '#SslCertificate': {
          load: me.reselect
        }
      },
      component: {
        'nx-coreui-sslcertificate-list menuitem[action=newfromserver]': {
          click: me.showAddWindowFromServer
        },
        'nx-coreui-sslcertificate-list menuitem[action=newfrompem]': {
          click: me.showAddWindowFromPem
        },
        'nx-coreui-sslcertificate-add-from-pem button[action=load]': {
          click: me.loadCertificateByPem
        },
        'nx-coreui-sslcertificate-add-from-server button[action=load]': {
          click: me.loadCertificateByServer
        },
        'nx-coreui-sslcertificate-details-panel button[action=add]': {
          click: me.create
        },
        'nx-coreui-sslcertificate-details-panel button[action=remove]': {
          click: me.onRemoveClick
        },
        'nx-coreui-sslcertificate-details-window button[action=add]': {
          click: me.create
        },
        'nx-coreui-sslcertificate-details-window button[action=remove]': {
          click: me.onRemoveClick
        }
      }
    });
  },

  /**
   * @override
   */
  getDescription: function (model) {
    return model.get('subjectCommonName');
  },

  /**
   * @override
   */
  onSelection: function (list, model) {
    if (Ext.isDefined(model)) {
      this.getDetails().loadRecord(model);
    }
  },

  /**
   * @private
   */
  showAddWindowFromServer: function () {
    var me = this;

    // Show the first panel in the create wizard, and set the breadcrumb
    me.setItemName(1, NX.I18n.get('SslCertificates_Load_Title'));
    me.loadCreateWizard(1, Ext.create('widget.nx-coreui-sslcertificate-add-from-server'));
  },

  /**
   * @private
   */
  showAddWindowFromPem: function () {
    var me = this;

    // Show the first panel in the create wizard, and set the breadcrumb
    me.setItemName(1, NX.I18n.get('SslCertificates_Paste_Title'));
    me.loadCreateWizard(1, Ext.create('widget.nx-coreui-sslcertificate-add-from-pem'));
  },

  /**
   * @private
   * Shows certificate details panel.
   */
  showCertificateDetailsPanel: function(certificate) {
    var me = this,
        panel = Ext.widget('nx-coreui-sslcertificate-details-panel'),
        form = panel.down('form'),
        model = me.getSslCertificateModel().create(certificate);

    // override form to show buttons
    me.overrideLoadRecord(form);
    // Load the certificate
    form.loadRecord(model);

    // Show the second panel in the create wiard, and set the breadcrumb
    me.setItemName(2, NX.I18n.get('Ssl_SslCertificateDetailsWindow_Title'));
    me.loadCreateWizard(2, panel);
  },

  /**
   * @private
   * Shows certificate details window.
   */
  showCertificateDetailsWindow: function (certificate) {
    var me = this,
        window = Ext.widget('nx-coreui-sslcertificate-details-window'),
        form = window.down('form'),
        model = me.getSslCertificateModel().create(certificate);

    // override form to show buttons
    me.overrideLoadRecord(form);
    // Load the certificate
    form.loadRecord(model);
  },

  /**
   * @private
   * Retrieves details of a certificate specified by PEM, showing the certificate details if successful.
   */
  loadCertificateByPem: function (button) {
    var me = this,
        basicForm = button.up('form').getForm(),
        pem = basicForm.getFieldValues()['pem'];

    me.getContent().getEl().mask(NX.I18n.get('SslTrustStore_Load_Mask'));
    NX.direct.ssl_Certificate.details(pem, function(response) {
      me.getContent().getEl().unmask();
      if (Ext.isObject(response)) {
        if (response.success) {
          me.showCertificateDetailsPanel(response.data);
        }
        else if (response.errors) {
          basicForm.markInvalid(response.errors);
        }
      }
    });
  },

  /**
   * @private
   * Retrieves certificate from host, showing the certificate details if successful.
   */
  loadCertificateByServer: function (button) {
    var me = this,
        server = button.up('form').getForm().getFieldValues()['server'],
        parsed = me.parseHostAndPort(server),
        protocolHint = server && Ext.String.startsWith(server, "https://") ? 'https' : undefined;

    me.getContent().getEl().mask(NX.I18n.get('SslTrustStore_Load_Mask'));
    NX.direct.ssl_Certificate.retrieveFromHost(parsed[0], parsed[1], protocolHint, function (response) {
      me.getContent().getEl().unmask();
      if (Ext.isObject(response) && response.success) {
        me.showCertificateDetailsPanel(response.data);
      }
    });
  },

  /**
   * @private
   * Parses server string into an array of [host,port].
   */
  parseHostAndPort: function (server) {
    var rx, matches;

    if (!server) {
      return [];
    }

    // neither URL nor host:port
    if (server.indexOf(":") === -1) {
      return [server];
    }

    // definitely no URL
    if (server.indexOf("/") === -1) {
      var serverPort = server.split(":");

      if (serverPort.length === 2) {
        serverPort[1] = Ext.Number.from(serverPort[1], undefined);
      }

      return serverPort;
    }

    rx = /[^:]*:\/\/([^:\/]*)(:([0-9]*))?/;
    matches = server.match(rx);
    if (matches) {
      return [matches[1], Ext.Number.from(matches[3], undefined)];
    }

    return [server];
  },

  /**
   * @private
   * Close the SSL certificate details window
   * that contains the button, if it exists.
   * @param {Ext.button.Button} button (optional)
   */
  closeCertDetailsWindowIfExists: function (button) {
    if (button) {
      var window = button.up('nx-coreui-sslcertificate-details-window');
      if (window) {
        window.close();
      }
    }
  },

  /**
   * @private
   * Creates an SSL certificate.
   */
  create: function (button) {
    var me = this,
        form = button.up('form'),
        model = form.getRecord(),
        description = me.getDescription(model);

    NX.direct.ssl_TrustStore.create(model.get('pem'), function (response) {
      me.getStore('SslCertificate').load();
      if (Ext.isObject(response) && response.success) {
        NX.Messages.add({ text: NX.I18n.format('SslCertificates_Load_Success', description), type: 'success' });
        me.closeCertDetailsWindowIfExists(button);
      }
    });
  },

  /**
   * @private
   * Deletes an SSL certificate
   */
  onRemoveClick: function (button) {
    var form = button.up('form'),
        model = form.getRecord();

    this.deleteModel(model, button);
  },

  /**
   * @private
   * @override
   * Deletes an SSL certificate.
   * @param {NX.coreui.model.SslCertificate} model to be deleted
   * @param {Ext.button.Button} button (optional)
   */
  deleteModel: function (model, button) {
    var me = this,
        description = me.getDescription(model);

    NX.direct.ssl_TrustStore.remove(model.getId(), function (response) {
      me.getStore('SslCertificate').load();
      if (Ext.isObject(response) && response.success) {
        NX.Messages.add({ text: NX.I18n.format('SslCertificates_Delete_Success', description), type: 'success' });
        me.closeCertDetailsWindowIfExists(button);
      }
    });
  },

  /**
   * @private
   * Override loadRecord() in order to show add/delete from store buttons.
   */
  overrideLoadRecord: function (form) {
    Ext.override(form, {
      loadRecord: function (model) {
        var me = this,
            tbar = me.getDockedItems('toolbar[dock="bottom"]')[0],
            button;

        if (model) {
          if (model.get('inTrustStore')) {
            tbar.insert(0, {
              text: NX.I18n.get('SslCertificates_Remove_Button'),
              action: 'remove',
              formBind: true,
              disabled: true,
              ui: 'nx-primary',
              glyph: 'xf1f8@FontAwesome' /* fa-trash */
            });
            button = tbar.down('button[action=remove]');
            me.mon(
                NX.Conditions.isPermitted('nexus:ssl-truststore:delete'),
                {
                  satisfied: function () {
                    button.enable();
                  },
                  unsatisfied: function () {
                    button.disable();
                  }
                }
            );
          }
          else {
            tbar.insert(0, {
              text: NX.I18n.get('SslCertificates_Add_Button'),
              action: 'add',
              formBind: true,
              disabled: true,
              ui: 'nx-primary',
              glyph: 'xf055@FontAwesome' /* fa-plus-circle */
            });
            button = tbar.down('button[action=add]');
            me.mon(
                NX.Conditions.isPermitted('nexus:ssl-truststore:create'),
                {
                  satisfied: function () {
                    button.enable();
                  },
                  unsatisfied: function () {
                    button.disable();
                  }
                }
            );
          }
        }
        me.callParent(arguments);
      }
    });
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Cleanup Policy Store.
 *
 * @since 3.14
 */
Ext.define('NX.coreui.store.CleanupPolicy', {
  extend: 'Ext.data.Store',
  model: 'NX.coreui.model.CleanupPolicy',

  proxy: {
    type: 'direct',

    api: {
      read: 'NX.direct.cleanup_CleanupPolicy.readByFormat'
    },

    reader: {
      type: 'json',
      rootProperty: 'data',
      successProperty: 'success'
    }
  },

  sorters: [
    { property: 'sortOrder', direction: 'DESC' },
    { property: 'name', direction: 'ASC'}
  ]
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Repository "Settings" panel.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.repository.RepositorySettings', {
  extend: 'NX.view.SettingsPanel',
  alias: 'widget.nx-coreui-repository-settings',
  requires: [
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function() {
    Ext.apply(this, {


      title: NX.I18n.get('Repository_RepositorySettings_Title'),

      settingsForm: { xtype: 'nx-coreui-repository-settings-form' },

      dockedItems: null
    });

    this.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Repository "Settings" form for a Rubygems Hosted repository.
 *
 * @since 3.1
 */
Ext.define('NX.coreui.view.repository.recipe.RubygemsHosted', {
  extend: 'NX.coreui.view.repository.RepositorySettingsForm',
  alias: 'widget.nx-coreui-repository-rubygems-hosted',
  requires: [
    'NX.Conditions',
    'NX.I18n',
    'NX.coreui.view.repository.facet.StorageFacet',
    'NX.coreui.view.repository.facet.StorageFacetHosted',
    'NX.coreui.view.repository.facet.CleanupPolicyFacet'
  ],

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    me.items = [
      {xtype: 'nx-coreui-repository-storage-facet'},
      {xtype: 'nx-coreui-repository-storage-hosted-facet'},
      {xtype: 'nx-coreui-repository-cleanup-policy-facet'}
    ];

    me.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Repository "Settings" form for a Yum Group repository.
 *
 * @since 3.11
 */
Ext.define('NX.coreui.view.repository.recipe.YumGroup', {
  extend: 'NX.coreui.view.repository.RepositorySettingsForm',
  alias: 'widget.nx-coreui-repository-yum-group',
  requires: [
    'NX.coreui.view.repository.facet.StorageFacet',
    'NX.coreui.view.repository.facet.GroupFacet'
  ],

  /**
   * @override
   */
  initComponent: function() {
    var me = this;

    me.items = [
      {xtype: 'nx-coreui-repository-storage-facet'},
      {xtype: 'nx-coreui-repository-group-facet', format: 'yum'}
    ];

    me.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Bundle store.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.store.Bundle', {
  extend: 'Ext.data.Store',
  model: 'NX.coreui.model.Bundle',

  proxy: {
    type: 'direct',
    paramsAsHash: false,
    api: {
      read: 'NX.direct.coreui_Bundle.read'
    },

    reader: {
      type: 'json',
      rootProperty: 'data',
      successProperty: 'success'
    }
  },

  sorters: { property: 'id', direction: 'ASC' }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Bundles controller.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.controller.Bundles', {
  extend: 'NX.controller.Drilldown',
  requires: [
    'NX.view.info.Panel',
    'NX.view.info.Entry',
    'NX.util.Url',
    'NX.Permissions',
    'NX.I18n'
  ],
  masters: [
    'nx-coreui-system-bundlelist'
  ],
  stores: [
    'Bundle'
  ],
  views: [
    'system.Bundles',
    'system.BundleList'
  ],
  refs: [
    { ref: 'feature', selector: 'nx-coreui-system-bundles' },
    { ref: 'list', selector: 'nx-coreui-system-bundlelist' },
    { ref: 'info', selector: 'nx-coreui-system-bundles nx-info-panel' }
  ],

  icons: {
    'bundle-default': {
      file: 'plugin.png',
      variants: ['x16', 'x32']
    }
  },

  /**
   * @override
   */
  init: function() {
    var me = this;

    me.features = {
      mode: 'admin',
      path: '/System/Bundles',
      text: NX.I18n.get('Bundles_Text'),
      description: NX.I18n.get('Bundles_Description'),
      view: 'NX.coreui.view.system.Bundles',
      iconConfig: {
        file: 'plugin.png',
        variants: ['x16', 'x32']
      },
      visible: function() {
        return NX.Permissions.check('nexus:bundles:read');
      }
    };

    me.callParent();

    me.listen({
      controller: {
        '#Refresh': {
          refresh: me.loadStores
        }
      },
      store: {
        '#Bundle': {
          load: me.reselect
        }
      }
    });
  },

  /**
   * @override
   */
  getDescription: function (model) {
    return model.get('name');
  },

  onSelection: function (list, model) {
    var me = this,
        info,
        headers;

    // TODO: Resolve better presentation

    if (Ext.isDefined(model)) {
      info = {};
      info[NX.I18n.get('Bundles_ID_Info')] = model.get('id');
      info[NX.I18n.get('Bundles_Name_Info')] = model.get('name');
      info[NX.I18n.get('Bundles_SymbolicName_Info')] = model.get('symbolicName');
      info[NX.I18n.get('Bundles_Version_Info')] = model.get('version');
      info[NX.I18n.get('Bundles_State_Info')] = model.get('state');
      info[NX.I18n.get('Bundles_Location_Info')] = model.get('location');
      info[NX.I18n.get('Bundles_StartLevel_Info')] = model.get('startLevel');
      info[NX.I18n.get('Bundles_LastModified_Info')] = model.get('lastModified');
      info[NX.I18n.get('Bundles_Fragment_Info')] = model.get('fragment');
      info[NX.I18n.get('Bundles_Fragments_Info')] = model.get('fragments');
      info[NX.I18n.get('Bundles_FragmentHosts_Info')] = model.get('fragmentHosts');

      headers = model.get('headers');
      if (headers) {
        Ext.iterate(headers, function (key, value) {
          info[NX.I18n.format('Bundles_Summary_Info', key)] = value;
        });
      }

      me.getInfo().showInfo(info);
    }
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext*/

/**
 * Privilege reference store.
 *
 * @since 3.1
 */
Ext.define('NX.coreui.store.PrivilegeReference', {
  extend: 'Ext.data.Store',
  model: 'NX.coreui.model.Reference',

  proxy: {
    type: 'direct',

    api: {
      read: 'NX.direct.coreui_Privilege.readReferences'
    },

    reader: {
      type: 'json',
      rootProperty: 'data',
      successProperty: 'success'
    }
  },
  
  sorters: { property: 'name', direction: 'ASC' }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Node model.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.model.Node', {
  extend: 'Ext.data.Model',
  idProperty: 'nodeIdentity',
  fields: [
    { name: 'nodeIdentity', type: 'string' },
    { name: 'local', type: 'bool' },
    { name: 'socketAddress', type: 'string' },
    { name: 'friendlyName', type: 'string' },
    { name: 'attributes', type: 'auto' /*object*/}
  ]
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Node store.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.store.Node', {
  extend: 'Ext.data.Store',
  model: 'NX.coreui.model.Node',

  proxy: {
    type: 'direct',
    paramsAsHash: false,
    api: {
      read: 'NX.direct.proui_Node.read'
    },

    reader: {
      type: 'json',
      rootProperty: 'data',
      successProperty: 'success'
    }
  },

  sorters: { property: 'local', direction: 'ASC' }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * User model.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.model.User', {
  extend: 'Ext.data.Model',
  idProperty: {
    name: 'id',
    convert: function(value, record) {
      return Ext.htmlEncode(record.get('userId'));
    }
  },
  fields: [
    {name: 'userId', type: 'string', sortType: 'asUCText' },
    {name: 'version', type: 'string', sortType: 'asUCText'},
    {name: 'realm', type: 'string', sortType: 'asUCText'},
    {name: 'firstName', type: 'string', sortType: 'asUCText' },
    {name: 'lastName', type: 'string', sortType: 'asUCText' },
    {name: 'email', type: 'string', sortType: 'asUCText'},
    {name: 'status', type: 'string', sortType: 'asUCText'},
    {name: 'roles', type: 'auto' /*array*/},
    {name: 'external', type: 'boolean'},
    {name: 'externalRoles', type: 'auto' /*array*/}
  ]
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Privilege "Settings" panel.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.privilege.PrivilegeSettings', {
  extend: 'NX.view.SettingsPanel',
  alias: 'widget.nx-coreui-privilege-settings',

  settingsForm: {xtype: 'nx-coreui-privilege-settings-form'}

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Privilege model.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.model.Privilege', {
  extend: 'Ext.data.Model',
  fields: [
    {name: 'id', type: 'string'},
    {name: 'version', type: 'string'},
    {name: 'name', type: 'string', sortType: 'asUCText'},
    {name: 'description', type: 'string', sortType: 'asUCText', convert: Ext.htmlEncode},
    {name: 'type', type: 'string', sortType: 'asUCText'},
    {name: 'readOnly', type: 'boolean'},
    {name: 'properties', type: 'auto' /*object*/},
    {name: 'permission', type: 'string', sortType: 'asUCText', convert: Ext.htmlEncode}
  ]
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Privilege store.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.store.Privilege', {
  extend: 'Ext.data.Store',
  model: 'NX.coreui.model.Privilege',

  proxy: {
    type: 'direct',

    api: {
      read: 'NX.direct.coreui_Privilege.read'
    },

    reader: {
      type: 'json',
      rootProperty: 'data',
      successProperty: 'success'
    }
  },

  buffered: true,
  pageSize: 300,
  trailingBufferZone: 20,
  leadingBufferZone: 50,

  remoteFilter: true,
  remoteSort: true,
  
  sorters: { property: 'name', direction: 'ASC' }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * REST API
 *
 * @since 3.6
 */
Ext.define('NX.coreui.view.system.Api', {
  extend: 'Ext.container.Container',
  alias: 'widget.nx-rest-api',
  requires: [
    'NX.Icons'
  ],

  cls: 'nx-iframe-full',
  width: '100%',
  layout: 'fit'
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Rubygems repository search contribution.
 *
 * @since 3.1
 */
Ext.define('NX.coreui.controller.SearchRubygems', {
  extend: 'NX.app.Controller',
  requires: [
    'NX.I18n'
  ],

  /**
   * @override
   */
  init: function() {
    var me = this,
        search = me.getController('NX.coreui.controller.Search');

    search.registerCriteria([
      {
        id: 'assets.attributes.rubygems.platform',
        group: NX.I18n.get('SearchRubygems_Group'),
        config: {
          format: 'rubygems',
          fieldLabel: NX.I18n.get('SearchRubygems_Platform_FieldLabel'),
          width: 250
        }
      },
      {
        id: 'assets.attributes.rubygems.summary',
        group: NX.I18n.get('SearchRubygems_Group'),
        config: {
          format: 'rubygems',
          fieldLabel: NX.I18n.get('SearchRubygems_Summary_FieldLabel'),
          width: 250
        }
      },
      {
        id: 'assets.attributes.rubygems.description',
        group: NX.I18n.get('SearchRubygems_Group'),
        config: {
          format: 'rubygems',
          fieldLabel: NX.I18n.get('SearchRubygems_Description_FieldLabel'),
          width: 250
        }
      }
    ], me);

    search.registerFilter({
      id: 'rubygems',
      name: 'Rubygems',
      text: NX.I18n.get('SearchRubygems_Text'),
      description: NX.I18n.get('SearchRubygems_Description'),
      readOnly: true,
      criterias: [
        { id: 'format', value: 'rubygems', hidden: true },
        { id: 'name.raw' },
        { id: 'version' },
        { id: 'assets.attributes.rubygems.platform' },
        { id: 'assets.attributes.rubygems.summary' },
        { id: 'assets.attributes.rubygems.description' }
      ]
    }, me);
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * @since 3.0
 */
Ext.define('NX.coreui.view.repository.facet.DockerConnectorFacet', {
  extend: 'Ext.form.FieldContainer',
  alias: 'widget.nx-coreui-repository-docker-connector-facet',
  requires: [
    'NX.I18n',
    'NX.State'
  ],

  /**
   * @override
   */
  initComponent: function() {
    var me = this;

    me.items = [
      {
        xtype: 'fieldset',
        itemId: 'dockerConnectors',
        cls: 'nx-form-section',
        title: NX.I18n.get('Repository_Facet_DockerConnectorFacet_Title'),
        width: 600,

        items: [
          {
            xtype: 'panel',
            layout: {
              type: 'hbox',
              align: 'center',
              pack: 'center'
            },
            items: [
              {
                xtype: 'panel',
                bodypadding: '10px',
                width: '85%',
                html: NX.I18n.get('Repository_Facet_DockerConnectorFacet_Help')
              }
            ]
          },
          {
            xtype: 'fieldcontainer',
            fieldLabel: NX.I18n.get('Repository_Facet_DockerConnectorFacet_HttpPort_FieldLabel'),
            helpText: NX.I18n.get('Repository_Facet_DockerConnectorFacet_HttpPort_HelpText'),
            layout: 'hbox',
            items: [
              me.createCheckbox('http'),
              me.createPort('http')
            ]
          },
          {
            xtype: 'fieldcontainer',
            fieldLabel: NX.I18n.get('Repository_Facet_DockerConnectorFacet_HttpsPort_FieldLabel'),
            helpText: NX.I18n.get('Repository_Facet_DockerConnectorFacet_HttpsPort_HelpText'),
            layout: 'hbox',
            items: [
              me.createCheckbox('https'),
              me.createPort('https')
            ]
          },
          {
            xtype: 'checkbox',
            name: 'attributes.docker.forceBasicAuth',
            fieldLabel: NX.I18n.get('Repository_Facet_DockerProxyFacet_BasicAuth_FieldLabel'),
            helpText: NX.I18n.get('Repository_Facet_DockerProxyFacet_BasicAuth_BoxLabel'),
            value: false
          }
        ]
      }
    ];

    Ext.override(me.up('form'), {
      doGetValues: function(values) {
        var processed = { attributes: {} };

        Ext.Object.each(values, function(key, value) {
          if (key === 'attributes.docker.forceBasicAuth') {
            value = !value;
          }

          var segments = key.split('.'),
              parent = processed;

          Ext.each(segments, function(segment, pos) {
            if (pos === segments.length - 1) {
              parent[segment] = value;
            }
            else {
              if (!parent[segment]) {
                parent[segment] = {};
              }
              parent = parent[segment];
            }
          });
        });

        return processed;
      },

      doSetValues: function(values) {
        var process = function(child, prefix) {
          Ext.Object.each(child, function(key, value) {
            var newPrefix = (prefix ? prefix + '.' : '') + key;

            if (newPrefix === 'attributes.docker.forceBasicAuth') {
              value = !value;
            }

            if (Ext.isObject(value)) {
              process(value, newPrefix);
            }
            else {
              values[newPrefix] = value;
            }
          });
        };

        process(values);
      }
    });

    me.callParent();
  },

  createCheckbox: function(type) {
    return {
      xtype: 'checkbox',
      itemId: type + 'Enabled',
      listeners: {
        /**
         * Enable/Disable the port.
         */
        change: function() {
          var form = this.up('form'),
              port = form.down('#' + type + 'Port');
          if (this.getValue()) {
            port.enable();
          }
          else {
            port.disable();
          }
          form.isValid();
        }
      }
    };
  },

  createPort: function(type) {
    return {
      xtype: 'numberfield',
      name: 'attributes.docker.' + type + 'Port',
      itemId: type + 'Port',
      minValue: 1,
      maxValue: 65536,
      allowDecimals: false,
      allowExponential: false,
      allowBlank: false,
      disabled: true,
      width: 565,
      style: {
        marginLeft: '5px'
      },
      listeners: {
        /**
         * Check the checkbox if port has value.
         */
        change: function() {
          var checkbox = this.up('form').down('#' + type + 'Enabled');
          if (this.getValue() && !checkbox.getValue()) {
            checkbox.setValue(true);
            checkbox.resetOriginalValue();
          }
        }
      }
    };
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Repository "Settings" form for a Docker Proxy repository.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.repository.recipe.DockerProxy', {
  extend: 'NX.coreui.view.repository.RepositorySettingsForm',
  alias: 'widget.nx-coreui-repository-docker-proxy',
  requires: [
    'NX.coreui.view.repository.facet.ProxyFacet',
    'NX.coreui.view.repository.facet.StorageFacet',
    'NX.coreui.view.repository.facet.HttpClientFacet',
    'NX.coreui.view.repository.facet.NegativeCacheFacet',
    'NX.coreui.view.repository.facet.DockerConnectorFacet',
    'NX.coreui.view.repository.facet.DockerProxyFacet',
    'NX.coreui.view.repository.facet.DockerV1Facet',
    'NX.coreui.view.repository.facet.CleanupPolicyFacet'
  ],

  /**
   * @override
   */
  initComponent: function() {
    var me = this;

    me.items = [
      {xtype: 'nx-coreui-repository-docker-connector-facet'},
      {xtype: 'nx-coreui-repository-docker-v1-facet'},
      {xtype: 'nx-coreui-repository-proxy-facet'},
      {xtype: 'nx-coreui-repository-storage-facet'},
      {xtype: 'nx-coreui-repository-negativecache-facet'},
      {xtype: 'nx-coreui-repository-cleanup-policy-facet'},
      {xtype: 'nx-coreui-repository-httpclient-facet'}
    ];

    me.callParent();

    me.down('#proxyFieldSet').add(1, {xtype: 'nx-coreui-repository-docker-proxy-facet'});
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Selector model.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.model.Selector', {
  extend: 'Ext.data.Model',
  requires: [
    'NX.I18n'
  ],
  fields: [
    {name: 'id', type: 'string', sortType: 'asUCText'},
    {name: 'name', type: 'string', sortType: 'asUCText'},
    {name: 'type', type: 'string', sortType: 'asUCText', defaultValue: 'csel'},
    {name: 'description', type: 'string', sortType: 'asUCText', convert: Ext.htmlEncode},
    {name: 'expression', type: 'string', sortType: 'asUCText'}
  ]
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Selector store.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.store.Selector', {
  extend: 'Ext.data.Store',
  model: 'NX.coreui.model.Selector',

  proxy: {
    type: 'direct',
    paramsAsHash: false,

    api: {
      read: 'NX.direct.coreui_Selector.read'
    },

    reader: {
      type: 'json',
      rootProperty: 'data',
      successProperty: 'success'
    }
  },

  sorters: {property: 'name', direction: 'ASC'}
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Asset tabs container.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.component.AssetContainer', {
  extend: 'Ext.Panel',
  alias: 'widget.nx-coreui-component-assetcontainer',
  requires: [
    'NX.Icons',
    'NX.ext.button.Button'
  ],

  /**
   * Currently shown asset model.
   *
   * @private
   */
  assetModel: undefined,

  /**
   * @override
   */
  initComponent: function() {
    Ext.apply(this, {
      layout: 'fit',

      dockedItems: {
        xtype: 'nx-actions',
        items: [
          {
            xtype: 'nx-button',
            text: NX.I18n.get('AssetInfo_Delete_Button'),
            glyph: 'xf1f8@FontAwesome' /* fa-trash */,
            action: 'deleteAsset',
            hidden: true
          }
        ]
      },

      items: [
        {
          xtype: 'nx-sorted-tabpanel',
          ui: 'nx-light',
          cls: 'nx-hr',
          itemId: 'assetInfoTabs',
          autoScroll: true,
          layout: 'vbox',
          activeTab: 0
        }
      ]
    });

    this.callParent();
  },

  /**
   * Shows an asset in container.
   *
   * @public
   * @param {NX.coreui.model.Asset} assetModel asset to be shown
   */
  refreshInfo: function (assetModel) {
    var me = this,
        iconName = 'asset-type-default',
        contentType;

    me.assetModel = assetModel;

    if (me.assetModel) {
      if (me.hidden) {
        me.show();
      }
      contentType = me.assetModel.get('contentType').replace('/', '-');
      if (NX.getApplication().getIconController().findIcon('asset-type-' + contentType, 'x16')) {
        iconName = 'asset-type-' + contentType;
      }
      me.setIconCls(NX.Icons.cls(iconName, 'x16'));
      me.setTitle(me.assetModel.get('name'));

      me.fireEvent('updated', me, me.assetModel);
    }
    else {
      me.hide();
    }
  },

  /**
   * Contribute a content tab related to the visible Asset. If the tabItemId already exists, it will be replaced.
   * @public
   */
  addTab: function (item) {
    var me = this, tabs = me.down('#assetInfoTabs');
    var existingTab = tabs.down('#' + item.itemId);
    if (existingTab) {
      tabs.remove(existingTab);
    }
    tabs.add(item);
    tabs.setActiveTab(0);
  },

  /**
   * Show a tab
   * @public
   */
  showTab: function (itemId) {
    var tabs = this.down('#assetInfoTabs'),
        existingTab = tabs.child('#' + itemId);

    if (existingTab) {
      existingTab.tab.show();
    }
  },

  /**
   * Hide a tab
   * @public
   */
  hideTab: function (itemId) {
    var tabs = this.down('#assetInfoTabs'),
        existingTab = tabs.child('#' + itemId),
        wasActive = tabs.getActiveTab() === existingTab;

    if (existingTab) {
      existingTab.tab.hide();

      if (wasActive) {
        tabs.setActiveTab(0);
      }
    }
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Authentication settings fields.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.system.AuthenticationSettings', {
  extend: 'Ext.form.FieldContainer',
  alias: 'widget.nx-coreui-system-authenticationsettings',
  requires: [
    'NX.I18n'
  ],

  namePrefix: undefined,

  defaults: {
    xtype: 'textfield'
  },

  /**
   * @override
   */
  initComponent: function () {
    var me = this,
        namePrefix = me.namePrefix ? me.namePrefix + 'A' : 'a';

    me.items = [
      {
        name: namePrefix + 'uthUsername',
        fieldLabel: NX.I18n.get('System_AuthenticationSettings_Username_FieldLabel'),
        allowBlank: false
      },
      {
        xtype: 'nx-password',
        name: namePrefix + 'uthPassword',
        fieldLabel: NX.I18n.get('System_AuthenticationSettings_Password_FieldLabel')
      },
      {
        name: namePrefix + 'uthNtlmHost',
        fieldLabel: NX.I18n.get('System_AuthenticationSettings_WindowsNtlmHostname_FieldLabel')
      },
      {
        name: namePrefix + 'uthNtlmDomain',
        fieldLabel: NX.I18n.get('System_AuthenticationSettings_WindowsNtlmDomain_FieldLabel')
      }
    ];

    me.callParent();
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Add  Cleanup Policy panel.
 *
 * @since 3.14
 */
Ext.define('NX.coreui.view.cleanuppolicy.CleanupPolicyAdd', {
  extend: 'NX.view.AddPanel',
  alias: 'widget.nx-coreui-cleanuppolicy-add',
  requires: [
    'NX.Conditions',
    'NX.I18n'
  ],

  defaultFocus: 'name',

  /**
   * @override
   */
  initComponent: function() {
    var me = this;

    me.settingsForm = {
      xtype: 'nx-coreui-cleanuppolicy-settings-form',
      api: {
        submit: 'NX.direct.cleanup_CleanupPolicy.create'
      },
      settingsFormSuccessMessage: function(data) {
        return NX.I18n.get('CleanupPolicy_CleanupPolicyAdd_Create_Success') + data['name'];
      },
      editableCondition: NX.Conditions.isPermitted('nexus:repository-admin:*:*:add'),
      editableMarker: NX.I18n.get('CleanupPolicy_CleanupPolicyAdd_Create_Error'),
      buttons: [
        {
          text: NX.I18n.get('CleanupPolicy_CleanupPolicyList_Preview_Button'),
          action: 'preview',
          ui: 'nx-primary'
        },
        {
          text: NX.I18n.get('CleanupPolicy_CleanupPolicyList_New_Button'),
          action: 'add',
          formBind: true,
          ui: 'nx-primary'
        },
        {text: NX.I18n.get('Add_Cancel_Button'), action: 'back'}
      ]
    };

    me.callParent();

    me.down('#name').setReadOnly(false);
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Search results grid.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.search.SearchResultList', {
  extend: 'NX.view.drilldown.Master',
  alias: 'widget.nx-coreui-search-result-list',
  requires: [
    'NX.I18n'
  ],

  allowClearSort: true,

  /**
   * @override
   */
  initComponent: function() {
    Ext.apply(this, {
      // Mark grid as health check columns target
      healthCheckColumnsTarget: true,
      // Mark grid as a component list
      componentList: true,

      store: 'SearchResult',

      // Prevent the store from automatically loading
      loadStore: Ext.emptyFn,

      viewConfig: {
        emptyText: NX.I18n.get('Search_SearchResultList_EmptyText'),
        deferEmptyText: false
      },

      columns: [
        {
          xtype: 'nx-iconcolumn',
          width: 36,
          iconVariant: 'x16',
          iconName: function () {
            return 'search-component';
          }
        },
        {
          text: NX.I18n.get('Search_SearchResultList_Name_Header'),
          dataIndex: 'name',
          stateId: 'name',
          flex: 3,
          renderer: Ext.htmlEncode
        },
        {
          header: NX.I18n.get('Search_SearchResultList_Group_Header'),
          dataIndex: 'group',
          stateId: 'group',
          flex: 4,
          renderer: NX.ext.grid.column.Renderers.optionalData
        },
        {
          header: NX.I18n.get('Search_SearchResultList_Version_Header'),
          dataIndex: 'version',
          stateId: 'version',
          flex: 1,
          renderer: NX.ext.grid.column.Renderers.optionalData
        },
        {
          header: NX.I18n.get('Search_SearchResultList_Format_Header'),
          dataIndex: 'format',
          stateId: 'format',
          width: 70,
          renderer: Ext.htmlEncode
        },
        {
          header: NX.I18n.get('Search_SearchResultList_Repository_Header'),
          dataIndex: 'repositoryName',
          stateId: 'repositoryName',
          hidden: true,
          renderer: Ext.htmlEncode
        }
      ],

      trailingBufferZone: 20,
      leadingBufferZone: 50
    });

    this.callParent();
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Privilege type model.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.model.PrivilegeType', {
  extend: 'Ext.data.Model',
  fields: [
    {name: 'id', type: 'string', sortType: 'asUCText'},
    {name: 'name', type: 'string', sortType: 'asUCText'},
    {name: 'about', type: 'string', sortType: 'asUCText'},
    {name: 'formFields', type: 'auto' /*object*/}
  ]
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/**
 * Utility functions to be shared between different implementations of HealthCheck.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.util.HealthCheckUtil', {
  singleton: true,

  /**
   * Helper method to generate consistent html for embedding iconography.
   * @param icon name of fa icon to display
   * @param style (optional) styles to include
   * @returns {string}
   */
  iconSpan: function (icon, style) {
    return '<span class="fa ' + icon + '"' + (style ? (' style="' + style + '"') : '') + '/>';
  },

  /*
   * Shortens a number, e.g. 234 -> 0.2k
   * @param a number to be formatted
   * @return {string}
   */
  simplifyNumber: function(count) {
    if (count < 100) {
      return count;
    }
    else if (count < 100000) {
      return Math.floor(count / 100) / 10 + 'k';
    }
    else if (count < 100000000) {
      return Math.floor(count / 100000) / 10 + 'm';
    }
    else {
      return Math.floor(count / 100000000) / 10 + 'b';
    }
  },

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Content selector preview window, listing the components that match the selector in the selected repository.
 *
 * @since 3.1
 */
Ext.define('NX.coreui.view.cleanuppolicy.CleanupPolicyPreviewWindow', {
  extend: 'NX.view.ModalDialog',
  alias: 'widget.nx-coreui-cleanuppolicy-preview-window',
  requires: [
    'NX.I18n',
    'NX.coreui.store.AllRepositoriesReference'
  ],

  config: {
    format: undefined
  },

  resizable: true,
  closable: true,
  layout: {
    type: 'vbox',
    align: 'stretch',
    pack: 'start'
  },
  height: 480,
  ui: 'nx-inset',

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    me.repositoryStore = Ext.create('NX.coreui.store.RepositoryReference', {
      remote: true,
      remoteFilter: true,
      sorters: {
        property: 'name',
        direction: 'ASC'
      }
    });

    if(me.format !== NX.I18n.get('Repository_Formats_All')) {
      me.repositoryStore.addFilter([
        {property: 'format', value: me.format},
        {property: 'type', value: '!group'}
      ]);
    } else {
      me.repositoryStore.addFilter([
        {property: 'type', value: '!group'}
      ]);
    }

    Ext.apply(me, {
      title: NX.I18n.get('CleanupPolicy_CleanupPolicyPreviewWindow_Title'),
      width: NX.view.ModalDialog.LARGE_MODAL,
      height: 540,
      buttonAlign: 'left',
      buttons: [
        {text: NX.I18n.get('Button_Close'), handler: me.close, action: 'close', scope: me}
      ],
      items: [
        {
          xtype: 'form',
          buttonAlign: 'left',
          items: [
            {
              xtype: 'combo',
              name: 'selectedRepository',
              fieldLabel: NX.I18n.get('CleanupPolicy_CleanupPolicyPreviewWindow_repository_FieldLabel'),
              helpText: NX.I18n.get('CleanupPolicy_CleanupPolicyPreviewWindow_repository_HelpText'),
              emptyText: NX.I18n.get('CleanupPolicy_CleanupPolicyPreviewWindow_repository_EmptyText'),
              editable: false,
              store: me.repositoryStore,
              valueField: 'id',
              displayField: 'name',
              allowBlank: false
            }
          ],
          buttons: [
            {
              text: NX.I18n.get('CleanupPolicy_CleanupPolicyPreviewWindow_Preview_Button'),
              action: 'preview',
              ui: 'nx-primary',
              formBind: true
            }
          ]
        },
        {
          xtype: 'panel',
          layout: 'hbox',
          ui: 'nx-drilldown-message',
          cls: 'nx-drilldown-warning',
          iconCls: NX.Icons.cls('drilldown-warning', 'x16'),
          title: NX.I18n.get('CleanupPolicy_CleanupPolicyPreviewWindow_Warning'),
          style: {
            marginTop: '10px',
            marginBottom: '5px'
          }
        },
        {
          xtype: 'gridpanel',
          store: 'CleanupPreview',
          flex: 1,
          viewConfig: {
            emptyText: NX.I18n.get('CleanupPolicy_CleanupPolicyPreviewWindow_EmptyText_View'),
            emptyTextFilter: NX.I18n.get('CleanupPolicy_CleanupPolicyPreviewWindow_EmptyText_Filter'),
            deferEmptyText: false
          },

          columns: [
            {
              xtype: 'nx-iconcolumn',
              dataIndex: 'contentType',
              width: 36,
              iconVariant: 'x16',
              iconName: function() { return 'tree-component'; }
            },
            {
              text: NX.I18n.get('CleanupPolicy_CleanupPolicyPreviewWindow_Name_Column'),
              dataIndex: 'name',
              stateId: 'name',
              flex: 1
            },
            {
              text: NX.I18n.get('CleanupPolicy_CleanupPolicyPreviewWindow_Group_Column'),
              dataIndex: 'group',
              stateId: 'group',
              flex: 1
            },
            {
              text: NX.I18n.get('CleanupPolicy_CleanupPolicyPreviewWindow_Version_Column'),
              dataIndex: 'version',
              stateId: 'version',
              flex: 1
            }
          ],

          tbar: {
            xtype: 'nx-actions',
            items: [
              '->',
              {
                xtype: 'nx-searchbox',
                itemId: 'filter',
                emptyText: NX.I18n.get('Grid_Plugin_FilterBox_Empty'),
                width: 200
              }
            ]
          },

          plugins: {
            ptype: 'bufferedrenderer',
            trailingBufferZone: 20,
            leadingBufferZone: 50
          }
        },
        {
          xtype: 'panel',
          itemId: 'componentCountPanel',
          hidden: true,
          layout: 'hbox',
          style: {
            marginTop: '10px',
            marginBottom: '5px'
          },
          items: [
            {
              xtype: 'label',
              style: {
                marginRight: '2px'
              },
              text: NX.I18n.get('CleanupPolicy_CleanupPolicyPreviewWindow_Total_Component_Count')
            },
            {
              xtype: 'label',
              id: 'currentComponentCount',
              name: 'currentComponentCount'
            },
            {
              xtype: 'label',
              style: {
                marginLeft: '2px',
                marginRight: '2px'
              },
              text: NX.I18n.get('CleanupPolicy_CleanupPolicyPreviewWindow_Total_Component_Count_Out_Of')
            },
            {
              xtype: 'label',
              id: 'totalComponentCount',
              name: 'totalComponentCount'
            }
          ]
        }
      ]
    });

    me.callParent();
    me.center();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Search Criteria store.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.store.SearchCriteria', {
  extend: 'Ext.data.Store',
  model: 'NX.coreui.model.SearchCriteria',
  requires: [
    'NX.I18n'
  ],

  autoLoad: true,

  proxy: {
    type: 'memory',
    reader: {
      type: 'json'
    }
  },

  sorters: { property: 'id', direction: 'ASC' },

  listeners: {
    'beforeSelect': function(sm, record, i, opts) {
      // only allow selection of supported records
      return record.get('supported');
    }
  },

  data: [
    {
      id: 'format',
      config: {
        fieldLabel: NX.I18n.get('SearchCriteria_Format_FieldLabel')
      }
    },
    {
      id: 'keyword',
      config: {
        fieldLabel: NX.I18n.get('SearchCriteria_Keyword_FieldLabel'),
        width: 250
      }
    },
    {
      id: 'repository_name',
      config: {
        fieldLabel: NX.I18n.get('SearchCriteria_RepositoryName_FieldLabel'),
        width: 250
      }
    },
    {
      id: 'version',
      config: {
        fieldLabel: NX.I18n.get('SearchCriteria_Version_FieldLabel')
      }
    },
    {
      id: 'group.raw',
      config: {
        fieldLabel: NX.I18n.get('SearchCriteria_Group_FieldLabel'),
        width: 250
      }
    },
    {
      id: 'name.raw',
      config: {
        fieldLabel: NX.I18n.get('SearchCriteria_Name_FieldLabel'),
        width: 200
      }
    },
    {
      id: 'tags',
      config: {
        fieldLabel: NX.I18n.get('SearchCriteria_Tag_FieldLabel'),
        width: 200
      }
    },
    {
      id: 'assets.attributes.checksum.sha1',
      group: NX.I18n.get('SearchCriteria_Checksum_Group'),
      config: {
        fieldLabel: NX.I18n.get('SearchCriteria_SHA1_FieldLabel'),
        width: 250
      }
    },
    {
      id: 'assets.attributes.checksum.sha256',
      group: NX.I18n.get('SearchCriteria_Checksum_Group'),
      config: {
        fieldLabel: NX.I18n.get('SearchCriteria_SHA256_FieldLabel'),
        width: 250
      }
    },
    {
      id: 'assets.attributes.checksum.sha512',
      group: NX.I18n.get('SearchCriteria_Checksum_Group'),
      config: {
        fieldLabel: NX.I18n.get('SearchCriteria_SHA2_FieldLabel'),
        width: 250
      }
    },
    {
      id: 'assets.attributes.checksum.md5',
      group: NX.I18n.get('SearchCriteria_Checksum_Group'),
      config: {
        fieldLabel: NX.I18n.get('SearchCriteria_MD5_FieldLabel'),
        width: 250
      }
    }
  ]
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * User search box.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.user.UserSearchBox', {
  extend: 'Ext.form.field.Text',
  alias: 'widget.nx-coreui-user-searchbox',
  requires: [
    'Ext.util.KeyNav',
    'NX.I18n'
  ],

  triggers: {
    clear: {
      cls: 'nx-form-fa-times-circle-trigger',
      handler: 'clearSearch',
      hidden: true
    },
    search: {
      cls: 'x-form-search-trigger',
      handler: 'doSearch'
    }
  },

  keyMap: {
    ESC: 'clearSearch',
    ENTER: 'doSearch'
  },

  listeners: {
    change: 'valueChanged'
  },

  width: 320,
  submitValue: false,

  /**
   * @override
   */
  initComponent: function() {
    var me = this;

    me.emptyText = NX.I18n.get('User_UserList_Filter_EmptyText');

    me.callParent();
  },

  /**
   * @private
   */
  doSearch: function() {
    var value = this.getValue();
    this.search(value);
  },

  /**
   * Search for value and fires a 'search' event.
   *
   * @public
   * @param value to search for
   */
  search: function(value) {
    var me = this;

    if (value !== me.getValue()) {
      me.setValue(value);
    }
    me.fireEvent('search', me, value);
  },

  /**
   * Clears the search.
   *
   * @public
   */
  clearSearch: function() {
    var me = this;

    if (me.getValue()) {
      me.setValue(undefined);
    }
    me.fireEvent('searchcleared', me);
  },

  valueChanged: function() {
    var clearTrigger = this.getTrigger('clear');
    if (this.getValue()) {
      clearTrigger.show();
    }
    else {
      clearTrigger.hide();
    }
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Search criteria mixin.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.search.SearchCriteria', {

  searchCriteria: true,

  filter: function () {
    var me = this;
    if (me.value) {
      return { property: me.criteriaId, value: me.value };
    }
    return undefined;
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Security Realm model.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.store.RealmType', {
  extend: 'Ext.data.Store',
  model: 'NX.coreui.model.Reference',

  proxy: {
    type: 'direct',
    paramsAsHash: false,

    api: {
      read: 'NX.direct.coreui_RealmSettings.readRealmTypes'
    },

    reader: {
      type: 'json',
      rootProperty: 'data',
      successProperty: 'success'
    }
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Anonymous Security Settings controller.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.controller.AnonymousSettings', {
  extend: 'NX.app.Controller',
  requires: [
    'NX.Permissions',
    'NX.I18n'
  ],

  views: [
    'security.AnonymousSettings'
  ],

  stores: [
    'RealmType'
  ],

  refs: [
    {
      ref: 'panel',
      selector: 'nx-coreui-security-anonymous-settings'
    },
    {
      ref: 'form',
      selector: 'nx-coreui-security-anonymous-settings nx-settingsform'
    }
  ],

  /**
   * @override
   */
  init: function () {
    var me = this;

    me.getApplication().getFeaturesController().registerFeature({
      mode: 'admin',
      path: '/Security/Anonymous',
      text: NX.I18n.get('AnonymousSettings_Text'),
      description: NX.I18n.get('AnonymousSettings_Description'),
      view: { xtype: 'nx-coreui-security-anonymous-settings' },
      iconConfig: {
        file: 'user_silhouette.png',
        variants: ['x16', 'x32']
      },
      visible: function () {
        return NX.Permissions.check('nexus:settings:read');
      }
    }, me);

    me.listen({
      controller: {
        '#Refresh': {
          refresh: me.loadRealmTypes
        }
      },
      component: {
        'nx-coreui-security-anonymous-settings': {
          beforerender: me.loadRealmTypes
        }
      }
    });
  },

  /**
   * @private
   */
  loadRealmTypes: function () {
    var me = this,
        panel = me.getPanel();

    if (panel) {
      me.getStore('RealmType').load(function() {
        // The form depends on this store, so load it after the store has loaded
        var form = me.getForm();
        if (form) {
          form.load();
        }
      });
    }
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Ssl use Nexus Truststore checkbox.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.ssl.SslUseTrustStore', {
  extend: 'Ext.form.FieldContainer',
  alias: 'widget.nx-coreui-sslusetruststore',
  requires: [
    'NX.I18n'
  ],

  initComponent: function () {
    var me = this;

    if (!me.fieldLabel && !me.boxLabel) {
      me.fieldLabel = NX.I18n.get('Ssl_SslUseTrustStore_BoxLabel');
    }
    if (me.fieldLabel === true) {
      me.fieldLabel = NX.I18n.get('Ssl_SslUseTrustStore_BoxLabel');
    }
    if (me.boxLabel === true) {
      me.boxLabel = NX.I18n.get('Ssl_SslUseTrustStore_BoxLabel');
    }

    me.items = {
      xtype: 'panel',
      layout: 'hbox',
      items: [
        {
          xtype: 'checkbox',
          name: me.name,
          value: me.value,
          inputValue: true,
          boxLabel: me.boxLabel,
          helpText: NX.I18n.get('Ssl_SslUseTrustStore_Certificate_HelpText')
        },
        {
          xtype: 'button',
          text: NX.I18n.get('Ssl_SslUseTrustStore_Certificate_Button'),
          ui: 'nx-plain',
          action: 'showcertificate',
          glyph: 'xf0a3@FontAwesome' /* fa-certificate */,
          margin: '0 0 0 5'
        }
      ]
    };

    me.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Ssl TrustStore controller.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.controller.SslTrustStore', {
  extend: 'NX.app.Controller',
  requires: [
    'NX.Conditions',
    'NX.coreui.controller.SslCertificates'
  ],

  views: [
    'ssl.SslUseTrustStore'
  ],

  refs: [
    {
      ref: 'main',
      selector: 'nx-main'
    }
  ],

  /**
   * @override
   */
  init: function() {
    var me = this;

    me.listen({
      component: {
        'field[useTrustStore]': {
          change: me.manageTrustStore
        },
        'nx-coreui-sslusetruststore button[action=showcertificate]': {
          click: me.loadCertificate
        }
      }
    });
  },

  /**
   * @private
   * @param field
   * @param field.useTrustStore
   * @param field.useTrustStoreField
   */
  manageTrustStore: function(field) {
    var me = this,
        container = field.up('container'),
        useTrustStoreField = field.useTrustStoreField,
        config, hostAndPort;

    if (Ext.isFunction(field.useTrustStore)) {
      config = field.useTrustStore.call(field, field);
      if (config) {
        hostAndPort = me.getHostAndPort(config);
        if (useTrustStoreField && ((useTrustStoreField.name !== config.name) || !hostAndPort.host)) {
          container.remove(useTrustStoreField);
          delete field.useTrustStoreField;
          useTrustStoreField = undefined;
        }
        if (hostAndPort.host) {
          if (!useTrustStoreField) {
            container.insert(container.items.indexOf(field) + 1, {
              xtype: 'nx-coreui-sslusetruststore',
              name: config.name,
              value: config.value,
              fieldLabel: field.useTrustStoreFieldLabel,
              boxLabel: field.useTrustStoreBoxLabel,
              useTrustStoreConfig: config,
              cls: 'nx-clear-both',
              listeners: {
                afterrender: me.bindConditions
              }
            });
            field.useTrustStoreField = container.down('nx-coreui-sslusetruststore[name=' + config.name + ']');
          }
          else {
            useTrustStoreField.useTrustStoreConfig = config;
          }
        }
      }
    }
    if ((!config) && useTrustStoreField) {
      container.remove(useTrustStoreField);
      delete field.useTrustStoreField;
    }
  },

  /**
   * @private
   * Retrieves certificate, showing the certificate details if successful.
   */
  loadCertificate: function(button) {
    var me = this,
        panel = button.up('panel').up('panel'),
        useTrustStoreConfig = button.up('nx-coreui-sslusetruststore').useTrustStoreConfig,
        hostAndPort = me.getHostAndPort(useTrustStoreConfig),
        protocolHint = useTrustStoreConfig.url && Ext.String.startsWith(useTrustStoreConfig.url.getValue(), "https://") ? 'https' : undefined,
        sslCertificates = me.getController('NX.coreui.controller.SslCertificates');

    me.getMain().getEl().mask(NX.I18n.get('SslTrustStore_Load_Mask'));
    NX.direct.ssl_Certificate.retrieveFromHost(hostAndPort.host, hostAndPort.port, protocolHint, function(response) {
      me.getMain().getEl().unmask();
      if (Ext.isObject(response) && response.success) {
        sslCertificates.showCertificateDetailsWindow(response.data);
      }
    });
  },

  /**
   * @private
   * Get host/port out of config.
   */
  getHostAndPort: function(config) {
    var sslCertificates = this.getController('NX.coreui.controller.SslCertificates'),
        valueOf = function(value) {
          if (Ext.isString(value)) {
            return value;
          }
          else if (value && Ext.isFunction(value.getValue)) {
            return value.getValue();
          }
          return undefined;
        },
        parsed, host, port;

    if (config.url) {
      parsed = sslCertificates.parseHostAndPort(valueOf(config.url));
      host = parsed[0];
      port = parsed[1];
    }
    else {
      host = valueOf(config.host);
      port = valueOf(config.port);
    }

    return {
      host: host,
      port: port
    };
  },

  bindConditions: function(useTrustStoreField) {
    var useTrustStoreCheckbox, useTrustStoreButton;

    useTrustStoreCheckbox = useTrustStoreField.down('checkbox');
    useTrustStoreButton = useTrustStoreField.down('button');
    useTrustStoreField.mon(
        NX.Conditions.and(
            NX.Conditions.isPermitted('nexus:ssl-truststore:create'),
            NX.Conditions.isPermitted('nexus:ssl-truststore:update')
        ),
        {
          satisfied: useTrustStoreCheckbox.enable,
          unsatisfied: useTrustStoreCheckbox.disable,
          scope: useTrustStoreCheckbox
        }
    );
    useTrustStoreField.mon(
        NX.Conditions.isPermitted('nexus:ssl-truststore:read'),
        {
          satisfied: useTrustStoreButton.enable,
          unsatisfied: useTrustStoreButton.disable,
          scope: useTrustStoreButton
        }
    );
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Chnage password window.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.user.UserChangePassword', {
  extend: 'NX.view.ModalDialog',
  alias: 'widget.nx-coreui-user-changepassword',
  requires: [
    'NX.Conditions',
    'NX.I18n'
  ],

  /**
   * @cfg userId to change password for
   */
  userId: undefined,

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    me.ui = 'nx-inset';
    me.title = NX.I18n.get('User_UserChangePassword_Title');

    me.setWidth(NX.view.ModalDialog.SMALL_MODAL);

    me.items = {
      xtype: 'form',
      editableCondition: NX.Conditions.isPermitted('nexus:userschangepw:create'),
      editableMarker: NX.I18n.get('User_UserChangePassword_NoPermission_Error'),
      defaults: {
        anchor: '100%',
        // allow cancel to be clicked w/o validating field to be non-blank
        validateOnBlur: false
      },
      items: [
        {
          xtype: 'nx-password',
          name: 'password',
          itemId: 'password',
          fieldLabel: NX.I18n.get('User_UserChangePassword_Password_FieldLabel'),
          allowBlank: false
        },
        {
          xtype: 'nx-password',
          fieldLabel: NX.I18n.get('User_UserChangePassword_PasswordConfirm_FieldLabel'),
          allowBlank: false,
          submitValue: false,
          validator: function () {
            var me = this;
            return (me.up('form').down('#password').getValue() === me.getValue()) ? true : NX.I18n.get('User_UserChangePassword_NoMatch_Error');
          }
        }
      ],

      buttonAlign: 'left',
      buttons: [
        { text: NX.I18n.get('User_UserChangePassword_Submit_Button'), action: 'changepassword', formBind: true, bindToEnter: true, ui: 'nx-primary' },
        { text: NX.I18n.get('User_UserChangePassword_Cancel_Button'), handler: function () {
          this.up('window').close();
        }}
      ]
    };

    me.maxHeight = Ext.getBody().getViewSize().height - 100;

    me.on({
      resize: function() {
        me.down('#password').focus();
      },
      single: true
    });

    me.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * User store.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.store.User', {
  extend: 'Ext.data.Store',
  model: 'NX.coreui.model.User',

  proxy: {
    type: 'direct',

    api: {
      read: 'NX.direct.coreui_User.read'
    },

    reader: {
      type: 'json',
      rootProperty: 'data',
      successProperty: 'success'
    }
  },

  pageSize: 100,

  sorters: { property: 'userId', direction: 'ASC' }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Maven repository search contribution.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.controller.SearchMaven', {
  extend: 'NX.app.Controller',
  requires: [
    'NX.I18n'
  ],

  /**
   * @override
   */
  init: function() {
    var me = this,
        search = me.getController('NX.coreui.controller.Search');

    search.registerCriteria([
      {
        id: 'attributes.maven2.groupId',
        group: NX.I18n.get('SearchMaven_Group'),
        config: {
          format: 'maven2',
          fieldLabel: NX.I18n.get('SearchMaven_GroupID_FieldLabel'),
          width: 250
        }
      },
      {
        id: 'attributes.maven2.artifactId',
        group: NX.I18n.get('SearchMaven_Group'),
        config: {
          format: 'maven2',
          fieldLabel: NX.I18n.get('SearchMaven_ArtifactID_FieldLabel'),
          width: 250
        }
      },
      {
        id: 'attributes.maven2.baseVersion',
        group: NX.I18n.get('SearchMaven_Group'),
        config: {
          format: 'maven2',
          fieldLabel: NX.I18n.get('SearchMaven_BaseVersion_FieldLabel'),
          width: 250
        }
      },
      {
        id: 'assets.attributes.maven2.classifier',
        group: NX.I18n.get('SearchMaven_Group'),
        config: {
          format: 'maven2',
          fieldLabel: NX.I18n.get('SearchMaven_Classifier_FieldLabel')
        }
      },
      {
        id: 'assets.attributes.maven2.extension',
        group: NX.I18n.get('SearchMaven_Group'),
        config: {
          format: 'maven2',
          fieldLabel: NX.I18n.get('SearchMaven_Extension_FieldLabel')
        }
      }
    ], me);

    search.registerFilter({
      id: 'maven2',
      name: 'Maven',
      text: NX.I18n.get('SearchMaven_Text'),
      description: NX.I18n.get('SearchMaven_Description'),
      readOnly: true,
      criterias: [
        { id: 'format', value: 'maven2', hidden: true },
        { id: 'attributes.maven2.groupId' },
        { id: 'attributes.maven2.artifactId' },
        { id: 'version' },
        { id: 'attributes.maven2.baseVersion' },
        { id: 'assets.attributes.maven2.classifier'},
        { id: 'assets.attributes.maven2.extension' }
      ]
    }, me);
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Cleanup Policy grid.
 *
 * @since 3.14
 */
Ext.define('NX.coreui.view.cleanuppolicy.CleanupPolicyList', {
  extend: 'NX.view.drilldown.Master',
  alias: 'widget.nx-coreui-cleanuppolicy-list',
  requires: [
    'NX.I18n'
  ],

  stateful: true,
  stateId: 'nx-coreui-cleanuppolicy-list',

  /**
   * @override
   */
  initComponent: function() {
    Ext.apply(this, {
      store: 'CleanupPolicies',

      columns: [
        {
          xtype: 'nx-iconcolumn',
          width: 36,
          iconVariant: 'x16',
          iconName: function () {
            return 'cleanuppolicy-default';
          }
        },
        { header: NX.I18n.get('CleanupPolicy_CleanupPolicyList_Name_Header'), dataIndex: 'name', stateId: 'name', flex: 1, renderer: Ext.htmlEncode },
        { header: NX.I18n.get('CleanupPolicy_CleanupPolicyList_Format_Header'), dataIndex: 'format', stateId: 'format', flex: 1, renderer: Ext.htmlEncode },
        { header: NX.I18n.get('CleanupPolicy_CleanupPolicyList_Notes_Header'), dataIndex: 'notes', stateId: 'notes', flex: 1, renderer: Ext.htmlEncode }
      ],

      viewConfig: {
        emptyText: NX.I18n.get('CleanupPolicy_CleanupPolicyList_EmptyState'),
        deferEmptyText: false
      },

      dockedItems: [{
        xtype: 'nx-actions',
        items: [
          {
            xtype: 'button',
            text: NX.I18n.get('CleanupPolicy_CleanupPolicyList_New_Button'),
            glyph: 'xf055@FontAwesome',
            action: 'new',
            disabled: true
          }
        ]
      }],

      plugins: [
        { ptype: 'gridfilterbox', emptyText: NX.I18n.get('CleanupPolicy_CleanupPolicyList_Filter_EmptyState') }
      ]
    });

    this.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Add repository window.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.repository.RepositoryAdd', {
  extend: 'NX.view.AddPanel',
  alias: 'widget.nx-coreui-repository-add',
  requires: [
    'NX.Conditions',
    'NX.I18n'
  ],

  recipe: undefined,

  /**
   * @override
   */
  initComponent: function() {
    var me = this;

    me.settingsForm = {
      xtype: 'nx-coreui-repository-' + me.recipe.getId(),
      api: {
        submit: 'NX.direct.coreui_Repository.create'
      },
      settingsFormSuccessMessage: function(data) {
        return NX.I18n.get('Repository_RepositoryAdd_Create_Success') + data['name'];
      },
      editableCondition: NX.Conditions.isPermitted('nexus:repository-admin:*:*:add'),
      editableMarker: NX.I18n.get('Repository_RepositoryAdd_Create_Error'),

      buttons: [
        { text: NX.I18n.get('Repository_RepositoryList_New_Button'), action: 'add', formBind: true, ui: 'nx-primary' },
        { text: NX.I18n.get('Add_Cancel_Button'), action: 'back' }
      ]
    };

    me.callParent();

    me.down('#name').setReadOnly(false);
    me.down('#format').setVisible(false);
    me.down('#type').setVisible(false);
    me.down('#url').setVisible(false);
    me.down('form').add({
      xtype: 'hiddenfield',
      name: 'recipe',
      value: me.recipe.getId()
    });

    // do not allow repositories to select blob stores that are assigned to a blob store group
    var storage = me.down('nx-coreui-repository-storage-facet').down('combo');
    if (storage && storage.name === 'attributes.storage.blobStoreName') {
      storage.getStore().clearFilter(true);
      storage.getStore().filter([
        {
          filterFn: function(item) {
            var blobStore = item.data;
            return !blobStore.groupName;
          }
        }
      ]);
    }
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * PyPI repository search contribution.
 *
 * @since 3.1
 */
Ext.define('NX.coreui.controller.SearchPyPi', {
  extend: 'NX.app.Controller',
  requires: [
    'NX.I18n'
  ],

  /**
   * @override
   */
  init: function() {
    var me = this,
        search = me.getController('NX.coreui.controller.Search');

    search.registerCriteria([
      {
        id: 'assets.attributes.pypi.classifiers',
        group: NX.I18n.get('SearchPyPi_Group'),
        config: {
          format: 'pypi',
          fieldLabel: NX.I18n.get('SearchPyPi_Classifiers_FieldLabel'),
          width: 250
        }
      },
      {
        id: 'assets.attributes.pypi.description',
        group: NX.I18n.get('SearchPyPi_Group'),
        config: {
          format: 'pypi',
          fieldLabel: NX.I18n.get('SearchPyPi_Description_FieldLabel'),
          width: 250
        }
      },
      {
        id: 'assets.attributes.pypi.keywords',
        group: NX.I18n.get('SearchPyPi_Group'),
        config: {
          format: 'pypi',
          fieldLabel: NX.I18n.get('SearchPyPi_Keywords_FieldLabel'),
          width: 250
        }
      },
      {
        id: 'assets.attributes.pypi.summary',
        group: NX.I18n.get('SearchPyPi_Group'),
        config: {
          format: 'pypi',
          fieldLabel: NX.I18n.get('SearchPyPi_Summary_FieldLabel'),
          width: 250
        }
      }
    ], me);

    search.registerFilter({
      id: 'pypi',
      name: 'pypi',
      text: NX.I18n.get('SearchPyPi_Text'),
      description: NX.I18n.get('SearchPyPi_Description'),
      readOnly: true,
      criterias: [
        { id: 'format', value: 'pypi', hidden: true },
        { id: 'assets.attributes.pypi.classifiers' },
        { id: 'assets.attributes.pypi.description' },
        { id: 'assets.attributes.pypi.keywords' },
        { id: 'assets.attributes.pypi.summary' }
      ]
    }, me);
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Repository "Settings" form for a NuGet Proxy repository.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.repository.recipe.NugetProxy', {
  extend: 'NX.coreui.view.repository.RepositorySettingsForm',
  alias: 'widget.nx-coreui-repository-nuget-proxy',
  requires: [
    'NX.coreui.view.repository.facet.ProxyFacet',
    'NX.coreui.view.repository.facet.StorageFacet',
    'NX.coreui.view.repository.facet.HttpClientFacet',
    'NX.coreui.view.repository.facet.NegativeCacheFacet',
    'NX.coreui.view.repository.facet.NugetProxyFacet',
    'NX.coreui.view.repository.facet.CleanupPolicyFacet'
  ],

  initComponent: function() {
    var me = this;

    me.items = [
      { xtype: 'nx-coreui-repository-nugetproxy-facet'},
      { xtype: 'nx-coreui-repository-proxy-facet'},
      { xtype: 'nx-coreui-repository-storage-facet'},
      { xtype: 'nx-coreui-repository-negativecache-facet'},
      { xtype: 'nx-coreui-repository-cleanup-policy-facet'},
      { xtype: 'nx-coreui-repository-httpclient-facet'}
    ];

    me.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Content selector preview window, listing the components that match the selector in the selected repository.
 *
 * @since 3.1
 */
Ext.define('NX.coreui.view.selector.SelectorPreviewWindow', {
  extend: 'NX.view.ModalDialog',
  alias: 'widget.nx-coreui-selector-preview-window',
  requires: [
    'NX.I18n',
    'NX.coreui.store.AllRepositoriesReference'
  ],

  config: {
    /**
     * @cfg {String} expression selector.
     */
    expression: undefined
  },

  resizable: true,
  closable: true,
  layout: {
    type: 'vbox',
    align: 'stretch',
    pack: 'start'
  },
  height: 480,
  ui: 'nx-inset',

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    Ext.apply(me, {
      title: NX.I18n.get('SelectorPreviewWindow_Title'),
      width: NX.view.ModalDialog.LARGE_MODAL,
      height: 540,
      buttonAlign: 'left',
      buttons: [
        {text: NX.I18n.get('Button_Close'), handler: me.close, action: 'close', scope: me}
      ],
      items: [
        {
          xtype: 'form',
          buttonAlign: 'left',
          items: [
            {
              xtype: 'combo',
              cls: 'nx-combo-disabled',
              name: 'type',
              fieldLabel: NX.I18n.get('SelectorPreviewWindow_type_FieldLabel'),
              editable: false,
              store: [
                ['jexl', NX.I18n.get('Selector_SelectorSettingsForm_Type_Jexl')],
                ['csel', NX.I18n.get('Selector_SelectorSettingsForm_Type_Sonatype')]
              ],
              value: 'csel',
              readOnly: true
            },
            {
              xtype: 'textareafield',
              name: 'expression',
              itemId: 'expression',
              fieldLabel: NX.I18n.get('SelectorPreviewWindow_expression_FieldLabel'),
              allowBlank: false,
              value: me.getExpression()
            },
            {
              xtype: 'combo',
              name: 'selectedRepository',
              fieldLabel: NX.I18n.get('SelectorPreviewWindow_repository_FieldLabel'),
              helpText: NX.I18n.get('SelectorPreviewWindow_repository_HelpText'),
              emptyText: NX.I18n.get('SelectorPreviewWindow_repository_EmptyText'),
              editable: false,
              store: Ext.create('NX.coreui.store.AllRepositoriesReference', {remote: true, autoLoad: true}),
              valueField: 'id',
              displayField: 'name',
              allowBlank: false
            }
          ],
          buttons: [
            {
              text: NX.I18n.get('SelectorPreviewWindow_Preview_Button'),
              action: 'preview',
              ui: 'nx-primary',
              formBind: true
            }
          ]
        },
        {
          xtype: 'gridpanel',
          store: me.assetStore,
          flex: 1,
          viewConfig: {
            emptyText: NX.I18n.get('SelectorPreviewWindow_EmptyText_View'),
            emptyTextFilter: NX.I18n.get('SelectorPreviewWindow_EmptyText_Filter'),
            deferEmptyText: false
          },

          columns: [
            {
              xtype: 'nx-iconcolumn',
              dataIndex: 'contentType',
              width: 36,
              iconVariant: 'x16',
              iconNamePrefix: 'asset-type-',
              iconName: function(value) {
                var assetType;

                if (value) {
                  assetType = value.replace('/', '-');
                  if (NX.getApplication().getIconController().findIcon('asset-type-' + assetType, 'x16')) {
                    return assetType;
                  }
                }
                return 'default';
              }
            },
            {
              text: NX.I18n.get('SelectorPreviewWindow_Name_Column'),
              dataIndex: 'name',
              stateId: 'name',
              flex: 1
            }
          ],

          tbar: {
            xtype: 'nx-actions',
            items: [
              '->',
              {
                xtype: 'nx-searchbox',
                itemId: 'filter',
                emptyText: NX.I18n.get('Grid_Plugin_FilterBox_Empty'),
                width: 200
              }
            ]
          },

          plugins: {
            ptype: 'bufferedrenderer',
            trailingBufferZone: 20,
            leadingBufferZone: 50
          }
        }
      ]
    });

    me.callParent();
    me.center();
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Add selector window.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.selector.SelectorAdd', {
  extend: 'NX.view.AddPanel',
  alias: 'widget.nx-coreui-selector-add',
  requires: [
    'NX.Conditions',
    'NX.I18n'
  ],

  defaultFocus: 'name',

  initComponent: function() {
    var me = this;

    me.settingsForm = {
      xtype: 'nx-coreui-selector-settings-form',
      api: {
        submit: 'NX.direct.coreui_Selector.create'
      },
      settingsFormSuccessMessage: function(data) {
        return NX.I18n.format('Selector_SelectorAdd_Create_Success', data['name']);
      },
      editableCondition: NX.Conditions.isPermitted('nexus:selectors:create'),
      editableMarker: NX.I18n.get('Selector_SelectorAdd_Create_Error'),

      buttons: [
        {text: NX.I18n.get('Selector_SelectorSettingsForm_Preview_Button'), action: 'preview', ui: 'nx-primary'},
        {text: NX.I18n.get('Selector_SelectorList_New_Button'), action: 'add', formBind: true, ui: 'nx-primary'},
        {text: NX.I18n.get('Add_Cancel_Button'), action: 'back'}
      ]
    };

    me.callParent();

    me.down('#name').setReadOnly(false);
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Selector grid.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.selector.SelectorList', {
  extend: 'NX.view.drilldown.Master',
  alias: 'widget.nx-coreui-selector-list',
  requires: [
    'NX.Icons',
    'NX.I18n'
  ],

  stateful: true,
  stateId: 'nx-coreui-selector-list',

  /**
   * @override
   */
  initComponent: function() {
    var me = this;

    me.store = 'Selector';

    me.columns = [
      {
        xtype: 'nx-iconcolumn',
        width: 36,
        iconVariant: 'x16',
        iconName: function() {
          return 'selector-default';
        }
      },
      {
        header: NX.I18n.get('Selector_SelectorList_Name_Header'),
        dataIndex: 'name',
        stateId: 'name',
        flex: 4
      },
      {
        header: NX.I18n.get('Selector_SelectorList_Type_Header'),
        dataIndex: 'type',
        stateId: 'type',
        flex: 1,
        renderer: function(value) {
          return value.toUpperCase();
        }
      },
      {
        header: NX.I18n.get('Selector_SelectorList_Description_Header'),
        dataIndex: 'description',
        stateId: 'description',
        flex: 4
      }
    ];

    me.viewConfig = {
      emptyText: NX.I18n.get('Selector_SelectorList_EmptyText'),
      deferEmptyText: false
    };

    me.plugins = [
      {
        ptype: 'gridfilterbox',
        emptyText: NX.I18n.get('Selector_SelectorList_Filter_EmptyText')
      }
    ];

    me.dockedItems = [
      {
        xtype: 'nx-actions',
        items: [
          {
            xtype: 'button',
            text: NX.I18n.get('Selector_SelectorList_New_Button'),
            glyph: 'xf055@FontAwesome' /* fa-plus-circle */,
            action: 'new',
            disabled: true
          }
        ]
      }
    ];

    me.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Selectors controller.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.controller.Selectors', {
  extend: 'NX.controller.Drilldown',
  requires: [
    'NX.Conditions',
    'NX.Messages',
    'NX.Permissions',
    'NX.I18n',
    'NX.coreui.view.selector.SelectorPreviewWindow'
  ],
  masters: [
    'nx-coreui-selector-list'
  ],
  models: [
    'Selector'
  ],
  stores: [
    'Selector',
    'PreviewAsset'
  ],
  views: [
    'selector.SelectorAdd',
    'selector.SelectorFeature',
    'selector.SelectorList',
    'selector.SelectorSettings',
    'selector.SelectorSettingsForm',
    'selector.SelectorPreviewWindow'
  ],
  refs: [
    {ref: 'feature', selector: 'nx-coreui-selector-feature'},
    {ref: 'list', selector: 'nx-coreui-selector-list'},
    {ref: 'settings', selector: 'nx-coreui-selector-feature nx-coreui-selector-settings'},
    {ref: 'previewWindow', selector: 'nx-coreui-selector-preview-window'},
    {ref: 'previewAssetList', selector: 'nx-coreui-selector-preview-window gridpanel'},
    {ref: 'previewRepositoryComboBox', selector: 'nx-coreui-selector-preview-window combo[name=selectedRepository]'},
    {ref: 'previewExpression', selector: 'nx-coreui-selector-preview-window textareafield[name=expression]'},
    {ref: 'type', selector: 'nx-coreui-selector-preview-window combo[name=type]'},
    {ref: 'previewWindowPreviewButton', selector: 'nx-coreui-selector-preview-window button[action=preview]'},
    {ref: 'addSettingsForm', selector: 'nx-coreui-selector-add nx-coreui-selector-settings-form'},
    {ref: 'editSettingsForm', selector: 'nx-coreui-selector-settings nx-coreui-selector-settings-form'},
    {ref: 'jexlHelp', selector: 'nx-coreui-selector-settings-form #jexlHelp'},
    {ref: 'cselHelp', selector: 'nx-coreui-selector-settings-form #cselHelp'}
  ],
  icons: {
    'selector-default': {
      file: 'content_selector.png',
      variants: ['x16', 'x32']
    }
  },

  permission: 'nexus:selectors',

  /**
   * @override
   */
  init: function() {
    var me = this;

    // We need a reference to the PreviewAsset store, but it should not auto-load when the Drilldown is activated.
    me.storesForLoad = ['Selector'];

    me.features = {
      mode: 'admin',
      path: '/Repository/Selectors',
      text: NX.I18n.get('Selectors_Text'),
      description: NX.I18n.get('Selectors_Description'),
      view: {xtype: 'nx-coreui-selector-feature'},
      iconConfig: {
        file: 'content_selector.png',
        variants: ['x16', 'x32']
      },
      visible: function() {
        return NX.Permissions.check('nexus:selectors:read');
      },
      weight: 300
    };

    me.callParent();

    me.listen({
      controller: {
        '#Refresh': {
          refresh: me.loadStores
        }
      },
      store: {
        '#Selector': {
          load: me.reselect
        },
        '#PreviewAsset': {
          load: me.loadPreviewAssetStore
        }
      },
      component: {
        'nx-coreui-selector-list': {
          beforerender: me.loadStores
        },
        'nx-coreui-selector-list button[action=new]': {
          click: me.showAddWindow
        },
        'nx-coreui-selector-settings-form': {
          submitted: me.loadStores,
          recordloaded: me.recordLoaded
        },
        'nx-coreui-selector-settings-form button[action=preview]': {
          click: me.showPreviewWindow
        },
        'nx-coreui-selector-preview-window gridpanel #filter': {
          search: me.filterPreviewAssetStore,
          searchcleared: me.clearFilterPreviewAssetStore
        },
        'nx-coreui-selector-preview-window button[action=preview]': {
          click: me.loadStore
        },
        'nx-coreui-selector-preview-window button[action=close]': {
          click: me.closePreviewWindow
        }
      }
    });
  },

  /**
   * @override
   */
  getDescription: function(model) {
    return model.get('name');
  },

  /**
   * @override
   */
  onSelection: function(list, model) {
    var me = this;

    me.addMode = false;

    if (Ext.isDefined(model)) {
      me.getSettings().loadRecord(model);
    }
  },

  recordLoaded: function(formPanel, record) {
    var me = this;

    if (record && record.get('type') === 'jexl') {
      me.getCselHelp().hide();
      me.getJexlHelp().show();
    }
    else {
      me.getJexlHelp().hide();
      me.getCselHelp().show();
    }
  },

  /**
   * @private
   */
  showAddWindow: function() {
    var me = this;

    me.addMode = true;

    // Show the first panel in the create wizard, and set the breadcrumb
    me.setItemName(1, NX.I18n.get('Selectors_Create_Title'));
    me.loadCreateWizard(1, Ext.create('widget.nx-coreui-selector-add'));
  },

  /**
   * @private
   */
  deleteModel: function(model) {
    var me = this,
        description = me.getDescription(model);

    NX.direct.coreui_Selector.remove(model.getId(), function(response) {
      me.getSelectorStore().load();
      if (Ext.isObject(response) && response.success) {
        NX.Messages.add({
          text: NX.I18n.format('Selectors_Delete_Message', description), type: 'success'
        });
      }
    });
  },

  showPreviewWindow: function() {
    var me = this, form;

    if (me.addMode) {
      form = me.getAddSettingsForm().getForm();
    }
    else {
      form = me.getEditSettingsForm().getForm();
    }

    var assetStore = me.getPreviewAssetStore();
    //make sure to empty the store so we don't see stale data
    assetStore.removeAll();

    Ext.create('NX.coreui.view.selector.SelectorPreviewWindow', {
      expression: form.findField('expression').getValue(),
      type: form.findField('type').getValue(),
      assetStore: assetStore
    });
  },

  closePreviewWindow: function() {
    var me = this, form, value = me.getPreviewExpression().getValue();

    if (value) {
      if (me.addMode) {
        form = me.getAddSettingsForm().getForm();
      }
      else {
        form = me.getEditSettingsForm().getForm();
      }

      form.findField('expression').setValue(value);
    }
  },

  loadStore: function() {
    var me = this,
        assetList = me.getPreviewAssetList(),
        assetStore = assetList.getStore(),
        repositoryName = me.getPreviewRepositoryComboBox().getValue();

    me.getPreviewExpression().clearInvalid();

    me.getPreviewWindowPreviewButton().disable();

    if (repositoryName) {
      assetStore.addFilter([
        {
          id: 'repositoryName',
          property: 'repositoryName',
          value: repositoryName
        },
        {
          id: 'expression',
          property: 'expression',
          value: me.getPreviewExpression().getValue()
        },
        {
          id: 'type',
          property: 'type',
          value: me.getType().getValue()
        }
      ]);
    }
  },

  loadPreviewAssetStore: function(store, records, successful, operation) {
    var me = this;

    var previewWindowPreviewButton = me.getPreviewWindowPreviewButton();
    if (previewWindowPreviewButton) {
      previewWindowPreviewButton.enable();
    }

    //since we are dealing with a store, there isn't typical api for mapping an error to a form field
    //so we do it manually
    if (!successful &&
        operation.getResponse().result &&
        operation.getResponse().result.errors &&
        operation.getResponse().result.errors.expression) {
      me.getPreviewExpression().markInvalid(operation.getResponse().result.errors.expression);
    }
  },

  filterPreviewAssetStore: function(filterTextField, value) {
    var grid = filterTextField.up('grid'),
        store = grid.getStore(),
        emptyText = grid.getView().emptyTextFilter;

    if (!grid.emptyText) {
      grid.emptyText = grid.getView().emptyText;
    }
    grid.getView().emptyText = '<div class="x-grid-empty">' + emptyText.replace(/\$filter/, value) + '</div>';
    grid.getSelectionModel().deselectAll();
    store.addFilter([
      {
        id: 'filter',
        property: 'filter',
        value: value
      }
    ]);
  },

  clearFilterPreviewAssetStore: function(filterTextField) {
    var grid = filterTextField.up('grid'),
        store = grid.getStore();

    if (grid.emptyText) {
      grid.getView().emptyText = grid.emptyText;
    }
    grid.getSelectionModel().deselectAll();
    // we have to remove filter directly as store#removeFilter() does not work when store#remoteFilter = true
    if (store.getFilters().removeAtKey('filter')) {
      if (store.getFilters().length) {
        store.filter();
      }
      else {
        store.clearFilter();
      }
    }
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/


/**
 * Metrics controller.
 *
 * @since 3.13
 */
Ext.define('NX.coreui.controller.MetricHealth', {
  extend: 'NX.app.Controller',
  requires: [
    'NX.Messages',
    'NX.Permissions',
    'NX.util.Url',
    'NX.I18n'
  ],

  views: [
    'support.MetricHealth'
  ],
  refs: [
    {
      ref: 'healthchecks',
      selector: 'nx-coreui-support-metric-health'
    },
    {
      ref: 'content',
      selector: 'nx-feature-content'
    }
  ],

  /**
   * @override
   */
  init: function () {
    var me = this;

    me.getApplication().getFeaturesController().registerFeature({
      mode: 'admin',
      path: '/Support/Status',
      view: { xtype: 'nx-coreui-support-metric-health' },
      text: NX.I18n.get('Metric_Health_Text'),
      description: NX.I18n.get('Metric_Health_Description'),
      iconConfig: {
        file: 'server_chart.png',
        variants: ['x16', 'x32']
      },
      visible: function () {
        return NX.Permissions.check('nexus:metrics:read');
      }
    }, me);

    me.listen({
      controller: {
        '#Refresh': {
          refresh: me.load
        }
      },
      component: {
        'nx-coreui-support-metric-health': {
          afterrender: me.load
        }
      }
    });
  },

  /**
   * Load metrics health information and populate Store.
   *
   * @private
   */
  load: function () {
    var me = this,
        panel = me.getHealthchecks(),
        loadStore = function (response) {
          var data = Ext.decode(response.responseText);
          var healthchecks = [];
          var keys = Ext.Object.getKeys(data);
          Ext.each(keys, function (key) {
            healthchecks.push({
              name: key,
              message: data[key].message,
              healthy: data[key].healthy,
              error: data[key].error
            });
          });
          panel.getStore().loadRawData(healthchecks);
        };
    
    if (!panel) {
      return;
    }

    me.getContent().getEl().mask(NX.I18n.get('Metric_Health_Load_Mask'));

    Ext.Ajax.request({
      url: NX.util.Url.urlOf('service/metrics/healthcheck'),
      method: 'GET',
      headers: {
        'accept': 'application/json'
      },
      scope: me,
      suppressStatus: true,

      callback: function (response) {
        me.getContent().getEl().unmask();
      },

      success: function (response) {
        loadStore(response);
      },
      failure: function (response) {
        // the server will respond with a 500 code if any checks fail, but the data is still returned
        loadStore(response);
      }
    });
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Asset store.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.store.ComponentAsset', {
  extend: 'Ext.data.Store',
  model: 'NX.coreui.model.Asset',

  proxy: {
    type: 'direct',

    api: {
      read: 'NX.direct.coreui_Component.readComponentAssets'
    },

    reader: {
      type: 'json',
      rootProperty: 'data',
      successProperty: 'success'
    }
  },

  remoteFilter: true,
  sorters: { property: 'name', direction: 'ASC' }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * npm repository search contribution.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.controller.SearchNpm', {
  extend: 'NX.app.Controller',
  requires: [
    'NX.I18n'
  ],

  /**
   * @override
   */
  init: function() {
    var me = this,
        search = me.getController('NX.coreui.controller.Search');

    search.registerCriteria([
      {
        id: 'group',
        group: NX.I18n.get('SearchNpm_Group'),
        config: {
          format: 'npm',
          fieldLabel: NX.I18n.get('SearchNpm_Scope_FieldLabel'),
          width: 250
        }
      },
      {
        id: 'assets.attributes.npm.author',
        group: NX.I18n.get('SearchNpm_Group'),
        config: {
          format: 'npm',
          fieldLabel: NX.I18n.get('SearchNpm_Author_FieldLabel'),
          width: 250
        }
      },
      {
        id: 'assets.attributes.npm.description',
        group: NX.I18n.get('SearchNpm_Group'),
        config: {
          format: 'npm',
          fieldLabel: NX.I18n.get('SearchNpm_Description_FieldLabel'),
          width: 250
        }
      },
      {
        id: 'assets.attributes.npm.keywords',
        group: NX.I18n.get('SearchNpm_Group'),
        config: {
          format: 'npm',
          fieldLabel: NX.I18n.get('SearchNpm_Keywords_FieldLabel'),
          width: 250
        }
      },
      {
        id: 'assets.attributes.npm.license',
        group: NX.I18n.get('SearchNpm_Group'),
        config: {
          format: 'npm',
          fieldLabel: NX.I18n.get('SearchNpm_License_FieldLabel'),
          width: 250
        }
      }
    ], me);

    search.registerFilter({
      id: 'npm',
      name: 'npm',
      text: NX.I18n.get('SearchNpm_Text'),
      description: NX.I18n.get('SearchNpm_Description'),
      readOnly: true,
      criterias: [
        { id: 'format', value: 'npm', hidden: true },
        { id: 'group' },
        { id: 'name.raw' },
        { id: 'version' },
        { id: 'assets.attributes.npm.author' },
        { id: 'assets.attributes.npm.description' },
        { id: 'assets.attributes.npm.keywords' },
        { id: 'assets.attributes.npm.license' }
      ]
    }, me);
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Http request settings fields.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.system.HttpRequestSettings', {
  extend: 'Ext.form.FieldContainer',
  alias: 'widget.nx-coreui-system-httprequestsettings',
  requires: [
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function() {
    Ext.apply(this, {
      items: [
        {
          xtype: 'textfield',
          name: 'userAgentSuffix',
          fieldLabel: NX.I18n.get('System_HttpRequestSettings_UserAgentCustomization_FieldLabel'),
          helpText: NX.I18n.get('System_HttpRequestSettings_UserAgentCustomization_HelpText')
        },
        {
          xtype: 'numberfield',
          name: 'timeout',
          fieldLabel: NX.I18n.get('System_HttpRequestSettings_Timeout_FieldLabel'),
          helpText: NX.I18n.get('System_HttpRequestSettings_Timeout_HelpText'),
          allowDecimals: false,
          allowExponential: false,
          minValue: 1,
          maxValue: 3600,
          emptyText: '20'
        },
        {
          xtype: 'numberfield',
          name: 'retries',
          fieldLabel: NX.I18n.get('System_HttpRequestSettings_Attempts_FieldLabel'),
          helpText: NX.I18n.get('System_HttpRequestSettings_Attempts_HelpText'),
          allowDecimals: false,
          allowExponential: false,
          minValue: 0,
          maxValue: 10,
          emptyText: '2'
        }
      ]
    });

    this.callParent();
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Add capability window.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.capability.CapabilityAdd', {
  extend: 'NX.view.AddPanel',
  alias: 'widget.nx-coreui-capability-add',
  requires: [
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    me.settingsForm = {
      xtype: 'nx-coreui-capability-settings-form',
      editableCondition: NX.Conditions.isPermitted('nexus:capabilities:create'),
      editableMarker: NX.I18n.get('Capability_CapabilitySettingsForm_Update_Error'),

      buttons: [
        { text: NX.I18n.get('Capability_CapabilityList_New_Button'), action: 'add', formBind: true, ui: 'nx-primary' },
        { text: NX.I18n.get('Add_Cancel_Button'), action: 'back' }
      ]
    };

    me.callParent();
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * User "Settings" form.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.user.UserSettingsForm', {
  extend: 'NX.view.SettingsForm',
  alias: 'widget.nx-coreui-user-settings-form',
  requires: [
    'NX.Conditions',
    'NX.I18n'
  ],

  api: {
    submit: 'NX.direct.coreui_User.update'
  },

  initComponent: function() {
    var me = this;

    me.settingsFormSuccessMessage = me.settingsFormSuccessMessage || function(data) {
      return NX.I18n.get('User_UserSettingsForm_Update_Success') + Ext.htmlEncode(data['userId']);
    };

    me.editableMarker = NX.I18n.get('User_UserSettingsForm_Update_Error');

    me.editableCondition = me.editableCondition || NX.Conditions.and(
        NX.Conditions.isPermitted('nexus:users:update'),
        NX.Conditions.formHasRecord('nx-coreui-user-settings-form', function(model) {
          return !model.get('external');
        })
    );

    me.items = [
      {
        name: 'userId',
        itemId: 'userId',
        readOnly: true,
        fieldLabel: NX.I18n.get('User_UserSettingsForm_ID_FieldLabel'),
        helpText: NX.I18n.get('User_UserSettingsForm_ID_HelpText')
      },
      { name: 'version', xtype: 'hiddenfield' },
      {
        name: 'firstName',
        fieldLabel: NX.I18n.get('User_UserSettingsForm_FirstName_FieldLabel')
      },
      {
        name: 'lastName',
        fieldLabel: NX.I18n.get('User_UserSettingsForm_LastName_FieldLabel')
      },
      {
        xtype: 'nx-email',
        name: 'email',
        fieldLabel: NX.I18n.get('User_UserSettingsForm_Email_FieldLabel'),
        helpText: NX.I18n.get('User_UserSettingsForm_Email_HelpText')
      },
      {
        xtype: 'combo',
        name: 'status',
        fieldLabel: NX.I18n.get('User_UserSettingsForm_Status_FieldLabel'),
        emptyText: NX.I18n.get('User_UserSettingsForm_Status_EmptyText'),
        allowBlank: false,
        editable: false,
        store: [
          ['active', NX.I18n.get('User_UserSettingsForm_Status_ActiveItem')],
          ['disabled', NX.I18n.get('User_UserSettingsForm_Status_DisabledItem')]
        ],
        queryMode: 'local'
      },
      {
        xtype: 'nx-itemselector',
        name: 'roles',
        itemId: 'roles',
        fieldLabel: NX.I18n.get('User_UserSettingsExternalForm_Roles_FieldLabel'),
        buttons: ['add', 'remove'],
        fromTitle: NX.I18n.get('User_UserSettingsExternalForm_Roles_FromTitle'),
        toTitle: NX.I18n.get('User_UserSettingsExternalForm_Roles_ToTitle'),
        store: 'Role',
        valueField: 'id',
        displayField: 'name',
        delimiter: null
      }
    ];

    me.callParent();
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Repository "Settings" form for a Yum Proxy repository
 *
 * @since 3.4
 */
Ext.define('NX.coreui.view.repository.recipe.YumProxy', {
  extend: 'NX.coreui.view.repository.RepositorySettingsForm',
  alias: 'widget.nx-coreui-repository-yum-proxy',
  requires: [
    'NX.coreui.view.repository.facet.ProxyFacet',
    'NX.coreui.view.repository.facet.StorageFacet',
    'NX.coreui.view.repository.facet.HttpClientFacet',
    'NX.coreui.view.repository.facet.NegativeCacheFacet',
    'NX.coreui.view.repository.facet.CleanupPolicyFacet'
  ],

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    me.items = [
      {xtype: 'nx-coreui-repository-proxy-facet'},
      {xtype: 'nx-coreui-repository-storage-facet'},
      {xtype: 'nx-coreui-repository-negativecache-facet'},
      {xtype: 'nx-coreui-repository-cleanup-policy-facet'},
      {xtype: 'nx-coreui-repository-httpclient-facet'}
    ];

    me.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Repository "Settings" form for a Bower Proxy repository
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.repository.recipe.BowerProxy', {
  extend: 'NX.coreui.view.repository.RepositorySettingsForm',
  alias: 'widget.nx-coreui-repository-bower-proxy',
  requires: [
    'NX.coreui.view.repository.facet.ProxyFacet',
    'NX.coreui.view.repository.facet.StorageFacet',
    'NX.coreui.view.repository.facet.HttpClientFacet',
    'NX.coreui.view.repository.facet.NegativeCacheFacet',
    'NX.coreui.view.repository.facet.BowerProxyFacet',
    'NX.coreui.view.repository.facet.CleanupPolicyFacet'
  ],

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    me.items = [
      {xtype: 'nx-coreui-repository-bower-proxy-facet'},
      {xtype: 'nx-coreui-repository-proxy-facet'},
      {xtype: 'nx-coreui-repository-storage-facet'},
      {xtype: 'nx-coreui-repository-negativecache-facet'},
      {xtype: 'nx-coreui-repository-cleanup-policy-facet'},
      {xtype: 'nx-coreui-repository-httpclient-facet'}
    ];

    me.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * License Users controller.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.controller.LicenseUsers', {
  extend: 'NX.app.Controller',
  requires: [
    'NX.Permissions',
    'NX.util.DownloadHelper',
    'NX.util.Url',
    'NX.I18n'
  ],

  stores: [
    'LicenseUser'
  ],
  views: [
    'licensing.LicenseUserList'
  ],
  refs: [
    {
      ref: 'list',
      selector: 'nx-coreui-licensing-licenseuser-list'
    }
  ],

  /**
   * @override
   */
  init: function () {
    var me = this;

    me.getApplication().getIconController().addIcons({
      'licenseuser-default': {
        file: 'ssl_certificates.png',
        variants: ['x16', 'x32']
      }
    });

    me.getApplication().getFeaturesController().registerFeature({
      mode: 'admin',
      path: '/System/Licensing/License Users',
      text: NX.I18n.get('LicenseUsers_Title'),
      description: NX.I18n.get('LicenseUsers_Description'),
      view: { xtype: 'nx-coreui-licensing-licenseuser-list' },
      iconConfig: {
        file: 'ssl_tls_manager.png',
        variants: ['x16', 'x32']
      },
      visible: function () {
        return NX.Permissions.check('nexus:licensing:read');
      }
    }, me);

    me.listen({
      controller: {
        '#Refresh': {
          refresh: me.load
        }
      },
      component: {
        'nx-coreui-licensing-licenseuser-list': {
          afterrender: me.load
        },
        'nx-coreui-licensing-licenseuser-list button[action=download]': {
          click: me.download
        }
      }
    });
  },

  /**
   * @private
   * Load active user store.
   */
  load: function () {
    var list = this.getList();

    if (list) {
      list.getStore().load();
    }
  },

  /**
   * @private
   * Download active users in CSV format.
   */
  download: function () {
    NX.util.DownloadHelper.downloadUrl(NX.util.Url.urlOf('service/rest/licensing/csv_access_data'));
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Role feature panel.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.role.RoleFeature', {
  extend: 'NX.view.drilldown.Drilldown',
  alias: 'widget.nx-coreui-role-feature',
  requires: [
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function() {
    Ext.apply(this, {
      iconName: 'role-default',

      masters: [
        { xtype: 'nx-coreui-role-list' }
      ],

      tabs: [
        { xtype: 'nx-coreui-role-settings', title: NX.I18n.get('Role_RoleFeature_Settings_Title'), weight: 10 }
      ],

      nxActions: [
        { xtype: 'button', text: NX.I18n.get('Role_RoleFeature_Delete_Button'), glyph: 'xf1f8@FontAwesome' /* fa-trash */, action: 'delete', disabled: true }
      ]
    });

    this.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Security realms controller.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.controller.RealmSettings', {
  extend: 'NX.app.Controller',
  requires: [
    'NX.Permissions',
    'NX.I18n'
  ],

  views: [
    'security.RealmSettings'
  ],

  stores: [
    'RealmType'
  ],

  refs: [
    {
      ref: 'panel',
      selector: 'nx-coreui-security-realm-settings'
    },
    {
      ref: 'form',
      selector: 'nx-coreui-security-realm-settings nx-settingsform'
    }
  ],

  /**
   * @override
   */
  init: function () {
    var me = this;

    me.getApplication().getFeaturesController().registerFeature({
      mode: 'admin',
      path: '/Security/Realms',
      view: { xtype: 'nx-coreui-security-realm-settings' },
      text: NX.I18n.get('RealmSettings_Text'),
      description: NX.I18n.get('RealmSettings_Description'),
      iconConfig: {
        file: 'shield.png',
        variants: ['x16', 'x32']
      },
      visible: function () {
        return NX.Permissions.check('nexus:settings:read');
      }
    }, me);

    me.listen({
      controller: {
        '#Refresh': {
          refresh: me.loadRealmTypes
        }
      },
      component: {
        'nx-coreui-security-realm-settings': {
          beforerender: me.loadRealmTypes
        }
      }
    });
  },

  /**
   * @private
   */
  loadRealmTypes: function () {
    var me = this,
        panel = me.getPanel();

    if (panel) {
      me.getStore('RealmType').load(function() {
        // The form depends on this store, so load it after the store has loaded
        var form = me.getForm();
        if (form) {
          form.load();
        }
      });
    }
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Git LFS repository search contribution.
 *
 * @since 3.3
 */
Ext.define('NX.coreui.controller.SearchGitLfs', {
  extend: 'NX.app.Controller',
  requires: [
    'NX.I18n'
  ],

  /**
   * @override
   */
  init: function() {
    var me = this,
        search = me.getController('NX.coreui.controller.Search');

    search.registerFilter({
      id: 'gitlfs',
      name: 'Git LFS',
      text: NX.I18n.get('SearchGitLfs_Text'),
      description: NX.I18n.get('SearchGitLfs_Description'),
      readOnly: true,
      criterias: [
        { id: 'format', value: 'gitlfs', hidden: true },
        { id: 'name.raw' }
      ]
    }, me);
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Metrics panel.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.support.Metrics', {
  extend: 'Ext.panel.Panel',
  alias: 'widget.nx-coreui-support-metrics',
  requires: [
    'Ext.chart.Chart',
    'Ext.chart.theme.*',
    'Ext.data.ArrayStore',
    'NX.Assert',
    'NX.I18n'
  ],
  scrollable: true,
  cls: 'nx-coreui-support-metrics',

  /**
   * @private
   */
  widgetPanel: function (title) {
    return {
      xtype: 'panel',
      ui: 'nx-subsection',
      cls: 'metricwidget',
      frame: true,
      height: 240,
      width: 300,
      layout: 'fit',
      colspan: 2,
      title: title
    };
  },

  /**
   * @private
   */
  nameDataTip: function(suffix) {
    return function(tooltip, record, context) {
      var title = record.get('name') + ': ' + record.get('data') + ' ' + suffix;
      var percentage = record.get('percentage');

      if (percentage) {
        title += " (" + percentage + "%)";
      }

      tooltip.setTitle(title);
    }
  },

  /**
   * @private
   */
  highlightConfig: {
    opacity: 0.8,
    stroke: '#55c',
    'stroke-width': 3
  },

  /**
   * @override
   */
  initComponent: function() {
    Ext.apply(this, {
      dockedItems: [{
        xtype: 'nx-actions',
        items: [
          {
            xtype: 'button',
            text: NX.I18n.get('Support_Metrics_Download_Button'),
            tooltip: NX.I18n.get('Metrics_Download_Tooltip'),
            glyph: 'xf019@FontAwesome' /* fa-download */,
            action: 'download'
          },
          '-',
          {
            xtype: 'button',
            text: NX.I18n.get('Support_Metrics_Dump_Button'),
            tooltip: NX.I18n.get('Support_Metrics_Dump_Tooltip'),
            glyph: 'xf019@FontAwesome' /* fa-download */,
            action: 'threads'
          }
        ]
      }],

      items: {
        xtype: 'panel',
        cls: [
          'nx-inset',
          'nx-hr'
        ],
        layout: 'column',

        // FIXME: Remove use of ui 'nx-subsection', adjust scss style of .nx-coreui-support-metrics .metricwidget

        items: [
          Ext.apply(this.widgetPanel(NX.I18n.get('Support_Metrics_MemoryUsage_Title')),
              {
                items: [
                  {
                    xtype: 'polar',
                    itemId: 'memoryUsage',
                    animate: false,
                    downloadServerUrl: ' ', // NEXUS-16479 avoids console warnings about security  //NOSONAR
                    insetPadding: 20,
                    colors: ['#5f7f1c', '#8ebd2b', '#ddd'],
                    store: Ext.create('Ext.data.ArrayStore', {
                      fields: ['name', 'data', 'percentage']
                    }),
                    series: [
                      {
                        type: 'pie',
                        angleField: 'data',
                        showInLegend: true,

                        label: {
                          field: 'name',
                          display: 'none'
                        },

                        tips: {
                          trackMouse: true,
                          renderer: this.nameDataTip('bytes')
                        }
                      }
                    ],
                    legend: {
                      docked: 'right'
                    }
                  }
                ]
              }
          ),
          Ext.apply(this.widgetPanel(NX.I18n.get('Support_Metrics_ThreadStates_Title')),
              {
                items: [
                  {
                    xtype: 'polar',
                    itemId: 'threadStates',
                    animate: false,
                    downloadServerUrl: ' ', // NEXUS-16479 avoids console warnings about security  //NOSONAR
                    insetPadding: 20,
                    theme: 'Base',
                    store: Ext.create('Ext.data.ArrayStore', {
                      fields: ['name', 'data']
                    }),
                    series: [
                      {
                        type: 'pie',
                        angleField: 'data',
                        showInLegend: true,

                        label: {
                          field: 'name',
                          display: 'none'
                        },

                        tips: {
                          trackMouse: true,
                          renderer: this.nameDataTip('')
                        }
                      }
                    ],
                    legend: {
                      docked: 'right',
                      boxStrokeWidth: 0
                    }
                  }
                ]
              }
          ),
          Ext.apply(this.widgetPanel(NX.I18n.get('Support_Metrics_Dispatches_Title')),
              {
                items: [
                  {
                    xtype: 'chart',
                    itemId: 'activeRequests',
                    animate: false,
                    downloadServerUrl: ' ', // NEXUS-16479 avoids console warnings about security  //NOSONAR
                    insetPadding: 20,
                    theme: 'Base',
                    flipXY: true,
                    store: Ext.create('Ext.data.ArrayStore', {
                      fields: ['name', 'data']
                    }),
                    axes: [
                      {
                        type: 'category',
                        position: 'left',
                        fields: ['name']
                      }
                    ],
                    series: [
                      {
                        type: 'bar',
                        axis: 'bottom',
                        highlight: true,
                        highlightCfg: this.highlightConfig,
                        label: {
                          display: 'insideEnd',
                          field: 'data',
                          renderer: Ext.util.Format.numberRenderer('0'),
                          orientation: 'horizontal',
                          color: '#333',
                          'text-anchor': 'middle'
                        },
                        xField: 'name',
                        yField: 'data',
                        tips: {
                          trackMouse: true,
                          renderer: this.nameDataTip('requests')
                        }
                      }
                    ]
                  }
                ]
              }
          ),
          Ext.apply(this.widgetPanel(NX.I18n.get('Support_Metrics_ResponseCode_Title')),
              {
                items: [
                  {
                    xtype: 'chart',
                    itemId: 'responseCodes',
                    animate: false,
                    downloadServerUrl: ' ', // NEXUS-16479 avoids console warnings about security  //NOSONAR
                    insetPadding: 20,
                    theme: 'Category1',
                    flipXY: true,
                    store: Ext.create('Ext.data.ArrayStore', {
                      fields: ['name', 'data'],
                      sorters: {property: 'name', direction: 'DESC'}
                    }),
                    axes: [
                      {
                        type: 'category',
                        position: 'left',
                        fields: ['name']
                      }
                    ],
                    series: [
                      {
                        type: 'bar',
                        axis: 'bottom',
                        highlight: true,
                        highlightCfg: this.highlightConfig,
                        tips: {
                          trackMouse: true,
                          renderer: this.nameDataTip('responses')
                        },
                        label: {
                          display: 'insideEnd',
                          field: 'data',
                          renderer: Ext.util.Format.numberRenderer('0'),
                          orientation: 'horizontal',
                          color: '#333',
                          'text-anchor': 'middle'
                        },
                        xField: 'name',
                        yField: 'data',
                        renderer: function (sprite, config, rendererData, index) {
                          var record = rendererData.store.getAt(index);
                          var color;
                          switch (record.get('name')) {
                            case '5xx':
                              color = 'rgb(255, 0, 0)';
                              break;
                            default: // covers all but error cases
                              color = 'rgb(68,220,225)';
                              break;
                          }
                          return Ext.apply(config, {
                            fill: color
                          });
                        }
                      }
                    ]
                  }
                ]
              }
          ),
          Ext.apply(this.widgetPanel(NX.I18n.get('Support_Metrics_Requests_Title')),
              {
                items: [
                  {
                    xtype: 'chart',
                    itemId: 'webRequests',
                    animate: false,
                    downloadServerUrl: ' ', // NEXUS-16479 avoids console warnings about security  //NOSONAR
                    insetPadding: 20,
                    theme: 'Category6',
                    flipXY: true,
                    store: Ext.create('Ext.data.ArrayStore', {
                      fields: ['name', 'data'],
                      sorters: {property: 'name', direction: 'DESC'}
                    }),
                    axes: [
                      {
                        type: 'category',
                        position: 'left',
                        fields: ['name']
                      }
                    ],
                    series: [
                      {
                        type: 'bar',
                        axis: 'bottom',
                        highlight: true,
                        highlightCfg: this.highlightConfig,
                        tips: {
                          trackMouse: true,
                          renderer: this.nameDataTip('requests')
                        },
                        label: {
                          display: 'insideEnd',
                          field: 'data',
                          renderer: Ext.util.Format.numberRenderer('0'),
                          orientation: 'horizontal',
                          color: '#333',
                          'text-anchor': 'middle'
                        },
                        xField: 'name',
                        yField: 'data'
                      }
                    ]
                  }
                ]
              }
          )
        ]
      }
    });

    this.callParent();
  },

  /**
   * Load the data into the store of the component referred to by the query.
   *
   * @private
   * @param data to be loaded
   * @param query used to find the component
   */
  loadStoreByQuery: function (data, query) {
    if (!this.rendered) {
      return;
    }

    var p = this.down(query);
    //<if assert>
//    NX.Assert.assert(p, "Expected this.down('" + query + "') to return component");
    //</if>
    if (p) {
      p.getStore().loadData(data);
    }
  },

  /**
   * @public
   */
  setMemoryUsageData: function (data) {
    this.loadStoreByQuery(data, 'panel #memoryUsage');
  },

  /**
   * @public
   */
  setThreadStatesData: function (data) {
    this.loadStoreByQuery(data, 'panel #threadStates');
  },

  /**
   * @public
   */
  setActiveRequestsData: function(data) {
    this.loadStoreByQuery(data, 'panel #activeRequests');
  },

  /**
   * @public
   */
  setResponseCodeData: function(data) {
    this.loadStoreByQuery(data, 'panel #responseCodes');
  },

  /**
   * @public
   */
  setWebRequestData: function(data) {
    this.loadStoreByQuery(data, 'panel #webRequests');
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/


/**
 * Metrics controller.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.controller.Metrics', {
  extend: 'NX.app.Controller',
  requires: [
    'Ext.Ajax',
    'NX.Messages',
    'NX.Permissions',
    'NX.util.Url',
    'NX.util.DownloadHelper',
    'NX.I18n'
  ],

  views: [
    'support.Metrics'
  ],
  refs: [
    {
      ref: 'metrics',
      selector: 'nx-coreui-support-metrics'
    },
    {
      ref: 'content',
      selector: 'nx-feature-content'
    }
  ],

  /**
   * @override
   */
  init: function () {
    var me = this;

    me.getApplication().getFeaturesController().registerFeature({
      mode: 'admin',
      path: '/Support/Metrics',
      view: { xtype: 'nx-coreui-support-metrics' },
      text: NX.I18n.get('Metrics_Text'),
      description: NX.I18n.get('Metrics_Description'),
      iconConfig: {
        file: 'chart_pie.png',
        variants: ['x16', 'x32']
      },
      visible: function () {
        return NX.Permissions.check('nexus:metrics:read');
      }
    }, me);

    me.listen({
      controller: {
        '#Refresh': {
          refresh: me.load
        }
      },
      component: {
        'nx-coreui-support-metrics': {
          afterrender: me.load
        },
        'nx-coreui-support-metrics button[action=download]': {
          'click': me.downloadMetrics
        },
        'nx-coreui-support-metrics button[action=threads]': {
          'click': me.downloadThreads
        }
      }
    });
  },

  /**
   * Load metrics information and update charts.
   *
   * @private
   */
  load: function () {
    var me = this,
        panel = me.getMetrics();

    if (!panel) {
      return;
    }

    me.getContent().getEl().mask(NX.I18n.get('Metrics_Load_Mask'));

    Ext.Ajax.request({
      url: NX.util.Url.urlOf('service/metrics/data'),
      method: 'GET',
      headers: {
        'accept': 'application/json'
      },
      scope: me,
      suppressStatus: true,

      callback: function (response) {
        me.getContent().getEl().unmask();
      },

      failure: function (response) {
        NX.Messages.add({ type: 'warning', text: NX.I18n.get('Metrics_Refresh_Warning') });
      },

      success: function (response) {
        var data = Ext.decode(response.responseText);
        var memoryTotalMax = gaugeValue('jvm.memory.total.max');
        var memoryUsed = gaugeValue('jvm.memory.total.used');
        var memoryAvailable = memoryTotalMax - memoryUsed;
        var memoryHeap = gaugeValue('jvm.memory.heap.used');
        var memoryHeapPercentage = Math.round((memoryHeap / memoryTotalMax) * 100);
        var memoryNonHeap = memoryUsed - memoryHeap;
        var memoryNonHeapPercentage = Math.round((memoryNonHeap / memoryTotalMax) * 100);

        // return gauge value
        function gaugeValue(name) {
          return data.gauges[name].value;
        }
        
        // return count from counter
        function counterValue(name) {
          return data.counters[name].count;
        }
       
        // return count from meter
        function meterCountValue(name) {
          return data.meters[name].count;
        }

        // return count from timer
        function timerCountValue(name) {
          return data.timers[name].count;
        }

        // update memory charts
        panel.setMemoryUsageData([
          {
            name: NX.I18n.get('Support_Metrics_Heap_Title'),
            data: memoryHeap,
            percentage: memoryHeapPercentage
          },
          {
            name: NX.I18n.get('Metrics_Heap_NonHeapItem'),
            data: memoryNonHeap,
            percentage: memoryNonHeapPercentage
          },
          {
            name: NX.I18n.get('Metrics_Heap_Available'),
            data: memoryAvailable,
            percentage: 100 - memoryHeapPercentage - memoryNonHeapPercentage
          }
        ]);

        // update threads charts
        panel.setThreadStatesData([
          { name: NX.I18n.get('Metrics_ThreadStates_New'), data: gaugeValue('jvm.thread-states.new.count') },
          { name: NX.I18n.get('Metrics_ThreadStates_Terminated'), data: gaugeValue('jvm.thread-states.terminated.count') },
          { name: NX.I18n.get('Metrics_ThreadStates_Blocked'), data: gaugeValue('jvm.thread-states.blocked.count') },
          { name: NX.I18n.get('Metrics_ThreadStates_Runnable'), data: gaugeValue('jvm.thread-states.runnable.count') },
          { name: NX.I18n.get('Metrics_ThreadStates_TimedWaiting'), data: gaugeValue('jvm.thread-states.timed_waiting.count') },
          { name: NX.I18n.get('Metrics_ThreadStates_Waiting'), data: gaugeValue('jvm.thread-states.waiting.count') }
        ]);
        
        // update active requests
        panel.setActiveRequestsData([
          { name: 'active-requests', data: counterValue('org.eclipse.jetty.webapp.WebAppContext.active-requests') },
          { name: 'active-dispatches', data: counterValue('org.eclipse.jetty.webapp.WebAppContext.active-dispatches') },
          { name: 'active-suspended', data: counterValue('org.eclipse.jetty.webapp.WebAppContext.active-suspended') }
        ]);
        
        // update web response codes
        panel.setResponseCodeData([
          {name: '1xx', data: meterCountValue('org.eclipse.jetty.webapp.WebAppContext.1xx-responses')},
          {name: '2xx', data: meterCountValue('org.eclipse.jetty.webapp.WebAppContext.2xx-responses')},
          {name: '3xx', data: meterCountValue('org.eclipse.jetty.webapp.WebAppContext.3xx-responses')},
          {name: '4xx', data: meterCountValue('org.eclipse.jetty.webapp.WebAppContext.4xx-responses')},
          {name: '5xx', data: meterCountValue('org.eclipse.jetty.webapp.WebAppContext.5xx-responses')}
        ]);
        
        panel.setWebRequestData([
          {name: 'GET', data: timerCountValue('org.eclipse.jetty.webapp.WebAppContext.get-requests')},    
          {name: 'PUT', data: timerCountValue('org.eclipse.jetty.webapp.WebAppContext.put-requests')},    
          {name: 'POST', data: timerCountValue('org.eclipse.jetty.webapp.WebAppContext.post-requests')},    
          {name: 'DELETE', data: timerCountValue('org.eclipse.jetty.webapp.WebAppContext.delete-requests')},    
          {name: 'OTHER', data: timerCountValue('org.eclipse.jetty.webapp.WebAppContext.other-requests')},    
          {name: 'OPTIONS', data: timerCountValue('org.eclipse.jetty.webapp.WebAppContext.options-requests')}    
        ]);
      }
    });
  },

  /**
   * @private
   * Download metrics data.
   */
  downloadMetrics: function () {
    NX.util.DownloadHelper.downloadUrl(NX.util.Url.urlOf('service/metrics/data?pretty=true&download=true'));
  },

  /**
   * @private
   * Download thread dump.
   */
  downloadThreads: function () {
    NX.util.DownloadHelper.downloadUrl(NX.util.Url.urlOf('service/metrics/threads?download=true'));
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * User feature panel.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.user.UserFeature', {
  extend: 'NX.view.drilldown.Drilldown',
  alias: 'widget.nx-coreui-user-feature',
  requires: [
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function() {
    Ext.apply(this, {
      iconName: 'user-default',

      masters: [
        { xtype: 'nx-coreui-user-list' }
      ],

      tabs: [
        { xtype: 'nx-coreui-user-settings', title: NX.I18n.get('User_UserFeature_Settings_Title'), weight: 10 }
      ],

      nxActions: [
        { xtype: 'button', text: NX.I18n.get('User_UserFeature_Delete_Button'), glyph: 'xf1f8@FontAwesome' /* fa-trash */, action: 'delete', disabled: true },
        { xtype: 'button', text: NX.I18n.get('User_UserFeature_ChangePasswordItem'), glyph: 'xf084@FontAwesome' /* fa-key */, action: 'setpassword', disabled: true}
      ]
    });

    this.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Privilege type store.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.store.PrivilegeType', {
  extend: 'Ext.data.Store',
  model: 'NX.coreui.model.PrivilegeType',
  requires: [
    'NX.State'
  ],

  proxy: {
    type: 'direct',
    paramsAsHash: false,
    api: {
      read: 'NX.direct.coreui_Privilege.readTypes'
    },

    reader: {
      type: 'json',
      rootProperty: 'data',
      successProperty: 'success'
    }
  },

  sorters: { property: 'name', direction: 'ASC' }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Configuration for Yum hosted repodata level.
 *
 * @since 3.8
 */
Ext.define('NX.coreui.view.repository.facet.YumHostedFacet', {
  extend: 'Ext.form.FieldContainer',
  alias: 'widget.nx-coreui-repository-yum-hosted-facet',
  requires: [
    'NX.I18n',
    'Ext.form.ComboBox'
  ],

  /**
   * @override
   */
  initComponent: function() {
    var me = this;

    me.items = [
      {
        xtype: 'fieldset',
        cls: 'nx-form-section',
        title: NX.I18n.get('Repository_Facet_YumHostedFacet_Title'),
        items: [
          {
            xtype: 'combo',
            name: 'attributes.yum.repodataDepth',
            fieldLabel: NX.I18n.get('Repository_Facet_YumHostedFacet_RepodataDepth_FieldLabel'),
            helpText: NX.I18n.get('Repository_Facet_YumHostedFacet_RepodataDepth_HelpText'),
            forceSelection: true,
            editable: false,
            allowBlank: false,
            store : [0, 1, 2, 3, 4, 5]
          },
          {
            xtype: 'combo',
            name: 'attributes.yum.deployPolicy',
            fieldLabel: NX.I18n.get('Repository_Facet_YumHostedFacet_DeployPolicy_FieldLabel'),
            helpText: NX.I18n.get('Repository_Facet_YumHostedFacet_DeployPolicy_HelpText'),
            emptyText: NX.I18n.get('Repository_Facet_YumHostedFacet_DeployPolicy_EmptyText'),
            editable: false,
            store: [
              ['STRICT', NX.I18n.get('Repository_Facet_YumHostedFacet_DeployPolicy_StrictItem')],
              ['PERMISSIVE', NX.I18n.get('Repository_Facet_YumHostedFacet_DeployPolicy_PermissiveItem')]
            ],
            value: 'STRICT'
          }
        ]
      }
    ];

    me.callParent();
  }
});


/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Repository "Settings" form for a Yum Hosted repository.
 *
 * @since 3.8
 */
Ext.define('NX.coreui.view.repository.recipe.YumHosted', {
  extend: 'NX.coreui.view.repository.RepositorySettingsForm',
  alias: 'widget.nx-coreui-repository-yum-hosted',
  requires: [
    'NX.coreui.view.repository.facet.StorageFacet',
    'NX.coreui.view.repository.facet.StorageFacetHosted',
    'NX.coreui.view.repository.facet.YumHostedFacet',
    'NX.coreui.view.repository.facet.CleanupPolicyFacet'
  ],

  /**
   * @override
   */
  initComponent: function() {
    var me = this;

    me.items = [
      { xtype: 'nx-coreui-repository-yum-hosted-facet'},
      { xtype: 'nx-coreui-repository-storage-facet'},
      { xtype: 'nx-coreui-repository-storage-hosted-facet'},
      { xtype: 'nx-coreui-repository-cleanup-policy-facet'}
    ];

    me.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * System Information panel.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.support.SysInfo', {
  extend: 'Ext.panel.Panel',
  alias: 'widget.nx-coreui-support-sysinfo',
  requires: [
    'Ext.XTemplate',
    'NX.Assert',
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function() {
    var me = this;

    me.layout = 'fit';

    me.dockedItems = [{
      xtype: 'nx-actions',
      items: [
        {
          xtype: 'button',
          text: NX.I18n.get('Support_SysInfo_Download_Button'),
          glyph: 'xf019@FontAwesome' /* fa-download */,
          action: 'download'
        }
      ]
    }];

    // simple named section with list of key-value properties
    me.sectionTpl = Ext.create('Ext.XTemplate',
      '<div class="x-panel x-panel-nx-subsection-framed">',
      '<div class="x-panel-header x-panel-header-nx-subsection-framed">',
      '<div class="x-title x-panel-header-title x-panel-header-title-nx-subsection-framed x-title-nx-subsection-framed">',
      '<div class="x-title-text x-title-text-nx-subsection-framed x-title-item">{name}</div></div></div>',
      '<div class="x-panel-bodyWrap">',
      '<div class="x-panel-body x-panel-body-nx-subsection-framed">',
      '<table>',
      '<tpl for="props">',
      '<tr>',
      '<td class="nx-info-entry-name">{name}</td>',
      '<td class="nx-info-entry-value">{value}</td>',
      '</tr>',
      '</tpl>',
      '</table>',
      '</div></div></div>',
      {
        compiled: true
      }
    );

    // nested named section with list of child named sections
    me.nestedSectionTpl = Ext.create('Ext.XTemplate',
      '<div class="x-panel x-panel-nx-subsection-framed">',
      '<div class="x-panel-header x-panel-header-nx-subsection-framed">',
      '<div class="x-title x-panel-header-title x-panel-header-title-nx-subsection-framed x-title-nx-subsection-framed">',
      '<div class="x-title-text x-title-text-nx-subsection-framed x-title-item">{name}</div></div></div>',
      '<div class="x-panel-bodyWrap">',
      '<div class="x-panel-body x-panel-body-nx-subsection-framed">',
      '<tpl for="nested">',
      '<h3>{name}</h3>',
      '<table>',
      '<tpl for="props">',
      '<tr>',
      '<td class="nx-info-entry-name">{name}</td>',
      '<td class="nx-info-entry-value">{value}</td>',
      '</tr>',
      '</tpl>',
      '</table>',
      '</tpl>',
      '</div></div></div>',
      {
        compiled: true
      }
    );

    // Helper to convert an object into an array of {name,value} properties
    function objectToProperties(obj) {
      var props = [];
      Ext.iterate(obj, function(key, value) {
        props.push({
          name: key,
          value: value
        });
      });
      return props;
    }

    // Main template renders all sections
    me.mainTpl = Ext.create('Ext.XTemplate',
        '<div class="nx-atlas-view-sysinfo-body nx-hr" style="height: 100%; overflow-y: scroll;">',
        '<div class="x-panel x-panel-nx-inset">',
        // nexus details
        '{[ this.section("nexus-status", values) ]}',
        '{[ this.section("nexus-node", values) ]}',
        '{[ this.section("nexus-configuration", values) ]}',
        '{[ this.section("nexus-properties", values) ]}',
        '{[ this.section("nexus-license", values) ]}',
        '{[ this.nestedSection("nexus-bundles", values) ]}',
        // system details
        '{[ this.section("system-time", values) ]}',
        '{[ this.section("system-properties", values) ]}',
        '{[ this.section("system-environment", values) ]}',
        '{[ this.section("system-runtime", values) ]}',
        '{[ this.nestedSection("system-network", values) ]}',
        '{[ this.nestedSection("system-filestores", values) ]}',
        '</div>',
        '</div>',
        {
          compiled: true,

          /**
           * Render a section.
           */
          section: function(name, values) {
            var data = values[name];

            return me.sectionTpl.apply({
              name: name,
              props: objectToProperties(data)
            });
          },

          /**
           * Render a nested section.
           */
          nestedSection: function(name, values) {
            var data = values[name],
                nested = [];

            Ext.iterate(data, function(key, value) {
              nested.push({
                name: key,
                props: objectToProperties(value)
              });
            });

            return me.nestedSectionTpl.apply({
              name: name,
              nested: nested
            });
          }
        }
    );

    me.callParent();
  },

  /**
   * Update the system information display.
   *
   * @public
   */
  setInfo: function(info) {
    var me = this;

    if (me.rendered) {
      me.mainTpl.overwrite(me.body, info);
    }
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Yum repository search contribution.
 *
 * @since 3.4
 */
Ext.define('NX.coreui.controller.SearchYum', {
  extend: 'NX.app.Controller',
  requires: [
    'NX.I18n'
  ],

  /**
   * @override
   */
  init: function() {
    var me = this,
        search = me.getController('NX.coreui.controller.Search');

    search.registerCriteria([
      {
        id: 'assets.attributes.yum.architecture',
        group: NX.I18n.get('SearchYum_Group'),
        config: {
          format: 'yum',
          fieldLabel: NX.I18n.get('SearchYum_Architecture_FieldLabel'),
          width: 250
        }
      },
      {
        id: 'attributes.yum.name',
        group: NX.I18n.get('SearchYum_Group'),
        config: {
          format: 'yum',
          fieldLabel: NX.I18n.get('SearchYum_Name_FieldLabel'),
          width: 250
        }
      }
    ], me);

    search.registerFilter({
      id: 'yum',
      name: 'Yum',
      text: NX.I18n.get('SearchYum_Text'),
      description: NX.I18n.get('SearchYum_Description'),
      readOnly: true,
      criterias: [
        { id: 'format', value: 'yum', hidden: true },
        { id: 'attributes.yum.name' },
        { id: 'version' },
        { id: 'assets.attributes.yum.architecture' }
      ]
    }, me);
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Role store.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.store.Role', {
  extend: 'Ext.data.Store',
  model: 'NX.coreui.model.Role',

  proxy: {
    type: 'direct',
    paramsAsHash: false,

    api: {
      read: 'NX.direct.coreui_Role.read'
    },

    reader: {
      type: 'json',
      rootProperty: 'data',
      successProperty: 'success'
    }
  },

  sorters: { property: 'name', direction: 'ASC' },

  listeners: {
    load: function(store, records) {
      // loop all roles, and sort the inner privileges array
      for (var i = 0; i < records.length; i++) {
        var role = records[i].data;
        role.privileges = Ext.Array.sort(role.privileges);
      }
    }
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Role "Settings" form.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.role.RoleSettingsForm', {
  extend: 'NX.view.SettingsForm',
  alias: 'widget.nx-coreui-role-settings-form',
  requires: [
    'NX.Conditions',
    'NX.coreui.store.Role',
    'NX.I18n',
    'NX.util.Validator'
  ],

  api: {
    submit: 'NX.direct.coreui_Role.update'
  },

  initComponent: function() {
    var me = this,
        idField;

    me.settingsFormSuccessMessage = me.settingsFormSuccessMessage || function(data) {
      return NX.I18n.get('Role_RoleSettingsForm_Update_Success') + Ext.String.htmlEncode(data['name']);
    };

    me.editableMarker = NX.I18n.get('Role_RoleSettingsForm_Update_Error');

    me.editableCondition = me.editableCondition || NX.Conditions.and(
        NX.Conditions.isPermitted('nexus:roles:update'),
        NX.Conditions.formHasRecord('nx-coreui-role-settings-form', function(model) {
          return !model.get('readOnly');
        })
    );

    if (me.source) {
      idField = {
        xtype: 'combo',
        name: 'id',
        itemId: 'id',
        fieldLabel: NX.I18n.get('Role_RoleSettingsForm_MappedRole_FieldLabel'),
        emptyText: NX.I18n.get('Role_RoleSettingsForm_MappedRole_EmptyText'),
        editable: true,
        store: 'RoleBySource',
        queryMode: 'local',
        displayField: 'name',
        valueField: 'id',
        vtype: 'nx-trim'
      };
    }
    else {
      idField = {
        name: 'id',
        itemId: 'id',
        readOnly: true,
        fieldLabel: NX.I18n.get('Role_RoleSettingsForm_RoleID_FieldLabel'),
        vtype: 'nx-trim'
      };
    }

    me.items = [
      {
        xtype: 'hiddenfield',
        name: 'version'
      },
      {
        xtype: 'hiddenfield',
        name: 'source',
        value: me.source || 'default'
      },
      idField,
      {
        name: 'name',
        fieldLabel: NX.I18n.get('Role_RoleSettingsForm_Name_FieldLabel'),
        transformRawValue: Ext.htmlDecode
      },
      {
        name: 'description',
        allowBlank: true,
        fieldLabel: NX.I18n.get('Role_RoleSettingsForm_Description_FieldLabel'),
        transformRawValue: Ext.htmlDecode
      },
      {
        xtype: 'nx-itemselector',
        name: 'privileges',
        itemId: 'privileges',
        fieldLabel: NX.I18n.get('Role_RoleSettingsForm_Privileges_FieldLabel'),
        allowBlank: true,
        buttons: ['add', 'remove'],
        fromTitle: NX.I18n.get('Role_RoleSettingsForm_Privileges_FromTitle'),
        toTitle: NX.I18n.get('Role_RoleSettingsForm_Privileges_ToTitle'),
        store: 'PrivilegeReference',
        valueField: 'id',
        displayField: 'name',
        delimiter: null
      },
      {
        xtype: 'nx-itemselector',
        name: 'roles',
        itemId: 'roles',
        fieldLabel: NX.I18n.get('Role_RoleSettingsForm_Roles_FieldLabel'),
        allowBlank: true,
        buttons: ['add', 'remove'],
        fromTitle: NX.I18n.get('Role_RoleSettingsForm_Roles_FromTitle'),
        toTitle: NX.I18n.get('Role_RoleSettingsForm_Roles_ToTitle'),
        store: Ext.create('Ext.data.ChainedStore', {
          source: 'Role'
        }),
        valueField: 'id',
        displayField: 'name',
        delimiter: null
      }
    ];

    me.callParent();

    NX.Conditions.formIs(me, function(form) {
      return !form.isDisabled();
    }).on({
      satisfied: function() {
        Ext.each(me.query('nx-itemselector'), function(it) {
          it.show();
        });
      },
      unsatisfied: function() {
        Ext.each(me.query('nx-itemselector'), function(it) {
          it.hide();
        });
      },
      scope: me
    });
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Repository "Settings" form for a Docker Hosted repository.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.repository.recipe.DockerHosted', {
  extend: 'NX.coreui.view.repository.RepositorySettingsForm',
  alias: 'widget.nx-coreui-repository-docker-hosted',
  requires: [
    'NX.coreui.view.repository.facet.StorageFacet',
    'NX.coreui.view.repository.facet.StorageFacetHosted',
    'NX.coreui.view.repository.facet.DockerConnectorFacet',
    'NX.coreui.view.repository.facet.DockerV1Facet',
    'NX.coreui.view.repository.facet.CleanupPolicyFacet'
  ],

  /**
   * @override
   */
  initComponent: function() {
    var me = this;

    me.items = [
      {xtype: 'nx-coreui-repository-docker-connector-facet'},
      {xtype: 'nx-coreui-repository-docker-v1-facet'},
      {xtype: 'nx-coreui-repository-storage-facet'},
      {xtype: 'nx-coreui-repository-storage-hosted-facet', writePolicy: 'ALLOW'},
      {xtype: 'nx-coreui-repository-cleanup-policy-facet'}
    ];

    me.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Search feature.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.search.SearchFeature', {
  extend: 'NX.view.drilldown.Drilldown',
  alias: 'widget.nx-coreui-searchfeature',

  cls: 'nx-coreui-searchfeature',
  iconCls: 'x-fa fa-search',

  initComponent: function() {
    var me = this;

    me.masters = [
      {
        // FIXME: change to container
        xtype: 'panel',
        layout: {
          type: 'vbox',
          align: 'stretch',
          pack: 'start'
        },
        items: [
          {
            // FIXME: change to container
            xtype: 'panel',
            cls: 'criteria',
            itemId: 'criteria',

            header: false,
            layout: 'column'

            // disable saving for now
            //tbar: [
            //  { xtype: 'button', text: 'Save', glyph: 'xf0c7@FontAwesome', action: 'save' },
            //],
          },
          {
            xtype: 'panel',
            itemId: 'info',
            ui: 'nx-info-message',
            iconCls: NX.Icons.cls('message-primary', 'x16'),
            hidden: true
          },
          {
            xtype: 'nx-coreui-search-result-list',
            cls: 'nx-search-result-list',
            flex: 1,
            header: false
          }
        ]
      },
      {
        // FIXME: change to container?
        xtype: 'panel',
        layout: {
          type: 'vbox',
          align: 'stretch',
          pack: 'start'
        },
        items: [
          {
            xtype: 'nx-coreui-component-details'
          },
          {
            xtype: 'nx-coreui-component-asset-list',
            flex: 1
          }
        ]
      }
    ];

    me.detail = {
      xtype: 'nx-coreui-component-assetcontainer',
      header: false,
      flex: 1
    };

    me.callParent();
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * System Information controller.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.controller.SysInfo', {
  extend: 'NX.app.Controller',
  requires: [
    'NX.Permissions',
    'NX.util.Url',
    'NX.util.DownloadHelper',
    'NX.Messages',
    'NX.I18n'
  ],

  views: [
    'support.SysInfo'
  ],
  refs: [
    {
      ref: 'sysInfo',
      selector: 'nx-coreui-support-sysinfo'
    },
    {
      ref: 'content',
      selector: 'nx-feature-content'
    }
  ],

  /**
   * @override
   */
  init: function () {
    var me = this;

    me.getApplication().getFeaturesController().registerFeature({
      mode: 'admin',
      path: '/Support/System Information',
      text: NX.I18n.get('SysInfo_Title'),
      description: NX.I18n.get('SysInfo_Description'),
      view: { xtype: 'nx-coreui-support-sysinfo' },
      iconConfig: {
        file: 'globe_place.png',
        variants: ['x16', 'x32']
      },
      visible: function () {
        return NX.Permissions.check('nexus:atlas:read');
      }
    }, me);

    me.listen({
      controller: {
        '#Refresh': {
          refresh: me.load
        }
      },
      component: {
        'nx-coreui-support-sysinfo': {
          afterrender: me.load
        },
        'nx-coreui-support-sysinfo button[action=download]': {
          'click': me.download
        }
      }
    });
  },

  /**
   * Load system information panel.
   *
   * @private
   */
  load: function () {
    var me = this,
        panel = me.getSysInfo();

    if (panel) {
      //<if debug>
//      me.logDebug('Refreshing sysinfo');
      //</if>

      me.getContent().getEl().mask(NX.I18n.get('SysInfo_Load_Mask'));
      NX.direct.atlas_SystemInformation.read(function (response) {
        me.getContent().getEl().unmask();
        if (Ext.isObject(response) && response.success) {
          panel.setInfo(response.data);
        }
      });
    }
  },

  /**
   * Download system information report.
   *
   * @private
   */
  download: function () {
    NX.util.DownloadHelper.downloadUrl(NX.util.Url.urlOf('service/rest/atlas/system-information'));
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * HTTP System Settings form.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.system.HttpSettings', {
  extend: 'NX.view.SettingsPanel',
  alias: 'widget.nx-coreui-system-http-settings',
  requires: [
    'NX.Conditions',
    'NX.coreui.view.system.AuthenticationSettings',
    'NX.coreui.view.system.HttpRequestSettings',
    'NX.I18n',
    'NX.ext.form.field.Hostname'
  ],

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    me.settingsForm = [
      {
        xtype: 'nx-settingsform',
        settingsFormSuccessMessage: NX.I18n.get('System_HttpSettings_Update_Success'),
        api: {
          load: 'NX.direct.coreui_HttpSettings.read',
          submit: 'NX.direct.coreui_HttpSettings.update'
        },
        editableCondition: NX.Conditions.isPermitted('nexus:settings:update'),
        editableMarker: NX.I18n.get('System_HttpSettings_Update_Error'),
        items: [
          // request settings
          {
            xtype: 'nx-coreui-system-httprequestsettings'
          },
          {
            xtype: 'nx-optionalfieldset',
            title: NX.I18n.get('System_HttpSettings_Proxy_Title'),
            checkboxToggle: true,
            checkboxName: 'httpEnabled',
            items: [
              {
                xtype: 'nx-hostname',
                name: 'httpHost',
                fieldLabel: NX.I18n.get('System_HttpSettings_ProxyHost_FieldLabel'),
                helpText: NX.I18n.get('System_HttpSettings_ProxyHost_HelpText'),
                allowBlank: false
              },
              {
                xtype: 'numberfield',
                name: 'httpPort',
                fieldLabel: NX.I18n.get('System_HttpSettings_ProxyPort_FieldLabel'),
                minValue: 1,
                maxValue: 65535,
                allowDecimals: false,
                allowExponential: false,
                allowBlank: false
              },
              {
                xtype: 'nx-optionalfieldset',
                title: NX.I18n.get('System_HttpSettings_Authentication_Title'),
                checkboxToggle: true,
                checkboxName: 'httpAuthEnabled',
                collapsed: true,
                items: {
                  xtype: 'nx-coreui-system-authenticationsettings',
                  namePrefix: 'http'
                }
              }
            ]
          },

          {
            xtype: 'nx-optionalfieldset',
            title: NX.I18n.get('System_HttpSettings_HttpsProxy_Title'),
            itemId: 'httpsProxy',
            checkboxToggle: true,
            checkboxName: 'httpsEnabled',
            collapsed: true,
            items: [
              {
                xtype: 'nx-hostname',
                name: 'httpsHost',
                fieldLabel: NX.I18n.get('System_HttpSettings_HttpsProxyHost_FieldLabel'),
                helpText: NX.I18n.get('System_HttpSettings_HttpsProxyHost_HelpText'),
                allowBlank: false
              },
              {
                xtype: 'numberfield',
                name: 'httpsPort',
                fieldLabel: NX.I18n.get('System_HttpSettings_HttpsProxyPort_FieldLabel'),
                minValue: 1,
                maxValue: 65535,
                allowDecimals: false,
                allowExponential: false,
                allowBlank: false
              },
              {
                xtype: 'nx-optionalfieldset',
                title: NX.I18n.get('System_HttpSettings_HttpsProxyAuthentication_Title'),
                checkboxToggle: true,
                checkboxName: 'httpsAuthEnabled',
                collapsed: true,
                items: {
                  xtype: 'nx-coreui-system-authenticationsettings',
                  namePrefix: 'https'
                }
              }
            ]
          },
          {
            xtype: 'nx-valueset',
            name: 'nonProxyHosts',
            itemId: 'nonProxyHosts',
            fieldLabel: NX.I18n.get('System_HttpSettings_ExcludeHosts_FieldLabel'),
            helpText: NX.I18n.get('System_HttpSettings_ExcludeHosts_HelpText'),
            sorted: true,
            allowBlank: true
          }
        ]
      }
    ];

    me.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * HTTP System Settings controller.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.controller.HttpSettings', {
  extend: 'NX.app.Controller',
  requires: [
    'NX.Permissions',
    'NX.I18n'
  ],

  views: [
    'system.HttpSettings'
  ],

  /**
   * @override
   */
  init: function () {
    var me = this;

    me.getApplication().getFeaturesController().registerFeature({
      mode: 'admin',
      path: '/System/HTTP',
      text: NX.I18n.get('HttpSettings_Text'),
      description: NX.I18n.get('HttpSettings_Description'),
      view: { xtype: 'nx-coreui-system-http-settings' },
      iconConfig: {
        file: 'lorry.png',
        variants: ['x16', 'x32']
      },
      visible: function () {
        return NX.Permissions.check('nexus:settings:read');
      }
    }, me);

    me.listen({
      component: {
        'nx-coreui-system-http-settings checkbox[name=httpEnabled]': {
          change: me.onHttpEnabledChanged
        }
      }
    });
  },

  /**
   * Enable HTTPS proxy settings only when HTTP proxy settings are enabled.
   *
   * @private
   */
  onHttpEnabledChanged: function (httpEnabled) {
    var form = httpEnabled.up('form'),
        httpsProxy = form.down('#httpsProxy'),
        nonProxyHosts = form.down('#nonProxyHosts');

    if (!httpEnabled.getValue()) {
      httpsProxy.collapse();
      httpsProxy.disable();
      nonProxyHosts.hide();
      nonProxyHosts.disable();
    }
    else if (httpsProxy.isDisabled()) {
      httpsProxy.enable();
      nonProxyHosts.enable();
      nonProxyHosts.show();
    }
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Repository "Settings" form for a Docker Hosted repository.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.repository.recipe.DockerGroup', {
  extend: 'NX.coreui.view.repository.RepositorySettingsForm',
  alias: 'widget.nx-coreui-repository-docker-group',
  requires: [
    'NX.coreui.view.repository.facet.StorageFacet',
    'NX.coreui.view.repository.facet.GroupFacet',
    'NX.coreui.view.repository.facet.DockerConnectorFacet',
    'NX.coreui.view.repository.facet.DockerV1Facet'
  ],

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    me.items = [
      {xtype: 'nx-coreui-repository-docker-connector-facet'},
      {xtype: 'nx-coreui-repository-docker-v1-facet'},
      {xtype: 'nx-coreui-repository-storage-facet'},
      {xtype: 'nx-coreui-repository-group-facet', format: 'docker'}
    ];

    me.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Capability "Settings" form.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.capability.CapabilitySettingsForm', {
  extend: 'NX.view.SettingsForm',
  alias: 'widget.nx-coreui-capability-settings-form',
  requires: [
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function() {
    var me = this;

    me.items = [
      {
        xtype: 'hiddenfield',
        name: 'id'
      },
      {
        xtype: 'hiddenfield',
        name: 'typeId'
      },
      {
        xtype: 'hiddenfield',
        name: 'notes'
      },
      {
        xtype: 'checkbox',
        boxLabel: NX.I18n.get('Capability_CapabilitySettingsForm_Enabled_FieldLabel'),
        name: 'enabled',
        allowBlank: false,
        checked: true,
        inputValue: true,
        editable: true
      },
      {
        xtype: 'nx-coreui-formfield-settingsfieldset',
        delimiter: ','
      }
    ];

    me.editableMarker = NX.I18n.get('Capability_CapabilityAdd_Create_Error');

    me.editableCondition = me.editableCondition || NX.Conditions.isPermitted('nexus:capabilities:update');

    me.callParent();
  },

  /**
   * @override
   * Imports capability into settings field set.
   * @param {NX.coreui.model.Capability} model capability model
   */
  loadRecord: function(model) {
    var me = this,
        capabilityTypeModel = NX.getApplication().getStore('CapabilityType').getById(model.get('typeId')),
        settingsFieldSet = me.down('nx-coreui-formfield-settingsfieldset');

    me.callParent(arguments);
    if (capabilityTypeModel) {
      settingsFieldSet.importProperties(model.get('properties'), capabilityTypeModel.get('formFields'));
    }
  },

  /**
   * @override
   * Exports capability from settings field set.
   * @returns {Object} form values
   */
  getValues: function() {
    var me = this,
        values = me.getForm().getValues(),
        capability = {
          id: values.id,
          typeId: values.typeId,
          notes: values.notes,
          enabled: values.enabled,
          properties: {}
        };

    Ext.apply(capability.properties, me.down('nx-coreui-formfield-settingsfieldset').exportProperties(values));
    return capability;
  },

  /**
   * Mark fields in this form invalid in bulk.
   * @param {Object/Object[]/Ext.data.Errors} errors
   * Either an array in the form `[{id:'fieldId', msg:'The message'}, ...]`,
   * an object hash of `{id: msg, id2: msg2}`, or a {@link Ext.data.Errors} object.
   */
  markInvalid: function(errors) {
    this.down('nx-coreui-formfield-settingsfieldset').markInvalid(errors);
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Capability feature panel.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.capability.CapabilityFeature', {
  extend: 'NX.view.drilldown.Drilldown',
  alias: 'widget.nx-coreui-capability-feature',
  requires: [
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function() {
    Ext.apply(this, {
      iconName: 'capability-default',

      masters: [
        { xtype: 'nx-coreui-capability-list' }
      ],

      tabs: [
        { xtype: 'nx-coreui-capability-summary', weight: 10 },
        { xtype: 'nx-coreui-capability-settings', title: NX.I18n.get('Capability_CapabilitySettings_Title'), weight: 20 }
      ],

      nxActions: [
        {
          xtype: 'button',
          text: NX.I18n.get('Capability_CapabilityFeature_Delete_Button'),
          action: 'delete',
          disabled: true,
          glyph: 'xf1f8@FontAwesome' /* fa-trash */
        },
        '-',
        {
          xtype: 'button',
          text: NX.I18n.get('Capability_CapabilityFeature_Enable_Button'),
          action: 'enable',
          handler: function(button) {
            button.fireEvent('runaction');
          },
          disabled: true,
          glyph: 'xf04b@FontAwesome' /* fa-play */
        },
        {
          xtype: 'button',
          text: NX.I18n.get('Capability_CapabilityFeature_Disable_Button'),
          action: 'disable',
          handler: function(button) {
            button.fireEvent('runaction');
          },
          disabled: true,
          glyph: 'xf04d@FontAwesome' /* fa-stop */
        }
      ]
    });

    this.callParent();
  }
});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Capability "Status" panel.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.capability.CapabilityStatus', {
  extend: 'Ext.panel.Panel',
  alias: 'widget.nx-coreui-capability-status',
  ui: 'nx-inset',
  requires: [
    'NX.I18n'
  ],

  html: '',

  /**
   * @public
   * Shows capability status text.
   * @param {String} text status text
   */
  showStatus: function (text) {
    this.html = text || NX.I18n.get('Capability_CapabilityStatus_EmptyText');
    if (this.body) {
      this.update(this.html);
    }
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Capability "About" panel.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.capability.CapabilityAbout', {
  extend: 'Ext.panel.Panel',
  alias: 'widget.nx-coreui-capability-about',
  ui: 'nx-inset',

  html: '',

  /**
   * @public
   * Shows capability about text.
   * @param {String} text about text
   */
  showAbout: function (text) {
    this.html = text;
    if (this.body) {
      this.update(this.html);
    }
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Select capability type window.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.capability.CapabilitySelectType', {
  extend: 'NX.view.drilldown.Master',
  alias: 'widget.nx-coreui-capability-selecttype',
  requires: [
    'NX.I18n'
  ],

  initComponent: function() {
    var me = this;

    me.store = 'CapabilityType';

    me.cls = 'nx-hr';

    me.columns = [
      {
        xtype: 'nx-iconcolumn',
        width: 36,
        iconVariant: 'x16',
        iconName: function() {
          return 'capability-default';
        }
      },
      { header: NX.I18n.get('Capability_CapabilitySelectType_Type_Header'), dataIndex: 'name', flex: 1 },
      { header: NX.I18n.get('Capability_CapabilitySelectType_Description_Header'), dataIndex: 'about', flex: 2,
        renderer: function(val) {
          var i;
          if (val) {
            i = val.indexOf('.');
            if (i > 0) {
              val = val.substring(0, i);
            }
            // replace HTML
            return val.replace(/(<([^>]+)>)/ig, '');
          }
          return val;
        }
      }
    ];

    me.on('afterrender', function(grid) {
        var view = grid.getView();
        grid.tip = Ext.create('Ext.tip.ToolTip', {
          target: view.el,
          delegate: view.itemSelector,
          trackMouse: true,
          renderTo: Ext.getBody(),
          dismissDelay: 0,
          listeners: {
            beforeshow: function updateTipBody(tip) {
              tip.update(view.getRecord(tip.triggerElement).get('about'));
            }
          }
        });
      }
    );

    me.on('destroy', function(grid) {
      if (grid.tip) {
        grid.tip.destroy();
      }
    });

    me.callParent();
  }

});

/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Capabilities controller.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.controller.Capabilities', {
  extend: 'NX.controller.Drilldown',
  requires: [
    'NX.view.info.Panel',
    'NX.view.info.Entry',
    'NX.Conditions',
    'NX.Dialogs',
    'NX.Messages',
    'NX.Permissions',
    'NX.I18n',
    'NX.ext.grid.column.Renderers'
  ],
  masters: [
    'nx-coreui-capability-list'
  ],
  stores: [
    'Capability',
    'CapabilityType'
  ],
  models: [
    'Capability'
  ],
  views: [
    'capability.CapabilityAdd',
    'capability.CapabilityFeature',
    'capability.CapabilityList',
    'capability.CapabilitySummary',
    'capability.CapabilitySelectType',
    'capability.CapabilitySettings',
    'capability.CapabilitySettingsForm',
    'capability.CapabilityStatus',
    'capability.CapabilityAbout',
    'formfield.SettingsFieldSet'
  ],
  refs: [
    { ref: 'feature', selector: 'nx-coreui-capability-feature' },
    { ref: 'content', selector: 'nx-feature-content' },
    { ref: 'list', selector: 'nx-coreui-capability-list' },
    { ref: 'summaryTab', selector: 'nx-coreui-capability-summary' },
    { ref: 'settingsTab', selector: 'nx-coreui-capability-settings' },
    { ref: 'summaryPanel', selector: '#nx-coreui-capability-summary-subsection' },
    { ref: 'statusPanel', selector: 'nx-coreui-capability-status' },
    { ref: 'aboutPanel', selector: 'nx-coreui-capability-about' },
    { ref: 'notesPanel', selector: '#nx-coreui-capability-notes-subsection' },
    { ref: 'settingsPanel', selector: 'nx-coreui-capability-settings-form' },
    { ref: 'enableButton', selector: 'nx-coreui-capability-feature button[action=enable]'},
    { ref: 'disableButton', selector: 'nx-coreui-capability-feature button[action=disable]'}
  ],
  icons: {
    'capability-default': {
      file: 'brick.png',
      variants: ['x16', 'x32']
    },
    'capability-active': {
      file: 'brick_valid.png',
      variants: ['x16', 'x32']
    },
    'capability-disabled': {
      file: 'brick_grey.png',
      variants: ['x16', 'x32']
    },
    'capability-error': {
      file: 'brick_error.png',
      variants: ['x16', 'x32']
    },
    'capability-passive': {
      file: 'brick_error.png',
      variants: ['x16', 'x32']
    }
  },

  permission: 'nexus:capabilities',

  /**
   * @override
   */
  init: function() {
    var me = this;

    me.features = {
      mode: 'admin',
      path: '/System/Capabilities',
      text: NX.I18n.get('Capabilities_Text'),
      description: NX.I18n.get('Capabilities_Description'),
      view: {xtype: 'nx-coreui-capability-feature'},
      iconConfig: {
        file: 'brick.png',
        variants: ['x16', 'x32']
      },
      visible: function() {
        return NX.Permissions.check('nexus:capabilities:read');
      }
    };

    me.callParent();

    me.listen({
      controller: {
        '#Refresh': {
          refresh: me.loadStores