/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
$(document).ready(function() {
    var me = this;
    $('#licenseTable').dataTable({
        sDom : 'rt',
        bAutoWidth : false,
        aoColumnDefs : [ {
            "bSortable" : false,
            "aTargets" : [ 0, 1, 2 ]
        }, {
            "sWidth" : "20%",
            "aTargets" : [ 0 ]
        }, {
            "sWidth" : "40%",
            "aTargets" : [ 1, 2 ]
        } ]
    });
    me.securityScoreRenderFn = function(severity) {
        return (me.isNumber(severity) && severity != -1000) ? Math.floor(severity) : "Unscored";
    };
    me.isNumber = function(input) {
        if (parseFloat(input) > 0) {
            return true;
        }

        return false;
    };
    me.securityTable = $('#securityTable').dataTable({
        sDom : 'rt',
        bAutoWidth : false,
        oLanguage : {
            "sEmptyTable" : "No known public vulnerabilities for this artifact"
        },
        bPaginate : false,
        aoColumnDefs : [ {
            "asSorting" : [ "desc", "asc" ],
            "sType" : "numeric",
            "bUseRendered" : false,
            "sWidth" : "20%",
            "aTargets" : [ 0 ]
        }, {
            "sWidth" : "40%",
            "aTargets" : [ 1, 2 ]
        }, {
            "fnRender" : function(oObj) {
                return me.securityScoreRenderFn(oObj.aData[0]);
            },
            "aTargets" : [ 0 ]
        } ],
        "fnDrawCallback" : function(oSettings) {
            setTimeout(function() {
                var groupVal = null;
                var matches = 0;
                var index = -1;
                var doGroup = me.securityTable.fnSettings().aaSorting[0][0] == 0;
                $('.threat-columns').each(function(i) {
                    var currVal = me.securityScoreRenderFn(oSettings.aoData[oSettings.aiDisplay[i]]._aData[0]);

                    $(this).addClass('nx-clm-bar');
                    if (currVal >= 7) {
                        $(this).addClass('critical');
                    } else if (currVal >= 4) {
                        $(this).addClass('severe');
                    } else if (currVal >= 0) {
                        $(this).addClass('moderate');
                    } else {
                        $(this).addClass('unspecified');
                    }

                    if (doGroup) {
                        $(this).addClass('threatLevel');
                        /* Reset values on new cell data. */
                        if (currVal != groupVal) {
                            groupVal = currVal;
                            index++;
                            matches = 0;
                        } else {
                            matches++;
                        }

                        if (currVal == groupVal && matches > 0) {
                            $(this).addClass('border-none');
                            $(this).removeClass('border-top');
                            $(this).text('');
                        } else {
                            $(this).addClass('border-top');
                            $(this).removeClass('border-none');
                            $(this).text(currVal);
                        }
                    } else {
                        $(this).removeClass('threatLevel');
                        $(this).removeClass('border-top');
                        $(this).removeClass('border-none');
                        $(this).text(me.securityScoreRenderFn(currVal));
                    }
                });
            }, 0);
        }
    });
});