/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;

final class CheckGlobalThis
implements NodeTraversal.Callback {
    static final DiagnosticType GLOBAL_THIS = DiagnosticType.warning("JSC_USED_GLOBAL_THIS", "dangerous use of the global 'this' object");
    private final AbstractCompiler compiler;
    private Node assignLhsChild = null;

    CheckGlobalThis(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        if (n.isFunction()) {
            JSDocInfo maybeLends;
            Node thisNode;
            Node functionNode;
            JSTypeExpression functionType;
            if (n.isArrowFunction()) {
                return true;
            }
            JSDocInfo jsDoc = NodeUtil.getBestJSDocInfo(n);
            if (jsDoc != null && (jsDoc.isConstructor() || jsDoc.isInterface() || jsDoc.hasThisType() || jsDoc.isOverride())) {
                return false;
            }
            if (jsDoc != null && (functionType = jsDoc.getType()) != null && (functionNode = functionType.getRoot()) != null && functionNode.isFunction() && (thisNode = functionNode.getFirstChild()) != null && thisNode.isThis()) {
                return false;
            }
            Token pType = parent.getToken();
            if (pType != Token.BLOCK && pType != Token.SCRIPT && pType != Token.NAME && pType != Token.ASSIGN && pType != Token.STRING_KEY) {
                return false;
            }
            Node grandparent = parent.getParent();
            if (NodeUtil.mayBeObjectLitKey(parent) && (maybeLends = grandparent.getJSDocInfo()) != null && maybeLends.hasLendsName() && maybeLends.getLendsName().getRoot().getString().endsWith(".prototype")) {
                return false;
            }
        }
        if (parent != null && parent.isAssign()) {
            Node lhs = parent.getFirstChild();
            if (n == lhs) {
                if (this.assignLhsChild == null) {
                    this.assignLhsChild = lhs;
                }
            } else if (NodeUtil.isGet(lhs)) {
                if (lhs.isGetProp() && lhs.getLastChild().getString().equals("prototype")) {
                    return false;
                }
                Node llhs = lhs.getFirstChild();
                if (llhs.isGetProp() && llhs.getLastChild().getString().equals("prototype")) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal unused, Node n, Node parent) {
        if (n.isThis() && this.shouldReportThis(n)) {
            this.compiler.report(JSError.make(n, GLOBAL_THIS, new String[0]));
        }
        if (n == this.assignLhsChild) {
            this.assignLhsChild = null;
        }
    }

    private boolean shouldReportThis(Node n) {
        Node parent = n.getParent();
        if (this.assignLhsChild != null) {
            return true;
        }
        return parent != null && NodeUtil.isGet(parent);
    }
}

