/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.DataFlowAnalysis;
import com.google.javascript.jscomp.LiveVariablesAnalysis;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.SyntacticScopeCreator;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.graph.Graph;
import com.google.javascript.jscomp.graph.GraphColoring;
import com.google.javascript.jscomp.graph.GraphNode;
import com.google.javascript.jscomp.graph.LinkedUndirectedGraph;
import com.google.javascript.jscomp.graph.UndiGraph;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;

class CoalesceVariableNames
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass,
NodeTraversal.ScopedCallback {
    private final AbstractCompiler compiler;
    private final Deque<GraphColoring<Var, Void>> colorings;
    private final Deque<LiveVariablesAnalysis> liveAnalyses;
    private final boolean usePseudoNames;
    private LiveVariablesAnalysis liveness;
    private final Comparator<Var> coloringTieBreaker = new Comparator<Var>(){

        @Override
        public int compare(Var v1, Var v2) {
            return CoalesceVariableNames.this.liveness.getVarIndex(v1.getName()) - CoalesceVariableNames.this.liveness.getVarIndex(v2.getName());
        }
    };

    CoalesceVariableNames(AbstractCompiler compiler, boolean usePseudoNames) {
        Preconditions.checkState(compiler.getLifeCycleStage().isNormalized());
        this.compiler = compiler;
        this.colorings = new ArrayDeque<GraphColoring<Var, Void>>();
        this.liveAnalyses = new ArrayDeque<LiveVariablesAnalysis>();
        this.usePseudoNames = usePseudoNames;
    }

    @Override
    public void process(Node externs, Node root) {
        Preconditions.checkNotNull(externs);
        Preconditions.checkNotNull(root);
        NodeTraversal.traverse(this.compiler, root, this);
        this.compiler.setLifeCycleStage(AbstractCompiler.LifeCycleStage.RAW);
    }

    private static boolean shouldOptimizeScope(NodeTraversal t) {
        if (!t.getScopeRoot().isFunction()) {
            return false;
        }
        HashMap<String, Var> allVarsInFn = new HashMap<String, Var>();
        ArrayList<Var> orderedVars = new ArrayList<Var>();
        NodeUtil.getAllVarsDeclaredInFunction(allVarsInFn, orderedVars, t.getCompiler(), t.getScopeCreator(), t.getScope());
        return 100 > orderedVars.size();
    }

    @Override
    public void enterScope(NodeTraversal t) {
        Node enclosingFunction;
        Scope scope = t.getScope();
        if (!CoalesceVariableNames.shouldOptimizeScope(t)) {
            return;
        }
        Preconditions.checkState(scope.isFunctionScope(), scope);
        ControlFlowGraph<Node> cfg = t.getControlFlowGraph();
        this.liveness = new LiveVariablesAnalysis(cfg, scope, null, this.compiler, new SyntacticScopeCreator(this.compiler));
        if (FeatureSet.ES3.contains(this.compiler.getOptions().getOutputFeatureSet()) && NodeUtil.getFunctionParameters(enclosingFunction = scope.getRootNode()).hasTwoChildren()) {
            this.liveness.markAllParametersEscaped();
        }
        this.liveness.analyze();
        this.liveAnalyses.push(this.liveness);
        UndiGraph<Var, Void> interferenceGraph = this.computeVariableNamesInterferenceGraph(cfg, this.liveness.getEscapedLocals());
        GraphColoring.GreedyGraphColoring<Var, Void> coloring = new GraphColoring.GreedyGraphColoring<Var, Void>(interferenceGraph, this.coloringTieBreaker);
        ((GraphColoring)coloring).color();
        this.colorings.push(coloring);
    }

    @Override
    public void exitScope(NodeTraversal t) {
        if (!CoalesceVariableNames.shouldOptimizeScope(t)) {
            return;
        }
        this.colorings.pop();
        this.liveAnalyses.pop();
        this.liveness = this.liveAnalyses.peek();
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (this.colorings.isEmpty() || !n.isName() || parent.isFunction()) {
            return;
        }
        Var var = this.liveness.getAllVariables().get(n.getString());
        GraphNode<Var, Void> vNode = this.colorings.peek().getGraph().getNode(var);
        if (vNode == null) {
            return;
        }
        Var coalescedVar = this.colorings.peek().getPartitionSuperNode(var);
        if (!this.usePseudoNames) {
            if (vNode.getValue().equals(coalescedVar)) {
                return;
            }
            n.setString(coalescedVar.name);
            this.compiler.reportChangeToEnclosingScope(n);
            if (NodeUtil.isNameDeclaration(parent) || NodeUtil.getEnclosingType(n, Token.DESTRUCTURING_LHS) != null && NodeUtil.isLhsByDestructuring(n)) {
                CoalesceVariableNames.makeDeclarationVar(coalescedVar);
                CoalesceVariableNames.removeVarDeclaration(n);
            }
        } else {
            String pseudoName = null;
            TreeSet<String> allMergedNames = new TreeSet<String>();
            for (Var iVar : this.liveness.getAllVariablesInOrder()) {
                if (this.colorings.peek().getGraph().getNode(iVar) == null || !coalescedVar.equals(this.colorings.peek().getPartitionSuperNode(iVar))) continue;
                allMergedNames.add(iVar.name);
            }
            if (allMergedNames.size() == 1) {
                return;
            }
            pseudoName = Joiner.on("_").join(allMergedNames);
            while (t.getScope().hasSlot(pseudoName)) {
                pseudoName = pseudoName + "$";
            }
            n.setString(pseudoName);
            this.compiler.reportChangeToEnclosingScope(n);
            if (!vNode.getValue().equals(coalescedVar) && (NodeUtil.isNameDeclaration(parent) || NodeUtil.getEnclosingType(n, Token.DESTRUCTURING_LHS) != null && NodeUtil.isLhsByDestructuring(n))) {
                CoalesceVariableNames.makeDeclarationVar(coalescedVar);
                CoalesceVariableNames.removeVarDeclaration(n);
            }
        }
    }

    private UndiGraph<Var, Void> computeVariableNamesInterferenceGraph(ControlFlowGraph<Node> cfg, Set<? extends Var> escaped) {
        LinkedUndirectedGraph<Var, Void> interferenceGraph = LinkedUndirectedGraph.create();
        List<Var> orderedVariables = this.liveness.getAllVariablesInOrder();
        for (Var v : orderedVariables) {
            if (escaped.contains(v) || v.getParentNode().isFunction() || v.getParentNode().isClass() || this.isInMultipleLvalueDecl(v)) continue;
            ((Graph)interferenceGraph).createNode(v);
        }
        int v1Index = -1;
        for (Var v1 : orderedVariables) {
            ++v1Index;
            int v2Index = -1;
            block2: for (Var v2 : orderedVariables) {
                DataFlowAnalysis.FlowState state;
                if (v1Index > ++v2Index || !interferenceGraph.hasNode(v1) || !interferenceGraph.hasNode(v2)) continue;
                if (v1.isParam() && v2.isParam()) {
                    interferenceGraph.connectIfNotFound(v1, null, v2);
                    continue;
                }
                for (DiGraph.DiGraphNode cfgNode : cfg.getDirectedGraphNodes()) {
                    if (cfg.isImplicitReturn(cfgNode) || (!((LiveVariablesAnalysis.LiveVariableLattice)(state = (DataFlowAnalysis.FlowState)cfgNode.getAnnotation()).getIn()).isLive(v1Index) || !((LiveVariablesAnalysis.LiveVariableLattice)state.getIn()).isLive(v2Index)) && (!((LiveVariablesAnalysis.LiveVariableLattice)state.getOut()).isLive(v1Index) || !((LiveVariablesAnalysis.LiveVariableLattice)state.getOut()).isLive(v2Index))) continue;
                    interferenceGraph.connectIfNotFound(v1, null, v2);
                    continue block2;
                }
                for (DiGraph.DiGraphNode cfgNode : cfg.getDirectedGraphNodes()) {
                    if (cfg.isImplicitReturn(cfgNode)) continue;
                    state = (DataFlowAnalysis.FlowState)cfgNode.getAnnotation();
                    boolean v1OutLive = ((LiveVariablesAnalysis.LiveVariableLattice)state.getOut()).isLive(v1Index);
                    boolean v2OutLive = ((LiveVariablesAnalysis.LiveVariableLattice)state.getOut()).isLive(v2Index);
                    CombinedLiveRangeChecker checker = new CombinedLiveRangeChecker((Node)cfgNode.getValue(), new LiveRangeChecker(v1, v2OutLive ? null : v2), new LiveRangeChecker(v2, v1OutLive ? null : v1));
                    checker.check((Node)cfgNode.getValue());
                    if (!checker.connectIfCrossed(interferenceGraph)) continue;
                    continue block2;
                }
            }
        }
        return interferenceGraph;
    }

    private boolean isInMultipleLvalueDecl(Var v) {
        Token declarationType = v.declarationType();
        switch (declarationType) {
            case LET: 
            case CONST: 
            case VAR: {
                Node nameDecl = NodeUtil.getEnclosingNode(v.getNode(), NodeUtil::isNameDeclaration);
                return NodeUtil.findLhsNodesInNode(nameDecl).size() > 1;
            }
        }
        return false;
    }

    private static void removeVarDeclaration(Node name) {
        Node var = NodeUtil.getEnclosingNode(name, NodeUtil::isNameDeclaration);
        Node parent = var.getParent();
        if (var.getFirstChild().isDestructuringLhs()) {
            Node destructuringLhs = var.getFirstChild();
            Node pattern = destructuringLhs.getFirstChild().detach();
            if (NodeUtil.isEnhancedFor(parent)) {
                var.replaceWith(pattern);
            } else {
                Node rvalue = var.getFirstFirstChild().detach();
                var.replaceWith(NodeUtil.newExpr(IR.assign(pattern, rvalue).srcref(var)));
            }
        } else if (NodeUtil.isEnhancedFor(parent)) {
            parent.replaceChild(var, name.detach());
        } else {
            Preconditions.checkState(var.hasOneChild() && var.getFirstChild() == name, var);
            if (name.hasChildren()) {
                Node value = name.removeFirstChild();
                var.removeChild(name);
                Node assign = IR.assign(name, value).srcref(name);
                if (!parent.isVanillaFor()) {
                    assign = NodeUtil.newExpr(assign);
                }
                parent.replaceChild(var, assign);
            } else {
                NodeUtil.removeChild(parent, var);
            }
        }
    }

    private static void makeDeclarationVar(Var coalescedName) {
        if (coalescedName.isLet() || coalescedName.isConst()) {
            Node declNode = NodeUtil.getEnclosingNode(coalescedName.getParentNode(), NodeUtil::isNameDeclaration);
            declNode.setToken(Token.VAR);
        }
    }

    private static class LiveRangeChecker {
        boolean defFound = false;
        boolean crossed = false;
        private final Var def;
        @Nullable
        private final Var use;

        public LiveRangeChecker(Var def, Var use) {
            this.def = Preconditions.checkNotNull(def);
            this.use = use;
        }

        public static boolean shouldVisit(Node n) {
            return n.isName() || n.hasChildren() && n.getFirstChild().isName();
        }

        void visit(Node n, Node parent) {
            if (!this.defFound && LiveRangeChecker.isAssignTo(this.def, n, parent)) {
                this.defFound = true;
            }
            if (this.defFound && (this.use == null || LiveRangeChecker.isReadFrom(this.use, n))) {
                this.crossed = true;
            }
        }

        static boolean isAssignTo(Var var, Node n, Node parent) {
            if (n.isName()) {
                if (parent.isParamList()) {
                    return var.getName().equals(n.getString());
                }
                if (NodeUtil.isNameDeclaration(parent) && n.hasChildren()) {
                    return var.getName().equals(n.getString());
                }
                if (NodeUtil.isLhsByDestructuring(n)) {
                    return var.getName().equals(n.getString());
                }
            } else if (NodeUtil.isAssignmentOp(n)) {
                Node name = n.getFirstChild();
                return name.isName() && var.getName().equals(name.getString());
            }
            return false;
        }

        static boolean isReadFrom(Var var, Node name) {
            return name.isName() && var.getName().equals(name.getString()) && !NodeUtil.isNameDeclOrSimpleAssignLhs(name, name.getParent());
        }
    }

    private static class CombinedLiveRangeChecker {
        private final Node root;
        private final LiveRangeChecker callback1;
        private final LiveRangeChecker callback2;

        CombinedLiveRangeChecker(Node root, LiveRangeChecker callback1, LiveRangeChecker callback2) {
            this.root = root;
            this.callback1 = callback1;
            this.callback2 = callback2;
        }

        void check(Node n) {
            if (n == this.root || !ControlFlowGraph.isEnteringNewCfgNode(n)) {
                if (n.isDestructuringLhs() && n.hasTwoChildren() || n.isAssign() && n.getFirstChild().isDestructuringPattern() || n.isDefaultValue()) {
                    this.check(n.getSecondChild());
                    this.check(n.getFirstChild());
                } else {
                    for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
                        this.check(c);
                    }
                }
                this.visit(n, n.getParent());
            }
        }

        void visit(Node n, Node parent) {
            if (LiveRangeChecker.shouldVisit(n)) {
                this.callback1.visit(n, parent);
                this.callback2.visit(n, parent);
            }
        }

        boolean connectIfCrossed(UndiGraph<Var, Void> interferenceGraph) {
            if (this.callback1.crossed || this.callback2.crossed) {
                Var v1 = this.callback1.def;
                Var v2 = this.callback2.def;
                interferenceGraph.connectIfNotFound(v1, null, v2);
                return true;
            }
            return false;
        }
    }
}

