/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.BasicBlock;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Reference;
import com.google.javascript.jscomp.ReferenceCollection;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.ScopeCreator;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public final class CrossChunkReferenceCollector
implements NodeTraversal.ScopedCallback,
CompilerPass {
    private final Map<String, Var> varsByName = new HashMap<String, Var>();
    private final Map<Var, ReferenceCollection> referenceMap = new LinkedHashMap<Var, ReferenceCollection>();
    private final List<BasicBlock> blockStack = new ArrayList<BasicBlock>();
    private final List<TopLevelStatement> topLevelStatements = new ArrayList<TopLevelStatement>();
    private final ScopeCreator scopeCreator;
    private final AbstractCompiler compiler;
    private int statementCounter = 0;
    private TopLevelStatementDraft topLevelStatementDraft = null;

    CrossChunkReferenceCollector(AbstractCompiler compiler, ScopeCreator creator) {
        this.compiler = compiler;
        this.scopeCreator = creator;
    }

    @Override
    public void process(Node externs, Node root) {
        Preconditions.checkState(this.topLevelStatements.isEmpty(), "process() called more than once");
        NodeTraversal t = new NodeTraversal(this.compiler, this, this.scopeCreator);
        t.traverseRoots(externs, root);
    }

    public void process(Node root) {
        Preconditions.checkState(this.topLevelStatements.isEmpty(), "process() called more than once");
        NodeTraversal t = new NodeTraversal(this.compiler, this, this.scopeCreator);
        t.traverse(root);
    }

    Iterable<Var> getAllSymbols() {
        return this.referenceMap.keySet();
    }

    ReferenceCollection getReferences(Var v) {
        return this.referenceMap.get(v);
    }

    ImmutableMap<String, Var> getGlobalVariableNamesMap() {
        return ImmutableMap.copyOf(this.varsByName);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (this.topLevelStatementDraft != null) {
            if (n.equals(this.topLevelStatementDraft.statementNode)) {
                this.topLevelStatements.add(new TopLevelStatement(this.topLevelStatementDraft));
                this.topLevelStatementDraft = null;
            } else if (n.isName()) {
                String varName = n.getString();
                Var v = (Var)t.getScope().getVar(varName);
                if (v != null && v.isGlobal() && !this.compiler.getCodingConvention().isExported(v.getName())) {
                    if (this.varsByName.containsKey(varName)) {
                        Preconditions.checkState(Objects.equals(this.varsByName.get(varName), v));
                    } else {
                        this.varsByName.put(varName, v);
                    }
                    Reference reference = new Reference(n, t, CrossChunkReferenceCollector.peek(this.blockStack));
                    if (reference.getNode() == this.topLevelStatementDraft.declaredNameNode) {
                        this.topLevelStatementDraft.declaredNameReference = reference;
                    } else {
                        this.topLevelStatementDraft.nonDeclarationReferences.add(reference);
                    }
                    this.addReferenceToCollection(v, reference);
                }
            }
        }
        if (CrossChunkReferenceCollector.isBlockBoundary(n, parent)) {
            CrossChunkReferenceCollector.pop(this.blockStack);
        }
    }

    @Override
    public void enterScope(NodeTraversal t) {
        BasicBlock parent;
        Node n = t.getScopeRoot();
        BasicBlock basicBlock = parent = this.blockStack.isEmpty() ? null : CrossChunkReferenceCollector.peek(this.blockStack);
        if (t.isHoistScope()) {
            this.blockStack.add(new BasicBlock(parent, n));
        }
    }

    @Override
    public void exitScope(NodeTraversal t) {
        if (t.isHoistScope()) {
            CrossChunkReferenceCollector.pop(this.blockStack);
        }
    }

    @Override
    public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
        if (parent != null && NodeUtil.isTopLevel(parent)) {
            Preconditions.checkState(this.topLevelStatementDraft == null, n);
            this.topLevelStatementDraft = this.initializeDraftStatement(nodeTraversal.getModule(), n);
        }
        if (CrossChunkReferenceCollector.isBlockBoundary(n, parent)) {
            this.blockStack.add(new BasicBlock(CrossChunkReferenceCollector.peek(this.blockStack), n));
        }
        return true;
    }

    private TopLevelStatementDraft initializeDraftStatement(JSModule module, Node statementNode) {
        TopLevelStatementDraft draft = new TopLevelStatementDraft(this.statementCounter++, module, statementNode);
        if (NodeUtil.isNameDeclaration(statementNode)) {
            draft.declaredNameNode = statementNode.getFirstChild();
            draft.declaredValueNode = statementNode.getFirstFirstChild();
        } else if (statementNode.isClass()) {
            draft.declaredNameNode = statementNode.getFirstChild();
            draft.declaredValueNode = statementNode;
        } else if (statementNode.isFunction()) {
            draft.declaredNameNode = statementNode.getFirstChild();
            draft.declaredValueNode = statementNode;
        } else if (statementNode.isExprResult()) {
            Node expr = Preconditions.checkNotNull(statementNode.getFirstChild());
            if (expr.isAssign()) {
                Node lhs = Preconditions.checkNotNull(expr.getFirstChild());
                Node rhs = Preconditions.checkNotNull(expr.getSecondChild());
                if (lhs.isName()) {
                    draft.declaredNameNode = lhs;
                    draft.declaredValueNode = rhs;
                } else if (lhs.isGetProp()) {
                    Node nameNode = Preconditions.checkNotNull(lhs.getFirstChild());
                    while (nameNode.isGetProp()) {
                        nameNode = Preconditions.checkNotNull(nameNode.getFirstChild());
                    }
                    if (nameNode.isName()) {
                        draft.declaredNameNode = nameNode;
                        draft.declaredValueNode = rhs;
                    }
                }
            } else if (expr.isCall()) {
                Node nameNode = null;
                Node valueNode = null;
                CodingConvention.SubclassRelationship relationship = this.compiler.getCodingConvention().getClassesDefinedByCall(expr);
                if (relationship != null) {
                    String declaredName = Preconditions.checkNotNull(relationship.subclassName);
                    for (Node callArg = expr.getSecondChild(); callArg != null; callArg = callArg.getNext()) {
                        if (!callArg.isName() || !declaredName.equals(callArg.getString())) continue;
                        nameNode = callArg;
                        break;
                    }
                } else if (NodeUtil.isObjectDefinePropertiesDefinition(expr)) {
                    Node targetObject = expr.getSecondChild();
                    nameNode = targetObject.isName() ? targetObject : targetObject.getFirstChild();
                    valueNode = targetObject.getNext();
                }
                if (nameNode != null) {
                    draft.declaredNameNode = nameNode;
                    draft.declaredValueNode = valueNode;
                }
            }
        }
        return draft;
    }

    private static <T> T pop(List<T> list) {
        return list.remove(list.size() - 1);
    }

    private static <T> T peek(List<T> list) {
        return Iterables.getLast(list);
    }

    private static boolean isBlockBoundary(Node n, Node parent) {
        if (parent != null) {
            switch (parent.getToken()) {
                case DO: 
                case FOR: 
                case FOR_IN: 
                case FOR_OF: 
                case FOR_AWAIT_OF: 
                case TRY: 
                case WHILE: 
                case WITH: 
                case CLASS: {
                    return true;
                }
                case AND: 
                case HOOK: 
                case IF: 
                case OR: 
                case SWITCH: {
                    return n != parent.getFirstChild();
                }
            }
        }
        return n.isCase();
    }

    private void addReferenceToCollection(Var v, Reference reference) {
        ReferenceCollection referenceInfo = this.referenceMap.get(v);
        if (referenceInfo == null) {
            referenceInfo = new ReferenceCollection();
            this.referenceMap.put(v, referenceInfo);
        }
        referenceInfo.add(reference);
    }

    List<TopLevelStatement> getTopLevelStatements() {
        return Collections.unmodifiableList(this.topLevelStatements);
    }

    private boolean canMoveValue(Scope scope, Node valueNode) {
        if (valueNode == null || NodeUtil.isLiteralValue(valueNode, true) || valueNode.isFunction()) {
            return true;
        }
        switch (valueNode.getToken()) {
            case CLASS: {
                Node classMembers = valueNode.getLastChild();
                for (Node member = classMembers.getFirstChild(); member != null; member = member.getNext()) {
                    if (member.isComputedProp()) {
                        Node keyExpr = member.getFirstChild();
                        Node method = member.getLastChild();
                        Preconditions.checkState(method.isFunction(), method);
                        if (this.canMoveValue(scope, keyExpr)) continue;
                        return false;
                    }
                    Preconditions.checkState(member.isMemberFunctionDef() || NodeUtil.isGetOrSetKey(member), member);
                }
                return true;
            }
            case CALL: {
                Node functionName = Preconditions.checkNotNull(valueNode.getFirstChild());
                return functionName.isName() && functionName.getString().equals("JSCompiler_stubMethod");
            }
            case ARRAYLIT: {
                for (Node child = valueNode.getFirstChild(); child != null; child = child.getNext()) {
                    if (this.canMoveValue(scope, child)) continue;
                    return false;
                }
                return true;
            }
            case OBJECTLIT: {
                block15: for (Node child = valueNode.getFirstChild(); child != null; child = child.getNext()) {
                    switch (child.getToken()) {
                        case MEMBER_FUNCTION_DEF: 
                        case GETTER_DEF: 
                        case SETTER_DEF: {
                            continue block15;
                        }
                        case COMPUTED_PROP: {
                            if (this.canMoveValue(scope, child.getFirstChild()) && this.canMoveValue(scope, child.getLastChild())) continue block15;
                            return false;
                        }
                        case STRING_KEY: 
                        case SPREAD: {
                            if (this.canMoveValue(scope, child.getOnlyChild())) continue block15;
                            return false;
                        }
                        default: {
                            throw new IllegalStateException("Unexpected child of OBJECTLIT: " + child.toStringTree());
                        }
                    }
                }
                return true;
            }
            case NAME: {
                ReferenceCollection refCollection;
                Var v = (Var)scope.getVar(valueNode.getString());
                if (v == null || !v.isGlobal() || (refCollection = this.getReferences(v)) == null || !refCollection.isWellDefined() || !refCollection.isAssignedOnceInLifetime()) break;
                return true;
            }
            case TEMPLATELIT: {
                for (Node child = valueNode.getFirstChild(); child != null; child = child.getNext()) {
                    if (child.isTemplateLitSub()) {
                        if (this.canMoveValue(scope, child.getFirstChild())) continue;
                        return false;
                    }
                    Preconditions.checkState(child.isTemplateLitString(), child);
                }
                return true;
            }
        }
        return false;
    }

    private static final class TopLevelStatementDraft {
        final int originalOrder;
        final JSModule module;
        final Node statementNode;
        final List<Reference> nonDeclarationReferences = new ArrayList<Reference>();
        Node declaredValueNode = null;
        Node declaredNameNode = null;
        Reference declaredNameReference = null;

        TopLevelStatementDraft(int originalOrder, JSModule module, Node statementNode) {
            this.originalOrder = originalOrder;
            this.module = module;
            this.statementNode = statementNode;
        }
    }

    final class TopLevelStatement {
        private final int originalOrder;
        private final JSModule module;
        private final Node statementNode;
        private final List<Reference> nonDeclarationReferences;
        private final Reference declaredNameReference;
        private final Node declaredValueNode;

        TopLevelStatement(TopLevelStatementDraft draft) {
            this.originalOrder = draft.originalOrder;
            this.module = draft.module;
            this.statementNode = draft.statementNode;
            this.nonDeclarationReferences = Collections.unmodifiableList(draft.nonDeclarationReferences);
            this.declaredNameReference = draft.declaredNameReference;
            this.declaredValueNode = draft.declaredValueNode;
        }

        int getOriginalOrder() {
            return this.originalOrder;
        }

        JSModule getModule() {
            return this.module;
        }

        Node getStatementNode() {
            return this.statementNode;
        }

        List<Reference> getNonDeclarationReferences() {
            return Collections.unmodifiableList(this.nonDeclarationReferences);
        }

        boolean isDeclarationStatement() {
            return this.declaredNameReference != null;
        }

        Reference getDeclaredNameReference() {
            return Preconditions.checkNotNull(this.declaredNameReference);
        }

        @Nullable
        Node getDeclaredValueNode() {
            return this.declaredValueNode;
        }

        boolean isMovableDeclaration() {
            return this.isDeclarationStatement() && CrossChunkReferenceCollector.this.canMoveValue(this.declaredNameReference.getScope(), this.declaredValueNode);
        }
    }
}

