/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.deps.ModuleNames;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;

public final class Es6RewriteClassExtendsExpressions
extends NodeTraversal.AbstractPostOrderCallback
implements HotSwapCompilerPass {
    static final String CLASS_EXTENDS_VAR = "$classextends$var";
    private final AbstractCompiler compiler;
    private int classExtendsVarCounter = 0;
    private static final FeatureSet features = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.CLASSES);

    Es6RewriteClassExtendsExpressions(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        TranspilationPasses.processTranspile(this.compiler, externs, features, this);
        TranspilationPasses.processTranspile(this.compiler, root, features, this);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        TranspilationPasses.hotSwapTranspile(this.compiler, scriptRoot, features, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isClass() && this.needsExtendsDecomposing(n)) {
            if (this.canDecomposeSimply(n)) {
                this.extractExtends(t, n);
            } else {
                this.decomposeInIIFE(t, n);
            }
        }
    }

    private boolean needsExtendsDecomposing(Node classNode) {
        Preconditions.checkArgument(classNode.isClass());
        Node superClassNode = classNode.getSecondChild();
        return !superClassNode.isEmpty() & !superClassNode.isQualifiedName();
    }

    private boolean canDecomposeSimply(Node classNode) {
        Node enclosingStatement = Preconditions.checkNotNull(NodeUtil.getEnclosingStatement(classNode), classNode);
        if (enclosingStatement == classNode) {
            return true;
        }
        Node classNodeParent = classNode.getParent();
        if (NodeUtil.isNameDeclaration(enclosingStatement) && classNodeParent.isName() && classNodeParent.isFirstChildOf(enclosingStatement)) {
            return true;
        }
        if (enclosingStatement.isExprResult() && classNodeParent.isOnlyChildOf(enclosingStatement) && classNodeParent.isAssign() && classNode.isSecondChildOf(classNodeParent)) {
            Node lhsNode = classNodeParent.getFirstChild();
            return !this.compiler.getAstAnalyzer().mayHaveSideEffects(lhsNode);
        }
        return false;
    }

    private void extractExtends(NodeTraversal t, Node classNode) {
        String name = ModuleNames.fileToJsIdentifier(classNode.getStaticSourceFile().getName()) + CLASS_EXTENDS_VAR + this.classExtendsVarCounter++;
        Node statement = NodeUtil.getEnclosingStatement(classNode);
        Node originalExtends = classNode.getSecondChild();
        originalExtends.replaceWith(IR.name(name).useSourceInfoFrom(originalExtends));
        Node extendsAlias = IR.constNode(IR.name(name), originalExtends).useSourceInfoIfMissingFromForTree(originalExtends);
        statement.getParent().addChildBefore(extendsAlias, statement);
        NodeUtil.addFeatureToScript(NodeUtil.getEnclosingScript(classNode), FeatureSet.Feature.CONST_DECLARATIONS);
        t.reportCodeChange(classNode);
    }

    private void decomposeInIIFE(NodeTraversal t, Node classNode) {
        Node functionBody = IR.block();
        Node function = IR.function(IR.name(""), IR.paramList(), functionBody);
        Node call = NodeUtil.newCallNode(function, new Node[0]);
        classNode.replaceWith(call);
        functionBody.addChildToBack(IR.returnNode(classNode));
        call.useSourceInfoIfMissingFromForTree(classNode);
        t.reportCodeChange(call);
        this.extractExtends(t, classNode);
    }
}

