/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.GlobalNamespace;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;

final class InlineAliases
implements CompilerPass {
    static final DiagnosticType ALIAS_CYCLE = DiagnosticType.error("JSC_ALIAS_CYCLE", "Alias path contains a cycle: {0} to {1}");
    private final AbstractCompiler compiler;
    private final Map<String, String> aliases = new LinkedHashMap<String, String>();
    private GlobalNamespace namespace;
    private final AstFactory astFactory;

    InlineAliases(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.astFactory = compiler.createAstFactory();
    }

    @Override
    public void process(Node externs, Node root) {
        this.namespace = new GlobalNamespace(this.compiler, externs, root);
        NodeTraversal.traverseRoots(this.compiler, new AliasesCollector(), externs, root);
        NodeTraversal.traverseRoots(this.compiler, new AliasesInliner(), externs, root);
    }

    private class AliasesInliner
    extends NodeTraversal.ExternsSkippingCallback {
        private AliasesInliner() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case NAME: 
                case GETPROP: {
                    if (!n.isQualifiedName() || !InlineAliases.this.aliases.containsKey(n.getQualifiedName())) break;
                    String leftmostName = NodeUtil.getRootOfQualifiedName(n).getString();
                    Var v = (Var)t.getScope().getVar(leftmostName);
                    if (v != null && v.isLocal()) {
                        return;
                    }
                    if (NodeUtil.isNameDeclOrSimpleAssignLhs(n, parent)) {
                        return;
                    }
                    Node newNode = InlineAliases.this.astFactory.createQName(t.getScope(), this.resolveAlias(n.getQualifiedName(), n));
                    newNode.useSourceInfoFromForTree(n.isGetProp() ? n.getLastChild() : n);
                    if (newNode.isGetProp()) {
                        newNode.getFirstChild().makeNonIndexableRecursive();
                    }
                    parent.replaceChild(n, newNode);
                    t.reportCodeChange();
                    break;
                }
            }
        }

        private String resolveAlias(String name, Node n) {
            LinkedHashSet<String> aliasPath = new LinkedHashSet<String>();
            while (InlineAliases.this.aliases.containsKey(name)) {
                if (!aliasPath.add(name)) {
                    InlineAliases.this.compiler.report(JSError.make(n, ALIAS_CYCLE, ((Object)aliasPath).toString(), name));
                    InlineAliases.this.aliases.remove(name);
                    break;
                }
                name = (String)InlineAliases.this.aliases.get(name);
            }
            return name;
        }
    }

    private class AliasesCollector
    extends NodeTraversal.ExternsSkippingCallback {
        private AliasesCollector() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case VAR: 
                case CONST: 
                case LET: {
                    if (!n.hasOneChild() || !t.inGlobalScope()) break;
                    this.visitAliasDefinition(n.getFirstChild(), NodeUtil.getBestJSDocInfo(n.getFirstChild()));
                    break;
                }
                case ASSIGN: {
                    if (parent == null || !parent.isExprResult() || !t.inGlobalScope()) break;
                    this.visitAliasDefinition(n.getFirstChild(), n.getJSDocInfo());
                    break;
                }
            }
        }

        private void visitAliasDefinition(Node lhs, JSDocInfo info) {
            Node rhs;
            if (this.isDeclaredConst(lhs, info) && (info == null || !info.hasTypeInformation()) && lhs.isQualifiedName() && (rhs = NodeUtil.getRValueOfLValue(lhs)) != null && rhs.isQualifiedName()) {
                GlobalNamespace.Name lhsName = InlineAliases.this.namespace.getOwnSlot(lhs.getQualifiedName());
                GlobalNamespace.Name rhsName = InlineAliases.this.namespace.getOwnSlot(rhs.getQualifiedName());
                if (lhsName != null && lhsName.calculateInlinability().shouldInlineUsages() && rhsName != null && rhsName.calculateInlinability().shouldInlineUsages() && !this.isPrivate(rhsName.getDeclaration().getNode())) {
                    InlineAliases.this.aliases.put(lhs.getQualifiedName(), rhs.getQualifiedName());
                }
            }
        }

        private boolean isDeclaredConst(Node lhs, JSDocInfo info) {
            if (info != null && info.hasConstAnnotation()) {
                return true;
            }
            return lhs.getParent().isConst();
        }

        private boolean isPrivate(Node nameNode) {
            if (nameNode.isQualifiedName() && InlineAliases.this.compiler.getCodingConvention().isPrivate(nameNode.getQualifiedName())) {
                return true;
            }
            JSDocInfo info = NodeUtil.getBestJSDocInfo(nameNode);
            return info != null && info.getVisibility().equals((Object)JSDocInfo.Visibility.PRIVATE);
        }
    }
}

