/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.SortedMap;

class OptimizeArgumentsArray
implements CompilerPass,
NodeTraversal.ScopedCallback {
    private static final String ARGUMENTS = "arguments";
    private static final String PARAMETER_PREFIX = "JSCompiler_OptimizeArgumentsArray_p";
    private final String paramPrefix;
    private int uniqueId = 0;
    private final AbstractCompiler compiler;
    private final Deque<List<Node>> argumentsAccessStack = new ArrayDeque<List<Node>>();
    private List<Node> currentArgumentsAccesses = ImmutableList.of();

    OptimizeArgumentsArray(AbstractCompiler compiler) {
        this(compiler, PARAMETER_PREFIX);
    }

    OptimizeArgumentsArray(AbstractCompiler compiler, String paramPrefix) {
        this.compiler = Preconditions.checkNotNull(compiler);
        this.paramPrefix = Preconditions.checkNotNull(paramPrefix);
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, Preconditions.checkNotNull(root), this);
    }

    @Override
    public void enterScope(NodeTraversal traversal) {
        if (!OptimizeArgumentsArray.definesArgumentsVar(traversal.getScopeRoot())) {
            return;
        }
        this.argumentsAccessStack.push(this.currentArgumentsAccesses);
        this.currentArgumentsAccesses = new ArrayList<Node>();
    }

    @Override
    public void exitScope(NodeTraversal traversal) {
        if (!OptimizeArgumentsArray.definesArgumentsVar(traversal.getScopeRoot())) {
            return;
        }
        this.tryReplaceArguments(traversal.getScope());
        this.currentArgumentsAccesses = this.argumentsAccessStack.pop();
    }

    private static boolean definesArgumentsVar(Node root) {
        return root.isFunction() && !root.isArrowFunction();
    }

    @Override
    public boolean shouldTraverse(NodeTraversal unused0, Node unused1, Node unused2) {
        return true;
    }

    @Override
    public void visit(NodeTraversal traversal, Node node, Node parent) {
        if (traversal.inGlobalHoistScope()) {
            return;
        }
        if (node.isName() && ARGUMENTS.equals(node.getString())) {
            this.currentArgumentsAccesses.add(node);
        }
    }

    private void tryReplaceArguments(Scope scope) {
        Node parametersList = NodeUtil.getFunctionParameters(scope.getRootNode());
        Preconditions.checkState(parametersList.isParamList(), parametersList);
        int numParameters = parametersList.getChildCount();
        int highestIndex = this.getHighestIndex(numParameters - 1);
        if (highestIndex < 0) {
            return;
        }
        ImmutableSortedMap<Integer, String> argNames = this.assembleParamNames(parametersList, highestIndex + 1);
        this.changeMethodSignature(argNames, parametersList);
        this.changeBody(argNames);
    }

    private int getHighestIndex(int highestIndex) {
        for (Node ref : this.currentArgumentsAccesses) {
            Node getElem = ref.getParent();
            if (!getElem.isGetElem() || ref != getElem.getFirstChild()) {
                return -1;
            }
            Node index = ref.getNext();
            if (!index.isNumber() || index.getDouble() < 0.0) {
                return -1;
            }
            if (index.getDouble() != Math.floor(index.getDouble())) {
                return -1;
            }
            Node getElemParent = getElem.getParent();
            if (getElemParent.isCall() && getElemParent.getFirstChild() == getElem) {
                return -1;
            }
            int value = (int)index.getDouble();
            if (value <= highestIndex) continue;
            highestIndex = value;
        }
        return highestIndex;
    }

    private void changeMethodSignature(ImmutableSortedMap<Integer, String> argNames, Node paramList) {
        SortedMap newParams = argNames.tailMap((Object)paramList.getChildCount());
        for (String name : ((ImmutableSortedMap)newParams).values()) {
            paramList.addChildToBack(IR.name(name).useSourceInfoIfMissingFrom(paramList));
        }
        if (!((ImmutableMap)((Object)newParams)).isEmpty()) {
            this.compiler.reportChangeToEnclosingScope(paramList);
        }
    }

    private void changeBody(ImmutableMap<Integer, String> argNames) {
        for (Node ref : this.currentArgumentsAccesses) {
            Node index = ref.getNext();
            Node parent = ref.getParent();
            int value = (int)index.getDouble();
            String name = argNames.get(value);
            if (name == null) continue;
            Node newName = IR.name(name).useSourceInfoIfMissingFrom(parent);
            parent.replaceWith(newName);
            this.compiler.reportChangeToEnclosingScope(newName);
        }
    }

    private ImmutableSortedMap<Integer, String> assembleParamNames(Node paramList, int maxCount) {
        Preconditions.checkArgument(paramList.isParamList(), paramList);
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        int index = 0;
        for (Node param = paramList.getFirstChild(); param != null; param = param.getNext()) {
            switch (param.getToken()) {
                case NAME: {
                    builder.put((Object)index, param.getString());
                    break;
                }
                case REST: {
                    return builder.build();
                }
                case DEFAULT_VALUE: 
                case OBJECT_PATTERN: 
                case ARRAY_PATTERN: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException(param.toString());
                }
            }
            ++index;
        }
        while (index < maxCount) {
            builder.put((Object)index, this.paramPrefix + this.uniqueId++);
            ++index;
        }
        return builder.build();
    }
}

