/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.errorprone.annotations.DoNotCall;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AccessorSummary;
import com.google.javascript.jscomp.AstAnalyzer;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.OptimizeCalls;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.graph.FixedPointGraphTraversal;
import com.google.javascript.jscomp.graph.LinkedDirectedGraph;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

class PureFunctionIdentifier
implements OptimizeCalls.CallGraphCompilerPass {
    private static final String PROP_NAME_PREFIX = ".";
    private final AbstractCompiler compiler;
    private final AstAnalyzer astAnalyzer;
    private final Map<String, AmbiguatedFunctionSummary> summariesByName = new HashMap<String, AmbiguatedFunctionSummary>();
    private final Multimap<Node, AmbiguatedFunctionSummary> summariesForAllNamesOfFunctionByNode = ArrayListMultimap.create();
    private final List<Node> allFunctionCalls = new ArrayList<Node>();
    private final LinkedDirectedGraph<AmbiguatedFunctionSummary, SideEffectPropagation> reverseCallGraph = LinkedDirectedGraph.createWithoutAnnotations();
    private final AmbiguatedFunctionSummary unknownFunctionSummary = AmbiguatedFunctionSummary.createInGraph(this.reverseCallGraph, "<unknown>").setAllFlags();
    private final boolean assumeGettersArePure;
    private boolean hasProcessed = false;
    private static final Predicate<Node> RHS_IS_ALWAYS_LOCAL = lhs -> true;
    private static final Predicate<Node> RHS_IS_NEVER_LOCAL = lhs -> false;
    private static final Predicate<Node> FIND_RHS_AND_CHECK_FOR_LOCAL_VALUE = lhs -> {
        Node rhs = NodeUtil.getRValueOfLValue(lhs);
        return rhs == null || NodeUtil.evaluatesToLocalValue(rhs);
    };

    public PureFunctionIdentifier(AbstractCompiler compiler, boolean assumeGettersArePure) {
        this.compiler = Preconditions.checkNotNull(compiler);
        this.assumeGettersArePure = assumeGettersArePure;
        this.astAnalyzer = compiler.getAstAnalyzer();
    }

    @Override
    public void process(Node externs, Node root, OptimizeCalls.ReferenceMap references) {
        Preconditions.checkState(this.compiler.getLifeCycleStage().isNormalized());
        Preconditions.checkState(!this.hasProcessed, "PureFunctionIdentifier::process may only be called once per instance.");
        this.hasProcessed = true;
        this.populateDatastructuresForAnalysisTraversal(references);
        NodeTraversal.traverse(this.compiler, externs, new ExternFunctionAnnotationAnalyzer());
        NodeTraversal.traverse(this.compiler, root, new FunctionBodyAnalyzer());
        this.propagateSideEffects();
        this.markPureFunctionCalls();
    }

    @Nullable
    private static ImmutableList<Node> collectCallableLeaves(Node expr) {
        ArrayList<Node> callables = new ArrayList<Node>();
        boolean allLegal = PureFunctionIdentifier.collectCallableLeavesInternal(expr, callables);
        return allLegal ? ImmutableList.copyOf(callables) : null;
    }

    private static boolean collectCallableLeavesInternal(Node expr, ArrayList<Node> results) {
        switch (expr.getToken()) {
            case FUNCTION: 
            case GETPROP: 
            case NAME: {
                results.add(expr);
                return true;
            }
            case SUPER: {
                Node clazz = Preconditions.checkNotNull(NodeUtil.getEnclosingClass(expr));
                Node function = Preconditions.checkNotNull(NodeUtil.getEnclosingFunction(expr));
                Node ctorDef = Preconditions.checkNotNull(NodeUtil.getEs6ClassConstructorMemberFunctionDef(clazz));
                Preconditions.checkState(function.isFirstChildOf(ctorDef), "Unknown SUPER reference: %s", (Object)expr.toStringTree());
                return PureFunctionIdentifier.collectCallableLeavesInternal(clazz.getSecondChild(), results);
            }
            case CLASS: {
                Node ctorDef = NodeUtil.getEs6ClassConstructorMemberFunctionDef(expr);
                if (ctorDef != null) {
                    return PureFunctionIdentifier.collectCallableLeavesInternal(ctorDef.getOnlyChild(), results);
                }
                if (expr.getSecondChild().isEmpty()) {
                    return true;
                }
                return PureFunctionIdentifier.collectCallableLeavesInternal(expr.getSecondChild(), results);
            }
            case AND: 
            case OR: {
                return PureFunctionIdentifier.collectCallableLeavesInternal(expr.getFirstChild(), results) && PureFunctionIdentifier.collectCallableLeavesInternal(expr.getSecondChild(), results);
            }
            case COMMA: 
            case ASSIGN: {
                return PureFunctionIdentifier.collectCallableLeavesInternal(expr.getSecondChild(), results);
            }
            case HOOK: {
                return PureFunctionIdentifier.collectCallableLeavesInternal(expr.getChildAtIndex(1), results) && PureFunctionIdentifier.collectCallableLeavesInternal(expr.getChildAtIndex(2), results);
            }
        }
        return false;
    }

    private static boolean isDefinitelyRValue(Node rvalue) {
        Node parent = rvalue.getParent();
        switch (parent.getToken()) {
            case GETPROP: 
            case AND: 
            case OR: 
            case COMMA: 
            case HOOK: 
            case EQ: 
            case NOT: 
            case SHEQ: 
            case ARRAYLIT: 
            case CALL: 
            case NEW: 
            case TAGGED_TEMPLATELIT: 
            case INSTANCEOF: 
            case TYPEOF: 
            case GETELEM: 
            case RETURN: 
            case YIELD: {
                return true;
            }
            case SWITCH: 
            case CASE: 
            case IF: 
            case WHILE: {
                return rvalue.isFirstChildOf(parent);
            }
            case EXPR_RESULT: {
                return !rvalue.isFromExterns();
            }
            case CLASS: 
            case ASSIGN: {
                return rvalue.isSecondChildOf(parent);
            }
            case STRING_KEY: {
                return parent.getParent().isObjectLit();
            }
        }
        return false;
    }

    private ImmutableList<Node> getGoogCacheCallableExpression(CodingConvention.Cache cacheCall) {
        Preconditions.checkNotNull(cacheCall);
        ImmutableCollection.Builder builder = ImmutableList.builder().addAll(PureFunctionIdentifier.collectCallableLeaves(cacheCall.valueFn));
        if (cacheCall.keyFn != null) {
            ((ImmutableList.Builder)builder).addAll(PureFunctionIdentifier.collectCallableLeaves(cacheCall.keyFn));
        }
        return ((ImmutableList.Builder)builder).build();
    }

    private ImmutableList<AmbiguatedFunctionSummary> getSummariesForCallee(Node invocation) {
        Preconditions.checkArgument(NodeUtil.isInvocation(invocation), invocation);
        CodingConvention.Cache cacheCall = this.compiler.getCodingConvention().describeCachingCall(invocation);
        ImmutableList<Node> callees = cacheCall != null ? this.getGoogCacheCallableExpression(cacheCall) : (PureFunctionIdentifier.isInvocationViaCallOrApply(invocation) ? ImmutableList.of(invocation.getFirstFirstChild()) : PureFunctionIdentifier.collectCallableLeaves(invocation.getFirstChild()));
        if (callees == null) {
            return ImmutableList.of(this.unknownFunctionSummary);
        }
        ImmutableList.Builder results = ImmutableList.builder();
        for (Node callee : callees) {
            if (callee.isFunction()) {
                Preconditions.checkState(callee.isFunction(), callee);
                Collection<AmbiguatedFunctionSummary> summariesForFunction = this.summariesForAllNamesOfFunctionByNode.get(callee);
                Preconditions.checkState(!summariesForFunction.isEmpty(), "Function missed during analysis: %s", (Object)callee);
                results.addAll(summariesForFunction);
                continue;
            }
            String calleeName = PureFunctionIdentifier.nameForReference(callee);
            results.add(this.summariesByName.getOrDefault(calleeName, this.unknownFunctionSummary));
        }
        return results.build();
    }

    private void populateDatastructuresForAnalysisTraversal(OptimizeCalls.ReferenceMap referenceMap) {
        ArrayListMultimap referencesByName = ArrayListMultimap.create();
        for (Map.Entry<String, ArrayList<Node>> entry : referenceMap.getNameReferences()) {
            referencesByName.putAll(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, ArrayList<Node>> entry : referenceMap.getPropReferences()) {
            referencesByName.putAll(PROP_NAME_PREFIX + entry.getKey(), entry.getValue());
        }
        Preconditions.checkState(!referencesByName.containsKey(""));
        Preconditions.checkState(!referencesByName.containsKey(PROP_NAME_PREFIX));
        for (String name : referencesByName.keySet()) {
            this.summariesByName.put(name, AmbiguatedFunctionSummary.createInGraph(this.reverseCallGraph, name));
        }
        Multimaps.asMap(referencesByName).forEach(this::populateFunctionDefinitions);
    }

    private void populateFunctionDefinitions(String name, List<Node> references) {
        AmbiguatedFunctionSummary summaryForName = Preconditions.checkNotNull(this.summariesByName.get(name));
        List rvaluesAssignedToName = references.stream().filter(n -> !PureFunctionIdentifier.isDefinitelyRValue(n)).map(NodeUtil::getRValueOfLValue).map(n -> n == null ? null : PureFunctionIdentifier.collectCallableLeaves(n)).collect(Collectors.toList());
        if (rvaluesAssignedToName.isEmpty() || rvaluesAssignedToName.contains(null)) {
            summaryForName.setAllFlags();
        } else {
            rvaluesAssignedToName.stream().flatMap(Collection::stream).forEach(rvalue -> {
                if (rvalue.isFunction()) {
                    this.summariesForAllNamesOfFunctionByNode.put((Node)rvalue, summaryForName);
                } else {
                    String rvalueName = PureFunctionIdentifier.nameForReference(rvalue);
                    AmbiguatedFunctionSummary rvalueSummary = this.summariesByName.getOrDefault(rvalueName, this.unknownFunctionSummary);
                    this.reverseCallGraph.connect(rvalueSummary.graphNode, SideEffectPropagation.forAlias(), summaryForName.graphNode);
                }
            });
        }
    }

    private void propagateSideEffects() {
        FixedPointGraphTraversal.newTraversal((source, edge, destination) -> edge.propagate((AmbiguatedFunctionSummary)source, (AmbiguatedFunctionSummary)destination)).computeFixedPoint(this.reverseCallGraph);
    }

    private void markPureFunctionCalls() {
        for (Node callNode : this.allFunctionCalls) {
            ImmutableList<AmbiguatedFunctionSummary> calleeSummaries = this.getSummariesForCallee(callNode);
            Node.SideEffectFlags flags = new Node.SideEffectFlags();
            if (calleeSummaries.isEmpty()) {
                flags.setAllFlags();
            } else {
                flags.clearAllFlags();
                for (AmbiguatedFunctionSummary calleeSummary : calleeSummaries) {
                    Preconditions.checkNotNull(calleeSummary);
                    if (calleeSummary.mutatesGlobalState()) {
                        flags.setMutatesGlobalState();
                    }
                    if (calleeSummary.mutatesArguments()) {
                        flags.setMutatesArguments();
                    }
                    if (calleeSummary.functionThrows()) {
                        flags.setThrows();
                    }
                    if (PureFunctionIdentifier.isCallOrTaggedTemplateLit(callNode) && calleeSummary.mutatesThis()) {
                        if (PureFunctionIdentifier.isInvocationViaCallOrApply(callNode)) {
                            flags.setMutatesArguments();
                        } else {
                            flags.setMutatesThis();
                        }
                    }
                    if (!calleeSummary.escapedReturn()) continue;
                    flags.setReturnsTainted();
                }
            }
            if (callNode.getFirstChild().isSuper()) {
                flags.setMutatesThis();
            }
            if (PureFunctionIdentifier.isCallOrTaggedTemplateLit(callNode)) {
                if (!this.astAnalyzer.functionCallHasSideEffects(callNode)) {
                    flags.clearSideEffectFlags();
                }
            } else if (callNode.isNew() && !this.astAnalyzer.constructorCallHasSideEffects(callNode)) {
                flags.clearSideEffectFlags();
            }
            if (callNode.getSideEffectFlags() == flags.valueOf()) continue;
            callNode.setSideEffectFlags(flags);
            this.compiler.reportChangeToEnclosingScope(callNode);
        }
    }

    private static boolean isInvocationViaCallOrApply(Node callSite) {
        Node receiver = callSite.getFirstFirstChild();
        if (receiver == null || !receiver.isName() && !receiver.isGetProp()) {
            return false;
        }
        return NodeUtil.isFunctionObjectCall(callSite) || NodeUtil.isFunctionObjectApply(callSite);
    }

    private static boolean isCallOrTaggedTemplateLit(Node invocation) {
        return invocation.isCall() || invocation.isTaggedTemplateLit();
    }

    @Nullable
    private static String nameForReference(Node nameRef) {
        switch (nameRef.getToken()) {
            case NAME: {
                return nameRef.getString();
            }
            case GETPROP: {
                return PROP_NAME_PREFIX + nameRef.getSecondChild().getString();
            }
        }
        throw new IllegalStateException("Unexpected name reference: " + nameRef.toStringTree());
    }

    private AccessorSummary.PropertyAccessKind getPropertyKind(String name) {
        return this.assumeGettersArePure ? AccessorSummary.PropertyAccessKind.NORMAL : this.compiler.getAccessorSummary().getKind(name);
    }

    static final class Driver
    implements CompilerPass {
        private final AbstractCompiler compiler;

        Driver(AbstractCompiler compiler) {
            this.compiler = compiler;
        }

        @Override
        public void process(Node externs, Node root) {
            OptimizeCalls.builder().setCompiler(this.compiler).setConsiderExterns(true).addPass(new PureFunctionIdentifier(this.compiler, this.compiler.getOptions().getAssumeGettersArePure())).build().process(externs, root);
        }
    }

    private static final class AmbiguatedFunctionSummary {
        private static final int THROWS = 1;
        private static final int MUTATES_GLOBAL_STATE = 2;
        private static final int MUTATES_THIS = 4;
        private static final int MUTATES_ARGUMENTS = 8;
        private static final int ESCAPED_RETURN = 16;
        private final String name;
        private final DiGraph.DiGraphNode<AmbiguatedFunctionSummary, SideEffectPropagation> graphNode;
        private int bitmask = 0;

        static AmbiguatedFunctionSummary createInGraph(DiGraph<AmbiguatedFunctionSummary, SideEffectPropagation> graph, String name) {
            return new AmbiguatedFunctionSummary(graph, name);
        }

        private AmbiguatedFunctionSummary(DiGraph<AmbiguatedFunctionSummary, SideEffectPropagation> graph, String name) {
            this.name = Preconditions.checkNotNull(name);
            this.graphNode = graph.createDirectedGraphNode(this);
        }

        private AmbiguatedFunctionSummary setMask(int mask) {
            this.bitmask |= mask;
            return this;
        }

        private boolean getMask(int mask) {
            return (this.bitmask & mask) != 0;
        }

        boolean mutatesThis() {
            return this.getMask(4);
        }

        AmbiguatedFunctionSummary setMutatesThis() {
            return this.setMask(4);
        }

        boolean escapedReturn() {
            return this.getMask(16);
        }

        AmbiguatedFunctionSummary setEscapedReturn() {
            return this.setMask(16);
        }

        boolean functionThrows() {
            return this.getMask(1);
        }

        AmbiguatedFunctionSummary setFunctionThrows() {
            return this.setMask(1);
        }

        boolean mutatesGlobalState() {
            return this.getMask(2);
        }

        AmbiguatedFunctionSummary setMutatesGlobalState() {
            return this.setMask(2);
        }

        boolean mutatesArguments() {
            return this.getMask(10);
        }

        AmbiguatedFunctionSummary setMutatesArguments() {
            return this.setMask(8);
        }

        AmbiguatedFunctionSummary setAllFlags() {
            return this.setMask(31);
        }

        @DoNotCall
        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("name", this.name).add("graphNode", this.graphNode.hashCode()).add("sideEffects", this.sideEffectsToString()).toString();
        }

        private String sideEffectsToString() {
            ArrayList<String> status = new ArrayList<String>();
            if (this.mutatesThis()) {
                status.add("this");
            }
            if (this.mutatesGlobalState()) {
                status.add("global");
            }
            if (this.mutatesArguments()) {
                status.add("args");
            }
            if (this.escapedReturn()) {
                status.add("return");
            }
            if (this.functionThrows()) {
                status.add("throw");
            }
            return ((Object)status).toString();
        }
    }

    private static class SideEffectPropagation {
        private final boolean callerIsAlias;
        private final boolean allArgsUnescapedLocal;
        private final boolean calleeThisEqualsCallerThis;
        @Nullable
        private final Node invocation;

        private SideEffectPropagation(boolean callerIsAlias, boolean allArgsUnescapedLocal, boolean calleeThisEqualsCallerThis, Node invocation) {
            Preconditions.checkArgument(invocation == null || NodeUtil.isInvocation(invocation), invocation);
            this.callerIsAlias = callerIsAlias;
            this.allArgsUnescapedLocal = allArgsUnescapedLocal;
            this.calleeThisEqualsCallerThis = calleeThisEqualsCallerThis;
            this.invocation = invocation;
        }

        static SideEffectPropagation forAlias() {
            return new SideEffectPropagation(true, false, false, null);
        }

        static SideEffectPropagation forInvocation(Node invocation) {
            Preconditions.checkArgument(NodeUtil.isInvocation(invocation), invocation);
            return new SideEffectPropagation(false, NodeUtil.allArgsUnescapedLocal(invocation), SideEffectPropagation.calleeAndCallerShareThis(invocation), invocation);
        }

        private static boolean calleeAndCallerShareThis(Node invocation) {
            if (!PureFunctionIdentifier.isCallOrTaggedTemplateLit(invocation)) {
                return false;
            }
            Node callee = invocation.getFirstChild();
            if (callee.isSuper()) {
                return true;
            }
            Node thisArg = PureFunctionIdentifier.isInvocationViaCallOrApply(invocation) ? invocation.getSecondChild() : (callee.isGetProp() ? callee.getFirstChild() : null);
            if (thisArg == null) {
                return false;
            }
            return thisArg.isThis() || thisArg.isSuper();
        }

        boolean propagate(AmbiguatedFunctionSummary callee, AmbiguatedFunctionSummary caller) {
            int initialCallerFlags = caller.bitmask;
            if (this.callerIsAlias) {
                caller.setMask(callee.bitmask);
                return caller.bitmask != initialCallerFlags;
            }
            if (callee.mutatesGlobalState()) {
                caller.setMutatesGlobalState();
            }
            if (callee.functionThrows()) {
                caller.setFunctionThrows();
            }
            if (callee.mutatesArguments() && !this.allArgsUnescapedLocal) {
                caller.setMutatesGlobalState();
            }
            if (callee.mutatesThis() && !this.invocation.isNew()) {
                if (this.calleeThisEqualsCallerThis) {
                    caller.setMutatesThis();
                } else {
                    caller.setMutatesGlobalState();
                }
            }
            return caller.bitmask != initialCallerFlags;
        }
    }

    private final class FunctionBodyAnalyzer
    implements NodeTraversal.ScopedCallback {
        private final SetMultimap<Node, Var> blacklistedVarsByFunction = HashMultimap.create();
        private final SetMultimap<Node, Var> taintedVarsByFunction = HashMultimap.create();

        private FunctionBodyAnalyzer() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal traversal, Node node, Node parent) {
            if (!node.isFunction()) {
                return true;
            }
            if (!PureFunctionIdentifier.this.summariesForAllNamesOfFunctionByNode.containsKey(node)) {
                AmbiguatedFunctionSummary summary = AmbiguatedFunctionSummary.createInGraph(PureFunctionIdentifier.this.reverseCallGraph, "<anonymous>");
                PureFunctionIdentifier.this.summariesForAllNamesOfFunctionByNode.put(node, summary);
            }
            return true;
        }

        @Override
        public void visit(NodeTraversal traversal, Node node, Node parent) {
            Scope containerScope;
            if (!PureFunctionIdentifier.this.compiler.getAstAnalyzer().nodeTypeMayHaveSideEffects(node) && !node.isReturn()) {
                return;
            }
            if (NodeUtil.isInvocation(node)) {
                PureFunctionIdentifier.this.allFunctionCalls.add(node);
            }
            if (!(containerScope = (Scope)traversal.getScope().getClosestContainerScope()).isFunctionScope()) {
                return;
            }
            Node enclosingFunction = containerScope.getRootNode();
            for (AmbiguatedFunctionSummary encloserSummary : PureFunctionIdentifier.this.summariesForAllNamesOfFunctionByNode.get(enclosingFunction)) {
                Preconditions.checkNotNull(encloserSummary);
                this.updateSideEffectsForNode(encloserSummary, traversal, node, enclosingFunction);
            }
        }

        private void updateSideEffectsForNode(AmbiguatedFunctionSummary encloserSummary, NodeTraversal traversal, Node node, Node enclosingFunction) {
            switch (node.getToken()) {
                case ASSIGN: {
                    this.visitLhsNodes(encloserSummary, traversal.getScope(), enclosingFunction, NodeUtil.findLhsNodesInNode(node), FIND_RHS_AND_CHECK_FOR_LOCAL_VALUE);
                    break;
                }
                case INC: 
                case DEC: 
                case DELPROP: {
                    this.visitLhsNodes(encloserSummary, traversal.getScope(), enclosingFunction, ImmutableList.of(node.getOnlyChild()), RHS_IS_ALWAYS_LOCAL);
                    break;
                }
                case FOR_AWAIT_OF: {
                    this.deprecatedSetSideEffectsForControlLoss(encloserSummary);
                }
                case FOR_OF: {
                    this.visitLhsNodes(encloserSummary, traversal.getScope(), enclosingFunction, NodeUtil.findLhsNodesInNode(node), RHS_IS_NEVER_LOCAL);
                    this.checkIteratesImpureIterable(node, encloserSummary);
                    break;
                }
                case FOR_IN: {
                    this.visitLhsNodes(encloserSummary, traversal.getScope(), enclosingFunction, NodeUtil.findLhsNodesInNode(node), RHS_IS_ALWAYS_LOCAL);
                    break;
                }
                case CALL: 
                case NEW: 
                case TAGGED_TEMPLATELIT: {
                    this.visitCall(encloserSummary, node);
                    break;
                }
                case NAME: {
                    Preconditions.checkArgument(NodeUtil.isNameDeclaration(node.getParent()), node.getParent());
                    Node value = node.getFirstChild();
                    if (value == null || NodeUtil.evaluatesToLocalValue(value)) break;
                    Scope scope = traversal.getScope();
                    Var var = (Var)scope.getVar(node.getString());
                    this.blacklistedVarsByFunction.put(enclosingFunction, var);
                    break;
                }
                case THROW: {
                    encloserSummary.setFunctionThrows();
                    break;
                }
                case RETURN: {
                    if (!node.hasChildren() || NodeUtil.evaluatesToLocalValue(node.getFirstChild())) break;
                    encloserSummary.setEscapedReturn();
                    break;
                }
                case YIELD: {
                    this.checkIteratesImpureIterable(node, encloserSummary);
                    this.deprecatedSetSideEffectsForControlLoss(encloserSummary);
                    break;
                }
                case AWAIT: {
                    this.deprecatedSetSideEffectsForControlLoss(encloserSummary);
                    break;
                }
                case REST: 
                case SPREAD: {
                    if (node.getParent().isObjectPattern() || node.getParent().isObjectLit()) {
                        if (PureFunctionIdentifier.this.assumeGettersArePure) break;
                        this.setSideEffectsForUnknownCall(encloserSummary);
                        break;
                    }
                    this.checkIteratesImpureIterable(node, encloserSummary);
                    break;
                }
                case STRING_KEY: {
                    if (!node.getParent().isObjectPattern() || !PureFunctionIdentifier.this.getPropertyKind(node.getString()).hasGetter()) break;
                    this.setSideEffectsForUnknownCall(encloserSummary);
                    break;
                }
                case GETPROP: {
                    if (!PureFunctionIdentifier.this.getPropertyKind(node.getLastChild().getString()).hasGetterOrSetter()) break;
                    this.setSideEffectsForUnknownCall(encloserSummary);
                    break;
                }
                default: {
                    if (NodeUtil.isCompoundAssignmentOp(node)) {
                        this.visitLhsNodes(encloserSummary, traversal.getScope(), enclosingFunction, ImmutableList.of(node.getFirstChild()), RHS_IS_ALWAYS_LOCAL);
                        break;
                    }
                    throw new IllegalArgumentException("Unhandled side effect node type " + node);
                }
            }
        }

        private void checkIteratesImpureIterable(Node node, AmbiguatedFunctionSummary encloserSummary) {
            if (!NodeUtil.iteratesImpureIterable(node)) {
                return;
            }
            this.setSideEffectsForUnknownCall(encloserSummary);
        }

        private void deprecatedSetSideEffectsForControlLoss(AmbiguatedFunctionSummary encloserSummary) {
            encloserSummary.setFunctionThrows();
        }

        private void setSideEffectsForUnknownCall(AmbiguatedFunctionSummary encloserSummary) {
            encloserSummary.setFunctionThrows();
            encloserSummary.setMutatesGlobalState();
            encloserSummary.setMutatesArguments();
            encloserSummary.setMutatesThis();
        }

        @Override
        public void enterScope(NodeTraversal t) {
        }

        @Override
        public void exitScope(NodeTraversal t) {
            Scope closestContainerScope = (Scope)t.getScope().getClosestContainerScope();
            if (!closestContainerScope.isFunctionScope()) {
                return;
            }
            Node function = closestContainerScope.getRootNode();
            block0: for (AmbiguatedFunctionSummary sideEffectInfo : PureFunctionIdentifier.this.summariesForAllNamesOfFunctionByNode.get(function)) {
                Preconditions.checkNotNull(sideEffectInfo, "%s has no side effect info.", (Object)function);
                if (sideEffectInfo.mutatesGlobalState()) continue;
                for (Var v : t.getScope().getVarIterable()) {
                    if (v.isParam() && !this.blacklistedVarsByFunction.containsEntry(function, v) && this.taintedVarsByFunction.containsEntry(function, v)) {
                        sideEffectInfo.setMutatesArguments();
                        continue;
                    }
                    boolean localVar = false;
                    if (!v.isParam() && !v.isCatch()) {
                        localVar = true;
                    }
                    if (localVar && !this.blacklistedVarsByFunction.containsEntry(function, v) || !this.taintedVarsByFunction.containsEntry(function, v)) continue;
                    sideEffectInfo.setMutatesGlobalState();
                    continue block0;
                }
            }
            if (t.getScopeRoot().isFunction()) {
                this.blacklistedVarsByFunction.removeAll(function);
                this.taintedVarsByFunction.removeAll(function);
            }
        }

        private boolean isVarDeclaredInSameContainerScope(@Nullable Var v, Scope scope) {
            return v != null && ((Scope)v.scope).hasSameContainerScope(scope);
        }

        private void visitLhsNodes(AmbiguatedFunctionSummary sideEffectInfo, Scope scope, Node enclosingFunction, List<Node> lhsNodes, Predicate<Node> hasLocalRhs) {
            for (Node lhs : lhsNodes) {
                if (NodeUtil.isGet(lhs)) {
                    if (lhs.getFirstChild().isThis()) {
                        sideEffectInfo.setMutatesThis();
                        continue;
                    }
                    Node objectNode = lhs.getFirstChild();
                    if (objectNode.isName()) {
                        Var var = (Var)scope.getVar(objectNode.getString());
                        if (this.isVarDeclaredInSameContainerScope(var, scope)) {
                            this.taintedVarsByFunction.put(enclosingFunction, var);
                            continue;
                        }
                        sideEffectInfo.setMutatesGlobalState();
                        continue;
                    }
                    sideEffectInfo.setMutatesGlobalState();
                    continue;
                }
                Preconditions.checkState(lhs.isName(), lhs);
                Var var = (Var)scope.getVar(lhs.getString());
                if (this.isVarDeclaredInSameContainerScope(var, scope)) {
                    if (hasLocalRhs.test(lhs)) continue;
                    this.blacklistedVarsByFunction.put(enclosingFunction, var);
                    continue;
                }
                sideEffectInfo.setMutatesGlobalState();
            }
        }

        private void visitCall(AmbiguatedFunctionSummary callerInfo, Node invocation) {
            if (invocation.isCall() && !PureFunctionIdentifier.this.astAnalyzer.functionCallHasSideEffects(invocation)) {
                return;
            }
            if (invocation.isNew() && !PureFunctionIdentifier.this.astAnalyzer.constructorCallHasSideEffects(invocation)) {
                return;
            }
            ImmutableList calleeSummaries = PureFunctionIdentifier.this.getSummariesForCallee(invocation);
            if (calleeSummaries.isEmpty()) {
                callerInfo.setAllFlags();
                return;
            }
            for (AmbiguatedFunctionSummary calleeInfo : calleeSummaries) {
                SideEffectPropagation edge = SideEffectPropagation.forInvocation(invocation);
                PureFunctionIdentifier.this.reverseCallGraph.connect(calleeInfo.graphNode, edge, callerInfo.graphNode);
            }
        }
    }

    private final class ExternFunctionAnnotationAnalyzer
    implements NodeTraversal.Callback {
        private ExternFunctionAnnotationAnalyzer() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal traversal, Node node, Node parent) {
            return true;
        }

        @Override
        public void visit(NodeTraversal traversal, Node node, Node parent) {
            if (!node.isFunction()) {
                return;
            }
            for (AmbiguatedFunctionSummary definitionSummary : PureFunctionIdentifier.this.summariesForAllNamesOfFunctionByNode.get(node)) {
                this.updateSideEffectsForExternFunction(node, definitionSummary);
            }
        }

        private void updateSideEffectsForExternFunction(Node externFunction, AmbiguatedFunctionSummary summary) {
            FunctionType functionType;
            Preconditions.checkArgument(externFunction.isFunction());
            Preconditions.checkArgument(externFunction.isFromExterns());
            JSDocInfo info = NodeUtil.getBestJSDocInfo(externFunction);
            JSType typei = externFunction.getJSType();
            FunctionType functionType2 = functionType = typei == null ? null : typei.toMaybeFunctionType();
            if (functionType == null) {
                summary.setEscapedReturn();
            } else {
                JSType retType = functionType.getReturnType();
                if (!this.isLocalValueType(retType, PureFunctionIdentifier.this.compiler)) {
                    summary.setEscapedReturn();
                }
            }
            if (info == null) {
                summary.setMutatesGlobalState();
                summary.setFunctionThrows();
            } else if (info.modifiesThis()) {
                summary.setMutatesThis();
            } else if (info.hasSideEffectsArgumentsAnnotation()) {
                summary.setMutatesArguments();
            } else if (!info.getThrownTypes().isEmpty()) {
                summary.setFunctionThrows();
            } else if (!info.isNoSideEffects()) {
                summary.setMutatesGlobalState();
            }
        }

        private boolean isLocalValueType(JSType typei, AbstractCompiler compiler) {
            Preconditions.checkNotNull(typei);
            JSType nativeObj = compiler.getTypeRegistry().getNativeType(JSTypeNative.OBJECT_TYPE);
            JSType subtype = typei.meetWith(nativeObj);
            return subtype.isEmptyType();
        }
    }
}

