/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.Node;

public final class RewriteObjectSpread
implements NodeTraversal.Callback,
HotSwapCompilerPass {
    private final AbstractCompiler compiler;
    private static final FeatureSet transpiledFeatures = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.OBJECT_LITERALS_WITH_SPREAD);
    private final AstFactory astFactory;

    public RewriteObjectSpread(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.astFactory = compiler.createAstFactory();
    }

    @Override
    public void process(Node externs, Node root) {
        TranspilationPasses.processTranspile(this.compiler, externs, transpiledFeatures, this);
        TranspilationPasses.processTranspile(this.compiler, root, transpiledFeatures, this);
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, transpiledFeatures);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        TranspilationPasses.hotSwapTranspile(this.compiler, scriptRoot, transpiledFeatures, this);
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, transpiledFeatures);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case OBJECTLIT: {
                this.visitObject(t, n);
                break;
            }
        }
    }

    private void visitObject(NodeTraversal t, Node obj) {
        for (Node child : obj.children()) {
            if (!child.isSpread()) continue;
            this.visitObjectWithSpread(t, obj);
            return;
        }
    }

    private void visitObjectWithSpread(NodeTraversal t, Node obj) {
        Preconditions.checkArgument(obj.isObjectLit());
        Node result = this.astFactory.createObjectDotAssignCall(t.getScope(), obj.getJSType(), this.astFactory.createEmptyObjectLit());
        Node trailingObjectLiteral = null;
        for (Node child : obj.children()) {
            if (child.isSpread()) {
                Node spreaded = child.removeFirstChild();
                result.addChildToBack(spreaded);
                trailingObjectLiteral = null;
                continue;
            }
            if (trailingObjectLiteral == null) {
                trailingObjectLiteral = this.astFactory.createEmptyObjectLit();
                result.addChildToBack(trailingObjectLiteral);
            }
            trailingObjectLiteral.addChildToBack(child.detach());
        }
        result.useSourceInfoIfMissingFromForTree(obj);
        obj.replaceWith(result);
        this.compiler.reportChangeToEnclosingScope(result);
    }
}

