/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AbstractScope;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DestructuredTarget;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.FunctionTypeBuilder;
import com.google.javascript.jscomp.InferJSDocInfo;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JsIterables;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Promises;
import com.google.javascript.jscomp.RhinoErrorReporter;
import com.google.javascript.jscomp.TypeInferencePass;
import com.google.javascript.jscomp.TypeValidator;
import com.google.javascript.jscomp.TypedScope;
import com.google.javascript.jscomp.TypedScopeCreator;
import com.google.javascript.jscomp.TypedVar;
import com.google.javascript.jscomp.type.ReverseAbstractInterpreter;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.QualifiedName;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.EnumType;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.NamedType;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.Property;
import com.google.javascript.rhino.jstype.TemplateTypeMap;
import com.google.javascript.rhino.jstype.TemplateTypeMapReplacer;
import com.google.javascript.rhino.jstype.TemplatizedType;
import com.google.javascript.rhino.jstype.TernaryValue;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;

public final class TypeCheck
implements NodeTraversal.Callback,
CompilerPass {
    static final DiagnosticType UNEXPECTED_TOKEN = DiagnosticType.error("JSC_INTERNAL_ERROR_UNEXPECTED_TOKEN", "Internal Error: TypeCheck doesn''t know how to handle {0}");
    static final DiagnosticType DETERMINISTIC_TEST = DiagnosticType.warning("JSC_DETERMINISTIC_TEST", "condition always evaluates to {2}\nleft : {0}\nright: {1}");
    static final DiagnosticType INEXISTENT_ENUM_ELEMENT = DiagnosticType.warning("JSC_INEXISTENT_ENUM_ELEMENT", "element {0} does not exist on this enum");
    public static final DiagnosticType INEXISTENT_PROPERTY = DiagnosticType.warning("JSC_INEXISTENT_PROPERTY", "Property {0} never defined on {1}");
    static final DiagnosticType POSSIBLE_INEXISTENT_PROPERTY = DiagnosticType.disabled("JSC_POSSIBLE_INEXISTENT_PROPERTY", "Property {0} never defined on {1}");
    static final DiagnosticType INEXISTENT_PROPERTY_WITH_SUGGESTION = DiagnosticType.warning("JSC_INEXISTENT_PROPERTY_WITH_SUGGESTION", "Property {0} never defined on {1}. Did you mean {2}?");
    public static final DiagnosticType STRICT_INEXISTENT_PROPERTY = DiagnosticType.disabled("JSC_STRICT_INEXISTENT_PROPERTY", "Property {0} never defined on {1}");
    public static final DiagnosticType STRICT_INEXISTENT_UNION_PROPERTY = DiagnosticType.disabled("JSC_STRICT_INEXISTENT_UNION_PROPERTY", "Property {0} not defined on all member types of {1}");
    static final DiagnosticType STRICT_INEXISTENT_PROPERTY_WITH_SUGGESTION = DiagnosticType.disabled("JSC_STRICT_INEXISTENT_PROPERTY_WITH_SUGGESTION", "Property {0} never defined on {1}. Did you mean {2}?");
    protected static final DiagnosticType NOT_A_CONSTRUCTOR = DiagnosticType.warning("JSC_NOT_A_CONSTRUCTOR", "cannot instantiate non-constructor");
    static final DiagnosticType INSTANTIATE_ABSTRACT_CLASS = DiagnosticType.warning("JSC_INSTANTIATE_ABSTRACT_CLASS", "cannot instantiate abstract class");
    static final DiagnosticType BIT_OPERATION = DiagnosticType.warning("JSC_BAD_TYPE_FOR_BIT_OPERATION", "operator {0} cannot be applied to {1}");
    static final DiagnosticType NOT_CALLABLE = DiagnosticType.warning("JSC_NOT_FUNCTION_TYPE", "{0} expressions are not callable");
    static final DiagnosticType CONSTRUCTOR_NOT_CALLABLE = DiagnosticType.warning("JSC_CONSTRUCTOR_NOT_CALLABLE", "Constructor {0} should be called with the \"new\" keyword");
    static final DiagnosticType ABSTRACT_SUPER_METHOD_NOT_USABLE = DiagnosticType.warning("JSC_ABSTRACT_SUPER_METHOD_NOT_USABLE", "Abstract super method {0} cannot be dereferenced");
    static final DiagnosticType FUNCTION_MASKS_VARIABLE = DiagnosticType.warning("JSC_FUNCTION_MASKS_VARIABLE", "function {0} masks variable (IE bug)");
    static final DiagnosticType MULTIPLE_VAR_DEF = DiagnosticType.warning("JSC_MULTIPLE_VAR_DEF", "declaration of multiple variables with shared type information");
    static final DiagnosticType ENUM_DUP = DiagnosticType.error("JSC_ENUM_DUP", "enum element {0} already defined");
    static final DiagnosticType INVALID_INTERFACE_MEMBER_DECLARATION = DiagnosticType.warning("JSC_INVALID_INTERFACE_MEMBER_DECLARATION", "interface members can only be empty property declarations, empty functions{0}");
    static final DiagnosticType INTERFACE_METHOD_NOT_EMPTY = DiagnosticType.warning("JSC_INTERFACE_METHOD_NOT_EMPTY", "interface member functions must have an empty body");
    static final DiagnosticType CONFLICTING_EXTENDED_TYPE = DiagnosticType.warning("JSC_CONFLICTING_EXTENDED_TYPE", "{1} cannot extend this type; {0}s can only extend {0}s");
    static final DiagnosticType ES5_CLASS_EXTENDING_ES6_CLASS = DiagnosticType.warning("JSC_ES5_CLASS_EXTENDING_ES6_CLASS", "ES5 class {0} cannot extend ES6 class {1}");
    static final DiagnosticType ES6_CLASS_EXTENDING_CLASS_WITH_GOOG_INHERITS = DiagnosticType.warning("JSC_ES6_CLASS_EXTENDING_CLASS_WITH_GOOG_INHERITS", "Do not use goog.inherits with ES6 classes. Use the ES6 `extends` keyword to inherit instead.");
    static final DiagnosticType INTERFACE_EXTENDS_LOOP = DiagnosticType.warning("JSC_INTERFACE_EXTENDS_LOOP", "extends loop involving {0}, loop: {1}");
    static final DiagnosticType CONFLICTING_IMPLEMENTED_TYPE = DiagnosticType.warning("JSC_CONFLICTING_IMPLEMENTED_TYPE", "{0} cannot implement this type; an interface can only extend, but not implement interfaces");
    static final DiagnosticType BAD_IMPLEMENTED_TYPE = DiagnosticType.warning("JSC_IMPLEMENTS_NON_INTERFACE", "can only implement interfaces");
    static final DiagnosticType HIDDEN_SUPERCLASS_PROPERTY = DiagnosticType.disabled("JSC_HIDDEN_SUPERCLASS_PROPERTY", "property {0} already defined on superclass {1}; use @override to override it");
    static final DiagnosticType HIDDEN_PROTOTYPAL_SUPERTYPE_PROPERTY = DiagnosticType.disabled("JSC_PROTOTYPAL_HIDDEN_SUPERCLASS_PROPERTY", "property {0} already defined on supertype {1}; use @override to override it");
    static final DiagnosticType HIDDEN_INTERFACE_PROPERTY = DiagnosticType.disabled("JSC_HIDDEN_INTERFACE_PROPERTY", "property {0} already defined on interface {1}; use @override to override it");
    static final DiagnosticType HIDDEN_SUPERCLASS_PROPERTY_MISMATCH = DiagnosticType.warning("JSC_HIDDEN_SUPERCLASS_PROPERTY_MISMATCH", "mismatch of the {0} property type and the type of the property it overrides from superclass {1}\noriginal: {2}\noverride: {3}");
    static final DiagnosticType HIDDEN_PROTOTYPAL_SUPERTYPE_PROPERTY_MISMATCH = DiagnosticType.warning("JSC_HIDDEN_PROTOTYPAL_SUPERTYPE_PROPERTY_MISMATCH", "mismatch of the {0} property type and the type of the property it overrides from supertype {1}\noriginal: {2}\noverride: {3}");
    static final DiagnosticType UNKNOWN_OVERRIDE = DiagnosticType.warning("JSC_UNKNOWN_OVERRIDE", "property {0} not defined on any superclass of {1}");
    static final DiagnosticType UNKNOWN_PROTOTYPAL_OVERRIDE = DiagnosticType.warning("JSC_UNKNOWN_PROTOTYPAL_OVERRIDE", "property {0} not defined on any supertype of {1}");
    static final DiagnosticType INTERFACE_METHOD_OVERRIDE = DiagnosticType.warning("JSC_INTERFACE_METHOD_OVERRIDE", "property {0} is already defined by the {1} extended interface");
    static final DiagnosticType UNKNOWN_EXPR_TYPE = DiagnosticType.warning("JSC_UNKNOWN_EXPR_TYPE", "could not determine the type of this expression");
    static final DiagnosticType UNRESOLVED_TYPE = DiagnosticType.warning("JSC_UNRESOLVED_TYPE", "could not resolve the name {0} to a type");
    static final DiagnosticType WRONG_ARGUMENT_COUNT = DiagnosticType.warning("JSC_WRONG_ARGUMENT_COUNT", "Function {0}: called with {1} argument(s). Function requires at least {2} argument(s){3}.");
    static final DiagnosticType ILLEGAL_IMPLICIT_CAST = DiagnosticType.warning("JSC_ILLEGAL_IMPLICIT_CAST", "Illegal annotation on {0}. @implicitCast may only be used in externs.");
    static final DiagnosticType INCOMPATIBLE_EXTENDED_PROPERTY_TYPE = DiagnosticType.warning("JSC_INCOMPATIBLE_EXTENDED_PROPERTY_TYPE", "Interface {0} has a property {1} with incompatible types in its super interfaces {2} and {3}");
    static final DiagnosticType EXPECTED_THIS_TYPE = DiagnosticType.warning("JSC_EXPECTED_THIS_TYPE", "\"{0}\" must be called with a \"this\" type");
    static final DiagnosticType IN_USED_WITH_STRUCT = DiagnosticType.warning("JSC_IN_USED_WITH_STRUCT", "Cannot use the IN operator with structs");
    static final DiagnosticType ILLEGAL_PROPERTY_CREATION = DiagnosticType.warning("JSC_ILLEGAL_PROPERTY_CREATION", "Cannot add a property to a struct instance after it is constructed. (If you already declared the property, make sure to give it a type.)");
    static final DiagnosticType ILLEGAL_OBJLIT_KEY = DiagnosticType.warning("JSC_ILLEGAL_OBJLIT_KEY", "Illegal key, the object literal is a {0}");
    static final DiagnosticType ILLEGAL_CLASS_KEY = DiagnosticType.warning("JSC_ILLEGAL_CLASS_KEY", "Illegal key, the class is a {0}");
    static final DiagnosticType NON_STRINGIFIABLE_OBJECT_KEY = DiagnosticType.warning("JSC_NON_STRINGIFIABLE_OBJECT_KEY", "Object type \"{0}\" contains non-stringifiable key and it may lead to an error. Please use ES6 Map instead or implement your own Map structure.");
    static final DiagnosticType ABSTRACT_METHOD_IN_CONCRETE_CLASS = DiagnosticType.warning("JSC_ABSTRACT_METHOD_IN_CONCRETE_CLASS", "Abstract methods can only appear in abstract classes. Please declare the class as @abstract");
    static final DiagnosticGroup ALL_DIAGNOSTICS = new DiagnosticGroup(DETERMINISTIC_TEST, INEXISTENT_ENUM_ELEMENT, INEXISTENT_PROPERTY, POSSIBLE_INEXISTENT_PROPERTY, INEXISTENT_PROPERTY_WITH_SUGGESTION, NOT_A_CONSTRUCTOR, INSTANTIATE_ABSTRACT_CLASS, BIT_OPERATION, NOT_CALLABLE, CONSTRUCTOR_NOT_CALLABLE, FUNCTION_MASKS_VARIABLE, MULTIPLE_VAR_DEF, ENUM_DUP, INVALID_INTERFACE_MEMBER_DECLARATION, INTERFACE_METHOD_NOT_EMPTY, CONFLICTING_EXTENDED_TYPE, CONFLICTING_IMPLEMENTED_TYPE, BAD_IMPLEMENTED_TYPE, HIDDEN_SUPERCLASS_PROPERTY_MISMATCH, HIDDEN_PROTOTYPAL_SUPERTYPE_PROPERTY_MISMATCH, UNKNOWN_OVERRIDE, UNKNOWN_PROTOTYPAL_OVERRIDE, INTERFACE_METHOD_OVERRIDE, UNRESOLVED_TYPE, WRONG_ARGUMENT_COUNT, ILLEGAL_IMPLICIT_CAST, INCOMPATIBLE_EXTENDED_PROPERTY_TYPE, EXPECTED_THIS_TYPE, IN_USED_WITH_STRUCT, ILLEGAL_CLASS_KEY, ILLEGAL_PROPERTY_CREATION, ILLEGAL_OBJLIT_KEY, NON_STRINGIFIABLE_OBJECT_KEY, ABSTRACT_METHOD_IN_CONCRETE_CLASS, ABSTRACT_SUPER_METHOD_NOT_USABLE, ES5_CLASS_EXTENDING_ES6_CLASS, RhinoErrorReporter.TYPE_PARSE_ERROR, RhinoErrorReporter.UNRECOGNIZED_TYPE_ERROR, TypedScopeCreator.UNKNOWN_LENDS, TypedScopeCreator.LENDS_ON_NON_OBJECT, TypedScopeCreator.CTOR_INITIALIZER, TypedScopeCreator.IFACE_INITIALIZER, FunctionTypeBuilder.THIS_TYPE_NON_OBJECT);
    private final AbstractCompiler compiler;
    private final TypeValidator validator;
    private final ReverseAbstractInterpreter reverseInterpreter;
    private final JSTypeRegistry typeRegistry;
    private TypedScope topScope;
    private TypedScopeCreator scopeCreator;
    private boolean reportUnknownTypes = false;
    private JSType.SubtypingMode subtypingMode = JSType.SubtypingMode.NORMAL;
    private boolean reportMissingProperties = true;
    private InferJSDocInfo inferJSDocInfo = null;
    private int typedCount = 0;
    private int nullCount = 0;
    private int unknownCount = 0;
    private boolean inExterns;

    public TypeCheck(AbstractCompiler compiler, ReverseAbstractInterpreter reverseInterpreter, JSTypeRegistry typeRegistry, TypedScope topScope, TypedScopeCreator scopeCreator) {
        this.compiler = compiler;
        this.validator = compiler.getTypeValidator();
        this.reverseInterpreter = reverseInterpreter;
        this.typeRegistry = typeRegistry;
        this.topScope = topScope;
        this.scopeCreator = scopeCreator;
        this.inferJSDocInfo = new InferJSDocInfo(compiler);
    }

    public TypeCheck(AbstractCompiler compiler, ReverseAbstractInterpreter reverseInterpreter, JSTypeRegistry typeRegistry) {
        this(compiler, reverseInterpreter, typeRegistry, null, null);
    }

    TypeCheck reportMissingProperties(boolean report) {
        this.reportMissingProperties = report;
        return this;
    }

    TypeCheck reportUnknownTypes(boolean report) {
        this.reportUnknownTypes = report;
        return this;
    }

    @Override
    public void process(Node externsRoot, Node jsRoot) {
        Preconditions.checkNotNull(this.scopeCreator);
        Preconditions.checkNotNull(this.topScope);
        Node externsAndJs = jsRoot.getParent();
        Preconditions.checkState(externsAndJs != null);
        Preconditions.checkState(externsRoot == null || externsAndJs.hasChild(externsRoot));
        if (externsRoot != null) {
            this.check(externsRoot, true);
        }
        this.check(jsRoot, false);
    }

    public TypedScope processForTesting(Node externsRoot, Node jsRoot) {
        Preconditions.checkState(this.scopeCreator == null);
        Preconditions.checkState(this.topScope == null);
        Preconditions.checkArgument(externsRoot == null || externsRoot.isRoot(), externsRoot);
        Preconditions.checkArgument(jsRoot.isRoot(), jsRoot);
        Preconditions.checkState(jsRoot.getParent() != null && jsRoot.getParent().isRoot(), jsRoot.getParent());
        Node externsAndJsRoot = jsRoot.getParent();
        Preconditions.checkState(externsRoot == null || externsRoot.getNext() == jsRoot, "externs root must be the preceding sibling of the js root");
        this.scopeCreator = new TypedScopeCreator(this.compiler);
        this.topScope = this.scopeCreator.createScope(externsAndJsRoot, (AbstractScope)null);
        TypeInferencePass inference = new TypeInferencePass(this.compiler, this.reverseInterpreter, this.topScope, this.scopeCreator);
        inference.process(externsRoot, jsRoot);
        this.process(externsRoot, jsRoot);
        return this.topScope;
    }

    void check(Node node, boolean externs) {
        Preconditions.checkNotNull(node);
        NodeTraversal t = new NodeTraversal(this.compiler, this, this.scopeCreator);
        this.inExterns = externs;
        t.traverseWithScope(node, this.topScope);
        if (externs) {
            this.inferJSDocInfo.process(node, null);
        } else {
            this.inferJSDocInfo.process(null, node);
        }
    }

    private void report(Node n, DiagnosticType diagnosticType, String ... arguments) {
        this.compiler.report(JSError.make(n, diagnosticType, arguments));
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        if (n.isScript()) {
            String filename = n.getSourceFileName();
            this.subtypingMode = filename != null && filename.endsWith(".java.js") ? JSType.SubtypingMode.IGNORE_NULL_UNDEFINED : JSType.SubtypingMode.NORMAL;
            this.validator.setSubtypingMode(this.subtypingMode);
        }
        switch (n.getToken()) {
            case FUNCTION: {
                TypedScope outerScope = t.getTypedScope();
                TypedVar var = outerScope.getVar(n.getFirstChild().getString());
                if (var == null || !((TypedScope)var.getScope()).hasSameContainerScope(outerScope) || var.getType() instanceof FunctionType || TypeValidator.hasDuplicateDeclarationSuppression(this.compiler, var.getNameNode())) break;
                this.report(n, FUNCTION_MASKS_VARIABLE, var.getName());
                break;
            }
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        boolean typeable = true;
        switch (n.getToken()) {
            case CAST: {
                Node expr = n.getFirstChild();
                JSType exprType = this.getJSType(expr);
                JSType castType = this.getJSType(n);
                if (!expr.isObjectLit()) {
                    this.validator.expectCanCast(n, castType, exprType);
                }
                this.ensureTyped(n, castType);
                expr.setJSTypeBeforeCast(exprType);
                if (!castType.restrictByNotNullOrUndefined().isSubtypeOf(exprType) && !expr.isObjectLit()) break;
                expr.setJSType(castType);
                break;
            }
            case NAME: {
                typeable = this.visitName(t, n, parent);
                break;
            }
            case COMMA: {
                this.ensureTyped(n, this.getJSType(n.getLastChild()));
                break;
            }
            case THIS: {
                this.ensureTyped(n, t.getTypedScope().getTypeOfThis());
                break;
            }
            case NULL: {
                this.ensureTyped(n, JSTypeNative.NULL_TYPE);
                break;
            }
            case NUMBER: {
                this.ensureTyped(n, JSTypeNative.NUMBER_TYPE);
                break;
            }
            case GETTER_DEF: 
            case SETTER_DEF: {
                break;
            }
            case ARRAYLIT: {
                this.ensureTyped(n, JSTypeNative.ARRAY_TYPE);
                break;
            }
            case REGEXP: {
                this.ensureTyped(n, JSTypeNative.REGEXP_TYPE);
                break;
            }
            case GETPROP: {
                this.visitGetProp(t, n);
                typeable = !parent.isAssign() || parent.getFirstChild() != n;
                break;
            }
            case GETELEM: {
                this.visitGetElem(n);
                typeable = false;
                break;
            }
            case VAR: 
            case LET: 
            case CONST: {
                this.visitVar(t, n);
                typeable = false;
                break;
            }
            case NEW: {
                this.visitNew(n);
                break;
            }
            case CALL: {
                this.visitCall(t, n);
                typeable = !parent.isExprResult();
                break;
            }
            case RETURN: {
                this.visitReturn(t, n);
                typeable = false;
                break;
            }
            case YIELD: {
                this.visitYield(t, n);
                break;
            }
            case SUPER: 
            case NEW_TARGET: 
            case AWAIT: {
                this.ensureTyped(n);
                break;
            }
            case DEC: 
            case INC: {
                Node left = n.getFirstChild();
                this.checkPropCreation(left);
                this.validator.expectNumber(left, this.getJSType(left), "increment/decrement");
                this.ensureTyped(n, JSTypeNative.NUMBER_TYPE);
                break;
            }
            case VOID: {
                this.ensureTyped(n, JSTypeNative.VOID_TYPE);
                break;
            }
            case STRING: 
            case TYPEOF: 
            case TEMPLATELIT: 
            case TEMPLATELIT_STRING: {
                this.ensureTyped(n, JSTypeNative.STRING_TYPE);
                break;
            }
            case TAGGED_TEMPLATELIT: {
                this.visitTaggedTemplateLit(n);
                this.ensureTyped(n);
                break;
            }
            case BITNOT: {
                JSType childType = this.getJSType(n.getFirstChild());
                if (!childType.matchesNumberContext()) {
                    this.report(n, BIT_OPERATION, NodeUtil.opToStr(n.getToken()), childType.toString());
                } else {
                    this.validator.expectNumberStrict(n, childType, "bitwise NOT");
                }
                this.ensureTyped(n, JSTypeNative.NUMBER_TYPE);
                break;
            }
            case POS: 
            case NEG: {
                Node left = n.getFirstChild();
                if (n.getToken() == Token.NEG) {
                    this.validator.expectNumber(left, this.getJSType(left), "sign operator");
                }
                this.ensureTyped(n, JSTypeNative.NUMBER_TYPE);
                break;
            }
            case EQ: 
            case NE: 
            case SHEQ: 
            case SHNE: {
                Node left = n.getFirstChild();
                Node right = n.getLastChild();
                if (left.isTypeOf()) {
                    if (right.isString()) {
                        this.checkTypeofString(right, right.getString());
                    }
                } else if (right.isTypeOf() && left.isString()) {
                    this.checkTypeofString(left, left.getString());
                }
                JSType leftType = this.getJSType(left);
                JSType rightType = this.getJSType(right);
                JSType leftTypeRestricted = leftType.restrictByNotNullOrUndefined();
                JSType rightTypeRestricted = rightType.restrictByNotNullOrUndefined();
                TernaryValue result = TernaryValue.UNKNOWN;
                if (n.getToken() == Token.EQ || n.isNE()) {
                    result = leftTypeRestricted.testForEquality(rightTypeRestricted);
                    if (n.isNE()) {
                        result = result.not();
                    }
                } else if (!leftTypeRestricted.canTestForShallowEqualityWith(rightTypeRestricted)) {
                    TernaryValue ternaryValue = result = n.getToken() == Token.SHEQ ? TernaryValue.FALSE : TernaryValue.TRUE;
                }
                if (result != TernaryValue.UNKNOWN) {
                    this.report(n, DETERMINISTIC_TEST, leftType.toString(), rightType.toString(), result.toString());
                }
                this.ensureTyped(n, JSTypeNative.BOOLEAN_TYPE);
                break;
            }
            case LT: 
            case LE: 
            case GT: 
            case GE: {
                Node leftSide = n.getFirstChild();
                Node rightSide = n.getLastChild();
                JSType leftType = this.getJSType(leftSide);
                JSType rightType = this.getJSType(rightSide);
                if (rightType.isUnknownType()) {
                    this.validator.expectStringOrNumber(leftSide, leftType, "left side of comparison");
                } else if (leftType.isUnknownType()) {
                    this.validator.expectStringOrNumber(rightSide, rightType, "right side of comparison");
                } else if (rightType.isNumber()) {
                    this.validator.expectNumber(leftSide, leftType, "left side of numeric comparison");
                } else if (leftType.isNumber()) {
                    this.validator.expectNumber(rightSide, rightType, "right side of numeric comparison");
                } else {
                    String errorMsg = "expected matching types in comparison";
                    this.validator.expectMatchingTypesStrict(n, leftType, rightType, errorMsg);
                    if (!leftType.matchesNumberContext() || !rightType.matchesNumberContext()) {
                        String message = "left side of comparison";
                        this.validator.expectString(leftSide, leftType, message);
                        this.validator.expectNotNullOrUndefined(t, leftSide, leftType, message, this.getNativeType(JSTypeNative.STRING_TYPE));
                        message = "right side of comparison";
                        this.validator.expectString(rightSide, rightType, message);
                        this.validator.expectNotNullOrUndefined(t, rightSide, rightType, message, this.getNativeType(JSTypeNative.STRING_TYPE));
                    }
                }
                this.ensureTyped(n, JSTypeNative.BOOLEAN_TYPE);
                break;
            }
            case IN: {
                Node left = n.getFirstChild();
                Node right = n.getLastChild();
                JSType rightType = this.getJSType(right);
                this.validator.expectStringOrSymbol(left, this.getJSType(left), "left side of 'in'");
                this.validator.expectObject(n, rightType, "'in' requires an object");
                if (rightType.isStruct()) {
                    this.report(right, IN_USED_WITH_STRUCT, new String[0]);
                }
                this.ensureTyped(n, JSTypeNative.BOOLEAN_TYPE);
                break;
            }
            case INSTANCEOF: {
                Node left = n.getFirstChild();
                Node right = n.getLastChild();
                JSType rightType = this.getJSType(right).restrictByNotNullOrUndefined();
                this.validator.expectAnyObject(left, this.getJSType(left), "deterministic instanceof yields false");
                this.validator.expectActualObject(right, rightType, "instanceof requires an object");
                this.ensureTyped(n, JSTypeNative.BOOLEAN_TYPE);
                break;
            }
            case ASSIGN: {
                this.visitAssign(t, n);
                typeable = false;
                break;
            }
            case ASSIGN_LSH: 
            case ASSIGN_RSH: 
            case ASSIGN_URSH: 
            case ASSIGN_DIV: 
            case ASSIGN_MOD: 
            case ASSIGN_BITOR: 
            case ASSIGN_BITXOR: 
            case ASSIGN_BITAND: 
            case ASSIGN_SUB: 
            case ASSIGN_ADD: 
            case ASSIGN_MUL: 
            case ASSIGN_EXPONENT: {
                this.checkPropCreation(n.getFirstChild());
            }
            case LSH: 
            case RSH: 
            case URSH: 
            case DIV: 
            case MOD: 
            case BITOR: 
            case BITXOR: 
            case BITAND: 
            case SUB: 
            case ADD: 
            case MUL: 
            case EXPONENT: {
                this.visitBinaryOperator(n.getToken(), n);
                break;
            }
            case TRUE: 
            case FALSE: 
            case NOT: 
            case DELPROP: {
                this.ensureTyped(n, JSTypeNative.BOOLEAN_TYPE);
                break;
            }
            case CASE: {
                JSType switchType = this.getJSType(parent.getFirstChild());
                JSType caseType = this.getJSType(n.getFirstChild());
                this.validator.expectSwitchMatchesCase(n, switchType, caseType);
                typeable = false;
                break;
            }
            case WITH: {
                Node child = n.getFirstChild();
                JSType childType = this.getJSType(child);
                this.validator.expectObject(child, childType, "with requires an object");
                typeable = false;
                break;
            }
            case FUNCTION: {
                this.visitFunction(n);
                break;
            }
            case CLASS: {
                this.visitClass(n);
                break;
            }
            case PARAM_LIST: 
            case STRING_KEY: 
            case MEMBER_FUNCTION_DEF: 
            case COMPUTED_PROP: 
            case LABEL: 
            case LABEL_NAME: 
            case SWITCH: 
            case BREAK: 
            case CATCH: 
            case TRY: 
            case SCRIPT: 
            case MODULE_BODY: 
            case EXPORT: 
            case EXPORT_SPEC: 
            case EXPORT_SPECS: 
            case IMPORT: 
            case IMPORT_SPEC: 
            case IMPORT_SPECS: 
            case IMPORT_STAR: 
            case EXPR_RESULT: 
            case BLOCK: 
            case ROOT: 
            case EMPTY: 
            case DEFAULT_CASE: 
            case CONTINUE: 
            case DEBUGGER: 
            case THROW: 
            case DO: 
            case IF: 
            case WHILE: 
            case FOR: 
            case TEMPLATELIT_SUB: 
            case REST: 
            case DESTRUCTURING_LHS: {
                typeable = false;
                break;
            }
            case ARRAY_PATTERN: {
                this.ensureTyped(n);
                this.validator.expectAutoboxesToIterable(n, this.getJSType(n), "array pattern destructuring requires an Iterable");
                break;
            }
            case OBJECT_PATTERN: {
                this.visitObjectPattern(n);
                break;
            }
            case DEFAULT_VALUE: {
                this.checkCanAssignToWithScope(t, n, n.getFirstChild(), this.getJSType(n.getSecondChild()), null, "default value has wrong type");
                Node lhs = n.getFirstChild();
                Node rhs = n.getSecondChild();
                if (lhs.isArrayPattern()) {
                    this.validator.expectAutoboxesToIterable(rhs, this.getJSType(rhs), "array pattern destructuring requires an Iterable");
                } else if (lhs.isObjectPattern()) {
                    this.validator.expectObject(rhs, this.getJSType(rhs), "cannot destructure a 'null' or 'undefined' default value");
                }
                typeable = false;
                break;
            }
            case CLASS_MEMBERS: {
                ObjectType typ = parent.getJSType().toMaybeFunctionType().getInstanceType();
                for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
                    this.visitObjectOrClassLiteralKey(child, n.getParent(), typ);
                }
                typeable = false;
                break;
            }
            case FOR_IN: {
                Node obj = n.getSecondChild();
                if (this.getJSType(obj).isStruct()) {
                    this.report(obj, IN_USED_WITH_STRUCT, new String[0]);
                }
                typeable = false;
                break;
            }
            case FOR_OF: 
            case FOR_AWAIT_OF: {
                this.ensureTyped(n.getSecondChild());
                typeable = false;
                break;
            }
            case AND: 
            case HOOK: 
            case OBJECTLIT: 
            case OR: {
                if (n.getJSType() != null) {
                    this.ensureTyped(n);
                } else if (n.isObjectLit() && parent.getJSType() instanceof EnumType) {
                    this.ensureTyped(n, parent.getJSType());
                } else {
                    this.ensureTyped(n);
                }
                if (!n.isObjectLit()) break;
                JSType typ = this.getJSType(n);
                for (Node key : n.children()) {
                    this.visitObjectOrClassLiteralKey(key, n, typ);
                }
                break;
            }
            case SPREAD: {
                this.checkSpread(n);
                typeable = false;
                break;
            }
            default: {
                this.report(n, UNEXPECTED_TOKEN, n.getToken().toString());
                this.ensureTyped(n);
            }
        }
        if (NodeUtil.isBlocklessArrowFunctionResult(n)) {
            this.visitImplicitReturnExpression(t, n);
        }
        if ((n.getParent().isForOf() || n.getParent().isForAwaitOf()) && n.getParent().getFirstChild() == n) {
            this.checkForOfTypes(t, n.getParent());
        }
        boolean bl = typeable = typeable && !this.inExterns;
        if (typeable) {
            this.doPercentTypedAccounting(n);
        }
        this.checkJsdocInfoContainsObjectWithBadKey(n);
    }

    private void checkSpread(Node spreadNode) {
        Node target = spreadNode.getOnlyChild();
        this.ensureTyped(target);
        JSType targetType = this.getJSType(target);
        switch (spreadNode.getParent().getToken()) {
            case OBJECTLIT: {
                break;
            }
            case ARRAYLIT: 
            case NEW: 
            case CALL: {
                this.validator.expectAutoboxesToIterable(target, targetType, "Spread operator only applies to Iterable types");
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected parent of SPREAD: " + spreadNode.getParent().toStringTree());
            }
        }
    }

    private void checkTypeofString(Node n, String s) {
        if (!(s.equals("number") || s.equals("string") || s.equals("boolean") || s.equals("undefined") || s.equals("function") || s.equals("object") || s.equals("symbol") || s.equals("unknown"))) {
            this.validator.expectValidTypeofName(n, s);
        }
    }

    private void doPercentTypedAccounting(Node n) {
        JSType type = n.getJSType();
        if (type == null) {
            ++this.nullCount;
        } else if (type.isUnknownType()) {
            if (this.reportUnknownTypes) {
                this.compiler.report(JSError.make(n, UNKNOWN_EXPR_TYPE, new String[0]));
            }
            ++this.unknownCount;
        } else {
            ++this.typedCount;
        }
    }

    private void visitAssign(NodeTraversal t, Node assign) {
        JSDocInfo info = assign.getJSDocInfo();
        Node lvalue = assign.getFirstChild();
        Node rvalue = assign.getLastChild();
        JSType rightType = this.getJSType(rvalue);
        this.checkCanAssignToWithScope(t, assign, lvalue, rightType, info, "assignment");
        this.ensureTyped(assign, rightType);
    }

    private void checkCanAssignToWithScope(NodeTraversal t, Node nodeToWarn, Node lvalue, JSType rightType, JSDocInfo info, String msg) {
        if (lvalue.isDestructuringPattern()) {
            this.checkDestructuringAssignment(t, nodeToWarn, lvalue, rightType, msg);
        } else {
            this.checkCanAssignToNameGetpropOrGetelem(t, nodeToWarn, lvalue, rightType, info, msg);
        }
    }

    private void checkDestructuringAssignment(NodeTraversal t, Node nodeToWarn, Node pattern, JSType rightType, String msg) {
        for (DestructuredTarget target : DestructuredTarget.createAllNonEmptyTargetsInPattern(this.typeRegistry, rightType, pattern)) {
            this.checkCanAssignToWithScope(t, nodeToWarn, target.getNode(), target.inferType(), null, msg);
        }
    }

    private void checkCanAssignToNameGetpropOrGetelem(NodeTraversal t, Node nodeToWarn, Node lvalue, JSType rightType, JSDocInfo info, String msg) {
        TypedVar var;
        Preconditions.checkArgument(lvalue.isName() || lvalue.isGetProp() || lvalue.isGetElem() || lvalue.isCast(), lvalue);
        if (lvalue.isGetProp()) {
            JSType jsType;
            Node object = lvalue.getFirstChild();
            JSType objectJsType = this.getJSType(object);
            Node property = lvalue.getLastChild();
            String pname = property.getString();
            if (object.isGetProp() && (jsType = this.getJSType(object.getFirstChild())).isInterface() && object.getLastChild().getString().equals("prototype")) {
                this.visitInterfacePropertyAssignment(object, lvalue);
            }
            this.checkEnumAlias(t, info, rightType, nodeToWarn);
            this.checkPropCreation(lvalue);
            if (pname.equals("prototype")) {
                this.validator.expectCanAssignToPrototype(objectJsType, nodeToWarn, rightType);
                return;
            }
            ObjectType objectCastType = ObjectType.cast(objectJsType.restrictByNotNullOrUndefined());
            JSType expectedPropertyType = this.getPropertyTypeIfDeclared(objectCastType, pname);
            this.checkPropertyInheritanceOnGetpropAssign(nodeToWarn, object, pname, info, expectedPropertyType);
            if (!expectedPropertyType.isUnknownType()) {
                if (!TypeCheck.propertyIsImplicitCast(objectCastType, pname)) {
                    this.validator.expectCanAssignToPropertyOf(nodeToWarn, rightType, expectedPropertyType, object, pname);
                }
                return;
            }
        }
        JSType leftType = this.getJSType(lvalue);
        if (lvalue.isQualifiedName() && (var = t.getTypedScope().getVar(lvalue.getQualifiedName())) != null) {
            if (var.isTypeInferred()) {
                return;
            }
            if (NodeUtil.getRootOfQualifiedName(lvalue).isThis() && t.getTypedScope() != var.getScope()) {
                return;
            }
            if (var.getType() != null) {
                leftType = var.getType();
            }
        }
        this.validator.expectCanAssignTo(nodeToWarn, rightType, leftType, msg);
    }

    private void checkPropCreation(Node lvalue) {
        Node prop;
        String propName;
        JSTypeRegistry.PropDefinitionKind kind;
        JSType objType;
        if (lvalue.isGetProp() && !(objType = this.getJSType(lvalue.getFirstChild())).isEmptyType() && !objType.isUnknownType() && !(kind = this.typeRegistry.canPropertyBeDefined(objType, propName = (prop = lvalue.getLastChild()).getString())).equals((Object)JSTypeRegistry.PropDefinitionKind.KNOWN)) {
            if (objType.isStruct()) {
                this.report(prop, ILLEGAL_PROPERTY_CREATION, new String[0]);
            } else {
                if (!objType.isNoType() && !objType.isUnknownType() && objType.isSubtypeOf(this.getNativeType(JSTypeNative.NULL_VOID))) {
                    return;
                }
                this.reportMissingProperty(lvalue.getFirstChild(), objType, lvalue.getSecondChild(), kind, true);
            }
        }
    }

    private void checkPropertyInheritanceOnGetpropAssign(Node assign, Node object, String property, JSDocInfo info, JSType propertyType) {
        if (object.isGetProp() && object.getSecondChild().getString().equals("prototype")) {
            Node preObject = object.getFirstChild();
            FunctionType ctorType = this.getJSType(preObject).toMaybeFunctionType();
            if (ctorType == null || !ctorType.hasInstanceType()) {
                return;
            }
            this.checkDeclaredPropertyAgainstNominalInheritance(assign, ctorType, property, info, propertyType);
            this.checkAbstractMethodInConcreteClass(assign, ctorType, info);
        } else {
            FunctionType ctorType = this.getJSType(object).toMaybeFunctionType();
            if (ctorType == null || !ctorType.hasInstanceType()) {
                return;
            }
            this.checkDeclaredPropertyAgainstPrototypalInheritance(assign, ctorType, property, info, propertyType);
        }
    }

    private void checkPropertyInheritanceOnPrototypeLitKey(Node key, String propertyName, ObjectType type) {
        this.checkPropertyInheritance(key, propertyName, type.getOwnerFunction(), type);
    }

    private void checkPropertyInheritanceOnClassMember(Node key, String propertyName, FunctionType ctorType) {
        if (key.isStaticMember()) {
            this.checkDeclaredPropertyAgainstPrototypalInheritance(key, ctorType, propertyName, key.getJSDocInfo(), ctorType.getPropertyType(propertyName));
        } else {
            this.checkPropertyInheritance(key, propertyName, ctorType, ctorType.getInstanceType());
        }
    }

    private void checkPropertyInheritance(Node key, String propertyName, FunctionType ctorType, ObjectType type) {
        if (ctorType == null || !ctorType.hasInstanceType()) {
            return;
        }
        this.checkDeclaredPropertyAgainstNominalInheritance(key.getFirstChild(), ctorType, propertyName, key.getJSDocInfo(), type.getPropertyType(propertyName));
        this.checkAbstractMethodInConcreteClass(key, ctorType, key.getJSDocInfo());
    }

    private void visitObjectPattern(Node pattern) {
        JSType patternType = this.getJSType(pattern);
        this.validator.expectObject(pattern, patternType, "cannot destructure 'null' or 'undefined'");
        for (Node child : pattern.children()) {
            DestructuredTarget target = DestructuredTarget.createTarget(this.typeRegistry, patternType, child);
            if (target.hasComputedProperty()) {
                Node computedProperty = target.getComputedProperty();
                this.validator.expectIndexMatch(computedProperty, patternType, this.getJSType(computedProperty.getFirstChild()));
                continue;
            }
            if (!target.hasStringKey()) continue;
            Node stringKey = target.getStringKey();
            if (!stringKey.isQuotedString()) {
                if (patternType.isDict()) {
                    this.report(stringKey, TypeValidator.ILLEGAL_PROPERTY_ACCESS, "unquoted", "dict");
                }
                this.checkPropertyAccessForDestructuring(pattern, patternType, stringKey, this.getJSType(target.getNode()));
                continue;
            }
            if (!patternType.isStruct()) continue;
            this.report(stringKey, TypeValidator.ILLEGAL_PROPERTY_ACCESS, "quoted", "struct");
        }
        this.ensureTyped(pattern);
    }

    private void visitObjectOrClassLiteralKey(Node key, Node owner, JSType ownerType) {
        boolean valid;
        JSType keyType;
        JSType allowedValueType;
        if (key.isEmpty()) {
            return;
        }
        if (owner.isFromExterns()) {
            this.ensureTyped(key);
            return;
        }
        if (key.isComputedProp()) {
            this.validator.expectIndexMatch(key, ownerType, this.getJSType(key.getFirstChild()));
            return;
        }
        if (key.isQuotedString()) {
            if (ownerType.isStruct()) {
                this.report(key, owner.isClass() ? ILLEGAL_CLASS_KEY : ILLEGAL_OBJLIT_KEY, "struct");
            }
        } else if (ownerType.isDict() && !NodeUtil.isEs6ConstructorMemberFunctionDef(key)) {
            this.report(key, owner.isClass() ? ILLEGAL_CLASS_KEY : ILLEGAL_OBJLIT_KEY, "dict");
        }
        if (key.isSpread()) {
            return;
        }
        Node rvalue = key.getFirstChild();
        JSType rightType = TypeCheck.getObjectLitKeyTypeFromValueType(key, this.getJSType(rvalue));
        if (rightType == null) {
            rightType = this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
        if ((allowedValueType = (keyType = this.getJSType(key))).isEnumElementType()) {
            allowedValueType = allowedValueType.toMaybeEnumElementType().getPrimitiveType();
        }
        if (valid = this.validator.expectCanAssignToPropertyOf(key, rightType, allowedValueType, owner, NodeUtil.getObjectLitKeyName(key))) {
            this.ensureTyped(key, rightType);
        } else {
            this.ensureTyped(key);
        }
        JSType objlitType = this.getJSType(owner);
        ObjectType type = ObjectType.cast(objlitType.restrictByNotNullOrUndefined());
        if (type != null) {
            String property = NodeUtil.getObjectLitKeyName(key);
            if (owner.isClass()) {
                this.checkPropertyInheritanceOnClassMember(key, property, type.toMaybeFunctionType());
            } else {
                this.checkPropertyInheritanceOnPrototypeLitKey(key, property, type);
            }
            if (type.hasProperty(property) && !type.isPropertyTypeInferred(property) && !TypeCheck.propertyIsImplicitCast(type, property)) {
                this.validator.expectCanAssignToPropertyOf(key, keyType, type.getPropertyType(property), owner, property);
            }
        }
    }

    private static boolean propertyIsImplicitCast(ObjectType type, String prop) {
        while (type != null) {
            JSDocInfo docInfo = type.getOwnPropertyJSDocInfo(prop);
            if (docInfo != null && docInfo.isImplicitCast()) {
                return true;
            }
            type = type.getImplicitPrototype();
        }
        return false;
    }

    private void checkDeclaredPropertyAgainstNominalInheritance(Node n, FunctionType ctorType, String propertyName, @Nullable JSDocInfo info, JSType propertyType) {
        boolean declaredLocally;
        if (TypeCheck.hasUnknownOrEmptySupertype(ctorType)) {
            return;
        }
        FunctionType superCtor = ctorType.getSuperClassConstructor();
        ObjectType superClass = null;
        boolean superClassHasProperty = false;
        boolean superClassHasDeclaredProperty = false;
        if (superCtor != null) {
            Property.OwnedProperty propSlot = superCtor.getInstanceType().findClosestDefinition(propertyName);
            boolean bl = superClassHasProperty = propSlot != null && !propSlot.isOwnedByInterface();
            if (superClassHasProperty) {
                superClass = propSlot.getOwnerInstanceType();
                superClassHasDeclaredProperty = !propSlot.getValue().isTypeInferred();
            }
        }
        boolean superInterfaceHasProperty = false;
        boolean superInterfaceHasDeclaredProperty = false;
        if (ctorType.isInterface()) {
            for (ObjectType interfaceType : ctorType.getExtendedInterfaces()) {
                superInterfaceHasProperty = superInterfaceHasProperty || interfaceType.hasProperty(propertyName);
                superInterfaceHasDeclaredProperty = superInterfaceHasDeclaredProperty || interfaceType.isPropertyTypeDeclared(propertyName);
            }
        }
        boolean declaredOverride = TypeCheck.declaresOverride(info);
        boolean foundInterfaceProperty = false;
        for (ObjectType implementedInterface : ctorType.getAllImplementedInterfaces()) {
            if (implementedInterface.isUnknownType() || implementedInterface.isEmptyType()) continue;
            Preconditions.checkState(implementedInterface.isInstanceType(), implementedInterface);
            Property.OwnedProperty propSlot = implementedInterface.findClosestDefinition(propertyName);
            boolean interfaceHasProperty = propSlot != null;
            boolean bl = foundInterfaceProperty = foundInterfaceProperty || interfaceHasProperty;
            if (declaredOverride || !interfaceHasProperty || "__proto__".equals(propertyName) || "constructor".equals(propertyName)) continue;
            this.compiler.report(JSError.make(n, HIDDEN_INTERFACE_PROPERTY, propertyName, propSlot.getOwnerInstanceType().getReferenceName()));
        }
        if (!(declaredOverride || superClassHasProperty || superInterfaceHasProperty)) {
            return;
        }
        boolean bl = declaredLocally = ctorType.isConstructor() && (ctorType.getPrototype().hasOwnProperty(propertyName) || ctorType.getInstanceType().hasOwnProperty(propertyName));
        if (!declaredOverride && superClassHasDeclaredProperty && declaredLocally && !"__proto__".equals(propertyName) && !"constructor".equals(propertyName)) {
            this.compiler.report(JSError.make(n, HIDDEN_SUPERCLASS_PROPERTY, propertyName, superClass.getReferenceName()));
        }
        if (superClassHasDeclaredProperty) {
            JSType superClassPropType = superClass.getPropertyType(propertyName);
            TemplateTypeMap ctorTypeMap = ctorType.getTypeOfThis().getTemplateTypeMap();
            if (!ctorTypeMap.isEmpty()) {
                superClassPropType = superClassPropType.visit(new TemplateTypeMapReplacer(this.typeRegistry, ctorTypeMap));
            }
            if (!propertyType.isSubtype(superClassPropType, this.subtypingMode)) {
                this.compiler.report(JSError.make(n, HIDDEN_SUPERCLASS_PROPERTY_MISMATCH, propertyName, superClass.getReferenceName(), superClassPropType.toString(), propertyType.toString()));
            }
        } else if (superInterfaceHasDeclaredProperty) {
            for (ObjectType interfaceType : ctorType.getExtendedInterfaces()) {
                JSType superPropertyType;
                Property.OwnedProperty propSlot = interfaceType.findClosestDefinition(propertyName);
                if (propSlot == null || propertyType.isSubtype(superPropertyType = propSlot.getValue().getType(), this.subtypingMode)) continue;
                this.compiler.report(JSError.make(n, HIDDEN_SUPERCLASS_PROPERTY_MISMATCH, propertyName, propSlot.getOwnerInstanceType().getReferenceName(), superPropertyType.toString(), propertyType.toString()));
            }
        } else if (!(foundInterfaceProperty || superClassHasProperty || superInterfaceHasProperty)) {
            this.compiler.report(JSError.make(n, UNKNOWN_OVERRIDE, propertyName, ctorType.getInstanceType().getReferenceName()));
        }
    }

    private void checkDeclaredPropertyAgainstPrototypalInheritance(Node n, ObjectType receiverType, String propertyName, @Nullable JSDocInfo info, JSType propertyType) {
        boolean declaredOverride = TypeCheck.declaresOverride(info);
        ObjectType supertypeWithProperty = Streams.stream(receiverType.getImplicitPrototypeChain()).filter(type -> type.hasOwnProperty(propertyName)).findFirst().orElse(null);
        if (supertypeWithProperty == null) {
            if (declaredOverride) {
                this.compiler.report(JSError.make(n, UNKNOWN_PROTOTYPAL_OVERRIDE, propertyName, receiverType.toString()));
            }
        } else {
            JSType overriddenPropertyType;
            if (!declaredOverride) {
                this.compiler.report(JSError.make(n, HIDDEN_PROTOTYPAL_SUPERTYPE_PROPERTY, propertyName, supertypeWithProperty.toString()));
            }
            if (!propertyType.isSubtypeOf(overriddenPropertyType = supertypeWithProperty.getPropertyType(propertyName))) {
                this.compiler.report(JSError.make(n, HIDDEN_PROTOTYPAL_SUPERTYPE_PROPERTY_MISMATCH, propertyName, supertypeWithProperty.toString(), overriddenPropertyType.toString(), propertyType.toString()));
            }
        }
    }

    private void checkAbstractMethodInConcreteClass(Node n, FunctionType ctorType, JSDocInfo info) {
        if (info == null || !info.isAbstract()) {
            return;
        }
        if (ctorType.isConstructor() && !ctorType.isAbstract()) {
            this.report(n, ABSTRACT_METHOD_IN_CONCRETE_CLASS, new String[0]);
        }
    }

    private static boolean hasUnknownOrEmptySupertype(FunctionType ctor) {
        Preconditions.checkArgument(ctor.isConstructor() || ctor.isInterface());
        Preconditions.checkArgument(!ctor.isUnknownType());
        ObjectType maybeSuperInstanceType;
        while ((maybeSuperInstanceType = ctor.getPrototype().getImplicitPrototype()) != null) {
            if (maybeSuperInstanceType.isUnknownType() || maybeSuperInstanceType.isEmptyType()) {
                return true;
            }
            ctor = maybeSuperInstanceType.getConstructor();
            if (ctor == null) {
                return false;
            }
            Preconditions.checkState(ctor.isConstructor() || ctor.isInterface());
        }
        return false;
    }

    static JSType getObjectLitKeyTypeFromValueType(Node key, JSType valueType) {
        if (valueType != null) {
            switch (key.getToken()) {
                case GETTER_DEF: {
                    if (valueType.isFunctionType()) {
                        FunctionType fntype = valueType.toMaybeFunctionType();
                        valueType = fntype.getReturnType();
                        break;
                    }
                    return null;
                }
                case SETTER_DEF: {
                    if (valueType.isFunctionType()) {
                        FunctionType fntype = valueType.toMaybeFunctionType();
                        Node param = fntype.getParametersNode().getFirstChild();
                        valueType = param.getJSType();
                        break;
                    }
                    return null;
                }
            }
        }
        return valueType;
    }

    private void visitInterfacePropertyAssignment(Node object, Node lvalue) {
        if (!lvalue.getParent().isAssign()) {
            this.reportInvalidInterfaceMemberDeclaration(object);
            return;
        }
        Node assign = lvalue.getParent();
        Node rvalue = assign.getSecondChild();
        JSType rvalueType = this.getJSType(rvalue);
        if (!rvalueType.isFunctionType()) {
            this.reportInvalidInterfaceMemberDeclaration(object);
        }
        if (rvalue.isFunction() && !NodeUtil.isEmptyBlock(NodeUtil.getFunctionBody(rvalue))) {
            String abstractMethodName = this.compiler.getCodingConvention().getAbstractMethodName();
            this.compiler.report(JSError.make(object, INTERFACE_METHOD_NOT_EMPTY, abstractMethodName));
        }
    }

    private void reportInvalidInterfaceMemberDeclaration(Node interfaceNode) {
        String abstractMethodName = this.compiler.getCodingConvention().getAbstractMethodName();
        String abstractMethodMessage = abstractMethodName != null ? ", or " + abstractMethodName : "";
        this.compiler.report(JSError.make(interfaceNode, INVALID_INTERFACE_MEMBER_DECLARATION, abstractMethodMessage));
    }

    boolean visitName(NodeTraversal t, Node n, Node parent) {
        Token parentNodeType = parent.getToken();
        if (parentNodeType == Token.FUNCTION || parentNodeType == Token.CATCH || parentNodeType == Token.PARAM_LIST || NodeUtil.isNameDeclaration(parent)) {
            return false;
        }
        if (NodeUtil.isEnhancedFor(parent) && parent.getFirstChild() == n) {
            return false;
        }
        JSType type = n.getJSType();
        if (type == null) {
            JSType varType;
            type = this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
            TypedVar var = t.getTypedScope().getVar(n.getString());
            if (var != null && (varType = var.getType()) != null) {
                type = varType;
            }
        }
        this.ensureTyped(n, type);
        return true;
    }

    private void checkForOfTypes(NodeTraversal t, Node forOf) {
        JSType actualType;
        Node lhs = forOf.getFirstChild();
        Node iterable = forOf.getSecondChild();
        JSType iterableType = this.getJSType(iterable);
        if (forOf.isForAwaitOf()) {
            Optional<JSType> maybeType = this.validator.expectAutoboxesToIterableOrAsyncIterable(iterable, iterableType, "Can only async iterate over a (non-null) Iterable or AsyncIterable type");
            if (!maybeType.isPresent()) {
                return;
            }
            actualType = maybeType.get();
        } else {
            this.validator.expectAutoboxesToIterable(iterable, iterableType, "Can only iterate over a (non-null) Iterable type");
            actualType = iterableType.autobox().getTemplateTypeMap().getResolvedTemplateType(this.typeRegistry.getIterableTemplate());
        }
        if (NodeUtil.isNameDeclaration(lhs)) {
            lhs = lhs.getFirstChild();
        }
        if (lhs.isDestructuringLhs()) {
            lhs = lhs.getFirstChild();
        }
        this.checkCanAssignToWithScope(t, forOf, lhs, actualType, lhs.getJSDocInfo(), "declared type of for-of loop variable does not match inferred type");
    }

    private void visitGetProp(NodeTraversal t, Node n) {
        Node property = n.getLastChild();
        Node objNode = n.getFirstChild();
        JSType childType = this.getJSType(objNode);
        if (childType.isDict()) {
            this.report(property, TypeValidator.ILLEGAL_PROPERTY_ACCESS, "'.'", "dict");
        } else if (this.validator.expectNotNullOrUndefined(t, n, childType, "No properties on this expression", this.getNativeType(JSTypeNative.OBJECT_TYPE))) {
            this.checkPropertyAccessForGetProp(n);
        }
        this.ensureTyped(n);
    }

    private void checkPropertyAccessForGetProp(Node getProp) {
        Preconditions.checkArgument(getProp.isGetProp(), getProp);
        Node objNode = getProp.getFirstChild();
        JSType objType = this.getJSType(objNode);
        Node propNode = getProp.getSecondChild();
        JSType propType = this.getJSType(getProp);
        this.checkAbstractPropertyAccess(getProp);
        this.checkPropertyAccess(objType, getProp, propType, propNode, objNode);
    }

    private void checkPropertyAccessForDestructuring(Node pattern, JSType objectType, Node stringKey, JSType inferredPropType) {
        Preconditions.checkArgument(pattern.isDestructuringPattern(), pattern);
        Preconditions.checkArgument(stringKey.isStringKey(), stringKey);
        Node objNode = null;
        Node patternParent = pattern.getParent();
        if ((patternParent.isAssign() || patternParent.isDestructuringLhs()) && pattern.getNext() != null) {
            objNode = pattern.getNext();
        }
        this.checkPropertyAccess(objectType, null, inferredPropType, stringKey, objNode);
    }

    private void checkAbstractPropertyAccess(Node method) {
        String objectProp;
        if (NodeUtil.isLhsOfAssign(method)) {
            return;
        }
        FunctionType methodType = this.getJSType(method).toMaybeFunctionType();
        if (methodType == null || !methodType.isAbstract() || methodType.isConstructor()) {
            return;
        }
        Node objectNode = method.getFirstChild();
        if (objectNode.isSuper()) {
            this.report(method, ABSTRACT_SUPER_METHOD_NOT_USABLE, methodType.getDisplayName());
        } else if (objectNode.isGetProp() && ((objectProp = objectNode.getSecondChild().getString()).equals("prototype") || this.compiler.getCodingConvention().isSuperClassReference(objectProp))) {
            this.report(method, ABSTRACT_SUPER_METHOD_NOT_USABLE, methodType.getDisplayName());
        }
    }

    private void checkPropertyAccess(JSType childType, @Nullable Node getProp, JSType propType, Node propNode, @Nullable Node objNode) {
        String propName = propNode.getString();
        if (propType.isEquivalentTo(this.typeRegistry.getNativeType(JSTypeNative.UNKNOWN_TYPE))) {
            ObjectType objectType = ObjectType.cast(childType = childType.autobox());
            if (objectType != null) {
                if (!objectType.hasProperty(propName) || objectType.isEquivalentTo(this.typeRegistry.getNativeType(JSTypeNative.UNKNOWN_TYPE))) {
                    if (objectType instanceof EnumType) {
                        this.report(getProp != null ? getProp : propNode, INEXISTENT_ENUM_ELEMENT, propName);
                    } else {
                        this.checkPropertyAccessHelper(objectType, propNode, objNode, getProp, false);
                    }
                }
            } else {
                this.checkPropertyAccessHelper(childType, propNode, objNode, getProp, false);
            }
        } else if (childType.isUnionType() && getProp != null && !this.isLValueGetProp(getProp)) {
            this.checkPropertyAccessHelper(childType, propNode, objNode, getProp, true);
        }
    }

    boolean isLValueGetProp(Node n) {
        Node parent = n.getParent();
        return (NodeUtil.isUpdateOperator(parent) || NodeUtil.isAssignmentOp(parent)) && parent.getFirstChild() == n;
    }

    private void checkPropertyAccessHelper(JSType objectType, Node propNode, @Nullable Node objNode, Node getProp, boolean strictCheck) {
        if (!this.reportMissingProperties || objectType.isEmptyType() || getProp != null && this.allowStrictPropertyAccessOnNode(getProp)) {
            return;
        }
        String propName = propNode.getString();
        JSTypeRegistry.PropDefinitionKind kind = this.typeRegistry.canPropertyBeDefined(objectType, propName);
        if (kind.equals((Object)JSTypeRegistry.PropDefinitionKind.KNOWN)) {
            return;
        }
        boolean isLooselyAssociated = kind.equals((Object)JSTypeRegistry.PropDefinitionKind.LOOSE) || kind.equals((Object)JSTypeRegistry.PropDefinitionKind.LOOSE_UNION);
        boolean isUnknownType = objectType.isUnknownType();
        if (isLooselyAssociated && isUnknownType) {
            return;
        }
        boolean isStruct = objectType.isStruct();
        boolean loosePropertyDeclaration = getProp != null && this.isQNameAssignmentTarget(getProp) && !isStruct;
        boolean maybePropExistenceCheck = !isStruct && getProp != null && this.allowLoosePropertyAccessOnNode(getProp);
        boolean strictReport = strictCheck || isLooselyAssociated || loosePropertyDeclaration || maybePropExistenceCheck;
        this.reportMissingProperty(objNode, objectType, propNode, kind, strictReport);
    }

    private void reportMissingProperty(@Nullable Node objNode, JSType objectType, Node propNode, JSTypeRegistry.PropDefinitionKind kind, boolean strictReport) {
        String propName = propNode.getString();
        boolean isObjectType = objectType.isEquivalentTo(this.getNativeType(JSTypeNative.OBJECT_TYPE));
        boolean lowConfidence = objectType.isUnknownType() || objectType.isAllType() || isObjectType;
        boolean isKnownToUnionMember = kind.equals((Object)JSTypeRegistry.PropDefinitionKind.LOOSE_UNION);
        SuggestionPair pair = null;
        if (!lowConfidence && !isKnownToUnionMember) {
            pair = TypeCheck.getClosestPropertySuggestion(objectType, propName, (propName.length() - 1) / 4);
        }
        if (pair != null) {
            DiagnosticType reportType = strictReport ? STRICT_INEXISTENT_PROPERTY_WITH_SUGGESTION : INEXISTENT_PROPERTY_WITH_SUGGESTION;
            this.report(propNode, reportType, propName, objNode != null ? this.typeRegistry.getReadableTypeName(objNode) : objectType.toString(), pair.suggestion);
        } else {
            DiagnosticType reportType = strictReport ? (isKnownToUnionMember ? STRICT_INEXISTENT_UNION_PROPERTY : STRICT_INEXISTENT_PROPERTY) : (lowConfidence ? POSSIBLE_INEXISTENT_PROPERTY : INEXISTENT_PROPERTY);
            this.report(propNode, reportType, propName, objNode != null ? this.typeRegistry.getReadableTypeName(objNode) : objectType.toString());
        }
    }

    private boolean allowStrictPropertyAccessOnNode(Node n) {
        return n.getParent().isTypeOf();
    }

    private boolean allowLoosePropertyAccessOnNode(Node n) {
        Node parent = n.getParent();
        return NodeUtil.isPropertyTest(this.compiler, n) || n.isQualifiedName() && parent.isExprResult();
    }

    private boolean isQNameAssignmentTarget(Node n) {
        Node parent = n.getParent();
        return n.isQualifiedName() && parent.isAssign() && parent.getFirstChild() == n;
    }

    private static SuggestionPair getClosestPropertySuggestion(JSType objectType, String propName, int maxDistance) {
        return null;
    }

    private void visitGetElem(Node n) {
        this.validator.expectIndexMatch(n, this.getJSType(n.getFirstChild()), this.getJSType(n.getLastChild()));
        this.ensureTyped(n);
    }

    private void visitVar(NodeTraversal t, Node n) {
        if (n.getParent().isForOf() || n.getParent().isForIn()) {
            return;
        }
        JSDocInfo varInfo = n.hasOneChild() ? n.getJSDocInfo() : null;
        for (Node child : n.children()) {
            if (child.isName()) {
                Node value = child.getFirstChild();
                if (value == null) continue;
                JSType valueType = this.getJSType(value);
                JSDocInfo info = child.getJSDocInfo();
                if (info == null) {
                    info = varInfo;
                }
                this.checkEnumAlias(t, info, valueType, value);
                this.checkCanAssignToWithScope(t, value, child, valueType, info, "initializing variable");
                continue;
            }
            Preconditions.checkState(child.isDestructuringLhs(), child);
            Node name = child.getFirstChild();
            Node value = child.getSecondChild();
            JSType valueType = this.getJSType(value);
            this.checkCanAssignToWithScope(t, child, name, valueType, null, "initializing variable");
        }
    }

    private void visitNew(Node n) {
        Node constructor = n.getFirstChild();
        JSType type = this.getJSType(constructor).restrictByNotNullOrUndefined();
        if (!this.couldBeAConstructor(type) || type.isEquivalentTo(this.typeRegistry.getNativeType(JSTypeNative.SYMBOL_OBJECT_FUNCTION_TYPE))) {
            this.report(n, NOT_A_CONSTRUCTOR, new String[0]);
            this.ensureTyped(n);
            return;
        }
        FunctionType fnType = type.toMaybeFunctionType();
        if (fnType != null && fnType.hasInstanceType()) {
            FunctionType ctorType = fnType.getInstanceType().getConstructor();
            if (ctorType != null && ctorType.isAbstract()) {
                this.report(n, INSTANTIATE_ABSTRACT_CLASS, new String[0]);
            }
            this.visitArgumentList(n, fnType);
            this.ensureTyped(n, fnType.getInstanceType());
        } else {
            this.ensureTyped(n);
        }
    }

    private boolean couldBeAConstructor(JSType type) {
        return type.isConstructor() || type.isEmptyType() || type.isUnknownType();
    }

    private void checkInterfaceConflictProperties(Node n, String functionName, Map<String, ObjectType> properties, Map<String, ObjectType> currentProperties, ObjectType interfaceType) {
        ObjectType implicitProto = interfaceType.getImplicitPrototype();
        Set<Object> currentPropertyNames = implicitProto == null ? ImmutableSet.of() : implicitProto.getOwnPropertyNames();
        for (String string : currentPropertyNames) {
            JSType oPropType;
            JSType thisPropType;
            ObjectType oType = properties.get(string);
            currentProperties.put(string, interfaceType);
            if (oType == null || (thisPropType = interfaceType.getPropertyType(string)).isSubtype(oPropType = oType.getPropertyType(string), this.subtypingMode) || oPropType.isSubtype(thisPropType, this.subtypingMode) || thisPropType.isFunctionType() && oPropType.isFunctionType() && thisPropType.toMaybeFunctionType().hasEqualCallType(oPropType.toMaybeFunctionType())) continue;
            this.compiler.report(JSError.make(n, INCOMPATIBLE_EXTENDED_PROPERTY_TYPE, functionName, string, oType.toString(), interfaceType.toString()));
        }
        for (ObjectType objectType : interfaceType.getCtorExtendedInterfaces()) {
            this.checkInterfaceConflictProperties(n, functionName, properties, currentProperties, objectType);
        }
    }

    private void visitFunction(Node n) {
        if (NodeUtil.isEs6Constructor(n)) {
            return;
        }
        FunctionType functionType = JSType.toMaybeFunctionType(n.getJSType());
        if (functionType.isConstructor()) {
            this.checkConstructor(n, functionType);
        } else if (functionType.isInterface()) {
            this.checkInterface(n, functionType);
        } else if (n.isAsyncGeneratorFunction()) {
            JSType returnType = functionType.getReturnType();
            this.validator.expectAsyncGeneratorSupertype(n, returnType, "An async generator function must return a (supertype of) AsyncGenerator");
        } else if (n.isGeneratorFunction()) {
            JSType returnType = functionType.getReturnType();
            this.validator.expectGeneratorSupertype(n, returnType, "A generator function must return a (supertype of) Generator");
        } else if (n.isAsyncFunction()) {
            JSType returnType = functionType.getReturnType();
            this.validator.expectValidAsyncReturnType(n, returnType);
        }
    }

    private void visitClass(Node n) {
        FunctionType functionType = JSType.toMaybeFunctionType(n.getJSType());
        Node extendsClause = n.getSecondChild();
        if (!extendsClause.isEmpty()) {
            JSType superType = extendsClause.getJSType();
            if (superType.isConstructor() || superType.isInterface()) {
                this.validator.expectExtends(n, functionType, superType.toMaybeFunctionType());
            } else if (!superType.isUnknownType()) {
                this.compiler.report(JSError.make(n, CONFLICTING_EXTENDED_TYPE, functionType.isConstructor() ? "constructor" : "interface", this.getBestFunctionName(n)));
            }
        }
        if (functionType.isConstructor()) {
            this.checkConstructor(n, functionType);
        } else if (functionType.isInterface()) {
            this.checkInterface(n, functionType);
        } else {
            throw new IllegalStateException("CLASS node's type must be either constructor or interface: " + functionType);
        }
    }

    private void checkConstructor(Node n, FunctionType functionType) {
        FunctionType baseConstructor = functionType.getSuperClassConstructor();
        if (!Objects.equals(baseConstructor, this.getNativeType(JSTypeNative.OBJECT_FUNCTION_TYPE)) && baseConstructor != null && baseConstructor.isInterface()) {
            this.compiler.report(JSError.make(n, CONFLICTING_EXTENDED_TYPE, "constructor", this.getBestFunctionName(n)));
        } else {
            if (n.isFunction() && baseConstructor != null && baseConstructor.getSource() != null && baseConstructor.getSource().isEs6Class() && !functionType.getSource().isEs6Class()) {
                this.compiler.report(JSError.make(n, ES5_CLASS_EXTENDING_ES6_CLASS, functionType.getDisplayName(), baseConstructor.getDisplayName()));
            }
            for (JSType jSType : functionType.getImplementedInterfaces()) {
                boolean badImplementedType = false;
                ObjectType baseInterfaceObj = ObjectType.cast(jSType);
                if (baseInterfaceObj != null) {
                    FunctionType interfaceConstructor = baseInterfaceObj.getConstructor();
                    if (interfaceConstructor != null && !interfaceConstructor.isInterface()) {
                        badImplementedType = true;
                    }
                } else {
                    badImplementedType = true;
                }
                if (!badImplementedType) continue;
                this.report(n, BAD_IMPLEMENTED_TYPE, this.getBestFunctionName(n));
            }
            this.validator.expectAllInterfaceProperties(n, functionType);
            if (!functionType.isAbstract()) {
                this.validator.expectAbstractMethodsImplemented(n, functionType);
            }
        }
    }

    private void checkInterface(Node n, FunctionType functionType) {
        List<FunctionType> loopPath;
        for (ObjectType extInterface : functionType.getExtendedInterfaces()) {
            if (extInterface.getConstructor() == null || extInterface.getConstructor().isInterface()) continue;
            this.compiler.report(JSError.make(n, CONFLICTING_EXTENDED_TYPE, "interface", this.getBestFunctionName(n)));
        }
        if (functionType.getExtendedInterfacesCount() > 1) {
            HashMap<String, ObjectType> properties = new HashMap<String, ObjectType>();
            LinkedHashMap<String, ObjectType> currentProperties = new LinkedHashMap<String, ObjectType>();
            for (ObjectType interfaceType : functionType.getExtendedInterfaces()) {
                currentProperties.clear();
                this.checkInterfaceConflictProperties(n, this.getBestFunctionName(n), properties, currentProperties, interfaceType);
                properties.putAll(currentProperties);
            }
        }
        if ((loopPath = functionType.checkExtendsLoop()) != null) {
            String strPath = "";
            for (int i = 0; i < loopPath.size() - 1; ++i) {
                strPath = strPath + loopPath.get(i).getDisplayName() + " -> ";
            }
            strPath = strPath + Iterables.getLast(loopPath).getDisplayName();
            this.compiler.report(JSError.make(n, INTERFACE_EXTENDS_LOOP, loopPath.get(0).getDisplayName(), strPath));
        }
    }

    private String getBestFunctionName(Node n) {
        Preconditions.checkState(n.isClass() || n.isFunction());
        String name = NodeUtil.getBestLValueName(NodeUtil.getBestLValue(n));
        return name != null ? name : "<anonymous@" + n.getSourceFileName() + ":" + n.getLineno() + ">";
    }

    private void checkCallConventions(NodeTraversal t, Node n) {
        CodingConvention.SubclassRelationship relationship = this.compiler.getCodingConvention().getClassesDefinedByCall(n);
        TypedScope scope = t.getTypedScope();
        if (relationship != null) {
            JSType superClass = scope.lookupQualifiedName(QualifiedName.of(relationship.superclassName));
            ObjectType superClassInstanceType = TypeValidator.getInstanceOfCtor(superClass);
            JSType subClass = scope.lookupQualifiedName(QualifiedName.of(relationship.subclassName));
            ObjectType subClassInstance = TypeValidator.getInstanceOfCtor(subClass);
            if (relationship.type == CodingConvention.SubclassType.INHERITS && superClassInstanceType != null && !superClassInstanceType.isEmptyType() && subClassInstance != null && !subClassInstance.isEmptyType()) {
                if (n.getFirstChild().isQualifiedName() && n.getFirstChild().matchesQualifiedName("goog.inherits") && subClass.toMaybeFunctionType() != null && subClass.toMaybeFunctionType().getSource() != null && subClass.toMaybeFunctionType().getSource().isEs6Class()) {
                    this.compiler.report(JSError.make(n, ES6_CLASS_EXTENDING_CLASS_WITH_GOOG_INHERITS, new String[0]));
                }
                this.validator.expectSuperType(n, superClassInstanceType, subClassInstance);
            }
        }
    }

    private void visitCall(NodeTraversal t, Node n) {
        this.checkCallConventions(t, n);
        Node child = n.getFirstChild();
        JSType childType = this.getJSType(child).restrictByNotNullOrUndefined();
        if (!childType.canBeCalled()) {
            this.report(n, NOT_CALLABLE, childType.toString());
            this.ensureTyped(n);
            return;
        }
        if (childType.isFunctionType()) {
            JSType receiverType;
            FunctionType functionType = childType.toMaybeFunctionType();
            if (functionType.isConstructor() && !functionType.isNativeObjectType() && (functionType.getReturnType().isUnknownType() || functionType.getReturnType().isVoidType()) && !n.getFirstChild().isSuper()) {
                this.report(n, CONSTRUCTOR_NOT_CALLABLE, childType.toString());
            }
            if (!(!functionType.isOrdinaryFunction() || NodeUtil.isGet(child) || (receiverType = functionType.getTypeOfThis()).isUnknownType() || receiverType.isAllType() || receiverType.isVoidType() || receiverType.isObjectType() && receiverType.toObjectType().isNativeObjectType())) {
                this.report(n, EXPECTED_THIS_TYPE, functionType.toString());
            }
            this.visitArgumentList(n, functionType);
            this.ensureTyped(n, functionType.getReturnType());
        } else {
            this.ensureTyped(n);
        }
    }

    private void visitArgumentList(Node call, FunctionType functionType) {
        Iterator<Node> parameters = functionType.getParameters().iterator();
        Iterator<Node> arguments = NodeUtil.getInvocationArgsAsIterable(call).iterator();
        this.checkArgumentsMatchParameters(call, functionType, arguments, parameters, 0);
    }

    private void checkArgumentsMatchParameters(Node call, FunctionType functionType, Iterator<Node> arguments, Iterator<Node> parameters, int firstParameterIndex) {
        int spreadArgumentCount = 0;
        int normalArgumentCount = firstParameterIndex;
        boolean checkArgumentTypeAgainstParameter = true;
        Node parameter = null;
        Node argument = null;
        while (arguments.hasNext()) {
            argument = arguments.next();
            if (argument.isSpread()) {
                ++spreadArgumentCount;
                checkArgumentTypeAgainstParameter = false;
            } else {
                ++normalArgumentCount;
            }
            if (checkArgumentTypeAgainstParameter) {
                if (parameters.hasNext()) {
                    parameter = parameters.next();
                } else if (parameter == null || !parameter.isVarArgs()) {
                    parameter = null;
                    checkArgumentTypeAgainstParameter = false;
                }
            }
            if (!checkArgumentTypeAgainstParameter) continue;
            this.validator.expectArgumentMatchesParameter(argument, this.getJSType(argument), this.getJSType(parameter), call, normalArgumentCount);
        }
        int minArity = functionType.getMinArity();
        int maxArity = functionType.getMaxArity();
        if (spreadArgumentCount > 0) {
            if (normalArgumentCount > maxArity) {
                this.report(call, WRONG_ARGUMENT_COUNT, this.typeRegistry.getReadableTypeNameNoDeref(call.getFirstChild()), "at least " + String.valueOf(normalArgumentCount), String.valueOf(minArity), maxArity == Integer.MAX_VALUE ? "" : " and no more than " + maxArity + " argument(s)");
            }
        } else if (minArity > normalArgumentCount || maxArity < normalArgumentCount) {
            this.report(call, WRONG_ARGUMENT_COUNT, this.typeRegistry.getReadableTypeNameNoDeref(call.getFirstChild()), String.valueOf(normalArgumentCount), String.valueOf(minArity), maxArity == Integer.MAX_VALUE ? "" : " and no more than " + maxArity + " argument(s)");
        }
    }

    private void visitImplicitReturnExpression(NodeTraversal t, Node exprNode) {
        Node enclosingFunction = t.getEnclosingFunction();
        JSType jsType = this.getJSType(enclosingFunction);
        if (jsType.isFunctionType()) {
            FunctionType functionType = jsType.toMaybeFunctionType();
            JSType expectedReturnType = functionType.getReturnType();
            if (expectedReturnType == null) {
                expectedReturnType = this.getNativeType(JSTypeNative.VOID_TYPE);
            } else if (enclosingFunction.isAsyncFunction()) {
                expectedReturnType = Promises.createAsyncReturnableType(this.typeRegistry, expectedReturnType);
            }
            JSType actualReturnType = this.getJSType(exprNode);
            this.validator.expectCanAssignTo(exprNode, actualReturnType, expectedReturnType, "inconsistent return type");
        }
    }

    private void visitReturn(NodeTraversal t, Node n) {
        Node enclosingFunction = t.getEnclosingFunction();
        if (enclosingFunction.isGeneratorFunction() && !n.hasChildren()) {
            return;
        }
        JSType jsType = this.getJSType(enclosingFunction);
        if (jsType.isFunctionType()) {
            JSType actualReturnType;
            FunctionType functionType = jsType.toMaybeFunctionType();
            JSType returnType = functionType.getReturnType();
            if (returnType == null) {
                returnType = this.getNativeType(JSTypeNative.VOID_TYPE);
            } else if (enclosingFunction.isGeneratorFunction()) {
                returnType = JsIterables.getElementType(returnType, this.typeRegistry);
                if (enclosingFunction.isAsyncGeneratorFunction()) {
                    returnType = Promises.createAsyncReturnableType(this.typeRegistry, Promises.wrapInIThenable(this.typeRegistry, returnType));
                }
            } else if (enclosingFunction.isAsyncFunction()) {
                returnType = Promises.createAsyncReturnableType(this.typeRegistry, returnType);
            } else if (returnType.isVoidType() && functionType.isConstructor()) {
                if (!n.hasChildren()) {
                    return;
                }
                returnType = functionType.getInstanceType();
            }
            Node valueNode = n.getFirstChild();
            if (valueNode == null) {
                actualReturnType = this.getNativeType(JSTypeNative.VOID_TYPE);
                valueNode = n;
            } else {
                actualReturnType = this.getJSType(valueNode);
            }
            this.validator.expectCanAssignTo(valueNode, actualReturnType, returnType, "inconsistent return type");
        }
    }

    private void visitYield(NodeTraversal t, Node n) {
        JSType actualYieldType;
        Node valueNode;
        JSType jsType = this.getJSType(t.getEnclosingFunction());
        JSType declaredYieldType = this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        if (jsType.isFunctionType()) {
            FunctionType functionType = jsType.toMaybeFunctionType();
            JSType returnType = functionType.getReturnType();
            declaredYieldType = JsIterables.getElementType(returnType, this.typeRegistry);
            if (t.getEnclosingFunction().isAsyncGeneratorFunction()) {
                declaredYieldType = Promises.createAsyncReturnableType(this.typeRegistry, Promises.wrapInIThenable(this.typeRegistry, declaredYieldType));
            }
        }
        if ((valueNode = n.getFirstChild()) == null) {
            actualYieldType = this.getNativeType(JSTypeNative.VOID_TYPE);
            valueNode = n;
        } else {
            actualYieldType = this.getJSType(valueNode);
        }
        if (n.isYieldAll()) {
            if (t.getEnclosingFunction().isAsyncGeneratorFunction()) {
                Optional<JSType> maybeActualYieldType = this.validator.expectAutoboxesToIterableOrAsyncIterable(n, actualYieldType, "Expression yield* expects an iterable or async iterable");
                if (!maybeActualYieldType.isPresent()) {
                    return;
                }
                actualYieldType = maybeActualYieldType.get();
            } else {
                if (!this.validator.expectAutoboxesToIterable(n, actualYieldType, "Expression yield* expects an iterable")) {
                    return;
                }
                actualYieldType = actualYieldType.autobox().getInstantiatedTypeArgument(this.getNativeType(JSTypeNative.ITERABLE_TYPE));
            }
        }
        this.validator.expectCanAssignTo(valueNode, actualYieldType, declaredYieldType, "Yielded type does not match declared return type.");
    }

    private void visitTaggedTemplateLit(Node n) {
        Node tag = n.getFirstChild();
        JSType tagType = tag.getJSType().restrictByNotNullOrUndefined();
        if (!tagType.canBeCalled()) {
            this.report(n, NOT_CALLABLE, tagType.toString());
            return;
        }
        if (!tagType.isFunctionType()) {
            return;
        }
        FunctionType tagFnType = tagType.toMaybeFunctionType();
        Iterator<Node> parameters = tagFnType.getParameters().iterator();
        if (!parameters.hasNext()) {
            this.report(n, WRONG_ARGUMENT_COUNT, this.typeRegistry.getReadableTypeNameNoDeref(tag), String.valueOf(NodeUtil.getInvocationArgsCount(n)), "0", " and no more than 0 argument(s)");
            return;
        }
        Node firstParameter = parameters.next();
        JSType parameterType = firstParameter.getJSType().restrictByNotNullOrUndefined();
        if (parameterType != null) {
            this.validator.expectITemplateArraySupertype(firstParameter, parameterType, "Invalid type for the first parameter of tag function");
        }
        this.checkArgumentsMatchParameters(n, tagFnType, NodeUtil.getInvocationArgsAsIterable(n).iterator(), parameters, 1);
    }

    private void visitBinaryOperator(Token op, Node n) {
        Node left = n.getFirstChild();
        JSType leftType = this.getJSType(left);
        Node right = n.getLastChild();
        JSType rightType = this.getJSType(right);
        switch (op) {
            case ASSIGN_LSH: 
            case ASSIGN_RSH: 
            case ASSIGN_URSH: 
            case LSH: 
            case RSH: 
            case URSH: {
                String opStr = NodeUtil.opToStr(n.getToken());
                if (!leftType.matchesNumberContext()) {
                    this.report(left, BIT_OPERATION, opStr, leftType.toString());
                } else {
                    this.validator.expectNumberStrict(n, leftType, "operator " + opStr);
                }
                if (!rightType.matchesNumberContext()) {
                    this.report(right, BIT_OPERATION, opStr, rightType.toString());
                    break;
                }
                this.validator.expectNumberStrict(n, rightType, "operator " + opStr);
                break;
            }
            case ASSIGN_DIV: 
            case ASSIGN_MOD: 
            case ASSIGN_SUB: 
            case ASSIGN_MUL: 
            case ASSIGN_EXPONENT: 
            case DIV: 
            case MOD: 
            case SUB: 
            case MUL: 
            case EXPONENT: {
                this.validator.expectNumber(left, leftType, "left operand");
                this.validator.expectNumber(right, rightType, "right operand");
                break;
            }
            case ASSIGN_BITOR: 
            case ASSIGN_BITXOR: 
            case ASSIGN_BITAND: 
            case BITOR: 
            case BITXOR: 
            case BITAND: {
                this.validator.expectBitwiseable(left, leftType, "bad left operand to bitwise operator");
                this.validator.expectBitwiseable(right, rightType, "bad right operand to bitwise operator");
                break;
            }
            case ASSIGN_ADD: 
            case ADD: {
                break;
            }
            default: {
                this.report(n, UNEXPECTED_TOKEN, op.toString());
            }
        }
        this.ensureTyped(n);
    }

    private void checkEnumAlias(NodeTraversal t, JSDocInfo declInfo, JSType valueType, Node nodeToWarn) {
        if (declInfo == null || !declInfo.hasEnumParameterType()) {
            return;
        }
        if (!valueType.isEnumType()) {
            return;
        }
        EnumType valueEnumType = valueType.toMaybeEnumType();
        JSType valueEnumPrimitiveType = valueEnumType.getElementsType().getPrimitiveType();
        this.validator.expectCanAssignTo(nodeToWarn, valueEnumPrimitiveType, declInfo.getEnumParameterType().evaluate(t.getTypedScope(), this.typeRegistry), "incompatible enum element types");
    }

    private JSType getJSType(Node n) {
        JSType jsType = n.getJSType();
        if (jsType == null) {
            return this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
        return jsType;
    }

    private JSType getPropertyTypeIfDeclared(@Nullable ObjectType objectType, String propertyName) {
        if (objectType != null && objectType.hasProperty(propertyName) && !objectType.isPropertyTypeInferred(propertyName)) {
            return objectType.getPropertyType(propertyName);
        }
        return this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
    }

    private void ensureTyped(Node n) {
        this.ensureTyped(n, this.getNativeType(JSTypeNative.UNKNOWN_TYPE));
    }

    private void ensureTyped(Node n, JSTypeNative type) {
        this.ensureTyped(n, this.getNativeType(type));
    }

    private void ensureTyped(Node n, JSType type) {
        Preconditions.checkState(!n.isFunction() || type.isFunctionType() || type.isUnknownType());
        if (n.getJSType() == null) {
            n.setJSType(type);
        }
    }

    double getTypedPercent() {
        int total = this.nullCount + this.unknownCount + this.typedCount;
        return total == 0 ? 0.0 : 100.0 * (double)this.typedCount / (double)total;
    }

    private JSType getNativeType(JSTypeNative typeId) {
        return this.typeRegistry.getNativeType(typeId);
    }

    private void checkJsdocInfoContainsObjectWithBadKey(Node n) {
        if (n.getJSDocInfo() != null) {
            JSDocInfo info = n.getJSDocInfo();
            this.checkTypeContainsObjectWithBadKey(n, info.getType());
            this.checkTypeContainsObjectWithBadKey(n, info.getReturnType());
            this.checkTypeContainsObjectWithBadKey(n, info.getTypedefType());
            for (String param : info.getParameterNames()) {
                this.checkTypeContainsObjectWithBadKey(n, info.getParameterType(param));
            }
        }
    }

    private void checkTypeContainsObjectWithBadKey(Node n, JSTypeExpression type) {
        JSType realType;
        JSType objectWithBadKey;
        if (type != null && type.getRoot().getJSType() != null && (objectWithBadKey = this.findObjectWithNonStringifiableKey(realType = type.getRoot().getJSType(), new HashSet<JSType>())) != null) {
            this.compiler.report(JSError.make(n, NON_STRINGIFIABLE_OBJECT_KEY, objectWithBadKey.toString()));
        }
    }

    private boolean isReasonableObjectPropertyKey(JSType type) {
        Object templatizedType;
        if (type.isUnknownType() || type.isNumber() || type.isString() || type.isSymbol() || type.isBooleanObjectType() || type.isBooleanValueType() || type.isDateType() || type.isRegexpType() || type.isInterface() || type.isRecordType() || type.isNullType() || type.isVoidType()) {
            return true;
        }
        if (type.toMaybeEnumElementType() != null) {
            return this.isReasonableObjectPropertyKey(type.toMaybeEnumElementType().getPrimitiveType());
        }
        if (type.isArrayType()) {
            return true;
        }
        if (type.isTemplatizedType() && ((TemplatizedType)(templatizedType = type.toMaybeTemplatizedType())).getReferencedType().isArrayType()) {
            return this.isReasonableObjectPropertyKey((JSType)((TemplatizedType)templatizedType).getTemplateTypes().get(0));
        }
        if (type instanceof NamedType) {
            return this.isReasonableObjectPropertyKey(((NamedType)type).getReferencedType());
        }
        if (type.isUnionType()) {
            for (JSType alternateType : type.toMaybeUnionType().getAlternates()) {
                if (this.isReasonableObjectPropertyKey(alternateType)) continue;
                return false;
            }
            return true;
        }
        if (type.isObject()) {
            ObjectType objectType = type.toMaybeObjectType();
            FunctionType constructor = objectType.getConstructor();
            if (constructor != null && ((JSType)constructor).isInterface()) {
                return true;
            }
            return this.classHasToString(objectType);
        }
        return false;
    }

    private boolean isObjectTypeWithNonStringifiableKey(JSType type) {
        if (!type.isTemplatizedType()) {
            return false;
        }
        TemplatizedType templatizedType = type.toMaybeTemplatizedType();
        if (templatizedType.getReferencedType().isNativeObjectType() && templatizedType.getTemplateTypes().size() > 1) {
            return !this.isReasonableObjectPropertyKey((JSType)templatizedType.getTemplateTypes().get(0));
        }
        return false;
    }

    private JSType findObjectWithNonStringifiableKey(JSType type, Set<JSType> alreadyCheckedTypes) {
        JSType result;
        if (alreadyCheckedTypes.contains(type)) {
            return null;
        }
        alreadyCheckedTypes.add(type);
        if (this.isObjectTypeWithNonStringifiableKey(type)) {
            return type;
        }
        if (type.isUnionType()) {
            for (JSType alternateType : type.toMaybeUnionType().getAlternates()) {
                result = this.findObjectWithNonStringifiableKey(alternateType, alreadyCheckedTypes);
                if (result == null) continue;
                return result;
            }
        }
        if (type.isTemplatizedType()) {
            for (JSType templateType : type.toMaybeTemplatizedType().getTemplateTypes()) {
                result = this.findObjectWithNonStringifiableKey(templateType, alreadyCheckedTypes);
                if (result == null) continue;
                return result;
            }
        }
        if (type.isOrdinaryFunction()) {
            FunctionType function = type.toMaybeFunctionType();
            for (Node parameter : function.getParameters()) {
                JSType result2 = this.findObjectWithNonStringifiableKey(parameter.getJSType(), alreadyCheckedTypes);
                if (result2 == null) continue;
                return result2;
            }
            return this.findObjectWithNonStringifiableKey(function.getReturnType(), alreadyCheckedTypes);
        }
        return null;
    }

    private boolean classHasToString(ObjectType type) {
        Property toStringProperty = type.getOwnSlot("toString");
        if (toStringProperty != null) {
            return toStringProperty.getType().isFunctionType();
        }
        ObjectType parent = type.getImplicitPrototype();
        if (parent != null && !parent.isNativeObjectType()) {
            return this.classHasToString(parent);
        }
        return false;
    }

    private static boolean declaresOverride(@Nullable JSDocInfo jsdoc) {
        return jsdoc != null && jsdoc.isOverride();
    }

    private static final class SuggestionPair {
        private final String suggestion;
        final int distance;

        private SuggestionPair(String suggestion, int distance) {
            this.suggestion = suggestion;
            this.distance = distance;
        }
    }
}

