/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Table;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.HamtPMap;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.PMap;
import com.google.javascript.rhino.QualifiedName;
import com.google.javascript.rhino.SimpleErrorReporter;
import com.google.javascript.rhino.StaticScope;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.AllType;
import com.google.javascript.rhino.jstype.ArrowType;
import com.google.javascript.rhino.jstype.AutoValue_JSTypeRegistry_ModuleSlot;
import com.google.javascript.rhino.jstype.BooleanType;
import com.google.javascript.rhino.jstype.EnumType;
import com.google.javascript.rhino.jstype.FunctionParamBuilder;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.NamedType;
import com.google.javascript.rhino.jstype.NoObjectType;
import com.google.javascript.rhino.jstype.NoResolvedType;
import com.google.javascript.rhino.jstype.NoType;
import com.google.javascript.rhino.jstype.NullType;
import com.google.javascript.rhino.jstype.NumberType;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.PrototypeObjectType;
import com.google.javascript.rhino.jstype.RecordType;
import com.google.javascript.rhino.jstype.RecordTypeBuilder;
import com.google.javascript.rhino.jstype.StaticTypedScope;
import com.google.javascript.rhino.jstype.StaticTypedSlot;
import com.google.javascript.rhino.jstype.StringType;
import com.google.javascript.rhino.jstype.SymbolType;
import com.google.javascript.rhino.jstype.TemplateType;
import com.google.javascript.rhino.jstype.TemplateTypeMap;
import com.google.javascript.rhino.jstype.TemplatizedType;
import com.google.javascript.rhino.jstype.UnionType;
import com.google.javascript.rhino.jstype.UnionTypeBuilder;
import com.google.javascript.rhino.jstype.UnknownType;
import com.google.javascript.rhino.jstype.ValueType;
import com.google.javascript.rhino.jstype.VoidType;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class JSTypeRegistry
implements Serializable {
    private TemplateType iObjectIndexTemplateKey;
    private TemplateType iObjectElementTemplateKey;
    private static final String I_OBJECT_ELEMENT_TEMPLATE = "IObject#VALUE";
    private TemplateType iterableTemplate;
    private TemplateType iteratorTemplate;
    private TemplateType iiterableResultTemplate;
    private TemplateType asyncIterableTemplate;
    private TemplateType asyncIteratorTemplate;
    private TemplateType generatorTemplate;
    private TemplateType asyncGeneratorTemplate;
    private TemplateType iThenableTemplateKey;
    private TemplateType promiseTemplateKey;
    private TemplateType arrayElementTemplateKey;
    @Deprecated
    public static final String OBJECT_ELEMENT_TEMPLATE = "IObject#VALUE";
    private final transient ErrorReporter reporter;
    private final JSType[] nativeTypes;
    private final Table<Node, String, JSType> scopedNameTable = HashBasedTable.create();
    private final transient Map<String, ModuleSlot> moduleToSlotMap = new HashMap<String, ModuleSlot>();
    private final Node nameTableGlobalRoot = new Node(Token.ROOT);
    private final Multimap<Node, String> nonNullableTypeNames = MultimapBuilder.hashKeys().hashSetValues().build();
    private final transient Set<String> forwardDeclaredTypes;
    private transient Multimap<String, JSType> typesIndexedByProperty = MultimapBuilder.hashKeys().linkedHashSetValues().build();
    private JSType sentinelObjectLiteral;
    private final Set<String> propertiesOfSupertypesInUnions = new HashSet<String>();
    private final Set<String> droppedPropertiesOfUnions = new HashSet<String>();
    private transient Map<String, Map<String, ObjectType>> eachRefTypeIndexedByProperty = new LinkedHashMap<String, Map<String, ObjectType>>();
    private final Map<String, JSType> greatestSubtypeByProperty = new HashMap<String, JSType>();
    private transient Multimap<String, FunctionType> interfaceToImplementors = LinkedHashMultimap.create();
    private final List<NamedType> unresolvedNamedTypes = new ArrayList<NamedType>();
    private final TemplateTypeMap emptyTemplateTypeMap;

    public JSTypeRegistry(ErrorReporter reporter) {
        this(reporter, ImmutableSet.of());
    }

    public JSTypeRegistry(ErrorReporter reporter, Set<String> forwardDeclaredTypes) {
        this.reporter = reporter;
        this.forwardDeclaredTypes = forwardDeclaredTypes;
        this.emptyTemplateTypeMap = new TemplateTypeMap(this, ImmutableList.of(), ImmutableList.of());
        this.nativeTypes = new JSType[JSTypeNative.values().length];
        this.resetForTypeCheck();
    }

    private JSType getSentinelObjectLiteral() {
        if (this.sentinelObjectLiteral == null) {
            this.sentinelObjectLiteral = this.createAnonymousObjectType(null);
        }
        return this.sentinelObjectLiteral;
    }

    public TemplateType getObjectElementKey() {
        return this.iObjectElementTemplateKey;
    }

    public TemplateType getObjectIndexKey() {
        Preconditions.checkNotNull(this.iObjectIndexTemplateKey);
        return this.iObjectIndexTemplateKey;
    }

    public TemplateType getIterableTemplate() {
        return Preconditions.checkNotNull(this.iterableTemplate);
    }

    public TemplateType getIteratorTemplate() {
        return Preconditions.checkNotNull(this.iteratorTemplate);
    }

    public TemplateType getAsyncIterableTemplate() {
        return Preconditions.checkNotNull(this.asyncIterableTemplate);
    }

    public TemplateType getAsyncIteratorTemplate() {
        return Preconditions.checkNotNull(this.asyncIteratorTemplate);
    }

    public TemplateType getIThenableTemplate() {
        return Preconditions.checkNotNull(this.iThenableTemplateKey);
    }

    public ImmutableList<TemplateType> maybeGetTemplateTypesOfBuiltin(String fnName) {
        ObjectType objType;
        JSType type = this.getType(null, fnName);
        ObjectType objectType = objType = type == null ? null : type.toObjectType();
        if (objType != null && objType.isNativeObjectType()) {
            ImmutableList<TemplateType> templateKeys = objType.getTemplateTypeMap().getUnfilledTemplateKeys();
            return templateKeys;
        }
        return null;
    }

    public ErrorReporter getErrorReporter() {
        return this.reporter;
    }

    public void resetForTypeCheck() {
        this.typesIndexedByProperty.clear();
        this.eachRefTypeIndexedByProperty.clear();
        this.initializeBuiltInTypes();
        this.scopedNameTable.clear();
        this.initializeRegistry();
    }

    private void initializeBuiltInTypes() {
        BooleanType booleanType = new BooleanType(this);
        this.registerNativeType(JSTypeNative.BOOLEAN_TYPE, booleanType);
        NullType nullType = new NullType(this);
        this.registerNativeType(JSTypeNative.NULL_TYPE, nullType);
        NumberType numberType = new NumberType(this);
        this.registerNativeType(JSTypeNative.NUMBER_TYPE, numberType);
        StringType stringType = new StringType(this);
        this.registerNativeType(JSTypeNative.STRING_TYPE, stringType);
        SymbolType symbolType = new SymbolType(this);
        this.registerNativeType(JSTypeNative.SYMBOL_TYPE, symbolType);
        UnknownType unknownType = new UnknownType(this, false);
        this.registerNativeType(JSTypeNative.UNKNOWN_TYPE, unknownType);
        UnknownType checkedUnknownType = new UnknownType(this, true);
        this.registerNativeType(JSTypeNative.CHECKED_UNKNOWN_TYPE, checkedUnknownType);
        VoidType voidType = new VoidType(this);
        this.registerNativeType(JSTypeNative.VOID_TYPE, voidType);
        AllType allType = new AllType(this);
        this.registerNativeType(JSTypeNative.ALL_TYPE, allType);
        this.iObjectIndexTemplateKey = new TemplateType(this, "IObject#KEY1");
        this.iObjectElementTemplateKey = new TemplateType(this, "IObject#VALUE");
        TemplateType iArrayLikeTemplate = new TemplateType(this, "VALUE2");
        this.arrayElementTemplateKey = new TemplateType(this, "T");
        this.iteratorTemplate = new TemplateType(this, "VALUE");
        this.iiterableResultTemplate = new TemplateType(this, "VALUE");
        this.asyncIteratorTemplate = new TemplateType(this, "VALUE");
        this.generatorTemplate = new TemplateType(this, "VALUE");
        this.asyncGeneratorTemplate = new TemplateType(this, "VALUE");
        this.iterableTemplate = new TemplateType(this, "VALUE");
        this.asyncIterableTemplate = new TemplateType(this, "VALUE");
        this.iThenableTemplateKey = new TemplateType(this, "TYPE");
        this.promiseTemplateKey = new TemplateType(this, "TYPE");
        PrototypeObjectType topLevelPrototype = new PrototypeObjectType(this, null, null, true, null);
        FunctionType iObjectFunctionType = this.nativeInterface("IObject", this.iObjectIndexTemplateKey, this.iObjectElementTemplateKey);
        this.registerNativeType(JSTypeNative.I_OBJECT_FUNCTION_TYPE, iObjectFunctionType);
        this.registerNativeType(JSTypeNative.I_OBJECT_TYPE, iObjectFunctionType.getInstanceType());
        FunctionType objectFunctionType = this.nativeConstructorBuilder("Object").withParamsNode(this.createOptionalParameters(allType)).withReturnsOwnInstanceType().withTemplateKeys(this.iObjectIndexTemplateKey, this.iObjectElementTemplateKey).build();
        objectFunctionType.setPrototype(topLevelPrototype, null);
        this.registerNativeType(JSTypeNative.OBJECT_FUNCTION_TYPE, objectFunctionType);
        this.registerNativeType(JSTypeNative.OBJECT_PROTOTYPE, objectFunctionType.getPrototype());
        ObjectType objectType = objectFunctionType.getInstanceType();
        this.registerNativeType(JSTypeNative.OBJECT_TYPE, objectType);
        FunctionType functionFunctionType = this.nativeConstructorBuilder("Function").withParamsNode(this.createParametersWithVarArgs(allType)).withReturnType(unknownType).withPrototypeBasedOn(objectType).build();
        functionFunctionType.setPrototypeBasedOn(objectType);
        this.registerNativeType(JSTypeNative.FUNCTION_FUNCTION_TYPE, functionFunctionType);
        ObjectType functionPrototype = functionFunctionType.getPrototype();
        this.registerNativeType(JSTypeNative.FUNCTION_PROTOTYPE, functionPrototype);
        NoType noType = new NoType(this);
        this.registerNativeType(JSTypeNative.NO_TYPE, noType);
        NoObjectType noObjectType = new NoObjectType(this);
        this.registerNativeType(JSTypeNative.NO_OBJECT_TYPE, noObjectType);
        NoResolvedType noResolvedType = new NoResolvedType(this);
        this.registerNativeType(JSTypeNative.NO_RESOLVED_TYPE, noResolvedType);
        FunctionType iterableFunctionType = this.nativeInterface("Iterable", this.iterableTemplate);
        this.registerNativeType(JSTypeNative.ITERABLE_FUNCTION_TYPE, iterableFunctionType);
        ObjectType iterableType = iterableFunctionType.getInstanceType();
        this.registerNativeType(JSTypeNative.ITERABLE_TYPE, iterableType);
        FunctionType iteratorFunctionType = this.nativeInterface("Iterator", this.iteratorTemplate);
        this.registerNativeType(JSTypeNative.ITERATOR_FUNCTION_TYPE, iteratorFunctionType);
        ObjectType iteratorType = iteratorFunctionType.getInstanceType();
        this.registerNativeType(JSTypeNative.ITERATOR_TYPE, iteratorType);
        FunctionType iiterableResultFunctionType = this.nativeInterface("IIterableResult", this.iiterableResultTemplate);
        this.registerNativeType(JSTypeNative.I_ITERABLE_RESULT_FUNCTION_TYPE, iiterableResultFunctionType);
        ObjectType iiterableResultType = iiterableResultFunctionType.getInstanceType();
        this.registerNativeType(JSTypeNative.I_ITERABLE_RESULT_TYPE, iiterableResultType);
        FunctionType iArrayLikeFunctionType = this.nativeRecord("IArrayLike", iArrayLikeTemplate);
        this.registerNativeType(JSTypeNative.I_ARRAY_LIKE_FUNCTION_TYPE, iArrayLikeFunctionType);
        ObjectType iArrayLikeType = iArrayLikeFunctionType.getInstanceType();
        this.registerNativeType(JSTypeNative.I_ARRAY_LIKE_TYPE, iArrayLikeType);
        FunctionType arrayFunctionType = this.nativeConstructorBuilder("Array").withParamsNode(this.createParametersWithVarArgs(allType)).withReturnsOwnInstanceType().withTemplateTypeMap(new TemplateTypeMap(this, ImmutableList.of(this.iObjectElementTemplateKey, this.arrayElementTemplateKey), ImmutableList.of(this.arrayElementTemplateKey))).build();
        arrayFunctionType.getPrototype();
        arrayFunctionType.setImplementedInterfaces(ImmutableList.of(this.createTemplatizedType(iterableType, this.arrayElementTemplateKey)));
        this.registerNativeType(JSTypeNative.ARRAY_FUNCTION_TYPE, arrayFunctionType);
        ObjectType arrayType = arrayFunctionType.getInstanceType();
        this.registerNativeType(JSTypeNative.ARRAY_TYPE, arrayType);
        FunctionType iTemplateArrayFunctionType = this.nativeConstructorBuilder("ITemplateArray").withParamsNode(this.createEmptyParams()).build();
        this.registerNativeType(JSTypeNative.I_TEMPLATE_ARRAY_TYPE, iTemplateArrayFunctionType.getInstanceType());
        FunctionType generatorFunctionType = this.nativeInterface("Generator", this.generatorTemplate);
        generatorFunctionType.setExtendedInterfaces(ImmutableList.of(this.createTemplatizedType(iterableType, this.generatorTemplate), this.createTemplatizedType(iteratorType, this.generatorTemplate)));
        this.registerNativeType(JSTypeNative.GENERATOR_FUNCTION_TYPE, generatorFunctionType);
        this.registerNativeType(JSTypeNative.GENERATOR_TYPE, generatorFunctionType.getInstanceType());
        FunctionType asyncIteratorFunctionType = this.nativeInterface("AsyncIterator", this.asyncIteratorTemplate);
        this.registerNativeType(JSTypeNative.ASYNC_ITERATOR_FUNCTION_TYPE, asyncIteratorFunctionType);
        this.registerNativeType(JSTypeNative.ASYNC_ITERATOR_TYPE, asyncIteratorFunctionType.getInstanceType());
        FunctionType asyncIterableFunctionType = this.nativeInterface("AsyncIterable", this.asyncIterableTemplate);
        this.registerNativeType(JSTypeNative.ASYNC_ITERABLE_FUNCTION_TYPE, asyncIterableFunctionType);
        this.registerNativeType(JSTypeNative.ASYNC_ITERABLE_TYPE, asyncIterableFunctionType.getInstanceType());
        FunctionType asyncGeneratorFunctionType = this.nativeInterface("AsyncGenerator", this.asyncGeneratorTemplate);
        this.registerNativeType(JSTypeNative.ASYNC_GENERATOR_FUNCTION_TYPE, asyncGeneratorFunctionType);
        this.registerNativeType(JSTypeNative.ASYNC_GENERATOR_TYPE, asyncGeneratorFunctionType.getInstanceType());
        FunctionType ithenableFunctionType = this.nativeInterface("IThenable", this.iThenableTemplateKey);
        this.registerNativeType(JSTypeNative.I_THENABLE_FUNCTION_TYPE, ithenableFunctionType);
        ObjectType ithenableType = ithenableFunctionType.getInstanceType();
        this.registerNativeType(JSTypeNative.I_THENABLE_TYPE, ithenableType);
        JSType thenableType = this.createRecordType(ImmutableMap.of("then", unknownType));
        this.identifyNonNullableName(null, "Thenable");
        this.registerNativeType(JSTypeNative.THENABLE_TYPE, thenableType);
        FunctionType promiseParameterType = this.createFunctionType((JSType)unknownType, this.createFunctionType((JSType)unknownType, this.createOptionalParameters(this.createUnionType(this.promiseTemplateKey, this.createTemplatizedType(ithenableType, this.promiseTemplateKey), thenableType, nullType))), this.createFunctionType((JSType)unknownType, this.createOptionalParameters(allType)));
        Node promiseParameter = IR.name("");
        promiseParameter.setJSType(promiseParameterType);
        FunctionType promiseFunctionType = this.nativeConstructorBuilder("Promise").withParamsNode(IR.paramList(promiseParameter)).withTemplateKeys(this.promiseTemplateKey).withExtendedTemplate(this.iThenableTemplateKey, this.promiseTemplateKey).build();
        promiseFunctionType.setImplementedInterfaces(ImmutableList.of(this.createTemplatizedType(ithenableType, this.promiseTemplateKey)));
        this.registerNativeType(JSTypeNative.PROMISE_FUNCTION_TYPE, promiseFunctionType);
        this.registerNativeType(JSTypeNative.PROMISE_TYPE, promiseFunctionType.getInstanceType());
        FunctionType booleanObjectFunctionType = this.nativeConstructorBuilder("Boolean").withParamsNode(this.createOptionalParameters(allType)).withReturnType(booleanType).build();
        booleanObjectFunctionType.getPrototype();
        this.registerNativeType(JSTypeNative.BOOLEAN_OBJECT_FUNCTION_TYPE, booleanObjectFunctionType);
        ObjectType booleanObjectType = booleanObjectFunctionType.getInstanceType();
        this.registerNativeType(JSTypeNative.BOOLEAN_OBJECT_TYPE, booleanObjectType);
        FunctionType dateFunctionType = this.nativeConstructorBuilder("Date").withParamsNode(this.createOptionalParameters(unknownType, unknownType, unknownType, unknownType, unknownType, unknownType, unknownType)).withReturnType(stringType).build();
        dateFunctionType.getPrototype();
        this.registerNativeType(JSTypeNative.DATE_FUNCTION_TYPE, dateFunctionType);
        ObjectType dateType = dateFunctionType.getInstanceType();
        this.registerNativeType(JSTypeNative.DATE_TYPE, dateType);
        FunctionType numberObjectFunctionType = this.nativeConstructorBuilder("Number").withParamsNode(this.createOptionalParameters(allType)).withReturnType(numberType).build();
        numberObjectFunctionType.getPrototype();
        this.registerNativeType(JSTypeNative.NUMBER_OBJECT_FUNCTION_TYPE, numberObjectFunctionType);
        ObjectType numberObjectType = numberObjectFunctionType.getInstanceType();
        this.registerNativeType(JSTypeNative.NUMBER_OBJECT_TYPE, numberObjectType);
        FunctionType regexpFunctionType = this.nativeConstructorBuilder("RegExp").withParamsNode(this.createOptionalParameters(allType, allType)).withReturnsOwnInstanceType().build();
        regexpFunctionType.getPrototype();
        this.registerNativeType(JSTypeNative.REGEXP_FUNCTION_TYPE, regexpFunctionType);
        ObjectType regexpType = regexpFunctionType.getInstanceType();
        this.registerNativeType(JSTypeNative.REGEXP_TYPE, regexpType);
        FunctionType stringObjectFunctionType = this.nativeConstructorBuilder("String").withParamsNode(this.createOptionalParameters(allType)).withReturnType(stringType).build();
        stringObjectFunctionType.getPrototype();
        this.registerNativeType(JSTypeNative.STRING_OBJECT_FUNCTION_TYPE, stringObjectFunctionType);
        ObjectType stringObjectType = stringObjectFunctionType.getInstanceType();
        this.registerNativeType(JSTypeNative.STRING_OBJECT_TYPE, stringObjectType);
        FunctionType symbolObjectFunctionType = this.nativeConstructorBuilder("Symbol").withParamsNode(this.createOptionalParameters(allType)).withReturnType(symbolType).build();
        symbolObjectFunctionType.getPrototype();
        this.registerNativeType(JSTypeNative.SYMBOL_OBJECT_FUNCTION_TYPE, symbolObjectFunctionType);
        ObjectType symbolObjectType = symbolObjectFunctionType.getInstanceType();
        this.registerNativeType(JSTypeNative.SYMBOL_OBJECT_TYPE, symbolObjectType);
        JSType nullVoid = this.createUnionType(nullType, voidType);
        this.registerNativeType(JSTypeNative.NULL_VOID, nullVoid);
        JSType objectSymbol = this.createUnionType(objectType, symbolType);
        this.registerNativeType(JSTypeNative.OBJECT_SYMBOL, objectSymbol);
        JSType objectNumberString = this.createUnionType(objectType, numberType, stringType);
        this.registerNativeType(JSTypeNative.OBJECT_NUMBER_STRING, objectNumberString);
        JSType objectNumberStringBoolean = this.createUnionType(objectType, numberType, stringType, booleanType);
        this.registerNativeType(JSTypeNative.OBJECT_NUMBER_STRING_BOOLEAN, objectNumberStringBoolean);
        JSType objectNumberStringBooleanSymbol = this.createUnionType(objectType, numberType, stringType, booleanType, symbolType);
        this.registerNativeType(JSTypeNative.OBJECT_NUMBER_STRING_BOOLEAN_SYMBOL, objectNumberStringBooleanSymbol);
        JSType numberStringBoolean = this.createUnionType(numberType, stringType, booleanType);
        this.registerNativeType(JSTypeNative.NUMBER_STRING_BOOLEAN, numberStringBoolean);
        JSType numberStringBooleanSymbol = this.createUnionType(numberType, stringType, booleanType, symbolType);
        this.registerNativeType(JSTypeNative.NUMBER_STRING_BOOLEAN_SYMBOL, numberStringBooleanSymbol);
        JSType numberSymbol = this.createUnionType(numberType, symbolType);
        this.registerNativeType(JSTypeNative.NUMBER_SYMBOL, numberSymbol);
        JSType stringSymbol = this.createUnionType(stringType, symbolType);
        this.registerNativeType(JSTypeNative.STRING_SYMBOL, stringSymbol);
        JSType numberString = this.createUnionType(numberType, stringType);
        this.registerNativeType(JSTypeNative.NUMBER_STRING, numberString);
        JSType numberStringSymbol = this.createUnionType(numberType, stringType, symbolType);
        this.registerNativeType(JSTypeNative.NUMBER_STRING_SYMBOL, numberStringSymbol);
        JSType stringValueOrObjectType = this.createUnionType(stringObjectType, stringType);
        this.registerNativeType(JSTypeNative.STRING_VALUE_OR_OBJECT_TYPE, stringValueOrObjectType);
        JSType numberValueOrObjectType = this.createUnionType(numberObjectType, numberType);
        this.registerNativeType(JSTypeNative.NUMBER_VALUE_OR_OBJECT_TYPE, numberValueOrObjectType);
        JSType symbolValueOrObjectType = this.createUnionType(symbolObjectType, symbolType);
        this.registerNativeType(JSTypeNative.SYMBOL_VALUE_OR_OBJECT_TYPE, symbolValueOrObjectType);
        FunctionType u2uFunctionType = this.createFunctionTypeWithVarArgs(unknownType, unknownType);
        this.registerNativeType(JSTypeNative.U2U_FUNCTION_TYPE, u2uFunctionType);
        FunctionType u2uConstructorType = new FunctionType(FunctionType.builder(this).withName("Function").withParamsNode(this.createParametersWithVarArgs(unknownType)).withReturnType(unknownType).withTypeOfThis(unknownType).forConstructor().forNativeType()){
            private static final long serialVersionUID = 1L;

            @Override
            public FunctionType getConstructor() {
                return this.registry.getNativeFunctionType(JSTypeNative.FUNCTION_FUNCTION_TYPE);
            }
        };
        functionFunctionType.setInstanceType(u2uConstructorType);
        u2uConstructorType.setImplicitPrototype(functionPrototype);
        this.registerNativeType(JSTypeNative.U2U_CONSTRUCTOR_TYPE, u2uConstructorType);
        FunctionType leastFunctionType = this.createNativeFunctionTypeWithVarArgs(noType, allType);
        this.registerNativeType(JSTypeNative.LEAST_FUNCTION_TYPE, leastFunctionType);
        FunctionType globalThisCtor = this.nativeConstructorBuilder("global this").withParamsNode(this.createParameters(allType)).withReturnType(numberType).build();
        ObjectType globalThis = globalThisCtor.getInstanceType();
        this.registerNativeType(JSTypeNative.GLOBAL_THIS, globalThis);
        FunctionType greatestFunctionType = this.createNativeFunctionTypeWithVarArgs(allType, noType);
        this.registerNativeType(JSTypeNative.GREATEST_FUNCTION_TYPE, greatestFunctionType);
        this.registerPropertyOnType("prototype", objectFunctionType);
    }

    private void initializeRegistry() {
        this.registerGlobalType(this.getNativeType(JSTypeNative.ARRAY_TYPE));
        this.registerGlobalType(this.getNativeType(JSTypeNative.ASYNC_ITERABLE_TYPE));
        this.registerGlobalType(this.getNativeType(JSTypeNative.ASYNC_ITERATOR_TYPE));
        this.registerGlobalType(this.getNativeType(JSTypeNative.ASYNC_GENERATOR_TYPE));
        this.registerGlobalType(this.getNativeType(JSTypeNative.BOOLEAN_OBJECT_TYPE));
        this.registerGlobalType(this.getNativeType(JSTypeNative.BOOLEAN_TYPE));
        this.registerGlobalType(this.getNativeType(JSTypeNative.I_ARRAY_LIKE_TYPE));
        this.registerGlobalType(this.getNativeType(JSTypeNative.ITERABLE_TYPE));
        this.registerGlobalType(this.getNativeType(JSTypeNative.ITERATOR_TYPE));
        this.registerGlobalType(this.getNativeType(JSTypeNative.GENERATOR_TYPE));
        this.registerGlobalType(this.getNativeType(JSTypeNative.DATE_TYPE));
        this.registerGlobalType(this.getNativeType(JSTypeNative.I_OBJECT_TYPE));
        this.registerGlobalType(this.getNativeType(JSTypeNative.I_ITERABLE_RESULT_TYPE));
        this.registerGlobalType(this.getNativeType(JSTypeNative.I_TEMPLATE_ARRAY_TYPE));
        this.registerGlobalType(this.getNativeType(JSTypeNative.I_THENABLE_TYPE));
        this.registerGlobalType(this.getNativeType(JSTypeNative.NULL_TYPE));
        this.registerGlobalType(this.getNativeType(JSTypeNative.NULL_TYPE), "Null");
        this.registerGlobalType(this.getNativeType(JSTypeNative.NUMBER_OBJECT_TYPE));
        this.registerGlobalType(this.getNativeType(JSTypeNative.NUMBER_TYPE));
        this.registerGlobalType(this.getNativeType(JSTypeNative.OBJECT_TYPE));
        this.registerGlobalType(this.getNativeType(JSTypeNative.PROMISE_TYPE));
        this.registerGlobalType(this.getNativeType(JSTypeNative.REGEXP_TYPE));
        this.registerGlobalType(this.getNativeType(JSTypeNative.STRING_OBJECT_TYPE));
        this.registerGlobalType(this.getNativeType(JSTypeNative.STRING_TYPE));
        this.registerGlobalType(this.getNativeType(JSTypeNative.SYMBOL_OBJECT_TYPE));
        this.registerGlobalType(this.getNativeType(JSTypeNative.SYMBOL_TYPE));
        this.registerGlobalType(this.getNativeType(JSTypeNative.THENABLE_TYPE), "Thenable");
        this.registerGlobalType(this.getNativeType(JSTypeNative.VOID_TYPE));
        this.registerGlobalType(this.getNativeType(JSTypeNative.VOID_TYPE), "Undefined");
        this.registerGlobalType(this.getNativeType(JSTypeNative.VOID_TYPE), "void");
        this.registerGlobalType(this.getNativeType(JSTypeNative.U2U_CONSTRUCTOR_TYPE), "Function");
        this.registerGlobalType(this.getNativeType(JSTypeNative.GLOBAL_THIS), "Global");
    }

    private static String getRootElementOfName(String name) {
        int index = name.indexOf(46);
        if (index != -1) {
            return name.substring(0, index);
        }
        return name;
    }

    private static StaticScope getLookupScope(StaticScope scope, String name) {
        if (scope != null && scope.getParentScope() != null) {
            return scope.getTopmostScopeOfEventualDeclaration(JSTypeRegistry.getRootElementOfName(name));
        }
        return scope;
    }

    @Nullable
    private Node getRootNodeForScope(StaticScope scope) {
        Node root = scope != null ? scope.getRootNode() : null;
        return root == null || root.isRoot() || root.isScript() ? this.nameTableGlobalRoot : root;
    }

    private boolean isDeclaredForScope(StaticScope scope, String name) {
        return this.getTypeInternal(scope, name) != null;
    }

    private static void checkTypeName(String typeName) {
        Preconditions.checkArgument(!typeName.contains("<"), "Type names cannot contain template annotations.");
    }

    private JSType getTypeInternal(StaticScope scope, String name) {
        TemplateType type;
        JSTypeRegistry.checkTypeName(name);
        if (scope instanceof SyntheticTemplateScope && (type = ((SyntheticTemplateScope)scope).getTemplateType(name)) != null) {
            return type;
        }
        return this.getTypeForScopeInternal(JSTypeRegistry.getLookupScope(scope, name), name);
    }

    private JSType getTypeForScopeInternal(StaticScope scope, String name) {
        Node rootNode = this.getRootNodeForScope(scope);
        JSType type = this.scopedNameTable.get(rootNode, name);
        return type;
    }

    private void registerGlobalType(JSType type) {
        this.register(null, type, type.toString());
    }

    private void registerGlobalType(JSType type, String name) {
        this.register(null, type, name);
    }

    private void reregister(StaticScope scope, JSType type, String name) {
        JSTypeRegistry.checkTypeName(name);
        this.registerForScope(JSTypeRegistry.getLookupScope(scope, name), type, name);
    }

    private void register(StaticScope scope, JSType type, String name) {
        JSTypeRegistry.checkTypeName(name);
        this.registerForScope(JSTypeRegistry.getLookupScope(scope, name), type, name);
    }

    private void registerForScope(StaticScope scope, JSType type, String name) {
        this.scopedNameTable.put(this.getRootNodeForScope(scope), name, type);
    }

    public void removeType(StaticScope scope, String name) {
        this.scopedNameTable.remove(this.getRootNodeForScope(JSTypeRegistry.getLookupScope(scope, name)), name);
    }

    private void registerNativeType(JSTypeNative typeId, JSType type) {
        this.nativeTypes[typeId.ordinal()] = type;
    }

    private static boolean isObjectLiteralThatCanBeSkipped(JSType t) {
        return (t = t.restrictByNotNullOrUndefined()).isRecordType() || t.isLiteralObject();
    }

    void registerDroppedPropertiesInUnion(RecordType subtype, RecordType supertype) {
        boolean foundDroppedProperty = false;
        for (String pname : subtype.getPropertyMap().getOwnPropertyNames()) {
            if (supertype.hasProperty(pname)) continue;
            foundDroppedProperty = true;
            this.droppedPropertiesOfUnions.add(pname);
        }
        if (foundDroppedProperty) {
            this.propertiesOfSupertypesInUnions.addAll(supertype.getPropertyMap().getOwnPropertyNames());
        }
    }

    public void registerPropertyOnType(String propertyName, JSType type) {
        if (JSTypeRegistry.isObjectLiteralThatCanBeSkipped(type)) {
            type = this.getSentinelObjectLiteral();
        }
        if (type.isUnionType()) {
            this.typesIndexedByProperty.putAll(propertyName, type.toMaybeUnionType().getAlternates());
        } else {
            this.typesIndexedByProperty.put(propertyName, type);
        }
        this.addReferenceTypeIndexedByProperty(propertyName, type);
        this.greatestSubtypeByProperty.remove(propertyName);
    }

    private void addReferenceTypeIndexedByProperty(String propertyName, JSType type) {
        if (type instanceof ObjectType && ((ObjectType)type).hasReferenceName()) {
            Map typeSet = this.eachRefTypeIndexedByProperty.computeIfAbsent(propertyName, k -> new LinkedHashMap());
            ObjectType objType = (ObjectType)type;
            typeSet.put(objType.getReferenceName(), objType);
        } else if (type instanceof NamedType) {
            this.addReferenceTypeIndexedByProperty(propertyName, ((NamedType)type).getReferencedType());
        } else if (type.isUnionType()) {
            for (JSType alternate : type.toMaybeUnionType().getAlternates()) {
                this.addReferenceTypeIndexedByProperty(propertyName, alternate);
            }
        }
    }

    public void unregisterPropertyOnType(String propertyName, JSType type) {
        Map<String, ObjectType> typeSet = this.eachRefTypeIndexedByProperty.get(propertyName);
        if (typeSet != null) {
            typeSet.remove(type.toObjectType().getReferenceName());
        }
    }

    public JSType getGreatestSubtypeWithProperty(JSType type, String propertyName) {
        JSType withProperty = this.greatestSubtypeByProperty.get(propertyName);
        if (withProperty != null) {
            return withProperty.getGreatestSubtype(type);
        }
        if (this.typesIndexedByProperty.containsKey(propertyName)) {
            Collection<JSType> typesWithProp = this.typesIndexedByProperty.get(propertyName);
            JSType built = UnionTypeBuilder.createForPropertyChecking(this).addAlternates(typesWithProp).build();
            this.greatestSubtypeByProperty.put(propertyName, built);
            return built.getGreatestSubtype(type);
        }
        return this.getNativeType(JSTypeNative.NO_TYPE);
    }

    public PropDefinitionKind canPropertyBeDefined(JSType type, String propertyName) {
        if (type.isStruct()) {
            switch (type.getPropertyKind(propertyName)) {
                case KNOWN_PRESENT: {
                    return PropDefinitionKind.KNOWN;
                }
                case MAYBE_PRESENT: {
                    return PropDefinitionKind.KNOWN;
                }
                case ABSENT: {
                    return PropDefinitionKind.UNKNOWN;
                }
            }
        } else {
            if (!type.isEmptyType() && !type.isUnknownType()) {
                switch (type.getPropertyKind(propertyName)) {
                    case KNOWN_PRESENT: {
                        return PropDefinitionKind.KNOWN;
                    }
                    case MAYBE_PRESENT: {
                        return PropDefinitionKind.KNOWN;
                    }
                }
            }
            if (this.typesIndexedByProperty.containsKey(propertyName)) {
                for (JSType alternative : this.typesIndexedByProperty.get(propertyName)) {
                    RecordType maybeRecordType;
                    JSType greatestSubtype = alternative.getGreatestSubtype(type);
                    if (greatestSubtype.isEmptyType() || (maybeRecordType = greatestSubtype.toMaybeRecordType()) != null && maybeRecordType.isSynthetic()) continue;
                    return PropDefinitionKind.LOOSE;
                }
            }
            if (type.toMaybeRecordType() != null) {
                RecordType rec = type.toMaybeRecordType();
                boolean mayBeInUnion = false;
                for (String pname : rec.getPropertyMap().getOwnPropertyNames()) {
                    if (!this.propertiesOfSupertypesInUnions.contains(pname)) continue;
                    mayBeInUnion = true;
                    break;
                }
                if (mayBeInUnion && this.droppedPropertiesOfUnions.contains(propertyName)) {
                    return PropDefinitionKind.LOOSE;
                }
            }
        }
        return PropDefinitionKind.UNKNOWN;
    }

    public Iterable<ObjectType> getEachReferenceTypeWithProperty(String propertyName) {
        if (this.eachRefTypeIndexedByProperty.containsKey(propertyName)) {
            return this.eachRefTypeIndexedByProperty.get(propertyName).values();
        }
        return ImmutableList.of();
    }

    ObjectType findCommonSuperObject(ObjectType a, ObjectType b) {
        List<ObjectType> stackA = JSTypeRegistry.getSuperStack(a);
        List<ObjectType> stackB = JSTypeRegistry.getSuperStack(b);
        ObjectType result = this.getNativeObjectType(JSTypeNative.OBJECT_TYPE);
        while (!stackA.isEmpty() && !stackB.isEmpty()) {
            ObjectType currentB;
            ObjectType currentA = stackA.remove(stackA.size() - 1);
            if (currentA.isEquivalentTo(currentB = stackB.remove(stackB.size() - 1))) {
                result = currentA;
                continue;
            }
            return result;
        }
        return result;
    }

    private static List<ObjectType> getSuperStack(ObjectType a) {
        ArrayList<ObjectType> stack = new ArrayList<ObjectType>(5);
        for (ObjectType current = a; current != null; current = current.getImplicitPrototype()) {
            stack.add(current);
        }
        return stack;
    }

    void registerTypeImplementingInterface(FunctionType type, ObjectType interfaceInstance) {
        this.interfaceToImplementors.put(interfaceInstance.getReferenceName(), type);
    }

    public Collection<FunctionType> getDirectImplementors(ObjectType interfaceInstance) {
        return this.interfaceToImplementors.get(interfaceInstance.getReferenceName());
    }

    public boolean declareType(StaticScope scope, String name, JSType type) {
        Preconditions.checkState(!name.isEmpty());
        if (this.getTypeForScopeInternal(JSTypeRegistry.getLookupScope(scope, name), name) != null) {
            return false;
        }
        this.register(scope, type, name);
        return true;
    }

    public boolean declareTypeForExactScope(StaticScope scope, String name, JSType type) {
        Preconditions.checkState(!name.isEmpty());
        if (this.getTypeForScopeInternal(scope, name) != null) {
            return false;
        }
        this.registerForScope(scope, type, name);
        return true;
    }

    public void overwriteDeclaredType(String name, JSType type) {
        this.overwriteDeclaredType(null, name, type);
    }

    public void overwriteDeclaredType(StaticScope scope, String name, JSType type) {
        Preconditions.checkState(this.isDeclaredForScope(scope, name), "missing name %s", (Object)name);
        this.reregister(scope, type, name);
    }

    public boolean isForwardDeclaredType(String name) {
        return this.forwardDeclaredTypes.contains(name);
    }

    public String getReadableTypeName(Node n) {
        return this.getReadableJSTypeName(n, true);
    }

    public String getReadableTypeNameNoDeref(Node n) {
        return this.getReadableJSTypeName(n, false);
    }

    public String createGetterPropName(String originalPropName) {
        return originalPropName;
    }

    public String createSetterPropName(String originalPropName) {
        return originalPropName;
    }

    private String getSimpleReadableJSTypeName(JSType type) {
        if (type instanceof AllType) {
            return type.toString();
        }
        if (type instanceof ValueType) {
            return type.toString();
        }
        if (type.isFunctionPrototypeType()) {
            return type.toString();
        }
        if (type instanceof ObjectType) {
            if (type.toObjectType() != null && type.toObjectType().getConstructor() != null) {
                Node source = type.toObjectType().getConstructor().getSource();
                if (source != null) {
                    Preconditions.checkState(source.isFunction() || source.isClass(), source);
                    String readable = source.getFirstChild().getOriginalName();
                    if (readable != null) {
                        return readable;
                    }
                }
                return type.toString();
            }
            return null;
        }
        if (type instanceof UnionType) {
            UnionType unionType = type.toMaybeUnionType();
            String union = null;
            for (JSType alternate : unionType.getAlternates()) {
                String name = this.getSimpleReadableJSTypeName(alternate);
                if (name == null) {
                    return null;
                }
                if (union == null) {
                    union = "(" + name;
                    continue;
                }
                union = union + "|" + name;
            }
            union = union + ")";
            return union;
        }
        return null;
    }

    @VisibleForTesting
    String getReadableJSTypeName(Node n, boolean dereference) {
        String propName;
        ObjectType objectType;
        String name;
        JSType autoboxed;
        JSType type = this.getJSTypeOrUnknown(n);
        if (dereference && !(autoboxed = type.autobox()).isNoType()) {
            type = autoboxed;
        }
        if ((name = this.getSimpleReadableJSTypeName(type)) != null) {
            return name;
        }
        if (n.isGetProp() && (objectType = this.getJSTypeOrUnknown(n.getFirstChild()).dereference()) != null && (objectType = objectType.getClosestDefiningType(propName = n.getLastChild().getString())) != null && (objectType.getConstructor() != null || objectType.isFunctionPrototypeType())) {
            return objectType + "." + propName;
        }
        if (n.isQualifiedName()) {
            return n.getQualifiedName();
        }
        if (type.isFunctionType()) {
            return "function";
        }
        return type.toString();
    }

    private JSType getJSTypeOrUnknown(Node n) {
        JSType jsType = n.getJSType();
        if (jsType == null) {
            return this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
        return jsType;
    }

    public JSType getTypeForScope(StaticScope scope, String jsTypeName) {
        return this.getTypeForScopeInternal(scope, jsTypeName);
    }

    public JSType getGlobalType(String jsTypeName) {
        return this.getType(null, jsTypeName);
    }

    public JSType getType(StaticScope scope, String jsTypeName) {
        return this.getTypeInternal(scope, jsTypeName);
    }

    public JSType getType(StaticTypedScope scope, String jsTypeName, String sourceName, int lineno, int charno) {
        return this.getType(scope, jsTypeName, sourceName, lineno, charno, true);
    }

    private JSType getType(StaticTypedScope scope, String jsTypeName, String sourceName, int lineno, int charno, boolean recordUnresolvedTypes) {
        switch (jsTypeName) {
            case "boolean": {
                return this.getNativeType(JSTypeNative.BOOLEAN_TYPE);
            }
            case "number": {
                return this.getNativeType(JSTypeNative.NUMBER_TYPE);
            }
            case "string": {
                return this.getNativeType(JSTypeNative.STRING_TYPE);
            }
            case "undefined": 
            case "void": {
                return this.getNativeType(JSTypeNative.VOID_TYPE);
            }
        }
        JSType type = null;
        JSType thisType = null;
        if (scope != null && scope.getTypeOfThis() != null) {
            thisType = scope.getTypeOfThis().toObjectType();
        }
        if (thisType != null && (type = thisType.getTemplateTypeMap().getTemplateTypeKeyByName(jsTypeName)) != null) {
            Preconditions.checkState(type.isTemplateType(), "expected:%s", (Object)type);
            return type;
        }
        type = this.getType(scope, jsTypeName);
        if (type == null) {
            NamedType namedType = this.createNamedType(scope, jsTypeName, sourceName, lineno, charno);
            if (recordUnresolvedTypes) {
                this.unresolvedNamedTypes.add(namedType);
            }
            type = namedType;
        }
        return type;
    }

    public JSType getNativeType(JSTypeNative typeId) {
        return this.nativeTypes[typeId.ordinal()];
    }

    public ObjectType getNativeObjectType(JSTypeNative typeId) {
        return (ObjectType)this.getNativeType(typeId);
    }

    public FunctionType getNativeFunctionType(JSTypeNative typeId) {
        return (FunctionType)this.getNativeType(typeId);
    }

    public void clearNamedTypes() {
        this.unresolvedNamedTypes.clear();
    }

    void addUnresolvedNamedType(NamedType type) {
        this.unresolvedNamedTypes.add(type);
    }

    public void resolveTypes() {
        for (NamedType type : this.unresolvedNamedTypes) {
            type.resolve(this.reporter);
        }
        this.unresolvedNamedTypes.clear();
        PrototypeObjectType globalThis = (PrototypeObjectType)this.getNativeType(JSTypeNative.GLOBAL_THIS);
        JSType windowType = this.getTypeInternal(null, "Window");
        if (globalThis.isUnknownType()) {
            ObjectType windowObjType = ObjectType.cast(windowType);
            if (windowObjType != null) {
                globalThis.setImplicitPrototype(windowObjType);
            } else {
                globalThis.setImplicitPrototype(this.getNativeObjectType(JSTypeNative.OBJECT_TYPE));
            }
        }
    }

    public JSType evaluateTypeExpressionInGlobalScope(JSTypeExpression expr) {
        return expr.evaluate(null, this);
    }

    public JSType createOptionalType(JSType type) {
        if (type instanceof UnknownType || type.isAllType()) {
            return type;
        }
        return this.createUnionType(type, this.getNativeType(JSTypeNative.VOID_TYPE));
    }

    public JSType createDefaultObjectUnion(JSType type) {
        if (type.isTemplateType()) {
            return type;
        }
        return this.createNullableType(type);
    }

    public JSType createNullableType(JSType type) {
        return this.createUnionType(type, this.getNativeType(JSTypeNative.NULL_TYPE));
    }

    public JSType createOptionalNullableType(JSType type) {
        return this.createUnionType(type, this.getNativeType(JSTypeNative.VOID_TYPE), this.getNativeType(JSTypeNative.NULL_TYPE));
    }

    public JSType createUnionType(JSType ... variants) {
        UnionTypeBuilder builder = UnionTypeBuilder.create(this);
        for (JSType type : variants) {
            builder.addAlternate(type);
        }
        return builder.build();
    }

    public JSType createUnionType(List<? extends JSType> variants) {
        return this.createUnionType(variants.toArray(new JSType[0]));
    }

    public JSType createUnionType(JSTypeNative ... variants) {
        UnionTypeBuilder builder = UnionTypeBuilder.create(this);
        for (JSTypeNative typeId : variants) {
            builder.addAlternate(this.getNativeType(typeId));
        }
        return builder.build();
    }

    public EnumType createEnumType(String name, Node source, JSType elementsType) {
        return new EnumType(this, name, source, elementsType);
    }

    ArrowType createArrowType(Node parametersNode, JSType returnType) {
        return new ArrowType(this, parametersNode, returnType);
    }

    ArrowType createArrowType(Node parametersNode) {
        return new ArrowType(this, parametersNode, null);
    }

    ArrowType createArrowType() {
        return new ArrowType(this, this.createEmptyParams(), null);
    }

    Node createEmptyParams() {
        return new Node(Token.PARAM_LIST);
    }

    public FunctionType createFunctionType(JSType returnType, JSType ... parameterTypes) {
        return this.createFunctionType(returnType, this.createParameters(parameterTypes));
    }

    public FunctionType createFunctionType(JSType returnType, Node parameters) {
        return FunctionType.builder(this).withParamsNode(parameters).withReturnType(returnType).build();
    }

    public FunctionType createFunctionTypeWithVarArgs(JSType returnType, JSType ... parameterTypes) {
        return this.createFunctionType(returnType, this.createParametersWithVarArgs(parameterTypes));
    }

    private FunctionType createNativeFunctionTypeWithVarArgs(JSType returnType, JSType ... parameterTypes) {
        return this.createNativeFunctionType(returnType, this.createParametersWithVarArgs(parameterTypes));
    }

    public JSType createFunctionTypeWithInstanceType(ObjectType instanceType, JSType returnType, List<JSType> parameterTypes) {
        Node paramsNode = this.createParameters(parameterTypes.toArray(new JSType[parameterTypes.size()]));
        return FunctionType.builder(this).withParamsNode(paramsNode).withReturnType(returnType).withTypeOfThis(instanceType).build();
    }

    public Node createParameters(JSType ... parameterTypes) {
        return this.createParameters(false, parameterTypes);
    }

    private Node createParameters(boolean lastVarArgs, JSType ... parameterTypes) {
        FunctionParamBuilder builder = new FunctionParamBuilder(this);
        int max = parameterTypes.length - 1;
        for (int i = 0; i <= max; ++i) {
            if (lastVarArgs && i == max) {
                builder.addVarArgs(parameterTypes[i]);
                continue;
            }
            builder.addRequiredParams(parameterTypes[i]);
        }
        return builder.build();
    }

    public Node createParametersWithVarArgs(JSType ... parameterTypes) {
        return this.createParameters(true, parameterTypes);
    }

    public Node createOptionalParameters(JSType ... parameterTypes) {
        FunctionParamBuilder builder = new FunctionParamBuilder(this);
        builder.addOptionalParams(parameterTypes);
        return builder.build();
    }

    public FunctionType createFunctionTypeWithNewReturnType(FunctionType existingFunctionType, JSType returnType) {
        return FunctionType.builder(this).copyFromOtherFunction(existingFunctionType).withReturnType(returnType).build();
    }

    private FunctionType createNativeFunctionType(JSType returnType, Node parameters) {
        return FunctionType.builder(this).withParamsNode(parameters).withReturnType(returnType).forNativeType().build();
    }

    public JSType buildRecordTypeFromObject(ObjectType objType) {
        RecordType recType = objType.toMaybeRecordType();
        if (recType != null) {
            return recType;
        }
        Set<String> propNames = objType.getOwnPropertyNames();
        if (propNames.isEmpty()) {
            return this.getNativeType(JSTypeNative.OBJECT_TYPE);
        }
        ImmutableMap.Builder<String, JSType> props = new ImmutableMap.Builder<String, JSType>();
        for (String propName : propNames) {
            props.put(propName, objType.getPropertyType(propName));
        }
        return this.createRecordType(props.build());
    }

    public JSType createRecordType(Map<String, ? extends JSType> props) {
        Map<String, ? extends JSType> propMap = props;
        RecordTypeBuilder builder = new RecordTypeBuilder(this);
        for (Map.Entry<String, ? extends JSType> e : propMap.entrySet()) {
            builder.addProperty(e.getKey(), e.getValue(), null);
        }
        return builder.build();
    }

    public ObjectType createObjectType(String name, ObjectType implicitPrototype) {
        return new PrototypeObjectType(this, name, implicitPrototype);
    }

    public ObjectType createAnonymousObjectType(JSDocInfo info) {
        PrototypeObjectType type = new PrototypeObjectType(this, null, null, true);
        type.setPrettyPrint(true);
        type.setJSDocInfo(info);
        return type;
    }

    public void resetImplicitPrototype(JSType type, ObjectType newImplicitProto) {
        if (type instanceof PrototypeObjectType) {
            PrototypeObjectType poType = (PrototypeObjectType)type;
            poType.clearCachedValues();
            poType.setImplicitPrototype(newImplicitProto);
        }
    }

    public FunctionType createConstructorType(String name, Node source, Node parameters, JSType returnType, ImmutableList<TemplateType> templateKeys, boolean isAbstract) {
        Preconditions.checkArgument(source == null || source.isFunction() || source.isClass());
        return FunctionType.builder(this).forConstructor().withName(name).withSourceNode(source).withParamsNode(parameters).withReturnType(returnType).withTemplateKeys(templateKeys).withIsAbstract(isAbstract).build();
    }

    public FunctionType createInterfaceType(String name, Node source, ImmutableList<TemplateType> templateKeys, boolean struct) {
        FunctionType fn = FunctionType.builder(this).forInterface().withName(name).withSourceNode(source).withEmptyParams().withTemplateKeys(templateKeys).build();
        if (struct) {
            fn.setStruct();
        }
        return fn;
    }

    public TemplateType createTemplateType(String name) {
        return new TemplateType(this, name);
    }

    public TemplateType createTemplateTypeWithTransformation(String name, Node expr) {
        return new TemplateType(this, name, expr);
    }

    public TemplateTypeMap createTemplateTypeMap(ImmutableList<TemplateType> templateKeys, ImmutableList<JSType> templateValues) {
        if (templateKeys == null) {
            templateKeys = ImmutableList.of();
        }
        if (templateValues == null) {
            templateValues = ImmutableList.of();
        }
        return templateKeys.isEmpty() && templateValues.isEmpty() ? this.emptyTemplateTypeMap : new TemplateTypeMap(this, templateKeys, templateValues);
    }

    public ObjectType instantiateGenericsWithUnknown(ObjectType obj) {
        if (obj.isTemplatizedType()) {
            ImmutableList.Builder unknowns = ImmutableList.builder();
            for (TemplateType unused : obj.getTemplateTypeMap().getTemplateKeys()) {
                unknowns.add(this.getNativeType(JSTypeNative.UNKNOWN_TYPE));
            }
            return this.createTemplatizedType(obj.toMaybeTemplatizedType().getRawType(), (ImmutableList<JSType>)unknowns.build());
        }
        return obj;
    }

    public JSType instantiateGenericType(ObjectType genericType, ImmutableList<JSType> typeArgs) {
        return this.createTemplatizedType(genericType, typeArgs);
    }

    public TemplatizedType createTemplatizedType(ObjectType baseType, ImmutableList<JSType> templatizedTypes) {
        return new TemplatizedType(this, baseType, templatizedTypes);
    }

    public TemplatizedType createTemplatizedType(ObjectType baseType, Map<TemplateType, JSType> templatizedTypes) {
        ImmutableList.Builder builder = ImmutableList.builder();
        TemplateTypeMap baseTemplateTypeMap = baseType.getTemplateTypeMap();
        for (TemplateType key : baseTemplateTypeMap.getUnfilledTemplateKeys()) {
            JSType templatizedType = templatizedTypes.containsKey(key) ? templatizedTypes.get(key) : this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
            builder.add(templatizedType);
        }
        return this.createTemplatizedType(baseType, (ImmutableList<JSType>)builder.build());
    }

    public TemplatizedType createTemplatizedType(ObjectType baseType, JSType ... templatizedTypes) {
        return this.createTemplatizedType(baseType, ImmutableList.copyOf(templatizedTypes));
    }

    @VisibleForTesting
    public NamedType createNamedType(StaticTypedScope scope, String reference, String sourceName, int lineno, int charno) {
        return new NamedType(scope, this, reference, sourceName, lineno, charno);
    }

    public void identifyNonNullableName(StaticScope scope, String name) {
        Preconditions.checkNotNull(name);
        StaticScope lookupScope = JSTypeRegistry.getLookupScope(scope, name);
        this.nonNullableTypeNames.put(this.getRootNodeForScope(lookupScope), name);
    }

    public boolean isNonNullableName(StaticScope scope, String name) {
        Preconditions.checkNotNull(name);
        scope = JSTypeRegistry.getLookupScope(scope, name);
        return this.nonNullableTypeNames.containsEntry(this.getRootNodeForScope(scope), name);
    }

    public JSType evaluateTypeExpression(JSTypeExpression expr, StaticTypedScope scope) {
        return this.createTypeFromCommentNode(expr.getRoot(), expr.getSourceName(), scope);
    }

    public JSType createTypeFromCommentNode(Node n) {
        return this.createTypeFromCommentNode(n, "[internal]", null);
    }

    public JSType createTypeFromCommentNode(Node n, String sourceName, StaticTypedScope scope) {
        return this.createFromTypeNodesInternal(n, sourceName, scope, true);
    }

    private JSType createFromTypeNodesInternal(Node n, String sourceName, StaticTypedScope scope, boolean recordUnresolvedTypes) {
        switch (n.getToken()) {
            case LC: {
                return this.createRecordTypeFromNodes(n.getFirstChild(), sourceName, scope);
            }
            case BANG: {
                JSType child = this.createFromTypeNodesInternal(n.getFirstChild(), sourceName, scope, recordUnresolvedTypes);
                if (child instanceof NamedType) {
                    JSType type = ((NamedType)child).getBangType();
                    if (type instanceof NamedType && recordUnresolvedTypes && type != child) {
                        this.unresolvedNamedTypes.add((NamedType)type);
                    }
                    return type;
                }
                return child.restrictByNotNullOrUndefined();
            }
            case QMARK: {
                Node firstChild = n.getFirstChild();
                if (firstChild == null) {
                    return this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
                }
                return this.createNullableType(this.createFromTypeNodesInternal(firstChild, sourceName, scope, recordUnresolvedTypes));
            }
            case EQUALS: {
                return this.createOptionalType(this.createFromTypeNodesInternal(n.getFirstChild(), sourceName, scope, recordUnresolvedTypes));
            }
            case ELLIPSIS: {
                return this.createFromTypeNodesInternal(n.getFirstChild(), sourceName, scope, recordUnresolvedTypes);
            }
            case STAR: {
                return this.getNativeType(JSTypeNative.ALL_TYPE);
            }
            case PIPE: {
                UnionTypeBuilder builder = UnionTypeBuilder.create(this);
                for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
                    builder.addAlternate(this.createFromTypeNodesInternal(child, sourceName, scope, recordUnresolvedTypes));
                }
                return builder.build();
            }
            case EMPTY: {
                return this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
            }
            case VOID: {
                return this.getNativeType(JSTypeNative.VOID_TYPE);
            }
            case TYPEOF: {
                String name = n.getFirstChild().getString();
                QualifiedName qname = QualifiedName.of(name);
                String root = qname.getRoot();
                StaticScope declarationScope = scope.getTopmostScopeOfEventualDeclaration(root);
                StaticTypedSlot rootSlot = scope.getSlot(root);
                JSType type = scope.lookupQualifiedName(qname);
                if (type == null || type.isUnknownType() || rootSlot.getScope() != declarationScope) {
                    return this.getType(scope, "typeof " + n.getFirstChild().getString(), sourceName, n.getLineno(), n.getCharno(), recordUnresolvedTypes);
                }
                if (type.isLiteralObject()) {
                    JSType scopeType = type;
                    type = this.createNamedType(scope, "typeof " + name, sourceName, n.getLineno(), n.getCharno());
                    ((NamedType)type).setReferencedType(scopeType);
                }
                return type;
            }
            case STRING: 
            case NAME: {
                JSType namedType = this.getType(scope, n.getString(), sourceName, n.getLineno(), n.getCharno(), recordUnresolvedTypes);
                if (namedType instanceof ObjectType && !this.isNonNullableName(scope, n.getString())) {
                    Node typeList = n.getFirstChild();
                    boolean isForwardDeclared = namedType instanceof NamedType;
                    if ((!namedType.isUnknownType() || isForwardDeclared) && typeList != null) {
                        ImmutableList.Builder templateTypes = ImmutableList.builder();
                        if ((n.getString().equals("Object") || n.getString().equals("window.Object")) && typeList.hasZeroOrOneChild()) {
                            templateTypes.add(this.getNativeType(JSTypeNative.UNKNOWN_TYPE));
                        }
                        int nAllowedTypes = isForwardDeclared ? Integer.MAX_VALUE : namedType.getTemplateTypeMap().numUnfilledTemplateKeys();
                        boolean recordTemplateArgs = recordUnresolvedTypes && !isForwardDeclared;
                        int templateNodeIndex = 0;
                        for (Node templateNode : typeList.children()) {
                            if (++templateNodeIndex > nAllowedTypes) {
                                this.reporter.warning("Too many template parameters", sourceName, templateNode.getLineno(), templateNode.getCharno());
                                break;
                            }
                            templateTypes.add(this.createFromTypeNodesInternal(templateNode, sourceName, scope, recordTemplateArgs));
                        }
                        namedType = isForwardDeclared ? new NamedType(scope, this, n.getString(), sourceName, n.getLineno(), n.getCharno(), (ImmutableList<JSType>)templateTypes.build()) : this.createTemplatizedType((ObjectType)namedType, (ImmutableList<JSType>)templateTypes.build());
                        Preconditions.checkNotNull(namedType);
                    }
                    return this.createDefaultObjectUnion(namedType);
                }
                return namedType;
            }
            case FUNCTION: {
                JSType thisType = null;
                boolean isConstructor = false;
                Node current = n.getFirstChild();
                if (current.isThis() || current.isNew()) {
                    Node contextNode = current.getFirstChild();
                    JSType candidateThisType = this.createFromTypeNodesInternal(contextNode, sourceName, scope, recordUnresolvedTypes);
                    if (candidateThisType.isNullType() || candidateThisType.isVoidType()) {
                        thisType = candidateThisType;
                    } else if (current.isThis()) {
                        thisType = candidateThisType.restrictByNotNullOrUndefined();
                    } else if (current.isNew() && (thisType = ObjectType.cast(candidateThisType.restrictByNotNullOrUndefined())) == null) {
                        this.reporter.warning(SimpleErrorReporter.getMessage0("msg.jsdoc.function.newnotobject"), sourceName, contextNode.getLineno(), contextNode.getCharno());
                    }
                    isConstructor = current.getToken() == Token.NEW;
                    current = current.getNext();
                }
                FunctionParamBuilder paramBuilder = new FunctionParamBuilder(this);
                if (current.getToken() == Token.PARAM_LIST) {
                    for (Node arg = current.getFirstChild(); arg != null; arg = arg.getNext()) {
                        if (arg.getToken() == Token.ELLIPSIS) {
                            if (!arg.hasChildren()) {
                                paramBuilder.addVarArgs(this.getNativeType(JSTypeNative.UNKNOWN_TYPE));
                                continue;
                            }
                            paramBuilder.addVarArgs(this.createFromTypeNodesInternal(arg.getFirstChild(), sourceName, scope, recordUnresolvedTypes));
                            continue;
                        }
                        JSType type = this.createFromTypeNodesInternal(arg, sourceName, scope, recordUnresolvedTypes);
                        if (arg.getToken() == Token.EQUALS) {
                            boolean addSuccess = paramBuilder.addOptionalParams(type);
                            if (addSuccess) continue;
                            this.reporter.warning(SimpleErrorReporter.getMessage0("msg.jsdoc.function.varargs"), sourceName, arg.getLineno(), arg.getCharno());
                            continue;
                        }
                        paramBuilder.addRequiredParams(type);
                    }
                    current = current.getNext();
                }
                JSType returnType = this.createFromTypeNodesInternal(current, sourceName, scope, recordUnresolvedTypes);
                return FunctionType.builder(this).withParamsNode(paramBuilder.build()).withReturnType(returnType).withTypeOfThis(thisType).withKind(isConstructor ? FunctionType.Kind.CONSTRUCTOR : FunctionType.Kind.ORDINARY).build();
            }
        }
        throw new IllegalStateException("Unexpected node in type expression: " + n);
    }

    private JSType createRecordTypeFromNodes(Node n, String sourceName, StaticTypedScope scope) {
        RecordTypeBuilder builder = new RecordTypeBuilder(this);
        for (Node fieldTypeNode = n.getFirstChild(); fieldTypeNode != null; fieldTypeNode = fieldTypeNode.getNext()) {
            String fieldName;
            Node fieldNameNode = fieldTypeNode;
            boolean hasType = false;
            if (fieldTypeNode.getToken() == Token.COLON) {
                fieldNameNode = fieldTypeNode.getFirstChild();
                hasType = true;
            }
            if ((fieldName = fieldNameNode.getString()).startsWith("'") || fieldName.startsWith("\"")) {
                fieldName = fieldName.substring(1, fieldName.length() - 1);
            }
            JSType fieldType = null;
            fieldType = hasType ? this.createFromTypeNodesInternal(fieldTypeNode.getLastChild(), sourceName, scope, true) : this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
            builder.addProperty(fieldName, fieldType, fieldNameNode);
        }
        return builder.build();
    }

    public void registerTemplateTypeNamesInScope(Iterable<TemplateType> keys, Node scopeRoot) {
        for (TemplateType key : keys) {
            this.scopedNameTable.put(scopeRoot, key.getReferenceName(), key);
        }
    }

    public StaticTypedScope createScopeWithTemplates(StaticTypedScope scope, Iterable<TemplateType> templates) {
        return new SyntheticTemplateScope(scope, templates);
    }

    @GwtIncompatible(value="ObjectOutputStream")
    public void saveContents(ObjectOutputStream out) throws IOException {
        out.writeObject(this.eachRefTypeIndexedByProperty);
        out.writeObject(this.interfaceToImplementors);
        out.writeObject(this.typesIndexedByProperty);
    }

    @GwtIncompatible(value="ObjectInputStream")
    public void restoreContents(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.eachRefTypeIndexedByProperty = (Map)in.readObject();
        this.interfaceToImplementors = (Multimap)in.readObject();
        this.typesIndexedByProperty = (Multimap)in.readObject();
    }

    private FunctionType.Builder nativeConstructorBuilder(String name) {
        return FunctionType.builder(this).forNativeType().forConstructor().withName(name);
    }

    private FunctionType nativeInterface(String name, TemplateType ... templateKeys) {
        FunctionType.Builder builder = FunctionType.builder(this).forNativeType().forInterface().withName(name);
        if (templateKeys.length > 0) {
            builder.withTemplateKeys(templateKeys);
        }
        return builder.build();
    }

    private FunctionType nativeRecord(String name, TemplateType ... templateKeys) {
        FunctionType type = this.nativeInterface(name, templateKeys);
        type.setImplicitMatch(true);
        return type;
    }

    public void registerClosureModule(String moduleName, Node definitionNode, JSType type) {
        this.moduleToSlotMap.put(moduleName, ModuleSlot.create(false, definitionNode, type));
    }

    public void registerLegacyClosureModule(String moduleName) {
        this.moduleToSlotMap.put(moduleName, ModuleSlot.create(true, null, null));
    }

    ModuleSlot getModuleSlot(String moduleName) {
        return this.moduleToSlotMap.get(moduleName);
    }

    static abstract class ModuleSlot {
        ModuleSlot() {
        }

        abstract boolean isLegacyModule();

        @Nullable
        abstract Node definitionNode();

        @Nullable
        abstract JSType type();

        static ModuleSlot create(boolean isLegacy, Node definitionNode, JSType type) {
            return new AutoValue_JSTypeRegistry_ModuleSlot(isLegacy, definitionNode, type);
        }
    }

    private static class SyntheticTemplateScope
    implements StaticTypedScope,
    Serializable {
        final StaticTypedScope delegate;
        final PMap<String, TemplateType> types;

        SyntheticTemplateScope(StaticTypedScope delegate, Iterable<TemplateType> templates) {
            this.delegate = delegate;
            PMap<String, TemplateType> types = delegate instanceof SyntheticTemplateScope ? ((SyntheticTemplateScope)delegate).types : HamtPMap.empty();
            for (TemplateType key : templates) {
                types = types.plus(key.getReferenceName(), key);
            }
            this.types = types;
        }

        @Override
        public Node getRootNode() {
            return this.delegate.getRootNode();
        }

        @Override
        public StaticTypedScope getParentScope() {
            return this.delegate.getParentScope();
        }

        @Override
        public StaticTypedSlot getSlot(String name) {
            return this.delegate.getSlot(name);
        }

        @Override
        public StaticTypedSlot getOwnSlot(String name) {
            return this.delegate.getOwnSlot(name);
        }

        @Override
        public JSType getTypeOfThis() {
            return this.delegate.getTypeOfThis();
        }

        @Nullable
        TemplateType getTemplateType(String name) {
            return this.types.get(name);
        }

        @Override
        public StaticScope getTopmostScopeOfEventualDeclaration(String name) {
            if (this.types.get(name) != null) {
                return this;
            }
            return this.delegate.getTopmostScopeOfEventualDeclaration(name);
        }
    }

    public static enum PropDefinitionKind {
        UNKNOWN,
        KNOWN,
        LOOSE,
        LOOSE_UNION;

    }
}

