/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.client;

import com.google.gwt.core.client.Callback;
import com.google.gwt.core.client.JavaScriptObject;

public class ScriptInjector {
    public static final JavaScriptObject TOP_WINDOW = ScriptInjector.nativeTopWindow();

    public static FromString fromString(String scriptBody) {
        return new FromString(scriptBody);
    }

    public static FromUrl fromUrl(String scriptUrl) {
        return new FromUrl(scriptUrl);
    }

    private static native void attachListeners(JavaScriptObject var0, Callback<Void, Exception> var1, boolean var2);

    private static native void nativeAttachToHead(JavaScriptObject var0, JavaScriptObject var1);

    private static native JavaScriptObject nativeDefaultWindow();

    private static native JavaScriptObject nativeGetDocument(JavaScriptObject var0);

    private static native JavaScriptObject nativeMakeScriptElement(JavaScriptObject var0);

    private static native void nativeRemove(JavaScriptObject var0);

    private static native void nativeSetSrc(JavaScriptObject var0, String var1);

    private static native void nativeSetText(JavaScriptObject var0, String var1);

    private static native void nativePropagateScriptNonceIfPossible(JavaScriptObject var0, JavaScriptObject var1);

    private static native JavaScriptObject nativeTopWindow();

    private ScriptInjector() {
    }

    public static class FromUrl {
        private Callback<Void, Exception> callback;
        private boolean removeTag = false;
        private final String scriptUrl;
        private JavaScriptObject window;

        private FromUrl(String scriptUrl) {
            this.scriptUrl = scriptUrl;
        }

        public JavaScriptObject inject() {
            JavaScriptObject wnd;
            JavaScriptObject javaScriptObject = wnd = this.window == null ? ScriptInjector.nativeDefaultWindow() : this.window;
            assert (wnd != null);
            JavaScriptObject doc = ScriptInjector.nativeGetDocument(wnd);
            assert (doc != null);
            JavaScriptObject scriptElement = ScriptInjector.nativeMakeScriptElement(doc);
            assert (scriptElement != null);
            if (this.callback != null || this.removeTag) {
                ScriptInjector.attachListeners(scriptElement, this.callback, this.removeTag);
            }
            ScriptInjector.nativeSetSrc(scriptElement, this.scriptUrl);
            ScriptInjector.nativePropagateScriptNonceIfPossible(doc, scriptElement);
            ScriptInjector.nativeAttachToHead(doc, scriptElement);
            return scriptElement;
        }

        public FromUrl setCallback(Callback<Void, Exception> callback) {
            this.callback = callback;
            return this;
        }

        public FromUrl setRemoveTag(boolean removeTag) {
            this.removeTag = removeTag;
            return this;
        }

        public FromUrl setWindow(JavaScriptObject window) {
            this.window = window;
            return this;
        }
    }

    public static class FromString {
        private boolean removeTag = true;
        private final String scriptBody;
        private JavaScriptObject window;

        public FromString(String scriptBody) {
            this.scriptBody = scriptBody;
        }

        public JavaScriptObject inject() {
            JavaScriptObject wnd;
            JavaScriptObject javaScriptObject = wnd = this.window == null ? ScriptInjector.nativeDefaultWindow() : this.window;
            assert (wnd != null);
            JavaScriptObject doc = ScriptInjector.nativeGetDocument(wnd);
            assert (doc != null);
            JavaScriptObject scriptElement = ScriptInjector.nativeMakeScriptElement(doc);
            assert (scriptElement != null);
            ScriptInjector.nativeSetText(scriptElement, this.scriptBody);
            ScriptInjector.nativePropagateScriptNonceIfPossible(doc, scriptElement);
            ScriptInjector.nativeAttachToHead(doc, scriptElement);
            if (this.removeTag) {
                ScriptInjector.nativeRemove(scriptElement);
            }
            return scriptElement;
        }

        public FromString setRemoveTag(boolean removeTag) {
            this.removeTag = removeTag;
            return this;
        }

        public FromString setWindow(JavaScriptObject window) {
            this.window = window;
            return this;
        }
    }
}

