/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.server.rpc;

import com.google.gwt.user.client.rpc.IncompatibleRemoteServiceException;
import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RpcToken;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.server.rpc.RPCRequest;
import com.google.gwt.user.server.rpc.RPCServletUtils;
import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.google.gwt.user.server.rpc.SerializationPolicyProvider;
import com.google.gwt.user.server.rpc.UnexpectedException;
import com.google.gwt.user.server.rpc.impl.DequeMap;
import com.google.gwt.user.server.rpc.impl.LegacySerializationPolicy;
import com.google.gwt.user.server.rpc.impl.SerializabilityUtil;
import com.google.gwt.user.server.rpc.impl.ServerSerializationStreamReader;
import com.google.gwt.user.server.rpc.impl.ServerSerializationStreamWriter;
import com.google.gwt.user.server.rpc.impl.TypeNameObfuscator;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class RPC {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_WRAPPER_CLASS_TO_PRIMITIVE_CLASS = new HashMap();
    private static Map<Class<?>, Set<String>> serviceToImplementedInterfacesMap;
    private static final HashMap<String, Class<?>> TYPE_NAMES;

    public static RPCRequest decodeRequest(String encodedRequest) {
        return RPC.decodeRequest(encodedRequest, null);
    }

    public static RPCRequest decodeRequest(String encodedRequest, Class<?> type) {
        return RPC.decodeRequest(encodedRequest, type, null);
    }

    public static RPCRequest decodeRequest(String encodedRequest, Class<?> type, SerializationPolicyProvider serializationPolicyProvider) {
        if (encodedRequest == null) {
            throw new NullPointerException("encodedRequest cannot be null");
        }
        if (encodedRequest.length() == 0) {
            throw new IllegalArgumentException("encodedRequest cannot be empty");
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> serviceIntf;
            ServerSerializationStreamReader streamReader = new ServerSerializationStreamReader(classLoader, serializationPolicyProvider);
            streamReader.prepareToRead(encodedRequest);
            RpcToken rpcToken = null;
            if (streamReader.hasFlags(2)) {
                rpcToken = (RpcToken)streamReader.deserializeValue(RpcToken.class);
            }
            String serviceIntfName = RPC.maybeDeobfuscate(streamReader, streamReader.readString());
            if (type != null && !RPC.implementsInterface(type, serviceIntfName)) {
                throw new IncompatibleRemoteServiceException("Blocked attempt to access interface '" + serviceIntfName + "', which is not implemented by '" + RPC.printTypeName(type) + "'; this is either misconfiguration or a hack attempt");
            }
            SerializationPolicy serializationPolicy = streamReader.getSerializationPolicy();
            try {
                serviceIntf = RPC.getClassFromSerializedName(serviceIntfName, classLoader);
                if (!RemoteService.class.isAssignableFrom(serviceIntf)) {
                    throw new IncompatibleRemoteServiceException("Blocked attempt to access interface '" + RPC.printTypeName(serviceIntf) + "', which doesn't extend RemoteService; this is either misconfiguration or a hack attempt");
                }
            }
            catch (ClassNotFoundException e) {
                throw new IncompatibleRemoteServiceException("Could not locate requested interface '" + serviceIntfName + "' in default classloader", e);
            }
            String serviceMethodName = streamReader.readString();
            int paramCount = streamReader.readInt();
            if (paramCount > streamReader.getNumberOfTokens()) {
                throw new IncompatibleRemoteServiceException("Invalid number of parameters");
            }
            Class[] parameterTypes = new Class[paramCount];
            for (int i = 0; i < parameterTypes.length; ++i) {
                String paramClassName = RPC.maybeDeobfuscate(streamReader, streamReader.readString());
                try {
                    parameterTypes[i] = RPC.getClassFromSerializedName(paramClassName, classLoader);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new IncompatibleRemoteServiceException("Parameter " + i + " of is of an unknown type '" + paramClassName + "'", e);
                }
            }
            try {
                TypeVariable<Method>[] methodTypes;
                Method method = serviceIntf.getMethod(serviceMethodName, parameterTypes);
                Type[] methodParameterTypes = method.getGenericParameterTypes();
                DequeMap resolvedTypes = new DequeMap();
                for (TypeVariable<Method> methodType : methodTypes = method.getTypeParameters()) {
                    SerializabilityUtil.resolveTypes(methodType, resolvedTypes);
                }
                Object[] parameterValues = new Object[parameterTypes.length];
                for (int i = 0; i < parameterValues.length; ++i) {
                    parameterValues[i] = streamReader.deserializeValue(parameterTypes[i], methodParameterTypes[i], resolvedTypes);
                }
                return new RPCRequest(method, parameterValues, rpcToken, serializationPolicy, streamReader.getFlags());
            }
            catch (NoSuchMethodException e) {
                throw new IncompatibleRemoteServiceException(RPC.formatMethodNotFoundErrorMessage(serviceIntf, serviceMethodName, parameterTypes));
            }
        }
        catch (SerializationException ex) {
            throw new IncompatibleRemoteServiceException(ex.getMessage(), ex);
        }
    }

    public static String encodeResponseForFailedRequest(RPCRequest rpcRequest, Throwable cause) throws SerializationException {
        if (rpcRequest == null) {
            return RPC.encodeResponseForFailure(null, cause, RPC.getDefaultSerializationPolicy(), 0);
        }
        return RPC.encodeResponseForFailure(null, cause, rpcRequest.getSerializationPolicy(), rpcRequest.getFlags());
    }

    public static String encodeResponseForFailure(Method serviceMethod, Throwable cause) throws SerializationException {
        return RPC.encodeResponseForFailure(serviceMethod, cause, RPC.getDefaultSerializationPolicy());
    }

    public static String encodeResponseForFailure(Method serviceMethod, Throwable cause, SerializationPolicy serializationPolicy) throws SerializationException {
        return RPC.encodeResponseForFailure(serviceMethod, cause, serializationPolicy, 0);
    }

    public static String encodeResponseForFailure(Method serviceMethod, Throwable cause, SerializationPolicy serializationPolicy, int flags) throws SerializationException {
        if (cause == null) {
            throw new NullPointerException("cause cannot be null");
        }
        if (serializationPolicy == null) {
            throw new NullPointerException("serializationPolicy");
        }
        if (serviceMethod != null && !RPCServletUtils.isExpectedException(serviceMethod, cause)) {
            throw new UnexpectedException("Service method '" + RPC.getSourceRepresentation(serviceMethod) + "' threw an unexpected exception: " + cause.toString(), cause);
        }
        return RPC.encodeResponse(cause.getClass(), cause, true, flags, serializationPolicy);
    }

    public static String encodeResponseForSuccess(Method serviceMethod, Object object) throws SerializationException {
        return RPC.encodeResponseForSuccess(serviceMethod, object, RPC.getDefaultSerializationPolicy());
    }

    public static String encodeResponseForSuccess(Method serviceMethod, Object object, SerializationPolicy serializationPolicy) throws SerializationException {
        return RPC.encodeResponseForSuccess(serviceMethod, object, serializationPolicy, 0);
    }

    public static String encodeResponseForSuccess(Method serviceMethod, Object object, SerializationPolicy serializationPolicy, int flags) throws SerializationException {
        Class<?> actualReturnType;
        if (serviceMethod == null) {
            throw new NullPointerException("serviceMethod cannot be null");
        }
        if (serializationPolicy == null) {
            throw new NullPointerException("serializationPolicy");
        }
        Class<?> methodReturnType = serviceMethod.getReturnType();
        if (!(methodReturnType == Void.TYPE || object == null || (actualReturnType = methodReturnType.isPrimitive() ? RPC.getPrimitiveClassFromWrapper(object.getClass()) : object.getClass()) != null && methodReturnType.isAssignableFrom(actualReturnType))) {
            throw new IllegalArgumentException("Type '" + RPC.printTypeName(object.getClass()) + "' does not match the return type in the method's signature: '" + RPC.getSourceRepresentation(serviceMethod) + "'");
        }
        return RPC.encodeResponse(methodReturnType, object, false, flags, serializationPolicy);
    }

    public static SerializationPolicy getDefaultSerializationPolicy() {
        return LegacySerializationPolicy.getInstance();
    }

    public static String invokeAndEncodeResponse(Object target, Method serviceMethod, Object[] args) throws SerializationException {
        return RPC.invokeAndEncodeResponse(target, serviceMethod, args, RPC.getDefaultSerializationPolicy());
    }

    public static String invokeAndEncodeResponse(Object target, Method serviceMethod, Object[] args, SerializationPolicy serializationPolicy) throws SerializationException {
        return RPC.invokeAndEncodeResponse(target, serviceMethod, args, serializationPolicy, 0);
    }

    public static String invokeAndEncodeResponse(Object target, Method serviceMethod, Object[] args, SerializationPolicy serializationPolicy, int flags) throws SerializationException {
        String responsePayload;
        if (serviceMethod == null) {
            throw new NullPointerException("serviceMethod");
        }
        if (serializationPolicy == null) {
            throw new NullPointerException("serializationPolicy");
        }
        try {
            Object result = serviceMethod.invoke(target, args);
            responsePayload = RPC.encodeResponseForSuccess(serviceMethod, result, serializationPolicy, flags);
        }
        catch (IllegalAccessException e) {
            SecurityException securityException = new SecurityException(RPC.formatIllegalAccessErrorMessage(target, serviceMethod));
            securityException.initCause(e);
            throw securityException;
        }
        catch (IllegalArgumentException e) {
            SecurityException securityException = new SecurityException(RPC.formatIllegalArgumentErrorMessage(target, serviceMethod, args));
            securityException.initCause(e);
            throw securityException;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            responsePayload = RPC.encodeResponseForFailure(serviceMethod, cause, serializationPolicy, flags);
        }
        return responsePayload;
    }

    private static int getRpcVersion() throws SerializationException {
        int version = Integer.getInteger("gwt.rpc.version", 7);
        if (version < 5 || version > 8) {
            throw new SerializationException("The RPC version " + version + " is not between " + 5 + " and " + 8);
        }
        return version;
    }

    private static String encodeResponse(Class<?> responseClass, Object object, boolean wasThrown, int flags, SerializationPolicy serializationPolicy) throws SerializationException {
        ServerSerializationStreamWriter stream = new ServerSerializationStreamWriter(serializationPolicy, RPC.getRpcVersion());
        stream.setFlags(flags);
        stream.prepareToWrite();
        if (responseClass != Void.TYPE) {
            stream.serializeValue(object, responseClass);
        }
        String bufferStr = (wasThrown ? "//EX" : "//OK") + stream.toString();
        return bufferStr;
    }

    private static String formatIllegalAccessErrorMessage(Object target, Method serviceMethod) {
        StringBuffer sb = new StringBuffer();
        sb.append("Blocked attempt to access inaccessible method '");
        sb.append(RPC.getSourceRepresentation(serviceMethod));
        sb.append("'");
        if (target != null) {
            sb.append(" on target '");
            sb.append(RPC.printTypeName(target.getClass()));
            sb.append("'");
        }
        sb.append("; this is either misconfiguration or a hack attempt");
        return sb.toString();
    }

    private static String formatIllegalArgumentErrorMessage(Object target, Method serviceMethod, Object[] args) {
        StringBuffer sb = new StringBuffer();
        sb.append("Blocked attempt to invoke method '");
        sb.append(RPC.getSourceRepresentation(serviceMethod));
        sb.append("'");
        if (target != null) {
            sb.append(" on target '");
            sb.append(RPC.printTypeName(target.getClass()));
            sb.append("'");
        }
        sb.append(" with invalid arguments");
        if (args != null && args.length > 0) {
            sb.append(Arrays.asList(args));
        }
        return sb.toString();
    }

    private static String formatMethodNotFoundErrorMessage(Class<?> serviceIntf, String serviceMethodName, Class<?>[] parameterTypes) {
        StringBuffer sb = new StringBuffer();
        sb.append("Could not locate requested method '");
        sb.append(serviceMethodName);
        sb.append("(");
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(RPC.printTypeName(parameterTypes[i]));
        }
        sb.append(")'");
        sb.append(" in interface '");
        sb.append(RPC.printTypeName(serviceIntf));
        sb.append("'");
        return sb.toString();
    }

    private static Class<?> getClassFromSerializedName(String serializedName, ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> value = TYPE_NAMES.get(serializedName);
        if (value != null) {
            return value;
        }
        return Class.forName(serializedName, false, classLoader);
    }

    private static Class<?> getPrimitiveClassFromWrapper(Class<?> wrapperClass) {
        return PRIMITIVE_WRAPPER_CLASS_TO_PRIMITIVE_CLASS.get(wrapperClass);
    }

    private static String getSourceRepresentation(Method method) {
        return method.toString().replace('$', '.');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean implementsInterface(Class<?> service, String intfName) {
        Map<Class<?>, Set<String>> map = serviceToImplementedInterfacesMap;
        synchronized (map) {
            Set<String> interfaceSet = serviceToImplementedInterfacesMap.get(service);
            if (interfaceSet != null) {
                if (interfaceSet.contains(intfName)) {
                    return true;
                }
            } else {
                interfaceSet = new HashSet<String>();
                serviceToImplementedInterfacesMap.put(service, interfaceSet);
            }
            if (!service.isInterface()) {
                while (service != null && !RemoteServiceServlet.class.equals(service)) {
                    Class<?>[] intfs;
                    for (Class<?> intf : intfs = service.getInterfaces()) {
                        if (!RPC.implementsInterfaceRecursive(intf, intfName)) continue;
                        interfaceSet.add(intfName);
                        return true;
                    }
                    service = service.getSuperclass();
                }
            } else if (RPC.implementsInterfaceRecursive(service, intfName)) {
                interfaceSet.add(intfName);
                return true;
            }
            return false;
        }
    }

    private static boolean implementsInterfaceRecursive(Class<?> clazz, String intfName) {
        Class<?>[] intfs;
        assert (clazz.isInterface());
        if (clazz.getName().equals(intfName)) {
            return true;
        }
        for (Class<?> intf : intfs = clazz.getInterfaces()) {
            if (!RPC.implementsInterfaceRecursive(intf, intfName)) continue;
            return true;
        }
        return false;
    }

    private static String maybeDeobfuscate(ServerSerializationStreamReader streamReader, String name) throws SerializationException {
        if (streamReader.hasFlags(1)) {
            SerializationPolicy serializationPolicy = streamReader.getSerializationPolicy();
            if (!(serializationPolicy instanceof TypeNameObfuscator)) {
                throw new IncompatibleRemoteServiceException("RPC request was encoded with obfuscated type names, but the SerializationPolicy in use does not implement " + TypeNameObfuscator.class.getName());
            }
            String maybe = ((TypeNameObfuscator)((Object)serializationPolicy)).getClassNameForTypeId(name);
            if (maybe != null) {
                return maybe;
            }
        } else {
            int index = name.indexOf(47);
            if (index != -1) {
                return name.substring(0, index);
            }
        }
        return name;
    }

    private static String printTypeName(Class<?> type) {
        if (type.equals(Integer.TYPE)) {
            return "int";
        }
        if (type.equals(Long.TYPE)) {
            return "long";
        }
        if (type.equals(Short.TYPE)) {
            return "short";
        }
        if (type.equals(Byte.TYPE)) {
            return "byte";
        }
        if (type.equals(Character.TYPE)) {
            return "char";
        }
        if (type.equals(Boolean.TYPE)) {
            return "boolean";
        }
        if (type.equals(Float.TYPE)) {
            return "float";
        }
        if (type.equals(Double.TYPE)) {
            return "double";
        }
        if (type.isArray()) {
            Class<?> componentType = type.getComponentType();
            return RPC.printTypeName(componentType) + "[]";
        }
        return type.getName().replace('$', '.');
    }

    private RPC() {
    }

    static {
        PRIMITIVE_WRAPPER_CLASS_TO_PRIMITIVE_CLASS.put(Boolean.class, Boolean.TYPE);
        PRIMITIVE_WRAPPER_CLASS_TO_PRIMITIVE_CLASS.put(Byte.class, Byte.TYPE);
        PRIMITIVE_WRAPPER_CLASS_TO_PRIMITIVE_CLASS.put(Character.class, Character.TYPE);
        PRIMITIVE_WRAPPER_CLASS_TO_PRIMITIVE_CLASS.put(Double.class, Double.TYPE);
        PRIMITIVE_WRAPPER_CLASS_TO_PRIMITIVE_CLASS.put(Float.class, Float.TYPE);
        PRIMITIVE_WRAPPER_CLASS_TO_PRIMITIVE_CLASS.put(Integer.class, Integer.TYPE);
        PRIMITIVE_WRAPPER_CLASS_TO_PRIMITIVE_CLASS.put(Long.class, Long.TYPE);
        PRIMITIVE_WRAPPER_CLASS_TO_PRIMITIVE_CLASS.put(Short.class, Short.TYPE);
        TYPE_NAMES = new HashMap();
        TYPE_NAMES.put("Z", Boolean.TYPE);
        TYPE_NAMES.put("B", Byte.TYPE);
        TYPE_NAMES.put("C", Character.TYPE);
        TYPE_NAMES.put("D", Double.TYPE);
        TYPE_NAMES.put("F", Float.TYPE);
        TYPE_NAMES.put("I", Integer.TYPE);
        TYPE_NAMES.put("J", Long.TYPE);
        TYPE_NAMES.put("S", Short.TYPE);
        serviceToImplementedInterfacesMap = new HashMap();
    }
}

