
### Intent

> Describe briefly what problem this pull request resolves, or what new feature it introduces. Include screenshots of any new or altered UI. Link to any Github issues that are related. 

### Approach

> Describe the approach taken and the tradeoffs involved if non-obvious; add an overview of the solution if it's complicated.

### Automated Tests

> Indicate whether this change includes unit tests or integration tests, or link a work item or pull request to add those tests to another repo. If the change cannot or will not be covered by a test, indicate why.

### QA Notes

> Add additional information for QA on how to validate the change, paying special attention to the level of risk, adjacent areas that could be affected by the change, and any important contextual information not present in the linked issues. 

### Checklist

- [ ] If this PR adds a new feature, or fixes a bug in a previously released version, it includes an entry in `NEWS.md` 
- [ ] If this PR adds or changes UI, the updated UI meets [accessibility standards](https://github.com/rstudio/rstudio/wiki/Accessibility)
- [ ] A reviewer is assigned to this PR (if unsure who to assign, check Area Owners list)
- [ ] This PR passes all local unit tests

<!-- Note for community contributors: Please sign our contributor agreement as described in CONTRIBUTING.md and note that you've done so in this space. Very much appreciate your contributions and support! -->


