## Filing Bugs

If you're experiencing behavior that appears to be a bug in RStudio, you're welcome to [file an issue](https://github.com/rstudio/rstudio/issues/new). Before you do, please go through this pre-flight checklist:

1. Is the source of the error or problem the RStudio IDE itself? Many errors you see inside RStudio come from R or R packages. If you're having trouble with R, read [Getting Help with R](https://www.r-project.org/help.html) for pointers.

2. Is your issue a bug rather than a question? If you're having general trouble with RStudio or have questions for the RStudio community, the [RStudio Community Forum](https://community.rstudio.com/c/rstudio-ide) is an excellent resource.

3. Are you the first person to report this issue? [Search the issue list](https://github.com/rstudio/rstudio/issues) to find out. If you aren't, the most helpful thing you can do is vote for the existing issue (add a +1 reaction to it), and optionally add a comment describing your own experience.

When you're ready to file an issue, see our [guide to writing good bug reports](https://github.com/rstudio/rstudio/wiki/Writing-Good-Bug-Reports) for more on how to write a great bug report.

## Enhancements

You're also welcome to submit ideas for enhancements to RStudio. When doing so, please [search the issue list](https://github.com/rstudio/rstudio/issues) to see if the enhancement has already been filed. If it has, vote for it (add a reaction to it) and optionally add a comment with your perspective on the idea. 

See our [guide to writing feature requests](https://github.com/rstudio/rstudio/wiki/Writing-Good-Feature-Requests) for more on how to write a great feature request.

## RStudio Pro

This repo contains the code for the open source version of RStudio and RStudio Server, and its issues page is for issues pertaining specifically to the open source version of the software. To report issues or request new features for the professional version of RStudio, please get in touch with the RStudio support team at <support@rstudio.com>.

## Contributing Code

We welcome contributions to RStudio. To submit a contribution:

1. [Fork](https://github.com/rstudio/rstudio/fork) the repository and make your changes.

2. Ensure that you have signed the [individual](https://rstudioblog.files.wordpress.com/2017/05/rstudio_individual_contributor_agreement.pdf) or [corporate](https://rstudioblog.files.wordpress.com/2017/05/rstudio_corporate_contributor_agreement.pdf) contributor agreement as appropriate. You can send the signed copy to jj@rstudio.com.

3. Submit a [pull request](https://help.github.com/articles/using-pull-requests).

We'll try to be as responsive as possible in reviewing and accepting pull requests. Appreciate your contributions very much!

## Code of Conduct

As contributors and maintainers of this project, we pledge to respect all people who contribute through reporting issues, posting feature requests, updating documentation, submitting pull requests or patches, and other activities.

We are committed to making participation in this project a harassment-free experience for everyone, regardless of level of experience, gender, gender identity and expression, sexual orientation, disability, personal appearance, body size, race, ethnicity, age, or religion.

Examples of unacceptable behavior by participants include the use of sexual language or imagery, derogatory comments or personal attacks, trolling, public or private harassment, insults, or other unprofessional conduct.

Project maintainers have the right and responsibility to remove, edit, or reject comments, commits, code, wiki edits, issues, and other contributions that are not aligned to this Code of Conduct. Project maintainers who do not follow the Code of Conduct may be removed from the project team.

Instances of abusive, harassing, or otherwise unacceptable behavior may be reported by opening an issue or contacting one or more of the project maintainers.

This Code of Conduct is adapted from the Contributor Covenant, version 1.0.0, available at <https://www.contributor-covenant.org/version/1/0/0/code-of-conduct.html>.

