/* UserPrefValues.hpp
 *
 * Copyright (C) 2022 by RStudio, PBC
 *
 * Unless you have received this program directly from RStudio pursuant
 * to the terms of a commercial license agreement with RStudio, then
 * this program is licensed to you under the terms of version 3 of the
 * GNU Affero General Public License. This program is distributed WITHOUT
 * ANY EXPRESS OR IMPLIED WARRANTY, INCLUDING THOSE OF NON-INFRINGEMENT,
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Please refer to the
 * AGPL (http://www.gnu.org/licenses/agpl-3.0.txt) for more details.
 *
 */
 
/* DO NOT HAND-EDIT! This file is automatically generated from the formal user preference schema
 * JSON. To add a preference, add it to "user-prefs-schema.json", then run "generate-prefs.R" to
 * rebuild this file.
 */

#ifndef SESSION_USER_PREF_VALUES_HPP
#define SESSION_USER_PREF_VALUES_HPP

#include <session/prefs/Preferences.hpp>

namespace rstudio {
namespace session {
namespace prefs {

#define kRunRprofileOnResume "run_rprofile_on_resume"
#define kSaveWorkspace "save_workspace"
#define kSaveWorkspaceAlways "always"
#define kSaveWorkspaceNever "never"
#define kSaveWorkspaceAsk "ask"
#define kLoadWorkspace "load_workspace"
#define kInitialWorkingDirectory "initial_working_directory"
#define kCranMirror "cran_mirror"
#define kCranMirrorName "name"
#define kCranMirrorHost "host"
#define kCranMirrorUrl "url"
#define kCranMirrorRepos "repos"
#define kCranMirrorCountry "country"
#define kCranMirrorSecondary "secondary"
#define kBioconductorMirrorName "bioconductor_mirror_name"
#define kBioconductorMirrorUrl "bioconductor_mirror_url"
#define kAlwaysSaveHistory "always_save_history"
#define kRemoveHistoryDuplicates "remove_history_duplicates"
#define kShowLastDotValue "show_last_dot_value"
#define kLineEndingConversion "line_ending_conversion"
#define kLineEndingConversionDefault "default"
#define kLineEndingConversionWindows "windows"
#define kLineEndingConversionPosix "posix"
#define kLineEndingConversionNative "native"
#define kLineEndingConversionPassthrough "passthrough"
#define kUseNewlinesInMakefiles "use_newlines_in_makefiles"
#define kWindowsTerminalShell "windows_terminal_shell"
#define kWindowsTerminalShellDefault "default"
#define kWindowsTerminalShellWinGitBash "win-git-bash"
#define kWindowsTerminalShellWinWslBash "win-wsl-bash"
#define kWindowsTerminalShellWinCmd "win-cmd"
#define kWindowsTerminalShellWinPs "win-ps"
#define kWindowsTerminalShellPsCore "ps-core"
#define kWindowsTerminalShellCustom "custom"
#define kWindowsTerminalShellNone "none"
#define kPosixTerminalShell "posix_terminal_shell"
#define kPosixTerminalShellDefault "default"
#define kPosixTerminalShellBash "bash"
#define kPosixTerminalShellZsh "zsh"
#define kPosixTerminalShellCustom "custom"
#define kPosixTerminalShellNone "none"
#define kCustomShellCommand "custom_shell_command"
#define kCustomShellOptions "custom_shell_options"
#define kShowLineNumbers "show_line_numbers"
#define kHighlightSelectedWord "highlight_selected_word"
#define kHighlightSelectedLine "highlight_selected_line"
#define kPanes "panes"
#define kPanesQuadrants "quadrants"
#define kPanesTabSet1 "tabSet1"
#define kPanesTabSet2 "tabSet2"
#define kPanesHiddenTabSet "hiddenTabSet"
#define kPanesConsoleLeftOnTop "console_left_on_top"
#define kPanesConsoleRightOnTop "console_right_on_top"
#define kPanesAdditionalSourceColumns "additional_source_columns"
#define kAllowSourceColumns "allow_source_columns"
#define kUseSpacesForTab "use_spaces_for_tab"
#define kNumSpacesForTab "num_spaces_for_tab"
#define kAutoDetectIndentation "auto_detect_indentation"
#define kShowMargin "show_margin"
#define kBlinkingCursor "blinking_cursor"
#define kMarginColumn "margin_column"
#define kShowInvisibles "show_invisibles"
#define kShowIndentGuides "show_indent_guides"
#define kContinueCommentsOnNewline "continue_comments_on_newline"
#define kHighlightWebLink "highlight_web_link"
#define kEditorKeybindings "editor_keybindings"
#define kEditorKeybindingsDefault "default"
#define kEditorKeybindingsVim "vim"
#define kEditorKeybindingsEmacs "emacs"
#define kEditorKeybindingsSublime "sublime"
#define kInsertMatching "insert_matching"
#define kInsertSpacesAroundEquals "insert_spaces_around_equals"
#define kInsertParensAfterFunctionCompletion "insert_parens_after_function_completion"
#define kTabMultilineCompletion "tab_multiline_completion"
#define kTabCompletion "tab_completion"
#define kShowHelpTooltipOnIdle "show_help_tooltip_on_idle"
#define kSurroundSelection "surround_selection"
#define kSurroundSelectionNever "never"
#define kSurroundSelectionQuotes "quotes"
#define kSurroundSelectionQuotesAndBrackets "quotes_and_brackets"
#define kEnableSnippets "enable_snippets"
#define kCodeCompletion "code_completion"
#define kCodeCompletionAlways "always"
#define kCodeCompletionNever "never"
#define kCodeCompletionTriggered "triggered"
#define kCodeCompletionManual "manual"
#define kCodeCompletionOther "code_completion_other"
#define kCodeCompletionOtherAlways "always"
#define kCodeCompletionOtherTriggered "triggered"
#define kCodeCompletionOtherManual "manual"
#define kConsoleCodeCompletion "console_code_completion"
#define kCodeCompletionDelay "code_completion_delay"
#define kCodeCompletionCharacters "code_completion_characters"
#define kShowFunctionSignatureTooltips "show_function_signature_tooltips"
#define kShowDiagnosticsR "show_diagnostics_r"
#define kShowDiagnosticsCpp "show_diagnostics_cpp"
#define kShowDiagnosticsYaml "show_diagnostics_yaml"
#define kShowDiagnosticsOther "show_diagnostics_other"
#define kStyleDiagnostics "style_diagnostics"
#define kDiagnosticsOnSave "diagnostics_on_save"
#define kBackgroundDiagnostics "background_diagnostics"
#define kBackgroundDiagnosticsDelayMs "background_diagnostics_delay_ms"
#define kDiagnosticsInRFunctionCalls "diagnostics_in_r_function_calls"
#define kCheckArgumentsToRFunctionCalls "check_arguments_to_r_function_calls"
#define kCheckUnexpectedAssignmentInFunctionCall "check_unexpected_assignment_in_function_call"
#define kWarnIfNoSuchVariableInScope "warn_if_no_such_variable_in_scope"
#define kWarnVariableDefinedButNotUsed "warn_variable_defined_but_not_used"
#define kAutoDiscoverPackageDependencies "auto_discover_package_dependencies"
#define kAutoAppendNewline "auto_append_newline"
#define kStripTrailingWhitespace "strip_trailing_whitespace"
#define kRestoreSourceDocumentCursorPosition "restore_source_document_cursor_position"
#define kReindentOnPaste "reindent_on_paste"
#define kVerticallyAlignArgumentsIndent "vertically_align_arguments_indent"
#define kSoftWrapRFiles "soft_wrap_r_files"
#define kSoftWrapRmdFiles "soft_wrap_rmd_files"
#define kFocusConsoleAfterExec "focus_console_after_exec"
#define kFoldStyle "fold_style"
#define kFoldStyleBeginOnly "begin-only"
#define kFoldStyleBeginAndEnd "begin-and-end"
#define kSaveBeforeSourcing "save_before_sourcing"
#define kSyntaxColorConsole "syntax_color_console"
#define kHighlightConsoleErrors "highlight_console_errors"
#define kScrollPastEndOfDocument "scroll_past_end_of_document"
#define kHighlightRFunctionCalls "highlight_r_function_calls"
#define kRainbowParentheses "rainbow_parentheses"
#define kConsoleLineLengthLimit "console_line_length_limit"
#define kConsoleMaxLines "console_max_lines"
#define kAnsiConsoleMode "ansi_console_mode"
#define kAnsiConsoleModeOff "off"
#define kAnsiConsoleModeOn "on"
#define kAnsiConsoleModeStrip "strip"
#define kLimitVisibleConsole "limit_visible_console"
#define kShowInlineToolbarForRCodeChunks "show_inline_toolbar_for_r_code_chunks"
#define kHighlightCodeChunks "highlight_code_chunks"
#define kSaveFilesBeforeBuild "save_files_before_build"
#define kFontSizePoints "font_size_points"
#define kHelpFontSizePoints "help_font_size_points"
#define kEditorTheme "editor_theme"
#define kServerEditorFontEnabled "server_editor_font_enabled"
#define kServerEditorFont "server_editor_font"
#define kDefaultEncoding "default_encoding"
#define kToolbarVisible "toolbar_visible"
#define kDefaultProjectLocation "default_project_location"
#define kSourceWithEcho "source_with_echo"
#define kDefaultSweaveEngine "default_sweave_engine"
#define kDefaultLatexProgram "default_latex_program"
#define kUseRoxygen "use_roxygen"
#define kUseDataimport "use_dataimport"
#define kPdfPreviewer "pdf_previewer"
#define kPdfPreviewerNone "none"
#define kPdfPreviewerDefault "default"
#define kPdfPreviewerRstudio "rstudio"
#define kPdfPreviewerDesktopSynctex "desktop-synctex"
#define kPdfPreviewerSystem "system"
#define kAlwaysEnableRnwConcordance "always_enable_rnw_concordance"
#define kInsertNumberedLatexSections "insert_numbered_latex_sections"
#define kSpellingDictionaryLanguage "spelling_dictionary_language"
#define kSpellingCustomDictionaries "spelling_custom_dictionaries"
#define kDocumentLoadLintDelay "document_load_lint_delay"
#define kIgnoreUppercaseWords "ignore_uppercase_words"
#define kIgnoreWordsWithNumbers "ignore_words_with_numbers"
#define kRealTimeSpellchecking "real_time_spellchecking"
#define kNavigateToBuildError "navigate_to_build_error"
#define kPackagesPaneEnabled "packages_pane_enabled"
#define kCppTemplate "cpp_template"
#define kRestoreSourceDocuments "restore_source_documents"
#define kHandleErrorsInUserCodeOnly "handle_errors_in_user_code_only"
#define kAutoExpandErrorTracebacks "auto_expand_error_tracebacks"
#define kCheckForUpdates "check_for_updates"
#define kShowInternalFunctions "show_internal_functions"
#define kShinyViewerType "shiny_viewer_type"
#define kShinyViewerTypeUser "user"
#define kShinyViewerTypeNone "none"
#define kShinyViewerTypePane "pane"
#define kShinyViewerTypeWindow "window"
#define kShinyViewerTypeBrowser "browser"
#define kShinyBackgroundJobs "shiny_background_jobs"
#define kPlumberViewerType "plumber_viewer_type"
#define kPlumberViewerTypeUser "user"
#define kPlumberViewerTypeNone "none"
#define kPlumberViewerTypePane "pane"
#define kPlumberViewerTypeWindow "window"
#define kPlumberViewerTypeBrowser "browser"
#define kDocumentAuthor "document_author"
#define kRmdAutoDate "rmd_auto_date"
#define kRmdPreferredTemplatePath "rmd_preferred_template_path"
#define kRmdViewerType "rmd_viewer_type"
#define kRmdViewerTypeWindow "window"
#define kRmdViewerTypePane "pane"
#define kRmdViewerTypeNone "none"
#define kShowPublishDiagnostics "show_publish_diagnostics"
#define kPublishCheckCertificates "publish_check_certificates"
#define kUsePublishCaBundle "use_publish_ca_bundle"
#define kPublishCaBundle "publish_ca_bundle"
#define kRmdChunkOutputInline "rmd_chunk_output_inline"
#define kShowDocOutlineRmd "show_doc_outline_rmd"
#define kAutoRunSetupChunk "auto_run_setup_chunk"
#define kHideConsoleOnChunkExecute "hide_console_on_chunk_execute"
#define kExecutionBehavior "execution_behavior"
#define kExecutionBehaviorLine "line"
#define kExecutionBehaviorStatement "statement"
#define kExecutionBehaviorParagraph "paragraph"
#define kShowTerminalTab "show_terminal_tab"
#define kTerminalLocalEcho "terminal_local_echo"
#define kTerminalWebsockets "terminal_websockets"
#define kTerminalCloseBehavior "terminal_close_behavior"
#define kTerminalCloseBehaviorAlways "always"
#define kTerminalCloseBehaviorClean "clean"
#define kTerminalCloseBehaviorNever "never"
#define kTerminalTrackEnvironment "terminal_track_environment"
#define kTerminalBellStyle "terminal_bell_style"
#define kTerminalBellStyleNone "none"
#define kTerminalBellStyleSound "sound"
#define kTerminalRenderer "terminal_renderer"
#define kTerminalRendererCanvas "canvas"
#define kTerminalRendererDom "dom"
#define kTerminalWeblinks "terminal_weblinks"
#define kShowRmdRenderCommand "show_rmd_render_command"
#define kEnableTextDrag "enable_text_drag"
#define kShowHiddenFiles "show_hidden_files"
#define kAlwaysShownFiles "always_shown_files"
#define kAlwaysShownExtensions "always_shown_extensions"
#define kSortFileNamesNaturally "sort_file_names_naturally"
#define kSyncFilesPaneWorkingDir "sync_files_pane_working_dir"
#define kJobsTabVisibility "jobs_tab_visibility"
#define kJobsTabVisibilityClosed "closed"
#define kJobsTabVisibilityShown "shown"
#define kJobsTabVisibilityDefault "default"
#define kShowLauncherJobsTab "show_launcher_jobs_tab"
#define kLauncherJobsSort "launcher_jobs_sort"
#define kLauncherJobsSortRecorded "recorded"
#define kLauncherJobsSortState "state"
#define kBusyDetection "busy_detection"
#define kBusyDetectionAlways "always"
#define kBusyDetectionNever "never"
#define kBusyDetectionList "list"
#define kBusyExclusionList "busy_exclusion_list"
#define kKnitWorkingDir "knit_working_dir"
#define kKnitWorkingDirDefault "default"
#define kKnitWorkingDirCurrent "current"
#define kKnitWorkingDirProject "project"
#define kDocOutlineShow "doc_outline_show"
#define kDocOutlineShowSectionsOnly "sections_only"
#define kDocOutlineShowSectionsAndChunks "sections_and_chunks"
#define kDocOutlineShowAll "all"
#define kLatexPreviewOnCursorIdle "latex_preview_on_cursor_idle"
#define kLatexPreviewOnCursorIdleNever "never"
#define kLatexPreviewOnCursorIdleInlineOnly "inline_only"
#define kLatexPreviewOnCursorIdleAlways "always"
#define kWrapTabNavigation "wrap_tab_navigation"
#define kGlobalTheme "global_theme"
#define kGlobalThemeDefault "default"
#define kGlobalThemeAlternate "alternate"
#define kGitDiffIgnoreWhitespace "git_diff_ignore_whitespace"
#define kConsoleDoubleClickSelect "console_double_click_select"
#define kConsoleSuspendBlockedNotice "console_suspend_blocked_notice"
#define kConsoleSuspendBlockedNoticeDelay "console_suspend_blocked_notice_delay"
#define kNewProjGitInit "new_proj_git_init"
#define kNewProjUseRenv "new_proj_use_renv"
#define kRootDocument "root_document"
#define kShowUserHomePage "show_user_home_page"
#define kShowUserHomePageAlways "always"
#define kShowUserHomePageNever "never"
#define kShowUserHomePageSessions "sessions"
#define kReuseSessionsForProjectLinks "reuse_sessions_for_project_links"
#define kVcsEnabled "vcs_enabled"
#define kVcsAutorefresh "vcs_autorefresh"
#define kGitExePath "git_exe_path"
#define kSvnExePath "svn_exe_path"
#define kTerminalPath "terminal_path"
#define kRsaKeyPath "rsa_key_path"
#define kUseDevtools "use_devtools"
#define kUseInternet2 "use_internet2"
#define kUseSecureDownload "use_secure_download"
#define kCleanupAfterRCmdCheck "cleanup_after_r_cmd_check"
#define kViewDirAfterRCmdCheck "view_dir_after_r_cmd_check"
#define kHideObjectFiles "hide_object_files"
#define kRestoreLastProject "restore_last_project"
#define kProjectSafeStartupSeconds "project_safe_startup_seconds"
#define kUseTinytex "use_tinytex"
#define kCleanTexi2dviOutput "clean_texi2dvi_output"
#define kLatexShellEscape "latex_shell_escape"
#define kRestoreProjectRVersion "restore_project_r_version"
#define kClangVerbose "clang_verbose"
#define kSubmitCrashReports "submit_crash_reports"
#define kDefaultRVersion "default_r_version"
#define kDefaultRVersionVersion "version"
#define kDefaultRVersionRHome "r_home"
#define kDefaultRVersionLabel "label"
#define kDefaultRVersionModule "module"
#define kDataViewerMaxColumns "data_viewer_max_columns"
#define kEnableScreenReader "enable_screen_reader"
#define kTypingStatusDelayMs "typing_status_delay_ms"
#define kReducedMotion "reduced_motion"
#define kTabKeyMoveFocus "tab_key_move_focus"
#define kFindPanelLegacyTabSequence "find_panel_legacy_tab_sequence"
#define kShowFocusRectangles "show_focus_rectangles"
#define kShowPanelFocusRectangle "show_panel_focus_rectangle"
#define kAutoSaveOnIdle "auto_save_on_idle"
#define kAutoSaveOnIdleCommit "commit"
#define kAutoSaveOnIdleBackup "backup"
#define kAutoSaveOnIdleNone "none"
#define kAutoSaveIdleMs "auto_save_idle_ms"
#define kAutoSaveOnBlur "auto_save_on_blur"
#define kTerminalInitialDirectory "terminal_initial_directory"
#define kTerminalInitialDirectoryProject "project"
#define kTerminalInitialDirectoryCurrent "current"
#define kTerminalInitialDirectoryHome "home"
#define kFullProjectPathInWindowTitle "full_project_path_in_window_title"
#define kVisualMarkdownEditingIsDefault "visual_markdown_editing_is_default"
#define kVisualMarkdownEditingListSpacing "visual_markdown_editing_list_spacing"
#define kVisualMarkdownEditingListSpacingTight "tight"
#define kVisualMarkdownEditingListSpacingSpaced "spaced"
#define kVisualMarkdownEditingWrap "visual_markdown_editing_wrap"
#define kVisualMarkdownEditingWrapNone "none"
#define kVisualMarkdownEditingWrapColumn "column"
#define kVisualMarkdownEditingWrapSentence "sentence"
#define kVisualMarkdownEditingWrapAtColumn "visual_markdown_editing_wrap_at_column"
#define kVisualMarkdownEditingReferencesLocation "visual_markdown_editing_references_location"
#define kVisualMarkdownEditingReferencesLocationBlock "block"
#define kVisualMarkdownEditingReferencesLocationSection "section"
#define kVisualMarkdownEditingReferencesLocationDocument "document"
#define kVisualMarkdownEditingCanonical "visual_markdown_editing_canonical"
#define kVisualMarkdownEditingMaxContentWidth "visual_markdown_editing_max_content_width"
#define kVisualMarkdownEditingShowDocOutline "visual_markdown_editing_show_doc_outline"
#define kVisualMarkdownEditingShowMargin "visual_markdown_editing_show_margin"
#define kVisualMarkdownCodeEditorLineNumbers "visual_markdown_code_editor_line_numbers"
#define kVisualMarkdownEditingFontSizePoints "visual_markdown_editing_font_size_points"
#define kVisualMarkdownCodeEditor "visual_markdown_code_editor"
#define kVisualMarkdownCodeEditorAce "ace"
#define kVisualMarkdownCodeEditorCodemirror "codemirror"
#define kZoteroLibraries "zotero_libraries"
#define kEmojiSkintone "emoji_skintone"
#define kEmojiSkintoneNone_ "(None)"
#define kEmojiSkintoneDefault_ "(Default)"
#define kEmojiSkintoneLight "Light"
#define kEmojiSkintoneMediumLight "Medium-Light"
#define kEmojiSkintoneMedium "Medium"
#define kEmojiSkintoneMediumDark "Medium-Dark"
#define kEmojiSkintoneDark "Dark"
#define kDisabledAriaLiveAnnouncements "disabled_aria_live_announcements"
#define kScreenreaderConsoleAnnounceLimit "screenreader_console_announce_limit"
#define kFileMonitorIgnoredComponents "file_monitor_ignored_components"
#define kInstallPkgDepsIndividually "install_pkg_deps_individually"
#define kGraphicsBackend "graphics_backend"
#define kGraphicsBackendDefault "default"
#define kGraphicsBackendCairo "cairo"
#define kGraphicsBackendCairoPng "cairo-png"
#define kGraphicsBackendQuartz "quartz"
#define kGraphicsBackendWindows "windows"
#define kGraphicsBackendRagg "ragg"
#define kGraphicsAntialiasing "graphics_antialiasing"
#define kGraphicsAntialiasingDefault "default"
#define kGraphicsAntialiasingNone "none"
#define kGraphicsAntialiasingGray "gray"
#define kGraphicsAntialiasingSubpixel "subpixel"
#define kBrowserFixedWidthFonts "browser_fixed_width_fonts"
#define kPythonType "python_type"
#define kPythonVersion "python_version"
#define kPythonPath "python_path"
#define kSaveRetryTimeout "save_retry_timeout"
#define kInsertNativePipeOperator "insert_native_pipe_operator"
#define kCommandPaletteMru "command_palette_mru"
#define kShowMemoryUsage "show_memory_usage"
#define kMemoryQueryIntervalSeconds "memory_query_interval_seconds"
#define kTerminalPythonIntegration "terminal_python_integration"
#define kSessionProtocolDebug "session_protocol_debug"
#define kPythonProjectEnvironmentAutomaticActivate "python_project_environment_automatic_activate"
#define kCheckNullExternalPointers "check_null_external_pointers"
#define kQuartoEnabled "quarto_enabled"
#define kQuartoEnabledAuto "auto"
#define kQuartoEnabledEnabled "enabled"
#define kQuartoEnabledDisabled "disabled"
#define kQuartoEnabledHidden "hidden"

class UserPrefValues: public Preferences
{
public:
   static std::vector<std::string> allKeys();
   /**
    * Whether to run .Rprofile again after resuming a suspended R session.
    */
   bool runRprofileOnResume();
   core::Error setRunRprofileOnResume(bool val);

   /**
    * Whether to save the workspace to an .Rdata file after the R session ends.
    */
   std::string saveWorkspace();
   core::Error setSaveWorkspace(std::string val);

   /**
    * Whether to load the workspace when the R session begins.
    */
   bool loadWorkspace();
   core::Error setLoadWorkspace(bool val);

   /**
    * The initial working directory for new R sessions.
    */
   std::string initialWorkingDirectory();
   core::Error setInitialWorkingDirectory(std::string val);

   /**
    * The CRAN mirror to use.
    */
   core::json::Object cranMirror();
   core::Error setCranMirror(core::json::Object val);

   /**
    * The name of the default Bioconductor mirror.
    */
   std::string bioconductorMirrorName();
   core::Error setBioconductorMirrorName(std::string val);

   /**
    * The URL of the default Bioconductor mirror.
    */
   std::string bioconductorMirrorUrl();
   core::Error setBioconductorMirrorUrl(std::string val);

   /**
    * Whether to always save the R console history.
    */
   bool alwaysSaveHistory();
   core::Error setAlwaysSaveHistory(bool val);

   /**
    * Whether to remove duplicate entries from the R console history.
    */
   bool removeHistoryDuplicates();
   core::Error setRemoveHistoryDuplicates(bool val);

   /**
    * Show the result of the last expression (.Last.value) in the Environment pane.
    */
   bool showLastDotValue();
   core::Error setShowLastDotValue(bool val);

   /**
    * The line ending format to use when saving files.
    */
   std::string lineEndingConversion();
   core::Error setLineEndingConversion(std::string val);

   /**
    * Whether to use newlines when saving Makefiles.
    */
   bool useNewlinesInMakefiles();
   core::Error setUseNewlinesInMakefiles(bool val);

   /**
    * The terminal shell to use on Windows.
    */
   std::string windowsTerminalShell();
   core::Error setWindowsTerminalShell(std::string val);

   /**
    * The terminal shell to use on POSIX operating systems (MacOS and Linux).
    */
   std::string posixTerminalShell();
   core::Error setPosixTerminalShell(std::string val);

   /**
    * The fully qualified path to the custom shell command to use in the Terminal tab.
    */
   std::string customShellCommand();
   core::Error setCustomShellCommand(std::string val);

   /**
    * The command-line options to pass to the custom shell command.
    */
   std::string customShellOptions();
   core::Error setCustomShellOptions(std::string val);

   /**
    * Show line numbers in RStudio's code editor.
    */
   bool showLineNumbers();
   core::Error setShowLineNumbers(bool val);

   /**
    * Highlight the selected word in RStudio's code editor.
    */
   bool highlightSelectedWord();
   core::Error setHighlightSelectedWord(bool val);

   /**
    * Highlight the selected line in RStudio's code editor.
    */
   bool highlightSelectedLine();
   core::Error setHighlightSelectedLine(bool val);

   /**
    * Layout of panes in the RStudio workbench.
    */
   core::json::Object panes();
   core::Error setPanes(core::json::Object val);

   /**
    * Whether to enable the ability to add source columns to display.
    */
   bool allowSourceColumns();
   core::Error setAllowSourceColumns(bool val);

   /**
    * Whether to insert spaces when pressing the Tab key.
    */
   bool useSpacesForTab();
   core::Error setUseSpacesForTab(bool val);

   /**
    * The number of spaces to insert when pressing the Tab key.
    */
   int numSpacesForTab();
   core::Error setNumSpacesForTab(int val);

   /**
    * Whether to automatically detect indentation settings from file contents.
    */
   bool autoDetectIndentation();
   core::Error setAutoDetectIndentation(bool val);

   /**
    * Whether to show the margin guide in the RStudio code editor.
    */
   bool showMargin();
   core::Error setShowMargin(bool val);

   /**
    * Whether to flash the cursor off and on.
    */
   bool blinkingCursor();
   core::Error setBlinkingCursor(bool val);

   /**
    * The number of columns of text after which the margin is shown.
    */
   int marginColumn();
   core::Error setMarginColumn(int val);

   /**
    * Whether to show invisible characters, such as spaces and tabs, in the RStudio code editor.
    */
   bool showInvisibles();
   core::Error setShowInvisibles(bool val);

   /**
    * Whether to show indentation guides in the RStudio code editor.
    */
   bool showIndentGuides();
   core::Error setShowIndentGuides(bool val);

   /**
    * Whether to continue comments (by inserting the comment character) after adding a new line.
    */
   bool continueCommentsOnNewline();
   core::Error setContinueCommentsOnNewline(bool val);

   /**
    * Whether web links in comments are clickable.
    */
   bool highlightWebLink();
   core::Error setHighlightWebLink(bool val);

   /**
    * The keybindings to use in the RStudio code editor.
    */
   std::string editorKeybindings();
   core::Error setEditorKeybindings(std::string val);

   /**
    * Whether to insert matching pairs, such as () and [], when the first is typed.
    */
   bool insertMatching();
   core::Error setInsertMatching(bool val);

   /**
    * Whether to insert spaces around the equals sign in R code.
    */
   bool insertSpacesAroundEquals();
   core::Error setInsertSpacesAroundEquals(bool val);

   /**
    * Whether to insert parentheses after function completions.
    */
   bool insertParensAfterFunctionCompletion();
   core::Error setInsertParensAfterFunctionCompletion(bool val);

   /**
    * Whether to attempt completion of multiple-line statements when pressing Tab.
    */
   bool tabMultilineCompletion();
   core::Error setTabMultilineCompletion(bool val);

   /**
    * Whether to attempt completion of statements when pressing Tab.
    */
   bool tabCompletion();
   core::Error setTabCompletion(bool val);

   /**
    * Whether to show help tooltips for functions when the cursor has not been recently moved.
    */
   bool showHelpTooltipOnIdle();
   core::Error setShowHelpTooltipOnIdle(bool val);

   /**
    * Which kinds of delimiters can be used to surround the current selection.
    */
   std::string surroundSelection();
   core::Error setSurroundSelection(std::string val);

   /**
    * Whether to enable code snippets in the RStudio code editor.
    */
   bool enableSnippets();
   core::Error setEnableSnippets(bool val);

   /**
    * When to use auto-completion for R code in the RStudio code editor.
    */
   std::string codeCompletion();
   core::Error setCodeCompletion(std::string val);

   /**
    * When to use auto-completion for other languages (such as JavaScript and SQL) in the RStudio code editor.
    */
   std::string codeCompletionOther();
   core::Error setCodeCompletionOther(std::string val);

   /**
    * Whether to always use code completion in the R console.
    */
   bool consoleCodeCompletion();
   core::Error setConsoleCodeCompletion(bool val);

   /**
    * The number of milliseconds to wait before offering code suggestions.
    */
   int codeCompletionDelay();
   core::Error setCodeCompletionDelay(int val);

   /**
    * The number of characters in a symbol that can be entered before completions are offered.
    */
   int codeCompletionCharacters();
   core::Error setCodeCompletionCharacters(int val);

   /**
    * Whether to show function signature tooltips during autocompletion.
    */
   bool showFunctionSignatureTooltips();
   core::Error setShowFunctionSignatureTooltips(bool val);

   /**
    * Whether to show diagnostic messages (such as syntax and usage errors) for R code as you type.
    */
   bool showDiagnosticsR();
   core::Error setShowDiagnosticsR(bool val);

   /**
    * Whether to show diagnostic messages for C++ code as you type.
    */
   bool showDiagnosticsCpp();
   core::Error setShowDiagnosticsCpp(bool val);

   /**
    * Whether to show diagnostic messages for YAML code as you type.
    */
   bool showDiagnosticsYaml();
   core::Error setShowDiagnosticsYaml(bool val);

   /**
    * Whether to show diagnostic messages for other types of code (not R, C++, or YAML).
    */
   bool showDiagnosticsOther();
   core::Error setShowDiagnosticsOther(bool val);

   /**
    * Whether to show style diagnostics (suggestions for improving R code style)
    */
   bool styleDiagnostics();
   core::Error setStyleDiagnostics(bool val);

   /**
    * Whether to check code for problems after saving it.
    */
   bool diagnosticsOnSave();
   core::Error setDiagnosticsOnSave(bool val);

   /**
    * Whether to run code diagnostics in the background, as you type.
    */
   bool backgroundDiagnostics();
   core::Error setBackgroundDiagnostics(bool val);

   /**
    * The number of milliseconds to delay before running code diagnostics in the background.
    */
   int backgroundDiagnosticsDelayMs();
   core::Error setBackgroundDiagnosticsDelayMs(int val);

   /**
    * Whether to run diagnostics in R function calls.
    */
   bool diagnosticsInRFunctionCalls();
   core::Error setDiagnosticsInRFunctionCalls(bool val);

   /**
    * Whether to check arguments to R function calls.
    */
   bool checkArgumentsToRFunctionCalls();
   core::Error setCheckArgumentsToRFunctionCalls(bool val);

   /**
    * Whether to check for unexpected variable assignments inside R function calls.
    */
   bool checkUnexpectedAssignmentInFunctionCall();
   core::Error setCheckUnexpectedAssignmentInFunctionCall(bool val);

   /**
    * Whether to generate a warning if a variable is used without being defined in the current scope.
    */
   bool warnIfNoSuchVariableInScope();
   core::Error setWarnIfNoSuchVariableInScope(bool val);

   /**
    * Whether to generate a warning if a variable is defined without being used in the current scope
    */
   bool warnVariableDefinedButNotUsed();
   core::Error setWarnVariableDefinedButNotUsed(bool val);

   /**
    * Whether to automatically discover and offer to install missing R package dependencies.
    */
   bool autoDiscoverPackageDependencies();
   core::Error setAutoDiscoverPackageDependencies(bool val);

   /**
    * Whether to ensure that source files end with a newline character.
    */
   bool autoAppendNewline();
   core::Error setAutoAppendNewline(bool val);

   /**
    * Whether to strip trailing whitespace from each line when saving.
    */
   bool stripTrailingWhitespace();
   core::Error setStripTrailingWhitespace(bool val);

   /**
    * Whether to save the position of the cursor when a file is closed, restore it when the file is opened.
    */
   bool restoreSourceDocumentCursorPosition();
   core::Error setRestoreSourceDocumentCursorPosition(bool val);

   /**
    * Whether to automatically re-indent code when it's pasted into RStudio.
    */
   bool reindentOnPaste();
   core::Error setReindentOnPaste(bool val);

   /**
    * Whether to vertically align arguments to R function calls during automatic indentation.
    */
   bool verticallyAlignArgumentsIndent();
   core::Error setVerticallyAlignArgumentsIndent(bool val);

   /**
    * Whether to soft-wrap R source files, wrapping the text for display without inserting newline characters.
    */
   bool softWrapRFiles();
   core::Error setSoftWrapRFiles(bool val);

   /**
    * Whether to soft-wrap R Markdown files (and similar types such as R HTML and R Notebooks)
    */
   bool softWrapRmdFiles();
   core::Error setSoftWrapRmdFiles(bool val);

   /**
    * Whether to focus the R console after executing an R command from a script.
    */
   bool focusConsoleAfterExec();
   core::Error setFocusConsoleAfterExec(bool val);

   /**
    * The style of folding to use.
    */
   std::string foldStyle();
   core::Error setFoldStyle(std::string val);

   /**
    * Whether to automatically save scripts before executing them.
    */
   bool saveBeforeSourcing();
   core::Error setSaveBeforeSourcing(bool val);

   /**
    * Whether to use syntax highlighting in the R console.
    */
   bool syntaxColorConsole();
   core::Error setSyntaxColorConsole(bool val);

   /**
    * Whether to display error, warning, and message output in a different color.
    */
   bool highlightConsoleErrors();
   core::Error setHighlightConsoleErrors(bool val);

   /**
    * Whether to allow scrolling past the end of a file.
    */
   bool scrollPastEndOfDocument();
   core::Error setScrollPastEndOfDocument(bool val);

   /**
    * Whether to highlight R function calls in the code editor.
    */
   bool highlightRFunctionCalls();
   core::Error setHighlightRFunctionCalls(bool val);

   /**
    * Whether to highlight parentheses in a variety of colors.
    */
   bool rainbowParentheses();
   core::Error setRainbowParentheses(bool val);

   /**
    * The maximum number of characters to display in a single line in the R console.
    */
   int consoleLineLengthLimit();
   core::Error setConsoleLineLengthLimit(int val);

   /**
    * The maximum number of console actions to store and display in the console scrollback buffer.
    */
   int consoleMaxLines();
   core::Error setConsoleMaxLines(int val);

   /**
    * How to treat ANSI escape codes in the console.
    */
   std::string ansiConsoleMode();
   core::Error setAnsiConsoleMode(std::string val);

   /**
    * Whether to only show a limited window of the total console output
    */
   bool limitVisibleConsole();
   core::Error setLimitVisibleConsole(bool val);

   /**
    * Whether to show a toolbar on code chunks in R Markdown documents.
    */
   bool showInlineToolbarForRCodeChunks();
   core::Error setShowInlineToolbarForRCodeChunks(bool val);

   /**
    * Whether to highlight code chunks in R Markdown documents with a different background color.
    */
   bool highlightCodeChunks();
   core::Error setHighlightCodeChunks(bool val);

   /**
    * Whether to save all open, unsaved files before building the project.
    */
   bool saveFilesBeforeBuild();
   core::Error setSaveFilesBeforeBuild(bool val);

   /**
    * The default editor font size, in points.
    */
   double fontSizePoints();
   core::Error setFontSizePoints(double val);

   /**
    * The help panel font size, in points.
    */
   double helpFontSizePoints();
   core::Error setHelpFontSizePoints(double val);

   /**
    * The name of the color theme to apply to the text editor in RStudio.
    */
   std::string editorTheme();
   core::Error setEditorTheme(std::string val);

   /**
    * Whether to use a custom editor font in RStudio Server.
    */
   bool serverEditorFontEnabled();
   core::Error setServerEditorFontEnabled(bool val);

   /**
    * The name of the fixed-width editor font to use with RStudio Server.
    */
   std::string serverEditorFont();
   core::Error setServerEditorFont(std::string val);

   /**
    * The default character encoding to use when saving files.
    */
   std::string defaultEncoding();
   core::Error setDefaultEncoding(std::string val);

   /**
    * Whether to show the toolbar at the top of the RStudio workbench.
    */
   bool toolbarVisible();
   core::Error setToolbarVisible(bool val);

   /**
    * The directory path under which to place new projects by default.
    */
   std::string defaultProjectLocation();
   core::Error setDefaultProjectLocation(std::string val);

   /**
    * Whether to echo R code when sourcing it.
    */
   bool sourceWithEcho();
   core::Error setSourceWithEcho(bool val);

   /**
    * The default engine to use when processing Sweave documents.
    */
   std::string defaultSweaveEngine();
   core::Error setDefaultSweaveEngine(std::string val);

   /**
    * The default program to use when processing LaTeX documents.
    */
   std::string defaultLatexProgram();
   core::Error setDefaultLatexProgram(std::string val);

   /**
    * Whether to use Roxygen for documentation.
    */
   bool useRoxygen();
   core::Error setUseRoxygen(bool val);

   /**
    * Whether to use RStudio's data import feature.
    */
   bool useDataimport();
   core::Error setUseDataimport(bool val);

   /**
    * The program to use to preview PDF files after generation.
    */
   std::string pdfPreviewer();
   core::Error setPdfPreviewer(std::string val);

   /**
    * Whether to always enable the concordance for RNW files.
    */
   bool alwaysEnableRnwConcordance();
   core::Error setAlwaysEnableRnwConcordance(bool val);

   /**
    * Whether to insert numbered sections in LaTeX.
    */
   bool insertNumberedLatexSections();
   core::Error setInsertNumberedLatexSections(bool val);

   /**
    * The language of the spelling dictionary to use for spell checking.
    */
   std::string spellingDictionaryLanguage();
   core::Error setSpellingDictionaryLanguage(std::string val);

   /**
    * The list of custom dictionaries to use when spell checking.
    */
   core::json::Array spellingCustomDictionaries();
   core::Error setSpellingCustomDictionaries(core::json::Array val);

   /**
    * The number of milliseconds to wait before linting a document after it is loaded.
    */
   int documentLoadLintDelay();
   core::Error setDocumentLoadLintDelay(int val);

   /**
    * Whether to ignore words in uppercase when spell checking.
    */
   bool ignoreUppercaseWords();
   core::Error setIgnoreUppercaseWords(bool val);

   /**
    * Whether to ignore words with numbers in them when spell checking.
    */
   bool ignoreWordsWithNumbers();
   core::Error setIgnoreWordsWithNumbers(bool val);

   /**
    * Whether to enable real-time spellchecking by default.
    */
   bool realTimeSpellchecking();
   core::Error setRealTimeSpellchecking(bool val);

   /**
    * Whether to navigate to build errors.
    */
   bool navigateToBuildError();
   core::Error setNavigateToBuildError(bool val);

   /**
    * Whether to enable RStudio's Packages pane.
    */
   bool packagesPaneEnabled();
   core::Error setPackagesPaneEnabled(bool val);

   /**
    * C++ template.
    */
   std::string cppTemplate();
   core::Error setCppTemplate(std::string val);

   /**
    * Whether to restore the last opened source documents when RStudio starts up.
    */
   bool restoreSourceDocuments();
   core::Error setRestoreSourceDocuments(bool val);

   /**
    * Whether to handle errors only when user code is on the stack.
    */
   bool handleErrorsInUserCodeOnly();
   core::Error setHandleErrorsInUserCodeOnly(bool val);

   /**
    * Whether to automatically expand tracebacks when an error occurs.
    */
   bool autoExpandErrorTracebacks();
   core::Error setAutoExpandErrorTracebacks(bool val);

   /**
    * Whether to check for new versions of RStudio when RStudio starts.
    */
   bool checkForUpdates();
   core::Error setCheckForUpdates(bool val);

   /**
    * Whether to show functions without source references in the Traceback pane while debugging.
    */
   bool showInternalFunctions();
   core::Error setShowInternalFunctions(bool val);

   /**
    * Where to display Shiny applications when they are run.
    */
   std::string shinyViewerType();
   core::Error setShinyViewerType(std::string val);

   /**
    * Whether to run Shiny applications as background jobs.
    */
   bool shinyBackgroundJobs();
   core::Error setShinyBackgroundJobs(bool val);

   /**
    * Where to display Shiny applications when they are run.
    */
   std::string plumberViewerType();
   core::Error setPlumberViewerType(std::string val);

   /**
    * The default name to use as the document author when creating new documents.
    */
   std::string documentAuthor();
   core::Error setDocumentAuthor(std::string val);

   /**
    * Use current date when rendering document
    */
   bool rmdAutoDate();
   core::Error setRmdAutoDate(bool val);

   /**
    * The path to the preferred R Markdown template.
    */
   std::string rmdPreferredTemplatePath();
   core::Error setRmdPreferredTemplatePath(std::string val);

   /**
    * Where to display R Markdown documents when they have completed rendering.
    */
   std::string rmdViewerType();
   core::Error setRmdViewerType(std::string val);

   /**
    * Whether to show verbose diagnostic information when publishing content.
    */
   bool showPublishDiagnostics();
   core::Error setShowPublishDiagnostics(bool val);

   /**
    * Whether to check remote server SSL certificates when publishing content.
    */
   bool publishCheckCertificates();
   core::Error setPublishCheckCertificates(bool val);

   /**
    * Whether to use a custom certificate authority (CA) bundle when publishing content.
    */
   bool usePublishCaBundle();
   core::Error setUsePublishCaBundle(bool val);

   /**
    * The path to the custom certificate authority (CA) bundle to use when publishing content.
    */
   std::string publishCaBundle();
   core::Error setPublishCaBundle(std::string val);

   /**
    * Whether to show chunk output inline for ordinary R Markdown documents.
    */
   bool rmdChunkOutputInline();
   core::Error setRmdChunkOutputInline(bool val);

   /**
    * Whether to show the document outline by default when opening R Markdown documents.
    */
   bool showDocOutlineRmd();
   core::Error setShowDocOutlineRmd(bool val);

   /**
    * Whether to automatically run an R Markdown document's Setup chunk before running other chunks.
    */
   bool autoRunSetupChunk();
   core::Error setAutoRunSetupChunk(bool val);

   /**
    * Whether to hide the R console when executing inline R Markdown chunks.
    */
   bool hideConsoleOnChunkExecute();
   core::Error setHideConsoleOnChunkExecute(bool val);

   /**
    * The unit of R code to execute when the Execute command is invoked.
    */
   std::string executionBehavior();
   core::Error setExecutionBehavior(std::string val);

   /**
    * Whether to show the Terminal tab.
    */
   bool showTerminalTab();
   core::Error setShowTerminalTab(bool val);

   /**
    * Whether to use local echo in the Terminal.
    */
   bool terminalLocalEcho();
   core::Error setTerminalLocalEcho(bool val);

   /**
    * Whether to use websockets to communicate with the shell in the Terminal tab.
    */
   bool terminalWebsockets();
   core::Error setTerminalWebsockets(bool val);

   /**
    * Whether to close the terminal pane after the shell exits.
    */
   std::string terminalCloseBehavior();
   core::Error setTerminalCloseBehavior(std::string val);

   /**
    * Whether to track and save changes to system environment variables in the Terminal.
    */
   bool terminalTrackEnvironment();
   core::Error setTerminalTrackEnvironment(bool val);

   /**
    * Terminal bell style
    */
   std::string terminalBellStyle();
   core::Error setTerminalBellStyle(std::string val);

   /**
    * Terminal rendering engine: canvas is faster, dom may be needed for some browsers or graphics cards
    */
   std::string terminalRenderer();
   core::Error setTerminalRenderer(std::string val);

   /**
    * Whether web links displayed in the Terminal tab are made clickable.
    */
   bool terminalWeblinks();
   core::Error setTerminalWeblinks(bool val);

   /**
    * Whether to print the render command use to knit R Markdown documents in the R Markdown tab.
    */
   bool showRmdRenderCommand();
   core::Error setShowRmdRenderCommand(bool val);

   /**
    * Whether to enable moving text on the editing surface by clicking and dragging it.
    */
   bool enableTextDrag();
   core::Error setEnableTextDrag(bool val);

   /**
    * Whether to show hidden files in the Files pane.
    */
   bool showHiddenFiles();
   core::Error setShowHiddenFiles(bool val);

   /**
    * List of file names (case sensitive) that are always shown in the Files Pane, regardless of whether hidden files are shown
    */
   core::json::Array alwaysShownFiles();
   core::Error setAlwaysShownFiles(core::json::Array val);

   /**
    * List of file extensions (beginning with ., not case sensitive) that are always shown in the Files Pane, regardless of whether hidden files are shown
    */
   core::json::Array alwaysShownExtensions();
   core::Error setAlwaysShownExtensions(core::json::Array val);

   /**
    * Whether to sort file names naturally, so that e.g., file10.R comes after file9.R
    */
   bool sortFileNamesNaturally();
   core::Error setSortFileNamesNaturally(bool val);

   /**
    * Whether to change the directory in the Files pane automatically when the working directory in R changes.
    */
   bool syncFilesPaneWorkingDir();
   core::Error setSyncFilesPaneWorkingDir(bool val);

   /**
    * The visibility of the Jobs tab.
    */
   std::string jobsTabVisibility();
   core::Error setJobsTabVisibility(std::string val);

   /**
    * Whether to show the Launcher jobs tab in RStudio Pro and RStudio Workbench.
    */
   bool showLauncherJobsTab();
   core::Error setShowLauncherJobsTab(bool val);

   /**
    * How to sort jobs in the Launcher tab in RStudio Pro and RStudio Workbench.
    */
   std::string launcherJobsSort();
   core::Error setLauncherJobsSort(std::string val);

   /**
    * How to detect busy status in the Terminal.
    */
   std::string busyDetection();
   core::Error setBusyDetection(std::string val);

   /**
    * A list of apps that should not be considered busy in the Terminal.
    */
   core::json::Array busyExclusionList();
   core::Error setBusyExclusionList(core::json::Array val);

   /**
    * The working directory to use when knitting R Markdown documents.
    */
   std::string knitWorkingDir();
   core::Error setKnitWorkingDir(std::string val);

   /**
    * Which objects to show in the document outline pane.
    */
   std::string docOutlineShow();
   core::Error setDocOutlineShow(std::string val);

   /**
    * When to preview LaTeX mathematical equations when cursor has not moved recently.
    */
   std::string latexPreviewOnCursorIdle();
   core::Error setLatexPreviewOnCursorIdle(std::string val);

   /**
    * Whether to wrap around when going to the previous or next editor tab.
    */
   bool wrapTabNavigation();
   core::Error setWrapTabNavigation(bool val);

   /**
    * The theme to use for the main RStudio user interface.
    */
   std::string globalTheme();
   core::Error setGlobalTheme(std::string val);

   /**
    * Whether to ignore whitespace when generating diffs of version controlled files.
    */
   bool gitDiffIgnoreWhitespace();
   core::Error setGitDiffIgnoreWhitespace(bool val);

   /**
    * Whether double-clicking should select a word in the Console pane.
    */
   bool consoleDoubleClickSelect();
   core::Error setConsoleDoubleClickSelect(bool val);

   /**
    * Whether the 'Auto Suspension Blocked' icon should appear in the R Console toolbar.
    */
   bool consoleSuspendBlockedNotice();
   core::Error setConsoleSuspendBlockedNotice(bool val);

   /**
    * How long to wait before warning that automatic session suspension has been paused. Higher values for less frequent notices.
    */
   int consoleSuspendBlockedNoticeDelay();
   core::Error setConsoleSuspendBlockedNoticeDelay(int val);

   /**
    * Whether a git repo should be initialized inside new projects by default.
    */
   bool newProjGitInit();
   core::Error setNewProjGitInit(bool val);

   /**
    * Whether an renv environment should be created inside new projects by default.
    */
   bool newProjUseRenv();
   core::Error setNewProjUseRenv(bool val);

   /**
    * The root document to use when compiling PDF documents.
    */
   std::string rootDocument();
   core::Error setRootDocument(std::string val);

   /**
    * When to show the server home page in RStudio Workbench.
    */
   std::string showUserHomePage();
   core::Error setShowUserHomePage(std::string val);

   /**
    * Whether to reuse sessions when opening projects in RStudio Workbench.
    */
   bool reuseSessionsForProjectLinks();
   core::Error setReuseSessionsForProjectLinks(bool val);

   /**
    * Whether to enable RStudio's version control system interface.
    */
   bool vcsEnabled();
   core::Error setVcsEnabled(bool val);

   /**
    * Automatically refresh VCS status?
    */
   bool vcsAutorefresh();
   core::Error setVcsAutorefresh(bool val);

   /**
    * The path to the Git executable to use.
    */
   std::string gitExePath();
   core::Error setGitExePath(std::string val);

   /**
    * The path to the Subversion executable to use.
    */
   std::string svnExePath();
   core::Error setSvnExePath(std::string val);

   /**
    * The path to the terminal executable to use.
    */
   std::string terminalPath();
   core::Error setTerminalPath(std::string val);

   /**
    * The path to the RSA key file to use.
    */
   std::string rsaKeyPath();
   core::Error setRsaKeyPath(std::string val);

   /**
    * Whether to use the devtools R package.
    */
   bool useDevtools();
   core::Error setUseDevtools(bool val);

   /**
    * Whether to use Internet2 for networking on R for Windows.
    */
   bool useInternet2();
   core::Error setUseInternet2(bool val);

   /**
    * Whether to use secure downloads when fetching R packages.
    */
   bool useSecureDownload();
   core::Error setUseSecureDownload(bool val);

   /**
    * Whether to clean up temporary files after running R CMD CHECK.
    */
   bool cleanupAfterRCmdCheck();
   core::Error setCleanupAfterRCmdCheck(bool val);

   /**
    * Whether to view the directory after running R CMD CHECK.
    */
   bool viewDirAfterRCmdCheck();
   core::Error setViewDirAfterRCmdCheck(bool val);

   /**
    * Whether to hide object files in the Files pane.
    */
   bool hideObjectFiles();
   core::Error setHideObjectFiles(bool val);

   /**
    * Whether to restore the last project when starting RStudio.
    */
   bool restoreLastProject();
   core::Error setRestoreLastProject(bool val);

   /**
    * The number of seconds after which a project is deemed to have successfully started.
    */
   int projectSafeStartupSeconds();
   core::Error setProjectSafeStartupSeconds(int val);

   /**
    * Use tinytex to compile .tex files.
    */
   bool useTinytex();
   core::Error setUseTinytex(bool val);

   /**
    * Whether to clean output after running Texi2Dvi.
    */
   bool cleanTexi2dviOutput();
   core::Error setCleanTexi2dviOutput(bool val);

   /**
    * Whether to enable shell escaping with LaTeX documents.
    */
   bool latexShellEscape();
   core::Error setLatexShellEscape(bool val);

   /**
    * Whether to restore the last version of R used by the project in RStudio Pro and RStudio Workbench.
    */
   bool restoreProjectRVersion();
   core::Error setRestoreProjectRVersion(bool val);

   /**
    * The verbosity level to use with Clang (0 - 2)
    */
   int clangVerbose();
   core::Error setClangVerbose(int val);

   /**
    * Whether to automatically submit crash reports to RStudio.
    */
   bool submitCrashReports();
   core::Error setSubmitCrashReports(bool val);

   /**
    * The R version to use by default.
    */
   core::json::Object defaultRVersion();
   core::Error setDefaultRVersion(core::json::Object val);

   /**
    * The maximum number of columns to show at once in the data viewer.
    */
   int dataViewerMaxColumns();
   core::Error setDataViewerMaxColumns(int val);

   /**
    * Support accessibility aids such as screen readers (RStudio Server).
    */
   bool enableScreenReader();
   core::Error setEnableScreenReader(bool val);

   /**
    * Number of milliseconds to wait after last keystroke before updating live region.
    */
   int typingStatusDelayMs();
   core::Error setTypingStatusDelayMs(int val);

   /**
    * Reduce use of animations in the user interface.
    */
   bool reducedMotion();
   core::Error setReducedMotion(bool val);

   /**
    * Tab key moves focus out of text editing controls instead of inserting tabs.
    */
   bool tabKeyMoveFocus();
   core::Error setTabKeyMoveFocus(bool val);

   /**
    * In source editor find panel, tab key moves focus directly from find text to replace text.
    */
   bool findPanelLegacyTabSequence();
   core::Error setFindPanelLegacyTabSequence(bool val);

   /**
    * Control with keyboard focus displays a visual focus indicator.
    */
   bool showFocusRectangles();
   core::Error setShowFocusRectangles(bool val);

   /**
    * Show which panel contains keyboard focus.
    */
   bool showPanelFocusRectangle();
   core::Error setShowPanelFocusRectangle(bool val);

   /**
    * How to deal with changes to documents on idle.
    */
   std::string autoSaveOnIdle();
   core::Error setAutoSaveOnIdle(std::string val);

   /**
    * The idle period, in milliseconds, after which documents should be auto-saved.
    */
   int autoSaveIdleMs();
   core::Error setAutoSaveIdleMs(int val);

   /**
    * Whether to automatically save when the editor loses focus.
    */
   bool autoSaveOnBlur();
   core::Error setAutoSaveOnBlur(bool val);

   /**
    * Initial directory for new terminals.
    */
   std::string terminalInitialDirectory();
   core::Error setTerminalInitialDirectory(std::string val);

   /**
    * Whether to show the full path to project in desktop window title.
    */
   bool fullProjectPathInWindowTitle();
   core::Error setFullProjectPathInWindowTitle(bool val);

   /**
    * Whether to enable visual editing by default for new markdown documents
    */
   bool visualMarkdownEditingIsDefault();
   core::Error setVisualMarkdownEditingIsDefault(bool val);

   /**
    * Default spacing for lists created in the visual editor
    */
   std::string visualMarkdownEditingListSpacing();
   core::Error setVisualMarkdownEditingListSpacing(std::string val);

   /**
    * Whether to automatically wrap text when writing markdown
    */
   std::string visualMarkdownEditingWrap();
   core::Error setVisualMarkdownEditingWrap(std::string val);

   /**
    * The column to wrap text at when writing markdown
    */
   int visualMarkdownEditingWrapAtColumn();
   core::Error setVisualMarkdownEditingWrapAtColumn(int val);

   /**
    * Placement of footnotes within markdown output.
    */
   std::string visualMarkdownEditingReferencesLocation();
   core::Error setVisualMarkdownEditingReferencesLocation(std::string val);

   /**
    * Whether to write canonical visual mode markdown when saving from source mode.
    */
   bool visualMarkdownEditingCanonical();
   core::Error setVisualMarkdownEditingCanonical(bool val);

   /**
    * Maximum content width for visual editing mode, in pixels
    */
   int visualMarkdownEditingMaxContentWidth();
   core::Error setVisualMarkdownEditingMaxContentWidth(int val);

   /**
    * Whether to show the document outline by default when opening R Markdown documents in visual mode.
    */
   bool visualMarkdownEditingShowDocOutline();
   core::Error setVisualMarkdownEditingShowDocOutline(bool val);

   /**
    * Whether to show the margin guide in the visual mode code blocks.
    */
   bool visualMarkdownEditingShowMargin();
   core::Error setVisualMarkdownEditingShowMargin(bool val);

   /**
    * Whether to show line numbers in the code editors used in visual mode
    */
   bool visualMarkdownCodeEditorLineNumbers();
   core::Error setVisualMarkdownCodeEditorLineNumbers(bool val);

   /**
    * The default visual editing mode font size, in points
    */
   int visualMarkdownEditingFontSizePoints();
   core::Error setVisualMarkdownEditingFontSizePoints(int val);

   /**
    * The name of the editor to use to provide code editing in visual mode
    */
   std::string visualMarkdownCodeEditor();
   core::Error setVisualMarkdownCodeEditor(std::string val);

   /**
    * Zotero libraries to insert citations from.
    */
   core::json::Array zoteroLibraries();
   core::Error setZoteroLibraries(core::json::Array val);

   /**
    * Preferred emoji skintone
    */
   std::string emojiSkintone();
   core::Error setEmojiSkintone(std::string val);

   /**
    * List of aria-live announcements to disable.
    */
   core::json::Array disabledAriaLiveAnnouncements();
   core::Error setDisabledAriaLiveAnnouncements(core::json::Array val);

   /**
    * Maximum number of lines of console output announced after a command.
    */
   int screenreaderConsoleAnnounceLimit();
   core::Error setScreenreaderConsoleAnnounceLimit(int val);

   /**
    * List of path components; file monitor will ignore paths containing one or more of these components.
    */
   core::json::Array fileMonitorIgnoredComponents();
   core::Error setFileMonitorIgnoredComponents(core::json::Array val);

   /**
    * Whether to install R package dependencies one at a time.
    */
   bool installPkgDepsIndividually();
   core::Error setInstallPkgDepsIndividually(bool val);

   /**
    * R graphics backend.
    */
   std::string graphicsBackend();
   core::Error setGraphicsBackend(std::string val);

   /**
    * Type of anti-aliasing to be used for generated R plots.
    */
   std::string graphicsAntialiasing();
   core::Error setGraphicsAntialiasing(std::string val);

   /**
    * List of fixed-width fonts to check for browser support.
    */
   core::json::Array browserFixedWidthFonts();
   core::Error setBrowserFixedWidthFonts(core::json::Array val);

   /**
    * The Python type.
    */
   std::string pythonType();
   core::Error setPythonType(std::string val);

   /**
    * The Python version.
    */
   std::string pythonVersion();
   core::Error setPythonVersion(std::string val);

   /**
    * The path to the default Python interpreter.
    */
   std::string pythonPath();
   core::Error setPythonPath(std::string val);

   /**
    * The maximum amount of seconds of retry for save operations.
    */
   int saveRetryTimeout();
   core::Error setSaveRetryTimeout(int val);

   /**
    * Whether the Insert Pipe Operator command should insert the native R pipe operator, |>
    */
   bool insertNativePipeOperator();
   core::Error setInsertNativePipeOperator(bool val);

   /**
    * Whether to keep track of recently used commands in the Command Palette
    */
   bool commandPaletteMru();
   core::Error setCommandPaletteMru(bool val);

   /**
    * Whether to compute and show memory usage in the Environment Pane
    */
   bool showMemoryUsage();
   core::Error setShowMemoryUsage(bool val);

   /**
    * How many seconds to wait between automatic requeries of memory statistics (0 to disable)
    */
   int memoryQueryIntervalSeconds();
   core::Error setMemoryQueryIntervalSeconds(int val);

   /**
    * Enable Python terminal hooks. When enabled, the RStudio-configured version of Python will be placed on the PATH.
    */
   bool terminalPythonIntegration();
   core::Error setTerminalPythonIntegration(bool val);

   /**
    * Enable session protocol debug logging showing all session requests and events
    */
   bool sessionProtocolDebug();
   core::Error setSessionProtocolDebug(bool val);

   /**
    * When enabled, if the active project contains a Python virtual environment, then RStudio will automatically activate this environment on startup.
    */
   bool pythonProjectEnvironmentAutomaticActivate();
   core::Error setPythonProjectEnvironmentAutomaticActivate(bool val);

   /**
    * When enabled, RStudio will detect R objects containing null external pointers when building the Environment pane, and avoid introspecting their contents further.
    */
   bool checkNullExternalPointers();
   core::Error setCheckNullExternalPointers(bool val);

   /**
    * Enable IDE features for the Quarto publishing system.
    */
   std::string quartoEnabled();
   core::Error setQuartoEnabled(std::string val);

};

        
}
}
}

#endif
