/* UserPrefValues.cpp
 *
 * Copyright (C) 2022 by RStudio, PBC
 *
 * Unless you have received this program directly from RStudio pursuant
 * to the terms of a commercial license agreement with RStudio, then
 * this program is licensed to you under the terms of version 3 of the
 * GNU Affero General Public License. This program is distributed WITHOUT
 * ANY EXPRESS OR IMPLIED WARRANTY, INCLUDING THOSE OF NON-INFRINGEMENT,
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Please refer to the
 * AGPL (http://www.gnu.org/licenses/agpl-3.0.txt) for more details.
 *
 */
 
/* DO NOT HAND-EDIT! This file is automatically generated from the formal user preference schema
 * JSON. To add a preference, add it to "user-prefs-schema.json", then run "generate-prefs.R" to
 * rebuild this file.
 */

#include <session/prefs/UserPrefValues.hpp>

namespace rstudio {
namespace session {
namespace prefs {

/**
 * Whether to run .Rprofile again after resuming a suspended R session.
 */
bool UserPrefValues::runRprofileOnResume()
{
   return readPref<bool>("run_rprofile_on_resume");
}

core::Error UserPrefValues::setRunRprofileOnResume(bool val)
{
   return writePref("run_rprofile_on_resume", val);
}

/**
 * Whether to save the workspace to an .Rdata file after the R session ends.
 */
std::string UserPrefValues::saveWorkspace()
{
   return readPref<std::string>("save_workspace");
}

core::Error UserPrefValues::setSaveWorkspace(std::string val)
{
   return writePref("save_workspace", val);
}

/**
 * Whether to load the workspace when the R session begins.
 */
bool UserPrefValues::loadWorkspace()
{
   return readPref<bool>("load_workspace");
}

core::Error UserPrefValues::setLoadWorkspace(bool val)
{
   return writePref("load_workspace", val);
}

/**
 * The initial working directory for new R sessions.
 */
std::string UserPrefValues::initialWorkingDirectory()
{
   return readPref<std::string>("initial_working_directory");
}

core::Error UserPrefValues::setInitialWorkingDirectory(std::string val)
{
   return writePref("initial_working_directory", val);
}

/**
 * The CRAN mirror to use.
 */
core::json::Object UserPrefValues::cranMirror()
{
   return readPref<core::json::Object>("cran_mirror");
}

core::Error UserPrefValues::setCranMirror(core::json::Object val)
{
   return writePref("cran_mirror", val);
}

/**
 * The name of the default Bioconductor mirror.
 */
std::string UserPrefValues::bioconductorMirrorName()
{
   return readPref<std::string>("bioconductor_mirror_name");
}

core::Error UserPrefValues::setBioconductorMirrorName(std::string val)
{
   return writePref("bioconductor_mirror_name", val);
}

/**
 * The URL of the default Bioconductor mirror.
 */
std::string UserPrefValues::bioconductorMirrorUrl()
{
   return readPref<std::string>("bioconductor_mirror_url");
}

core::Error UserPrefValues::setBioconductorMirrorUrl(std::string val)
{
   return writePref("bioconductor_mirror_url", val);
}

/**
 * Whether to always save the R console history.
 */
bool UserPrefValues::alwaysSaveHistory()
{
   return readPref<bool>("always_save_history");
}

core::Error UserPrefValues::setAlwaysSaveHistory(bool val)
{
   return writePref("always_save_history", val);
}

/**
 * Whether to remove duplicate entries from the R console history.
 */
bool UserPrefValues::removeHistoryDuplicates()
{
   return readPref<bool>("remove_history_duplicates");
}

core::Error UserPrefValues::setRemoveHistoryDuplicates(bool val)
{
   return writePref("remove_history_duplicates", val);
}

/**
 * Show the result of the last expression (.Last.value) in the Environment pane.
 */
bool UserPrefValues::showLastDotValue()
{
   return readPref<bool>("show_last_dot_value");
}

core::Error UserPrefValues::setShowLastDotValue(bool val)
{
   return writePref("show_last_dot_value", val);
}

/**
 * The line ending format to use when saving files.
 */
std::string UserPrefValues::lineEndingConversion()
{
   return readPref<std::string>("line_ending_conversion");
}

core::Error UserPrefValues::setLineEndingConversion(std::string val)
{
   return writePref("line_ending_conversion", val);
}

/**
 * Whether to use newlines when saving Makefiles.
 */
bool UserPrefValues::useNewlinesInMakefiles()
{
   return readPref<bool>("use_newlines_in_makefiles");
}

core::Error UserPrefValues::setUseNewlinesInMakefiles(bool val)
{
   return writePref("use_newlines_in_makefiles", val);
}

/**
 * The terminal shell to use on Windows.
 */
std::string UserPrefValues::windowsTerminalShell()
{
   return readPref<std::string>("windows_terminal_shell");
}

core::Error UserPrefValues::setWindowsTerminalShell(std::string val)
{
   return writePref("windows_terminal_shell", val);
}

/**
 * The terminal shell to use on POSIX operating systems (MacOS and Linux).
 */
std::string UserPrefValues::posixTerminalShell()
{
   return readPref<std::string>("posix_terminal_shell");
}

core::Error UserPrefValues::setPosixTerminalShell(std::string val)
{
   return writePref("posix_terminal_shell", val);
}

/**
 * The fully qualified path to the custom shell command to use in the Terminal tab.
 */
std::string UserPrefValues::customShellCommand()
{
   return readPref<std::string>("custom_shell_command");
}

core::Error UserPrefValues::setCustomShellCommand(std::string val)
{
   return writePref("custom_shell_command", val);
}

/**
 * The command-line options to pass to the custom shell command.
 */
std::string UserPrefValues::customShellOptions()
{
   return readPref<std::string>("custom_shell_options");
}

core::Error UserPrefValues::setCustomShellOptions(std::string val)
{
   return writePref("custom_shell_options", val);
}

/**
 * Show line numbers in RStudio's code editor.
 */
bool UserPrefValues::showLineNumbers()
{
   return readPref<bool>("show_line_numbers");
}

core::Error UserPrefValues::setShowLineNumbers(bool val)
{
   return writePref("show_line_numbers", val);
}

/**
 * Highlight the selected word in RStudio's code editor.
 */
bool UserPrefValues::highlightSelectedWord()
{
   return readPref<bool>("highlight_selected_word");
}

core::Error UserPrefValues::setHighlightSelectedWord(bool val)
{
   return writePref("highlight_selected_word", val);
}

/**
 * Highlight the selected line in RStudio's code editor.
 */
bool UserPrefValues::highlightSelectedLine()
{
   return readPref<bool>("highlight_selected_line");
}

core::Error UserPrefValues::setHighlightSelectedLine(bool val)
{
   return writePref("highlight_selected_line", val);
}

/**
 * Layout of panes in the RStudio workbench.
 */
core::json::Object UserPrefValues::panes()
{
   return readPref<core::json::Object>("panes");
}

core::Error UserPrefValues::setPanes(core::json::Object val)
{
   return writePref("panes", val);
}

/**
 * Whether to enable the ability to add source columns to display.
 */
bool UserPrefValues::allowSourceColumns()
{
   return readPref<bool>("allow_source_columns");
}

core::Error UserPrefValues::setAllowSourceColumns(bool val)
{
   return writePref("allow_source_columns", val);
}

/**
 * Whether to insert spaces when pressing the Tab key.
 */
bool UserPrefValues::useSpacesForTab()
{
   return readPref<bool>("use_spaces_for_tab");
}

core::Error UserPrefValues::setUseSpacesForTab(bool val)
{
   return writePref("use_spaces_for_tab", val);
}

/**
 * The number of spaces to insert when pressing the Tab key.
 */
int UserPrefValues::numSpacesForTab()
{
   return readPref<int>("num_spaces_for_tab");
}

core::Error UserPrefValues::setNumSpacesForTab(int val)
{
   return writePref("num_spaces_for_tab", val);
}

/**
 * Whether to automatically detect indentation settings from file contents.
 */
bool UserPrefValues::autoDetectIndentation()
{
   return readPref<bool>("auto_detect_indentation");
}

core::Error UserPrefValues::setAutoDetectIndentation(bool val)
{
   return writePref("auto_detect_indentation", val);
}

/**
 * Whether to show the margin guide in the RStudio code editor.
 */
bool UserPrefValues::showMargin()
{
   return readPref<bool>("show_margin");
}

core::Error UserPrefValues::setShowMargin(bool val)
{
   return writePref("show_margin", val);
}

/**
 * Whether to flash the cursor off and on.
 */
bool UserPrefValues::blinkingCursor()
{
   return readPref<bool>("blinking_cursor");
}

core::Error UserPrefValues::setBlinkingCursor(bool val)
{
   return writePref("blinking_cursor", val);
}

/**
 * The number of columns of text after which the margin is shown.
 */
int UserPrefValues::marginColumn()
{
   return readPref<int>("margin_column");
}

core::Error UserPrefValues::setMarginColumn(int val)
{
   return writePref("margin_column", val);
}

/**
 * Whether to show invisible characters, such as spaces and tabs, in the RStudio code editor.
 */
bool UserPrefValues::showInvisibles()
{
   return readPref<bool>("show_invisibles");
}

core::Error UserPrefValues::setShowInvisibles(bool val)
{
   return writePref("show_invisibles", val);
}

/**
 * Whether to show indentation guides in the RStudio code editor.
 */
bool UserPrefValues::showIndentGuides()
{
   return readPref<bool>("show_indent_guides");
}

core::Error UserPrefValues::setShowIndentGuides(bool val)
{
   return writePref("show_indent_guides", val);
}

/**
 * Whether to continue comments (by inserting the comment character) after adding a new line.
 */
bool UserPrefValues::continueCommentsOnNewline()
{
   return readPref<bool>("continue_comments_on_newline");
}

core::Error UserPrefValues::setContinueCommentsOnNewline(bool val)
{
   return writePref("continue_comments_on_newline", val);
}

/**
 * Whether web links in comments are clickable.
 */
bool UserPrefValues::highlightWebLink()
{
   return readPref<bool>("highlight_web_link");
}

core::Error UserPrefValues::setHighlightWebLink(bool val)
{
   return writePref("highlight_web_link", val);
}

/**
 * The keybindings to use in the RStudio code editor.
 */
std::string UserPrefValues::editorKeybindings()
{
   return readPref<std::string>("editor_keybindings");
}

core::Error UserPrefValues::setEditorKeybindings(std::string val)
{
   return writePref("editor_keybindings", val);
}

/**
 * Whether to insert matching pairs, such as () and [], when the first is typed.
 */
bool UserPrefValues::insertMatching()
{
   return readPref<bool>("insert_matching");
}

core::Error UserPrefValues::setInsertMatching(bool val)
{
   return writePref("insert_matching", val);
}

/**
 * Whether to insert spaces around the equals sign in R code.
 */
bool UserPrefValues::insertSpacesAroundEquals()
{
   return readPref<bool>("insert_spaces_around_equals");
}

core::Error UserPrefValues::setInsertSpacesAroundEquals(bool val)
{
   return writePref("insert_spaces_around_equals", val);
}

/**
 * Whether to insert parentheses after function completions.
 */
bool UserPrefValues::insertParensAfterFunctionCompletion()
{
   return readPref<bool>("insert_parens_after_function_completion");
}

core::Error UserPrefValues::setInsertParensAfterFunctionCompletion(bool val)
{
   return writePref("insert_parens_after_function_completion", val);
}

/**
 * Whether to attempt completion of multiple-line statements when pressing Tab.
 */
bool UserPrefValues::tabMultilineCompletion()
{
   return readPref<bool>("tab_multiline_completion");
}

core::Error UserPrefValues::setTabMultilineCompletion(bool val)
{
   return writePref("tab_multiline_completion", val);
}

/**
 * Whether to attempt completion of statements when pressing Tab.
 */
bool UserPrefValues::tabCompletion()
{
   return readPref<bool>("tab_completion");
}

core::Error UserPrefValues::setTabCompletion(bool val)
{
   return writePref("tab_completion", val);
}

/**
 * Whether to show help tooltips for functions when the cursor has not been recently moved.
 */
bool UserPrefValues::showHelpTooltipOnIdle()
{
   return readPref<bool>("show_help_tooltip_on_idle");
}

core::Error UserPrefValues::setShowHelpTooltipOnIdle(bool val)
{
   return writePref("show_help_tooltip_on_idle", val);
}

/**
 * Which kinds of delimiters can be used to surround the current selection.
 */
std::string UserPrefValues::surroundSelection()
{
   return readPref<std::string>("surround_selection");
}

core::Error UserPrefValues::setSurroundSelection(std::string val)
{
   return writePref("surround_selection", val);
}

/**
 * Whether to enable code snippets in the RStudio code editor.
 */
bool UserPrefValues::enableSnippets()
{
   return readPref<bool>("enable_snippets");
}

core::Error UserPrefValues::setEnableSnippets(bool val)
{
   return writePref("enable_snippets", val);
}

/**
 * When to use auto-completion for R code in the RStudio code editor.
 */
std::string UserPrefValues::codeCompletion()
{
   return readPref<std::string>("code_completion");
}

core::Error UserPrefValues::setCodeCompletion(std::string val)
{
   return writePref("code_completion", val);
}

/**
 * When to use auto-completion for other languages (such as JavaScript and SQL) in the RStudio code editor.
 */
std::string UserPrefValues::codeCompletionOther()
{
   return readPref<std::string>("code_completion_other");
}

core::Error UserPrefValues::setCodeCompletionOther(std::string val)
{
   return writePref("code_completion_other", val);
}

/**
 * Whether to always use code completion in the R console.
 */
bool UserPrefValues::consoleCodeCompletion()
{
   return readPref<bool>("console_code_completion");
}

core::Error UserPrefValues::setConsoleCodeCompletion(bool val)
{
   return writePref("console_code_completion", val);
}

/**
 * The number of milliseconds to wait before offering code suggestions.
 */
int UserPrefValues::codeCompletionDelay()
{
   return readPref<int>("code_completion_delay");
}

core::Error UserPrefValues::setCodeCompletionDelay(int val)
{
   return writePref("code_completion_delay", val);
}

/**
 * The number of characters in a symbol that can be entered before completions are offered.
 */
int UserPrefValues::codeCompletionCharacters()
{
   return readPref<int>("code_completion_characters");
}

core::Error UserPrefValues::setCodeCompletionCharacters(int val)
{
   return writePref("code_completion_characters", val);
}

/**
 * Whether to show function signature tooltips during autocompletion.
 */
bool UserPrefValues::showFunctionSignatureTooltips()
{
   return readPref<bool>("show_function_signature_tooltips");
}

core::Error UserPrefValues::setShowFunctionSignatureTooltips(bool val)
{
   return writePref("show_function_signature_tooltips", val);
}

/**
 * Whether to show diagnostic messages (such as syntax and usage errors) for R code as you type.
 */
bool UserPrefValues::showDiagnosticsR()
{
   return readPref<bool>("show_diagnostics_r");
}

core::Error UserPrefValues::setShowDiagnosticsR(bool val)
{
   return writePref("show_diagnostics_r", val);
}

/**
 * Whether to show diagnostic messages for C++ code as you type.
 */
bool UserPrefValues::showDiagnosticsCpp()
{
   return readPref<bool>("show_diagnostics_cpp");
}

core::Error UserPrefValues::setShowDiagnosticsCpp(bool val)
{
   return writePref("show_diagnostics_cpp", val);
}

/**
 * Whether to show diagnostic messages for YAML code as you type.
 */
bool UserPrefValues::showDiagnosticsYaml()
{
   return readPref<bool>("show_diagnostics_yaml");
}

core::Error UserPrefValues::setShowDiagnosticsYaml(bool val)
{
   return writePref("show_diagnostics_yaml", val);
}

/**
 * Whether to show diagnostic messages for other types of code (not R, C++, or YAML).
 */
bool UserPrefValues::showDiagnosticsOther()
{
   return readPref<bool>("show_diagnostics_other");
}

core::Error UserPrefValues::setShowDiagnosticsOther(bool val)
{
   return writePref("show_diagnostics_other", val);
}

/**
 * Whether to show style diagnostics (suggestions for improving R code style)
 */
bool UserPrefValues::styleDiagnostics()
{
   return readPref<bool>("style_diagnostics");
}

core::Error UserPrefValues::setStyleDiagnostics(bool val)
{
   return writePref("style_diagnostics", val);
}

/**
 * Whether to check code for problems after saving it.
 */
bool UserPrefValues::diagnosticsOnSave()
{
   return readPref<bool>("diagnostics_on_save");
}

core::Error UserPrefValues::setDiagnosticsOnSave(bool val)
{
   return writePref("diagnostics_on_save", val);
}

/**
 * Whether to run code diagnostics in the background, as you type.
 */
bool UserPrefValues::backgroundDiagnostics()
{
   return readPref<bool>("background_diagnostics");
}

core::Error UserPrefValues::setBackgroundDiagnostics(bool val)
{
   return writePref("background_diagnostics", val);
}

/**
 * The number of milliseconds to delay before running code diagnostics in the background.
 */
int UserPrefValues::backgroundDiagnosticsDelayMs()
{
   return readPref<int>("background_diagnostics_delay_ms");
}

core::Error UserPrefValues::setBackgroundDiagnosticsDelayMs(int val)
{
   return writePref("background_diagnostics_delay_ms", val);
}

/**
 * Whether to run diagnostics in R function calls.
 */
bool UserPrefValues::diagnosticsInRFunctionCalls()
{
   return readPref<bool>("diagnostics_in_r_function_calls");
}

core::Error UserPrefValues::setDiagnosticsInRFunctionCalls(bool val)
{
   return writePref("diagnostics_in_r_function_calls", val);
}

/**
 * Whether to check arguments to R function calls.
 */
bool UserPrefValues::checkArgumentsToRFunctionCalls()
{
   return readPref<bool>("check_arguments_to_r_function_calls");
}

core::Error UserPrefValues::setCheckArgumentsToRFunctionCalls(bool val)
{
   return writePref("check_arguments_to_r_function_calls", val);
}

/**
 * Whether to check for unexpected variable assignments inside R function calls.
 */
bool UserPrefValues::checkUnexpectedAssignmentInFunctionCall()
{
   return readPref<bool>("check_unexpected_assignment_in_function_call");
}

core::Error UserPrefValues::setCheckUnexpectedAssignmentInFunctionCall(bool val)
{
   return writePref("check_unexpected_assignment_in_function_call", val);
}

/**
 * Whether to generate a warning if a variable is used without being defined in the current scope.
 */
bool UserPrefValues::warnIfNoSuchVariableInScope()
{
   return readPref<bool>("warn_if_no_such_variable_in_scope");
}

core::Error UserPrefValues::setWarnIfNoSuchVariableInScope(bool val)
{
   return writePref("warn_if_no_such_variable_in_scope", val);
}

/**
 * Whether to generate a warning if a variable is defined without being used in the current scope
 */
bool UserPrefValues::warnVariableDefinedButNotUsed()
{
   return readPref<bool>("warn_variable_defined_but_not_used");
}

core::Error UserPrefValues::setWarnVariableDefinedButNotUsed(bool val)
{
   return writePref("warn_variable_defined_but_not_used", val);
}

/**
 * Whether to automatically discover and offer to install missing R package dependencies.
 */
bool UserPrefValues::autoDiscoverPackageDependencies()
{
   return readPref<bool>("auto_discover_package_dependencies");
}

core::Error UserPrefValues::setAutoDiscoverPackageDependencies(bool val)
{
   return writePref("auto_discover_package_dependencies", val);
}

/**
 * Whether to ensure that source files end with a newline character.
 */
bool UserPrefValues::autoAppendNewline()
{
   return readPref<bool>("auto_append_newline");
}

core::Error UserPrefValues::setAutoAppendNewline(bool val)
{
   return writePref("auto_append_newline", val);
}

/**
 * Whether to strip trailing whitespace from each line when saving.
 */
bool UserPrefValues::stripTrailingWhitespace()
{
   return readPref<bool>("strip_trailing_whitespace");
}

core::Error UserPrefValues::setStripTrailingWhitespace(bool val)
{
   return writePref("strip_trailing_whitespace", val);
}

/**
 * Whether to save the position of the cursor when a file is closed, restore it when the file is opened.
 */
bool UserPrefValues::restoreSourceDocumentCursorPosition()
{
   return readPref<bool>("restore_source_document_cursor_position");
}

core::Error UserPrefValues::setRestoreSourceDocumentCursorPosition(bool val)
{
   return writePref("restore_source_document_cursor_position", val);
}

/**
 * Whether to automatically re-indent code when it's pasted into RStudio.
 */
bool UserPrefValues::reindentOnPaste()
{
   return readPref<bool>("reindent_on_paste");
}

core::Error UserPrefValues::setReindentOnPaste(bool val)
{
   return writePref("reindent_on_paste", val);
}

/**
 * Whether to vertically align arguments to R function calls during automatic indentation.
 */
bool UserPrefValues::verticallyAlignArgumentsIndent()
{
   return readPref<bool>("vertically_align_arguments_indent");
}

core::Error UserPrefValues::setVerticallyAlignArgumentsIndent(bool val)
{
   return writePref("vertically_align_arguments_indent", val);
}

/**
 * Whether to soft-wrap R source files, wrapping the text for display without inserting newline characters.
 */
bool UserPrefValues::softWrapRFiles()
{
   return readPref<bool>("soft_wrap_r_files");
}

core::Error UserPrefValues::setSoftWrapRFiles(bool val)
{
   return writePref("soft_wrap_r_files", val);
}

/**
 * Whether to soft-wrap R Markdown files (and similar types such as R HTML and R Notebooks)
 */
bool UserPrefValues::softWrapRmdFiles()
{
   return readPref<bool>("soft_wrap_rmd_files");
}

core::Error UserPrefValues::setSoftWrapRmdFiles(bool val)
{
   return writePref("soft_wrap_rmd_files", val);
}

/**
 * Whether to focus the R console after executing an R command from a script.
 */
bool UserPrefValues::focusConsoleAfterExec()
{
   return readPref<bool>("focus_console_after_exec");
}

core::Error UserPrefValues::setFocusConsoleAfterExec(bool val)
{
   return writePref("focus_console_after_exec", val);
}

/**
 * The style of folding to use.
 */
std::string UserPrefValues::foldStyle()
{
   return readPref<std::string>("fold_style");
}

core::Error UserPrefValues::setFoldStyle(std::string val)
{
   return writePref("fold_style", val);
}

/**
 * Whether to automatically save scripts before executing them.
 */
bool UserPrefValues::saveBeforeSourcing()
{
   return readPref<bool>("save_before_sourcing");
}

core::Error UserPrefValues::setSaveBeforeSourcing(bool val)
{
   return writePref("save_before_sourcing", val);
}

/**
 * Whether to use syntax highlighting in the R console.
 */
bool UserPrefValues::syntaxColorConsole()
{
   return readPref<bool>("syntax_color_console");
}

core::Error UserPrefValues::setSyntaxColorConsole(bool val)
{
   return writePref("syntax_color_console", val);
}

/**
 * Whether to display error, warning, and message output in a different color.
 */
bool UserPrefValues::highlightConsoleErrors()
{
   return readPref<bool>("highlight_console_errors");
}

core::Error UserPrefValues::setHighlightConsoleErrors(bool val)
{
   return writePref("highlight_console_errors", val);
}

/**
 * Whether to allow scrolling past the end of a file.
 */
bool UserPrefValues::scrollPastEndOfDocument()
{
   return readPref<bool>("scroll_past_end_of_document");
}

core::Error UserPrefValues::setScrollPastEndOfDocument(bool val)
{
   return writePref("scroll_past_end_of_document", val);
}

/**
 * Whether to highlight R function calls in the code editor.
 */
bool UserPrefValues::highlightRFunctionCalls()
{
   return readPref<bool>("highlight_r_function_calls");
}

core::Error UserPrefValues::setHighlightRFunctionCalls(bool val)
{
   return writePref("highlight_r_function_calls", val);
}

/**
 * Whether to highlight parentheses in a variety of colors.
 */
bool UserPrefValues::rainbowParentheses()
{
   return readPref<bool>("rainbow_parentheses");
}

core::Error UserPrefValues::setRainbowParentheses(bool val)
{
   return writePref("rainbow_parentheses", val);
}

/**
 * The maximum number of characters to display in a single line in the R console.
 */
int UserPrefValues::consoleLineLengthLimit()
{
   return readPref<int>("console_line_length_limit");
}

core::Error UserPrefValues::setConsoleLineLengthLimit(int val)
{
   return writePref("console_line_length_limit", val);
}

/**
 * The maximum number of console actions to store and display in the console scrollback buffer.
 */
int UserPrefValues::consoleMaxLines()
{
   return readPref<int>("console_max_lines");
}

core::Error UserPrefValues::setConsoleMaxLines(int val)
{
   return writePref("console_max_lines", val);
}

/**
 * How to treat ANSI escape codes in the console.
 */
std::string UserPrefValues::ansiConsoleMode()
{
   return readPref<std::string>("ansi_console_mode");
}

core::Error UserPrefValues::setAnsiConsoleMode(std::string val)
{
   return writePref("ansi_console_mode", val);
}

/**
 * Whether to only show a limited window of the total console output
 */
bool UserPrefValues::limitVisibleConsole()
{
   return readPref<bool>("limit_visible_console");
}

core::Error UserPrefValues::setLimitVisibleConsole(bool val)
{
   return writePref("limit_visible_console", val);
}

/**
 * Whether to show a toolbar on code chunks in R Markdown documents.
 */
bool UserPrefValues::showInlineToolbarForRCodeChunks()
{
   return readPref<bool>("show_inline_toolbar_for_r_code_chunks");
}

core::Error UserPrefValues::setShowInlineToolbarForRCodeChunks(bool val)
{
   return writePref("show_inline_toolbar_for_r_code_chunks", val);
}

/**
 * Whether to highlight code chunks in R Markdown documents with a different background color.
 */
bool UserPrefValues::highlightCodeChunks()
{
   return readPref<bool>("highlight_code_chunks");
}

core::Error UserPrefValues::setHighlightCodeChunks(bool val)
{
   return writePref("highlight_code_chunks", val);
}

/**
 * Whether to save all open, unsaved files before building the project.
 */
bool UserPrefValues::saveFilesBeforeBuild()
{
   return readPref<bool>("save_files_before_build");
}

core::Error UserPrefValues::setSaveFilesBeforeBuild(bool val)
{
   return writePref("save_files_before_build", val);
}

/**
 * The default editor font size, in points.
 */
double UserPrefValues::fontSizePoints()
{
   return readPref<double>("font_size_points");
}

core::Error UserPrefValues::setFontSizePoints(double val)
{
   return writePref("font_size_points", val);
}

/**
 * The help panel font size, in points.
 */
double UserPrefValues::helpFontSizePoints()
{
   return readPref<double>("help_font_size_points");
}

core::Error UserPrefValues::setHelpFontSizePoints(double val)
{
   return writePref("help_font_size_points", val);
}

/**
 * The name of the color theme to apply to the text editor in RStudio.
 */
std::string UserPrefValues::editorTheme()
{
   return readPref<std::string>("editor_theme");
}

core::Error UserPrefValues::setEditorTheme(std::string val)
{
   return writePref("editor_theme", val);
}

/**
 * Whether to use a custom editor font in RStudio Server.
 */
bool UserPrefValues::serverEditorFontEnabled()
{
   return readPref<bool>("server_editor_font_enabled");
}

core::Error UserPrefValues::setServerEditorFontEnabled(bool val)
{
   return writePref("server_editor_font_enabled", val);
}

/**
 * The name of the fixed-width editor font to use with RStudio Server.
 */
std::string UserPrefValues::serverEditorFont()
{
   return readPref<std::string>("server_editor_font");
}

core::Error UserPrefValues::setServerEditorFont(std::string val)
{
   return writePref("server_editor_font", val);
}

/**
 * The default character encoding to use when saving files.
 */
std::string UserPrefValues::defaultEncoding()
{
   return readPref<std::string>("default_encoding");
}

core::Error UserPrefValues::setDefaultEncoding(std::string val)
{
   return writePref("default_encoding", val);
}

/**
 * Whether to show the toolbar at the top of the RStudio workbench.
 */
bool UserPrefValues::toolbarVisible()
{
   return readPref<bool>("toolbar_visible");
}

core::Error UserPrefValues::setToolbarVisible(bool val)
{
   return writePref("toolbar_visible", val);
}

/**
 * The directory path under which to place new projects by default.
 */
std::string UserPrefValues::defaultProjectLocation()
{
   return readPref<std::string>("default_project_location");
}

core::Error UserPrefValues::setDefaultProjectLocation(std::string val)
{
   return writePref("default_project_location", val);
}

/**
 * Whether to echo R code when sourcing it.
 */
bool UserPrefValues::sourceWithEcho()
{
   return readPref<bool>("source_with_echo");
}

core::Error UserPrefValues::setSourceWithEcho(bool val)
{
   return writePref("source_with_echo", val);
}

/**
 * The default engine to use when processing Sweave documents.
 */
std::string UserPrefValues::defaultSweaveEngine()
{
   return readPref<std::string>("default_sweave_engine");
}

core::Error UserPrefValues::setDefaultSweaveEngine(std::string val)
{
   return writePref("default_sweave_engine", val);
}

/**
 * The default program to use when processing LaTeX documents.
 */
std::string UserPrefValues::defaultLatexProgram()
{
   return readPref<std::string>("default_latex_program");
}

core::Error UserPrefValues::setDefaultLatexProgram(std::string val)
{
   return writePref("default_latex_program", val);
}

/**
 * Whether to use Roxygen for documentation.
 */
bool UserPrefValues::useRoxygen()
{
   return readPref<bool>("use_roxygen");
}

core::Error UserPrefValues::setUseRoxygen(bool val)
{
   return writePref("use_roxygen", val);
}

/**
 * Whether to use RStudio's data import feature.
 */
bool UserPrefValues::useDataimport()
{
   return readPref<bool>("use_dataimport");
}

core::Error UserPrefValues::setUseDataimport(bool val)
{
   return writePref("use_dataimport", val);
}

/**
 * The program to use to preview PDF files after generation.
 */
std::string UserPrefValues::pdfPreviewer()
{
   return readPref<std::string>("pdf_previewer");
}

core::Error UserPrefValues::setPdfPreviewer(std::string val)
{
   return writePref("pdf_previewer", val);
}

/**
 * Whether to always enable the concordance for RNW files.
 */
bool UserPrefValues::alwaysEnableRnwConcordance()
{
   return readPref<bool>("always_enable_rnw_concordance");
}

core::Error UserPrefValues::setAlwaysEnableRnwConcordance(bool val)
{
   return writePref("always_enable_rnw_concordance", val);
}

/**
 * Whether to insert numbered sections in LaTeX.
 */
bool UserPrefValues::insertNumberedLatexSections()
{
   return readPref<bool>("insert_numbered_latex_sections");
}

core::Error UserPrefValues::setInsertNumberedLatexSections(bool val)
{
   return writePref("insert_numbered_latex_sections", val);
}

/**
 * The language of the spelling dictionary to use for spell checking.
 */
std::string UserPrefValues::spellingDictionaryLanguage()
{
   return readPref<std::string>("spelling_dictionary_language");
}

core::Error UserPrefValues::setSpellingDictionaryLanguage(std::string val)
{
   return writePref("spelling_dictionary_language", val);
}

/**
 * The list of custom dictionaries to use when spell checking.
 */
core::json::Array UserPrefValues::spellingCustomDictionaries()
{
   return readPref<core::json::Array>("spelling_custom_dictionaries");
}

core::Error UserPrefValues::setSpellingCustomDictionaries(core::json::Array val)
{
   return writePref("spelling_custom_dictionaries", val);
}

/**
 * The number of milliseconds to wait before linting a document after it is loaded.
 */
int UserPrefValues::documentLoadLintDelay()
{
   return readPref<int>("document_load_lint_delay");
}

core::Error UserPrefValues::setDocumentLoadLintDelay(int val)
{
   return writePref("document_load_lint_delay", val);
}

/**
 * Whether to ignore words in uppercase when spell checking.
 */
bool UserPrefValues::ignoreUppercaseWords()
{
   return readPref<bool>("ignore_uppercase_words");
}

core::Error UserPrefValues::setIgnoreUppercaseWords(bool val)
{
   return writePref("ignore_uppercase_words", val);
}

/**
 * Whether to ignore words with numbers in them when spell checking.
 */
bool UserPrefValues::ignoreWordsWithNumbers()
{
   return readPref<bool>("ignore_words_with_numbers");
}

core::Error UserPrefValues::setIgnoreWordsWithNumbers(bool val)
{
   return writePref("ignore_words_with_numbers", val);
}

/**
 * Whether to enable real-time spellchecking by default.
 */
bool UserPrefValues::realTimeSpellchecking()
{
   return readPref<bool>("real_time_spellchecking");
}

core::Error UserPrefValues::setRealTimeSpellchecking(bool val)
{
   return writePref("real_time_spellchecking", val);
}

/**
 * Whether to navigate to build errors.
 */
bool UserPrefValues::navigateToBuildError()
{
   return readPref<bool>("navigate_to_build_error");
}

core::Error UserPrefValues::setNavigateToBuildError(bool val)
{
   return writePref("navigate_to_build_error", val);
}

/**
 * Whether to enable RStudio's Packages pane.
 */
bool UserPrefValues::packagesPaneEnabled()
{
   return readPref<bool>("packages_pane_enabled");
}

core::Error UserPrefValues::setPackagesPaneEnabled(bool val)
{
   return writePref("packages_pane_enabled", val);
}

/**
 * C++ template.
 */
std::string UserPrefValues::cppTemplate()
{
   return readPref<std::string>("cpp_template");
}

core::Error UserPrefValues::setCppTemplate(std::string val)
{
   return writePref("cpp_template", val);
}

/**
 * Whether to restore the last opened source documents when RStudio starts up.
 */
bool UserPrefValues::restoreSourceDocuments()
{
   return readPref<bool>("restore_source_documents");
}

core::Error UserPrefValues::setRestoreSourceDocuments(bool val)
{
   return writePref("restore_source_documents", val);
}

/**
 * Whether to handle errors only when user code is on the stack.
 */
bool UserPrefValues::handleErrorsInUserCodeOnly()
{
   return readPref<bool>("handle_errors_in_user_code_only");
}

core::Error UserPrefValues::setHandleErrorsInUserCodeOnly(bool val)
{
   return writePref("handle_errors_in_user_code_only", val);
}

/**
 * Whether to automatically expand tracebacks when an error occurs.
 */
bool UserPrefValues::autoExpandErrorTracebacks()
{
   return readPref<bool>("auto_expand_error_tracebacks");
}

core::Error UserPrefValues::setAutoExpandErrorTracebacks(bool val)
{
   return writePref("auto_expand_error_tracebacks", val);
}

/**
 * Whether to check for new versions of RStudio when RStudio starts.
 */
bool UserPrefValues::checkForUpdates()
{
   return readPref<bool>("check_for_updates");
}

core::Error UserPrefValues::setCheckForUpdates(bool val)
{
   return writePref("check_for_updates", val);
}

/**
 * Whether to show functions without source references in the Traceback pane while debugging.
 */
bool UserPrefValues::showInternalFunctions()
{
   return readPref<bool>("show_internal_functions");
}

core::Error UserPrefValues::setShowInternalFunctions(bool val)
{
   return writePref("show_internal_functions", val);
}

/**
 * Where to display Shiny applications when they are run.
 */
std::string UserPrefValues::shinyViewerType()
{
   return readPref<std::string>("shiny_viewer_type");
}

core::Error UserPrefValues::setShinyViewerType(std::string val)
{
   return writePref("shiny_viewer_type", val);
}

/**
 * Whether to run Shiny applications as background jobs.
 */
bool UserPrefValues::shinyBackgroundJobs()
{
   return readPref<bool>("shiny_background_jobs");
}

core::Error UserPrefValues::setShinyBackgroundJobs(bool val)
{
   return writePref("shiny_background_jobs", val);
}

/**
 * Where to display Shiny applications when they are run.
 */
std::string UserPrefValues::plumberViewerType()
{
   return readPref<std::string>("plumber_viewer_type");
}

core::Error UserPrefValues::setPlumberViewerType(std::string val)
{
   return writePref("plumber_viewer_type", val);
}

/**
 * The default name to use as the document author when creating new documents.
 */
std::string UserPrefValues::documentAuthor()
{
   return readPref<std::string>("document_author");
}

core::Error UserPrefValues::setDocumentAuthor(std::string val)
{
   return writePref("document_author", val);
}

/**
 * Use current date when rendering document
 */
bool UserPrefValues::rmdAutoDate()
{
   return readPref<bool>("rmd_auto_date");
}

core::Error UserPrefValues::setRmdAutoDate(bool val)
{
   return writePref("rmd_auto_date", val);
}

/**
 * The path to the preferred R Markdown template.
 */
std::string UserPrefValues::rmdPreferredTemplatePath()
{
   return readPref<std::string>("rmd_preferred_template_path");
}

core::Error UserPrefValues::setRmdPreferredTemplatePath(std::string val)
{
   return writePref("rmd_preferred_template_path", val);
}

/**
 * Where to display R Markdown documents when they have completed rendering.
 */
std::string UserPrefValues::rmdViewerType()
{
   return readPref<std::string>("rmd_viewer_type");
}

core::Error UserPrefValues::setRmdViewerType(std::string val)
{
   return writePref("rmd_viewer_type", val);
}

/**
 * Whether to show verbose diagnostic information when publishing content.
 */
bool UserPrefValues::showPublishDiagnostics()
{
   return readPref<bool>("show_publish_diagnostics");
}

core::Error UserPrefValues::setShowPublishDiagnostics(bool val)
{
   return writePref("show_publish_diagnostics", val);
}

/**
 * Whether to check remote server SSL certificates when publishing content.
 */
bool UserPrefValues::publishCheckCertificates()
{
   return readPref<bool>("publish_check_certificates");
}

core::Error UserPrefValues::setPublishCheckCertificates(bool val)
{
   return writePref("publish_check_certificates", val);
}

/**
 * Whether to use a custom certificate authority (CA) bundle when publishing content.
 */
bool UserPrefValues::usePublishCaBundle()
{
   return readPref<bool>("use_publish_ca_bundle");
}

core::Error UserPrefValues::setUsePublishCaBundle(bool val)
{
   return writePref("use_publish_ca_bundle", val);
}

/**
 * The path to the custom certificate authority (CA) bundle to use when publishing content.
 */
std::string UserPrefValues::publishCaBundle()
{
   return readPref<std::string>("publish_ca_bundle");
}

core::Error UserPrefValues::setPublishCaBundle(std::string val)
{
   return writePref("publish_ca_bundle", val);
}

/**
 * Whether to show chunk output inline for ordinary R Markdown documents.
 */
bool UserPrefValues::rmdChunkOutputInline()
{
   return readPref<bool>("rmd_chunk_output_inline");
}

core::Error UserPrefValues::setRmdChunkOutputInline(bool val)
{
   return writePref("rmd_chunk_output_inline", val);
}

/**
 * Whether to show the document outline by default when opening R Markdown documents.
 */
bool UserPrefValues::showDocOutlineRmd()
{
   return readPref<bool>("show_doc_outline_rmd");
}

core::Error UserPrefValues::setShowDocOutlineRmd(bool val)
{
   return writePref("show_doc_outline_rmd", val);
}

/**
 * Whether to automatically run an R Markdown document's Setup chunk before running other chunks.
 */
bool UserPrefValues::autoRunSetupChunk()
{
   return readPref<bool>("auto_run_setup_chunk");
}

core::Error UserPrefValues::setAutoRunSetupChunk(bool val)
{
   return writePref("auto_run_setup_chunk", val);
}

/**
 * Whether to hide the R console when executing inline R Markdown chunks.
 */
bool UserPrefValues::hideConsoleOnChunkExecute()
{
   return readPref<bool>("hide_console_on_chunk_execute");
}

core::Error UserPrefValues::setHideConsoleOnChunkExecute(bool val)
{
   return writePref("hide_console_on_chunk_execute", val);
}

/**
 * The unit of R code to execute when the Execute command is invoked.
 */
std::string UserPrefValues::executionBehavior()
{
   return readPref<std::string>("execution_behavior");
}

core::Error UserPrefValues::setExecutionBehavior(std::string val)
{
   return writePref("execution_behavior", val);
}

/**
 * Whether to show the Terminal tab.
 */
bool UserPrefValues::showTerminalTab()
{
   return readPref<bool>("show_terminal_tab");
}

core::Error UserPrefValues::setShowTerminalTab(bool val)
{
   return writePref("show_terminal_tab", val);
}

/**
 * Whether to use local echo in the Terminal.
 */
bool UserPrefValues::terminalLocalEcho()
{
   return readPref<bool>("terminal_local_echo");
}

core::Error UserPrefValues::setTerminalLocalEcho(bool val)
{
   return writePref("terminal_local_echo", val);
}

/**
 * Whether to use websockets to communicate with the shell in the Terminal tab.
 */
bool UserPrefValues::terminalWebsockets()
{
   return readPref<bool>("terminal_websockets");
}

core::Error UserPrefValues::setTerminalWebsockets(bool val)
{
   return writePref("terminal_websockets", val);
}

/**
 * Whether to close the terminal pane after the shell exits.
 */
std::string UserPrefValues::terminalCloseBehavior()
{
   return readPref<std::string>("terminal_close_behavior");
}

core::Error UserPrefValues::setTerminalCloseBehavior(std::string val)
{
   return writePref("terminal_close_behavior", val);
}

/**
 * Whether to track and save changes to system environment variables in the Terminal.
 */
bool UserPrefValues::terminalTrackEnvironment()
{
   return readPref<bool>("terminal_track_environment");
}

core::Error UserPrefValues::setTerminalTrackEnvironment(bool val)
{
   return writePref("terminal_track_environment", val);
}

/**
 * Terminal bell style
 */
std::string UserPrefValues::terminalBellStyle()
{
   return readPref<std::string>("terminal_bell_style");
}

core::Error UserPrefValues::setTerminalBellStyle(std::string val)
{
   return writePref("terminal_bell_style", val);
}

/**
 * Terminal rendering engine: canvas is faster, dom may be needed for some browsers or graphics cards
 */
std::string UserPrefValues::terminalRenderer()
{
   return readPref<std::string>("terminal_renderer");
}

core::Error UserPrefValues::setTerminalRenderer(std::string val)
{
   return writePref("terminal_renderer", val);
}

/**
 * Whether web links displayed in the Terminal tab are made clickable.
 */
bool UserPrefValues::terminalWeblinks()
{
   return readPref<bool>("terminal_weblinks");
}

core::Error UserPrefValues::setTerminalWeblinks(bool val)
{
   return writePref("terminal_weblinks", val);
}

/**
 * Whether to print the render command use to knit R Markdown documents in the R Markdown tab.
 */
bool UserPrefValues::showRmdRenderCommand()
{
   return readPref<bool>("show_rmd_render_command");
}

core::Error UserPrefValues::setShowRmdRenderCommand(bool val)
{
   return writePref("show_rmd_render_command", val);
}

/**
 * Whether to enable moving text on the editing surface by clicking and dragging it.
 */
bool UserPrefValues::enableTextDrag()
{
   return readPref<bool>("enable_text_drag");
}

core::Error UserPrefValues::setEnableTextDrag(bool val)
{
   return writePref("enable_text_drag", val);
}

/**
 * Whether to show hidden files in the Files pane.
 */
bool UserPrefValues::showHiddenFiles()
{
   return readPref<bool>("show_hidden_files");
}

core::Error UserPrefValues::setShowHiddenFiles(bool val)
{
   return writePref("show_hidden_files", val);
}

/**
 * List of file names (case sensitive) that are always shown in the Files Pane, regardless of whether hidden files are shown
 */
core::json::Array UserPrefValues::alwaysShownFiles()
{
   return readPref<core::json::Array>("always_shown_files");
}

core::Error UserPrefValues::setAlwaysShownFiles(core::json::Array val)
{
   return writePref("always_shown_files", val);
}

/**
 * List of file extensions (beginning with ., not case sensitive) that are always shown in the Files Pane, regardless of whether hidden files are shown
 */
core::json::Array UserPrefValues::alwaysShownExtensions()
{
   return readPref<core::json::Array>("always_shown_extensions");
}

core::Error UserPrefValues::setAlwaysShownExtensions(core::json::Array val)
{
   return writePref("always_shown_extensions", val);
}

/**
 * Whether to sort file names naturally, so that e.g., file10.R comes after file9.R
 */
bool UserPrefValues::sortFileNamesNaturally()
{
   return readPref<bool>("sort_file_names_naturally");
}

core::Error UserPrefValues::setSortFileNamesNaturally(bool val)
{
   return writePref("sort_file_names_naturally", val);
}

/**
 * Whether to change the directory in the Files pane automatically when the working directory in R changes.
 */
bool UserPrefValues::syncFilesPaneWorkingDir()
{
   return readPref<bool>("sync_files_pane_working_dir");
}

core::Error UserPrefValues::setSyncFilesPaneWorkingDir(bool val)
{
   return writePref("sync_files_pane_working_dir", val);
}

/**
 * The visibility of the Jobs tab.
 */
std::string UserPrefValues::jobsTabVisibility()
{
   return readPref<std::string>("jobs_tab_visibility");
}

core::Error UserPrefValues::setJobsTabVisibility(std::string val)
{
   return writePref("jobs_tab_visibility", val);
}

/**
 * Whether to show the Launcher jobs tab in RStudio Pro and RStudio Workbench.
 */
bool UserPrefValues::showLauncherJobsTab()
{
   return readPref<bool>("show_launcher_jobs_tab");
}

core::Error UserPrefValues::setShowLauncherJobsTab(bool val)
{
   return writePref("show_launcher_jobs_tab", val);
}

/**
 * How to sort jobs in the Launcher tab in RStudio Pro and RStudio Workbench.
 */
std::string UserPrefValues::launcherJobsSort()
{
   return readPref<std::string>("launcher_jobs_sort");
}

core::Error UserPrefValues::setLauncherJobsSort(std::string val)
{
   return writePref("launcher_jobs_sort", val);
}

/**
 * How to detect busy status in the Terminal.
 */
std::string UserPrefValues::busyDetection()
{
   return readPref<std::string>("busy_detection");
}

core::Error UserPrefValues::setBusyDetection(std::string val)
{
   return writePref("busy_detection", val);
}

/**
 * A list of apps that should not be considered busy in the Terminal.
 */
core::json::Array UserPrefValues::busyExclusionList()
{
   return readPref<core::json::Array>("busy_exclusion_list");
}

core::Error UserPrefValues::setBusyExclusionList(core::json::Array val)
{
   return writePref("busy_exclusion_list", val);
}

/**
 * The working directory to use when knitting R Markdown documents.
 */
std::string UserPrefValues::knitWorkingDir()
{
   return readPref<std::string>("knit_working_dir");
}

core::Error UserPrefValues::setKnitWorkingDir(std::string val)
{
   return writePref("knit_working_dir", val);
}

/**
 * Which objects to show in the document outline pane.
 */
std::string UserPrefValues::docOutlineShow()
{
   return readPref<std::string>("doc_outline_show");
}

core::Error UserPrefValues::setDocOutlineShow(std::string val)
{
   return writePref("doc_outline_show", val);
}

/**
 * When to preview LaTeX mathematical equations when cursor has not moved recently.
 */
std::string UserPrefValues::latexPreviewOnCursorIdle()
{
   return readPref<std::string>("latex_preview_on_cursor_idle");
}

core::Error UserPrefValues::setLatexPreviewOnCursorIdle(std::string val)
{
   return writePref("latex_preview_on_cursor_idle", val);
}

/**
 * Whether to wrap around when going to the previous or next editor tab.
 */
bool UserPrefValues::wrapTabNavigation()
{
   return readPref<bool>("wrap_tab_navigation");
}

core::Error UserPrefValues::setWrapTabNavigation(bool val)
{
   return writePref("wrap_tab_navigation", val);
}

/**
 * The theme to use for the main RStudio user interface.
 */
std::string UserPrefValues::globalTheme()
{
   return readPref<std::string>("global_theme");
}

core::Error UserPrefValues::setGlobalTheme(std::string val)
{
   return writePref("global_theme", val);
}

/**
 * Whether to ignore whitespace when generating diffs of version controlled files.
 */
bool UserPrefValues::gitDiffIgnoreWhitespace()
{
   return readPref<bool>("git_diff_ignore_whitespace");
}

core::Error UserPrefValues::setGitDiffIgnoreWhitespace(bool val)
{
   return writePref("git_diff_ignore_whitespace", val);
}

/**
 * Whether double-clicking should select a word in the Console pane.
 */
bool UserPrefValues::consoleDoubleClickSelect()
{
   return readPref<bool>("console_double_click_select");
}

core::Error UserPrefValues::setConsoleDoubleClickSelect(bool val)
{
   return writePref("console_double_click_select", val);
}

/**
 * Whether the 'Auto Suspension Blocked' icon should appear in the R Console toolbar.
 */
bool UserPrefValues::consoleSuspendBlockedNotice()
{
   return readPref<bool>("console_suspend_blocked_notice");
}

core::Error UserPrefValues::setConsoleSuspendBlockedNotice(bool val)
{
   return writePref("console_suspend_blocked_notice", val);
}

/**
 * How long to wait before warning that automatic session suspension has been paused. Higher values for less frequent notices.
 */
int UserPrefValues::consoleSuspendBlockedNoticeDelay()
{
   return readPref<int>("console_suspend_blocked_notice_delay");
}

core::Error UserPrefValues::setConsoleSuspendBlockedNoticeDelay(int val)
{
   return writePref("console_suspend_blocked_notice_delay", val);
}

/**
 * Whether a git repo should be initialized inside new projects by default.
 */
bool UserPrefValues::newProjGitInit()
{
   return readPref<bool>("new_proj_git_init");
}

core::Error UserPrefValues::setNewProjGitInit(bool val)
{
   return writePref("new_proj_git_init", val);
}

/**
 * Whether an renv environment should be created inside new projects by default.
 */
bool UserPrefValues::newProjUseRenv()
{
   return readPref<bool>("new_proj_use_renv");
}

core::Error UserPrefValues::setNewProjUseRenv(bool val)
{
   return writePref("new_proj_use_renv", val);
}

/**
 * The root document to use when compiling PDF documents.
 */
std::string UserPrefValues::rootDocument()
{
   return readPref<std::string>("root_document");
}

core::Error UserPrefValues::setRootDocument(std::string val)
{
   return writePref("root_document", val);
}

/**
 * When to show the server home page in RStudio Workbench.
 */
std::string UserPrefValues::showUserHomePage()
{
   return readPref<std::string>("show_user_home_page");
}

core::Error UserPrefValues::setShowUserHomePage(std::string val)
{
   return writePref("show_user_home_page", val);
}

/**
 * Whether to reuse sessions when opening projects in RStudio Workbench.
 */
bool UserPrefValues::reuseSessionsForProjectLinks()
{
   return readPref<bool>("reuse_sessions_for_project_links");
}

core::Error UserPrefValues::setReuseSessionsForProjectLinks(bool val)
{
   return writePref("reuse_sessions_for_project_links", val);
}

/**
 * Whether to enable RStudio's version control system interface.
 */
bool UserPrefValues::vcsEnabled()
{
   return readPref<bool>("vcs_enabled");
}

core::Error UserPrefValues::setVcsEnabled(bool val)
{
   return writePref("vcs_enabled", val);
}

/**
 * Automatically refresh VCS status?
 */
bool UserPrefValues::vcsAutorefresh()
{
   return readPref<bool>("vcs_autorefresh");
}

core::Error UserPrefValues::setVcsAutorefresh(bool val)
{
   return writePref("vcs_autorefresh", val);
}

/**
 * The path to the Git executable to use.
 */
std::string UserPrefValues::gitExePath()
{
   return readPref<std::string>("git_exe_path");
}

core::Error UserPrefValues::setGitExePath(std::string val)
{
   return writePref("git_exe_path", val);
}

/**
 * The path to the Subversion executable to use.
 */
std::string UserPrefValues::svnExePath()
{
   return readPref<std::string>("svn_exe_path");
}

core::Error UserPrefValues::setSvnExePath(std::string val)
{
   return writePref("svn_exe_path", val);
}

/**
 * The path to the terminal executable to use.
 */
std::string UserPrefValues::terminalPath()
{
   return readPref<std::string>("terminal_path");
}

core::Error UserPrefValues::setTerminalPath(std::string val)
{
   return writePref("terminal_path", val);
}

/**
 * The path to the RSA key file to use.
 */
std::string UserPrefValues::rsaKeyPath()
{
   return readPref<std::string>("rsa_key_path");
}

core::Error UserPrefValues::setRsaKeyPath(std::string val)
{
   return writePref("rsa_key_path", val);
}

/**
 * Whether to use the devtools R package.
 */
bool UserPrefValues::useDevtools()
{
   return readPref<bool>("use_devtools");
}

core::Error UserPrefValues::setUseDevtools(bool val)
{
   return writePref("use_devtools", val);
}

/**
 * Whether to use Internet2 for networking on R for Windows.
 */
bool UserPrefValues::useInternet2()
{
   return readPref<bool>("use_internet2");
}

core::Error UserPrefValues::setUseInternet2(bool val)
{
   return writePref("use_internet2", val);
}

/**
 * Whether to use secure downloads when fetching R packages.
 */
bool UserPrefValues::useSecureDownload()
{
   return readPref<bool>("use_secure_download");
}

core::Error UserPrefValues::setUseSecureDownload(bool val)
{
   return writePref("use_secure_download", val);
}

/**
 * Whether to clean up temporary files after running R CMD CHECK.
 */
bool UserPrefValues::cleanupAfterRCmdCheck()
{
   return readPref<bool>("cleanup_after_r_cmd_check");
}

core::Error UserPrefValues::setCleanupAfterRCmdCheck(bool val)
{
   return writePref("cleanup_after_r_cmd_check", val);
}

/**
 * Whether to view the directory after running R CMD CHECK.
 */
bool UserPrefValues::viewDirAfterRCmdCheck()
{
   return readPref<bool>("view_dir_after_r_cmd_check");
}

core::Error UserPrefValues::setViewDirAfterRCmdCheck(bool val)
{
   return writePref("view_dir_after_r_cmd_check", val);
}

/**
 * Whether to hide object files in the Files pane.
 */
bool UserPrefValues::hideObjectFiles()
{
   return readPref<bool>("hide_object_files");
}

core::Error UserPrefValues::setHideObjectFiles(bool val)
{
   return writePref("hide_object_files", val);
}

/**
 * Whether to restore the last project when starting RStudio.
 */
bool UserPrefValues::restoreLastProject()
{
   return readPref<bool>("restore_last_project");
}

core::Error UserPrefValues::setRestoreLastProject(bool val)
{
   return writePref("restore_last_project", val);
}

/**
 * The number of seconds after which a project is deemed to have successfully started.
 */
int UserPrefValues::projectSafeStartupSeconds()
{
   return readPref<int>("project_safe_startup_seconds");
}

core::Error UserPrefValues::setProjectSafeStartupSeconds(int val)
{
   return writePref("project_safe_startup_seconds", val);
}

/**
 * Use tinytex to compile .tex files.
 */
bool UserPrefValues::useTinytex()
{
   return readPref<bool>("use_tinytex");
}

core::Error UserPrefValues::setUseTinytex(bool val)
{
   return writePref("use_tinytex", val);
}

/**
 * Whether to clean output after running Texi2Dvi.
 */
bool UserPrefValues::cleanTexi2dviOutput()
{
   return readPref<bool>("clean_texi2dvi_output");
}

core::Error UserPrefValues::setCleanTexi2dviOutput(bool val)
{
   return writePref("clean_texi2dvi_output", val);
}

/**
 * Whether to enable shell escaping with LaTeX documents.
 */
bool UserPrefValues::latexShellEscape()
{
   return readPref<bool>("latex_shell_escape");
}

core::Error UserPrefValues::setLatexShellEscape(bool val)
{
   return writePref("latex_shell_escape", val);
}

/**
 * Whether to restore the last version of R used by the project in RStudio Pro and RStudio Workbench.
 */
bool UserPrefValues::restoreProjectRVersion()
{
   return readPref<bool>("restore_project_r_version");
}

core::Error UserPrefValues::setRestoreProjectRVersion(bool val)
{
   return writePref("restore_project_r_version", val);
}

/**
 * The verbosity level to use with Clang (0 - 2)
 */
int UserPrefValues::clangVerbose()
{
   return readPref<int>("clang_verbose");
}

core::Error UserPrefValues::setClangVerbose(int val)
{
   return writePref("clang_verbose", val);
}

/**
 * Whether to automatically submit crash reports to RStudio.
 */
bool UserPrefValues::submitCrashReports()
{
   return readPref<bool>("submit_crash_reports");
}

core::Error UserPrefValues::setSubmitCrashReports(bool val)
{
   return writePref("submit_crash_reports", val);
}

/**
 * The R version to use by default.
 */
core::json::Object UserPrefValues::defaultRVersion()
{
   return readPref<core::json::Object>("default_r_version");
}

core::Error UserPrefValues::setDefaultRVersion(core::json::Object val)
{
   return writePref("default_r_version", val);
}

/**
 * The maximum number of columns to show at once in the data viewer.
 */
int UserPrefValues::dataViewerMaxColumns()
{
   return readPref<int>("data_viewer_max_columns");
}

core::Error UserPrefValues::setDataViewerMaxColumns(int val)
{
   return writePref("data_viewer_max_columns", val);
}

/**
 * Support accessibility aids such as screen readers (RStudio Server).
 */
bool UserPrefValues::enableScreenReader()
{
   return readPref<bool>("enable_screen_reader");
}

core::Error UserPrefValues::setEnableScreenReader(bool val)
{
   return writePref("enable_screen_reader", val);
}

/**
 * Number of milliseconds to wait after last keystroke before updating live region.
 */
int UserPrefValues::typingStatusDelayMs()
{
   return readPref<int>("typing_status_delay_ms");
}

core::Error UserPrefValues::setTypingStatusDelayMs(int val)
{
   return writePref("typing_status_delay_ms", val);
}

/**
 * Reduce use of animations in the user interface.
 */
bool UserPrefValues::reducedMotion()
{
   return readPref<bool>("reduced_motion");
}

core::Error UserPrefValues::setReducedMotion(bool val)
{
   return writePref("reduced_motion", val);
}

/**
 * Tab key moves focus out of text editing controls instead of inserting tabs.
 */
bool UserPrefValues::tabKeyMoveFocus()
{
   return readPref<bool>("tab_key_move_focus");
}

core::Error UserPrefValues::setTabKeyMoveFocus(bool val)
{
   return writePref("tab_key_move_focus", val);
}

/**
 * In source editor find panel, tab key moves focus directly from find text to replace text.
 */
bool UserPrefValues::findPanelLegacyTabSequence()
{
   return readPref<bool>("find_panel_legacy_tab_sequence");
}

core::Error UserPrefValues::setFindPanelLegacyTabSequence(bool val)
{
   return writePref("find_panel_legacy_tab_sequence", val);
}

/**
 * Control with keyboard focus displays a visual focus indicator.
 */
bool UserPrefValues::showFocusRectangles()
{
   return readPref<bool>("show_focus_rectangles");
}

core::Error UserPrefValues::setShowFocusRectangles(bool val)
{
   return writePref("show_focus_rectangles", val);
}

/**
 * Show which panel contains keyboard focus.
 */
bool UserPrefValues::showPanelFocusRectangle()
{
   return readPref<bool>("show_panel_focus_rectangle");
}

core::Error UserPrefValues::setShowPanelFocusRectangle(bool val)
{
   return writePref("show_panel_focus_rectangle", val);
}

/**
 * How to deal with changes to documents on idle.
 */
std::string UserPrefValues::autoSaveOnIdle()
{
   return readPref<std::string>("auto_save_on_idle");
}

core::Error UserPrefValues::setAutoSaveOnIdle(std::string val)
{
   return writePref("auto_save_on_idle", val);
}

/**
 * The idle period, in milliseconds, after which documents should be auto-saved.
 */
int UserPrefValues::autoSaveIdleMs()
{
   return readPref<int>("auto_save_idle_ms");
}

core::Error UserPrefValues::setAutoSaveIdleMs(int val)
{
   return writePref("auto_save_idle_ms", val);
}

/**
 * Whether to automatically save when the editor loses focus.
 */
bool UserPrefValues::autoSaveOnBlur()
{
   return readPref<bool>("auto_save_on_blur");
}

core::Error UserPrefValues::setAutoSaveOnBlur(bool val)
{
   return writePref("auto_save_on_blur", val);
}

/**
 * Initial directory for new terminals.
 */
std::string UserPrefValues::terminalInitialDirectory()
{
   return readPref<std::string>("terminal_initial_directory");
}

core::Error UserPrefValues::setTerminalInitialDirectory(std::string val)
{
   return writePref("terminal_initial_directory", val);
}

/**
 * Whether to show the full path to project in desktop window title.
 */
bool UserPrefValues::fullProjectPathInWindowTitle()
{
   return readPref<bool>("full_project_path_in_window_title");
}

core::Error UserPrefValues::setFullProjectPathInWindowTitle(bool val)
{
   return writePref("full_project_path_in_window_title", val);
}

/**
 * Whether to enable visual editing by default for new markdown documents
 */
bool UserPrefValues::visualMarkdownEditingIsDefault()
{
   return readPref<bool>("visual_markdown_editing_is_default");
}

core::Error UserPrefValues::setVisualMarkdownEditingIsDefault(bool val)
{
   return writePref("visual_markdown_editing_is_default", val);
}

/**
 * Default spacing for lists created in the visual editor
 */
std::string UserPrefValues::visualMarkdownEditingListSpacing()
{
   return readPref<std::string>("visual_markdown_editing_list_spacing");
}

core::Error UserPrefValues::setVisualMarkdownEditingListSpacing(std::string val)
{
   return writePref("visual_markdown_editing_list_spacing", val);
}

/**
 * Whether to automatically wrap text when writing markdown
 */
std::string UserPrefValues::visualMarkdownEditingWrap()
{
   return readPref<std::string>("visual_markdown_editing_wrap");
}

core::Error UserPrefValues::setVisualMarkdownEditingWrap(std::string val)
{
   return writePref("visual_markdown_editing_wrap", val);
}

/**
 * The column to wrap text at when writing markdown
 */
int UserPrefValues::visualMarkdownEditingWrapAtColumn()
{
   return readPref<int>("visual_markdown_editing_wrap_at_column");
}

core::Error UserPrefValues::setVisualMarkdownEditingWrapAtColumn(int val)
{
   return writePref("visual_markdown_editing_wrap_at_column", val);
}

/**
 * Placement of footnotes within markdown output.
 */
std::string UserPrefValues::visualMarkdownEditingReferencesLocation()
{
   return readPref<std::string>("visual_markdown_editing_references_location");
}

core::Error UserPrefValues::setVisualMarkdownEditingReferencesLocation(std::string val)
{
   return writePref("visual_markdown_editing_references_location", val);
}

/**
 * Whether to write canonical visual mode markdown when saving from source mode.
 */
bool UserPrefValues::visualMarkdownEditingCanonical()
{
   return readPref<bool>("visual_markdown_editing_canonical");
}

core::Error UserPrefValues::setVisualMarkdownEditingCanonical(bool val)
{
   return writePref("visual_markdown_editing_canonical", val);
}

/**
 * Maximum content width for visual editing mode, in pixels
 */
int UserPrefValues::visualMarkdownEditingMaxContentWidth()
{
   return readPref<int>("visual_markdown_editing_max_content_width");
}

core::Error UserPrefValues::setVisualMarkdownEditingMaxContentWidth(int val)
{
   return writePref("visual_markdown_editing_max_content_width", val);
}

/**
 * Whether to show the document outline by default when opening R Markdown documents in visual mode.
 */
bool UserPrefValues::visualMarkdownEditingShowDocOutline()
{
   return readPref<bool>("visual_markdown_editing_show_doc_outline");
}

core::Error UserPrefValues::setVisualMarkdownEditingShowDocOutline(bool val)
{
   return writePref("visual_markdown_editing_show_doc_outline", val);
}

/**
 * Whether to show the margin guide in the visual mode code blocks.
 */
bool UserPrefValues::visualMarkdownEditingShowMargin()
{
   return readPref<bool>("visual_markdown_editing_show_margin");
}

core::Error UserPrefValues::setVisualMarkdownEditingShowMargin(bool val)
{
   return writePref("visual_markdown_editing_show_margin", val);
}

/**
 * Whether to show line numbers in the code editors used in visual mode
 */
bool UserPrefValues::visualMarkdownCodeEditorLineNumbers()
{
   return readPref<bool>("visual_markdown_code_editor_line_numbers");
}

core::Error UserPrefValues::setVisualMarkdownCodeEditorLineNumbers(bool val)
{
   return writePref("visual_markdown_code_editor_line_numbers", val);
}

/**
 * The default visual editing mode font size, in points
 */
int UserPrefValues::visualMarkdownEditingFontSizePoints()
{
   return readPref<int>("visual_markdown_editing_font_size_points");
}

core::Error UserPrefValues::setVisualMarkdownEditingFontSizePoints(int val)
{
   return writePref("visual_markdown_editing_font_size_points", val);
}

/**
 * The name of the editor to use to provide code editing in visual mode
 */
std::string UserPrefValues::visualMarkdownCodeEditor()
{
   return readPref<std::string>("visual_markdown_code_editor");
}

core::Error UserPrefValues::setVisualMarkdownCodeEditor(std::string val)
{
   return writePref("visual_markdown_code_editor", val);
}

/**
 * Zotero libraries to insert citations from.
 */
core::json::Array UserPrefValues::zoteroLibraries()
{
   return readPref<core::json::Array>("zotero_libraries");
}

core::Error UserPrefValues::setZoteroLibraries(core::json::Array val)
{
   return writePref("zotero_libraries", val);
}

/**
 * Preferred emoji skintone
 */
std::string UserPrefValues::emojiSkintone()
{
   return readPref<std::string>("emoji_skintone");
}

core::Error UserPrefValues::setEmojiSkintone(std::string val)
{
   return writePref("emoji_skintone", val);
}

/**
 * List of aria-live announcements to disable.
 */
core::json::Array UserPrefValues::disabledAriaLiveAnnouncements()
{
   return readPref<core::json::Array>("disabled_aria_live_announcements");
}

core::Error UserPrefValues::setDisabledAriaLiveAnnouncements(core::json::Array val)
{
   return writePref("disabled_aria_live_announcements", val);
}

/**
 * Maximum number of lines of console output announced after a command.
 */
int UserPrefValues::screenreaderConsoleAnnounceLimit()
{
   return readPref<int>("screenreader_console_announce_limit");
}

core::Error UserPrefValues::setScreenreaderConsoleAnnounceLimit(int val)
{
   return writePref("screenreader_console_announce_limit", val);
}

/**
 * List of path components; file monitor will ignore paths containing one or more of these components.
 */
core::json::Array UserPrefValues::fileMonitorIgnoredComponents()
{
   return readPref<core::json::Array>("file_monitor_ignored_components");
}

core::Error UserPrefValues::setFileMonitorIgnoredComponents(core::json::Array val)
{
   return writePref("file_monitor_ignored_components", val);
}

/**
 * Whether to install R package dependencies one at a time.
 */
bool UserPrefValues::installPkgDepsIndividually()
{
   return readPref<bool>("install_pkg_deps_individually");
}

core::Error UserPrefValues::setInstallPkgDepsIndividually(bool val)
{
   return writePref("install_pkg_deps_individually", val);
}

/**
 * R graphics backend.
 */
std::string UserPrefValues::graphicsBackend()
{
   return readPref<std::string>("graphics_backend");
}

core::Error UserPrefValues::setGraphicsBackend(std::string val)
{
   return writePref("graphics_backend", val);
}

/**
 * Type of anti-aliasing to be used for generated R plots.
 */
std::string UserPrefValues::graphicsAntialiasing()
{
   return readPref<std::string>("graphics_antialiasing");
}

core::Error UserPrefValues::setGraphicsAntialiasing(std::string val)
{
   return writePref("graphics_antialiasing", val);
}

/**
 * List of fixed-width fonts to check for browser support.
 */
core::json::Array UserPrefValues::browserFixedWidthFonts()
{
   return readPref<core::json::Array>("browser_fixed_width_fonts");
}

core::Error UserPrefValues::setBrowserFixedWidthFonts(core::json::Array val)
{
   return writePref("browser_fixed_width_fonts", val);
}

/**
 * The Python type.
 */
std::string UserPrefValues::pythonType()
{
   return readPref<std::string>("python_type");
}

core::Error UserPrefValues::setPythonType(std::string val)
{
   return writePref("python_type", val);
}

/**
 * The Python version.
 */
std::string UserPrefValues::pythonVersion()
{
   return readPref<std::string>("python_version");
}

core::Error UserPrefValues::setPythonVersion(std::string val)
{
   return writePref("python_version", val);
}

/**
 * The path to the default Python interpreter.
 */
std::string UserPrefValues::pythonPath()
{
   return readPref<std::string>("python_path");
}

core::Error UserPrefValues::setPythonPath(std::string val)
{
   return writePref("python_path", val);
}

/**
 * The maximum amount of seconds of retry for save operations.
 */
int UserPrefValues::saveRetryTimeout()
{
   return readPref<int>("save_retry_timeout");
}

core::Error UserPrefValues::setSaveRetryTimeout(int val)
{
   return writePref("save_retry_timeout", val);
}

/**
 * Whether the Insert Pipe Operator command should insert the native R pipe operator, |>
 */
bool UserPrefValues::insertNativePipeOperator()
{
   return readPref<bool>("insert_native_pipe_operator");
}

core::Error UserPrefValues::setInsertNativePipeOperator(bool val)
{
   return writePref("insert_native_pipe_operator", val);
}

/**
 * Whether to keep track of recently used commands in the Command Palette
 */
bool UserPrefValues::commandPaletteMru()
{
   return readPref<bool>("command_palette_mru");
}

core::Error UserPrefValues::setCommandPaletteMru(bool val)
{
   return writePref("command_palette_mru", val);
}

/**
 * Whether to compute and show memory usage in the Environment Pane
 */
bool UserPrefValues::showMemoryUsage()
{
   return readPref<bool>("show_memory_usage");
}

core::Error UserPrefValues::setShowMemoryUsage(bool val)
{
   return writePref("show_memory_usage", val);
}

/**
 * How many seconds to wait between automatic requeries of memory statistics (0 to disable)
 */
int UserPrefValues::memoryQueryIntervalSeconds()
{
   return readPref<int>("memory_query_interval_seconds");
}

core::Error UserPrefValues::setMemoryQueryIntervalSeconds(int val)
{
   return writePref("memory_query_interval_seconds", val);
}

/**
 * Enable Python terminal hooks. When enabled, the RStudio-configured version of Python will be placed on the PATH.
 */
bool UserPrefValues::terminalPythonIntegration()
{
   return readPref<bool>("terminal_python_integration");
}

core::Error UserPrefValues::setTerminalPythonIntegration(bool val)
{
   return writePref("terminal_python_integration", val);
}

/**
 * Enable session protocol debug logging showing all session requests and events
 */
bool UserPrefValues::sessionProtocolDebug()
{
   return readPref<bool>("session_protocol_debug");
}

core::Error UserPrefValues::setSessionProtocolDebug(bool val)
{
   return writePref("session_protocol_debug", val);
}

/**
 * When enabled, if the active project contains a Python virtual environment, then RStudio will automatically activate this environment on startup.
 */
bool UserPrefValues::pythonProjectEnvironmentAutomaticActivate()
{
   return readPref<bool>("python_project_environment_automatic_activate");
}

core::Error UserPrefValues::setPythonProjectEnvironmentAutomaticActivate(bool val)
{
   return writePref("python_project_environment_automatic_activate", val);
}

/**
 * When enabled, RStudio will detect R objects containing null external pointers when building the Environment pane, and avoid introspecting their contents further.
 */
bool UserPrefValues::checkNullExternalPointers()
{
   return readPref<bool>("check_null_external_pointers");
}

core::Error UserPrefValues::setCheckNullExternalPointers(bool val)
{
   return writePref("check_null_external_pointers", val);
}

/**
 * Enable IDE features for the Quarto publishing system.
 */
std::string UserPrefValues::quartoEnabled()
{
   return readPref<std::string>("quarto_enabled");
}

core::Error UserPrefValues::setQuartoEnabled(std::string val)
{
   return writePref("quarto_enabled", val);
}

std::vector<std::string> UserPrefValues::allKeys()
{
   return std::vector<std::string>({
      kRunRprofileOnResume,
      kSaveWorkspace,
      kLoadWorkspace,
      kInitialWorkingDirectory,
      kCranMirror,
      kBioconductorMirrorName,
      kBioconductorMirrorUrl,
      kAlwaysSaveHistory,
      kRemoveHistoryDuplicates,
      kShowLastDotValue,
      kLineEndingConversion,
      kUseNewlinesInMakefiles,
      kWindowsTerminalShell,
      kPosixTerminalShell,
      kCustomShellCommand,
      kCustomShellOptions,
      kShowLineNumbers,
      kHighlightSelectedWord,
      kHighlightSelectedLine,
      kPanes,
      kAllowSourceColumns,
      kUseSpacesForTab,
      kNumSpacesForTab,
      kAutoDetectIndentation,
      kShowMargin,
      kBlinkingCursor,
      kMarginColumn,
      kShowInvisibles,
      kShowIndentGuides,
      kContinueCommentsOnNewline,
      kHighlightWebLink,
      kEditorKeybindings,
      kInsertMatching,
      kInsertSpacesAroundEquals,
      kInsertParensAfterFunctionCompletion,
      kTabMultilineCompletion,
      kTabCompletion,
      kShowHelpTooltipOnIdle,
      kSurroundSelection,
      kEnableSnippets,
      kCodeCompletion,
      kCodeCompletionOther,
      kConsoleCodeCompletion,
      kCodeCompletionDelay,
      kCodeCompletionCharacters,
      kShowFunctionSignatureTooltips,
      kShowDiagnosticsR,
      kShowDiagnosticsCpp,
      kShowDiagnosticsYaml,
      kShowDiagnosticsOther,
      kStyleDiagnostics,
      kDiagnosticsOnSave,
      kBackgroundDiagnostics,
      kBackgroundDiagnosticsDelayMs,
      kDiagnosticsInRFunctionCalls,
      kCheckArgumentsToRFunctionCalls,
      kCheckUnexpectedAssignmentInFunctionCall,
      kWarnIfNoSuchVariableInScope,
      kWarnVariableDefinedButNotUsed,
      kAutoDiscoverPackageDependencies,
      kAutoAppendNewline,
      kStripTrailingWhitespace,
      kRestoreSourceDocumentCursorPosition,
      kReindentOnPaste,
      kVerticallyAlignArgumentsIndent,
      kSoftWrapRFiles,
      kSoftWrapRmdFiles,
      kFocusConsoleAfterExec,
      kFoldStyle,
      kSaveBeforeSourcing,
      kSyntaxColorConsole,
      kHighlightConsoleErrors,
      kScrollPastEndOfDocument,
      kHighlightRFunctionCalls,
      kRainbowParentheses,
      kConsoleLineLengthLimit,
      kConsoleMaxLines,
      kAnsiConsoleMode,
      kLimitVisibleConsole,
      kShowInlineToolbarForRCodeChunks,
      kHighlightCodeChunks,
      kSaveFilesBeforeBuild,
      kFontSizePoints,
      kHelpFontSizePoints,
      kEditorTheme,
      kServerEditorFontEnabled,
      kServerEditorFont,
      kDefaultEncoding,
      kToolbarVisible,
      kDefaultProjectLocation,
      kSourceWithEcho,
      kDefaultSweaveEngine,
      kDefaultLatexProgram,
      kUseRoxygen,
      kUseDataimport,
      kPdfPreviewer,
      kAlwaysEnableRnwConcordance,
      kInsertNumberedLatexSections,
      kSpellingDictionaryLanguage,
      kSpellingCustomDictionaries,
      kDocumentLoadLintDelay,
      kIgnoreUppercaseWords,
      kIgnoreWordsWithNumbers,
      kRealTimeSpellchecking,
      kNavigateToBuildError,
      kPackagesPaneEnabled,
      kCppTemplate,
      kRestoreSourceDocuments,
      kHandleErrorsInUserCodeOnly,
      kAutoExpandErrorTracebacks,
      kCheckForUpdates,
      kShowInternalFunctions,
      kShinyViewerType,
      kShinyBackgroundJobs,
      kPlumberViewerType,
      kDocumentAuthor,
      kRmdAutoDate,
      kRmdPreferredTemplatePath,
      kRmdViewerType,
      kShowPublishDiagnostics,
      kPublishCheckCertificates,
      kUsePublishCaBundle,
      kPublishCaBundle,
      kRmdChunkOutputInline,
      kShowDocOutlineRmd,
      kAutoRunSetupChunk,
      kHideConsoleOnChunkExecute,
      kExecutionBehavior,
      kShowTerminalTab,
      kTerminalLocalEcho,
      kTerminalWebsockets,
      kTerminalCloseBehavior,
      kTerminalTrackEnvironment,
      kTerminalBellStyle,
      kTerminalRenderer,
      kTerminalWeblinks,
      kShowRmdRenderCommand,
      kEnableTextDrag,
      kShowHiddenFiles,
      kAlwaysShownFiles,
      kAlwaysShownExtensions,
      kSortFileNamesNaturally,
      kSyncFilesPaneWorkingDir,
      kJobsTabVisibility,
      kShowLauncherJobsTab,
      kLauncherJobsSort,
      kBusyDetection,
      kBusyExclusionList,
      kKnitWorkingDir,
      kDocOutlineShow,
      kLatexPreviewOnCursorIdle,
      kWrapTabNavigation,
      kGlobalTheme,
      kGitDiffIgnoreWhitespace,
      kConsoleDoubleClickSelect,
      kConsoleSuspendBlockedNotice,
      kConsoleSuspendBlockedNoticeDelay,
      kNewProjGitInit,
      kNewProjUseRenv,
      kRootDocument,
      kShowUserHomePage,
      kReuseSessionsForProjectLinks,
      kVcsEnabled,
      kVcsAutorefresh,
      kGitExePath,
      kSvnExePath,
      kTerminalPath,
      kRsaKeyPath,
      kUseDevtools,
      kUseInternet2,
      kUseSecureDownload,
      kCleanupAfterRCmdCheck,
      kViewDirAfterRCmdCheck,
      kHideObjectFiles,
      kRestoreLastProject,
      kProjectSafeStartupSeconds,
      kUseTinytex,
      kCleanTexi2dviOutput,
      kLatexShellEscape,
      kRestoreProjectRVersion,
      kClangVerbose,
      kSubmitCrashReports,
      kDefaultRVersion,
      kDataViewerMaxColumns,
      kEnableScreenReader,
      kTypingStatusDelayMs,
      kReducedMotion,
      kTabKeyMoveFocus,
      kFindPanelLegacyTabSequence,
      kShowFocusRectangles,
      kShowPanelFocusRectangle,
      kAutoSaveOnIdle,
      kAutoSaveIdleMs,
      kAutoSaveOnBlur,
      kTerminalInitialDirectory,
      kFullProjectPathInWindowTitle,
      kVisualMarkdownEditingIsDefault,
      kVisualMarkdownEditingListSpacing,
      kVisualMarkdownEditingWrap,
      kVisualMarkdownEditingWrapAtColumn,
      kVisualMarkdownEditingReferencesLocation,
      kVisualMarkdownEditingCanonical,
      kVisualMarkdownEditingMaxContentWidth,
      kVisualMarkdownEditingShowDocOutline,
      kVisualMarkdownEditingShowMargin,
      kVisualMarkdownCodeEditorLineNumbers,
      kVisualMarkdownEditingFontSizePoints,
      kVisualMarkdownCodeEditor,
      kZoteroLibraries,
      kEmojiSkintone,
      kDisabledAriaLiveAnnouncements,
      kScreenreaderConsoleAnnounceLimit,
      kFileMonitorIgnoredComponents,
      kInstallPkgDepsIndividually,
      kGraphicsBackend,
      kGraphicsAntialiasing,
      kBrowserFixedWidthFonts,
      kPythonType,
      kPythonVersion,
      kPythonPath,
      kSaveRetryTimeout,
      kInsertNativePipeOperator,
      kCommandPaletteMru,
      kShowMemoryUsage,
      kMemoryQueryIntervalSeconds,
      kTerminalPythonIntegration,
      kSessionProtocolDebug,
      kPythonProjectEnvironmentAutomaticActivate,
      kCheckNullExternalPointers,
      kQuartoEnabled,
   });
}
   

}
}
}
