/*
 * CmdConstants.java
 *
 * Copyright (C) 2022 by RStudio, PBC
 *
 * Unless you have received this program directly from RStudio pursuant
 * to the terms of a commercial license agreement with RStudio, then
 * this program is licensed to you under the terms of version 3 of the
 * GNU Affero General Public License. This program is distributed WITHOUT
 * ANY EXPRESS OR IMPLIED WARRANTY, INCLUDING THOSE OF NON-INFRINGEMENT,
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Please refer to the
 * AGPL (http://www.gnu.org/licenses/agpl-3.0.txt) for more details.
 *
 */

// WARNING: Do not edit this file manually, it has been auto-generated
// To edit this file, rerun i18n_gwt_interface.py

package org.rstudio.studio.client.workbench.commands;
import com.google.gwt.i18n.client.Constants;

public interface CmdConstants extends Constants {
    // setWorkingDirToProjectDir
    @DefaultStringValue("Set Working Directory to Project Directory") // $NON-NLS-1$
    String setWorkingDirToProjectDirLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String setWorkingDirToProjectDirButtonLabel();
    @DefaultStringValue("To _Project Directory") // $NON-NLS-1$
    String setWorkingDirToProjectDirMenuLabel();
    @DefaultStringValue("Change working directory to project root directory") // $NON-NLS-1$
    String setWorkingDirToProjectDirDesc();
    
    // setWorkingDirToActiveDoc
    @DefaultStringValue("Set Working Directory to Current Document's Directory") // $NON-NLS-1$
    String setWorkingDirToActiveDocLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String setWorkingDirToActiveDocButtonLabel();
    @DefaultStringValue("To _Source File Location") // $NON-NLS-1$
    String setWorkingDirToActiveDocMenuLabel();
    @DefaultStringValue("Change working directory to path of active document") // $NON-NLS-1$
    String setWorkingDirToActiveDocDesc();
    
    // setWorkingDirToFilesPane
    @DefaultStringValue("Set Working Directory to Directory in Files Pane") // $NON-NLS-1$
    String setWorkingDirToFilesPaneLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String setWorkingDirToFilesPaneButtonLabel();
    @DefaultStringValue("To _Files Pane Location") // $NON-NLS-1$
    String setWorkingDirToFilesPaneMenuLabel();
    @DefaultStringValue("Change working directory to location of Files pane") // $NON-NLS-1$
    String setWorkingDirToFilesPaneDesc();
    
    // setWorkingDir
    @DefaultStringValue("Set Working Directory...") // $NON-NLS-1$
    String setWorkingDirLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String setWorkingDirButtonLabel();
    @DefaultStringValue("_Choose Directory...") // $NON-NLS-1$
    String setWorkingDirMenuLabel();
    @DefaultStringValue("Select and change to a new working directory") // $NON-NLS-1$
    String setWorkingDirDesc();
    
    // newSourceDoc
    @DefaultStringValue("Create a New R Script") // $NON-NLS-1$
    String newSourceDocLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String newSourceDocButtonLabel();
    @DefaultStringValue("_R Script") // $NON-NLS-1$
    String newSourceDocMenuLabel();
    @DefaultStringValue("Create a new R script") // $NON-NLS-1$
    String newSourceDocDesc();
    
    // newRNotebook
    @DefaultStringValue("R _Notebook") // $NON-NLS-1$
    String newRNotebookMenuLabel();
    @DefaultStringValue("Create a new R Markdown notebook") // $NON-NLS-1$
    String newRNotebookDesc();
    
    // newTextDoc
    @DefaultStringValue("_Text File") // $NON-NLS-1$
    String newTextDocMenuLabel();
    @DefaultStringValue("Create a new text file") // $NON-NLS-1$
    String newTextDocDesc();
    
    // newCDoc
    @DefaultStringValue("_C File") // $NON-NLS-1$
    String newCDocMenuLabel();
    @DefaultStringValue("Create a new C file") // $NON-NLS-1$
    String newCDocDesc();
    
    // newCppDoc
    @DefaultStringValue("_C++ File") // $NON-NLS-1$
    String newCppDocMenuLabel();
    @DefaultStringValue("Create a new C++ file") // $NON-NLS-1$
    String newCppDocDesc();
    
    // newHeaderDoc
    @DefaultStringValue("_Header File") // $NON-NLS-1$
    String newHeaderDocMenuLabel();
    @DefaultStringValue("Create a new header file") // $NON-NLS-1$
    String newHeaderDocDesc();
    
    // newMarkdownDoc
    @DefaultStringValue("_Markdown File") // $NON-NLS-1$
    String newMarkdownDocMenuLabel();
    @DefaultStringValue("Create a new Markdown document") // $NON-NLS-1$
    String newMarkdownDocDesc();
    
    // newPythonDoc
    @DefaultStringValue("_Python Script") // $NON-NLS-1$
    String newPythonDocMenuLabel();
    @DefaultStringValue("Create a new Python script") // $NON-NLS-1$
    String newPythonDocDesc();
    
    // newShellDoc
    @DefaultStringValue("_Shell Script") // $NON-NLS-1$
    String newShellDocMenuLabel();
    @DefaultStringValue("Create a new shell script") // $NON-NLS-1$
    String newShellDocDesc();
    
    // newStanDoc
    @DefaultStringValue("_Stan File") // $NON-NLS-1$
    String newStanDocMenuLabel();
    @DefaultStringValue("Create a new Stan program") // $NON-NLS-1$
    String newStanDocDesc();
    
    // newHtmlDoc
    @DefaultStringValue("_HTML File") // $NON-NLS-1$
    String newHtmlDocMenuLabel();
    @DefaultStringValue("Create a new HTML file") // $NON-NLS-1$
    String newHtmlDocDesc();
    
    // newJavaScriptDoc
    @DefaultStringValue("_JavaScript File") // $NON-NLS-1$
    String newJavaScriptDocMenuLabel();
    @DefaultStringValue("Create a new JavaScript file") // $NON-NLS-1$
    String newJavaScriptDocDesc();
    
    // newCssDoc
    @DefaultStringValue("_CSS File") // $NON-NLS-1$
    String newCssDocMenuLabel();
    @DefaultStringValue("Create a new CSS file") // $NON-NLS-1$
    String newCssDocDesc();
    
    // newD3Doc
    @DefaultStringValue("_D3 Script") // $NON-NLS-1$
    String newD3DocMenuLabel();
    @DefaultStringValue("Create a new D3 Script") // $NON-NLS-1$
    String newD3DocDesc();
    
    // newRPlumberDoc
    @DefaultStringValue("Plumber _API...") // $NON-NLS-1$
    String newRPlumberDocMenuLabel();
    @DefaultStringValue("Create a new Plumber API") // $NON-NLS-1$
    String newRPlumberDocDesc();
    
    // rcppHelp
    @DefaultStringValue("Help on using Rcpp") // $NON-NLS-1$
    String rcppHelpDesc();
    
    // printCppCompletions
    @DefaultStringValue("Print C++ Completions") // $NON-NLS-1$
    String printCppCompletionsDesc();
    
    // newSweaveDoc
    @DefaultStringValue("R _Sweave") // $NON-NLS-1$
    String newSweaveDocMenuLabel();
    @DefaultStringValue("Create a new R Sweave document") // $NON-NLS-1$
    String newSweaveDocDesc();
    
    // newRMarkdownDoc
    @DefaultStringValue("R _Markdown...") // $NON-NLS-1$
    String newRMarkdownDocMenuLabel();
    @DefaultStringValue("Create a new R Markdown document") // $NON-NLS-1$
    String newRMarkdownDocDesc();
    
    // newQuartoDoc
    @DefaultStringValue("_Quarto Document...") // $NON-NLS-1$
    String newQuartoDocMenuLabel();
    @DefaultStringValue("Create a new Quarto document") // $NON-NLS-1$
    String newQuartoDocDesc();
    
    // newQuartoPres
    @DefaultStringValue("_Quarto Presentation...") // $NON-NLS-1$
    String newQuartoPresMenuLabel();
    @DefaultStringValue("Create a new Quarto presentation") // $NON-NLS-1$
    String newQuartoPresDesc();
    
    // serveQuartoSite
    @DefaultStringValue("_Preview Site") // $NON-NLS-1$
    String serveQuartoSiteMenuLabel();
    @DefaultStringValue("Run development server for Quarto site") // $NON-NLS-1$
    String serveQuartoSiteDesc();
    
    // newRShinyApp
    @DefaultStringValue("Shiny _Web App...") // $NON-NLS-1$
    String newRShinyAppMenuLabel();
    @DefaultStringValue("Create a new Shiny web application") // $NON-NLS-1$
    String newRShinyAppDesc();
    
    // newRHTMLDoc
    @DefaultStringValue("R _HTML") // $NON-NLS-1$
    String newRHTMLDocMenuLabel();
    @DefaultStringValue("Create a new R HTML document") // $NON-NLS-1$
    String newRHTMLDocDesc();
    
    // newRPresentationDoc
    @DefaultStringValue("R _Presentation") // $NON-NLS-1$
    String newRPresentationDocMenuLabel();
    @DefaultStringValue("Create a new R presentation") // $NON-NLS-1$
    String newRPresentationDocDesc();
    
    // newRDocumentationDoc
    @DefaultStringValue("R Doc_umentation...") // $NON-NLS-1$
    String newRDocumentationDocMenuLabel();
    @DefaultStringValue("Create a new Rd documentation file") // $NON-NLS-1$
    String newRDocumentationDocDesc();
    
    // newSqlDoc
    @DefaultStringValue("SQ_L Script") // $NON-NLS-1$
    String newSqlDocMenuLabel();
    @DefaultStringValue("Create a new SQL script") // $NON-NLS-1$
    String newSqlDocDesc();
    
    // openSourceDoc
    @DefaultStringValue("Open File...") // $NON-NLS-1$
    String openSourceDocLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String openSourceDocButtonLabel();
    @DefaultStringValue("_Open File...") // $NON-NLS-1$
    String openSourceDocMenuLabel();
    @DefaultStringValue("Open an existing file") // $NON-NLS-1$
    String openSourceDocDesc();
    
    // openSourceDocNewColumn
    @DefaultStringValue("Open File in New Column...") // $NON-NLS-1$
    String openSourceDocNewColumnLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String openSourceDocNewColumnButtonLabel();
    @DefaultStringValue("Open File in New C_olumn...") // $NON-NLS-1$
    String openSourceDocNewColumnMenuLabel();
    @DefaultStringValue("Open an existing file in a new column") // $NON-NLS-1$
    String openSourceDocNewColumnDesc();
    
    // reopenSourceDocWithEncoding
    @DefaultStringValue("Reopen Current Document with Encoding...") // $NON-NLS-1$
    String reopenSourceDocWithEncodingLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String reopenSourceDocWithEncodingButtonLabel();
    @DefaultStringValue("Reopen with _Encoding...") // $NON-NLS-1$
    String reopenSourceDocWithEncodingMenuLabel();
    @DefaultStringValue("Reopen the current file with a different encoding") // $NON-NLS-1$
    String reopenSourceDocWithEncodingDesc();
    
    // saveSourceDoc
    @DefaultStringValue("Save Current Document") // $NON-NLS-1$
    String saveSourceDocLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String saveSourceDocButtonLabel();
    @DefaultStringValue("_Save") // $NON-NLS-1$
    String saveSourceDocMenuLabel();
    @DefaultStringValue("Save current document") // $NON-NLS-1$
    String saveSourceDocDesc();
    
    // renameSourceDoc
    @DefaultStringValue("Rename Current Document") // $NON-NLS-1$
    String renameSourceDocLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String renameSourceDocButtonLabel();
    @DefaultStringValue("_Rename") // $NON-NLS-1$
    String renameSourceDocMenuLabel();
    @DefaultStringValue("Rename current document") // $NON-NLS-1$
    String renameSourceDocDesc();
    
    // copySourceDocPath
    @DefaultStringValue("Copy Document Path") // $NON-NLS-1$
    String copySourceDocPathLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String copySourceDocPathButtonLabel();
    @DefaultStringValue("Copy Path") // $NON-NLS-1$
    String copySourceDocPathMenuLabel();
    @DefaultStringValue("Copy current document path") // $NON-NLS-1$
    String copySourceDocPathDesc();
    
    // saveSourceDocAs
    @DefaultStringValue("Save Current Document As...") // $NON-NLS-1$
    String saveSourceDocAsLabel();
    @DefaultStringValue("Save as") // $NON-NLS-1$
    String saveSourceDocAsButtonLabel();
    @DefaultStringValue("Save _As...") // $NON-NLS-1$
    String saveSourceDocAsMenuLabel();
    @DefaultStringValue("Save current file to a specific path") // $NON-NLS-1$
    String saveSourceDocAsDesc();
    
    // saveAllSourceDocs
    @DefaultStringValue("Save All Source Documents") // $NON-NLS-1$
    String saveAllSourceDocsLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String saveAllSourceDocsButtonLabel();
    @DefaultStringValue("Sa_ve All") // $NON-NLS-1$
    String saveAllSourceDocsMenuLabel();
    @DefaultStringValue("Save all open documents") // $NON-NLS-1$
    String saveAllSourceDocsDesc();
    
    // saveSourceDocWithEncoding
    @DefaultStringValue("Save Current Document with Encoding...") // $NON-NLS-1$
    String saveSourceDocWithEncodingLabel();
    @DefaultStringValue("Save wit_h Encoding...") // $NON-NLS-1$
    String saveSourceDocWithEncodingMenuLabel();
    @DefaultStringValue("Save the current file with a different encoding") // $NON-NLS-1$
    String saveSourceDocWithEncodingDesc();
    
    // closeSourceDoc
    @DefaultStringValue("Close Current Document") // $NON-NLS-1$
    String closeSourceDocLabel();
    @DefaultStringValue("_Close") // $NON-NLS-1$
    String closeSourceDocMenuLabel();
    
    // closeAllSourceDocs
    @DefaultStringValue("Close All Documents") // $NON-NLS-1$
    String closeAllSourceDocsLabel();
    @DefaultStringValue("C_lose All") // $NON-NLS-1$
    String closeAllSourceDocsMenuLabel();
    
    // closeOtherSourceDocs
    @DefaultStringValue("Close Other Documents") // $NON-NLS-1$
    String closeOtherSourceDocsLabel();
    @DefaultStringValue("Close All E_xcept Current") // $NON-NLS-1$
    String closeOtherSourceDocsMenuLabel();
    
    // vcsFileDiff
    @DefaultStringValue("Show Differences for File") // $NON-NLS-1$
    String vcsFileDiffLabel();
    @DefaultStringValue("_Diff of") // $NON-NLS-1$
    String vcsFileDiffMenuLabel();
    @DefaultStringValue("Show differences for the file") // $NON-NLS-1$
    String vcsFileDiffDesc();
    
    // vcsFileLog
    @DefaultStringValue("Show Changelog for File") // $NON-NLS-1$
    String vcsFileLogLabel();
    @DefaultStringValue("_Log of") // $NON-NLS-1$
    String vcsFileLogMenuLabel();
    @DefaultStringValue("Show log of changes to the file") // $NON-NLS-1$
    String vcsFileLogDesc();
    
    // vcsFileRevert
    @DefaultStringValue("Revert Changes to File") // $NON-NLS-1$
    String vcsFileRevertLabel();
    @DefaultStringValue("_Revert") // $NON-NLS-1$
    String vcsFileRevertMenuLabel();
    @DefaultStringValue("Revert changes to the file") // $NON-NLS-1$
    String vcsFileRevertDesc();
    
    // vcsViewOnGitHub
    @DefaultStringValue("View file on GitHub") // $NON-NLS-1$
    String vcsViewOnGitHubLabel();
    @DefaultStringValue("_View FILE on GitHub") // $NON-NLS-1$
    String vcsViewOnGitHubMenuLabel();
    @DefaultStringValue("View this file on Github") // $NON-NLS-1$
    String vcsViewOnGitHubDesc();
    
    // vcsBlameOnGitHub
    @DefaultStringValue("View 'git blame' on GitHub") // $NON-NLS-1$
    String vcsBlameOnGitHubLabel();
    @DefaultStringValue("_Blame FILE on GitHub") // $NON-NLS-1$
    String vcsBlameOnGitHubMenuLabel();
    @DefaultStringValue("Blame view for this file on Github") // $NON-NLS-1$
    String vcsBlameOnGitHubDesc();
    
    // printSourceDoc
    @DefaultStringValue("") // $NON-NLS-1$
    String printSourceDocButtonLabel();
    @DefaultStringValue("Pr_int...") // $NON-NLS-1$
    String printSourceDocMenuLabel();
    @DefaultStringValue("Print the current file") // $NON-NLS-1$
    String printSourceDocDesc();
    
    // popoutDoc
    @DefaultStringValue("Show Document in New Window") // $NON-NLS-1$
    String popoutDocLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String popoutDocButtonLabel();
    @DefaultStringValue("Show in new window") // $NON-NLS-1$
    String popoutDocDesc();
    
    // returnDocToMain
    @DefaultStringValue("Return Document to Main Window") // $NON-NLS-1$
    String returnDocToMainLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String returnDocToMainButtonLabel();
    @DefaultStringValue("Return to main window") // $NON-NLS-1$
    String returnDocToMainDesc();
    
    // mru0
    
    // mru1
    
    // mru2
    
    // mru3
    
    // mru4
    
    // mru5
    
    // mru6
    
    // mru7
    
    // mru8
    
    // mru9
    
    // mru10
    
    // mru11
    
    // mru12
    
    // mru13
    
    // mru14
    
    // clearRecentFiles
    @DefaultStringValue("_Clear List") // $NON-NLS-1$
    String clearRecentFilesMenuLabel();
    
    // newProject
    @DefaultStringValue("Create a New Project...") // $NON-NLS-1$
    String newProjectLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String newProjectButtonLabel();
    @DefaultStringValue("New _Project...") // $NON-NLS-1$
    String newProjectMenuLabel();
    @DefaultStringValue("Create a project") // $NON-NLS-1$
    String newProjectDesc();
    
    // openProject
    @DefaultStringValue("Open Project...") // $NON-NLS-1$
    String openProjectLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String openProjectButtonLabel();
    @DefaultStringValue("Ope_n Project...") // $NON-NLS-1$
    String openProjectMenuLabel();
    @DefaultStringValue("Open a project") // $NON-NLS-1$
    String openProjectDesc();
    
    // openProjectInNewWindow
    @DefaultStringValue("Open Project with New R Session") // $NON-NLS-1$
    String openProjectInNewWindowLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String openProjectInNewWindowButtonLabel();
    @DefaultStringValue("Open Project in Ne_w Session...") // $NON-NLS-1$
    String openProjectInNewWindowMenuLabel();
    @DefaultStringValue("Open project in a new R session") // $NON-NLS-1$
    String openProjectInNewWindowDesc();
    
    // shareProject
    @DefaultStringValue("Share Project...") // $NON-NLS-1$
    String shareProjectLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String shareProjectButtonLabel();
    @DefaultStringValue("S_hare Project...") // $NON-NLS-1$
    String shareProjectMenuLabel();
    @DefaultStringValue("Share this project with others") // $NON-NLS-1$
    String shareProjectDesc();
    
    // openSharedProject
    @DefaultStringValue("Open Shared Project") // $NON-NLS-1$
    String openSharedProjectLabel();
    @DefaultStringValue("More...") // $NON-NLS-1$
    String openSharedProjectMenuLabel();
    @DefaultStringValue("Open a project shared with you") // $NON-NLS-1$
    String openSharedProjectDesc();
    
    // projectMru0
    
    // projectMru1
    
    // projectMru2
    
    // projectMru3
    
    // projectMru4
    
    // projectMru5
    
    // projectMru6
    
    // projectMru7
    
    // projectMru8
    
    // projectMru9
    
    // projectMru10
    
    // projectMru11
    
    // projectMru12
    
    // projectMru13
    
    // projectMru14
    
    // clearRecentProjects
    @DefaultStringValue("_Clear Project List") // $NON-NLS-1$
    String clearRecentProjectsMenuLabel();
    
    // closeProject
    @DefaultStringValue("Close Current Project") // $NON-NLS-1$
    String closeProjectLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String closeProjectButtonLabel();
    @DefaultStringValue("Close Projec_t") // $NON-NLS-1$
    String closeProjectMenuLabel();
    @DefaultStringValue("Close the currently open project") // $NON-NLS-1$
    String closeProjectDesc();
    
    // projectOptions
    @DefaultStringValue("Edit Project Options...") // $NON-NLS-1$
    String projectOptionsLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String projectOptionsButtonLabel();
    @DefaultStringValue("_Project Options...") // $NON-NLS-1$
    String projectOptionsMenuLabel();
    @DefaultStringValue("Edit options for the current project") // $NON-NLS-1$
    String projectOptionsDesc();
    
    // projectSweaveOptions
    @DefaultStringValue("") // $NON-NLS-1$
    String projectSweaveOptionsButtonLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String projectSweaveOptionsMenuLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String projectSweaveOptionsDesc();
    
    // showToolbar
    @DefaultStringValue("Show _Toolbar") // $NON-NLS-1$
    String showToolbarMenuLabel();
    
    // hideToolbar
    @DefaultStringValue("Hide _Toolbar") // $NON-NLS-1$
    String hideToolbarMenuLabel();
    
    // toggleToolbar
    @DefaultStringValue("Toggle Visibility of Toolbar") // $NON-NLS-1$
    String toggleToolbarLabel();
    @DefaultStringValue("Toggle Toolbar") // $NON-NLS-1$
    String toggleToolbarMenuLabel();
    
    // zoomActualSize
    @DefaultStringValue("Actual _Size") // $NON-NLS-1$
    String zoomActualSizeMenuLabel();
    
    // zoomIn
    @DefaultStringValue("_Zoom In") // $NON-NLS-1$
    String zoomInMenuLabel();
    
    // zoomOut
    @DefaultStringValue("Zoom O_ut") // $NON-NLS-1$
    String zoomOutMenuLabel();
    
    // goToFileFunction
    @DefaultStringValue("Go To File/Function...") // $NON-NLS-1$
    String goToFileFunctionLabel();
    @DefaultStringValue("Go To File/F_unction...") // $NON-NLS-1$
    String goToFileFunctionMenuLabel();
    
    // switchFocusSourceConsole
    @DefaultStringValue("Switch Focus between Source/Console") // $NON-NLS-1$
    String switchFocusSourceConsoleLabel();
    
    // activateSource
    @DefaultStringValue("Move Focus to Source") // $NON-NLS-1$
    String activateSourceLabel();
    @DefaultStringValue("Move Focus to Sou_rce") // $NON-NLS-1$
    String activateSourceMenuLabel();
    
    // activateConsolePane
    @DefaultStringValue("Move Focus to Console Panel") // $NON-NLS-1$
    String activateConsolePaneLabel();
    @DefaultStringValue("Move Focus to _Console Panel") // $NON-NLS-1$
    String activateConsolePaneMenuLabel();
    
    // activateConsole
    @DefaultStringValue("Move Focus to Console") // $NON-NLS-1$
    String activateConsoleLabel();
    @DefaultStringValue("Move Focus to _Console") // $NON-NLS-1$
    String activateConsoleMenuLabel();
    
    // activateEnvironment
    @DefaultStringValue("Show Environment Pane") // $NON-NLS-1$
    String activateEnvironmentLabel();
    @DefaultStringValue("Show _Environment") // $NON-NLS-1$
    String activateEnvironmentMenuLabel();
    
    // activateData
    @DefaultStringValue("Show Data Pane") // $NON-NLS-1$
    String activateDataLabel();
    @DefaultStringValue("Show _Data") // $NON-NLS-1$
    String activateDataMenuLabel();
    
    // activateHistory
    @DefaultStringValue("Show History Pane") // $NON-NLS-1$
    String activateHistoryLabel();
    @DefaultStringValue("Show Histor_y") // $NON-NLS-1$
    String activateHistoryMenuLabel();
    
    // activateFiles
    @DefaultStringValue("Show Files Pane") // $NON-NLS-1$
    String activateFilesLabel();
    @DefaultStringValue("Show F_iles") // $NON-NLS-1$
    String activateFilesMenuLabel();
    
    // activatePlots
    @DefaultStringValue("Show Plots Pane") // $NON-NLS-1$
    String activatePlotsLabel();
    @DefaultStringValue("Show Pl_ots") // $NON-NLS-1$
    String activatePlotsMenuLabel();
    
    // activatePackages
    @DefaultStringValue("Show Packages Pane") // $NON-NLS-1$
    String activatePackagesLabel();
    @DefaultStringValue("Show Pac_kages") // $NON-NLS-1$
    String activatePackagesMenuLabel();
    
    // activateHelp
    @DefaultStringValue("Show Help Pane") // $NON-NLS-1$
    String activateHelpLabel();
    @DefaultStringValue("Move Focus to _Help") // $NON-NLS-1$
    String activateHelpMenuLabel();
    
    // activateVcs
    @DefaultStringValue("Show VCS Pane") // $NON-NLS-1$
    String activateVcsLabel();
    @DefaultStringValue("Show _Vcs") // $NON-NLS-1$
    String activateVcsMenuLabel();
    
    // activateBuild
    @DefaultStringValue("Show Build Pane") // $NON-NLS-1$
    String activateBuildLabel();
    @DefaultStringValue("Show _Build") // $NON-NLS-1$
    String activateBuildMenuLabel();
    
    // activateViewer
    @DefaultStringValue("Show Viewer Pane") // $NON-NLS-1$
    String activateViewerLabel();
    @DefaultStringValue("Show Vie_wer") // $NON-NLS-1$
    String activateViewerMenuLabel();
    
    // activatePresentation
    @DefaultStringValue("Show Presentation Pane") // $NON-NLS-1$
    String activatePresentationLabel();
    @DefaultStringValue("Show Prese_ntation") // $NON-NLS-1$
    String activatePresentationMenuLabel();
    
    // activatePresentation2
    @DefaultStringValue("Show Presentation Pane") // $NON-NLS-1$
    String activatePresentation2Label();
    @DefaultStringValue("Show Prese_ntation") // $NON-NLS-1$
    String activatePresentation2MenuLabel();
    
    // activateConnections
    @DefaultStringValue("Show Connections Pane") // $NON-NLS-1$
    String activateConnectionsLabel();
    @DefaultStringValue("Show Co_nnections") // $NON-NLS-1$
    String activateConnectionsMenuLabel();
    
    // activateTutorial
    @DefaultStringValue("Show Tutorial Pane") // $NON-NLS-1$
    String activateTutorialLabel();
    @DefaultStringValue("Show _Tutorial") // $NON-NLS-1$
    String activateTutorialMenuLabel();
    
    // activateJobs
    @DefaultStringValue("Show Jobs Pane") // $NON-NLS-1$
    String activateJobsLabel();
    @DefaultStringValue("Show _Jobs") // $NON-NLS-1$
    String activateJobsMenuLabel();
    
    // activateLauncherJobs
    @DefaultStringValue("Show Launcher Pane") // $NON-NLS-1$
    String activateLauncherJobsLabel();
    @DefaultStringValue("Show _Launcher") // $NON-NLS-1$
    String activateLauncherJobsMenuLabel();
    
    // activateCompilePDF
    @DefaultStringValue("Show Compile PDF Pane") // $NON-NLS-1$
    String activateCompilePDFLabel();
    @DefaultStringValue("Show Compile _PDF") // $NON-NLS-1$
    String activateCompilePDFMenuLabel();
    
    // activateFindInFiles
    @DefaultStringValue("Show Find in Files") // $NON-NLS-1$
    String activateFindInFilesLabel();
    @DefaultStringValue("Show _Find in Files") // $NON-NLS-1$
    String activateFindInFilesMenuLabel();
    
    // activateSourceCpp
    @DefaultStringValue("Show Source Cpp Pane") // $NON-NLS-1$
    String activateSourceCppLabel();
    @DefaultStringValue("Show Sou_rce Cpp") // $NON-NLS-1$
    String activateSourceCppMenuLabel();
    
    // activateRMarkdown
    @DefaultStringValue("Show R Markdown Pane") // $NON-NLS-1$
    String activateRMarkdownLabel();
    @DefaultStringValue("Show _R Markdown") // $NON-NLS-1$
    String activateRMarkdownMenuLabel();
    
    // activateDeployContent
    @DefaultStringValue("Show Deploy Content Pane") // $NON-NLS-1$
    String activateDeployContentLabel();
    @DefaultStringValue("Show Deploy _Content") // $NON-NLS-1$
    String activateDeployContentMenuLabel();
    
    // activateMarkers
    @DefaultStringValue("Show Markers Pane") // $NON-NLS-1$
    String activateMarkersLabel();
    @DefaultStringValue("Show _Markers") // $NON-NLS-1$
    String activateMarkersMenuLabel();
    
    // activateSQLResults
    @DefaultStringValue("Show SQL Results Pane") // $NON-NLS-1$
    String activateSQLResultsLabel();
    @DefaultStringValue("Show S_QL Results") // $NON-NLS-1$
    String activateSQLResultsMenuLabel();
    
    // layoutZoomSource
    @DefaultStringValue("Zoom Source") // $NON-NLS-1$
    String layoutZoomSourceLabel();
    @DefaultStringValue("Zoom Sou_rce") // $NON-NLS-1$
    String layoutZoomSourceMenuLabel();
    
    // layoutZoomConsolePane
    @DefaultStringValue("Zoom Console Pane") // $NON-NLS-1$
    String layoutZoomConsolePaneLabel();
    @DefaultStringValue("Zoom Console Pane") // $NON-NLS-1$
    String layoutZoomConsolePaneMenuLabel();
    
    // layoutZoomConsole
    @DefaultStringValue("Zoom Console") // $NON-NLS-1$
    String layoutZoomConsoleLabel();
    @DefaultStringValue("Zoom _Console") // $NON-NLS-1$
    String layoutZoomConsoleMenuLabel();
    
    // layoutZoomEnvironment
    @DefaultStringValue("Zoom Environment") // $NON-NLS-1$
    String layoutZoomEnvironmentLabel();
    @DefaultStringValue("Zoom _Environment") // $NON-NLS-1$
    String layoutZoomEnvironmentMenuLabel();
    
    // layoutZoomHistory
    @DefaultStringValue("Zoom History") // $NON-NLS-1$
    String layoutZoomHistoryLabel();
    @DefaultStringValue("Zoom Histor_y") // $NON-NLS-1$
    String layoutZoomHistoryMenuLabel();
    
    // layoutZoomFiles
    @DefaultStringValue("Zoom Files") // $NON-NLS-1$
    String layoutZoomFilesLabel();
    @DefaultStringValue("Zoom F_iles") // $NON-NLS-1$
    String layoutZoomFilesMenuLabel();
    
    // layoutZoomPlots
    @DefaultStringValue("Zoom Plots") // $NON-NLS-1$
    String layoutZoomPlotsLabel();
    @DefaultStringValue("Zoom Pl_ots") // $NON-NLS-1$
    String layoutZoomPlotsMenuLabel();
    
    // layoutZoomPackages
    @DefaultStringValue("Zoom Packages") // $NON-NLS-1$
    String layoutZoomPackagesLabel();
    @DefaultStringValue("Zoom P_ackages") // $NON-NLS-1$
    String layoutZoomPackagesMenuLabel();
    
    // layoutZoomHelp
    @DefaultStringValue("Zoom Help") // $NON-NLS-1$
    String layoutZoomHelpLabel();
    @DefaultStringValue("Zoom _Help") // $NON-NLS-1$
    String layoutZoomHelpMenuLabel();
    
    // layoutZoomVcs
    @DefaultStringValue("Zoom VCS") // $NON-NLS-1$
    String layoutZoomVcsLabel();
    @DefaultStringValue("Zoom _VCS") // $NON-NLS-1$
    String layoutZoomVcsMenuLabel();
    
    // layoutZoomTutorial
    @DefaultStringValue("Zoom Tutorial") // $NON-NLS-1$
    String layoutZoomTutorialLabel();
    @DefaultStringValue("Zoom _Tutorial") // $NON-NLS-1$
    String layoutZoomTutorialMenuLabel();
    
    // layoutZoomBuild
    @DefaultStringValue("Zoom Build") // $NON-NLS-1$
    String layoutZoomBuildLabel();
    @DefaultStringValue("Zoom _Build") // $NON-NLS-1$
    String layoutZoomBuildMenuLabel();
    
    // layoutZoomViewer
    @DefaultStringValue("Zoom Viewer") // $NON-NLS-1$
    String layoutZoomViewerLabel();
    @DefaultStringValue("Zoom Vie_wer") // $NON-NLS-1$
    String layoutZoomViewerMenuLabel();
    
    // layoutZoomConnections
    @DefaultStringValue("Zoom Connections") // $NON-NLS-1$
    String layoutZoomConnectionsLabel();
    @DefaultStringValue("Zoom Co_nnections") // $NON-NLS-1$
    String layoutZoomConnectionsMenuLabel();
    
    // layoutZoomPresentation2
    @DefaultStringValue("Zoom Presentation") // $NON-NLS-1$
    String layoutZoomPresentation2Label();
    @DefaultStringValue("Zoom _Presentation") // $NON-NLS-1$
    String layoutZoomPresentation2MenuLabel();
    
    // layoutZoomCurrentPane
    @DefaultStringValue("Toggle Zoom for Current Pane") // $NON-NLS-1$
    String layoutZoomCurrentPaneLabel();
    
    // layoutEndZoom
    @DefaultStringValue("Show All Panes") // $NON-NLS-1$
    String layoutEndZoomLabel();
    @DefaultStringValue("_Show All Panes") // $NON-NLS-1$
    String layoutEndZoomMenuLabel();
    
    // newSourceColumn
    @DefaultStringValue("Add Source Column") // $NON-NLS-1$
    String newSourceColumnLabel();
    @DefaultStringValue("_Add Source Column") // $NON-NLS-1$
    String newSourceColumnMenuLabel();
    
    // layoutConsoleOnLeft
    @DefaultStringValue("Console on Left") // $NON-NLS-1$
    String layoutConsoleOnLeftLabel();
    @DefaultStringValue("Console on _Left") // $NON-NLS-1$
    String layoutConsoleOnLeftMenuLabel();
    
    // layoutConsoleOnRight
    @DefaultStringValue("Console on Right") // $NON-NLS-1$
    String layoutConsoleOnRightLabel();
    @DefaultStringValue("Console on _Right") // $NON-NLS-1$
    String layoutConsoleOnRightMenuLabel();
    
    // layoutZoomLeftColumn
    @DefaultStringValue("Zoom Left / Center Column") // $NON-NLS-1$
    String layoutZoomLeftColumnLabel();
    @DefaultStringValue("_Zoom Left / Center Column") // $NON-NLS-1$
    String layoutZoomLeftColumnMenuLabel();
    
    // layoutZoomRightColumn
    @DefaultStringValue("Zoom Right Column") // $NON-NLS-1$
    String layoutZoomRightColumnLabel();
    @DefaultStringValue("Zoo_m Right Column") // $NON-NLS-1$
    String layoutZoomRightColumnMenuLabel();
    
    // jumpTo
    @DefaultStringValue("Jump To...") // $NON-NLS-1$
    String jumpToLabel();
    @DefaultStringValue("_Jump To...") // $NON-NLS-1$
    String jumpToMenuLabel();
    
    // switchToTab
    @DefaultStringValue("Switch to Tab...") // $NON-NLS-1$
    String switchToTabLabel();
    @DefaultStringValue("Switch to Ta_b...") // $NON-NLS-1$
    String switchToTabMenuLabel();
    
    // previousTab
    @DefaultStringValue("Open Previous Tab") // $NON-NLS-1$
    String previousTabLabel();
    @DefaultStringValue("_Previous Tab") // $NON-NLS-1$
    String previousTabMenuLabel();
    
    // nextTab
    @DefaultStringValue("Open Next Tab") // $NON-NLS-1$
    String nextTabLabel();
    @DefaultStringValue("_Next Tab") // $NON-NLS-1$
    String nextTabMenuLabel();
    
    // firstTab
    @DefaultStringValue("Open First Tab") // $NON-NLS-1$
    String firstTabLabel();
    @DefaultStringValue("_First Tab") // $NON-NLS-1$
    String firstTabMenuLabel();
    
    // lastTab
    @DefaultStringValue("Open Last Tab") // $NON-NLS-1$
    String lastTabLabel();
    @DefaultStringValue("_Last Tab") // $NON-NLS-1$
    String lastTabMenuLabel();
    
    // moveTabLeft
    @DefaultStringValue("Move Tab Left") // $NON-NLS-1$
    String moveTabLeftLabel();
    @DefaultStringValue("Move Tab Lef_t") // $NON-NLS-1$
    String moveTabLeftMenuLabel();
    
    // moveTabRight
    @DefaultStringValue("Move Tab Right") // $NON-NLS-1$
    String moveTabRightLabel();
    @DefaultStringValue("Move Tab _Right") // $NON-NLS-1$
    String moveTabRightMenuLabel();
    
    // moveTabToFirst
    @DefaultStringValue("Move Tab to First") // $NON-NLS-1$
    String moveTabToFirstLabel();
    @DefaultStringValue("Move Tab to _First") // $NON-NLS-1$
    String moveTabToFirstMenuLabel();
    
    // moveTabToLast
    @DefaultStringValue("Move Tab to Last") // $NON-NLS-1$
    String moveTabToLastLabel();
    @DefaultStringValue("Move Tab to La_st") // $NON-NLS-1$
    String moveTabToLastMenuLabel();
    
    // goToLine
    @DefaultStringValue("Go to Line...") // $NON-NLS-1$
    String goToLineLabel();
    @DefaultStringValue("_Go to Line...") // $NON-NLS-1$
    String goToLineMenuLabel();
    
    // toggleFullScreen
    @DefaultStringValue("Toggle _Full Screen") // $NON-NLS-1$
    String toggleFullScreenMenuLabel();
    
    // findFromSelection
    @DefaultStringValue("_Use Selection for Find") // $NON-NLS-1$
    String findFromSelectionMenuLabel();
    
    // quickAddNext
    @DefaultStringValue("Find and Add Next") // $NON-NLS-1$
    String quickAddNextLabel();
    @DefaultStringValue("Add") // $NON-NLS-1$
    String quickAddNextButtonLabel();
    @DefaultStringValue("Find and Add Next") // $NON-NLS-1$
    String quickAddNextMenuLabel();
    @DefaultStringValue("Find and add next occurence") // $NON-NLS-1$
    String quickAddNextDesc();
    
    // findAll
    @DefaultStringValue("Find All") // $NON-NLS-1$
    String findAllLabel();
    
    // findReplace
    @DefaultStringValue("Find / Replace Text...") // $NON-NLS-1$
    String findReplaceLabel();
    @DefaultStringValue("_Find...") // $NON-NLS-1$
    String findReplaceMenuLabel();
    
    // findNext
    @DefaultStringValue("Find Next Occurence") // $NON-NLS-1$
    String findNextLabel();
    @DefaultStringValue("Next") // $NON-NLS-1$
    String findNextButtonLabel();
    @DefaultStringValue("Find _Next") // $NON-NLS-1$
    String findNextMenuLabel();
    @DefaultStringValue("Find next occurrence") // $NON-NLS-1$
    String findNextDesc();
    
    // findPrevious
    @DefaultStringValue("Find Previous Occurence") // $NON-NLS-1$
    String findPreviousLabel();
    @DefaultStringValue("Prev") // $NON-NLS-1$
    String findPreviousButtonLabel();
    @DefaultStringValue("Find Pre_vious") // $NON-NLS-1$
    String findPreviousMenuLabel();
    @DefaultStringValue("Find previous occurrence") // $NON-NLS-1$
    String findPreviousDesc();
    
    // findSelectAll
    @DefaultStringValue("Find and Select All") // $NON-NLS-1$
    String findSelectAllLabel();
    @DefaultStringValue("All") // $NON-NLS-1$
    String findSelectAllButtonLabel();
    @DefaultStringValue("Find And Select All") // $NON-NLS-1$
    String findSelectAllMenuLabel();
    @DefaultStringValue("Find and select all matches") // $NON-NLS-1$
    String findSelectAllDesc();
    
    // replaceAndFind
    @DefaultStringValue("Replace and Find Next") // $NON-NLS-1$
    String replaceAndFindLabel();
    @DefaultStringValue("Replace") // $NON-NLS-1$
    String replaceAndFindButtonLabel();
    @DefaultStringValue("_Replace and Find") // $NON-NLS-1$
    String replaceAndFindMenuLabel();
    @DefaultStringValue("Replace and find next occurrence") // $NON-NLS-1$
    String replaceAndFindDesc();
    
    // findInFiles
    @DefaultStringValue("Find _in Files...") // $NON-NLS-1$
    String findInFilesMenuLabel();
    
    // fold
    @DefaultStringValue("Collapse Fold") // $NON-NLS-1$
    String foldLabel();
    @DefaultStringValue("_Collapse") // $NON-NLS-1$
    String foldMenuLabel();
    
    // unfold
    @DefaultStringValue("Expand Fold") // $NON-NLS-1$
    String unfoldLabel();
    @DefaultStringValue("E_xpand") // $NON-NLS-1$
    String unfoldMenuLabel();
    
    // foldAll
    @DefaultStringValue("Collapse All Folds") // $NON-NLS-1$
    String foldAllLabel();
    @DefaultStringValue("Collapse _All") // $NON-NLS-1$
    String foldAllMenuLabel();
    
    // unfoldAll
    @DefaultStringValue("Expand All Folds") // $NON-NLS-1$
    String unfoldAllLabel();
    @DefaultStringValue("Ex_pand All") // $NON-NLS-1$
    String unfoldAllMenuLabel();
    
    // jumpToMatching
    @DefaultStringValue("Jump to Matching Bracket") // $NON-NLS-1$
    String jumpToMatchingLabel();
    @DefaultStringValue("Jump To _Matching") // $NON-NLS-1$
    String jumpToMatchingMenuLabel();
    @DefaultStringValue("Jump to matching bracket") // $NON-NLS-1$
    String jumpToMatchingDesc();
    
    // expandToMatching
    @DefaultStringValue("Expand to Matching Bracket") // $NON-NLS-1$
    String expandToMatchingLabel();
    @DefaultStringValue("Expand To _Matching") // $NON-NLS-1$
    String expandToMatchingMenuLabel();
    @DefaultStringValue("Expand selection to matching bracket") // $NON-NLS-1$
    String expandToMatchingDesc();
    
    // addCursorAbove
    @DefaultStringValue("Add Cursor Above Current Cursor") // $NON-NLS-1$
    String addCursorAboveMenuLabel();
    
    // addCursorBelow
    @DefaultStringValue("Add Cursor Below Current Cursor") // $NON-NLS-1$
    String addCursorBelowMenuLabel();
    
    // moveLinesUp
    @DefaultStringValue("Move Lines Up") // $NON-NLS-1$
    String moveLinesUpMenuLabel();
    
    // moveLinesDown
    @DefaultStringValue("Move Lines Down") // $NON-NLS-1$
    String moveLinesDownMenuLabel();
    
    // expandToLine
    @DefaultStringValue("Expand Selection to Line") // $NON-NLS-1$
    String expandToLineMenuLabel();
    
    // copyLinesDown
    @DefaultStringValue("Copy Lines Down") // $NON-NLS-1$
    String copyLinesDownMenuLabel();
    
    // joinLines
    @DefaultStringValue("Join Lines") // $NON-NLS-1$
    String joinLinesMenuLabel();
    
    // removeLine
    @DefaultStringValue("Remove Line") // $NON-NLS-1$
    String removeLineMenuLabel();
    
    // splitIntoLines
    @DefaultStringValue("Split Into Lines") // $NON-NLS-1$
    String splitIntoLinesMenuLabel();
    @DefaultStringValue("Create a new cursor on each line in current selection") // $NON-NLS-1$
    String splitIntoLinesDesc();
    
    // editLinesFromStart
    @DefaultStringValue("Edit Lines from Start") // $NON-NLS-1$
    String editLinesFromStartMenuLabel();
    @DefaultStringValue("Create a new cursor at start of each line in selection") // $NON-NLS-1$
    String editLinesFromStartDesc();
    
    // executeAllCode
    @DefaultStringValue("Run All Code in Current Source File") // $NON-NLS-1$
    String executeAllCodeLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String executeAllCodeButtonLabel();
    @DefaultStringValue("Run _All") // $NON-NLS-1$
    String executeAllCodeMenuLabel();
    @DefaultStringValue("Run all of the code in the source file") // $NON-NLS-1$
    String executeAllCodeDesc();
    
    // executeCode
    @DefaultStringValue("Run Current Line or Selection") // $NON-NLS-1$
    String executeCodeLabel();
    @DefaultStringValue("Run") // $NON-NLS-1$
    String executeCodeButtonLabel();
    @DefaultStringValue("Run Selected _Line(s)") // $NON-NLS-1$
    String executeCodeMenuLabel();
    @DefaultStringValue("Run the current line or selection") // $NON-NLS-1$
    String executeCodeDesc();
    
    // executeCodeWithoutMovingCursor
    @DefaultStringValue("Run Current Line or Selection (Without Moving Cursor)") // $NON-NLS-1$
    String executeCodeWithoutMovingCursorLabel();
    @DefaultStringValue("Run") // $NON-NLS-1$
    String executeCodeWithoutMovingCursorButtonLabel();
    @DefaultStringValue("Run _Line(s) without moving cursor") // $NON-NLS-1$
    String executeCodeWithoutMovingCursorMenuLabel();
    @DefaultStringValue("Run the current line or selection without moving the cursor") // $NON-NLS-1$
    String executeCodeWithoutMovingCursorDesc();
    
    // executeCodeWithoutFocus
    
    // executeToCurrentLine
    @DefaultStringValue("Execute Code up to Current Line") // $NON-NLS-1$
    String executeToCurrentLineLabel();
    @DefaultStringValue("Run From _Beginning To Line") // $NON-NLS-1$
    String executeToCurrentLineMenuLabel();
    @DefaultStringValue("Run from the beginning of the source file up through the current line") // $NON-NLS-1$
    String executeToCurrentLineDesc();
    
    // executeFromCurrentLine
    @DefaultStringValue("Execute Code From Current Line to End of Document") // $NON-NLS-1$
    String executeFromCurrentLineLabel();
    @DefaultStringValue("Run From Line to _End") // $NON-NLS-1$
    String executeFromCurrentLineMenuLabel();
    @DefaultStringValue("Run from the current line through the end of the source file") // $NON-NLS-1$
    String executeFromCurrentLineDesc();
    
    // executeCurrentFunction
    @DefaultStringValue("Run Current Function Definition") // $NON-NLS-1$
    String executeCurrentFunctionLabel();
    @DefaultStringValue("Run _Function Definition") // $NON-NLS-1$
    String executeCurrentFunctionMenuLabel();
    @DefaultStringValue("Run the top-level function definition, if any, that contains the cursor") // $NON-NLS-1$
    String executeCurrentFunctionDesc();
    
    // executeCurrentSection
    @DefaultStringValue("Execute Current Code Section") // $NON-NLS-1$
    String executeCurrentSectionLabel();
    @DefaultStringValue("Run Section") // $NON-NLS-1$
    String executeCurrentSectionButtonLabel();
    @DefaultStringValue("Run Code _Section") // $NON-NLS-1$
    String executeCurrentSectionMenuLabel();
    @DefaultStringValue("Run the code section that contains the cursor") // $NON-NLS-1$
    String executeCurrentSectionDesc();
    
    // executeLastCode
    @DefaultStringValue("Re-Run Previous Code Execution") // $NON-NLS-1$
    String executeLastCodeLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String executeLastCodeButtonLabel();
    @DefaultStringValue("Re-Run _Previous") // $NON-NLS-1$
    String executeLastCodeMenuLabel();
    @DefaultStringValue("Re-run the previous code region") // $NON-NLS-1$
    String executeLastCodeDesc();
    
    // executeCurrentLine
    @DefaultStringValue("Execute Current Line") // $NON-NLS-1$
    String executeCurrentLineLabel();
    @DefaultStringValue("Execute Current _Line") // $NON-NLS-1$
    String executeCurrentLineMenuLabel();
    @DefaultStringValue("Execute the line which contains the cursor") // $NON-NLS-1$
    String executeCurrentLineDesc();
    
    // executeCurrentStatement
    @DefaultStringValue("Execute Current Statement") // $NON-NLS-1$
    String executeCurrentStatementLabel();
    @DefaultStringValue("Execute Current _Statement") // $NON-NLS-1$
    String executeCurrentStatementMenuLabel();
    @DefaultStringValue("Execute the entire R statement which contains the cursor.") // $NON-NLS-1$
    String executeCurrentStatementDesc();
    
    // executeCurrentParagraph
    @DefaultStringValue("Execute Current Paragraph") // $NON-NLS-1$
    String executeCurrentParagraphLabel();
    @DefaultStringValue("Execute Current _Paragraph") // $NON-NLS-1$
    String executeCurrentParagraphMenuLabel();
    @DefaultStringValue("Execute the current paragraph of code, delimited by blank lines.") // $NON-NLS-1$
    String executeCurrentParagraphDesc();
    
    // insertChunk
    @DefaultStringValue("_Insert Chunk") // $NON-NLS-1$
    String insertChunkMenuLabel();
    @DefaultStringValue("Insert a new code chunk") // $NON-NLS-1$
    String insertChunkDesc();
    
    // insertChunkR
    @DefaultStringValue("R") // $NON-NLS-1$
    String insertChunkRMenuLabel();
    @DefaultStringValue("Insert a new R chunk") // $NON-NLS-1$
    String insertChunkRDesc();
    
    // insertChunkBash
    @DefaultStringValue("Bash") // $NON-NLS-1$
    String insertChunkBashMenuLabel();
    @DefaultStringValue("Insert a new Bash chunk") // $NON-NLS-1$
    String insertChunkBashDesc();
    
    // insertChunkD3
    @DefaultStringValue("D3") // $NON-NLS-1$
    String insertChunkD3MenuLabel();
    @DefaultStringValue("Insert a new D3 chunk") // $NON-NLS-1$
    String insertChunkD3Desc();
    
    // insertChunkPython
    @DefaultStringValue("Python") // $NON-NLS-1$
    String insertChunkPythonMenuLabel();
    @DefaultStringValue("Insert a new Python chunk") // $NON-NLS-1$
    String insertChunkPythonDesc();
    
    // insertChunkRCPP
    @DefaultStringValue("Rcpp") // $NON-NLS-1$
    String insertChunkRCPPMenuLabel();
    @DefaultStringValue("Insert a new Rcpp chunk") // $NON-NLS-1$
    String insertChunkRCPPDesc();
    
    // insertChunkStan
    @DefaultStringValue("Stan") // $NON-NLS-1$
    String insertChunkStanMenuLabel();
    @DefaultStringValue("Insert a new Stan chunk") // $NON-NLS-1$
    String insertChunkStanDesc();
    
    // insertChunkSQL
    @DefaultStringValue("SQL") // $NON-NLS-1$
    String insertChunkSQLMenuLabel();
    @DefaultStringValue("Insert a new SQL chunk") // $NON-NLS-1$
    String insertChunkSQLDesc();
    
    // switchToChunkR
    @DefaultStringValue("R") // $NON-NLS-1$
    String switchToChunkRMenuLabel();
    @DefaultStringValue("Switch chunk to R") // $NON-NLS-1$
    String switchToChunkRDesc();
    
    // switchToChunkBash
    @DefaultStringValue("Bash") // $NON-NLS-1$
    String switchToChunkBashMenuLabel();
    @DefaultStringValue("Switch chunk to Bash") // $NON-NLS-1$
    String switchToChunkBashDesc();
    
    // switchToChunkPython
    @DefaultStringValue("Python") // $NON-NLS-1$
    String switchToChunkPythonMenuLabel();
    @DefaultStringValue("Switch chunk to Python") // $NON-NLS-1$
    String switchToChunkPythonDesc();
    
    // switchToChunkRCPP
    @DefaultStringValue("Rcpp") // $NON-NLS-1$
    String switchToChunkRCPPMenuLabel();
    @DefaultStringValue("Switch chunk to Rcpp") // $NON-NLS-1$
    String switchToChunkRCPPDesc();
    
    // switchToChunkStan
    @DefaultStringValue("Stan") // $NON-NLS-1$
    String switchToChunkStanMenuLabel();
    @DefaultStringValue("Switch chunk to Stan") // $NON-NLS-1$
    String switchToChunkStanDesc();
    
    // switchToChunkSQL
    @DefaultStringValue("SQL") // $NON-NLS-1$
    String switchToChunkSQLMenuLabel();
    @DefaultStringValue("Switch chunk to SQL") // $NON-NLS-1$
    String switchToChunkSQLDesc();
    
    // insertSection
    @DefaultStringValue("_Insert Section...") // $NON-NLS-1$
    String insertSectionMenuLabel();
    @DefaultStringValue("Insert a new code section") // $NON-NLS-1$
    String insertSectionDesc();
    
    // executePreviousChunks
    @DefaultStringValue("_Run All Chunks Above") // $NON-NLS-1$
    String executePreviousChunksMenuLabel();
    @DefaultStringValue("Run all chunks above the current one") // $NON-NLS-1$
    String executePreviousChunksDesc();
    
    // executeSubsequentChunks
    @DefaultStringValue("Run All C_hunks Below") // $NON-NLS-1$
    String executeSubsequentChunksMenuLabel();
    @DefaultStringValue("Run all chunks below the current one") // $NON-NLS-1$
    String executeSubsequentChunksDesc();
    
    // executeCurrentChunk
    @DefaultStringValue("Run _Current Chunk") // $NON-NLS-1$
    String executeCurrentChunkMenuLabel();
    @DefaultStringValue("Run the current code chunk") // $NON-NLS-1$
    String executeCurrentChunkDesc();
    
    // executeNextChunk
    @DefaultStringValue("Run _Next Chunk") // $NON-NLS-1$
    String executeNextChunkMenuLabel();
    @DefaultStringValue("Run the next code chunk") // $NON-NLS-1$
    String executeNextChunkDesc();
    
    // executeSetupChunk
    @DefaultStringValue("Run _Setup Chunk") // $NON-NLS-1$
    String executeSetupChunkMenuLabel();
    @DefaultStringValue("Run the initial setup chunk") // $NON-NLS-1$
    String executeSetupChunkDesc();
    
    // goToHelp
    @DefaultStringValue("Show Help for Current Function") // $NON-NLS-1$
    String goToHelpLabel();
    @DefaultStringValue("Go To _Help") // $NON-NLS-1$
    String goToHelpMenuLabel();
    @DefaultStringValue("Go to help for the currently selected function") // $NON-NLS-1$
    String goToHelpDesc();
    
    // goToDefinition
    @DefaultStringValue("_Go To Function Definition") // $NON-NLS-1$
    String goToDefinitionMenuLabel();
    @DefaultStringValue("Go to to the definition of the currently selected function") // $NON-NLS-1$
    String goToDefinitionDesc();
    
    // codeCompletion
    @DefaultStringValue("Retrieve Completions") // $NON-NLS-1$
    String codeCompletionLabel();
    @DefaultStringValue("Code Completion") // $NON-NLS-1$
    String codeCompletionMenuLabel();
    @DefaultStringValue("Show code completions at the current cursor location") // $NON-NLS-1$
    String codeCompletionDesc();
    
    // sourceNavigateBack
    @DefaultStringValue("Bac_k") // $NON-NLS-1$
    String sourceNavigateBackMenuLabel();
    @DefaultStringValue("Go back to the previous source location") // $NON-NLS-1$
    String sourceNavigateBackDesc();
    
    // sourceNavigateForward
    @DefaultStringValue("For_ward") // $NON-NLS-1$
    String sourceNavigateForwardMenuLabel();
    @DefaultStringValue("Go forward to the next source location") // $NON-NLS-1$
    String sourceNavigateForwardDesc();
    
    // extractFunction
    @DefaultStringValue("E_xtract Function") // $NON-NLS-1$
    String extractFunctionMenuLabel();
    @DefaultStringValue("Turn the current selection into a function") // $NON-NLS-1$
    String extractFunctionDesc();
    
    // extractLocalVariable
    @DefaultStringValue("Extract _Variable") // $NON-NLS-1$
    String extractLocalVariableMenuLabel();
    @DefaultStringValue("Extract a variable out of the current selection") // $NON-NLS-1$
    String extractLocalVariableDesc();
    
    // findUsages
    @DefaultStringValue("Find _Usages") // $NON-NLS-1$
    String findUsagesMenuLabel();
    @DefaultStringValue("Find source locations where this symbol is used") // $NON-NLS-1$
    String findUsagesDesc();
    
    // sourceFile
    @DefaultStringValue("") // $NON-NLS-1$
    String sourceFileButtonLabel();
    @DefaultStringValue("Source _File...") // $NON-NLS-1$
    String sourceFileMenuLabel();
    @DefaultStringValue("Source the contents of an R file") // $NON-NLS-1$
    String sourceFileDesc();
    
    // previewJS
    @DefaultStringValue("Preview") // $NON-NLS-1$
    String previewJSButtonLabel();
    @DefaultStringValue("Preview J_S") // $NON-NLS-1$
    String previewJSMenuLabel();
    @DefaultStringValue("Preview the active JavaScript document") // $NON-NLS-1$
    String previewJSDesc();
    
    // previewSql
    @DefaultStringValue("Preview") // $NON-NLS-1$
    String previewSqlButtonLabel();
    @DefaultStringValue("Preview S_QL") // $NON-NLS-1$
    String previewSqlMenuLabel();
    @DefaultStringValue("Preview the active SQL document") // $NON-NLS-1$
    String previewSqlDesc();
    
    // sourceActiveDocument
    @DefaultStringValue("Source") // $NON-NLS-1$
    String sourceActiveDocumentButtonLabel();
    @DefaultStringValue("_Source") // $NON-NLS-1$
    String sourceActiveDocumentMenuLabel();
    @DefaultStringValue("Source the contents of the active document") // $NON-NLS-1$
    String sourceActiveDocumentDesc();
    
    // sourceActiveDocumentWithEcho
    @DefaultStringValue("") // $NON-NLS-1$
    String sourceActiveDocumentWithEchoButtonLabel();
    @DefaultStringValue("Source with _Echo") // $NON-NLS-1$
    String sourceActiveDocumentWithEchoMenuLabel();
    @DefaultStringValue("Source the contents of the active document (with echo)") // $NON-NLS-1$
    String sourceActiveDocumentWithEchoDesc();
    
    // runDocumentFromServerDotR
    @DefaultStringValue("Run Document") // $NON-NLS-1$
    String runDocumentFromServerDotRButtonLabel();
    @DefaultStringValue("Run _Document") // $NON-NLS-1$
    String runDocumentFromServerDotRMenuLabel();
    @DefaultStringValue("Run the interactive document") // $NON-NLS-1$
    String runDocumentFromServerDotRDesc();
    
    // commentUncomment
    @DefaultStringValue("Comment / Uncomment Selection") // $NON-NLS-1$
    String commentUncommentLabel();
    @DefaultStringValue("_Comment/Uncomment Lines") // $NON-NLS-1$
    String commentUncommentMenuLabel();
    @DefaultStringValue("Comment or uncomment the current line/selection") // $NON-NLS-1$
    String commentUncommentDesc();
    
    // reformatCode
    @DefaultStringValue("Reformat Current Selection") // $NON-NLS-1$
    String reformatCodeLabel();
    @DefaultStringValue("Re_format Code") // $NON-NLS-1$
    String reformatCodeMenuLabel();
    @DefaultStringValue("Reformat the current line/selection") // $NON-NLS-1$
    String reformatCodeDesc();
    
    // showDiagnosticsActiveDocument
    @DefaultStringValue("Show Diagnostics for Current Document") // $NON-NLS-1$
    String showDiagnosticsActiveDocumentLabel();
    @DefaultStringValue("Show _Diagnostics") // $NON-NLS-1$
    String showDiagnosticsActiveDocumentMenuLabel();
    @DefaultStringValue("Show diagnostics for the active document") // $NON-NLS-1$
    String showDiagnosticsActiveDocumentDesc();
    
    // showDiagnosticsProject
    @DefaultStringValue("Show Diagnostics for Current Project") // $NON-NLS-1$
    String showDiagnosticsProjectLabel();
    @DefaultStringValue("Show Diagnostics (Projec_t)") // $NON-NLS-1$
    String showDiagnosticsProjectMenuLabel();
    @DefaultStringValue("Show diagnostics for all source files in the current project") // $NON-NLS-1$
    String showDiagnosticsProjectDesc();
    
    // reindent
    @DefaultStringValue("Reindent Selection") // $NON-NLS-1$
    String reindentLabel();
    @DefaultStringValue("_Reindent Lines") // $NON-NLS-1$
    String reindentMenuLabel();
    @DefaultStringValue("Reindent the current line/selection") // $NON-NLS-1$
    String reindentDesc();
    
    // reflowComment
    @DefaultStringValue("Reflow Co_mment") // $NON-NLS-1$
    String reflowCommentMenuLabel();
    @DefaultStringValue("Reflow selected comment lines so they wrap evenly") // $NON-NLS-1$
    String reflowCommentDesc();
    
    // renameInScope
    @DefaultStringValue("Rename Symbol in Scope") // $NON-NLS-1$
    String renameInScopeLabel();
    @DefaultStringValue("Ren_ame in Scope") // $NON-NLS-1$
    String renameInScopeMenuLabel();
    @DefaultStringValue("Rename symbol in current scope") // $NON-NLS-1$
    String renameInScopeDesc();
    
    // insertSnippet
    @DefaultStringValue("Insert Snippet") // $NON-NLS-1$
    String insertSnippetMenuLabel();
    @DefaultStringValue("Expand snippet at cursor") // $NON-NLS-1$
    String insertSnippetDesc();
    
    // insertRoxygenSkeleton
    @DefaultStringValue("Insert Ro_xygen Skeleton") // $NON-NLS-1$
    String insertRoxygenSkeletonMenuLabel();
    @DefaultStringValue("Insert a roxygen comment for the current function") // $NON-NLS-1$
    String insertRoxygenSkeletonDesc();
    
    // expandSelection
    @DefaultStringValue("Expand Selection") // $NON-NLS-1$
    String expandSelectionMenuLabel();
    @DefaultStringValue("Expand selection") // $NON-NLS-1$
    String expandSelectionDesc();
    
    // shrinkSelection
    @DefaultStringValue("Shrink Selection") // $NON-NLS-1$
    String shrinkSelectionMenuLabel();
    @DefaultStringValue("Shrink selection") // $NON-NLS-1$
    String shrinkSelectionDesc();
    
    // goToNextSection
    @DefaultStringValue("Go to Next Section") // $NON-NLS-1$
    String goToNextSectionLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String goToNextSectionButtonLabel();
    @DefaultStringValue("Go to next section/chunk") // $NON-NLS-1$
    String goToNextSectionDesc();
    
    // goToPrevSection
    @DefaultStringValue("Go to Previous Section") // $NON-NLS-1$
    String goToPrevSectionLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String goToPrevSectionButtonLabel();
    @DefaultStringValue("Go to previous section/chunk") // $NON-NLS-1$
    String goToPrevSectionDesc();
    
    // goToStartOfCurrentScope
    
    // goToEndOfCurrentScope
    
    // goToNextChunk
    @DefaultStringValue("Go to Next Chunk") // $NON-NLS-1$
    String goToNextChunkLabel();
    @DefaultStringValue("Go to next chunk") // $NON-NLS-1$
    String goToNextChunkDesc();
    
    // goToPrevChunk
    @DefaultStringValue("Go to Previous Chunk") // $NON-NLS-1$
    String goToPrevChunkLabel();
    @DefaultStringValue("Go to previous chunk") // $NON-NLS-1$
    String goToPrevChunkDesc();
    
    // expandRaggedSelection
    @DefaultStringValue("Expand Ragged Selection") // $NON-NLS-1$
    String expandRaggedSelectionLabel();
    
    // markdownHelp
    @DefaultStringValue("Open Markdown Quick Reference") // $NON-NLS-1$
    String markdownHelpLabel();
    @DefaultStringValue("_Markdown Quick Reference") // $NON-NLS-1$
    String markdownHelpMenuLabel();
    @DefaultStringValue("Markdown quick reference") // $NON-NLS-1$
    String markdownHelpDesc();
    
    // openRoxygenQuickReference
    @DefaultStringValue("_Roxygen Quick Reference") // $NON-NLS-1$
    String openRoxygenQuickReferenceMenuLabel();
    @DefaultStringValue("Roxygen quick reference") // $NON-NLS-1$
    String openRoxygenQuickReferenceDesc();
    
    // toggleDocumentOutline
    @DefaultStringValue("Toggle Document Outline") // $NON-NLS-1$
    String toggleDocumentOutlineLabel();
    @DefaultStringValue("Outline") // $NON-NLS-1$
    String toggleDocumentOutlineButtonLabel();
    @DefaultStringValue("_Show Document Outline") // $NON-NLS-1$
    String toggleDocumentOutlineMenuLabel();
    @DefaultStringValue("Show document outline") // $NON-NLS-1$
    String toggleDocumentOutlineDesc();
    
    // toggleRmdVisualMode
    @DefaultStringValue("Toggle Visual Markdown Editor") // $NON-NLS-1$
    String toggleRmdVisualModeLabel();
    @DefaultStringValue("_Use Visual Editor") // $NON-NLS-1$
    String toggleRmdVisualModeMenuLabel();
    @DefaultStringValue("Switch markdown editing mode") // $NON-NLS-1$
    String toggleRmdVisualModeDesc();
    
    // enableProsemirrorDevTools
    @DefaultStringValue("Enable Prosemirror DevTools") // $NON-NLS-1$
    String enableProsemirrorDevToolsLabel();
    @DefaultStringValue("_Prosemirror DevTools") // $NON-NLS-1$
    String enableProsemirrorDevToolsMenuLabel();
    @DefaultStringValue("Enable Prosemirror DevTools") // $NON-NLS-1$
    String enableProsemirrorDevToolsDesc();
    
    // usingRMarkdownHelp
    @DefaultStringValue("_Using R Markdown") // $NON-NLS-1$
    String usingRMarkdownHelpMenuLabel();
    @DefaultStringValue("Guide to using R Markdown") // $NON-NLS-1$
    String usingRMarkdownHelpDesc();
    
    // authoringRPresentationsHelp
    @DefaultStringValue("_Authoring R Presentations") // $NON-NLS-1$
    String authoringRPresentationsHelpMenuLabel();
    @DefaultStringValue("Guide to using R Markdown") // $NON-NLS-1$
    String authoringRPresentationsHelpDesc();
    
    // openRStudioIDECheatSheet
    @DefaultStringValue("_RStudio IDE Cheat Sheet") // $NON-NLS-1$
    String openRStudioIDECheatSheetMenuLabel();
    @DefaultStringValue("RStudio IDE cheat sheet") // $NON-NLS-1$
    String openRStudioIDECheatSheetDesc();
    
    // openDataVisualizationCheatSheet
    @DefaultStringValue("Data Visualization with _ggplot2") // $NON-NLS-1$
    String openDataVisualizationCheatSheetMenuLabel();
    @DefaultStringValue("Data visualization with ggplot2") // $NON-NLS-1$
    String openDataVisualizationCheatSheetDesc();
    
    // openPurrrCheatSheet
    @DefaultStringValue("List manipulation with _purrr") // $NON-NLS-1$
    String openPurrrCheatSheetMenuLabel();
    @DefaultStringValue("List manipulation with purrr") // $NON-NLS-1$
    String openPurrrCheatSheetDesc();
    
    // openPackageDevelopmentCheatSheet
    @DefaultStringValue("Package De_velopment with devtools") // $NON-NLS-1$
    String openPackageDevelopmentCheatSheetMenuLabel();
    @DefaultStringValue("Package development with devtools") // $NON-NLS-1$
    String openPackageDevelopmentCheatSheetDesc();
    
    // openDataImportCheatSheet
    @DefaultStringValue("_Import Data with readr") // $NON-NLS-1$
    String openDataImportCheatSheetMenuLabel();
    @DefaultStringValue("Import data with readr") // $NON-NLS-1$
    String openDataImportCheatSheetDesc();
    
    // openDataWranglingCheatSheet
    @DefaultStringValue("Data Manipulation with dplyr, tid_yr") // $NON-NLS-1$
    String openDataWranglingCheatSheetMenuLabel();
    @DefaultStringValue("Data manipulation with dplyr and tidyr") // $NON-NLS-1$
    String openDataWranglingCheatSheetDesc();
    
    // openDataTransformationCheatSheet
    @DefaultStringValue("Data Transformation with _dplyr") // $NON-NLS-1$
    String openDataTransformationCheatSheetMenuLabel();
    @DefaultStringValue("Data transformation with dplyr") // $NON-NLS-1$
    String openDataTransformationCheatSheetDesc();
    
    // openSparklyrCheatSheet
    @DefaultStringValue("Interfacing Spar_k with sparklyr") // $NON-NLS-1$
    String openSparklyrCheatSheetMenuLabel();
    @DefaultStringValue("Interfacing Apache Spark with sparklyr") // $NON-NLS-1$
    String openSparklyrCheatSheetDesc();
    
    // openRMarkdownCheatSheet
    @DefaultStringValue("R _Markdown Cheat Sheet") // $NON-NLS-1$
    String openRMarkdownCheatSheetMenuLabel();
    @DefaultStringValue("R Markdown cheat sheet") // $NON-NLS-1$
    String openRMarkdownCheatSheetDesc();
    
    // openRMarkdownReferenceGuide
    @DefaultStringValue("R Markdo_wn Reference Guide") // $NON-NLS-1$
    String openRMarkdownReferenceGuideMenuLabel();
    @DefaultStringValue("R Markdown reference guide") // $NON-NLS-1$
    String openRMarkdownReferenceGuideDesc();
    
    // openShinyCheatSheet
    @DefaultStringValue("Web Applications with _shiny") // $NON-NLS-1$
    String openShinyCheatSheetMenuLabel();
    @DefaultStringValue("Build web applications with Shiny") // $NON-NLS-1$
    String openShinyCheatSheetDesc();
    
    // browseCheatSheets
    @DefaultStringValue("_Browse Cheat Sheets...") // $NON-NLS-1$
    String browseCheatSheetsMenuLabel();
    @DefaultStringValue("Browse available cheat sheets in your web browser") // $NON-NLS-1$
    String browseCheatSheetsDesc();
    
    // knitDocument
    @DefaultStringValue("Knit Current Document") // $NON-NLS-1$
    String knitDocumentLabel();
    @DefaultStringValue("Knit") // $NON-NLS-1$
    String knitDocumentButtonLabel();
    @DefaultStringValue("_Knit Document") // $NON-NLS-1$
    String knitDocumentMenuLabel();
    @DefaultStringValue("Knit the current document") // $NON-NLS-1$
    String knitDocumentDesc();
    
    // quartoRenderDocument
    @DefaultStringValue("Render Current Document") // $NON-NLS-1$
    String quartoRenderDocumentLabel();
    @DefaultStringValue("Render") // $NON-NLS-1$
    String quartoRenderDocumentButtonLabel();
    @DefaultStringValue("_Render Document") // $NON-NLS-1$
    String quartoRenderDocumentMenuLabel();
    @DefaultStringValue("Render the current document") // $NON-NLS-1$
    String quartoRenderDocumentDesc();
    
    // previewHTML
    @DefaultStringValue("Preview Document as HTML") // $NON-NLS-1$
    String previewHTMLLabel();
    @DefaultStringValue("Preview") // $NON-NLS-1$
    String previewHTMLButtonLabel();
    @DefaultStringValue("Previe_w") // $NON-NLS-1$
    String previewHTMLMenuLabel();
    @DefaultStringValue("Show a preview of the current document as HTML") // $NON-NLS-1$
    String previewHTMLDesc();
    
    // publishHTML
    @DefaultStringValue("Publish to RPubs...") // $NON-NLS-1$
    String publishHTMLLabel();
    @DefaultStringValue("Publish") // $NON-NLS-1$
    String publishHTMLButtonLabel();
    @DefaultStringValue("P_ublish to RPubs...") // $NON-NLS-1$
    String publishHTMLMenuLabel();
    @DefaultStringValue("Publish the current document") // $NON-NLS-1$
    String publishHTMLDesc();
    
    // compilePDF
    @DefaultStringValue("Compile to PDF...") // $NON-NLS-1$
    String compilePDFLabel();
    @DefaultStringValue("Compile PDF") // $NON-NLS-1$
    String compilePDFButtonLabel();
    @DefaultStringValue("_Compile PDF") // $NON-NLS-1$
    String compilePDFMenuLabel();
    @DefaultStringValue("Compile a PDF from the current LaTeX or Sweave document") // $NON-NLS-1$
    String compilePDFDesc();
    
    // compileNotebook
    @DefaultStringValue("_Compile Report...") // $NON-NLS-1$
    String compileNotebookMenuLabel();
    @DefaultStringValue("Compile a report from the current R script") // $NON-NLS-1$
    String compileNotebookDesc();
    
    // editRmdFormatOptions
    @DefaultStringValue("_Output Options...") // $NON-NLS-1$
    String editRmdFormatOptionsMenuLabel();
    @DefaultStringValue("Edit the R Markdown format options for the current file") // $NON-NLS-1$
    String editRmdFormatOptionsDesc();
    
    // knitWithParameters
    @DefaultStringValue("Knit with Parameters...") // $NON-NLS-1$
    String knitWithParametersLabel();
    @DefaultStringValue("Knit _with Parameters...") // $NON-NLS-1$
    String knitWithParametersMenuLabel();
    @DefaultStringValue("Knit the document with a set of custom parameters") // $NON-NLS-1$
    String knitWithParametersDesc();
    
    // clearKnitrCache
    @DefaultStringValue("Clear Knitr Cache...") // $NON-NLS-1$
    String clearKnitrCacheMenuLabel();
    @DefaultStringValue("Clear the knitr cache for the current document") // $NON-NLS-1$
    String clearKnitrCacheDesc();
    
    // clearPrerenderedOutput
    @DefaultStringValue("Clear Prerendered Output...") // $NON-NLS-1$
    String clearPrerenderedOutputMenuLabel();
    @DefaultStringValue("Clear the prerendered output for the current document") // $NON-NLS-1$
    String clearPrerenderedOutputDesc();
    
    // notebookExpandAllOutput
    @DefaultStringValue("") // $NON-NLS-1$
    String notebookExpandAllOutputButtonLabel();
    @DefaultStringValue("E_xpand All Output") // $NON-NLS-1$
    String notebookExpandAllOutputMenuLabel();
    @DefaultStringValue("Expand all code chunk output in the current file") // $NON-NLS-1$
    String notebookExpandAllOutputDesc();
    
    // notebookToggleExpansion
    @DefaultStringValue("") // $NON-NLS-1$
    String notebookToggleExpansionButtonLabel();
    @DefaultStringValue("Toggle Chunk Output Expansion") // $NON-NLS-1$
    String notebookToggleExpansionMenuLabel();
    @DefaultStringValue("Expand or collapse the output of the current notebook chunk") // $NON-NLS-1$
    String notebookToggleExpansionDesc();
    
    // notebookCollapseAllOutput
    @DefaultStringValue("") // $NON-NLS-1$
    String notebookCollapseAllOutputButtonLabel();
    @DefaultStringValue("Collapse All _Output") // $NON-NLS-1$
    String notebookCollapseAllOutputMenuLabel();
    @DefaultStringValue("Collapse all code chunk output in the current file") // $NON-NLS-1$
    String notebookCollapseAllOutputDesc();
    
    // notebookClearOutput
    @DefaultStringValue("") // $NON-NLS-1$
    String notebookClearOutputButtonLabel();
    @DefaultStringValue("Cl_ear Output") // $NON-NLS-1$
    String notebookClearOutputMenuLabel();
    @DefaultStringValue("Clear the output of the current notebook chunk") // $NON-NLS-1$
    String notebookClearOutputDesc();
    
    // notebookClearAllOutput
    @DefaultStringValue("") // $NON-NLS-1$
    String notebookClearAllOutputButtonLabel();
    @DefaultStringValue("Clear A_ll Output") // $NON-NLS-1$
    String notebookClearAllOutputMenuLabel();
    @DefaultStringValue("Remove all code chunk output in the current file") // $NON-NLS-1$
    String notebookClearAllOutputDesc();
    
    // synctexSearch
    @DefaultStringValue("") // $NON-NLS-1$
    String synctexSearchButtonLabel();
    @DefaultStringValue("S_ync PDF View to Editor") // $NON-NLS-1$
    String synctexSearchMenuLabel();
    @DefaultStringValue("Sync PDF view to editor location (Ctrl+Click)") // $NON-NLS-1$
    String synctexSearchDesc();
    
    // checkSpelling
    @DefaultStringValue("Check _Spelling...") // $NON-NLS-1$
    String checkSpellingMenuLabel();
    @DefaultStringValue("Check spelling in document") // $NON-NLS-1$
    String checkSpellingDesc();
    
    // wordCount
    @DefaultStringValue("_Word Count") // $NON-NLS-1$
    String wordCountMenuLabel();
    @DefaultStringValue("Count words in selection or document") // $NON-NLS-1$
    String wordCountDesc();
    
    // newFolder
    @DefaultStringValue("Create a New Folder...") // $NON-NLS-1$
    String newFolderLabel();
    @DefaultStringValue("New Folder") // $NON-NLS-1$
    String newFolderButtonLabel();
    @DefaultStringValue("Folder...") // $NON-NLS-1$
    String newFolderMenuLabel();
    @DefaultStringValue("Create a new folder") // $NON-NLS-1$
    String newFolderDesc();
    
    // touchSourceDoc
    @DefaultStringValue("Create a Blank R script in current directory") // $NON-NLS-1$
    String touchSourceDocLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String touchSourceDocButtonLabel();
    @DefaultStringValue("_R Script") // $NON-NLS-1$
    String touchSourceDocMenuLabel();
    @DefaultStringValue("Create a blank R script in current directory") // $NON-NLS-1$
    String touchSourceDocDesc();
    
    // touchTextDoc
    @DefaultStringValue("_Text File") // $NON-NLS-1$
    String touchTextDocMenuLabel();
    @DefaultStringValue("Create a blank text file in current directory") // $NON-NLS-1$
    String touchTextDocDesc();
    
    // touchCDoc
    @DefaultStringValue("_C File") // $NON-NLS-1$
    String touchCDocMenuLabel();
    @DefaultStringValue("Create a blank C file in current directory") // $NON-NLS-1$
    String touchCDocDesc();
    
    // touchCppDoc
    @DefaultStringValue("_C++ File") // $NON-NLS-1$
    String touchCppDocMenuLabel();
    @DefaultStringValue("Create a blank C++ file in current directory") // $NON-NLS-1$
    String touchCppDocDesc();
    
    // touchHeaderDoc
    @DefaultStringValue("_Header File") // $NON-NLS-1$
    String touchHeaderDocMenuLabel();
    @DefaultStringValue("Create a blank header file in current directory") // $NON-NLS-1$
    String touchHeaderDocDesc();
    
    // touchMarkdownDoc
    @DefaultStringValue("_Markdown File") // $NON-NLS-1$
    String touchMarkdownDocMenuLabel();
    @DefaultStringValue("Create a blank Markdown document in current directory") // $NON-NLS-1$
    String touchMarkdownDocDesc();
    
    // touchPythonDoc
    @DefaultStringValue("_Python Script") // $NON-NLS-1$
    String touchPythonDocMenuLabel();
    @DefaultStringValue("Create a blank Python script in current directory") // $NON-NLS-1$
    String touchPythonDocDesc();
    
    // touchShellDoc
    @DefaultStringValue("_Shell Script") // $NON-NLS-1$
    String touchShellDocMenuLabel();
    @DefaultStringValue("Create a blank shell script in current directory") // $NON-NLS-1$
    String touchShellDocDesc();
    
    // touchStanDoc
    @DefaultStringValue("_Stan File") // $NON-NLS-1$
    String touchStanDocMenuLabel();
    @DefaultStringValue("Create a blank Stan program in current directory") // $NON-NLS-1$
    String touchStanDocDesc();
    
    // touchHtmlDoc
    @DefaultStringValue("_HTML File") // $NON-NLS-1$
    String touchHtmlDocMenuLabel();
    @DefaultStringValue("Create a blank HTML file in current directory") // $NON-NLS-1$
    String touchHtmlDocDesc();
    
    // touchJavaScriptDoc
    @DefaultStringValue("_JavaScript File") // $NON-NLS-1$
    String touchJavaScriptDocMenuLabel();
    @DefaultStringValue("Create a blank JavaScript file in current directory") // $NON-NLS-1$
    String touchJavaScriptDocDesc();
    
    // touchCssDoc
    @DefaultStringValue("_CSS File") // $NON-NLS-1$
    String touchCssDocMenuLabel();
    @DefaultStringValue("Create a blank CSS file in current directory") // $NON-NLS-1$
    String touchCssDocDesc();
    
    // touchD3Doc
    @DefaultStringValue("_D3 Script") // $NON-NLS-1$
    String touchD3DocMenuLabel();
    @DefaultStringValue("Create a blank D3 script in current directory") // $NON-NLS-1$
    String touchD3DocDesc();
    
    // touchSweaveDoc
    @DefaultStringValue("R _Sweave") // $NON-NLS-1$
    String touchSweaveDocMenuLabel();
    @DefaultStringValue("Create a blank R Sweave document in current directory") // $NON-NLS-1$
    String touchSweaveDocDesc();
    
    // touchRMarkdownDoc
    @DefaultStringValue("R _Markdown...") // $NON-NLS-1$
    String touchRMarkdownDocMenuLabel();
    @DefaultStringValue("Create a blank R Markdown document in current directory") // $NON-NLS-1$
    String touchRMarkdownDocDesc();
    
    // touchQuartoDoc
    @DefaultStringValue("_Quarto Doc...") // $NON-NLS-1$
    String touchQuartoDocMenuLabel();
    @DefaultStringValue("Create a blank Quarto document in current directory") // $NON-NLS-1$
    String touchQuartoDocDesc();
    
    // touchRHTMLDoc
    @DefaultStringValue("R _HTML") // $NON-NLS-1$
    String touchRHTMLDocMenuLabel();
    @DefaultStringValue("Create a blank R HTML document in current directory") // $NON-NLS-1$
    String touchRHTMLDocDesc();
    
    // touchSqlDoc
    @DefaultStringValue("SQ_L Script") // $NON-NLS-1$
    String touchSqlDocMenuLabel();
    @DefaultStringValue("Create a new SQL script in current directory") // $NON-NLS-1$
    String touchSqlDocDesc();
    
    // uploadFile
    @DefaultStringValue("Upload Files...") // $NON-NLS-1$
    String uploadFileLabel();
    @DefaultStringValue("Upload") // $NON-NLS-1$
    String uploadFileButtonLabel();
    @DefaultStringValue("Upload Files...") // $NON-NLS-1$
    String uploadFileMenuLabel();
    @DefaultStringValue("Upload files to server") // $NON-NLS-1$
    String uploadFileDesc();
    
    // copyFile
    @DefaultStringValue("Copy Files...") // $NON-NLS-1$
    String copyFileLabel();
    @DefaultStringValue("Copy") // $NON-NLS-1$
    String copyFileButtonLabel();
    @DefaultStringValue("Copy...") // $NON-NLS-1$
    String copyFileMenuLabel();
    @DefaultStringValue("Copy selected file or folder") // $NON-NLS-1$
    String copyFileDesc();
    
    // copyFileTo
    @DefaultStringValue("Copy Files To...") // $NON-NLS-1$
    String copyFileToLabel();
    @DefaultStringValue("Copy To") // $NON-NLS-1$
    String copyFileToButtonLabel();
    @DefaultStringValue("Copy To...") // $NON-NLS-1$
    String copyFileToMenuLabel();
    @DefaultStringValue("Copy selected file or folder to another folder") // $NON-NLS-1$
    String copyFileToDesc();
    
    // moveFiles
    @DefaultStringValue("Move Files...") // $NON-NLS-1$
    String moveFilesLabel();
    @DefaultStringValue("Move") // $NON-NLS-1$
    String moveFilesButtonLabel();
    @DefaultStringValue("Move...") // $NON-NLS-1$
    String moveFilesMenuLabel();
    @DefaultStringValue("Move selected files or folders") // $NON-NLS-1$
    String moveFilesDesc();
    
    // exportFiles
    @DefaultStringValue("Export Files...") // $NON-NLS-1$
    String exportFilesLabel();
    @DefaultStringValue("Export") // $NON-NLS-1$
    String exportFilesButtonLabel();
    @DefaultStringValue("Export...") // $NON-NLS-1$
    String exportFilesMenuLabel();
    @DefaultStringValue("Export selected files or folders") // $NON-NLS-1$
    String exportFilesDesc();
    
    // renameFile
    @DefaultStringValue("Rename Current File...") // $NON-NLS-1$
    String renameFileLabel();
    @DefaultStringValue("Rename") // $NON-NLS-1$
    String renameFileButtonLabel();
    @DefaultStringValue("Rename selected file or folder") // $NON-NLS-1$
    String renameFileDesc();
    
    // deleteFiles
    @DefaultStringValue("Delete Files...") // $NON-NLS-1$
    String deleteFilesLabel();
    @DefaultStringValue("Delete") // $NON-NLS-1$
    String deleteFilesButtonLabel();
    @DefaultStringValue("Delete selected files or folders") // $NON-NLS-1$
    String deleteFilesDesc();
    
    // refreshFiles
    @DefaultStringValue("Refresh") // $NON-NLS-1$
    String refreshFilesMenuLabel();
    @DefaultStringValue("Refresh file listing") // $NON-NLS-1$
    String refreshFilesDesc();
    
    // goToWorkingDir
    @DefaultStringValue("") // $NON-NLS-1$
    String goToWorkingDirButtonLabel();
    @DefaultStringValue("Go To Working Directory") // $NON-NLS-1$
    String goToWorkingDirMenuLabel();
    @DefaultStringValue("View the current working directory") // $NON-NLS-1$
    String goToWorkingDirDesc();
    
    // setAsWorkingDir
    @DefaultStringValue("Set As Working Directory") // $NON-NLS-1$
    String setAsWorkingDirLabel();
    
    // copyFilesPaneCurrentDirectory
    @DefaultStringValue("Copy Folder Path to Clipboard") // $NON-NLS-1$
    String copyFilesPaneCurrentDirectoryLabel();
    
    // openFilesInSinglePane
    @DefaultStringValue("Open Selected in Source Pane") // $NON-NLS-1$
    String openFilesInSinglePaneLabel();
    
    // openEachFileInColumns
    @DefaultStringValue("Open Each File in New Columns") // $NON-NLS-1$
    String openEachFileInColumnsLabel();
    
    // showFolder
    @DefaultStringValue("Show Folder in New Window") // $NON-NLS-1$
    String showFolderLabel();
    
    // vcsAddFiles
    @DefaultStringValue("Add Files or Folders") // $NON-NLS-1$
    String vcsAddFilesLabel();
    @DefaultStringValue("Add") // $NON-NLS-1$
    String vcsAddFilesButtonLabel();
    @DefaultStringValue("Add") // $NON-NLS-1$
    String vcsAddFilesMenuLabel();
    @DefaultStringValue("Add the selected files or folders") // $NON-NLS-1$
    String vcsAddFilesDesc();
    
    // vcsRemoveFiles
    @DefaultStringValue("Remove Files or Folders") // $NON-NLS-1$
    String vcsRemoveFilesLabel();
    @DefaultStringValue("Delete") // $NON-NLS-1$
    String vcsRemoveFilesButtonLabel();
    @DefaultStringValue("Delete") // $NON-NLS-1$
    String vcsRemoveFilesMenuLabel();
    @DefaultStringValue("Delete the selected files or folders") // $NON-NLS-1$
    String vcsRemoveFilesDesc();
    
    // vcsDiff
    @DefaultStringValue("Diff Selected Files") // $NON-NLS-1$
    String vcsDiffLabel();
    @DefaultStringValue("Diff") // $NON-NLS-1$
    String vcsDiffButtonLabel();
    @DefaultStringValue("Diff") // $NON-NLS-1$
    String vcsDiffMenuLabel();
    @DefaultStringValue("Diff selected file(s)") // $NON-NLS-1$
    String vcsDiffDesc();
    
    // vcsCommit
    @DefaultStringValue("Commit Pending Changes") // $NON-NLS-1$
    String vcsCommitLabel();
    @DefaultStringValue("Commit") // $NON-NLS-1$
    String vcsCommitButtonLabel();
    @DefaultStringValue("_Commit...") // $NON-NLS-1$
    String vcsCommitMenuLabel();
    @DefaultStringValue("Commit pending changes") // $NON-NLS-1$
    String vcsCommitDesc();
    
    // vcsRevert
    @DefaultStringValue("Revert Changes") // $NON-NLS-1$
    String vcsRevertLabel();
    @DefaultStringValue("Revert") // $NON-NLS-1$
    String vcsRevertButtonLabel();
    @DefaultStringValue("Revert...") // $NON-NLS-1$
    String vcsRevertMenuLabel();
    @DefaultStringValue("Revert selected changes") // $NON-NLS-1$
    String vcsRevertDesc();
    
    // vcsShowHistory
    @DefaultStringValue("View History of Previous Commits") // $NON-NLS-1$
    String vcsShowHistoryLabel();
    @DefaultStringValue("History") // $NON-NLS-1$
    String vcsShowHistoryButtonLabel();
    @DefaultStringValue("_History") // $NON-NLS-1$
    String vcsShowHistoryMenuLabel();
    @DefaultStringValue("View history of previous commits") // $NON-NLS-1$
    String vcsShowHistoryDesc();
    
    // vcsRefresh
    @DefaultStringValue("Refresh File List from Source Control") // $NON-NLS-1$
    String vcsRefreshLabel();
    @DefaultStringValue("Refresh listing") // $NON-NLS-1$
    String vcsRefreshDesc();
    
    // vcsRefreshNoError
    
    // vcsOpen
    @DefaultStringValue("Open Selected Files(s)") // $NON-NLS-1$
    String vcsOpenLabel();
    @DefaultStringValue("Open File") // $NON-NLS-1$
    String vcsOpenMenuLabel();
    @DefaultStringValue("Open selected file(s)") // $NON-NLS-1$
    String vcsOpenDesc();
    
    // vcsIgnore
    @DefaultStringValue("Ignore Files or Folders") // $NON-NLS-1$
    String vcsIgnoreLabel();
    @DefaultStringValue("Ignore") // $NON-NLS-1$
    String vcsIgnoreButtonLabel();
    @DefaultStringValue("Ignore...") // $NON-NLS-1$
    String vcsIgnoreMenuLabel();
    @DefaultStringValue("Ignore the selected files or folders") // $NON-NLS-1$
    String vcsIgnoreDesc();
    
    // vcsPull
    @DefaultStringValue("Pull") // $NON-NLS-1$
    String vcsPullButtonLabel();
    @DefaultStringValue("_Pull Branches") // $NON-NLS-1$
    String vcsPullMenuLabel();
    
    // vcsPullRebase
    @DefaultStringValue("Pull with Rebase") // $NON-NLS-1$
    String vcsPullRebaseButtonLabel();
    @DefaultStringValue("_Pull with Rebase") // $NON-NLS-1$
    String vcsPullRebaseMenuLabel();
    
    // vcsPush
    @DefaultStringValue("Push") // $NON-NLS-1$
    String vcsPushButtonLabel();
    @DefaultStringValue("P_ush Branch") // $NON-NLS-1$
    String vcsPushMenuLabel();
    
    // vcsCleanup
    @DefaultStringValue("Cleanup") // $NON-NLS-1$
    String vcsCleanupButtonLabel();
    @DefaultStringValue("Cleanu_p") // $NON-NLS-1$
    String vcsCleanupMenuLabel();
    @DefaultStringValue("Recursively clean up the working copy (removing locks, etc)") // $NON-NLS-1$
    String vcsCleanupDesc();
    
    // vcsResolve
    @DefaultStringValue("Resolve") // $NON-NLS-1$
    String vcsResolveButtonLabel();
    @DefaultStringValue("Resolve...") // $NON-NLS-1$
    String vcsResolveMenuLabel();
    @DefaultStringValue("Resolve conflicts in the selected files or folders") // $NON-NLS-1$
    String vcsResolveDesc();
    
    // consoleClear
    @DefaultStringValue("Clear Console") // $NON-NLS-1$
    String consoleClearLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String consoleClearButtonLabel();
    @DefaultStringValue("Cle_ar Console") // $NON-NLS-1$
    String consoleClearMenuLabel();
    @DefaultStringValue("Clear console") // $NON-NLS-1$
    String consoleClearDesc();
    
    // clearBuild
    @DefaultStringValue("Clear Build Pane Output") // $NON-NLS-1$
    String clearBuildLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String clearBuildButtonLabel();
    @DefaultStringValue("Clear build") // $NON-NLS-1$
    String clearBuildDesc();
    
    // interruptR
    @DefaultStringValue("Interrupt R Session") // $NON-NLS-1$
    String interruptRLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String interruptRButtonLabel();
    @DefaultStringValue("_Interrupt R") // $NON-NLS-1$
    String interruptRMenuLabel();
    @DefaultStringValue("Interrupt R") // $NON-NLS-1$
    String interruptRDesc();
    
    // restartR
    @DefaultStringValue("Restart R Session") // $NON-NLS-1$
    String restartRLabel();
    @DefaultStringValue("_Restart R") // $NON-NLS-1$
    String restartRMenuLabel();
    @DefaultStringValue("Restart R") // $NON-NLS-1$
    String restartRDesc();
    
    // restartRClearOutput
    @DefaultStringValue("Restart R Session and Clear Chunk Output") // $NON-NLS-1$
    String restartRClearOutputLabel();
    @DefaultStringValue("Restart R and Clear _Output") // $NON-NLS-1$
    String restartRClearOutputMenuLabel();
    @DefaultStringValue("Restart R session and clear chunk output") // $NON-NLS-1$
    String restartRClearOutputDesc();
    
    // restartRRunAllChunks
    @DefaultStringValue("Restart R Session and Run All Chunks") // $NON-NLS-1$
    String restartRRunAllChunksLabel();
    @DefaultStringValue("Restart R and Run _All Chunks") // $NON-NLS-1$
    String restartRRunAllChunksMenuLabel();
    @DefaultStringValue("Restart R session and run all chunks") // $NON-NLS-1$
    String restartRRunAllChunksDesc();
    
    // terminateR
    @DefaultStringValue("Terminate R Session") // $NON-NLS-1$
    String terminateRLabel();
    @DefaultStringValue("_Terminate R...") // $NON-NLS-1$
    String terminateRMenuLabel();
    @DefaultStringValue("Forcibly terminate R session") // $NON-NLS-1$
    String terminateRDesc();
    
    // showPdfExternal
    @DefaultStringValue("Show PDF in External Viewer") // $NON-NLS-1$
    String showPdfExternalLabel();
    @DefaultStringValue("Show PDF in External Viewer") // $NON-NLS-1$
    String showPdfExternalMenuLabel();
    @DefaultStringValue("Show in an external PDF viewer window") // $NON-NLS-1$
    String showPdfExternalDesc();
    
    // openHtmlExternal
    @DefaultStringValue("Open Page with Web Browser") // $NON-NLS-1$
    String openHtmlExternalLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String openHtmlExternalButtonLabel();
    @DefaultStringValue("View the page with the system web browser") // $NON-NLS-1$
    String openHtmlExternalDesc();
    
    // saveHtmlPreviewAsLocalFile
    @DefaultStringValue("File on Local Computer...") // $NON-NLS-1$
    String saveHtmlPreviewAsLocalFileMenuLabel();
    @DefaultStringValue("Download the page to a local file") // $NON-NLS-1$
    String saveHtmlPreviewAsLocalFileDesc();
    
    // saveHtmlPreviewAs
    @DefaultStringValue("Save As") // $NON-NLS-1$
    String saveHtmlPreviewAsButtonLabel();
    @DefaultStringValue("File on RStudio Server...") // $NON-NLS-1$
    String saveHtmlPreviewAsMenuLabel();
    @DefaultStringValue("Save the page to another location") // $NON-NLS-1$
    String saveHtmlPreviewAsDesc();
    
    // showHtmlPreviewLog
    @DefaultStringValue("Log") // $NON-NLS-1$
    String showHtmlPreviewLogButtonLabel();
    @DefaultStringValue("Show the compilation log for this document") // $NON-NLS-1$
    String showHtmlPreviewLogDesc();
    
    // refreshHtmlPreview
    @DefaultStringValue("Refresh the preview") // $NON-NLS-1$
    String refreshHtmlPreviewDesc();
    
    // refreshPresentation
    @DefaultStringValue("Refresh the presentation") // $NON-NLS-1$
    String refreshPresentationDesc();
    
    // presentationFullscreen
    @DefaultStringValue("Show presentation in full screen mode") // $NON-NLS-1$
    String presentationFullscreenDesc();
    
    // presentationHome
    @DefaultStringValue("Go to the first slide") // $NON-NLS-1$
    String presentationHomeDesc();
    
    // presentationNext
    @DefaultStringValue("Go to the next slide") // $NON-NLS-1$
    String presentationNextDesc();
    
    // presentationPrev
    @DefaultStringValue("Go to the previous slide") // $NON-NLS-1$
    String presentationPrevDesc();
    
    // presentationEdit
    @DefaultStringValue("Edit this slide of the presentation") // $NON-NLS-1$
    String presentationEditDesc();
    
    // presentationViewInBrowser
    @DefaultStringValue("_View in Browser") // $NON-NLS-1$
    String presentationViewInBrowserMenuLabel();
    @DefaultStringValue("View the presentation in an external web browser") // $NON-NLS-1$
    String presentationViewInBrowserDesc();
    
    // presentationSaveAsStandalone
    @DefaultStringValue("_Save As Web Page...") // $NON-NLS-1$
    String presentationSaveAsStandaloneMenuLabel();
    @DefaultStringValue("Save the presentation as a standalone web page") // $NON-NLS-1$
    String presentationSaveAsStandaloneDesc();
    
    // clearPresentationCache
    @DefaultStringValue("Clear Knitr Cache...") // $NON-NLS-1$
    String clearPresentationCacheMenuLabel();
    @DefaultStringValue("Clear knitr cache for this presentation") // $NON-NLS-1$
    String clearPresentationCacheDesc();
    
    // refreshPresentation2
    @DefaultStringValue("Refresh Presentation") // $NON-NLS-1$
    String refreshPresentation2MenuLabel();
    @DefaultStringValue("Refresh the presentation preview") // $NON-NLS-1$
    String refreshPresentation2Desc();
    
    // presentation2Home
    @DefaultStringValue("Go to the first slide") // $NON-NLS-1$
    String presentation2HomeDesc();
    
    // presentation2Next
    @DefaultStringValue("Go to the next slide") // $NON-NLS-1$
    String presentation2NextDesc();
    
    // presentation2Prev
    @DefaultStringValue("Go to the previous slide") // $NON-NLS-1$
    String presentation2PrevDesc();
    
    // presentation2Edit
    @DefaultStringValue("Edit") // $NON-NLS-1$
    String presentation2EditButtonLabel();
    @DefaultStringValue("Edit Presentation Source") // $NON-NLS-1$
    String presentation2EditMenuLabel();
    @DefaultStringValue("Edit this slide of the presentation") // $NON-NLS-1$
    String presentation2EditDesc();
    
    // presentation2Present
    @DefaultStringValue("Present") // $NON-NLS-1$
    String presentation2PresentButtonLabel();
    @DefaultStringValue("Present in an external web browser") // $NON-NLS-1$
    String presentation2PresentDesc();
    
    // presentation2PresentFromBeginning
    @DefaultStringValue("Present from Beginning") // $NON-NLS-1$
    String presentation2PresentFromBeginningMenuLabel();
    @DefaultStringValue("Present from the first slide in an external web browser") // $NON-NLS-1$
    String presentation2PresentFromBeginningDesc();
    
    // presentation2Print
    @DefaultStringValue("Print") // $NON-NLS-1$
    String presentation2PrintButtonLabel();
    @DefaultStringValue("Open a browser to print the presentation") // $NON-NLS-1$
    String presentation2PrintDesc();
    
    // historySendToSource
    @DefaultStringValue("Insert Command into Document") // $NON-NLS-1$
    String historySendToSourceLabel();
    @DefaultStringValue("To Source") // $NON-NLS-1$
    String historySendToSourceButtonLabel();
    @DefaultStringValue("Insert into _Source") // $NON-NLS-1$
    String historySendToSourceMenuLabel();
    @DefaultStringValue("Insert the selected commands into the current document (Shift+Enter)") // $NON-NLS-1$
    String historySendToSourceDesc();
    
    // historySendToConsole
    @DefaultStringValue("Send Command to Console") // $NON-NLS-1$
    String historySendToConsoleLabel();
    @DefaultStringValue("To Console") // $NON-NLS-1$
    String historySendToConsoleButtonLabel();
    @DefaultStringValue("Send to _Console") // $NON-NLS-1$
    String historySendToConsoleMenuLabel();
    @DefaultStringValue("Send the selected commands to the R console (Enter)") // $NON-NLS-1$
    String historySendToConsoleDesc();
    
    // loadHistory
    @DefaultStringValue("") // $NON-NLS-1$
    String loadHistoryButtonLabel();
    @DefaultStringValue("_Load History...") // $NON-NLS-1$
    String loadHistoryMenuLabel();
    @DefaultStringValue("Load history from an existing file") // $NON-NLS-1$
    String loadHistoryDesc();
    
    // saveHistory
    @DefaultStringValue("") // $NON-NLS-1$
    String saveHistoryButtonLabel();
    @DefaultStringValue("Sa_ve History As...") // $NON-NLS-1$
    String saveHistoryMenuLabel();
    @DefaultStringValue("Save history into a file") // $NON-NLS-1$
    String saveHistoryDesc();
    
    // historyRemoveEntries
    @DefaultStringValue("") // $NON-NLS-1$
    String historyRemoveEntriesButtonLabel();
    @DefaultStringValue("_Remove Entries...") // $NON-NLS-1$
    String historyRemoveEntriesMenuLabel();
    @DefaultStringValue("Remove the selected history entries") // $NON-NLS-1$
    String historyRemoveEntriesDesc();
    
    // clearHistory
    @DefaultStringValue("") // $NON-NLS-1$
    String clearHistoryButtonLabel();
    @DefaultStringValue("Clear _All...") // $NON-NLS-1$
    String clearHistoryMenuLabel();
    @DefaultStringValue("Clear all history entries") // $NON-NLS-1$
    String clearHistoryDesc();
    
    // historyDismissResults
    @DefaultStringValue("Dismiss History Results") // $NON-NLS-1$
    String historyDismissResultsLabel();
    @DefaultStringValue("Done") // $NON-NLS-1$
    String historyDismissResultsButtonLabel();
    
    // historyShowContext
    @DefaultStringValue("Show In Context") // $NON-NLS-1$
    String historyShowContextLabel();
    
    // historyDismissContext
    @DefaultStringValue("Dismiss History Context") // $NON-NLS-1$
    String historyDismissContextLabel();
    @DefaultStringValue("Back") // $NON-NLS-1$
    String historyDismissContextButtonLabel();
    
    // nextPlot
    @DefaultStringValue("Show Next Plot") // $NON-NLS-1$
    String nextPlotLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String nextPlotButtonLabel();
    @DefaultStringValue("_Next Plot") // $NON-NLS-1$
    String nextPlotMenuLabel();
    @DefaultStringValue("Next plot") // $NON-NLS-1$
    String nextPlotDesc();
    
    // previousPlot
    @DefaultStringValue("Show Previous Plot") // $NON-NLS-1$
    String previousPlotLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String previousPlotButtonLabel();
    @DefaultStringValue("_Previous Plot") // $NON-NLS-1$
    String previousPlotMenuLabel();
    @DefaultStringValue("Previous plot") // $NON-NLS-1$
    String previousPlotDesc();
    
    // savePlotAsImage
    @DefaultStringValue("Save Plot As Image...") // $NON-NLS-1$
    String savePlotAsImageLabel();
    @DefaultStringValue("Save as _Image...") // $NON-NLS-1$
    String savePlotAsImageMenuLabel();
    @DefaultStringValue("Save the current plot as an image file") // $NON-NLS-1$
    String savePlotAsImageDesc();
    
    // savePlotAsPdf
    @DefaultStringValue("Save Plot as PDF...") // $NON-NLS-1$
    String savePlotAsPdfLabel();
    @DefaultStringValue("Save as P_DF...") // $NON-NLS-1$
    String savePlotAsPdfMenuLabel();
    @DefaultStringValue("Save the current plot as a PDF file") // $NON-NLS-1$
    String savePlotAsPdfDesc();
    
    // copyPlotToClipboard
    @DefaultStringValue("Copy Current Plot to Clipboard...") // $NON-NLS-1$
    String copyPlotToClipboardLabel();
    @DefaultStringValue("Cop_y to Clipboard...") // $NON-NLS-1$
    String copyPlotToClipboardMenuLabel();
    @DefaultStringValue("Copy the current plot to the clipboard") // $NON-NLS-1$
    String copyPlotToClipboardDesc();
    
    // zoomPlot
    @DefaultStringValue("Zoom") // $NON-NLS-1$
    String zoomPlotButtonLabel();
    @DefaultStringValue("_Zoom Plot...") // $NON-NLS-1$
    String zoomPlotMenuLabel();
    @DefaultStringValue("View a larger version of the plot in a new window") // $NON-NLS-1$
    String zoomPlotDesc();
    
    // removePlot
    @DefaultStringValue("Remove Current Plot...") // $NON-NLS-1$
    String removePlotLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String removePlotButtonLabel();
    @DefaultStringValue("_Remove Plot...") // $NON-NLS-1$
    String removePlotMenuLabel();
    @DefaultStringValue("Remove the current plot") // $NON-NLS-1$
    String removePlotDesc();
    
    // clearPlots
    @DefaultStringValue("Clear All Plots...") // $NON-NLS-1$
    String clearPlotsLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String clearPlotsButtonLabel();
    @DefaultStringValue("_Clear All...") // $NON-NLS-1$
    String clearPlotsMenuLabel();
    @DefaultStringValue("Clear all Plots") // $NON-NLS-1$
    String clearPlotsDesc();
    
    // refreshPlot
    @DefaultStringValue("Refresh Current Plot") // $NON-NLS-1$
    String refreshPlotLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String refreshPlotButtonLabel();
    @DefaultStringValue("Refresh") // $NON-NLS-1$
    String refreshPlotMenuLabel();
    @DefaultStringValue("Refresh current plot") // $NON-NLS-1$
    String refreshPlotDesc();
    
    // showManipulator
    @DefaultStringValue("Show Manipulator for Current Plot") // $NON-NLS-1$
    String showManipulatorLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String showManipulatorButtonLabel();
    @DefaultStringValue("Show _Manipulator") // $NON-NLS-1$
    String showManipulatorMenuLabel();
    @DefaultStringValue("Show the manipulator for this plot") // $NON-NLS-1$
    String showManipulatorDesc();
    
    // clearWorkspace
    @DefaultStringValue("_Clear Workspace...") // $NON-NLS-1$
    String clearWorkspaceMenuLabel();
    @DefaultStringValue("Clear objects from the workspace") // $NON-NLS-1$
    String clearWorkspaceDesc();
    
    // loadWorkspace
    @DefaultStringValue("_Load Workspace...") // $NON-NLS-1$
    String loadWorkspaceMenuLabel();
    @DefaultStringValue("Load workspace") // $NON-NLS-1$
    String loadWorkspaceDesc();
    
    // saveWorkspace
    @DefaultStringValue("_Save Workspace As...") // $NON-NLS-1$
    String saveWorkspaceMenuLabel();
    @DefaultStringValue("Save workspace as") // $NON-NLS-1$
    String saveWorkspaceDesc();
    
    // importDatasetFromFile
    @DefaultStringValue("Import Dataset from File...") // $NON-NLS-1$
    String importDatasetFromFileLabel();
    @DefaultStringValue("From _Local File...") // $NON-NLS-1$
    String importDatasetFromFileMenuLabel();
    
    // importDatasetFromURL
    @DefaultStringValue("Import Dataset from URL...") // $NON-NLS-1$
    String importDatasetFromURLLabel();
    @DefaultStringValue("From _Web URL...") // $NON-NLS-1$
    String importDatasetFromURLMenuLabel();
    
    // importDatasetFromCsv
    @DefaultStringValue("From CSV") // $NON-NLS-1$
    String importDatasetFromCsvLabel();
    @DefaultStringValue("From _CSV") // $NON-NLS-1$
    String importDatasetFromCsvMenuLabel();
    
    // importDatasetFromCsvUsingReadr
    @DefaultStringValue("From Text (readr)...") // $NON-NLS-1$
    String importDatasetFromCsvUsingReadrLabel();
    @DefaultStringValue("From Text (_readr)...") // $NON-NLS-1$
    String importDatasetFromCsvUsingReadrMenuLabel();
    
    // importDatasetFromCsvUsingBase
    @DefaultStringValue("From Text (base)...") // $NON-NLS-1$
    String importDatasetFromCsvUsingBaseLabel();
    @DefaultStringValue("From Text (_base)...") // $NON-NLS-1$
    String importDatasetFromCsvUsingBaseMenuLabel();
    
    // importDatasetFromSAV
    @DefaultStringValue("Import Dataset from SPSS...") // $NON-NLS-1$
    String importDatasetFromSAVLabel();
    @DefaultStringValue("From _SPSS...") // $NON-NLS-1$
    String importDatasetFromSAVMenuLabel();
    
    // importDatasetFromSAS
    @DefaultStringValue("Import Dataset from SAS...") // $NON-NLS-1$
    String importDatasetFromSASLabel();
    @DefaultStringValue("From S_AS...") // $NON-NLS-1$
    String importDatasetFromSASMenuLabel();
    
    // importDatasetFromStata
    @DefaultStringValue("Import Dataset from Stata...") // $NON-NLS-1$
    String importDatasetFromStataLabel();
    @DefaultStringValue("From S_tata...") // $NON-NLS-1$
    String importDatasetFromStataMenuLabel();
    
    // importDatasetFromXLS
    @DefaultStringValue("Import Dataset from Excel...") // $NON-NLS-1$
    String importDatasetFromXLSLabel();
    @DefaultStringValue("From _Excel...") // $NON-NLS-1$
    String importDatasetFromXLSMenuLabel();
    
    // refreshWorkspace
    @DefaultStringValue("") // $NON-NLS-1$
    String refreshWorkspaceButtonLabel();
    @DefaultStringValue("Refresh") // $NON-NLS-1$
    String refreshWorkspaceMenuLabel();
    @DefaultStringValue("Refresh Workspace") // $NON-NLS-1$
    String refreshWorkspaceDesc();
    
    // installPackage
    @DefaultStringValue("Install Packages...") // $NON-NLS-1$
    String installPackageLabel();
    @DefaultStringValue("Install") // $NON-NLS-1$
    String installPackageButtonLabel();
    @DefaultStringValue("Install Pac_kages...") // $NON-NLS-1$
    String installPackageMenuLabel();
    @DefaultStringValue("Install R packages") // $NON-NLS-1$
    String installPackageDesc();
    
    // updatePackages
    @DefaultStringValue("Update Packages...") // $NON-NLS-1$
    String updatePackagesLabel();
    @DefaultStringValue("Update") // $NON-NLS-1$
    String updatePackagesButtonLabel();
    @DefaultStringValue("Check for Package _Updates...") // $NON-NLS-1$
    String updatePackagesMenuLabel();
    @DefaultStringValue("Check for package updates") // $NON-NLS-1$
    String updatePackagesDesc();
    
    // refreshPackages
    @DefaultStringValue("Refresh Packages Pane") // $NON-NLS-1$
    String refreshPackagesLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String refreshPackagesButtonLabel();
    @DefaultStringValue("Refresh Package listing") // $NON-NLS-1$
    String refreshPackagesDesc();
    
    // packratBootstrap
    @DefaultStringValue("Packrat") // $NON-NLS-1$
    String packratBootstrapButtonLabel();
    @DefaultStringValue("_Initialize Packrat...") // $NON-NLS-1$
    String packratBootstrapMenuLabel();
    @DefaultStringValue("Use packrat with this project") // $NON-NLS-1$
    String packratBootstrapDesc();
    
    // packratClean
    @DefaultStringValue("_Clean Unused Packages...") // $NON-NLS-1$
    String packratCleanMenuLabel();
    @DefaultStringValue("Remove unused packages from your packrat library") // $NON-NLS-1$
    String packratCleanDesc();
    
    // packratHelp
    @DefaultStringValue("Using Packrat") // $NON-NLS-1$
    String packratHelpMenuLabel();
    @DefaultStringValue("Help on using packrat with R projects") // $NON-NLS-1$
    String packratHelpDesc();
    
    // packratOptions
    @DefaultStringValue("Options") // $NON-NLS-1$
    String packratOptionsButtonLabel();
    @DefaultStringValue("Packrat _Options...") // $NON-NLS-1$
    String packratOptionsMenuLabel();
    @DefaultStringValue("Configure packrat options for this project") // $NON-NLS-1$
    String packratOptionsDesc();
    
    // packratBundle
    @DefaultStringValue("Bundle") // $NON-NLS-1$
    String packratBundleButtonLabel();
    @DefaultStringValue("Export Project _Bundle...") // $NON-NLS-1$
    String packratBundleMenuLabel();
    @DefaultStringValue("Bundle a Packrat Project") // $NON-NLS-1$
    String packratBundleDesc();
    
    // packratCheckStatus
    @DefaultStringValue("Check Library _Status...") // $NON-NLS-1$
    String packratCheckStatusMenuLabel();
    @DefaultStringValue("Check the status of the Packrat library") // $NON-NLS-1$
    String packratCheckStatusDesc();
    
    // renvHelp
    @DefaultStringValue("Introduction to renv") // $NON-NLS-1$
    String renvHelpMenuLabel();
    @DefaultStringValue("Learn how to use renv") // $NON-NLS-1$
    String renvHelpDesc();
    
    // renvSnapshot
    @DefaultStringValue("Snapshot Library...") // $NON-NLS-1$
    String renvSnapshotMenuLabel();
    @DefaultStringValue("Snapshot the state of your project library") // $NON-NLS-1$
    String renvSnapshotDesc();
    
    // renvRestore
    @DefaultStringValue("Restore Library...") // $NON-NLS-1$
    String renvRestoreMenuLabel();
    @DefaultStringValue("Restore your project library from renv.lock") // $NON-NLS-1$
    String renvRestoreDesc();
    
    // versionControlOptions
    @DefaultStringValue("_Options...") // $NON-NLS-1$
    String versionControlOptionsMenuLabel();
    @DefaultStringValue("Configure version control options") // $NON-NLS-1$
    String versionControlOptionsDesc();
    
    // versionControlHelp
    @DefaultStringValue("_Using Version Control") // $NON-NLS-1$
    String versionControlHelpMenuLabel();
    @DefaultStringValue("Help on using version control with RStudio") // $NON-NLS-1$
    String versionControlHelpDesc();
    
    // versionControlShowRsaKey
    @DefaultStringValue("Show Public Key...") // $NON-NLS-1$
    String versionControlShowRsaKeyLabel();
    @DefaultStringValue("Show Public Key...") // $NON-NLS-1$
    String versionControlShowRsaKeyMenuLabel();
    @DefaultStringValue("Show RSA public key") // $NON-NLS-1$
    String versionControlShowRsaKeyDesc();
    
    // versionControlProjectSetup
    @DefaultStringValue("Project _Setup...") // $NON-NLS-1$
    String versionControlProjectSetupMenuLabel();
    @DefaultStringValue("Setup version control for the current project") // $NON-NLS-1$
    String versionControlProjectSetupDesc();
    
    // showShellDialog
    @DefaultStringValue("Open Shell") // $NON-NLS-1$
    String showShellDialogLabel();
    @DefaultStringValue("_Shell...") // $NON-NLS-1$
    String showShellDialogMenuLabel();
    @DefaultStringValue("Execute shell commands") // $NON-NLS-1$
    String showShellDialogDesc();
    
    // newTerminal
    @DefaultStringValue("New Terminal") // $NON-NLS-1$
    String newTerminalLabel();
    @DefaultStringValue("_New Terminal") // $NON-NLS-1$
    String newTerminalMenuLabel();
    @DefaultStringValue("Create a new terminal") // $NON-NLS-1$
    String newTerminalDesc();
    
    // activateTerminal
    @DefaultStringValue("Move Focus to Terminal") // $NON-NLS-1$
    String activateTerminalLabel();
    @DefaultStringValue("_Move Focus to Terminal") // $NON-NLS-1$
    String activateTerminalMenuLabel();
    
    // renameTerminal
    @DefaultStringValue("Rename Terminal") // $NON-NLS-1$
    String renameTerminalLabel();
    @DefaultStringValue("_Rename Terminal") // $NON-NLS-1$
    String renameTerminalMenuLabel();
    @DefaultStringValue("Change terminal session name") // $NON-NLS-1$
    String renameTerminalDesc();
    
    // closeTerminal
    @DefaultStringValue("Close Terminal") // $NON-NLS-1$
    String closeTerminalLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String closeTerminalButtonLabel();
    @DefaultStringValue("Cl_ose Terminal") // $NON-NLS-1$
    String closeTerminalMenuLabel();
    @DefaultStringValue("Close current terminal session") // $NON-NLS-1$
    String closeTerminalDesc();
    
    // closeAllTerminals
    @DefaultStringValue("Close All Terminals") // $NON-NLS-1$
    String closeAllTerminalsLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String closeAllTerminalsButtonLabel();
    @DefaultStringValue("Close _All Terminals") // $NON-NLS-1$
    String closeAllTerminalsMenuLabel();
    
    // clearTerminalScrollbackBuffer
    @DefaultStringValue("Clear Terminal Buffer") // $NON-NLS-1$
    String clearTerminalScrollbackBufferLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String clearTerminalScrollbackBufferButtonLabel();
    @DefaultStringValue("_Clear Terminal Buffer") // $NON-NLS-1$
    String clearTerminalScrollbackBufferMenuLabel();
    @DefaultStringValue("Clear terminal") // $NON-NLS-1$
    String clearTerminalScrollbackBufferDesc();
    
    // previousTerminal
    @DefaultStringValue("Previous Terminal") // $NON-NLS-1$
    String previousTerminalLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String previousTerminalButtonLabel();
    @DefaultStringValue("_Previous Terminal") // $NON-NLS-1$
    String previousTerminalMenuLabel();
    @DefaultStringValue("Show previous terminal") // $NON-NLS-1$
    String previousTerminalDesc();
    
    // nextTerminal
    @DefaultStringValue("Next Terminal") // $NON-NLS-1$
    String nextTerminalLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String nextTerminalButtonLabel();
    @DefaultStringValue("Ne_xt Terminal") // $NON-NLS-1$
    String nextTerminalMenuLabel();
    @DefaultStringValue("Show next terminal") // $NON-NLS-1$
    String nextTerminalDesc();
    
    // showTerminalInfo
    @DefaultStringValue("Terminal Diagnostics...") // $NON-NLS-1$
    String showTerminalInfoLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String showTerminalInfoButtonLabel();
    @DefaultStringValue("Terminal _Diagnostics...") // $NON-NLS-1$
    String showTerminalInfoMenuLabel();
    @DefaultStringValue("Show info on current terminal") // $NON-NLS-1$
    String showTerminalInfoDesc();
    
    // interruptTerminal
    @DefaultStringValue("Send Interrupt") // $NON-NLS-1$
    String interruptTerminalLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String interruptTerminalButtonLabel();
    @DefaultStringValue("_Interrupt Current Terminal") // $NON-NLS-1$
    String interruptTerminalMenuLabel();
    @DefaultStringValue("Send Ctrl+C to Current Terminal") // $NON-NLS-1$
    String interruptTerminalDesc();
    
    // sendTerminalToEditor
    @DefaultStringValue("Copy Terminal to Editor") // $NON-NLS-1$
    String sendTerminalToEditorLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String sendTerminalToEditorButtonLabel();
    @DefaultStringValue("Copy Terminal to _Editor") // $NON-NLS-1$
    String sendTerminalToEditorMenuLabel();
    @DefaultStringValue("Copy current terminal's buffer to a new editor buffer") // $NON-NLS-1$
    String sendTerminalToEditorDesc();
    
    // sendToTerminal
    @DefaultStringValue("Send Selection to Terminal") // $NON-NLS-1$
    String sendToTerminalLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String sendToTerminalButtonLabel();
    @DefaultStringValue("Send to _Terminal") // $NON-NLS-1$
    String sendToTerminalMenuLabel();
    @DefaultStringValue("Send the current line or selection to terminal") // $NON-NLS-1$
    String sendToTerminalDesc();
    
    // sendFilenameToTerminal
    @DefaultStringValue("Send _Filename to Terminal") // $NON-NLS-1$
    String sendFilenameToTerminalMenuLabel();
    
    // openNewTerminalAtEditorLocation
    @DefaultStringValue("_Open New Terminal at File Location") // $NON-NLS-1$
    String openNewTerminalAtEditorLocationMenuLabel();
    
    // openNewTerminalAtFilePaneLocation
    @DefaultStringValue("Open New Terminal Here") // $NON-NLS-1$
    String openNewTerminalAtFilePaneLocationMenuLabel();
    
    // setTerminalToCurrentDirectory
    @DefaultStringValue("_Go to Current Directory") // $NON-NLS-1$
    String setTerminalToCurrentDirectoryMenuLabel();
    
    // browseAddins
    @DefaultStringValue("Browse Addins") // $NON-NLS-1$
    String browseAddinsLabel();
    @DefaultStringValue("_Browse Addins...") // $NON-NLS-1$
    String browseAddinsMenuLabel();
    @DefaultStringValue("Browse addins") // $NON-NLS-1$
    String browseAddinsDesc();
    
    // macPreferences
    @DefaultStringValue("_Preferences...") // $NON-NLS-1$
    String macPreferencesMenuLabel();
    
    // showOptions
    @DefaultStringValue("_Global Options...") // $NON-NLS-1$
    String showOptionsMenuLabel();
    
    // showCodeOptions
    @DefaultStringValue("Code Options...") // $NON-NLS-1$
    String showCodeOptionsLabel();
    
    // showConsoleOptions
    @DefaultStringValue("Console Options...") // $NON-NLS-1$
    String showConsoleOptionsLabel();
    
    // showAppearanceOptions
    @DefaultStringValue("Appearance Options...") // $NON-NLS-1$
    String showAppearanceOptionsLabel();
    
    // paneLayout
    @DefaultStringValue("Pane Layout Options...") // $NON-NLS-1$
    String paneLayoutLabel();
    @DefaultStringValue("Pane Layo_ut...") // $NON-NLS-1$
    String paneLayoutMenuLabel();
    
    // showPackagesOptions
    @DefaultStringValue("Packages Options...") // $NON-NLS-1$
    String showPackagesOptionsLabel();
    
    // showRMarkdownOptions
    @DefaultStringValue("R Markdown Options...") // $NON-NLS-1$
    String showRMarkdownOptionsLabel();
    
    // showSweaveOptions
    @DefaultStringValue("Sweave Options...") // $NON-NLS-1$
    String showSweaveOptionsLabel();
    
    // showSpellingOptions
    @DefaultStringValue("Spelling Options...") // $NON-NLS-1$
    String showSpellingOptionsLabel();
    
    // showVcsOptions
    @DefaultStringValue("Git/SVN Version Control Options...") // $NON-NLS-1$
    String showVcsOptionsLabel();
    
    // showPublishingOptions
    @DefaultStringValue("Publishing Options...") // $NON-NLS-1$
    String showPublishingOptionsLabel();
    
    // showTerminalOptions
    @DefaultStringValue("_Terminal Options...") // $NON-NLS-1$
    String showTerminalOptionsMenuLabel();
    
    // showAccessibilityOptions
    @DefaultStringValue("Accessibility _Options...") // $NON-NLS-1$
    String showAccessibilityOptionsMenuLabel();
    
    // showPythonOptions
    @DefaultStringValue("Python Options...") // $NON-NLS-1$
    String showPythonOptionsLabel();
    
    // modifyKeyboardShortcuts
    @DefaultStringValue("_Modify Keyboard Shortcuts...") // $NON-NLS-1$
    String modifyKeyboardShortcutsMenuLabel();
    @DefaultStringValue("Modify keyboard shortcuts") // $NON-NLS-1$
    String modifyKeyboardShortcutsDesc();
    
    // editCodeSnippets
    @DefaultStringValue("_Edit Code Snippets...") // $NON-NLS-1$
    String editCodeSnippetsMenuLabel();
    @DefaultStringValue("Edit code snippets") // $NON-NLS-1$
    String editCodeSnippetsDesc();
    
    // checkForUpdates
    @DefaultStringValue("Check for RStudio Updates") // $NON-NLS-1$
    String checkForUpdatesLabel();
    @DefaultStringValue("Check for _Updates") // $NON-NLS-1$
    String checkForUpdatesMenuLabel();
    
    // helpUsingRStudio
    @DefaultStringValue("RStudio _Docs") // $NON-NLS-1$
    String helpUsingRStudioMenuLabel();
    
    // helpKeyboardShortcuts
    @DefaultStringValue("_Keyboard Shortcuts Help") // $NON-NLS-1$
    String helpKeyboardShortcutsMenuLabel();
    
    // helpBack
    @DefaultStringValue("Previous Help Topic") // $NON-NLS-1$
    String helpBackLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String helpBackButtonLabel();
    @DefaultStringValue("Previous topic") // $NON-NLS-1$
    String helpBackDesc();
    
    // helpForward
    @DefaultStringValue("Next Help Topic") // $NON-NLS-1$
    String helpForwardLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String helpForwardButtonLabel();
    @DefaultStringValue("Next topic") // $NON-NLS-1$
    String helpForwardDesc();
    
    // helpHome
    @DefaultStringValue("Show R Help") // $NON-NLS-1$
    String helpHomeLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String helpHomeButtonLabel();
    @DefaultStringValue("R _Help") // $NON-NLS-1$
    String helpHomeMenuLabel();
    @DefaultStringValue("Show R Help") // $NON-NLS-1$
    String helpHomeDesc();
    
    // helpSearch
    @DefaultStringValue("Search R Hel_p") // $NON-NLS-1$
    String helpSearchMenuLabel();
    
    // printHelp
    @DefaultStringValue("Print Help Topic") // $NON-NLS-1$
    String printHelpLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String printHelpButtonLabel();
    @DefaultStringValue("Print topic") // $NON-NLS-1$
    String printHelpDesc();
    
    // clearHelpHistory
    @DefaultStringValue("Clear Help History") // $NON-NLS-1$
    String clearHelpHistoryLabel();
    @DefaultStringValue("Clear history") // $NON-NLS-1$
    String clearHelpHistoryMenuLabel();
    @DefaultStringValue("Clear history") // $NON-NLS-1$
    String clearHelpHistoryDesc();
    
    // helpPopout
    @DefaultStringValue("Show Help in New Window") // $NON-NLS-1$
    String helpPopoutLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String helpPopoutButtonLabel();
    @DefaultStringValue("Show in new window") // $NON-NLS-1$
    String helpPopoutDesc();
    
    // refreshHelp
    @DefaultStringValue("Refresh Help Topic") // $NON-NLS-1$
    String refreshHelpLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String refreshHelpButtonLabel();
    @DefaultStringValue("Refresh") // $NON-NLS-1$
    String refreshHelpMenuLabel();
    @DefaultStringValue("Refresh topic") // $NON-NLS-1$
    String refreshHelpDesc();
    
    // tutorialPopout
    @DefaultStringValue("") // $NON-NLS-1$
    String tutorialPopoutButtonLabel();
    @DefaultStringValue("Show in new window") // $NON-NLS-1$
    String tutorialPopoutDesc();
    
    // tutorialBack
    @DefaultStringValue("") // $NON-NLS-1$
    String tutorialBackButtonLabel();
    @DefaultStringValue("Go back") // $NON-NLS-1$
    String tutorialBackDesc();
    
    // tutorialForward
    @DefaultStringValue("") // $NON-NLS-1$
    String tutorialForwardButtonLabel();
    @DefaultStringValue("Go forward") // $NON-NLS-1$
    String tutorialForwardDesc();
    
    // tutorialZoom
    @DefaultStringValue("Zoom") // $NON-NLS-1$
    String tutorialZoomButtonLabel();
    @DefaultStringValue("View a larger version in a new window") // $NON-NLS-1$
    String tutorialZoomDesc();
    
    // tutorialRefresh
    @DefaultStringValue("Refresh tutorial") // $NON-NLS-1$
    String tutorialRefreshDesc();
    
    // tutorialStop
    @DefaultStringValue("") // $NON-NLS-1$
    String tutorialStopButtonLabel();
    @DefaultStringValue("Stop tutorial") // $NON-NLS-1$
    String tutorialStopDesc();
    
    // tutorialHome
    @DefaultStringValue("") // $NON-NLS-1$
    String tutorialHomeButtonLabel();
    @DefaultStringValue("Return to home") // $NON-NLS-1$
    String tutorialHomeDesc();
    
    // viewerPopout
    @DefaultStringValue("") // $NON-NLS-1$
    String viewerPopoutButtonLabel();
    @DefaultStringValue("Show in new window") // $NON-NLS-1$
    String viewerPopoutDesc();
    
    // viewerBack
    @DefaultStringValue("") // $NON-NLS-1$
    String viewerBackButtonLabel();
    @DefaultStringValue("Go back") // $NON-NLS-1$
    String viewerBackDesc();
    
    // viewerForward
    @DefaultStringValue("") // $NON-NLS-1$
    String viewerForwardButtonLabel();
    @DefaultStringValue("Go forward") // $NON-NLS-1$
    String viewerForwardDesc();
    
    // viewerZoom
    @DefaultStringValue("Zoom") // $NON-NLS-1$
    String viewerZoomButtonLabel();
    @DefaultStringValue("View a larger version in a new window") // $NON-NLS-1$
    String viewerZoomDesc();
    
    // viewerRefresh
    @DefaultStringValue("Refresh viewer") // $NON-NLS-1$
    String viewerRefreshDesc();
    
    // viewerEditSource
    @DefaultStringValue("Edit") // $NON-NLS-1$
    String viewerEditSourceButtonLabel();
    @DefaultStringValue("Edit source file") // $NON-NLS-1$
    String viewerEditSourceDesc();
    
    // viewerSaveAllAndRefresh
    @DefaultStringValue("Save source files and refresh viewer") // $NON-NLS-1$
    String viewerSaveAllAndRefreshDesc();
    
    // viewerStop
    @DefaultStringValue("") // $NON-NLS-1$
    String viewerStopButtonLabel();
    @DefaultStringValue("Stop application") // $NON-NLS-1$
    String viewerStopDesc();
    
    // viewerClear
    @DefaultStringValue("") // $NON-NLS-1$
    String viewerClearButtonLabel();
    @DefaultStringValue("Remove current viewer item") // $NON-NLS-1$
    String viewerClearDesc();
    
    // viewerClearAll
    @DefaultStringValue("") // $NON-NLS-1$
    String viewerClearAllButtonLabel();
    @DefaultStringValue("Clear all viewer items") // $NON-NLS-1$
    String viewerClearAllDesc();
    
    // viewerSaveAsImage
    @DefaultStringValue("Save as Image...") // $NON-NLS-1$
    String viewerSaveAsImageMenuLabel();
    @DefaultStringValue("Save as an image file") // $NON-NLS-1$
    String viewerSaveAsImageDesc();
    
    // viewerSaveAsWebPage
    @DefaultStringValue("Save as Web Page...") // $NON-NLS-1$
    String viewerSaveAsWebPageMenuLabel();
    @DefaultStringValue("Save as a standalone web page") // $NON-NLS-1$
    String viewerSaveAsWebPageDesc();
    
    // viewerCopyToClipboard
    @DefaultStringValue("Copy to Clipboard...") // $NON-NLS-1$
    String viewerCopyToClipboardMenuLabel();
    @DefaultStringValue("Copy to the system clipboard") // $NON-NLS-1$
    String viewerCopyToClipboardDesc();
    
    // raiseException
    @DefaultStringValue("Raise E_xception") // $NON-NLS-1$
    String raiseExceptionMenuLabel();
    
    // raiseException2
    @DefaultStringValue("Raise Exception _JS") // $NON-NLS-1$
    String raiseException2MenuLabel();
    
    // showWarningBar
    @DefaultStringValue("Show warning bar") // $NON-NLS-1$
    String showWarningBarMenuLabel();
    
    // showRequestLog
    @DefaultStringValue("_Request Log") // $NON-NLS-1$
    String showRequestLogMenuLabel();
    @DefaultStringValue("Show internal request log") // $NON-NLS-1$
    String showRequestLogDesc();
    
    // diagnosticsReport
    @DefaultStringValue("_Write Diagnostics Report") // $NON-NLS-1$
    String diagnosticsReportMenuLabel();
    
    // openDeveloperConsole
    @DefaultStringValue("_Open Developer Console") // $NON-NLS-1$
    String openDeveloperConsoleMenuLabel();
    
    // reloadUi
    @DefaultStringValue("Reload _UI") // $NON-NLS-1$
    String reloadUiMenuLabel();
    
    // logFocusedElement
    @DefaultStringValue("Log focused element") // $NON-NLS-1$
    String logFocusedElementMenuLabel();
    
    // debugDumpContents
    @DefaultStringValue("_Dump Editor Contents...") // $NON-NLS-1$
    String debugDumpContentsMenuLabel();
    
    // debugImportDump
    @DefaultStringValue("_Import Editor Contents...") // $NON-NLS-1$
    String debugImportDumpMenuLabel();
    
    // refreshSuperDevMode
    
    // newSession
    @DefaultStringValue("Open a New R Session") // $NON-NLS-1$
    String newSessionLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String newSessionButtonLabel();
    @DefaultStringValue("_New Session") // $NON-NLS-1$
    String newSessionMenuLabel();
    @DefaultStringValue("Open a new R session") // $NON-NLS-1$
    String newSessionDesc();
    
    // suspendSession
    @DefaultStringValue("Suspend R Session") // $NON-NLS-1$
    String suspendSessionLabel();
    @DefaultStringValue("_Suspend R Session") // $NON-NLS-1$
    String suspendSessionMenuLabel();
    
    // quitSession
    @DefaultStringValue("Quit the Current R Session") // $NON-NLS-1$
    String quitSessionLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String quitSessionButtonLabel();
    @DefaultStringValue("_Quit Session...") // $NON-NLS-1$
    String quitSessionMenuLabel();
    @DefaultStringValue("Quit the current R session") // $NON-NLS-1$
    String quitSessionDesc();
    
    // forceQuitSession
    @DefaultStringValue("Quit the Current R Session Even if Busy") // $NON-NLS-1$
    String forceQuitSessionLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String forceQuitSessionButtonLabel();
    @DefaultStringValue("Force Quit Session...") // $NON-NLS-1$
    String forceQuitSessionMenuLabel();
    @DefaultStringValue("Quit the current R session even if busy") // $NON-NLS-1$
    String forceQuitSessionDesc();
    
    // showSessionServerOptionsDialog
    @DefaultStringValue("Session Server Settings...") // $NON-NLS-1$
    String showSessionServerOptionsDialogLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String showSessionServerOptionsDialogButtonLabel();
    @DefaultStringValue("_Session Server Settings...") // $NON-NLS-1$
    String showSessionServerOptionsDialogMenuLabel();
    @DefaultStringValue("Configure available session servers") // $NON-NLS-1$
    String showSessionServerOptionsDialogDesc();
    
    // showAboutDialog
    @DefaultStringValue("About RStudio...") // $NON-NLS-1$
    String showAboutDialogLabel();
    @DefaultStringValue("A_bout RStudio") // $NON-NLS-1$
    String showAboutDialogMenuLabel();
    
    // showLicenseDialog
    @DefaultStringValue("Manage License...") // $NON-NLS-1$
    String showLicenseDialogLabel();
    @DefaultStringValue("Ma_nage License...") // $NON-NLS-1$
    String showLicenseDialogMenuLabel();
    
    // showLogFiles
    @DefaultStringValue("_Show Log Files") // $NON-NLS-1$
    String showLogFilesMenuLabel();
    
    // updateCredentials
    @DefaultStringValue("_Update Credentials") // $NON-NLS-1$
    String updateCredentialsMenuLabel();
    
    // rstudioCommunityForum
    @DefaultStringValue("RStudio Community _Forum") // $NON-NLS-1$
    String rstudioCommunityForumMenuLabel();
    
    // rstudioSupport
    @DefaultStringValue("RStudio _Support") // $NON-NLS-1$
    String rstudioSupportMenuLabel();
    
    // rstudioLicense
    @DefaultStringValue("RStudio _License") // $NON-NLS-1$
    String rstudioLicenseMenuLabel();
    
    // buildAll
    @DefaultStringValue("Install and Restart") // $NON-NLS-1$
    String buildAllLabel();
    @DefaultStringValue("Install and Restart") // $NON-NLS-1$
    String buildAllButtonLabel();
    @DefaultStringValue("_Install and Restart") // $NON-NLS-1$
    String buildAllMenuLabel();
    @DefaultStringValue("Install the package and restart R") // $NON-NLS-1$
    String buildAllDesc();
    
    // rebuildAll
    @DefaultStringValue("Clean and Rebuild") // $NON-NLS-1$
    String rebuildAllLabel();
    @DefaultStringValue("Clean and _Rebuild") // $NON-NLS-1$
    String rebuildAllMenuLabel();
    @DefaultStringValue("Clean previous output and rebuild all") // $NON-NLS-1$
    String rebuildAllDesc();
    
    // cleanAll
    @DefaultStringValue("Clean All") // $NON-NLS-1$
    String cleanAllLabel();
    @DefaultStringValue("Clean") // $NON-NLS-1$
    String cleanAllButtonLabel();
    @DefaultStringValue("_Clean All") // $NON-NLS-1$
    String cleanAllMenuLabel();
    @DefaultStringValue("Clean all") // $NON-NLS-1$
    String cleanAllDesc();
    
    // buildSourcePackage
    @DefaultStringValue("Build _Source Package") // $NON-NLS-1$
    String buildSourcePackageMenuLabel();
    @DefaultStringValue("Build a source package") // $NON-NLS-1$
    String buildSourcePackageDesc();
    
    // buildBinaryPackage
    @DefaultStringValue("Build Binar_y Package") // $NON-NLS-1$
    String buildBinaryPackageMenuLabel();
    @DefaultStringValue("Build a binary package") // $NON-NLS-1$
    String buildBinaryPackageDesc();
    
    // devtoolsLoadAll
    @DefaultStringValue("Execute devtools::load_all()") // $NON-NLS-1$
    String devtoolsLoadAllLabel();
    @DefaultStringValue("_Load All") // $NON-NLS-1$
    String devtoolsLoadAllMenuLabel();
    @DefaultStringValue("Execute devtools::load_all") // $NON-NLS-1$
    String devtoolsLoadAllDesc();
    
    // roxygenizePackage
    @DefaultStringValue("Build Package Documentation") // $NON-NLS-1$
    String roxygenizePackageLabel();
    @DefaultStringValue("_Document") // $NON-NLS-1$
    String roxygenizePackageMenuLabel();
    @DefaultStringValue("Build package documentation") // $NON-NLS-1$
    String roxygenizePackageDesc();
    
    // checkPackage
    @DefaultStringValue("Check") // $NON-NLS-1$
    String checkPackageButtonLabel();
    @DefaultStringValue("_Check Package") // $NON-NLS-1$
    String checkPackageMenuLabel();
    @DefaultStringValue("R CMD check") // $NON-NLS-1$
    String checkPackageDesc();
    
    // testPackage
    @DefaultStringValue("_Test Package") // $NON-NLS-1$
    String testPackageMenuLabel();
    @DefaultStringValue("Run tests for package") // $NON-NLS-1$
    String testPackageDesc();
    
    // testTestthatFile
    @DefaultStringValue("Run testthat Tests") // $NON-NLS-1$
    String testTestthatFileLabel();
    @DefaultStringValue("Run Tests") // $NON-NLS-1$
    String testTestthatFileButtonLabel();
    @DefaultStringValue("Run tests for file") // $NON-NLS-1$
    String testTestthatFileMenuLabel();
    @DefaultStringValue("Run tests using the testthat package") // $NON-NLS-1$
    String testTestthatFileDesc();
    
    // testShinytestFile
    @DefaultStringValue("Run shinytest Test") // $NON-NLS-1$
    String testShinytestFileLabel();
    @DefaultStringValue("Run Test") // $NON-NLS-1$
    String testShinytestFileButtonLabel();
    @DefaultStringValue("Run test for file") // $NON-NLS-1$
    String testShinytestFileMenuLabel();
    @DefaultStringValue("Run test using the shinytest package") // $NON-NLS-1$
    String testShinytestFileDesc();
    
    // stopBuild
    @DefaultStringValue("Sto_p Build") // $NON-NLS-1$
    String stopBuildMenuLabel();
    @DefaultStringValue("Stop the current build") // $NON-NLS-1$
    String stopBuildDesc();
    
    // buildToolsProjectSetup
    @DefaultStringValue("Configure Build Tools...") // $NON-NLS-1$
    String buildToolsProjectSetupLabel();
    @DefaultStringValue("Configure Build _Tools...") // $NON-NLS-1$
    String buildToolsProjectSetupMenuLabel();
    @DefaultStringValue("Configure build tools") // $NON-NLS-1$
    String buildToolsProjectSetupDesc();
    
    // refreshEnvironment
    @DefaultStringValue("_Refresh Environment") // $NON-NLS-1$
    String refreshEnvironmentMenuLabel();
    @DefaultStringValue("Refresh the list of objects in the environment") // $NON-NLS-1$
    String refreshEnvironmentDesc();
    
    // undoDummy
    @DefaultStringValue("_Undo") // $NON-NLS-1$
    String undoDummyMenuLabel();
    
    // redoDummy
    @DefaultStringValue("Re_do") // $NON-NLS-1$
    String redoDummyMenuLabel();
    
    // cutDummy
    @DefaultStringValue("Cu_t") // $NON-NLS-1$
    String cutDummyMenuLabel();
    
    // copyDummy
    @DefaultStringValue("_Copy") // $NON-NLS-1$
    String copyDummyMenuLabel();
    
    // pasteDummy
    @DefaultStringValue("_Paste") // $NON-NLS-1$
    String pasteDummyMenuLabel();
    
    // pasteWithIndentDummy
    @DefaultStringValue("Pa_ste with Indent") // $NON-NLS-1$
    String pasteWithIndentDummyMenuLabel();
    
    // yankBeforeCursor
    @DefaultStringValue("Yank Before Cursor") // $NON-NLS-1$
    String yankBeforeCursorLabel();
    
    // yankAfterCursor
    @DefaultStringValue("Yank After Cursor") // $NON-NLS-1$
    String yankAfterCursorLabel();
    
    // pasteLastYank
    @DefaultStringValue("Paste Last Yank") // $NON-NLS-1$
    String pasteLastYankLabel();
    
    // insertAssignmentOperator
    @DefaultStringValue("Insert Assignment Operator") // $NON-NLS-1$
    String insertAssignmentOperatorLabel();
    
    // insertPipeOperator
    @DefaultStringValue("Insert Pipe Operator") // $NON-NLS-1$
    String insertPipeOperatorLabel();
    
    // openNextFileOnFilesystem
    @DefaultStringValue("Open Next File on Filesystem") // $NON-NLS-1$
    String openNextFileOnFilesystemLabel();
    
    // openPreviousFileOnFilesystem
    @DefaultStringValue("Open Previous File on Filesystem") // $NON-NLS-1$
    String openPreviousFileOnFilesystemLabel();
    
    // toggleSoftWrapMode
    @DefaultStringValue("Toggle Soft Wrap Mode") // $NON-NLS-1$
    String toggleSoftWrapModeLabel();
    @DefaultStringValue("Soft _Wrap Long Lines") // $NON-NLS-1$
    String toggleSoftWrapModeMenuLabel();
    
    // toggleRainbowParens
    @DefaultStringValue("Toggle Rainbow Parentheses Mode") // $NON-NLS-1$
    String toggleRainbowParensLabel();
    @DefaultStringValue("Rain_bow Parentheses") // $NON-NLS-1$
    String toggleRainbowParensMenuLabel();
    
    // maximizeConsole
    @DefaultStringValue("Maximize Console") // $NON-NLS-1$
    String maximizeConsoleMenuLabel();
    
    // debugBreakpoint
    @DefaultStringValue("Toggle Breakpoint on Current Line") // $NON-NLS-1$
    String debugBreakpointLabel();
    @DefaultStringValue("Toggle _Breakpoint") // $NON-NLS-1$
    String debugBreakpointMenuLabel();
    @DefaultStringValue("Set or remove a breakpoint on the current line of code") // $NON-NLS-1$
    String debugBreakpointDesc();
    
    // debugClearBreakpoints
    @DefaultStringValue("Clear All Breakpoints...") // $NON-NLS-1$
    String debugClearBreakpointsLabel();
    @DefaultStringValue("Clear _All Breakpoints...") // $NON-NLS-1$
    String debugClearBreakpointsMenuLabel();
    @DefaultStringValue("Remove all the breakpoints in the current project") // $NON-NLS-1$
    String debugClearBreakpointsDesc();
    
    // debugContinue
    @DefaultStringValue("Continue Execution") // $NON-NLS-1$
    String debugContinueLabel();
    @DefaultStringValue("Continue") // $NON-NLS-1$
    String debugContinueButtonLabel();
    @DefaultStringValue("_Continue") // $NON-NLS-1$
    String debugContinueMenuLabel();
    @DefaultStringValue("Continue execution until the next breakpoint is encountered") // $NON-NLS-1$
    String debugContinueDesc();
    
    // debugStop
    @DefaultStringValue("Stop Debugging") // $NON-NLS-1$
    String debugStopLabel();
    @DefaultStringValue("Stop") // $NON-NLS-1$
    String debugStopButtonLabel();
    @DefaultStringValue("_Stop Debugging") // $NON-NLS-1$
    String debugStopMenuLabel();
    @DefaultStringValue("Exit debug mode") // $NON-NLS-1$
    String debugStopDesc();
    
    // debugStep
    @DefaultStringValue("Execute Next Line") // $NON-NLS-1$
    String debugStepLabel();
    @DefaultStringValue("Next") // $NON-NLS-1$
    String debugStepButtonLabel();
    @DefaultStringValue("E_xecute Next Line") // $NON-NLS-1$
    String debugStepMenuLabel();
    @DefaultStringValue("Execute the next line of code") // $NON-NLS-1$
    String debugStepDesc();
    
    // debugStepInto
    @DefaultStringValue("Step Into Function") // $NON-NLS-1$
    String debugStepIntoLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String debugStepIntoButtonLabel();
    @DefaultStringValue("Step _Into Function") // $NON-NLS-1$
    String debugStepIntoMenuLabel();
    @DefaultStringValue("Step into the current function call") // $NON-NLS-1$
    String debugStepIntoDesc();
    
    // debugFinish
    @DefaultStringValue("Finish Function/Loop") // $NON-NLS-1$
    String debugFinishLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String debugFinishButtonLabel();
    @DefaultStringValue("_Finish Function/Loop") // $NON-NLS-1$
    String debugFinishMenuLabel();
    @DefaultStringValue("Execute the remainder of the current function or loop") // $NON-NLS-1$
    String debugFinishDesc();
    
    // debugHelp
    @DefaultStringValue("Show Guide on Debugging with RStudio") // $NON-NLS-1$
    String debugHelpLabel();
    @DefaultStringValue("Debugging _Help") // $NON-NLS-1$
    String debugHelpMenuLabel();
    @DefaultStringValue("Guide to debugging features") // $NON-NLS-1$
    String debugHelpDesc();
    
    // errorsMessage
    @DefaultStringValue("_Message Only") // $NON-NLS-1$
    String errorsMessageMenuLabel();
    @DefaultStringValue("Print the error message when an unhandled error occurs") // $NON-NLS-1$
    String errorsMessageDesc();
    
    // errorsTraceback
    @DefaultStringValue("_Error Inspector") // $NON-NLS-1$
    String errorsTracebackMenuLabel();
    @DefaultStringValue("Show the error inspector when an unhandled error occurs") // $NON-NLS-1$
    String errorsTracebackDesc();
    
    // errorsBreak
    @DefaultStringValue("_Break in Code") // $NON-NLS-1$
    String errorsBreakMenuLabel();
    @DefaultStringValue("Break when any unhandled error occurs") // $NON-NLS-1$
    String errorsBreakDesc();
    
    // startProfiler
    @DefaultStringValue("_Start Profiling") // $NON-NLS-1$
    String startProfilerMenuLabel();
    @DefaultStringValue("Start profiling R code") // $NON-NLS-1$
    String startProfilerDesc();
    
    // stopProfiler
    @DefaultStringValue("Stop Profiling") // $NON-NLS-1$
    String stopProfilerButtonLabel();
    @DefaultStringValue("Stop Profilin_g") // $NON-NLS-1$
    String stopProfilerMenuLabel();
    @DefaultStringValue("Stop profiling R code") // $NON-NLS-1$
    String stopProfilerDesc();
    
    // profileCode
    @DefaultStringValue("Profile Current Line or Selection") // $NON-NLS-1$
    String profileCodeLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String profileCodeButtonLabel();
    @DefaultStringValue("_Profile Selected Line(s)") // $NON-NLS-1$
    String profileCodeMenuLabel();
    @DefaultStringValue("Profile the current line or selection") // $NON-NLS-1$
    String profileCodeDesc();
    
    // gotoProfileSource
    @DefaultStringValue("Go To Profile Sources") // $NON-NLS-1$
    String gotoProfileSourceLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String gotoProfileSourceButtonLabel();
    @DefaultStringValue("Open sources associated with the selection") // $NON-NLS-1$
    String gotoProfileSourceDesc();
    
    // profileCodeWithoutFocus
    @DefaultStringValue("Profile Current Line or Selection Without Focus") // $NON-NLS-1$
    String profileCodeWithoutFocusLabel();
    
    // openProfile
    @DefaultStringValue("Open Profile...") // $NON-NLS-1$
    String openProfileLabel();
    @DefaultStringValue("_Open Profile...") // $NON-NLS-1$
    String openProfileMenuLabel();
    @DefaultStringValue("Opens a profile from a file") // $NON-NLS-1$
    String openProfileDesc();
    
    // saveProfileAs
    @DefaultStringValue("Save Profile As...") // $NON-NLS-1$
    String saveProfileAsLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String saveProfileAsButtonLabel();
    @DefaultStringValue("_Save Profile As...") // $NON-NLS-1$
    String saveProfileAsMenuLabel();
    @DefaultStringValue("Saves current profile into a file") // $NON-NLS-1$
    String saveProfileAsDesc();
    
    // openProfileInBrowser
    @DefaultStringValue("Open Profile in Browser...") // $NON-NLS-1$
    String openProfileInBrowserLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String openProfileInBrowserButtonLabel();
    @DefaultStringValue("_Open Profile in Browser") // $NON-NLS-1$
    String openProfileInBrowserMenuLabel();
    @DefaultStringValue("Opens current profile in a web browser") // $NON-NLS-1$
    String openProfileInBrowserDesc();
    
    // profileHelp
    @DefaultStringValue("Show Guide on Profiling with RStudio") // $NON-NLS-1$
    String profileHelpLabel();
    @DefaultStringValue("Profiling _Help") // $NON-NLS-1$
    String profileHelpMenuLabel();
    @DefaultStringValue("Guide to profiling features") // $NON-NLS-1$
    String profileHelpDesc();
    
    // reloadShinyApp
    @DefaultStringValue("Reload Shiny Application") // $NON-NLS-1$
    String reloadShinyAppLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String reloadShinyAppButtonLabel();
    @DefaultStringValue("Reload") // $NON-NLS-1$
    String reloadShinyAppMenuLabel();
    @DefaultStringValue("Reload the Shiny application") // $NON-NLS-1$
    String reloadShinyAppDesc();
    
    // shinyRunInPane
    @DefaultStringValue("Run Shiny Application in New Pane") // $NON-NLS-1$
    String shinyRunInPaneLabel();
    @DefaultStringValue("Run in Viewer Pane") // $NON-NLS-1$
    String shinyRunInPaneMenuLabel();
    @DefaultStringValue("Run the Shiny application in an RStudio pane") // $NON-NLS-1$
    String shinyRunInPaneDesc();
    
    // shinyRunInViewer
    @DefaultStringValue("Run Shiny Application in RStudio Viewer") // $NON-NLS-1$
    String shinyRunInViewerLabel();
    @DefaultStringValue("Run in Window") // $NON-NLS-1$
    String shinyRunInViewerMenuLabel();
    @DefaultStringValue("Run the Shiny application in an RStudio viewer window") // $NON-NLS-1$
    String shinyRunInViewerDesc();
    
    // shinyRunInBrowser
    @DefaultStringValue("Run Shiny Application in Web Browser") // $NON-NLS-1$
    String shinyRunInBrowserLabel();
    @DefaultStringValue("Run External") // $NON-NLS-1$
    String shinyRunInBrowserMenuLabel();
    @DefaultStringValue("Run the Shiny application in the system's default Web browser") // $NON-NLS-1$
    String shinyRunInBrowserDesc();
    
    // shinyRecordTest
    @DefaultStringValue("Record a test for Shiny") // $NON-NLS-1$
    String shinyRecordTestLabel();
    @DefaultStringValue("Record Test") // $NON-NLS-1$
    String shinyRecordTestButtonLabel();
    @DefaultStringValue("Record Test") // $NON-NLS-1$
    String shinyRecordTestMenuLabel();
    @DefaultStringValue("Record test for Shiny application") // $NON-NLS-1$
    String shinyRecordTestDesc();
    
    // shinyRunAllTests
    @DefaultStringValue("Run tests for Shiny application") // $NON-NLS-1$
    String shinyRunAllTestsLabel();
    @DefaultStringValue("Run Tests") // $NON-NLS-1$
    String shinyRunAllTestsButtonLabel();
    @DefaultStringValue("Run Tests") // $NON-NLS-1$
    String shinyRunAllTestsMenuLabel();
    @DefaultStringValue("Run tests for Shiny application") // $NON-NLS-1$
    String shinyRunAllTestsDesc();
    
    // shinyCompareTest
    @DefaultStringValue("Compare test results for Shiny application") // $NON-NLS-1$
    String shinyCompareTestLabel();
    @DefaultStringValue("Compare Results") // $NON-NLS-1$
    String shinyCompareTestButtonLabel();
    @DefaultStringValue("Compare Results") // $NON-NLS-1$
    String shinyCompareTestMenuLabel();
    @DefaultStringValue("Compare test results for Shiny application") // $NON-NLS-1$
    String shinyCompareTestDesc();
    
    // reloadPlumberAPI
    @DefaultStringValue("Reload Plumber API") // $NON-NLS-1$
    String reloadPlumberAPILabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String reloadPlumberAPIButtonLabel();
    @DefaultStringValue("Reload") // $NON-NLS-1$
    String reloadPlumberAPIMenuLabel();
    @DefaultStringValue("Reload the Plumber API") // $NON-NLS-1$
    String reloadPlumberAPIDesc();
    
    // plumberRunInPane
    @DefaultStringValue("Run Plumber API in New Pane") // $NON-NLS-1$
    String plumberRunInPaneLabel();
    @DefaultStringValue("Run in Viewer Pane") // $NON-NLS-1$
    String plumberRunInPaneMenuLabel();
    @DefaultStringValue("Run the Plumber API in an RStudio pane") // $NON-NLS-1$
    String plumberRunInPaneDesc();
    
    // plumberRunInViewer
    @DefaultStringValue("Run Plumber API in RStudio Viewer") // $NON-NLS-1$
    String plumberRunInViewerLabel();
    @DefaultStringValue("Run in Window") // $NON-NLS-1$
    String plumberRunInViewerMenuLabel();
    @DefaultStringValue("Run the Plumber API in an RStudio viewer window") // $NON-NLS-1$
    String plumberRunInViewerDesc();
    
    // plumberRunInBrowser
    @DefaultStringValue("Run Plumber API in Web Browser") // $NON-NLS-1$
    String plumberRunInBrowserLabel();
    @DefaultStringValue("Run External") // $NON-NLS-1$
    String plumberRunInBrowserMenuLabel();
    @DefaultStringValue("Run the Plumber API in the system's default Web browser") // $NON-NLS-1$
    String plumberRunInBrowserDesc();
    
    // rsconnectDeploy
    @DefaultStringValue("P_ublish...") // $NON-NLS-1$
    String rsconnectDeployMenuLabel();
    @DefaultStringValue("Publish the application or document") // $NON-NLS-1$
    String rsconnectDeployDesc();
    
    // rsconnectConfigure
    @DefaultStringValue("_Configure Application...") // $NON-NLS-1$
    String rsconnectConfigureMenuLabel();
    @DefaultStringValue("Configure the application") // $NON-NLS-1$
    String rsconnectConfigureDesc();
    
    // rsconnectManageAccounts
    @DefaultStringValue("_Manage Accounts...") // $NON-NLS-1$
    String rsconnectManageAccountsMenuLabel();
    @DefaultStringValue("Connect or disconnect accounts") // $NON-NLS-1$
    String rsconnectManageAccountsDesc();
    
    // showGpuDiagnostics
    @DefaultStringValue("Show _GPU Diagnostics") // $NON-NLS-1$
    String showGpuDiagnosticsMenuLabel();
    
    // toggleEditorTokenInfo
    @DefaultStringValue("_Toggle Editor Token Information") // $NON-NLS-1$
    String toggleEditorTokenInfoMenuLabel();
    
    // showDomElements
    @DefaultStringValue("_Show DOM Elements") // $NON-NLS-1$
    String showDomElementsMenuLabel();
    
    // newConnection
    @DefaultStringValue("New Connection") // $NON-NLS-1$
    String newConnectionButtonLabel();
    @DefaultStringValue("New Connection...") // $NON-NLS-1$
    String newConnectionMenuLabel();
    @DefaultStringValue("Create a new connection") // $NON-NLS-1$
    String newConnectionDesc();
    
    // removeConnection
    @DefaultStringValue("") // $NON-NLS-1$
    String removeConnectionButtonLabel();
    @DefaultStringValue("Remove Connection...") // $NON-NLS-1$
    String removeConnectionMenuLabel();
    @DefaultStringValue("Remove connection from the connection history") // $NON-NLS-1$
    String removeConnectionDesc();
    
    // disconnectConnection
    @DefaultStringValue("Disconnect") // $NON-NLS-1$
    String disconnectConnectionMenuLabel();
    @DefaultStringValue("Disconnect from a connection") // $NON-NLS-1$
    String disconnectConnectionDesc();
    
    // refreshConnection
    @DefaultStringValue("Refresh Connection Data") // $NON-NLS-1$
    String refreshConnectionLabel();
    @DefaultStringValue("Refresh") // $NON-NLS-1$
    String refreshConnectionMenuLabel();
    @DefaultStringValue("Refresh data") // $NON-NLS-1$
    String refreshConnectionDesc();
    
    // sparkLog
    @DefaultStringValue("View Spark Log") // $NON-NLS-1$
    String sparkLogLabel();
    @DefaultStringValue("Log") // $NON-NLS-1$
    String sparkLogButtonLabel();
    @DefaultStringValue("Spark Log") // $NON-NLS-1$
    String sparkLogMenuLabel();
    @DefaultStringValue("View the log for the Spark connection") // $NON-NLS-1$
    String sparkLogDesc();
    
    // sparkUI
    @DefaultStringValue("SparkUI") // $NON-NLS-1$
    String sparkUIButtonLabel();
    @DefaultStringValue("SparkUI") // $NON-NLS-1$
    String sparkUIMenuLabel();
    @DefaultStringValue("View the browser UI for the Spark connection") // $NON-NLS-1$
    String sparkUIDesc();
    
    // sparkHelp
    @DefaultStringValue("") // $NON-NLS-1$
    String sparkHelpButtonLabel();
    @DefaultStringValue("Using Spark with RStudio") // $NON-NLS-1$
    String sparkHelpMenuLabel();
    @DefaultStringValue("Help on using Spark with RStudio") // $NON-NLS-1$
    String sparkHelpDesc();
    
    // startJob
    @DefaultStringValue("Start Local Job") // $NON-NLS-1$
    String startJobButtonLabel();
    @DefaultStringValue("_Start Local Job...") // $NON-NLS-1$
    String startJobMenuLabel();
    @DefaultStringValue("Run a background local job") // $NON-NLS-1$
    String startJobDesc();
    
    // sourceAsJob
    @DefaultStringValue("Source as Local Job...") // $NON-NLS-1$
    String sourceAsJobMenuLabel();
    @DefaultStringValue("Run the current R script as a local job") // $NON-NLS-1$
    String sourceAsJobDesc();
    
    // clearJobs
    @DefaultStringValue("_Clear Local Jobs") // $NON-NLS-1$
    String clearJobsMenuLabel();
    @DefaultStringValue("Clean up all completed local jobs") // $NON-NLS-1$
    String clearJobsDesc();
    
    // runSelectionAsJob
    @DefaultStringValue("Ru_n Selection as Local Job") // $NON-NLS-1$
    String runSelectionAsJobMenuLabel();
    @DefaultStringValue("Run the selected code as a local job") // $NON-NLS-1$
    String runSelectionAsJobDesc();
    
    // startLauncherJob
    @DefaultStringValue("Start Launcher Job") // $NON-NLS-1$
    String startLauncherJobButtonLabel();
    @DefaultStringValue("Start Launcher _Job...") // $NON-NLS-1$
    String startLauncherJobMenuLabel();
    @DefaultStringValue("Run a background job on a cluster") // $NON-NLS-1$
    String startLauncherJobDesc();
    
    // sourceAsLauncherJob
    @DefaultStringValue("Source as Launcher Job...") // $NON-NLS-1$
    String sourceAsLauncherJobMenuLabel();
    @DefaultStringValue("Run the current R script on a cluster") // $NON-NLS-1$
    String sourceAsLauncherJobDesc();
    
    // runSelectionAsLauncherJob
    @DefaultStringValue("Run Selection as _Launcher Job") // $NON-NLS-1$
    String runSelectionAsLauncherJobMenuLabel();
    @DefaultStringValue("Run the selected code as a launcher job") // $NON-NLS-1$
    String runSelectionAsLauncherJobDesc();
    
    // sortLauncherJobsRecorded
    @DefaultStringValue("Sort by Submission Time") // $NON-NLS-1$
    String sortLauncherJobsRecordedMenuLabel();
    @DefaultStringValue("Sort jobs by time submitted") // $NON-NLS-1$
    String sortLauncherJobsRecordedDesc();
    
    // sortLauncherJobsState
    @DefaultStringValue("Sort by Job State") // $NON-NLS-1$
    String sortLauncherJobsStateMenuLabel();
    @DefaultStringValue("Sort jobs by current state") // $NON-NLS-1$
    String sortLauncherJobsStateDesc();
    
    // showFileMenu
    @DefaultStringValue("Show File Menu") // $NON-NLS-1$
    String showFileMenuMenuLabel();
    
    // showEditMenu
    @DefaultStringValue("Show Edit Menu") // $NON-NLS-1$
    String showEditMenuMenuLabel();
    
    // showCodeMenu
    @DefaultStringValue("Show Code Menu") // $NON-NLS-1$
    String showCodeMenuMenuLabel();
    
    // showViewMenu
    @DefaultStringValue("Show View Menu") // $NON-NLS-1$
    String showViewMenuMenuLabel();
    
    // showPlotsMenu
    @DefaultStringValue("Show Plots Menu") // $NON-NLS-1$
    String showPlotsMenuMenuLabel();
    
    // showSessionMenu
    @DefaultStringValue("Show Session Menu") // $NON-NLS-1$
    String showSessionMenuMenuLabel();
    
    // showBuildMenu
    @DefaultStringValue("Show Build Menu") // $NON-NLS-1$
    String showBuildMenuMenuLabel();
    
    // showDebugMenu
    @DefaultStringValue("Show Debug Menu") // $NON-NLS-1$
    String showDebugMenuMenuLabel();
    
    // showProfileMenu
    @DefaultStringValue("Show Profile Menu") // $NON-NLS-1$
    String showProfileMenuMenuLabel();
    
    // showToolsMenu
    @DefaultStringValue("Show Tools Menu") // $NON-NLS-1$
    String showToolsMenuMenuLabel();
    
    // showHelpMenu
    @DefaultStringValue("Show Help Menu") // $NON-NLS-1$
    String showHelpMenuMenuLabel();
    
    // editUserPrefs
    @DefaultStringValue("_Edit User Prefs File") // $NON-NLS-1$
    String editUserPrefsMenuLabel();
    
    // clearUserPrefs
    @DefaultStringValue("_Clear User Prefs") // $NON-NLS-1$
    String clearUserPrefsMenuLabel();
    
    // viewAllPrefs
    @DefaultStringValue("_View All Prefs") // $NON-NLS-1$
    String viewAllPrefsMenuLabel();
    
    // toggleScreenReaderSupport
    @DefaultStringValue("_Screen Reader Support") // $NON-NLS-1$
    String toggleScreenReaderSupportMenuLabel();
    
    // showAccessibilityHelp
    @DefaultStringValue("Accessibility _Help...") // $NON-NLS-1$
    String showAccessibilityHelpMenuLabel();
    
    // toggleTabKeyMovesFocus
    @DefaultStringValue("_Tab Key Always Moves Focus") // $NON-NLS-1$
    String toggleTabKeyMovesFocusMenuLabel();
    
    // focusMainToolbar
    @DefaultStringValue("Focus _Main Toolbar") // $NON-NLS-1$
    String focusMainToolbarMenuLabel();
    
    // focusConsoleOutputEnd
    @DefaultStringValue("_Focus Console Output") // $NON-NLS-1$
    String focusConsoleOutputEndMenuLabel();
    
    // focusNextPane
    @DefaultStringValue("_Focus Next Pane") // $NON-NLS-1$
    String focusNextPaneMenuLabel();
    
    // focusPreviousPane
    @DefaultStringValue("_Focus Previous Pane") // $NON-NLS-1$
    String focusPreviousPaneMenuLabel();
    
    // signOut
    @DefaultStringValue("Sign Out") // $NON-NLS-1$
    String signOutLabel();
    @DefaultStringValue("") // $NON-NLS-1$
    String signOutButtonLabel();
    @DefaultStringValue("Sign Ou_t") // $NON-NLS-1$
    String signOutMenuLabel();
    @DefaultStringValue("Sign out from RStudio") // $NON-NLS-1$
    String signOutDesc();
    
    // loadServerHome
    @DefaultStringValue("") // $NON-NLS-1$
    String loadServerHomeButtonLabel();
    @DefaultStringValue("RStudio Server _Home") // $NON-NLS-1$
    String loadServerHomeMenuLabel();
    
    // speakEditorLocation
    @DefaultStringValue("Speak Text _Editor Location") // $NON-NLS-1$
    String speakEditorLocationMenuLabel();
    
    // focusLeftSeparator
    @DefaultStringValue("A_djust Left Splitter") // $NON-NLS-1$
    String focusLeftSeparatorMenuLabel();
    
    // focusRightSeparator
    @DefaultStringValue("Ad_just Right Splitter") // $NON-NLS-1$
    String focusRightSeparatorMenuLabel();
    
    // focusCenterSeparator
    @DefaultStringValue("Adjust Center S_plitter") // $NON-NLS-1$
    String focusCenterSeparatorMenuLabel();
    
    // focusSourceColumnSeparator
    @DefaultStringValue("Adjust Source Column Spli_tter") // $NON-NLS-1$
    String focusSourceColumnSeparatorMenuLabel();
    
    // showShortcutCommand
    @DefaultStringValue("Show _Keyboard Shortcut Commands") // $NON-NLS-1$
    String showShortcutCommandMenuLabel();
    
    // showCommandPalette
    @DefaultStringValue("Show Command Palette") // $NON-NLS-1$
    String showCommandPaletteLabel();
    @DefaultStringValue("Show _Command Palette") // $NON-NLS-1$
    String showCommandPaletteMenuLabel();
    
    // clearCommandPaletteMru
    @DefaultStringValue("Clear Recently Executed Command List") // $NON-NLS-1$
    String clearCommandPaletteMruMenuLabel();
    
    // freeUnusedMemory
    @DefaultStringValue("_Free Unused R Memory") // $NON-NLS-1$
    String freeUnusedMemoryMenuLabel();
    
    // showMemoryUsageReport
    @DefaultStringValue("Memory Usage _Report...") // $NON-NLS-1$
    String showMemoryUsageReportMenuLabel();
    
    // toggleShowMemoryUsage
    @DefaultStringValue("Toggle Memory Usage Display in Environment Pane") // $NON-NLS-1$
    String toggleShowMemoryUsageLabel();
    @DefaultStringValue("_Show Current Memory Usage") // $NON-NLS-1$
    String toggleShowMemoryUsageMenuLabel();
    
}