/* UserPrefsAccessor.java
 *
 * Copyright (C) 2022 by RStudio, PBC
 *
 * Unless you have received this program directly from RStudio pursuant
 * to the terms of a commercial license agreement with RStudio, then
 * this program is licensed to you under the terms of version 3 of the
 * GNU Affero General Public License. This program is distributed WITHOUT
 * ANY EXPRESS OR IMPLIED WARRANTY, INCLUDING THOSE OF NON-INFRINGEMENT,
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Please refer to the
 * AGPL (http://www.gnu.org/licenses/agpl-3.0.txt) for more details.
 *
 */
 
/* DO NOT HAND-EDIT! This file is automatically generated from the formal user preference schema
 * JSON. To add a preference, add it to "user-prefs-schema.json", then run "generate-prefs.R" to
 * rebuild this file.
 */

package org.rstudio.studio.client.workbench.prefs.model;

import org.rstudio.core.client.js.JsObject;
import org.rstudio.studio.client.workbench.model.SessionInfo;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsArrayString;
import com.google.gwt.core.client.JsArray;
import org.rstudio.core.client.JsArrayUtil;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.core.client.GWT;


/**
 * Accessor class for user preferences.
 */ 
public class UserPrefsAccessor extends Prefs
{
   public UserPrefsAccessor(SessionInfo sessionInfo, 
                            JsArray<PrefLayer> prefLayers)
   {
      super(prefLayers);
   }
   
   /**
    * Whether to run .Rprofile again after resuming a suspended R session.
    */
   public PrefValue<Boolean> runRprofileOnResume()
   {
      return bool(
         "run_rprofile_on_resume",
         _constants.runRprofileOnResumeTitle(), 
         _constants.runRprofileOnResumeDescription(), 
         false);
   }

   /**
    * Whether to save the workspace to an .Rdata file after the R session ends.
    */
   public PrefValue<String> saveWorkspace()
   {
      return enumeration(
         "save_workspace",
         _constants.saveWorkspaceTitle(), 
         _constants.saveWorkspaceDescription(), 
         new String[] {
            SAVE_WORKSPACE_ALWAYS,
            SAVE_WORKSPACE_NEVER,
            SAVE_WORKSPACE_ASK
         },
         "ask");
   }

   public final static String SAVE_WORKSPACE_ALWAYS = "always";
   public final static String SAVE_WORKSPACE_NEVER = "never";
   public final static String SAVE_WORKSPACE_ASK = "ask";

   /**
    * Whether to load the workspace when the R session begins.
    */
   public PrefValue<Boolean> loadWorkspace()
   {
      return bool(
         "load_workspace",
         _constants.loadWorkspaceTitle(), 
         _constants.loadWorkspaceDescription(), 
         true);
   }

   /**
    * The initial working directory for new R sessions.
    */
   public PrefValue<String> initialWorkingDirectory()
   {
      return string(
         "initial_working_directory",
         _constants.initialWorkingDirectoryTitle(), 
         _constants.initialWorkingDirectoryDescription(), 
         "");
   }

   /**
    * The CRAN mirror to use.
    */
   public PrefValue<CranMirror> cranMirror()
   {
      return object(
         "cran_mirror",
         _constants.cranMirrorTitle(), 
         _constants.cranMirrorDescription(), 
         null);
   }

   public static class CranMirror extends JavaScriptObject
   {
      protected CranMirror() {} 

      public final native String getName() /*-{
         return this && this.name || "Global (CDN)";
      }-*/;

      public final native String getHost() /*-{
         return this && this.host || "RStudio";
      }-*/;

      public final native String getUrl() /*-{
         return this && this.url || "https://cran.rstudio.com/";
      }-*/;

      public final native String getRepos() /*-{
         return this && this.repos || "";
      }-*/;

      public final native String getCountry() /*-{
         return this && this.country || "us";
      }-*/;

      public final native String getSecondary() /*-{
         return this && this.secondary || "";
      }-*/;

   }

   /**
    * The name of the default Bioconductor mirror.
    */
   public PrefValue<String> bioconductorMirrorName()
   {
      return string(
         "bioconductor_mirror_name",
         _constants.bioconductorMirrorNameTitle(), 
         _constants.bioconductorMirrorNameDescription(), 
         "Seattle (USA)");
   }

   /**
    * The URL of the default Bioconductor mirror.
    */
   public PrefValue<String> bioconductorMirrorUrl()
   {
      return string(
         "bioconductor_mirror_url",
         _constants.bioconductorMirrorUrlTitle(), 
         _constants.bioconductorMirrorUrlDescription(), 
         "http://www.bioconductor.org");
   }

   /**
    * Whether to always save the R console history.
    */
   public PrefValue<Boolean> alwaysSaveHistory()
   {
      return bool(
         "always_save_history",
         _constants.alwaysSaveHistoryTitle(), 
         _constants.alwaysSaveHistoryDescription(), 
         true);
   }

   /**
    * Whether to remove duplicate entries from the R console history.
    */
   public PrefValue<Boolean> removeHistoryDuplicates()
   {
      return bool(
         "remove_history_duplicates",
         _constants.removeHistoryDuplicatesTitle(), 
         _constants.removeHistoryDuplicatesDescription(), 
         false);
   }

   /**
    * Show the result of the last expression (.Last.value) in the Environment pane.
    */
   public PrefValue<Boolean> showLastDotValue()
   {
      return bool(
         "show_last_dot_value",
         _constants.showLastDotValueTitle(), 
         _constants.showLastDotValueDescription(), 
         false);
   }

   /**
    * The line ending format to use when saving files.
    */
   public PrefValue<String> lineEndingConversion()
   {
      return enumeration(
         "line_ending_conversion",
         _constants.lineEndingConversionTitle(), 
         _constants.lineEndingConversionDescription(), 
         new String[] {
            LINE_ENDING_CONVERSION_DEFAULT,
            LINE_ENDING_CONVERSION_WINDOWS,
            LINE_ENDING_CONVERSION_POSIX,
            LINE_ENDING_CONVERSION_NATIVE,
            LINE_ENDING_CONVERSION_PASSTHROUGH
         },
         "native");
   }

   public final static String LINE_ENDING_CONVERSION_DEFAULT = "default";
   public final static String LINE_ENDING_CONVERSION_WINDOWS = "windows";
   public final static String LINE_ENDING_CONVERSION_POSIX = "posix";
   public final static String LINE_ENDING_CONVERSION_NATIVE = "native";
   public final static String LINE_ENDING_CONVERSION_PASSTHROUGH = "passthrough";

   /**
    * Whether to use newlines when saving Makefiles.
    */
   public PrefValue<Boolean> useNewlinesInMakefiles()
   {
      return bool(
         "use_newlines_in_makefiles",
         _constants.useNewlinesInMakefilesTitle(), 
         _constants.useNewlinesInMakefilesDescription(), 
         true);
   }

   /**
    * The terminal shell to use on Windows.
    */
   public PrefValue<String> windowsTerminalShell()
   {
      return enumeration(
         "windows_terminal_shell",
         _constants.windowsTerminalShellTitle(), 
         _constants.windowsTerminalShellDescription(), 
         new String[] {
            WINDOWS_TERMINAL_SHELL_DEFAULT,
            WINDOWS_TERMINAL_SHELL_WIN_GIT_BASH,
            WINDOWS_TERMINAL_SHELL_WIN_WSL_BASH,
            WINDOWS_TERMINAL_SHELL_WIN_CMD,
            WINDOWS_TERMINAL_SHELL_WIN_PS,
            WINDOWS_TERMINAL_SHELL_PS_CORE,
            WINDOWS_TERMINAL_SHELL_CUSTOM,
            WINDOWS_TERMINAL_SHELL_NONE
         },
         "default");
   }

   public final static String WINDOWS_TERMINAL_SHELL_DEFAULT = "default";
   public final static String WINDOWS_TERMINAL_SHELL_WIN_GIT_BASH = "win-git-bash";
   public final static String WINDOWS_TERMINAL_SHELL_WIN_WSL_BASH = "win-wsl-bash";
   public final static String WINDOWS_TERMINAL_SHELL_WIN_CMD = "win-cmd";
   public final static String WINDOWS_TERMINAL_SHELL_WIN_PS = "win-ps";
   public final static String WINDOWS_TERMINAL_SHELL_PS_CORE = "ps-core";
   public final static String WINDOWS_TERMINAL_SHELL_CUSTOM = "custom";
   public final static String WINDOWS_TERMINAL_SHELL_NONE = "none";

   /**
    * The terminal shell to use on POSIX operating systems (MacOS and Linux).
    */
   public PrefValue<String> posixTerminalShell()
   {
      return enumeration(
         "posix_terminal_shell",
         _constants.posixTerminalShellTitle(), 
         _constants.posixTerminalShellDescription(), 
         new String[] {
            POSIX_TERMINAL_SHELL_DEFAULT,
            POSIX_TERMINAL_SHELL_BASH,
            POSIX_TERMINAL_SHELL_ZSH,
            POSIX_TERMINAL_SHELL_CUSTOM,
            POSIX_TERMINAL_SHELL_NONE
         },
         "default");
   }

   public final static String POSIX_TERMINAL_SHELL_DEFAULT = "default";
   public final static String POSIX_TERMINAL_SHELL_BASH = "bash";
   public final static String POSIX_TERMINAL_SHELL_ZSH = "zsh";
   public final static String POSIX_TERMINAL_SHELL_CUSTOM = "custom";
   public final static String POSIX_TERMINAL_SHELL_NONE = "none";

   /**
    * The fully qualified path to the custom shell command to use in the Terminal tab.
    */
   public PrefValue<String> customShellCommand()
   {
      return string(
         "custom_shell_command",
         _constants.customShellCommandTitle(), 
         _constants.customShellCommandDescription(), 
         "");
   }

   /**
    * The command-line options to pass to the custom shell command.
    */
   public PrefValue<String> customShellOptions()
   {
      return string(
         "custom_shell_options",
         _constants.customShellOptionsTitle(), 
         _constants.customShellOptionsDescription(), 
         "");
   }

   /**
    * Show line numbers in RStudio's code editor.
    */
   public PrefValue<Boolean> showLineNumbers()
   {
      return bool(
         "show_line_numbers",
         _constants.showLineNumbersTitle(), 
         _constants.showLineNumbersDescription(), 
         true);
   }

   /**
    * Highlight the selected word in RStudio's code editor.
    */
   public PrefValue<Boolean> highlightSelectedWord()
   {
      return bool(
         "highlight_selected_word",
         _constants.highlightSelectedWordTitle(), 
         _constants.highlightSelectedWordDescription(), 
         true);
   }

   /**
    * Highlight the selected line in RStudio's code editor.
    */
   public PrefValue<Boolean> highlightSelectedLine()
   {
      return bool(
         "highlight_selected_line",
         _constants.highlightSelectedLineTitle(), 
         _constants.highlightSelectedLineDescription(), 
         false);
   }

   /**
    * Layout of panes in the RStudio workbench.
    */
   public PrefValue<Panes> panes()
   {
      return object(
         "panes",
         _constants.panesTitle(), 
         _constants.panesDescription(), 
         null);
   }

   public static class Panes extends JavaScriptObject
   {
      protected Panes() {} 

      public final static String QUADRANTS_SOURCE = "Source";
      public final static String QUADRANTS_CONSOLE = "Console";
      public final static String QUADRANTS_TABSET1 = "TabSet1";
      public final static String QUADRANTS_TABSET2 = "TabSet2";
      public final static String QUADRANTS_HIDDENTABSET = "HiddenTabSet";

      public final native JsArrayString getQuadrants() /*-{
         return this && this.quadrants || ["Source","Console","TabSet1","TabSet2","HiddenTabSet"];
      }-*/;

      public final native JsArrayString getTabSet1() /*-{
         return this && this.tabSet1 || ["Environment","History","Connections","Build","VCS","Tutorial","Presentation"];
      }-*/;

      public final native JsArrayString getTabSet2() /*-{
         return this && this.tabSet2 || ["Files","Plots","Packages","Help","Viewer","Presentations"];
      }-*/;

      public final native JsArrayString getHiddenTabSet() /*-{
         return this && this.hiddenTabSet || [];
      }-*/;

      public final native boolean getConsoleLeftOnTop() /*-{
         return this && this.console_left_on_top || false;
      }-*/;

      public final native boolean getConsoleRightOnTop() /*-{
         return this && this.console_right_on_top || true;
      }-*/;

      public final native int getAdditionalSourceColumns() /*-{
         return this && this.additional_source_columns || 0;
      }-*/;

   }

   /**
    * Whether to enable the ability to add source columns to display.
    */
   public PrefValue<Boolean> allowSourceColumns()
   {
      return bool(
         "allow_source_columns",
         _constants.allowSourceColumnsTitle(), 
         _constants.allowSourceColumnsDescription(), 
         true);
   }

   /**
    * Whether to insert spaces when pressing the Tab key.
    */
   public PrefValue<Boolean> useSpacesForTab()
   {
      return bool(
         "use_spaces_for_tab",
         _constants.useSpacesForTabTitle(), 
         _constants.useSpacesForTabDescription(), 
         true);
   }

   /**
    * The number of spaces to insert when pressing the Tab key.
    */
   public PrefValue<Integer> numSpacesForTab()
   {
      return integer(
         "num_spaces_for_tab",
         _constants.numSpacesForTabTitle(), 
         _constants.numSpacesForTabDescription(), 
         2);
   }

   /**
    * Whether to automatically detect indentation settings from file contents.
    */
   public PrefValue<Boolean> autoDetectIndentation()
   {
      return bool(
         "auto_detect_indentation",
         _constants.autoDetectIndentationTitle(), 
         _constants.autoDetectIndentationDescription(), 
         false);
   }

   /**
    * Whether to show the margin guide in the RStudio code editor.
    */
   public PrefValue<Boolean> showMargin()
   {
      return bool(
         "show_margin",
         _constants.showMarginTitle(), 
         _constants.showMarginDescription(), 
         true);
   }

   /**
    * Whether to flash the cursor off and on.
    */
   public PrefValue<Boolean> blinkingCursor()
   {
      return bool(
         "blinking_cursor",
         _constants.blinkingCursorTitle(), 
         _constants.blinkingCursorDescription(), 
         true);
   }

   /**
    * The number of columns of text after which the margin is shown.
    */
   public PrefValue<Integer> marginColumn()
   {
      return integer(
         "margin_column",
         _constants.marginColumnTitle(), 
         _constants.marginColumnDescription(), 
         80);
   }

   /**
    * Whether to show invisible characters, such as spaces and tabs, in the RStudio code editor.
    */
   public PrefValue<Boolean> showInvisibles()
   {
      return bool(
         "show_invisibles",
         _constants.showInvisiblesTitle(), 
         _constants.showInvisiblesDescription(), 
         false);
   }

   /**
    * Whether to show indentation guides in the RStudio code editor.
    */
   public PrefValue<Boolean> showIndentGuides()
   {
      return bool(
         "show_indent_guides",
         _constants.showIndentGuidesTitle(), 
         _constants.showIndentGuidesDescription(), 
         false);
   }

   /**
    * Whether to continue comments (by inserting the comment character) after adding a new line.
    */
   public PrefValue<Boolean> continueCommentsOnNewline()
   {
      return bool(
         "continue_comments_on_newline",
         _constants.continueCommentsOnNewlineTitle(), 
         _constants.continueCommentsOnNewlineDescription(), 
         false);
   }

   /**
    * Whether web links in comments are clickable.
    */
   public PrefValue<Boolean> highlightWebLink()
   {
      return bool(
         "highlight_web_link",
         _constants.highlightWebLinkTitle(), 
         _constants.highlightWebLinkDescription(), 
         true);
   }

   /**
    * The keybindings to use in the RStudio code editor.
    */
   public PrefValue<String> editorKeybindings()
   {
      return enumeration(
         "editor_keybindings",
         _constants.editorKeybindingsTitle(), 
         _constants.editorKeybindingsDescription(), 
         new String[] {
            EDITOR_KEYBINDINGS_DEFAULT,
            EDITOR_KEYBINDINGS_VIM,
            EDITOR_KEYBINDINGS_EMACS,
            EDITOR_KEYBINDINGS_SUBLIME
         },
         "default",
         new String[] {
            _constants.editorKeybindingsEnum_default(),
            _constants.editorKeybindingsEnum_vim(),
            _constants.editorKeybindingsEnum_emacs(),
            _constants.editorKeybindingsEnum_sublime()
         });
   }

   public final static String EDITOR_KEYBINDINGS_DEFAULT = "default";
   public final static String EDITOR_KEYBINDINGS_VIM = "vim";
   public final static String EDITOR_KEYBINDINGS_EMACS = "emacs";
   public final static String EDITOR_KEYBINDINGS_SUBLIME = "sublime";

   /**
    * Whether to insert matching pairs, such as () and [], when the first is typed.
    */
   public PrefValue<Boolean> insertMatching()
   {
      return bool(
         "insert_matching",
         _constants.insertMatchingTitle(), 
         _constants.insertMatchingDescription(), 
         true);
   }

   /**
    * Whether to insert spaces around the equals sign in R code.
    */
   public PrefValue<Boolean> insertSpacesAroundEquals()
   {
      return bool(
         "insert_spaces_around_equals",
         _constants.insertSpacesAroundEqualsTitle(), 
         _constants.insertSpacesAroundEqualsDescription(), 
         true);
   }

   /**
    * Whether to insert parentheses after function completions.
    */
   public PrefValue<Boolean> insertParensAfterFunctionCompletion()
   {
      return bool(
         "insert_parens_after_function_completion",
         _constants.insertParensAfterFunctionCompletionTitle(), 
         _constants.insertParensAfterFunctionCompletionDescription(), 
         true);
   }

   /**
    * Whether to attempt completion of multiple-line statements when pressing Tab.
    */
   public PrefValue<Boolean> tabMultilineCompletion()
   {
      return bool(
         "tab_multiline_completion",
         _constants.tabMultilineCompletionTitle(), 
         _constants.tabMultilineCompletionDescription(), 
         false);
   }

   /**
    * Whether to attempt completion of statements when pressing Tab.
    */
   public PrefValue<Boolean> tabCompletion()
   {
      return bool(
         "tab_completion",
         _constants.tabCompletionTitle(), 
         _constants.tabCompletionDescription(), 
         true);
   }

   /**
    * Whether to show help tooltips for functions when the cursor has not been recently moved.
    */
   public PrefValue<Boolean> showHelpTooltipOnIdle()
   {
      return bool(
         "show_help_tooltip_on_idle",
         _constants.showHelpTooltipOnIdleTitle(), 
         _constants.showHelpTooltipOnIdleDescription(), 
         false);
   }

   /**
    * Which kinds of delimiters can be used to surround the current selection.
    */
   public PrefValue<String> surroundSelection()
   {
      return enumeration(
         "surround_selection",
         _constants.surroundSelectionTitle(), 
         _constants.surroundSelectionDescription(), 
         new String[] {
            SURROUND_SELECTION_NEVER,
            SURROUND_SELECTION_QUOTES,
            SURROUND_SELECTION_QUOTES_AND_BRACKETS
         },
         "quotes_and_brackets",
         new String[] {
            _constants.surroundSelectionEnum_never(),
            _constants.surroundSelectionEnum_quotes(),
            _constants.surroundSelectionEnum_quotes_and_brackets()
         });
   }

   public final static String SURROUND_SELECTION_NEVER = "never";
   public final static String SURROUND_SELECTION_QUOTES = "quotes";
   public final static String SURROUND_SELECTION_QUOTES_AND_BRACKETS = "quotes_and_brackets";

   /**
    * Whether to enable code snippets in the RStudio code editor.
    */
   public PrefValue<Boolean> enableSnippets()
   {
      return bool(
         "enable_snippets",
         _constants.enableSnippetsTitle(), 
         _constants.enableSnippetsDescription(), 
         true);
   }

   /**
    * When to use auto-completion for R code in the RStudio code editor.
    */
   public PrefValue<String> codeCompletion()
   {
      return enumeration(
         "code_completion",
         _constants.codeCompletionTitle(), 
         _constants.codeCompletionDescription(), 
         new String[] {
            CODE_COMPLETION_ALWAYS,
            CODE_COMPLETION_NEVER,
            CODE_COMPLETION_TRIGGERED,
            CODE_COMPLETION_MANUAL
         },
         "always",
         new String[] {
            _constants.codeCompletionEnum_always(),
            _constants.codeCompletionEnum_never(),
            _constants.codeCompletionEnum_triggered(),
            _constants.codeCompletionEnum_manual()
         });
   }

   public final static String CODE_COMPLETION_ALWAYS = "always";
   public final static String CODE_COMPLETION_NEVER = "never";
   public final static String CODE_COMPLETION_TRIGGERED = "triggered";
   public final static String CODE_COMPLETION_MANUAL = "manual";

   /**
    * When to use auto-completion for other languages (such as JavaScript and SQL) in the RStudio code editor.
    */
   public PrefValue<String> codeCompletionOther()
   {
      return enumeration(
         "code_completion_other",
         _constants.codeCompletionOtherTitle(), 
         _constants.codeCompletionOtherDescription(), 
         new String[] {
            CODE_COMPLETION_OTHER_ALWAYS,
            CODE_COMPLETION_OTHER_TRIGGERED,
            CODE_COMPLETION_OTHER_MANUAL
         },
         "always",
         new String[] {
            _constants.codeCompletionOtherEnum_always(),
            _constants.codeCompletionOtherEnum_triggered(),
            _constants.codeCompletionOtherEnum_manual()
         });
   }

   public final static String CODE_COMPLETION_OTHER_ALWAYS = "always";
   public final static String CODE_COMPLETION_OTHER_TRIGGERED = "triggered";
   public final static String CODE_COMPLETION_OTHER_MANUAL = "manual";

   /**
    * Whether to always use code completion in the R console.
    */
   public PrefValue<Boolean> consoleCodeCompletion()
   {
      return bool(
         "console_code_completion",
         _constants.consoleCodeCompletionTitle(), 
         _constants.consoleCodeCompletionDescription(), 
         true);
   }

   /**
    * The number of milliseconds to wait before offering code suggestions.
    */
   public PrefValue<Integer> codeCompletionDelay()
   {
      return integer(
         "code_completion_delay",
         _constants.codeCompletionDelayTitle(), 
         _constants.codeCompletionDelayDescription(), 
         250);
   }

   /**
    * The number of characters in a symbol that can be entered before completions are offered.
    */
   public PrefValue<Integer> codeCompletionCharacters()
   {
      return integer(
         "code_completion_characters",
         _constants.codeCompletionCharactersTitle(), 
         _constants.codeCompletionCharactersDescription(), 
         3);
   }

   /**
    * Whether to show function signature tooltips during autocompletion.
    */
   public PrefValue<Boolean> showFunctionSignatureTooltips()
   {
      return bool(
         "show_function_signature_tooltips",
         _constants.showFunctionSignatureTooltipsTitle(), 
         _constants.showFunctionSignatureTooltipsDescription(), 
         true);
   }

   /**
    * Whether to show diagnostic messages (such as syntax and usage errors) for R code as you type.
    */
   public PrefValue<Boolean> showDiagnosticsR()
   {
      return bool(
         "show_diagnostics_r",
         _constants.showDiagnosticsRTitle(), 
         _constants.showDiagnosticsRDescription(), 
         true);
   }

   /**
    * Whether to show diagnostic messages for C++ code as you type.
    */
   public PrefValue<Boolean> showDiagnosticsCpp()
   {
      return bool(
         "show_diagnostics_cpp",
         _constants.showDiagnosticsCppTitle(), 
         _constants.showDiagnosticsCppDescription(), 
         true);
   }

   /**
    * Whether to show diagnostic messages for YAML code as you type.
    */
   public PrefValue<Boolean> showDiagnosticsYaml()
   {
      return bool(
         "show_diagnostics_yaml",
         _constants.showDiagnosticsYamlTitle(), 
         _constants.showDiagnosticsYamlDescription(), 
         true);
   }

   /**
    * Whether to show diagnostic messages for other types of code (not R, C++, or YAML).
    */
   public PrefValue<Boolean> showDiagnosticsOther()
   {
      return bool(
         "show_diagnostics_other",
         _constants.showDiagnosticsOtherTitle(), 
         _constants.showDiagnosticsOtherDescription(), 
         false);
   }

   /**
    * Whether to show style diagnostics (suggestions for improving R code style)
    */
   public PrefValue<Boolean> styleDiagnostics()
   {
      return bool(
         "style_diagnostics",
         _constants.styleDiagnosticsTitle(), 
         _constants.styleDiagnosticsDescription(), 
         false);
   }

   /**
    * Whether to check code for problems after saving it.
    */
   public PrefValue<Boolean> diagnosticsOnSave()
   {
      return bool(
         "diagnostics_on_save",
         _constants.diagnosticsOnSaveTitle(), 
         _constants.diagnosticsOnSaveDescription(), 
         true);
   }

   /**
    * Whether to run code diagnostics in the background, as you type.
    */
   public PrefValue<Boolean> backgroundDiagnostics()
   {
      return bool(
         "background_diagnostics",
         _constants.backgroundDiagnosticsTitle(), 
         _constants.backgroundDiagnosticsDescription(), 
         true);
   }

   /**
    * The number of milliseconds to delay before running code diagnostics in the background.
    */
   public PrefValue<Integer> backgroundDiagnosticsDelayMs()
   {
      return integer(
         "background_diagnostics_delay_ms",
         _constants.backgroundDiagnosticsDelayMsTitle(), 
         _constants.backgroundDiagnosticsDelayMsDescription(), 
         2000);
   }

   /**
    * Whether to run diagnostics in R function calls.
    */
   public PrefValue<Boolean> diagnosticsInRFunctionCalls()
   {
      return bool(
         "diagnostics_in_r_function_calls",
         _constants.diagnosticsInRFunctionCallsTitle(), 
         _constants.diagnosticsInRFunctionCallsDescription(), 
         true);
   }

   /**
    * Whether to check arguments to R function calls.
    */
   public PrefValue<Boolean> checkArgumentsToRFunctionCalls()
   {
      return bool(
         "check_arguments_to_r_function_calls",
         _constants.checkArgumentsToRFunctionCallsTitle(), 
         _constants.checkArgumentsToRFunctionCallsDescription(), 
         false);
   }

   /**
    * Whether to check for unexpected variable assignments inside R function calls.
    */
   public PrefValue<Boolean> checkUnexpectedAssignmentInFunctionCall()
   {
      return bool(
         "check_unexpected_assignment_in_function_call",
         _constants.checkUnexpectedAssignmentInFunctionCallTitle(), 
         _constants.checkUnexpectedAssignmentInFunctionCallDescription(), 
         false);
   }

   /**
    * Whether to generate a warning if a variable is used without being defined in the current scope.
    */
   public PrefValue<Boolean> warnIfNoSuchVariableInScope()
   {
      return bool(
         "warn_if_no_such_variable_in_scope",
         _constants.warnIfNoSuchVariableInScopeTitle(), 
         _constants.warnIfNoSuchVariableInScopeDescription(), 
         false);
   }

   /**
    * Whether to generate a warning if a variable is defined without being used in the current scope
    */
   public PrefValue<Boolean> warnVariableDefinedButNotUsed()
   {
      return bool(
         "warn_variable_defined_but_not_used",
         _constants.warnVariableDefinedButNotUsedTitle(), 
         _constants.warnVariableDefinedButNotUsedDescription(), 
         false);
   }

   /**
    * Whether to automatically discover and offer to install missing R package dependencies.
    */
   public PrefValue<Boolean> autoDiscoverPackageDependencies()
   {
      return bool(
         "auto_discover_package_dependencies",
         _constants.autoDiscoverPackageDependenciesTitle(), 
         _constants.autoDiscoverPackageDependenciesDescription(), 
         true);
   }

   /**
    * Whether to ensure that source files end with a newline character.
    */
   public PrefValue<Boolean> autoAppendNewline()
   {
      return bool(
         "auto_append_newline",
         _constants.autoAppendNewlineTitle(), 
         _constants.autoAppendNewlineDescription(), 
         false);
   }

   /**
    * Whether to strip trailing whitespace from each line when saving.
    */
   public PrefValue<Boolean> stripTrailingWhitespace()
   {
      return bool(
         "strip_trailing_whitespace",
         _constants.stripTrailingWhitespaceTitle(), 
         _constants.stripTrailingWhitespaceDescription(), 
         false);
   }

   /**
    * Whether to save the position of the cursor when a file is closed, restore it when the file is opened.
    */
   public PrefValue<Boolean> restoreSourceDocumentCursorPosition()
   {
      return bool(
         "restore_source_document_cursor_position",
         _constants.restoreSourceDocumentCursorPositionTitle(), 
         _constants.restoreSourceDocumentCursorPositionDescription(), 
         true);
   }

   /**
    * Whether to automatically re-indent code when it's pasted into RStudio.
    */
   public PrefValue<Boolean> reindentOnPaste()
   {
      return bool(
         "reindent_on_paste",
         _constants.reindentOnPasteTitle(), 
         _constants.reindentOnPasteDescription(), 
         true);
   }

   /**
    * Whether to vertically align arguments to R function calls during automatic indentation.
    */
   public PrefValue<Boolean> verticallyAlignArgumentsIndent()
   {
      return bool(
         "vertically_align_arguments_indent",
         _constants.verticallyAlignArgumentsIndentTitle(), 
         _constants.verticallyAlignArgumentsIndentDescription(), 
         true);
   }

   /**
    * Whether to soft-wrap R source files, wrapping the text for display without inserting newline characters.
    */
   public PrefValue<Boolean> softWrapRFiles()
   {
      return bool(
         "soft_wrap_r_files",
         _constants.softWrapRFilesTitle(), 
         _constants.softWrapRFilesDescription(), 
         false);
   }

   /**
    * Whether to soft-wrap R Markdown files (and similar types such as R HTML and R Notebooks)
    */
   public PrefValue<Boolean> softWrapRmdFiles()
   {
      return bool(
         "soft_wrap_rmd_files",
         _constants.softWrapRmdFilesTitle(), 
         _constants.softWrapRmdFilesDescription(), 
         true);
   }

   /**
    * Whether to focus the R console after executing an R command from a script.
    */
   public PrefValue<Boolean> focusConsoleAfterExec()
   {
      return bool(
         "focus_console_after_exec",
         _constants.focusConsoleAfterExecTitle(), 
         _constants.focusConsoleAfterExecDescription(), 
         false);
   }

   /**
    * The style of folding to use.
    */
   public PrefValue<String> foldStyle()
   {
      return enumeration(
         "fold_style",
         _constants.foldStyleTitle(), 
         _constants.foldStyleDescription(), 
         new String[] {
            FOLD_STYLE_BEGIN_ONLY,
            FOLD_STYLE_BEGIN_AND_END
         },
         "begin-and-end",
         new String[] {
            _constants.foldStyleEnum_begin_only(),
            _constants.foldStyleEnum_begin_and_end()
         });
   }

   public final static String FOLD_STYLE_BEGIN_ONLY = "begin-only";
   public final static String FOLD_STYLE_BEGIN_AND_END = "begin-and-end";

   /**
    * Whether to automatically save scripts before executing them.
    */
   public PrefValue<Boolean> saveBeforeSourcing()
   {
      return bool(
         "save_before_sourcing",
         _constants.saveBeforeSourcingTitle(), 
         _constants.saveBeforeSourcingDescription(), 
         true);
   }

   /**
    * Whether to use syntax highlighting in the R console.
    */
   public PrefValue<Boolean> syntaxColorConsole()
   {
      return bool(
         "syntax_color_console",
         _constants.syntaxColorConsoleTitle(), 
         _constants.syntaxColorConsoleDescription(), 
         false);
   }

   /**
    * Whether to display error, warning, and message output in a different color.
    */
   public PrefValue<Boolean> highlightConsoleErrors()
   {
      return bool(
         "highlight_console_errors",
         _constants.highlightConsoleErrorsTitle(), 
         _constants.highlightConsoleErrorsDescription(), 
         true);
   }

   /**
    * Whether to allow scrolling past the end of a file.
    */
   public PrefValue<Boolean> scrollPastEndOfDocument()
   {
      return bool(
         "scroll_past_end_of_document",
         _constants.scrollPastEndOfDocumentTitle(), 
         _constants.scrollPastEndOfDocumentDescription(), 
         false);
   }

   /**
    * Whether to highlight R function calls in the code editor.
    */
   public PrefValue<Boolean> highlightRFunctionCalls()
   {
      return bool(
         "highlight_r_function_calls",
         _constants.highlightRFunctionCallsTitle(), 
         _constants.highlightRFunctionCallsDescription(), 
         false);
   }

   /**
    * Whether to highlight parentheses in a variety of colors.
    */
   public PrefValue<Boolean> rainbowParentheses()
   {
      return bool(
         "rainbow_parentheses",
         _constants.rainbowParenthesesTitle(), 
         _constants.rainbowParenthesesDescription(), 
         false);
   }

   /**
    * The maximum number of characters to display in a single line in the R console.
    */
   public PrefValue<Integer> consoleLineLengthLimit()
   {
      return integer(
         "console_line_length_limit",
         _constants.consoleLineLengthLimitTitle(), 
         _constants.consoleLineLengthLimitDescription(), 
         1000);
   }

   /**
    * The maximum number of console actions to store and display in the console scrollback buffer.
    */
   public PrefValue<Integer> consoleMaxLines()
   {
      return integer(
         "console_max_lines",
         _constants.consoleMaxLinesTitle(), 
         _constants.consoleMaxLinesDescription(), 
         1000);
   }

   /**
    * How to treat ANSI escape codes in the console.
    */
   public PrefValue<String> ansiConsoleMode()
   {
      return enumeration(
         "ansi_console_mode",
         _constants.ansiConsoleModeTitle(), 
         _constants.ansiConsoleModeDescription(), 
         new String[] {
            ANSI_CONSOLE_MODE_OFF,
            ANSI_CONSOLE_MODE_ON,
            ANSI_CONSOLE_MODE_STRIP
         },
         "on");
   }

   public final static String ANSI_CONSOLE_MODE_OFF = "off";
   public final static String ANSI_CONSOLE_MODE_ON = "on";
   public final static String ANSI_CONSOLE_MODE_STRIP = "strip";

   /**
    * Whether to only show a limited window of the total console output
    */
   public PrefValue<Boolean> limitVisibleConsole()
   {
      return bool(
         "limit_visible_console",
         _constants.limitVisibleConsoleTitle(), 
         _constants.limitVisibleConsoleDescription(), 
         false);
   }

   /**
    * Whether to show a toolbar on code chunks in R Markdown documents.
    */
   public PrefValue<Boolean> showInlineToolbarForRCodeChunks()
   {
      return bool(
         "show_inline_toolbar_for_r_code_chunks",
         _constants.showInlineToolbarForRCodeChunksTitle(), 
         _constants.showInlineToolbarForRCodeChunksDescription(), 
         true);
   }

   /**
    * Whether to highlight code chunks in R Markdown documents with a different background color.
    */
   public PrefValue<Boolean> highlightCodeChunks()
   {
      return bool(
         "highlight_code_chunks",
         _constants.highlightCodeChunksTitle(), 
         _constants.highlightCodeChunksDescription(), 
         true);
   }

   /**
    * Whether to save all open, unsaved files before building the project.
    */
   public PrefValue<Boolean> saveFilesBeforeBuild()
   {
      return bool(
         "save_files_before_build",
         _constants.saveFilesBeforeBuildTitle(), 
         _constants.saveFilesBeforeBuildDescription(), 
         false);
   }

   /**
    * The default editor font size, in points.
    */
   public PrefValue<Double> fontSizePoints()
   {
      return dbl(
         "font_size_points",
         _constants.fontSizePointsTitle(), 
         _constants.fontSizePointsDescription(), 
         10.0);
   }

   /**
    * The help panel font size, in points.
    */
   public PrefValue<Double> helpFontSizePoints()
   {
      return dbl(
         "help_font_size_points",
         _constants.helpFontSizePointsTitle(), 
         _constants.helpFontSizePointsDescription(), 
         10.0);
   }

   /**
    * The name of the color theme to apply to the text editor in RStudio.
    */
   public PrefValue<String> editorTheme()
   {
      return string(
         "editor_theme",
         _constants.editorThemeTitle(), 
         _constants.editorThemeDescription(), 
         "Textmate (default)");
   }

   /**
    * Whether to use a custom editor font in RStudio Server.
    */
   public PrefValue<Boolean> serverEditorFontEnabled()
   {
      return bool(
         "server_editor_font_enabled",
         _constants.serverEditorFontEnabledTitle(), 
         _constants.serverEditorFontEnabledDescription(), 
         false);
   }

   /**
    * The name of the fixed-width editor font to use with RStudio Server.
    */
   public PrefValue<String> serverEditorFont()
   {
      return string(
         "server_editor_font",
         _constants.serverEditorFontTitle(), 
         _constants.serverEditorFontDescription(), 
         "");
   }

   /**
    * The default character encoding to use when saving files.
    */
   public PrefValue<String> defaultEncoding()
   {
      return string(
         "default_encoding",
         _constants.defaultEncodingTitle(), 
         _constants.defaultEncodingDescription(), 
         "");
   }

   /**
    * Whether to show the toolbar at the top of the RStudio workbench.
    */
   public PrefValue<Boolean> toolbarVisible()
   {
      return bool(
         "toolbar_visible",
         _constants.toolbarVisibleTitle(), 
         _constants.toolbarVisibleDescription(), 
         true);
   }

   /**
    * The directory path under which to place new projects by default.
    */
   public PrefValue<String> defaultProjectLocation()
   {
      return string(
         "default_project_location",
         _constants.defaultProjectLocationTitle(), 
         _constants.defaultProjectLocationDescription(), 
         "");
   }

   /**
    * Whether to echo R code when sourcing it.
    */
   public PrefValue<Boolean> sourceWithEcho()
   {
      return bool(
         "source_with_echo",
         _constants.sourceWithEchoTitle(), 
         _constants.sourceWithEchoDescription(), 
         false);
   }

   /**
    * The default engine to use when processing Sweave documents.
    */
   public PrefValue<String> defaultSweaveEngine()
   {
      return string(
         "default_sweave_engine",
         _constants.defaultSweaveEngineTitle(), 
         _constants.defaultSweaveEngineDescription(), 
         "Sweave");
   }

   /**
    * The default program to use when processing LaTeX documents.
    */
   public PrefValue<String> defaultLatexProgram()
   {
      return string(
         "default_latex_program",
         _constants.defaultLatexProgramTitle(), 
         _constants.defaultLatexProgramDescription(), 
         "pdfLaTeX");
   }

   /**
    * Whether to use Roxygen for documentation.
    */
   public PrefValue<Boolean> useRoxygen()
   {
      return bool(
         "use_roxygen",
         _constants.useRoxygenTitle(), 
         _constants.useRoxygenDescription(), 
         false);
   }

   /**
    * Whether to use RStudio's data import feature.
    */
   public PrefValue<Boolean> useDataimport()
   {
      return bool(
         "use_dataimport",
         _constants.useDataimportTitle(), 
         _constants.useDataimportDescription(), 
         true);
   }

   /**
    * The program to use to preview PDF files after generation.
    */
   public PrefValue<String> pdfPreviewer()
   {
      return enumeration(
         "pdf_previewer",
         _constants.pdfPreviewerTitle(), 
         _constants.pdfPreviewerDescription(), 
         new String[] {
            PDF_PREVIEWER_NONE,
            PDF_PREVIEWER_DEFAULT,
            PDF_PREVIEWER_RSTUDIO,
            PDF_PREVIEWER_DESKTOP_SYNCTEX,
            PDF_PREVIEWER_SYSTEM
         },
         "default");
   }

   public final static String PDF_PREVIEWER_NONE = "none";
   public final static String PDF_PREVIEWER_DEFAULT = "default";
   public final static String PDF_PREVIEWER_RSTUDIO = "rstudio";
   public final static String PDF_PREVIEWER_DESKTOP_SYNCTEX = "desktop-synctex";
   public final static String PDF_PREVIEWER_SYSTEM = "system";

   /**
    * Whether to always enable the concordance for RNW files.
    */
   public PrefValue<Boolean> alwaysEnableRnwConcordance()
   {
      return bool(
         "always_enable_rnw_concordance",
         _constants.alwaysEnableRnwConcordanceTitle(), 
         _constants.alwaysEnableRnwConcordanceDescription(), 
         true);
   }

   /**
    * Whether to insert numbered sections in LaTeX.
    */
   public PrefValue<Boolean> insertNumberedLatexSections()
   {
      return bool(
         "insert_numbered_latex_sections",
         _constants.insertNumberedLatexSectionsTitle(), 
         _constants.insertNumberedLatexSectionsDescription(), 
         false);
   }

   /**
    * The language of the spelling dictionary to use for spell checking.
    */
   public PrefValue<String> spellingDictionaryLanguage()
   {
      return string(
         "spelling_dictionary_language",
         _constants.spellingDictionaryLanguageTitle(), 
         _constants.spellingDictionaryLanguageDescription(), 
         "en_US");
   }

   /**
    * The list of custom dictionaries to use when spell checking.
    */
   public PrefValue<JsArrayString> spellingCustomDictionaries()
   {
      return object(
         "spelling_custom_dictionaries",
         _constants.spellingCustomDictionariesTitle(), 
         _constants.spellingCustomDictionariesDescription(), 
         JsArrayUtil.createStringArray());
   }

   /**
    * The number of milliseconds to wait before linting a document after it is loaded.
    */
   public PrefValue<Integer> documentLoadLintDelay()
   {
      return integer(
         "document_load_lint_delay",
         _constants.documentLoadLintDelayTitle(), 
         _constants.documentLoadLintDelayDescription(), 
         5000);
   }

   /**
    * Whether to ignore words in uppercase when spell checking.
    */
   public PrefValue<Boolean> ignoreUppercaseWords()
   {
      return bool(
         "ignore_uppercase_words",
         _constants.ignoreUppercaseWordsTitle(), 
         _constants.ignoreUppercaseWordsDescription(), 
         true);
   }

   /**
    * Whether to ignore words with numbers in them when spell checking.
    */
   public PrefValue<Boolean> ignoreWordsWithNumbers()
   {
      return bool(
         "ignore_words_with_numbers",
         _constants.ignoreWordsWithNumbersTitle(), 
         _constants.ignoreWordsWithNumbersDescription(), 
         true);
   }

   /**
    * Whether to enable real-time spellchecking by default.
    */
   public PrefValue<Boolean> realTimeSpellchecking()
   {
      return bool(
         "real_time_spellchecking",
         _constants.realTimeSpellcheckingTitle(), 
         _constants.realTimeSpellcheckingDescription(), 
         true);
   }

   /**
    * Whether to navigate to build errors.
    */
   public PrefValue<Boolean> navigateToBuildError()
   {
      return bool(
         "navigate_to_build_error",
         _constants.navigateToBuildErrorTitle(), 
         _constants.navigateToBuildErrorDescription(), 
         true);
   }

   /**
    * Whether to enable RStudio's Packages pane.
    */
   public PrefValue<Boolean> packagesPaneEnabled()
   {
      return bool(
         "packages_pane_enabled",
         _constants.packagesPaneEnabledTitle(), 
         _constants.packagesPaneEnabledDescription(), 
         true);
   }

   /**
    * C++ template.
    */
   public PrefValue<String> cppTemplate()
   {
      return string(
         "cpp_template",
         _constants.cppTemplateTitle(), 
         _constants.cppTemplateDescription(), 
         "Rcpp");
   }

   /**
    * Whether to restore the last opened source documents when RStudio starts up.
    */
   public PrefValue<Boolean> restoreSourceDocuments()
   {
      return bool(
         "restore_source_documents",
         _constants.restoreSourceDocumentsTitle(), 
         _constants.restoreSourceDocumentsDescription(), 
         true);
   }

   /**
    * Whether to handle errors only when user code is on the stack.
    */
   public PrefValue<Boolean> handleErrorsInUserCodeOnly()
   {
      return bool(
         "handle_errors_in_user_code_only",
         _constants.handleErrorsInUserCodeOnlyTitle(), 
         _constants.handleErrorsInUserCodeOnlyDescription(), 
         true);
   }

   /**
    * Whether to automatically expand tracebacks when an error occurs.
    */
   public PrefValue<Boolean> autoExpandErrorTracebacks()
   {
      return bool(
         "auto_expand_error_tracebacks",
         _constants.autoExpandErrorTracebacksTitle(), 
         _constants.autoExpandErrorTracebacksDescription(), 
         false);
   }

   /**
    * Whether to check for new versions of RStudio when RStudio starts.
    */
   public PrefValue<Boolean> checkForUpdates()
   {
      return bool(
         "check_for_updates",
         _constants.checkForUpdatesTitle(), 
         _constants.checkForUpdatesDescription(), 
         true);
   }

   /**
    * Whether to show functions without source references in the Traceback pane while debugging.
    */
   public PrefValue<Boolean> showInternalFunctions()
   {
      return bool(
         "show_internal_functions",
         _constants.showInternalFunctionsTitle(), 
         _constants.showInternalFunctionsDescription(), 
         false);
   }

   /**
    * Where to display Shiny applications when they are run.
    */
   public PrefValue<String> shinyViewerType()
   {
      return enumeration(
         "shiny_viewer_type",
         _constants.shinyViewerTypeTitle(), 
         _constants.shinyViewerTypeDescription(), 
         new String[] {
            SHINY_VIEWER_TYPE_USER,
            SHINY_VIEWER_TYPE_NONE,
            SHINY_VIEWER_TYPE_PANE,
            SHINY_VIEWER_TYPE_WINDOW,
            SHINY_VIEWER_TYPE_BROWSER
         },
         "window");
   }

   public final static String SHINY_VIEWER_TYPE_USER = "user";
   public final static String SHINY_VIEWER_TYPE_NONE = "none";
   public final static String SHINY_VIEWER_TYPE_PANE = "pane";
   public final static String SHINY_VIEWER_TYPE_WINDOW = "window";
   public final static String SHINY_VIEWER_TYPE_BROWSER = "browser";

   /**
    * Whether to run Shiny applications as background jobs.
    */
   public PrefValue<Boolean> shinyBackgroundJobs()
   {
      return bool(
         "shiny_background_jobs",
         _constants.shinyBackgroundJobsTitle(), 
         _constants.shinyBackgroundJobsDescription(), 
         false);
   }

   /**
    * Where to display Shiny applications when they are run.
    */
   public PrefValue<String> plumberViewerType()
   {
      return enumeration(
         "plumber_viewer_type",
         _constants.plumberViewerTypeTitle(), 
         _constants.plumberViewerTypeDescription(), 
         new String[] {
            PLUMBER_VIEWER_TYPE_USER,
            PLUMBER_VIEWER_TYPE_NONE,
            PLUMBER_VIEWER_TYPE_PANE,
            PLUMBER_VIEWER_TYPE_WINDOW,
            PLUMBER_VIEWER_TYPE_BROWSER
         },
         "window");
   }

   public final static String PLUMBER_VIEWER_TYPE_USER = "user";
   public final static String PLUMBER_VIEWER_TYPE_NONE = "none";
   public final static String PLUMBER_VIEWER_TYPE_PANE = "pane";
   public final static String PLUMBER_VIEWER_TYPE_WINDOW = "window";
   public final static String PLUMBER_VIEWER_TYPE_BROWSER = "browser";

   /**
    * The default name to use as the document author when creating new documents.
    */
   public PrefValue<String> documentAuthor()
   {
      return string(
         "document_author",
         _constants.documentAuthorTitle(), 
         _constants.documentAuthorDescription(), 
         "");
   }

   /**
    * Use current date when rendering document
    */
   public PrefValue<Boolean> rmdAutoDate()
   {
      return bool(
         "rmd_auto_date",
         _constants.rmdAutoDateTitle(), 
         _constants.rmdAutoDateDescription(), 
         false);
   }

   /**
    * The path to the preferred R Markdown template.
    */
   public PrefValue<String> rmdPreferredTemplatePath()
   {
      return string(
         "rmd_preferred_template_path",
         _constants.rmdPreferredTemplatePathTitle(), 
         _constants.rmdPreferredTemplatePathDescription(), 
         "");
   }

   /**
    * Where to display R Markdown documents when they have completed rendering.
    */
   public PrefValue<String> rmdViewerType()
   {
      return enumeration(
         "rmd_viewer_type",
         _constants.rmdViewerTypeTitle(), 
         _constants.rmdViewerTypeDescription(), 
         new String[] {
            RMD_VIEWER_TYPE_WINDOW,
            RMD_VIEWER_TYPE_PANE,
            RMD_VIEWER_TYPE_NONE
         },
         "window");
   }

   public final static String RMD_VIEWER_TYPE_WINDOW = "window";
   public final static String RMD_VIEWER_TYPE_PANE = "pane";
   public final static String RMD_VIEWER_TYPE_NONE = "none";

   /**
    * Whether to show verbose diagnostic information when publishing content.
    */
   public PrefValue<Boolean> showPublishDiagnostics()
   {
      return bool(
         "show_publish_diagnostics",
         _constants.showPublishDiagnosticsTitle(), 
         _constants.showPublishDiagnosticsDescription(), 
         false);
   }

   /**
    * Whether to check remote server SSL certificates when publishing content.
    */
   public PrefValue<Boolean> publishCheckCertificates()
   {
      return bool(
         "publish_check_certificates",
         _constants.publishCheckCertificatesTitle(), 
         _constants.publishCheckCertificatesDescription(), 
         true);
   }

   /**
    * Whether to use a custom certificate authority (CA) bundle when publishing content.
    */
   public PrefValue<Boolean> usePublishCaBundle()
   {
      return bool(
         "use_publish_ca_bundle",
         _constants.usePublishCaBundleTitle(), 
         _constants.usePublishCaBundleDescription(), 
         false);
   }

   /**
    * The path to the custom certificate authority (CA) bundle to use when publishing content.
    */
   public PrefValue<String> publishCaBundle()
   {
      return string(
         "publish_ca_bundle",
         _constants.publishCaBundleTitle(), 
         _constants.publishCaBundleDescription(), 
         "");
   }

   /**
    * Whether to show chunk output inline for ordinary R Markdown documents.
    */
   public PrefValue<Boolean> rmdChunkOutputInline()
   {
      return bool(
         "rmd_chunk_output_inline",
         _constants.rmdChunkOutputInlineTitle(), 
         _constants.rmdChunkOutputInlineDescription(), 
         true);
   }

   /**
    * Whether to show the document outline by default when opening R Markdown documents.
    */
   public PrefValue<Boolean> showDocOutlineRmd()
   {
      return bool(
         "show_doc_outline_rmd",
         _constants.showDocOutlineRmdTitle(), 
         _constants.showDocOutlineRmdDescription(), 
         false);
   }

   /**
    * Whether to automatically run an R Markdown document's Setup chunk before running other chunks.
    */
   public PrefValue<Boolean> autoRunSetupChunk()
   {
      return bool(
         "auto_run_setup_chunk",
         _constants.autoRunSetupChunkTitle(), 
         _constants.autoRunSetupChunkDescription(), 
         true);
   }

   /**
    * Whether to hide the R console when executing inline R Markdown chunks.
    */
   public PrefValue<Boolean> hideConsoleOnChunkExecute()
   {
      return bool(
         "hide_console_on_chunk_execute",
         _constants.hideConsoleOnChunkExecuteTitle(), 
         _constants.hideConsoleOnChunkExecuteDescription(), 
         true);
   }

   /**
    * The unit of R code to execute when the Execute command is invoked.
    */
   public PrefValue<String> executionBehavior()
   {
      return enumeration(
         "execution_behavior",
         _constants.executionBehaviorTitle(), 
         _constants.executionBehaviorDescription(), 
         new String[] {
            EXECUTION_BEHAVIOR_LINE,
            EXECUTION_BEHAVIOR_STATEMENT,
            EXECUTION_BEHAVIOR_PARAGRAPH
         },
         "statement",
         new String[] {
            _constants.executionBehaviorEnum_line(),
            _constants.executionBehaviorEnum_statement(),
            _constants.executionBehaviorEnum_paragraph()
         });
   }

   public final static String EXECUTION_BEHAVIOR_LINE = "line";
   public final static String EXECUTION_BEHAVIOR_STATEMENT = "statement";
   public final static String EXECUTION_BEHAVIOR_PARAGRAPH = "paragraph";

   /**
    * Whether to show the Terminal tab.
    */
   public PrefValue<Boolean> showTerminalTab()
   {
      return bool(
         "show_terminal_tab",
         _constants.showTerminalTabTitle(), 
         _constants.showTerminalTabDescription(), 
         true);
   }

   /**
    * Whether to use local echo in the Terminal.
    */
   public PrefValue<Boolean> terminalLocalEcho()
   {
      return bool(
         "terminal_local_echo",
         _constants.terminalLocalEchoTitle(), 
         _constants.terminalLocalEchoDescription(), 
         true);
   }

   /**
    * Whether to use websockets to communicate with the shell in the Terminal tab.
    */
   public PrefValue<Boolean> terminalWebsockets()
   {
      return bool(
         "terminal_websockets",
         _constants.terminalWebsocketsTitle(), 
         _constants.terminalWebsocketsDescription(), 
         true);
   }

   /**
    * Whether to close the terminal pane after the shell exits.
    */
   public PrefValue<String> terminalCloseBehavior()
   {
      return enumeration(
         "terminal_close_behavior",
         _constants.terminalCloseBehaviorTitle(), 
         _constants.terminalCloseBehaviorDescription(), 
         new String[] {
            TERMINAL_CLOSE_BEHAVIOR_ALWAYS,
            TERMINAL_CLOSE_BEHAVIOR_CLEAN,
            TERMINAL_CLOSE_BEHAVIOR_NEVER
         },
         "always");
   }

   public final static String TERMINAL_CLOSE_BEHAVIOR_ALWAYS = "always";
   public final static String TERMINAL_CLOSE_BEHAVIOR_CLEAN = "clean";
   public final static String TERMINAL_CLOSE_BEHAVIOR_NEVER = "never";

   /**
    * Whether to track and save changes to system environment variables in the Terminal.
    */
   public PrefValue<Boolean> terminalTrackEnvironment()
   {
      return bool(
         "terminal_track_environment",
         _constants.terminalTrackEnvironmentTitle(), 
         _constants.terminalTrackEnvironmentDescription(), 
         true);
   }

   /**
    * Terminal bell style
    */
   public PrefValue<String> terminalBellStyle()
   {
      return enumeration(
         "terminal_bell_style",
         _constants.terminalBellStyleTitle(), 
         _constants.terminalBellStyleDescription(), 
         new String[] {
            TERMINAL_BELL_STYLE_NONE,
            TERMINAL_BELL_STYLE_SOUND
         },
         "sound");
   }

   public final static String TERMINAL_BELL_STYLE_NONE = "none";
   public final static String TERMINAL_BELL_STYLE_SOUND = "sound";

   /**
    * Terminal rendering engine: canvas is faster, dom may be needed for some browsers or graphics cards
    */
   public PrefValue<String> terminalRenderer()
   {
      return enumeration(
         "terminal_renderer",
         _constants.terminalRendererTitle(), 
         _constants.terminalRendererDescription(), 
         new String[] {
            TERMINAL_RENDERER_CANVAS,
            TERMINAL_RENDERER_DOM
         },
         "canvas");
   }

   public final static String TERMINAL_RENDERER_CANVAS = "canvas";
   public final static String TERMINAL_RENDERER_DOM = "dom";

   /**
    * Whether web links displayed in the Terminal tab are made clickable.
    */
   public PrefValue<Boolean> terminalWeblinks()
   {
      return bool(
         "terminal_weblinks",
         _constants.terminalWeblinksTitle(), 
         _constants.terminalWeblinksDescription(), 
         true);
   }

   /**
    * Whether to print the render command use to knit R Markdown documents in the R Markdown tab.
    */
   public PrefValue<Boolean> showRmdRenderCommand()
   {
      return bool(
         "show_rmd_render_command",
         _constants.showRmdRenderCommandTitle(), 
         _constants.showRmdRenderCommandDescription(), 
         false);
   }

   /**
    * Whether to enable moving text on the editing surface by clicking and dragging it.
    */
   public PrefValue<Boolean> enableTextDrag()
   {
      return bool(
         "enable_text_drag",
         _constants.enableTextDragTitle(), 
         _constants.enableTextDragDescription(), 
         true);
   }

   /**
    * Whether to show hidden files in the Files pane.
    */
   public PrefValue<Boolean> showHiddenFiles()
   {
      return bool(
         "show_hidden_files",
         _constants.showHiddenFilesTitle(), 
         _constants.showHiddenFilesDescription(), 
         false);
   }

   /**
    * List of file names (case sensitive) that are always shown in the Files Pane, regardless of whether hidden files are shown
    */
   public PrefValue<JsArrayString> alwaysShownFiles()
   {
      return object(
         "always_shown_files",
         _constants.alwaysShownFilesTitle(), 
         _constants.alwaysShownFilesDescription(), 
         JsArrayUtil.createStringArray(".build.yml", ".gitlab-ci.yml", ".travis.yml"));
   }

   /**
    * List of file extensions (beginning with ., not case sensitive) that are always shown in the Files Pane, regardless of whether hidden files are shown
    */
   public PrefValue<JsArrayString> alwaysShownExtensions()
   {
      return object(
         "always_shown_extensions",
         _constants.alwaysShownExtensionsTitle(), 
         _constants.alwaysShownExtensionsDescription(), 
         JsArrayUtil.createStringArray(".circleci", ".gitattributes", ".github", ".gitignore", ".httr-oauth", ".r", ".rbuildignore", ".rdata", ".renvignore", ".renviron", ".rhistory", ".rprofile", ".ruserdata"));
   }

   /**
    * Whether to sort file names naturally, so that e.g., file10.R comes after file9.R
    */
   public PrefValue<Boolean> sortFileNamesNaturally()
   {
      return bool(
         "sort_file_names_naturally",
         _constants.sortFileNamesNaturallyTitle(), 
         _constants.sortFileNamesNaturallyDescription(), 
         true);
   }

   /**
    * Whether to change the directory in the Files pane automatically when the working directory in R changes.
    */
   public PrefValue<Boolean> syncFilesPaneWorkingDir()
   {
      return bool(
         "sync_files_pane_working_dir",
         _constants.syncFilesPaneWorkingDirTitle(), 
         _constants.syncFilesPaneWorkingDirDescription(), 
         false);
   }

   /**
    * The visibility of the Jobs tab.
    */
   public PrefValue<String> jobsTabVisibility()
   {
      return enumeration(
         "jobs_tab_visibility",
         _constants.jobsTabVisibilityTitle(), 
         _constants.jobsTabVisibilityDescription(), 
         new String[] {
            JOBS_TAB_VISIBILITY_CLOSED,
            JOBS_TAB_VISIBILITY_SHOWN,
            JOBS_TAB_VISIBILITY_DEFAULT
         },
         "default");
   }

   public final static String JOBS_TAB_VISIBILITY_CLOSED = "closed";
   public final static String JOBS_TAB_VISIBILITY_SHOWN = "shown";
   public final static String JOBS_TAB_VISIBILITY_DEFAULT = "default";

   /**
    * Whether to show the Launcher jobs tab in RStudio Pro and RStudio Workbench.
    */
   public PrefValue<Boolean> showLauncherJobsTab()
   {
      return bool(
         "show_launcher_jobs_tab",
         _constants.showLauncherJobsTabTitle(), 
         _constants.showLauncherJobsTabDescription(), 
         true);
   }

   /**
    * How to sort jobs in the Launcher tab in RStudio Pro and RStudio Workbench.
    */
   public PrefValue<String> launcherJobsSort()
   {
      return enumeration(
         "launcher_jobs_sort",
         _constants.launcherJobsSortTitle(), 
         _constants.launcherJobsSortDescription(), 
         new String[] {
            LAUNCHER_JOBS_SORT_RECORDED,
            LAUNCHER_JOBS_SORT_STATE
         },
         "recorded");
   }

   public final static String LAUNCHER_JOBS_SORT_RECORDED = "recorded";
   public final static String LAUNCHER_JOBS_SORT_STATE = "state";

   /**
    * How to detect busy status in the Terminal.
    */
   public PrefValue<String> busyDetection()
   {
      return enumeration(
         "busy_detection",
         _constants.busyDetectionTitle(), 
         _constants.busyDetectionDescription(), 
         new String[] {
            BUSY_DETECTION_ALWAYS,
            BUSY_DETECTION_NEVER,
            BUSY_DETECTION_LIST
         },
         "always");
   }

   public final static String BUSY_DETECTION_ALWAYS = "always";
   public final static String BUSY_DETECTION_NEVER = "never";
   public final static String BUSY_DETECTION_LIST = "list";

   /**
    * A list of apps that should not be considered busy in the Terminal.
    */
   public PrefValue<JsArrayString> busyExclusionList()
   {
      return object(
         "busy_exclusion_list",
         _constants.busyExclusionListTitle(), 
         _constants.busyExclusionListDescription(), 
         JsArrayUtil.createStringArray("tmux", "screen"));
   }

   /**
    * The working directory to use when knitting R Markdown documents.
    */
   public PrefValue<String> knitWorkingDir()
   {
      return enumeration(
         "knit_working_dir",
         _constants.knitWorkingDirTitle(), 
         _constants.knitWorkingDirDescription(), 
         new String[] {
            KNIT_WORKING_DIR_DEFAULT,
            KNIT_WORKING_DIR_CURRENT,
            KNIT_WORKING_DIR_PROJECT
         },
         "default");
   }

   public final static String KNIT_WORKING_DIR_DEFAULT = "default";
   public final static String KNIT_WORKING_DIR_CURRENT = "current";
   public final static String KNIT_WORKING_DIR_PROJECT = "project";

   /**
    * Which objects to show in the document outline pane.
    */
   public PrefValue<String> docOutlineShow()
   {
      return enumeration(
         "doc_outline_show",
         _constants.docOutlineShowTitle(), 
         _constants.docOutlineShowDescription(), 
         new String[] {
            DOC_OUTLINE_SHOW_SECTIONS_ONLY,
            DOC_OUTLINE_SHOW_SECTIONS_AND_CHUNKS,
            DOC_OUTLINE_SHOW_ALL
         },
         "sections_only");
   }

   public final static String DOC_OUTLINE_SHOW_SECTIONS_ONLY = "sections_only";
   public final static String DOC_OUTLINE_SHOW_SECTIONS_AND_CHUNKS = "sections_and_chunks";
   public final static String DOC_OUTLINE_SHOW_ALL = "all";

   /**
    * When to preview LaTeX mathematical equations when cursor has not moved recently.
    */
   public PrefValue<String> latexPreviewOnCursorIdle()
   {
      return enumeration(
         "latex_preview_on_cursor_idle",
         _constants.latexPreviewOnCursorIdleTitle(), 
         _constants.latexPreviewOnCursorIdleDescription(), 
         new String[] {
            LATEX_PREVIEW_ON_CURSOR_IDLE_NEVER,
            LATEX_PREVIEW_ON_CURSOR_IDLE_INLINE_ONLY,
            LATEX_PREVIEW_ON_CURSOR_IDLE_ALWAYS
         },
         "always");
   }

   public final static String LATEX_PREVIEW_ON_CURSOR_IDLE_NEVER = "never";
   public final static String LATEX_PREVIEW_ON_CURSOR_IDLE_INLINE_ONLY = "inline_only";
   public final static String LATEX_PREVIEW_ON_CURSOR_IDLE_ALWAYS = "always";

   /**
    * Whether to wrap around when going to the previous or next editor tab.
    */
   public PrefValue<Boolean> wrapTabNavigation()
   {
      return bool(
         "wrap_tab_navigation",
         _constants.wrapTabNavigationTitle(), 
         _constants.wrapTabNavigationDescription(), 
         true);
   }

   /**
    * The theme to use for the main RStudio user interface.
    */
   public PrefValue<String> globalTheme()
   {
      return enumeration(
         "global_theme",
         _constants.globalThemeTitle(), 
         _constants.globalThemeDescription(), 
         new String[] {
            GLOBAL_THEME_DEFAULT,
            GLOBAL_THEME_ALTERNATE
         },
         "default");
   }

   public final static String GLOBAL_THEME_DEFAULT = "default";
   public final static String GLOBAL_THEME_ALTERNATE = "alternate";

   /**
    * Whether to ignore whitespace when generating diffs of version controlled files.
    */
   public PrefValue<Boolean> gitDiffIgnoreWhitespace()
   {
      return bool(
         "git_diff_ignore_whitespace",
         _constants.gitDiffIgnoreWhitespaceTitle(), 
         _constants.gitDiffIgnoreWhitespaceDescription(), 
         false);
   }

   /**
    * Whether double-clicking should select a word in the Console pane.
    */
   public PrefValue<Boolean> consoleDoubleClickSelect()
   {
      return bool(
         "console_double_click_select",
         _constants.consoleDoubleClickSelectTitle(), 
         _constants.consoleDoubleClickSelectDescription(), 
         false);
   }

   /**
    * Whether the 'Auto Suspension Blocked' icon should appear in the R Console toolbar.
    */
   public PrefValue<Boolean> consoleSuspendBlockedNotice()
   {
      return bool(
         "console_suspend_blocked_notice",
         _constants.consoleSuspendBlockedNoticeTitle(), 
         _constants.consoleSuspendBlockedNoticeDescription(), 
         true);
   }

   /**
    * How long to wait before warning that automatic session suspension has been paused. Higher values for less frequent notices.
    */
   public PrefValue<Integer> consoleSuspendBlockedNoticeDelay()
   {
      return integer(
         "console_suspend_blocked_notice_delay",
         _constants.consoleSuspendBlockedNoticeDelayTitle(), 
         _constants.consoleSuspendBlockedNoticeDelayDescription(), 
         5);
   }

   /**
    * Whether a git repo should be initialized inside new projects by default.
    */
   public PrefValue<Boolean> newProjGitInit()
   {
      return bool(
         "new_proj_git_init",
         _constants.newProjGitInitTitle(), 
         _constants.newProjGitInitDescription(), 
         false);
   }

   /**
    * Whether an renv environment should be created inside new projects by default.
    */
   public PrefValue<Boolean> newProjUseRenv()
   {
      return bool(
         "new_proj_use_renv",
         _constants.newProjUseRenvTitle(), 
         _constants.newProjUseRenvDescription(), 
         false);
   }

   /**
    * The root document to use when compiling PDF documents.
    */
   public PrefValue<String> rootDocument()
   {
      return string(
         "root_document",
         _constants.rootDocumentTitle(), 
         _constants.rootDocumentDescription(), 
         "");
   }

   /**
    * When to show the server home page in RStudio Workbench.
    */
   public PrefValue<String> showUserHomePage()
   {
      return enumeration(
         "show_user_home_page",
         _constants.showUserHomePageTitle(), 
         _constants.showUserHomePageDescription(), 
         new String[] {
            SHOW_USER_HOME_PAGE_ALWAYS,
            SHOW_USER_HOME_PAGE_NEVER,
            SHOW_USER_HOME_PAGE_SESSIONS
         },
         "sessions");
   }

   public final static String SHOW_USER_HOME_PAGE_ALWAYS = "always";
   public final static String SHOW_USER_HOME_PAGE_NEVER = "never";
   public final static String SHOW_USER_HOME_PAGE_SESSIONS = "sessions";

   /**
    * Whether to reuse sessions when opening projects in RStudio Workbench.
    */
   public PrefValue<Boolean> reuseSessionsForProjectLinks()
   {
      return bool(
         "reuse_sessions_for_project_links",
         _constants.reuseSessionsForProjectLinksTitle(), 
         _constants.reuseSessionsForProjectLinksDescription(), 
         false);
   }

   /**
    * Whether to enable RStudio's version control system interface.
    */
   public PrefValue<Boolean> vcsEnabled()
   {
      return bool(
         "vcs_enabled",
         _constants.vcsEnabledTitle(), 
         _constants.vcsEnabledDescription(), 
         true);
   }

   /**
    * Automatically refresh VCS status?
    */
   public PrefValue<Boolean> vcsAutorefresh()
   {
      return bool(
         "vcs_autorefresh",
         _constants.vcsAutorefreshTitle(), 
         _constants.vcsAutorefreshDescription(), 
         true);
   }

   /**
    * The path to the Git executable to use.
    */
   public PrefValue<String> gitExePath()
   {
      return string(
         "git_exe_path",
         _constants.gitExePathTitle(), 
         _constants.gitExePathDescription(), 
         "");
   }

   /**
    * The path to the Subversion executable to use.
    */
   public PrefValue<String> svnExePath()
   {
      return string(
         "svn_exe_path",
         _constants.svnExePathTitle(), 
         _constants.svnExePathDescription(), 
         "");
   }

   /**
    * The path to the terminal executable to use.
    */
   public PrefValue<String> terminalPath()
   {
      return string(
         "terminal_path",
         _constants.terminalPathTitle(), 
         _constants.terminalPathDescription(), 
         "");
   }

   /**
    * The path to the RSA key file to use.
    */
   public PrefValue<String> rsaKeyPath()
   {
      return string(
         "rsa_key_path",
         _constants.rsaKeyPathTitle(), 
         _constants.rsaKeyPathDescription(), 
         "");
   }

   /**
    * Whether to use the devtools R package.
    */
   public PrefValue<Boolean> useDevtools()
   {
      return bool(
         "use_devtools",
         _constants.useDevtoolsTitle(), 
         _constants.useDevtoolsDescription(), 
         true);
   }

   /**
    * Whether to use Internet2 for networking on R for Windows.
    */
   public PrefValue<Boolean> useInternet2()
   {
      return bool(
         "use_internet2",
         _constants.useInternet2Title(), 
         _constants.useInternet2Description(), 
         true);
   }

   /**
    * Whether to use secure downloads when fetching R packages.
    */
   public PrefValue<Boolean> useSecureDownload()
   {
      return bool(
         "use_secure_download",
         _constants.useSecureDownloadTitle(), 
         _constants.useSecureDownloadDescription(), 
         true);
   }

   /**
    * Whether to clean up temporary files after running R CMD CHECK.
    */
   public PrefValue<Boolean> cleanupAfterRCmdCheck()
   {
      return bool(
         "cleanup_after_r_cmd_check",
         _constants.cleanupAfterRCmdCheckTitle(), 
         _constants.cleanupAfterRCmdCheckDescription(), 
         true);
   }

   /**
    * Whether to view the directory after running R CMD CHECK.
    */
   public PrefValue<Boolean> viewDirAfterRCmdCheck()
   {
      return bool(
         "view_dir_after_r_cmd_check",
         _constants.viewDirAfterRCmdCheckTitle(), 
         _constants.viewDirAfterRCmdCheckDescription(), 
         false);
   }

   /**
    * Whether to hide object files in the Files pane.
    */
   public PrefValue<Boolean> hideObjectFiles()
   {
      return bool(
         "hide_object_files",
         _constants.hideObjectFilesTitle(), 
         _constants.hideObjectFilesDescription(), 
         true);
   }

   /**
    * Whether to restore the last project when starting RStudio.
    */
   public PrefValue<Boolean> restoreLastProject()
   {
      return bool(
         "restore_last_project",
         _constants.restoreLastProjectTitle(), 
         _constants.restoreLastProjectDescription(), 
         true);
   }

   /**
    * The number of seconds after which a project is deemed to have successfully started.
    */
   public PrefValue<Integer> projectSafeStartupSeconds()
   {
      return integer(
         "project_safe_startup_seconds",
         _constants.projectSafeStartupSecondsTitle(), 
         _constants.projectSafeStartupSecondsDescription(), 
         30);
   }

   /**
    * Use tinytex to compile .tex files.
    */
   public PrefValue<Boolean> useTinytex()
   {
      return bool(
         "use_tinytex",
         _constants.useTinytexTitle(), 
         _constants.useTinytexDescription(), 
         false);
   }

   /**
    * Whether to clean output after running Texi2Dvi.
    */
   public PrefValue<Boolean> cleanTexi2dviOutput()
   {
      return bool(
         "clean_texi2dvi_output",
         _constants.cleanTexi2dviOutputTitle(), 
         _constants.cleanTexi2dviOutputDescription(), 
         true);
   }

   /**
    * Whether to enable shell escaping with LaTeX documents.
    */
   public PrefValue<Boolean> latexShellEscape()
   {
      return bool(
         "latex_shell_escape",
         _constants.latexShellEscapeTitle(), 
         _constants.latexShellEscapeDescription(), 
         false);
   }

   /**
    * Whether to restore the last version of R used by the project in RStudio Pro and RStudio Workbench.
    */
   public PrefValue<Boolean> restoreProjectRVersion()
   {
      return bool(
         "restore_project_r_version",
         _constants.restoreProjectRVersionTitle(), 
         _constants.restoreProjectRVersionDescription(), 
         true);
   }

   /**
    * The verbosity level to use with Clang (0 - 2)
    */
   public PrefValue<Integer> clangVerbose()
   {
      return integer(
         "clang_verbose",
         _constants.clangVerboseTitle(), 
         _constants.clangVerboseDescription(), 
         0);
   }

   /**
    * Whether to automatically submit crash reports to RStudio.
    */
   public PrefValue<Boolean> submitCrashReports()
   {
      return bool(
         "submit_crash_reports",
         _constants.submitCrashReportsTitle(), 
         _constants.submitCrashReportsDescription(), 
         true);
   }

   /**
    * The R version to use by default.
    */
   public PrefValue<DefaultRVersion> defaultRVersion()
   {
      return object(
         "default_r_version",
         _constants.defaultRVersionTitle(), 
         _constants.defaultRVersionDescription(), 
         null);
   }

   public static class DefaultRVersion extends JavaScriptObject
   {
      protected DefaultRVersion() {} 

      public final native String getVersion() /*-{
         return this && this.version || "";
      }-*/;

      public final native String getRHome() /*-{
         return this && this.r_home || "";
      }-*/;

      public final native String getLabel() /*-{
         return this && this.label || "";
      }-*/;

      public final native String getModule() /*-{
         return this && this.module || "";
      }-*/;

   }

   /**
    * The maximum number of columns to show at once in the data viewer.
    */
   public PrefValue<Integer> dataViewerMaxColumns()
   {
      return integer(
         "data_viewer_max_columns",
         _constants.dataViewerMaxColumnsTitle(), 
         _constants.dataViewerMaxColumnsDescription(), 
         50);
   }

   /**
    * Support accessibility aids such as screen readers (RStudio Server).
    */
   public PrefValue<Boolean> enableScreenReader()
   {
      return bool(
         "enable_screen_reader",
         _constants.enableScreenReaderTitle(), 
         _constants.enableScreenReaderDescription(), 
         false);
   }

   /**
    * Number of milliseconds to wait after last keystroke before updating live region.
    */
   public PrefValue<Integer> typingStatusDelayMs()
   {
      return integer(
         "typing_status_delay_ms",
         _constants.typingStatusDelayMsTitle(), 
         _constants.typingStatusDelayMsDescription(), 
         2000);
   }

   /**
    * Reduce use of animations in the user interface.
    */
   public PrefValue<Boolean> reducedMotion()
   {
      return bool(
         "reduced_motion",
         _constants.reducedMotionTitle(), 
         _constants.reducedMotionDescription(), 
         false);
   }

   /**
    * Tab key moves focus out of text editing controls instead of inserting tabs.
    */
   public PrefValue<Boolean> tabKeyMoveFocus()
   {
      return bool(
         "tab_key_move_focus",
         _constants.tabKeyMoveFocusTitle(), 
         _constants.tabKeyMoveFocusDescription(), 
         false);
   }

   /**
    * In source editor find panel, tab key moves focus directly from find text to replace text.
    */
   public PrefValue<Boolean> findPanelLegacyTabSequence()
   {
      return bool(
         "find_panel_legacy_tab_sequence",
         _constants.findPanelLegacyTabSequenceTitle(), 
         _constants.findPanelLegacyTabSequenceDescription(), 
         false);
   }

   /**
    * Control with keyboard focus displays a visual focus indicator.
    */
   public PrefValue<Boolean> showFocusRectangles()
   {
      return bool(
         "show_focus_rectangles",
         _constants.showFocusRectanglesTitle(), 
         _constants.showFocusRectanglesDescription(), 
         true);
   }

   /**
    * Show which panel contains keyboard focus.
    */
   public PrefValue<Boolean> showPanelFocusRectangle()
   {
      return bool(
         "show_panel_focus_rectangle",
         _constants.showPanelFocusRectangleTitle(), 
         _constants.showPanelFocusRectangleDescription(), 
         false);
   }

   /**
    * How to deal with changes to documents on idle.
    */
   public PrefValue<String> autoSaveOnIdle()
   {
      return enumeration(
         "auto_save_on_idle",
         _constants.autoSaveOnIdleTitle(), 
         _constants.autoSaveOnIdleDescription(), 
         new String[] {
            AUTO_SAVE_ON_IDLE_COMMIT,
            AUTO_SAVE_ON_IDLE_BACKUP,
            AUTO_SAVE_ON_IDLE_NONE
         },
         "backup",
         new String[] {
            _constants.autoSaveOnIdleEnum_commit(),
            _constants.autoSaveOnIdleEnum_backup(),
            _constants.autoSaveOnIdleEnum_none()
         });
   }

   public final static String AUTO_SAVE_ON_IDLE_COMMIT = "commit";
   public final static String AUTO_SAVE_ON_IDLE_BACKUP = "backup";
   public final static String AUTO_SAVE_ON_IDLE_NONE = "none";

   /**
    * The idle period, in milliseconds, after which documents should be auto-saved.
    */
   public PrefValue<Integer> autoSaveIdleMs()
   {
      return integer(
         "auto_save_idle_ms",
         _constants.autoSaveIdleMsTitle(), 
         _constants.autoSaveIdleMsDescription(), 
         1000);
   }

   /**
    * Whether to automatically save when the editor loses focus.
    */
   public PrefValue<Boolean> autoSaveOnBlur()
   {
      return bool(
         "auto_save_on_blur",
         _constants.autoSaveOnBlurTitle(), 
         _constants.autoSaveOnBlurDescription(), 
         false);
   }

   /**
    * Initial directory for new terminals.
    */
   public PrefValue<String> terminalInitialDirectory()
   {
      return enumeration(
         "terminal_initial_directory",
         _constants.terminalInitialDirectoryTitle(), 
         _constants.terminalInitialDirectoryDescription(), 
         new String[] {
            TERMINAL_INITIAL_DIRECTORY_PROJECT,
            TERMINAL_INITIAL_DIRECTORY_CURRENT,
            TERMINAL_INITIAL_DIRECTORY_HOME
         },
         "project");
   }

   public final static String TERMINAL_INITIAL_DIRECTORY_PROJECT = "project";
   public final static String TERMINAL_INITIAL_DIRECTORY_CURRENT = "current";
   public final static String TERMINAL_INITIAL_DIRECTORY_HOME = "home";

   /**
    * Whether to show the full path to project in desktop window title.
    */
   public PrefValue<Boolean> fullProjectPathInWindowTitle()
   {
      return bool(
         "full_project_path_in_window_title",
         _constants.fullProjectPathInWindowTitleTitle(), 
         _constants.fullProjectPathInWindowTitleDescription(), 
         false);
   }

   /**
    * Whether to enable visual editing by default for new markdown documents
    */
   public PrefValue<Boolean> visualMarkdownEditingIsDefault()
   {
      return bool(
         "visual_markdown_editing_is_default",
         _constants.visualMarkdownEditingIsDefaultTitle(), 
         _constants.visualMarkdownEditingIsDefaultDescription(), 
         false);
   }

   /**
    * Default spacing for lists created in the visual editor
    */
   public PrefValue<String> visualMarkdownEditingListSpacing()
   {
      return enumeration(
         "visual_markdown_editing_list_spacing",
         _constants.visualMarkdownEditingListSpacingTitle(), 
         _constants.visualMarkdownEditingListSpacingDescription(), 
         new String[] {
            VISUAL_MARKDOWN_EDITING_LIST_SPACING_TIGHT,
            VISUAL_MARKDOWN_EDITING_LIST_SPACING_SPACED
         },
         "spaced");
   }

   public final static String VISUAL_MARKDOWN_EDITING_LIST_SPACING_TIGHT = "tight";
   public final static String VISUAL_MARKDOWN_EDITING_LIST_SPACING_SPACED = "spaced";

   /**
    * Whether to automatically wrap text when writing markdown
    */
   public PrefValue<String> visualMarkdownEditingWrap()
   {
      return enumeration(
         "visual_markdown_editing_wrap",
         _constants.visualMarkdownEditingWrapTitle(), 
         _constants.visualMarkdownEditingWrapDescription(), 
         new String[] {
            VISUAL_MARKDOWN_EDITING_WRAP_NONE,
            VISUAL_MARKDOWN_EDITING_WRAP_COLUMN,
            VISUAL_MARKDOWN_EDITING_WRAP_SENTENCE
         },
         "none");
   }

   public final static String VISUAL_MARKDOWN_EDITING_WRAP_NONE = "none";
   public final static String VISUAL_MARKDOWN_EDITING_WRAP_COLUMN = "column";
   public final static String VISUAL_MARKDOWN_EDITING_WRAP_SENTENCE = "sentence";

   /**
    * The column to wrap text at when writing markdown
    */
   public PrefValue<Integer> visualMarkdownEditingWrapAtColumn()
   {
      return integer(
         "visual_markdown_editing_wrap_at_column",
         _constants.visualMarkdownEditingWrapAtColumnTitle(), 
         _constants.visualMarkdownEditingWrapAtColumnDescription(), 
         72);
   }

   /**
    * Placement of footnotes within markdown output.
    */
   public PrefValue<String> visualMarkdownEditingReferencesLocation()
   {
      return enumeration(
         "visual_markdown_editing_references_location",
         _constants.visualMarkdownEditingReferencesLocationTitle(), 
         _constants.visualMarkdownEditingReferencesLocationDescription(), 
         new String[] {
            VISUAL_MARKDOWN_EDITING_REFERENCES_LOCATION_BLOCK,
            VISUAL_MARKDOWN_EDITING_REFERENCES_LOCATION_SECTION,
            VISUAL_MARKDOWN_EDITING_REFERENCES_LOCATION_DOCUMENT
         },
         "block");
   }

   public final static String VISUAL_MARKDOWN_EDITING_REFERENCES_LOCATION_BLOCK = "block";
   public final static String VISUAL_MARKDOWN_EDITING_REFERENCES_LOCATION_SECTION = "section";
   public final static String VISUAL_MARKDOWN_EDITING_REFERENCES_LOCATION_DOCUMENT = "document";

   /**
    * Whether to write canonical visual mode markdown when saving from source mode.
    */
   public PrefValue<Boolean> visualMarkdownEditingCanonical()
   {
      return bool(
         "visual_markdown_editing_canonical",
         _constants.visualMarkdownEditingCanonicalTitle(), 
         _constants.visualMarkdownEditingCanonicalDescription(), 
         false);
   }

   /**
    * Maximum content width for visual editing mode, in pixels
    */
   public PrefValue<Integer> visualMarkdownEditingMaxContentWidth()
   {
      return integer(
         "visual_markdown_editing_max_content_width",
         _constants.visualMarkdownEditingMaxContentWidthTitle(), 
         _constants.visualMarkdownEditingMaxContentWidthDescription(), 
         700);
   }

   /**
    * Whether to show the document outline by default when opening R Markdown documents in visual mode.
    */
   public PrefValue<Boolean> visualMarkdownEditingShowDocOutline()
   {
      return bool(
         "visual_markdown_editing_show_doc_outline",
         _constants.visualMarkdownEditingShowDocOutlineTitle(), 
         _constants.visualMarkdownEditingShowDocOutlineDescription(), 
         true);
   }

   /**
    * Whether to show the margin guide in the visual mode code blocks.
    */
   public PrefValue<Boolean> visualMarkdownEditingShowMargin()
   {
      return bool(
         "visual_markdown_editing_show_margin",
         _constants.visualMarkdownEditingShowMarginTitle(), 
         _constants.visualMarkdownEditingShowMarginDescription(), 
         false);
   }

   /**
    * Whether to show line numbers in the code editors used in visual mode
    */
   public PrefValue<Boolean> visualMarkdownCodeEditorLineNumbers()
   {
      return bool(
         "visual_markdown_code_editor_line_numbers",
         _constants.visualMarkdownCodeEditorLineNumbersTitle(), 
         _constants.visualMarkdownCodeEditorLineNumbersDescription(), 
         false);
   }

   /**
    * The default visual editing mode font size, in points
    */
   public PrefValue<Integer> visualMarkdownEditingFontSizePoints()
   {
      return integer(
         "visual_markdown_editing_font_size_points",
         _constants.visualMarkdownEditingFontSizePointsTitle(), 
         _constants.visualMarkdownEditingFontSizePointsDescription(), 
         0);
   }

   /**
    * The name of the editor to use to provide code editing in visual mode
    */
   public PrefValue<String> visualMarkdownCodeEditor()
   {
      return enumeration(
         "visual_markdown_code_editor",
         _constants.visualMarkdownCodeEditorTitle(), 
         _constants.visualMarkdownCodeEditorDescription(), 
         new String[] {
            VISUAL_MARKDOWN_CODE_EDITOR_ACE,
            VISUAL_MARKDOWN_CODE_EDITOR_CODEMIRROR
         },
         "ace");
   }

   public final static String VISUAL_MARKDOWN_CODE_EDITOR_ACE = "ace";
   public final static String VISUAL_MARKDOWN_CODE_EDITOR_CODEMIRROR = "codemirror";

   /**
    * Zotero libraries to insert citations from.
    */
   public PrefValue<JsArrayString> zoteroLibraries()
   {
      return object(
         "zotero_libraries",
         _constants.zoteroLibrariesTitle(), 
         _constants.zoteroLibrariesDescription(), 
         JsArrayUtil.createStringArray("My Library"));
   }

   /**
    * Preferred emoji skintone
    */
   public PrefValue<String> emojiSkintone()
   {
      return enumeration(
         "emoji_skintone",
         _constants.emojiSkintoneTitle(), 
         _constants.emojiSkintoneDescription(), 
         new String[] {
            EMOJI_SKINTONE__NONE_,
            EMOJI_SKINTONE__DEFAULT_,
            EMOJI_SKINTONE_LIGHT,
            EMOJI_SKINTONE_MEDIUM_LIGHT,
            EMOJI_SKINTONE_MEDIUM,
            EMOJI_SKINTONE_MEDIUM_DARK,
            EMOJI_SKINTONE_DARK
         },
         "(None)");
   }

   public final static String EMOJI_SKINTONE__NONE_ = "(None)";
   public final static String EMOJI_SKINTONE__DEFAULT_ = "(Default)";
   public final static String EMOJI_SKINTONE_LIGHT = "Light";
   public final static String EMOJI_SKINTONE_MEDIUM_LIGHT = "Medium-Light";
   public final static String EMOJI_SKINTONE_MEDIUM = "Medium";
   public final static String EMOJI_SKINTONE_MEDIUM_DARK = "Medium-Dark";
   public final static String EMOJI_SKINTONE_DARK = "Dark";

   /**
    * List of aria-live announcements to disable.
    */
   public PrefValue<JsArrayString> disabledAriaLiveAnnouncements()
   {
      return object(
         "disabled_aria_live_announcements",
         _constants.disabledAriaLiveAnnouncementsTitle(), 
         _constants.disabledAriaLiveAnnouncementsDescription(), 
         JsArrayUtil.createStringArray());
   }

   /**
    * Maximum number of lines of console output announced after a command.
    */
   public PrefValue<Integer> screenreaderConsoleAnnounceLimit()
   {
      return integer(
         "screenreader_console_announce_limit",
         _constants.screenreaderConsoleAnnounceLimitTitle(), 
         _constants.screenreaderConsoleAnnounceLimitDescription(), 
         25);
   }

   /**
    * List of path components; file monitor will ignore paths containing one or more of these components.
    */
   public PrefValue<JsArrayString> fileMonitorIgnoredComponents()
   {
      return object(
         "file_monitor_ignored_components",
         _constants.fileMonitorIgnoredComponentsTitle(), 
         _constants.fileMonitorIgnoredComponentsDescription(), 
         JsArrayUtil.createStringArray());
   }

   /**
    * Whether to install R package dependencies one at a time.
    */
   public PrefValue<Boolean> installPkgDepsIndividually()
   {
      return bool(
         "install_pkg_deps_individually",
         _constants.installPkgDepsIndividuallyTitle(), 
         _constants.installPkgDepsIndividuallyDescription(), 
         true);
   }

   /**
    * R graphics backend.
    */
   public PrefValue<String> graphicsBackend()
   {
      return enumeration(
         "graphics_backend",
         _constants.graphicsBackendTitle(), 
         _constants.graphicsBackendDescription(), 
         new String[] {
            GRAPHICS_BACKEND_DEFAULT,
            GRAPHICS_BACKEND_CAIRO,
            GRAPHICS_BACKEND_CAIRO_PNG,
            GRAPHICS_BACKEND_QUARTZ,
            GRAPHICS_BACKEND_WINDOWS,
            GRAPHICS_BACKEND_RAGG
         },
         "default");
   }

   public final static String GRAPHICS_BACKEND_DEFAULT = "default";
   public final static String GRAPHICS_BACKEND_CAIRO = "cairo";
   public final static String GRAPHICS_BACKEND_CAIRO_PNG = "cairo-png";
   public final static String GRAPHICS_BACKEND_QUARTZ = "quartz";
   public final static String GRAPHICS_BACKEND_WINDOWS = "windows";
   public final static String GRAPHICS_BACKEND_RAGG = "ragg";

   /**
    * Type of anti-aliasing to be used for generated R plots.
    */
   public PrefValue<String> graphicsAntialiasing()
   {
      return enumeration(
         "graphics_antialiasing",
         _constants.graphicsAntialiasingTitle(), 
         _constants.graphicsAntialiasingDescription(), 
         new String[] {
            GRAPHICS_ANTIALIASING_DEFAULT,
            GRAPHICS_ANTIALIASING_NONE,
            GRAPHICS_ANTIALIASING_GRAY,
            GRAPHICS_ANTIALIASING_SUBPIXEL
         },
         "default");
   }

   public final static String GRAPHICS_ANTIALIASING_DEFAULT = "default";
   public final static String GRAPHICS_ANTIALIASING_NONE = "none";
   public final static String GRAPHICS_ANTIALIASING_GRAY = "gray";
   public final static String GRAPHICS_ANTIALIASING_SUBPIXEL = "subpixel";

   /**
    * List of fixed-width fonts to check for browser support.
    */
   public PrefValue<JsArrayString> browserFixedWidthFonts()
   {
      return object(
         "browser_fixed_width_fonts",
         _constants.browserFixedWidthFontsTitle(), 
         _constants.browserFixedWidthFontsDescription(), 
         JsArrayUtil.createStringArray("Andale Mono", "Bitstream Vera Sans Mono", "Cascadia Code", "Consolas", "Courier New", "Courier", "DejaVu Sans Mono", "Droid Sans Mono", "Fira Code", "Hack", "IBM Plex Mono", "Inconsolata", "JetBrains Mono", "Lucida Console", "Lucida Sans Typewriter", "Menlo", "Monaco", "Monoid", "Operator Mono", "Pragmata", "SF Mono", "Source Code Pro", "Vera Sans Mono", "Victor Mono", "Ubuntu Mono"));
   }

   /**
    * The Python type.
    */
   public PrefValue<String> pythonType()
   {
      return string(
         "python_type",
         _constants.pythonTypeTitle(), 
         _constants.pythonTypeDescription(), 
         "");
   }

   /**
    * The Python version.
    */
   public PrefValue<String> pythonVersion()
   {
      return string(
         "python_version",
         _constants.pythonVersionTitle(), 
         _constants.pythonVersionDescription(), 
         "");
   }

   /**
    * The path to the default Python interpreter.
    */
   public PrefValue<String> pythonPath()
   {
      return string(
         "python_path",
         _constants.pythonPathTitle(), 
         _constants.pythonPathDescription(), 
         "");
   }

   /**
    * The maximum amount of seconds of retry for save operations.
    */
   public PrefValue<Integer> saveRetryTimeout()
   {
      return integer(
         "save_retry_timeout",
         _constants.saveRetryTimeoutTitle(), 
         _constants.saveRetryTimeoutDescription(), 
         15);
   }

   /**
    * Whether the Insert Pipe Operator command should insert the native R pipe operator, |>
    */
   public PrefValue<Boolean> insertNativePipeOperator()
   {
      return bool(
         "insert_native_pipe_operator",
         _constants.insertNativePipeOperatorTitle(), 
         _constants.insertNativePipeOperatorDescription(), 
         false);
   }

   /**
    * Whether to keep track of recently used commands in the Command Palette
    */
   public PrefValue<Boolean> commandPaletteMru()
   {
      return bool(
         "command_palette_mru",
         _constants.commandPaletteMruTitle(), 
         _constants.commandPaletteMruDescription(), 
         true);
   }

   /**
    * Whether to compute and show memory usage in the Environment Pane
    */
   public PrefValue<Boolean> showMemoryUsage()
   {
      return bool(
         "show_memory_usage",
         _constants.showMemoryUsageTitle(), 
         _constants.showMemoryUsageDescription(), 
         true);
   }

   /**
    * How many seconds to wait between automatic requeries of memory statistics (0 to disable)
    */
   public PrefValue<Integer> memoryQueryIntervalSeconds()
   {
      return integer(
         "memory_query_interval_seconds",
         _constants.memoryQueryIntervalSecondsTitle(), 
         _constants.memoryQueryIntervalSecondsDescription(), 
         10);
   }

   /**
    * Enable Python terminal hooks. When enabled, the RStudio-configured version of Python will be placed on the PATH.
    */
   public PrefValue<Boolean> terminalPythonIntegration()
   {
      return bool(
         "terminal_python_integration",
         _constants.terminalPythonIntegrationTitle(), 
         _constants.terminalPythonIntegrationDescription(), 
         true);
   }

   /**
    * Enable session protocol debug logging showing all session requests and events
    */
   public PrefValue<Boolean> sessionProtocolDebug()
   {
      return bool(
         "session_protocol_debug",
         _constants.sessionProtocolDebugTitle(), 
         _constants.sessionProtocolDebugDescription(), 
         false);
   }

   /**
    * When enabled, if the active project contains a Python virtual environment, then RStudio will automatically activate this environment on startup.
    */
   public PrefValue<Boolean> pythonProjectEnvironmentAutomaticActivate()
   {
      return bool(
         "python_project_environment_automatic_activate",
         _constants.pythonProjectEnvironmentAutomaticActivateTitle(), 
         _constants.pythonProjectEnvironmentAutomaticActivateDescription(), 
         true);
   }

   /**
    * When enabled, RStudio will detect R objects containing null external pointers when building the Environment pane, and avoid introspecting their contents further.
    */
   public PrefValue<Boolean> checkNullExternalPointers()
   {
      return bool(
         "check_null_external_pointers",
         _constants.checkNullExternalPointersTitle(), 
         _constants.checkNullExternalPointersDescription(), 
         false);
   }

   /**
    * Enable IDE features for the Quarto publishing system.
    */
   public PrefValue<String> quartoEnabled()
   {
      return enumeration(
         "quarto_enabled",
         _constants.quartoEnabledTitle(), 
         _constants.quartoEnabledDescription(), 
         new String[] {
            QUARTO_ENABLED_AUTO,
            QUARTO_ENABLED_ENABLED,
            QUARTO_ENABLED_DISABLED,
            QUARTO_ENABLED_HIDDEN
         },
         "auto");
   }

   public final static String QUARTO_ENABLED_AUTO = "auto";
   public final static String QUARTO_ENABLED_ENABLED = "enabled";
   public final static String QUARTO_ENABLED_DISABLED = "disabled";
   public final static String QUARTO_ENABLED_HIDDEN = "hidden";

   public void syncPrefs(String layer, JsObject source)
   {
      if (source.hasKey("run_rprofile_on_resume"))
         runRprofileOnResume().setValue(layer, source.getBool("run_rprofile_on_resume"));
      if (source.hasKey("save_workspace"))
         saveWorkspace().setValue(layer, source.getString("save_workspace"));
      if (source.hasKey("load_workspace"))
         loadWorkspace().setValue(layer, source.getBool("load_workspace"));
      if (source.hasKey("initial_working_directory"))
         initialWorkingDirectory().setValue(layer, source.getString("initial_working_directory"));
      if (source.hasKey("cran_mirror"))
         cranMirror().setValue(layer, source.getObject("cran_mirror"));
      if (source.hasKey("bioconductor_mirror_name"))
         bioconductorMirrorName().setValue(layer, source.getString("bioconductor_mirror_name"));
      if (source.hasKey("bioconductor_mirror_url"))
         bioconductorMirrorUrl().setValue(layer, source.getString("bioconductor_mirror_url"));
      if (source.hasKey("always_save_history"))
         alwaysSaveHistory().setValue(layer, source.getBool("always_save_history"));
      if (source.hasKey("remove_history_duplicates"))
         removeHistoryDuplicates().setValue(layer, source.getBool("remove_history_duplicates"));
      if (source.hasKey("show_last_dot_value"))
         showLastDotValue().setValue(layer, source.getBool("show_last_dot_value"));
      if (source.hasKey("line_ending_conversion"))
         lineEndingConversion().setValue(layer, source.getString("line_ending_conversion"));
      if (source.hasKey("use_newlines_in_makefiles"))
         useNewlinesInMakefiles().setValue(layer, source.getBool("use_newlines_in_makefiles"));
      if (source.hasKey("windows_terminal_shell"))
         windowsTerminalShell().setValue(layer, source.getString("windows_terminal_shell"));
      if (source.hasKey("posix_terminal_shell"))
         posixTerminalShell().setValue(layer, source.getString("posix_terminal_shell"));
      if (source.hasKey("custom_shell_command"))
         customShellCommand().setValue(layer, source.getString("custom_shell_command"));
      if (source.hasKey("custom_shell_options"))
         customShellOptions().setValue(layer, source.getString("custom_shell_options"));
      if (source.hasKey("show_line_numbers"))
         showLineNumbers().setValue(layer, source.getBool("show_line_numbers"));
      if (source.hasKey("highlight_selected_word"))
         highlightSelectedWord().setValue(layer, source.getBool("highlight_selected_word"));
      if (source.hasKey("highlight_selected_line"))
         highlightSelectedLine().setValue(layer, source.getBool("highlight_selected_line"));
      if (source.hasKey("panes"))
         panes().setValue(layer, source.getObject("panes"));
      if (source.hasKey("allow_source_columns"))
         allowSourceColumns().setValue(layer, source.getBool("allow_source_columns"));
      if (source.hasKey("use_spaces_for_tab"))
         useSpacesForTab().setValue(layer, source.getBool("use_spaces_for_tab"));
      if (source.hasKey("num_spaces_for_tab"))
         numSpacesForTab().setValue(layer, source.getInteger("num_spaces_for_tab"));
      if (source.hasKey("auto_detect_indentation"))
         autoDetectIndentation().setValue(layer, source.getBool("auto_detect_indentation"));
      if (source.hasKey("show_margin"))
         showMargin().setValue(layer, source.getBool("show_margin"));
      if (source.hasKey("blinking_cursor"))
         blinkingCursor().setValue(layer, source.getBool("blinking_cursor"));
      if (source.hasKey("margin_column"))
         marginColumn().setValue(layer, source.getInteger("margin_column"));
      if (source.hasKey("show_invisibles"))
         showInvisibles().setValue(layer, source.getBool("show_invisibles"));
      if (source.hasKey("show_indent_guides"))
         showIndentGuides().setValue(layer, source.getBool("show_indent_guides"));
      if (source.hasKey("continue_comments_on_newline"))
         continueCommentsOnNewline().setValue(layer, source.getBool("continue_comments_on_newline"));
      if (source.hasKey("highlight_web_link"))
         highlightWebLink().setValue(layer, source.getBool("highlight_web_link"));
      if (source.hasKey("editor_keybindings"))
         editorKeybindings().setValue(layer, source.getString("editor_keybindings"));
      if (source.hasKey("insert_matching"))
         insertMatching().setValue(layer, source.getBool("insert_matching"));
      if (source.hasKey("insert_spaces_around_equals"))
         insertSpacesAroundEquals().setValue(layer, source.getBool("insert_spaces_around_equals"));
      if (source.hasKey("insert_parens_after_function_completion"))
         insertParensAfterFunctionCompletion().setValue(layer, source.getBool("insert_parens_after_function_completion"));
      if (source.hasKey("tab_multiline_completion"))
         tabMultilineCompletion().setValue(layer, source.getBool("tab_multiline_completion"));
      if (source.hasKey("tab_completion"))
         tabCompletion().setValue(layer, source.getBool("tab_completion"));
      if (source.hasKey("show_help_tooltip_on_idle"))
         showHelpTooltipOnIdle().setValue(layer, source.getBool("show_help_tooltip_on_idle"));
      if (source.hasKey("surround_selection"))
         surroundSelection().setValue(layer, source.getString("surround_selection"));
      if (source.hasKey("enable_snippets"))
         enableSnippets().setValue(layer, source.getBool("enable_snippets"));
      if (source.hasKey("code_completion"))
         codeCompletion().setValue(layer, source.getString("code_completion"));
      if (source.hasKey("code_completion_other"))
         codeCompletionOther().setValue(layer, source.getString("code_completion_other"));
      if (source.hasKey("console_code_completion"))
         consoleCodeCompletion().setValue(layer, source.getBool("console_code_completion"));
      if (source.hasKey("code_completion_delay"))
         codeCompletionDelay().setValue(layer, source.getInteger("code_completion_delay"));
      if (source.hasKey("code_completion_characters"))
         codeCompletionCharacters().setValue(layer, source.getInteger("code_completion_characters"));
      if (source.hasKey("show_function_signature_tooltips"))
         showFunctionSignatureTooltips().setValue(layer, source.getBool("show_function_signature_tooltips"));
      if (source.hasKey("show_diagnostics_r"))
         showDiagnosticsR().setValue(layer, source.getBool("show_diagnostics_r"));
      if (source.hasKey("show_diagnostics_cpp"))
         showDiagnosticsCpp().setValue(layer, source.getBool("show_diagnostics_cpp"));
      if (source.hasKey("show_diagnostics_yaml"))
         showDiagnosticsYaml().setValue(layer, source.getBool("show_diagnostics_yaml"));
      if (source.hasKey("show_diagnostics_other"))
         showDiagnosticsOther().setValue(layer, source.getBool("show_diagnostics_other"));
      if (source.hasKey("style_diagnostics"))
         styleDiagnostics().setValue(layer, source.getBool("style_diagnostics"));
      if (source.hasKey("diagnostics_on_save"))
         diagnosticsOnSave().setValue(layer, source.getBool("diagnostics_on_save"));
      if (source.hasKey("background_diagnostics"))
         backgroundDiagnostics().setValue(layer, source.getBool("background_diagnostics"));
      if (source.hasKey("background_diagnostics_delay_ms"))
         backgroundDiagnosticsDelayMs().setValue(layer, source.getInteger("background_diagnostics_delay_ms"));
      if (source.hasKey("diagnostics_in_r_function_calls"))
         diagnosticsInRFunctionCalls().setValue(layer, source.getBool("diagnostics_in_r_function_calls"));
      if (source.hasKey("check_arguments_to_r_function_calls"))
         checkArgumentsToRFunctionCalls().setValue(layer, source.getBool("check_arguments_to_r_function_calls"));
      if (source.hasKey("check_unexpected_assignment_in_function_call"))
         checkUnexpectedAssignmentInFunctionCall().setValue(layer, source.getBool("check_unexpected_assignment_in_function_call"));
      if (source.hasKey("warn_if_no_such_variable_in_scope"))
         warnIfNoSuchVariableInScope().setValue(layer, source.getBool("warn_if_no_such_variable_in_scope"));
      if (source.hasKey("warn_variable_defined_but_not_used"))
         warnVariableDefinedButNotUsed().setValue(layer, source.getBool("warn_variable_defined_but_not_used"));
      if (source.hasKey("auto_discover_package_dependencies"))
         autoDiscoverPackageDependencies().setValue(layer, source.getBool("auto_discover_package_dependencies"));
      if (source.hasKey("auto_append_newline"))
         autoAppendNewline().setValue(layer, source.getBool("auto_append_newline"));
      if (source.hasKey("strip_trailing_whitespace"))
         stripTrailingWhitespace().setValue(layer, source.getBool("strip_trailing_whitespace"));
      if (source.hasKey("restore_source_document_cursor_position"))
         restoreSourceDocumentCursorPosition().setValue(layer, source.getBool("restore_source_document_cursor_position"));
      if (source.hasKey("reindent_on_paste"))
         reindentOnPaste().setValue(layer, source.getBool("reindent_on_paste"));
      if (source.hasKey("vertically_align_arguments_indent"))
         verticallyAlignArgumentsIndent().setValue(layer, source.getBool("vertically_align_arguments_indent"));
      if (source.hasKey("soft_wrap_r_files"))
         softWrapRFiles().setValue(layer, source.getBool("soft_wrap_r_files"));
      if (source.hasKey("soft_wrap_rmd_files"))
         softWrapRmdFiles().setValue(layer, source.getBool("soft_wrap_rmd_files"));
      if (source.hasKey("focus_console_after_exec"))
         focusConsoleAfterExec().setValue(layer, source.getBool("focus_console_after_exec"));
      if (source.hasKey("fold_style"))
         foldStyle().setValue(layer, source.getString("fold_style"));
      if (source.hasKey("save_before_sourcing"))
         saveBeforeSourcing().setValue(layer, source.getBool("save_before_sourcing"));
      if (source.hasKey("syntax_color_console"))
         syntaxColorConsole().setValue(layer, source.getBool("syntax_color_console"));
      if (source.hasKey("highlight_console_errors"))
         highlightConsoleErrors().setValue(layer, source.getBool("highlight_console_errors"));
      if (source.hasKey("scroll_past_end_of_document"))
         scrollPastEndOfDocument().setValue(layer, source.getBool("scroll_past_end_of_document"));
      if (source.hasKey("highlight_r_function_calls"))
         highlightRFunctionCalls().setValue(layer, source.getBool("highlight_r_function_calls"));
      if (source.hasKey("rainbow_parentheses"))
         rainbowParentheses().setValue(layer, source.getBool("rainbow_parentheses"));
      if (source.hasKey("console_line_length_limit"))
         consoleLineLengthLimit().setValue(layer, source.getInteger("console_line_length_limit"));
      if (source.hasKey("console_max_lines"))
         consoleMaxLines().setValue(layer, source.getInteger("console_max_lines"));
      if (source.hasKey("ansi_console_mode"))
         ansiConsoleMode().setValue(layer, source.getString("ansi_console_mode"));
      if (source.hasKey("limit_visible_console"))
         limitVisibleConsole().setValue(layer, source.getBool("limit_visible_console"));
      if (source.hasKey("show_inline_toolbar_for_r_code_chunks"))
         showInlineToolbarForRCodeChunks().setValue(layer, source.getBool("show_inline_toolbar_for_r_code_chunks"));
      if (source.hasKey("highlight_code_chunks"))
         highlightCodeChunks().setValue(layer, source.getBool("highlight_code_chunks"));
      if (source.hasKey("save_files_before_build"))
         saveFilesBeforeBuild().setValue(layer, source.getBool("save_files_before_build"));
      if (source.hasKey("font_size_points"))
         fontSizePoints().setValue(layer, source.getDbl("font_size_points"));
      if (source.hasKey("help_font_size_points"))
         helpFontSizePoints().setValue(layer, source.getDbl("help_font_size_points"));
      if (source.hasKey("editor_theme"))
         editorTheme().setValue(layer, source.getString("editor_theme"));
      if (source.hasKey("server_editor_font_enabled"))
         serverEditorFontEnabled().setValue(layer, source.getBool("server_editor_font_enabled"));
      if (source.hasKey("server_editor_font"))
         serverEditorFont().setValue(layer, source.getString("server_editor_font"));
      if (source.hasKey("default_encoding"))
         defaultEncoding().setValue(layer, source.getString("default_encoding"));
      if (source.hasKey("toolbar_visible"))
         toolbarVisible().setValue(layer, source.getBool("toolbar_visible"));
      if (source.hasKey("default_project_location"))
         defaultProjectLocation().setValue(layer, source.getString("default_project_location"));
      if (source.hasKey("source_with_echo"))
         sourceWithEcho().setValue(layer, source.getBool("source_with_echo"));
      if (source.hasKey("default_sweave_engine"))
         defaultSweaveEngine().setValue(layer, source.getString("default_sweave_engine"));
      if (source.hasKey("default_latex_program"))
         defaultLatexProgram().setValue(layer, source.getString("default_latex_program"));
      if (source.hasKey("use_roxygen"))
         useRoxygen().setValue(layer, source.getBool("use_roxygen"));
      if (source.hasKey("use_dataimport"))
         useDataimport().setValue(layer, source.getBool("use_dataimport"));
      if (source.hasKey("pdf_previewer"))
         pdfPreviewer().setValue(layer, source.getString("pdf_previewer"));
      if (source.hasKey("always_enable_rnw_concordance"))
         alwaysEnableRnwConcordance().setValue(layer, source.getBool("always_enable_rnw_concordance"));
      if (source.hasKey("insert_numbered_latex_sections"))
         insertNumberedLatexSections().setValue(layer, source.getBool("insert_numbered_latex_sections"));
      if (source.hasKey("spelling_dictionary_language"))
         spellingDictionaryLanguage().setValue(layer, source.getString("spelling_dictionary_language"));
      if (source.hasKey("spelling_custom_dictionaries"))
         spellingCustomDictionaries().setValue(layer, source.getObject("spelling_custom_dictionaries"));
      if (source.hasKey("document_load_lint_delay"))
         documentLoadLintDelay().setValue(layer, source.getInteger("document_load_lint_delay"));
      if (source.hasKey("ignore_uppercase_words"))
         ignoreUppercaseWords().setValue(layer, source.getBool("ignore_uppercase_words"));
      if (source.hasKey("ignore_words_with_numbers"))
         ignoreWordsWithNumbers().setValue(layer, source.getBool("ignore_words_with_numbers"));
      if (source.hasKey("real_time_spellchecking"))
         realTimeSpellchecking().setValue(layer, source.getBool("real_time_spellchecking"));
      if (source.hasKey("navigate_to_build_error"))
         navigateToBuildError().setValue(layer, source.getBool("navigate_to_build_error"));
      if (source.hasKey("packages_pane_enabled"))
         packagesPaneEnabled().setValue(layer, source.getBool("packages_pane_enabled"));
      if (source.hasKey("cpp_template"))
         cppTemplate().setValue(layer, source.getString("cpp_template"));
      if (source.hasKey("restore_source_documents"))
         restoreSourceDocuments().setValue(layer, source.getBool("restore_source_documents"));
      if (source.hasKey("handle_errors_in_user_code_only"))
         handleErrorsInUserCodeOnly().setValue(layer, source.getBool("handle_errors_in_user_code_only"));
      if (source.hasKey("auto_expand_error_tracebacks"))
         autoExpandErrorTracebacks().setValue(layer, source.getBool("auto_expand_error_tracebacks"));
      if (source.hasKey("check_for_updates"))
         checkForUpdates().setValue(layer, source.getBool("check_for_updates"));
      if (source.hasKey("show_internal_functions"))
         showInternalFunctions().setValue(layer, source.getBool("show_internal_functions"));
      if (source.hasKey("shiny_viewer_type"))
         shinyViewerType().setValue(layer, source.getString("shiny_viewer_type"));
      if (source.hasKey("shiny_background_jobs"))
         shinyBackgroundJobs().setValue(layer, source.getBool("shiny_background_jobs"));
      if (source.hasKey("plumber_viewer_type"))
         plumberViewerType().setValue(layer, source.getString("plumber_viewer_type"));
      if (source.hasKey("document_author"))
         documentAuthor().setValue(layer, source.getString("document_author"));
      if (source.hasKey("rmd_auto_date"))
         rmdAutoDate().setValue(layer, source.getBool("rmd_auto_date"));
      if (source.hasKey("rmd_preferred_template_path"))
         rmdPreferredTemplatePath().setValue(layer, source.getString("rmd_preferred_template_path"));
      if (source.hasKey("rmd_viewer_type"))
         rmdViewerType().setValue(layer, source.getString("rmd_viewer_type"));
      if (source.hasKey("show_publish_diagnostics"))
         showPublishDiagnostics().setValue(layer, source.getBool("show_publish_diagnostics"));
      if (source.hasKey("publish_check_certificates"))
         publishCheckCertificates().setValue(layer, source.getBool("publish_check_certificates"));
      if (source.hasKey("use_publish_ca_bundle"))
         usePublishCaBundle().setValue(layer, source.getBool("use_publish_ca_bundle"));
      if (source.hasKey("publish_ca_bundle"))
         publishCaBundle().setValue(layer, source.getString("publish_ca_bundle"));
      if (source.hasKey("rmd_chunk_output_inline"))
         rmdChunkOutputInline().setValue(layer, source.getBool("rmd_chunk_output_inline"));
      if (source.hasKey("show_doc_outline_rmd"))
         showDocOutlineRmd().setValue(layer, source.getBool("show_doc_outline_rmd"));
      if (source.hasKey("auto_run_setup_chunk"))
         autoRunSetupChunk().setValue(layer, source.getBool("auto_run_setup_chunk"));
      if (source.hasKey("hide_console_on_chunk_execute"))
         hideConsoleOnChunkExecute().setValue(layer, source.getBool("hide_console_on_chunk_execute"));
      if (source.hasKey("execution_behavior"))
         executionBehavior().setValue(layer, source.getString("execution_behavior"));
      if (source.hasKey("show_terminal_tab"))
         showTerminalTab().setValue(layer, source.getBool("show_terminal_tab"));
      if (source.hasKey("terminal_local_echo"))
         terminalLocalEcho().setValue(layer, source.getBool("terminal_local_echo"));
      if (source.hasKey("terminal_websockets"))
         terminalWebsockets().setValue(layer, source.getBool("terminal_websockets"));
      if (source.hasKey("terminal_close_behavior"))
         terminalCloseBehavior().setValue(layer, source.getString("terminal_close_behavior"));
      if (source.hasKey("terminal_track_environment"))
         terminalTrackEnvironment().setValue(layer, source.getBool("terminal_track_environment"));
      if (source.hasKey("terminal_bell_style"))
         terminalBellStyle().setValue(layer, source.getString("terminal_bell_style"));
      if (source.hasKey("terminal_renderer"))
         terminalRenderer().setValue(layer, source.getString("terminal_renderer"));
      if (source.hasKey("terminal_weblinks"))
         terminalWeblinks().setValue(layer, source.getBool("terminal_weblinks"));
      if (source.hasKey("show_rmd_render_command"))
         showRmdRenderCommand().setValue(layer, source.getBool("show_rmd_render_command"));
      if (source.hasKey("enable_text_drag"))
         enableTextDrag().setValue(layer, source.getBool("enable_text_drag"));
      if (source.hasKey("show_hidden_files"))
         showHiddenFiles().setValue(layer, source.getBool("show_hidden_files"));
      if (source.hasKey("always_shown_files"))
         alwaysShownFiles().setValue(layer, source.getObject("always_shown_files"));
      if (source.hasKey("always_shown_extensions"))
         alwaysShownExtensions().setValue(layer, source.getObject("always_shown_extensions"));
      if (source.hasKey("sort_file_names_naturally"))
         sortFileNamesNaturally().setValue(layer, source.getBool("sort_file_names_naturally"));
      if (source.hasKey("sync_files_pane_working_dir"))
         syncFilesPaneWorkingDir().setValue(layer, source.getBool("sync_files_pane_working_dir"));
      if (source.hasKey("jobs_tab_visibility"))
         jobsTabVisibility().setValue(layer, source.getString("jobs_tab_visibility"));
      if (source.hasKey("show_launcher_jobs_tab"))
         showLauncherJobsTab().setValue(layer, source.getBool("show_launcher_jobs_tab"));
      if (source.hasKey("launcher_jobs_sort"))
         launcherJobsSort().setValue(layer, source.getString("launcher_jobs_sort"));
      if (source.hasKey("busy_detection"))
         busyDetection().setValue(layer, source.getString("busy_detection"));
      if (source.hasKey("busy_exclusion_list"))
         busyExclusionList().setValue(layer, source.getObject("busy_exclusion_list"));
      if (source.hasKey("knit_working_dir"))
         knitWorkingDir().setValue(layer, source.getString("knit_working_dir"));
      if (source.hasKey("doc_outline_show"))
         docOutlineShow().setValue(layer, source.getString("doc_outline_show"));
      if (source.hasKey("latex_preview_on_cursor_idle"))
         latexPreviewOnCursorIdle().setValue(layer, source.getString("latex_preview_on_cursor_idle"));
      if (source.hasKey("wrap_tab_navigation"))
         wrapTabNavigation().setValue(layer, source.getBool("wrap_tab_navigation"));
      if (source.hasKey("global_theme"))
         globalTheme().setValue(layer, source.getString("global_theme"));
      if (source.hasKey("git_diff_ignore_whitespace"))
         gitDiffIgnoreWhitespace().setValue(layer, source.getBool("git_diff_ignore_whitespace"));
      if (source.hasKey("console_double_click_select"))
         consoleDoubleClickSelect().setValue(layer, source.getBool("console_double_click_select"));
      if (source.hasKey("console_suspend_blocked_notice"))
         consoleSuspendBlockedNotice().setValue(layer, source.getBool("console_suspend_blocked_notice"));
      if (source.hasKey("console_suspend_blocked_notice_delay"))
         consoleSuspendBlockedNoticeDelay().setValue(layer, source.getInteger("console_suspend_blocked_notice_delay"));
      if (source.hasKey("new_proj_git_init"))
         newProjGitInit().setValue(layer, source.getBool("new_proj_git_init"));
      if (source.hasKey("new_proj_use_renv"))
         newProjUseRenv().setValue(layer, source.getBool("new_proj_use_renv"));
      if (source.hasKey("root_document"))
         rootDocument().setValue(layer, source.getString("root_document"));
      if (source.hasKey("show_user_home_page"))
         showUserHomePage().setValue(layer, source.getString("show_user_home_page"));
      if (source.hasKey("reuse_sessions_for_project_links"))
         reuseSessionsForProjectLinks().setValue(layer, source.getBool("reuse_sessions_for_project_links"));
      if (source.hasKey("vcs_enabled"))
         vcsEnabled().setValue(layer, source.getBool("vcs_enabled"));
      if (source.hasKey("vcs_autorefresh"))
         vcsAutorefresh().setValue(layer, source.getBool("vcs_autorefresh"));
      if (source.hasKey("git_exe_path"))
         gitExePath().setValue(layer, source.getString("git_exe_path"));
      if (source.hasKey("svn_exe_path"))
         svnExePath().setValue(layer, source.getString("svn_exe_path"));
      if (source.hasKey("terminal_path"))
         terminalPath().setValue(layer, source.getString("terminal_path"));
      if (source.hasKey("rsa_key_path"))
         rsaKeyPath().setValue(layer, source.getString("rsa_key_path"));
      if (source.hasKey("use_devtools"))
         useDevtools().setValue(layer, source.getBool("use_devtools"));
      if (source.hasKey("use_internet2"))
         useInternet2().setValue(layer, source.getBool("use_internet2"));
      if (source.hasKey("use_secure_download"))
         useSecureDownload().setValue(layer, source.getBool("use_secure_download"));
      if (source.hasKey("cleanup_after_r_cmd_check"))
         cleanupAfterRCmdCheck().setValue(layer, source.getBool("cleanup_after_r_cmd_check"));
      if (source.hasKey("view_dir_after_r_cmd_check"))
         viewDirAfterRCmdCheck().setValue(layer, source.getBool("view_dir_after_r_cmd_check"));
      if (source.hasKey("hide_object_files"))
         hideObjectFiles().setValue(layer, source.getBool("hide_object_files"));
      if (source.hasKey("restore_last_project"))
         restoreLastProject().setValue(layer, source.getBool("restore_last_project"));
      if (source.hasKey("project_safe_startup_seconds"))
         projectSafeStartupSeconds().setValue(layer, source.getInteger("project_safe_startup_seconds"));
      if (source.hasKey("use_tinytex"))
         useTinytex().setValue(layer, source.getBool("use_tinytex"));
      if (source.hasKey("clean_texi2dvi_output"))
         cleanTexi2dviOutput().setValue(layer, source.getBool("clean_texi2dvi_output"));
      if (source.hasKey("latex_shell_escape"))
         latexShellEscape().setValue(layer, source.getBool("latex_shell_escape"));
      if (source.hasKey("restore_project_r_version"))
         restoreProjectRVersion().setValue(layer, source.getBool("restore_project_r_version"));
      if (source.hasKey("clang_verbose"))
         clangVerbose().setValue(layer, source.getInteger("clang_verbose"));
      if (source.hasKey("submit_crash_reports"))
         submitCrashReports().setValue(layer, source.getBool("submit_crash_reports"));
      if (source.hasKey("default_r_version"))
         defaultRVersion().setValue(layer, source.getObject("default_r_version"));
      if (source.hasKey("data_viewer_max_columns"))
         dataViewerMaxColumns().setValue(layer, source.getInteger("data_viewer_max_columns"));
      if (source.hasKey("enable_screen_reader"))
         enableScreenReader().setValue(layer, source.getBool("enable_screen_reader"));
      if (source.hasKey("typing_status_delay_ms"))
         typingStatusDelayMs().setValue(layer, source.getInteger("typing_status_delay_ms"));
      if (source.hasKey("reduced_motion"))
         reducedMotion().setValue(layer, source.getBool("reduced_motion"));
      if (source.hasKey("tab_key_move_focus"))
         tabKeyMoveFocus().setValue(layer, source.getBool("tab_key_move_focus"));
      if (source.hasKey("find_panel_legacy_tab_sequence"))
         findPanelLegacyTabSequence().setValue(layer, source.getBool("find_panel_legacy_tab_sequence"));
      if (source.hasKey("show_focus_rectangles"))
         showFocusRectangles().setValue(layer, source.getBool("show_focus_rectangles"));
      if (source.hasKey("show_panel_focus_rectangle"))
         showPanelFocusRectangle().setValue(layer, source.getBool("show_panel_focus_rectangle"));
      if (source.hasKey("auto_save_on_idle"))
         autoSaveOnIdle().setValue(layer, source.getString("auto_save_on_idle"));
      if (source.hasKey("auto_save_idle_ms"))
         autoSaveIdleMs().setValue(layer, source.getInteger("auto_save_idle_ms"));
      if (source.hasKey("auto_save_on_blur"))
         autoSaveOnBlur().setValue(layer, source.getBool("auto_save_on_blur"));
      if (source.hasKey("terminal_initial_directory"))
         terminalInitialDirectory().setValue(layer, source.getString("terminal_initial_directory"));
      if (source.hasKey("full_project_path_in_window_title"))
         fullProjectPathInWindowTitle().setValue(layer, source.getBool("full_project_path_in_window_title"));
      if (source.hasKey("visual_markdown_editing_is_default"))
         visualMarkdownEditingIsDefault().setValue(layer, source.getBool("visual_markdown_editing_is_default"));
      if (source.hasKey("visual_markdown_editing_list_spacing"))
         visualMarkdownEditingListSpacing().setValue(layer, source.getString("visual_markdown_editing_list_spacing"));
      if (source.hasKey("visual_markdown_editing_wrap"))
         visualMarkdownEditingWrap().setValue(layer, source.getString("visual_markdown_editing_wrap"));
      if (source.hasKey("visual_markdown_editing_wrap_at_column"))
         visualMarkdownEditingWrapAtColumn().setValue(layer, source.getInteger("visual_markdown_editing_wrap_at_column"));
      if (source.hasKey("visual_markdown_editing_references_location"))
         visualMarkdownEditingReferencesLocation().setValue(layer, source.getString("visual_markdown_editing_references_location"));
      if (source.hasKey("visual_markdown_editing_canonical"))
         visualMarkdownEditingCanonical().setValue(layer, source.getBool("visual_markdown_editing_canonical"));
      if (source.hasKey("visual_markdown_editing_max_content_width"))
         visualMarkdownEditingMaxContentWidth().setValue(layer, source.getInteger("visual_markdown_editing_max_content_width"));
      if (source.hasKey("visual_markdown_editing_show_doc_outline"))
         visualMarkdownEditingShowDocOutline().setValue(layer, source.getBool("visual_markdown_editing_show_doc_outline"));
      if (source.hasKey("visual_markdown_editing_show_margin"))
         visualMarkdownEditingShowMargin().setValue(layer, source.getBool("visual_markdown_editing_show_margin"));
      if (source.hasKey("visual_markdown_code_editor_line_numbers"))
         visualMarkdownCodeEditorLineNumbers().setValue(layer, source.getBool("visual_markdown_code_editor_line_numbers"));
      if (source.hasKey("visual_markdown_editing_font_size_points"))
         visualMarkdownEditingFontSizePoints().setValue(layer, source.getInteger("visual_markdown_editing_font_size_points"));
      if (source.hasKey("visual_markdown_code_editor"))
         visualMarkdownCodeEditor().setValue(layer, source.getString("visual_markdown_code_editor"));
      if (source.hasKey("zotero_libraries"))
         zoteroLibraries().setValue(layer, source.getObject("zotero_libraries"));
      if (source.hasKey("emoji_skintone"))
         emojiSkintone().setValue(layer, source.getString("emoji_skintone"));
      if (source.hasKey("disabled_aria_live_announcements"))
         disabledAriaLiveAnnouncements().setValue(layer, source.getObject("disabled_aria_live_announcements"));
      if (source.hasKey("screenreader_console_announce_limit"))
         screenreaderConsoleAnnounceLimit().setValue(layer, source.getInteger("screenreader_console_announce_limit"));
      if (source.hasKey("file_monitor_ignored_components"))
         fileMonitorIgnoredComponents().setValue(layer, source.getObject("file_monitor_ignored_components"));
      if (source.hasKey("install_pkg_deps_individually"))
         installPkgDepsIndividually().setValue(layer, source.getBool("install_pkg_deps_individually"));
      if (source.hasKey("graphics_backend"))
         graphicsBackend().setValue(layer, source.getString("graphics_backend"));
      if (source.hasKey("graphics_antialiasing"))
         graphicsAntialiasing().setValue(layer, source.getString("graphics_antialiasing"));
      if (source.hasKey("browser_fixed_width_fonts"))
         browserFixedWidthFonts().setValue(layer, source.getObject("browser_fixed_width_fonts"));
      if (source.hasKey("python_type"))
         pythonType().setValue(layer, source.getString("python_type"));
      if (source.hasKey("python_version"))
         pythonVersion().setValue(layer, source.getString("python_version"));
      if (source.hasKey("python_path"))
         pythonPath().setValue(layer, source.getString("python_path"));
      if (source.hasKey("save_retry_timeout"))
         saveRetryTimeout().setValue(layer, source.getInteger("save_retry_timeout"));
      if (source.hasKey("insert_native_pipe_operator"))
         insertNativePipeOperator().setValue(layer, source.getBool("insert_native_pipe_operator"));
      if (source.hasKey("command_palette_mru"))
         commandPaletteMru().setValue(layer, source.getBool("command_palette_mru"));
      if (source.hasKey("show_memory_usage"))
         showMemoryUsage().setValue(layer, source.getBool("show_memory_usage"));
      if (source.hasKey("memory_query_interval_seconds"))
         memoryQueryIntervalSeconds().setValue(layer, source.getInteger("memory_query_interval_seconds"));
      if (source.hasKey("terminal_python_integration"))
         terminalPythonIntegration().setValue(layer, source.getBool("terminal_python_integration"));
      if (source.hasKey("session_protocol_debug"))
         sessionProtocolDebug().setValue(layer, source.getBool("session_protocol_debug"));
      if (source.hasKey("python_project_environment_automatic_activate"))
         pythonProjectEnvironmentAutomaticActivate().setValue(layer, source.getBool("python_project_environment_automatic_activate"));
      if (source.hasKey("check_null_external_pointers"))
         checkNullExternalPointers().setValue(layer, source.getBool("check_null_external_pointers"));
      if (source.hasKey("quarto_enabled"))
         quartoEnabled().setValue(layer, source.getString("quarto_enabled"));
   }
   public List<PrefValue<?>> allPrefs()
   {
      ArrayList<PrefValue<?>> prefs = new ArrayList<PrefValue<?>>();
      prefs.add(runRprofileOnResume());
      prefs.add(saveWorkspace());
      prefs.add(loadWorkspace());
      prefs.add(initialWorkingDirectory());
      prefs.add(cranMirror());
      prefs.add(bioconductorMirrorName());
      prefs.add(bioconductorMirrorUrl());
      prefs.add(alwaysSaveHistory());
      prefs.add(removeHistoryDuplicates());
      prefs.add(showLastDotValue());
      prefs.add(lineEndingConversion());
      prefs.add(useNewlinesInMakefiles());
      prefs.add(windowsTerminalShell());
      prefs.add(posixTerminalShell());
      prefs.add(customShellCommand());
      prefs.add(customShellOptions());
      prefs.add(showLineNumbers());
      prefs.add(highlightSelectedWord());
      prefs.add(highlightSelectedLine());
      prefs.add(panes());
      prefs.add(allowSourceColumns());
      prefs.add(useSpacesForTab());
      prefs.add(numSpacesForTab());
      prefs.add(autoDetectIndentation());
      prefs.add(showMargin());
      prefs.add(blinkingCursor());
      prefs.add(marginColumn());
      prefs.add(showInvisibles());
      prefs.add(showIndentGuides());
      prefs.add(continueCommentsOnNewline());
      prefs.add(highlightWebLink());
      prefs.add(editorKeybindings());
      prefs.add(insertMatching());
      prefs.add(insertSpacesAroundEquals());
      prefs.add(insertParensAfterFunctionCompletion());
      prefs.add(tabMultilineCompletion());
      prefs.add(tabCompletion());
      prefs.add(showHelpTooltipOnIdle());
      prefs.add(surroundSelection());
      prefs.add(enableSnippets());
      prefs.add(codeCompletion());
      prefs.add(codeCompletionOther());
      prefs.add(consoleCodeCompletion());
      prefs.add(codeCompletionDelay());
      prefs.add(codeCompletionCharacters());
      prefs.add(showFunctionSignatureTooltips());
      prefs.add(showDiagnosticsR());
      prefs.add(showDiagnosticsCpp());
      prefs.add(showDiagnosticsYaml());
      prefs.add(showDiagnosticsOther());
      prefs.add(styleDiagnostics());
      prefs.add(diagnosticsOnSave());
      prefs.add(backgroundDiagnostics());
      prefs.add(backgroundDiagnosticsDelayMs());
      prefs.add(diagnosticsInRFunctionCalls());
      prefs.add(checkArgumentsToRFunctionCalls());
      prefs.add(checkUnexpectedAssignmentInFunctionCall());
      prefs.add(warnIfNoSuchVariableInScope());
      prefs.add(warnVariableDefinedButNotUsed());
      prefs.add(autoDiscoverPackageDependencies());
      prefs.add(autoAppendNewline());
      prefs.add(stripTrailingWhitespace());
      prefs.add(restoreSourceDocumentCursorPosition());
      prefs.add(reindentOnPaste());
      prefs.add(verticallyAlignArgumentsIndent());
      prefs.add(softWrapRFiles());
      prefs.add(softWrapRmdFiles());
      prefs.add(focusConsoleAfterExec());
      prefs.add(foldStyle());
      prefs.add(saveBeforeSourcing());
      prefs.add(syntaxColorConsole());
      prefs.add(highlightConsoleErrors());
      prefs.add(scrollPastEndOfDocument());
      prefs.add(highlightRFunctionCalls());
      prefs.add(rainbowParentheses());
      prefs.add(consoleLineLengthLimit());
      prefs.add(consoleMaxLines());
      prefs.add(ansiConsoleMode());
      prefs.add(limitVisibleConsole());
      prefs.add(showInlineToolbarForRCodeChunks());
      prefs.add(highlightCodeChunks());
      prefs.add(saveFilesBeforeBuild());
      prefs.add(fontSizePoints());
      prefs.add(helpFontSizePoints());
      prefs.add(editorTheme());
      prefs.add(serverEditorFontEnabled());
      prefs.add(serverEditorFont());
      prefs.add(defaultEncoding());
      prefs.add(toolbarVisible());
      prefs.add(defaultProjectLocation());
      prefs.add(sourceWithEcho());
      prefs.add(defaultSweaveEngine());
      prefs.add(defaultLatexProgram());
      prefs.add(useRoxygen());
      prefs.add(useDataimport());
      prefs.add(pdfPreviewer());
      prefs.add(alwaysEnableRnwConcordance());
      prefs.add(insertNumberedLatexSections());
      prefs.add(spellingDictionaryLanguage());
      prefs.add(spellingCustomDictionaries());
      prefs.add(documentLoadLintDelay());
      prefs.add(ignoreUppercaseWords());
      prefs.add(ignoreWordsWithNumbers());
      prefs.add(realTimeSpellchecking());
      prefs.add(navigateToBuildError());
      prefs.add(packagesPaneEnabled());
      prefs.add(cppTemplate());
      prefs.add(restoreSourceDocuments());
      prefs.add(handleErrorsInUserCodeOnly());
      prefs.add(autoExpandErrorTracebacks());
      prefs.add(checkForUpdates());
      prefs.add(showInternalFunctions());
      prefs.add(shinyViewerType());
      prefs.add(shinyBackgroundJobs());
      prefs.add(plumberViewerType());
      prefs.add(documentAuthor());
      prefs.add(rmdAutoDate());
      prefs.add(rmdPreferredTemplatePath());
      prefs.add(rmdViewerType());
      prefs.add(showPublishDiagnostics());
      prefs.add(publishCheckCertificates());
      prefs.add(usePublishCaBundle());
      prefs.add(publishCaBundle());
      prefs.add(rmdChunkOutputInline());
      prefs.add(showDocOutlineRmd());
      prefs.add(autoRunSetupChunk());
      prefs.add(hideConsoleOnChunkExecute());
      prefs.add(executionBehavior());
      prefs.add(showTerminalTab());
      prefs.add(terminalLocalEcho());
      prefs.add(terminalWebsockets());
      prefs.add(terminalCloseBehavior());
      prefs.add(terminalTrackEnvironment());
      prefs.add(terminalBellStyle());
      prefs.add(terminalRenderer());
      prefs.add(terminalWeblinks());
      prefs.add(showRmdRenderCommand());
      prefs.add(enableTextDrag());
      prefs.add(showHiddenFiles());
      prefs.add(alwaysShownFiles());
      prefs.add(alwaysShownExtensions());
      prefs.add(sortFileNamesNaturally());
      prefs.add(syncFilesPaneWorkingDir());
      prefs.add(jobsTabVisibility());
      prefs.add(showLauncherJobsTab());
      prefs.add(launcherJobsSort());
      prefs.add(busyDetection());
      prefs.add(busyExclusionList());
      prefs.add(knitWorkingDir());
      prefs.add(docOutlineShow());
      prefs.add(latexPreviewOnCursorIdle());
      prefs.add(wrapTabNavigation());
      prefs.add(globalTheme());
      prefs.add(gitDiffIgnoreWhitespace());
      prefs.add(consoleDoubleClickSelect());
      prefs.add(consoleSuspendBlockedNotice());
      prefs.add(consoleSuspendBlockedNoticeDelay());
      prefs.add(newProjGitInit());
      prefs.add(newProjUseRenv());
      prefs.add(rootDocument());
      prefs.add(showUserHomePage());
      prefs.add(reuseSessionsForProjectLinks());
      prefs.add(vcsEnabled());
      prefs.add(vcsAutorefresh());
      prefs.add(gitExePath());
      prefs.add(svnExePath());
      prefs.add(terminalPath());
      prefs.add(rsaKeyPath());
      prefs.add(useDevtools());
      prefs.add(useInternet2());
      prefs.add(useSecureDownload());
      prefs.add(cleanupAfterRCmdCheck());
      prefs.add(viewDirAfterRCmdCheck());
      prefs.add(hideObjectFiles());
      prefs.add(restoreLastProject());
      prefs.add(projectSafeStartupSeconds());
      prefs.add(useTinytex());
      prefs.add(cleanTexi2dviOutput());
      prefs.add(latexShellEscape());
      prefs.add(restoreProjectRVersion());
      prefs.add(clangVerbose());
      prefs.add(submitCrashReports());
      prefs.add(defaultRVersion());
      prefs.add(dataViewerMaxColumns());
      prefs.add(enableScreenReader());
      prefs.add(typingStatusDelayMs());
      prefs.add(reducedMotion());
      prefs.add(tabKeyMoveFocus());
      prefs.add(findPanelLegacyTabSequence());
      prefs.add(showFocusRectangles());
      prefs.add(showPanelFocusRectangle());
      prefs.add(autoSaveOnIdle());
      prefs.add(autoSaveIdleMs());
      prefs.add(autoSaveOnBlur());
      prefs.add(terminalInitialDirectory());
      prefs.add(fullProjectPathInWindowTitle());
      prefs.add(visualMarkdownEditingIsDefault());
      prefs.add(visualMarkdownEditingListSpacing());
      prefs.add(visualMarkdownEditingWrap());
      prefs.add(visualMarkdownEditingWrapAtColumn());
      prefs.add(visualMarkdownEditingReferencesLocation());
      prefs.add(visualMarkdownEditingCanonical());
      prefs.add(visualMarkdownEditingMaxContentWidth());
      prefs.add(visualMarkdownEditingShowDocOutline());
      prefs.add(visualMarkdownEditingShowMargin());
      prefs.add(visualMarkdownCodeEditorLineNumbers());
      prefs.add(visualMarkdownEditingFontSizePoints());
      prefs.add(visualMarkdownCodeEditor());
      prefs.add(zoteroLibraries());
      prefs.add(emojiSkintone());
      prefs.add(disabledAriaLiveAnnouncements());
      prefs.add(screenreaderConsoleAnnounceLimit());
      prefs.add(fileMonitorIgnoredComponents());
      prefs.add(installPkgDepsIndividually());
      prefs.add(graphicsBackend());
      prefs.add(graphicsAntialiasing());
      prefs.add(browserFixedWidthFonts());
      prefs.add(pythonType());
      prefs.add(pythonVersion());
      prefs.add(pythonPath());
      prefs.add(saveRetryTimeout());
      prefs.add(insertNativePipeOperator());
      prefs.add(commandPaletteMru());
      prefs.add(showMemoryUsage());
      prefs.add(memoryQueryIntervalSeconds());
      prefs.add(terminalPythonIntegration());
      prefs.add(sessionProtocolDebug());
      prefs.add(pythonProjectEnvironmentAutomaticActivate());
      prefs.add(checkNullExternalPointers());
      prefs.add(quartoEnabled());
      return prefs;
   }
   

   public int userLayer()
   {
      return LAYER_USER;
   }

   public int projectLayer()
   {
      return LAYER_PROJECT;
   }

   public static final int LAYER_DEFAULT  = 0;
   public static final int LAYER_COMPUTED = 1;
   public static final int LAYER_SYSTEM   = 2;
   public static final int LAYER_USER     = 3;
   public static final int LAYER_PROJECT  = 4;

   private UserPrefsAccessorConstants _constants = GWT.create(UserPrefsAccessorConstants.class);
}
