/*
 * CommandClickEvent.java
 *
 * Copyright (C) 2022 by RStudio, PBC
 *
 * Unless you have received this program directly from RStudio pursuant
 * to the terms of a commercial license agreement with RStudio, then
 * this program is licensed to you under the terms of version 3 of the
 * GNU Affero General Public License. This program is distributed WITHOUT
 * ANY EXPRESS OR IMPLIED WARRANTY, INCLUDING THOSE OF NON-INFRINGEMENT,
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Please refer to the
 * AGPL (http://www.gnu.org/licenses/agpl-3.0.txt) for more details.
 *
 */
package org.rstudio.studio.client.workbench.views.source.editors.text.events;

import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;

import org.rstudio.studio.client.workbench.views.source.editors.text.ace.AceClickEvent;

public class CommandClickEvent extends GwtEvent<CommandClickEvent.Handler>
{
   public CommandClickEvent(AceClickEvent event)
   {
      event_ = event;
   }

   public AceClickEvent getEvent()
   {
      return event_;
   }

   public NativeEvent getNativeEvent()
   {
      return event_.getNativeEvent();
   }

   private final AceClickEvent event_;

   // Boilerplate ----

   public interface Handler extends EventHandler
   {
      void onCommandClick(CommandClickEvent event);
   }

   public static final Type<Handler> TYPE = new Type<>();

   @Override
   public Type<Handler> getAssociatedType()
   {
      return TYPE;
   }

   @Override
   protected void dispatch(Handler handler)
   {
      handler.onCommandClick(this);
   }
}
