// this script is required so we can keep the arguments used by electron-forge/maker-dmg when generating the package
// Example: electron-forge make --platform=win32 --arch=x64
// On some platforms, the package name generated by electron-forge/maker-dmg has a max length set to 27 because of node-appdmg package

const getArgumentValueFromMakeCli = (argument) => {
  try {
    const value =
      process.argv[
        1 +
          process.argv
            .map((arg, index) => ({
              arg,
              index,
            }))
            .filter((arg) => arg.arg.includes('--' + argument))
            .map((arg) => arg.index)[0]
      ];

    return value;
  } catch (error) {
    console.warn(
      `Error when getting platform from "--${argument}" argument for "electron-forge make" command: `,
      error,
    );
  }

  return undefined;
};

const createFullPackageFileName = () => {
  const package = require('../package.json');
  const fs = require('fs');

  const platformName = getPlatformName();
  const archName = getArchName();

  const dmgName = `${package.productName}-electron-${platformName}-${archName}-${package.version}`.replace(
    new RegExp('\\+', 'g'),
    '-',
  );

  const outDir = `${__dirname}/../out/`;
  const filenameExtension = 'filename';

  if (!fs.existsSync(outDir)) {
    fs.mkdirSync(outDir, { recursive: true });
  }

  fs.appendFile(`${outDir}${dmgName}.${filenameExtension}`, '', function (err) {
    if (err) throw err;
    console.log('\nFull Filename Saved! Path: ', `${outDir}${dmgName}.${filenameExtension}`);
  });
};

const getPlatformName = (isShortName = true) => {
  let platformName = getArgumentValueFromMakeCli('platform') || process.platform;
  console.log(platformName);
  if (!isShortName) return platformName;

  switch (platformName) {
    case 'darwin':
      platformName = 'osx';
      break;
    case 'linux':
      platformName = 'linux';
      break;
    case 'win32':
      platformName = 'win';
      break;
    default:
      console.error(`Unsupported platform: ${platformName}`);
      process.exit(1);
  }

  return platformName;
};

const getArchName = () => {
  const archName = getArgumentValueFromMakeCli('arch') || process.arch;
  return archName;
};

exports.createFullPackageFileName = createFullPackageFileName;
exports.getPlatformName = getPlatformName;
exports.getArchName = getArchName;
