/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.table.engine;

import java.io.File;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.tmatesoft.sqljet.core.ISqlJetMutex;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetTransactionMode;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtree;
import org.tmatesoft.sqljet.core.internal.ISqlJetDbHandle;
import org.tmatesoft.sqljet.core.internal.ISqlJetFile;
import org.tmatesoft.sqljet.core.internal.ISqlJetFileSystem;
import org.tmatesoft.sqljet.core.internal.ISqlJetFileSystemsManager;
import org.tmatesoft.sqljet.core.internal.SqlJetBtreeFlags;
import org.tmatesoft.sqljet.core.internal.SqlJetFileOpenPermission;
import org.tmatesoft.sqljet.core.internal.SqlJetFileType;
import org.tmatesoft.sqljet.core.internal.SqlJetPagerJournalMode;
import org.tmatesoft.sqljet.core.internal.SqlJetSafetyLevel;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetBtree;
import org.tmatesoft.sqljet.core.internal.db.SqlJetDbHandle;
import org.tmatesoft.sqljet.core.internal.fs.SqlJetFileSystemsManager;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetSchema;
import org.tmatesoft.sqljet.core.internal.table.SqlJetOptions;
import org.tmatesoft.sqljet.core.table.ISqlJetBusyHandler;
import org.tmatesoft.sqljet.core.table.ISqlJetOptions;
import org.tmatesoft.sqljet.core.table.SqlJetDefaultBusyHandler;
import org.tmatesoft.sqljet.core.table.engine.ISqlJetEngineSynchronized;
import org.tmatesoft.sqljet.core.table.engine.ISqlJetEngineTransaction;

public class SqlJetEngine {
    private static final Set<SqlJetBtreeFlags> READ_FLAGS = Collections.unmodifiableSet(SqlJetUtility.of(SqlJetBtreeFlags.READONLY));
    private static final Set<SqlJetFileOpenPermission> READ_PERMISSIONS = Collections.unmodifiableSet(SqlJetUtility.of(SqlJetFileOpenPermission.READONLY));
    private static final Set<SqlJetBtreeFlags> WRITE_FLAGS = Collections.unmodifiableSet(SqlJetUtility.of(SqlJetBtreeFlags.READWRITE, SqlJetBtreeFlags.CREATE));
    private static final Set<SqlJetFileOpenPermission> WRITE_PREMISSIONS = Collections.unmodifiableSet(SqlJetUtility.of(SqlJetFileOpenPermission.READWRITE, SqlJetFileOpenPermission.CREATE));
    protected static final ISqlJetFileSystemsManager FILE_SYSTEM_MANAGER = SqlJetFileSystemsManager.getManager();
    protected ISqlJetFileSystem fileSystem = FILE_SYSTEM_MANAGER.find(null);
    protected boolean writable;
    protected ISqlJetDbHandle dbHandle;
    protected ISqlJetBtree btree;
    protected boolean open = false;
    protected File file;
    private boolean transaction;
    private SqlJetTransactionMode transactionMode;

    public SqlJetEngine(File file, boolean writable) {
        this.writable = writable;
        this.file = file;
    }

    public SqlJetEngine(File file, boolean writable, ISqlJetFileSystem fs) {
        this.writable = writable;
        this.file = file;
        this.fileSystem = fs;
    }

    public SqlJetEngine(File file, boolean writable, String fsName) throws SqlJetException {
        this.writable = writable;
        this.file = file;
        this.fileSystem = FILE_SYSTEM_MANAGER.find(fsName);
        if (this.fileSystem == null) {
            throw new SqlJetException(String.format("File system '%s' not found", fsName));
        }
    }

    public void registerFileSystem(ISqlJetFileSystem fs, boolean isDefault) throws SqlJetException {
        FILE_SYSTEM_MANAGER.register(fs, isDefault);
    }

    public void unregisterFileSystem(ISqlJetFileSystem fs) throws SqlJetException {
        FILE_SYSTEM_MANAGER.unregister(fs);
    }

    public File getFile() {
        return this.file;
    }

    public boolean isWritable() throws SqlJetException {
        return this.writable;
    }

    public ISqlJetFileSystem getFileSystem() {
        return this.fileSystem;
    }

    public boolean isOpen() {
        return this.open;
    }

    protected void checkOpen() throws SqlJetException {
        if (!this.isOpen()) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Database closed");
        }
    }

    public synchronized void open() throws SqlJetException {
        if (!this.open) {
            this.dbHandle = new SqlJetDbHandle(this.fileSystem);
            this.dbHandle.setBusyHandler(new SqlJetDefaultBusyHandler());
            this.btree = new SqlJetBtree();
            EnumSet<SqlJetBtreeFlags> flags = EnumSet.copyOf(this.writable ? WRITE_FLAGS : READ_FLAGS);
            EnumSet<SqlJetFileOpenPermission> permissions = EnumSet.copyOf(this.writable ? WRITE_PREMISSIONS : READ_PERMISSIONS);
            SqlJetFileType type = this.file != null ? SqlJetFileType.MAIN_DB : SqlJetFileType.TEMP_DB;
            this.btree.open(this.file, this.dbHandle, flags, type, permissions);
            ISqlJetFile file = this.btree.getPager().getFile();
            if (file != null) {
                Set<SqlJetFileOpenPermission> realPermissions = this.btree.getPager().getFile().getPermissions();
                this.writable = realPermissions.contains((Object)SqlJetFileOpenPermission.READWRITE);
            }
        } else {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Database is open already");
        }
        this.open = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object runSynchronized(ISqlJetEngineSynchronized op) throws SqlJetException {
        this.checkOpen();
        this.dbHandle.getMutex().enter();
        try {
            Object object = op.runSynchronized(this);
            Object var4_3 = null;
            this.dbHandle.getMutex().leave();
            return object;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.dbHandle.getMutex().leave();
            throw throwable;
        }
    }

    public void close() throws SqlJetException {
        if (this.open) {
            this.runSynchronized(new ISqlJetEngineSynchronized(){

                public Object runSynchronized(SqlJetEngine engine) throws SqlJetException {
                    if (SqlJetEngine.this.btree != null) {
                        SqlJetEngine.this.btree.close();
                        SqlJetEngine.this.btree = null;
                        SqlJetEngine.this.open = false;
                    }
                    SqlJetEngine.this.closeResources();
                    return null;
                }
            });
            if (!this.open) {
                this.dbHandle = null;
            }
        }
    }

    protected void closeResources() throws SqlJetException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.open) {
                this.close();
            }
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }

    protected void readSchema() throws SqlJetException {
        this.runSynchronized(new ISqlJetEngineSynchronized(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object runSynchronized(SqlJetEngine engine) throws SqlJetException {
                SqlJetEngine.this.btree.enter();
                try {
                    SqlJetEngine.this.dbHandle.setOptions(new SqlJetOptions(SqlJetEngine.this.btree, SqlJetEngine.this.dbHandle));
                    SqlJetEngine.this.btree.setSchema(new SqlJetSchema(SqlJetEngine.this.dbHandle, SqlJetEngine.this.btree));
                    Object var3_2 = null;
                    SqlJetEngine.this.btree.leave();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    SqlJetEngine.this.btree.leave();
                    throw throwable;
                }
                return null;
            }
        });
    }

    public ISqlJetOptions getOptions() throws SqlJetException {
        this.checkOpen();
        if (null == this.btree.getSchema()) {
            this.readSchema();
        }
        return this.dbHandle.getOptions();
    }

    public void refreshSchema() throws SqlJetException {
        if (null == this.btree.getSchema() || !this.getOptions().verifySchemaVersion(false)) {
            this.readSchema();
        }
    }

    protected SqlJetSchema getSchemaInternal() throws SqlJetException {
        this.checkOpen();
        this.refreshSchema();
        return this.btree.getSchema();
    }

    public ISqlJetBusyHandler getBusyHandler() {
        return this.dbHandle.getBusyHandler();
    }

    public void setBusyHandler(ISqlJetBusyHandler busyHandler) {
        this.dbHandle.setBusyHandler(busyHandler);
    }

    public ISqlJetMutex getMutex() {
        return this.dbHandle.getMutex();
    }

    public void setCacheSize(final int cacheSize) throws SqlJetException {
        this.checkOpen();
        this.runSynchronized(new ISqlJetEngineSynchronized(){

            public Object runSynchronized(SqlJetEngine engine) throws SqlJetException {
                SqlJetEngine.this.btree.setCacheSize(cacheSize);
                return null;
            }
        });
    }

    public int getCacheSize() throws SqlJetException {
        this.checkOpen();
        this.refreshSchema();
        return (Integer)this.runSynchronized(new ISqlJetEngineSynchronized(){

            public Object runSynchronized(SqlJetEngine engine) throws SqlJetException {
                return SqlJetEngine.this.btree.getCacheSize();
            }
        });
    }

    public void setSafetyLevel(final SqlJetSafetyLevel safetyLevel) throws SqlJetException {
        this.checkOpen();
        this.runSynchronized(new ISqlJetEngineSynchronized(){

            public Object runSynchronized(SqlJetEngine engine) throws SqlJetException {
                SqlJetEngine.this.btree.setSafetyLevel(safetyLevel);
                return null;
            }
        });
    }

    public void setJournalMode(final SqlJetPagerJournalMode journalMode) throws SqlJetException {
        this.checkOpen();
        this.runSynchronized(new ISqlJetEngineSynchronized(){

            public Object runSynchronized(SqlJetEngine engine) throws SqlJetException {
                SqlJetEngine.this.btree.setJournalMode(journalMode);
                return null;
            }
        });
    }

    public SqlJetSafetyLevel getSafetyLevel() throws SqlJetException {
        this.checkOpen();
        this.refreshSchema();
        return (SqlJetSafetyLevel)((Object)this.runSynchronized(new ISqlJetEngineSynchronized(){

            public Object runSynchronized(SqlJetEngine engine) throws SqlJetException {
                return SqlJetEngine.this.btree.getSafetyLevel();
            }
        }));
    }

    public SqlJetPagerJournalMode getJournalMode() throws SqlJetException {
        this.checkOpen();
        this.refreshSchema();
        return (SqlJetPagerJournalMode)((Object)this.runSynchronized(new ISqlJetEngineSynchronized(){

            public Object runSynchronized(SqlJetEngine engine) throws SqlJetException {
                return SqlJetEngine.this.btree.getJournalMode();
            }
        }));
    }

    public boolean isInTransaction() {
        return this.transaction;
    }

    public SqlJetTransactionMode getTransactionMode() {
        return this.transactionMode;
    }

    public void beginTransaction(final SqlJetTransactionMode mode) throws SqlJetException {
        this.checkOpen();
        this.runSynchronized(new ISqlJetEngineSynchronized(){

            public Object runSynchronized(SqlJetEngine engine) throws SqlJetException {
                if (!SqlJetEngine.this.isTransactionStarted(mode)) {
                    SqlJetEngine.this.doBeginTransaction(mode);
                }
                return null;
            }
        });
    }

    public void commit() throws SqlJetException {
        this.checkOpen();
        this.runSynchronized(new ISqlJetEngineSynchronized(){

            public Object runSynchronized(SqlJetEngine engine) throws SqlJetException {
                if (SqlJetEngine.this.isInTransaction()) {
                    SqlJetEngine.this.doCommitTransaction();
                }
                return null;
            }
        });
    }

    public void rollback() throws SqlJetException {
        this.checkOpen();
        this.runSynchronized(new ISqlJetEngineSynchronized(){

            public Object runSynchronized(SqlJetEngine engine) throws SqlJetException {
                SqlJetEngine.this.doRollbackTransaction();
                return null;
            }
        });
    }

    protected Object runEngineTransaction(final ISqlJetEngineTransaction op, final SqlJetTransactionMode mode) throws SqlJetException {
        this.checkOpen();
        return this.runSynchronized(new ISqlJetEngineSynchronized(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object runSynchronized(SqlJetEngine engine) throws SqlJetException {
                Object object;
                block4: {
                    if (SqlJetEngine.this.isTransactionStarted(mode)) {
                        return op.run(SqlJetEngine.this);
                    }
                    SqlJetEngine.this.doBeginTransaction(mode);
                    boolean success = false;
                    try {
                        Object result = op.run(SqlJetEngine.this);
                        SqlJetEngine.this.doCommitTransaction();
                        success = true;
                        object = result;
                        Object var6_5 = null;
                        if (success) break block4;
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        if (!success) {
                            SqlJetEngine.this.doRollbackTransaction();
                        }
                        SqlJetEngine.this.transaction = false;
                        SqlJetEngine.this.transactionMode = null;
                        throw throwable;
                    }
                    SqlJetEngine.this.doRollbackTransaction();
                }
                SqlJetEngine.this.transaction = false;
                SqlJetEngine.this.transactionMode = null;
                return object;
            }
        });
    }

    private boolean isTransactionStarted(SqlJetTransactionMode mode) {
        return this.transaction && (this.transactionMode == mode || mode == SqlJetTransactionMode.READ_ONLY);
    }

    private void doBeginTransaction(SqlJetTransactionMode mode) throws SqlJetException {
        this.btree.beginTrans(mode);
        this.refreshSchema();
        this.transaction = true;
        this.transactionMode = mode;
    }

    private void doCommitTransaction() throws SqlJetException {
        this.btree.closeAllCursors();
        this.btree.commit();
        this.transaction = false;
        this.transactionMode = null;
    }

    private void doRollbackTransaction() throws SqlJetException {
        this.btree.closeAllCursors();
        this.btree.rollback();
        this.transaction = false;
        this.transactionMode = null;
    }
}

