/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svn;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.svn.cli.svn.SVNCommand;
import org.tmatesoft.svn.cli.svn.SVNNotifyPrinter;
import org.tmatesoft.svn.cli.svn.SVNOption;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNPath;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.core.wc2.SvnUpgrade;

public class SVNUpgradeCommand
extends SVNCommand {
    public SVNUpgradeCommand() {
        super("upgrade", new String[0]);
    }

    @Override
    protected Collection createSupportedOptions() {
        LinkedList<SVNOption> options = new LinkedList<SVNOption>();
        options.add(SVNOption.QUIET);
        options.add(SVNOption.TARGETS);
        return options;
    }

    @Override
    public void run() throws SVNException {
        List<String> targets = this.getSVNEnvironment().combineTargets(this.getSVNEnvironment().getTargets(), true);
        if (targets.isEmpty()) {
            targets.add("");
        }
        SvnOperationFactory factory = new SvnOperationFactory();
        if (!this.getSVNEnvironment().isQuiet()) {
            factory.setEventHandler(new SVNNotifyPrinter(this.getSVNEnvironment()));
        }
        SvnUpgrade upgrade = factory.createUpgrade();
        for (String targetName : targets) {
            SVNPath target = new SVNPath(targetName);
            if (!target.isFile()) continue;
            this.getSVNEnvironment().checkCancelled();
            upgrade.setSingleTarget(SvnTarget.fromFile(target.getFile()));
            try {
                upgrade.run();
            }
            catch (SVNException e) {
                this.getSVNEnvironment().handleWarning(e.getErrorMessage(), new SVNErrorCode[]{SVNErrorCode.WC_NOT_DIRECTORY}, this.getSVNEnvironment().isQuiet());
            }
        }
    }
}

