/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.io.fs.FSClosestCopy;
import org.tmatesoft.svn.core.internal.io.fs.FSCopyInheritance;
import org.tmatesoft.svn.core.internal.io.fs.FSErrors;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSFile;
import org.tmatesoft.svn.core.internal.io.fs.FSID;
import org.tmatesoft.svn.core.internal.io.fs.FSNodeHistory;
import org.tmatesoft.svn.core.internal.io.fs.FSParentPath;
import org.tmatesoft.svn.core.internal.io.fs.FSRepository;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSRoot;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.SVNLocationEntry;
import org.tmatesoft.svn.util.SVNLogType;

public class FSRevisionRoot
extends FSRoot {
    private long myRevision;
    private long myRootOffset;
    private long myChangesOffset;

    public FSRevisionRoot(FSFS owner, long revision) {
        super(owner);
        this.myRevision = revision;
        this.myRootOffset = -1L;
        this.myChangesOffset = -1L;
    }

    @Override
    public long getRevision() {
        return this.myRevision;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map getChangedPaths() throws SVNException {
        try (FSFile file = this.getOwner().getPackOrRevisionFSFile(this.getRevision());){
            this.loadOffsets(file);
            file.seek(this.myChangesOffset);
            Map map = this.fetchAllChanges(file, true);
            return map;
        }
    }

    @Override
    public FSCopyInheritance getCopyInheritance(FSParentPath child) throws SVNException {
        return null;
    }

    public FSNodeHistory getNodeHistory(String path) throws SVNException {
        SVNNodeKind kind = this.checkNodeKind(path);
        if (kind == SVNNodeKind.NONE) {
            SVNErrorManager.error(FSErrors.errorNotFound(this, path), SVNLogType.FSFS);
        }
        return new FSNodeHistory(new SVNLocationEntry(this.getRevision(), SVNPathUtil.canonicalizeAbsolutePath(path)), false, new SVNLocationEntry(-1L, null), this.getOwner());
    }

    public FSClosestCopy getClosestCopy(String path) throws SVNException {
        FSParentPath parentPath = this.openPath(path, true, true);
        SVNLocationEntry copyDstEntry = FSNodeHistory.findYoungestCopyroot(this.getOwner().getRepositoryRoot(), parentPath);
        if (copyDstEntry == null || copyDstEntry.getRevision() == 0L) {
            return null;
        }
        FSRevisionRoot copyDstRoot = this.getOwner().createRevisionRoot(copyDstEntry.getRevision());
        if (copyDstRoot.checkNodeKind(path) == SVNNodeKind.NONE) {
            return null;
        }
        FSParentPath copyDstParentPath = copyDstRoot.openPath(path, true, true);
        FSRevisionNode copyDstNode = copyDstParentPath.getRevNode();
        if (!copyDstNode.getId().isRelated(parentPath.getRevNode().getId())) {
            return null;
        }
        long createdRev = copyDstNode.getCreatedRevision();
        if (createdRev == copyDstEntry.getRevision() && copyDstNode.getPredecessorId() == null) {
            return null;
        }
        return new FSClosestCopy(copyDstRoot, copyDstEntry.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FSRevisionNode getRootRevisionNode() throws SVNException {
        if (this.myRootRevisionNode == null) {
            try (FSFile file = this.getOwner().getPackOrRevisionFSFile(this.getRevision());){
                this.loadOffsets(file);
                file.seek(this.myRootOffset);
                Map headers = file.readHeader();
                this.myRootRevisionNode = FSRevisionNode.fromMap(headers);
            }
        }
        return this.myRootRevisionNode;
    }

    public SVNLocationEntry getPreviousLocation(String path, long[] appearedRevision) throws SVNException {
        FSClosestCopy closestCopy;
        if (appearedRevision != null && appearedRevision.length > 0) {
            appearedRevision[0] = -1L;
        }
        if ((closestCopy = this.getClosestCopy(path)) == null) {
            return null;
        }
        FSRevisionRoot copyTargetRoot = closestCopy.getRevisionRoot();
        String copyTargetPath = closestCopy.getPath();
        FSRevisionNode copyFromNode = copyTargetRoot.getRevisionNode(copyTargetPath);
        String copyFromPath = copyFromNode.getCopyFromPath();
        long copyFromRevision = copyFromNode.getCopyFromRevision();
        String remainder = "";
        if (!path.equals(copyTargetPath) && (remainder = path.substring(copyTargetPath.length())).startsWith("/")) {
            remainder = remainder.substring(1);
        }
        String previousPath = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(copyFromPath, remainder));
        if (appearedRevision != null && appearedRevision.length > 0) {
            appearedRevision[0] = copyTargetRoot.getRevision();
        }
        return new SVNLocationEntry(copyFromRevision, previousPath);
    }

    public long getNodeOriginRevision(String path) throws SVNException {
        String cachedOriginID;
        path = SVNPathUtil.canonicalizeAbsolutePath(path);
        FSRevisionNode node = this.getRevisionNode(path);
        String nodeID = node.getId().getNodeID();
        FSFS fsfs = this.getOwner();
        if (nodeID.startsWith("_")) {
            return -1L;
        }
        int dashIndex = nodeID.indexOf(45);
        if (dashIndex != -1 && dashIndex != nodeID.length() - 1) {
            try {
                return Long.parseLong(nodeID.substring(dashIndex + 1));
            }
            catch (NumberFormatException nfe) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, nfe), SVNLogType.FSFS);
            }
        }
        if ((cachedOriginID = fsfs.getNodeOrigin(nodeID)) != null) {
            FSID id = FSID.fromString(cachedOriginID);
            return id.getRevision();
        }
        long lastRev = -1L;
        String lastPath = path;
        FSRevisionRoot curRoot = this;
        while (true) {
            SVNLocationEntry previousLocation;
            if (FSRepository.isValidRevision(lastRev)) {
                curRoot = fsfs.createRevisionRoot(lastRev);
            }
            if ((previousLocation = curRoot.getPreviousLocation(lastPath, null)) == null) break;
            lastPath = previousLocation.getPath();
            lastRev = previousLocation.getRevision();
        }
        node = curRoot.getRevisionNode(lastPath);
        FSID predID = node.getId();
        while (predID != null) {
            node = fsfs.getRevisionNode(predID);
            predID = node.getPredecessorId();
        }
        if (!nodeID.startsWith("_")) {
            fsfs.setNodeOrigin(nodeID, node.getId());
        }
        return node.getCreatedRevision();
    }

    private void loadOffsets(FSFile file) throws SVNException {
        if (this.myRootOffset >= 0L) {
            return;
        }
        long[] rootOffset = new long[]{-1L};
        long[] changesOffset = new long[]{-1L};
        FSRepositoryUtil.loadRootChangesOffset(this.getOwner(), this.getRevision(), file, rootOffset, changesOffset);
        this.myRootOffset = rootOffset[0];
        this.myChangesOffset = changesOffset[0];
    }
}

