/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;
import org.tmatesoft.svn.core.internal.wc.ISVNUpdateEditor;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNExternal;
import org.tmatesoft.svn.core.internal.wc.SVNFileListUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.ISVNDirFetcher;
import org.tmatesoft.svn.core.internal.wc17.SVNExternalsStore;
import org.tmatesoft.svn.core.internal.wc17.SVNReporter17;
import org.tmatesoft.svn.core.internal.wc17.SVNUpdateEditor17;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.SVNWCUtils;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields;
import org.tmatesoft.svn.core.internal.wc17.db.SvnExternalFileReporter;
import org.tmatesoft.svn.core.internal.wc17.db.SvnExternalUpdateEditor;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbExternals;
import org.tmatesoft.svn.core.internal.wc2.SvnRepositoryAccess;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgInheritableProperties;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgOperationRunner;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.SVNCapability;
import org.tmatesoft.svn.core.io.SVNLocationSegment;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.ISVNConflictHandler;
import org.tmatesoft.svn.core.wc.SVNConflictChoice;
import org.tmatesoft.svn.core.wc.SVNConflictDescription;
import org.tmatesoft.svn.core.wc.SVNConflictResult;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.AbstractSvnUpdate;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnRelocate;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

public abstract class SvnNgAbstractUpdate<V, T extends AbstractSvnUpdate<V>>
extends SvnNgOperationRunner<V, T> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long update(SVNWCContext wcContext, File localAbspath, SVNRevision revision, SVNDepth depth, boolean depthIsSticky, boolean ignoreExternals, boolean allowUnversionedObstructions, boolean addsAsMoodifications, boolean makeParents, boolean innerUpdate, boolean sleepForTimestamp) throws SVNException {
        long l;
        block13: {
            assert (!innerUpdate || !makeParents);
            File lockRootPath = null;
            try {
                File anchor;
                if (makeParents) {
                    File parentPath = localAbspath;
                    ArrayList<File> missingParents = new ArrayList<File>();
                    while (true) {
                        try {
                            lockRootPath = this.getWcContext().acquireWriteLock(parentPath, !innerUpdate, true);
                        }
                        catch (SVNException e) {
                            if (e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_NOT_WORKING_COPY || SVNFileUtil.getParentFile(parentPath) == null) {
                                throw e;
                            }
                            parentPath = SVNFileUtil.getParentFile(parentPath);
                            missingParents.add(0, parentPath);
                            continue;
                        }
                        break;
                    }
                    anchor = lockRootPath;
                    for (File missingParent : missingParents) {
                        long revnum = this.updateInternal(wcContext, missingParent, anchor, revision, SVNDepth.EMPTY, false, ignoreExternals, allowUnversionedObstructions, addsAsMoodifications, sleepForTimestamp, false, ((AbstractSvnUpdate)this.getOperation()).getOptions().getConflictResolver());
                        anchor = missingParent;
                        revision = SVNRevision.create(revnum);
                    }
                } else {
                    lockRootPath = anchor = wcContext.acquireWriteLock(localAbspath, !innerUpdate, true);
                }
                RecordConflictsResolver recordConflictsResolver = new RecordConflictsResolver();
                long updateRevision = this.updateInternal(wcContext, localAbspath, anchor, revision, depth, depthIsSticky, ignoreExternals, allowUnversionedObstructions, addsAsMoodifications, sleepForTimestamp, true, recordConflictsResolver);
                ISVNConflictHandler conflictResolver = this.getWcContext().getOptions().getConflictResolver();
                if (conflictResolver != null && recordConflictsResolver.hasConflicts()) {
                    for (SVNConflictDescription conflictDescription : recordConflictsResolver.getConflicts()) {
                        this.getWcContext().resolvedConflict(conflictDescription.getPath(), SVNDepth.UNKNOWN, true, null, true, null);
                    }
                }
                l = updateRevision;
                if (lockRootPath == null) break block13;
            }
            catch (Throwable throwable) {
                if (lockRootPath != null) {
                    wcContext.releaseWriteLock(lockRootPath);
                }
                throw throwable;
            }
            wcContext.releaseWriteLock(lockRootPath);
        }
        return l;
    }

    /*
     * Unable to fully structure code
     */
    protected long updateInternal(SVNWCContext wcContext, File localAbspath, File anchorAbspath, SVNRevision revision, SVNDepth depth, boolean depthIsSticky, boolean ignoreExternals, boolean allowUnversionedObstructions, boolean addsAsMoodifications, boolean sleepForTimestamp, boolean notifySummary, ISVNConflictHandler conflictHandler) throws SVNException {
        if (depth == SVNDepth.UNKNOWN) {
            depthIsSticky = false;
        }
        target = localAbspath.equals(anchorAbspath) == false ? SVNFileUtil.getFileName(localAbspath) : "";
        nodeBaseInfo = wcContext.getNodeBase(anchorAbspath, true, false);
        reposRelPath = nodeBaseInfo.reposRelPath;
        reposRootUrl = nodeBaseInfo.reposRootUrl;
        reposUuid = nodeBaseInfo.reposUuid;
        targetConflicted = false;
        if (reposRelPath != null) {
            anchorUrl = reposRootUrl.appendPath(SVNFileUtil.getFilePath(reposRelPath), false);
            try {
                conflictInfo = wcContext.getConflicted(localAbspath, true, true, false);
                if (!conflictInfo.textConflicted && !conflictInfo.propConflicted) ** GOTO lbl20
                targetConflicted = true;
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) ** GOTO lbl20
                throw e;
            }
        } else {
            anchorUrl = null;
        }
lbl20:
        // 4 sources

        if (anchorUrl == null || targetConflicted) {
            event = SVNEventFactory.createSVNEvent(localAbspath, SVNNodeKind.UNKNOWN, null, -1L, SVNEventAction.SKIP_CONFLICTED, SVNEventAction.UPDATE_SKIP_WORKING_ONLY, null, null);
            eventHandler = ((AbstractSvnUpdate)this.getOperation()).getEventHandler();
            if (eventHandler != null) {
                eventHandler.handleEvent(event, -1.0);
            }
            return -1L;
        }
        v0 = croppingTarget = depthIsSticky != false && depth.compareTo(SVNDepth.INFINITY) < 0;
        if (croppingTarget) {
            if (depth == SVNDepth.EXCLUDE) {
                wcContext.exclude(localAbspath);
                return -1L;
            }
            targetKind = wcContext.readKind(localAbspath, true);
            if (targetKind == SVNNodeKind.DIR) {
                wcContext.cropTree(localAbspath, depth);
            }
        }
        preservedExts = ((AbstractSvnUpdate)this.getOperation()).getOptions().getPreservedConflictFileExtensions();
        useCommitTimes = ((AbstractSvnUpdate)this.getOperation()).getOptions().isUseCommitTimes();
        if (notifySummary) {
            this.handleEvent(SVNEventFactory.createSVNEvent(localAbspath, SVNNodeKind.NONE, null, -1L, SVNEventAction.UPDATE_STARTED, null, null, null, 0L, 0L));
        }
        cleanCheckout = SvnNgAbstractUpdate.isEmptyWc(localAbspath, anchorAbspath);
        repos = this.getRepositoryAccess().createRepository(anchorUrl, anchorAbspath);
        serverSupportsDepth = repos.hasCapability(SVNCapability.DEPTH);
        reporter = new SVNReporter17(localAbspath, wcContext, true, serverSupportsDepth == false, depth, ((AbstractSvnUpdate)this.getOperation()).isUpdateLocksOnDemand(), false, depthIsSticky == false, useCommitTimes, null);
        revNumber = this.getWcContext().getRevisionNumber(revision, null, repos, localAbspath);
        reposRoot = repos.getRepositoryRoot(true);
        inheritableProperties = SvnNgInheritableProperties.getInheritalbeProperites(wcContext, repos, localAbspath, revNumber, depth);
        repos2 = new SVNRepository[1];
        dirFetcher = new ISVNDirFetcher(){

            @Override
            public Map<String, SVNDirEntry> fetchEntries(SVNURL reposRoot, File path) throws SVNException {
                SVNURL url = SVNWCUtils.join(reposRoot, path);
                if (repos2[0] == null) {
                    repos2[0] = SvnNgAbstractUpdate.this.getRepositoryAccess().createRepository(url, null, false);
                } else {
                    repos2[0].setLocation(url, false);
                }
                final HashMap<String, SVNDirEntry> entries = new HashMap<String, SVNDirEntry>();
                if (repos2[0].checkPath("", revNumber) == SVNNodeKind.DIR) {
                    repos2[0].getDir("", revNumber, null, new ISVNDirEntryHandler(){

                        @Override
                        public void handleDirEntry(SVNDirEntry dirEntry) throws SVNException {
                            if (dirEntry.getName() != null && !"".equals(dirEntry.getName())) {
                                entries.put(dirEntry.getName(), dirEntry);
                            }
                        }
                    });
                    return entries;
                }
                return null;
            }
        };
        externalsStore = new SVNExternalsStore();
        editor = SVNUpdateEditor17.createUpdateEditor(wcContext, revNumber, anchorAbspath, target, inheritableProperties, useCommitTimes, null, depth, depthIsSticky, ((AbstractSvnUpdate)this.getOperation()).isAllowUnversionedObstructions(), true, serverSupportsDepth, cleanCheckout, dirFetcher, externalsStore, preservedExts, conflictHandler);
        try {
            repos.update(revNumber, target, depthIsSticky != false ? depth : SVNDepth.UNKNOWN, false, (ISVNReporterBaton)reporter, (ISVNEditor)editor);
        }
        catch (SVNException e) {
            this.sleepForTimestamp();
            throw e;
        }
        finally {
            if (repos2[0] != null) {
                repos2[0].closeSession();
            }
        }
        targetRevision = editor.getTargetRevision();
        if (targetRevision >= 0L) {
            if ((depth.isRecursive() || croppingTarget) && !((AbstractSvnUpdate)this.getOperation()).isIgnoreExternals()) {
                this.getWcContext().getDb().gatherExternalDefinitions(localAbspath, externalsStore);
                this.handleExternals(externalsStore.getNewExternals(), externalsStore.getDepths(), anchorUrl, localAbspath, reposRoot, depth, false);
            }
            if (sleepForTimestamp) {
                this.sleepForTimestamp();
            }
            if (notifySummary) {
                this.handleEvent(SVNEventFactory.createSVNEvent(localAbspath, SVNNodeKind.NONE, null, targetRevision, SVNEventAction.UPDATE_COMPLETED, null, null, null, reporter.getReportedFilesCount(), reporter.getTotalFilesCount()));
            }
        }
        return targetRevision;
    }

    protected void handleExternals(Map<File, String> newExternals, Map<File, SVNDepth> ambientDepths, SVNURL anchorUrl, File targetAbspath, SVNURL reposRoot, SVNDepth requestedDepth, boolean sleepForTimestamp) throws SVNException {
        Map<File, File> oldExternals = this.getWcContext().getDb().getExternalsDefinedBelow(targetAbspath);
        for (File externalPath : newExternals.keySet()) {
            String externalDefinition = newExternals.get(externalPath);
            SVNDepth ambientDepth = SVNDepth.INFINITY;
            if (ambientDepths != null) {
                ambientDepth = ambientDepths.get(externalPath);
            }
            this.handleExternalsChange(reposRoot, externalPath, externalDefinition, oldExternals, ambientDepth, requestedDepth);
        }
        for (File oldExternalPath : oldExternals.keySet()) {
            File definingAbsPath = oldExternals.get(oldExternalPath);
            try {
                this.handleExternalItemRemoval(definingAbsPath, oldExternalPath);
            }
            catch (SVNCancelException cancel) {
                throw cancel;
            }
            catch (SVNException e) {
                this.handleEvent(SVNEventFactory.createSVNEvent(oldExternalPath, SVNNodeKind.NONE, null, -1L, SVNEventAction.FAILED_EXTERNAL, SVNEventAction.UPDATE_EXTERNAL_REMOVED, e.getErrorMessage(), null));
            }
        }
    }

    private void handleExternalItemRemoval(File definingAbsPath, File localAbsPath) throws SVNException {
        SVNErrorMessage err;
        block9: {
            SVNNodeKind kind = this.getWcContext().readKind(localAbsPath, false);
            if (kind == SVNNodeKind.NONE) {
                SvnWcDbExternals.removeExternalNode(this.getWcContext(), localAbsPath, definingAbsPath, null);
                return;
            }
            File lockRootAbsPath = null;
            boolean lockedHere = this.getWcContext().getDb().isWCLockOwns(localAbsPath, false);
            if (!lockedHere) {
                lockRootAbsPath = this.getWcContext().acquireWriteLock(localAbsPath, false, true);
            }
            err = null;
            try {
                SvnWcDbExternals.removeExternal(this.getWcContext(), definingAbsPath, localAbsPath);
            }
            catch (SVNException e) {
                err = e.getErrorMessage();
            }
            this.handleEvent(SVNEventFactory.createSVNEvent(localAbsPath, SVNNodeKind.NONE, null, -1L, SVNEventAction.UPDATE_EXTERNAL_REMOVED, SVNEventAction.UPDATE_EXTERNAL_REMOVED, err, null, 1L, 1L));
            if (lockRootAbsPath != null) {
                try {
                    this.getWcContext().releaseWriteLock(lockRootAbsPath);
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_LOCKED) break block9;
                    throw e;
                }
            }
        }
        if (err != null && err.getErrorCode() == SVNErrorCode.WC_LEFT_LOCAL_MOD) {
            err = null;
        }
        if (err != null) {
            SVNErrorManager.error(err, SVNLogType.WC);
        }
    }

    private void handleExternalsChange(SVNURL reposRoot, File externalPath, String externalDefinition, Map<File, File> oldExternals, SVNDepth ambientDepth, SVNDepth requestedDepth) throws SVNException {
        if (requestedDepth.compareTo(SVNDepth.INFINITY) < 0 && requestedDepth != SVNDepth.UNKNOWN || ambientDepth.compareTo(SVNDepth.INFINITY) < 0 && requestedDepth.compareTo(SVNDepth.INFINITY) < 0) {
            return;
        }
        if (externalDefinition != null) {
            SVNExternal[] externals = SVNExternal.parseExternals(externalPath, externalDefinition);
            SVNURL url = this.getWcContext().getNodeUrl(externalPath);
            for (int i = 0; i < externals.length; ++i) {
                File targetAbsPath = SVNFileUtil.createFilePath(externalPath, externals[i].getPath());
                File oldExternalDefiningPath = oldExternals.get(targetAbsPath);
                try {
                    this.handleExternalItemChange(reposRoot, externalPath, url, targetAbsPath, oldExternalDefiningPath, externals[i]);
                }
                catch (SVNCancelException cancel) {
                    throw cancel;
                }
                catch (SVNException e) {
                    this.handleEvent(SVNEventFactory.createSVNEvent(targetAbsPath, SVNNodeKind.NONE, null, -1L, SVNEventAction.FAILED_EXTERNAL, SVNEventAction.UPDATE_EXTERNAL, e.getErrorMessage(), null));
                }
                if (oldExternalDefiningPath == null) continue;
                oldExternals.remove(targetAbsPath);
            }
        }
    }

    private void handleExternalItemChange(SVNURL rootUrl, File parentPath, SVNURL parentUrl, File localAbsPath, File oldDefiningPath, SVNExternal newItem) throws SVNException {
        SVNErrorMessage err;
        assert (newItem != null);
        assert (rootUrl != null && parentUrl != null);
        SVNURL newUrl = newItem.resolveURL(rootUrl, parentUrl);
        newUrl = SvnTarget.fromURL(newUrl).getURL();
        SVNRevision externalRevision = newItem.getRevision();
        SVNRevision externalPegRevision = newItem.getPegRevision();
        if (((AbstractSvnUpdate)this.getOperation()).getExternalsHandler() != null) {
            SVNRevision[] revs = ((AbstractSvnUpdate)this.getOperation()).getExternalsHandler().handleExternal(localAbsPath, newUrl, externalRevision, externalPegRevision, newItem.getRawValue(), SVNRevision.UNDEFINED);
            if (revs == null) {
                this.handleEvent(SVNEventFactory.createSVNEvent(localAbsPath, SVNNodeKind.DIR, null, -1L, SVNEventAction.SKIP, SVNEventAction.UPDATE_EXTERNAL, null, null));
                return;
            }
            externalRevision = revs.length > 0 && revs[0] != null ? revs[0] : externalRevision;
            externalPegRevision = revs.length > 1 && revs[1] != null ? revs[1] : externalPegRevision;
        }
        Structure<SvnRepositoryAccess.RepositoryInfo> repositoryInfo = this.getRepositoryAccess().createRepositoryFor(SvnTarget.fromURL(newUrl), externalRevision, externalPegRevision, null);
        SVNRepository repository = (SVNRepository)repositoryInfo.get(SvnRepositoryAccess.RepositoryInfo.repository);
        long externalRevnum = repositoryInfo.lng(SvnRepositoryAccess.RepositoryInfo.revision);
        repositoryInfo.release();
        String repositoryUUID = repository.getRepositoryUUID(true);
        SVNURL repositoryRoot = repository.getRepositoryRoot(true);
        SVNNodeKind externalKind = repository.checkPath("", externalRevnum);
        if (externalKind == SVNNodeKind.NONE) {
            err = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "URL ''{0}'' at revision {1} doesn''t exist", repository.getLocation(), externalRevnum);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (externalKind != SVNNodeKind.DIR && externalKind != SVNNodeKind.FILE) {
            err = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "URL ''{0}'' at revision {1} is not a file or a directory", repository.getLocation(), externalRevnum);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        SVNNodeKind localKind = externalKind;
        this.handleEvent(SVNEventFactory.createSVNEvent(localAbsPath, externalKind, null, -1L, SVNEventAction.UPDATE_EXTERNAL, null, null, null, 0L, 0L));
        if (oldDefiningPath == null) {
            SVNFileUtil.ensureDirectoryExists(SVNFileUtil.getParentFile(localAbsPath));
        }
        if (localKind == SVNNodeKind.DIR) {
            this.switchDirExternal(localAbsPath, newUrl, externalRevision, externalPegRevision, parentPath);
        } else if (localKind == SVNNodeKind.FILE) {
            if (!repositoryRoot.equals(rootUrl)) {
                SVNWCContext.SVNWCNodeReposInfo localReposInfo = this.getWcContext().getNodeReposInfo(parentPath);
                SVNURL localReposRootUrl = localReposInfo.reposRootUrl;
                String localReposUuid = localReposInfo.reposUuid;
                String externalRepositoryPath = SVNURLUtil.getRelativeURL(repositoryRoot, newUrl, false);
                if (localReposUuid == null || localReposRootUrl == null || externalRepositoryPath == null || !localReposUuid.equals(repositoryUUID)) {
                    SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Unsupported external: url of file external ''{0}'' is not in repository ''{0}''", newUrl, rootUrl);
                    SVNErrorManager.error(errorMessage, SVNLogType.WC);
                }
                newUrl = localReposRootUrl.appendPath(externalRepositoryPath, false);
                Structure<SvnRepositoryAccess.RepositoryInfo> repositoryInfoStructure = this.getRepositoryAccess().createRepositoryFor(SvnTarget.fromURL(newUrl), newItem.getRevision(), newItem.getPegRevision(), null);
                repository = (SVNRepository)repositoryInfoStructure.get(SvnRepositoryAccess.RepositoryInfo.repository);
                externalRevnum = repositoryInfoStructure.lng(SvnRepositoryAccess.RepositoryInfo.revision);
            }
            this.switchFileExternal(localAbsPath, newUrl, externalPegRevision, externalRevision, parentPath, repository, externalRevnum, repository.getRepositoryRoot(true));
        } else {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.ASSERTION_FAIL);
            SVNErrorManager.error(errorMessage, SVNLogType.WC);
        }
    }

    private void switchDirExternal(File localAbsPath, SVNURL url, SVNRevision revision, SVNRevision pegRevision, File definingPath) throws SVNException {
        int workingCopyFormat;
        SVNFileType fileKind;
        block8: {
            fileKind = SVNFileType.getType(localAbsPath);
            SVNWCDb.DirParsedInfo parsed = ((SVNWCDb)this.getWcContext().getDb()).parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadOnly);
            workingCopyFormat = parsed.wcDbDir.getWCRoot().getFormat();
            if (fileKind == SVNFileType.DIRECTORY) {
                SVNURL nodeUrl = null;
                try {
                    nodeUrl = this.getWcContext().getNodeUrl(localAbsPath);
                    if (nodeUrl == null) break block8;
                    if (url.equals(nodeUrl)) {
                        this.update(this.getWcContext(), localAbsPath, revision, SVNDepth.UNKNOWN, false, false, false, true, false, true, false);
                        return;
                    }
                    SVNWCContext.SVNWCNodeReposInfo nodeRepositoryInfo = this.getWcContext().getNodeReposInfo(localAbsPath);
                    SVNURL repositoryRootUrl = nodeRepositoryInfo.reposRootUrl;
                    if (nodeRepositoryInfo == null || repositoryRootUrl == null) break block8;
                    if (!SVNURLUtil.isAncestor(repositoryRootUrl, url)) {
                        SVNRepository svnRepository = this.getRepositoryAccess().createRepository(url, null, true);
                        SVNURL repositoryRoot = svnRepository.getRepositoryRoot(true);
                        SvnRelocate relocate = ((AbstractSvnUpdate)this.getOperation()).getOperationFactory().createRelocate();
                        relocate.setFromUrl(repositoryRootUrl);
                        relocate.setToUrl(repositoryRoot);
                        relocate.setSingleTarget(SvnTarget.fromFile(localAbsPath));
                        try {
                            relocate.run();
                        }
                        catch (SVNException e) {
                            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_INVALID_RELOCATION || e.getErrorMessage().getErrorCode() == SVNErrorCode.CLIENT_INVALID_RELOCATION) {
                                this.relegateExternal(localAbsPath, url, revision, pegRevision, definingPath, fileKind, workingCopyFormat);
                                return;
                            }
                            throw e;
                        }
                        repositoryRootUrl = repositoryRoot;
                    }
                    this.doSwitch(localAbsPath, url, revision, pegRevision, SVNDepth.INFINITY, true, false, false, true, false);
                    this.getWcContext().getDb().registerExternal(definingPath, localAbsPath, SVNNodeKind.DIR, repositoryRootUrl, nodeRepositoryInfo.reposUuid, SVNFileUtil.createFilePath(SVNPathUtil.getPathAsChild(repositoryRootUrl.getPath(), url.getPath())), -1L, -1L);
                    return;
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) break block8;
                    throw e;
                }
            }
        }
        this.relegateExternal(localAbsPath, url, revision, pegRevision, definingPath, fileKind, workingCopyFormat);
    }

    private void relegateExternal(File localAbsPath, SVNURL url, SVNRevision revision, SVNRevision pegRevision, File definingPath, SVNFileType fileKind, int targetWorkingCopyFormat) throws SVNException {
        if (fileKind == SVNFileType.DIRECTORY) {
            this.getWcContext().acquireWriteLock(localAbsPath, false, false);
            this.relegateExternalDir(definingPath, localAbsPath);
        } else {
            SVNFileUtil.ensureDirectoryExists(localAbsPath);
        }
        this.checkout(url, localAbsPath, pegRevision, revision, SVNDepth.INFINITY, false, false, false, targetWorkingCopyFormat);
        SVNWCContext.SVNWCNodeReposInfo nodeRepositoryInfo = this.getWcContext().getNodeReposInfo(localAbsPath);
        this.getWcContext().getDb().registerExternal(definingPath, localAbsPath, SVNNodeKind.DIR, nodeRepositoryInfo.reposRootUrl, nodeRepositoryInfo.reposUuid, SVNFileUtil.createFilePath(SVNPathUtil.getPathAsChild(nodeRepositoryInfo.reposRootUrl.getPath(), url.getPath())), -1L, -1L);
    }

    private void relegateExternalDir(File wriAbsPath, File localAbsPath) throws SVNException {
        try {
            SvnWcDbExternals.removeExternal(this.getWcContext(), wriAbsPath, localAbsPath);
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_LEFT_LOCAL_MOD) {
                File oldName = SVNFileUtil.createUniqueFile(localAbsPath.getParentFile(), localAbsPath.getName(), ".OLD", false);
                SVNFileUtil.deleteFile(oldName);
                SVNFileUtil.rename(localAbsPath, oldName);
                return;
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchFileExternal(File localAbsPath, SVNURL url, SVNRevision pegRevision, SVNRevision revision, File defDirAbspath, SVNRepository repository, long repositoryRevision, SVNURL reposRootUrl) throws SVNException {
        SVNErrorMessage err;
        String defPath;
        File wcRoot;
        String rootPath;
        File dirAbspath = SVNFileUtil.getParentFile(localAbsPath);
        boolean lockedHere = this.getWcContext().getDb().isWCLockOwns(dirAbspath, false);
        if (!lockedHere && !SVNPathUtil.isAncestor(rootPath = (wcRoot = this.getWcContext().getDb().getWCRoot(dirAbspath)).getAbsolutePath().replace(File.separatorChar, '/'), defPath = defDirAbspath.getAbsolutePath().replace(File.separatorChar, '/'))) {
            err = SVNErrorMessage.create(SVNErrorCode.WC_BAD_PATH, "Cannot insert a file external defined on ''{0}'' into the working copy ''{1}''", defDirAbspath, wcRoot);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        SVNNodeKind kind = SVNNodeKind.NONE;
        SVNNodeKind externalKind = SVNNodeKind.NONE;
        try {
            kind = this.getWcContext().readKind(localAbsPath, false);
            Structure<StructureFields.ExternalNodeInfo> externalInfo = null;
            try {
                externalInfo = SvnWcDbExternals.readExternal(this.getWcContext(), localAbsPath, localAbsPath, StructureFields.ExternalNodeInfo.kind);
                ISVNWCDb.SVNWCDbKind eKind = (ISVNWCDb.SVNWCDbKind)((Object)externalInfo.get(StructureFields.ExternalNodeInfo.kind));
                if (eKind != null) {
                    externalKind = eKind.toNodeKind();
                }
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_PATH_NOT_FOUND) {
                    throw e;
                }
            }
            finally {
                if (externalInfo != null) {
                    externalInfo.release();
                }
            }
        }
        catch (SVNException e) {
            if (!lockedHere) {
                this.getWcContext().releaseWriteLock(dirAbspath);
            }
            throw e;
        }
        if (kind != SVNNodeKind.NONE && kind != SVNNodeKind.UNKNOWN) {
            if (externalKind != SVNNodeKind.FILE) {
                if (!lockedHere) {
                    this.getWcContext().releaseWriteLock(dirAbspath);
                }
                SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.CLIENT_FILE_EXTERNAL_OVERWRITE_VERSIONED, "The file external from ''{0}'' cannot overwrite the existing versioned item at ''{1}''", url, localAbsPath);
                SVNErrorManager.error(err2, SVNLogType.WC);
            }
        } else {
            SVNNodeKind diskKind = SVNFileType.getNodeKind(SVNFileType.getType(localAbsPath));
            if (diskKind == SVNNodeKind.FILE || diskKind == SVNNodeKind.DIR) {
                if (!lockedHere) {
                    this.getWcContext().releaseWriteLock(dirAbspath);
                }
                err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_FOUND, "The file external ''{0}'' can not be created because the node exists.", (Object)localAbsPath);
                SVNErrorManager.error(err, SVNLogType.WC);
                return;
            }
        }
        SvnTarget target = SvnTarget.fromURL(url);
        Structure<SvnRepositoryAccess.RepositoryInfo> repositoryInfo = this.getRepositoryAccess().createRepositoryFor(target, revision, pegRevision, dirAbspath);
        repository = (SVNRepository)repositoryInfo.get(SvnRepositoryAccess.RepositoryInfo.repository);
        long revnum = repositoryInfo.lng(SvnRepositoryAccess.RepositoryInfo.revision);
        SVNURL switchUrl = (SVNURL)repositoryInfo.get(SvnRepositoryAccess.RepositoryInfo.url);
        repositoryInfo.release();
        String uuid = repository.getRepositoryUUID(true);
        String[] preservedExts = ((AbstractSvnUpdate)this.getOperation()).getOptions().getPreservedConflictFileExtensions();
        boolean useCommitTimes = ((AbstractSvnUpdate)this.getOperation()).getOptions().isUseCommitTimes();
        Map<String, SVNProperties> iprops = repository.getInheritedProperties("", revnum, null);
        if (iprops != null && !iprops.isEmpty()) {
            iprops = SvnNgInheritableProperties.translateInheritedPropertiesPaths(iprops);
        }
        repository.setLocation(SVNURL.parseURIEncoded(SVNPathUtil.removeTail(url.toString())), true);
        File definitionAbsPath = SVNFileUtil.getParentFile(localAbsPath);
        ISVNUpdateEditor updateEditor = SvnExternalUpdateEditor.createEditor(this.getWcContext(), localAbsPath, definitionAbsPath, switchUrl, reposRootUrl, uuid, iprops, useCommitTimes, preservedExts, definitionAbsPath, url, pegRevision, revision);
        SvnExternalFileReporter reporter = new SvnExternalFileReporter(this.getWcContext(), localAbsPath, true, useCommitTimes);
        repository.update(url, revnum, SVNFileUtil.getFileName(localAbsPath), SVNDepth.UNKNOWN, (ISVNReporterBaton)reporter, (ISVNEditor)updateEditor);
        this.handleEvent(SVNEventFactory.createSVNEvent(localAbsPath, SVNNodeKind.NONE, null, revnum, SVNEventAction.UPDATE_COMPLETED, null, null, null, 1L, 1L));
        if (!lockedHere) {
            this.getWcContext().releaseWriteLock(dirAbspath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long doSwitch(File localAbsPath, SVNURL switchUrl, SVNRevision revision, SVNRevision pegRevision, SVNDepth depth, boolean depthIsSticky, boolean ignoreExternals, boolean allowUnversionedObstructions, boolean ignoreAncestry, boolean sleepForTimestamp) throws SVNException {
        File anchor = null;
        boolean releaseLock = false;
        try {
            try {
                anchor = this.getWcContext().obtainAnchorPath(localAbsPath, true, true);
                this.getWcContext().getDb().obtainWCLock(anchor, -1, false);
                releaseLock = true;
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_LOCKED) {
                    throw e;
                }
                releaseLock = false;
            }
            this.getWcContext().getDb().clearDavCacheRecursive(localAbsPath);
            long l = this.switchInternal(localAbsPath, anchor, switchUrl, revision, pegRevision, depth, depthIsSticky, ignoreExternals, allowUnversionedObstructions, ignoreAncestry, sleepForTimestamp);
            return l;
        }
        finally {
            if (anchor != null && releaseLock) {
                this.getWcContext().releaseWriteLock(anchor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long switchInternal(File localAbsPath, File anchor, SVNURL switchUrl, SVNRevision revision, SVNRevision pegRevision, SVNDepth depth, boolean depthIsSticky, boolean ignoreExternals, boolean allowUnversionedObstructions, boolean ignoreAncestry, boolean sleepForTimestamp) throws SVNException {
        if (depth == SVNDepth.UNKNOWN) {
            depthIsSticky = false;
        }
        Structure<StructureFields.NodeInfo> nodeInfo = this.getWcContext().getDb().readInfo(localAbsPath, StructureFields.NodeInfo.haveWork);
        try {
            if (nodeInfo.is(StructureFields.NodeInfo.haveWork)) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot switch ''{0}'' because it is not in the repository yet", (Object)localAbsPath);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
        }
        finally {
            nodeInfo.release();
        }
        String[] preservedExts = ((AbstractSvnUpdate)this.getOperation()).getOptions().getPreservedConflictFileExtensions();
        boolean useCommitTimes = ((AbstractSvnUpdate)this.getOperation()).getOptions().isUseCommitTimes();
        String target = !localAbsPath.equals(anchor) ? SVNFileUtil.getFileName(localAbsPath) : "";
        SVNURL anchorUrl = this.getWcContext().getNodeUrl(anchor);
        if (anchorUrl == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "Directory ''{0}'' has no URL", (Object)anchor);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (depthIsSticky && depth.compareTo(SVNDepth.INFINITY) < 0) {
            if (depth == SVNDepth.EXCLUDE) {
                this.getWcContext().exclude(localAbsPath);
                return -1L;
            }
            SVNNodeKind targetKind = this.getWcContext().readKind(localAbsPath, true);
            if (targetKind == SVNNodeKind.DIR) {
                this.getWcContext().cropTree(localAbsPath, depth);
            }
        }
        Structure<SvnRepositoryAccess.RepositoryInfo> repositoryInfo = this.getRepositoryAccess().createRepositoryFor(SvnTarget.fromURL(switchUrl), revision, pegRevision, anchor);
        SVNRepository repository = (SVNRepository)repositoryInfo.get(SvnRepositoryAccess.RepositoryInfo.repository);
        final long revnum = repositoryInfo.lng(SvnRepositoryAccess.RepositoryInfo.revision);
        SVNURL switchRevUrl = (SVNURL)repositoryInfo.get(SvnRepositoryAccess.RepositoryInfo.url);
        repositoryInfo.release();
        SVNURL switchRootUrl = repository.getRepositoryRoot(true);
        if (!anchorUrl.equals(switchRootUrl) && !anchorUrl.toString().startsWith(switchRootUrl.toString() + "/")) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_SWITCH, "''{0}'' is not the same repository as ''{1}''", anchorUrl, switchRootUrl);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (!ignoreAncestry) {
            SVNURL targetUrl = this.getWcContext().getNodeUrl(localAbsPath);
            long targetRev = this.getWcContext().getNodeBaseRev(localAbsPath);
            SVNLocationSegment ancestor = this.getRepositoryAccess().getYoungestCommonAncestor(switchRevUrl, revnum, targetUrl, targetRev);
            if (ancestor.getPath() == null || ancestor.getStartRevision() < 0L) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_UNRELATED_RESOURCES, "''{0}'' shares no common ancestry with ''{1}''", switchUrl, localAbsPath);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
        }
        HashMap<File, Map<String, SVNProperties>> wcIprops = new HashMap<File, Map<String, SVNProperties>>();
        if (!switchRootUrl.equals(switchRevUrl)) {
            boolean isWcRoot = this.getWcContext().checkWCRoot((File)localAbsPath, (boolean)false).wcRoot;
            boolean needsCache = true;
            if (!isWcRoot) {
                SVNURL parentURL = this.getWcContext().getNodeUrl(SVNFileUtil.getParentFile(localAbsPath));
                boolean bl = needsCache = !parentURL.appendPath(localAbsPath.getName(), false).equals(switchRevUrl);
            }
            if (needsCache) {
                Map<String, SVNProperties> iprops = repository.getInheritedProperties("", revnum, null);
                iprops = SvnNgInheritableProperties.translateInheritedPropertiesPaths(iprops);
                wcIprops.put(localAbsPath, iprops);
            }
        }
        repository.setLocation(anchorUrl, false);
        boolean serverSupportsDepth = repository.hasCapability(SVNCapability.DEPTH);
        SVNExternalsStore externalsStore = new SVNExternalsStore();
        final SVNRepository[] repos2 = new SVNRepository[1];
        ISVNDirFetcher dirFetcher = new ISVNDirFetcher(){

            @Override
            public Map<String, SVNDirEntry> fetchEntries(SVNURL reposRoot, File path) throws SVNException {
                SVNURL url = SVNWCUtils.join(reposRoot, path);
                if (repos2[0] == null) {
                    repos2[0] = SvnNgAbstractUpdate.this.getRepositoryAccess().createRepository(url, null, false);
                } else {
                    repos2[0].setLocation(url, false);
                }
                final HashMap<String, SVNDirEntry> entries = new HashMap<String, SVNDirEntry>();
                SVNNodeKind kind = repos2[0].checkPath("", revnum);
                if (kind == SVNNodeKind.DIR) {
                    repos2[0].getDir("", revnum, null, new ISVNDirEntryHandler(){

                        @Override
                        public void handleDirEntry(SVNDirEntry dirEntry) throws SVNException {
                            if (dirEntry.getName() != null && !"".equals(dirEntry.getName())) {
                                entries.put(dirEntry.getName(), dirEntry);
                            }
                        }
                    });
                }
                return entries;
            }
        };
        SVNReporter17 reporter = new SVNReporter17(localAbsPath, this.getWcContext(), true, !serverSupportsDepth, depth, ((AbstractSvnUpdate)this.getOperation()).isUpdateLocksOnDemand(), false, !depthIsSticky, useCommitTimes, null);
        ISVNUpdateEditor editor = SVNUpdateEditor17.createUpdateEditor(this.getWcContext(), revnum, anchor, target, wcIprops, useCommitTimes, switchRevUrl, depth, depthIsSticky, allowUnversionedObstructions, false, serverSupportsDepth, false, dirFetcher, externalsStore, preservedExts, ((AbstractSvnUpdate)this.getOperation()).getOptions().getConflictResolver());
        try {
            repository.diff(switchRevUrl, revnum, revnum, target, ignoreAncestry, depthIsSticky ? depth : SVNDepth.UNKNOWN, true, (ISVNReporterBaton)reporter, (ISVNEditor)editor);
        }
        catch (SVNException e) {
            this.sleepForTimestamp();
            throw e;
        }
        if (depth.isRecursive() && !((AbstractSvnUpdate)this.getOperation()).isIgnoreExternals()) {
            this.getWcContext().getDb().gatherExternalDefinitions(localAbsPath, externalsStore);
            this.handleExternals(externalsStore.getNewExternals(), externalsStore.getDepths(), anchorUrl, localAbsPath, switchRootUrl, depth, true);
        }
        if (sleepForTimestamp) {
            this.sleepForTimestamp();
        }
        this.handleEvent(SVNEventFactory.createSVNEvent(localAbsPath, SVNNodeKind.NONE, null, revnum, SVNEventAction.UPDATE_COMPLETED, null, null, null, reporter.getReportedFilesCount(), reporter.getTotalFilesCount()));
        return editor.getTargetRevision();
    }

    protected long checkout(SVNURL url, File localAbspath, SVNRevision pegRevision, SVNRevision revision, SVNDepth depth, boolean ignoreExternals, boolean allowUnversionedObstructions, boolean sleepForTimestamp, int targetWorkingCopyFormat) throws SVNException {
        SVNErrorMessage err;
        Structure<SvnRepositoryAccess.RepositoryInfo> repositoryInfo = this.getRepositoryAccess().createRepositoryFor(SvnTarget.fromURL(url), revision, pegRevision, null);
        url = (SVNURL)repositoryInfo.get(SvnRepositoryAccess.RepositoryInfo.url);
        SVNRepository repository = (SVNRepository)repositoryInfo.get(SvnRepositoryAccess.RepositoryInfo.repository);
        long revnum = repositoryInfo.lng(SvnRepositoryAccess.RepositoryInfo.revision);
        repositoryInfo.release();
        SVNURL rootUrl = repository.getRepositoryRoot(true);
        String uuid = repository.getRepositoryUUID(true);
        SVNNodeKind kind = repository.checkPath("", revnum);
        if (kind == SVNNodeKind.FILE) {
            err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "URL ''{0}'' refers to a file, not a directory", (Object)url);
            SVNErrorManager.error(err, SVNLogType.WC);
        } else if (kind == SVNNodeKind.NONE) {
            err = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "URL ''{0}'' doesn''t exist", (Object)url);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        SVNFileType fileKind = SVNFileType.getType(localAbspath);
        if (fileKind == SVNFileType.NONE) {
            SVNFileUtil.ensureDirectoryExists(localAbspath);
            this.getWcContext().initializeWC(localAbspath, url, rootUrl, uuid, revnum, depth == SVNDepth.UNKNOWN ? SVNDepth.INFINITY : depth, targetWorkingCopyFormat);
        } else if (fileKind == SVNFileType.DIRECTORY) {
            int formatVersion = this.getWcContext().checkWC(localAbspath);
            if (formatVersion >= 29 && SvnOperationFactory.isVersionedDirectory(localAbspath)) {
                SVNURL entryUrl = this.getWcContext().getNodeUrl(localAbspath);
                if (entryUrl != null && !url.equals(entryUrl)) {
                    String message = "''{0}'' is already a working copy for a different URL";
                    message = message + "; perform update to complete it";
                    SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, message, (Object)localAbspath);
                    SVNErrorManager.error(err2, SVNLogType.WC);
                }
            } else {
                depth = depth == SVNDepth.UNKNOWN ? SVNDepth.INFINITY : depth;
                this.getWcContext().initializeWC(localAbspath, url, rootUrl, uuid, revnum, depth == SVNDepth.UNKNOWN ? SVNDepth.INFINITY : depth, targetWorkingCopyFormat);
            }
        } else {
            SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.WC_NODE_KIND_CHANGE, "''{0}'' already exists and is not a directory", (Object)localAbspath);
            SVNErrorManager.error(err3, SVNLogType.WC);
        }
        return this.update(this.getWcContext(), localAbspath, revision, depth, true, ignoreExternals, allowUnversionedObstructions, true, false, false, sleepForTimestamp);
    }

    protected static boolean isEmptyWc(File root, File anchorAbspath) {
        if (!root.equals(anchorAbspath)) {
            return false;
        }
        File[] children = SVNFileListUtil.listFiles(root);
        if (children != null) {
            return children.length == 1 && SVNFileUtil.getAdminDirectoryName().equals(children[0].getName());
        }
        return true;
    }

    private static class RecordConflictsResolver
    implements ISVNConflictHandler {
        private final List<SVNConflictDescription> conflicts = new ArrayList<SVNConflictDescription>();

        private RecordConflictsResolver() {
        }

        @Override
        public SVNConflictResult handleConflict(SVNConflictDescription conflictDescription) throws SVNException {
            this.conflicts.add(conflictDescription);
            return new SVNConflictResult(SVNConflictChoice.POSTPONE, null);
        }

        private List<SVNConflictDescription> getConflicts() {
            return this.conflicts;
        }

        public boolean hasConflicts() {
            return this.conflicts.size() > 0;
        }
    }
}

