from mercurial.node import hex
from mercurial import bookmarks, merge

def sgwtstate(ui, repo, **opts):
    ctx = repo[None]
    parents = [p for p in ctx.parents() if p.rev() >= 0]

    ui.write('heads\t', len(parents), '\n')
    for p in parents:
        ui.write('head\t', hex(p.node()), '\n')

    if len(parents) >= 2:
        commonAncestor = repo.changelog.ancestor(parents[0].node(), parents[1].node())
        ui.write('commonancestor\t', hex(commonAncestor), '\n')

    ui.write('headrev\t', parents[0].rev() if len(parents) >= 1 else -1, '\n')

    tip = repo[len(repo) - 1] if len(repo) >= 1 else None
    ui.write('tip\t', hex(tip.node()) if tip is not None else '', '\n')
    ui.write('tiprev\t', tip.rev() if tip is not None else -1, '\n')

    branch = ctx.branch()
    ui.write('branch\t', branch, '\n')

    try:
        bookmark = bookmarks.readactive(repo)
    except AttributeError:
        bookmark = bookmarks.readcurrent(repo)
    ui.write('bookmark\t', bookmark if bookmark is not None else '', '\n')

    mergestate = merge.mergestate(repo)
    mergestateactive = mergestate.active()
    ui.write('mergestate\t', mergestateactive, '\n')
    if mergestateactive:
        unresolved = list(mergestate.unresolved())
        ui.write('unresolved\t', len(unresolved), '\n')
        for f in unresolved:
            ui.write(f, '\n')

    ui.write('state\t')
    try:
        f = repo.opener('graftstate')
        try:
            nodes = f.read().splitlines()
            ui.write('grafting')
        finally:
            f.close()
        return
    except IOError:
        pass

    try:
        f = repo.opener("rebasestate")
        try:
            wdparent = -1
            target = -1
            for i, l in enumerate(f.read().splitlines()):
                if i == 0:
                    wdparent = repo[l].rev()
                elif i == 1:
                    target = repo[l].rev()

            ui.write('rebasing\n')
            ui.write('wdparent\t', hex(repo[wdparent].node()) if wdparent >= 0 else '', '\n')
            ui.write('wdparentrev\t', wdparent, '\n')
            ui.write('target\t', hex(repo[target].node()) if target >= 0 else '', '\n')
            ui.write('targetrev\t', target, '\n')
        finally:
            f.close()
        return
    except IOError:
        pass

    if len(parents) >= 2:
        ui.write('merging\n')
    else:
        ui.write('normal\n')

cmdtable = {
    'sgwtstate': (sgwtstate, [])
}
