/*******************************************************************************
 * Copyright (c) 2000, 2011 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     Syntevo GmbH    - major redesign
 *******************************************************************************/
package com.syntevo.q.swt;

import java.util.List;

import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.*;

final class QTabFolderLayout extends Layout {

	// Constants ==============================================================

	static final int SPACE_RIGHT_BESIDE_TOPRIGHT = 0;
	static final int MIN_TAB_WIDTH = 32;

	// Setup ==================================================================

	public QTabFolderLayout() {
	}

	// Implemented ============================================================

	@Override
	protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
		final QTabFolder folder = (QTabFolder)composite;
		final List<QTabFolderItem> items = folder.getItemsList();

		int tabWidth = items.size() * MIN_TAB_WIDTH + 3;

		final Control topRightControl = folder.getTopRight();
		if (topRightControl != null) {
			final Point pt = topRightControl.computeSize(SWT.DEFAULT, folder.getTabHeight(), flushCache);
			tabWidth += SPACE_RIGHT_BESIDE_TOPRIGHT + pt.x;
		}

		int controlW = 0;
		int controlH = 0;
		// preferred size of controls in tab items
		for (QTabFolderItem item : items) {
			final Point size = folder.getPreferredSize(item.getControl(), flushCache);
			controlW = Math.max(controlW, size.x);
			controlH = Math.max(controlH, size.y);
		}

		final Rectangle trim = folder.computeTrim(0, 0, Math.max(tabWidth, controlW), controlH);
		return new Point(trim.width, trim.height);
	}

	@Override
	protected boolean flushCache(Control control) {
		return true;
	}

	@Override
	protected void layout(Composite composite, boolean flushCache) {
		final QTabFolder folder = (QTabFolder)composite;

		final QTabFolderItem selectedItem = folder.getSelection();
		if (selectedItem == null) {
			return;
		}

		selectedItem.getControl().setBounds(folder.getClientArea());
		folder.updateItems();
	}
}
