/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.plugin.common.bugtracker.commit.messagesource;

import com.syntevo.openapi.deprecated.smartsvn.command.SvnClients;
import com.syntevo.openapi.deprecated.smartsvn.file.Path;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.subversion.javahl.ISVNClient;
import org.apache.subversion.javahl.SubversionException;
import org.apache.subversion.javahl.callback.InfoCallback;
import org.apache.subversion.javahl.types.Depth;
import org.apache.subversion.javahl.types.Info;
import org.apache.subversion.javahl.types.Revision;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BugtrackerCommitMessageSourceUtils {
    private static final String BUGTRAQ_URL = "bugtraq:url";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static String findBugtraqURL(@NotNull SvnClients clients, @NotNull Path path) {
        try {
            ISVNClient svnClient = clients.createClient();
            try {
                for (File directory = path.getFile(); directory != null; directory = directory.getParentFile()) {
                    block12: {
                        Info[] infoContainer;
                        block10: {
                            String url;
                            block11: {
                                byte[] propertyData = svnClient.propertyGet(directory.getAbsolutePath(), BUGTRAQ_URL, Revision.WORKING, Revision.WORKING);
                                infoContainer = new Info[1];
                                svnClient.info2(directory.getAbsolutePath(), null, null, Depth.empty, null, new InfoCallback(){

                                    public void singleInfo(Info info) {
                                        if (infoContainer[0] == null) {
                                            infoContainer[0] = info;
                                        }
                                    }
                                });
                                if (propertyData == null || propertyData.length == 0) break block10;
                                url = new String(propertyData, "ASCII");
                                if (url.startsWith("/")) break block11;
                                String string = url;
                                svnClient.dispose();
                                return string;
                            }
                            String rootURL = infoContainer[0].getReposRootUrl();
                            String string = BugtrackerCommitMessageSourceUtils.getFullURL(url, rootURL);
                            svnClient.dispose();
                            return string;
                        }
                        String wcroot = infoContainer[0].getWcroot();
                        if (wcroot == null || !wcroot.equals(directory.getAbsolutePath())) break block12;
                        String string = null;
                        svnClient.dispose();
                        return string;
                    }
                    continue;
                    catch (UnsupportedEncodingException | URISyntaxException | SubversionException ex) {
                        // empty catch block
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                svnClient.dispose();
                throw throwable;
            }
            svnClient.dispose();
            return null;
        }
        catch (SubversionException subversionException) {
            // empty catch block
        }
        return null;
    }

    @NotNull
    public static String getFullURL(@NotNull String shortURL, @NotNull String repositoryRoot) throws URISyntaxException {
        if (shortURL.startsWith("/")) {
            StringBuilder fullURL = new StringBuilder();
            URI repositoryRootURL = new URI(repositoryRoot);
            fullURL.append(repositoryRootURL.getScheme());
            fullURL.append("://");
            fullURL.append(repositoryRootURL.getHost());
            if (shortURL.startsWith("/:")) {
                fullURL.append(shortURL.substring(1));
            } else if (repositoryRootURL.getPort() != -1) {
                fullURL.append(":");
                fullURL.append(repositoryRootURL.getPort());
            } else {
                fullURL.append(shortURL);
            }
            return fullURL.toString();
        }
        if (shortURL.startsWith("^/")) {
            String fullURL;
            shortURL = shortURL.substring(2);
            while (shortURL.startsWith("../")) {
                shortURL = shortURL.substring(3);
                repositoryRoot = BugtrackerCommitMessageSourceUtils.removePathTail(repositoryRoot);
            }
            if (shortURL.startsWith("/")) {
                shortURL = shortURL.substring(1);
            }
            if ((fullURL = repositoryRoot).endsWith("/")) {
                fullURL = fullURL.substring(0, fullURL.length() - 1);
            }
            return fullURL + "/" + shortURL;
        }
        return shortURL;
    }

    private static String removePathTail(String path) throws URISyntaxException {
        URI pathURI = new URI(path);
        String newPath = BugtrackerCommitMessageSourceUtils.removeTail(pathURI.getPath());
        URI uri = new URI(pathURI.getScheme(), pathURI.getUserInfo(), pathURI.getHost(), pathURI.getPort(), newPath, pathURI.getQuery(), pathURI.getFragment());
        return uri.toString();
    }

    private static String removeTail(String path) {
        for (int index = path.length() - 1; index >= 0; --index) {
            if (path.charAt(index) != '/') continue;
            return path.substring(0, index);
        }
        return "";
    }
}

