/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.plugin.jira.commit;

public class JiraUrl {
    private static final String VIEW_ISSUE_SIGNATURE = "ViewIssue.jspa?key=";
    private static final String BROWSE_SIGNATURE = "browse/";
    private final String baseUrl;
    private final String projectKey;

    public static JiraUrl parseFromBugtraqUrls(String url) {
        if (url == null) {
            return null;
        }
        String baseUrl = JiraUrl.extractBaseURL(url);
        String projectKey = JiraUrl.extractProjectKey(url);
        if (baseUrl == null || projectKey == null) {
            return null;
        }
        return new JiraUrl(baseUrl, projectKey);
    }

    public JiraUrl(String baseUrl, String projectKey) {
        this.baseUrl = baseUrl;
        this.projectKey = projectKey;
    }

    public String toString() {
        return this.baseUrl + "/" + this.projectKey;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    private static String extractBaseURL(String url) {
        String signature = JiraUrl.findSignature(url);
        if (signature == null) {
            return null;
        }
        int signatureIndex = url.indexOf(signature);
        if ((url = url.substring(0, signatureIndex)).endsWith("/secure/")) {
            url = url.substring(0, url.length() - "/secure/".length());
        }
        return url;
    }

    private static String extractProjectKey(String url) {
        String signature = JiraUrl.findSignature(url);
        if (signature == null) {
            return null;
        }
        int startIndex = url.indexOf(signature);
        int hyphenIndex = (url = url.substring(startIndex + signature.length())).indexOf("-");
        if (hyphenIndex == -1) {
            return null;
        }
        return url.substring(0, hyphenIndex);
    }

    private static String findSignature(String url) {
        if (url.indexOf(VIEW_ISSUE_SIGNATURE) >= 0) {
            return VIEW_ISSUE_SIGNATURE;
        }
        if (url.indexOf(BROWSE_SIGNATURE) >= 0) {
            return BROWSE_SIGNATURE;
        }
        return null;
    }
}

