/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.plugin.jira.commit.messagesource;

import com.syntevo.openapi.deprecated.gui.GuiSpacings;
import com.syntevo.openapi.deprecated.gui.dialog.AbstractDialog;
import com.syntevo.openapi.deprecated.gui.dialog.DialogDisplayer;
import com.syntevo.openapi.deprecated.gui.dialog.IDialogResultHandler;
import com.syntevo.openapi.deprecated.smartsvn.command.commit.ICommitMessageSource;
import com.syntevo.openapi.deprecated.smartsvn.settings.SettingsServices;
import com.syntevo.openapi.deprecated.util.Consumer;
import com.syntevo.plugin.jira.commit.JiraUIConnection;
import com.syntevo.plugin.jira.commit.messagesource.JiraCommitMessageSourceDialog;
import com.syntevo.plugin.jira.commit.messagesource.JiraIssueLoader;
import com.syntevo.plugin.jira.commit.messagesource.JiraIssueTable;
import com.syntevo.plugin.jira.commit.messagesource.JiraQueryConfiguration;
import com.syntevo.plugin.jira.transport.JiraIssue;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Display;
import org.jetbrains.annotations.NotNull;

final class JiraCommitMessageSource
implements ICommitMessageSource,
JiraIssueTable {
    private final DialogDisplayer dialogDisplayer;
    private final JiraIssueLoader issueLoader;
    private final JiraQueryConfiguration queryConfiguration;
    private List<JiraIssue> pendingIssues = new ArrayList<JiraIssue>();
    private JiraCommitMessageSourceDialog currentDialog;

    public JiraCommitMessageSource(String baseUrl, SettingsServices settingsServices, String projectKey, GuiSpacings spacings, DialogDisplayer dialogDisplayer) {
        this.dialogDisplayer = dialogDisplayer;
        this.issueLoader = new JiraIssueLoader(this);
        this.issueLoader.start();
        boolean loadAll = "true".equals(System.getProperty("smartsvn.plugin.jira.loadAllIssues", System.getProperty("smartsvn.plugin.jira.load-all-issues", "false")));
        this.queryConfiguration = new JiraQueryConfiguration(new JiraUIConnection(baseUrl, settingsServices, false, spacings, dialogDisplayer), projectKey, loadAll);
        JiraQueryConfiguration silentQueryConfiguration = new JiraQueryConfiguration(new JiraUIConnection(baseUrl, settingsServices, true, spacings, dialogDisplayer), projectKey, loadAll);
        this.issueLoader.load(silentQueryConfiguration, true);
    }

    @NotNull
    public String getMenuItemName() {
        return "Get from JIRA...";
    }

    public void getCommitMessage(final @NotNull Consumer<String> consumer) {
        JiraCommitMessageSourceDialog dialog;
        this.currentDialog = dialog = new JiraCommitMessageSourceDialog(this.pendingIssues, this.issueLoader, this.queryConfiguration);
        this.issueLoader.load(this.queryConfiguration, false);
        this.dialogDisplayer.showAsync((AbstractDialog)this.currentDialog, new IDialogResultHandler(){

            public void handleDialogResult(int value) {
                JiraCommitMessageSource.this.currentDialog = null;
                if (value == 2) {
                    consumer.consumer((Object)dialog.getCommitMessage());
                }
            }
        });
    }

    public void cleanup() {
        this.issueLoader.abortAndCleanup();
    }

    @Override
    public void setIssues(final List<JiraIssue> issues) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                JiraCommitMessageSource.this.pendingIssues = new ArrayList(issues);
                if (JiraCommitMessageSource.this.currentDialog != null) {
                    JiraCommitMessageSource.this.currentDialog.setIssues(JiraCommitMessageSource.this.pendingIssues);
                }
            }
        });
    }
}

