/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.plugin.jira.commit.messagesource;

import com.syntevo.openapi.deprecated.gui.dialog.AbstractDialog;
import com.syntevo.openapi.deprecated.gui.dialog.AbstractOkCancelDialog;
import com.syntevo.openapi.deprecated.gui.dialog.DialogValidationFailedException;
import com.syntevo.plugin.jira.commit.messagesource.JiraIssueLoader;
import com.syntevo.plugin.jira.commit.messagesource.JiraQueryConfiguration;
import com.syntevo.plugin.jira.transport.JiraIssue;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.jetbrains.annotations.NotNull;

final class JiraCommitMessageSourceDialog
extends AbstractOkCancelDialog {
    private final JiraIssueLoader issueLoader;
    private final JiraQueryConfiguration queryConfiguration;
    private List<JiraIssue> issues;
    private Table table;
    private String commitMessage;

    public JiraCommitMessageSourceDialog(@NotNull List<JiraIssue> issues, JiraIssueLoader issueLoader, JiraQueryConfiguration queryConfiguration) {
        this.issues = issues;
        this.issueLoader = issueLoader;
        this.queryConfiguration = queryConfiguration;
        this.getOkAction().setName("Select");
    }

    @NotNull
    public String getTitle() {
        return "Select JIRA Issue";
    }

    @NotNull
    public Control createComponent(@NotNull Composite parent) {
        Composite panel = new Composite(parent, 0){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                return new Point(600, 400);
            }
        };
        panel.setLayout((Layout)new FillLayout());
        this.table = new Table(panel, 68354);
        this.table.setHeaderVisible(true);
        new TableColumn(this.table, 131072).setText("Key");
        new TableColumn(this.table, 0).setText("Summary");
        new TableColumn(this.table, 0).setText("Status");
        this.table.addListener(14, new Listener(){

            public void handleEvent(Event event) {
                JiraCommitMessageSourceDialog.this.performOk();
            }
        });
        this.updateTableFromIssues();
        this.pack();
        return panel;
    }

    protected void ok() throws DialogValidationFailedException {
        int[] selection = this.table.getSelectionIndices();
        if (selection.length == 0) {
            throw new DialogValidationFailedException((Control)this.table, "Please select one or more issue.", "Or press Cancel to abort.");
        }
        ArrayList<JiraIssue> selectedIssues = new ArrayList<JiraIssue>();
        for (int row : selection) {
            selectedIssues.add(this.issues.get(row));
        }
        this.commitMessage = JiraCommitMessageSourceDialog.createCommitMessage(selectedIssues);
        super.ok();
    }

    @NotNull
    public Button initButtonPanel(@NotNull AbstractDialog.ButtonPanel buttonPanel) {
        buttonPanel.addButton(new AbstractDialog.ButtonAction("Refresh", 3){

            public void performAction() {
                JiraCommitMessageSourceDialog.this.issueLoader.load(JiraCommitMessageSourceDialog.this.queryConfiguration, true);
            }
        });
        return super.initButtonPanel(buttonPanel);
    }

    public String getCommitMessage() {
        return this.commitMessage;
    }

    public void setIssues(@NotNull List<JiraIssue> issues) {
        boolean firstNonEmptySet = this.issues.size() > 0 && issues.size() > 0;
        HashSet<String> selectedKeys = new HashSet<String>();
        for (int row : this.table.getSelectionIndices()) {
            selectedKeys.add(this.issues.get(row).getKey());
        }
        this.issues = issues;
        this.updateTableFromIssues();
        if (firstNonEmptySet) {
            this.pack();
        }
        if (selectedKeys.size() > 0) {
            ArrayList<Integer> indicesToSelect = new ArrayList<Integer>();
            int i = 0;
            for (JiraIssue issue : issues) {
                if (selectedKeys.contains(issue.getKey())) {
                    indicesToSelect.add(i);
                }
                ++i;
            }
            int[] indicesToSelectArray = new int[indicesToSelect.size()];
            for (i = 0; i < indicesToSelectArray.length; ++i) {
                indicesToSelectArray[i] = (Integer)indicesToSelect.get(i);
            }
            this.table.setSelection(indicesToSelectArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTableFromIssues() {
        this.table.setRedraw(false);
        try {
            this.table.setItemCount(this.issues.size());
            TableItem[] items = this.table.getItems();
            for (int i = 0; i < items.length; ++i) {
                TableItem item = items[i];
                JiraIssue issue = this.issues.get(i);
                item.setText(0, issue.getKey());
                item.setText(1, issue.getSummary());
                item.setText(2, issue.getStatus().getName());
            }
        }
        finally {
            this.table.setRedraw(true);
        }
    }

    private void pack() {
        for (TableColumn column : this.table.getColumns()) {
            column.pack();
        }
    }

    private static String createCommitMessage(List<JiraIssue> issues) {
        StringBuilder message = new StringBuilder();
        Iterator<JiraIssue> it = issues.iterator();
        while (it.hasNext()) {
            JiraIssue issue = it.next();
            message.append(issue.getKey());
            message.append(": ");
            message.append(issue.getSummary());
            if (!it.hasNext()) continue;
            message.append("\n");
        }
        return message.toString();
    }
}

