/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.plugin.jira.commit.messagesource;

import com.syntevo.openapi.deprecated.gui.GuiSpacings;
import com.syntevo.openapi.deprecated.smartsvn.command.commit.CommitMessageSourceServices;
import com.syntevo.openapi.deprecated.smartsvn.command.commit.ICommitMessageSource;
import com.syntevo.openapi.deprecated.smartsvn.command.commit.ICommitMessageSourceFactory;
import com.syntevo.openapi.deprecated.smartsvn.file.Path;
import com.syntevo.openapi.deprecated.smartsvn.settings.SettingsServices;
import com.syntevo.plugin.common.bugtracker.commit.messagesource.BugtrackerCommitMessageSourceUtils;
import com.syntevo.plugin.jira.commit.JiraUrl;
import com.syntevo.plugin.jira.commit.messagesource.JiraCommitMessageSource;

public final class JiraCommitMessageSourceFactory
implements ICommitMessageSourceFactory {
    private final SettingsServices settingsServices;
    private final GuiSpacings spacings;

    public JiraCommitMessageSourceFactory(SettingsServices settingsServices, GuiSpacings spacings) {
        this.settingsServices = settingsServices;
        this.spacings = spacings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICommitMessageSource createCommitMessageSource(CommitMessageSourceServices sourceServices) {
        Thread currentThread = Thread.currentThread();
        ClassLoader originalContextClassLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(this.getClass().getClassLoader());
        try {
            Path commitRootPath = sourceServices.getCommitRootPath();
            String bugtraqURL = BugtrackerCommitMessageSourceUtils.findBugtraqURL(sourceServices.getClients(), commitRootPath);
            if (bugtraqURL == null) {
                ICommitMessageSource iCommitMessageSource = null;
                return iCommitMessageSource;
            }
            JiraUrl url = JiraUrl.parseFromBugtraqUrls(bugtraqURL);
            if (url == null) {
                ICommitMessageSource iCommitMessageSource = null;
                return iCommitMessageSource;
            }
            String baseUrl = url.getBaseUrl();
            if (baseUrl == null) {
                ICommitMessageSource iCommitMessageSource = null;
                return iCommitMessageSource;
            }
            JiraCommitMessageSource jiraCommitMessageSource = new JiraCommitMessageSource(baseUrl, this.settingsServices, url.getProjectKey(), this.spacings, sourceServices.getDialogDisplayer());
            return jiraCommitMessageSource;
        }
        finally {
            currentThread.setContextClassLoader(originalContextClassLoader);
        }
    }
}

