/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.plugin.jira.commit.messagesource;

import com.syntevo.plugin.jira.JiraPlugin;
import com.syntevo.plugin.jira.commit.messagesource.JiraIssueList;
import com.syntevo.plugin.jira.commit.messagesource.JiraIssueLoaderTableUpdater;
import com.syntevo.plugin.jira.commit.messagesource.JiraIssueTable;
import com.syntevo.plugin.jira.commit.messagesource.JiraQueryConfiguration;
import com.syntevo.plugin.jira.transport.JiraIssueStatus;
import com.syntevo.plugin.jira.transport.JiraQueryClient;
import com.syntevo.plugin.jira.transport.JiraSoapClient;
import com.syntevo.plugin.jira.transport.JiraVersion;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.soap.SOAPException;

final class JiraIssueLoader
extends Thread {
    private static final int UNRELEASED_VERSIONS_TO_DISPLAY;
    private final JiraIssueList issueList = new JiraIssueList();
    private final JiraIssueTable table;
    private JiraQueryConfiguration configuration;
    private boolean forceRefresh;
    private boolean aborted;
    private JiraIssueLoaderTableUpdater tableUpdater;

    public JiraIssueLoader(JiraIssueTable table) {
        this.table = table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        JiraQueryConfiguration configuration = null;
        while (true) {
            try {
                while (true) {
                    JiraIssueLoader jiraIssueLoader = this;
                    // MONITORENTER : jiraIssueLoader
                    while (this.configuration == null && !this.aborted) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException ex) {}
                    }
                    if (this.aborted) {
                        // MONITOREXIT : jiraIssueLoader
                        return;
                    }
                    if (JiraIssueLoader.areConfigurationsEqual(configuration, this.configuration) && !this.forceRefresh) {
                        this.configuration = null;
                        // MONITOREXIT : jiraIssueLoader
                        continue;
                    }
                    configuration = this.configuration;
                    this.forceRefresh = false;
                    this.issueList.clear();
                    if (configuration == null) {
                        // MONITOREXIT : jiraIssueLoader
                        continue;
                    }
                    JiraSoapClient soapClient = new JiraSoapClient(configuration.getConnection());
                    Object queryClient = new JiraQueryClient(configuration.getConnection());
                    this.tableUpdater = new JiraIssueLoaderTableUpdater((JiraQueryClient)queryClient, this.issueList, this.table);
                    // MONITOREXIT : jiraIssueLoader
                    try {
                        String username;
                        String projectId;
                        List<JiraVersion> unreleasedVersions;
                        block33: {
                            try {
                                if (!soapClient.login()) {
                                    jiraIssueLoader = this;
                                    // MONITORENTER : jiraIssueLoader
                                    configuration = null;
                                    this.configuration = null;
                                    // MONITOREXIT : jiraIssueLoader
                                }
                                break block33;
                            }
                            catch (SOAPException ex) {
                                JiraPlugin.LOGGER.error(ex.getMessage(), (Throwable)ex);
                                configuration.getConnection().showError("Connection failed.", ex);
                                queryClient = this;
                                // MONITORENTER : queryClient
                                configuration = null;
                                this.configuration = null;
                                // MONITOREXIT : queryClient
                            }
                            continue;
                        }
                        try {
                            List<JiraVersion> unreleasedVersionsByProjectKeyInOrder = soapClient.getUnreleasedVersionsByProjectKeyInOrder(configuration.getProjectKey());
                            JiraIssueLoader jiraIssueLoader2 = this;
                            // MONITORENTER : jiraIssueLoader2
                            unreleasedVersions = unreleasedVersionsByProjectKeyInOrder;
                            // MONITOREXIT : jiraIssueLoader2
                            if (configuration.isLoadAll()) {
                                projectId = soapClient.getProjectIDByKey(configuration.getProjectKey());
                                this.tableUpdater.load(projectId, null, Collections.emptyList(), Collections.emptyList(), 2);
                                continue;
                            }
                            projectId = soapClient.getProjectIDByKey(configuration.getProjectKey());
                            username = soapClient.getLoggedInUsername();
                            this.tableUpdater.load(projectId, username, Collections.singletonList(JiraIssueStatus.IN_PROGRESS), Collections.emptyList(), 0);
                        }
                        finally {
                            soapClient.logout();
                            continue;
                        }
                        if (unreleasedVersions.isEmpty() || UNRELEASED_VERSIONS_TO_DISPLAY == 0) {
                            this.tableUpdater.load(projectId, username, Arrays.asList(JiraIssueStatus.OPEN, JiraIssueStatus.REOPENED), Collections.emptyList(), 1);
                        } else {
                            ArrayList<String> firstUnreleasedVersions = new ArrayList<String>();
                            for (int index = 0; index < Math.min(UNRELEASED_VERSIONS_TO_DISPLAY, unreleasedVersions.size()); ++index) {
                                firstUnreleasedVersions.add(unreleasedVersions.get(index).getId());
                            }
                            this.tableUpdater.load(projectId, username, Arrays.asList(JiraIssueStatus.OPEN, JiraIssueStatus.REOPENED), firstUnreleasedVersions, 1);
                        }
                    }
                    catch (IOException | SOAPException ex) {
                        JiraPlugin.LOGGER.error(ex.getMessage(), ex);
                        configuration.getConnection().showError("Connection failed.", ex);
                    }
                    JiraIssueLoader ex = this;
                    // MONITORENTER : ex
                    this.configuration = null;
                    // MONITOREXIT : ex
                }
            }
            catch (Throwable ex) {
                JiraPlugin.LOGGER.error(ex.getMessage(), ex);
                continue;
            }
            break;
        }
    }

    public synchronized void load(JiraQueryConfiguration configuration, boolean forceRefresh) {
        this.configuration = configuration;
        this.forceRefresh = forceRefresh;
        this.notifyAll();
    }

    public synchronized void abortAndCleanup() {
        this.aborted = true;
        if (this.tableUpdater != null) {
            this.tableUpdater.abort();
        }
        this.notifyAll();
    }

    private static boolean areConfigurationsEqual(JiraQueryConfiguration configuration1, JiraQueryConfiguration configuration2) {
        if (configuration1 == null) {
            return configuration2 == null;
        }
        if (configuration2 == null) {
            return false;
        }
        return configuration1.getConnection().getUrl().equals(configuration2.getConnection().getUrl()) && configuration1.getProjectKey().equals(configuration2.getProjectKey());
    }

    static {
        int unreleasedVersions = 3;
        try {
            unreleasedVersions = Integer.parseInt(System.getProperty("smartsvn.plugin.jira.unreleasedVersionsToDisplay", System.getProperty("smartsvn.plugin.jira.unreleased-versions-to-display", String.valueOf(unreleasedVersions))));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        UNRELEASED_VERSIONS_TO_DISPLAY = unreleasedVersions;
    }
}

