/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.plugin.jira.commit.workflow;

import com.syntevo.openapi.deprecated.gui.GuiSpacings;
import com.syntevo.openapi.deprecated.smartsvn.command.commit.CommitWorkflowServices;
import com.syntevo.openapi.deprecated.smartsvn.command.commit.FilterCommitWorkflow;
import com.syntevo.openapi.deprecated.smartsvn.command.commit.ICommitPacketPhase;
import com.syntevo.openapi.deprecated.smartsvn.command.commit.ICommitPostCommandPhase;
import com.syntevo.openapi.deprecated.smartsvn.command.commit.ICommitWorkflow;
import com.syntevo.openapi.deprecated.smartsvn.settings.SettingsServices;
import com.syntevo.plugin.jira.commit.workflow.JiraFilesPhase;
import com.syntevo.plugin.jira.commit.workflow.JiraPostCommandPhase;
import com.syntevo.plugin.jira.commit.workflow.JiraResolvePacket;
import java.util.ArrayList;
import java.util.List;

final class JiraCommitWorkflow
extends FilterCommitWorkflow {
    private final List<ICommitPacketPhase> packetPhases;
    private final CommitWorkflowServices services;
    private JiraFilesPhase filesPhase;

    public JiraCommitWorkflow(ICommitWorkflow baseWorkflow, CommitWorkflowServices services, SettingsServices settingsServices, GuiSpacings spacings) {
        super(baseWorkflow);
        this.services = services;
        this.packetPhases = new ArrayList<ICommitPacketPhase>();
        for (ICommitPacketPhase phase : new ArrayList(baseWorkflow.getPacketPhases())) {
            if (phase.getID().equals("files")) {
                this.filesPhase = new JiraFilesPhase(phase, settingsServices, services.getPacketPhaseJobRunner(), spacings, services.getPacketPhaseDialogDisplayer());
                this.packetPhases.add((ICommitPacketPhase)this.filesPhase);
                continue;
            }
            this.packetPhases.add(phase);
        }
    }

    public List<ICommitPacketPhase> getPacketPhases() {
        return this.packetPhases;
    }

    public ICommitPostCommandPhase getPostCommandPhase() {
        ICommitPostCommandPhase wrappedPhase = super.getPostCommandPhase();
        if (this.filesPhase == null) {
            return wrappedPhase;
        }
        List<JiraResolvePacket> resolvePackets = this.filesPhase.getResolvePackets();
        if (resolvePackets == null || resolvePackets.isEmpty()) {
            return wrappedPhase;
        }
        return new JiraPostCommandPhase(wrappedPhase, resolvePackets, this.services.getPrePostCommandPhaseDialogDisplayer());
    }
}

