/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.plugin.jira.commit.workflow;

import com.syntevo.plugin.jira.commit.JiraUIConnection;
import com.syntevo.plugin.jira.transport.JiraIssue;
import com.syntevo.plugin.jira.transport.JiraVersion;
import java.util.ArrayList;
import java.util.List;

class JiraResolvablePacket {
    private final String issueKey;
    private final String projectKey;
    private final JiraUIConnection connection;
    private JiraIssue issue;
    private List<JiraVersion> unreleasedVersions;

    public JiraResolvablePacket(String issueKey, String projectKey, JiraUIConnection connection) {
        this.issueKey = issueKey;
        this.projectKey = projectKey;
        this.connection = connection;
    }

    public String toString() {
        return this.issueKey;
    }

    public int hashCode() {
        return this.issueKey.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JiraResolvablePacket packet = (JiraResolvablePacket)obj;
        return this.issueKey.equals(packet.issueKey) && this.projectKey.equals(packet.projectKey) && this.connection.getUrl().equals(packet.connection.getUrl());
    }

    public String getIssueKey() {
        return this.issueKey;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public JiraUIConnection getConnection() {
        return this.connection;
    }

    public JiraIssue getIssue() {
        return this.issue;
    }

    public void setIssue(JiraIssue issue) {
        this.issue = issue;
    }

    public List<JiraVersion> getUnreleasedVersions() {
        return this.unreleasedVersions;
    }

    public void setUnreleasedVersions(List<JiraVersion> unreleasedVersions) {
        this.unreleasedVersions = new ArrayList<JiraVersion>(unreleasedVersions);
    }
}

