/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.plugin.jira.commit.workflow;

import com.syntevo.openapi.deprecated.gui.GuiSpacings;
import com.syntevo.openapi.deprecated.gui.dialog.AbstractOkCancelDialog;
import com.syntevo.openapi.deprecated.gui.dialog.DialogValidationFailedException;
import com.syntevo.openapi.deprecated.util.UiUtils;
import com.syntevo.plugin.jira.commit.workflow.JiraResolvablePacket;
import com.syntevo.plugin.jira.transport.JiraIssue;
import com.syntevo.plugin.jira.transport.JiraVersion;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.jetbrains.annotations.NotNull;

final class JiraResolveIssueDialog
extends AbstractOkCancelDialog {
    private final String message;
    private final List<JiraVersion> unreleasedVersions;
    private final List<JiraVersion> fixVersions;
    private final GuiSpacings spacings;
    private Button resolveButton;
    private Combo fixVersionComboBox;
    private Button dontResolveButton;
    private JiraVersion fixVersion;

    @NotNull
    public static JiraResolveIssueDialog createInstance(List<JiraVersion> unreleasedVersions, JiraResolvablePacket packet, GuiSpacings spacings) {
        JiraIssue issue = packet.getIssue();
        String summary = issue.getSummary();
        if (summary.length() > 50) {
            summary = summary.substring(0, 47) + "...";
        }
        return new JiraResolveIssueDialog("Do you want to resolve issue " + issue.getKey() + ": " + summary + "?", unreleasedVersions, issue.getFixVersions(), spacings);
    }

    private JiraResolveIssueDialog(String message, List<JiraVersion> unreleasedVersions, List<JiraVersion> fixVersions, GuiSpacings spacings) {
        this.message = message;
        this.unreleasedVersions = unreleasedVersions;
        this.fixVersions = fixVersions;
        this.spacings = spacings;
    }

    @NotNull
    public String getTitle() {
        return "Resolve JIRA Issue";
    }

    @NotNull
    public Control createComponent(@NotNull Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = this.spacings.getYSeparator();
        panel.setLayout((Layout)layout);
        Label messageLabel = UiUtils.createLabel((String)this.message, (Composite)panel);
        messageLabel.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Control radioButtonPanel = this.createRadioButtonPanel(panel);
        radioButtonPanel.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        String[] versionNames = new String[this.unreleasedVersions.size()];
        int indexToSelect = -1;
        for (int i = 0; i < versionNames.length; ++i) {
            JiraVersion version = this.unreleasedVersions.get(i);
            versionNames[i] = version.getName();
            if (indexToSelect >= 0 || !this.fixVersions.contains(version)) continue;
            indexToSelect = i;
        }
        this.fixVersionComboBox.setItems(versionNames);
        if (indexToSelect >= 0) {
            this.fixVersionComboBox.select(indexToSelect);
        }
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JiraResolveIssueDialog.this.updateEnabledStates();
            }
        };
        this.resolveButton.addSelectionListener((SelectionListener)selectionListener);
        this.dontResolveButton.addSelectionListener((SelectionListener)selectionListener);
        this.updateEnabledStates();
        return panel;
    }

    public void dialogShowing() {
        super.dialogShowing();
        if (this.fixVersionComboBox.isEnabled()) {
            this.fixVersionComboBox.setFocus();
        } else {
            this.dontResolveButton.setFocus();
        }
    }

    protected void ok() throws DialogValidationFailedException {
        if (this.resolveButton.getSelection()) {
            int selectionIndex = this.fixVersionComboBox.getSelectionIndex();
            if (selectionIndex < 0) {
                throw new DialogValidationFailedException((Control)this.fixVersionComboBox, "No version selected.", "Please select the version where the issue should be marked as fixed.");
            }
            this.fixVersion = this.unreleasedVersions.get(selectionIndex);
        } else {
            this.fixVersion = null;
        }
        super.ok();
    }

    public JiraVersion getFixVersion() {
        return this.fixVersion;
    }

    private Control createRadioButtonPanel(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = this.spacings.getXRelated();
        layout.verticalSpacing = this.spacings.getYUnrelated();
        panel.setLayout((Layout)layout);
        this.dontResolveButton = UiUtils.createRadioButton((String)"&Don't mark as resolved", (Composite)panel);
        this.dontResolveButton.setLayoutData((Object)new GridData(16384, 4, false, false, 2, 1));
        this.dontResolveButton.setSelection(true);
        this.resolveButton = UiUtils.createRadioButton((String)"&Mark as resolved in version:", (Composite)panel);
        this.resolveButton.setLayoutData((Object)new GridData(16384, 4, false, false));
        this.fixVersionComboBox = new Combo(panel, 2056);
        this.fixVersionComboBox.setLayoutData((Object)new GridData(4, 4, true, false));
        return panel;
    }

    private void updateEnabledStates() {
        this.fixVersionComboBox.setEnabled(this.resolveButton.getSelection());
    }
}

