/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.plugin.jira.transport;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class JiraIssueStatus {
    public static final JiraIssueStatus IN_PROGRESS = new JiraIssueStatus("in-progress", "3", "In progress", 0);
    public static final JiraIssueStatus OPEN = new JiraIssueStatus("open", "1", "Open", 1);
    public static final JiraIssueStatus REOPENED = new JiraIssueStatus("reopened", "4", "Reopened", 2);
    public static final JiraIssueStatus RESOLVED = new JiraIssueStatus("resolved", "5", "Resolved", 3);
    public static final JiraIssueStatus CLOSED = new JiraIssueStatus("closed", "6", "Closed", 4);
    public static final JiraIssueStatus UNKNOWN = new JiraIssueStatus("unknown", null, "???", -1);
    public static final List<JiraIssueStatus> ALL = Collections.unmodifiableList(Arrays.asList(OPEN, IN_PROGRESS, RESOLVED, REOPENED, CLOSED, UNKNOWN));
    private final String id;
    private final String jiraId;
    private final String name;
    private final int relevance;

    public static JiraIssueStatus parseFromId(String jiraId) {
        for (JiraIssueStatus status : ALL) {
            if (status.jiraId == null || !status.jiraId.equals(jiraId)) continue;
            return status;
        }
        return UNKNOWN;
    }

    public JiraIssueStatus(String id, String jiraId, String name, int relevance) {
        this.id = id;
        this.jiraId = jiraId;
        this.name = name;
        this.relevance = relevance;
    }

    public String toString() {
        return this.id;
    }

    public String getJiraId() {
        return this.jiraId;
    }

    public String getName() {
        return this.name;
    }

    public int getRelevance() {
        return this.relevance;
    }
}

