/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.plugin.jira.transport;

import com.syntevo.plugin.jira.transport.JiraIssue;
import com.syntevo.plugin.jira.transport.JiraIssueResolution;
import com.syntevo.plugin.jira.transport.JiraIssueStatus;
import com.syntevo.plugin.jira.transport.JiraIssueType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

final class JiraIssueXmlHandler
extends DefaultHandler {
    private final List<String> currentElements = new ArrayList<String>();
    private final StringBuffer characters = new StringBuffer();
    private final List<JiraIssue> issues = new ArrayList<JiraIssue>();
    private JiraIssue currentIssue;
    private Attributes currentAttributes;

    JiraIssueXmlHandler() {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        boolean inIssueBefore = this.isInIssue();
        this.currentElements.add(qName);
        boolean inIssueAfter = this.isInIssue();
        this.characters.setLength(0);
        this.currentAttributes = new AttributesImpl(attributes);
        if (!inIssueBefore && inIssueAfter) {
            this.currentIssue = new JiraIssue();
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.currentElements.size() == 0) {
            throw new SAXException("Unexpected endElement.");
        }
        String lastElement = this.currentElements.get(this.currentElements.size() - 1);
        if (!JiraIssueXmlHandler.areEqual(qName, lastElement)) {
            throw new SAXException("Unexpected endElement encountered, expected " + this.currentElements + ", actual '" + qName + "'.");
        }
        this.currentElements.remove(this.currentElements.size() - 1);
        if (this.currentIssue == null) {
            return;
        }
        if ("key".equals(qName)) {
            this.currentIssue.setKey(this.getAttributeExisting("id"), this.getCharactersTrimmed());
        } else if ("summary".equals(qName)) {
            this.currentIssue.setSummary(this.getCharactersTrimmed());
        } else if ("assignee".equals(qName)) {
            this.currentIssue.setAssignee(this.getAttributeExisting("username"));
        } else if ("type".equals(qName)) {
            this.currentIssue.setType(JiraIssueType.parseFromId(this.getAttributeExisting("id")));
        } else if ("status".equals(qName)) {
            this.currentIssue.setStatus(JiraIssueStatus.parseFromId(this.getAttributeExisting("id")));
        } else if ("resolution".equals(qName)) {
            this.currentIssue.setResolution(JiraIssueResolution.parseFromId(this.getAttributeExisting("id")));
        }
        if (!this.isInIssue()) {
            if (this.currentIssue.getId() != null && this.currentIssue.getKey() != null) {
                this.issues.add(this.currentIssue);
            }
            this.currentIssue = null;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.characters.append(ch, start, length);
    }

    public List<JiraIssue> getIssues() {
        return Collections.unmodifiableList(this.issues);
    }

    private String getAttributeExisting(String key) throws SAXException {
        int index = this.currentAttributes.getIndex(key);
        if (index == -1) {
            throw new SAXException("Attribute '" + key + "' expected, but not found.");
        }
        return this.currentAttributes.getValue(index);
    }

    private boolean isInIssue() {
        if (!this.hasElement("rss", 0)) {
            return false;
        }
        return this.hasElement("rss", 0) && this.hasElement("channel", 1) && this.hasElement("item", 2);
    }

    private boolean hasElement(String name, int position) {
        if (this.currentElements.size() <= position) {
            return false;
        }
        return JiraIssueXmlHandler.areEqual(this.currentElements.get(position), name);
    }

    private String getCharactersTrimmed() {
        return this.characters.toString().trim();
    }

    private static boolean areEqual(String str1, String str2) {
        if (str1 == null) {
            return str2 == null;
        }
        return str1.equals(str2);
    }
}

