/*
 * Decompiled with CFR 0.152.
 */
package jdbm.helper;

import java.io.IOException;
import jdbm.extser.Stateless;
import jdbm.helper.Conversion;
import jdbm.helper.Serializer;

public class LongPackedSerializer
implements Serializer<Long>,
Stateless {
    public static final transient LongPackedSerializer INSTANCE = new LongPackedSerializer();
    private static final long serialVersionUID = -2040877409068885002L;

    @Override
    public byte[] serialize(Long obj) throws IOException {
        return Conversion.convertToPackedByteArray(obj);
    }

    @Override
    public Long deserialize(byte[] serialized) throws IOException {
        long number = Conversion.recoverLongFromPacked(serialized);
        return new Long(number);
    }
}

