/*
 * Decompiled with CFR 0.152.
 */
package jdbm.helper;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import jdbm.helper.CacheEvictionException;
import jdbm.helper.CachePolicy;
import jdbm.helper.CachePolicyListener;
import jdbm.helper.ICacheEntry;
import jdbm.helper.Serializer;
import jdbm.helper.maps.LongKeyMap;
import jdbm.helper.maps.LongKeyOpenHashMap;

public class MRUNativeLong
implements CachePolicy {
    LongKeyMap _hash;
    final int _max;
    final double _loadFactor;
    CacheEntry _first;
    CacheEntry _last;
    Vector listeners = new Vector();

    public MRUNativeLong(int max) {
        this(max, 0.75);
    }

    public MRUNativeLong(int max, double loadFactor) {
        if (max <= 0) {
            throw new IllegalArgumentException("MRU cache must contain at least one entry");
        }
        this._max = max;
        this._loadFactor = loadFactor;
        this.removeAll();
    }

    public int size() {
        return this._hash.size();
    }

    public void put(Object _key, Object value, boolean dirty, Serializer ser) throws CacheEvictionException {
        long key = (Long)_key;
        CacheEntry entry = (CacheEntry)this._hash.get(key);
        if (entry != null) {
            entry._value = value;
            entry._dirty = dirty;
            entry._ser = ser;
            this.touchEntry(entry);
        } else {
            if (this._hash.size() == this._max) {
                entry = this.purgeEntry();
                entry._key = _key;
                entry._value = value;
                entry._dirty = dirty;
                entry._ser = ser;
            } else {
                entry = new CacheEntry(_key, value, dirty, ser);
            }
            this.addEntry(entry);
            this._hash.put(key, entry);
        }
    }

    public Object get(Object _key) {
        long key = (Long)_key;
        CacheEntry entry = (CacheEntry)this._hash.get(key);
        if (entry != null) {
            this.touchEntry(entry);
            return entry.getValue();
        }
        return null;
    }

    public void remove(Object _key) {
        long key = (Long)_key;
        CacheEntry entry = (CacheEntry)this._hash.get(key);
        if (entry != null) {
            this.removeEntry(entry);
            this._hash.remove(key);
        }
    }

    @Override
    public void removeAll() {
        this._hash = new LongKeyOpenHashMap(this._max, this._loadFactor);
        this._first = null;
        this._last = null;
    }

    public Enumeration elements() {
        return new MRUEnumeration(this._hash.values().iterator(), true);
    }

    public Enumeration entries() {
        return new MRUEnumeration(this._hash.values().iterator(), false);
    }

    @Override
    public void addListener(CachePolicyListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Cannot add null listener.");
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.addElement(listener);
        }
    }

    @Override
    public void removeListener(CachePolicyListener listener) {
        this.listeners.removeElement(listener);
    }

    protected void addEntry(CacheEntry entry) {
        if (this._first == null) {
            this._first = entry;
            this._last = entry;
        } else {
            this._last.setNext(entry);
            entry.setPrevious(this._last);
            this._last = entry;
        }
    }

    protected void removeEntry(CacheEntry entry) {
        if (entry == this._first) {
            this._first = entry.getNext();
        }
        if (this._last == entry) {
            this._last = entry.getPrevious();
        }
        CacheEntry previous = entry.getPrevious();
        CacheEntry next = entry.getNext();
        if (previous != null) {
            previous.setNext(next);
        }
        if (next != null) {
            next.setPrevious(previous);
        }
        entry.setPrevious(null);
        entry.setNext(null);
    }

    protected void touchEntry(CacheEntry entry) {
        if (this._last == entry) {
            return;
        }
        this.removeEntry(entry);
        this.addEntry(entry);
    }

    protected CacheEntry purgeEntry() throws CacheEvictionException {
        CacheEntry entry = this._first;
        for (int i = 0; i < this.listeners.size(); ++i) {
            CachePolicyListener listener = (CachePolicyListener)this.listeners.elementAt(i);
            listener.cacheObjectEvicted(entry._key, entry._value, entry._dirty, entry._ser);
        }
        this.removeEntry(entry);
        this._hash.remove((Long)entry.getKey());
        entry._value = null;
        return entry;
    }

    static class MRUEnumeration
    implements Enumeration {
        private Iterator _itr;
        private boolean _resolve;

        MRUEnumeration(Iterator itr, boolean resolve) {
            this._itr = itr;
            this._resolve = resolve;
        }

        @Override
        public boolean hasMoreElements() {
            return this._itr.hasNext();
        }

        public Object nextElement() {
            CacheEntry entry = (CacheEntry)this._itr.next();
            if (this._resolve) {
                return entry.getValue();
            }
            return entry;
        }
    }

    static class CacheEntry
    implements ICacheEntry {
        Object _key;
        Object _value;
        boolean _dirty;
        Serializer _ser;
        private CacheEntry _previous;
        private CacheEntry _next;

        CacheEntry(Object key, Object value, boolean dirty, Serializer ser) {
            this._key = key;
            this._value = value;
            this._dirty = dirty;
            this._ser = ser;
        }

        public Object getKey() {
            return this._key;
        }

        public Object getValue() {
            return this._value;
        }

        CacheEntry getPrevious() {
            return this._previous;
        }

        void setPrevious(CacheEntry entry) {
            this._previous = entry;
        }

        CacheEntry getNext() {
            return this._next;
        }

        void setNext(CacheEntry entry) {
            this._next = entry;
        }

        @Override
        public boolean isDirty() {
            return this._dirty;
        }

        @Override
        public void setDirty(boolean dirty) {
            this._dirty = dirty;
        }

        public Serializer getSerializer() {
            return this._ser;
        }
    }
}

