/*
 * Decompiled with CFR 0.152.
 */
package jdbm.helper.maps;

import jdbm.helper.maps.DefaultLongHashFunction;
import jdbm.helper.maps.LongKeyMap;
import jdbm.helper.maps.LongKeyMapIterator;

public abstract class AbstractLongKeyMap<E>
implements LongKeyMap<E> {
    protected AbstractLongKeyMap() {
    }

    @Override
    public void clear() {
        LongKeyMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    @Override
    public E remove(long key) {
        LongKeyMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            Object value = i.getValue();
            i.remove();
            return value;
        }
        return null;
    }

    @Override
    public void putAll(LongKeyMap<E> map) {
        LongKeyMapIterator<E> i = map.entries();
        while (i.hasNext()) {
            i.next();
            this.put(i.getKey(), i.getValue());
        }
    }

    @Override
    public boolean containsKey(long key) {
        LongKeyMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return true;
        }
        return false;
    }

    @Override
    public E get(long key) {
        LongKeyMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return i.getValue();
        }
        return null;
    }

    @Override
    public boolean containsValue(Object value) {
        LongKeyMapIterator i = this.entries();
        if (value == null) {
            while (i.hasNext()) {
                i.next();
                if (value != null) continue;
                return true;
            }
        } else {
            while (i.hasNext()) {
                i.next();
                if (!value.equals(i.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof LongKeyMap)) {
            return false;
        }
        LongKeyMap map = (LongKeyMap)obj;
        if (this.size() != map.size()) {
            return false;
        }
        LongKeyMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            long k = i.getKey();
            Object v = i.getValue();
            if (v == null) {
                if (map.get(k) != null) {
                    return false;
                }
                if (map.containsKey(k)) continue;
                return false;
            }
            if (v.equals(map.get(k))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int h = 0;
        LongKeyMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            h += DefaultLongHashFunction.INSTANCE.hash(i.getKey()) ^ i.getValue().hashCode();
        }
        return h;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int size() {
        int size = 0;
        LongKeyMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            ++size;
        }
        return size;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append('[');
        LongKeyMapIterator i = this.entries();
        while (i.hasNext()) {
            if (s.length() > 1) {
                s.append(',');
            }
            i.next();
            s.append(String.valueOf(i.getKey()));
            s.append("->");
            s.append(String.valueOf(i.getValue()));
        }
        s.append(']');
        return s.toString();
    }

    public void trimToSize() {
    }
}

