/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import jdbm.recman.BlockIo;
import jdbm.recman.DataPage;
import jdbm.recman.Location;
import jdbm.recman.LogicalRowIdManager;
import jdbm.recman.PageManager;
import jdbm.recman.PhysicalRowIdManager;
import jdbm.recman.RecordFile;
import jdbm.recman.RecordHeader;

public class BufferedRecordInstallManager {
    static boolean DEBUG = false;
    private final RecordFile _file;
    private final LogicalRowIdManager _logMgr;
    private final PhysicalRowIdManager _physMgr;
    private PageManager _pageman;
    private final Bucket _bucket;
    final int _wasteMargin;
    private final int _wasteMargin2;
    private final Counters _counters = new Counters();

    public Counters getCounters() {
        return this._counters;
    }

    public BufferedRecordInstallManager(RecordFile file, LogicalRowIdManager logMgr, PhysicalRowIdManager physMgr, PageManager pageman, int wasteMargin, int wasteMargin2) {
        if (file == null || logMgr == null || physMgr == null || pageman == null) {
            throw new IllegalArgumentException();
        }
        if (wasteMargin < 0 || wasteMargin > 8172) {
            throw new IllegalArgumentException("wasteMargin");
        }
        if (wasteMargin2 < 0 || wasteMargin2 > 8172) {
            throw new IllegalArgumentException("wasteMargin2");
        }
        this._file = file;
        this._logMgr = logMgr;
        this._physMgr = physMgr;
        this._pageman = pageman;
        this._bucket = new Bucket();
        this._wasteMargin = wasteMargin;
        this._wasteMargin2 = wasteMargin2;
    }

    public byte[] fetch(Location logRowId) {
        byte[] data = this._bucket.fetch(logRowId);
        if (data != null) {
            ++this._counters.recordsFetched;
        }
        return data;
    }

    public void delete(Location logRowId) {
        if (this._bucket.delete(logRowId)) {
            ++this._counters.recordsDeleted;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Location logRowId, byte[] data) throws IOException {
        if (logRowId == null || data == null) {
            throw new IllegalArgumentException();
        }
        ++this._counters.recordsUpdated;
        Location physRowId = this._logMgr.fetch(logRowId);
        if (data.length > 8172) {
            this.updateOrInsertRecord(logRowId, physRowId, data);
            return;
        }
        if (physRowId.getBlock() != 0L) {
            boolean enoughSpace;
            BlockIo block = this._file.get(physRowId.getBlock());
            try {
                RecordHeader header = new RecordHeader(block, physRowId.getOffset());
                enoughSpace = data.length <= header.getAvailableSize();
            }
            finally {
                this._file.release(block);
            }
            if (enoughSpace) {
                this._physMgr.write(physRowId, data, 0, data.length);
                return;
            }
        }
        if (this._bucket._avail < 8 + data.length) {
            this.installBucketPageAtOnce(this._bucket);
        }
        this._bucket.add(logRowId, physRowId, data);
    }

    public void abort() {
        ++this._counters.abort;
        this._bucket.clear();
    }

    public void commit() throws IOException {
        ++this._counters.commit;
        if (this._bucket.isEmpty()) {
            return;
        }
        if (this._bucket._avail < this._wasteMargin2) {
            this.installBucketPageAtOnce(this._bucket);
        } else {
            this.installBucketRecordAtOnce(this._bucket);
        }
    }

    void installBucketPageAtOnce(Bucket bucket) throws IOException {
        if (bucket.getRecordCount() == 0) {
            throw new IllegalStateException();
        }
        ++this._counters.bucketsInstalledPageAtOnce;
        long blockId = this._pageman.allocate((short)1);
        BlockIo block = this._file.get(blockId);
        try {
            DataPage curPage = DataPage.getDataPageView(block);
            curPage.setFirst((short)20);
            int avail = 8172;
            short offset = 20;
            int nrecs = 0;
            Iterator<BufferedRecord> itr = bucket.iterator();
            while (itr.hasNext()) {
                BufferedRecord rec = itr.next();
                Location logRowId = rec.getLogicalRowId();
                Location oldPhysRowId = rec.getPhysicalRowId();
                if (!oldPhysRowId.isZero()) {
                    this._physMgr.delete(oldPhysRowId);
                }
                Location physRowId = new Location(blockId, offset);
                this._logMgr.update(logRowId, physRowId);
                RecordHeader hdr = new RecordHeader(block, offset);
                byte[] data = rec.getData();
                int len = data.length;
                hdr.setAvailableSize(len);
                hdr.setCurrentSize(len);
                short dataOffset = (short)(offset + 8);
                System.arraycopy(data, 0, block.getData(), dataOffset, len);
                int size = 8 + len;
                offset = (short)(offset + size);
                ++nrecs;
                if ((avail -= size) < 0) {
                    throw new AssertionError();
                }
                if (offset > 8192) {
                    throw new AssertionError();
                }
            }
            if (DEBUG) {
                System.err.println("Installed " + nrecs + " records on page=" + blockId + ", waste=" + avail);
            }
            this._counters.recordsInstalled += nrecs;
            this._counters.recordsInstalledPageAtOnce += nrecs;
            ++this._counters.bucketsInstalled;
            ++this._counters.bucketsInstalledPageAtOnce;
            this._counters.bytesWritten += (long)bucket._size;
            this._counters.bytesWasted += (long)bucket._avail;
            this._file.release(blockId, true);
        }
        catch (Throwable t) {
            this._file.release(block);
            IOException ex = new IOException();
            ex.initCause(t);
            throw ex;
        }
        bucket.clear();
    }

    void installBucketRecordAtOnce(Bucket bucket) throws IOException {
        if (bucket.getRecordCount() == 0) {
            throw new IllegalStateException();
        }
        ++this._counters.bucketsInstalledRecordAtOnce;
        int nrecs = 0;
        Iterator<BufferedRecord> itr = this._bucket.iterator();
        while (itr.hasNext()) {
            BufferedRecord rec = itr.next();
            Location logRowId = rec.getLogicalRowId();
            Location physRowId = this._logMgr.fetch(logRowId);
            byte[] data = rec.getData();
            Location newPhysRowId = physRowId.getBlock() == 0L ? this._physMgr.insert(data, 0, data.length) : this._physMgr.update(physRowId, data, 0, data.length);
            if (!newPhysRowId.equals(physRowId)) {
                this._logMgr.update(logRowId, newPhysRowId);
            }
            ++nrecs;
        }
        if (DEBUG) {
            System.err.println("Installed " + nrecs + " records using record at a time allocation.");
        }
        this._counters.recordsInstalled += nrecs;
        this._counters.recordsInstalledRecordAtOnce += nrecs;
        ++this._counters.bucketsInstalled;
        ++this._counters.bucketsInstalledRecordAtOnce;
        this._counters.bytesWritten += (long)bucket._size;
        bucket.clear();
    }

    private void updateOrInsertRecord(Location logRowId, Location physRowId, byte[] data) throws IOException {
        Location newRecid = physRowId.getBlock() == 0L ? this._physMgr.insert(data, 0, data.length) : this._physMgr.update(physRowId, data, 0, data.length);
        if (!newRecid.equals(physRowId)) {
            this._logMgr.update(logRowId, newRecid);
        }
    }

    static final class BufferedRecord {
        private final Location _logRowId;
        private final Location _physRowId;
        private final byte[] _data;

        BufferedRecord(Location logRowId, Location physRowId, byte[] data) {
            if (logRowId == null || physRowId == null || data == null) {
                throw new IllegalArgumentException();
            }
            this._logRowId = logRowId;
            this._physRowId = physRowId;
            this._data = data;
        }

        public Location getLogicalRowId() {
            return this._logRowId;
        }

        public byte[] getData() {
            return this._data;
        }

        public int size() {
            return this._data.length;
        }

        public Location getPhysicalRowId() {
            return this._physRowId;
        }

        public String toString() {
            return "BR<" + this._logRowId + ",len=" + this._data.length + ">";
        }
    }

    static final class Bucket {
        private final HashMap<Location, BufferedRecord> _recs = new HashMap();
        static final int _capacity = 8172;
        int _avail = 8172;
        int _size = 0;

        Bucket() {
        }

        void clear() {
            this._avail = 8172;
            this._size = 0;
            this._recs.clear();
        }

        boolean add(Location logRowId, Location physRowId, byte[] data) {
            if (logRowId == null || physRowId == null || data == null) {
                throw new IllegalArgumentException();
            }
            int len = 8 + data.length;
            if (len > this._avail) {
                throw new IllegalStateException();
            }
            boolean deleted = this._delete(logRowId);
            if (this._recs.put(logRowId, new BufferedRecord(logRowId, physRowId, data)) != null) {
                throw new AssertionError();
            }
            this._size += len;
            this._avail -= len;
            if (this._size > 8172) {
                throw new AssertionError();
            }
            if (this._avail < 0) {
                throw new AssertionError();
            }
            return deleted;
        }

        public Iterator<BufferedRecord> iterator() {
            return this._recs.values().iterator();
        }

        public int getRecordCount() {
            return this._recs.size();
        }

        public boolean isEmpty() {
            return this._size == 0;
        }

        public byte[] fetch(Location logRowId) {
            if (logRowId == null) {
                throw new IllegalArgumentException();
            }
            BufferedRecord rec = this._recs.get(logRowId);
            if (rec == null) {
                return null;
            }
            return rec.getData();
        }

        public boolean delete(Location logRowId) throws IllegalStateException {
            return this._delete(logRowId);
        }

        private boolean _delete(Location logRowId) {
            if (logRowId == null) {
                throw new IllegalArgumentException();
            }
            BufferedRecord rec = this._recs.remove(logRowId);
            if (rec != null) {
                int size = 8 + rec.size();
                this._size -= size;
                this._avail += size;
                return true;
            }
            return false;
        }
    }

    public class Counters {
        int recordsUpdated;
        int recordsFetched;
        int recordsDeleted;
        int commit;
        int abort;
        int bucketsExisting;
        int bucketsInstalled;
        int bucketsInstalledPageAtOnce;
        int bucketsInstalledRecordAtOnce;
        int recordsInstalledPageAtOnce;
        int recordsInstalledRecordAtOnce;
        int recordsInstalled;
        long bytesWritten;
        long bytesWasted;

        public Counters() {
            this.resetCounters();
        }

        public void resetCounters() {
            this.recordsDeleted = 0;
            this.recordsFetched = 0;
            this.recordsUpdated = 0;
            this.abort = 0;
            this.commit = 0;
            this.bucketsExisting = 1;
            this.bucketsInstalledRecordAtOnce = 0;
            this.bucketsInstalledPageAtOnce = 0;
            this.bucketsInstalled = 0;
            this.recordsInstalledPageAtOnce = 0;
            this.recordsInstalledRecordAtOnce = 0;
            this.recordsInstalled = 0;
            this.bytesWritten = 0L;
            this.bytesWasted = 0L;
        }

        public void writeCounters() {
            System.err.println("BufferedRecordInstallManager:: counters");
            System.err.println("records: insertOrUpdate=" + this.recordsUpdated + ", fetched=" + this.recordsFetched + ", deleted=" + this.recordsDeleted + ", commit=" + this.commit + ", abort=" + this.abort);
            System.err.println("records installed: pageAtOnce=" + this.recordsInstalledPageAtOnce + ", recordAtOnce=" + this.recordsInstalledRecordAtOnce + ", total=" + this.recordsInstalled);
            System.err.println("buckets: existing=" + this.bucketsExisting + ", installed=" + this.bucketsInstalled + ", installedPageAtOnce=" + this.bucketsInstalledPageAtOnce + ", installedRecordAtOnce=" + this.bucketsInstalledRecordAtOnce);
            System.err.println("bytes: written=" + this.bytesWritten + ", wasted=" + this.bytesWasted + (this.bytesWritten > 0L ? ", " + (float)((int)((float)this.bytesWasted / (float)this.bytesWritten * 1000.0f)) / 10.0f + "% wasted" : ""));
            System.err.println("wasteMargin1=" + BufferedRecordInstallManager.this._wasteMargin + ", wasteMargin2=" + BufferedRecordInstallManager.this._wasteMargin2);
        }
    }
}

