/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.plugin.trac.commit;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TracUrl {
    private static final String TICKET_SIGNATURE = "/ticket/";
    private static final String JSON_RPC_SUFFIX = "/login/jsonrpc";
    private final String baseUrl;

    @Nullable
    public static TracUrl parseFromBugtraqUrls(@Nullable String url) {
        if (url == null) {
            return null;
        }
        String baseUrl = TracUrl.extractBaseURL(url);
        if (baseUrl == null) {
            return null;
        }
        return new TracUrl(baseUrl + JSON_RPC_SUFFIX);
    }

    public TracUrl(@NotNull String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String toString() {
        return this.baseUrl;
    }

    @NotNull
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Nullable
    private static String extractBaseURL(@NotNull String url) {
        String signature = TracUrl.findSignature(url);
        if (signature == null) {
            return null;
        }
        int signatureIndex = url.indexOf(signature);
        url = url.substring(0, signatureIndex);
        return url;
    }

    @Nullable
    private static String findSignature(@NotNull String url) {
        if (url.contains(TICKET_SIGNATURE)) {
            return TICKET_SIGNATURE;
        }
        return null;
    }
}

