/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.plugin.trac.commit.messagesource;

import com.syntevo.openapi.deprecated.gui.dialog.AbstractDialog;
import com.syntevo.openapi.deprecated.gui.dialog.AbstractOkCancelDialog;
import com.syntevo.openapi.deprecated.gui.dialog.DialogDisplayer;
import com.syntevo.openapi.deprecated.gui.dialog.DialogValidationFailedException;
import com.syntevo.openapi.deprecated.gui.dialog.IDialogResultHandler;
import com.syntevo.openapi.deprecated.smartsvn.command.commit.CommitBugtraqProperties;
import com.syntevo.plugin.trac.commit.messagesource.TracConfigureCommitMessagePatternDialog;
import com.syntevo.plugin.trac.commit.messagesource.TracIssueLoader;
import com.syntevo.plugin.trac.commit.messagesource.TracQueryConfiguration;
import com.syntevo.plugin.trac.transport.TracIssue;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TracCommitMessageSourceDialog
extends AbstractOkCancelDialog {
    private final TracIssueLoader issueLoader;
    private final TracQueryConfiguration queryConfiguration;
    private final DialogDisplayer dialogDisplayer;
    private final CommitBugtraqProperties bugtraqProperties;
    private List<TracIssue> issues;
    private Table table;
    private String commitMessage;
    private String commitMessagePattern;

    public TracCommitMessageSourceDialog(@Nullable List<TracIssue> issues, @NotNull TracIssueLoader issueLoader, @Nullable TracQueryConfiguration queryConfiguration, @Nullable String commitMessagePattern, @NotNull CommitBugtraqProperties bugtraqProperties, @NotNull DialogDisplayer dialogDisplayer) {
        this.issues = issues;
        this.issueLoader = issueLoader;
        this.queryConfiguration = queryConfiguration;
        this.commitMessagePattern = commitMessagePattern;
        this.bugtraqProperties = bugtraqProperties;
        this.dialogDisplayer = dialogDisplayer;
        this.getOkAction().setName("Select");
    }

    @NotNull
    public String getTitle() {
        return "Select Trac Issue";
    }

    @NotNull
    public Control createComponent(@NotNull Composite parent) {
        Composite panel = new Composite(parent, 0){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                return new Point(600, 400);
            }
        };
        panel.setLayout((Layout)new FillLayout());
        this.table = new Table(panel, 68354);
        this.table.setHeaderVisible(true);
        new TableColumn(this.table, 131072).setText("ID");
        new TableColumn(this.table, 0).setText("Summary");
        new TableColumn(this.table, 0).setText("Status");
        new TableColumn(this.table, 0).setText("Milestone");
        new TableColumn(this.table, 0).setText("Version");
        this.table.addListener(14, new Listener(){

            public void handleEvent(Event event) {
                TracCommitMessageSourceDialog.this.performOk();
            }
        });
        this.updateTableFromIssues();
        this.pack();
        return panel;
    }

    protected void ok() throws DialogValidationFailedException {
        int[] selection = this.table.getSelectionIndices();
        if (selection.length == 0) {
            throw new DialogValidationFailedException((Control)this.table, "Please select one or more issue.", "Or press Cancel to abort.");
        }
        ArrayList<TracIssue> selectedIssues = new ArrayList<TracIssue>();
        for (int row : selection) {
            selectedIssues.add(this.issues.get(row));
        }
        if (this.commitMessagePattern != null) {
            this.commitMessagePattern = this.commitMessagePattern.trim();
        }
        this.commitMessage = TracCommitMessageSourceDialog.createCommitMessage(selectedIssues, this.commitMessagePattern, this.bugtraqProperties);
        super.ok();
    }

    @NotNull
    public Button initButtonPanel(@NotNull AbstractDialog.ButtonPanel buttonPanel) {
        buttonPanel.addButton(new AbstractDialog.ButtonAction("Refresh", 3){

            public void performAction() {
                TracCommitMessageSourceDialog.this.issueLoader.load(TracCommitMessageSourceDialog.this.queryConfiguration, true);
            }
        });
        if (this.bugtraqProperties.getMessage() == null) {
            buttonPanel.addButton(new AbstractDialog.ButtonAction("Configure", 3){

                public void performAction() {
                    TracCommitMessageSourceDialog.this.configureMessagePattern();
                }
            });
        }
        return super.initButtonPanel(buttonPanel);
    }

    @NotNull
    public String getCommitMessage() {
        return this.commitMessage;
    }

    @Nullable
    public String getCommitMessagePattern() {
        return this.commitMessagePattern;
    }

    public void setIssues(@NotNull List<TracIssue> issues) {
        boolean firstNonEmptySet = this.issues.size() > 0 && issues.size() > 0;
        HashSet<Long> selectedKeys = new HashSet<Long>();
        for (int row : this.table.getSelectionIndices()) {
            selectedKeys.add(this.issues.get(row).getId());
        }
        this.issues = issues;
        this.updateTableFromIssues();
        if (firstNonEmptySet) {
            this.pack();
        }
        if (selectedKeys.size() > 0) {
            ArrayList<Integer> indicesToSelect = new ArrayList<Integer>();
            int i = 0;
            for (TracIssue issue : issues) {
                if (selectedKeys.contains(issue.getId())) {
                    indicesToSelect.add(i);
                }
                ++i;
            }
            int[] indicesToSelectArray = new int[indicesToSelect.size()];
            for (i = 0; i < indicesToSelectArray.length; ++i) {
                indicesToSelectArray[i] = (Integer)indicesToSelect.get(i);
            }
            this.table.setSelection(indicesToSelectArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTableFromIssues() {
        this.table.setRedraw(false);
        try {
            this.table.setItemCount(this.issues.size());
            TableItem[] items = this.table.getItems();
            for (int i = 0; i < items.length; ++i) {
                TableItem item = items[i];
                TracIssue issue = this.issues.get(i);
                item.setText(0, String.valueOf(issue.getId()));
                item.setText(1, issue.getSummary());
                item.setText(2, issue.getStatus().getName());
                item.setText(3, issue.getMilestoneName());
                item.setText(4, issue.getVersionName());
            }
        }
        finally {
            this.table.setRedraw(true);
        }
    }

    private void pack() {
        for (TableColumn column : this.table.getColumns()) {
            column.pack();
        }
    }

    private void configureMessagePattern() {
        final TracConfigureCommitMessagePatternDialog messagePatternDialog = new TracConfigureCommitMessagePatternDialog(this.commitMessagePattern);
        this.dialogDisplayer.showAsync((AbstractDialog)messagePatternDialog, new IDialogResultHandler(){

            public void handleDialogResult(int value) {
                if (value != 2) {
                    return;
                }
                TracCommitMessageSourceDialog.this.commitMessagePattern = messagePatternDialog.getCommitMessagePattern();
            }
        });
    }

    @NotNull
    private static String createCommitMessage(@NotNull List<TracIssue> issues, @Nullable String commitMessagePattern, @NotNull CommitBugtraqProperties bugtraqProperties) {
        TracIssue issue;
        Iterator<TracIssue> it;
        StringBuilder idBuilder = new StringBuilder();
        StringBuilder messageBuilder = new StringBuilder();
        String bugtraqMessage = bugtraqProperties.getMessage();
        if (bugtraqMessage != null) {
            it = issues.iterator();
            while (it.hasNext()) {
                issue = it.next();
                idBuilder.append(bugtraqMessage.replace("%BUGID%", String.valueOf(issue.getId())));
                if (!it.hasNext()) continue;
                idBuilder.append(",");
            }
        }
        it = issues.iterator();
        while (it.hasNext()) {
            issue = it.next();
            if (bugtraqMessage == null && commitMessagePattern != null && !commitMessagePattern.isEmpty()) {
                String message = commitMessagePattern.replace("%BUGID%", String.valueOf(issue.getId()));
                message = message.replace("%MESSAGE%", issue.getSummary());
                messageBuilder.append(message);
            } else {
                messageBuilder.append(issue.getSummary());
            }
            if (!it.hasNext()) continue;
            messageBuilder.append("\n");
        }
        if (bugtraqMessage != null) {
            if (bugtraqProperties.isAppend()) {
                return messageBuilder.toString() + "\n" + idBuilder.toString();
            }
            return idBuilder.toString() + "\n" + messageBuilder.toString();
        }
        return messageBuilder.toString();
    }
}

